// Vampire Savior 2: The Lord of Vampire

#include "cps.h"

STDINPUTINFOSPEC(Drv, CpsFsi);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  8*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=  8*0x400000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x400000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  for (i=0;i<8;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
  nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

  nRet=Cps2LoadTiles(CpsGfx           ,10);
  nRet=Cps2LoadTiles(CpsGfx+4*0x400000,14);

  nRet=BurnLoadRom(CpsZRom         ,18,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);

  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,20,1);
  nRet=BurnLoadRom(pqs+0x400000,21,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit(); if (nRet!=0) return 1;

  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

//==============================================
//Vampire Savior 2: The Lord of Vampire (Japan)
//==============================================


static struct BurnRomInfo Vsav2RomDesc[]=
{

  {"vs2jx.03" ,0x80000,0x8f83159a, 0x10},
  {"vs2jx.04" ,0x80000,0xe9822de8, 0x10},

  {"vs2j.03"  ,0x80000,0x89fd86b4, 0x10},
  {"vs2j.04"  ,0x80000,0x107c091b, 0x10},
  {"vs2j.05"  ,0x80000,0x61979638, 0x10},
  {"vs2j.06"  ,0x80000,0xf37c5bc2, 0x10},
  {"vs2j.07"  ,0x80000,0x8f885809, 0x10},
  {"vs2j.08"  ,0x80000,0x2018c120, 0x10},
  {"vs2j.09"  ,0x80000,0xfac3c217, 0x10},
  {"vs2j.10"  ,0x80000,0xeb490213, 0x10},

  {"vs2.13"  ,0x400000,0x5c852f52,    1},
  {"vs2.15"  ,0x400000,0xa20f58af,    1},
  {"vs2.17"  ,0x400000,0x39db59ad,    1},
  {"vs2.19"  ,0x400000,0x00c763a7,    1},
  {"vs2.14"  ,0x400000,0xcd09bd63,    1},
  {"vs2.16"  ,0x400000,0xe0182c15,    1},
  {"vs2.18"  ,0x400000,0x778dc4f6,    1},
  {"vs2.20"  ,0x400000,0x605d9d1d,    1},

  {"vs2.01"  ,0x020000,0x35190139,    2},
  {"vs2.02"  ,0x020000,0xc32dba09,    2},

  {"vs2.11"  ,0x400000,0xd67e47b7,    2},
  {"vs2.12"  ,0x400000,0x6d020a14,    2},
};

STD_ROM_PICK(Vsav2) STD_ROM_FN(Vsav2)

struct BurnDriver BurnDrvCpsVsav2=
{
  {"vsav2" ,"Vampire Savior 2: The Lord of Vampire (Japan 970913)","","Capcom","CPS2","1997",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Vsav2RomInfo, Vsav2RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
