// Street Fighter Alpha 2

#include "cps.h"

STDINPUTINFOSPEC(Drv, CpsFsi);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  6*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=   0x1400000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  for (i=0;i<6;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
  nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

  nRet=Cps2LoadTiles(CpsGfx           , 8);
  nRet=Cps2LoadTiles(CpsGfx+4*0x400000,12);

  nRet=BurnLoadRom(CpsZRom         ,16,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,17,1);

  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,18,1);
  nRet=BurnLoadRom(pqs+0x200000,19,1);
  BurnByteswap(pqs,nCpsQSamLen);

  nRet=CpsRunInit(); if (nRet!=0) return 1;

  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}

//============================
//Street Fighter Alpha 2 (USA)
//============================


static struct BurnRomInfo Sfa2RomDesc[]=
{
  {"sz2ux.03",0x80000,0x6bb6005f, 0x10},
  {"sz2ux.04",0x80000,0x74308a4b, 0x10},

  {"sz2u.03" ,0x80000,0x84a09006, 0x10},
  {"sz2u.04" ,0x80000,0xac46e5ed, 0x10},
  {"sz2u.05" ,0x80000,0x6c0c79d3, 0x10},
  {"sz2u.06" ,0x80000,0xc5c8eb63, 0x10},
  {"sz2u.07" ,0x80000,0x5de01cc5, 0x10},
  {"sz2u.08" ,0x80000,0xbea11d56, 0x10},

  {"sz2.13"  ,0x400000,0x4d1f1f22,    1},
  {"sz2.15"  ,0x400000,0x19cea680,    1},
  {"sz2.17"  ,0x400000,0xe01b4588,    1},
  {"sz2.19"  ,0x400000,0x0feeda64,    1},
  {"sz2.14"  ,0x100000,0x0560c6aa,    1},
  {"sz2.16"  ,0x100000,0xae940f87,    1},
  {"sz2.18"  ,0x100000,0x4bc3c8bc,    1},
  {"sz2.20"  ,0x100000,0x39e674c0,    1},

  {"sz2.01a"  ,0x020000,0x1bc323cf,    2},
  {"sz2.02a"  ,0x020000,0xba6a5013,    2},

  {"sz2.11"  ,0x200000,0xaa47a601,    2},
  {"sz2.12"  ,0x200000,0x2237bc53,    2},
};

STD_ROM_PICK(Sfa2) STD_ROM_FN(Sfa2)

struct BurnDriver BurnDrvCpsSfa2=
{
  {"sfa2" ,"Street Fighter Alpha 2 (US 960306)","","Capcom","CPS2","1996",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfa2RomInfo, Sfa2RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===================================
//Street Fighter Zero 2 Alpha (Japan)
//===================================


static struct BurnRomInfo Sfz2ajRomDesc[]=
{
  {"szajx.03a",0x80000,0x6d3aa71e, 0x10}, // xor decryption table
  {"szajx.04a",0x80000,0x006d5cb8, 0x10}, // xor decryption table

  {"szaj.03a" ,0x80000,0xa3802fe3, 0x10}, // 68000 code (encrypted)
  {"szaj.04a" ,0x80000,0xe7ca87c7, 0x10},
  {"szaj.05a" ,0x80000,0xc88ebf88, 0x10},
  {"szaj.06a" ,0x80000,0x35ed5b7a, 0x10},
  {"szaj.07a" ,0x80000,0x975dcb3e, 0x10},
  {"szaj.08a" ,0x80000,0xdc73f2d7, 0x10},

  {"sz2.13"  ,0x400000,0x4d1f1f22,    1}, // 8
  {"sz2.15"  ,0x400000,0x19cea680,    1},
  {"sz2.17"  ,0x400000,0xe01b4588,    1},
  {"sz2.19"  ,0x400000,0x0feeda64,    1},
  {"sz2.14"  ,0x100000,0x0560c6aa,    1},
  {"sz2.16"  ,0x100000,0xae940f87,    1},
  {"sz2.18"  ,0x100000,0x4bc3c8bc,    1},
  {"sz2.20"  ,0x100000,0x39e674c0,    1},

  {"sz2.01a"  ,0x020000,0x1bc323cf,    2}, // 16
  {"sz2.02a"  ,0x020000,0xba6a5013,    2},
  // sound - samples
  {"sz2.11"  ,0x200000,0xaa47a601,    2},
  {"sz2.12"  ,0x200000,0x2237bc53,    2},
};

STD_ROM_PICK(Sfz2aj) STD_ROM_FN(Sfz2aj)

struct BurnDriver BurnDrvCpsSfz2aj=
{
  {"sfz2aj" ,"Street Fighter Zero 2 Alpha (Japan 960805)","","Capcom","CPS2","1996","sfa2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfz2ajRomInfo, Sfz2ajRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//=============================
//Street Fighter Zero 2 (Japan)
//=============================


static struct BurnRomInfo Sfz2jRomDesc[]=
{
  {"sz2jx.03a",0x80000,0x6a765c08, 0x10},
  {"sz2jx.04a",0x80000,0x66139273, 0x10},

  {"sz2j.03a" ,0x80000,0x97461e28, 0x10},
  {"sz2j.04a" ,0x80000,0xae4851a9, 0x10},
  {"sz2.05"   ,0x80000,0x98e8e992, 0x10},
  {"sz2.06"   ,0x80000,0x5b1d49c0, 0x10},
  {"sz2j.07a" ,0x80000,0xd910b2a2, 0x10},
  {"sz2.08"   ,0x80000,0x0fe8585d, 0x10},

  {"sz2.13"  ,0x400000,0x4d1f1f22,    1},
  {"sz2.15"  ,0x400000,0x19cea680,    1},
  {"sz2.17"  ,0x400000,0xe01b4588,    1},
  {"sz2.19"  ,0x400000,0x0feeda64,    1},
  {"sz2.14"  ,0x100000,0x0560c6aa,    1},
  {"sz2.16"  ,0x100000,0xae940f87,    1},
  {"sz2.18"  ,0x100000,0x4bc3c8bc,    1},
  {"sz2.20"  ,0x100000,0x39e674c0,    1},

  {"sz2.01a"  ,0x020000,0x1bc323cf,    2},
  {"sz2.02a"  ,0x020000,0xba6a5013,    2},

  {"sz2.11"  ,0x200000,0xaa47a601,    2},
  {"sz2.12"  ,0x200000,0x2237bc53,    2},
};

STD_ROM_PICK(Sfz2j) STD_ROM_FN(Sfz2j)

struct BurnDriver BurnDrvCpsSfz2j=
{
  {"sfz2j" ,"Street Fighter Zero 2 (Japan 960227)","","Capcom","CPS2","1996","sfa2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfz2jRomInfo, Sfz2jRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//============================
//Street Fighter Zero 2 (Asia)
//============================


static struct BurnRomInfo Sfz2aRomDesc[]=
{
  {"sz2ax.03a",0x80000,0xb76d8578, 0x10},
  {"sz2ax.04a",0x80000,0xd4dc0b1e, 0x10},

  {"sz2a.03a" ,0x80000,0x30d2099f, 0x10},
  {"sz2a.04a" ,0x80000,0x1cc94db1, 0x10},
  {"sz2.05"   ,0x80000,0x98e8e992, 0x10},
  {"sz2.06"   ,0x80000,0x5b1d49c0, 0x10},
  {"sz2a.07a" ,0x80000,0x0aed2494, 0x10},
  {"sz2.08"   ,0x80000,0x0fe8585d, 0x10},

  {"sz2.13"  ,0x400000,0x4d1f1f22,    1},
  {"sz2.15"  ,0x400000,0x19cea680,    1},
  {"sz2.17"  ,0x400000,0xe01b4588,    1},
  {"sz2.19"  ,0x400000,0x0feeda64,    1},
  {"sz2.14"  ,0x100000,0x0560c6aa,    1},
  {"sz2.16"  ,0x100000,0xae940f87,    1},
  {"sz2.18"  ,0x100000,0x4bc3c8bc,    1},
  {"sz2.20"  ,0x100000,0x39e674c0,    1},

  {"sz2.01a"  ,0x020000,0x1bc323cf,    2},
  {"sz2.02a"  ,0x020000,0xba6a5013,    2},

  {"sz2.11"  ,0x200000,0xaa47a601,    2},
  {"sz2.12"  ,0x200000,0x2237bc53,    2},
};

STD_ROM_PICK(Sfz2a) STD_ROM_FN(Sfz2a)

struct BurnDriver BurnDrvCpsSfz2a=
{
  {"sfz2a" ,"Street Fighter Zero 2 (Asia 960227)","","Capcom","CPS2","1996","sfa2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfz2aRomInfo, Sfz2aRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//======================================
//Street Fighter Zero 2 Alpha (Hispanic)
//======================================


static struct BurnRomInfo Sfz2ahRomDesc[]=
{
  {"szahx.03" ,0x80000,0x00000000, 0x10}, // xor decryption table
  {"szahx.04" ,0x80000,0x00000000, 0x10}, // xor decryption table

  {"szah.03"  ,0x80000,0x06f93d1d, 0x10}, // 68000 code (encrypted)
  {"szah.04"  ,0x80000,0xe62ee914, 0x10},
  {"szah.05"  ,0x80000,0x2b7f4b20, 0x10},
  {"szah.06"  ,0x80000,0x0abda2fc, 0x10},
  {"szah.07"  ,0x80000,0xe9430762, 0x10},
  {"szah.08"  ,0x80000,0xb65711a9, 0x10},

  {"sz2.13"  ,0x400000,0x4d1f1f22,    1}, // 8
  {"sz2.15"  ,0x400000,0x19cea680,    1},
  {"sz2.17"  ,0x400000,0xe01b4588,    1},
  {"sz2.19"  ,0x400000,0x0feeda64,    1},
  {"sz2.14"  ,0x100000,0x0560c6aa,    1},
  {"sz2.16"  ,0x100000,0xae940f87,    1},
  {"sz2.18"  ,0x100000,0x4bc3c8bc,    1},
  {"sz2.20"  ,0x100000,0x39e674c0,    1},

  {"sz2.01a"  ,0x020000,0x1bc323cf,    2}, // 16
  {"sz2.02a"  ,0x020000,0xba6a5013,    2},
  // sound - samples
  {"sz2.11"  ,0x200000,0xaa47a601,    2},
  {"sz2.12"  ,0x200000,0x2237bc53,    2},
};

STD_ROM_PICK(Sfz2ah) STD_ROM_FN(Sfz2ah)

struct BurnDriverX BurnDrvCpsSfz2ah=
{
  {"sfz2ah" ,"Street Fighter Zero 2 Alpha (Hispanic 960813)","Encrypted","Capcom","CPS2","1996","sfa2", NULL},
  0,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfz2ahRomInfo, Sfz2ahRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//======================================
//Street Fighter Zero 2 Alpha (Asia)
//======================================


static struct BurnRomInfo Sfz2aaRomDesc[]=
{
  {"szaax.03" ,0x80000,0xa75f58bf, 0x10}, // xor decryption table
  {"szaax.04" ,0x80000,0xd02351ab, 0x10}, // xor decryption table

  {"szaa.03"  ,0x80000,0x88e7023e, 0x10}, // 68000 code (encrypted)
  {"szaa.04"  ,0x80000,0xae8ec36e, 0x10},
  {"szaa.05"  ,0x80000,0xf053a55e, 0x10},
  {"szaa.06"  ,0x80000,0xcfc0e7a8, 0x10},
  {"szaa.07"  ,0x80000,0x5feb8b20, 0x10},
  {"szaa.08"  ,0x80000,0x6eb6d412, 0x10},

  {"sz2.13"  ,0x400000,0x4d1f1f22,    1}, // 8
  {"sz2.15"  ,0x400000,0x19cea680,    1},
  {"sz2.17"  ,0x400000,0xe01b4588,    1},
  {"sz2.19"  ,0x400000,0x0feeda64,    1},
  {"sz2.14"  ,0x100000,0x0560c6aa,    1},
  {"sz2.16"  ,0x100000,0xae940f87,    1},
  {"sz2.18"  ,0x100000,0x4bc3c8bc,    1},
  {"sz2.20"  ,0x100000,0x39e674c0,    1},

  {"sz2.01a"  ,0x020000,0x1bc323cf,    2}, // 16
  {"sz2.02a"  ,0x020000,0xba6a5013,    2},
  // sound - samples
  {"sz2.11"  ,0x200000,0xaa47a601,    2},
  {"sz2.12"  ,0x200000,0x2237bc53,    2},
};

STD_ROM_PICK(Sfz2aa) STD_ROM_FN(Sfz2aa)

struct BurnDriver BurnDrvCpsSfz2aa=
{
  {"sfz2aa" ,"Street Fighter Zero 2 Alpha (Asia 960826)","","Capcom","CPS2","1996","sfa2", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Sfz2aaRomInfo, Sfz2aaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
