#include "cps.h"

/*============================
Rockman 2 - The Power Fighters
============================*/

static struct BurnInputInfo DrvInputList[] =
{
	{"P1 Coin"       , 0, CpsInp020 + 4, "p1 coin"   },
	{"P1 Start"      , 0, CpsInp020 + 0, "p1 start"  },
	{"P1 Up"         , 0, CpsInp001 + 3, "p1 up"     },
	{"P1 Down"       , 0, CpsInp001 + 2, "p1 down"   },
	{"P1 Left"       , 0, CpsInp001 + 1, "p1 left"   },
	{"P1 Right"      , 0, CpsInp001 + 0, "p1 right"  },
	{"P1 Attack"     , 0, CpsInp001 + 4, "p1 fire 1" },
	{"P1 Jump"       , 0, CpsInp001 + 5, "p1 fire 2" },
	{"P1 Select"     , 0, CpsInp001 + 6, "p1 fire 3" },

	{"P2 Coin"       , 0, CpsInp020 + 5, "p2 coin"   },
	{"P2 Start"      , 0, CpsInp020 + 1, "p2 start"  },
	{"P2 Up"         , 0, CpsInp000 + 3, "p2 up"     },
	{"P2 Down"       , 0, CpsInp000 + 2, "p2 down"   },
	{"P2 Left"       , 0, CpsInp000 + 1, "p2 left"   },
	{"P2 Right"      , 0, CpsInp000 + 0, "p2 right"  },
	{"P2 Attack"     , 0, CpsInp000 + 4, "p2 fire 1" },
	{"P2 Jump"       , 0, CpsInp000 + 5, "p2 fire 2" },
	{"P2 Select"     , 0, CpsInp000 + 6, "p2 fire 3" },

	{"Reset"         , 0, &CpsReset    , "reset"     },
	{"Diagnostic"    , 0, CpsInp021 + 1, "diag"      },
	{"Service"       , 0, CpsInp021 + 2, "service"   },
};

STDINPUTINFO(Drv);


static int DrvInit()
{
	int nRet = 0; int i = 0; unsigned char *pqs = NULL;

	Cps = 2;
	nCpsRomLen  = 3 * 0x080000;
	nCpsCodeLen = 2 * 0x080000;
	nCpsGfxLen  = 4 * 0x200000;
	nCpsZRomLen = 2 * 0x020000;
	nCpsQSamLen = 2 * 0x200000;
	nRet = CpsInit(); if (nRet != 0) return 1;

	// Load program roms (as they are on the roms) for CpsRom
	for (i = 0; i < 3; i++)
	{ nRet = BurnLoadRom(CpsRom + 0x080000 * i, 2 + i, 1); if (nRet != 0) return 1; }

	// Make decrypted rom
	memcpy(CpsCode, CpsRom, nCpsCodeLen);
	nRet = BurnXorRom(CpsCode           , 0, 1); if (nRet != 0) return 1;
	nRet = BurnXorRom(CpsCode + 0x080000, 1, 1); if (nRet != 0) return 1;

	// Load graphics roms
	Cps2LoadTiles(CpsGfx, 5);

	nRet = BurnLoadRom(CpsZRom          ,  9, 1);
	nRet = BurnLoadRom(CpsZRom + 0x20000, 10, 1);

	pqs = (unsigned char *)CpsQSam;
	nRet = BurnLoadRom(pqs           , 11, 1);
	nRet = BurnLoadRom(pqs + 0x200000, 12, 1);
	BurnByteswap(pqs, nCpsQSamLen);

	nRet = CpsRunInit();

	if (nRet != 0) return 1;
	return 0;
}

static int DrvExit()
{

	CpsRunExit();
	CpsExit();
	nCpsQSamLen = 0;
	nCpsZRomLen = 0;
	nCpsGfxLen  = 0;
	nCpsCodeLen = 0;
	nCpsRomLen  = 0;
	Cps = 0;
	return 0;
}

/*=================
 Megaman 2 (USA)
=================*/


static struct BurnRomInfo Megaman2RomDesc[]=
{
	{"rm2ux.03"  , 0x080000, 0x93e28bde, 0x10},
	{"rm2ux.04"  , 0x080000, 0x74ebf83c, 0x10},

	{"rm2u.03"   , 0x080000, 0x8ffc2cd1, 0x10},
	{"rm2u.04"   , 0x080000, 0xbb30083a, 0x10},
	{"rm2.05"    , 0x080000, 0x02ee9efc, 0x10},

	{"rm2.14"    , 0x200000, 0x9b1f00b4,    1},
	{"rm2.16"    , 0x200000, 0xc2bb0c24,    1},
	{"rm2.18"    , 0x200000, 0x12257251,    1},
	{"rm2.20"    , 0x200000, 0xf9b6e786,    1},

	{"rm2.01a"   , 0x020000, 0xd18e7859,    2},
	{"rm2.02"    , 0x020000, 0xc463ece0,    2},

	{"rm2.11"    , 0x200000, 0x2106174d,    2},
	{"rm2.12"    , 0x200000, 0x546c1636,    2},
};

STD_ROM_PICK(Megaman2) STD_ROM_FN(Megaman2)

struct BurnDriver BurnDrvCpsMegaman2=
{
	{"megaman2", "Megaman 2: The Power Fighters (US 960708)", "", "Capcom", "CPS2", "1996", NULL, NULL},
	1, 2, HARDWARE_CAPCOM_CPS2,
	NULL, Megaman2RomInfo, Megaman2RomName, DrvInputInfo, NULL,
	DrvInit, DrvExit, Cps2Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal ,384, 224, 4, 3
};

/*=================
 Rockman 2 (Japan)
=================*/


static struct BurnRomInfo Rckman2jRomDesc[]=
{
	{"rm2jx.03"  , 0x080000, 0x2c297750, 0x10},
	{"rm2jx.04"  , 0x080000, 0x676a116e, 0x10},

	{"rm2j.03"   , 0x080000, 0xdbaa1437, 0x10},
	{"rm2j.04"   , 0x080000, 0xcf5ba612, 0x10},
	{"rm2.05"    , 0x080000, 0x02ee9efc, 0x10},

	{"rm2.14"    , 0x200000, 0x9b1f00b4,    1},
	{"rm2.16"    , 0x200000, 0xc2bb0c24,    1},
	{"rm2.18"    , 0x200000, 0x12257251,    1},
	{"rm2.20"    , 0x200000, 0xf9b6e786,    1},

	{"rm2.01a"   , 0x020000, 0xd18e7859,    2},
	{"rm2.02"    , 0x020000, 0xc463ece0,    2},

	{"rm2.11"    , 0x200000, 0x2106174d,    2},
	{"rm2.12"    , 0x200000, 0x546c1636,    2},
};

STD_ROM_PICK(Rckman2j) STD_ROM_FN(Rckman2j)

struct BurnDriver BurnDrvCpsRckman2j=
{
	{"rckman2j", "Rockman 2: The Power Fighters (Japan 960708)", "", "Capcom", "CPS2", "1996", "megaman2", NULL},
	1, 2, HARDWARE_CAPCOM_CPS2,
	NULL, Rckman2jRomInfo, Rckman2jRomName, DrvInputInfo, NULL,
	DrvInit, DrvExit, Cps2Frame, CpsRedraw, CpsAreaScan,
	&CpsRecalcPal, 384, 224, 4, 3
};
