// Marvel Super Heroes

#include "cps.h"

STDINPUTINFOSPEC(Drv, CpsFsi);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  8*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=  8*0x400000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms (as they are on the roms) for CpsRom
  for (i=0;i<8;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  // Make decrypted rom
  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
  nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

  // Load graphics roms
  nRet=Cps2LoadTiles(CpsGfx           ,10);
  nRet=Cps2LoadTiles(CpsGfx+4*0x400000,14);

  // Load Z80 Roms
  nRet=BurnLoadRom(CpsZRom         ,18,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);

  // Load Q Sample Roms
  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,20,1);
  nRet=BurnLoadRom(pqs+0x200000,21,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit();

  if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}


//=========================
//Marvel Super Heroes (USA)
//=========================


static struct BurnRomInfo MshRomDesc[]=
{
  {"mshux.03",0x80000,0x10bfc357, 0x10}, // xor decryption table
  {"mshux.04",0x80000,0x871f0863, 0x10},

  {"mshu.03" ,0x80000,0xd2805bdd, 0x10}, // 68000 code (encrypted)
  {"mshu.04" ,0x80000,0x743f96ff, 0x10},
  {"msh.05"  ,0x80000,0x6a091b9e, 0x10},
  {"msh.06b" ,0x80000,0x803e3fa4, 0x10},
  {"msh.07a" ,0x80000,0xc45f8e27, 0x10},
  {"msh.08a" ,0x80000,0x9ca6f12c, 0x10},
  {"msh.09a" ,0x80000,0x82ec27af, 0x10},
  {"msh.10b" ,0x80000,0x8d931196, 0x10},

  // graphics:
  {"msh.13"  ,0x400000,0x09d14566,    1}, // 10
  {"msh.15"  ,0x400000,0xee962057,    1},
  {"msh.17"  ,0x400000,0x604ece14,    1},
  {"msh.19"  ,0x400000,0x94a731e8,    1},
  {"msh.14"  ,0x400000,0x4197973e,    1},
  {"msh.16"  ,0x400000,0x438da4a0,    1},
  {"msh.18"  ,0x400000,0x4db92d94,    1},
  {"msh.20"  ,0x400000,0xa2b0c6c0,    1},

  // sound - z80 roms
  {"msh.01"  ,0x020000,0xc976e6f9,    2}, // 18
  {"msh.02"  ,0x020000,0xce67d0d9,    2},
  // sound - samples
  {"msh.11"  ,0x200000,0x37ac6d30,    2},
  {"msh.12"  ,0x200000,0xde092570,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Msh) STD_ROM_FN(Msh)

struct BurnDriver BurnDrvCpsMsh=
{
  {"msh" ,"Marvel Super Heroes (US 951024)","","Capcom","CPS2","1995",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, MshRomInfo, MshRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==============================
//Marvel Super Heroes (Hispanic)
//==============================


static struct BurnRomInfo MshhRomDesc[]=
{
  {"mshhx.03c",0x80000,0x6daf52bb, 0x10}, // xor decryption table
  {"mshhx.04c",0x80000,0x5684655a, 0x10},

  {"mshh.03c" ,0x80000,0x8d84b0fa, 0x10}, // 68000 code (encrypted)
  {"mshh.04c" ,0x80000,0xd638f601, 0x10},
  {"mshh.05a" ,0x80000,0xf37539e6, 0x10},
  {"msh.06b"  ,0x80000,0x803e3fa4, 0x10},
  {"msh.07a"  ,0x80000,0xc45f8e27, 0x10},
  {"msh.08a"  ,0x80000,0x9ca6f12c, 0x10},
  {"msh.09a"  ,0x80000,0x82ec27af, 0x10},
  {"msh.10b"  ,0x80000,0x8d931196, 0x10},

  // graphics:
  {"msh.13"  ,0x400000,0x09d14566,    1}, // 10
  {"msh.15"  ,0x400000,0xee962057,    1},
  {"msh.17"  ,0x400000,0x604ece14,    1},
  {"msh.19"  ,0x400000,0x94a731e8,    1},
  {"msh.14"  ,0x400000,0x4197973e,    1},
  {"msh.16"  ,0x400000,0x438da4a0,    1},
  {"msh.18"  ,0x400000,0x4db92d94,    1},
  {"msh.20"  ,0x400000,0xa2b0c6c0,    1},

  // sound - z80 roms
  {"msh.01"  ,0x020000,0xc976e6f9,    2}, // 18
  {"msh.02"  ,0x020000,0xce67d0d9,    2},
  // sound - samples
  {"msh.11"  ,0x200000,0x37ac6d30,    2},
  {"msh.12"  ,0x200000,0xde092570,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Mshh) STD_ROM_FN(Mshh)

struct BurnDriver BurnDrvCpsMshh=
{
  {"mshh" ,"Marvel Super Heroes (Hispanic 951117)","","Capcom","CPS2","1995","msh", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, MshhRomInfo, MshhRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//===========================
//Marvel Super Heroes (Japan)
//===========================


static struct BurnRomInfo MshjRomDesc[]=
{
  {"mshjx.03f",0x80000,0xa15f32f2, 0x10}, // xor decryption table
  {"mshjx.04f",0x80000,0xc81be228, 0x10},

  {"mshj.03f" ,0x80000,0xff172fd2, 0x10}, // 68000 code (encrypted)
  {"mshj.04f" ,0x80000,0xebbb205a, 0x10},
  {"msh.05"   ,0x80000,0x6a091b9e, 0x10},
  {"msh.06b"  ,0x80000,0x803e3fa4, 0x10},
  {"msh.07a"  ,0x80000,0xc45f8e27, 0x10},
  {"msh.08a"  ,0x80000,0x9ca6f12c, 0x10},
  {"msh.09a"  ,0x80000,0x82ec27af, 0x10},
  {"msh.10b"  ,0x80000,0x8d931196, 0x10},

  // graphics:
  {"msh.13"  ,0x400000,0x09d14566,    1}, // 10
  {"msh.15"  ,0x400000,0xee962057,    1},
  {"msh.17"  ,0x400000,0x604ece14,    1},
  {"msh.19"  ,0x400000,0x94a731e8,    1},
  {"msh.14"  ,0x400000,0x4197973e,    1},
  {"msh.16"  ,0x400000,0x438da4a0,    1},
  {"msh.18"  ,0x400000,0x4db92d94,    1},
  {"msh.20"  ,0x400000,0xa2b0c6c0,    1},

  // sound - z80 roms
  {"msh.01"  ,0x020000,0xc976e6f9,    2}, // 18
  {"msh.02"  ,0x020000,0xce67d0d9,    2},
  // sound - samples
  {"msh.11"  ,0x200000,0x37ac6d30,    2},
  {"msh.12"  ,0x200000,0xde092570,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Mshj) STD_ROM_FN(Mshj)

struct BurnDriver BurnDrvCpsMshj=
{
  {"mshj" ,"Marvel Super Heroes (Japan 951024)","","Capcom","CPS2","1995","msh", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, MshjRomInfo, MshjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//==========================
//Marvel Super Heroes (Asia)
//==========================


static struct BurnRomInfo MshaRomDesc[]=
{
  {"mshax.03e",0x80000,0x7423947b, 0x10}, // xor decryption table
  {"mshax.04e",0x80000,0xbd4a3071, 0x10},

  {"msha.03e" ,0x80000,0xec84ec44, 0x10}, // 68000 code (encrypted)
  {"msha.04e" ,0x80000,0x098b8503, 0x10},
  {"msh.05"   ,0x80000,0x6a091b9e, 0x10},
  {"msh.06b"  ,0x80000,0x803e3fa4, 0x10},
  {"msh.07a"  ,0x80000,0xc45f8e27, 0x10},
  {"msh.08a"  ,0x80000,0x9ca6f12c, 0x10},
  {"msh.09a"  ,0x80000,0x82ec27af, 0x10},
  {"msh.10b"  ,0x80000,0x8d931196, 0x10},

  // graphics:
  {"msh.13"  ,0x400000,0x09d14566,    1}, // 10
  {"msh.15"  ,0x400000,0xee962057,    1},
  {"msh.17"  ,0x400000,0x604ece14,    1},
  {"msh.19"  ,0x400000,0x94a731e8,    1},
  {"msh.14"  ,0x400000,0x4197973e,    1},
  {"msh.16"  ,0x400000,0x438da4a0,    1},
  {"msh.18"  ,0x400000,0x4db92d94,    1},
  {"msh.20"  ,0x400000,0xa2b0c6c0,    1},

  // sound - z80 roms
  {"msh.01"  ,0x020000,0xc976e6f9,    2}, // 18
  {"msh.02"  ,0x020000,0xce67d0d9,    2},
  // sound - samples
  {"msh.11"  ,0x200000,0x37ac6d30,    2},
  {"msh.12"  ,0x200000,0xde092570,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Msha) STD_ROM_FN(Msha)

struct BurnDriver BurnDrvCpsMsha=
{
  {"msha" ,"Marvel Super Heroes (Asia 951024)","","Capcom","CPS2","1995","msh", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, MshaRomInfo, MshaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

