// Tenchi wo Kurau

#include "cps.h"

static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"         , 0, CpsInp018+0, "p1 coin"},
  {"P1 Start"        , 0, CpsInp018+4, "p1 start"},
  {"P1 Up"           , 0, CpsInp001+3, "p1 up"},
  {"P1 Down"         , 0, CpsInp001+2, "p1 down"},
  {"P1 Left"         , 0, CpsInp001+1, "p1 left"},
  {"P1 Right"        , 0, CpsInp001+0, "p1 right"},
  {"P1 Attack Left"  , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 Attack Right" , 0, CpsInp001+5, "p1 fire 2"},
  {"P1 Special"      , 0, CpsInp001+6, "p1 fire 3"},

  {"P2 Coin"         , 0, CpsInp018+1, "p2 coin"},
  {"P2 Start"        , 0, CpsInp018+5, "p2 start"},
  {"P2 Up"           , 0, CpsInp000+3, "p2 up"},
  {"P2 Down"         , 0, CpsInp000+2, "p2 down"},
  {"P2 Left"         , 0, CpsInp000+1, "p2 left"},
  {"P2 Right"        , 0, CpsInp000+0, "p2 right"},
  {"P2 Attack Left"  , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 Attack Right" , 0, CpsInp000+5, "p2 fire 2"},
  {"P2 Special"      , 0, CpsInp000+6, "p2 fire 3"},

  {"Reset"           , 0, &CpsReset,   "reset"},
  {"Diagnostic"      , 0, CpsInp018+6, "diag"},
  {"Service"         , 0, CpsInp018+2, "service"},
  {"Dip A"           , 2, &Cpi01A    , "dip"},
  {"Dip B"           , 2, &Cpi01C    , "dip"},
  {"Dip C"           , 2, &Cpi01E    , "dip"},
};

STDINPUTINFO(Drv);

static struct BurnDIPInfo dwDIPList[]=
{
	// Defaults
	{0x15, 0xff, 0xff, 0x00, NULL                },
	{0x16, 0xff, 0xff, 0x00, NULL                },
	{0x17, 0xff, 0xff, 0x00, NULL                },

	// Dip A
        {0   , 0xfe, 0   , 7   , "Coin 1"            },
	{0x15, 0x01, 0x07, 0x06, "4 Coins 1 Credit"  },
	{0x15, 0x01, 0x07, 0x05, "3 Coins 1 Credit"  },
	{0x15, 0x01, 0x07, 0x04, "2 Coins 1 Credit"  },
	{0x15, 0x01, 0x07, 0x00, "1 Coin 1 Credit"   },
	{0x15, 0x01, 0x07, 0x01, "1 Coin 2 Credits"  },
	{0x15, 0x01, 0x07, 0x02, "1 Coin 3 Credits"  },
	{0x15, 0x01, 0x07, 0x03, "1 Coin 4 Credits"  },

        {0   , 0xfe, 0   , 7   , "Coin 2"            },
	{0x15, 0x01, 0x38, 0x30, "4 Coins 1 Credit"  },
	{0x15, 0x01, 0x38, 0x28, "3 Coins 1 Credit"  },
	{0x15, 0x01, 0x38, 0x20, "2 Coins 1 Credit"  },
	{0x15, 0x01, 0x38, 0x00, "1 Coin 1 Credit"   },
	{0x15, 0x01, 0x38, 0x08, "1 Coin 2 Credits"  },
	{0x15, 0x01, 0x38, 0x10, "1 Coin 3 Credits"  },
	{0x15, 0x01, 0x38, 0x18, "1 Coin 4 Credits"  },

//	{0   , 0xfe, 0   , 2   , "Unknown"           },
//	{0x15, 0x01, 0x40, 0x00, "Off"               },
//	{0x15, 0x01, 0x40, 0x40, "On"                },

        {0   , 0xfe, 0   , 2   , "Free Play"         },
	{0x15, 0x01, 0x80, 0x00, "Off"               },
	{0x15, 0x01, 0x80, 0x80, "On"                },

	// Dip B
	{0   , 0xfe, 0   , 8   , "Difficulty"        },
	{0x16, 0x01, 0x07, 0x03, "Very Easy"         },
	{0x16, 0x01, 0x07, 0x02, "Easy 2"            },
	{0x16, 0x01, 0x07, 0x01, "Easy 1"            },
	{0x16, 0x01, 0x07, 0x00, "Normal"            },
	{0x16, 0x01, 0x07, 0x04, "Difficult 1"       },
	{0x16, 0x01, 0x07, 0x05, "Difficult 2"       },
	{0x16, 0x01, 0x07, 0x06, "Difficult 3"       },
	{0x16, 0x01, 0x07, 0x07, "Very Difficult"    },

//	{0   , 0xfe, 0   , 2   , "Unknown"           },
//	{0x16, 0x01, 0x08, 0x00, "Off"               },
//	{0x16, 0x01, 0x08, 0x08, "On"                },

//	{0   , 0xfe, 0   , 2   , "Unknown"           },
//	{0x16, 0x01, 0x10, 0x00, "Off"               },
//	{0x16, 0x01, 0x10, 0x10, "On"                },

//	{0   , 0xfe, 0   , 2   , "Unknown"           },
//	{0x16, 0x01, 0x20, 0x00, "Off"               },
//	{0x16, 0x01, 0x20, 0x20, "On"                },

//	{0   , 0xfe, 0   , 2   , "Unknown"           },
//	{0x16, 0x01, 0x40, 0x00, "Off"               },
//	{0x16, 0x01, 0x40, 0x40, "On"                },

//	{0   , 0xfe, 0   , 2   , "Unknown"           },
//	{0x16, 0x01, 0x80, 0x00, "Off"               },
//	{0x16, 0x01, 0x80, 0x80, "On"                },

	// Dip C
	{0   , 0xfe, 0   , 2   , "Freeze"            },
	{0x17, 0x01, 0x01, 0x00, "Off"               },
	{0x17, 0x01, 0x01, 0x01, "On"                },

	{0   , 0xfe, 0   , 2   , "Turbo Mode"        },
	{0x17, 0x01, 0x02, 0x00, "Off"               },
	{0x17, 0x01, 0x02, 0x02, "On"                },

//	{0   , 0xfe, 0   , 2   , "Unknown"           },
//	{0x17, 0x01, 0x04, 0x00, "Off"               },
//	{0x17, 0x01, 0x04, 0x04, "On"                },

//	{0   , 0xfe, 0   , 2   , "Unknown"           },
//	{0x17, 0x01, 0x08, 0x00, "Off"               },
//	{0x17, 0x01, 0x08, 0x08, "On"                },

	{0   , 0xfe, 0   , 2   , "Flip"              },
	{0x17, 0x01, 0x10, 0x00, "Off"               },
	{0x17, 0x01, 0x10, 0x10, "On"                },

	{0   , 0xfe, 0   , 2   , "Demo Sound"        },
	{0x17, 0x01, 0x20, 0x00, "Off"               },
	{0x17, 0x01, 0x20, 0x20, "On"                },

	{0   , 0xfe, 0   , 2   , "Continue"          },
	{0x17, 0x01, 0x40, 0x00, "Off"               },
	{0x17, 0x01, 0x40, 0x40, "On"                },
};

STDDIPINFO(dw);


static int DrvInit()
{
  int nRet=0;
  Cps=1;
  nCpsRomLen=  0x100000;
  nCpsCodeLen= 0; // not encrypted
  nCpsGfxLen=  8*0x080000;
  nCpsZRomLen= 0x010000;
  nCpsAdLen=   2*0x020000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms
  nRet=BurnLoadRom(CpsRom+0x000001,0,2); if (nRet!=0) return 1;
  nRet=BurnLoadRom(CpsRom+0x000000,1,2); if (nRet!=0) return 1;
  nRet=BurnLoadRom(CpsRom+0x040001,2,2); if (nRet!=0) return 1;
  nRet=BurnLoadRom(CpsRom+0x040000,3,2); if (nRet!=0) return 1;
  nRet=BurnLoadRom(CpsRom+0x080001,4,2); if (nRet!=0) return 1;
  nRet=BurnLoadRom(CpsRom+0x080000,5,2); if (nRet!=0) return 1;
  nRet=BurnLoadRom(CpsRom+0x0c0001,6,2); if (nRet!=0) return 1;
  nRet=BurnLoadRom(CpsRom+0x0c0000,7,2); if (nRet!=0) return 1;

  // Load graphics roms
  CpsLoadTilesByte(CpsGfx,             8);
  CpsLoadTilesByte(CpsGfx+(0x100000), 16);
  CpsLoadTilesByte(CpsGfx+(0x200000), 24);
  CpsLoadTilesByte(CpsGfx+(0x300000), 32);

  nCpsGfxScroll[2]=0x200000;
  nCpsGfxScroll[3]=0x200000;

  nCpsLcReg=0x6c; // Layer control register is at 0x6c
  CpsLayEn[1]=0x02;
  CpsLayEn[2]=0x04;
  CpsLayEn[3]=0x08;

  MaskAddr[0]=0x6a;
  MaskAddr[1]=0x68;
  MaskAddr[2]=0x66;
  MaskAddr[3]=0x64;

  // Load Z80 Rom
  nRet=BurnLoadRom(CpsZRom,40,1);

  // Load ADPCM data
  nRet=BurnLoadRom(CpsAd        ,41,1);
  nRet=BurnLoadRom(CpsAd+0x20000,42,1);


  nRet=CpsRunInit(); if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{


  CpsRunExit();

  CpsExit();
  nCpsAdLen=0; nCpsZRomLen=0; nCpsGfxLen=0; nCpsRomLen=0;
  Cps=0;
  return 0;
}


//=======================
//Tenchi wo Kurau (Japan)
//=======================

// Count possible zip names and (if pszName!=NULL) return them

// Rom information
static struct BurnRomInfo DwjRomDesc[]=
{
  {"36.bin" ,0x20000,0x1a516657,0x10}, // 0 even 68000 code
  {"42.bin" ,0x20000,0x12a290a0,0x10}, // 1 odd
  {"37.bin" ,0x20000,0x932fc943,0x10}, // 2 even
  {"43.bin" ,0x20000,0x872ad76d,0x10}, // 3 odd
  {"34.bin" ,0x20000,0x8f663d00,0x10}, // 4 even 68000 code
  {"40.bin" ,0x20000,0x1586dbf3,0x10}, // 5 odd
  {"35.bin" ,0x20000,0x9db93d7a,0x10}, // 6 even
  {"41.bin" ,0x20000,0x1aae69a4,0x10}, // 7 odd

  // graphics:
  {"09.bin" ,0x20000,0xc3e83c69,   1}, // 8
  {"01.bin" ,0x20000,0x187b2886,   1},
  {"13.bin" ,0x20000,0x0273d87d,   1},
  {"05.bin" ,0x20000,0x339378b8,   1},
  {"24.bin" ,0x20000,0xc6909b6f,   1}, // 12
  {"17.bin" ,0x20000,0x2e2f8320,   1},
  {"38.bin" ,0x20000,0xcd7923ed,   1},
  {"32.bin" ,0x20000,0x21a0a453,   1},
  {"10.bin" ,0x20000,0xff28f8d0,   1}, // 16
  {"02.bin" ,0x20000,0xcc83c02f,   1},
  {"14.bin" ,0x20000,0x18fb232c,   1},
  {"06.bin" ,0x20000,0x6f9edd75,   1},
  {"25.bin" ,0x20000,0x152ea74a,   1}, // 20
  {"18.bin" ,0x20000,0x1833f932,   1},
  {"39.bin" ,0x20000,0xbc09b360,   1},
  {"33.bin" ,0x20000,0x89de1533,   1},
  {"11.bin" ,0x20000,0x29eaf490,   1}, // 24
  {"03.bin" ,0x20000,0x7bf51337,   1},
  {"15.bin" ,0x20000,0xd36cdb91,   1},
  {"07.bin" ,0x20000,0xe04af054,   1},
  {"26.bin" ,0x20000,0x07fc714b,   1}, // 28
  {"19.bin" ,0x20000,0x7114e5c6,   1},
  {"28.bin" ,0x20000,0xaf62bf07,   1},
  {"21.bin" ,0x20000,0x523f462a,   1},
  {"12.bin" ,0x20000,0x38652339,   1}, // 32
  {"04.bin" ,0x20000,0x4951bc0f,   1},
  {"16.bin" ,0x20000,0x381608ae,   1},
  {"08.bin" ,0x20000,0xb475d4e9,   1},
  {"27.bin" ,0x20000,0xa27e81fa,   1}, // 36
  {"20.bin" ,0x20000,0x002796dc,   1},
  {"29.bin" ,0x20000,0x6b41f82d,   1},
  {"22.bin" ,0x20000,0x52145369,   1},

  // z80 rom
  {"23.bin" ,0x10000,0xb3b79d4f,   1}, // 40
  // samples
  {"30.bin" ,0x20000,0x7e5f6cb4,   1},
  {"31.bin" ,0x20000,0x4a30c737,   1},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Dwj) STD_ROM_FN(Dwj)

struct BurnDriver BurnDrvCpsDwj=
{
  {"dwj","Tenchi wo Kurau (Japan)","","Capcom","CPS1","1989","dw", NULL},
  1,2,HARDWARE_CAPCOM_CPS1,
  NULL,DwjRomInfo,DwjRomName,DrvInputInfo, dwDIPInfo,
  DrvInit,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

//====================
//Dynasty Wars (World)
//====================

// Count possible zip names and (if pszName!=NULL) return them

// Rom information
static struct BurnRomInfo DwRomDesc[]=
{
  {"d_wars30.11f" ,0x20000,0xf9ec6d68,0x10}, // 0 even 68000 code
  {"d_wars35.11h" ,0x20000,0xe41fff2f,0x10}, // 1 odd
  {"d_wars31.12f" ,0x20000,0xe3de76ff,0x10}, // 2 even
  {"d_wars36.12h" ,0x20000,0x7a13cfbf,0x10}, // 3 odd
  {"34.bin"       ,0x20000,0x8f663d00,0x10}, // 4 even 68000 code
  {"40.bin"       ,0x20000,0x1586dbf3,0x10}, // 5 odd
  {"35.bin"       ,0x20000,0x9db93d7a,0x10}, // 6 even
  {"41.bin"       ,0x20000,0x1aae69a4,0x10}, // 7 odd

  // graphics:
  {"09.bin"       ,0x20000,0xc3e83c69,   1}, // 8
  {"01.bin"       ,0x20000,0x187b2886,   1},
  {"13.bin"       ,0x20000,0x0273d87d,   1},
  {"05.bin"       ,0x20000,0x339378b8,   1},
  {"24.bin"       ,0x20000,0xc6909b6f,   1}, // 12
  {"17.bin"       ,0x20000,0x2e2f8320,   1},
  {"38.bin"       ,0x20000,0xcd7923ed,   1},
  {"32.bin"       ,0x20000,0x21a0a453,   1},
  {"10.bin"       ,0x20000,0xff28f8d0,   1}, // 16
  {"02.bin"       ,0x20000,0xcc83c02f,   1},
  {"14.bin"       ,0x20000,0x18fb232c,   1},
  {"06.bin"       ,0x20000,0x6f9edd75,   1},
  {"25.bin"       ,0x20000,0x152ea74a,   1}, // 20
  {"18.bin"       ,0x20000,0x1833f932,   1},
  {"39.bin"       ,0x20000,0xbc09b360,   1},
  {"33.bin"       ,0x20000,0x89de1533,   1},
  {"11.bin"       ,0x20000,0x29eaf490,   1}, // 24
  {"03.bin"       ,0x20000,0x7bf51337,   1},
  {"15.bin"       ,0x20000,0xd36cdb91,   1},
  {"07.bin"       ,0x20000,0xe04af054,   1},
  {"26.bin"       ,0x20000,0x07fc714b,   1}, // 28
  {"19.bin"       ,0x20000,0x7114e5c6,   1},
  {"28.bin"       ,0x20000,0xaf62bf07,   1},
  {"21.bin"       ,0x20000,0x523f462a,   1},
  {"12.bin"       ,0x20000,0x38652339,   1}, // 32
  {"04.bin"       ,0x20000,0x4951bc0f,   1},
  {"16.bin"       ,0x20000,0x381608ae,   1},
  {"08.bin"       ,0x20000,0xb475d4e9,   1},
  {"27.bin"       ,0x20000,0xa27e81fa,   1}, // 36
  {"20.bin"       ,0x20000,0x002796dc,   1},
  {"29.bin"       ,0x20000,0x6b41f82d,   1},
  {"22.bin"       ,0x20000,0x52145369,   1},

  // z80 rom
  {"23.bin"       ,0x10000,0xb3b79d4f,   1}, // 40
  // samples
  {"d_wars18.11c" ,0x20000,0xac6e307d,   1},
  {"d_wars19.12c" ,0x20000,0x068741db,   1},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Dw) STD_ROM_FN(Dw)

struct BurnDriver BurnDrvCpsDw=
{
  {"dw","Dynasty Wars (World)","","Capcom","CPS1","1989",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS1,
  NULL,DwRomInfo,DwRomName,DrvInputInfo, dwDIPInfo,
  DrvInit,DrvExit,Cps1Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
