#include "cps.h"

/*==========================================================
 Darkstalkers: The Night Warriors
==========================================================*/

STDINPUTINFOSPEC(Drv, CpsFsi);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  8*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=   0x1400000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms (as they are on the roms) for CpsRom
  for (i=0;i<8;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  // Make decrypted rom
  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
  nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

  // Load graphics roms
  nRet=Cps2LoadTiles(CpsGfx           ,10);
  nRet=Cps2LoadTiles(CpsGfx+ 0x1000000,14);

  // Load Z80 Roms
  nRet=BurnLoadRom(CpsZRom         ,18,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);

  // Load Q Sample Roms
  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,20,1);
  nRet=BurnLoadRom(pqs+0x200000,21,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit(); if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}


/*===================================
 Vampire: The Night Warriors (Japan)
===================================*/


static struct BurnRomInfo VampjRomDesc[]=
{
  {"vamjx.03a",0x80000,0x2549f7bc, 0x10},
  {"vamjx.04b",0x80000,0xbb5a30a5, 0x10},

  {"vamj.03a" ,0x80000,0xf55d3722, 0x10},
  {"vamj.04b" ,0x80000,0x4d9c43c4, 0x10},
  {"vamj.05a" ,0x80000,0x6c497e92, 0x10},
  {"vamj.06a" ,0x80000,0xf1bbecb6, 0x10},
  {"vamj.07a" ,0x80000,0x1067ad84, 0x10},
  {"vamj.08a" ,0x80000,0x4b89f41f, 0x10},
  {"vamj.09a" ,0x80000,0xfc0a4aac, 0x10},
  {"vamj.10a" ,0x80000,0x9270c26b, 0x10},

  {"vam.13"  ,0x400000,0xc51baf99,    1},
  {"vam.15"  ,0x400000,0x3ce83c77,    1},
  {"vam.17"  ,0x400000,0x4f2408e0,    1},
  {"vam.19"  ,0x400000,0x9ff60250,    1},
  {"vam.14"  ,0x100000,0xbd87243c,    1},
  {"vam.16"  ,0x100000,0xafec855f,    1},
  {"vam.18"  ,0x100000,0x3a033625,    1},
  {"vam.20"  ,0x100000,0x2bff6a89,    1},

  {"vam.01"  ,0x020000,0x64b685d5,    2},
  {"vam.02"  ,0x020000,0xcf7c97c7,    2},

  {"vam.11"  ,0x200000,0x4a39deb2,    2},
  {"vam.12"  ,0x200000,0x1a3e5c03,    2},

};

STD_ROM_PICK(Vampj) STD_ROM_FN(Vampj)

struct BurnDriver BurnDrvCpsVampj=
{
  {"vampj" ,"Vampire: The Night Warriors (Japan 940705)","","Capcom","CPS2","1994","dstlk", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, VampjRomInfo, VampjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*=======================================
 Vampire: The Night Warriors (Japan alt)
=======================================*/


static struct BurnRomInfo VampjaRomDesc[]=
{
  {"vamjx.03a",0x80000,0x2549f7bc, 0x10},
  {"vamjx.04a",0x80000,0xfe64a5cf, 0x10},

  {"vamj.03a" ,0x80000,0xf55d3722, 0x10},
  {"vamj.04a" ,0x80000,0xfdcbdae3, 0x10},
  {"vamj.05a" ,0x80000,0x6c497e92, 0x10},
  {"vamj.06a" ,0x80000,0xf1bbecb6, 0x10},
  {"vamj.07a" ,0x80000,0x1067ad84, 0x10},
  {"vamj.08a" ,0x80000,0x4b89f41f, 0x10},
  {"vamj.09a" ,0x80000,0xfc0a4aac, 0x10},
  {"vamj.10a" ,0x80000,0x9270c26b, 0x10},

  {"vam.13"  ,0x400000,0xc51baf99,    1},
  {"vam.15"  ,0x400000,0x3ce83c77,    1},
  {"vam.17"  ,0x400000,0x4f2408e0,    1},
  {"vam.19"  ,0x400000,0x9ff60250,    1},
  {"vam.14"  ,0x100000,0xbd87243c,    1},
  {"vam.16"  ,0x100000,0xafec855f,    1},
  {"vam.18"  ,0x100000,0x3a033625,    1},
  {"vam.20"  ,0x100000,0x2bff6a89,    1},

  {"vam.01"  ,0x020000,0x64b685d5,    2},
  {"vam.02"  ,0x020000,0xcf7c97c7,    2},

  {"vam.11"  ,0x200000,0x4a39deb2,    2},
  {"vam.12"  ,0x200000,0x1a3e5c03,    2},

};

STD_ROM_PICK(Vampja) STD_ROM_FN(Vampja)

struct BurnDriver BurnDrvCpsVampja=
{
  {"vampja" ,"Vampire: The Night Warriors (Japan 940705 alt)","","Capcom","CPS2","1994","dstlk", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, VampjaRomInfo, VampjaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*======================================
 Vampire: The Night Warriors (Japan r1)
======================================*/


static struct BurnRomInfo Vampjr1RomDesc[]=
{
  {"vamjx.03",0x80000,0xf6fe646a, 0x10},
  {"vamjx.04",0x80000,0x566014e5, 0x10},

  {"vamj.03" ,0x80000,0x8895bf77, 0x10},
  {"vamj.04" ,0x80000,0x5027db3d, 0x10},
  {"vamj.05" ,0x80000,0x97c66fdb, 0x10},
  {"vamj.06" ,0x80000,0x9b4c3426, 0x10},
  {"vamj.07" ,0x80000,0x303bc4fd, 0x10},
  {"vamj.08" ,0x80000,0x3dea3646, 0x10},
  {"vamj.09" ,0x80000,0xc119a827, 0x10},
  {"vamj.10" ,0x80000,0x46593b79, 0x10},

  {"vam.13"  ,0x400000,0xc51baf99,    1},
  {"vam.15"  ,0x400000,0x3ce83c77,    1},
  {"vam.17"  ,0x400000,0x4f2408e0,    1},
  {"vam.19"  ,0x400000,0x9ff60250,    1},
  {"vam.14"  ,0x100000,0xbd87243c,    1},
  {"vam.16"  ,0x100000,0xafec855f,    1},
  {"vam.18"  ,0x100000,0x3a033625,    1},
  {"vam.20"  ,0x100000,0x2bff6a89,    1},

  {"vam.01"  ,0x020000,0x64b685d5,    2},
  {"vam.02"  ,0x020000,0xcf7c97c7,    2},

  {"vam.11"  ,0x200000,0x4a39deb2,    2},
  {"vam.12"  ,0x200000,0x1a3e5c03,    2},

};

STD_ROM_PICK(Vampjr1) STD_ROM_FN(Vampjr1)

struct BurnDriver BurnDrvCpsVampjr1=
{
  {"vampjr1" ,"Vampire: The Night Warriors (Japan 940630)","","Capcom","CPS2","1994","dstlk", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Vampjr1RomInfo, Vampjr1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*======================================
 Dalkstalkers: The Night Warriors (Euro)
======================================*/


static struct BurnRomInfo DstlkRomDesc[]=
{
  {"vamex.03a",0x80000,0x2d1e4919, 0x10},
  {"vamex.04a",0x80000,0xe5172837, 0x10},

  {"vame.03a" ,0x80000,0x004c9cff, 0x10},
  {"vame.04a" ,0x80000,0xae413ff2, 0x10},
  {"vame.05a" ,0x80000,0x60678756, 0x10},
  {"vame.06a" ,0x80000,0x912870b3, 0x10},
  {"vame.07a" ,0x80000,0xdabae3e8, 0x10},
  {"vame.08a" ,0x80000,0x2c6e3077, 0x10},
  {"vame.09a" ,0x80000,0xf16db74b, 0x10},
  {"vame.10a" ,0x80000,0x701e2147, 0x10},

  {"vam.13"  ,0x400000,0xc51baf99,    1},
  {"vam.15"  ,0x400000,0x3ce83c77,    1},
  {"vam.17"  ,0x400000,0x4f2408e0,    1},
  {"vam.19"  ,0x400000,0x9ff60250,    1},
  {"vam.14"  ,0x100000,0xbd87243c,    1},
  {"vam.16"  ,0x100000,0xafec855f,    1},
  {"vam.18"  ,0x100000,0x3a033625,    1},
  {"vam.20"  ,0x100000,0x2bff6a89,    1},

  {"vam.01"  ,0x020000,0x64b685d5,    2},
  {"vam.02"  ,0x020000,0xcf7c97c7,    2},

  {"vam.11"  ,0x200000,0x4a39deb2,    2},
  {"vam.12"  ,0x200000,0x1a3e5c03,    2},

};

STD_ROM_PICK(Dstlk) STD_ROM_FN(Dstlk)

struct BurnDriver BurnDrvCpsDstlk=
{
  {"dstlk" ,"Darkstalkers: The Night Warriors (Euro 940705)","","Capcom","CPS2","1994",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, DstlkRomInfo, DstlkRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*======================================
 Dalkstalkers: The Night Warriors (USA)
======================================*/


static struct BurnRomInfo DstlkuRomDesc[]=
{
  {"vamux.03b",0x80000,0x15ff2d3e, 0x10},
  {"vamux.04b",0x80000,0x4cf62f1b, 0x10},

  {"vamu.03b" ,0x80000,0x68a6343f, 0x10},
  {"vamu.04b" ,0x80000,0x58161453, 0x10},
  {"vamu.05b" ,0x80000,0xdfc038b8, 0x10},
  {"vamu.06b" ,0x80000,0xc3842c89, 0x10},
  {"vamu.07b" ,0x80000,0x25b60b6e, 0x10},
  {"vamu.08b" ,0x80000,0x2113c596, 0x10},
  {"vamu.09b" ,0x80000,0x2d1e9ae5, 0x10},
  {"vamu.10b" ,0x80000,0x81145622, 0x10},

  {"vam.13"  ,0x400000,0xc51baf99,    1},
  {"vam.15"  ,0x400000,0x3ce83c77,    1},
  {"vam.17"  ,0x400000,0x4f2408e0,    1},
  {"vam.19"  ,0x400000,0x9ff60250,    1},
  {"vam.14"  ,0x100000,0xbd87243c,    1},
  {"vam.16"  ,0x100000,0xafec855f,    1},
  {"vam.18"  ,0x100000,0x3a033625,    1},
  {"vam.20"  ,0x100000,0x2bff6a89,    1},

  {"vam.01"  ,0x020000,0x64b685d5,    2},
  {"vam.02"  ,0x020000,0xcf7c97c7,    2},

  {"vam.11"  ,0x200000,0x4a39deb2,    2},
  {"vam.12"  ,0x200000,0x1a3e5c03,    2},

};

STD_ROM_PICK(Dstlku) STD_ROM_FN(Dstlku)

struct BurnDriver BurnDrvCpsDstlku=
{
  {"dstlku" ,"Darkstalkers: The Night Warriors (US 940818)","","Capcom","CPS2","1994","dstlk", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, DstlkuRomInfo, DstlkuRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*=========================================
 Dalkstalkers: The Night Warriors (USA r1)
=========================================*/


static struct BurnRomInfo Dstlkur1RomDesc[]=
{
  {"vamux.03a",0x80000,0xdb0837f5, 0x10},
  {"vamux.04a",0x80000,0x8a924055, 0x10},

  {"vamu.03a" ,0x80000,0x628899f9, 0x10},
  {"vamu.04a" ,0x80000,0x696d9b25, 0x10},
  {"vamu.05a" ,0x80000,0x673ed50a, 0x10},
  {"vamu.06a" ,0x80000,0xf2377be7, 0x10},
  {"vamu.07a" ,0x80000,0xd8f498c4, 0x10},
  {"vamu.08a" ,0x80000,0xe6a8a1a0, 0x10},
  {"vamu.09a" ,0x80000,0x8dd55b24, 0x10},
  {"vamu.10a" ,0x80000,0xc1a3d9be, 0x10},

  {"vam.13"  ,0x400000,0xc51baf99,    1},
  {"vam.15"  ,0x400000,0x3ce83c77,    1},
  {"vam.17"  ,0x400000,0x4f2408e0,    1},
  {"vam.19"  ,0x400000,0x9ff60250,    1},
  {"vam.14"  ,0x100000,0xbd87243c,    1},
  {"vam.16"  ,0x100000,0xafec855f,    1},
  {"vam.18"  ,0x100000,0x3a033625,    1},
  {"vam.20"  ,0x100000,0x2bff6a89,    1},

  {"vam.01"  ,0x020000,0x64b685d5,    2},
  {"vam.02"  ,0x020000,0xcf7c97c7,    2},

  {"vam.11"  ,0x200000,0x4a39deb2,    2},
  {"vam.12"  ,0x200000,0x1a3e5c03,    2},

};

STD_ROM_PICK(Dstlkur1) STD_ROM_FN(Dstlkur1)

struct BurnDriver BurnDrvCpsDstlkur1=
{
  {"dstlkur1" ,"Darkstalkers: The Night Warriors (US 940705)","","Capcom","CPS2","1994","dstlk", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, Dstlkur1RomInfo, Dstlkur1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*======================================
 Darkstalkers: The Night Warriors (Asia)
======================================*/


static struct BurnRomInfo DstlkaRomDesc[]=
{
  {"vamax.03a",0x80000,0x9b7d6254, 0x10},
  {"vamax.04a",0x80000,0xd9ec3a82, 0x10},

  {"vama.03a" ,0x80000,0x294e0bec, 0x10},
  {"vama.04a" ,0x80000,0xbc18e128, 0x10},
  {"vama.05a" ,0x80000,0xe709fa59, 0x10},
  {"vama.06a" ,0x80000,0x55e4d387, 0x10},
  {"vama.07a" ,0x80000,0x24e8f981, 0x10},
  {"vama.08a" ,0x80000,0x743f3a8e, 0x10},
  {"vama.09a" ,0x80000,0x67fa5573, 0x10},
  {"vama.10a" ,0x80000,0x5e03d747, 0x10},

  {"vam.13"  ,0x400000,0xc51baf99,    1},
  {"vam.15"  ,0x400000,0x3ce83c77,    1},
  {"vam.17"  ,0x400000,0x4f2408e0,    1},
  {"vam.19"  ,0x400000,0x9ff60250,    1},
  {"vam.14"  ,0x100000,0xbd87243c,    1},
  {"vam.16"  ,0x100000,0xafec855f,    1},
  {"vam.18"  ,0x100000,0x3a033625,    1},
  {"vam.20"  ,0x100000,0x2bff6a89,    1},

  {"vam.01"  ,0x020000,0x64b685d5,    2},
  {"vam.02"  ,0x020000,0xcf7c97c7,    2},

  {"vam.11"  ,0x200000,0x4a39deb2,    2},
  {"vam.12"  ,0x200000,0x1a3e5c03,    2},

};

STD_ROM_PICK(Dstlka) STD_ROM_FN(Dstlka)

struct BurnDriver BurnDrvCpsDstlka=
{
  {"dstlka" ,"Darkstalkers: The Night Warriors (Asia 940705)","","Capcom","CPS2","1994","dstlk", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, DstlkaRomInfo, DstlkaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
