#include "cps.h"

/*==================================
 D&D:TOD
==================================*/


static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"       , 0, CpsInp020+4, "p1 coin"  },
  {"P1 Start"      , 0, CpsInp020+0, "p1 start" },
  {"P1 Up"         , 0, CpsInp001+3, "p1 up"    },
  {"P1 Down"       , 0, CpsInp001+2, "p1 down"  },
  {"P1 Left"       , 0, CpsInp001+1, "p1 left"  },
  {"P1 Right"      , 0, CpsInp001+0, "p1 right" },
  {"P1 Attack"     , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 Jump"       , 0, CpsInp001+5, "p1 fire 2"},
  {"P1 Use"        , 0, CpsInp001+6, "p1 fire 3"},
  {"P1 Select"     , 0, CpsInp001+7, "p1 fire 4"},

  {"P2 Coin"       , 0, CpsInp020+5, "p2 coin"  },
  {"P2 Start"      , 0, CpsInp020+1, "p2 start" },
  {"P2 Up"         , 0, CpsInp000+3, "p2 up"    },
  {"P2 Down"       , 0, CpsInp000+2, "p2 down"  },
  {"P2 Left"       , 0, CpsInp000+1, "p2 left"  },
  {"P2 Right"      , 0, CpsInp000+0, "p2 right" },
  {"P2 Attack"     , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 Jump"       , 0, CpsInp000+5, "p2 fire 2"},
  {"P2 Use"        , 0, CpsInp000+6, "p2 fire 3"},
  {"P2 Select"     , 0, CpsInp000+7, "p2 fire 4"},

  {"P3 Coin"       , 0, CpsInp020+6, "p3 coin"  },
  {"P3 Start"      , 0, CpsInp020+2, "p3 start" },
  {"P3 Up"         , 0, CpsInp011+3, "p3 up"    },
  {"P3 Down"       , 0, CpsInp011+2, "p3 down"  },
  {"P3 Left"       , 0, CpsInp011+1, "p3 left"  },
  {"P3 Right"      , 0, CpsInp011+0, "p3 right" },
  {"P3 Attack"     , 0, CpsInp011+4, "p3 fire 1"},
  {"P3 Jump"       , 0, CpsInp011+5, "p3 fire 2"},
  {"P3 Use"        , 0, CpsInp011+6, "p3 fire 3"},
  {"P3 Select"     , 0, CpsInp011+7, "p3 fire 4"},

  {"P4 Coin"       , 0, CpsInp020+7, "p4 coin"  },
  {"P4 Start"      , 0, CpsInp020+3, "p4 start" },
  {"P4 Up"         , 0, CpsInp010+3, "p4 up"    },
  {"P4 Down"       , 0, CpsInp010+2, "p4 down"  },
  {"P4 Left"       , 0, CpsInp010+1, "p4 left"  },
  {"P4 Right"      , 0, CpsInp010+0, "p4 right" },
  {"P4 Attack"     , 0, CpsInp010+4, "p4 fire 1"},
  {"P4 Jump"       , 0, CpsInp010+5, "p4 fire 2"},
  {"P4 Use"        , 0, CpsInp010+6, "p4 fire 3"},
  {"P4 Select"     , 0, CpsInp010+7, "p4 fire 4"},

  {"Reset"         , 0, &CpsReset,   "reset"    },
  {"Diagnostic"    , 0, CpsInp021+1, "diag"     },
  {"Service"       , 0, CpsInp021+2, "service"  },
};

STDINPUTINFO(Drv);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  5*0x080000;
  nCpsCodeLen= 3*0x080000;
  nCpsGfxLen=    0xc00000;
  nCpsZRomLen= 1*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms (as they are on the roms) for CpsRom
  for (i=0;i<5;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,3+i,1); if (nRet!=0) return 1; }

  // Make decrypted rom
  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  for (i=0;i<3;i++)
  { nRet=BurnXorRom(CpsCode+i*0x080000,i,1); if (nRet!=0) return 1; }

  // Load graphics roms
  nRet=Cps2LoadTiles(CpsGfx           , 8);
  nRet=Cps2LoadTiles(CpsGfx+  0x800000,12);

  // Load Z80 Roms
  nRet=BurnLoadRom(CpsZRom,16,1);

  // Load Q Sample Roms
  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,17,1);
  nRet=BurnLoadRom(pqs+0x200000,18,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit(); if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{


  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}


/*========================
 D&D: Tower of Doom (Euro)
========================*/


static struct BurnRomInfo DdtodRomDesc[]=
{
  {"dadex.03c",0x80000,0x7b8b9b2c, 0x10}, // xor decryption tables
  {"dadex.04c",0x80000,0x370626d3, 0x10},
  {"dadex.05c",0x80000,0x5fd29e95, 0x10},

  {"dade.03c" ,0x80000,0x8e73533d, 0x10}, // 68000 code (encrypted)
  {"dade.04c" ,0x80000,0x00c2e82e, 0x10},
  {"dade.05c" ,0x80000,0xea996008, 0x10},
  {"dade.06a" ,0x80000,0x6225495a, 0x10},
  {"dade.07a" ,0x80000,0xb3480ec3, 0x10},

  // graphics:
  {"dad.13"  ,0x200000,0xda3cb7d6,    1}, // 8
  {"dad.15"  ,0x200000,0x92b63172,    1},
  {"dad.17"  ,0x200000,0xb98757f5,    1},
  {"dad.19"  ,0x200000,0x8121ce46,    1},
  {"dad.14"  ,0x100000,0x837e6f3f,    1},
  {"dad.16"  ,0x100000,0xf0916bdb,    1},
  {"dad.18"  ,0x100000,0xcef393ef,    1},
  {"dad.20"  ,0x100000,0x8953fe9e,    1},

  // sound - z80 roms
  {"dad.01"  ,0x020000,0x3f5e2424,    2}, // 16
  // sound - samples
  {"dad.11"  ,0x200000,0x0c499b67,    2},
  {"dad.12"  ,0x200000,0x2f0b5a4e,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddtod) STD_ROM_FN(Ddtod)

struct BurnDriver BurnDrvCpsDdtod=
{
  {"ddtod" ,"Dungeons & Dragons: Tower of Doom (Euro 940412)","","Capcom","CPS2","1994",NULL, NULL},
  1,4,HARDWARE_CAPCOM_CPS2,
  NULL, DdtodRomInfo, DdtodRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*========================
 D&D: Tower of Doom (USA)
========================*/


static struct BurnRomInfo DdtoduRomDesc[]=
{
  {"dadux.03b",0x80000,0xf59ee70c, 0x10}, // xor decryption tables
  {"dadux.04b",0x80000,0x622628ae, 0x10},
  {"dadux.05b",0x80000,0x424bd6e3, 0x10},

  {"dadu.03b" ,0x80000,0xa519905f, 0x10}, // 68000 code (encrypted)
  {"dadu.04b" ,0x80000,0x52562d38, 0x10},
  {"dadu.05b" ,0x80000,0xee1cfbfe, 0x10},
  {"dad.06"   ,0x80000,0x13aa3e56, 0x10},
  {"dad.07"   ,0x80000,0x431cb6dd, 0x10},

  // graphics:
  {"dad.13"  ,0x200000,0xda3cb7d6,    1}, // 8
  {"dad.15"  ,0x200000,0x92b63172,    1},
  {"dad.17"  ,0x200000,0xb98757f5,    1},
  {"dad.19"  ,0x200000,0x8121ce46,    1},
  {"dad.14"  ,0x100000,0x837e6f3f,    1},
  {"dad.16"  ,0x100000,0xf0916bdb,    1},
  {"dad.18"  ,0x100000,0xcef393ef,    1},
  {"dad.20"  ,0x100000,0x8953fe9e,    1},

  // sound - z80 roms
  {"dad.01"  ,0x020000,0x3f5e2424,    2}, // 16
  // sound - samples
  {"dad.11"  ,0x200000,0x0c499b67,    2},
  {"dad.12"  ,0x200000,0x2f0b5a4e,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddtodu) STD_ROM_FN(Ddtodu)

struct BurnDriver BurnDrvCpsDdtodu=
{
  {"ddtodu" ,"Dungeons & Dragons: Tower of Doom (US 940125)","","Capcom","CPS2","1994","ddtod", NULL},
  1,4,HARDWARE_CAPCOM_CPS2,
  NULL, DdtoduRomInfo, DdtoduRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*===========================
 D&D: Tower of Doom (USA r1)
===========================*/


static struct BurnRomInfo Ddtodur1RomDesc[]=
{
  {"dadux.03a",0x80000,0xf9ba14b6, 0x10}, // xor decryption tables
  {"dadux.04a",0x80000,0xed85ec29, 0x10},
  {"dadux.05a",0x80000,0xdbae3d1b, 0x10},

  {"dadu.03a" ,0x80000,0x4413f177, 0x10}, // 68000 code (encrypted)
  {"dadu.04a" ,0x80000,0x168de230, 0x10},
  {"dadu.05a" ,0x80000,0x03d39e91, 0x10},
  {"dad.06"   ,0x80000,0x13aa3e56, 0x10},
  {"dad.07"   ,0x80000,0x431cb6dd, 0x10},

  // graphics:
  {"dad.13"  ,0x200000,0xda3cb7d6,    1}, // 8
  {"dad.15"  ,0x200000,0x92b63172,    1},
  {"dad.17"  ,0x200000,0xb98757f5,    1},
  {"dad.19"  ,0x200000,0x8121ce46,    1},
  {"dad.14"  ,0x100000,0x837e6f3f,    1},
  {"dad.16"  ,0x100000,0xf0916bdb,    1},
  {"dad.18"  ,0x100000,0xcef393ef,    1},
  {"dad.20"  ,0x100000,0x8953fe9e,    1},

  // sound - z80 roms
  {"dad.01"  ,0x020000,0x3f5e2424,    2}, // 16
  // sound - samples
  {"dad.11"  ,0x200000,0x0c499b67,    2},
  {"dad.12"  ,0x200000,0x2f0b5a4e,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddtodur1) STD_ROM_FN(Ddtodur1)

struct BurnDriver BurnDrvCpsDdtodur1=
{
  {"ddtodur1" ,"Dungeons & Dragons: Tower of Doom (US 940113)","","Capcom","CPS2","1994","ddtod", NULL},
  1,4,HARDWARE_CAPCOM_CPS2,
  NULL, Ddtodur1RomInfo, Ddtodur1RomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*==========================
 D&D: Tower of Doom (Japan)
==========================*/


static struct BurnRomInfo DdtodjRomDesc[]=
{
  {"dadjx.03a",0x80000,0x4c7334d3, 0x10}, // xor decryption tables
  {"dadjx.04a",0x80000,0xcfd15109, 0x10},
  {"dadjx.05a",0x80000,0xd23bcd71, 0x10},

  {"dadj.03a" ,0x80000,0x711638dc, 0x10}, // 68000 code (encrypted)
  {"dadj.04a" ,0x80000,0x4869639c, 0x10},
  {"dadj.05a" ,0x80000,0x484c0efa, 0x10},
  {"dad.06"   ,0x80000,0x13aa3e56, 0x10},
  {"dad.07"   ,0x80000,0x431cb6dd, 0x10},

  // graphics:
  {"dad.13"  ,0x200000,0xda3cb7d6,    1}, // 8
  {"dad.15"  ,0x200000,0x92b63172,    1},
  {"dad.17"  ,0x200000,0xb98757f5,    1},
  {"dad.19"  ,0x200000,0x8121ce46,    1},
  {"dad.14"  ,0x100000,0x837e6f3f,    1},
  {"dad.16"  ,0x100000,0xf0916bdb,    1},
  {"dad.18"  ,0x100000,0xcef393ef,    1},
  {"dad.20"  ,0x100000,0x8953fe9e,    1},

  // sound - z80 roms
  {"dad.01"  ,0x020000,0x3f5e2424,    2}, // 16
  // sound - samples
  {"dad.11"  ,0x200000,0x0c499b67,    2},
  {"dad.12"  ,0x200000,0x2f0b5a4e,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddtodj) STD_ROM_FN(Ddtodj)

struct BurnDriver BurnDrvCpsDdtodj=
{
  {"ddtodj" ,"Dungeons & Dragons: Tower of Doom (Japan 940113)","","Capcom","CPS2","1994","ddtod", NULL},
  1,4,HARDWARE_CAPCOM_CPS2,
  NULL, DdtodjRomInfo, DdtodjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*===================================
 D&D: Tower of Doom (Asia) Encrypted
===================================*/


static struct BurnRomInfo DdtodaRomDesc[]=
{
  {"dadax.03a",0x80000,0x00000000, 0x10}, // xor decryption tables
  {"dadax.04a",0x80000,0x00000000, 0x10},
  {"dadax.05a",0x80000,0x00000000, 0x10},

  {"dada.03a" ,0x80000,0xfc6f2dd7, 0x10}, // 68000 code (encrypted)
  {"dada.04a" ,0x80000,0xd4be4009, 0x10},
  {"dada.05a" ,0x80000,0x6712d1cf, 0x10},
  {"dad.06"   ,0x80000,0x13aa3e56, 0x10},
  {"dad.07"   ,0x80000,0x431cb6dd, 0x10},

  // graphics:
  {"dad.13"  ,0x200000,0xda3cb7d6,    1}, // 8
  {"dad.15"  ,0x200000,0x92b63172,    1},
  {"dad.17"  ,0x200000,0xb98757f5,    1},
  {"dad.19"  ,0x200000,0x8121ce46,    1},
  {"dad.14"  ,0x100000,0x837e6f3f,    1},
  {"dad.16"  ,0x100000,0xf0916bdb,    1},
  {"dad.18"  ,0x100000,0xcef393ef,    1},
  {"dad.20"  ,0x100000,0x8953fe9e,    1},

  // sound - z80 roms
  {"dad.01"  ,0x020000,0x3f5e2424,    2}, // 16
  // sound - samples
  {"dad.11"  ,0x200000,0x0c499b67,    2},
  {"dad.12"  ,0x200000,0x2f0b5a4e,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddtoda) STD_ROM_FN(Ddtoda)

struct BurnDriverX BurnDrvCpsDdtoda=
{
  {"ddtoda" ,"Dungeons & Dragons: Tower of Doom (Asia 940113)","Encrypted","Capcom","CPS2","1994","ddtod", NULL},
  0,4,HARDWARE_CAPCOM_CPS2,
  NULL, DdtodaRomInfo, DdtodaRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*============================
 D&D: Tower of Doom (Hispanic)
============================*/


static struct BurnRomInfo DdtodhRomDesc[]=
{
  {"dadhx.03b",0x80000,0xb9a16065, 0x10}, // xor decryption tables
  {"dadhx.04b",0x80000,0x6b0d5086, 0x10},
  {"dadhx.05b",0x80000,0xe01ee2b2, 0x10},

  {"dadh.03b" ,0x80000,0xae0cb98e, 0x10}, // 68000 code (encrypted)
  {"dadh.04b" ,0x80000,0xb5774363, 0x10},
  {"dadh.05b" ,0x80000,0x6ce2a485, 0x10},
  {"dad.06"   ,0x80000,0x13aa3e56, 0x10},
  {"dad.07"   ,0x80000,0x431cb6dd, 0x10},

  // graphics:
  {"dad.13"  ,0x200000,0xda3cb7d6,    1}, // 8
  {"dad.15"  ,0x200000,0x92b63172,    1},
  {"dad.17"  ,0x200000,0xb98757f5,    1},
  {"dad.19"  ,0x200000,0x8121ce46,    1},
  {"dad.14"  ,0x100000,0x837e6f3f,    1},
  {"dad.16"  ,0x100000,0xf0916bdb,    1},
  {"dad.18"  ,0x100000,0xcef393ef,    1},
  {"dad.20"  ,0x100000,0x8953fe9e,    1},

  // sound - z80 roms
  {"dad.01"  ,0x020000,0x3f5e2424,    2}, // 16
  // sound - samples
  {"dad.11"  ,0x200000,0x0c499b67,    2},
  {"dad.12"  ,0x200000,0x2f0b5a4e,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Ddtodh) STD_ROM_FN(Ddtodh)

struct BurnDriver BurnDrvCpsDdtodh=
{
  {"ddtodh" ,"Dungeons & Dragons: Tower of Doom (Hispanic 940125)",NULL,"Capcom","CPS2","1994","ddtod", NULL},
  1,4,HARDWARE_CAPCOM_CPS2,
  NULL, DdtodhRomInfo, DdtodhRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
