#include "cps.h"

/*=====================================================
 Cyberbots: Fullmetal Madness
=====================================================*/

static struct BurnInputInfo DrvInputList[] =
{
  {"P1 Coin"       , 0, CpsInp020+4, "p1 coin"},
  {"P1 Start"      , 0, CpsInp020+0, "p1 start"},
  {"P1 Up"         , 0, CpsInp001+3, "p1 up"},
  {"P1 Down"       , 0, CpsInp001+2, "p1 down"},
  {"P1 Left"       , 0, CpsInp001+1, "p1 left"},
  {"P1 Right"      , 0, CpsInp001+0, "p1 right"},
  {"P1 Low Attack" , 0, CpsInp001+4, "p1 fire 1"},
  {"P1 High Attack", 0, CpsInp001+5, "p1 fire 2"},
  {"P1 Boost"      , 0, CpsInp001+6, "p1 fire 3"},
  {"P1 Weapon"     , 0, CpsInp001+7, "p1 fire 4"},

  {"P2 Coin"       , 0, CpsInp020+5, "p2 coin"},
  {"P2 Start"      , 0, CpsInp020+1, "p2 start"},
  {"P2 Up"         , 0, CpsInp000+3, "p2 up"},
  {"P2 Down"       , 0, CpsInp000+2, "p2 down"},
  {"P2 Left"       , 0, CpsInp000+1, "p2 left"},
  {"P2 Right"      , 0, CpsInp000+0, "p2 right"},
  {"P2 Low Attack" , 0, CpsInp000+4, "p2 fire 1"},
  {"P2 High Attack", 0, CpsInp000+5, "p2 fire 2"},
  {"P2 Boost"      , 0, CpsInp000+6, "p2 fire 3"},
  {"P2 Weapon"     , 0, CpsInp000+7, "p2 fire 4"},

  {"Reset"         , 0, &CpsReset   , "reset"},
  {"Diagnostic"    , 0, CpsInp021+1, "diag"},
  {"Service"       , 0, CpsInp021+2, "service"},
};

STDINPUTINFO(Drv);


static int DrvInit()
{
  int nRet=0; int i=0; unsigned char *pqs=NULL;

  Cps=2;
  nCpsRomLen=  8*0x080000;
  nCpsCodeLen= 2*0x080000;
  nCpsGfxLen=  8*0x400000;
  nCpsZRomLen= 2*0x020000;
  nCpsQSamLen= 2*0x200000;
  nRet=CpsInit(); if (nRet!=0) return 1;

  // Load program roms (as they are on the roms) for CpsRom
  for (i=0;i<8;i++)
  { nRet=BurnLoadRom(CpsRom+0x080000*i,2+i,1); if (nRet!=0) return 1; }

  // Make decrypted rom
  memcpy(CpsCode,CpsRom,nCpsCodeLen);
  nRet=BurnXorRom(CpsCode         ,0,1); if (nRet!=0) return 1;
  nRet=BurnXorRom(CpsCode+0x080000,1,1); if (nRet!=0) return 1;

  // Load graphics roms
  nRet=Cps2LoadTiles(CpsGfx           ,10);
  nRet=Cps2LoadTiles(CpsGfx+4*0x400000,14);

  // Load Z80 Roms
  nRet=BurnLoadRom(CpsZRom         ,18,1);
  nRet=BurnLoadRom(CpsZRom+ 0x20000,19,1);

  // Load Q Sample Roms
  pqs=(unsigned char *)CpsQSam;
  nRet=BurnLoadRom(pqs         ,20,1);
  nRet=BurnLoadRom(pqs+0x200000,21,1);
  BurnByteswap(pqs,nCpsQSamLen);


  nRet=CpsRunInit(); if (nRet!=0) return 1;
  // Ready to go
  return 0;
}

static int DrvExit()
{

  CpsRunExit();
  CpsExit();
  nCpsQSamLen=0;
  nCpsZRomLen=0;
  nCpsGfxLen=0;
  nCpsCodeLen=0;
  nCpsRomLen=0;
  Cps=0;
  return 0;
}


/*====================================
 Cyberbots: Fullmetal Madness (Japan)
====================================*/


static struct BurnRomInfo CybotsjRomDesc[]=
{
  {"cybjx.03",0x80000,0x867c9acd, 0x10}, // xor decryption tables
  {"cybjx.04",0x80000,0x57ed677f, 0x10},

  {"cybj.03" ,0x80000,0x6096eada, 0x10}, // 68000 code (encrypted)
  {"cybj.04" ,0x80000,0x7b0ffaa9, 0x10},
  {"cyb.05"  ,0x80000,0xec40408e, 0x10},
  {"cyb.06"  ,0x80000,0x1ad0bed2, 0x10},
  {"cyb.07"  ,0x80000,0x6245a39a, 0x10},
  {"cyb.08"  ,0x80000,0x4b48e223, 0x10},
  {"cyb.09"  ,0x80000,0xe15238f6, 0x10},
  {"cyb.10"  ,0x80000,0x75f4003b, 0x10},

  // graphics:
  {"cyb.13" ,0x400000,0xf0dce192,    1}, // 10
  {"cyb.15" ,0x400000,0x187aa39c,    1},
  {"cyb.17" ,0x400000,0x8a0e4b12,    1},
  {"cyb.19" ,0x400000,0x34b62612,    1},
  {"cyb.14" ,0x400000,0xc1537957,    1},
  {"cyb.16" ,0x400000,0x15349e86,    1},
  {"cyb.18" ,0x400000,0xd83e977d,    1},
  {"cyb.20" ,0x400000,0x77cdad5c,    1},

  // sound - z80 roms
  {"cyb.01" ,0x020000,0x9c0fb079,    2}, // 18
  {"cyb.02" ,0x020000,0x51cb0c4e,    2},
  // sound - samples
  {"cyb.11" ,0x200000,0x362ccab2,    2},
  {"cyb.12" ,0x200000,0x7066e9cc,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Cybotsj) STD_ROM_FN(Cybotsj)

struct BurnDriver BurnDrvCpsCybotsj=
{
  {"cybotsj" ,"Cyberbots: Fullmetal Madness (Japan 950420)","","Capcom","CPS2","1995","cybots", NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, CybotsjRomInfo, CybotsjRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};

/*=================================
 Cyberbots: Fullmetal Madness (USA)
=================================*/


static struct BurnRomInfo CybotsRomDesc[]=
{
  {"cybux.03",0x80000,0x4b4f5b32, 0x10}, // xor decryption tables
  {"cybux.04",0x80000,0x6615a7e9, 0x10},

  {"cybu.03" ,0x80000,0xdb4da8f4, 0x10}, // 68000 code (encrypted)
  {"cybu.04" ,0x80000,0x1eec68ac, 0x10},
  {"cyb.05"  ,0x80000,0xec40408e, 0x10},
  {"cyb.06"  ,0x80000,0x1ad0bed2, 0x10},
  {"cyb.07"  ,0x80000,0x6245a39a, 0x10},
  {"cyb.08"  ,0x80000,0x4b48e223, 0x10},
  {"cyb.09"  ,0x80000,0xe15238f6, 0x10},
  {"cyb.10"  ,0x80000,0x75f4003b, 0x10},

  // graphics:
  {"cyb.13" ,0x400000,0xf0dce192,    1}, // 10
  {"cyb.15" ,0x400000,0x187aa39c,    1},
  {"cyb.17" ,0x400000,0x8a0e4b12,    1},
  {"cyb.19" ,0x400000,0x34b62612,    1},
  {"cyb.14" ,0x400000,0xc1537957,    1},
  {"cyb.16" ,0x400000,0x15349e86,    1},
  {"cyb.18" ,0x400000,0xd83e977d,    1},
  {"cyb.20" ,0x400000,0x77cdad5c,    1},

  // sound - z80 roms
  {"cyb.01" ,0x020000,0x9c0fb079,    2}, // 18
  {"cyb.02" ,0x020000,0x51cb0c4e,    2},
  // sound - samples
  {"cyb.11" ,0x200000,0x362ccab2,    2},
  {"cyb.12" ,0x200000,0x7066e9cc,    2},
};

// Make The RomInfo/Name functions for the game
STD_ROM_PICK(Cybots) STD_ROM_FN(Cybots)

struct BurnDriver BurnDrvCpsCybots=
{
  {"cybots" ,"Cyberbots: Fullmetal Madness (US 950424)","","Capcom","CPS2","1995",NULL, NULL},
  1,2,HARDWARE_CAPCOM_CPS2,
  NULL, CybotsRomInfo, CybotsRomName, DrvInputInfo, NULL,
  DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
  &CpsRecalcPal,384,224,4,3
};
