#include "cps.h"

/*====================================================================================
 Capcom Sports Club
====================================================================================*/

static struct BurnInputInfo DrvInputList[] =
{
	{"P1 Coin"    ,0, CpsInp020+4, "p1 coin"  },
	{"P1 Start"   ,0, CpsInp020+0, "p1 start" },
	{"P1 Up"      ,0, CpsInp001+3, "p1 up"    },
	{"P1 Down"    ,0, CpsInp001+2, "p1 down"  },
	{"P1 Left"    ,0, CpsInp001+1, "p1 left"  },
	{"P1 Right"   ,0, CpsInp001+0, "p1 right" },
	{"P1 Button 1",0, CpsInp001+4, "p1 fire 1"},
	{"P1 Button 2",0, CpsInp001+5, "p1 fire 2"},
	{"P1 Button 3",0, CpsInp001+6, "p1 fire 3"},

	{"P2 Coin"    ,0, CpsInp020+5, "p2 coin"  },
	{"P2 Start"   ,0, CpsInp020+1, "p2 start" },
	{"P2 Up"      ,0, CpsInp000+3, "p2 up"    },
	{"P2 Down"    ,0, CpsInp000+2, "p2 down"  },
	{"P2 Left"    ,0, CpsInp000+1, "p2 left"  },
	{"P2 Right"   ,0, CpsInp000+0, "p2 right" },
	{"P2 Button 1",0, CpsInp000+4, "p2 fire 1"},
	{"P2 Button 2",0, CpsInp000+5, "p2 fire 2"},
	{"P2 Button 3",0, CpsInp000+6, "p2 fire 3"},

	{"Reset"      ,0, &CpsReset, "reset"      },
	{"Diagnostic" ,0, CpsInp021+1, "diag"     },
	{"Service"    ,0, CpsInp021+2, "service"  },
};

STDINPUTINFO(Drv);


static int DrvInit()
{
	int nRet=0; int i=0; unsigned char *pqs=NULL;

	Cps=2;
	nCpsRomLen= 5*0x080000;
	nCpsCodeLen= 4*0x080000;
	nCpsGfxLen= 4*0x200000;
	nCpsZRomLen= 1*0x020000;
	nCpsQSamLen= 2*0x200000;
	nRet=CpsInit(); if (nRet!=0) return 1;

	for (i=0;i<5;i++)
	{ nRet=BurnLoadRom(CpsRom+0x080000*i,4+i,1); if (nRet!=0) return 1; }

	memcpy(CpsCode,CpsRom,nCpsCodeLen);
	for (i=0;i<4;i++)
	{ nRet=BurnXorRom(CpsCode+0x080000*i,0+i,1); if (nRet!=0) return 1; }

	nRet=Cps2LoadTiles(CpsGfx ,9);

	nRet=BurnLoadRom(CpsZRom ,13,1);

	pqs=(unsigned char *)CpsQSam;
	nRet=BurnLoadRom(pqs ,14,1);
	nRet=BurnLoadRom(pqs+0x200000,15,1);
	BurnByteswap(pqs,nCpsQSamLen);




	nRet=CpsRunInit(); if (nRet!=0) return 1;

	return 0;
}

static int DrvExit()
{
	CpsRunExit();
	CpsExit();
	nCpsQSamLen=0;
	nCpsZRomLen=0;
	nCpsGfxLen=0;
	nCpsCodeLen=0;
	nCpsRomLen=0;
	Cps=0;
	return 0;
}


/*=====================
Capcom Sports Club Asia
=====================*/


static struct BurnRomInfo CsclubaRomDesc[]=
{
	{"cscax.03" ,0x80000,0x9f95b1e1, 0x10},
	{"cscax.04" ,0x80000,0x08e85ab2, 0x10},
	{"cscax.05" ,0x80000,0x1b2fae1d, 0x10},
	{"cscax.06" ,0x80000,0x9e548ba8, 0x10},

	{"csca.03" ,0x80000,0xb6acd708,  0x10},
	{"csca.04" ,0x80000,0xd44ae35f,  0x10},
	{"csca.05" ,0x80000,0x8da76aec,  0x10},
	{"csca.06" ,0x80000,0xa1b7b1ee,  0x10},
	{"csc.07"  ,0x80000,0x01b05caa,  0x10},

	{"csc.14" ,0x200000,0xe8904afa,     1},
	{"csc.16" ,0x200000,0xc98c8079,     1},
	{"csc.18" ,0x200000,0xc030df5a,     1},
	{"csc.20" ,0x200000,0xb4e55863,     1},

	{"csc.01" ,0x020000,0xee162111,     2},

	{"csc.11" ,0x200000,0xa027b827,     2},
	{"csc.12" ,0x200000,0xcb7f6e55,     2},
};

STD_ROM_PICK(Cscluba) STD_ROM_FN(Cscluba)

struct BurnDriver BurnDrvCpsCscluba=
{
	{"cscluba" ,"Capcom Sports Club (Asia 970722)","","Capcom","CPS2","1997",NULL, NULL},
    1,2,HARDWARE_CAPCOM_CPS2,
	NULL, CsclubaRomInfo, CsclubaRomName, DrvInputInfo, NULL,
	DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
	&CpsRecalcPal,384,224,4,3
};

/*======================
Capcom Sports Club Japan
======================*/


static struct BurnRomInfo DrvRomDesc[]=
{
	{"cscjx.03",0x80000,0x2de1d45d, 0x10},
	{"cscjx.04",0x80000,0x81b25d76, 0x10},
	{"cscjx.05",0x80000,0x5adb1c93, 0x10},
	{"cscjx.06",0x80000,0xf5558f79, 0x10},

	{"cscj.03" ,0x80000,0xec4ddaa2, 0x10},
	{"cscj.04" ,0x80000,0x60c632bb, 0x10},
	{"cscj.05" ,0x80000,0xad042003, 0x10},
	{"cscj.06" ,0x80000,0x169e4d40, 0x10},
	{"csc.07"  ,0x80000,0x01b05caa, 0x10},

	{"csc.14" ,0x200000,0xe8904afa,    1},
	{"csc.16" ,0x200000,0xc98c8079,    1},
	{"csc.18" ,0x200000,0xc030df5a,    1},
	{"csc.20" ,0x200000,0xb4e55863,    1},

	{"csc.01" ,0x020000,0xee162111,    2},

	{"csc.11" ,0x200000,0xa027b827,    2},
	{"csc.12" ,0x200000,0xcb7f6e55,    2},
};

STD_ROM_PICK(Drv) STD_ROM_FN(Drv)

struct BurnDriver BurnDrvCpsCsclubj=
{
	{"csclubj" ,"Capcom Sports Club (Japan 970722)","","Capcom","CPS2","1997","cscluba", NULL},
	1,2,HARDWARE_CAPCOM_CPS2,
	NULL, DrvRomInfo, DrvRomName, DrvInputInfo, NULL,
	DrvInit,DrvExit,Cps2Frame,CpsRedraw,CpsAreaScan,
	&CpsRecalcPal,384,224,4,3
};
