#!/bin/perl

# Auto generate an 8 character unique name for each file
local $autoNameNumber = 0;
local @newFILEs;
local @FILEs = `find ./MAME/src/drivers/*.c`;

use constant DATA_PREFIX  => 'D';
use constant CODE_PREFIX  => 'C';
use constant BSS_PREFIX   => 'B';
use constant CONST_PREFIX => 'K';


	# Create the imageblddbg.switch file
open( DBGPRELOADFILE, ">imageblddbg.switch" );
print DBGPRELOADFILE "/IN:\"Debug\\MAMEoX.exe\"\n";
print DBGPRELOADFILE "/OUT:\"Debug\\MAMEoX.xbe\"\n";
print DBGPRELOADFILE "/STACK:\"0x20000\"\n";
print DBGPRELOADFILE "/DEBUG\n";
print DBGPRELOADFILE "/LIMITMEM\n";
print DBGPRELOADFILE "/NOLOGO\n";
print DBGPRELOADFILE "/formatud\n";
print DBGPRELOADFILE "/testname:\"MAMEoX Util (Don't Run)\"\n";
print DBGPRELOADFILE "/testid:0x4D414D45\n";

open( PRELOADFILE, ">imagebld.switch" );
print DBGPRELOADFILE "/IN:\"Release\\MAMEoX.exe\"\n";
print DBGPRELOADFILE "/OUT:\"Release\\MAMEoX.xbe\"\n";
print PRELOADFILE "/STACK:\"0x20000\"\n";
print PRELOADFILE "/LIMITMEM\n";
print PRELOADFILE "/NOLOGO\n";
print PRELOADFILE "/formatud\n";
print PRELOADFILE "/testname:\"MAMEoX Util (Don't Run)\"\n";
print PRELOADFILE "/testid:0x4D414D45\n";


	# Create the Sections.h file
open( GENERATEDFILE, ">./MAMEoX/includes/Sections.h" );
print GENERATEDFILE "/**\n";
print GENERATEDFILE "  * \\file      Sections.h\n";
print GENERATEDFILE "  * \\brief     Registration of MAME files for creation and usage of XBOX\n";
print GENERATEDFILE "  *             loadable sections.\n";
print GENERATEDFILE "  *\n";
print GENERATEDFILE "  * \\note      This file is autogenerated via Sectionize.pl DO NOT EDIT!\n";
print GENERATEDFILE "  */\n";
print GENERATEDFILE "#pragma once\n";
print GENERATEDFILE "//= I N C L U D E S ====================================================\n";
print GENERATEDFILE "#include \"MAMEoX.h\"\n";
print GENERATEDFILE "#ifdef __cplusplus\n";
print GENERATEDFILE "extern \"C\" {\n";
print GENERATEDFILE "#endif\n";
print GENERATEDFILE "#include \"osd_cpu.h\"\n";
print GENERATEDFILE "//= P R O T O T Y P E S ================================================\n";
print GENERATEDFILE "\n#ifdef _DEBUG\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "//	CheckDriverSectionRAM\n";
print GENERATEDFILE "//! \\brief    Prints the size of each driver/snd/vdeo segment\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "void CheckDriverSectionRAM( void );\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	CheckCPUSectionRAM\n";
print GENERATEDFILE "//! \\brief    Prints the size of each CPU segment\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "void CheckCPUSectionRAM( void );\n";
print GENERATEDFILE "#endif\n\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "//	InitDriverSectionizer\n";
print GENERATEDFILE "//! \\brief    Initializes the DriverSectionizer subsystem\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "void InitDriverSectionizer( void );\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	TerminateDriverSectionizer\n";
print GENERATEDFILE "//! \\brief    Terminates the DriverSectionizer subsystem\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "void TerminateDriverSectionizer( void );\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	LoadDriverSectionByName\n";
print GENERATEDFILE "//! \\brief    Loads the section associated with the passed name\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\param    DriverFileName - The name of the file whose section\n";
print GENERATEDFILE "//!                             should be loaded\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\return   BOOL - Operation status\n";
print GENERATEDFILE "//! \\retval   TRUE - success\n";
print GENERATEDFILE "//! \\return   FALSE - Failure\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL LoadDriverSectionByName( const char *DriverFileName );\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	UnloadDriverSectionByName\n";
print GENERATEDFILE "//! \\brief    Unloads the section associated with the passed name\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\param    DriverFileName - The name of the file whose section\n";
print GENERATEDFILE "//!                             should be unloaded\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\return   BOOL - Operation status\n";
print GENERATEDFILE "//! \\retval   TRUE - success\n";
print GENERATEDFILE "//! \\return   FALSE - Failure\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL UnloadDriverSectionByName( const char *DriverFileName );\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	LoadDriverSections\n";
print GENERATEDFILE "//! \\brief    Loads all of the driver sections\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\return   BOOL - Operation status\n";
print GENERATEDFILE "//! \\retval   TRUE - success\n";
print GENERATEDFILE "//! \\return   FALSE - Failure\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL LoadDriverSections( void );\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	UnloadDriverSections\n";
print GENERATEDFILE "//! \\brief    Unloads all of the driver sections\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\return   BOOL - Operation status\n";
print GENERATEDFILE "//! \\retval   TRUE - success\n";
print GENERATEDFILE "//! \\return   FALSE - Failure\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL UnloadDriverSections( void );\n";


print GENERATEDFILE "\n\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	InitCPUSectionizer\n";
print GENERATEDFILE "//! \\brief    Initializes the DriverSectionizer subsystem\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "void InitCPUSectionizer( void );\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	TerminateCPUSectionizer\n";
print GENERATEDFILE "//! \\brief    Terminates the DriverSectionizer subsystem\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "void TerminateCPUSectionizer( void );\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	LoadCPUSectionByID\n";
print GENERATEDFILE "//! \\brief    Loads the section associated with the passed name\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\param    CPUID - The ID of the CPU whose section\n";
print GENERATEDFILE "//!                    should be loaded\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\return   BOOL - Operation status\n";
print GENERATEDFILE "//! \\retval   TRUE - success\n";
print GENERATEDFILE "//! \\return   FALSE - Failure\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL LoadCPUSectionByID( UINT32 CPUID );\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	UnloadCPUSectionByID\n";
print GENERATEDFILE "//! \\brief    Unloads the section associated with the passed name\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\param    CPUID - The ID of the CPU whose section\n";
print GENERATEDFILE "//!                    should be loaded\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\return   BOOL - Operation status\n";
print GENERATEDFILE "//! \\retval   TRUE - success\n";
print GENERATEDFILE "//! \\return   FALSE - Failure\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL UnloadCPUSectionByID( UINT32 CPUID );\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	LoadCPUSections\n";
print GENERATEDFILE "//! \\brief    Loads all of the CPU sections\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\return   BOOL - Operation status\n";
print GENERATEDFILE "//! \\retval   TRUE - success\n";
print GENERATEDFILE "//! \\return   FALSE - Failure\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL LoadCPUSections( void );\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	UnloadCPUSections\n";
print GENERATEDFILE "//! \\brief    Unloads all of the CPU sections\n";
print GENERATEDFILE "//!\n";
print GENERATEDFILE "//! \\return   BOOL - Operation status\n";
print GENERATEDFILE "//! \\retval   TRUE - success\n";
print GENERATEDFILE "//! \\return   FALSE - Failure\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL UnloadCPUSections( void );\n";
print GENERATEDFILE "#ifdef __cplusplus\n";
print GENERATEDFILE "} // End extern \"C\"\n";
print GENERATEDFILE "#endif\n";
close( GENERATEDFILE );


	# Create the DriverSections.cpp file
open( GENERATEDFILE, ">./MAMEoX/sources/DriverSections.cpp" );
print GENERATEDFILE "/**\n";
print GENERATEDFILE "  * \\file      DriverSections.cpp\n";
print GENERATEDFILE "  * \\brief     Registration of driver files for creation and usage of XBOX\n";
print GENERATEDFILE "  *             loadable sections\n";
print GENERATEDFILE "  *\n";
print GENERATEDFILE "  * \\note      This file is autogenerated via Sectionize.pl DO NOT EDIT!\n";
print GENERATEDFILE "  */\n\n";
print GENERATEDFILE "//= I N C L U D E S ====================================================\n";
print GENERATEDFILE "#include \"MAMEoX.h\"\n";
print GENERATEDFILE "#include <stdio.h>\n";
print GENERATEDFILE "#include <map>\n";
print GENERATEDFILE "#include <string>\n";
print GENERATEDFILE "#include \"DebugLogger.h\"\n";
print GENERATEDFILE "extern \"C\" {\n";
print GENERATEDFILE "#include \"osd_cpu.h\"\n";
print GENERATEDFILE "}\n";
print GENERATEDFILE "//= D E F I N E S ======================================================\n";
print GENERATEDFILE "#define DATA_PREFIX      \"".DATA_PREFIX."\"\n";
print GENERATEDFILE "#define CODE_PREFIX      \"".CODE_PREFIX."\"\n";
print GENERATEDFILE "#define BSS_PREFIX       \"".BSS_PREFIX."\"\n";
print GENERATEDFILE "#define CONST_PREFIX     \"".CONST_PREFIX."\"\n";
print GENERATEDFILE "\n";
print GENERATEDFILE "//= G L O B A L = V A R S ==============================================\n";
print GENERATEDFILE "static std::map< std::string, std::string >  g_nameToSectionMap;\n\n";
print GENERATEDFILE "//= P R O T O T Y P E S ================================================\n";
print GENERATEDFILE "extern \"C\" static void RegisterDriverSectionNames( void );\n\n";
print GENERATEDFILE "//= F U N C T I O N S ==================================================\n";
print GENERATEDFILE "extern \"C\" {\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	InitDriverSectionizer\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "void InitDriverSectionizer( void )\n";
print GENERATEDFILE "{\n";
print GENERATEDFILE "  g_nameToSectionMap.clear();\n";
print GENERATEDFILE "  void *addr;\n";
print GENERATEDFILE "  addr = XLoadSection( \"DRVSNIZE\" );\n";
print GENERATEDFILE "  if( !addr )\n";
print GENERATEDFILE "  {\n";
print GENERATEDFILE "    UINT32 lastErr = GetLastError();\n";
print GENERATEDFILE "    PRINTMSG( T_ERROR, \"XLoadSection failed! 0x%X\\r\\n\", lastErr );\n";
print GENERATEDFILE "  }\n";
print GENERATEDFILE "  RegisterDriverSectionNames();\n";
print GENERATEDFILE "}\n\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	TerminateDriverSectionizer\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "void TerminateDriverSectionizer( void )\n";
print GENERATEDFILE "{\n";
print GENERATEDFILE "  g_nameToSectionMap.clear();\n";
print GENERATEDFILE "  XFreeSection( \"DRVSNIZE\" );\n";
print GENERATEDFILE "}\n\n";
print GENERATEDFILE "#pragma code_seg( \"DRVCSNZE\" )\n";
print GENERATEDFILE "#pragma data_seg( \"DRVDSNZE\" )\n";
print GENERATEDFILE "#pragma comment(linker, \"/merge:DRVCSNZE=DRVSNIZE\")\n";
print GENERATEDFILE "#pragma comment(linker, \"/merge:DRVDSNZE=DRVSNIZE\")\n";
print GENERATEDFILE "\n#ifdef _DEBUG\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "//	CheckDriverSectionRAM\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "void CheckDriverSectionRAM( void )\n";
print GENERATEDFILE "{\n";
print GENERATEDFILE "  DWORD total = 0;\n";
print GENERATEDFILE "  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.begin();\n";
print GENERATEDFILE "  for( ; i != g_nameToSectionMap.end(); ++i )\n";
print GENERATEDFILE "  {\n";
print GENERATEDFILE "    HANDLE h = XGetSectionHandle( (*i).second.c_str() );\n";
print GENERATEDFILE "    if( h != INVALID_HANDLE_VALUE )\n";
print GENERATEDFILE "    {\n";
print GENERATEDFILE "      UINT32 sz = XGetSectionSize( h );\n";
print GENERATEDFILE "      PRINTMSG( T_INFO, \"Driver %s %lu\", (*i).first.c_str(), sz );\n";
print GENERATEDFILE "      total += sz;\n";
print GENERATEDFILE "    }\n";
print GENERATEDFILE "    else\n";
print GENERATEDFILE "      PRINTMSG( T_ERROR, \"Invalid section %s for file %s!\", (*i).second.c_str(), (*i).first.c_str() );\n";
print GENERATEDFILE "  }\n";
print GENERATEDFILE "  PRINTMSG( T_INFO, \"Total %lu bytes\\n\", total );\n";
print GENERATEDFILE "}\n";
print GENERATEDFILE "#endif\n\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	RegisterSectionName\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "static void RegisterSectionName( const char *DriverFileName, const char *sectionName )\n";
print GENERATEDFILE "{\n";
print GENERATEDFILE "    // Add the section name to the map\n";
print GENERATEDFILE "  g_nameToSectionMap[ DriverFileName ] = sectionName;\n";
print GENERATEDFILE "}\n\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	LoadDriverSectionByName\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL LoadDriverSectionByName( const char *DriverFileName )\n";
print GENERATEDFILE "{\n";
print GENERATEDFILE "  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.find( DriverFileName );\n";
print GENERATEDFILE "  if( i == g_nameToSectionMap.end() )\n";
print GENERATEDFILE "    return FALSE;\n";
print GENERATEDFILE "  void *addr;\n";
print GENERATEDFILE "  PRINTMSG( T_INFO, \"Load section %s, ID %s\\n\", DriverFileName, (*i).second.c_str() );\n";
print GENERATEDFILE "  addr = XLoadSection( (*i).second.c_str() );\n";
print GENERATEDFILE "  if( !addr )\n";
print GENERATEDFILE "  {\n";
print GENERATEDFILE "    UINT32 lastErr = GetLastError();\n";
print GENERATEDFILE "    PRINTMSG( T_ERROR, \"XLoadSection failed! 0x%X\\r\\n\", lastErr );\n";
print GENERATEDFILE "    //osd_print_error( \"Failed to load section %s!\", (*i).second.c_str() );\n";
print GENERATEDFILE "    //return FALSE;\n";
print GENERATEDFILE "  }\n";
print GENERATEDFILE "  return TRUE;\n";
print GENERATEDFILE "}\n\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	UnloadDriverSectionByName\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL UnloadDriverSectionByName( const char *DriverFileName )\n";
print GENERATEDFILE "{\n";
print GENERATEDFILE "  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.find( DriverFileName );\n";
print GENERATEDFILE "  if( i == g_nameToSectionMap.end() )\n";
print GENERATEDFILE "    return FALSE;\n";
print GENERATEDFILE "  return XFreeSection( (*i).second.c_str() );\n";
print GENERATEDFILE "}\n\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	LoadDriverSections\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL LoadDriverSections( void )\n";
print GENERATEDFILE "{\n";
print GENERATEDFILE "  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.begin();\n";
print GENERATEDFILE "  for( ; i != g_nameToSectionMap.end(); ++i )\n";
print GENERATEDFILE "  {\n";
print GENERATEDFILE "    if( !XLoadSection( (*i).second.c_str() ) )\n";
print GENERATEDFILE "    {\n";
print GENERATEDFILE "      PRINTMSG( T_ERROR, \"Failed to load section %s!\", (*i).second.c_str() );\n";
print GENERATEDFILE "      //return FALSE;\n";
print GENERATEDFILE "    }\n";
print GENERATEDFILE "  }\n";
print GENERATEDFILE "  return TRUE;\n";
print GENERATEDFILE "}\n\n";




print "Sectionizing drivers, sound hardware, and video hardware...\n";

#  LoadDriverSectionByName( "src\\drivers\\mpatrol.c" );   // 10 yard fight is dependent on the mpatrol vidhrdw
#  LoadDriverSectionByName( "src\\drivers\\snk.c" );       // hal21.c is dependent on snk vidhrdw (ASO - Armored Scrum Object)
#  LoadDriverSectionByName( "src\\drivers\\galaxian.c" );  // Amidar
#  LoadDriverSectionByName( "src\\drivers\\scramble.c" );  // Amidar
#  LoadDriverSectionByName( "src\\drivers\\scobra.c" );    // Amidar
#  LoadDriverSectionByName( "src\\drivers\\rampart.c" );   // Arcade Classic Arcadecl.c
#  LoadDriverSectionByName( "src\\drivers\\williams.c" );  // Archrivals
#  LoadDriverSectionByName( "src\\drivers\\rastan.c" );    // Asuka & Asuka (sound)
#  LoadDriverSectionByName( "src\\drivers\\hal21.c" );     // Athena
#  LoadDriverSectionByName( "src\\drivers\\espial.c" );    // battle cruiser
#  LoadDriverSectionByName( "src\\drivers\\bzone.c" );     // gravitar
#  LoadDriverSectionByName( "src\\drivers\\nova2001.c" );  // Penguin-Kun War
#  LoadDriverSectionByName( "src\\drivers\\gottlieb.c" );  // exterminator
#  LoadDriverSectionByName( "src\\drivers\\pengo.c" );     // eyes
#  LoadDriverSectionByName( "src\\drivers\\megasys1.c" );  // F1 Grand Prix Star
#  LoadDriverSectionByName( "src\\drivers\\rallyx.c" );    // Loco-Motion
#  LoadDriverSectionByName( "src\\drivers\\timeplt.c" );   // Loco-Motion
#  LoadDriverSectionByName( "src\\drivers\\exidy.c" );     // Victory
#  LoadDriverSectionByName( "src\\drivers\\m72.c" );       // Bomber Man World (World)
#  LoadDriverSectionByName( "src\\drivers\\leland.c" );    // Asylum (prototype)
#  LoadDriverSectionByName( "src\\drivers\\trackfld.c" );  // Hyper Sports, Hyper Olympics '84?
#  taito_f3 - Super Chase
#  fromance - Pipe Dream
#  frogger - Frog (Galaxian Hardware)
#  midyunit - Mortal Kombat 2
#  midtunit - WWF Wrestlemania
#  konamigx - Metaorphic Force
#  segar.c - Star Trek
#  zaxxon.c - Congo Bongo

# Note: Watch on midxunit.c, it only seems to be for Revolution X, which 
#       runs out of memory at the moment, there may be problems there in the
#       future.
@SkipDrivers = ( "jrcrypt.c" );

@TwinCobraFamily = ( "wardner.c", "twincobr.c" );
@CapcomFamily = ( "cps1.c", "cps2.c" );
@NamcoFamily = ( "namcoic.c", "namcona1.c", "namconb1.c", "namcond1.c", "namcos1.c",
                 "namcos2.c", "namcos21.c", "namcos22.c", "namcos86.c", "namcos11.c" );
@SegaFamily = ( "multi32.c", "system1.c", "system16.c", "system18.c", "system24.c", "system32.c",
				"aburner.c", "sharrier.c", "outrun.c" );

@MoonPatrolFamily = ( "mpatrol.c", "yard.c" );								# 10 Yard Fight07/07/2003
@SNKFamily = ( "snk.c", "hal21.c" );										# ASO - Armored Scrum Object, Athena
@AmidarFamily = ( "galaxian.c", "scramble.c", "scobra.c", 
                  "amidar.c", "frogger.c", "pacman.c",
				  "pengo.c" );												# Amidar, Frog (Galaxian Hardware), Pac-Man (Galaxian Hardware), eyes
@RampartFamily = ( "rampart.c", "arcadecl.c" );								# Arcade Classics
@RastanFamily = ( "rastan.c", "asuka.c", "opwolf.c", "rainbow.c" );			# Asuka & Asuka, Operation Wolf, Rainbow Islands
@EspialFamily = ( "espial.c", "marineb.c" );								# Battle Cruiser M-12
@BZoneFamily = ( "bzone.c", "bwidow.c" );									# Gravitar
@Nova2001Family = ( "nova2001.c", "pkunwar.c" );							# Penguin-Kun War
@GottLiebFamily = ( "gottlieb.c", "exterm.c" );							    # exterminator
@Megasys1Family = ( "megasys1.c", "cischeat.c" );							# F-1 Grand Prix Star II
@LocoMotionFamily = ( "rallyx.c", "timeplt.c", "locomotn.c", 
					  "tutankhm.c", "pooyan.c" );							# Loco-Motion, Tutankham, Pooyan
@ExidyFamily = ( "exidy.c", "victory.c" );									# Victory
@M72Family = ( "m72.c", "m90.c", "vigilant.c" );							# Bomber Man World (World), Vigilante
@LelandFamily = ( "leland.c", "ataxx.c" );									# Asylum (prototype)
@TrackFldFamily = ( "trackfld.c", "hyperspt.c", "yiear.c" );				# Hyper Sports, Hyper Olympics '84, Yie ar Kung Fu
@Taito_F3Family = ( "taito_f3.c", "superchs.c", "groundfx.c",
					"gunbustr.c", "undrfire.c" );							# Super Chase, Ground Effects, Gunbuster, Under Fire
@FromanceFamily = ( "fromance.c", "pipedrm.c" );							# Pipe Dream
@MidwayMCRFamily = ( "mcr1.c", "mcr2.c", "mcr3.c", "mcr68.c", "williams.c",
					 "midyunit.c", "midtunit.c", "midwunit.c", 
					 "midvunit.c", "midxunit.c" );							# Arch rivals, Mortal Kombat II, WWF: Wrestlemania (rev 1.30 08/10/95), Mortal Kombat, Revolution X
@KonamiGXFamily = ( "konamigx.c", "mystwarr.c" );							# Metamorphic Force
@SegarFamily = ( "segar.c", "sega.c" );										# Star Trek
@ZaxxonFamily = ( "zaxxon.c", "congo.c" );									# Congo Bongo

@WizFamily = ( "wiz.c", "rollrace.c" );										# Fighting Roller

@TetrisPlus2Family = ( "ms32.c", "tetrisp2.c" );							# Tetris Plus 2 (MegaSystem 32 Version)

local @Families = ( \@CapcomFamily, \@NamcoFamily, \@SegaFamily, \@MidwayMCRFamily, \@TwinCobraFamily,
					\@MoonPatrolFamily, \@SNKFamily, \@AmidarFamily, \@RampartFamily, \@RastanFamily,
					\@EspialFamily, \@BZoneFamily, \@Nova2001Family, \@GottLiebFamily, 
					\@Megasys1Family, \@LocoMotionFamily, \@ExidyFamily, \@M72Family, \@LelandFamily,
					\@TrackFldFamily, \@Taito_F3Family, \@FromanceFamily, \@MidYUnitFamily, \@KonamiGXFamily,
					\@SegarFamily, \@ZaxxonFamily, \@WizFamily, \@TetrisPlus2Family );
$autoNameNumber = $#Families + 50;


print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	UnloadDriverSections\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "BOOL UnloadDriverSections( void )\n";
print GENERATEDFILE "{\n";
print GENERATEDFILE "  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.begin();\n";
print GENERATEDFILE "  for( ; i != g_nameToSectionMap.end(); ++i )\n";
print GENERATEDFILE "  {\n";
print GENERATEDFILE "      // Only unload families once (all but the first member are skipped)\n";
print GENERATEDFILE "    if( (*i).first == ";
local $IsFirst = true;
foreach( @Families ) {
	$FamilyArray = $_;
	foreach( @{$FamilyArray} ) {
			# Skip the first (key) member of the family
		if( $_ eq $FamilyArray->[0] ) {
			next;
		}

			# Print OR
		if( $IsFirst ne true ) {
			print GENERATEDFILE " ||\n        (*i).first == ";
		}
		$IsFirst = false;

			# Print code to ignore this member
		print GENERATEDFILE "\"src\\\\drivers\\\\$_\"";
	}
}
print GENERATEDFILE " )\n";
print GENERATEDFILE "        continue;\n";
print GENERATEDFILE "    XFreeSection( (*i).second.c_str() );\n";
print GENERATEDFILE "  }\n";
print GENERATEDFILE "  return TRUE;\n";
print GENERATEDFILE "}\n\n";
print GENERATEDFILE "\n//-------------------------------------------------------------\n";
print GENERATEDFILE "//	RegisterDriverSectionNames\n";
print GENERATEDFILE "//-------------------------------------------------------------\n";
print GENERATEDFILE "static void RegisterDriverSectionNames( void )\n";
print GENERATEDFILE "{\n";


# Do two passes, one to find the last autoNameNumber, another to actually
# modify the files
print "Pass 1...\n";

foreach( @FILEs ) {
	chomp( $_ );

	$DriverFileName = $_;

		# Change the DriverName to what will be present in the actual MAME code
		# Drop the ./MAME/ portion
	/^\.\/MAME\/src\/drivers\/(.*\.c)$/;
	$DriverNoPath = $1;
	$DriverName = "src\\\\drivers\\\\$1";
	$IsValid = true;

		# Skip the fake jrcrypt.c file and all the hack files
	foreach( @SkipDrivers ) {
		if( ($DriverNoPath eq $_ ) ) {
			print "Skipping $DriverNoPath.\n";
			$IsValid = false;
			last;
		}
	}

	next if( $IsValid eq false );


	$Family = false;
	$FamilyID = 0;
	foreach( @Families ) {
		$FamilyArray = $_;
		$FamilyID++;
		foreach( @{$FamilyArray} ) {
			if( ($DriverNoPath eq $_ ) ) {
				print "$DriverNoPath is in family $FamilyID.\n";
				$Family = $FamilyID;
				last;
			}
		}
	}



	($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
	 $atime,$mtime,$ctime,$blksize,$blocks) = stat( $DriverFileName );

	open( FILE, "<$DriverFileName" ) || die "Failed to open file $DriverFileName!\n";
	sysread( FILE, $File, $size );
	close( FILE );

	if( ($File =~ /\#pragma code_seg/) ) {
			# this should only happen on the first pass
		if( $Family ne false ) {
			print PRELOADFILE "/NOPRELOAD:\"$myAutoNameNumber\"\n";
			print DBGPRELOADFILE "/NOPRELOAD:\"$myAutoNameNumber\"\n";
			print GENERATEDFILE "  RegisterSectionName( \"$DriverName\", \"$Family\" );\n";
			$myAutoNameNumber = 0;	# Don't increment (families should always be less anyway)
		} else {
			$File =~ /\#pragma code_seg\(\"C(\d+)\"\)/;
			$myAutoNameNumber = $1;
			print PRELOADFILE "/NOPRELOAD:\"$myAutoNameNumber\"\n";
			print DBGPRELOADFILE "/NOPRELOAD:\"$myAutoNameNumber\"\n";
			print GENERATEDFILE "  RegisterSectionName( \"$DriverName\", \"$myAutoNameNumber\" );\n";
		}


		if( $myAutoNameNumber >= $autoNameNumber ) {
			$autoNameNumber = $myAutoNameNumber + 1;
		}		

	} else {
	   push @newFILEs, $DriverFileName;
	}
}


# Second pass, write out the section headers
print "Pass 2...\n";
if( scalar( @newFILEs ) == 0 ) {
	print "Nothing to do.\n";
}

foreach( @newFILEs ) {
	chomp( $_ );

	$DriverFileName = $_;

		# Change the DriverName to what will be present in the actual MAME code
		# Drop the ./MAME/ portion
	/^\.\/MAME\/src\/drivers\/(.*\.c)$/;
	$DriverNoPath = $1;
	$DriverName = "src\\\\drivers\\\\$1";
	$IsValid = true;

		# Skip the fake jrcrypt.c file and all the hack files
	foreach( @SkipDrivers ) {
		if( ($DriverNoPath eq $_ ) ) {
			print "Skipping $DriverNoPath.\n";
			$IsValid = false;
			last;
		}
	}

	next if( $IsValid eq false );

	$Family = false;
	$FamilyID = 0;
	foreach( @Families ) {
		$FamilyArray = $_;
		$FamilyID++;
		foreach( @{$FamilyArray} ) {
			if( ($DriverNoPath eq $_ ) ) {
				print "$DriverNoPath is in family $FamilyID.\n";
				$Family = $FamilyID;
				last;
			}
		}
	}

	if( $Family ne false ) {
		print PRELOADFILE "/NOPRELOAD:\"$myAutoNameNumber\"\n";
		print DBGPRELOADFILE "/NOPRELOAD:\"$myAutoNameNumber\"\n";
		print GENERATEDFILE "  RegisterSectionName( \"$DriverName\", \"$Family\" );\n";
	} else {
		print PRELOADFILE "/NOPRELOAD:\"$autoNameNumber\"\n";
		print DBGPRELOADFILE "/NOPRELOAD:\"$autoNameNumber\"\n";
		print GENERATEDFILE "  RegisterSectionName( \"$DriverName\", \"$autoNameNumber\" );\n";
	}

	($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
	 $atime,$mtime,$ctime,$blksize,$blocks) = stat( $DriverFileName );

	open( FILE, "<$DriverFileName" ) || die "Failed to open file $DriverFileName!\n";
	sysread( FILE, $File, $size );
	close( FILE );

		# Write out the section header/footer
	if( $Family ne false ) {
		WriteSectionData( $DriverFileName, $File, $Family );
	} else {
		WriteSectionData( $DriverFileName, $File, $autoNameNumber );
	}

		# Also do the vidhdrw file, if one exists
	$VidHardwareName = $DriverFileName;
	$VidHardwareName =~ s/\/drivers\//\/vidhrdw\//;

	($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
	 $atime,$mtime,$ctime,$blksize,$blocks) = stat( $VidHardwareName );

	if( open( FILE, "<$VidHardwareName" ) ) {
		$File = "";
		sysread( FILE, $File, $size );
		close( FILE );

		if( !($File =~ /\#pragma code_seg/) ) {
			if( $Family ne false ) {
				WriteSectionData( $VidHardwareName, $File, $Family );
			} else {
				WriteSectionData( $VidHardwareName, $File, $autoNameNumber );
			}
		}
	}

		# Also do the sndhrdw file, if one exists
	$SoundHardwareName = $DriverFileName;
	$SoundHardwareName =~ s/\/drivers\//\/sndhrdw\//;

	($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
	 $atime,$mtime,$ctime,$blksize,$blocks) = stat( $SoundHardwareName );

	if( open( FILE, "<$SoundHardwareName" ) ) {
		$File = "";
		sysread( FILE, $File, $size );
		close( FILE );

		if( !($File =~ /\#pragma code_seg/) ) {
			if( $Family ne false ) {
				WriteSectionData( $SoundHardwareName, $File, $Family );
			} else {
				WriteSectionData( $SoundHardwareName, $File, $autoNameNumber );
			}
		}
	}

		# Also do the machine file, if one exists
	$MachineHardwareName = $DriverFileName;
	$MachineHardwareName =~ s/\/drivers\//\/machine\//;

	($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
	 $atime,$mtime,$ctime,$blksize,$blocks) = stat( $MachineHardwareName );

	if( open( FILE, "<$MachineHardwareName" ) ) {
		$File = "";
		sysread( FILE, $File, $size );
		close( FILE );

		if( !($File =~ /\#pragma code_seg/) ) {
			if( $Family ne false ) {
				WriteSectionData( $MachineHardwareName, $File, $Family );
			} else {
				WriteSectionData( $MachineHardwareName, $File, $autoNameNumber );
			}
		}
	}

	$autoNameNumber++;
}
print GENERATEDFILE "}\n";
print GENERATEDFILE "#pragma code_seg()\n";
print GENERATEDFILE "#pragma data_seg()\n";
print GENERATEDFILE "} // End extern \"C\"\n\n\n";
close( GENERATEDFILE );













#------------------------------------------------------------------------------


print "\n\nSectionizing CPU's...\n";

#local @CPUDirs = `find ./MAME/src/cpu -path \'*/CVS\' -prune -o -type d -a -print`;
@FILEs    = `find ./MAME/src/cpu/ -name *.c`;
@newFILEs = ();
local $OldCPUName = "";


#@SkipCPUs = ( "DSP32", "I8085", "JAGUAR", "MIPS", "NEC", "PIC16C5X", "TMS9900" );
@SkipCPUs = ();

	# Notes on CPU families:
	# - Items on the first line have actual source files, 
	#	the rest share the original sources
	# - The families have been derived by reading cpuintrf.c, checking which
	#	#if (HAS_)'s lead to which #includes. Sometimes this fails, in which case
	#   the CPUx macros themselves need to be consulted (example HAS_R5000, provides CPUs
	#   CPU_R5000BE and CPU_R5000LE, no CPU_R5000)

	# The xxxFamily string defines the source directories of the CPU family
	# The xxxClones array defines the list of all CPU_ #defines that use the source files in xxxFamily
	# NOTE: it is very important that the family of the CPU be the first item in the Clones list,
	#       if the family name is the name of a real CPU! (there are cases where it's not, like "MIPS" )

$adsp2100Family = "ADSP2100";
@adsp2100Clones = ( "ADSP2100", "ADSP2101", "ADSP2105", "ADSP2115" );

$armFamily = "ARM";
@armClones = ( "ARM" );

$asapFamily = "ASAP";
@asapClones = ( "ASAP" );

$ccpuFamily = "CCPU";
@ccpuClones = ( "CCPU" );

$dsp32Family = "DSP32";
@dsp32Clones = ( "DSP32C" );

$h6280Family = "H6280";
@h6280Clones = ( "H6280" );

$hd6309Family = "HD6309";
@hd6309Clones = ( "HD6309" );

$i8039Family = "I8039";
@i8039Clones = ( "I8035", "I8039", "I8048", "N7751" );

$i8085Family = "I8085";
@Z80Clones = ( "8080", "8085A" );

$i86Family = "I86";
@i86Clones = ( "I86", 
#			   "I88",		# Disabled in VCPPMame.h
			   "I186" );
#			   "I188",		# Disabled in VCPPMame.h
#			   "I286" );	# Disabled in VCPPMame.h

$i8x41Family = "I8X41";
@i8x41Clones = ( "I8X41" );

$JaguarFamily = "JAGUAR";
@JaguarClones = ( "JAGUARGPU", "JAGUARDSP" );

$KonamiFamily = "KONAMI";
@KonamiClones = ( "KONAMI" );

$m6502Family = "M6502";
@m6502Clones = ( "M6502", 
				 "M65C02", 
#				 "M65SC02", # Disabled in VCPPMame.h
				 "M6510", 
#				 "M6510T",	# Disabled in VCPPMame.h
#				 "M7501",	# Disabled in VCPPMame.h
#				 "M8502",	# Disabled in VCPPMame.h
				 "N2A03", 
				 "DECO16" );
#				 "M4510" );	# Disabled in VCPPMame.h
#				 "M65CE02",	# Disabled in VCPPMame.h
#				 "M6509" ); # Disabled in VCPPMame.h

$m6800Family = "M6800";
@m6800Clones = ( "M6800", "M6801", "M6802", "M6803", "M6808", "HD63701" );

$m68000Family = "M68000";
@m68000Clones = ( "M68000", "M68010", "M68020", "M68EC020" );

$m6805Family = "M6805";
@m6805Clones = ( "M6805", "M68705", "HD63705" );

$m6809Family = "M6809";
@m6809Clones = ( "M6809" );

$mipsFamily = "MIPS";
@mipsClones = (	"PSXCPU",
				"R3000BE", 
				"R3000LE", 
				"R4600BE", 
				"R4600LE", 
				"R5000BE",
				"R5000LE" );

$NECFamily = "NEC";
@NECClones = ( "V20", "V30", "V33" );

$pic16c5xFamily = "PIC16C5X";
@pic16c5xClones = ( "PIC16C54", "PIC16C55", "PIC16C56", "PIC16C57", "PIC16C58" );

$s2650Family = "S2650";
@s2650Clones = ( "S2650" );

$sh2Family = "SH2";
@sh2Clones = ( "SH2" );

$t11Family = "T11";
@t11Clones = ( "T11" );

$tms32010Family = "TMS32010";
@tms32010Clones = ( "TMS32010" );

$tms32025Family = "TMS32025";
@tms32025Clones = ( "TMS32025" );

$tms32031Family = "TMS32031";
@tms32031Clones = ( "TMS32031" );

$tms34010Family = "TMS34010";
@tms34010Clones = ( "TMS34010", "TMS34020" );

$tms9900Family = "TMS9900";
@tms9900Clones = (	#"TMS9900", # Disabled in VCPPMame.h
					#"TMS9940", # Disabled in VCPPMame.h
					"TMS9980", 
					#"TMS9985", # Disabled in VCPPMame.h
					#"TMS9989", # Disabled in VCPPMame.h
					"TMS9995" );
					#"TMS99105A",	# Disabled in VCPPMame.h
					#"TMS99110A" );	# Disabled in VCPPMame.h

$udp7810Family = "UPD7810";
@udp7810Clones = ( "UPD7810", "UPD7807" );

$v60Family = "V60";
@v60Clones = ( "V60", "V70" );

$Z180Family = "Z180";
@Z180Clones = ( "Z180" );

$Z80Family = "Z80";
@Z80Clones = ( "Z80" );

$z8000Family = "Z8000";
@z8000Clones = ( "Z8000" );

$g65816Family = "g65816";
@g65816Clones = ( "g65816" );

$spc700Family = "spc700";
@spc700Clones = ( "spc700" );

@Families = (	\$Z80Family, 
				\$Z180Family, 
				\$i8085Family,
				\$m6502Family, 
				\$h6280Family,
				\$i86Family,
				\$NECFamily,
				\$v60Family,
				\$i8039Family,
				\$i8x41Family,
				\$m6800Family,
				\$m6805Family,
				\$m6809Family,
				\$hd6309Family,
				\$KonamiFamily,
				\$m68000Family,
				\$t11Family,
				\$s2650Family,
				\$tms34010Family,
				\$tms9900Family,
				\$z8000Family,
				\$tms32010Family,
				\$tms32025Family,
				\$tms32031Family,
				\$ccpuFamily,
				\$adsp2100Family,
				\$mipsFamily,
				\$asapFamily,
				\$udp7810Family,
				\$JaguarFamily,
				\$armFamily,
				\$sh2Family,
				\$dsp32Family,
				\$pic16c5xFamily,
				\$g65816Family,
				\$spc700Family );



@Clones = ( \@Z80Clones,
			\@Z180Clones,
			\@Z80Clones,
			\@m6502Clones,
			\@h6280Clones,
			\@i86Clones,
			\@NECClones,
			\@v60Clones,
			\@i8039Clones,
			\@i8x41Clones,
			\@m6800Clones,
			\@m6805Clones,
			\@m6809Clones,
			\@hd6309Clones,
			\@KonamiClones,
			\@m68000Clones,
			\@t11Clones,
			\@s2650Clones,
			\@tms34010Clones,
			\@tms9900Clones,
			\@z8000Clones,
			\@tms32010Clones,
			\@tms32025Clones,
			\@tms32031Clones,
			\@ccpuClones,
			\@adsp2100Clones,
			\@mipsClones,
			\@asapClones,
			\@udp7810Clones,
			\@JaguarClones,
			\@armClones,
			\@sh2Clones,
			\@dsp32Clones,
			\@pic16c5xClones,
			\@g65816Clones,
			\@spc700Clones );

$autoNameNumber = $#Families + 10;



	# Create the CPUSections.cpp file
open( CPUFILE, ">./MAMEoX/sources/CPUSections.cpp" );
print CPUFILE "/**\n";
print CPUFILE "  * \\file      CPUSections.cpp\n";
print CPUFILE "  * \\brief     Registration of CPU files for creation and usage of XBOX\n";
print CPUFILE "  *             loadable sections\n";
print CPUFILE "  *\n";
print CPUFILE "  * \\note      This file is autogenerated via Sectionize.pl DO NOT EDIT!\n";
print CPUFILE "  */\n\n";
print CPUFILE "//= I N C L U D E S ====================================================\n";
print CPUFILE "#include \"MAMEoX.h\"\n";
print CPUFILE "#include <stdio.h>\n";
print CPUFILE "#include <map>\n";
print CPUFILE "#include <string>\n";
print CPUFILE "#include \"DebugLogger.h\"\n";
print CPUFILE "extern \"C\" {\n";
print CPUFILE "#include \"osd_cpu.h\"\n";
print CPUFILE "#include \"cpuintrf.h\"\n";
print CPUFILE "}\n";
print CPUFILE "//= D E F I N E S ======================================================\n";
print CPUFILE "#define DATA_PREFIX      \"C".DATA_PREFIX."\"\n";
print CPUFILE "#define CODE_PREFIX      \"C".CODE_PREFIX."\"\n";
print CPUFILE "#define BSS_PREFIX       \"C".BSS_PREFIX."\"\n";
print CPUFILE "#define CONST_PREFIX     \"C".CONST_PREFIX."\"\n";
print CPUFILE "\n";
print CPUFILE "//= G L O B A L = V A R S ==============================================\n";
print CPUFILE "static std::map< UINT32, std::string >  g_IDToSectionMap;\n\n";
print CPUFILE "//= P R O T O T Y P E S ================================================\n";
print CPUFILE "extern \"C\" static void RegisterCPUSectionNames( void );\n\n";
print CPUFILE "//= F U N C T I O N S ==================================================\n";
print CPUFILE "extern \"C\" {\n";
print CPUFILE "\n//-------------------------------------------------------------\n";
print CPUFILE "//	InitCPUSectionizer\n";
print CPUFILE "//-------------------------------------------------------------\n";
print CPUFILE "void InitCPUSectionizer( void )\n";
print CPUFILE "{\n";
print CPUFILE "  g_IDToSectionMap.clear();\n";
print CPUFILE "  void *addr;\n";
print CPUFILE "  addr = XLoadSection( \"CPUSNIZE\" );\n";
print CPUFILE "  if( !addr )\n";
print CPUFILE "  {\n";
print CPUFILE "    UINT32 lastErr = GetLastError();\n";
print CPUFILE "    PRINTMSG( T_ERROR, \"XLoadSection failed! 0x%X\\r\\n\", lastErr );\n";
print CPUFILE "  }\n";
print CPUFILE "  RegisterCPUSectionNames();\n";
print CPUFILE "}\n\n";
print CPUFILE "\n//-------------------------------------------------------------\n";
print CPUFILE "//	TerminateCPUSectionizer\n";
print CPUFILE "//-------------------------------------------------------------\n";
print CPUFILE "void TerminateCPUSectionizer( void )\n";
print CPUFILE "{\n";
print CPUFILE "  g_IDToSectionMap.clear();\n";
print CPUFILE "  XFreeSection( \"CPUSNIZE\" );\n";
print CPUFILE "}\n\n";
print CPUFILE "#pragma code_seg( \"CPUCSNZE\" )\n";
print CPUFILE "#pragma data_seg( \"CPUDSNZE\" )\n";
print CPUFILE "#pragma comment(linker, \"/merge:CPUCSNZE=CPUSNIZE\")\n";
print CPUFILE "#pragma comment(linker, \"/merge:CPUDSNZE=CPUSNIZE\")\n";
print CPUFILE "\n#ifdef _DEBUG\n";
print CPUFILE "//-------------------------------------------------------------\n";
print CPUFILE "//	CheckCPUSectionRAM\n";
print CPUFILE "//-------------------------------------------------------------\n";
print CPUFILE "void CheckCPUSectionRAM( void )\n";
print CPUFILE "{\n";
print CPUFILE "  DWORD total = 0;\n";
print CPUFILE "  std::map< UINT32, std::string >::iterator i = g_IDToSectionMap.begin();\n";
print CPUFILE "  for( ; i != g_IDToSectionMap.end(); ++i )\n";
print CPUFILE "  {\n";
print CPUFILE "    HANDLE h = XGetSectionHandle( (*i).second.c_str() );\n";
print CPUFILE "    if( h != INVALID_HANDLE_VALUE )\n";
print CPUFILE "    {\n";
print CPUFILE "      UINT32 sz = XGetSectionSize( h );\n";
print CPUFILE "      PRINTMSG( T_INFO, \"CPU%lu %lu\", (*i).first, sz );\n";
print CPUFILE "      total += sz;\n";
print CPUFILE "    }\n";
print CPUFILE "    else\n";
print CPUFILE "      PRINTMSG( T_ERROR, \"Invalid section %s for CPU%lu!\", (*i).second.c_str(), (*i).first );\n";
print CPUFILE "  }\n";
print CPUFILE "  PRINTMSG( T_INFO, \"Total %lu bytes\\n\", total );\n";
print CPUFILE "}\n";
print CPUFILE "#endif\n\n";
print CPUFILE "\n//-------------------------------------------------------------\n";
print CPUFILE "//	RegisterSectionID\n";
print CPUFILE "//-------------------------------------------------------------\n";
print CPUFILE "static void RegisterSectionID( UINT32 CPUID, const char *DataSectionName )\n";
print CPUFILE "{\n";
print CPUFILE "    // Add the section name to the map\n";
print CPUFILE "  g_IDToSectionMap[ CPUID ] = DataSectionName;\n";
print CPUFILE "}\n\n";
print CPUFILE "\n//-------------------------------------------------------------\n";
print CPUFILE "//	LoadCPUSectionByID\n";
print CPUFILE "//-------------------------------------------------------------\n";
print CPUFILE "BOOL LoadCPUSectionByID( UINT32 CPUID )\n";
print CPUFILE "{\n";
print CPUFILE "  std::map< UINT32, std::string >::iterator i = g_IDToSectionMap.find( CPUID );\n";
print CPUFILE "  if( i == g_IDToSectionMap.end() )\n";
print CPUFILE "    return FALSE;\n";
print CPUFILE "  void *addr;\n";
print CPUFILE "  PRINTMSG( T_INFO, \"Load section CPU%lu, ID %s\\n\", CPUID, (*i).second.c_str() );\n";
print CPUFILE "  addr = XLoadSection( (*i).second.c_str() );\n";
print CPUFILE "  if( !addr )\n";
print CPUFILE "  {\n";
print CPUFILE "    UINT32 lastErr = GetLastError();\n";
print CPUFILE "    PRINTMSG( T_ERROR, \"XLoadSection failed for section %s! 0x%X\\r\\n\", (*i).second.c_str(), lastErr );\n";
print CPUFILE "  }\n";
print CPUFILE "  return TRUE;\n";
print CPUFILE "}\n\n";
print CPUFILE "\n//-------------------------------------------------------------\n";
print CPUFILE "//	UnloadCPUSectionByID\n";
print CPUFILE "//-------------------------------------------------------------\n";
print CPUFILE "BOOL UnloadCPUSectionByID( UINT32 CPUID )\n";
print CPUFILE "{\n";
print CPUFILE "  std::map< UINT32, std::string >::iterator i = g_IDToSectionMap.find( CPUID );\n";
print CPUFILE "  if( i == g_IDToSectionMap.end() )\n";
print CPUFILE "    return FALSE;\n";
print CPUFILE "  return XFreeSection( (*i).second.c_str() );\n";
print CPUFILE "}\n\n";
print CPUFILE "\n//-------------------------------------------------------------\n";
print CPUFILE "//	LoadCPUSections\n";
print CPUFILE "//-------------------------------------------------------------\n";
print CPUFILE "BOOL LoadCPUSections( void )\n";
print CPUFILE "{\n";
print CPUFILE "  std::map< UINT32, std::string >::iterator i = g_IDToSectionMap.begin();\n";
print CPUFILE "  for( ; i != g_IDToSectionMap.end(); ++i )\n";
print CPUFILE "  {\n";
print CPUFILE "    if( !XLoadSection( (*i).second.c_str() ) )\n";
print CPUFILE "    {\n";
print CPUFILE "      PRINTMSG( T_ERROR, \"Failed to load section %s!\", (*i).second.c_str() );\n";
print CPUFILE "      //return FALSE;\n";
print CPUFILE "    }\n";
print CPUFILE "  }\n";
print CPUFILE "  return TRUE;\n";
print CPUFILE "}\n\n";
print CPUFILE "\n//-------------------------------------------------------------\n";
print CPUFILE "//	UnloadCPUSections\n";
print CPUFILE "//-------------------------------------------------------------\n";
print CPUFILE "BOOL UnloadCPUSections( void )\n";
print CPUFILE "{\n";
print CPUFILE "  std::map< UINT32, std::string >::iterator i = g_IDToSectionMap.begin();\n";
print CPUFILE "  for( ; i != g_IDToSectionMap.end(); ++i )\n";
print CPUFILE "  {\n";
print CPUFILE "      // Only unload families once (all but the first member are skipped)\n";
print CPUFILE "    if( (*i).first == ";
local $IsFirst = true;
foreach( @Clones ) {
	$CloneArray = $_;
	foreach( @{$CloneArray} ) {
			# Skip the first (key) member of the family
		if( $_ eq $CloneArray->[0] ) {
			next;
		}

			# Print OR
		if( $IsFirst ne true ) {
			print CPUFILE " ||\n        (*i).first == ";
		}
		$IsFirst = false;

			# Print code to ignore this member
		print CPUFILE "CPU_$_";
	}
}
print CPUFILE " )\n";
print CPUFILE "        continue;\n";
print CPUFILE "    XFreeSection( (*i).second.c_str() );\n";
print CPUFILE "  }\n";
print CPUFILE "  return TRUE;\n";
print CPUFILE "}\n\n";
print CPUFILE "\n//-------------------------------------------------------------\n";
print CPUFILE "//	RegisterCPUSectionNames\n";
print CPUFILE "//-------------------------------------------------------------\n";
print CPUFILE "static void RegisterCPUSectionNames( void )\n";
print CPUFILE "{\n";




# Do two passes, one to find the last autoNameNumber, another to actually
# modify the files
print "Pass 1...\n";

foreach( @FILEs ) {
	chomp( $_ );

	$DriverFileName = $_;
	$CPUName = $_;
		# Change the CPUName to what will be present in the actual code
		# Drop the ./MAME/src/cpu portion
	$CPUName =~ /^\.\/MAME\/src\/cpu\/(.+)\/.+\.c$/;
	$CPUName = $1;

	$IsValid = true;

		# Skip the fake jrcrypt.c file and all the hack files
	foreach( @SkipCPUs ) {
		$CPUToSkip = $_;
		if( uc($CPUName) eq $CPUToSkip ) {
			print "Skipping $CPUName.\n";
			$IsValid = false;
			last;
		}
	}
	next if( $IsValid eq false );

	$Family = false;
	$FamilyID = 0;
	foreach( @Families ) {
		$FamilyID++;
		if( uc($CPUName) eq $$_ ) {
			print "$CPUName is in family $FamilyID.\n";
			$Family = $FamilyID;
			last;
		}
	}


	($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
	 $atime,$mtime,$ctime,$blksize,$blocks) = stat( $DriverFileName );

	open( FILE, "<$DriverFileName" ) || die "Failed to open file $DriverFileName!\n";
	sysread( FILE, $File, $size );
	close( FILE );

	if( ($File =~ /\#pragma code_seg/) ) {
			# this should only happen on the first pass
		$File =~ /\#pragma code_seg\(\"CC(\d+)\"\)/;
		$myAutoNameNumber = $1;

			# Unlike the drivers, we want one name for an entire directory
			# so only register on a new directory (CPUName)
		if( $CPUName ne $OldCPUName ) {
			$OldCPUName = $CPUName;
			$ucaseCPUName = uc( $CPUName );
			if( $Family ne false ) {
				$myAutoNameNumber = 0;	# Don't increment (families should always be less anyway)
				print PRELOADFILE "/NOPRELOAD:\"C$Family\"\n";
				print DBGPRELOADFILE "/NOPRELOAD:\"C$Family\"\n";
					# Each real CPU is also listed as a clone, so this would be a duplicate
				#print CPUFILE "  RegisterSectionID( CPU_$ucaseCPUName, \"CPU$Family\" );\n";

					# Register all the clones for this CPU
				$CloneArray = @Clones[$Family-1];
				foreach( @{$CloneArray} ) {
					print CPUFILE "  RegisterSectionID( CPU_$_, \"CPU$Family\" );\n";
				}
			}
			else {
				print PRELOADFILE "/NOPRELOAD:\"C$myAutoNameNumber\"\n";
				print DBGPRELOADFILE "/NOPRELOAD:\"C$myAutoNameNumber\"\n";
				print CPUFILE "  RegisterSectionID( CPU_$ucaseCPUName, \"CPU$myAutoNameNumber\" );\n";
			}
		}

		if( $myAutoNameNumber >= $autoNameNumber ) {
			$autoNameNumber = $myAutoNameNumber + 1;
		}
	} else {
		push @newFILEs, $DriverFileName;
	}
}

# Second pass, write out the section headers
print "Pass 2...\n";
if( scalar( @newFILEs ) == 0 ) {
	print "Nothing to do.\n";
}

$OldCPUName = "";
foreach( @newFILEs ) {
	chomp( $_ );

	$DriverFileName = $_;
	$CPUName = $_;
		# Change the CPUName to what will be present in the actual code
		# Drop the ./MAME/src/cpu portion
	$CPUName =~ /^\.\/MAME\/src\/cpu\/(.+)\/.+\.c$/;
	$CPUName = $1;

	$IsValid = true;

		# Skip the fake jrcrypt.c file and all the hack files
	foreach( @SkipCPUs ) {
		$CPUToSkip = $_;
		$CPUToSkip =~ s/\.c/\\.c/;
		if( ($CPUName =~ /.*$CPUToSkip/ ) ) {
			print "Skipping $CPUName.\n";
			$IsValid = false;
			last;
		}
	}
	next if( $IsValid eq false );

	$Family = false;
	$FamilyID = 0;
	foreach( @Families ) {
		$FamilyArray = $_;
		$FamilyID++;
		if( uc($CPUName) eq $$_ ) {
			print "$CPUName is in family $FamilyID.\n";
			$Family = $FamilyID;
			last;
		}
	}

		# Unlike the drivers, we want one name for an entire directory
		# so only register on a new directory (CPUName)
	if( $CPUName ne $OldCPUName ) {
		$OldCPUName = $CPUName;
		$ucaseCPUName = uc( $CPUName );
		if( $Family ne false ) {
			print PRELOADFILE "/NOPRELOAD:\"C$Family\"\n";
			print DBGPRELOADFILE "/NOPRELOAD:\"C$Family\"\n";
				# Each real CPU is also listed as a clone, so this would be a duplicate
			#print CPUFILE "  RegisterSectionID( CPU_$ucaseCPUName, \"CPU$Family\" );\n";

				# Register all the clones for this CPU
			$CloneArray = @Clones[$Family-1];
			foreach( @{$CloneArray} ) {
				print CPUFILE "  RegisterSectionID( CPU_$_, \"CPU$Family\" );\n";
			}
		} else {
			$autoNameNumber++;
			print PRELOADFILE "/NOPRELOAD:\"C$autoNameNumber\"\n";
			print DBGPRELOADFILE "/NOPRELOAD:\"C$autoNameNumber\"\n";
			print CPUFILE "  RegisterSectionID( CPU_$ucaseCPUName, \"CPU$autoNameNumber\" );\n";
		}
	}


	($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
	 $atime,$mtime,$ctime,$blksize,$blocks) = stat( $DriverFileName );

	open( FILE, "<$DriverFileName" ) || die "Failed to open file $DriverFileName!\n";
	sysread( FILE, $File, $size );
	close( FILE );

		# Write out the section header/footer
	if( $Family ne false ) {
		WriteCPUSectionData( $DriverFileName, $File, $Family );
	} else {
		WriteCPUSectionData( $DriverFileName, $File, $autoNameNumber );
	}
}

print CPUFILE "}\n";
print CPUFILE "#pragma code_seg()\n";
print CPUFILE "#pragma data_seg()\n";
print CPUFILE "} // End extern \"C\"\n\n\n";
close( CPUFILE );


close( PRELOADFILE );
close( DBGPRELOADFILE );



#------------------------------------------------------------------------
#	WriteSectionData
#------------------------------------------------------------------------
sub WriteSectionData( $$$ ) {
	my $FileName = $_[0];
	my $File = $_[1];
	my $autoNameNumber = $_[2];
	my $DataSectionName = "\"D$autoNameNumber\"";
	my $CodeSectionName = "\"C$autoNameNumber\"";
	my $BSSSectionName = "\"B$autoNameNumber\"";
	my $ConstSectionName= "\"K$autoNameNumber\"";

	open( FILE, ">$FileName" ) || die "Could not open $FileName for output!\n";

		#open the segment
	my $SegLine = "#pragma code_seg($CodeSectionName)\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma data_seg($DataSectionName)\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma bss_seg($BSSSectionName)\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma const_seg($ConstSectionName)\n";
	syswrite( FILE, $SegLine, length($SegLine) );


		# Merge all of the sections into one segment (identified by $autoNameNumber)
		# Note: It is _very_ important to put the data section first, otherwise the
		#       merged section will be read-only!
	$SegLine = "#pragma comment(linker, \"/merge:D$autoNameNumber=$autoNameNumber\")\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma comment(linker, \"/merge:C$autoNameNumber=$autoNameNumber\")\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma comment(linker, \"/merge:B$autoNameNumber=$autoNameNumber\")\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma comment(linker, \"/merge:K$autoNameNumber=$autoNameNumber\")\n";
	syswrite( FILE, $SegLine, length($SegLine) );


		#write the old file data
	syswrite( FILE, $File, $size );

		#Close the segment
	$SegLine = "#pragma code_seg()\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma data_seg()\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma bss_seg()\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma const_seg()\n";
	syswrite( FILE, $SegLine, length($SegLine) );

	close( FILE );
}

#------------------------------------------------------------------------
#	WriteCPUSectionData
#------------------------------------------------------------------------
sub WriteCPUSectionData( $$$ ) {
	my $FileName = $_[0];
	my $File = $_[1];
	my $autoNameNumber = $_[2];
	my $CodeSectionName = "\"CC$autoNameNumber\"";
	my $DataSectionName = "\"CD$autoNameNumber\"";
	my $BSSSectionName = "\"CB$autoNameNumber\"";
	my $ConstSectionName= "\"CK$autoNameNumber\"";

	open( FILE, ">$FileName" ) || die "Could not open $FileName for output!\n";

		#open the segment
	my $SegLine = "#pragma code_seg($CodeSectionName)\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma data_seg($DataSectionName)\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma bss_seg($BSSSectionName)\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma const_seg($ConstSectionName)\n";
	syswrite( FILE, $SegLine, length($SegLine) );

		# Merge all of the sections into one segment (identified by C$autoNameNumber)
		# Note: It is _very_ important to put the data section first, otherwise the
		#       merged section will be read-only!
	$SegLine = "#pragma comment(linker, \"/merge:CD$autoNameNumber=CPU$autoNameNumber\")\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma comment(linker, \"/merge:CC$autoNameNumber=CPU$autoNameNumber\")\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma comment(linker, \"/merge:CB$autoNameNumber=CPU$autoNameNumber\")\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma comment(linker, \"/merge:CK$autoNameNumber=CPU$autoNameNumber\")\n";
	syswrite( FILE, $SegLine, length($SegLine) );


		#write the old file data
	syswrite( FILE, $File, $size );

		#Close the segment
	$SegLine = "#pragma code_seg()\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma data_seg()\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma bss_seg()\n";
	syswrite( FILE, $SegLine, length($SegLine) );
	$SegLine = "#pragma const_seg()\n";
	syswrite( FILE, $SegLine, length($SegLine) );

	close( FILE );
}
