/**
  * \file      DriverSections.cpp
  * \brief     Registration of driver files for creation and usage of XBOX
  *             loadable sections
  *
  * \note      This file is autogenerated via Sectionize.pl DO NOT EDIT!
  */

//= I N C L U D E S ====================================================
#include "MAMEoX.h"
#include <stdio.h>
#include <map>
#include <string>
#include "DebugLogger.h"
extern "C" {
#include "osd_cpu.h"
}
//= D E F I N E S ======================================================
#define DATA_PREFIX      "D"
#define CODE_PREFIX      "C"
#define BSS_PREFIX       "B"
#define CONST_PREFIX     "K"

//= G L O B A L = V A R S ==============================================
static std::map< std::string, std::string >  g_nameToSectionMap;

//= P R O T O T Y P E S ================================================
extern "C" static void RegisterDriverSectionNames( void );

//= F U N C T I O N S ==================================================
extern "C" {

//-------------------------------------------------------------
//	InitDriverSectionizer
//-------------------------------------------------------------
void InitDriverSectionizer( void )
{
  g_nameToSectionMap.clear();
  void *addr;
  addr = XLoadSection( "DRVSNIZE" );
  if( !addr )
  {
    UINT32 lastErr = GetLastError();
    PRINTMSG( T_ERROR, "XLoadSection failed! 0x%X\r\n", lastErr );
  }
  RegisterDriverSectionNames();
}


//-------------------------------------------------------------
//	TerminateDriverSectionizer
//-------------------------------------------------------------
void TerminateDriverSectionizer( void )
{
  g_nameToSectionMap.clear();
  XFreeSection( "DRVSNIZE" );
}

#pragma code_seg( "DRVCSNZE" )
#pragma data_seg( "DRVDSNZE" )
#pragma comment(linker, "/merge:DRVCSNZE=DRVSNIZE")
#pragma comment(linker, "/merge:DRVDSNZE=DRVSNIZE")

#ifdef _DEBUG
//-------------------------------------------------------------
//	CheckDriverSectionRAM
//-------------------------------------------------------------
void CheckDriverSectionRAM( void )
{
  DWORD total = 0;
  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.begin();
  for( ; i != g_nameToSectionMap.end(); ++i )
  {
    HANDLE h = XGetSectionHandle( (*i).second.c_str() );
    if( h != INVALID_HANDLE_VALUE )
    {
      UINT32 sz = XGetSectionSize( h );
      PRINTMSG( T_INFO, "Driver %s %lu", (*i).first.c_str(), sz );
      total += sz;
    }
    else
      PRINTMSG( T_ERROR, "Invalid section %s for file %s!", (*i).second.c_str(), (*i).first.c_str() );
  }
  PRINTMSG( T_INFO, "Total %lu bytes\n", total );
}
#endif


//-------------------------------------------------------------
//	RegisterSectionName
//-------------------------------------------------------------
static void RegisterSectionName( const char *DriverFileName, const char *sectionName )
{
    // Add the section name to the map
  g_nameToSectionMap[ DriverFileName ] = sectionName;
}


//-------------------------------------------------------------
//	LoadDriverSectionByName
//-------------------------------------------------------------
BOOL LoadDriverSectionByName( const char *DriverFileName )
{
  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.find( DriverFileName );
  if( i == g_nameToSectionMap.end() )
    return FALSE;
  void *addr;
  PRINTMSG( T_INFO, "Load section %s, ID %s\n", DriverFileName, (*i).second.c_str() );
  addr = XLoadSection( (*i).second.c_str() );
  if( !addr )
  {
    UINT32 lastErr = GetLastError();
    PRINTMSG( T_ERROR, "XLoadSection failed! 0x%X\r\n", lastErr );
    //osd_print_error( "Failed to load section %s!", (*i).second.c_str() );
    //return FALSE;
  }
  return TRUE;
}


//-------------------------------------------------------------
//	UnloadDriverSectionByName
//-------------------------------------------------------------
BOOL UnloadDriverSectionByName( const char *DriverFileName )
{
  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.find( DriverFileName );
  if( i == g_nameToSectionMap.end() )
    return FALSE;
  return XFreeSection( (*i).second.c_str() );
}


//-------------------------------------------------------------
//	LoadDriverSections
//-------------------------------------------------------------
BOOL LoadDriverSections( void )
{
  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.begin();
  for( ; i != g_nameToSectionMap.end(); ++i )
  {
    if( !XLoadSection( (*i).second.c_str() ) )
    {
      PRINTMSG( T_ERROR, "Failed to load section %s!", (*i).second.c_str() );
      //return FALSE;
    }
  }
  return TRUE;
}


//-------------------------------------------------------------
//	UnloadDriverSections
//-------------------------------------------------------------
BOOL UnloadDriverSections( void )
{
  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.begin();
  for( ; i != g_nameToSectionMap.end(); ++i )
  {
      // Only unload families once (all but the first member are skipped)
    if( (*i).first == "src\\drivers\\cps2.c" ||
        (*i).first == "src\\drivers\\namcona1.c" ||
        (*i).first == "src\\drivers\\namconb1.c" ||
        (*i).first == "src\\drivers\\namcond1.c" ||
        (*i).first == "src\\drivers\\namcos1.c" ||
        (*i).first == "src\\drivers\\namcos2.c" ||
        (*i).first == "src\\drivers\\namcos21.c" ||
        (*i).first == "src\\drivers\\namcos22.c" ||
        (*i).first == "src\\drivers\\namcos86.c" ||
        (*i).first == "src\\drivers\\namcos11.c" ||
        (*i).first == "src\\drivers\\system1.c" ||
        (*i).first == "src\\drivers\\system16.c" ||
        (*i).first == "src\\drivers\\system18.c" ||
        (*i).first == "src\\drivers\\system24.c" ||
        (*i).first == "src\\drivers\\system32.c" ||
        (*i).first == "src\\drivers\\aburner.c" ||
        (*i).first == "src\\drivers\\sharrier.c" ||
        (*i).first == "src\\drivers\\outrun.c" ||
        (*i).first == "src\\drivers\\segasyse.c" ||
        (*i).first == "src\\drivers\\segac2.c" ||
        (*i).first == "src\\drivers\\mcr2.c" ||
        (*i).first == "src\\drivers\\mcr3.c" ||
        (*i).first == "src\\drivers\\mcr68.c" ||
        (*i).first == "src\\drivers\\williams.c" ||
        (*i).first == "src\\drivers\\midyunit.c" ||
        (*i).first == "src\\drivers\\midtunit.c" ||
        (*i).first == "src\\drivers\\midwunit.c" ||
        (*i).first == "src\\drivers\\midvunit.c" ||
        (*i).first == "src\\drivers\\midxunit.c" ||
        (*i).first == "src\\drivers\\twincobr.c" ||
        (*i).first == "src\\drivers\\yard.c" ||
        (*i).first == "src\\drivers\\hal21.c" ||
        (*i).first == "src\\drivers\\marvins.c" ||
        (*i).first == "src\\drivers\\sgladiat.c" ||
        (*i).first == "src\\drivers\\scramble.c" ||
        (*i).first == "src\\drivers\\scobra.c" ||
        (*i).first == "src\\drivers\\amidar.c" ||
        (*i).first == "src\\drivers\\frogger.c" ||
        (*i).first == "src\\drivers\\pacman.c" ||
        (*i).first == "src\\drivers\\pengo.c" ||
        (*i).first == "src\\drivers\\cclimber.c" ||
        (*i).first == "src\\drivers\\dkong.c" ||
        (*i).first == "src\\drivers\\yamato.c" ||
        (*i).first == "src\\drivers\\phoenix.c" ||
        (*i).first == "src\\drivers\\epos.c" ||
        (*i).first == "src\\drivers\\arcadecl.c" ||
        (*i).first == "src\\drivers\\asuka.c" ||
        (*i).first == "src\\drivers\\opwolf.c" ||
        (*i).first == "src\\drivers\\rainbow.c" ||
        (*i).first == "src\\drivers\\topspeed.c" ||
        (*i).first == "src\\drivers\\marineb.c" ||
        (*i).first == "src\\drivers\\zodiack.c" ||
        (*i).first == "src\\drivers\\bwidow.c" ||
        (*i).first == "src\\drivers\\pkunwar.c" ||
        (*i).first == "src\\drivers\\exterm.c" ||
        (*i).first == "src\\drivers\\cischeat.c" ||
        (*i).first == "src\\drivers\\timeplt.c" ||
        (*i).first == "src\\drivers\\locomotn.c" ||
        (*i).first == "src\\drivers\\tutankhm.c" ||
        (*i).first == "src\\drivers\\pooyan.c" ||
        (*i).first == "src\\drivers\\rocnrope.c" ||
        (*i).first == "src\\drivers\\junofrst.c" ||
        (*i).first == "src\\drivers\\victory.c" ||
        (*i).first == "src\\drivers\\m90.c" ||
        (*i).first == "src\\drivers\\vigilant.c" ||
        (*i).first == "src\\drivers\\shisen.c" ||
        (*i).first == "src\\drivers\\ataxx.c" ||
        (*i).first == "src\\drivers\\hyperspt.c" ||
        (*i).first == "src\\drivers\\yiear.c" ||
        (*i).first == "src\\drivers\\sbasketb.c" ||
        (*i).first == "src\\drivers\\superchs.c" ||
        (*i).first == "src\\drivers\\groundfx.c" ||
        (*i).first == "src\\drivers\\gunbustr.c" ||
        (*i).first == "src\\drivers\\undrfire.c" ||
        (*i).first == "src\\drivers\\pipedrm.c" ||
        (*i).first == "src\\drivers\\mystwarr.c" ||
        (*i).first == "src\\drivers\\sega.c" ||
        (*i).first == "src\\drivers\\congo.c" ||
        (*i).first == "src\\drivers\\rollrace.c" ||
        (*i).first == "src\\drivers\\tetrisp2.c" ||
        (*i).first == "src\\drivers\\clshroad.c" ||
        (*i).first == "src\\drivers\\rotaryf.c" ||
        (*i).first == "src\\drivers\\circus.c" ||
        (*i).first == "src\\drivers\\40love.c" ||
        (*i).first == "src\\drivers\\scregg.c" ||
        (*i).first == "src\\drivers\\sslam.c" ||
        (*i).first == "src\\drivers\\spiders.c" ||
        (*i).first == "src\\drivers\\chinagat.c" ||
        (*i).first == "src\\drivers\\eprom.c" )
        continue;
    XFreeSection( (*i).second.c_str() );
  }
  return TRUE;
}


//-------------------------------------------------------------
//	RegisterDriverSectionNames
//-------------------------------------------------------------
static void RegisterDriverSectionNames( void )
{
  RegisterSectionName( "src\\drivers\\1942.c", "77" );
  RegisterSectionName( "src\\drivers\\1943.c", "78" );
  RegisterSectionName( "src\\drivers\\40love.c", "31" );
  RegisterSectionName( "src\\drivers\\4enraya.c", "80" );
  RegisterSectionName( "src\\drivers\\8080bw.c", "30" );
  RegisterSectionName( "src\\drivers\\88games.c", "82" );
  RegisterSectionName( "src\\drivers\\aburner.c", "3" );
  RegisterSectionName( "src\\drivers\\ace.c", "84" );
  RegisterSectionName( "src\\drivers\\actfancr.c", "85" );
  RegisterSectionName( "src\\drivers\\aeroboto.c", "86" );
  RegisterSectionName( "src\\drivers\\aerofgt.c", "87" );
  RegisterSectionName( "src\\drivers\\afega.c", "88" );
  RegisterSectionName( "src\\drivers\\airbustr.c", "89" );
  RegisterSectionName( "src\\drivers\\ajax.c", "90" );
  RegisterSectionName( "src\\drivers\\aliens.c", "91" );
  RegisterSectionName( "src\\drivers\\alpha68k.c", "92" );
  RegisterSectionName( "src\\drivers\\ambush.c", "93" );
  RegisterSectionName( "src\\drivers\\amidar.c", "8" );
  RegisterSectionName( "src\\drivers\\amspdwy.c", "95" );
  RegisterSectionName( "src\\drivers\\angelkds.c", "96" );
  RegisterSectionName( "src\\drivers\\appoooh.c", "97" );
  RegisterSectionName( "src\\drivers\\aquarium.c", "98" );
  RegisterSectionName( "src\\drivers\\arabian.c", "99" );
  RegisterSectionName( "src\\drivers\\arcadecl.c", "9" );
  RegisterSectionName( "src\\drivers\\argus.c", "101" );
  RegisterSectionName( "src\\drivers\\arkanoid.c", "102" );
  RegisterSectionName( "src\\drivers\\armedf.c", "103" );
  RegisterSectionName( "src\\drivers\\artmagic.c", "104" );
  RegisterSectionName( "src\\drivers\\asterix.c", "105" );
  RegisterSectionName( "src\\drivers\\asteroid.c", "106" );
  RegisterSectionName( "src\\drivers\\astinvad.c", "107" );
  RegisterSectionName( "src\\drivers\\astrocde.c", "108" );
  RegisterSectionName( "src\\drivers\\astrof.c", "109" );
  RegisterSectionName( "src\\drivers\\asuka.c", "10" );
  RegisterSectionName( "src\\drivers\\atarifb.c", "111" );
  RegisterSectionName( "src\\drivers\\atarig1.c", "112" );
  RegisterSectionName( "src\\drivers\\atarig42.c", "113" );
  RegisterSectionName( "src\\drivers\\atarigt.c", "114" );
  RegisterSectionName( "src\\drivers\\atarigx2.c", "115" );
  RegisterSectionName( "src\\drivers\\atarisy1.c", "116" );
  RegisterSectionName( "src\\drivers\\atarisy2.c", "117" );
  RegisterSectionName( "src\\drivers\\ataxx.c", "19" );
  RegisterSectionName( "src\\drivers\\atetris.c", "119" );
  RegisterSectionName( "src\\drivers\\avalnche.c", "120" );
  RegisterSectionName( "src\\drivers\\aztarac.c", "122" );
  RegisterSectionName( "src\\drivers\\badlands.c", "123" );
  RegisterSectionName( "src\\drivers\\bagman.c", "124" );
  RegisterSectionName( "src\\drivers\\balsente.c", "125" );
  RegisterSectionName( "src\\drivers\\bankp.c", "126" );
  RegisterSectionName( "src\\drivers\\baraduke.c", "127" );
  RegisterSectionName( "src\\drivers\\batman.c", "128" );
  RegisterSectionName( "src\\drivers\\battlane.c", "129" );
  RegisterSectionName( "src\\drivers\\battlera.c", "130" );
  RegisterSectionName( "src\\drivers\\battlex.c", "131" );
  RegisterSectionName( "src\\drivers\\battlnts.c", "132" );
  RegisterSectionName( "src\\drivers\\bbusters.c", "133" );
  RegisterSectionName( "src\\drivers\\beaminv.c", "134" );
  RegisterSectionName( "src\\drivers\\beathead.c", "135" );
  RegisterSectionName( "src\\drivers\\beezer.c", "136" );
  RegisterSectionName( "src\\drivers\\berzerk.c", "137" );
  RegisterSectionName( "src\\drivers\\bigevglf.c", "747" );
  RegisterSectionName( "src\\drivers\\bigstrkb.c", "138" );
  RegisterSectionName( "src\\drivers\\bionicc.c", "139" );
  RegisterSectionName( "src\\drivers\\bishi.c", "768" );
  RegisterSectionName( "src\\drivers\\bking2.c", "140" );
  RegisterSectionName( "src\\drivers\\bladestl.c", "141" );
  RegisterSectionName( "src\\drivers\\blktiger.c", "142" );
  RegisterSectionName( "src\\drivers\\blmbycar.c", "143" );
  RegisterSectionName( "src\\drivers\\blockade.c", "144" );
  RegisterSectionName( "src\\drivers\\blockhl.c", "145" );
  RegisterSectionName( "src\\drivers\\blockout.c", "146" );
  RegisterSectionName( "src\\drivers\\bloodbro.c", "147" );
  RegisterSectionName( "src\\drivers\\blstroid.c", "148" );
  RegisterSectionName( "src\\drivers\\blueprnt.c", "149" );
  RegisterSectionName( "src\\drivers\\bogeyman.c", "150" );
  RegisterSectionName( "src\\drivers\\bombjack.c", "151" );
  RegisterSectionName( "src\\drivers\\bosco.c", "152" );
  RegisterSectionName( "src\\drivers\\bottom9.c", "153" );
  RegisterSectionName( "src\\drivers\\boxer.c", "154" );
  RegisterSectionName( "src\\drivers\\brkthru.c", "155" );
  RegisterSectionName( "src\\drivers\\bsktball.c", "156" );
  RegisterSectionName( "src\\drivers\\btime.c", "32" );
  RegisterSectionName( "src\\drivers\\btoads.c", "158" );
  RegisterSectionName( "src\\drivers\\bublbobl.c", "159" );
  RegisterSectionName( "src\\drivers\\buggychl.c", "31" );
  RegisterSectionName( "src\\drivers\\bwidow.c", "12" );
  RegisterSectionName( "src\\drivers\\bwing.c", "162" );
  RegisterSectionName( "src\\drivers\\bzone.c", "12" );
  RegisterSectionName( "src\\drivers\\cabal.c", "164" );
  RegisterSectionName( "src\\drivers\\canyon.c", "165" );
  RegisterSectionName( "src\\drivers\\capbowl.c", "166" );
  RegisterSectionName( "src\\drivers\\carjmbre.c", "167" );
  RegisterSectionName( "src\\drivers\\carpolo.c", "168" );
  RegisterSectionName( "src\\drivers\\cave.c", "169" );
  RegisterSectionName( "src\\drivers\\cbasebal.c", "170" );
  RegisterSectionName( "src\\drivers\\cbuster.c", "171" );
  RegisterSectionName( "src\\drivers\\ccastles.c", "172" );
  RegisterSectionName( "src\\drivers\\cchasm.c", "173" );
  RegisterSectionName( "src\\drivers\\cclimber.c", "8" );
  RegisterSectionName( "src\\drivers\\centiped.c", "175" );
  RegisterSectionName( "src\\drivers\\chaknpop.c", "176" );
  RegisterSectionName( "src\\drivers\\champbas.c", "177" );
  RegisterSectionName( "src\\drivers\\cheekyms.c", "178" );
  RegisterSectionName( "src\\drivers\\chinagat.c", "35" );
  RegisterSectionName( "src\\drivers\\chindrag.c", "180" );
  RegisterSectionName( "src\\drivers\\chqflag.c", "181" );
  RegisterSectionName( "src\\drivers\\cinemat.c", "182" );
  RegisterSectionName( "src\\drivers\\circus.c", "30" );
  RegisterSectionName( "src\\drivers\\circusc.c", "184" );
  RegisterSectionName( "src\\drivers\\cischeat.c", "15" );
  RegisterSectionName( "src\\drivers\\citycon.c", "186" );
  RegisterSectionName( "src\\drivers\\clayshoo.c", "187" );
  RegisterSectionName( "src\\drivers\\cloak.c", "188" );
  RegisterSectionName( "src\\drivers\\cloud9.c", "189" );
  RegisterSectionName( "src\\drivers\\clshroad.c", "29" );
  RegisterSectionName( "src\\drivers\\cninja.c", "191" );
  RegisterSectionName( "src\\drivers\\cojag.c", "192" );
  RegisterSectionName( "src\\drivers\\combatsc.c", "193" );
  RegisterSectionName( "src\\drivers\\commando.c", "194" );
  RegisterSectionName( "src\\drivers\\compgolf.c", "769" );
  RegisterSectionName( "src\\drivers\\contra.c", "196" );
  RegisterSectionName( "src\\drivers\\coolpool.c", "197" );
  RegisterSectionName( "src\\drivers\\cop01.c", "198" );
  RegisterSectionName( "src\\drivers\\copsnrob.c", "199" );
  RegisterSectionName( "src\\drivers\\cosmic.c", "200" );
  RegisterSectionName( "src\\drivers\\cps1.c", "1" );
  RegisterSectionName( "src\\drivers\\cps2.c", "1" );
  RegisterSectionName( "src\\drivers\\crbaloon.c", "203" );
  RegisterSectionName( "src\\drivers\\crgolf.c", "204" );
  RegisterSectionName( "src\\drivers\\crimfght.c", "205" );
  RegisterSectionName( "src\\drivers\\crshrace.c", "206" );
  RegisterSectionName( "src\\drivers\\cshooter.c", "207" );
  RegisterSectionName( "src\\drivers\\cvs.c", "208" );
  RegisterSectionName( "src\\drivers\\cyberbal.c", "209" );
  RegisterSectionName( "src\\drivers\\darius.c", "210" );
  RegisterSectionName( "src\\drivers\\darkseal.c", "211" );
  RegisterSectionName( "src\\drivers\\dassault.c", "212" );
  RegisterSectionName( "src\\drivers\\dbz2.c", "213" );
  RegisterSectionName( "src\\drivers\\dcon.c", "214" );
  RegisterSectionName( "src\\drivers\\dday.c", "215" );
  RegisterSectionName( "src\\drivers\\ddenlovr.c", "216" );
  RegisterSectionName( "src\\drivers\\ddragon.c", "35" );
  RegisterSectionName( "src\\drivers\\ddragon3.c", "218" );
  RegisterSectionName( "src\\drivers\\ddrible.c", "219" );
  RegisterSectionName( "src\\drivers\\deadang.c", "220" );
  RegisterSectionName( "src\\drivers\\dec0.c", "221" );
  RegisterSectionName( "src\\drivers\\dec8.c", "222" );
  RegisterSectionName( "src\\drivers\\deco32.c", "223" );
  RegisterSectionName( "src\\drivers\\decocass.c", "224" );
  RegisterSectionName( "src\\drivers\\deniam.c", "225" );
  RegisterSectionName( "src\\drivers\\destroyr.c", "226" );
  RegisterSectionName( "src\\drivers\\digdug.c", "227" );
  RegisterSectionName( "src\\drivers\\diverboy.c", "228" );
  RegisterSectionName( "src\\drivers\\djboy.c", "229" );
  RegisterSectionName( "src\\drivers\\djmain.c", "770" );
  RegisterSectionName( "src\\drivers\\dkong.c", "8" );
  RegisterSectionName( "src\\drivers\\dlair.c", "231" );
  RegisterSectionName( "src\\drivers\\docastle.c", "232" );
  RegisterSectionName( "src\\drivers\\dogfgt.c", "233" );
  RegisterSectionName( "src\\drivers\\dooyong.c", "235" );
  RegisterSectionName( "src\\drivers\\dorachan.c", "771" );
  RegisterSectionName( "src\\drivers\\dotrikun.c", "236" );
  RegisterSectionName( "src\\drivers\\dragrace.c", "237" );
  RegisterSectionName( "src\\drivers\\drgnmst.c", "238" );
  RegisterSectionName( "src\\drivers\\dribling.c", "239" );
  RegisterSectionName( "src\\drivers\\drmicro.c", "240" );
  RegisterSectionName( "src\\drivers\\dynax.c", "241" );
  RegisterSectionName( "src\\drivers\\dynduke.c", "242" );
  RegisterSectionName( "src\\drivers\\embargo.c", "772" );
  RegisterSectionName( "src\\drivers\\enigma2.c", "243" );
  RegisterSectionName( "src\\drivers\\epos.c", "8" );
  RegisterSectionName( "src\\drivers\\eprom.c", "36" );
  RegisterSectionName( "src\\drivers\\equites.c", "246" );
  RegisterSectionName( "src\\drivers\\esd16.c", "247" );
  RegisterSectionName( "src\\drivers\\espial.c", "11" );
  RegisterSectionName( "src\\drivers\\exctsccr.c", "249" );
  RegisterSectionName( "src\\drivers\\exedexes.c", "250" );
  RegisterSectionName( "src\\drivers\\exerion.c", "251" );
  RegisterSectionName( "src\\drivers\\exidy.c", "17" );
  RegisterSectionName( "src\\drivers\\exidy440.c", "253" );
  RegisterSectionName( "src\\drivers\\exprraid.c", "254" );
  RegisterSectionName( "src\\drivers\\exterm.c", "14" );
  RegisterSectionName( "src\\drivers\\exzisus.c", "256" );
  RegisterSectionName( "src\\drivers\\f1gp.c", "257" );
  RegisterSectionName( "src\\drivers\\fantland.c", "258" );
  RegisterSectionName( "src\\drivers\\fastfred.c", "259" );
  RegisterSectionName( "src\\drivers\\fastlane.c", "260" );
  RegisterSectionName( "src\\drivers\\fcombat.c", "261" );
  RegisterSectionName( "src\\drivers\\finalizr.c", "262" );
  RegisterSectionName( "src\\drivers\\findout.c", "263" );
  RegisterSectionName( "src\\drivers\\firetrap.c", "264" );
  RegisterSectionName( "src\\drivers\\firetrk.c", "265" );
  RegisterSectionName( "src\\drivers\\fitfight.c", "266" );
  RegisterSectionName( "src\\drivers\\flkatck.c", "267" );
  RegisterSectionName( "src\\drivers\\flower.c", "268" );
  RegisterSectionName( "src\\drivers\\flstory.c", "269" );
  RegisterSectionName( "src\\drivers\\flyball.c", "270" );
  RegisterSectionName( "src\\drivers\\foodf.c", "271" );
  RegisterSectionName( "src\\drivers\\freekick.c", "272" );
  RegisterSectionName( "src\\drivers\\frogger.c", "8" );
  RegisterSectionName( "src\\drivers\\fromanc2.c", "274" );
  RegisterSectionName( "src\\drivers\\fromance.c", "22" );
  RegisterSectionName( "src\\drivers\\funkybee.c", "276" );
  RegisterSectionName( "src\\drivers\\funkyjet.c", "277" );
  RegisterSectionName( "src\\drivers\\fuukifg2.c", "758" );
  RegisterSectionName( "src\\drivers\\fuukifg3.c", "759" );
  RegisterSectionName( "src\\drivers\\gaelco.c", "279" );
  RegisterSectionName( "src\\drivers\\gaelco2.c", "280" );
  RegisterSectionName( "src\\drivers\\gaiden.c", "281" );
  RegisterSectionName( "src\\drivers\\galaga.c", "282" );
  RegisterSectionName( "src\\drivers\\galaxian.c", "8" );
  RegisterSectionName( "src\\drivers\\galivan.c", "284" );
  RegisterSectionName( "src\\drivers\\galpani2.c", "285" );
  RegisterSectionName( "src\\drivers\\galpanic.c", "286" );
  RegisterSectionName( "src\\drivers\\galspnbl.c", "287" );
  RegisterSectionName( "src\\drivers\\gameplan.c", "288" );
  RegisterSectionName( "src\\drivers\\gaplus.c", "289" );
  RegisterSectionName( "src\\drivers\\gauntlet.c", "290" );
  RegisterSectionName( "src\\drivers\\gberet.c", "291" );
  RegisterSectionName( "src\\drivers\\gbusters.c", "292" );
  RegisterSectionName( "src\\drivers\\gcpinbal.c", "293" );
  RegisterSectionName( "src\\drivers\\gijoe.c", "295" );
  RegisterSectionName( "src\\drivers\\ginganin.c", "296" );
  RegisterSectionName( "src\\drivers\\gladiatr.c", "297" );
  RegisterSectionName( "src\\drivers\\glass.c", "298" );
  RegisterSectionName( "src\\drivers\\gng.c", "299" );
  RegisterSectionName( "src\\drivers\\goindol.c", "300" );
  RegisterSectionName( "src\\drivers\\gomoku.c", "301" );
  RegisterSectionName( "src\\drivers\\gotcha.c", "302" );
  RegisterSectionName( "src\\drivers\\gottlieb.c", "14" );
  RegisterSectionName( "src\\drivers\\gotya.c", "304" );
  RegisterSectionName( "src\\drivers\\gradius3.c", "305" );
  RegisterSectionName( "src\\drivers\\grchamp.c", "306" );
  RegisterSectionName( "src\\drivers\\gridlee.c", "307" );
  RegisterSectionName( "src\\drivers\\groundfx.c", "21" );
  RegisterSectionName( "src\\drivers\\grtwall.c", "310" );
  RegisterSectionName( "src\\drivers\\gstriker.c", "311" );
  RegisterSectionName( "src\\drivers\\gsword.c", "312" );
  RegisterSectionName( "src\\drivers\\gumbo.c", "313" );
  RegisterSectionName( "src\\drivers\\gunbustr.c", "21" );
  RegisterSectionName( "src\\drivers\\gundealr.c", "315" );
  RegisterSectionName( "src\\drivers\\gunsmoke.c", "316" );
  RegisterSectionName( "src\\drivers\\gyruss.c", "317" );
  RegisterSectionName( "src\\drivers\\hal21.c", "7" );
  RegisterSectionName( "src\\drivers\\halleys.c", "319" );
  RegisterSectionName( "src\\drivers\\hanaawas.c", "320" );
  RegisterSectionName( "src\\drivers\\hanaroku.c", "321" );
  RegisterSectionName( "src\\drivers\\harddriv.c", "322" );
  RegisterSectionName( "src\\drivers\\hcastle.c", "323" );
  RegisterSectionName( "src\\drivers\\hexa.c", "324" );
  RegisterSectionName( "src\\drivers\\hexion.c", "325" );
  RegisterSectionName( "src\\drivers\\higemaru.c", "326" );
  RegisterSectionName( "src\\drivers\\hitme.c", "327" );
  RegisterSectionName( "src\\drivers\\hnayayoi.c", "328" );
  RegisterSectionName( "src\\drivers\\holeland.c", "329" );
  RegisterSectionName( "src\\drivers\\homedata.c", "330" );
  RegisterSectionName( "src\\drivers\\homerun.c", "773" );
  RegisterSectionName( "src\\drivers\\hyhoo.c", "331" );
  RegisterSectionName( "src\\drivers\\hyperspt.c", "20" );
  RegisterSectionName( "src\\drivers\\hyprduel.c", "333" );
  RegisterSectionName( "src\\drivers\\ikki.c", "334" );
  RegisterSectionName( "src\\drivers\\inufuku.c", "767" );
  RegisterSectionName( "src\\drivers\\iqblock.c", "335" );
  RegisterSectionName( "src\\drivers\\irobot.c", "336" );
  RegisterSectionName( "src\\drivers\\ironhors.c", "337" );
  RegisterSectionName( "src\\drivers\\itech32.c", "338" );
  RegisterSectionName( "src\\drivers\\itech8.c", "339" );
  RegisterSectionName( "src\\drivers\\jack.c", "340" );
  RegisterSectionName( "src\\drivers\\jackal.c", "341" );
  RegisterSectionName( "src\\drivers\\jailbrek.c", "342" );
  RegisterSectionName( "src\\drivers\\jalmah.c", "343" );
  RegisterSectionName( "src\\drivers\\jcross.c", "774" );
  RegisterSectionName( "src\\drivers\\jedi.c", "344" );
  RegisterSectionName( "src\\drivers\\jrpacman.c", "345" );
  RegisterSectionName( "src\\drivers\\junofrst.c", "16" );
  RegisterSectionName( "src\\drivers\\kaneko16.c", "347" );
  RegisterSectionName( "src\\drivers\\kangaroo.c", "348" );
  RegisterSectionName( "src\\drivers\\karnov.c", "349" );
  RegisterSectionName( "src\\drivers\\kchamp.c", "350" );
  RegisterSectionName( "src\\drivers\\kickgoal.c", "351" );
  RegisterSectionName( "src\\drivers\\kingobox.c", "352" );
  RegisterSectionName( "src\\drivers\\kinst.c", "353" );
  RegisterSectionName( "src\\drivers\\klax.c", "354" );
  RegisterSectionName( "src\\drivers\\kncljoe.c", "355" );
  RegisterSectionName( "src\\drivers\\konamigx.c", "24" );
  RegisterSectionName( "src\\drivers\\kopunch.c", "357" );
  RegisterSectionName( "src\\drivers\\kyugo.c", "358" );
  RegisterSectionName( "src\\drivers\\labyrunr.c", "359" );
  RegisterSectionName( "src\\drivers\\ladybug.c", "360" );
  RegisterSectionName( "src\\drivers\\ladyfrog.c", "775" );
  RegisterSectionName( "src\\drivers\\lasso.c", "361" );
  RegisterSectionName( "src\\drivers\\lastduel.c", "362" );
  RegisterSectionName( "src\\drivers\\lazercmd.c", "363" );
  RegisterSectionName( "src\\drivers\\legionna.c", "364" );
  RegisterSectionName( "src\\drivers\\leland.c", "19" );
  RegisterSectionName( "src\\drivers\\lemmings.c", "366" );
  RegisterSectionName( "src\\drivers\\leprechn.c", "367" );
  RegisterSectionName( "src\\drivers\\lethalj.c", "368" );
  RegisterSectionName( "src\\drivers\\liberate.c", "369" );
  RegisterSectionName( "src\\drivers\\liberatr.c", "370" );
  RegisterSectionName( "src\\drivers\\lkage.c", "371" );
  RegisterSectionName( "src\\drivers\\locomotn.c", "16" );
  RegisterSectionName( "src\\drivers\\looping.c", "373" );
  RegisterSectionName( "src\\drivers\\lsasquad.c", "374" );
  RegisterSectionName( "src\\drivers\\ltcasino.c", "748" );
  RegisterSectionName( "src\\drivers\\lwings.c", "375" );
  RegisterSectionName( "src\\drivers\\m107.c", "376" );
  RegisterSectionName( "src\\drivers\\m62.c", "377" );
  RegisterSectionName( "src\\drivers\\m72.c", "18" );
  RegisterSectionName( "src\\drivers\\m79amb.c", "379" );
  RegisterSectionName( "src\\drivers\\m90.c", "18" );
  RegisterSectionName( "src\\drivers\\m92.c", "381" );
  RegisterSectionName( "src\\drivers\\macrossp.c", "382" );
  RegisterSectionName( "src\\drivers\\madmotor.c", "383" );
  RegisterSectionName( "src\\drivers\\magmax.c", "384" );
  RegisterSectionName( "src\\drivers\\mainevt.c", "385" );
  RegisterSectionName( "src\\drivers\\mainsnk.c", "386" );
  RegisterSectionName( "src\\drivers\\mappy.c", "387" );
  RegisterSectionName( "src\\drivers\\marineb.c", "11" );
  RegisterSectionName( "src\\drivers\\marinedt.c", "776" );
  RegisterSectionName( "src\\drivers\\mario.c", "389" );
  RegisterSectionName( "src\\drivers\\markham.c", "390" );
  RegisterSectionName( "src\\drivers\\marvins.c", "7" );
  RegisterSectionName( "src\\drivers\\matmania.c", "392" );
  RegisterSectionName( "src\\drivers\\mayumi.c", "393" );
  RegisterSectionName( "src\\drivers\\mazerbla.c", "749" );
  RegisterSectionName( "src\\drivers\\mcatadv.c", "394" );
  RegisterSectionName( "src\\drivers\\mcr1.c", "4" );
  RegisterSectionName( "src\\drivers\\mcr2.c", "4" );
  RegisterSectionName( "src\\drivers\\mcr3.c", "4" );
  RegisterSectionName( "src\\drivers\\mcr68.c", "4" );
  RegisterSectionName( "src\\drivers\\meadows.c", "399" );
  RegisterSectionName( "src\\drivers\\megasys1.c", "15" );
  RegisterSectionName( "src\\drivers\\megazone.c", "401" );
  RegisterSectionName( "src\\drivers\\mermaid.c", "402" );
  RegisterSectionName( "src\\drivers\\metlclsh.c", "403" );
  RegisterSectionName( "src\\drivers\\metro.c", "404" );
  RegisterSectionName( "src\\drivers\\mexico86.c", "405" );
  RegisterSectionName( "src\\drivers\\mhavoc.c", "406" );
  RegisterSectionName( "src\\drivers\\midtunit.c", "4" );
  RegisterSectionName( "src\\drivers\\midvunit.c", "4" );
  RegisterSectionName( "src\\drivers\\midwunit.c", "4" );
  RegisterSectionName( "src\\drivers\\midxunit.c", "4" );
  RegisterSectionName( "src\\drivers\\midyunit.c", "4" );
  RegisterSectionName( "src\\drivers\\mikie.c", "412" );
  RegisterSectionName( "src\\drivers\\minivadr.c", "413" );
  RegisterSectionName( "src\\drivers\\missb2.c", "414" );
  RegisterSectionName( "src\\drivers\\missile.c", "415" );
  RegisterSectionName( "src\\drivers\\mitchell.c", "416" );
  RegisterSectionName( "src\\drivers\\mjkjidai.c", "417" );
  RegisterSectionName( "src\\drivers\\mjsister.c", "418" );
  RegisterSectionName( "src\\drivers\\mnight.c", "419" );
  RegisterSectionName( "src\\drivers\\mogura.c", "760" );
  RegisterSectionName( "src\\drivers\\mole.c", "420" );
  RegisterSectionName( "src\\drivers\\momoko.c", "421" );
  RegisterSectionName( "src\\drivers\\monaco.c", "765" );
  RegisterSectionName( "src\\drivers\\moo.c", "422" );
  RegisterSectionName( "src\\drivers\\mosaic.c", "423" );
  RegisterSectionName( "src\\drivers\\mouser.c", "424" );
  RegisterSectionName( "src\\drivers\\mpatrol.c", "6" );
  RegisterSectionName( "src\\drivers\\mrdo.c", "426" );
  RegisterSectionName( "src\\drivers\\mrflea.c", "427" );
  RegisterSectionName( "src\\drivers\\mrjong.c", "428" );
  RegisterSectionName( "src\\drivers\\ms32.c", "28" );
  RegisterSectionName( "src\\drivers\\msisaac.c", "430" );
  RegisterSectionName( "src\\drivers\\mugsmash.c", "431" );
  RegisterSectionName( "src\\drivers\\multi32.c", "3" );
  RegisterSectionName( "src\\drivers\\munchmo.c", "433" );
  RegisterSectionName( "src\\drivers\\mustache.c", "434" );
  RegisterSectionName( "src\\drivers\\mystston.c", "435" );
  RegisterSectionName( "src\\drivers\\mystwarr.c", "24" );
  RegisterSectionName( "src\\drivers\\namcoic.c", "2" );
  RegisterSectionName( "src\\drivers\\namcona1.c", "2" );
  RegisterSectionName( "src\\drivers\\namconb1.c", "2" );
  RegisterSectionName( "src\\drivers\\namcond1.c", "2" );
  RegisterSectionName( "src\\drivers\\namcos1.c", "2" );
  RegisterSectionName( "src\\drivers\\namcos11.c", "2" );
  RegisterSectionName( "src\\drivers\\namcos2.c", "2" );
  RegisterSectionName( "src\\drivers\\namcos21.c", "2" );
  RegisterSectionName( "src\\drivers\\namcos22.c", "2" );
  RegisterSectionName( "src\\drivers\\namcos86.c", "2" );
  RegisterSectionName( "src\\drivers\\naughtyb.c", "447" );
  RegisterSectionName( "src\\drivers\\nbmj8688.c", "448" );
  RegisterSectionName( "src\\drivers\\nbmj8891.c", "449" );
  RegisterSectionName( "src\\drivers\\nbmj8991.c", "450" );
  RegisterSectionName( "src\\drivers\\nbmj9195.c", "451" );
  RegisterSectionName( "src\\drivers\\nemesis.c", "452" );
  RegisterSectionName( "src\\drivers\\neogeo.c", "453" );
  RegisterSectionName( "src\\drivers\\news.c", "454" );
  RegisterSectionName( "src\\drivers\\ninjakd2.c", "455" );
  RegisterSectionName( "src\\drivers\\ninjakid.c", "456" );
  RegisterSectionName( "src\\drivers\\ninjaw.c", "457" );
  RegisterSectionName( "src\\drivers\\nitedrvr.c", "458" );
  RegisterSectionName( "src\\drivers\\niyanpai.c", "459" );
  RegisterSectionName( "src\\drivers\\nmk16.c", "460" );
  RegisterSectionName( "src\\drivers\\nova2001.c", "13" );
  RegisterSectionName( "src\\drivers\\nss.c", "750" );
  RegisterSectionName( "src\\drivers\\nycaptor.c", "462" );
  RegisterSectionName( "src\\drivers\\nyny.c", "34" );
  RegisterSectionName( "src\\drivers\\offtwall.c", "464" );
  RegisterSectionName( "src\\drivers\\ohmygod.c", "465" );
  RegisterSectionName( "src\\drivers\\ojankohs.c", "466" );
  RegisterSectionName( "src\\drivers\\olibochu.c", "467" );
  RegisterSectionName( "src\\drivers\\omegaf.c", "468" );
  RegisterSectionName( "src\\drivers\\omegrace.c", "469" );
  RegisterSectionName( "src\\drivers\\oneshot.c", "470" );
  RegisterSectionName( "src\\drivers\\opwolf.c", "10" );
  RegisterSectionName( "src\\drivers\\orbit.c", "472" );
  RegisterSectionName( "src\\drivers\\othldrby.c", "473" );
  RegisterSectionName( "src\\drivers\\othunder.c", "474" );
  RegisterSectionName( "src\\drivers\\outrun.c", "3" );
  RegisterSectionName( "src\\drivers\\overdriv.c", "476" );
  RegisterSectionName( "src\\drivers\\pacland.c", "477" );
  RegisterSectionName( "src\\drivers\\pacman.c", "8" );
  RegisterSectionName( "src\\drivers\\pandoras.c", "479" );
  RegisterSectionName( "src\\drivers\\paradise.c", "480" );
  RegisterSectionName( "src\\drivers\\parodius.c", "481" );
  RegisterSectionName( "src\\drivers\\pass.c", "482" );
  RegisterSectionName( "src\\drivers\\pastelgl.c", "483" );
  RegisterSectionName( "src\\drivers\\pbaction.c", "484" );
  RegisterSectionName( "src\\drivers\\pbillian.c", "485" );
  RegisterSectionName( "src\\drivers\\pcktgal.c", "486" );
  RegisterSectionName( "src\\drivers\\pengo.c", "8" );
  RegisterSectionName( "src\\drivers\\pgm.c", "488" );
  RegisterSectionName( "src\\drivers\\phoenix.c", "8" );
  RegisterSectionName( "src\\drivers\\pingpong.c", "491" );
  RegisterSectionName( "src\\drivers\\pipedrm.c", "22" );
  RegisterSectionName( "src\\drivers\\pirates.c", "493" );
  RegisterSectionName( "src\\drivers\\pitnrun.c", "751" );
  RegisterSectionName( "src\\drivers\\pkunwar.c", "13" );
  RegisterSectionName( "src\\drivers\\playch10.c", "495" );
  RegisterSectionName( "src\\drivers\\playmark.c", "33" );
  RegisterSectionName( "src\\drivers\\plygonet.c", "497" );
  RegisterSectionName( "src\\drivers\\polepos.c", "498" );
  RegisterSectionName( "src\\drivers\\policetr.c", "499" );
  RegisterSectionName( "src\\drivers\\polyplay.c", "500" );
  RegisterSectionName( "src\\drivers\\pong.c", "766" );
  RegisterSectionName( "src\\drivers\\poolshrk.c", "501" );
  RegisterSectionName( "src\\drivers\\pooyan.c", "16" );
  RegisterSectionName( "src\\drivers\\popeye.c", "503" );
  RegisterSectionName( "src\\drivers\\popper.c", "504" );
  RegisterSectionName( "src\\drivers\\portrait.c", "505" );
  RegisterSectionName( "src\\drivers\\powerins.c", "506" );
  RegisterSectionName( "src\\drivers\\prehisle.c", "507" );
  RegisterSectionName( "src\\drivers\\psikyo.c", "508" );
  RegisterSectionName( "src\\drivers\\psikyo4.c", "509" );
  RegisterSectionName( "src\\drivers\\psikyosh.c", "510" );
  RegisterSectionName( "src\\drivers\\psychic5.c", "511" );
  RegisterSectionName( "src\\drivers\\punchout.c", "512" );
  RegisterSectionName( "src\\drivers\\pushman.c", "513" );
  RegisterSectionName( "src\\drivers\\qix.c", "514" );
  RegisterSectionName( "src\\drivers\\quantum.c", "515" );
  RegisterSectionName( "src\\drivers\\quizdna.c", "516" );
  RegisterSectionName( "src\\drivers\\r2dtank.c", "517" );
  RegisterSectionName( "src\\drivers\\raiden.c", "518" );
  RegisterSectionName( "src\\drivers\\raiden2.c", "519" );
  RegisterSectionName( "src\\drivers\\raiders5.c", "520" );
  RegisterSectionName( "src\\drivers\\rainbow.c", "10" );
  RegisterSectionName( "src\\drivers\\rallyx.c", "16" );
  RegisterSectionName( "src\\drivers\\rampart.c", "9" );
  RegisterSectionName( "src\\drivers\\rastan.c", "10" );
  RegisterSectionName( "src\\drivers\\realbrk.c", "525" );
  RegisterSectionName( "src\\drivers\\redalert.c", "526" );
  RegisterSectionName( "src\\drivers\\redclash.c", "527" );
  RegisterSectionName( "src\\drivers\\relief.c", "528" );
  RegisterSectionName( "src\\drivers\\renegade.c", "529" );
  RegisterSectionName( "src\\drivers\\retofinv.c", "530" );
  RegisterSectionName( "src\\drivers\\rmhaihai.c", "531" );
  RegisterSectionName( "src\\drivers\\rockola.c", "532" );
  RegisterSectionName( "src\\drivers\\rockrage.c", "533" );
  RegisterSectionName( "src\\drivers\\rocnrope.c", "16" );
  RegisterSectionName( "src\\drivers\\rohga.c", "535" );
  RegisterSectionName( "src\\drivers\\rollerg.c", "536" );
  RegisterSectionName( "src\\drivers\\rollrace.c", "27" );
  RegisterSectionName( "src\\drivers\\rotaryf.c", "30" );
  RegisterSectionName( "src\\drivers\\route16.c", "539" );
  RegisterSectionName( "src\\drivers\\royalmah.c", "540" );
  RegisterSectionName( "src\\drivers\\rpunch.c", "541" );
  RegisterSectionName( "src\\drivers\\rungun.c", "542" );
  RegisterSectionName( "src\\drivers\\safarir.c", "543" );
  RegisterSectionName( "src\\drivers\\sauro.c", "544" );
  RegisterSectionName( "src\\drivers\\sbasketb.c", "20" );
  RegisterSectionName( "src\\drivers\\sbowling.c", "752" );
  RegisterSectionName( "src\\drivers\\sbrkout.c", "546" );
  RegisterSectionName( "src\\drivers\\sbugger.c", "547" );
  RegisterSectionName( "src\\drivers\\scobra.c", "8" );
  RegisterSectionName( "src\\drivers\\scramble.c", "8" );
  RegisterSectionName( "src\\drivers\\scregg.c", "32" );
  RegisterSectionName( "src\\drivers\\sega.c", "25" );
  RegisterSectionName( "src\\drivers\\segac2.c", "3" );
  RegisterSectionName( "src\\drivers\\segar.c", "25" );
  RegisterSectionName( "src\\drivers\\segasyse.c", "3" );
  RegisterSectionName( "src\\drivers\\seicross.c", "555" );
  RegisterSectionName( "src\\drivers\\sengokmj.c", "753" );
  RegisterSectionName( "src\\drivers\\senjyo.c", "556" );
  RegisterSectionName( "src\\drivers\\seta.c", "557" );
  RegisterSectionName( "src\\drivers\\seta2.c", "558" );
  RegisterSectionName( "src\\drivers\\sf1.c", "559" );
  RegisterSectionName( "src\\drivers\\sg1000a.c", "560" );
  RegisterSectionName( "src\\drivers\\sgladiat.c", "7" );
  RegisterSectionName( "src\\drivers\\shadfrce.c", "562" );
  RegisterSectionName( "src\\drivers\\shangha3.c", "563" );
  RegisterSectionName( "src\\drivers\\shanghai.c", "564" );
  RegisterSectionName( "src\\drivers\\shangkid.c", "565" );
  RegisterSectionName( "src\\drivers\\shaolins.c", "566" );
  RegisterSectionName( "src\\drivers\\sharrier.c", "3" );
  RegisterSectionName( "src\\drivers\\shisen.c", "18" );
  RegisterSectionName( "src\\drivers\\shootout.c", "569" );
  RegisterSectionName( "src\\drivers\\shougi.c", "570" );
  RegisterSectionName( "src\\drivers\\shuuz.c", "571" );
  RegisterSectionName( "src\\drivers\\sidearms.c", "572" );
  RegisterSectionName( "src\\drivers\\sidepckt.c", "573" );
  RegisterSectionName( "src\\drivers\\silkroad.c", "574" );
  RegisterSectionName( "src\\drivers\\simpsons.c", "575" );
  RegisterSectionName( "src\\drivers\\skullxbo.c", "576" );
  RegisterSectionName( "src\\drivers\\skyarmy.c", "577" );
  RegisterSectionName( "src\\drivers\\skychut.c", "578" );
  RegisterSectionName( "src\\drivers\\skydiver.c", "579" );
  RegisterSectionName( "src\\drivers\\skyfox.c", "580" );
  RegisterSectionName( "src\\drivers\\skykid.c", "581" );
  RegisterSectionName( "src\\drivers\\skyraid.c", "582" );
  RegisterSectionName( "src\\drivers\\slapfght.c", "583" );
  RegisterSectionName( "src\\drivers\\slapshot.c", "584" );
  RegisterSectionName( "src\\drivers\\snk.c", "7" );
  RegisterSectionName( "src\\drivers\\snk68.c", "586" );
  RegisterSectionName( "src\\drivers\\snowbros.c", "587" );
  RegisterSectionName( "src\\drivers\\solomon.c", "588" );
  RegisterSectionName( "src\\drivers\\sonson.c", "589" );
  RegisterSectionName( "src\\drivers\\spacefb.c", "590" );
  RegisterSectionName( "src\\drivers\\spbactn.c", "591" );
  RegisterSectionName( "src\\drivers\\spcforce.c", "592" );
  RegisterSectionName( "src\\drivers\\spdbuggy.c", "593" );
  RegisterSectionName( "src\\drivers\\spdodgeb.c", "594" );
  RegisterSectionName( "src\\drivers\\speedatk.c", "761" );
  RegisterSectionName( "src\\drivers\\speedbal.c", "595" );
  RegisterSectionName( "src\\drivers\\speedspn.c", "596" );
  RegisterSectionName( "src\\drivers\\spiders.c", "34" );
  RegisterSectionName( "src\\drivers\\splash.c", "598" );
  RegisterSectionName( "src\\drivers\\sprcros2.c", "599" );
  RegisterSectionName( "src\\drivers\\sprint2.c", "600" );
  RegisterSectionName( "src\\drivers\\sprint4.c", "754" );
  RegisterSectionName( "src\\drivers\\sprint8.c", "762" );
  RegisterSectionName( "src\\drivers\\spy.c", "601" );
  RegisterSectionName( "src\\drivers\\srmp2.c", "602" );
  RegisterSectionName( "src\\drivers\\srumbler.c", "603" );
  RegisterSectionName( "src\\drivers\\sshangha.c", "604" );
  RegisterSectionName( "src\\drivers\\sslam.c", "33" );
  RegisterSectionName( "src\\drivers\\ssozumo.c", "606" );
  RegisterSectionName( "src\\drivers\\ssrj.c", "755" );
  RegisterSectionName( "src\\drivers\\ssv.c", "607" );
  RegisterSectionName( "src\\drivers\\stactics.c", "608" );
  RegisterSectionName( "src\\drivers\\stadhero.c", "609" );
  RegisterSectionName( "src\\drivers\\starcrus.c", "610" );
  RegisterSectionName( "src\\drivers\\starfire.c", "611" );
  RegisterSectionName( "src\\drivers\\starshp1.c", "612" );
  RegisterSectionName( "src\\drivers\\starwars.c", "613" );
  RegisterSectionName( "src\\drivers\\statriv2.c", "614" );
  RegisterSectionName( "src\\drivers\\stfight.c", "615" );
  RegisterSectionName( "src\\drivers\\stlforce.c", "616" );
  RegisterSectionName( "src\\drivers\\strnskil.c", "617" );
  RegisterSectionName( "src\\drivers\\strvmstr.c", "763" );
  RegisterSectionName( "src\\drivers\\stv.c", "618" );
  RegisterSectionName( "src\\drivers\\subs.c", "619" );
  RegisterSectionName( "src\\drivers\\suna16.c", "620" );
  RegisterSectionName( "src\\drivers\\suna8.c", "621" );
  RegisterSectionName( "src\\drivers\\supbtime.c", "622" );
  RegisterSectionName( "src\\drivers\\supdrapo.c", "756" );
  RegisterSectionName( "src\\drivers\\superchs.c", "21" );
  RegisterSectionName( "src\\drivers\\superqix.c", "625" );
  RegisterSectionName( "src\\drivers\\suprloco.c", "626" );
  RegisterSectionName( "src\\drivers\\suprnova.c", "627" );
  RegisterSectionName( "src\\drivers\\suprslam.c", "628" );
  RegisterSectionName( "src\\drivers\\surpratk.c", "629" );
  RegisterSectionName( "src\\drivers\\system1.c", "3" );
  RegisterSectionName( "src\\drivers\\system16.c", "3" );
  RegisterSectionName( "src\\drivers\\system18.c", "3" );
  RegisterSectionName( "src\\drivers\\system24.c", "3" );
  RegisterSectionName( "src\\drivers\\system32.c", "3" );
  RegisterSectionName( "src\\drivers\\tagteam.c", "635" );
  RegisterSectionName( "src\\drivers\\tail2nos.c", "636" );
  RegisterSectionName( "src\\drivers\\taito_b.c", "637" );
  RegisterSectionName( "src\\drivers\\taito_f2.c", "638" );
  RegisterSectionName( "src\\drivers\\taito_f3.c", "21" );
  RegisterSectionName( "src\\drivers\\taito_h.c", "640" );
  RegisterSectionName( "src\\drivers\\taito_l.c", "641" );
  RegisterSectionName( "src\\drivers\\taito_x.c", "642" );
  RegisterSectionName( "src\\drivers\\taito_z.c", "643" );
  RegisterSectionName( "src\\drivers\\taitoair.c", "644" );
  RegisterSectionName( "src\\drivers\\taitosj.c", "645" );
  RegisterSectionName( "src\\drivers\\tankbatt.c", "646" );
  RegisterSectionName( "src\\drivers\\tankbust.c", "647" );
  RegisterSectionName( "src\\drivers\\taotaido.c", "648" );
  RegisterSectionName( "src\\drivers\\targeth.c", "649" );
  RegisterSectionName( "src\\drivers\\taxidrvr.c", "650" );
  RegisterSectionName( "src\\drivers\\tbowl.c", "651" );
  RegisterSectionName( "src\\drivers\\tecmo.c", "652" );
  RegisterSectionName( "src\\drivers\\tecmo16.c", "653" );
  RegisterSectionName( "src\\drivers\\tecmosys.c", "654" );
  RegisterSectionName( "src\\drivers\\tehkanwc.c", "655" );
  RegisterSectionName( "src\\drivers\\tempest.c", "656" );
  RegisterSectionName( "src\\drivers\\terracre.c", "657" );
  RegisterSectionName( "src\\drivers\\tetrisp2.c", "28" );
  RegisterSectionName( "src\\drivers\\thedeep.c", "659" );
  RegisterSectionName( "src\\drivers\\thepit.c", "660" );
  RegisterSectionName( "src\\drivers\\thief.c", "661" );
  RegisterSectionName( "src\\drivers\\thoop2.c", "662" );
  RegisterSectionName( "src\\drivers\\thunderj.c", "36" );
  RegisterSectionName( "src\\drivers\\thunderx.c", "664" );
  RegisterSectionName( "src\\drivers\\tickee.c", "665" );
  RegisterSectionName( "src\\drivers\\tigeroad.c", "666" );
  RegisterSectionName( "src\\drivers\\timelimt.c", "667" );
  RegisterSectionName( "src\\drivers\\timeplt.c", "16" );
  RegisterSectionName( "src\\drivers\\tmnt.c", "669" );
  RegisterSectionName( "src\\drivers\\tnzs.c", "670" );
  RegisterSectionName( "src\\drivers\\toaplan1.c", "671" );
  RegisterSectionName( "src\\drivers\\toaplan2.c", "672" );
  RegisterSectionName( "src\\drivers\\toki.c", "673" );
  RegisterSectionName( "src\\drivers\\toobin.c", "674" );
  RegisterSectionName( "src\\drivers\\topspeed.c", "10" );
  RegisterSectionName( "src\\drivers\\toratora.c", "676" );
  RegisterSectionName( "src\\drivers\\tourtabl.c", "677" );
  RegisterSectionName( "src\\drivers\\toypop.c", "678" );
  RegisterSectionName( "src\\drivers\\tp84.c", "679" );
  RegisterSectionName( "src\\drivers\\trackfld.c", "20" );
  RegisterSectionName( "src\\drivers\\travrusa.c", "681" );
  RegisterSectionName( "src\\drivers\\triplhnt.c", "682" );
  RegisterSectionName( "src\\drivers\\troangel.c", "683" );
  RegisterSectionName( "src\\drivers\\truco.c", "684" );
  RegisterSectionName( "src\\drivers\\tryout.c", "777" );
  RegisterSectionName( "src\\drivers\\tsamurai.c", "685" );
  RegisterSectionName( "src\\drivers\\ttmahjng.c", "686" );
  RegisterSectionName( "src\\drivers\\tubep.c", "687" );
  RegisterSectionName( "src\\drivers\\tugboat.c", "688" );
  RegisterSectionName( "src\\drivers\\tumblep.c", "689" );
  RegisterSectionName( "src\\drivers\\tunhunt.c", "690" );
  RegisterSectionName( "src\\drivers\\turbo.c", "691" );
  RegisterSectionName( "src\\drivers\\tutankhm.c", "16" );
  RegisterSectionName( "src\\drivers\\twin16.c", "693" );
  RegisterSectionName( "src\\drivers\\twincobr.c", "5" );
  RegisterSectionName( "src\\drivers\\ultraman.c", "695" );
  RegisterSectionName( "src\\drivers\\ultratnk.c", "696" );
  RegisterSectionName( "src\\drivers\\undrfire.c", "21" );
  RegisterSectionName( "src\\drivers\\unico.c", "698" );
  RegisterSectionName( "src\\drivers\\usgames.c", "699" );
  RegisterSectionName( "src\\drivers\\vamphalf.c", "764" );
  RegisterSectionName( "src\\drivers\\vaportra.c", "700" );
  RegisterSectionName( "src\\drivers\\vastar.c", "701" );
  RegisterSectionName( "src\\drivers\\vball.c", "702" );
  RegisterSectionName( "src\\drivers\\vendetta.c", "703" );
  RegisterSectionName( "src\\drivers\\vicdual.c", "704" );
  RegisterSectionName( "src\\drivers\\victory.c", "17" );
  RegisterSectionName( "src\\drivers\\videopin.c", "706" );
  RegisterSectionName( "src\\drivers\\vigilant.c", "18" );
  RegisterSectionName( "src\\drivers\\vindictr.c", "708" );
  RegisterSectionName( "src\\drivers\\volfied.c", "709" );
  RegisterSectionName( "src\\drivers\\vsnes.c", "710" );
  RegisterSectionName( "src\\drivers\\vulgus.c", "711" );
  RegisterSectionName( "src\\drivers\\wallc.c", "712" );
  RegisterSectionName( "src\\drivers\\wardner.c", "5" );
  RegisterSectionName( "src\\drivers\\warpwarp.c", "714" );
  RegisterSectionName( "src\\drivers\\warriorb.c", "715" );
  RegisterSectionName( "src\\drivers\\wc90.c", "716" );
  RegisterSectionName( "src\\drivers\\wc90b.c", "717" );
  RegisterSectionName( "src\\drivers\\wecleman.c", "718" );
  RegisterSectionName( "src\\drivers\\welltris.c", "719" );
  RegisterSectionName( "src\\drivers\\wgp.c", "720" );
  RegisterSectionName( "src\\drivers\\williams.c", "4" );
  RegisterSectionName( "src\\drivers\\wilytowr.c", "722" );
  RegisterSectionName( "src\\drivers\\wiping.c", "29" );
  RegisterSectionName( "src\\drivers\\wiz.c", "27" );
  RegisterSectionName( "src\\drivers\\wolfpack.c", "725" );
  RegisterSectionName( "src\\drivers\\wrally.c", "726" );
  RegisterSectionName( "src\\drivers\\wwfsstar.c", "727" );
  RegisterSectionName( "src\\drivers\\wwfwfest.c", "728" );
  RegisterSectionName( "src\\drivers\\xain.c", "729" );
  RegisterSectionName( "src\\drivers\\xevious.c", "730" );
  RegisterSectionName( "src\\drivers\\xexex.c", "731" );
  RegisterSectionName( "src\\drivers\\xmen.c", "732" );
  RegisterSectionName( "src\\drivers\\xorworld.c", "757" );
  RegisterSectionName( "src\\drivers\\xxmissio.c", "733" );
  RegisterSectionName( "src\\drivers\\xybots.c", "734" );
  RegisterSectionName( "src\\drivers\\xyonix.c", "735" );
  RegisterSectionName( "src\\drivers\\yamato.c", "8" );
  RegisterSectionName( "src\\drivers\\yard.c", "6" );
  RegisterSectionName( "src\\drivers\\yiear.c", "20" );
  RegisterSectionName( "src\\drivers\\yumefuda.c", "778" );
  RegisterSectionName( "src\\drivers\\yunsun16.c", "739" );
  RegisterSectionName( "src\\drivers\\yunsung8.c", "740" );
  RegisterSectionName( "src\\drivers\\zac2650.c", "741" );
  RegisterSectionName( "src\\drivers\\zaccaria.c", "742" );
  RegisterSectionName( "src\\drivers\\zaxxon.c", "26" );
  RegisterSectionName( "src\\drivers\\zerozone.c", "744" );
  RegisterSectionName( "src\\drivers\\zn.c", "745" );
  RegisterSectionName( "src\\drivers\\zodiack.c", "11" );
  RegisterSectionName( "src\\drivers\\ashnojoe.c", "779" );
  RegisterSectionName( "src\\drivers\\crospang.c", "780" );
  RegisterSectionName( "src\\drivers\\deco_mlc.c", "781" );
  RegisterSectionName( "src\\drivers\\funybubl.c", "782" );
  RegisterSectionName( "src\\drivers\\goal92.c", "783" );
  RegisterSectionName( "src\\drivers\\jchan.c", "784" );
  RegisterSectionName( "src\\drivers\\konamigq.c", "785" );
  RegisterSectionName( "src\\drivers\\malzak.c", "786" );
  RegisterSectionName( "src\\drivers\\namcos10.c", "787" );
  RegisterSectionName( "src\\drivers\\namcos12.c", "788" );
  RegisterSectionName( "src\\drivers\\quizpani.c", "789" );
  RegisterSectionName( "src\\drivers\\rabbit.c", "790" );
  RegisterSectionName( "src\\drivers\\runaway.c", "791" );
  RegisterSectionName( "src\\drivers\\seattle.c", "792" );
  RegisterSectionName( "src\\drivers\\sspeedr.c", "793" );
  RegisterSectionName( "src\\drivers\\stvhacks.c", "794" );
  RegisterSectionName( "src\\drivers\\supertnk.c", "795" );
  RegisterSectionName( "src\\drivers\\tceptor.c", "796" );
  RegisterSectionName( "src\\drivers\\vmetal.c", "797" );
}
#pragma code_seg()
#pragma data_seg()
} // End extern "C"


