#pragma code_seg("C646")
#pragma data_seg("D646")
#pragma bss_seg("B646")
#pragma const_seg("K646")
#pragma comment(linker, "/merge:D646=646")
#pragma comment(linker, "/merge:C646=646")
#pragma comment(linker, "/merge:B646=646")
#pragma comment(linker, "/merge:K646=646")
/***************************************************************************

  vidhrdw.c

  Functions to emulate the video hardware of the machine.

***************************************************************************/

#include "driver.h"
#include "vidhrdw/generic.h"

UINT8 *tankbatt_bulletsram;
size_t tankbatt_bulletsram_size;

static struct tilemap *bg_tilemap;

/***************************************************************************

  Convert the color PROMs into a more useable format.

***************************************************************************/
PALETTE_INIT( tankbatt )
{
	int i;
	#define TOTAL_COLORS(gfxn) (Machine->gfx[gfxn]->total_colors * Machine->gfx[gfxn]->color_granularity)
	#define COLOR(gfxn,offs) (colortable[Machine->drv->gfxdecodeinfo[gfxn].color_codes_start + offs])

	#define RES_1	0xc0 /* this is a guess */
	#define RES_2	0x3f /* this is a guess */

	/* Stick black in there */
	palette_set_color(0,0,0,0);

	/* ? Skip the first byte ? */
	color_prom++;

	for (i = 1;i < Machine->drv->total_colors;i++)
	{
		int bit0, bit1, bit2, bit3, r, g, b;

		bit0 = (*color_prom >> 0) & 0x01; /* intensity */
		bit1 = (*color_prom >> 1) & 0x01; /* red */
		bit2 = (*color_prom >> 2) & 0x01; /* green */
		bit3 = (*color_prom >> 3) & 0x01; /* blue */

		/* red component */
		r = RES_1 * bit1;
		if (bit1) r += RES_2 * bit0;

		/* green component */
		g = RES_1 * bit2;
		if (bit2) g += RES_2 * bit0;

		/* blue component */
		b = RES_1 * bit3;
		if (bit3) b += RES_2 * bit0;

		palette_set_color(i,r,g,b);
		color_prom += 4;
	}

	for (i = 0;i < 128;i++)
	{
		colortable[i++] = 0;
		colortable[i] = (i/2) + 1;
	}
}

WRITE_HANDLER( tankbatt_videoram_w )
{
	if (videoram[offset] != data)
	{
		videoram[offset] = data;
		tilemap_mark_tile_dirty(bg_tilemap, offset);
	}
}

static void get_bg_tile_info(int tile_index)
{
	int code = videoram[tile_index];
	int color = videoram[tile_index] >> 2;

	SET_TILE_INFO(0, code, color, 0)
}

VIDEO_START( tankbatt )
{
	bg_tilemap = tilemap_create(get_bg_tile_info, tilemap_scan_rows,
		TILEMAP_OPAQUE, 8, 8, 32, 32);

	if ( !bg_tilemap )
		return 1;

	return 0;
}

static void tankbatt_draw_bullets( struct mame_bitmap *bitmap )
{
	int offs;

	for (offs = 0;offs < tankbatt_bulletsram_size;offs += 2)
	{
		int color = 63;	/* cyan, same color as the tanks */
		int x = tankbatt_bulletsram[offs + 1];
		int y = 255 - tankbatt_bulletsram[offs] - 2;

		drawgfx(bitmap,Machine->gfx[1],
			0,	/* this is just a square, generated by the hardware */
			color,
			0,0,
			x,y,
			&Machine->visible_area,TRANSPARENCY_NONE,0);
	}
}

VIDEO_UPDATE( tankbatt )
{
	tilemap_draw(bitmap, &Machine->visible_area, bg_tilemap, 0, 0);
	tankbatt_draw_bullets(bitmap);
}
#pragma code_seg()
#pragma data_seg()
#pragma bss_seg()
#pragma const_seg()
