/**
  * \file      DriverSections.cpp
  * \brief     Registration of driver files for creation and usage of XBOX
  *             loadable sections
  *
  * \note      This file is autogenerated via Sectionize.pl DO NOT EDIT!
  */

//= I N C L U D E S ====================================================
#include <Xtl.h>
#include <stdio.h>
#include <map>
#include <string>
#include "MAMEoX.h"
#include "DebugLogger.h"
extern "C" {
#include "osd_cpu.h"
}
//= D E F I N E S ======================================================
#define DATA_PREFIX      "D"
#define CODE_PREFIX      "C"
#define BSS_PREFIX       "B"
#define CONST_PREFIX     "K"

//= G L O B A L = V A R S ==============================================
static std::map< std::string, std::string >  g_nameToSectionMap;

//= P R O T O T Y P E S ================================================
extern "C" static void RegisterDriverSectionNames( void );

//= F U N C T I O N S ==================================================
extern "C" {

//-------------------------------------------------------------
//	InitDriverSectionizer
//-------------------------------------------------------------
void InitDriverSectionizer( void )
{
  g_nameToSectionMap.clear();
  void *addr;
  addr = XLoadSection( "DRVSNIZE" );
  if( !addr )
  {
    UINT32 lastErr = GetLastError();
    PRINTMSG( T_ERROR, "XLoadSection failed! 0x%X\r\n", lastErr );
  }
  RegisterDriverSectionNames();
}


//-------------------------------------------------------------
//	TerminateDriverSectionizer
//-------------------------------------------------------------
void TerminateDriverSectionizer( void )
{
  g_nameToSectionMap.clear();
  XFreeSection( "DRVSNIZE" );
}

#pragma code_seg( "DRVCSNZE" )
#pragma data_seg( "DRVDSNZE" )
#pragma comment(linker, "/merge:DRVCSNZE=DRVSNIZE")
#pragma comment(linker, "/merge:DRVDSNZE=DRVSNIZE")

#ifdef _DEBUG
//-------------------------------------------------------------
//	CheckDriverSectionRAM
//-------------------------------------------------------------
void CheckDriverSectionRAM( void )
{
  DWORD total = 0;
  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.begin();
  for( ; i != g_nameToSectionMap.end(); ++i )
  {
    HANDLE h = XGetSectionHandle( (*i).second.c_str() );
    if( h != INVALID_HANDLE_VALUE )
    {
      UINT32 sz = XGetSectionSize( h );
      PRINTMSG( T_INFO, "Driver %s %lu", (*i).first.c_str(), sz );
      total += sz;
    }
    else
      PRINTMSG( T_ERROR, "Invalid section %s for file %s!", (*i).second.c_str(), (*i).first.c_str() );
  }
  PRINTMSG( T_INFO, "Total %lu bytes\n", total );
}
#endif


//-------------------------------------------------------------
//	RegisterSectionName
//-------------------------------------------------------------
static void RegisterSectionName( const char *DriverFileName, const char *sectionName )
{
    // Add the section name to the map
  g_nameToSectionMap[ DriverFileName ] = sectionName;
}


//-------------------------------------------------------------
//	LoadDriverSectionByName
//-------------------------------------------------------------
BOOL LoadDriverSectionByName( const char *DriverFileName )
{
  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.find( DriverFileName );
  if( i == g_nameToSectionMap.end() )
    return FALSE;
  void *addr;
  PRINTMSG( T_INFO, "Load section %s, ID %s\n", DriverFileName, (*i).second.c_str() );
  addr = XLoadSection( (*i).second.c_str() );
  if( !addr )
  {
    UINT32 lastErr = GetLastError();
    PRINTMSG( T_ERROR, "XLoadSection failed! 0x%X\r\n", lastErr );
    //osd_print_error( "Failed to load section %s!", (*i).second.c_str() );
    //return FALSE;
  }
  return TRUE;
}


//-------------------------------------------------------------
//	UnloadDriverSectionByName
//-------------------------------------------------------------
BOOL UnloadDriverSectionByName( const char *DriverFileName )
{
  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.find( DriverFileName );
  if( i == g_nameToSectionMap.end() )
    return FALSE;
  return XFreeSection( (*i).second.c_str() );
}


//-------------------------------------------------------------
//	LoadDriverSections
//-------------------------------------------------------------
BOOL LoadDriverSections( void )
{
  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.begin();
  for( ; i != g_nameToSectionMap.end(); ++i )
  {
    if( !XLoadSection( (*i).second.c_str() ) )
    {
      PRINTMSG( T_ERROR, "Failed to load section %s!", (*i).second.c_str() );
      //return FALSE;
    }
  }
  return TRUE;
}


//-------------------------------------------------------------
//	UnloadDriverSections
//-------------------------------------------------------------
BOOL UnloadDriverSections( void )
{
  std::map< std::string, std::string >::iterator i = g_nameToSectionMap.begin();
  for( ; i != g_nameToSectionMap.end(); ++i )
  {
      // Only unload families once (all but the first member are skipped)
    if( (*i).first == "src\\drivers\\cps2.c" ||
        (*i).first == "src\\drivers\\namcona1.c" ||
        (*i).first == "src\\drivers\\namconb1.c" ||
        (*i).first == "src\\drivers\\namcond1.c" ||
        (*i).first == "src\\drivers\\namcos1.c" ||
        (*i).first == "src\\drivers\\namcos2.c" ||
        (*i).first == "src\\drivers\\namcos21.c" ||
        (*i).first == "src\\drivers\\namcos22.c" ||
        (*i).first == "src\\drivers\\namcos86.c" ||
        (*i).first == "src\\drivers\\system1.c" ||
        (*i).first == "src\\drivers\\system16.c" ||
        (*i).first == "src\\drivers\\system18.c" ||
        (*i).first == "src\\drivers\\system24.c" ||
        (*i).first == "src\\drivers\\system32.c" ||
        (*i).first == "src\\drivers\\aburner.c" ||
        (*i).first == "src\\drivers\\sharrier.c" ||
        (*i).first == "src\\drivers\\outrun.c" )
        continue;
    XFreeSection( (*i).second.c_str() );
  }
  return TRUE;
}


//-------------------------------------------------------------
//	RegisterDriverSectionNames
//-------------------------------------------------------------
static void RegisterDriverSectionNames( void )
{
  RegisterSectionName( "src\\drivers\\1942.c", "12" );
  RegisterSectionName( "src\\drivers\\1943.c", "13" );
  RegisterSectionName( "src\\drivers\\40love.c", "14" );
  RegisterSectionName( "src\\drivers\\4enraya.c", "15" );
  RegisterSectionName( "src\\drivers\\8080bw.c", "16" );
  RegisterSectionName( "src\\drivers\\88games.c", "17" );
  RegisterSectionName( "src\\drivers\\aburner.c", "3" );
  RegisterSectionName( "src\\drivers\\ace.c", "19" );
  RegisterSectionName( "src\\drivers\\actfancr.c", "20" );
  RegisterSectionName( "src\\drivers\\aeroboto.c", "21" );
  RegisterSectionName( "src\\drivers\\aerofgt.c", "22" );
  RegisterSectionName( "src\\drivers\\afega.c", "23" );
  RegisterSectionName( "src\\drivers\\airbustr.c", "24" );
  RegisterSectionName( "src\\drivers\\ajax.c", "25" );
  RegisterSectionName( "src\\drivers\\aliens.c", "26" );
  RegisterSectionName( "src\\drivers\\alpha68k.c", "27" );
  RegisterSectionName( "src\\drivers\\ambush.c", "28" );
  RegisterSectionName( "src\\drivers\\amidar.c", "29" );
  RegisterSectionName( "src\\drivers\\amspdwy.c", "30" );
  RegisterSectionName( "src\\drivers\\angelkds.c", "31" );
  RegisterSectionName( "src\\drivers\\appoooh.c", "32" );
  RegisterSectionName( "src\\drivers\\aquarium.c", "33" );
  RegisterSectionName( "src\\drivers\\arabian.c", "34" );
  RegisterSectionName( "src\\drivers\\arcadecl.c", "35" );
  RegisterSectionName( "src\\drivers\\argus.c", "36" );
  RegisterSectionName( "src\\drivers\\arkanoid.c", "37" );
  RegisterSectionName( "src\\drivers\\armedf.c", "38" );
  RegisterSectionName( "src\\drivers\\artmagic.c", "39" );
  RegisterSectionName( "src\\drivers\\asterix.c", "40" );
  RegisterSectionName( "src\\drivers\\asteroid.c", "41" );
  RegisterSectionName( "src\\drivers\\astinvad.c", "42" );
  RegisterSectionName( "src\\drivers\\astrocde.c", "43" );
  RegisterSectionName( "src\\drivers\\astrof.c", "44" );
  RegisterSectionName( "src\\drivers\\asuka.c", "45" );
  RegisterSectionName( "src\\drivers\\atarifb.c", "46" );
  RegisterSectionName( "src\\drivers\\atarig1.c", "47" );
  RegisterSectionName( "src\\drivers\\atarig42.c", "48" );
  RegisterSectionName( "src\\drivers\\atarigt.c", "49" );
  RegisterSectionName( "src\\drivers\\atarigx2.c", "50" );
  RegisterSectionName( "src\\drivers\\atarisy1.c", "51" );
  RegisterSectionName( "src\\drivers\\atarisy2.c", "52" );
  RegisterSectionName( "src\\drivers\\ataxx.c", "53" );
  RegisterSectionName( "src\\drivers\\atetris.c", "54" );
  RegisterSectionName( "src\\drivers\\avalnche.c", "55" );
  RegisterSectionName( "src\\drivers\\avengrgs.c", "56" );
  RegisterSectionName( "src\\drivers\\aztarac.c", "57" );
  RegisterSectionName( "src\\drivers\\badlands.c", "58" );
  RegisterSectionName( "src\\drivers\\bagman.c", "59" );
  RegisterSectionName( "src\\drivers\\balsente.c", "60" );
  RegisterSectionName( "src\\drivers\\bankp.c", "61" );
  RegisterSectionName( "src\\drivers\\baraduke.c", "62" );
  RegisterSectionName( "src\\drivers\\batman.c", "63" );
  RegisterSectionName( "src\\drivers\\battlane.c", "64" );
  RegisterSectionName( "src\\drivers\\battlera.c", "65" );
  RegisterSectionName( "src\\drivers\\battlex.c", "66" );
  RegisterSectionName( "src\\drivers\\battlnts.c", "67" );
  RegisterSectionName( "src\\drivers\\bbusters.c", "68" );
  RegisterSectionName( "src\\drivers\\beaminv.c", "69" );
  RegisterSectionName( "src\\drivers\\beathead.c", "70" );
  RegisterSectionName( "src\\drivers\\beezer.c", "71" );
  RegisterSectionName( "src\\drivers\\berzerk.c", "72" );
  RegisterSectionName( "src\\drivers\\bigstrkb.c", "73" );
  RegisterSectionName( "src\\drivers\\bionicc.c", "74" );
  RegisterSectionName( "src\\drivers\\bking2.c", "75" );
  RegisterSectionName( "src\\drivers\\bladestl.c", "76" );
  RegisterSectionName( "src\\drivers\\blktiger.c", "77" );
  RegisterSectionName( "src\\drivers\\blmbycar.c", "78" );
  RegisterSectionName( "src\\drivers\\blockade.c", "79" );
  RegisterSectionName( "src\\drivers\\blockhl.c", "80" );
  RegisterSectionName( "src\\drivers\\blockout.c", "81" );
  RegisterSectionName( "src\\drivers\\bloodbro.c", "82" );
  RegisterSectionName( "src\\drivers\\blstroid.c", "83" );
  RegisterSectionName( "src\\drivers\\blueprnt.c", "84" );
  RegisterSectionName( "src\\drivers\\bogeyman.c", "85" );
  RegisterSectionName( "src\\drivers\\bombjack.c", "86" );
  RegisterSectionName( "src\\drivers\\bosco.c", "87" );
  RegisterSectionName( "src\\drivers\\bottom9.c", "88" );
  RegisterSectionName( "src\\drivers\\brkthru.c", "89" );
  RegisterSectionName( "src\\drivers\\bsktball.c", "90" );
  RegisterSectionName( "src\\drivers\\btime.c", "91" );
  RegisterSectionName( "src\\drivers\\btoads.c", "92" );
  RegisterSectionName( "src\\drivers\\bublbobl.c", "93" );
  RegisterSectionName( "src\\drivers\\buggychl.c", "94" );
  RegisterSectionName( "src\\drivers\\bwidow.c", "95" );
  RegisterSectionName( "src\\drivers\\bwing.c", "96" );
  RegisterSectionName( "src\\drivers\\cabal.c", "97" );
  RegisterSectionName( "src\\drivers\\canyon.c", "98" );
  RegisterSectionName( "src\\drivers\\capbowl.c", "99" );
  RegisterSectionName( "src\\drivers\\carjmbre.c", "100" );
  RegisterSectionName( "src\\drivers\\carpolo.c", "101" );
  RegisterSectionName( "src\\drivers\\cave.c", "102" );
  RegisterSectionName( "src\\drivers\\cbasebal.c", "103" );
  RegisterSectionName( "src\\drivers\\cbuster.c", "104" );
  RegisterSectionName( "src\\drivers\\ccastles.c", "105" );
  RegisterSectionName( "src\\drivers\\cchasm.c", "106" );
  RegisterSectionName( "src\\drivers\\cclimber.c", "107" );
  RegisterSectionName( "src\\drivers\\centiped.c", "108" );
  RegisterSectionName( "src\\drivers\\chaknpop.c", "109" );
  RegisterSectionName( "src\\drivers\\champbas.c", "110" );
  RegisterSectionName( "src\\drivers\\cheekyms.c", "111" );
  RegisterSectionName( "src\\drivers\\chinagat.c", "112" );
  RegisterSectionName( "src\\drivers\\chindrag.c", "113" );
  RegisterSectionName( "src\\drivers\\chqflag.c", "114" );
  RegisterSectionName( "src\\drivers\\cinemat.c", "115" );
  RegisterSectionName( "src\\drivers\\circus.c", "116" );
  RegisterSectionName( "src\\drivers\\circusc.c", "117" );
  RegisterSectionName( "src\\drivers\\cischeat.c", "118" );
  RegisterSectionName( "src\\drivers\\citycon.c", "119" );
  RegisterSectionName( "src\\drivers\\clayshoo.c", "120" );
  RegisterSectionName( "src\\drivers\\cloak.c", "121" );
  RegisterSectionName( "src\\drivers\\cloud9.c", "122" );
  RegisterSectionName( "src\\drivers\\clshroad.c", "123" );
  RegisterSectionName( "src\\drivers\\cninja.c", "124" );
  RegisterSectionName( "src\\drivers\\cojag.c", "125" );
  RegisterSectionName( "src\\drivers\\combatsc.c", "126" );
  RegisterSectionName( "src\\drivers\\commando.c", "127" );
  RegisterSectionName( "src\\drivers\\congo.c", "128" );
  RegisterSectionName( "src\\drivers\\contra.c", "129" );
  RegisterSectionName( "src\\drivers\\coolpool.c", "130" );
  RegisterSectionName( "src\\drivers\\cop01.c", "131" );
  RegisterSectionName( "src\\drivers\\copsnrob.c", "132" );
  RegisterSectionName( "src\\drivers\\cosmic.c", "133" );
  RegisterSectionName( "src\\drivers\\cps1.c", "1" );
  RegisterSectionName( "src\\drivers\\cps2.c", "1" );
  RegisterSectionName( "src\\drivers\\crbaloon.c", "136" );
  RegisterSectionName( "src\\drivers\\crgolf.c", "137" );
  RegisterSectionName( "src\\drivers\\crimfght.c", "138" );
  RegisterSectionName( "src\\drivers\\crshrace.c", "139" );
  RegisterSectionName( "src\\drivers\\cshooter.c", "140" );
  RegisterSectionName( "src\\drivers\\cvs.c", "141" );
  RegisterSectionName( "src\\drivers\\cyberbal.c", "142" );
  RegisterSectionName( "src\\drivers\\darius.c", "143" );
  RegisterSectionName( "src\\drivers\\darkseal.c", "144" );
  RegisterSectionName( "src\\drivers\\dassault.c", "145" );
  RegisterSectionName( "src\\drivers\\dbz2.c", "146" );
  RegisterSectionName( "src\\drivers\\dcon.c", "147" );
  RegisterSectionName( "src\\drivers\\dday.c", "148" );
  RegisterSectionName( "src\\drivers\\ddenlovr.c", "149" );
  RegisterSectionName( "src\\drivers\\ddragon.c", "150" );
  RegisterSectionName( "src\\drivers\\ddragon3.c", "151" );
  RegisterSectionName( "src\\drivers\\ddrible.c", "152" );
  RegisterSectionName( "src\\drivers\\deadang.c", "153" );
  RegisterSectionName( "src\\drivers\\dec0.c", "154" );
  RegisterSectionName( "src\\drivers\\dec8.c", "155" );
  RegisterSectionName( "src\\drivers\\deco32.c", "156" );
  RegisterSectionName( "src\\drivers\\decocass.c", "157" );
  RegisterSectionName( "src\\drivers\\deniam.c", "158" );
  RegisterSectionName( "src\\drivers\\destroyr.c", "159" );
  RegisterSectionName( "src\\drivers\\digdug.c", "160" );
  RegisterSectionName( "src\\drivers\\diverboy.c", "161" );
  RegisterSectionName( "src\\drivers\\djboy.c", "162" );
  RegisterSectionName( "src\\drivers\\dkong.c", "163" );
  RegisterSectionName( "src\\drivers\\dlair.c", "164" );
  RegisterSectionName( "src\\drivers\\docastle.c", "165" );
  RegisterSectionName( "src\\drivers\\dogfgt.c", "166" );
  RegisterSectionName( "src\\drivers\\dominos.c", "167" );
  RegisterSectionName( "src\\drivers\\dooyong.c", "168" );
  RegisterSectionName( "src\\drivers\\dotrikun.c", "169" );
  RegisterSectionName( "src\\drivers\\dragrace.c", "170" );
  RegisterSectionName( "src\\drivers\\drgnmst.c", "171" );
  RegisterSectionName( "src\\drivers\\dribling.c", "172" );
  RegisterSectionName( "src\\drivers\\drmicro.c", "173" );
  RegisterSectionName( "src\\drivers\\dynax.c", "174" );
  RegisterSectionName( "src\\drivers\\dynduke.c", "175" );
  RegisterSectionName( "src\\drivers\\epos.c", "176" );
  RegisterSectionName( "src\\drivers\\eprom.c", "177" );
  RegisterSectionName( "src\\drivers\\equites.c", "178" );
  RegisterSectionName( "src\\drivers\\esd16.c", "179" );
  RegisterSectionName( "src\\drivers\\exctsccr.c", "180" );
  RegisterSectionName( "src\\drivers\\exedexes.c", "181" );
  RegisterSectionName( "src\\drivers\\exerion.c", "182" );
  RegisterSectionName( "src\\drivers\\exidy440.c", "183" );
  RegisterSectionName( "src\\drivers\\exprraid.c", "184" );
  RegisterSectionName( "src\\drivers\\exterm.c", "185" );
  RegisterSectionName( "src\\drivers\\exzisus.c", "186" );
  RegisterSectionName( "src\\drivers\\f1gp.c", "187" );
  RegisterSectionName( "src\\drivers\\fantland.c", "188" );
  RegisterSectionName( "src\\drivers\\fastfred.c", "189" );
  RegisterSectionName( "src\\drivers\\fastlane.c", "190" );
  RegisterSectionName( "src\\drivers\\fcombat.c", "191" );
  RegisterSectionName( "src\\drivers\\finalizr.c", "192" );
  RegisterSectionName( "src\\drivers\\findout.c", "193" );
  RegisterSectionName( "src\\drivers\\firetrap.c", "194" );
  RegisterSectionName( "src\\drivers\\firetrk.c", "195" );
  RegisterSectionName( "src\\drivers\\fitfight.c", "196" );
  RegisterSectionName( "src\\drivers\\flkatck.c", "197" );
  RegisterSectionName( "src\\drivers\\flower.c", "198" );
  RegisterSectionName( "src\\drivers\\flstory.c", "199" );
  RegisterSectionName( "src\\drivers\\flyball.c", "200" );
  RegisterSectionName( "src\\drivers\\foodf.c", "201" );
  RegisterSectionName( "src\\drivers\\freekick.c", "202" );
  RegisterSectionName( "src\\drivers\\frogger.c", "203" );
  RegisterSectionName( "src\\drivers\\fromanc2.c", "204" );
  RegisterSectionName( "src\\drivers\\fromance.c", "205" );
  RegisterSectionName( "src\\drivers\\funkybee.c", "206" );
  RegisterSectionName( "src\\drivers\\funkyjet.c", "207" );
  RegisterSectionName( "src\\drivers\\fuuki16.c", "208" );
  RegisterSectionName( "src\\drivers\\gaelco.c", "209" );
  RegisterSectionName( "src\\drivers\\gaelco2.c", "210" );
  RegisterSectionName( "src\\drivers\\gaiden.c", "211" );
  RegisterSectionName( "src\\drivers\\galaga.c", "212" );
  RegisterSectionName( "src\\drivers\\galivan.c", "213" );
  RegisterSectionName( "src\\drivers\\galpani2.c", "214" );
  RegisterSectionName( "src\\drivers\\galpanic.c", "215" );
  RegisterSectionName( "src\\drivers\\galspnbl.c", "216" );
  RegisterSectionName( "src\\drivers\\gameplan.c", "217" );
  RegisterSectionName( "src\\drivers\\gaplus.c", "218" );
  RegisterSectionName( "src\\drivers\\gauntlet.c", "219" );
  RegisterSectionName( "src\\drivers\\gberet.c", "220" );
  RegisterSectionName( "src\\drivers\\gbusters.c", "221" );
  RegisterSectionName( "src\\drivers\\gcpinbal.c", "222" );
  RegisterSectionName( "src\\drivers\\geebee.c", "223" );
  RegisterSectionName( "src\\drivers\\gijoe.c", "224" );
  RegisterSectionName( "src\\drivers\\ginganin.c", "225" );
  RegisterSectionName( "src\\drivers\\gladiatr.c", "226" );
  RegisterSectionName( "src\\drivers\\glass.c", "227" );
  RegisterSectionName( "src\\drivers\\gng.c", "228" );
  RegisterSectionName( "src\\drivers\\goindol.c", "229" );
  RegisterSectionName( "src\\drivers\\gomoku.c", "230" );
  RegisterSectionName( "src\\drivers\\gotcha.c", "231" );
  RegisterSectionName( "src\\drivers\\gotya.c", "232" );
  RegisterSectionName( "src\\drivers\\gradius3.c", "233" );
  RegisterSectionName( "src\\drivers\\grchamp.c", "234" );
  RegisterSectionName( "src\\drivers\\gridlee.c", "235" );
  RegisterSectionName( "src\\drivers\\grobda.c", "236" );
  RegisterSectionName( "src\\drivers\\groundfx.c", "237" );
  RegisterSectionName( "src\\drivers\\grtwall.c", "238" );
  RegisterSectionName( "src\\drivers\\gstriker.c", "239" );
  RegisterSectionName( "src\\drivers\\gsword.c", "240" );
  RegisterSectionName( "src\\drivers\\gumbo.c", "241" );
  RegisterSectionName( "src\\drivers\\gunbustr.c", "242" );
  RegisterSectionName( "src\\drivers\\gundealr.c", "243" );
  RegisterSectionName( "src\\drivers\\gunsmoke.c", "244" );
  RegisterSectionName( "src\\drivers\\gyruss.c", "245" );
  RegisterSectionName( "src\\drivers\\halleys.c", "246" );
  RegisterSectionName( "src\\drivers\\hanaawas.c", "247" );
  RegisterSectionName( "src\\drivers\\hanaroku.c", "248" );
  RegisterSectionName( "src\\drivers\\harddriv.c", "249" );
  RegisterSectionName( "src\\drivers\\hcastle.c", "250" );
  RegisterSectionName( "src\\drivers\\hexa.c", "251" );
  RegisterSectionName( "src\\drivers\\hexion.c", "252" );
  RegisterSectionName( "src\\drivers\\higemaru.c", "253" );
  RegisterSectionName( "src\\drivers\\hitme.c", "254" );
  RegisterSectionName( "src\\drivers\\hnayayoi.c", "255" );
  RegisterSectionName( "src\\drivers\\holeland.c", "256" );
  RegisterSectionName( "src\\drivers\\homedata.c", "257" );
  RegisterSectionName( "src\\drivers\\hyhoo.c", "258" );
  RegisterSectionName( "src\\drivers\\hyperspt.c", "259" );
  RegisterSectionName( "src\\drivers\\hyprduel.c", "260" );
  RegisterSectionName( "src\\drivers\\ikki.c", "261" );
  RegisterSectionName( "src\\drivers\\iqblock.c", "262" );
  RegisterSectionName( "src\\drivers\\irobot.c", "263" );
  RegisterSectionName( "src\\drivers\\ironhors.c", "264" );
  RegisterSectionName( "src\\drivers\\itech32.c", "265" );
  RegisterSectionName( "src\\drivers\\itech8.c", "266" );
  RegisterSectionName( "src\\drivers\\jack.c", "267" );
  RegisterSectionName( "src\\drivers\\jackal.c", "268" );
  RegisterSectionName( "src\\drivers\\jailbrek.c", "269" );
  RegisterSectionName( "src\\drivers\\jalmah.c", "270" );
  RegisterSectionName( "src\\drivers\\jedi.c", "271" );
  RegisterSectionName( "src\\drivers\\jrpacman.c", "272" );
  RegisterSectionName( "src\\drivers\\junofrst.c", "273" );
  RegisterSectionName( "src\\drivers\\kaneko16.c", "274" );
  RegisterSectionName( "src\\drivers\\kangaroo.c", "275" );
  RegisterSectionName( "src\\drivers\\karnov.c", "276" );
  RegisterSectionName( "src\\drivers\\kchamp.c", "277" );
  RegisterSectionName( "src\\drivers\\kickgoal.c", "278" );
  RegisterSectionName( "src\\drivers\\kingobox.c", "279" );
  RegisterSectionName( "src\\drivers\\kinst.c", "280" );
  RegisterSectionName( "src\\drivers\\klax.c", "281" );
  RegisterSectionName( "src\\drivers\\kncljoe.c", "282" );
  RegisterSectionName( "src\\drivers\\konamigx.c", "283" );
  RegisterSectionName( "src\\drivers\\kopunch.c", "284" );
  RegisterSectionName( "src\\drivers\\kyugo.c", "285" );
  RegisterSectionName( "src\\drivers\\labyrunr.c", "286" );
  RegisterSectionName( "src\\drivers\\ladybug.c", "287" );
  RegisterSectionName( "src\\drivers\\lasso.c", "288" );
  RegisterSectionName( "src\\drivers\\lastduel.c", "289" );
  RegisterSectionName( "src\\drivers\\lazercmd.c", "290" );
  RegisterSectionName( "src\\drivers\\legionna.c", "291" );
  RegisterSectionName( "src\\drivers\\lemmings.c", "292" );
  RegisterSectionName( "src\\drivers\\leprechn.c", "293" );
  RegisterSectionName( "src\\drivers\\lethalj.c", "294" );
  RegisterSectionName( "src\\drivers\\liberate.c", "295" );
  RegisterSectionName( "src\\drivers\\liberatr.c", "296" );
  RegisterSectionName( "src\\drivers\\lkage.c", "297" );
  RegisterSectionName( "src\\drivers\\locomotn.c", "298" );
  RegisterSectionName( "src\\drivers\\looping.c", "299" );
  RegisterSectionName( "src\\drivers\\lsasquad.c", "300" );
  RegisterSectionName( "src\\drivers\\lwings.c", "301" );
  RegisterSectionName( "src\\drivers\\m107.c", "302" );
  RegisterSectionName( "src\\drivers\\m62.c", "303" );
  RegisterSectionName( "src\\drivers\\m79amb.c", "304" );
  RegisterSectionName( "src\\drivers\\m90.c", "305" );
  RegisterSectionName( "src\\drivers\\m92.c", "306" );
  RegisterSectionName( "src\\drivers\\macrossp.c", "307" );
  RegisterSectionName( "src\\drivers\\madmotor.c", "308" );
  RegisterSectionName( "src\\drivers\\magmax.c", "309" );
  RegisterSectionName( "src\\drivers\\mainevt.c", "310" );
  RegisterSectionName( "src\\drivers\\mainsnk.c", "311" );
  RegisterSectionName( "src\\drivers\\mappy.c", "312" );
  RegisterSectionName( "src\\drivers\\marineb.c", "313" );
  RegisterSectionName( "src\\drivers\\mario.c", "314" );
  RegisterSectionName( "src\\drivers\\markham.c", "315" );
  RegisterSectionName( "src\\drivers\\marvins.c", "316" );
  RegisterSectionName( "src\\drivers\\matmania.c", "317" );
  RegisterSectionName( "src\\drivers\\mayumi.c", "318" );
  RegisterSectionName( "src\\drivers\\mcatadv.c", "319" );
  RegisterSectionName( "src\\drivers\\mcr1.c", "320" );
  RegisterSectionName( "src\\drivers\\mcr2.c", "321" );
  RegisterSectionName( "src\\drivers\\mcr3.c", "322" );
  RegisterSectionName( "src\\drivers\\mcr68.c", "323" );
  RegisterSectionName( "src\\drivers\\meadows.c", "324" );
  RegisterSectionName( "src\\drivers\\megazone.c", "325" );
  RegisterSectionName( "src\\drivers\\mermaid.c", "326" );
  RegisterSectionName( "src\\drivers\\metlclsh.c", "327" );
  RegisterSectionName( "src\\drivers\\metro.c", "328" );
  RegisterSectionName( "src\\drivers\\mexico86.c", "329" );
  RegisterSectionName( "src\\drivers\\mhavoc.c", "330" );
  RegisterSectionName( "src\\drivers\\midtunit.c", "331" );
  RegisterSectionName( "src\\drivers\\midvunit.c", "332" );
  RegisterSectionName( "src\\drivers\\midwunit.c", "333" );
  RegisterSectionName( "src\\drivers\\midxunit.c", "334" );
  RegisterSectionName( "src\\drivers\\midyunit.c", "335" );
  RegisterSectionName( "src\\drivers\\mikie.c", "336" );
  RegisterSectionName( "src\\drivers\\minivadr.c", "337" );
  RegisterSectionName( "src\\drivers\\missb2.c", "338" );
  RegisterSectionName( "src\\drivers\\missile.c", "339" );
  RegisterSectionName( "src\\drivers\\mitchell.c", "340" );
  RegisterSectionName( "src\\drivers\\mjkjidai.c", "341" );
  RegisterSectionName( "src\\drivers\\mjsister.c", "342" );
  RegisterSectionName( "src\\drivers\\mnight.c", "343" );
  RegisterSectionName( "src\\drivers\\mole.c", "344" );
  RegisterSectionName( "src\\drivers\\momoko.c", "345" );
  RegisterSectionName( "src\\drivers\\moo.c", "346" );
  RegisterSectionName( "src\\drivers\\mosaic.c", "347" );
  RegisterSectionName( "src\\drivers\\mouser.c", "348" );
  RegisterSectionName( "src\\drivers\\mrdo.c", "349" );
  RegisterSectionName( "src\\drivers\\mrflea.c", "350" );
  RegisterSectionName( "src\\drivers\\mrjong.c", "351" );
  RegisterSectionName( "src\\drivers\\ms32.c", "352" );
  RegisterSectionName( "src\\drivers\\msisaac.c", "353" );
  RegisterSectionName( "src\\drivers\\mugsmash.c", "354" );
  RegisterSectionName( "src\\drivers\\multi32.c", "3" );
  RegisterSectionName( "src\\drivers\\munchmo.c", "356" );
  RegisterSectionName( "src\\drivers\\mustache.c", "357" );
  RegisterSectionName( "src\\drivers\\mystston.c", "358" );
  RegisterSectionName( "src\\drivers\\mystwarr.c", "359" );
  RegisterSectionName( "src\\drivers\\namcoic.c", "2" );
  RegisterSectionName( "src\\drivers\\namcona1.c", "2" );
  RegisterSectionName( "src\\drivers\\namconb1.c", "2" );
  RegisterSectionName( "src\\drivers\\namcond1.c", "2" );
  RegisterSectionName( "src\\drivers\\namcos1.c", "2" );
  RegisterSectionName( "src\\drivers\\namcos2.c", "2" );
  RegisterSectionName( "src\\drivers\\namcos21.c", "2" );
  RegisterSectionName( "src\\drivers\\namcos22.c", "2" );
  RegisterSectionName( "src\\drivers\\namcos86.c", "2" );
  RegisterSectionName( "src\\drivers\\naughtyb.c", "369" );
  RegisterSectionName( "src\\drivers\\nbmj8688.c", "370" );
  RegisterSectionName( "src\\drivers\\nbmj8891.c", "371" );
  RegisterSectionName( "src\\drivers\\nbmj8991.c", "372" );
  RegisterSectionName( "src\\drivers\\nbmj9195.c", "373" );
  RegisterSectionName( "src\\drivers\\nemesis.c", "374" );
  RegisterSectionName( "src\\drivers\\neogeo.c", "375" );
  RegisterSectionName( "src\\drivers\\news.c", "376" );
  RegisterSectionName( "src\\drivers\\ninjakd2.c", "377" );
  RegisterSectionName( "src\\drivers\\ninjakid.c", "378" );
  RegisterSectionName( "src\\drivers\\ninjaw.c", "379" );
  RegisterSectionName( "src\\drivers\\nitedrvr.c", "380" );
  RegisterSectionName( "src\\drivers\\niyanpai.c", "381" );
  RegisterSectionName( "src\\drivers\\nmk16.c", "382" );
  RegisterSectionName( "src\\drivers\\nycaptor.c", "383" );
  RegisterSectionName( "src\\drivers\\nyny.c", "384" );
  RegisterSectionName( "src\\drivers\\offtwall.c", "385" );
  RegisterSectionName( "src\\drivers\\ohmygod.c", "386" );
  RegisterSectionName( "src\\drivers\\ojankohs.c", "387" );
  RegisterSectionName( "src\\drivers\\olibochu.c", "388" );
  RegisterSectionName( "src\\drivers\\omegaf.c", "389" );
  RegisterSectionName( "src\\drivers\\omegrace.c", "390" );
  RegisterSectionName( "src\\drivers\\oneshot.c", "391" );
  RegisterSectionName( "src\\drivers\\opwolf.c", "392" );
  RegisterSectionName( "src\\drivers\\orbit.c", "393" );
  RegisterSectionName( "src\\drivers\\othldrby.c", "394" );
  RegisterSectionName( "src\\drivers\\othunder.c", "395" );
  RegisterSectionName( "src\\drivers\\outrun.c", "3" );
  RegisterSectionName( "src\\drivers\\overdriv.c", "397" );
  RegisterSectionName( "src\\drivers\\pacland.c", "398" );
  RegisterSectionName( "src\\drivers\\pacman.c", "399" );
  RegisterSectionName( "src\\drivers\\pandoras.c", "400" );
  RegisterSectionName( "src\\drivers\\paradise.c", "401" );
  RegisterSectionName( "src\\drivers\\parodius.c", "402" );
  RegisterSectionName( "src\\drivers\\pass.c", "403" );
  RegisterSectionName( "src\\drivers\\pastelgl.c", "404" );
  RegisterSectionName( "src\\drivers\\pbaction.c", "405" );
  RegisterSectionName( "src\\drivers\\pbillian.c", "406" );
  RegisterSectionName( "src\\drivers\\pcktgal.c", "407" );
  RegisterSectionName( "src\\drivers\\pgm.c", "408" );
  RegisterSectionName( "src\\drivers\\phoenix.c", "409" );
  RegisterSectionName( "src\\drivers\\phozon.c", "410" );
  RegisterSectionName( "src\\drivers\\pingpong.c", "411" );
  RegisterSectionName( "src\\drivers\\pipedrm.c", "412" );
  RegisterSectionName( "src\\drivers\\pirates.c", "413" );
  RegisterSectionName( "src\\drivers\\pkunwar.c", "414" );
  RegisterSectionName( "src\\drivers\\playch10.c", "415" );
  RegisterSectionName( "src\\drivers\\playmark.c", "416" );
  RegisterSectionName( "src\\drivers\\plygonet.c", "417" );
  RegisterSectionName( "src\\drivers\\polepos.c", "418" );
  RegisterSectionName( "src\\drivers\\policetr.c", "419" );
  RegisterSectionName( "src\\drivers\\polyplay.c", "420" );
  RegisterSectionName( "src\\drivers\\poolshrk.c", "421" );
  RegisterSectionName( "src\\drivers\\pooyan.c", "422" );
  RegisterSectionName( "src\\drivers\\popeye.c", "423" );
  RegisterSectionName( "src\\drivers\\popper.c", "424" );
  RegisterSectionName( "src\\drivers\\portrait.c", "425" );
  RegisterSectionName( "src\\drivers\\powerins.c", "426" );
  RegisterSectionName( "src\\drivers\\prehisle.c", "427" );
  RegisterSectionName( "src\\drivers\\psikyo.c", "428" );
  RegisterSectionName( "src\\drivers\\psikyo4.c", "429" );
  RegisterSectionName( "src\\drivers\\psikyosh.c", "430" );
  RegisterSectionName( "src\\drivers\\psychic5.c", "431" );
  RegisterSectionName( "src\\drivers\\punchout.c", "432" );
  RegisterSectionName( "src\\drivers\\pushman.c", "433" );
  RegisterSectionName( "src\\drivers\\qix.c", "434" );
  RegisterSectionName( "src\\drivers\\quantum.c", "435" );
  RegisterSectionName( "src\\drivers\\quizdna.c", "436" );
  RegisterSectionName( "src\\drivers\\raiden.c", "437" );
  RegisterSectionName( "src\\drivers\\raiden2.c", "438" );
  RegisterSectionName( "src\\drivers\\raiders5.c", "439" );
  RegisterSectionName( "src\\drivers\\rainbow.c", "440" );
  RegisterSectionName( "src\\drivers\\realbrk.c", "441" );
  RegisterSectionName( "src\\drivers\\redalert.c", "442" );
  RegisterSectionName( "src\\drivers\\redclash.c", "443" );
  RegisterSectionName( "src\\drivers\\relief.c", "444" );
  RegisterSectionName( "src\\drivers\\renegade.c", "445" );
  RegisterSectionName( "src\\drivers\\retofinv.c", "446" );
  RegisterSectionName( "src\\drivers\\rmhaihai.c", "447" );
  RegisterSectionName( "src\\drivers\\rockola.c", "448" );
  RegisterSectionName( "src\\drivers\\rockrage.c", "449" );
  RegisterSectionName( "src\\drivers\\rocnrope.c", "450" );
  RegisterSectionName( "src\\drivers\\rohga.c", "451" );
  RegisterSectionName( "src\\drivers\\rollerg.c", "452" );
  RegisterSectionName( "src\\drivers\\rollrace.c", "453" );
  RegisterSectionName( "src\\drivers\\rotaryf.c", "454" );
  RegisterSectionName( "src\\drivers\\route16.c", "455" );
  RegisterSectionName( "src\\drivers\\royalmah.c", "456" );
  RegisterSectionName( "src\\drivers\\rpunch.c", "457" );
  RegisterSectionName( "src\\drivers\\rungun.c", "458" );
  RegisterSectionName( "src\\drivers\\safarir.c", "459" );
  RegisterSectionName( "src\\drivers\\sauro.c", "460" );
  RegisterSectionName( "src\\drivers\\sbasketb.c", "461" );
  RegisterSectionName( "src\\drivers\\sbrkout.c", "462" );
  RegisterSectionName( "src\\drivers\\sbugger.c", "463" );
  RegisterSectionName( "src\\drivers\\scregg.c", "464" );
  RegisterSectionName( "src\\drivers\\sega.c", "465" );
  RegisterSectionName( "src\\drivers\\segac2.c", "466" );
  RegisterSectionName( "src\\drivers\\segar.c", "467" );
  RegisterSectionName( "src\\drivers\\segasyse.c", "468" );
  RegisterSectionName( "src\\drivers\\seicross.c", "469" );
  RegisterSectionName( "src\\drivers\\senjyo.c", "470" );
  RegisterSectionName( "src\\drivers\\seta.c", "471" );
  RegisterSectionName( "src\\drivers\\seta2.c", "472" );
  RegisterSectionName( "src\\drivers\\sf1.c", "473" );
  RegisterSectionName( "src\\drivers\\sg1000a.c", "474" );
  RegisterSectionName( "src\\drivers\\sgladiat.c", "475" );
  RegisterSectionName( "src\\drivers\\shadfrce.c", "476" );
  RegisterSectionName( "src\\drivers\\shangha3.c", "477" );
  RegisterSectionName( "src\\drivers\\shanghai.c", "478" );
  RegisterSectionName( "src\\drivers\\shangkid.c", "479" );
  RegisterSectionName( "src\\drivers\\shaolins.c", "480" );
  RegisterSectionName( "src\\drivers\\sharrier.c", "3" );
  RegisterSectionName( "src\\drivers\\shisen.c", "482" );
  RegisterSectionName( "src\\drivers\\shootout.c", "483" );
  RegisterSectionName( "src\\drivers\\shougi.c", "484" );
  RegisterSectionName( "src\\drivers\\shuuz.c", "485" );
  RegisterSectionName( "src\\drivers\\sidearms.c", "486" );
  RegisterSectionName( "src\\drivers\\sidepckt.c", "487" );
  RegisterSectionName( "src\\drivers\\silkroad.c", "488" );
  RegisterSectionName( "src\\drivers\\simpsons.c", "489" );
  RegisterSectionName( "src\\drivers\\skullxbo.c", "490" );
  RegisterSectionName( "src\\drivers\\skyarmy.c", "491" );
  RegisterSectionName( "src\\drivers\\skychut.c", "492" );
  RegisterSectionName( "src\\drivers\\skydiver.c", "493" );
  RegisterSectionName( "src\\drivers\\skyfox.c", "494" );
  RegisterSectionName( "src\\drivers\\skykid.c", "495" );
  RegisterSectionName( "src\\drivers\\skyraid.c", "496" );
  RegisterSectionName( "src\\drivers\\slapfght.c", "497" );
  RegisterSectionName( "src\\drivers\\slapshot.c", "498" );
  RegisterSectionName( "src\\drivers\\snk68.c", "499" );
  RegisterSectionName( "src\\drivers\\snowbros.c", "500" );
  RegisterSectionName( "src\\drivers\\solomon.c", "501" );
  RegisterSectionName( "src\\drivers\\sonson.c", "502" );
  RegisterSectionName( "src\\drivers\\spacefb.c", "503" );
  RegisterSectionName( "src\\drivers\\spbactn.c", "504" );
  RegisterSectionName( "src\\drivers\\spcforce.c", "505" );
  RegisterSectionName( "src\\drivers\\spdbuggy.c", "506" );
  RegisterSectionName( "src\\drivers\\spdodgeb.c", "507" );
  RegisterSectionName( "src\\drivers\\speedbal.c", "508" );
  RegisterSectionName( "src\\drivers\\speedspn.c", "509" );
  RegisterSectionName( "src\\drivers\\spiders.c", "510" );
  RegisterSectionName( "src\\drivers\\splash.c", "511" );
  RegisterSectionName( "src\\drivers\\sprcros2.c", "512" );
  RegisterSectionName( "src\\drivers\\sprint2.c", "513" );
  RegisterSectionName( "src\\drivers\\spy.c", "514" );
  RegisterSectionName( "src\\drivers\\srmp2.c", "515" );
  RegisterSectionName( "src\\drivers\\srumbler.c", "516" );
  RegisterSectionName( "src\\drivers\\sshangha.c", "517" );
  RegisterSectionName( "src\\drivers\\sslam.c", "518" );
  RegisterSectionName( "src\\drivers\\ssozumo.c", "519" );
  RegisterSectionName( "src\\drivers\\ssv.c", "520" );
  RegisterSectionName( "src\\drivers\\stactics.c", "521" );
  RegisterSectionName( "src\\drivers\\stadhero.c", "522" );
  RegisterSectionName( "src\\drivers\\starcrus.c", "523" );
  RegisterSectionName( "src\\drivers\\starfire.c", "524" );
  RegisterSectionName( "src\\drivers\\starshp1.c", "525" );
  RegisterSectionName( "src\\drivers\\starwars.c", "526" );
  RegisterSectionName( "src\\drivers\\statriv2.c", "527" );
  RegisterSectionName( "src\\drivers\\stfight.c", "528" );
  RegisterSectionName( "src\\drivers\\stlforce.c", "529" );
  RegisterSectionName( "src\\drivers\\strnskil.c", "530" );
  RegisterSectionName( "src\\drivers\\stv.c", "531" );
  RegisterSectionName( "src\\drivers\\subs.c", "532" );
  RegisterSectionName( "src\\drivers\\suna16.c", "533" );
  RegisterSectionName( "src\\drivers\\suna8.c", "534" );
  RegisterSectionName( "src\\drivers\\supbtime.c", "535" );
  RegisterSectionName( "src\\drivers\\superchs.c", "536" );
  RegisterSectionName( "src\\drivers\\superpac.c", "537" );
  RegisterSectionName( "src\\drivers\\superqix.c", "538" );
  RegisterSectionName( "src\\drivers\\suprloco.c", "539" );
  RegisterSectionName( "src\\drivers\\suprnova.c", "540" );
  RegisterSectionName( "src\\drivers\\suprslam.c", "541" );
  RegisterSectionName( "src\\drivers\\surpratk.c", "542" );
  RegisterSectionName( "src\\drivers\\system1.c", "3" );
  RegisterSectionName( "src\\drivers\\system16.c", "3" );
  RegisterSectionName( "src\\drivers\\system18.c", "3" );
  RegisterSectionName( "src\\drivers\\system24.c", "3" );
  RegisterSectionName( "src\\drivers\\system32.c", "3" );
  RegisterSectionName( "src\\drivers\\tagteam.c", "548" );
  RegisterSectionName( "src\\drivers\\tail2nos.c", "549" );
  RegisterSectionName( "src\\drivers\\taito_b.c", "550" );
  RegisterSectionName( "src\\drivers\\taito_f2.c", "551" );
  RegisterSectionName( "src\\drivers\\taito_h.c", "552" );
  RegisterSectionName( "src\\drivers\\taito_l.c", "553" );
  RegisterSectionName( "src\\drivers\\taito_x.c", "554" );
  RegisterSectionName( "src\\drivers\\taito_z.c", "555" );
  RegisterSectionName( "src\\drivers\\taitoair.c", "556" );
  RegisterSectionName( "src\\drivers\\taitosj.c", "557" );
  RegisterSectionName( "src\\drivers\\tankbatt.c", "558" );
  RegisterSectionName( "src\\drivers\\tankbust.c", "559" );
  RegisterSectionName( "src\\drivers\\taotaido.c", "560" );
  RegisterSectionName( "src\\drivers\\targeth.c", "561" );
  RegisterSectionName( "src\\drivers\\taxidrvr.c", "562" );
  RegisterSectionName( "src\\drivers\\tbowl.c", "563" );
  RegisterSectionName( "src\\drivers\\tecmo.c", "564" );
  RegisterSectionName( "src\\drivers\\tecmo16.c", "565" );
  RegisterSectionName( "src\\drivers\\tecmosys.c", "566" );
  RegisterSectionName( "src\\drivers\\tehkanwc.c", "567" );
  RegisterSectionName( "src\\drivers\\tempest.c", "568" );
  RegisterSectionName( "src\\drivers\\terracre.c", "569" );
  RegisterSectionName( "src\\drivers\\tetrisp2.c", "570" );
  RegisterSectionName( "src\\drivers\\thedeep.c", "571" );
  RegisterSectionName( "src\\drivers\\thepit.c", "572" );
  RegisterSectionName( "src\\drivers\\thief.c", "573" );
  RegisterSectionName( "src\\drivers\\thoop2.c", "574" );
  RegisterSectionName( "src\\drivers\\thunderj.c", "575" );
  RegisterSectionName( "src\\drivers\\thunderx.c", "576" );
  RegisterSectionName( "src\\drivers\\tickee.c", "577" );
  RegisterSectionName( "src\\drivers\\tigeroad.c", "578" );
  RegisterSectionName( "src\\drivers\\timelimt.c", "579" );
  RegisterSectionName( "src\\drivers\\tmnt.c", "580" );
  RegisterSectionName( "src\\drivers\\tnzs.c", "581" );
  RegisterSectionName( "src\\drivers\\toaplan1.c", "582" );
  RegisterSectionName( "src\\drivers\\toaplan2.c", "583" );
  RegisterSectionName( "src\\drivers\\toki.c", "584" );
  RegisterSectionName( "src\\drivers\\toobin.c", "585" );
  RegisterSectionName( "src\\drivers\\topspeed.c", "586" );
  RegisterSectionName( "src\\drivers\\toratora.c", "587" );
  RegisterSectionName( "src\\drivers\\tourtabl.c", "588" );
  RegisterSectionName( "src\\drivers\\toypop.c", "589" );
  RegisterSectionName( "src\\drivers\\tp84.c", "590" );
  RegisterSectionName( "src\\drivers\\travrusa.c", "591" );
  RegisterSectionName( "src\\drivers\\triplhnt.c", "592" );
  RegisterSectionName( "src\\drivers\\troangel.c", "593" );
  RegisterSectionName( "src\\drivers\\truco.c", "594" );
  RegisterSectionName( "src\\drivers\\tsamurai.c", "595" );
  RegisterSectionName( "src\\drivers\\ttmahjng.c", "596" );
  RegisterSectionName( "src\\drivers\\tubep.c", "597" );
  RegisterSectionName( "src\\drivers\\tugboat.c", "598" );
  RegisterSectionName( "src\\drivers\\tumblep.c", "599" );
  RegisterSectionName( "src\\drivers\\tunhunt.c", "600" );
  RegisterSectionName( "src\\drivers\\turbo.c", "601" );
  RegisterSectionName( "src\\drivers\\tutankhm.c", "602" );
  RegisterSectionName( "src\\drivers\\twin16.c", "603" );
  RegisterSectionName( "src\\drivers\\twincobr.c", "604" );
  RegisterSectionName( "src\\drivers\\ultraman.c", "605" );
  RegisterSectionName( "src\\drivers\\ultratnk.c", "606" );
  RegisterSectionName( "src\\drivers\\undrfire.c", "607" );
  RegisterSectionName( "src\\drivers\\unico.c", "608" );
  RegisterSectionName( "src\\drivers\\usgames.c", "609" );
  RegisterSectionName( "src\\drivers\\vaportra.c", "610" );
  RegisterSectionName( "src\\drivers\\vastar.c", "611" );
  RegisterSectionName( "src\\drivers\\vball.c", "612" );
  RegisterSectionName( "src\\drivers\\vendetta.c", "613" );
  RegisterSectionName( "src\\drivers\\vicdual.c", "614" );
  RegisterSectionName( "src\\drivers\\victory.c", "615" );
  RegisterSectionName( "src\\drivers\\videopin.c", "616" );
  RegisterSectionName( "src\\drivers\\vigilant.c", "617" );
  RegisterSectionName( "src\\drivers\\vindictr.c", "618" );
  RegisterSectionName( "src\\drivers\\volfied.c", "619" );
  RegisterSectionName( "src\\drivers\\vsnes.c", "620" );
  RegisterSectionName( "src\\drivers\\vulgus.c", "621" );
  RegisterSectionName( "src\\drivers\\wallc.c", "622" );
  RegisterSectionName( "src\\drivers\\wardner.c", "623" );
  RegisterSectionName( "src\\drivers\\warpwarp.c", "624" );
  RegisterSectionName( "src\\drivers\\warriorb.c", "625" );
  RegisterSectionName( "src\\drivers\\wc90.c", "626" );
  RegisterSectionName( "src\\drivers\\wc90b.c", "627" );
  RegisterSectionName( "src\\drivers\\wecleman.c", "628" );
  RegisterSectionName( "src\\drivers\\welltris.c", "629" );
  RegisterSectionName( "src\\drivers\\wgp.c", "630" );
  RegisterSectionName( "src\\drivers\\wilytowr.c", "631" );
  RegisterSectionName( "src\\drivers\\wiping.c", "632" );
  RegisterSectionName( "src\\drivers\\wiz.c", "633" );
  RegisterSectionName( "src\\drivers\\wolfpack.c", "634" );
  RegisterSectionName( "src\\drivers\\wrally.c", "635" );
  RegisterSectionName( "src\\drivers\\wwfsstar.c", "636" );
  RegisterSectionName( "src\\drivers\\wwfwfest.c", "637" );
  RegisterSectionName( "src\\drivers\\xain.c", "638" );
  RegisterSectionName( "src\\drivers\\xevious.c", "639" );
  RegisterSectionName( "src\\drivers\\xexex.c", "640" );
  RegisterSectionName( "src\\drivers\\xmen.c", "641" );
  RegisterSectionName( "src\\drivers\\xxmissio.c", "642" );
  RegisterSectionName( "src\\drivers\\xybots.c", "643" );
  RegisterSectionName( "src\\drivers\\xyonix.c", "644" );
  RegisterSectionName( "src\\drivers\\yamato.c", "645" );
  RegisterSectionName( "src\\drivers\\yard.c", "646" );
  RegisterSectionName( "src\\drivers\\yiear.c", "647" );
  RegisterSectionName( "src\\drivers\\yunsun16.c", "648" );
  RegisterSectionName( "src\\drivers\\yunsung8.c", "649" );
  RegisterSectionName( "src\\drivers\\zac2650.c", "650" );
  RegisterSectionName( "src\\drivers\\zaccaria.c", "651" );
  RegisterSectionName( "src\\drivers\\zaxxon.c", "652" );
  RegisterSectionName( "src\\drivers\\zerozone.c", "653" );
  RegisterSectionName( "src\\drivers\\zn.c", "654" );
  RegisterSectionName( "src\\drivers\\zodiack.c", "655" );
}
#pragma code_seg()
#pragma data_seg()
} // End extern "C"


