#pragma code_seg("C638")
#pragma data_seg("D638")
#pragma bss_seg("B638")
#pragma const_seg("K638")
#pragma comment(linker, "/merge:D638=638")
#pragma comment(linker, "/merge:C638=638")
#pragma comment(linker, "/merge:B638=638")
#pragma comment(linker, "/merge:K638=638")


static unsigned char text_dec1_tb[64] = {
  0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x00,
  0x99, 0x99, 0x99, 0x19, 0x19, 0x19, 0x19, 0x99, 0x00, 0x00, 0x00, 0x80, 0x80, 0x80, 0x80, 0x60,
  0x60, 0xa8, 0x60, 0xe0, 0x28, 0xe0, 0x79, 0x60, 0x60, 0x60, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0x60,
  0xa8, 0xa8, 0xa8, 0x28, 0xe0, 0xe0, 0xe0, 0x60, 0x60, 0x60, 0x60, 0xe0, 0xe0, 0xe0, 0xe0, 0x60,
};

static unsigned char text_dec2_tb[64] = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
  0x24, 0x25, 0x24, 0x61, 0x4c, 0x44, 0x64, 0x64, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x80,
  0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xc0,
  0x89, 0x89, 0xa9, 0xe8, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0x08,
};

static unsigned char text_dec3_tb[64] = {
  0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10,
  0x2c, 0x2c, 0x2c, 0x3c, 0x30, 0x30, 0x34, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x50,
  0x50, 0x27, 0x50, 0x50, 0x50, 0x50, 0x50, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x50,
  0x26, 0x23, 0x26, 0x3f, 0x50, 0x50, 0x50, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x50,
};

static unsigned char text_dec2_tb2[16] = {
  0x00, 0x00, 0x00, 0x21, 0x31, 0x31, 0x31, 0x31, 0x21, 0x21, 0x21, 0x01, 0x11, 0x11, 0x11, 0x11,
};	
  
static unsigned char text_dec3_tb2[4] = { 0x0c, 0x08, 0x04, 0x00 };
static unsigned char text_dec3_tb3[4] = { 0x03, 0x01, 0x02, 0x00 };

static unsigned char text_gm1(int adr)
{
  unsigned char x;
  x = 0xa5 ^ text_dec1_tb[adr>>10];
  if(((adr & 0xc00) == 0x800) && ((adr & 0x3ff) >= 0x3b0))
    x ^= 0x80;
  return x;
}

static unsigned char text_gm2(int adr)
{
  return 0xc0 ^ text_dec2_tb[adr>>10] ^ text_dec2_tb2[(adr >> 4)&15] ^ ((adr>>8) & 1);
}

static unsigned char text_gm3(int adr)
{
  unsigned char x = 0x60 ^ text_dec3_tb[adr>>10] ^ text_dec3_tb2[(adr >> 4)&3] ^ text_dec3_tb3[(adr >> 10)&3];
  if((adr+0x3d0) & 0x200)
    x ^= 0x80;
  if((adr & 0x3ff) >= 0x3b0)
    x ^= 0x02;
  if((adr & 0x7ff) >= 0x7b0)
    x ^= 0x01;

  return x;
}


static int text_sw1[8] = { 7, 3, 6, 5, 4, 0, 1, 2 };
static int text_sw2[8] = { 5, 0, 4, 6, 3, 2, 1, 7 };
static int text_sw3[8] = { 5, 6, 7, 4, 2, 3, 1, 0 };

static unsigned char sw8(const int *tb, unsigned char v)
{
  int i;
  unsigned char r = 0;
  for(i=0; i<8; i++)
    if(v & (1<<tb[i]))
      r |= 1<<(7-i);
  return r;
}

void seibuspi_text_decrypt(unsigned char *rom)
{
  int i;
  for(i=0; i<0x10000; i++) {
    rom[i*3]   = ~sw8(text_sw1, rom[i*3  ]^text_gm1(i));
    rom[i*3+1] = ~sw8(text_sw2, rom[i*3+1]^text_gm2(i));
    rom[i*3+2] = ~sw8(text_sw3, rom[i*3+2]^text_gm3(i));
  }
}

void seibuspi_bg_decrypt(unsigned char *rom)
{
  int i,j;
  for(j=0; j<0x600000; j+=0xc0000) {
    for(i=0; i<0x40000; i++) {
	  rom[j + (i*3)]   = ~sw8(text_sw1, rom[j + (i*3)  ]^text_gm1(i / 4));
	  rom[j + (i*3)+1] = ~sw8(text_sw2, rom[j + (i*3)+1]^text_gm2(i / 4));
	  rom[j + (i*3)+2] = ~sw8(text_sw3, rom[j + (i*3)+2]^text_gm3(i / 4));
	}
  }
}
#pragma code_seg()
#pragma data_seg()
#pragma bss_seg()
#pragma const_seg()
