#pragma code_seg("C372")
#pragma data_seg("D372")
#pragma bss_seg("B372")
#pragma const_seg("K372")
#pragma comment(linker, "/merge:D372=372")
#pragma comment(linker, "/merge:C372=372")
#pragma comment(linker, "/merge:B372=372")
#pragma comment(linker, "/merge:K372=372")
/* Hyper NeoGeo 64



currently constructed from bits of the kinst driver

not sure whats going on .. even seems to have different behavior with dynarec enabled / disabled



Known games on this system

Beast Busters 2nd Nightmare ( http://emustatus.rainemu.com/games/bbustr2nd.htm )
Buriki One ( http://emustatus.rainemu.com/games/buriki1.htm )
Fatal Fury: Wild Ambition ( http://emustatus.rainemu.com/games/ffurywa.htm )
Roads Edge ( http://emustatus.rainemu.com/games/redge.htm )
Samurai Shodown 64 ( http://emustatus.rainemu.com/games/sams64.htm )
Samurai Shodown: Warrior's Rage ( http://emustatus.rainemu.com/games/samswr.htm )
Xtreme Rally / Offbeat Racer ( http://emustatus.rainemu.com/games/xrally.htm )


pr = program
sc = scroll characters?
sd = sound
tx = textures
sp = sprites?
vt = vertex?
*/

/*

NeoGeo Hyper 64 (Main Board)
SNK, 1997

This is a 3D system comprising one large PCB with many custom smt components
on both sides, one interface PCB with JAMMA connector and sound circuitry, and
one game cartridge. Only the Main PCB and interface PCB are detailed here.

PCB No: LVS-MAC SNK 1997.06.02

Top Side

No.  PCB Label  IC Markings               IC Package
----------------------------------------------------
01   ASIC1      NEO64-REN                 QFP304
02   ASIC3      NEO64-GTE                 QFP208
03   ASIC5      NEO64-SYS                 QFP208
04   ASIC7      NEO64-BGC                 QFP240
05   ASIC8      NEO64-SPR                 QFP208
06   ASIC10     NEO64-SCC                 QFP208
07   CPU1       NEC D30200GD-100 VR4300   QFP120
08   CPU3       KL5C80A12CFP              QFP80
09   DPRAM1     DT7133 LA35J              PLCC68
10   DSP1       L7A1045 L6028 DSP-A       QFP120
11   FPGA1      ALTERA EPF10K10QC208-4    QFP208
12   FROM1      MBM29F400B-12             TSOP48 (archived as FROM1.BIN)
13   FSRAM1     TC55V1664AJ-15            SOJ44
14   FSRAM2     TC55V1664AJ-15            SOJ44
15   FSRAM3     TC55V1664AJ-15            SOJ44
16   IC4        SMC COM20020-5ILJ         PLCC28
17   OSC1       M33.333 KDS 7M            -
18   OSC2       M50.113 KDS 7L            -
19   OSC3       A33.868 KDS 7M            -
20   OSC4       A40.000 KDS 7L            -
21   PSRAM1     TC551001BFL-70L           SOP32
22   PSRAM2     TC551001BFL-70L           SOP32
23   ROM1       ALTERA EPC1PC8            DIP8   (130817 bytes, archived as ROM1.BIN)
24   SRAM5      TC55257DFL-85L            SOP28


PCB LAYOUT (TOP)
----------------
              CONN9

   ASIC1           ASIC3            CPU1

                                               DPRAM1
                        OSC2        ASIC5                 ROM1
   FSRAM1               OSC2
   FSRAM2                                             FPGA1
   FSRAM3                           ASIC10       OSC4

                                                 CPU3  IC4
   PSRAM1  ASIC7   ASIC8            DSP1 OSC3    SRAM5
   PSRAM2                                              FROM1


              CONN10



Bottom Side

No.  PCB Label  IC Markings               IC Package
----------------------------------------------------
01   ASIC2      NEO64-REN                 QFP304
02   ASIC4      NEO64-TRI2                QFP208
03   ASIC6      NEO64-CVR                 QFP120
04   ASIC9      NEO64-CAL                 QFP208
05   BROM1      MBM29F400B-12             TSOP48  (archived as BROM1.BIN)
06   CPU2       NEC D70326AGJ-16 V53A     QFP120
07   DRAM1      HY51V18164BJC-60          SOJ42
08   DRAM2      HY51V18164BJC-60          SOJ42
09   DRAM3      HY51V18164BJC-60          SOJ42
10   FSRAM4     TC55V1664AJ-15            SOJ44
11   FSRAM5     TC55V1664AJ-15            SOJ44
12   FSRAM6     TC55V1664AJ-15            SOJ44
13   PSRAM3     TC551001BFL-70L           SOP32
14   PSRAM4     TC551001BFL-70L           SOP32
15   SRAM1      TC55257DFL-85L            SOP28
16   SRAM2      TC55257DFL-85L            SOP28
17   SRAM3      TC551001BFL-70L           SOP32
18   SRAM4      TC551001BFL-70L           SOP32
19   Y1         D320L7                    XTAL

PCB LAYOUT (BOTTOM, Y-mirrored)
-------------------------------
             CONN10

 PSRAM4  ASIC9                   SRAM4     CPU1  Y1
 PSRAM3         SRAM1            SRAM3
                SRAM2

   FSRAM1                        DRAM3
   FSRAM2
   FSRAM3                        DRAM1
                   BROM1         DRAM2

   ASIC2           ASIC4         ASIC6

             CONN9



INTERFACE PCB
-------------

PCB No: LVS-JAM SNK 1999.1.20

No.  PCB Label  IC Markings               IC Package
----------------------------------------------------
01   DPRAM1     DT 71321 LA55PF           QFP64
02   IC1        MC44200FT                 QFP44
03   IOCTR1     TOSHIBA TMP87CH40N-4828   SDIP64
04   BACKUP     EPSON RTC62423            SOP24
05   BKRAM1     W24258S-70LE              SOP28
06   IC6        NEC C1891ACY              DIP20
07   BT1        3V Coin Battery
08   SW1        2 position DIPSW  OFF = JAMMA       ON = MVS
09   SW2        4 position DIPSW
10   SW3        2 position DIPSW  OFF = MONO/JAMMA  ON = 2CH MVS


PCB LAYOUT
----------

                     J A M M A



       SW3              SW1

 IC6                          IOCTR1
                              BACKUP
                              BKRAM1
       SW2   BT1  DPRAM1               IC1



Notes:
       1. The game cart plugs into the main PCB on the TOP side into CONN9 & CONN10
       2. If the game cart is not plugged in, the hardware shows nothing on screen.

*/

/*

Buriki One
SNK, 1999

This game runs on Neo Geo Hyper 64 hardware. The game cart contains nothing
except a huge pile of surface mounted ROMs on both sides of the PCB.
All of them are 32MBits each.
The cart can accept a maximum of 84 ROMs totalling for a maximun cart size of 2688MBits.

PCB Layout
----------

Top

LVS-DG2
|----------------------------------------------------------------------------|
|                         |----------------------|                           |
|                         |----------------------|                           |
|                                                                            |
|                                                                            |
| SC03A.101  SC04A.103      X          X          X          X      SD03A.79 |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| SC07A.102  SC08A.104  SP05A.106  SP06A.110  SP07A.114  SP08A.118  SD04A.80 |
|                                                                            |
|                                                                            |
|                                X          X          X          X          |
|                                                                            |
|                                                                            |
| TX04A.4    TX04A.12            X          X          X          X          |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| TX03A.3    TX03A.11            X          X          X      PR06A.86       |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| TX02A.2    TX02A.10            X          X          X      PR04A.84       |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| TX01A.1    TX01A.9             X          X          X      PR02B.82       |
|                                                                            |
|                                                                            |
|                         |----------------------|                           |
|                         |----------------------|                           |
|----------------------------------------------------------------------------|


Bottom

LVS-DG2
|----------------------------------------------------------------------------|
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| TX01A.5    TX01A.13        VT03A.19   VT02A.18   VT01A.17   PR01B.81       |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| TX02A.6    TX02A.14            X          X          X      PR03A.83       |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| TX03A.7    TX03A.15            X          X          X      PR05A.85       |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| TX04A.8    TX04A.16            X          X          X          X          |
|                                                                            |
|                                                                            |
|                                X          X          X          X          |
|                                                                            |
|                                                                            |
| SC05A.98   SC06A.100      X          X          X          X      SD02A.78 |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
| SC01A.97   SC02A.99   SP01A.105  SP02A.109  SP03A.113  SP04A.117  SD01A.77 |
|                                                                            |
|                                                                            |
|                                                                            |
|                                                                            |
|----------------------------------------------------------------------------|
Notes:
      X = Unpopulated position
      ROMs are mirrored. i.e. TX/PR/SP/SC etc ROMs line up on both sides of the PCB.
      There are 4 copies of each TX ROM on the PCB.


*/




#include "driver.h"
#include "cpu/mips/mips3.h"

/* no video yet */

static data32_t* hng64_videoram;
static struct tilemap *hng64_tilemap;


WRITE32_HANDLER( hng64_videoram_w )
{
	COMBINE_DATA(&hng64_videoram[offset]);
	tilemap_mark_tile_dirty(hng64_tilemap,offset);
}

static void get_hng64_tile_info(int tile_index)
{
	int tileno;
	tileno = hng64_videoram[tile_index];
	SET_TILE_INFO(0,tileno,0,0)
}

VIDEO_START( hng64 )
{
	hng64_tilemap = tilemap_create(get_hng64_tile_info,tilemap_scan_rows,TILEMAP_OPAQUE, 8, 8, 64,64); /* 64x64x4 = 0x4000 */

	return 0;
}

VIDEO_UPDATE( hng64 )
{
	tilemap_draw(bitmap,cliprect,hng64_tilemap,0,0);
}

/* unknown */
#define MASTER_CLOCK	50000000



static ADDRESS_MAP_START( hng_map, ADDRESS_SPACE_PROGRAM, 32 )
	AM_RANGE(0x00000000, 0x0000ffff) AM_RAM
	AM_RANGE(0x60000000, 0x60000fff) AM_RAM

	AM_RANGE(0x80008000, 0x8000ffff) AM_RAM //? copies code here and runs it if cart present?

	AM_RANGE(0x9fc00000, 0x9fc7ffff) AM_ROM AM_SHARE(2)	/* bios mirror */
	AM_RANGE(0xa0000000, 0xa03fffff) AM_RAM
	AM_RANGE(0xa4000000, 0xa7ffffff) AM_WRITENOP AM_ROM AM_REGION(REGION_USER3,0) // reads HYPER NEOGEO 64 string from 0xa4000060 but does less if its present?

	AM_RANGE(0xbf808000, 0xbf8087ff) AM_RAM
	AM_RANGE(0xbfc00000, 0xbfc7ffff) AM_WRITENOP AM_ROM AM_SHARE(2) AM_REGION(REGION_USER1, 0)
	AM_RANGE(0xc0000000, 0xc000bfff) AM_RAM
	AM_RANGE(0xc0100000, 0xc017ffff) AM_RAM

	AM_RANGE(0xc0200000, 0xc0203fff) AM_READWRITE(MRA32_RAM, hng64_videoram_w) AM_BASE(&hng64_videoram) /* "scroll RAM" (printf() is at bfc08228) */


	AM_RANGE(0xd0100000, 0xd015ffff) AM_RAM
	AM_RANGE(0xd0200000, 0xd025ffff) AM_RAM
	AM_RANGE(0xe0200000, 0xe03fffff) AM_RAM
ADDRESS_MAP_END

INPUT_PORTS_START( hng64 )
INPUT_PORTS_END



static struct GfxLayout hng64_layout =
{
	8,8,
	RGN_FRAC(1,1),
	8,
	{ 0,1,2,3,4,5,6,7 },
	{ 56, 24, 48,16,  40, 8,  32, 0 },
	{ 0*64, 1*64, 2*64, 3*64, 4*64, 5*64, 6*64, 7*64 },
	8*64
};


static struct GfxLayout hng64_16_layout =
{
	16,16,
	RGN_FRAC(1,1),
	8,
	{ 0,1,2,3,4,5,6,7 },

	{ 56, 24, 48,16,  40, 8,  32, 0,
	 1024+56, 1024+24, 1024+48,1024+16,  1024+40, 1024+8,  1024+32, 1024+0 },
	{ 0*64, 1*64, 2*64, 3*64, 4*64, 5*64, 6*64, 7*64,8*64,9*64,10*64,11*64,12*64,13*64,14*64,15*64 },
	32*64
};

/* not really much point in this, but it allows us to see the 1024x1024 texture pages */
static struct GfxLayout hng64_tex_layout =
{
	1024,1024,
	RGN_FRAC(1,1),
	8,
	{ 0,1,2,3,4,5,6,7 },
	{
	   0*8,    1*8,   2*8,     3*8,    4*8,    5*8,    6*8,    7*8, 8*8, 9*8, 10*8, 11*8, 12*8, 13*8, 14*8, 15*8,
	  16*8,   17*8,   18*8,   19*8,   20*8,   21*8,   22*8,   23*8, 24*8, 25*8, 26*8, 27*8, 28*8, 29*8, 30*8, 31*8,
	  32*8,   33*8,   34*8,   35*8,   36*8,   37*8,   38*8,   39*8, 40*8, 41*8, 42*8, 43*8, 44*8, 45*8, 46*8, 47*8,
	  48*8,   49*8,   50*8,   51*8,   52*8,   53*8,   54*8,   55*8, 56*8, 57*8, 58*8, 59*8, 60*8, 61*8, 62*8, 63*8,
	  64*8,   65*8,   66*8,   67*8,   68*8,   69*8,   70*8,   71*8, 72*8, 73*8, 74*8, 75*8, 76*8, 77*8, 78*8, 79*8,
	  80*8,   81*8,   82*8,   83*8,   84*8,   85*8,   86*8,   87*8, 88*8, 89*8, 90*8, 91*8, 92*8, 93*8, 94*8, 95*8,
	  96*8,   97*8,   98*8,   99*8,  100*8,  101*8,  102*8,  103*8, 104*8, 105*8, 106*8, 107*8, 108*8, 109*8, 110*8, 111*8,
	 112*8,  113*8,  114*8,  115*8,  116*8,  117*8,  118*8,  119*8, 120*8, 121*8, 122*8, 123*8, 124*8, 125*8, 126*8, 127*8,
	 128*8,  129*8,  130*8,  131*8,  132*8,  133*8,  134*8,  135*8, 136*8, 137*8, 138*8, 139*8, 140*8, 141*8, 142*8, 143*8,
	 144*8,  145*8,  146*8,  147*8,  148*8,  149*8,  150*8,  151*8, 152*8, 153*8, 154*8, 155*8, 156*8, 157*8, 158*8, 159*8,
	 160*8,  161*8,  162*8,  163*8,  164*8,  165*8,  166*8,  167*8, 168*8, 169*8, 170*8, 171*8, 172*8, 173*8, 174*8, 175*8,
	 176*8,  177*8,  178*8,  179*8,  180*8,  181*8,  182*8,  183*8, 184*8, 185*8, 186*8, 187*8, 188*8, 189*8, 190*8, 191*8,
	 192*8,  193*8,  194*8,  195*8,  196*8,  197*8,  198*8,  199*8, 200*8, 201*8, 202*8, 203*8, 204*8, 205*8, 206*8, 207*8,
	 208*8,  209*8,  210*8,  211*8,  212*8,  213*8,  214*8,  215*8, 216*8, 217*8, 218*8, 219*8, 220*8, 221*8, 222*8, 223*8,
	 224*8,  225*8,  226*8,  227*8,  228*8,  229*8,  230*8,  231*8, 232*8, 233*8, 234*8, 235*8, 236*8, 237*8, 238*8, 239*8,
	 240*8,  241*8,  242*8,  243*8,  244*8,  245*8,  246*8,  247*8, 248*8, 249*8, 250*8, 251*8, 252*8, 253*8, 254*8, 255*8,
	 256*8,  257*8,  258*8,  259*8,  260*8,  261*8,  262*8,  263*8, 264*8, 265*8, 266*8, 267*8, 268*8, 269*8, 270*8, 271*8,
	 272*8,  273*8,  274*8,  275*8,  276*8,  277*8,  278*8,  279*8, 280*8, 281*8, 282*8, 283*8, 284*8, 285*8, 286*8, 287*8,
	 288*8,  289*8,  290*8,  291*8,  292*8,  293*8,  294*8,  295*8, 296*8, 297*8, 298*8, 299*8, 300*8, 301*8, 302*8, 303*8,
	 304*8,  305*8,  306*8,  307*8,  308*8,  309*8,  310*8,  311*8, 312*8, 313*8, 314*8, 315*8, 316*8, 317*8, 318*8, 319*8,
	 320*8,  321*8,  322*8,  323*8,  324*8,  325*8,  326*8,  327*8, 328*8, 329*8, 330*8, 331*8, 332*8, 333*8, 334*8, 335*8,
	 336*8,  337*8,  338*8,  339*8,  340*8,  341*8,  342*8,  343*8, 344*8, 345*8, 346*8, 347*8, 348*8, 349*8, 350*8, 351*8,
	 352*8,  353*8,  354*8,  355*8,  356*8,  357*8,  358*8,  359*8, 360*8, 361*8, 362*8, 363*8, 364*8, 365*8, 366*8, 367*8,
	 368*8,  369*8,  370*8,  371*8,  372*8,  373*8,  374*8,  375*8, 376*8, 377*8, 378*8, 379*8, 380*8, 381*8, 382*8, 383*8,
	 384*8,  385*8,  386*8,  387*8,  388*8,  389*8,  390*8,  391*8, 392*8, 393*8, 394*8, 395*8, 396*8, 397*8, 398*8, 399*8,
	 400*8,  401*8,  402*8,  403*8,  404*8,  405*8,  406*8,  407*8, 408*8, 409*8, 410*8, 411*8, 412*8, 413*8, 414*8, 415*8,
	 416*8,  417*8,  418*8,  419*8,  420*8,  421*8,  422*8,  423*8, 424*8, 425*8, 426*8, 427*8, 428*8, 429*8, 430*8, 431*8,
	 432*8,  433*8,  434*8,  435*8,  436*8,  437*8,  438*8,  439*8, 440*8, 441*8, 442*8, 443*8, 444*8, 445*8, 446*8, 447*8,
	 448*8,  449*8,  450*8,  451*8,  452*8,  453*8,  454*8,  455*8, 456*8, 457*8, 458*8, 459*8, 460*8, 461*8, 462*8, 463*8,
	 464*8,  465*8,  466*8,  467*8,  468*8,  469*8,  470*8,  471*8, 472*8, 473*8, 474*8, 475*8, 476*8, 477*8, 478*8, 479*8,
	 480*8,  481*8,  482*8,  483*8,  484*8,  485*8,  486*8,  487*8, 488*8, 489*8, 490*8, 491*8, 492*8, 493*8, 494*8, 495*8,
	 496*8,  497*8,  498*8,  499*8,  500*8,  501*8,  502*8,  503*8, 504*8, 505*8, 506*8, 507*8, 508*8, 509*8, 510*8, 511*8,
	 512*8,  513*8,  514*8,  515*8,  516*8,  517*8,  518*8,  519*8, 520*8, 521*8, 522*8, 523*8, 524*8, 525*8, 526*8, 527*8,
	 528*8,  529*8,  530*8,  531*8,  532*8,  533*8,  534*8,  535*8, 536*8, 537*8, 538*8, 539*8, 540*8, 541*8, 542*8, 543*8,
	 544*8,  545*8,  546*8,  547*8,  548*8,  549*8,  550*8,  551*8, 552*8, 553*8, 554*8, 555*8, 556*8, 557*8, 558*8, 559*8,
	 560*8,  561*8,  562*8,  563*8,  564*8,  565*8,  566*8,  567*8, 568*8, 569*8, 570*8, 571*8, 572*8, 573*8, 574*8, 575*8,
	 576*8,  577*8,  578*8,  579*8,  580*8,  581*8,  582*8,  583*8, 584*8, 585*8, 586*8, 587*8, 588*8, 589*8, 590*8, 591*8,
	 592*8,  593*8,  594*8,  595*8,  596*8,  597*8,  598*8,  599*8, 600*8, 601*8, 602*8, 603*8, 604*8, 605*8, 606*8, 607*8,
	 608*8,  609*8,  610*8,  611*8,  612*8,  613*8,  614*8,  615*8, 616*8, 617*8, 618*8, 619*8, 620*8, 621*8, 622*8, 623*8,
	 624*8,  625*8,  626*8,  627*8,  628*8,  629*8,  630*8,  631*8, 632*8, 633*8, 634*8, 635*8, 636*8, 637*8, 638*8, 639*8,
	 640*8,  641*8,  642*8,  643*8,  644*8,  645*8,  646*8,  647*8, 648*8, 649*8, 650*8, 651*8, 652*8, 653*8, 654*8, 655*8,
	 656*8,  657*8,  658*8,  659*8,  660*8,  661*8,  662*8,  663*8, 664*8, 665*8, 666*8, 667*8, 668*8, 669*8, 670*8, 671*8,
	 672*8,  673*8,  674*8,  675*8,  676*8,  677*8,  678*8,  679*8, 680*8, 681*8, 682*8, 683*8, 684*8, 685*8, 686*8, 687*8,
	 688*8,  689*8,  690*8,  691*8,  692*8,  693*8,  694*8,  695*8, 696*8, 697*8, 698*8, 699*8, 700*8, 701*8, 702*8, 703*8,
	 704*8,  705*8,  706*8,  707*8,  708*8,  709*8,  710*8,  711*8, 712*8, 713*8, 714*8, 715*8, 716*8, 717*8, 718*8, 719*8,
	 720*8,  721*8,  722*8,  723*8,  724*8,  725*8,  726*8,  727*8, 728*8, 729*8, 730*8, 731*8, 732*8, 733*8, 734*8, 735*8,
	 736*8,  737*8,  738*8,  739*8,  740*8,  741*8,  742*8,  743*8, 744*8, 745*8, 746*8, 747*8, 748*8, 749*8, 750*8, 751*8,
	 752*8,  753*8,  754*8,  755*8,  756*8,  757*8,  758*8,  759*8, 760*8, 761*8, 762*8, 763*8, 764*8, 765*8, 766*8, 767*8,
	 768*8,  769*8,  770*8,  771*8,  772*8,  773*8,  774*8,  775*8, 776*8, 777*8, 778*8, 779*8, 780*8, 781*8, 782*8, 783*8,
	 784*8,  785*8,  786*8,  787*8,  788*8,  789*8,  790*8,  791*8, 792*8, 793*8, 794*8, 795*8, 796*8, 797*8, 798*8, 799*8,
	 800*8,  801*8,  802*8,  803*8,  804*8,  805*8,  806*8,  807*8, 808*8, 809*8, 810*8, 811*8, 812*8, 813*8, 814*8, 815*8,
	 816*8,  817*8,  818*8,  819*8,  820*8,  821*8,  822*8,  823*8, 824*8, 825*8, 826*8, 827*8, 828*8, 829*8, 830*8, 831*8,
	 832*8,  833*8,  834*8,  835*8,  836*8,  837*8,  838*8,  839*8, 840*8, 841*8, 842*8, 843*8, 844*8, 845*8, 846*8, 847*8,
	 848*8,  849*8,  850*8,  851*8,  852*8,  853*8,  854*8,  855*8, 856*8, 857*8, 858*8, 859*8, 860*8, 861*8, 862*8, 863*8,
	 864*8,  865*8,  866*8,  867*8,  868*8,  869*8,  870*8,  871*8, 872*8, 873*8, 874*8, 875*8, 876*8, 877*8, 878*8, 879*8,
	 880*8,  881*8,  882*8,  883*8,  884*8,  885*8,  886*8,  887*8, 888*8, 889*8, 890*8, 891*8, 892*8, 893*8, 894*8, 895*8,
	 896*8,  897*8,  898*8,  899*8,  900*8,  901*8,  902*8,  903*8, 904*8, 905*8, 906*8, 907*8, 908*8, 909*8, 910*8, 911*8,
	 912*8,  913*8,  914*8,  915*8,  916*8,  917*8,  918*8,  919*8, 920*8, 921*8, 922*8, 923*8, 924*8, 925*8, 926*8, 927*8,
	 928*8,  929*8,  930*8,  931*8,  932*8,  933*8,  934*8,  935*8, 936*8, 937*8, 938*8, 939*8, 940*8, 941*8, 942*8, 943*8,
	 944*8,  945*8,  946*8,  947*8,  948*8,  949*8,  950*8,  951*8, 952*8, 953*8, 954*8, 955*8, 956*8, 957*8, 958*8, 959*8,
	 960*8,  961*8,  962*8,  963*8,  964*8,  965*8,  966*8,  967*8, 968*8, 969*8, 970*8, 971*8, 972*8, 973*8, 974*8, 975*8,
	 976*8,  977*8,  978*8,  979*8,  980*8,  981*8,  982*8,  983*8, 984*8, 985*8, 986*8, 987*8, 988*8, 989*8, 990*8, 991*8,
	 992*8,  993*8,  994*8,  995*8,  996*8,  997*8,  998*8,  999*8, 1000*8, 1001*8, 1002*8, 1003*8, 1004*8, 1005*8, 1006*8, 1007*8,
	1008*8, 1009*8, 1010*8, 1011*8, 1012*8, 1013*8, 1014*8, 1015*8, 1016*8, 1017*8, 1018*8, 1019*8, 1020*8, 1021*8, 1022*8, 1023*8,
	},
	{
	0*8192, 1*8192, 2*8192, 3*8192, 4*8192, 5*8192, 6*8192, 7*8192, 8*8192, 9*8192, 10*8192, 11*8192, 12*8192, 13*8192, 14*8192, 15*8192,
	16*8192, 17*8192, 18*8192, 19*8192, 20*8192, 21*8192, 22*8192, 23*8192, 24*8192, 25*8192, 26*8192, 27*8192, 28*8192, 29*8192, 30*8192, 31*8192,
	32*8192, 33*8192, 34*8192, 35*8192, 36*8192, 37*8192, 38*8192, 39*8192, 40*8192, 41*8192, 42*8192, 43*8192, 44*8192, 45*8192, 46*8192, 47*8192,
	48*8192, 49*8192, 50*8192, 51*8192, 52*8192, 53*8192, 54*8192, 55*8192, 56*8192, 57*8192, 58*8192, 59*8192, 60*8192, 61*8192, 62*8192, 63*8192,
	64*8192, 65*8192, 66*8192, 67*8192, 68*8192, 69*8192, 70*8192, 71*8192, 72*8192, 73*8192, 74*8192, 75*8192, 76*8192, 77*8192, 78*8192, 79*8192,
	80*8192, 81*8192, 82*8192, 83*8192, 84*8192, 85*8192, 86*8192, 87*8192, 88*8192, 89*8192, 90*8192, 91*8192, 92*8192, 93*8192, 94*8192, 95*8192,
	96*8192, 97*8192, 98*8192, 99*8192, 100*8192, 101*8192, 102*8192, 103*8192, 104*8192, 105*8192, 106*8192, 107*8192, 108*8192, 109*8192, 110*8192, 111*8192,
	112*8192, 113*8192, 114*8192, 115*8192, 116*8192, 117*8192, 118*8192, 119*8192, 120*8192, 121*8192, 122*8192, 123*8192, 124*8192, 125*8192, 126*8192, 127*8192,
	128*8192, 129*8192, 130*8192, 131*8192, 132*8192, 133*8192, 134*8192, 135*8192, 136*8192, 137*8192, 138*8192, 139*8192, 140*8192, 141*8192, 142*8192, 143*8192,
	144*8192, 145*8192, 146*8192, 147*8192, 148*8192, 149*8192, 150*8192, 151*8192, 152*8192, 153*8192, 154*8192, 155*8192, 156*8192, 157*8192, 158*8192, 159*8192,
	160*8192, 161*8192, 162*8192, 163*8192, 164*8192, 165*8192, 166*8192, 167*8192, 168*8192, 169*8192, 170*8192, 171*8192, 172*8192, 173*8192, 174*8192, 175*8192,
	176*8192, 177*8192, 178*8192, 179*8192, 180*8192, 181*8192, 182*8192, 183*8192, 184*8192, 185*8192, 186*8192, 187*8192, 188*8192, 189*8192, 190*8192, 191*8192,
	192*8192, 193*8192, 194*8192, 195*8192, 196*8192, 197*8192, 198*8192, 199*8192, 200*8192, 201*8192, 202*8192, 203*8192, 204*8192, 205*8192, 206*8192, 207*8192,
	208*8192, 209*8192, 210*8192, 211*8192, 212*8192, 213*8192, 214*8192, 215*8192, 216*8192, 217*8192, 218*8192, 219*8192, 220*8192, 221*8192, 222*8192, 223*8192,
	224*8192, 225*8192, 226*8192, 227*8192, 228*8192, 229*8192, 230*8192, 231*8192, 232*8192, 233*8192, 234*8192, 235*8192, 236*8192, 237*8192, 238*8192, 239*8192,
	240*8192, 241*8192, 242*8192, 243*8192, 244*8192, 245*8192, 246*8192, 247*8192, 248*8192, 249*8192, 250*8192, 251*8192, 252*8192, 253*8192, 254*8192, 255*8192,
	256*8192, 257*8192, 258*8192, 259*8192, 260*8192, 261*8192, 262*8192, 263*8192, 264*8192, 265*8192, 266*8192, 267*8192, 268*8192, 269*8192, 270*8192, 271*8192,
	272*8192, 273*8192, 274*8192, 275*8192, 276*8192, 277*8192, 278*8192, 279*8192, 280*8192, 281*8192, 282*8192, 283*8192, 284*8192, 285*8192, 286*8192, 287*8192,
	288*8192, 289*8192, 290*8192, 291*8192, 292*8192, 293*8192, 294*8192, 295*8192, 296*8192, 297*8192, 298*8192, 299*8192, 300*8192, 301*8192, 302*8192, 303*8192,
	304*8192, 305*8192, 306*8192, 307*8192, 308*8192, 309*8192, 310*8192, 311*8192, 312*8192, 313*8192, 314*8192, 315*8192, 316*8192, 317*8192, 318*8192, 319*8192,
	320*8192, 321*8192, 322*8192, 323*8192, 324*8192, 325*8192, 326*8192, 327*8192, 328*8192, 329*8192, 330*8192, 331*8192, 332*8192, 333*8192, 334*8192, 335*8192,
	336*8192, 337*8192, 338*8192, 339*8192, 340*8192, 341*8192, 342*8192, 343*8192, 344*8192, 345*8192, 346*8192, 347*8192, 348*8192, 349*8192, 350*8192, 351*8192,
	352*8192, 353*8192, 354*8192, 355*8192, 356*8192, 357*8192, 358*8192, 359*8192, 360*8192, 361*8192, 362*8192, 363*8192, 364*8192, 365*8192, 366*8192, 367*8192,
	368*8192, 369*8192, 370*8192, 371*8192, 372*8192, 373*8192, 374*8192, 375*8192, 376*8192, 377*8192, 378*8192, 379*8192, 380*8192, 381*8192, 382*8192, 383*8192,
	384*8192, 385*8192, 386*8192, 387*8192, 388*8192, 389*8192, 390*8192, 391*8192, 392*8192, 393*8192, 394*8192, 395*8192, 396*8192, 397*8192, 398*8192, 399*8192,
	400*8192, 401*8192, 402*8192, 403*8192, 404*8192, 405*8192, 406*8192, 407*8192, 408*8192, 409*8192, 410*8192, 411*8192, 412*8192, 413*8192, 414*8192, 415*8192,
	416*8192, 417*8192, 418*8192, 419*8192, 420*8192, 421*8192, 422*8192, 423*8192, 424*8192, 425*8192, 426*8192, 427*8192, 428*8192, 429*8192, 430*8192, 431*8192,
	432*8192, 433*8192, 434*8192, 435*8192, 436*8192, 437*8192, 438*8192, 439*8192, 440*8192, 441*8192, 442*8192, 443*8192, 444*8192, 445*8192, 446*8192, 447*8192,
	448*8192, 449*8192, 450*8192, 451*8192, 452*8192, 453*8192, 454*8192, 455*8192, 456*8192, 457*8192, 458*8192, 459*8192, 460*8192, 461*8192, 462*8192, 463*8192,
	464*8192, 465*8192, 466*8192, 467*8192, 468*8192, 469*8192, 470*8192, 471*8192, 472*8192, 473*8192, 474*8192, 475*8192, 476*8192, 477*8192, 478*8192, 479*8192,
	480*8192, 481*8192, 482*8192, 483*8192, 484*8192, 485*8192, 486*8192, 487*8192, 488*8192, 489*8192, 490*8192, 491*8192, 492*8192, 493*8192, 494*8192, 495*8192,
	496*8192, 497*8192, 498*8192, 499*8192, 500*8192, 501*8192, 502*8192, 503*8192, 504*8192, 505*8192, 506*8192, 507*8192, 508*8192, 509*8192, 510*8192, 511*8192,
	512*8192, 513*8192, 514*8192, 515*8192, 516*8192, 517*8192, 518*8192, 519*8192, 520*8192, 521*8192, 522*8192, 523*8192, 524*8192, 525*8192, 526*8192, 527*8192,
	528*8192, 529*8192, 530*8192, 531*8192, 532*8192, 533*8192, 534*8192, 535*8192, 536*8192, 537*8192, 538*8192, 539*8192, 540*8192, 541*8192, 542*8192, 543*8192,
	544*8192, 545*8192, 546*8192, 547*8192, 548*8192, 549*8192, 550*8192, 551*8192, 552*8192, 553*8192, 554*8192, 555*8192, 556*8192, 557*8192, 558*8192, 559*8192,
	560*8192, 561*8192, 562*8192, 563*8192, 564*8192, 565*8192, 566*8192, 567*8192, 568*8192, 569*8192, 570*8192, 571*8192, 572*8192, 573*8192, 574*8192, 575*8192,
	576*8192, 577*8192, 578*8192, 579*8192, 580*8192, 581*8192, 582*8192, 583*8192, 584*8192, 585*8192, 586*8192, 587*8192, 588*8192, 589*8192, 590*8192, 591*8192,
	592*8192, 593*8192, 594*8192, 595*8192, 596*8192, 597*8192, 598*8192, 599*8192, 600*8192, 601*8192, 602*8192, 603*8192, 604*8192, 605*8192, 606*8192, 607*8192,
	608*8192, 609*8192, 610*8192, 611*8192, 612*8192, 613*8192, 614*8192, 615*8192, 616*8192, 617*8192, 618*8192, 619*8192, 620*8192, 621*8192, 622*8192, 623*8192,
	624*8192, 625*8192, 626*8192, 627*8192, 628*8192, 629*8192, 630*8192, 631*8192, 632*8192, 633*8192, 634*8192, 635*8192, 636*8192, 637*8192, 638*8192, 639*8192,
	640*8192, 641*8192, 642*8192, 643*8192, 644*8192, 645*8192, 646*8192, 647*8192, 648*8192, 649*8192, 650*8192, 651*8192, 652*8192, 653*8192, 654*8192, 655*8192,
	656*8192, 657*8192, 658*8192, 659*8192, 660*8192, 661*8192, 662*8192, 663*8192, 664*8192, 665*8192, 666*8192, 667*8192, 668*8192, 669*8192, 670*8192, 671*8192,
	672*8192, 673*8192, 674*8192, 675*8192, 676*8192, 677*8192, 678*8192, 679*8192, 680*8192, 681*8192, 682*8192, 683*8192, 684*8192, 685*8192, 686*8192, 687*8192,
	688*8192, 689*8192, 690*8192, 691*8192, 692*8192, 693*8192, 694*8192, 695*8192, 696*8192, 697*8192, 698*8192, 699*8192, 700*8192, 701*8192, 702*8192, 703*8192,
	704*8192, 705*8192, 706*8192, 707*8192, 708*8192, 709*8192, 710*8192, 711*8192, 712*8192, 713*8192, 714*8192, 715*8192, 716*8192, 717*8192, 718*8192, 719*8192,
	720*8192, 721*8192, 722*8192, 723*8192, 724*8192, 725*8192, 726*8192, 727*8192, 728*8192, 729*8192, 730*8192, 731*8192, 732*8192, 733*8192, 734*8192, 735*8192,
	736*8192, 737*8192, 738*8192, 739*8192, 740*8192, 741*8192, 742*8192, 743*8192, 744*8192, 745*8192, 746*8192, 747*8192, 748*8192, 749*8192, 750*8192, 751*8192,
	752*8192, 753*8192, 754*8192, 755*8192, 756*8192, 757*8192, 758*8192, 759*8192, 760*8192, 761*8192, 762*8192, 763*8192, 764*8192, 765*8192, 766*8192, 767*8192,
	768*8192, 769*8192, 770*8192, 771*8192, 772*8192, 773*8192, 774*8192, 775*8192, 776*8192, 777*8192, 778*8192, 779*8192, 780*8192, 781*8192, 782*8192, 783*8192,
	784*8192, 785*8192, 786*8192, 787*8192, 788*8192, 789*8192, 790*8192, 791*8192, 792*8192, 793*8192, 794*8192, 795*8192, 796*8192, 797*8192, 798*8192, 799*8192,
	800*8192, 801*8192, 802*8192, 803*8192, 804*8192, 805*8192, 806*8192, 807*8192, 808*8192, 809*8192, 810*8192, 811*8192, 812*8192, 813*8192, 814*8192, 815*8192,
	816*8192, 817*8192, 818*8192, 819*8192, 820*8192, 821*8192, 822*8192, 823*8192, 824*8192, 825*8192, 826*8192, 827*8192, 828*8192, 829*8192, 830*8192, 831*8192,
	832*8192, 833*8192, 834*8192, 835*8192, 836*8192, 837*8192, 838*8192, 839*8192, 840*8192, 841*8192, 842*8192, 843*8192, 844*8192, 845*8192, 846*8192, 847*8192,
	848*8192, 849*8192, 850*8192, 851*8192, 852*8192, 853*8192, 854*8192, 855*8192, 856*8192, 857*8192, 858*8192, 859*8192, 860*8192, 861*8192, 862*8192, 863*8192,
	864*8192, 865*8192, 866*8192, 867*8192, 868*8192, 869*8192, 870*8192, 871*8192, 872*8192, 873*8192, 874*8192, 875*8192, 876*8192, 877*8192, 878*8192, 879*8192,
	880*8192, 881*8192, 882*8192, 883*8192, 884*8192, 885*8192, 886*8192, 887*8192, 888*8192, 889*8192, 890*8192, 891*8192, 892*8192, 893*8192, 894*8192, 895*8192,
	896*8192, 897*8192, 898*8192, 899*8192, 900*8192, 901*8192, 902*8192, 903*8192, 904*8192, 905*8192, 906*8192, 907*8192, 908*8192, 909*8192, 910*8192, 911*8192,
	912*8192, 913*8192, 914*8192, 915*8192, 916*8192, 917*8192, 918*8192, 919*8192, 920*8192, 921*8192, 922*8192, 923*8192, 924*8192, 925*8192, 926*8192, 927*8192,
	928*8192, 929*8192, 930*8192, 931*8192, 932*8192, 933*8192, 934*8192, 935*8192, 936*8192, 937*8192, 938*8192, 939*8192, 940*8192, 941*8192, 942*8192, 943*8192,
	944*8192, 945*8192, 946*8192, 947*8192, 948*8192, 949*8192, 950*8192, 951*8192, 952*8192, 953*8192, 954*8192, 955*8192, 956*8192, 957*8192, 958*8192, 959*8192,
	960*8192, 961*8192, 962*8192, 963*8192, 964*8192, 965*8192, 966*8192, 967*8192, 968*8192, 969*8192, 970*8192, 971*8192, 972*8192, 973*8192, 974*8192, 975*8192,
	976*8192, 977*8192, 978*8192, 979*8192, 980*8192, 981*8192, 982*8192, 983*8192, 984*8192, 985*8192, 986*8192, 987*8192, 988*8192, 989*8192, 990*8192, 991*8192,
	992*8192, 993*8192, 994*8192, 995*8192, 996*8192, 997*8192, 998*8192, 999*8192, 1000*8192, 1001*8192, 1002*8192, 1003*8192, 1004*8192, 1005*8192, 1006*8192, 1007*8192,
	1008*8192, 1009*8192, 1010*8192, 1011*8192, 1012*8192, 1013*8192, 1014*8192, 1015*8192, 1016*8192, 1017*8192, 1018*8192, 1019*8192, 1020*8192, 1021*8192, 1022*8192, 1023*8192,
	},
	1024*8192
};

static struct GfxDecodeInfo gfxdecodeinfo[] =
{
	{ REGION_GFX1, 0, &hng64_layout,     0x0, 2 }, /* scrolltiles */
	{ REGION_GFX1, 0, &hng64_16_layout,  0x0, 2 }, /* scroll tiles */
	{ REGION_GFX2, 0, &hng64_layout,     0x0, 2 }, /* sprite tiles */
	{ REGION_GFX2, 0, &hng64_16_layout,  0x0, 2 }, /* sprite tiles */

	{ REGION_GFX3, 0, &hng64_tex_layout, 0x0, 2 }, /* texture pages */
	{ -1 } /* end of array */
};

DRIVER_INIT(hng64)
{
}

/* ?? */
static struct mips3_config config =
{
	16384,				/* code cache size */
	16384				/* data cache size */
};


MACHINE_DRIVER_START( hng64 )

	/* basic machine hardware */
	MDRV_CPU_ADD(R4600BE, MASTER_CLOCK/2)  /* actually R4300 ? */
	MDRV_CPU_CONFIG(config)
	MDRV_CPU_PROGRAM_MAP(hng_map, 0)
//	MDRV_CPU_VBLANK_INT(irq0_start,1)

	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	MDRV_GFXDECODE(gfxdecodeinfo)

	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
	MDRV_SCREEN_SIZE(768, 512)
	MDRV_VISIBLE_AREA(0, 767, 0, 511)
	MDRV_PALETTE_LENGTH(0x200)

	MDRV_VIDEO_START(hng64)
	MDRV_VIDEO_UPDATE(hng64)
MACHINE_DRIVER_END

ROM_START( hng64 )
	ROM_REGION32_BE( 0x0100000, REGION_USER1, 0 ) /* 512k for R4000 BIOS code */
	ROM_LOAD ( "brom1.bin", 0x000000, 0x080000,  CRC(a30dd3de) SHA1(3e2fd0a56214e6f5dcb93687e409af13d065ea30) )
	ROM_REGION( 0x0100000, REGION_USER2, 0 ) /* unknown / unused bios roms */
	ROM_LOAD ( "from1.bin", 0x000000, 0x080000,  CRC(6b933005) SHA1(e992747f46c48b66e5509fe0adf19c91250b00c7) )
	ROM_LOAD ( "rom1.bin",  0x000000, 0x01ff32,  CRC(4a6832dc) SHA1(ae504f7733c2f40450157cd1d3b85bc83fac8569) )
ROM_END


ROM_START( buriki )
	ROM_REGION( 0x80000, REGION_CPU1, 0 )		/* dummy region for R4000 */

	/* BIOS */
	ROM_REGION32_BE( 0x0100000, REGION_USER1, 0 ) /* 512k for R4000 BIOS code */
	ROM_LOAD ( "brom1.bin", 0x000000, 0x080000,  CRC(a30dd3de) SHA1(3e2fd0a56214e6f5dcb93687e409af13d065ea30) )
	ROM_REGION( 0x0100000, REGION_USER2, 0 ) /* unknown / unused bios roms */
	ROM_LOAD ( "from1.bin", 0x000000, 0x080000,  CRC(6b933005) SHA1(e992747f46c48b66e5509fe0adf19c91250b00c7) )
	ROM_LOAD ( "rom1.bin",  0x000000, 0x01ff32,  CRC(4a6832dc) SHA1(ae504f7733c2f40450157cd1d3b85bc83fac8569) )
	/* END BIOS */

	ROM_REGION32_LE( 0x1800000, REGION_USER3, 0 ) /* Program Code, mapped at ??? maybe banked?  LE? */
	ROM_LOAD32_WORD( "007pr01b.81", 0x0000000, 0x400000, CRC(a31202f5) SHA1(c657729b292d394ced021a0201a1c5608a7118ba) )
	ROM_LOAD32_WORD( "007pr02b.82", 0x0000002, 0x400000, CRC(a563fed6) SHA1(9af9a021beb814e35df968abe5a99225a124b5eb) )
	ROM_LOAD32_WORD( "007pr03a.83", 0x0800000, 0x400000, CRC(da5f6105) SHA1(5424cf5289cef66e301e968b4394e551918fe99b) )
	ROM_LOAD32_WORD( "007pr04a.84", 0x0800002, 0x400000, CRC(befc7bce) SHA1(83d9ecf944e03a40cf25ee288077c2265d6a588a) )
	ROM_LOAD32_WORD( "007pr05a.85", 0x1000000, 0x400000, CRC(013e28bc) SHA1(45e5ac45b42b26957c2877ac1042472c4b5ec914) )
	ROM_LOAD32_WORD( "007pr06a.86", 0x1000002, 0x400000, CRC(0620fccc) SHA1(e0bffc56b019c79276a4ef5ec7354edda15b0889) )

	/* Scroll Characters 8x8x8 / 16x16x8 */
	ROM_REGION( 0x2000000, REGION_GFX1, 0 )
	ROM_LOAD32_BYTE( "007sc01a.97", 0x0000000, 0x400000, CRC(21dfb5bc) SHA1(0daa6c105e1b95bb354df5f26862f1d2824be61f) )
	ROM_LOAD32_BYTE( "007sc02a.99", 0x0000001, 0x400000, CRC(c41579e8) SHA1(3bc7949e3367b2e1c5c6473d66836fb57b57faee) )
	ROM_LOAD32_BYTE( "007sc03a.101",0x0000002, 0x400000, CRC(71d3c241) SHA1(76c6b27be23ab57d3298bddecd20ac18e56b4f76) )
	ROM_LOAD32_BYTE( "007sc04a.103",0x0000003, 0x400000, CRC(69dac894) SHA1(6d87a307ddde0908e3108a72ce3659cfba29bf43) )
	ROM_LOAD32_BYTE( "007sc05a.98", 0x1000000, 0x400000, CRC(27f848c1) SHA1(2ee9cca4e68e56c7c17c8e2d7e0f55a34a5960bd) )
	ROM_LOAD32_BYTE( "007sc06a.100",0x1000001, 0x400000, CRC(c39e9b4c) SHA1(3c8a0494c2a6866ecc0df2c551619c57ee072440) )
	ROM_LOAD32_BYTE( "007sc07a.102",0x1000002, 0x400000, CRC(753e7e3d) SHA1(39b2e9fd23878d8fc4f98fe88b466e963d8fc959) )
	ROM_LOAD32_BYTE( "007sc08a.104",0x1000003, 0x400000, CRC(b605928e) SHA1(558042b84115273fa581606daafba0e9688fa002) )

	/* Sprite Characters - 8x8x8 / 16x16x8 */
	ROM_REGION( 0x2000000, REGION_GFX2, 0 )
	ROM_LOAD32_BYTE( "007sp01a.105",0x0000000, 0x400000, CRC(5b5f4850) SHA1(7e81f5c7ceb75f5c7701528735d7664847103cb9) )
	ROM_LOAD32_BYTE( "007sp02a.109",0x0000001, 0x400000, CRC(cf3ced64) SHA1(5964cb2723ddf9e7c53c06e10c59c80d305de79d) )
	ROM_LOAD32_BYTE( "007sp03a.113",0x0000002, 0x400000, CRC(25c8e7d4) SHA1(f3648e81bc8275e3abe8e018a7eab7303f34ec18) )
	ROM_LOAD32_BYTE( "007sp04a.117",0x0000003, 0x400000, CRC(7c8cb382) SHA1(de4dfdf834e6da7c4bafe8d34c940f9dfa2de998) )
	ROM_LOAD32_BYTE( "007sp05a.106",0x1000000, 0x400000, CRC(32d2fa41) SHA1(b16a0bbd397be2a8d532c85951b924e2e086a189) )
	ROM_LOAD32_BYTE( "007sp06a.110",0x1000001, 0x400000, CRC(b6f8d7f3) SHA1(70ce94f2193ee39218022da617413c42f6753574) )
	ROM_LOAD32_BYTE( "007sp07a.114",0x1000002, 0x400000, CRC(5caa1cc9) SHA1(3e40b10ea3bcf1239d0015da4be869632b805ddd) )
	ROM_LOAD32_BYTE( "007sp08a.118",0x1000003, 0x400000, CRC(7a158c67) SHA1(d66f4920a513208d45b908a1934d9afb894debf1) )

	/* Textures - 1024x1024x8 pages? */
	ROM_REGION( 0x1000000, REGION_GFX3, 0 )
	/* note: same roms are at different positions on the board, repeated a total of 4 times*/
	ROM_LOAD( "007tx01a.1", 0x0000000, 0x400000, CRC(a7774075) SHA1(4f3da9af131a7efb0f0a5180da57c19c65fffb82) )
	ROM_LOAD( "007tx02a.2", 0x0400000, 0x400000, CRC(bc05d5fd) SHA1(84e3fafcebdeb1e2ffae80785949c973a14055d8) )
	ROM_LOAD( "007tx03a.3", 0x0800000, 0x400000, CRC(da9484fb) SHA1(f54b669a66400df00bf25436e5fd5c9bf68dbd55) )
	ROM_LOAD( "007tx04a.4", 0x0c00000, 0x400000, CRC(02aa3f46) SHA1(1fca89c70586f8ebcdf669ecac121afa5cdf623f) )
	ROM_LOAD( "007tx01a.5", 0x0000000, 0x400000, CRC(a7774075) SHA1(4f3da9af131a7efb0f0a5180da57c19c65fffb82) )
	ROM_LOAD( "007tx02a.6", 0x0400000, 0x400000, CRC(bc05d5fd) SHA1(84e3fafcebdeb1e2ffae80785949c973a14055d8) )
	ROM_LOAD( "007tx03a.7", 0x0800000, 0x400000, CRC(da9484fb) SHA1(f54b669a66400df00bf25436e5fd5c9bf68dbd55) )
	ROM_LOAD( "007tx04a.8", 0x0c00000, 0x400000, CRC(02aa3f46) SHA1(1fca89c70586f8ebcdf669ecac121afa5cdf623f) )
	ROM_LOAD( "007tx01a.9", 0x0000000, 0x400000, CRC(a7774075) SHA1(4f3da9af131a7efb0f0a5180da57c19c65fffb82) )
	ROM_LOAD( "007tx02a.10",0x0400000, 0x400000, CRC(bc05d5fd) SHA1(84e3fafcebdeb1e2ffae80785949c973a14055d8) )
	ROM_LOAD( "007tx03a.11",0x0800000, 0x400000, CRC(da9484fb) SHA1(f54b669a66400df00bf25436e5fd5c9bf68dbd55) )
	ROM_LOAD( "007tx04a.12",0x0c00000, 0x400000, CRC(02aa3f46) SHA1(1fca89c70586f8ebcdf669ecac121afa5cdf623f) )
	ROM_LOAD( "007tx01a.13",0x0000000, 0x400000, CRC(a7774075) SHA1(4f3da9af131a7efb0f0a5180da57c19c65fffb82) )
	ROM_LOAD( "007tx02a.14",0x0400000, 0x400000, CRC(bc05d5fd) SHA1(84e3fafcebdeb1e2ffae80785949c973a14055d8) )
	ROM_LOAD( "007tx03a.15",0x0800000, 0x400000, CRC(da9484fb) SHA1(f54b669a66400df00bf25436e5fd5c9bf68dbd55) )
	ROM_LOAD( "007tx04a.16",0x0c00000, 0x400000, CRC(02aa3f46) SHA1(1fca89c70586f8ebcdf669ecac121afa5cdf623f) )

	ROM_REGION( 0x0c00000, REGION_GFX4, 0 ) /* Vertex / 3d roms? */
	/* they seem to interleave together, but there are only 3, x, y and z maybe? */
	ROM_LOAD( "007vt01a.17", 0x0000000, 0x400000, CRC(f78a0376) SHA1(fde4ddd4bf326ae5f1ed10311c237b13b62e060c) )
	ROM_LOAD( "007vt02a.18", 0x0400000, 0x400000, CRC(f365f608) SHA1(035fd9b829b7720c4aee6fdf204c080e6157994f) )
	ROM_LOAD( "007vt03a.19", 0x0800000, 0x400000, CRC(ba05654d) SHA1(b7fe532732c0af7860c8eded3c5abd304d74e08e) )

	ROM_REGION( 0x1000000, REGION_SOUND1, 0 ) /* Sound Samples? */
	ROM_LOAD( "007sd01a.77", 0x0000000, 0x400000, CRC(1afb48c6) SHA1(b072d4fe72d6c5267864818d300b32e85b426213) )
	ROM_LOAD( "007sd02a.78", 0x0400000, 0x400000, CRC(c65f1dd5) SHA1(7f504c585a10c1090dbd1ac31a3a0db920c992a0) )
	ROM_LOAD( "007sd03a.79", 0x0800000, 0x400000, CRC(356f25c8) SHA1(5250865900894232960686f40c5da35b3868b78c) )
	ROM_LOAD( "007sd04a.80", 0x0800000, 0x400000, CRC(dabfbbad) SHA1(7d58d5181705618e0e2d69c6fdb81b9b3d2b9e0f) )
ROM_END

/* Bios */
GAMEX( 1997, hng64,  0,        hng64, hng64, 0,     ROT0, "SNK", "Hyper NeoGeo 64 Bios", GAME_NOT_WORKING|GAME_NO_SOUND|NOT_A_DRIVER )

/* Games */
GAMEX( 1999, buriki, hng64,    hng64, hng64, hng64, ROT0, "SNK", "Buriki One", GAME_NOT_WORKING|GAME_NO_SOUND )
#pragma code_seg()
#pragma data_seg()
#pragma bss_seg()
#pragma const_seg()
