/**

  * \file      XBESectionUtil.cpp

  * \brief     Registration of Driver/CPU files for creation and usage of XBOX

  *             loadable sections

  *

  * \note      This file is autogenerated via Sectionize.pl, so any

  *               changes will probably be lost.

  */



//= I N C L U D E S ====================================================
#include "MAMEoX.h"
#include <stdio.h>
#include <map>
#include <string>
#include "DebugLogger.h"


extern "C" {
#include "osd_cpu.h"
#include "cpuintrf.h"
}


//= D E F I N E S ======================================================

struct driverSectionRegistration_t 
{
		// For some reason making these a const char, then unloading
		// the DRVSNIZE will cause a crash in retail mode. I'm not at
		// all sure exactly why this is yet, my only guess is that there
		// is something odd about how quoted constants in initializers are
		// placed into the XBE section.
  //const char *m_driverName;
  //const char *m_sectionName;
	char	m_driverName[16];
	char	m_sectionName[8];
};


#define REGISTER_DRIVERSECTION( driverName, sectionName )     { driverName, sectionName }



//= G L O B A L = V A R S ==============================================
static std::map< UINT, std::string >         g_CPUIDToSectionMap;

static BOOL																	 g_driverSectionizerLoaded = TRUE;
static BOOL																	 g_cpuSectionizerLoaded = TRUE;

//= P R O T O T Y P E S ================================================
extern "C" static void RegisterCPUSectionNames( void );


//= F U N C T I O N S ==================================================
extern "C" {

//-------------------------------------------------------------
//	InitDriverSectionizer
//-------------------------------------------------------------
void InitDriverSectionizer( void )
{
	if( !g_driverSectionizerLoaded )
	{
		if( !XLoadSection( "DRVSNIZE" ) )
		{
			PRINTMSG(( T_ERROR, "XLoadSection failed! 0x%X\r\n", GetLastError() ));
		}
		else
			g_driverSectionizerLoaded = TRUE;
	}
}


//-------------------------------------------------------------
//	TerminateDriverSectionizer
//-------------------------------------------------------------
void TerminateDriverSectionizer( void )
{
  if( !XFreeSection( "DRVSNIZE" ) )
	{
		PRINTMSG(( T_ERROR, "XFreeSection failed! 0x%X\r\n", GetLastError() ));
	}
	else
		g_driverSectionizerLoaded = FALSE;
}

//-------------------------------------------------------------
//	InitCPUSectionizer
//-------------------------------------------------------------
void InitCPUSectionizer( void )
{
  g_CPUIDToSectionMap.clear();

	if( !g_cpuSectionizerLoaded )
	{
		if( !XLoadSection( "CPUSNIZE" ) )
		{
			PRINTMSG(( T_ERROR, "XLoadSection failed! 0x%X\r\n", GetLastError() ));
		}
		else
			g_cpuSectionizerLoaded = TRUE;
	}
  RegisterCPUSectionNames();
}

//-------------------------------------------------------------
//	TerminateCPUSectionizer
//-------------------------------------------------------------
void TerminateCPUSectionizer( void )
{
  g_CPUIDToSectionMap.clear();
  if( !XFreeSection( "CPUSNIZE" ) )
	{
		PRINTMSG(( T_ERROR, "XFreeSection failed! 0x%X\r\n", GetLastError() ));
	}
	else
		g_cpuSectionizerLoaded = FALSE;
}


#pragma code_seg("DRVCSNZE")
#pragma data_seg("DRVDSNZE")
#pragma bss_seg("DRVBSNZE")
#pragma const_seg("DRVKSNZE")
#pragma comment(linker, "/merge:DRVDSNZE=DRVSNIZE")
#pragma comment(linker, "/merge:DRVCSNZE=DRVSNIZE")
#pragma comment(linker, "/merge:DRVBSNZE=DRVSNIZE")
#pragma comment(linker, "/merge:DRVKSNZE=DRVSNIZE")

#define   NUM_DRIVERSECTIONS				753

static const driverSectionRegistration_t			g_driverSectionRegistry[NUM_DRIVERSECTIONS] = { 

           REGISTER_DRIVERSECTION( "1942.c", "99" ),

           REGISTER_DRIVERSECTION( "1943.c", "100" ),

           REGISTER_DRIVERSECTION( "1945kiii.c", "101" ),

           REGISTER_DRIVERSECTION( "40love.c", "1" ),

           REGISTER_DRIVERSECTION( "4enraya.c", "103" ),

           REGISTER_DRIVERSECTION( "8080bw.c", "2" ),

           REGISTER_DRIVERSECTION( "88games.c", "105" ),

           REGISTER_DRIVERSECTION( "aburner.c", "3" ),

           REGISTER_DRIVERSECTION( "ace.c", "107" ),

           REGISTER_DRIVERSECTION( "actfancr.c", "4" ),

           REGISTER_DRIVERSECTION( "aeroboto.c", "109" ),

           REGISTER_DRIVERSECTION( "aerofgt.c", "110" ),

           REGISTER_DRIVERSECTION( "afega.c", "111" ),

           REGISTER_DRIVERSECTION( "airbustr.c", "112" ),

           REGISTER_DRIVERSECTION( "ajax.c", "113" ),

           REGISTER_DRIVERSECTION( "aliens.c", "114" ),

           REGISTER_DRIVERSECTION( "alpha68k.c", "115" ),

           REGISTER_DRIVERSECTION( "ambush.c", "116" ),

           REGISTER_DRIVERSECTION( "amidar.c", "5" ),

           REGISTER_DRIVERSECTION( "amspdwy.c", "118" ),

           REGISTER_DRIVERSECTION( "angelkds.c", "119" ),

           REGISTER_DRIVERSECTION( "appoooh.c", "120" ),

           REGISTER_DRIVERSECTION( "aquarium.c", "121" ),

           REGISTER_DRIVERSECTION( "arabian.c", "122" ),

           REGISTER_DRIVERSECTION( "arcadecl.c", "6" ),

           REGISTER_DRIVERSECTION( "argus.c", "124" ),

           REGISTER_DRIVERSECTION( "arkanoid.c", "125" ),

           REGISTER_DRIVERSECTION( "armedf.c", "126" ),

           REGISTER_DRIVERSECTION( "artmagic.c", "7" ),

           REGISTER_DRIVERSECTION( "ashnojoe.c", "128" ),

           REGISTER_DRIVERSECTION( "asterix.c", "129" ),

           REGISTER_DRIVERSECTION( "asteroid.c", "130" ),

           REGISTER_DRIVERSECTION( "astinvad.c", "131" ),

           REGISTER_DRIVERSECTION( "astrocde.c", "132" ),

           REGISTER_DRIVERSECTION( "astrof.c", "133" ),

           REGISTER_DRIVERSECTION( "asuka.c", "8" ),

           REGISTER_DRIVERSECTION( "atarifb.c", "135" ),

           REGISTER_DRIVERSECTION( "atarig1.c", "136" ),

           REGISTER_DRIVERSECTION( "atarig42.c", "137" ),

           REGISTER_DRIVERSECTION( "atarigt.c", "138" ),

           REGISTER_DRIVERSECTION( "atarigx2.c", "139" ),

           REGISTER_DRIVERSECTION( "atarisy1.c", "140" ),

           REGISTER_DRIVERSECTION( "atarisy2.c", "141" ),

           REGISTER_DRIVERSECTION( "ataxx.c", "9" ),

           REGISTER_DRIVERSECTION( "atetris.c", "143" ),

           REGISTER_DRIVERSECTION( "avalnche.c", "144" ),

           REGISTER_DRIVERSECTION( "aztarac.c", "145" ),

           REGISTER_DRIVERSECTION( "badlands.c", "146" ),

           REGISTER_DRIVERSECTION( "bagman.c", "5" ),

           REGISTER_DRIVERSECTION( "balsente.c", "148" ),

           REGISTER_DRIVERSECTION( "bankp.c", "149" ),

           REGISTER_DRIVERSECTION( "baraduke.c", "10" ),

           REGISTER_DRIVERSECTION( "batman.c", "11" ),

           REGISTER_DRIVERSECTION( "battlane.c", "12" ),

           REGISTER_DRIVERSECTION( "battlera.c", "4" ),

           REGISTER_DRIVERSECTION( "battlex.c", "154" ),

           REGISTER_DRIVERSECTION( "battlnts.c", "155" ),

           REGISTER_DRIVERSECTION( "bbusters.c", "156" ),

           REGISTER_DRIVERSECTION( "beaminv.c", "157" ),

           REGISTER_DRIVERSECTION( "beathead.c", "158" ),

           REGISTER_DRIVERSECTION( "beezer.c", "159" ),

           REGISTER_DRIVERSECTION( "berzerk.c", "160" ),

           REGISTER_DRIVERSECTION( "bigevglf.c", "161" ),

           REGISTER_DRIVERSECTION( "bigstrkb.c", "13" ),

           REGISTER_DRIVERSECTION( "bionicc.c", "163" ),

           REGISTER_DRIVERSECTION( "bishi.c", "164" ),

           REGISTER_DRIVERSECTION( "bking2.c", "165" ),

           REGISTER_DRIVERSECTION( "bladestl.c", "166" ),

           REGISTER_DRIVERSECTION( "blktiger.c", "167" ),

           REGISTER_DRIVERSECTION( "blmbycar.c", "168" ),

           REGISTER_DRIVERSECTION( "blockade.c", "169" ),

           REGISTER_DRIVERSECTION( "blockhl.c", "170" ),

           REGISTER_DRIVERSECTION( "blockout.c", "171" ),

           REGISTER_DRIVERSECTION( "bloodbro.c", "172" ),

           REGISTER_DRIVERSECTION( "blstroid.c", "173" ),

           REGISTER_DRIVERSECTION( "blueprnt.c", "174" ),

           REGISTER_DRIVERSECTION( "bmcbowl.c", "175" ),

           REGISTER_DRIVERSECTION( "bogeyman.c", "176" ),

           REGISTER_DRIVERSECTION( "bombjack.c", "177" ),

           REGISTER_DRIVERSECTION( "bosco.c", "178" ),

           REGISTER_DRIVERSECTION( "bottom9.c", "179" ),

           REGISTER_DRIVERSECTION( "boxer.c", "180" ),

           REGISTER_DRIVERSECTION( "brkthru.c", "181" ),

           REGISTER_DRIVERSECTION( "bsktball.c", "182" ),

           REGISTER_DRIVERSECTION( "btime.c", "40" ),

           REGISTER_DRIVERSECTION( "btoads.c", "7" ),

           REGISTER_DRIVERSECTION( "bublbobl.c", "33" ),

           REGISTER_DRIVERSECTION( "buggychl.c", "1" ),

           REGISTER_DRIVERSECTION( "bwidow.c", "14" ),

           REGISTER_DRIVERSECTION( "bwing.c", "188" ),

           REGISTER_DRIVERSECTION( "bzone.c", "14" ),

           REGISTER_DRIVERSECTION( "cabal.c", "190" ),

           REGISTER_DRIVERSECTION( "canyon.c", "191" ),

           REGISTER_DRIVERSECTION( "capbowl.c", "192" ),

           REGISTER_DRIVERSECTION( "carjmbre.c", "193" ),

           REGISTER_DRIVERSECTION( "carpolo.c", "194" ),

           REGISTER_DRIVERSECTION( "cave.c", "195" ),

           REGISTER_DRIVERSECTION( "cball.c", "196" ),

           REGISTER_DRIVERSECTION( "cbasebal.c", "197" ),

           REGISTER_DRIVERSECTION( "cbuster.c", "4" ),

           REGISTER_DRIVERSECTION( "ccastles.c", "199" ),

           REGISTER_DRIVERSECTION( "cchasm.c", "200" ),

           REGISTER_DRIVERSECTION( "cclimber.c", "5" ),

           REGISTER_DRIVERSECTION( "centiped.c", "202" ),

           REGISTER_DRIVERSECTION( "chaknpop.c", "203" ),

           REGISTER_DRIVERSECTION( "champbas.c", "204" ),

           REGISTER_DRIVERSECTION( "changela.c", "205" ),

           REGISTER_DRIVERSECTION( "cheekyms.c", "206" ),

           REGISTER_DRIVERSECTION( "chinagat.c", "15" ),

           REGISTER_DRIVERSECTION( "chindrag.c", "208" ),

           REGISTER_DRIVERSECTION( "chqflag.c", "209" ),

           REGISTER_DRIVERSECTION( "cinemat.c", "16" ),

           REGISTER_DRIVERSECTION( "circus.c", "2" ),

           REGISTER_DRIVERSECTION( "circusc.c", "212" ),

           REGISTER_DRIVERSECTION( "cischeat.c", "13" ),

           REGISTER_DRIVERSECTION( "citycon.c", "214" ),

           REGISTER_DRIVERSECTION( "clayshoo.c", "215" ),

           REGISTER_DRIVERSECTION( "cloak.c", "216" ),

           REGISTER_DRIVERSECTION( "cloud9.c", "217" ),

           REGISTER_DRIVERSECTION( "clshroad.c", "17" ),

           REGISTER_DRIVERSECTION( "cninja.c", "4" ),

           REGISTER_DRIVERSECTION( "cntsteer.c", "220" ),

           REGISTER_DRIVERSECTION( "cojag.c", "18" ),

           REGISTER_DRIVERSECTION( "combatsc.c", "222" ),

           REGISTER_DRIVERSECTION( "commando.c", "223" ),

           REGISTER_DRIVERSECTION( "compgolf.c", "224" ),

           REGISTER_DRIVERSECTION( "contra.c", "225" ),

           REGISTER_DRIVERSECTION( "coolpool.c", "7" ),

           REGISTER_DRIVERSECTION( "cop01.c", "227" ),

           REGISTER_DRIVERSECTION( "copsnrob.c", "228" ),

           REGISTER_DRIVERSECTION( "cosmic.c", "229" ),

           REGISTER_DRIVERSECTION( "cps1.c", "19" ),

           REGISTER_DRIVERSECTION( "cps2.c", "19" ),

           REGISTER_DRIVERSECTION( "cps3.c", "232" ),

           REGISTER_DRIVERSECTION( "crbaloon.c", "233" ),

           REGISTER_DRIVERSECTION( "crgolf.c", "234" ),

           REGISTER_DRIVERSECTION( "crimfght.c", "235" ),

           REGISTER_DRIVERSECTION( "crospang.c", "236" ),

           REGISTER_DRIVERSECTION( "crshrace.c", "237" ),

           REGISTER_DRIVERSECTION( "cshooter.c", "238" ),

           REGISTER_DRIVERSECTION( "cvs.c", "5" ),

           REGISTER_DRIVERSECTION( "cyberbal.c", "240" ),

           REGISTER_DRIVERSECTION( "darius.c", "241" ),

           REGISTER_DRIVERSECTION( "darkseal.c", "4" ),

           REGISTER_DRIVERSECTION( "dassault.c", "4" ),

           REGISTER_DRIVERSECTION( "dbz2.c", "244" ),

           REGISTER_DRIVERSECTION( "dcheese.c", "245" ),

           REGISTER_DRIVERSECTION( "dcon.c", "246" ),

           REGISTER_DRIVERSECTION( "dday.c", "247" ),

           REGISTER_DRIVERSECTION( "ddayjlc.c", "248" ),

           REGISTER_DRIVERSECTION( "ddenlovr.c", "249" ),

           REGISTER_DRIVERSECTION( "ddragon.c", "15" ),

           REGISTER_DRIVERSECTION( "ddragon3.c", "251" ),

           REGISTER_DRIVERSECTION( "ddrible.c", "252" ),

           REGISTER_DRIVERSECTION( "deadang.c", "253" ),

           REGISTER_DRIVERSECTION( "dec0.c", "4" ),

           REGISTER_DRIVERSECTION( "dec8.c", "255" ),

           REGISTER_DRIVERSECTION( "deco102.c", "256" ),

           REGISTER_DRIVERSECTION( "deco156.c", "257" ),

           REGISTER_DRIVERSECTION( "deco32.c", "4" ),

           REGISTER_DRIVERSECTION( "deco_mlc.c", "259" ),

           REGISTER_DRIVERSECTION( "decocass.c", "260" ),

           REGISTER_DRIVERSECTION( "deniam.c", "261" ),

           REGISTER_DRIVERSECTION( "destroyr.c", "262" ),

           REGISTER_DRIVERSECTION( "digdug.c", "263" ),

           REGISTER_DRIVERSECTION( "diverboy.c", "264" ),

           REGISTER_DRIVERSECTION( "djboy.c", "265" ),

           REGISTER_DRIVERSECTION( "djmain.c", "266" ),

           REGISTER_DRIVERSECTION( "dkong.c", "5" ),

           REGISTER_DRIVERSECTION( "dlair.c", "268" ),

           REGISTER_DRIVERSECTION( "docastle.c", "269" ),

           REGISTER_DRIVERSECTION( "dogfgt.c", "270" ),

           REGISTER_DRIVERSECTION( "dooyong.c", "271" ),

           REGISTER_DRIVERSECTION( "dorachan.c", "272" ),

           REGISTER_DRIVERSECTION( "dotrikun.c", "273" ),

           REGISTER_DRIVERSECTION( "dragrace.c", "274" ),

           REGISTER_DRIVERSECTION( "drgnmst.c", "20" ),

           REGISTER_DRIVERSECTION( "dribling.c", "276" ),

           REGISTER_DRIVERSECTION( "drmicro.c", "277" ),

           REGISTER_DRIVERSECTION( "dynadice.c", "278" ),

           REGISTER_DRIVERSECTION( "dynax.c", "279" ),

           REGISTER_DRIVERSECTION( "dynduke.c", "280" ),

           REGISTER_DRIVERSECTION( "embargo.c", "281" ),

           REGISTER_DRIVERSECTION( "enigma2.c", "282" ),

           REGISTER_DRIVERSECTION( "epos.c", "5" ),

           REGISTER_DRIVERSECTION( "eprom.c", "11" ),

           REGISTER_DRIVERSECTION( "equites.c", "285" ),

           REGISTER_DRIVERSECTION( "esd16.c", "286" ),

           REGISTER_DRIVERSECTION( "espial.c", "32" ),

           REGISTER_DRIVERSECTION( "exctsccr.c", "288" ),

           REGISTER_DRIVERSECTION( "exedexes.c", "289" ),

           REGISTER_DRIVERSECTION( "exerion.c", "22" ),

           REGISTER_DRIVERSECTION( "exidy.c", "21" ),

           REGISTER_DRIVERSECTION( "exidy440.c", "292" ),

           REGISTER_DRIVERSECTION( "exprraid.c", "293" ),

           REGISTER_DRIVERSECTION( "exterm.c", "7" ),

           REGISTER_DRIVERSECTION( "exzisus.c", "295" ),

           REGISTER_DRIVERSECTION( "f1gp.c", "296" ),

           REGISTER_DRIVERSECTION( "fantland.c", "297" ),

           REGISTER_DRIVERSECTION( "fastfred.c", "298" ),

           REGISTER_DRIVERSECTION( "fastlane.c", "299" ),

           REGISTER_DRIVERSECTION( "fcombat.c", "22" ),

           REGISTER_DRIVERSECTION( "finalizr.c", "301" ),

           REGISTER_DRIVERSECTION( "findout.c", "302" ),

           REGISTER_DRIVERSECTION( "firetrap.c", "303" ),

           REGISTER_DRIVERSECTION( "firetrk.c", "304" ),

           REGISTER_DRIVERSECTION( "fitfight.c", "305" ),

           REGISTER_DRIVERSECTION( "flkatck.c", "306" ),

           REGISTER_DRIVERSECTION( "flower.c", "307" ),

           REGISTER_DRIVERSECTION( "flstory.c", "308" ),

           REGISTER_DRIVERSECTION( "flyball.c", "309" ),

           REGISTER_DRIVERSECTION( "foodf.c", "310" ),

           REGISTER_DRIVERSECTION( "freekick.c", "311" ),

           REGISTER_DRIVERSECTION( "frogger.c", "5" ),

           REGISTER_DRIVERSECTION( "fromanc2.c", "313" ),

           REGISTER_DRIVERSECTION( "fromance.c", "37" ),

           REGISTER_DRIVERSECTION( "funkybee.c", "315" ),

           REGISTER_DRIVERSECTION( "funkyjet.c", "4" ),

           REGISTER_DRIVERSECTION( "funybubl.c", "317" ),

           REGISTER_DRIVERSECTION( "fuukifg2.c", "318" ),

           REGISTER_DRIVERSECTION( "fuukifg3.c", "319" ),

           REGISTER_DRIVERSECTION( "gaelco.c", "23" ),

           REGISTER_DRIVERSECTION( "gaelco2.c", "23" ),

           REGISTER_DRIVERSECTION( "gaelco3d.c", "322" ),

           REGISTER_DRIVERSECTION( "gaiden.c", "323" ),

           REGISTER_DRIVERSECTION( "galaga.c", "324" ),

           REGISTER_DRIVERSECTION( "galaxian.c", "5" ),

           REGISTER_DRIVERSECTION( "galivan.c", "326" ),

           REGISTER_DRIVERSECTION( "galpani2.c", "24" ),

           REGISTER_DRIVERSECTION( "galpani3.c", "328" ),

           REGISTER_DRIVERSECTION( "galpanic.c", "329" ),

           REGISTER_DRIVERSECTION( "galspnbl.c", "330" ),

           REGISTER_DRIVERSECTION( "gameplan.c", "331" ),

           REGISTER_DRIVERSECTION( "gaplus.c", "332" ),

           REGISTER_DRIVERSECTION( "gauntlet.c", "333" ),

           REGISTER_DRIVERSECTION( "gberet.c", "334" ),

           REGISTER_DRIVERSECTION( "gbusters.c", "335" ),

           REGISTER_DRIVERSECTION( "gcpinbal.c", "336" ),

           REGISTER_DRIVERSECTION( "getrivia.c", "337" ),

           REGISTER_DRIVERSECTION( "gijoe.c", "338" ),

           REGISTER_DRIVERSECTION( "ginganin.c", "339" ),

           REGISTER_DRIVERSECTION( "gladiatr.c", "340" ),

           REGISTER_DRIVERSECTION( "glass.c", "341" ),

           REGISTER_DRIVERSECTION( "gng.c", "342" ),

           REGISTER_DRIVERSECTION( "goal92.c", "25" ),

           REGISTER_DRIVERSECTION( "goindol.c", "344" ),

           REGISTER_DRIVERSECTION( "gomoku.c", "345" ),

           REGISTER_DRIVERSECTION( "gotcha.c", "346" ),

           REGISTER_DRIVERSECTION( "gottlieb.c", "7" ),

           REGISTER_DRIVERSECTION( "gotya.c", "348" ),

           REGISTER_DRIVERSECTION( "gradius3.c", "349" ),

           REGISTER_DRIVERSECTION( "grchamp.c", "350" ),

           REGISTER_DRIVERSECTION( "gridlee.c", "351" ),

           REGISTER_DRIVERSECTION( "groundfx.c", "3" ),

           REGISTER_DRIVERSECTION( "grtwall.c", "353" ),

           REGISTER_DRIVERSECTION( "gstriker.c", "354" ),

           REGISTER_DRIVERSECTION( "gsword.c", "355" ),

           REGISTER_DRIVERSECTION( "gumbo.c", "356" ),

           REGISTER_DRIVERSECTION( "gunbustr.c", "3" ),

           REGISTER_DRIVERSECTION( "gundealr.c", "358" ),

           REGISTER_DRIVERSECTION( "gunsmoke.c", "359" ),

           REGISTER_DRIVERSECTION( "gyruss.c", "360" ),

           REGISTER_DRIVERSECTION( "hal21.c", "26" ),

           REGISTER_DRIVERSECTION( "halleys.c", "362" ),

           REGISTER_DRIVERSECTION( "hanaawas.c", "363" ),

           REGISTER_DRIVERSECTION( "hanaroku.c", "364" ),

           REGISTER_DRIVERSECTION( "harddriv.c", "7" ),

           REGISTER_DRIVERSECTION( "hcastle.c", "366" ),

           REGISTER_DRIVERSECTION( "hexa.c", "367" ),

           REGISTER_DRIVERSECTION( "hexion.c", "368" ),

           REGISTER_DRIVERSECTION( "higemaru.c", "369" ),

           REGISTER_DRIVERSECTION( "hitme.c", "370" ),

           REGISTER_DRIVERSECTION( "hnayayoi.c", "371" ),

           REGISTER_DRIVERSECTION( "hng64.c", "372" ),

           REGISTER_DRIVERSECTION( "holeland.c", "373" ),

           REGISTER_DRIVERSECTION( "homedata.c", "374" ),

           REGISTER_DRIVERSECTION( "homerun.c", "375" ),

           REGISTER_DRIVERSECTION( "hyhoo.c", "376" ),

           REGISTER_DRIVERSECTION( "hyperspt.c", "27" ),

           REGISTER_DRIVERSECTION( "hyprduel.c", "378" ),

           REGISTER_DRIVERSECTION( "ikki.c", "379" ),

           REGISTER_DRIVERSECTION( "inufuku.c", "380" ),

           REGISTER_DRIVERSECTION( "iqblock.c", "381" ),

           REGISTER_DRIVERSECTION( "irobot.c", "382" ),

           REGISTER_DRIVERSECTION( "ironhors.c", "383" ),

           REGISTER_DRIVERSECTION( "itech32.c", "384" ),

           REGISTER_DRIVERSECTION( "itech8.c", "385" ),

           REGISTER_DRIVERSECTION( "jack.c", "386" ),

           REGISTER_DRIVERSECTION( "jackal.c", "387" ),

           REGISTER_DRIVERSECTION( "jailbrek.c", "388" ),

           REGISTER_DRIVERSECTION( "jalmah.c", "389" ),

           REGISTER_DRIVERSECTION( "jchan.c", "390" ),

           REGISTER_DRIVERSECTION( "jcross.c", "26" ),

           REGISTER_DRIVERSECTION( "jedi.c", "392" ),

           REGISTER_DRIVERSECTION( "jrpacman.c", "393" ),

           REGISTER_DRIVERSECTION( "junofrst.c", "28" ),

           REGISTER_DRIVERSECTION( "kaneko16.c", "24" ),

           REGISTER_DRIVERSECTION( "kangaroo.c", "396" ),

           REGISTER_DRIVERSECTION( "karnov.c", "397" ),

           REGISTER_DRIVERSECTION( "kchamp.c", "398" ),

           REGISTER_DRIVERSECTION( "kickgoal.c", "399" ),

           REGISTER_DRIVERSECTION( "kingobox.c", "400" ),

           REGISTER_DRIVERSECTION( "kinst.c", "7" ),

           REGISTER_DRIVERSECTION( "klax.c", "11" ),

           REGISTER_DRIVERSECTION( "kncljoe.c", "10" ),

           REGISTER_DRIVERSECTION( "konamigq.c", "29" ),

           REGISTER_DRIVERSECTION( "konamigv.c", "405" ),

           REGISTER_DRIVERSECTION( "konamigx.c", "29" ),

           REGISTER_DRIVERSECTION( "kopunch.c", "407" ),

           REGISTER_DRIVERSECTION( "ksayakyu.c", "408" ),

           REGISTER_DRIVERSECTION( "kyugo.c", "409" ),

           REGISTER_DRIVERSECTION( "labyrunr.c", "410" ),

           REGISTER_DRIVERSECTION( "ladybug.c", "5" ),

           REGISTER_DRIVERSECTION( "ladyfrog.c", "412" ),

           REGISTER_DRIVERSECTION( "lasso.c", "413" ),

           REGISTER_DRIVERSECTION( "lastduel.c", "414" ),

           REGISTER_DRIVERSECTION( "lazercmd.c", "415" ),

           REGISTER_DRIVERSECTION( "legionna.c", "25" ),

           REGISTER_DRIVERSECTION( "leland.c", "9" ),

           REGISTER_DRIVERSECTION( "lemmings.c", "418" ),

           REGISTER_DRIVERSECTION( "leprechn.c", "419" ),

           REGISTER_DRIVERSECTION( "lethal.c", "420" ),

           REGISTER_DRIVERSECTION( "lethalj.c", "7" ),

           REGISTER_DRIVERSECTION( "liberate.c", "422" ),

           REGISTER_DRIVERSECTION( "liberatr.c", "423" ),

           REGISTER_DRIVERSECTION( "lkage.c", "12" ),

           REGISTER_DRIVERSECTION( "locomotn.c", "28" ),

           REGISTER_DRIVERSECTION( "looping.c", "426" ),

           REGISTER_DRIVERSECTION( "lordgun.c", "427" ),

           REGISTER_DRIVERSECTION( "lsasquad.c", "428" ),

           REGISTER_DRIVERSECTION( "ltcasino.c", "429" ),

           REGISTER_DRIVERSECTION( "lvcards.c", "430" ),

           REGISTER_DRIVERSECTION( "lwings.c", "431" ),

           REGISTER_DRIVERSECTION( "m107.c", "31" ),

           REGISTER_DRIVERSECTION( "m62.c", "10" ),

           REGISTER_DRIVERSECTION( "m72.c", "30" ),

           REGISTER_DRIVERSECTION( "m79amb.c", "435" ),

           REGISTER_DRIVERSECTION( "m90.c", "30" ),

           REGISTER_DRIVERSECTION( "m92.c", "31" ),

           REGISTER_DRIVERSECTION( "macrossp.c", "438" ),

           REGISTER_DRIVERSECTION( "macs.c", "439" ),

           REGISTER_DRIVERSECTION( "madalien.c", "440" ),

           REGISTER_DRIVERSECTION( "madmotor.c", "4" ),

           REGISTER_DRIVERSECTION( "magmax.c", "442" ),

           REGISTER_DRIVERSECTION( "mainevt.c", "443" ),

           REGISTER_DRIVERSECTION( "mainsnk.c", "444" ),

           REGISTER_DRIVERSECTION( "malzak.c", "5" ),

           REGISTER_DRIVERSECTION( "mappy.c", "46" ),

           REGISTER_DRIVERSECTION( "marineb.c", "32" ),

           REGISTER_DRIVERSECTION( "marinedt.c", "448" ),

           REGISTER_DRIVERSECTION( "mario.c", "5" ),

           REGISTER_DRIVERSECTION( "markham.c", "450" ),

           REGISTER_DRIVERSECTION( "marvins.c", "26" ),

           REGISTER_DRIVERSECTION( "matmania.c", "452" ),

           REGISTER_DRIVERSECTION( "mayumi.c", "453" ),

           REGISTER_DRIVERSECTION( "mazerbla.c", "454" ),

           REGISTER_DRIVERSECTION( "mcatadv.c", "455" ),

           REGISTER_DRIVERSECTION( "mcr1.c", "7" ),

           REGISTER_DRIVERSECTION( "mcr2.c", "7" ),

           REGISTER_DRIVERSECTION( "mcr3.c", "7" ),

           REGISTER_DRIVERSECTION( "mcr68.c", "7" ),

           REGISTER_DRIVERSECTION( "meadows.c", "460" ),

           REGISTER_DRIVERSECTION( "megasys1.c", "13" ),

           REGISTER_DRIVERSECTION( "megazone.c", "462" ),

           REGISTER_DRIVERSECTION( "meijinsn.c", "463" ),

           REGISTER_DRIVERSECTION( "mermaid.c", "464" ),

           REGISTER_DRIVERSECTION( "metlclsh.c", "465" ),

           REGISTER_DRIVERSECTION( "metro.c", "466" ),

           REGISTER_DRIVERSECTION( "mexico86.c", "467" ),

           REGISTER_DRIVERSECTION( "mgolf.c", "468" ),

           REGISTER_DRIVERSECTION( "mhavoc.c", "469" ),

           REGISTER_DRIVERSECTION( "micro3d.c", "470" ),

           REGISTER_DRIVERSECTION( "midtunit.c", "7" ),

           REGISTER_DRIVERSECTION( "midvunit.c", "7" ),

           REGISTER_DRIVERSECTION( "midwunit.c", "7" ),

           REGISTER_DRIVERSECTION( "midxunit.c", "7" ),

           REGISTER_DRIVERSECTION( "midyunit.c", "7" ),

           REGISTER_DRIVERSECTION( "mikie.c", "476" ),

           REGISTER_DRIVERSECTION( "minivadr.c", "477" ),

           REGISTER_DRIVERSECTION( "missb2.c", "33" ),

           REGISTER_DRIVERSECTION( "missile.c", "479" ),

           REGISTER_DRIVERSECTION( "mitchell.c", "480" ),

           REGISTER_DRIVERSECTION( "mjkjidai.c", "481" ),

           REGISTER_DRIVERSECTION( "mjsister.c", "482" ),

           REGISTER_DRIVERSECTION( "mnight.c", "483" ),

           REGISTER_DRIVERSECTION( "model1.c", "484" ),

           REGISTER_DRIVERSECTION( "mogura.c", "485" ),

           REGISTER_DRIVERSECTION( "mole.c", "486" ),

           REGISTER_DRIVERSECTION( "momoko.c", "487" ),

           REGISTER_DRIVERSECTION( "moo.c", "488" ),

           REGISTER_DRIVERSECTION( "mosaic.c", "489" ),

           REGISTER_DRIVERSECTION( "mouser.c", "490" ),

           REGISTER_DRIVERSECTION( "mpatrol.c", "10" ),

           REGISTER_DRIVERSECTION( "mrdo.c", "492" ),

           REGISTER_DRIVERSECTION( "mrflea.c", "493" ),

           REGISTER_DRIVERSECTION( "mrjong.c", "494" ),

           REGISTER_DRIVERSECTION( "ms32.c", "34" ),

           REGISTER_DRIVERSECTION( "msisaac.c", "496" ),

           REGISTER_DRIVERSECTION( "mugsmash.c", "497" ),

           REGISTER_DRIVERSECTION( "multi32.c", "35" ),

           REGISTER_DRIVERSECTION( "munchmo.c", "499" ),

           REGISTER_DRIVERSECTION( "mustache.c", "500" ),

           REGISTER_DRIVERSECTION( "mystston.c", "501" ),

           REGISTER_DRIVERSECTION( "mystwarr.c", "29" ),

           REGISTER_DRIVERSECTION( "n8080.c", "503" ),

           REGISTER_DRIVERSECTION( "namcofl.c", "504" ),

           REGISTER_DRIVERSECTION( "namcoic.c", "10" ),

           REGISTER_DRIVERSECTION( "namcona1.c", "506" ),

           REGISTER_DRIVERSECTION( "namconb1.c", "10" ),

           REGISTER_DRIVERSECTION( "namcond1.c", "508" ),

           REGISTER_DRIVERSECTION( "namcos1.c", "10" ),

           REGISTER_DRIVERSECTION( "namcos10.c", "510" ),

           REGISTER_DRIVERSECTION( "namcos11.c", "511" ),

           REGISTER_DRIVERSECTION( "namcos12.c", "512" ),

           REGISTER_DRIVERSECTION( "namcos2.c", "10" ),

           REGISTER_DRIVERSECTION( "namcos21.c", "10" ),

           REGISTER_DRIVERSECTION( "namcos22.c", "515" ),

           REGISTER_DRIVERSECTION( "namcos23.c", "516" ),

           REGISTER_DRIVERSECTION( "namcos86.c", "10" ),

           REGISTER_DRIVERSECTION( "naughtyb.c", "518" ),

           REGISTER_DRIVERSECTION( "nbmj8688.c", "36" ),

           REGISTER_DRIVERSECTION( "nbmj8891.c", "36" ),

           REGISTER_DRIVERSECTION( "nbmj8991.c", "521" ),

           REGISTER_DRIVERSECTION( "nbmj9195.c", "522" ),

           REGISTER_DRIVERSECTION( "nemesis.c", "523" ),

           REGISTER_DRIVERSECTION( "neogeo.c", "524" ),

           REGISTER_DRIVERSECTION( "news.c", "525" ),

           REGISTER_DRIVERSECTION( "ninjakd2.c", "526" ),

           REGISTER_DRIVERSECTION( "ninjakid.c", "527" ),

           REGISTER_DRIVERSECTION( "ninjaw.c", "48" ),

           REGISTER_DRIVERSECTION( "nitedrvr.c", "529" ),

           REGISTER_DRIVERSECTION( "niyanpai.c", "530" ),

           REGISTER_DRIVERSECTION( "nmk16.c", "531" ),

           REGISTER_DRIVERSECTION( "nova2001.c", "38" ),

           REGISTER_DRIVERSECTION( "nss.c", "533" ),

           REGISTER_DRIVERSECTION( "nycaptor.c", "534" ),

           REGISTER_DRIVERSECTION( "nyny.c", "42" ),

           REGISTER_DRIVERSECTION( "offtwall.c", "536" ),

           REGISTER_DRIVERSECTION( "ohmygod.c", "537" ),

           REGISTER_DRIVERSECTION( "ojankohs.c", "538" ),

           REGISTER_DRIVERSECTION( "olibochu.c", "539" ),

           REGISTER_DRIVERSECTION( "omegaf.c", "540" ),

           REGISTER_DRIVERSECTION( "omegrace.c", "541" ),

           REGISTER_DRIVERSECTION( "oneshot.c", "542" ),

           REGISTER_DRIVERSECTION( "onetwo.c", "543" ),

           REGISTER_DRIVERSECTION( "opwolf.c", "8" ),

           REGISTER_DRIVERSECTION( "orbit.c", "545" ),

           REGISTER_DRIVERSECTION( "othldrby.c", "546" ),

           REGISTER_DRIVERSECTION( "othunder.c", "547" ),

           REGISTER_DRIVERSECTION( "outrun.c", "3" ),

           REGISTER_DRIVERSECTION( "overdriv.c", "549" ),

           REGISTER_DRIVERSECTION( "pacland.c", "10" ),

           REGISTER_DRIVERSECTION( "pacman.c", "5" ),

           REGISTER_DRIVERSECTION( "pandoras.c", "552" ),

           REGISTER_DRIVERSECTION( "paradise.c", "553" ),

           REGISTER_DRIVERSECTION( "parodius.c", "554" ),

           REGISTER_DRIVERSECTION( "pass.c", "555" ),

           REGISTER_DRIVERSECTION( "pastelgl.c", "556" ),

           REGISTER_DRIVERSECTION( "pbaction.c", "557" ),

           REGISTER_DRIVERSECTION( "pbchmp95.c", "558" ),

           REGISTER_DRIVERSECTION( "pbillian.c", "559" ),

           REGISTER_DRIVERSECTION( "pcktgal.c", "560" ),

           REGISTER_DRIVERSECTION( "pengo.c", "5" ),

           REGISTER_DRIVERSECTION( "pgm.c", "562" ),

           REGISTER_DRIVERSECTION( "phoenix.c", "5" ),

           REGISTER_DRIVERSECTION( "pingpong.c", "564" ),

           REGISTER_DRIVERSECTION( "pipedrm.c", "37" ),

           REGISTER_DRIVERSECTION( "pirates.c", "566" ),

           REGISTER_DRIVERSECTION( "pitnrun.c", "567" ),

           REGISTER_DRIVERSECTION( "pkunwar.c", "38" ),

           REGISTER_DRIVERSECTION( "playch10.c", "569" ),

           REGISTER_DRIVERSECTION( "playmark.c", "20" ),

           REGISTER_DRIVERSECTION( "plygonet.c", "571" ),

           REGISTER_DRIVERSECTION( "polepos.c", "572" ),

           REGISTER_DRIVERSECTION( "policetr.c", "573" ),

           REGISTER_DRIVERSECTION( "polyplay.c", "574" ),

           REGISTER_DRIVERSECTION( "poolshrk.c", "575" ),

           REGISTER_DRIVERSECTION( "pooyan.c", "28" ),

           REGISTER_DRIVERSECTION( "popeye.c", "577" ),

           REGISTER_DRIVERSECTION( "popper.c", "578" ),

           REGISTER_DRIVERSECTION( "portrait.c", "579" ),

           REGISTER_DRIVERSECTION( "powerins.c", "580" ),

           REGISTER_DRIVERSECTION( "prehisle.c", "581" ),

           REGISTER_DRIVERSECTION( "psikyo.c", "582" ),

           REGISTER_DRIVERSECTION( "psikyo4.c", "583" ),

           REGISTER_DRIVERSECTION( "psikyosh.c", "584" ),

           REGISTER_DRIVERSECTION( "psychic5.c", "585" ),

           REGISTER_DRIVERSECTION( "pturn.c", "586" ),

           REGISTER_DRIVERSECTION( "punchout.c", "587" ),

           REGISTER_DRIVERSECTION( "pushman.c", "588" ),

           REGISTER_DRIVERSECTION( "qdrmfgp.c", "589" ),

           REGISTER_DRIVERSECTION( "qix.c", "590" ),

           REGISTER_DRIVERSECTION( "quantum.c", "591" ),

           REGISTER_DRIVERSECTION( "quasar.c", "592" ),

           REGISTER_DRIVERSECTION( "quizdna.c", "593" ),

           REGISTER_DRIVERSECTION( "quizpani.c", "594" ),

           REGISTER_DRIVERSECTION( "r2dtank.c", "595" ),

           REGISTER_DRIVERSECTION( "rabbit.c", "596" ),

           REGISTER_DRIVERSECTION( "raiden.c", "597" ),

           REGISTER_DRIVERSECTION( "raiden2.c", "598" ),

           REGISTER_DRIVERSECTION( "raiders5.c", "599" ),

           REGISTER_DRIVERSECTION( "rainbow.c", "8" ),

           REGISTER_DRIVERSECTION( "rallyx.c", "28" ),

           REGISTER_DRIVERSECTION( "rampart.c", "6" ),

           REGISTER_DRIVERSECTION( "rastan.c", "8" ),

           REGISTER_DRIVERSECTION( "realbrk.c", "604" ),

           REGISTER_DRIVERSECTION( "redalert.c", "605" ),

           REGISTER_DRIVERSECTION( "redclash.c", "606" ),

           REGISTER_DRIVERSECTION( "relief.c", "607" ),

           REGISTER_DRIVERSECTION( "renegade.c", "608" ),

           REGISTER_DRIVERSECTION( "retofinv.c", "609" ),

           REGISTER_DRIVERSECTION( "rmhaihai.c", "610" ),

           REGISTER_DRIVERSECTION( "rockola.c", "611" ),

           REGISTER_DRIVERSECTION( "rockrage.c", "612" ),

           REGISTER_DRIVERSECTION( "rocnrope.c", "28" ),

           REGISTER_DRIVERSECTION( "rohga.c", "4" ),

           REGISTER_DRIVERSECTION( "rollerg.c", "615" ),

           REGISTER_DRIVERSECTION( "rollrace.c", "39" ),

           REGISTER_DRIVERSECTION( "rotaryf.c", "2" ),

           REGISTER_DRIVERSECTION( "route16.c", "618" ),

           REGISTER_DRIVERSECTION( "royalmah.c", "619" ),

           REGISTER_DRIVERSECTION( "rpunch.c", "620" ),

           REGISTER_DRIVERSECTION( "runaway.c", "621" ),

           REGISTER_DRIVERSECTION( "rungun.c", "622" ),

           REGISTER_DRIVERSECTION( "safarir.c", "623" ),

           REGISTER_DRIVERSECTION( "sauro.c", "624" ),

           REGISTER_DRIVERSECTION( "sbasketb.c", "27" ),

           REGISTER_DRIVERSECTION( "sbowling.c", "626" ),

           REGISTER_DRIVERSECTION( "sbrkout.c", "627" ),

           REGISTER_DRIVERSECTION( "sbugger.c", "628" ),

           REGISTER_DRIVERSECTION( "scobra.c", "5" ),

           REGISTER_DRIVERSECTION( "scotrsht.c", "630" ),

           REGISTER_DRIVERSECTION( "scramble.c", "5" ),

           REGISTER_DRIVERSECTION( "scregg.c", "40" ),

           REGISTER_DRIVERSECTION( "seattle.c", "7" ),

           REGISTER_DRIVERSECTION( "sega.c", "41" ),

           REGISTER_DRIVERSECTION( "segac2.c", "3" ),

           REGISTER_DRIVERSECTION( "segar.c", "41" ),

           REGISTER_DRIVERSECTION( "segasyse.c", "3" ),

           REGISTER_DRIVERSECTION( "seibuspi.c", "638" ),

           REGISTER_DRIVERSECTION( "seicross.c", "639" ),

           REGISTER_DRIVERSECTION( "sengokmj.c", "640" ),

           REGISTER_DRIVERSECTION( "senjyo.c", "641" ),

           REGISTER_DRIVERSECTION( "seta.c", "44" ),

           REGISTER_DRIVERSECTION( "seta2.c", "643" ),

           REGISTER_DRIVERSECTION( "sf1.c", "644" ),

           REGISTER_DRIVERSECTION( "sg1000a.c", "645" ),

           REGISTER_DRIVERSECTION( "sgladiat.c", "26" ),

           REGISTER_DRIVERSECTION( "shadfrce.c", "647" ),

           REGISTER_DRIVERSECTION( "shangha3.c", "648" ),

           REGISTER_DRIVERSECTION( "shanghai.c", "649" ),

           REGISTER_DRIVERSECTION( "shangkid.c", "650" ),

           REGISTER_DRIVERSECTION( "shaolins.c", "651" ),

           REGISTER_DRIVERSECTION( "sharrier.c", "3" ),

           REGISTER_DRIVERSECTION( "shisen.c", "30" ),

           REGISTER_DRIVERSECTION( "shootout.c", "654" ),

           REGISTER_DRIVERSECTION( "shougi.c", "655" ),

           REGISTER_DRIVERSECTION( "shuuz.c", "656" ),

           REGISTER_DRIVERSECTION( "sidearms.c", "657" ),

           REGISTER_DRIVERSECTION( "sidepckt.c", "658" ),

           REGISTER_DRIVERSECTION( "silkroad.c", "659" ),

           REGISTER_DRIVERSECTION( "simpsons.c", "660" ),

           REGISTER_DRIVERSECTION( "skullxbo.c", "661" ),

           REGISTER_DRIVERSECTION( "skyarmy.c", "662" ),

           REGISTER_DRIVERSECTION( "skychut.c", "663" ),

           REGISTER_DRIVERSECTION( "skydiver.c", "664" ),

           REGISTER_DRIVERSECTION( "skyfox.c", "665" ),

           REGISTER_DRIVERSECTION( "skykid.c", "10" ),

           REGISTER_DRIVERSECTION( "skyraid.c", "667" ),

           REGISTER_DRIVERSECTION( "slapfght.c", "668" ),

           REGISTER_DRIVERSECTION( "slapshot.c", "669" ),

           REGISTER_DRIVERSECTION( "snk.c", "26" ),

           REGISTER_DRIVERSECTION( "snk68.c", "671" ),

           REGISTER_DRIVERSECTION( "snowbros.c", "672" ),

           REGISTER_DRIVERSECTION( "solomon.c", "673" ),

           REGISTER_DRIVERSECTION( "sonson.c", "674" ),

           REGISTER_DRIVERSECTION( "spacefb.c", "675" ),

           REGISTER_DRIVERSECTION( "spbactn.c", "676" ),

           REGISTER_DRIVERSECTION( "spcforce.c", "677" ),

           REGISTER_DRIVERSECTION( "spdbuggy.c", "678" ),

           REGISTER_DRIVERSECTION( "spdodgeb.c", "679" ),

           REGISTER_DRIVERSECTION( "speedatk.c", "680" ),

           REGISTER_DRIVERSECTION( "speedbal.c", "681" ),

           REGISTER_DRIVERSECTION( "speedspn.c", "682" ),

           REGISTER_DRIVERSECTION( "spiders.c", "42" ),

           REGISTER_DRIVERSECTION( "splash.c", "684" ),

           REGISTER_DRIVERSECTION( "sprcros2.c", "685" ),

           REGISTER_DRIVERSECTION( "sprint2.c", "686" ),

           REGISTER_DRIVERSECTION( "sprint4.c", "687" ),

           REGISTER_DRIVERSECTION( "sprint8.c", "688" ),

           REGISTER_DRIVERSECTION( "spy.c", "689" ),

           REGISTER_DRIVERSECTION( "srmp2.c", "690" ),

           REGISTER_DRIVERSECTION( "srumbler.c", "691" ),

           REGISTER_DRIVERSECTION( "sshangha.c", "692" ),

           REGISTER_DRIVERSECTION( "ssingles.c", "693" ),

           REGISTER_DRIVERSECTION( "sslam.c", "20" ),

           REGISTER_DRIVERSECTION( "ssozumo.c", "695" ),

           REGISTER_DRIVERSECTION( "sspeedr.c", "696" ),

           REGISTER_DRIVERSECTION( "ssrj.c", "697" ),

           REGISTER_DRIVERSECTION( "ssv.c", "698" ),

           REGISTER_DRIVERSECTION( "st0016.c", "699" ),

           REGISTER_DRIVERSECTION( "stactics.c", "700" ),

           REGISTER_DRIVERSECTION( "stadhero.c", "701" ),

           REGISTER_DRIVERSECTION( "starcrus.c", "702" ),

           REGISTER_DRIVERSECTION( "starfire.c", "703" ),

           REGISTER_DRIVERSECTION( "starshp1.c", "704" ),

           REGISTER_DRIVERSECTION( "starwars.c", "705" ),

           REGISTER_DRIVERSECTION( "statriv2.c", "706" ),

           REGISTER_DRIVERSECTION( "stfight.c", "707" ),

           REGISTER_DRIVERSECTION( "stlforce.c", "708" ),

           REGISTER_DRIVERSECTION( "strnskil.c", "709" ),

           REGISTER_DRIVERSECTION( "strvmstr.c", "710" ),

           REGISTER_DRIVERSECTION( "stv.c", "43" ),

           REGISTER_DRIVERSECTION( "stvhacks.c", "43" ),

           REGISTER_DRIVERSECTION( "subs.c", "713" ),

           REGISTER_DRIVERSECTION( "suna16.c", "714" ),

           REGISTER_DRIVERSECTION( "suna8.c", "715" ),

           REGISTER_DRIVERSECTION( "supbtime.c", "4" ),

           REGISTER_DRIVERSECTION( "supdrapo.c", "717" ),

           REGISTER_DRIVERSECTION( "superchs.c", "3" ),

           REGISTER_DRIVERSECTION( "superqix.c", "719" ),

           REGISTER_DRIVERSECTION( "supertnk.c", "720" ),

           REGISTER_DRIVERSECTION( "suprloco.c", "721" ),

           REGISTER_DRIVERSECTION( "suprnova.c", "722" ),

           REGISTER_DRIVERSECTION( "suprridr.c", "723" ),

           REGISTER_DRIVERSECTION( "suprslam.c", "724" ),

           REGISTER_DRIVERSECTION( "surpratk.c", "725" ),

           REGISTER_DRIVERSECTION( "system1.c", "726" ),

           REGISTER_DRIVERSECTION( "system16.c", "3" ),

           REGISTER_DRIVERSECTION( "system18.c", "3" ),

           REGISTER_DRIVERSECTION( "system24.c", "729" ),

           REGISTER_DRIVERSECTION( "system32.c", "35" ),

           REGISTER_DRIVERSECTION( "tagteam.c", "731" ),

           REGISTER_DRIVERSECTION( "tail2nos.c", "732" ),

           REGISTER_DRIVERSECTION( "taito_b.c", "3" ),

           REGISTER_DRIVERSECTION( "taito_f2.c", "734" ),

           REGISTER_DRIVERSECTION( "taito_f3.c", "3" ),

           REGISTER_DRIVERSECTION( "taito_h.c", "736" ),

           REGISTER_DRIVERSECTION( "taito_l.c", "737" ),

           REGISTER_DRIVERSECTION( "taito_x.c", "44" ),

           REGISTER_DRIVERSECTION( "taito_z.c", "739" ),

           REGISTER_DRIVERSECTION( "taitoair.c", "740" ),

           REGISTER_DRIVERSECTION( "taitojc.c", "741" ),

           REGISTER_DRIVERSECTION( "taitosj.c", "742" ),

           REGISTER_DRIVERSECTION( "talbot.c", "743" ),

           REGISTER_DRIVERSECTION( "tankbatt.c", "744" ),

           REGISTER_DRIVERSECTION( "tankbust.c", "745" ),

           REGISTER_DRIVERSECTION( "taotaido.c", "746" ),

           REGISTER_DRIVERSECTION( "targeth.c", "747" ),

           REGISTER_DRIVERSECTION( "taxidrvr.c", "748" ),

           REGISTER_DRIVERSECTION( "tbowl.c", "749" ),

           REGISTER_DRIVERSECTION( "tceptor.c", "10" ),

           REGISTER_DRIVERSECTION( "tcl.c", "751" ),

           REGISTER_DRIVERSECTION( "tecmo.c", "752" ),

           REGISTER_DRIVERSECTION( "tecmo16.c", "753" ),

           REGISTER_DRIVERSECTION( "tecmosys.c", "754" ),

           REGISTER_DRIVERSECTION( "tehkanwc.c", "755" ),

           REGISTER_DRIVERSECTION( "tempest.c", "756" ),

           REGISTER_DRIVERSECTION( "terracre.c", "757" ),

           REGISTER_DRIVERSECTION( "tetrisp2.c", "34" ),

           REGISTER_DRIVERSECTION( "thedeep.c", "759" ),

           REGISTER_DRIVERSECTION( "thepit.c", "760" ),

           REGISTER_DRIVERSECTION( "thief.c", "761" ),

           REGISTER_DRIVERSECTION( "thoop2.c", "762" ),

           REGISTER_DRIVERSECTION( "thunderj.c", "11" ),

           REGISTER_DRIVERSECTION( "thunderx.c", "764" ),

           REGISTER_DRIVERSECTION( "tickee.c", "7" ),

           REGISTER_DRIVERSECTION( "tigeroad.c", "766" ),

           REGISTER_DRIVERSECTION( "timelimt.c", "767" ),

           REGISTER_DRIVERSECTION( "timeplt.c", "28" ),

           REGISTER_DRIVERSECTION( "tmnt.c", "45" ),

           REGISTER_DRIVERSECTION( "tnzs.c", "770" ),

           REGISTER_DRIVERSECTION( "toaplan1.c", "771" ),

           REGISTER_DRIVERSECTION( "toaplan2.c", "772" ),

           REGISTER_DRIVERSECTION( "toki.c", "773" ),

           REGISTER_DRIVERSECTION( "toobin.c", "774" ),

           REGISTER_DRIVERSECTION( "topspeed.c", "8" ),

           REGISTER_DRIVERSECTION( "toratora.c", "776" ),

           REGISTER_DRIVERSECTION( "tourtabl.c", "777" ),

           REGISTER_DRIVERSECTION( "toypop.c", "46" ),

           REGISTER_DRIVERSECTION( "tp84.c", "779" ),

           REGISTER_DRIVERSECTION( "trackfld.c", "27" ),

           REGISTER_DRIVERSECTION( "travrusa.c", "10" ),

           REGISTER_DRIVERSECTION( "triplhnt.c", "782" ),

           REGISTER_DRIVERSECTION( "troangel.c", "10" ),

           REGISTER_DRIVERSECTION( "truco.c", "784" ),

           REGISTER_DRIVERSECTION( "tryout.c", "785" ),

           REGISTER_DRIVERSECTION( "tsamurai.c", "786" ),

           REGISTER_DRIVERSECTION( "ttmahjng.c", "787" ),

           REGISTER_DRIVERSECTION( "tubep.c", "788" ),

           REGISTER_DRIVERSECTION( "tugboat.c", "789" ),

           REGISTER_DRIVERSECTION( "tumblep.c", "4" ),

           REGISTER_DRIVERSECTION( "tunhunt.c", "791" ),

           REGISTER_DRIVERSECTION( "turbo.c", "792" ),

           REGISTER_DRIVERSECTION( "tutankhm.c", "28" ),

           REGISTER_DRIVERSECTION( "twin16.c", "45" ),

           REGISTER_DRIVERSECTION( "twincobr.c", "47" ),

           REGISTER_DRIVERSECTION( "ultraman.c", "796" ),

           REGISTER_DRIVERSECTION( "ultratnk.c", "797" ),

           REGISTER_DRIVERSECTION( "undrfire.c", "3" ),

           REGISTER_DRIVERSECTION( "unico.c", "799" ),

           REGISTER_DRIVERSECTION( "usgames.c", "800" ),

           REGISTER_DRIVERSECTION( "vamphalf.c", "801" ),

           REGISTER_DRIVERSECTION( "vaportra.c", "4" ),

           REGISTER_DRIVERSECTION( "vastar.c", "803" ),

           REGISTER_DRIVERSECTION( "vball.c", "804" ),

           REGISTER_DRIVERSECTION( "vendetta.c", "805" ),

           REGISTER_DRIVERSECTION( "vicdual.c", "806" ),

           REGISTER_DRIVERSECTION( "victory.c", "21" ),

           REGISTER_DRIVERSECTION( "videopin.c", "808" ),

           REGISTER_DRIVERSECTION( "vigilant.c", "30" ),

           REGISTER_DRIVERSECTION( "vindictr.c", "11" ),

           REGISTER_DRIVERSECTION( "vmetal.c", "811" ),

           REGISTER_DRIVERSECTION( "volfied.c", "812" ),

           REGISTER_DRIVERSECTION( "vsnes.c", "813" ),

           REGISTER_DRIVERSECTION( "vulgus.c", "814" ),

           REGISTER_DRIVERSECTION( "wallc.c", "815" ),

           REGISTER_DRIVERSECTION( "wardner.c", "47" ),

           REGISTER_DRIVERSECTION( "warpwarp.c", "817" ),

           REGISTER_DRIVERSECTION( "warriorb.c", "48" ),

           REGISTER_DRIVERSECTION( "wc90.c", "49" ),

           REGISTER_DRIVERSECTION( "wc90b.c", "49" ),

           REGISTER_DRIVERSECTION( "wecleman.c", "821" ),

           REGISTER_DRIVERSECTION( "welltris.c", "822" ),

           REGISTER_DRIVERSECTION( "wgp.c", "823" ),

           REGISTER_DRIVERSECTION( "williams.c", "7" ),

           REGISTER_DRIVERSECTION( "wilytowr.c", "825" ),

           REGISTER_DRIVERSECTION( "wiping.c", "17" ),

           REGISTER_DRIVERSECTION( "wiz.c", "39" ),

           REGISTER_DRIVERSECTION( "wolfpack.c", "828" ),

           REGISTER_DRIVERSECTION( "wrally.c", "829" ),

           REGISTER_DRIVERSECTION( "wwfsstar.c", "830" ),

           REGISTER_DRIVERSECTION( "wwfwfest.c", "831" ),

           REGISTER_DRIVERSECTION( "xain.c", "832" ),

           REGISTER_DRIVERSECTION( "xevious.c", "833" ),

           REGISTER_DRIVERSECTION( "xexex.c", "834" ),

           REGISTER_DRIVERSECTION( "xmen.c", "835" ),

           REGISTER_DRIVERSECTION( "xorworld.c", "836" ),

           REGISTER_DRIVERSECTION( "xxmissio.c", "837" ),

           REGISTER_DRIVERSECTION( "xybots.c", "838" ),

           REGISTER_DRIVERSECTION( "xyonix.c", "839" ),

           REGISTER_DRIVERSECTION( "yamato.c", "5" ),

           REGISTER_DRIVERSECTION( "yard.c", "10" ),

           REGISTER_DRIVERSECTION( "yiear.c", "27" ),

           REGISTER_DRIVERSECTION( "yumefuda.c", "843" ),

           REGISTER_DRIVERSECTION( "yunsun16.c", "844" ),

           REGISTER_DRIVERSECTION( "yunsung8.c", "845" ),

           REGISTER_DRIVERSECTION( "zac2650.c", "846" ),

           REGISTER_DRIVERSECTION( "zaccaria.c", "847" ),

           REGISTER_DRIVERSECTION( "zaxxon.c", "848" ),

           REGISTER_DRIVERSECTION( "zerozone.c", "849" ),

           REGISTER_DRIVERSECTION( "zn.c", "850" ),

           REGISTER_DRIVERSECTION( "zodiack.c", "32" ) };



//-------------------------------------------------------------
//	IsDriverClone
//-------------------------------------------------------------
inline BOOL IsDriverClone( const char *driverName )
{
  return( !strcmp( driverName, "40love.c" ) ||
        !strcmp( driverName, "8080bw.c" ) ||
        !strcmp( driverName, "rotaryf.c" ) ||
        !strcmp( driverName, "aburner.c" ) ||
        !strcmp( driverName, "taito_b.c" ) ||
        !strcmp( driverName, "taito_f3.c" ) ||
        !strcmp( driverName, "groundfx.c" ) ||
        !strcmp( driverName, "gunbustr.c" ) ||
        !strcmp( driverName, "outrun.c" ) ||
        !strcmp( driverName, "segasyse.c" ) ||
        !strcmp( driverName, "system18.c" ) ||
        !strcmp( driverName, "segac2.c" ) ||
        !strcmp( driverName, "sharrier.c" ) ||
        !strcmp( driverName, "superchs.c" ) ||
        !strcmp( driverName, "undrfire.c" ) ||
        !strcmp( driverName, "battlera.c" ) ||
        !strcmp( driverName, "cbuster.c" ) ||
        !strcmp( driverName, "cninja.c" ) ||
        !strcmp( driverName, "darkseal.c" ) ||
        !strcmp( driverName, "dassault.c" ) ||
        !strcmp( driverName, "dec0.c" ) ||
        !strcmp( driverName, "deco32.c" ) ||
        !strcmp( driverName, "funkyjet.c" ) ||
        !strcmp( driverName, "madmotor.c" ) ||
        !strcmp( driverName, "rohga.c" ) ||
        !strcmp( driverName, "supbtime.c" ) ||
        !strcmp( driverName, "tumblep.c" ) ||
        !strcmp( driverName, "vaportra.c" ) ||
        !strcmp( driverName, "cclimber.c" ) ||
        !strcmp( driverName, "cvs.c" ) ||
        !strcmp( driverName, "dkong.c" ) ||
        !strcmp( driverName, "epos.c" ) ||
        !strcmp( driverName, "galaxian.c" ) ||
        !strcmp( driverName, "ladybug.c" ) ||
        !strcmp( driverName, "mario.c" ) ||
        !strcmp( driverName, "pengo.c" ) ||
        !strcmp( driverName, "phoenix.c" ) ||
        !strcmp( driverName, "frogger.c" ) ||
        !strcmp( driverName, "pacman.c" ) ||
        !strcmp( driverName, "scobra.c" ) ||
        !strcmp( driverName, "scramble.c" ) ||
        !strcmp( driverName, "amidar.c" ) ||
        !strcmp( driverName, "malzak.c" ) ||
        !strcmp( driverName, "yamato.c" ) ||
        !strcmp( driverName, "arcadecl.c" ) ||
        !strcmp( driverName, "btoads.c" ) ||
        !strcmp( driverName, "coolpool.c" ) ||
        !strcmp( driverName, "gottlieb.c" ) ||
        !strcmp( driverName, "exterm.c" ) ||
        !strcmp( driverName, "harddriv.c" ) ||
        !strcmp( driverName, "kinst.c" ) ||
        !strcmp( driverName, "lethalj.c" ) ||
        !strcmp( driverName, "williams.c" ) ||
        !strcmp( driverName, "midyunit.c" ) ||
        !strcmp( driverName, "midtunit.c" ) ||
        !strcmp( driverName, "mcr3.c" ) ||
        !strcmp( driverName, "mcr68.c" ) ||
        !strcmp( driverName, "mcr1.c" ) ||
        !strcmp( driverName, "mcr2.c" ) ||
        !strcmp( driverName, "midvunit.c" ) ||
        !strcmp( driverName, "midwunit.c" ) ||
        !strcmp( driverName, "midxunit.c" ) ||
        !strcmp( driverName, "seattle.c" ) ||
        !strcmp( driverName, "tickee.c" ) ||
        !strcmp( driverName, "asuka.c" ) ||
        !strcmp( driverName, "opwolf.c" ) ||
        !strcmp( driverName, "rainbow.c" ) ||
        !strcmp( driverName, "topspeed.c" ) ||
        !strcmp( driverName, "ataxx.c" ) ||
        !strcmp( driverName, "kncljoe.c" ) ||
        !strcmp( driverName, "m62.c" ) ||
        !strcmp( driverName, "mpatrol.c" ) ||
        !strcmp( driverName, "namcos1.c" ) ||
        !strcmp( driverName, "namcos86.c" ) ||
        !strcmp( driverName, "pacland.c" ) ||
        !strcmp( driverName, "skykid.c" ) ||
        !strcmp( driverName, "namcoic.c" ) ||
        !strcmp( driverName, "namcos2.c" ) ||
        !strcmp( driverName, "tceptor.c" ) ||
        !strcmp( driverName, "namconb1.c" ) ||
        !strcmp( driverName, "namcos21.c" ) ||
        !strcmp( driverName, "travrusa.c" ) ||
        !strcmp( driverName, "troangel.c" ) ||
        !strcmp( driverName, "yard.c" ) ||
        !strcmp( driverName, "batman.c" ) ||
        !strcmp( driverName, "klax.c" ) ||
        !strcmp( driverName, "eprom.c" ) ||
        !strcmp( driverName, "vindictr.c" ) ||
        !strcmp( driverName, "battlane.c" ) ||
        !strcmp( driverName, "bigstrkb.c" ) ||
        !strcmp( driverName, "cischeat.c" ) ||
        !strcmp( driverName, "bwidow.c" ) ||
        !strcmp( driverName, "chinagat.c" ) ||
        !strcmp( driverName, "clshroad.c" ) ||
        !strcmp( driverName, "cps2.c" ) ||
        !strcmp( driverName, "playmark.c" ) ||
        !strcmp( driverName, "sslam.c" ) ||
        !strcmp( driverName, "exidy.c" ) ||
        !strcmp( driverName, "fcombat.c" ) ||
        !strcmp( driverName, "gaelco.c" ) ||
        !strcmp( driverName, "galpani2.c" ) ||
        !strcmp( driverName, "goal92.c" ) ||
        !strcmp( driverName, "hal21.c" ) ||
        !strcmp( driverName, "jcross.c" ) ||
        !strcmp( driverName, "marvins.c" ) ||
        !strcmp( driverName, "sgladiat.c" ) ||
        !strcmp( driverName, "hyperspt.c" ) ||
        !strcmp( driverName, "sbasketb.c" ) ||
        !strcmp( driverName, "yiear.c" ) ||
        !strcmp( driverName, "junofrst.c" ) ||
        !strcmp( driverName, "timeplt.c" ) ||
        !strcmp( driverName, "rallyx.c" ) ||
        !strcmp( driverName, "locomotn.c" ) ||
        !strcmp( driverName, "pooyan.c" ) ||
        !strcmp( driverName, "rocnrope.c" ) ||
        !strcmp( driverName, "konamigq.c" ) ||
        !strcmp( driverName, "mystwarr.c" ) ||
        !strcmp( driverName, "m90.c" ) ||
        !strcmp( driverName, "shisen.c" ) ||
        !strcmp( driverName, "vigilant.c" ) ||
        !strcmp( driverName, "m92.c" ) ||
        !strcmp( driverName, "marineb.c" ) ||
        !strcmp( driverName, "zodiack.c" ) ||
        !strcmp( driverName, "missb2.c" ) ||
        !strcmp( driverName, "ms32.c" ) ||
        !strcmp( driverName, "multi32.c" ) ||
        !strcmp( driverName, "nbmj8891.c" ) ||
        !strcmp( driverName, "pipedrm.c" ) ||
        !strcmp( driverName, "pkunwar.c" ) ||
        !strcmp( driverName, "rollrace.c" ) ||
        !strcmp( driverName, "scregg.c" ) ||
        !strcmp( driverName, "sega.c" ) ||
        !strcmp( driverName, "spiders.c" ) ||
        !strcmp( driverName, "stv.c" ) ||
        !strcmp( driverName, "taito_x.c" ) ||
        !strcmp( driverName, "tmnt.c" ) ||
        !strcmp( driverName, "toypop.c" ) ||
        !strcmp( driverName, "wardner.c" ) ||
        !strcmp( driverName, "warriorb.c" ) ||
        !strcmp( driverName, "wc90b.c" ) );
}

#ifdef _DEBUG
//-------------------------------------------------------------
//	CheckDriverSectionRAM
//-------------------------------------------------------------
void CheckDriverSectionRAM( void )
{
  DWORD total = 0;

	const driverSectionRegistration_t *entry = (const driverSectionRegistration_t *)g_driverSectionRegistry;
	for( int i = 0; i < NUM_DRIVERSECTIONS; ++entry, ++i )
	{
      // Only test families once (all but the first member are skipped)
		if( !IsDriverClone( entry->m_driverName ) )
		{
			HANDLE h = XGetSectionHandle( entry->m_sectionName );
			if( h != INVALID_HANDLE_VALUE )
			{
				UINT32 sz = XGetSectionSize( h );
				PRINTMSG(( T_INFO, "Driver %s %lu", entry->m_driverName, sz ));
				total += sz;
			}
			else
				PRINTMSG(( T_ERROR, "Invalid section %s for file %s!", entry->m_sectionName, entry->m_driverName ));
		}
	}
  PRINTMSG(( T_INFO, "Total %lu bytes\n", total ));
}
#endif




//-------------------------------------------------------------
//	LoadDriverSections
//-------------------------------------------------------------
BOOL LoadDriverSections( void )
{
	const driverSectionRegistration_t *entry = (const driverSectionRegistration_t *)g_driverSectionRegistry;
	for( int i = 0; i < NUM_DRIVERSECTIONS; ++entry, ++i )
	{
      // Only load families once (all but the first member are skipped)
		if( !IsDriverClone( entry->m_driverName ) )
		{
			if( !XLoadSection( entry->m_sectionName ) )
			{
				PRINTMSG(( T_ERROR, "XLoadSection %s for driver %s failed! 0x%X", entry->m_sectionName, entry->m_driverName, GetLastError() ));
				return FALSE;
			}
		}
  }
  return TRUE;
}

//-------------------------------------------------------------
//	UnloadDriverSections
//-------------------------------------------------------------
BOOL UnloadDriverSections( void )
{
	const driverSectionRegistration_t *entry = (const driverSectionRegistration_t *)g_driverSectionRegistry;
	for( int i = 0; i < NUM_DRIVERSECTIONS; ++entry, ++i )
	{
      // Only unload families once (all but the first member are skipped)
		if( !IsDriverClone( entry->m_driverName ) )
		{
		  if( !XFreeSection( entry->m_sectionName ) )
			{
				PRINTMSG(( T_ERROR, "XFreeSection %s for driver %s failed! 0x%X", entry->m_sectionName, entry->m_driverName, GetLastError() ));
			}
		}
	}

	return TRUE;
}

//-------------------------------------------------------------
//	LoadDriverSectionByName
//-------------------------------------------------------------
BOOL LoadDriverSectionByName( const char *driverFileName )
{
	const driverSectionRegistration_t *entry = (const driverSectionRegistration_t *)g_driverSectionRegistry;
	for( int i = 0; i < NUM_DRIVERSECTIONS; ++entry, ++i )
	{
		if( !strcmp( entry->m_driverName, driverFileName ) )
		{
			PRINTMSG(( T_INFO, "Load section %s for driver %s\n", entry->m_sectionName, entry->m_driverName ));
			if( !XLoadSection( entry->m_sectionName ) )
			{
				PRINTMSG(( T_ERROR, "XLoadSection %s for driver %s failed! 0x%X", entry->m_sectionName, entry->m_driverName, GetLastError() ));
				return FALSE;
			}

			return TRUE;
		}
	}

	PRINTMSG(( T_INFO, "No section registered for driver %s!\n", driverFileName ));
  return FALSE;
}


//-------------------------------------------------------------
//	UnloadDriverSectionByName
//-------------------------------------------------------------
BOOL UnloadDriverSectionByName( const char *driverFileName )
{
	const driverSectionRegistration_t *entry = (const driverSectionRegistration_t *)g_driverSectionRegistry;
	for( int i = 0; i < NUM_DRIVERSECTIONS; ++entry, ++i )
	{
		if( !strcmp( entry->m_driverName, driverFileName ) )
		{
			PRINTMSG(( T_INFO, "Free section %s for driver %s\n", entry->m_sectionName, entry->m_driverName ));
			if( !XFreeSection( entry->m_sectionName ) )
			{
				PRINTMSG(( T_ERROR, "XFreeSection %s for driver %s failed! 0x%X", entry->m_sectionName, entry->m_driverName, GetLastError() ));
				return FALSE;
			}

			return TRUE;
		}
	}

	PRINTMSG(( T_INFO, "No section registered for driver %s!\n", driverFileName ));
  return FALSE;
}

#pragma code_seg()			// End of DRVSNIZE
#pragma data_seg()
#pragma bss_seg()
#pragma const_seg()



  //--- CPU Functions -----------------------------------------------

#pragma code_seg( "CPUCSNZE" )
#pragma data_seg( "CPUDSNZE" )
#pragma const_seg( "CPUKSNZE" )
#pragma bss_seg( "CPUBSNZE" )
#pragma comment(linker, "/merge:CPUCSNZE=CPUSNIZE")
#pragma comment(linker, "/merge:CPUDSNZE=CPUSNIZE")
#pragma comment(linker, "/merge:CPUKSNZE=CPUSNIZE")
#pragma comment(linker, "/merge:CPUBSNZE=CPUSNIZE")

#ifdef _DEBUG
//-------------------------------------------------------------
//	CheckCPUSectionRAM
//-------------------------------------------------------------
void CheckCPUSectionRAM( void )
{
  DWORD total = 0;
  std::map< UINT32, std::string >::iterator i = g_CPUIDToSectionMap.begin();
  for( ; i != g_CPUIDToSectionMap.end(); ++i )
  {
    HANDLE h = XGetSectionHandle( (*i).second.c_str() );
    if( h != INVALID_HANDLE_VALUE )
    {
      UINT32 sz = XGetSectionSize( h );
      PRINTMSG(( T_INFO, "CPU%lu %lu", (*i).first, sz ));
      total += sz;
    }
    else
      PRINTMSG(( T_ERROR, "Invalid section %s for CPU%lu!", (*i).second.c_str(), (*i).first ));
  }
  PRINTMSG(( T_INFO, "Total %lu bytes\n", total ));
}
#endif


//-------------------------------------------------------------
//	RegisterSectionID
//-------------------------------------------------------------
static void RegisterSectionID( UINT32 CPUID, const char *DataSectionName )
{
    // Add the section name to the map
  g_CPUIDToSectionMap[ CPUID ] = DataSectionName;
}


//-------------------------------------------------------------
//	LoadCPUSectionByID
//-------------------------------------------------------------
BOOL LoadCPUSectionByID( UINT32 CPUID )
{
  std::map< UINT32, std::string >::iterator i = g_CPUIDToSectionMap.find( CPUID );
  if( i == g_CPUIDToSectionMap.end() )
    return FALSE;
  void *addr;
  PRINTMSG(( T_INFO, "Load section CPU%lu, ID %s\n", CPUID, (*i).second.c_str() ));
  addr = XLoadSection( (*i).second.c_str() );
  if( !addr )
  {
    UINT32 lastErr = GetLastError();
    PRINTMSG(( T_ERROR, "XLoadSection failed for section %s! 0x%X\r\n", (*i).second.c_str(), lastErr ));
  }
  return TRUE;
}


//-------------------------------------------------------------
//	UnloadCPUSectionByID
//-------------------------------------------------------------
BOOL UnloadCPUSectionByID( UINT32 CPUID )
{
  std::map< UINT32, std::string >::iterator i = g_CPUIDToSectionMap.find( CPUID );
  if( i == g_CPUIDToSectionMap.end() )
    return FALSE;
  return XFreeSection( (*i).second.c_str() );
}


//-------------------------------------------------------------
//	LoadCPUSections
//-------------------------------------------------------------
BOOL LoadCPUSections( void )
{
  std::map< UINT32, std::string >::iterator i = g_CPUIDToSectionMap.begin();
  for( ; i != g_CPUIDToSectionMap.end(); ++i )
  {
    if( !XLoadSection( (*i).second.c_str() ) )
    {
      PRINTMSG(( T_ERROR, "Failed to load section %s!", (*i).second.c_str() ));
      //return FALSE;
    }
  }
  return TRUE;
}


//-------------------------------------------------------------
//	UnloadCPUSections
//-------------------------------------------------------------
BOOL UnloadCPUSections( void )
{
  std::map< UINT32, std::string >::iterator i = g_CPUIDToSectionMap.begin();
  for( ; i != g_CPUIDToSectionMap.end(); ++i )
  {
      // Only unload families once (all but the first member are skipped)
    if( (*i).first == CPU_M65C02 ||
        (*i).first == CPU_M6510 ||
        (*i).first == CPU_N2A03 ||
        (*i).first == CPU_DECO16 ||
        (*i).first == CPU_I186 ||
        (*i).first == CPU_V30 ||
        (*i).first == CPU_V33 ||
        (*i).first == CPU_V70 ||
        (*i).first == CPU_I8039 ||
        (*i).first == CPU_I8048 ||
        (*i).first == CPU_N7751 ||
        (*i).first == CPU_M6801 ||
        (*i).first == CPU_M6802 ||
        (*i).first == CPU_M6803 ||
        (*i).first == CPU_M6808 ||
        (*i).first == CPU_HD63701 ||
        (*i).first == CPU_NSC8105 ||
        (*i).first == CPU_M68705 ||
        (*i).first == CPU_HD63705 ||
        (*i).first == CPU_M68010 ||
        (*i).first == CPU_M68020 ||
        (*i).first == CPU_M68EC020 ||
        (*i).first == CPU_TMS34020 ||
        (*i).first == CPU_TMS9995 ||
        (*i).first == CPU_ADSP2101 ||
        (*i).first == CPU_ADSP2105 ||
        (*i).first == CPU_ADSP2115 ||
        (*i).first == CPU_R3000BE ||
        (*i).first == CPU_R3000LE ||
        (*i).first == CPU_R4600BE ||
        (*i).first == CPU_R4600LE ||
        (*i).first == CPU_R5000BE ||
        (*i).first == CPU_R5000LE ||
        (*i).first == CPU_UPD7807 ||
        (*i).first == CPU_JAGUARDSP ||
        (*i).first == CPU_PIC16C55 ||
        (*i).first == CPU_PIC16C56 ||
        (*i).first == CPU_PIC16C57 ||
        (*i).first == CPU_PIC16C58 )
        continue;
    XFreeSection( (*i).second.c_str() );
  }
  return TRUE;
}


//-------------------------------------------------------------
//	RegisterCPUSectionNames
//-------------------------------------------------------------
static void RegisterCPUSectionNames( void )
{
  RegisterSectionID( CPU_ADSP2100, "CPU26" );
  RegisterSectionID( CPU_ADSP2101, "CPU26" );
  RegisterSectionID( CPU_ADSP2105, "CPU26" );
  RegisterSectionID( CPU_ADSP2115, "CPU26" );
  RegisterSectionID( CPU_ARM, "CPU31" );
  RegisterSectionID( CPU_ASAP, "CPU28" );
  RegisterSectionID( CPU_CCPU, "CPU25" );
  RegisterSectionID( CPU_DSP32C, "CPU33" );
  RegisterSectionID( CPU_E132XS, "CPU47" );
  RegisterSectionID( CPU_G65816, "CPU48" );
  //RegisterSectionID( CPU_GENSYNC, "CPU49" );
  RegisterSectionID( CPU_H6280, "CPU5" );
  RegisterSectionID( CPU_HD6309, "CPU14" );
  RegisterSectionID( CPU_I386, "CPU50" );
  RegisterSectionID( CPU_I8035, "CPU9" );
  RegisterSectionID( CPU_I8039, "CPU9" );
  RegisterSectionID( CPU_I8048, "CPU9" );
  RegisterSectionID( CPU_N7751, "CPU9" );
  RegisterSectionID( CPU_Z80, "CPU3" );
  RegisterSectionID( CPU_I86, "CPU6" );
  RegisterSectionID( CPU_I186, "CPU6" );
  RegisterSectionID( CPU_I8X41, "CPU10" );
  RegisterSectionID( CPU_I960, "CPU51" );
  RegisterSectionID( CPU_JAGUARGPU, "CPU30" );
  RegisterSectionID( CPU_JAGUARDSP, "CPU30" );
  RegisterSectionID( CPU_KONAMI, "CPU15" );
  RegisterSectionID( CPU_M6502, "CPU4" );
  RegisterSectionID( CPU_M65C02, "CPU4" );
  RegisterSectionID( CPU_M6510, "CPU4" );
  RegisterSectionID( CPU_N2A03, "CPU4" );
  RegisterSectionID( CPU_DECO16, "CPU4" );
  RegisterSectionID( CPU_M6800, "CPU11" );
  RegisterSectionID( CPU_M6801, "CPU11" );
  RegisterSectionID( CPU_M6802, "CPU11" );
  RegisterSectionID( CPU_M6803, "CPU11" );
  RegisterSectionID( CPU_M6808, "CPU11" );
  RegisterSectionID( CPU_HD63701, "CPU11" );
  RegisterSectionID( CPU_NSC8105, "CPU11" );
  RegisterSectionID( CPU_M68000, "CPU16" );
  RegisterSectionID( CPU_M68010, "CPU16" );
  RegisterSectionID( CPU_M68020, "CPU16" );
  RegisterSectionID( CPU_M68EC020, "CPU16" );
  RegisterSectionID( CPU_M6805, "CPU12" );
  RegisterSectionID( CPU_M68705, "CPU12" );
  RegisterSectionID( CPU_HD63705, "CPU12" );
  RegisterSectionID( CPU_M6809, "CPU13" );
  RegisterSectionID( CPU_PSXCPU, "CPU27" );
  RegisterSectionID( CPU_R3000BE, "CPU27" );
  RegisterSectionID( CPU_R3000LE, "CPU27" );
  RegisterSectionID( CPU_R4600BE, "CPU27" );
  RegisterSectionID( CPU_R4600LE, "CPU27" );
  RegisterSectionID( CPU_R5000BE, "CPU27" );
  RegisterSectionID( CPU_R5000LE, "CPU27" );
  RegisterSectionID( CPU_V20, "CPU7" );
  RegisterSectionID( CPU_V30, "CPU7" );
  RegisterSectionID( CPU_V33, "CPU7" );
  RegisterSectionID( CPU_PIC16C54, "CPU34" );
  RegisterSectionID( CPU_PIC16C55, "CPU34" );
  RegisterSectionID( CPU_PIC16C56, "CPU34" );
  RegisterSectionID( CPU_PIC16C57, "CPU34" );
  RegisterSectionID( CPU_PIC16C58, "CPU34" );
  RegisterSectionID( CPU_S2650, "CPU18" );
  RegisterSectionID( CPU_SH2, "CPU32" );
  RegisterSectionID( CPU_SPC700, "CPU52" );
  RegisterSectionID( CPU_T11, "CPU17" );
  RegisterSectionID( CPU_TMS32010, "CPU22" );
  RegisterSectionID( CPU_TMS32025, "CPU23" );
  RegisterSectionID( CPU_TMS32031, "CPU24" );
  RegisterSectionID( CPU_TMS34010, "CPU19" );
  RegisterSectionID( CPU_TMS34020, "CPU19" );
  RegisterSectionID( CPU_TMS9980, "CPU20" );
  RegisterSectionID( CPU_TMS9995, "CPU20" );
  RegisterSectionID( CPU_UPD7810, "CPU29" );
  RegisterSectionID( CPU_UPD7807, "CPU29" );
  RegisterSectionID( CPU_V60, "CPU8" );
  RegisterSectionID( CPU_V70, "CPU8" );
  RegisterSectionID( CPU_Z180, "CPU2" );
  RegisterSectionID( CPU_Z80, "CPU1" );
  RegisterSectionID( CPU_Z8000, "CPU21" );
}
#pragma code_seg()
#pragma data_seg()
#pragma const_seg()
#pragma bss_seg()


} // End extern "C"


