#pragma code_seg("C3")
#pragma data_seg("D3")
#pragma bss_seg("B3")
#pragma const_seg("K3")
#pragma comment(linker, "/merge:D3=3")
#pragma comment(linker, "/merge:C3=3")
#pragma comment(linker, "/merge:B3=3")
#pragma comment(linker, "/merge:K3=3")
#include "driver.h"
#include "system16.h"

//int sys16_sh_shadowpal;
//int sys16_MaxShadowColors;

data16_t *sys16_workingram;
data16_t *sys16_workingram2;
data16_t *sys16_extraram;
data16_t *sys16_extraram2;
data16_t *sys16_extraram3;
data16_t *sys16_extraram4;

static void patch_codeX( int offset, int data, int cpu ){
	int aligned_offset = offset&0xfffffe;
	data16_t *mem = (data16_t *)memory_region(REGION_CPU1+cpu);
	int old_word = mem[aligned_offset/2];

	if( offset&1 )
		data = (old_word&0xff00)|data;
	else
		data = (old_word&0x00ff)|(data<<8);

	mem[aligned_offset/2] = data;
}

void sys16_patch_code( int offset, int data ){
	patch_codeX(offset,data,0);
}
void sys16_patch_code2( int offset, int data ){
	patch_codeX(offset,data,2);
}
void sys16_patch_z80code( int offset, int data ){
	UINT8 *RAM = memory_region(REGION_CPU2);
	RAM[offset] = data;
}


READ16_HANDLER( SYS16_MRA16_WORKINGRAM2_SHARE ){ return sys16_workingram2[offset]; }
WRITE16_HANDLER( SYS16_MWA16_WORKINGRAM2_SHARE ){ COMBINE_DATA( &sys16_workingram2[offset] ); }
READ16_HANDLER( SYS16_MRA16_ROADRAM_SHARE ){ return sys16_roadram[offset]; }
WRITE16_HANDLER( SYS16_MWA16_ROADRAM_SHARE ){ COMBINE_DATA( &sys16_roadram[offset] ); }
READ16_HANDLER( SYS16_CPU3ROM16_r ){
	const data16_t *pMem = (data16_t *)memory_region(REGION_CPU3);
	return pMem[offset];
}
READ16_HANDLER( SYS16_CPU2_RESET_HACK ){
	cpunum_set_input_line(2, INPUT_LINE_RESET, PULSE_LINE);
	return 0;
}

void (*sys16_custom_irq)(void);

extern int sys16_wwfix, sys16_alienfix;

MACHINE_INIT( sys16_onetime ){
	sys16_wwfix = sys16_alienfix = 0;
	sys16_bg1_trans=0;
	sys16_rowscroll_scroll=0;
	sys18_splittab_bg_x=0;
	sys18_splittab_bg_y=0;
	sys18_splittab_fg_x=0;
	sys18_splittab_fg_y=0;

	sys16_quartet_title_kludge=0;

	sys16_custom_irq=NULL;

//	sys16_MaxShadowColors = NumOfShadowColors;

#ifdef SPACEHARRIER_OFFSETS
	spaceharrier_patternoffsets=0;
#endif
}

static struct GfxLayout charlayout =
{
	8,8,
	RGN_FRAC(1,3),
	3,
	{ RGN_FRAC(2,3), RGN_FRAC(1,3), RGN_FRAC(0,3) },
	{ 0, 1, 2, 3, 4, 5, 6, 7 },
	{ 0*8, 1*8, 2*8, 3*8, 4*8, 5*8, 6*8, 7*8 },
	8*8
};

struct GfxDecodeInfo sys16_gfxdecodeinfo[] = {
	{ REGION_GFX1, 0, &charlayout,	0, 1024 },
	{ -1 } /* end of array */
};

void sys16_interleave_sprite_data( int bank_size )
{
	unsigned char *temp = osd_malloc( bank_size );
	bank_size/=4;
	if( temp ){
		unsigned char *base = memory_region(REGION_GFX2);
		unsigned char *p1 = temp;
		unsigned char *p2 = temp+bank_size;
		unsigned char *p3 = temp+bank_size*2;
		unsigned char *p4 = temp+bank_size*3;

		memcpy (temp, base, bank_size*4 );

		while( bank_size-- ){
			*base++ = *p4++;
			*base++ = *p3++;
			*base++ = *p2++;
			*base++ = *p1++;
		}
	}
	free( temp );
}

void system16_decode(data16_t *dest,data16_t *source,int size,unsigned short *decrypt_data)
{
	int offset,data,decode_offset,mask;

	for(offset=0;offset<size;offset+=2)
	{
		data=source[offset/2];

		switch(offset & 0x22a)
		{
			default:
			case 0x000:	mask=0;		break;
			case 0x002:	mask=1;		break;
			case 0x008:	mask=2;		break;
			case 0x00a:	mask=3;		break;
			case 0x020:	mask=4;		break;
			case 0x022:	mask=5;		break;
			case 0x028:	mask=6;		break;
			case 0x02a:	mask=7;		break;
			case 0x200:	mask=8;		break;
			case 0x202:	mask=9;		break;
			case 0x208:	mask=10;	break;
			case 0x20a:	mask=11;	break;
			case 0x220:	mask=12;	break;
			case 0x222:	mask=13;	break;
			case 0x228:	mask=14;	break;
			case 0x22a:	mask=15;	break;
		}

		decode_offset = ((data >> 8) & 0xfc ) | ((data >> 5) & 0x2 ) | ((data >> 3) & 0x1 );

		data^= decrypt_data[mask*256+decode_offset];

//		if(decrypt_data[mask*256+decode_offset] == 0xffff)
//			logerror("Decrypt Error: Offset=%5x\n",offset);

		dest[offset/2] = data;
	}
}

/***********************************************************************************
      Decryption Tables for Endurob2
***********************************************************************************/
unsigned short enduroracer_decrypt_data[16][256]=
{
{//table for address mask 0000:
0xdc40,0xd448,0xd800,0xd008,0x5048,0x5840,0x5408,0x5c00,0xb400,0xbc08,0xb040,0xb848,0xa808,0xa000,0xac48,0xa440,
0xdc40,0xd448,0xd800,0xd008,0x5048,0x5840,0xffff,0x5c00,0xb400,0xbc08,0xb040,0xb848,0xffff,0xa000,0xffff,0xffff,
0x5440,0x5c48,0x5000,0x5808,0xd848,0xffff,0xffff,0xd400,0xb400,0xbc08,0xffff,0xb848,0xa808,0xa000,0xffff,0xffff,
0x5440,0x5c48,0x5000,0x5808,0xd848,0xd040,0xffff,0xd400,0xffff,0xbc08,0xb040,0xb848,0xa808,0xa000,0xffff,0xffff,
0xdc40,0xd448,0xd800,0xd008,0x5048,0x5840,0x5408,0x5c00,0xac00,0xa408,0xa840,0xa048,0xb008,0xb800,0xb448,0xbc40,
0xdc40,0xd448,0xd800,0xd008,0x5048,0x5840,0x5408,0x5c00,0xac00,0xa408,0xffff,0xa048,0xffff,0xb800,0xffff,0xffff,
0x5440,0x5c48,0x5000,0xffff,0xd848,0xd040,0xdc08,0xd400,0xac00,0xa408,0xffff,0xffff,0xb008,0xb800,0xb448,0xffff,
0x5440,0x5c48,0x5000,0xffff,0xd848,0xffff,0xffff,0xffff,0xffff,0xa408,0xa840,0xa048,0xb008,0xb800,0xffff,0xbc40,
0xdc40,0xd448,0xd800,0xd008,0x5048,0xffff,0xffff,0x5c00,0xb400,0xbc08,0xb040,0xb848,0xa808,0xa000,0xac48,0xa440,
0xdc40,0xd448,0xd800,0xd008,0x5048,0x5840,0x5408,0xffff,0xb400,0xbc08,0xffff,0xb848,0xffff,0xa000,0xac48,0xffff,
0xffff,0x5c48,0x5000,0xffff,0xd848,0xffff,0xdc08,0xd400,0xb400,0xbc08,0xb040,0xb848,0xa808,0xa000,0xac48,0xa440,
0xffff,0xffff,0x5000,0x5808,0xffff,0xffff,0xdc08,0xffff,0xb400,0xbc08,0xb040,0xb848,0xa808,0xa000,0xac48,0xa440,
0xdc40,0xd448,0xd800,0xd008,0xffff,0xffff,0xffff,0xffff,0xac00,0xffff,0xa840,0xffff,0xb008,0xffff,0xb448,0xbc40,
0xdc40,0xd448,0xd800,0xd008,0x5048,0xffff,0xffff,0x5c00,0xffff,0xa408,0xffff,0xffff,0xffff,0xffff,0xb448,0xffff,
0x5440,0x5c48,0x5000,0x5808,0xd848,0xd040,0xdc08,0xd400,0xac00,0xa408,0xa840,0xa048,0xffff,0xb800,0xffff,0xffff,
0xffff,0x5c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xd400,0xac00,0xffff,0xffff,0xa048,0xb008,0xb800,0xb448,0xbc40},
{//table for address mask 0001:
0x6440,0x6048,0xc800,0x9440,0xa048,0xf440,0x0408,0xf848,0x4c08,0x0808,0x8008,0x8400,0x2000,0xc400,0x1400,0x4008,
0x3800,0x5c08,0x0408,0xc848,0x1440,0xe800,0x3008,0xffff,0x0848,0xdc48,0x3c48,0xc840,0xac48,0xffff,0xc000,0x3408,
0xb848,0x2c40,0x6440,0x2040,0xffff,0xffff,0x5800,0x3440,0x7840,0xffff,0x0408,0x9848,0xf440,0x8040,0xc840,0x6c48,
0x9408,0xf000,0x2000,0xf400,0x4848,0x2408,0x9c48,0x3840,0xe400,0x2008,0x9800,0x9440,0x2808,0x9c08,0x4c40,0xffff,
0xb040,0xe448,0x9440,0x0800,0x4c40,0xffff,0x6848,0x8c48,0xb048,0xf448,0x9408,0x6000,0xffff,0x7840,0x0800,0x3440,
0xdc00,0xe808,0x0848,0x0408,0xffff,0xffff,0xffff,0xc000,0x6408,0xb008,0xffff,0x2c40,0x1848,0xffff,0x8c08,0xffff,
0x3c48,0x5840,0x9800,0xdc00,0x0000,0x3408,0xbc08,0xc808,0x5c40,0xffff,0xffff,0xffff,0x7008,0xe400,0xffff,0xa848,
0x1008,0x8400,0xffff,0x9840,0x1400,0xffff,0x6040,0xffff,0xf000,0x6408,0xffff,0xffff,0x1440,0xffff,0xe048,0xe440,
0x4848,0x1408,0x6400,0xf008,0xe448,0xffff,0x3848,0xffff,0xffff,0x7440,0x9408,0xffff,0xffff,0xffff,0x9000,0xffff,
0x8440,0x4800,0xa840,0x5c48,0x2800,0xffff,0xe408,0x7000,0xffff,0xffff,0x7848,0xffff,0xf008,0xd408,0xffff,0xffff,
0xffff,0xffff,0xd808,0x5c08,0xe808,0x8c00,0x3440,0xffff,0xffff,0xffff,0xe800,0xffff,0xf800,0x8c00,0x4c40,0x1848,
0x4008,0x8400,0xcc48,0xd848,0x2408,0xffff,0xffff,0x8c40,0xffff,0x1408,0xe440,0xb048,0xe448,0xffff,0x9840,0x6c48,
0x1408,0x8848,0x2000,0xe408,0xffff,0xffff,0xffff,0x1008,0xcc00,0xffff,0xd008,0x8400,0xffff,0x9c40,0xffff,0xc800,
0x8800,0x8440,0xdc40,0x7848,0xffff,0xd848,0xb840,0x9c40,0xffff,0xffff,0xffff,0x9840,0xffff,0xd848,0xa808,0x9c00,
0xe848,0xffff,0xe448,0x6048,0x1400,0xd008,0xb048,0xc448,0xd800,0x8440,0xffff,0x3808,0xf408,0x3000,0xffff,0x0408,
0x9408,0xffff,0xffff,0xffff,0x5000,0x3408,0xffff,0xffff,0xffff,0xd848,0xffff,0x6448,0x7800,0x1440,0xf448,0xa040},
{//table for address mask 0004:
0x9440,0x9440,0xec40,0x7c40,0xac08,0xa048,0x1448,0x7808,0x8840,0x7840,0x6000,0xf040,0xc848,0x5448,0x4c48,0xb008,
0x4008,0xe008,0xa808,0x9808,0x7008,0x7008,0xffff,0x0808,0xcc08,0xffff,0x4408,0x8408,0x8400,0x1440,0x6c40,0x9c40,
0xd800,0xe840,0x9000,0x3000,0xffff,0x1800,0xffff,0xffff,0x3408,0x5848,0xffff,0x8008,0x8c40,0x4000,0x6800,0xffff,
0x0c48,0x9c48,0xd408,0xd448,0x3440,0x9440,0xffff,0x7c40,0x8c40,0xffff,0x5400,0x0840,0x9008,0x5008,0x1808,0xb848,
0xa800,0x3800,0xd000,0xd000,0x3848,0x6408,0xec08,0x2008,0xb400,0x9040,0x7800,0x5c00,0x0040,0x6040,0x7840,0x8840,
0xec48,0xdc48,0x0448,0xa448,0x1400,0xffff,0x5c00,0x6c40,0xffff,0x7448,0xffff,0xffff,0xdc00,0xb040,0x0440,0x0800,
0xe440,0x0040,0x8800,0xffff,0x1c40,0xe040,0x5840,0x3400,0xdc08,0x4048,0x6448,0x9808,0x8408,0x4408,0x6c08,0x3c08,
0xa008,0x8448,0x3c08,0xffff,0x6008,0x6048,0xffff,0x2848,0xffff,0x5800,0x4c00,0xffff,0x0448,0x3808,0xffff,0xe048,
0xd400,0xd840,0x0c40,0xffff,0x8408,0x7848,0xffff,0xa008,0x3848,0xc408,0xbc48,0x2048,0xe048,0xa808,0x2008,0x6808,
0x5c48,0x0008,0xe408,0xd848,0x1c48,0x8c48,0xffff,0xffff,0x2c00,0x8000,0xc840,0xffff,0xffff,0x7800,0x9000,0xb440,
0xffff,0x3408,0x2c48,0xffff,0xffff,0xffff,0x4400,0x8840,0x7408,0xffff,0x9c08,0xffff,0xffff,0x2c40,0xffff,0xec00,
0x7c40,0x1000,0x3840,0xc440,0xffff,0xf800,0xb000,0xffff,0xffff,0xa040,0x1840,0x4840,0xb808,0xac48,0x7448,0x6048,
0xcc00,0x3040,0x1440,0x8800,0xffff,0x9848,0x8048,0xffff,0x9408,0xdc08,0x5448,0x1c08,0xfc00,0x0c00,0x8400,0xffff,
0xb448,0x1808,0x0c08,0xc048,0xcc00,0xd840,0xa040,0xffff,0xffff,0xffff,0xd040,0xffff,0x0400,0x9840,0xdc40,0x2000,
0xffff,0x2c08,0xc448,0x4c48,0xc440,0xffff,0xa400,0x1c00,0xffff,0xffff,0x3048,0x5048,0xe848,0xb848,0xffff,0xc048,
0xffff,0xf800,0xffff,0xffff,0xffff,0xffff,0xd408,0xf048,0xffff,0x0c00,0xffff,0xe400,0x2c48,0xe008,0x9408,0x3848},
{//table for address mask 0005:
0xb400,0x0c08,0x8808,0xf040,0x3800,0x1048,0x3008,0x0c00,0x9c08,0x4400,0xffff,0x7848,0xd008,0xc840,0xe800,0x8408,
0x9440,0x7c08,0x2c08,0xf400,0x5c48,0x6040,0x8000,0xa848,0x7840,0xffff,0xfc48,0x8400,0xffff,0xffff,0xffff,0x4000,
0x5048,0x8840,0x7440,0x9c08,0xffff,0xb440,0x2c40,0x0808,0x2c08,0xffff,0x7400,0x4848,0x4040,0xffff,0x6808,0x1040,
0x5808,0x2040,0x0840,0xb048,0x9840,0xbc08,0xe408,0xffff,0x5040,0x6008,0xa848,0x1c40,0xa408,0x7c00,0xf440,0x1c08,
0xc400,0xbc08,0xac08,0x3040,0x3848,0xffff,0x4000,0xa848,0xac00,0x4448,0xcc48,0x1440,0x3800,0x0848,0x7448,0xc040,
0x6008,0xffff,0x2c40,0x5448,0xffff,0xffff,0x6040,0xd848,0x0048,0x7800,0x1800,0xa008,0xffff,0x4400,0x1040,0x2c08,
0x1848,0x8800,0xd040,0xa448,0xdc00,0x6408,0x4c48,0x3400,0xf440,0x9448,0x2808,0xffff,0x9408,0xec40,0x2000,0xffff,
0x3400,0x4008,0xffff,0x4800,0xa000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xb008,0xffff,0x2008,0xffff,0x2c40,
0xb408,0xcc40,0x1440,0xac48,0xffff,0xe040,0x6c40,0x1848,0x8c48,0xffff,0xffff,0xdc08,0x8440,0xe848,0xffff,0x1040,
0xbc48,0x6440,0x6840,0x8008,0x8800,0xfc08,0xb008,0xffff,0xd000,0xffff,0x4048,0x9840,0x8048,0x9400,0xac00,0xcc08,
0xffff,0x6008,0xffff,0xffff,0x7400,0xffff,0xc848,0x5400,0x4800,0xffff,0x5448,0xec40,0xffff,0x5c08,0xffff,0xa040,
0xa800,0x1008,0x6408,0xffff,0xffff,0x9800,0x9c40,0xe448,0xffff,0xffff,0x6040,0xffff,0xffff,0xffff,0xffff,0xe408,
0xffff,0xffff,0xc000,0xe448,0xffff,0xffff,0xa808,0x7000,0x0440,0xbc48,0xffff,0x0800,0x0008,0xb400,0xffff,0x3848,
0x7400,0x5048,0x2c08,0xffff,0xc000,0x7808,0xffff,0xd800,0xffff,0xc800,0xec00,0xffff,0x2c40,0x1008,0x8448,0xffff,
0xffff,0xf008,0xf408,0xc800,0xffff,0xffff,0x7c40,0xc448,0xfc08,0xe840,0x9400,0xf408,0xffff,0xf000,0x8840,0x6008,
0xffff,0xa440,0x6040,0xffff,0xd448,0xffff,0xffff,0xb448,0xb040,0xdc48,0xffff,0xffff,0x3c40,0x8448,0xe408,0x9c40},
{//table for address mask 0010:
0x3c08,0xac00,0x4c48,0xcc48,0x8c08,0x0848,0x9400,0x6800,0x0c48,0x1448,0x7c40,0x6408,0xb400,0xb000,0xac40,0xc040,
0x9c40,0x5800,0x0c48,0x5000,0x4c40,0x0c48,0xffff,0x0448,0xbc08,0xffff,0x6440,0x0840,0xffff,0xd400,0x1c08,0x5c08,
0x1440,0xd008,0xc440,0xcc08,0x0c08,0xffff,0x6008,0xe440,0x7c00,0x0840,0x7c08,0xfc00,0x9c00,0x5c08,0xd840,0xffff,
0xa400,0xe408,0xe848,0x8c08,0x4c48,0x4040,0xbc00,0xffff,0xdc48,0xffff,0x3000,0xe400,0x5c48,0xf808,0x6448,0x6c48,
0xffff,0xdc48,0x2000,0xe008,0x6008,0xffff,0xffff,0xb440,0x6c00,0xec08,0x1808,0x3840,0xffff,0xa440,0x9040,0x6c08,
0xa808,0x7c00,0x9000,0x5c00,0xffff,0x5c00,0xb848,0xf848,0xffff,0x5c48,0xffff,0xe448,0xffff,0xffff,0xffff,0x4000,
0x0808,0xf400,0x7000,0x5040,0x5c40,0x1c48,0x2448,0x2040,0x5048,0x9c40,0x2840,0x6848,0x0400,0x8c40,0x7c08,0x1000,
0xc440,0x4440,0x1c48,0xe040,0x6008,0x5c08,0xffff,0x3808,0x6c00,0x3c08,0xb408,0x7048,0xc848,0x4c08,0xffff,0x5048,
0xf808,0xffff,0x6c08,0x5000,0x1040,0xec40,0x4440,0x0448,0xc048,0xe048,0xffff,0xffff,0xffff,0xb400,0xffff,0xffff,
0xb848,0xffff,0x3c00,0x6c48,0xa000,0x2008,0xdc00,0xffff,0xffff,0x2c00,0xffff,0xffff,0x8000,0x8848,0xffff,0xffff,
0xd040,0xffff,0xffff,0xec48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xcc48,0x0848,0x8848,0xffff,0x8c48,
0xffff,0xffff,0x2c48,0xbc40,0xffff,0xffff,0x8800,0xac40,0xffff,0xffff,0xffff,0xc440,0xb808,0xffff,0xffff,0xbc08,
0xffff,0xe848,0x7048,0xb408,0x1c00,0xffff,0x9048,0x1040,0x9000,0xd008,0xc848,0x0c40,0xc448,0xc008,0xffff,0xa808,
0xec48,0xa808,0x4040,0xc800,0xffff,0x4040,0x9808,0x9c48,0x5400,0xffff,0x5040,0x1048,0xffff,0xffff,0xffff,0xffff,
0xa440,0xc000,0xffff,0x0008,0xffff,0x8000,0x1800,0x1008,0x1c08,0x5040,0x1408,0xb808,0xb840,0xe808,0xb040,0x3040,
0xc040,0x0048,0x7000,0xffff,0x9408,0xffff,0xffff,0x1848,0xffff,0x1000,0x2840,0x2000,0x4c40,0x5848,0x7c08,0x6000},
{//table for address mask 0011:
0x9c40,0x5848,0x2000,0xfc08,0xcc08,0x4808,0x9848,0xf448,0xd400,0xc048,0x6840,0x6408,0xc008,0xc408,0x9448,0x7848,
0x0840,0x9440,0x6c00,0xffff,0x1c08,0x9000,0x0c08,0x0c40,0x4000,0xffff,0x6000,0xffff,0x1008,0xffff,0x2448,0xc440,
0xf840,0x6040,0xd800,0x5008,0xe048,0xffff,0xffff,0x9c40,0xffff,0x2c40,0x4000,0x5c08,0xc808,0xa000,0x1800,0xffff,
0x7840,0xf048,0x8c48,0x4048,0xb448,0xec08,0x2848,0xa440,0x7440,0x6848,0xc048,0x0808,0x9c08,0x6008,0xe048,0xa840,
0x1c40,0x9448,0xa808,0xcc00,0x4840,0x2000,0xd000,0xe000,0xffff,0x9848,0xa408,0x8000,0xc440,0x0840,0x9840,0x2800,
0xffff,0x1448,0x9c08,0xd048,0xffff,0x7400,0xcc40,0x8448,0xffff,0x1848,0xffff,0x4848,0x1c08,0x5c40,0xc040,0x0848,
0x0008,0xac08,0xcc48,0x0c40,0x2c08,0xa000,0xc408,0xf048,0x4c08,0xe448,0x8048,0x2400,0xe408,0xffff,0xffff,0xfc48,
0xb440,0x3808,0xffff,0x9400,0xec40,0x7000,0xffff,0xb048,0x2c40,0x7048,0x6c40,0xffff,0x6040,0x7c00,0xffff,0xf808,
0x3c48,0xd040,0x2400,0xd800,0xac40,0xffff,0xd848,0x5440,0xffff,0x9c40,0x6c40,0x9400,0xe400,0xbc40,0xffff,0x9c40,
0xec48,0x2c08,0x7c00,0xf408,0xffff,0xffff,0xffff,0xf048,0xe048,0xb408,0xffff,0xffff,0xffff,0xffff,0xe048,0xffff,
0xb048,0x8408,0xd848,0x4008,0x9800,0xffff,0xffff,0xffff,0xffff,0x1c08,0x9448,0xffff,0x9400,0xffff,0xb848,0xffff,
0xe448,0x2440,0xd000,0x4448,0x1800,0xffff,0x9000,0xffff,0xcc08,0xffff,0xffff,0xffff,0x1400,0xffff,0x1c00,0xffff,
0xffff,0x7000,0xe808,0xd848,0xffff,0xf408,0xd400,0x8048,0xfc08,0x5840,0xe408,0x4048,0xffff,0xf808,0xffff,0x0c48,
0x6800,0x2400,0x5808,0x9800,0x6c40,0x7408,0xdc40,0xb800,0xf000,0xffff,0x7048,0xd400,0xe040,0x7808,0xd040,0xffff,
0xc000,0x5040,0xfc40,0xc840,0xc840,0xffff,0xe000,0xe048,0x5800,0x5c40,0xffff,0xe000,0xffff,0xffff,0x6c00,0xec48,
0xffff,0xffff,0xffff,0xd400,0xffff,0xffff,0x9c08,0xb448,0x0808,0x8c40,0xd448,0xd800,0x0048,0x4048,0x5408,0xfc08},
{//table for address mask 0014:
0x1c00,0x5c48,0xa408,0x8440,0x1c00,0x5c48,0x5440,0x5c48,0xb040,0xb848,0x5c00,0x1c48,0xf400,0xfc08,0xac48,0xa440,
0x3808,0xc400,0x4008,0x1848,0x1c48,0xc400,0xffff,0x1800,0x6448,0xffff,0xffff,0x1040,0xffff,0xffff,0xffff,0x1008,
0xd448,0xa000,0x6800,0x8c00,0xd448,0x3c48,0x2008,0xffff,0xffff,0x3808,0x0008,0xf800,0xa048,0xa440,0x2800,0xdc40,
0x9c40,0x3c08,0xc440,0x8448,0xd800,0x1800,0xec48,0xffff,0x3c00,0x3400,0xcc48,0x6c48,0x3c00,0xffff,0x8440,0x2808,
0xe048,0x6048,0xcc48,0xd800,0x5440,0xffff,0xcc48,0x2808,0x1840,0x9c48,0x9008,0x7008,0xcc48,0x9c48,0xb448,0x7000,
0xffff,0x3400,0x1840,0x3c48,0xffff,0x1040,0x5c00,0xe400,0xffff,0xffff,0xffff,0x6440,0x0c08,0xc400,0xffff,0x2c08,
0x2c40,0xd800,0x9400,0x7000,0x4008,0x0c48,0x9400,0x5440,0x4448,0x1008,0x3440,0xffff,0x2800,0x5440,0x7000,0xffff,
0xc440,0x5c48,0xffff,0xffff,0xa808,0xffff,0x0848,0xf008,0xac48,0x6440,0x7c48,0xffff,0xc000,0x0848,0x7c48,0xffff,
0xa840,0xa000,0x1008,0xd800,0xffff,0x8440,0xa840,0xffff,0x1c00,0xd400,0xb800,0xffff,0x1c00,0xd400,0x9048,0xf800,
0xa448,0xffff,0x7c08,0x6c48,0xffff,0x7008,0xffff,0xffff,0x7008,0xdc48,0x4400,0x6440,0xffff,0xdc48,0xfc48,0xffff,
0xcc08,0xd800,0xc440,0xe048,0xe848,0x4448,0xffff,0xa408,0xffff,0x4008,0xffff,0xffff,0xffff,0xdc40,0x9c40,0xffff,
0xffff,0xffff,0x7000,0xe400,0x3c00,0x4840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc000,0x4048,0xffff,0x9c00,
0x7008,0xd400,0xd808,0xffff,0xec00,0xd400,0xfc48,0xffff,0xffff,0xffff,0x0c48,0xffff,0xd408,0xffff,0xffff,0xa440,
0x3848,0xffff,0xb400,0x5048,0xffff,0xffff,0xb400,0x1800,0xffff,0xec48,0x0040,0x9840,0x9c48,0xffff,0xffff,0xffff,
0xc440,0x2800,0x2c40,0xc448,0x7008,0xffff,0x6800,0xc448,0xfc48,0xffff,0x9400,0x3848,0xffff,0xa440,0x9400,0xffff,
0xffff,0xffff,0xffff,0x9c00,0xffff,0x1800,0xbc48,0x9c00,0xffff,0xbc00,0xffff,0xffff,0x2800,0x2008,0x4048,0x4840},
{//table for address mask 0015:
0xb800,0x1408,0x7840,0x5048,0x7040,0x7040,0x2c00,0x2c00,0x2840,0x6048,0x9800,0x9400,0xbc08,0x3808,0xa040,0x8448,
0x2840,0xa840,0x0808,0xe808,0x2c08,0xc000,0xffff,0x0848,0x8808,0x4008,0x2848,0xdc48,0xffff,0xffff,0xffff,0x5008,
0xc440,0x0040,0x3400,0x7000,0x9c08,0x3800,0x0048,0xcc48,0x4808,0xb408,0xa448,0x1448,0x7c40,0x4040,0x3c08,0xffff,
0xb408,0xe008,0x9440,0x3840,0xbc40,0xd440,0x6c00,0xffff,0x0840,0xc848,0x3400,0x5c00,0x6c08,0xc008,0x9048,0xe040,
0xbc40,0xb040,0x2c00,0x4c00,0xb400,0x5000,0x3c48,0x4440,0x3808,0x8800,0xe848,0xc848,0xffff,0x0440,0x9400,0x0c00,
0xa808,0xa408,0x9c48,0x9c48,0xfc40,0x2840,0x4c00,0x9800,0xffff,0xffff,0xf800,0x8408,0x8408,0x7c08,0x4448,0xbc48,
0x5000,0x6008,0x8448,0x6848,0xdc40,0xb048,0xffff,0x3c00,0x6840,0xffff,0xffff,0x2c08,0x8800,0xb408,0xffff,0x4448,
0xe048,0x7440,0xffff,0xe400,0x5c08,0x3808,0xffff,0xffff,0x8808,0xec08,0x1448,0x3c48,0x5848,0xffff,0xffff,0xffff,
0xffff,0x6440,0xffff,0xe000,0xffff,0xffff,0xffff,0xd840,0xffff,0xf408,0xc448,0x0040,0x2848,0x6c48,0xffff,0xffff,
0xe000,0xffff,0x3448,0x2c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xf040,0xe400,0xcc00,0xffff,0xffff,0xffff,0xf448,
0xffff,0xffff,0xcc40,0x6048,0xffff,0xffff,0xffff,0xffff,0x2848,0x5440,0xffff,0x4008,0x8008,0xf008,0xc448,0xffff,
0xb440,0xc040,0xffff,0x3c00,0xd000,0xa408,0x5448,0x3848,0x0800,0x0c08,0xffff,0xec48,0xffff,0xffff,0xffff,0xffff,
0xfc08,0x5008,0xf448,0xffff,0xffff,0xffff,0xffff,0xffff,0xe448,0xdc40,0xc008,0x1800,0xdc08,0x8408,0x2048,0x8c48,
0xb440,0xa048,0x4400,0x8c00,0xec00,0x0808,0xf840,0xd848,0xffff,0xdc08,0x2040,0x7048,0xf840,0xffff,0xf000,0x8808,
0xd440,0x2040,0xa800,0x2800,0x3408,0xffff,0xc040,0x2c48,0xec08,0x9c08,0x4048,0x8848,0xffff,0x9440,0xe400,0x2008,
0x9408,0xb000,0xd048,0xffff,0xb440,0xb840,0xe400,0xe800,0x0c40,0xffff,0xf808,0xbc00,0x4008,0x6800,0xf048,0x7848},
{//table for address mask 0100:
0x8448,0x0c00,0x6c08,0xf040,0x9440,0x7c48,0x4c40,0x2048,0xf008,0x4c08,0x6848,0x2408,0x2000,0x6c40,0xe840,0xa440,
0x0c48,0xd440,0xb448,0x7840,0x1000,0xd048,0x6440,0xffff,0x3408,0x9c48,0xfc08,0x5408,0xf408,0x5008,0xffff,0x3808,
0xc048,0x0040,0x7448,0xa040,0x7c00,0xf000,0xffff,0x6840,0x8400,0x4040,0x4c40,0x8840,0x6c48,0xf000,0xffff,0x0c40,
0x1808,0x8840,0xfc48,0x7800,0x7048,0x8408,0xb848,0xffff,0x5840,0x8840,0x3040,0x1000,0x4408,0x9000,0xf008,0x3000,
0x0c48,0x7008,0xc448,0xb848,0x4448,0xd800,0xb808,0x3040,0x1c00,0x7008,0xc400,0x2c08,0xffff,0xc808,0xa848,0xa008,
0xdc48,0x2448,0x4408,0x4c48,0x2448,0xffff,0x8448,0x4440,0xffff,0xa808,0x1c00,0x5448,0xffff,0xa440,0x7c40,0x6c40,
0x3000,0xa400,0xffff,0x3c40,0xb848,0x1008,0x7048,0xd848,0x0400,0xffff,0x7040,0xffff,0xf800,0x1008,0xa400,0xffff,
0x6840,0x7800,0xffff,0xffff,0xe400,0xffff,0xffff,0xac40,0xdc00,0x3808,0x0800,0x6808,0x5400,0xffff,0xa440,0xffff,
0x5440,0x3848,0x0840,0xe048,0xdc40,0x9408,0xa400,0x6848,0xe000,0x7840,0x2840,0xb040,0xe440,0xffff,0x8c40,0xffff,
0x8c40,0x4008,0x7000,0x3848,0xf840,0x9848,0x2c40,0xc848,0xffff,0xffff,0x5840,0xffff,0xb808,0x9848,0xffff,0xffff,
0x6400,0x2048,0x9440,0xffff,0xffff,0xa400,0xf400,0x6c00,0xffff,0x2408,0x5c48,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xf848,0x4c40,0x2c48,0xffff,0xc848,0xb008,0xa048,0xffff,0xf848,0xc408,0xffff,0xffff,0xffff,0xb848,0x2800,
0xffff,0x9000,0x3000,0x0840,0xffff,0x9040,0xf048,0xffff,0xffff,0x9000,0xffff,0x7840,0xffff,0x0c48,0xffff,0xc408,
0x0c40,0x4000,0xc400,0x8800,0x6c08,0xffff,0x9c48,0x0c00,0xc008,0xffff,0xffff,0xa000,0xffff,0xffff,0xffff,0xffff,
0x3448,0x1408,0xfc48,0xdc48,0xec48,0xffff,0xffff,0x3848,0x1408,0xd400,0xffff,0x6000,0x1040,0xffff,0xec00,0xffff,
0xe848,0xffff,0xffff,0xffff,0xffff,0xffff,0x6000,0xa400,0xffff,0xffff,0x6c48,0xffff,0x1c00,0x7c08,0x4c00,0xa808},
{//table for address mask 0101:
0x2000,0xf448,0xac00,0x4c48,0x5c40,0x5000,0x3440,0x9800,0x4840,0x9c08,0x3040,0xd008,0xc000,0x3808,0xf848,0x5040,
0x3800,0xc840,0xd000,0x8440,0xffff,0x9000,0xffff,0xffff,0x3040,0xd040,0xd840,0x0c40,0xffff,0xffff,0x5008,0x6800,
0x9800,0xa008,0x6048,0x0840,0x5c40,0xe840,0xffff,0x9040,0xffff,0x7408,0x0848,0x5c08,0x1408,0xec00,0x2c40,0xffff,
0x7c08,0x4400,0x8440,0xec48,0xb408,0x4400,0xffff,0x3800,0x9800,0xcc08,0x8400,0x7408,0x7c48,0x1440,0xffff,0xbc08,
0x4c00,0xbc40,0x3000,0x6440,0xffff,0xffff,0x6840,0xa400,0x6440,0xa800,0xcc40,0xa000,0xffff,0x4048,0x4c48,0x3c48,
0x4008,0x9440,0xc808,0x2840,0x0040,0xffff,0xc840,0x6400,0x3800,0x6440,0xa000,0x5c40,0xdc48,0xffff,0xf448,0x4000,
0xb008,0x7800,0xe840,0x7048,0xf040,0x0048,0xbc40,0x1848,0xf440,0x5800,0xffff,0x3000,0xa808,0x5800,0x1408,0xffff,
0x5400,0x9c08,0x0c48,0xffff,0x6c00,0xffff,0x2400,0x5400,0xc800,0xffff,0x3000,0xffff,0x1440,0xb000,0x3840,0xc800,
0x3c48,0xdc48,0x2048,0xf448,0x5000,0xcc40,0xffff,0x3440,0xffff,0xffff,0x1848,0x4c08,0xe808,0xe000,0x7040,0x2848,
0xd000,0x8408,0xa800,0x5808,0x9000,0x6c40,0xa800,0xffff,0x8848,0xdc40,0x0048,0xffff,0xe048,0xffff,0xb800,0x7008,
0xa040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa448,0x4400,0x3c00,0x3408,0xa448,0xffff,
0xffff,0xec40,0xffff,0xffff,0xffff,0xffff,0xb408,0x4448,0xa400,0xffff,0x4800,0x9c00,0xffff,0xac48,0xffff,0xffff,
0x3048,0xffff,0xdc48,0xffff,0xffff,0xc040,0xffff,0xf840,0xffff,0xffff,0x9040,0x9c00,0xffff,0xec48,0xc440,0xffff,
0x5808,0xb808,0x4008,0x9408,0x9c00,0x0040,0x6400,0x5840,0x5400,0x6840,0xffff,0xffff,0xffff,0x6000,0x8c40,0xffff,
0xe848,0xffff,0xffff,0x7808,0xffff,0x8848,0xf008,0x0048,0xffff,0xc400,0xffff,0x6c00,0x3408,0x8008,0xffff,0xffff,
0x0c40,0xffff,0x9408,0x9c00,0x2400,0xffff,0xffff,0x4848,0xc400,0xffff,0xfc00,0xffff,0xe840,0x9808,0x3440,0x8008},
{//table for address mask 0104:
0x4440,0x2800,0x9848,0xb048,0x8808,0xb000,0x8c48,0xb440,0xa440,0xac48,0x3040,0x6800,0x5808,0x0448,0x2440,0x6c08,
0x3000,0x2800,0xdc00,0x4848,0xffff,0x2000,0xffff,0x4c40,0x7000,0x3c48,0x7408,0xf000,0xffff,0x0448,0x6008,0xf408,
0x4408,0xcc08,0xb448,0x3400,0xc008,0xf408,0xffff,0x3008,0x1c00,0xe840,0x3448,0xec48,0x9800,0xe040,0xffff,0xffff,
0xf040,0xcc08,0xc008,0x3c00,0x7440,0x6408,0xcc40,0x3808,0xffff,0x7840,0xe008,0x8448,0x2c48,0xe040,0xffff,0x8040,
0x3c00,0x3840,0xd408,0xc848,0x5400,0xffff,0xd000,0xa048,0x4848,0x8008,0x0c40,0xbc00,0xffff,0x8400,0x0848,0xe400,
0xe808,0xf040,0x6040,0xc848,0x2008,0xffff,0x6448,0x3048,0x3c40,0xffff,0xffff,0x2c00,0xffff,0xffff,0xbc00,0xe400,
0x5c00,0x4c08,0xffff,0x2c40,0x5808,0x4800,0x2448,0xe440,0xe448,0xf440,0x3800,0xf808,0xe040,0xf048,0xffff,0x0008,
0x1848,0x7408,0x6840,0x2c40,0x1c40,0x7000,0x5040,0x7440,0xa000,0xac40,0x4c08,0xffff,0xa408,0xffff,0xffff,0x0008,
0xc448,0xe000,0xf400,0x4c48,0x0800,0xffff,0x7000,0x5848,0x2448,0xffff,0xac08,0xe440,0xd800,0xfc48,0xffff,0xffff,
0xb008,0xf008,0x4048,0x4000,0xdc40,0x5c40,0xc448,0xc400,0xf008,0x7008,0x1840,0xffff,0xffff,0xec40,0x9c40,0x9c08,
0xffff,0xa440,0xffff,0xffff,0xffff,0xa808,0x9808,0xffff,0xb048,0x8440,0xb440,0xffff,0xa448,0xb808,0xffff,0x8408,
0x5c08,0xb448,0x4000,0xc448,0xffff,0xb800,0xffff,0x4048,0xf400,0x9448,0xffff,0x9c40,0xe000,0xa800,0xffff,0xffff,
0xac00,0x0008,0xdc08,0x7008,0x5400,0x8408,0xd800,0xffff,0xffff,0xffff,0xffff,0x9008,0x8048,0xdc00,0x6048,0xffff,
0x7808,0x3c40,0x9840,0x6000,0x2008,0x2840,0x9c48,0xffff,0xffff,0x9448,0x2008,0x8000,0x5440,0xffff,0xffff,0xffff,
0x6400,0x8440,0xffff,0x3448,0xffff,0xffff,0x2448,0x5800,0xbc48,0xffff,0xffff,0x7448,0xb840,0xffff,0x0000,0x2800,
0xd048,0xffff,0xf840,0x2440,0xd440,0xffff,0x5040,0xffff,0x0800,0xe000,0xffff,0x6440,0x0c08,0xf400,0xd408,0x3808},
{//table for address mask 0105:
0x8c08,0x7c08,0x3c48,0xe840,0x3008,0x3040,0x1400,0x5008,0x1c40,0x5c40,0x3848,0x7800,0x9040,0xc000,0x2000,0x7040,
0xa448,0x8040,0xcc48,0x9c08,0xd848,0x9840,0xffff,0x9400,0xc400,0x0008,0xac00,0xac48,0x8800,0xffff,0xffff,0x8448,
0xe840,0xb800,0xf000,0xd000,0xc008,0xd408,0x2c00,0xcc00,0xffff,0xffff,0x9040,0xd048,0xf408,0x8448,0xffff,0xfc48,
0x1008,0x7448,0x2448,0x1048,0x9840,0xdc08,0xd808,0xffff,0x8408,0xc400,0xe408,0x8448,0x3c40,0x4c48,0x5840,0x3c00,
0xf000,0x9440,0xd808,0x2808,0xd800,0x1c08,0x0040,0x4448,0x4048,0x0040,0x2c08,0x2848,0xffff,0xb808,0xc440,0x9400,
0x3c48,0x6c08,0x0c00,0x5c40,0x4000,0x4440,0xd000,0xffff,0xffff,0x6808,0xfc48,0xfc00,0xffff,0xffff,0x1048,0x6008,
0x0408,0x3040,0xffff,0x8048,0x9c48,0xffff,0xc840,0x0c48,0x8440,0xc008,0xffff,0x1000,0x3c08,0x1c08,0xffff,0xac00,
0xf840,0x8800,0x7400,0x0408,0xa448,0xffff,0xffff,0x7c40,0xd808,0x8848,0x2440,0x6008,0xc408,0x9448,0xffff,0x2840,
0x8c40,0xffff,0x5400,0x7040,0xffff,0xa008,0xdc48,0x9c40,0x8c08,0x8800,0xc000,0x2000,0x9008,0xc048,0x7848,0xffff,
0xffff,0xffff,0x8408,0xa408,0xd800,0x9808,0xffff,0x6848,0xc448,0xffff,0xffff,0x5448,0xffff,0xffff,0xa840,0xffff,
0xffff,0x9c40,0xffff,0x0840,0xffff,0xffff,0xffff,0xffff,0x3800,0x7c08,0xf840,0xf808,0xd048,0x8400,0xffff,0xffff,
0xc448,0xa008,0x2c48,0x7800,0xbc00,0xdc40,0x1440,0xffff,0xa048,0xffff,0xffff,0xffff,0xe800,0xffff,0xffff,0x6448,
0x2440,0x4000,0x4040,0x2008,0xd848,0xffff,0x3808,0xffff,0x6408,0xffff,0x2440,0xe048,0x4808,0xffff,0xffff,0x0848,
0xffff,0xffff,0xd440,0xf440,0xd048,0xffff,0xc840,0x8c08,0xf840,0xffff,0xd408,0x9400,0xffff,0xffff,0xffff,0xcc40,
0xffff,0xa008,0x9848,0xc808,0xffff,0xdc08,0xc408,0x8408,0xa000,0xc040,0xa808,0xa840,0xac40,0x8c40,0x2440,0xd440,
0xffff,0xffff,0xffff,0xffff,0x3400,0xffff,0xffff,0xffff,0xffff,0xffff,0x7c40,0x6840,0xc440,0x9400,0xd048,0x8008},
{//table for address mask 0110:
0x9040,0x9448,0x9800,0x9c08,0xc400,0xc008,0xcc40,0xc848,0x8048,0x8440,0x8808,0x8c00,0x4408,0x4000,0x4c48,0x4840,
0x9040,0x9448,0x9800,0x9c08,0xc400,0xc008,0xcc40,0xc848,0xffff,0xffff,0xffff,0x8c00,0x4408,0xffff,0x4c48,0x4840,
0x9040,0x9448,0x9800,0x9c08,0xffff,0x4808,0x4440,0xffff,0xffff,0x8440,0x8808,0x8c00,0xcc08,0xc800,0xc448,0xc040,
0x9040,0x9448,0x9800,0x9c08,0x4c00,0x4808,0x4440,0x4048,0x8048,0x8440,0x8808,0x8c00,0xcc08,0xc800,0xc448,0xffff,
0x8840,0x8c48,0x8000,0x8408,0xc400,0xc008,0xcc40,0xc848,0x9848,0x9c40,0x9008,0x9400,0x4408,0x4000,0x4c48,0x4840,
0xffff,0x8c48,0x8000,0x8408,0xc400,0xffff,0xcc40,0xc848,0xffff,0xffff,0xffff,0x9400,0x4408,0x4000,0x4c48,0x4840,
0x8840,0x8c48,0x8000,0x8408,0x4c00,0x4808,0x4440,0x4048,0x9848,0xffff,0xffff,0x9400,0xcc08,0xc800,0xc448,0xc040,
0x8840,0x8c48,0x8000,0x8408,0x4c00,0x4808,0x4440,0x4048,0x9848,0x9c40,0x9008,0xffff,0xcc08,0xc800,0xffff,0xc040,
0x9040,0x9448,0x9800,0x9c08,0xc400,0xc008,0xcc40,0xc848,0x8048,0x8440,0x8808,0x8c00,0xffff,0xffff,0xffff,0x4840,
0x9040,0x9448,0x9800,0x9c08,0xc400,0xc008,0xcc40,0xffff,0x8048,0x8440,0xffff,0xffff,0x4408,0x4000,0xffff,0x4840,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4048,0xffff,0x8440,0x8808,0xffff,0xcc08,0xffff,0xffff,0xffff,
0x9040,0xffff,0x9800,0xffff,0xffff,0x4808,0x4440,0x4048,0xffff,0xffff,0xffff,0x8c00,0xcc08,0xffff,0xffff,0xffff,
0x8840,0x8c48,0x8000,0x8408,0xc400,0xc008,0xcc40,0xc848,0x9848,0x9c40,0x9008,0xffff,0xffff,0xffff,0x4c48,0xffff,
0x8840,0x8c48,0x8000,0x8408,0xc400,0xc008,0xcc40,0xc848,0x9848,0x9c40,0x9008,0x9400,0xffff,0x4000,0xffff,0x4840,
0x8840,0x8c48,0x8000,0x8408,0x4c00,0xffff,0x4440,0x4048,0xffff,0xffff,0x9008,0x9400,0xcc08,0xc800,0xc448,0xc040,
0xffff,0xffff,0x8000,0xffff,0xffff,0xffff,0xffff,0x4048,0xffff,0x9c40,0xffff,0x9400,0xcc08,0xc800,0xc448,0xc040},
{//table for address mask 0111:
0x0848,0x3c00,0x2400,0x2c48,0x8008,0x3c48,0xb448,0x5408,0x9000,0x3c40,0x2c08,0x9448,0x6048,0x1400,0x9448,0x6400,
0x4408,0xd040,0x5840,0xf008,0x5448,0x0000,0x7400,0x1c48,0xf008,0xd448,0xc400,0xf440,0x1408,0x0c48,0x0800,0x9440,
0x8000,0x2c48,0x2800,0x0048,0x9c48,0xe008,0xffff,0xd848,0xa800,0x0040,0x1440,0x7000,0xffff,0xcc08,0x4c40,0xffff,
0x6808,0xdc40,0xd808,0xe840,0x4808,0xbc40,0xffff,0x9008,0x8440,0x7c00,0xf800,0xcc40,0xcc00,0xffff,0xc808,0x4c48,
0xa008,0xec40,0x3840,0xd808,0x0840,0xffff,0xe848,0xffff,0xffff,0xb000,0xb448,0xe800,0x0848,0xd800,0x3c00,0x4048,
0x2c48,0x5000,0x1400,0xc448,0x4000,0xffff,0xffff,0x4448,0x1040,0xffff,0xffff,0xffff,0x5808,0xffff,0xffff,0x1c08,
0xac48,0x8408,0x0440,0xa800,0xd048,0xbc08,0xb840,0xc000,0xe448,0x3408,0x8c08,0x0048,0x1408,0xf440,0xffff,0xffff,
0x5c40,0x6c00,0xec48,0xffff,0x1008,0xffff,0xffff,0xffff,0x6808,0x7848,0x5048,0x1c08,0xd448,0xffff,0xa408,0x0048,
0x0400,0xb840,0x3c40,0xdc00,0xffff,0xffff,0x7000,0xe840,0x9c48,0xac00,0xa848,0x8c00,0xffff,0xffff,0x2400,0xffff,
0xffff,0x5400,0xffff,0x6040,0xd408,0x6840,0xffff,0x5008,0x7440,0xcc08,0xc840,0x6408,0xffff,0xd000,0x5048,0xffff,
0xffff,0x1008,0x9040,0xffff,0xbc00,0xb840,0x0c40,0xffff,0xb048,0xffff,0x8800,0x0448,0xffff,0xe040,0xe408,0x8848,
0xffff,0xffff,0x7848,0x2408,0x9848,0xffff,0xffff,0x8c48,0xffff,0xffff,0xf440,0x4808,0x8c40,0x0808,0x8840,0xffff,
0xffff,0x9808,0x2008,0xffff,0x0c00,0xffff,0xffff,0x0848,0x8c00,0x5840,0xffff,0x8848,0xffff,0xffff,0x1c40,0x1808,
0x4008,0xd448,0xfc48,0xa408,0xffff,0xffff,0xa448,0x2c08,0xec08,0xffff,0xffff,0xffff,0x5c40,0xffff,0x3800,0xffff,
0x1400,0x5048,0xffff,0x9448,0xffff,0xd440,0xc408,0x5840,0x0c08,0x5440,0xffff,0x7408,0xffff,0xffff,0xffff,0x5448,
0xfc08,0xffff,0xa408,0xffff,0xe448,0xf008,0xf440,0xf400,0xffff,0xffff,0xac00,0x6848,0xe000,0xf040,0xd440,0x9800},
{//table for address mask 0114:
0x6448,0x2040,0x4400,0x0008,0xe848,0xe008,0xc800,0xe448,0x9008,0x8408,0x9448,0xc440,0xdc00,0x9c40,0xd840,0x9800,
0x1800,0xb840,0x7048,0xd408,0x0400,0xb800,0x6c48,0xffff,0x3440,0xffff,0xac00,0x4040,0x1848,0xffff,0xffff,0x4000,
0x0000,0xc440,0x2c48,0x5048,0xffff,0x5808,0x7000,0x1c40,0xffff,0x3008,0xc000,0x3808,0xffff,0x7440,0x4448,0xb408,
0x4c48,0x5c40,0xa448,0xf800,0xc048,0x0000,0xa400,0xd408,0xffff,0x3808,0x1800,0xfc40,0xd000,0x4c48,0xc048,0xe040,
0x4808,0x3408,0x0008,0xc000,0xffff,0x7800,0x2c00,0xb440,0xffff,0x7840,0x9848,0x8c48,0x6400,0xf440,0x8448,0xd008,
0x1000,0x0040,0x3840,0x1800,0xa848,0x2c48,0x7448,0x3040,0x9c48,0xf408,0xcc00,0x0448,0x6c00,0xffff,0x4000,0xffff,
0xf008,0xac40,0x3448,0x1440,0xd448,0x8048,0x9800,0x0840,0x4c40,0xec08,0xffff,0xffff,0xd000,0xffff,0x4448,0xffff,
0xa800,0x3808,0xffff,0xb008,0x4c48,0x7400,0xffff,0x3c08,0x7448,0xffff,0x7400,0xffff,0xd800,0xffff,0xcc48,0xb048,
0xc448,0x0440,0xc848,0x0808,0xe840,0xffff,0xd448,0x2c40,0x1800,0x4808,0xa000,0x5c40,0x0400,0xffff,0x8c08,0x3008,
0xc000,0xffff,0xcc00,0xdc08,0x8c08,0x3c08,0x4000,0xffff,0x3448,0x1000,0xffff,0xd840,0xffff,0xffff,0x7440,0xe808,
0xffff,0xec40,0xe440,0xf400,0x8008,0x8008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9048,0xd440,0xffff,0xffff,
0x6848,0xd448,0x6c40,0xfc48,0x4440,0x8808,0xac00,0xb040,0x0000,0xffff,0xb008,0xb008,0x1c00,0x4c40,0xffff,0x3c08,
0xd400,0xf408,0x9440,0x6808,0xffff,0xe808,0xd848,0x2c40,0x2048,0xffff,0x4400,0x4440,0xe008,0xffff,0xc800,0xd808,
0xdc00,0x2840,0x0c08,0xb008,0x0448,0xa440,0x2000,0xffff,0xffff,0xffff,0x2048,0xcc40,0xffff,0x2808,0xffff,0xffff,
0x6000,0xffff,0xffff,0x3808,0xd440,0x8c40,0xffff,0xb408,0xc448,0xffff,0xa800,0xffff,0xffff,0x2408,0x8c40,0x1c48,
0xffff,0xec08,0x2848,0xffff,0xec48,0xf008,0xe808,0xb040,0xffff,0xffff,0xffff,0xffff,0x0000,0xffff,0x0440,0x7400},
{//table for address mask 0115:
0x0c48,0xb440,0x3040,0xe848,0x6440,0x2800,0x0848,0x6c00,0x6c48,0x2840,0x2848,0x2448,0x4c48,0x4408,0x3848,0xa008,
0x8848,0xc848,0x3c08,0x6848,0xe040,0xffff,0x5400,0x0408,0xb840,0x5448,0xffff,0xa448,0x9840,0x4008,0x2000,0xc800,
0x0000,0xa440,0x7840,0xa008,0x3808,0xb008,0xffff,0x8008,0xb400,0x3840,0x1448,0xcc08,0xffff,0xdc00,0xe400,0xffff,
0xd400,0xd848,0xd048,0xd840,0xec08,0xb408,0x5800,0xffff,0xc008,0x4448,0xbc40,0x6040,0xd008,0xd800,0xc400,0xffff,
0xcc40,0x1408,0xf400,0x1c00,0xffff,0x0408,0xd400,0x9840,0x0048,0x0000,0xc808,0xd008,0x1808,0x3808,0xa000,0x5440,
0xf840,0x6000,0x2c48,0x7408,0xffff,0x7000,0x3c48,0x1840,0x3448,0xd400,0xffff,0xb800,0xffff,0xec08,0xffff,0xd440,
0x9448,0x9c40,0x5808,0x6440,0x6408,0xbc40,0xffff,0x5c48,0x5840,0xffff,0xffff,0xffff,0xa808,0xc440,0xc448,0xcc40,
0xa048,0x4848,0x7808,0x3808,0x4800,0xffff,0xffff,0x5000,0x6c40,0x2848,0xffff,0xffff,0xffff,0xffff,0x6c40,0x7408,
0x4000,0x3800,0x7440,0x5440,0x5000,0xffff,0x4c48,0xc800,0xf400,0xffff,0xcc40,0x9840,0xffff,0xc848,0xdc40,0xffff,
0xffff,0xffff,0x2808,0xd440,0xffff,0xffff,0x4000,0xa008,0xffff,0x5008,0x4408,0x1840,0x1808,0xb440,0x6408,0x6c00,
0x6848,0xa008,0xec40,0xe400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8048,0xd808,0x6040,0xffff,0xffff,0xb000,
0xbc40,0xa408,0xffff,0x3c48,0x9c40,0xffff,0xb408,0x2c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xa440,0xffff,0x1c48,
0x6400,0xffff,0xb008,0xb800,0xffff,0xc040,0x9008,0xffff,0xffff,0x9840,0xdc08,0xffff,0xb048,0xffff,0xb400,0xe848,
0x4808,0x2c48,0xc840,0xd008,0xffff,0x4440,0xd840,0xa448,0x8408,0xffff,0x7040,0x1c00,0xffff,0xffff,0xffff,0x6848,
0xd400,0xf400,0xb400,0x2040,0xffff,0xcc08,0x3c40,0x1848,0x1800,0xe008,0xffff,0x3848,0xe840,0xf008,0x5048,0x2848,
0xf808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3408,0xffff,0x0800,0xffff,0xdc40,0xffff,0xf840,0x3000}

};


unsigned short enduroracer_decrypt_data2[16][256]=
{
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4000,0xffff,0xffff,0xffff,0xffff,0x0408,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6040,0xffff,0x1c40,0x0c48,0x1c00,
0xffff,0xffff,0xffff,0x6840,0xffff,0x3800,0x2808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x3000,0xffff,0x3040,0xffff,0xffff,0xffff,0x0c00,0xffff,0xffff,0xffff,0x1808,
0xffff,0xffff,0xffff,0xffff,0xffff,0x4048,0x4c00,0xffff,0x1808,0x4408,0x4840,0xffff,0xffff,0x5400,0x4408,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c40,
0xffff,0xffff,0xffff,0xffff,0x6808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x6008,0xffff,0xffff,0x7040,0x6048,0xffff,0xffff,0x6848,0xffff,0xffff,0xffff,0xffff,0x1408,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x8008,0x8c40,0xffff,0xffff,0xffff,0xffff,0xdc48,0xffff,0xffff,0xffff,0xffff,
0xac40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa448,0xffff,0xffff,0xffff,0xe840,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc000,0xffff,0xc808,0xffff,0xffff,0xc840,0xffff,
0xffff,0xdc40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd448,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xc840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd448,0xd800,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xbc00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9848,0xffff,0xa448,0xffff,0xffff,0xffff,0xffff,0x9008,0xffff,0xffff},
{
0xffff,0xffff,0x4808,0x0808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5400,0xffff,0xffff,0xffff,0x2040,0x2448,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0008,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4800,0xffff,0xffff,0x1000,0x3808,0xffff,0xffff,0xffff,0x6808,0x2440,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3400,0x5448,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4c48,0xffff,0xffff,0x0c00,
0x5000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c48,0x5c00,0xffff,0x1008,0xffff,0xffff,0x2c00,
0xffff,0xffff,0xffff,0xffff,0x3c48,0xffff,0xffff,0x7048,0x5400,0xffff,0xffff,0x0008,0x3000,0xffff,0x6840,0xffff,
0xffff,0x4448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7448,0xffff,0xffff,0x6000,0xffff,0x5808,0xffff,0xffff,
0xffff,0xc800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8808,0xffff,0xffff,0xffff,0xfc00,0x8840,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x9440,0xffff,0xffff,0xffff,0xd448,0xffff,0xf800,0xffff,0xffff,0xffff,0xffff,0xffff,
0xa408,0xa400,0xffff,0x5c00,0xffff,0xffff,0xfc00,0xffff,0xffff,0xffff,0xffff,0xffff,0x9c40,0xb000,0xffff,0xffff,
0xffff,0xffff,0xffff,0x9008,0xffff,0xd408,0x9440,0x8048,0xffff,0xffff,0xb400,0x9c08,0xffff,0xffff,0xffff,0xa840,
0xec08,0xfc40,0xffff,0xffff,0xffff,0xcc08,0xffff,0xffff,0xffff,0xe048,0xffff,0xffff,0xffff,0x9408,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xa448,0xc000,0xffff,0xffff,0x9c00,0xf848,0xffff,0xa408,0xffff,0xffff,0xec48,
0xffff,0xec08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe040,0xffff,0xffff,0xffff,0xffff,0xfc48,0xf440,
0xffff,0xffff,0xe000,0xffff,0x9000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9008,0x8408},
{
0xffff,0xffff,0xffff,0x0c48,0x0808,0x4048,0xffff,0x6848,0xffff,0xffff,0xffff,0xffff,0xffff,0x6048,0xffff,0xffff,
0xffff,0xffff,0xffff,0x3040,0x4c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x2840,0x2440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x4000,0x0c08,0xffff,0xffff,0xffff,0x6c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4040,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0x2848,0x7000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5440,0xffff,0xffff,
0xffff,0x2840,0xffff,0x6040,0x6008,0x6448,0xffff,0xffff,0xffff,0x5408,0xffff,0xffff,0x5408,0xffff,0xffff,0x4c00,
0x1408,0xffff,0xffff,0xffff,0xffff,0xffff,0x1000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x8800,0x8400,0xd408,0xffff,0xffff,0xec00,0xffff,0x9c08,0x8808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xb400,0xffff,0x8808,0xd848,0x8c00,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8c08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd400,0xc808,0xffff,0xc840,0xffff,0xc800,0xffff,0xffff,0xffff,0xffff,
0xffff,0x2c40,0xffff,0x2c00,0xffff,0xa048,0xffff,0xffff,0xcc00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xe400,0xffff,0xe440,0xffff,0xc840,0xe840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x8000,0xffff,0xec08,0xffff,0xffff,0xffff,0x9840,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0x4048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5400,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0x6848,0xffff,0xffff,0xffff,0x6c40,0xffff,0xffff,0xffff,0x6008,0xffff,0xffff,0xffff,0xffff,
0x4408,0x4400,0xffff,0xffff,0x4000,0x5800,0xffff,0x2c48,0x4c48,0x5448,0xffff,0xffff,0x4840,0x5040,0x4800,0xffff,
0xffff,0x6c08,0xffff,0xffff,0x7000,0x6800,0xffff,0xffff,0xffff,0x6448,0x3800,0xffff,0x7840,0xffff,0xffff,0xffff,
0xffff,0x2c00,0xffff,0xffff,0x3008,0xffff,0xffff,0xffff,0x3c40,0x2440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x1c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1440,0x0800,0xffff,0xffff,0x1048,0xffff,0xffff,
0xffff,0xffff,0x8048,0xffff,0xffff,0xffff,0x8440,0xffff,0xffff,0xffff,0x8808,0x8800,0xffff,0xffff,0x8c00,0xffff,
0xffff,0xffff,0xffff,0x9848,0xffff,0xffff,0xffff,0x9c40,0xffff,0xffff,0xffff,0x9008,0xffff,0xffff,0xffff,0x9400,
0xffff,0xffff,0xb048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xb808,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xac40,0xffff,0x4440,0xffff,0xa008,0xffff,0xffff,0xffff,0xffff,
0xd408,0xcc08,0xffff,0xffff,0xd000,0xc800,0xffff,0xec48,0xffff,0xc448,0xffff,0xffff,0xd840,0xc040,0xffff,0xffff,
0xffff,0xffff,0xf040,0xffff,0xe000,0xffff,0xffff,0xffff,0xffff,0xffff,0xf800,0xffff,0xe840,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xa008,0xb808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa848,0xb048,0xffff,0xffff,
0xffff,0xffff,0xc040,0xffff,0xffff,0xffff,0xffff,0xffff,0x9c40,0xffff,0xc800,0xffff,0x9848,0xffff,0xffff,0xffff},
{
0x4c40,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c48,0xffff,0x0040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x1440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1848,0xffff,0xffff,0xffff,0xffff,
0xffff,0x0808,0xffff,0xffff,0xffff,0x2000,0xffff,0x2040,0x5848,0x2848,0x1c40,0xffff,0xffff,0xffff,0xffff,0x2c00,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0400,0xffff,0x0848,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2448,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c08,0xffff,
0xffff,0xffff,0x5400,0xffff,0xffff,0xffff,0x5800,0xffff,0xffff,0x7808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x0400,0xffff,0xffff,0xffff,0xffff,0xffff,0x9448,0xffff,0x9408,0x9400,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x1848,0xffff,0x7000,0x7008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8000,0xffff,0xffff,
0xf040,0xffff,0xffff,0x8400,0xffff,0xffff,0xe400,0xffff,0xffff,0xffff,0xffff,0xa000,0x9c08,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xd840,0xd400,0xcc48,0xffff,0xffff,0xffff,0xcc00,0xffff,0xc440,0xffff,0xffff,0xffff,0xffff,0xffff,0xa008,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xac08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe000,0xc848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe048,0xffff,0xd400,0xc048,0xe848,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2440,0xf800,0xffff,0x0840,0xffff,0x0840,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x7440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2800,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1400,0xffff,0xffff,0xffff,
0xffff,0xffff,0x0800,0xffff,0xffff,0xffff,0xffff,0xffff,0x3c08,0x3c00,0xffff,0x1c48,0xffff,0xffff,0xffff,0xffff,
0x5c08,0x4048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1c08,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0x3c40,0x0c08,0xffff,0xffff,0x1c40,0x4840,0xffff,0xffff,0xffff,0xffff,0x5048,0xffff,0xffff,
0xffff,0x2440,0xffff,0xffff,0xffff,0xffff,0x3c08,0xffff,0xffff,0xffff,0xffff,0x7c40,0xffff,0xffff,0xffff,0xffff,
0x7448,0xffff,0xffff,0xffff,0xffff,0x0c00,0xffff,0xffff,0xffff,0x6040,0xffff,0xffff,0xffff,0x3440,0xffff,0xffff,
0xffff,0xffff,0xe848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8408,0xffff,0xffff,0xc840,
0xc800,0xac40,0xffff,0xffff,0xd808,0xffff,0x9c40,0xffff,0xac00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xac08,
0xffff,0xffff,0xffff,0xffff,0xffff,0xbc48,0xffff,0xffff,0xffff,0xffff,0xc040,0xffff,0xffff,0xffff,0xffff,0xffff,
0x9008,0xffff,0xffff,0xd048,0xffff,0xffff,0xffff,0xffff,0xbc00,0xffff,0xbc40,0xffff,0xffff,0xffff,0xffff,0xa440,
0xffff,0x9c48,0xdc08,0xffff,0xffff,0xe048,0xffff,0xffff,0xc048,0xffff,0xffff,0xc848,0x8048,0xffff,0xffff,0xffff,
0xffff,0xffff,0xd800,0xdc40,0xffff,0xffff,0xffff,0xd848,0xffff,0xf048,0xffff,0xffff,0xffff,0xd040,0xffff,0xffff,
0xa048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa048,0xffff,0xffff,0xc800,0xffff,0xffff,0xffff,0xa000,0xc448,
0xffff,0xe808,0xffff,0xffff,0xffff,0xc408,0xffff,0xffff,0xe808,0xffff,0xffff,0xb048,0xec00,0xffff,0xf800,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0000,0xffff,
0xffff,0x1400,0xffff,0x1440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1c00,0xffff,0xffff,
0x4c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x5000,0xffff,0xffff,0xffff,0xffff,0x5808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7000,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c40,0x4440,0xffff,0xffff,
0x7c40,0xffff,0xffff,0xffff,0xffff,0xffff,0x6c40,0xffff,0x7408,0x6048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x7800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7800,0x7400,
0xffff,0xe040,0xffff,0xffff,0xffff,0xffff,0x8808,0xffff,0xffff,0xe008,0x9848,0xb040,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xe000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc008,0xffff,0xffff,0xffff,0xffff,0xc448,
0xffff,0xffff,0xe408,0xffff,0xffff,0xffff,0xffff,0xec00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa800,
0xd048,0xffff,0xffff,0xffff,0xc000,0xffff,0xffff,0xc048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xd008,0xffff,0xffff,0xffff,0xffff,0xffff,0xdc48,0xffff,0xffff,0x8c40,0xffff,0xb448,0xffff,0xffff,
0xffff,0x8800,0xffff,0xe840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe048,0xc840,
0xf000,0xffff,0xffff,0x0c00,0xffff,0xffff,0xffff,0xffff,0xa400,0xffff,0xffff,0xffff,0xffff,0xffff,0x8808,0xffff},
{
0x0040,0xffff,0xffff,0xffff,0xffff,0x2400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0x5c00,0xffff,0x1408,0xffff,0xffff,0xffff,0x4448,0xe408,0xe400,0xffff,0xffff,0xffff,0xffff,
0xffff,0x6840,0xffff,0xffff,0xffff,0xffff,0x6c48,0x6000,0xffff,0xffff,0x2448,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x7400,0xffff,0xffff,0xffff,0xffff,0x5c40,0xffff,0xffff,0xffff,0xffff,0x2808,0xffff,0xffff,0xffff,0xffff,
0x2448,0x4848,0xffff,0x5408,0xffff,0x4000,0xffff,0x5048,0xffff,0xffff,0xffff,0xffff,0x5048,0xffff,0x5c48,0xffff,
0xffff,0xffff,0xffff,0x5400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2400,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x5008,0x5848,0x6800,0xffff,0xffff,0x1808,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x6808,0xffff,0xffff,0xffff,0xffff,0xffff,0x1c00,0x7000,0xffff,0xffff,0x3000,0xffff,0xffff,0xffff,
0xbc40,0xffff,0xffff,0xffff,0xffff,0xa800,0xf048,0xac48,0xf840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xa808,0xffff,0xffff,0xffff,0xffff,0xa848,0x9048,0xffff,0xffff,0xd048,0xffff,
0x8440,0xffff,0xbc48,0xa408,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x8c08,0xffff,0xb040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xcc48,0xffff,0xa440,0xffff,0xc400,0xffff,0xffff,0xffff,0xe800,0xffff,0xfc40,0xffff,
0xffff,0xffff,0xffff,0xffff,0xb040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8408,0xffff,0xffff,
0xc040,0xffff,0xec00,0xffff,0xc400,0xffff,0xe448,0xffff,0xffff,0xffff,0xffff,0xffff,0xdc40,0xffff,0xffff,0xffff,
0xf048,0xffff,0xffff,0xffff,0xffff,0xffff,0x9808,0xffff,0xffff,0xffff,0xffff,0xffff,0xbc08,0xffff,0xd400,0xffff},
{
0xffff,0x0008,0xffff,0xffff,0xffff,0x4c08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x3840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2c00,0xffff,0xffff,
0x0c08,0xffff,0xffff,0x1c40,0xffff,0x5400,0xffff,0x0448,0xffff,0xffff,0xffff,0xffff,0xffff,0x3000,0x2048,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xb408,0xb400,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x6808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3048,0xffff,0x5040,0xffff,0x5c00,
0xffff,0xffff,0xffff,0x6400,0xffff,0xffff,0x6c00,0xffff,0xffff,0xffff,0xffff,0xffff,0x2c48,0xffff,0x2008,0xffff,
0x7800,0xffff,0xffff,0x7c48,0xffff,0x7000,0xffff,0x7c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6440,0xffff,
0x9048,0xffff,0xffff,0xffff,0xc440,0xc008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x9048,0x9400,0xffff,0xffff,0xffff,0xd440,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xa000,0xa008,0xffff,0xf040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xec40,0xffff,0xffff,0x9800,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xcc00,0xffff,0xffff,0xac00,0xa848,0xffff,0xffff,0xffff,0xffff,0xffff,0x9c00,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xe848,0xffff,0xffff,0x9808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xe800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc408,0xbc40,0xffff,0xffff,0xffff,
0xffff,0xb840,0xffff,0xac40,0xffff,0xbc48,0xffff,0xffff,0xffff,0xffff,0xffff,0xd808,0xffff,0xffff,0xc848,0xffff},
{
0xffff,0xffff,0x4c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x5048,0x5c00,0x3440,0x1008,0xffff,0xffff,0xffff,0xffff,0x3000,0xffff,0x0408,0xffff,0xffff,0xffff,0x4c48,0xffff,
0xffff,0x4008,0x2808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1040,0x7c08,0xffff,0xffff,0x3800,0x1008,0xffff,
0xffff,0xffff,0xffff,0xffff,0x1400,0xffff,0x7c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6048,
0x7840,0xffff,0xffff,0xffff,0x6000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x5800,0xffff,0xffff,0xffff,0xffff,0x5c40,0xffff,0xffff,0x0848,0x4848,0xffff,0xffff,0xffff,0xffff,0xffff,
0x3c48,0x2800,0xffff,0x7400,0xffff,0xffff,0xffff,0xffff,0x5c08,0xffff,0xffff,0x7448,0xffff,0xffff,0xffff,0xffff,
0x9808,0x8c40,0xffff,0xffff,0x9408,0xffff,0xffff,0xffff,0xffff,0xffff,0xc440,0xffff,0xffff,0x8c40,0xffff,0x8c00,
0xffff,0xffff,0x8c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xbc00,0xffff,0xffff,0x6040,0xffff,0x6000,
0xa400,0xffff,0xffff,0xffff,0xffff,0xffff,0xbc08,0xffff,0xf440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xb848,0xffff,0xffff,0xffff,0x8448,0xffff,0xffff,0xe840,0xec48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xc448,0xc400,0xf048,0xcc08,0xffff,0xffff,0xcc48,0xf408,0x9408,0xffff,0xffff,0xffff,0xffff,0xffff,0x9848,
0xffff,0xffff,0x9400,0x9800,0xffff,0xffff,0xffff,0xffff,0xffff,0x8808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xec08,0xffff,0xffff,0xffff,0xffff,0xffff,0x8448,0xffff,0xffff,0xffff,0xffff,0xb400,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xfc08,0xf400,0xec48,0xffff,0xffff,0xffff,0xd448,0xf848,0xfc40,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0x4c08,0x3848,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c48,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x3c08,0xe840,0xffff,0xe800,0xffff,0xffff,0xffff,0x4048,0xffff,0xffff,0xffff,0xffff,
0xffff,0x3048,0xffff,0x1440,0xffff,0xffff,0xffff,0xffff,0x3808,0xffff,0xffff,0x4048,0xffff,0xffff,0xffff,0xffff,
0xffff,0x7c08,0xffff,0xffff,0x3408,0xffff,0x3808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0x5c48,0x4808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1c48,0xffff,0x6048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c40,0xffff,0xffff,0xffff,
0xffff,0xffff,0x2400,0x7808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xcc48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xac08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x9848,0xffff,0xffff,0xffff,0xffff,0xd400,0x8408,0xffff,0x9c08,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe840,0xfc00,0xffff,0xffff,0xb408,0xffff,0xffff,0xf000,
0x9048,0x8848,0x9040,0x9c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe048,0xffff,
0xffff,0xc808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xcc48,0xcc48,0xfc40,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xd400,0xffff,0xd800,0xcc48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xe808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xfc00,0xfc08,0xffff,0xac00,0xffff,0xfc48,0xffff,0xffff},
{
0x0000,0xffff,0xffff,0xffff,0xffff,0x0440,0xffff,0x6c48,0xffff,0xffff,0x0000,0x0440,0x4000,0xffff,0x0c00,0x6c08,
0xffff,0xffff,0x7040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2000,0xffff,0xffff,0x1400,0xffff,0xffff,
0xffff,0x6000,0xffff,0xffff,0xffff,0xffff,0xffff,0x3c40,0xffff,0x1448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xcc48,0xffff,0xffff,0x7440,0x1808,0xffff,0xffff,0xffff,0x1400,0xffff,0xffff,0xffff,0xffff,0xffff,0x0048,0xffff,
0x4400,0xffff,0x4440,0xffff,0xffff,0xffff,0x4840,0xffff,0xffff,0xffff,0x4c48,0xffff,0x7840,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4048,0xffff,0xffff,0xffff,0x5c08,0x0c00,0xffff,0xffff,
0xffff,0xffff,0xffff,0x5800,0xffff,0xffff,0x2c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2c00,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5840,0xffff,
0xffff,0xa048,0xffff,0xffff,0xffff,0xffff,0x8c40,0xffff,0xffff,0xffff,0xd400,0xffff,0xffff,0xa408,0xffff,0xffff,
0xffff,0xffff,0xffff,0x9400,0x9848,0xffff,0xffff,0xffff,0xffff,0xffff,0xd008,0xf040,0xd400,0xffff,0xffff,0xac08,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xac08,0xffff,0xffff,0xffff,0xffff,0x9040,0xffff,0xffff,0xffff,0xffff,
0x9c40,0xffff,0xffff,0xffff,0xffff,0x8840,0xf800,0xffff,0xffff,0xffff,0xb400,0xffff,0xffff,0xdc00,0xffff,0xffff,
0xffff,0xffff,0xf040,0xffff,0xffff,0x9408,0xffff,0x8c40,0xd448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe800,
0xffff,0x8408,0xffff,0xffff,0xffff,0xffff,0xffff,0x8000,0xffff,0x8048,0xc840,0xffff,0xffff,0xffff,0xffff,0xcc00,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xbc48,0xffff,0xffff,0xffff,0xffff,0xbc40,0xb800,0xffff,0xffff,
0xffff,0xffff,0xffff,0xb008,0x9800,0xffff,0xffff,0xe840,0xfc40,0xffff,0xfc00,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4408,0xffff,0x0800,0x0440,0xf408,0x5408,0x5848,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4848,0xffff,0xffff,0x4448,0x1448,0xffff,0xffff,0x5408,0x4400,
0xffff,0xffff,0xffff,0xffff,0xffff,0x6840,0xffff,0xffff,0x0800,0x0c08,0xffff,0xffff,0x6440,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x4400,0x4008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6400,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x5000,0x1800,0xffff,0xffff,0x5c48,0xffff,0x0c00,0xffff,0xffff,0x6008,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7c08,0xffff,0xffff,
0xffff,0xffff,0x4048,0xffff,0xffff,0xffff,0xffff,0x7c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c00,
0xb448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8040,0xffff,0xffff,0xd400,0xffff,0xb840,0xffff,
0xa048,0xffff,0xffff,0xffff,0xffff,0xffff,0x9848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xc408,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8040,0xe040,0xffff,0x8008,0xffff,
0xffff,0xffff,0xa840,0xd040,0xffff,0xb400,0xffff,0xffff,0x9c08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc400,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd848,0xffff,0xffff,0xd800,0xffff,0xd800,0xd848,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xf840,0xfc48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xb848,0xffff,0xd800},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1008,0xffff,0xffff,0xffff,0xffff,0x4040,0x5808,0xffff,
0xffff,0x3c48,0xffff,0xffff,0xffff,0xffff,0x3440,0xffff,0x5c48,0xffff,0x5808,0x4c08,0xffff,0xffff,0xffff,0x2c48,
0x1c48,0xffff,0x1400,0xffff,0x2c08,0xffff,0xffff,0xffff,0x4800,0x3440,0xffff,0x2840,0xffff,0xffff,0xffff,0x1800,
0xffff,0x7000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c40,0x4c00,0xffff,0x4c40,0xffff,0x0008,0xffff,0xffff,0x7040,
0xffff,0x4408,0xffff,0xffff,0xffff,0xffff,0x7c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1440,0xffff,
0xffff,0x3008,0xffff,0x6c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x1c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3008,0x7400,0x7808,0xffff,0xffff,0xffff,
0xb040,0xffff,0x9808,0x8c40,0xffff,0xffff,0xffff,0xbc00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe848,
0xb800,0xffff,0xffff,0xffff,0xffff,0xffff,0x9408,0x9400,0xffff,0xa048,0xffff,0xffff,0xffff,0x9c08,0x6008,0x6000,
0xffff,0xa808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe808,0xffff,0xa840,0xcc00,0xffff,
0xffff,0xffff,0xffff,0xe808,0xffff,0xffff,0xffff,0x8848,0xffff,0xffff,0xffff,0xffff,0xec08,0x8400,0xffff,0xffff,
0xffff,0xa840,0x9c40,0xdc40,0xffff,0xffff,0xffff,0xffff,0xffff,0xa000,0xc400,0xffff,0xffff,0xffff,0xffff,0xa800,
0xd848,0xffff,0xc800,0xffff,0xffff,0x8c08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd448,0xffff,0xffff,
0xffff,0xe048,0xe400,0xe408,0xb808,0xffff,0xffff,0xffff,0xdc00,0xffff,0xffff,0xffff,0xbc40,0xc808,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd448,0xffff,0x9c40,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3000,0xffff,0xffff,0x6800,0xffff,0xffff,0xffff,0xffff,0x3000,
0xffff,0xffff,0xffff,0xffff,0xffff,0x2c08,0xffff,0xffff,0x5408,0xffff,0xffff,0xffff,0x3048,0xffff,0xffff,0xffff,
0x0840,0xffff,0xffff,0xffff,0x0c48,0xffff,0x1408,0x4400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3440,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5440,0xffff,0x7048,
0xffff,0x4040,0xffff,0x4000,0xffff,0x0040,0xffff,0xffff,0x4040,0x4040,0xffff,0xffff,0xffff,0x1840,0xffff,0x2040,
0xffff,0xffff,0xffff,0xffff,0x5040,0x0c48,0x5000,0xffff,0xffff,0x1040,0xffff,0x7808,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0x0040,0xffff,0xffff,0xffff,0x5808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x5000,0xffff,0xffff,0xffff,0xffff,0x7040,0xffff,0xffff,0x5000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x8400,0xffff,0xffff,0x8448,0xffff,0x8000,0xd440,0x8040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8040,
0xffff,0xffff,0xdc08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xec08,0xa448,0xffff,0xffff,0xffff,0xffff,0xffff,0xec08,0xffff,0xffff,0xa448,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xbc48,0xffff,0xffff,0xfc08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xe400,0x9000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xcc00,0xffff,
0xffff,0x8408,0xffff,0x9008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xec08,0xec00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xf840,0xffff,0xffff,0xffff,0x0440,0xffff,0x0400,0xffff,0xfc08,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0x5808,0xffff,0xffff,0xffff,0x5440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x5c00,0xffff,0xffff,0xffff,0x5808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xdc40,0xffff,0xdc00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x5000,0xffff,0xffff,0xffff,0x5c48,0xffff,0xffff,0xffff,0x5840,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x5c00,0xffff,0xffff,0xffff,0x5808,0xffff,0xffff,0xffff,0x5440,0xffff,0xffff,0xffff,0x5048,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x5000,0xffff,0xffff,0xffff,0x5c48,0xffff,0xffff,0xffff,0x5840,0xffff,0xffff,0xffff,
0x5408,0xffff,0xffff,0xffff,0x5000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xd448,0xffff,0xffff,0xa840,0xd040,0xffff,0xb400,0xffff,0xdc08,0xffff,0xffff,0xffff,0xd800,0xffff,0xbc40,0xffff,
0xffff,0xffff,0xffff,0xa840,0xffff,0xffff,0xb400,0xffff,0xffff,0xffff,0xb848,0xa000,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xa840,0xffff,0xffff,0xffff,0xac48,0xffff,0xffff,0xb848,0xa000,0xffff,0xffff,0xffff,0xa408,
0xffff,0xffff,0xb008,0xa840,0xffff,0xffff,0xb400,0xffff,0xffff,0xffff,0xb848,0xa000,0xffff,0xffff,0xbc40,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xac00,0xffff,
0xd448,0xffff,0xffff,0xffff,0xd040,0xffff,0xd000,0xffff,0xdc08,0xffff,0xffff,0xffff,0xd800,0xffff,0xffff,0xffff,
0xffff,0xdc40,0xa048,0xffff,0xffff,0xffff,0xa440,0xbc08,0xffff,0xd400,0xffff,0xb040,0xffff,0xffff,0xffff,0xb448,
0xffff,0xffff,0xa048,0xb800,0xffff,0xd848,0xa440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd008,0xffff,0xffff}
};


void endurob2_decode_data(data16_t *dest,data16_t *source,int size)
{
	system16_decode(dest,source,size,(unsigned short *)enduroracer_decrypt_data);
}


// This seems generally correct, but there are errors.
void endurob2_decode_data2(data16_t *dest,data16_t *source,int size)
{
	system16_decode(dest,source,size,(unsigned short *)enduroracer_decrypt_data2);
}


/***********************************************************************************
      Decryption Tables for Enduror
***********************************************************************************/
// rom 7637/7641
unsigned short enduroracer_decrypt_data3[16][256]=
{
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0x2c40,0xffff,0xffff,0xffff,0xffff,0x2400,0xffff,0xffff,0x3840,0xffff,0xffff,0xffff,0xffff,
0xffff,0x2400,0xffff,0xffff,0xffff,0xffff,0x2408,0xffff,0x3800,0x3000,0xffff,0xffff,0xffff,0xffff,0x0008,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x1c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3048,0xffff,
0x0848,0xffff,0x6800,0xffff,0xffff,0xffff,0x6048,0xffff,0x2c48,0xffff,0x4c00,0xffff,0xffff,0xffff,0x7448,0xffff,
0xffff,0x1048,0x7400,0x6800,0x6808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4c00,0x7c08,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xf048,0xffff,0x8800,0xffff,0xffff,0xffff,0xffff,0x8040,0xd448,0xe008,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9c40,0x9440,0xffff,0xffff,
0xffff,0xffff,0xf440,0xffff,0xffff,0xffff,0xffff,0x5800,0xd008,0xffff,0xffff,0xc048,0xffff,0xffff,0xffff,0xffff,
0xd808,0xdc08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xc408,0xffff,0xffff,0xffff,0xcc40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xec48,0xffff,0x8c00,0xffff,0xffff,0xd040,0xffff,0xd848,0xc848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x9000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0x1848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5000,0x2c48,0xffff,0xffff,0xffff,0x0440,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x6c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3408,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x2800,0x5440,0xffff,0x2400,0xffff,0xffff,0xffff,0x0c40,0x2408,0xffff,0xffff,
0xffff,0x0008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c48,0xffff,0x5808,0xffff,0xffff,0xffff,0xffff,
0xffff,0x7048,0xffff,0xffff,0xffff,0x6808,0xffff,0xffff,0x6408,0x5848,0xffff,0x2848,0xffff,0x2040,0xffff,0xffff,
0x0c00,0x7000,0xffff,0xffff,0xffff,0x5840,0x2400,0xa800,0x5440,0x5800,0xffff,0x2800,0x7c00,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1008,0x7800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x2c40,0xffff,0xffff,0x2040,0x7848,0xffff,0xffff,0xffff,0x3040,0xffff,0xffff,
0xffff,0xffff,0x9c08,0xffff,0xffff,0xffff,0xffff,0xd808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8c08,0xffff,
0xffff,0xffff,0xac40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd840,0xf448,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xe808,0xffff,0xffff,0xffff,0xa048,0xf840,0xffff,0xffff,0xe448,0xac48,0xffff,0xffff,0xac40,0xffff,
0xffff,0xf400,0xffff,0xffff,0xffff,0xffff,0xa000,0xffff,0xffff,0xffff,0xd400,0xffff,0xffff,0xffff,0xac08,0xffff,
0xffff,0x8440,0xa800,0xffff,0xffff,0xffff,0xd040,0xffff,0xffff,0xac08,0xe000,0xdc40,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x9848,0xffff,0xffff,0xffff,0xd008,0xcc40,0xffff,0xffff,0xd048,0xdc08,0xffff,0xffff,0xf840,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xdc40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd840,0xd000,
0xffff,0xffff,0xec48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf000,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x7c00,0x0848,0xffff,0xffff,0xffff,0x1c00,0xffff,0x1008,0xffff,0xffff,0xffff,0xffff,0xffff,0x1448,0xffff,0xffff,
0xffff,0x0408,0xffff,0xffff,0xffff,0x2040,0xd808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x0400,0xffff,0x6840,0xffff,0xffff,0xffff,0x7440,0xffff,0x5800,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x5840,0xffff,0x5448,0xffff,0xffff,0xffff,0x7848,0xffff,0xffff,0xffff,0x5c00,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6808,0xffff,0xffff,0xffff,0xffff,0xffff,0x7c40,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6848,0xffff,
0xffff,0x8040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8808,0xffff,0xffff,0xffff,0xac40,0xffff,0xb440,
0xc800,0xbc48,0xffff,0xffff,0xdc48,0xffff,0xffff,0xffff,0xc048,0xffff,0xffff,0x9c48,0xffff,0xa048,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xd448,0xffff,0xffff,0xffff,0xac00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xa000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa848,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xc808,0xffff,0xf008,0xffff,0xffff,0xa808,0xffff,0xffff,0xc040,0xffff,0xac08,0xffff,0xffff,0xffff,
0xffff,0xffff,0x9400,0xffff,0xffff,0xffff,0xb048,0xffff,0xd400,0xffff,0xffff,0xffff,0xffff,0xb448,0xb800,0xffff,
0xb440,0xffff,0xffff,0xffff,0x9008,0xffff,0xffff,0xffff,0xffff,0xffff,0xe448,0x9048,0x9840,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4000,0x1048,0xffff,0xffff,0xffff,
0x0400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4000,0xffff,0xffff,0x5848,0xffff,0x2048,0xffff,
0x1400,0xffff,0x7c40,0x0008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7048,0x1000,0xffff,0xffff,0xffff,
0xffff,0x0008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2000,0xffff,
0xffff,0x1448,0xffff,0xffff,0xffff,0xffff,0x2400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x5c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5440,0x0048,0xffff,0x6808,
0xffff,0xffff,0xffff,0x6c00,0xffff,0xffff,0xffff,0x9800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6408,0x7808,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6408,0xffff,0xffff,0x6840,
0xffff,0xffff,0xffff,0x9040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe048,0xc008,0xffff,0xffff,0x9408,
0x9c00,0xffff,0xffff,0xffff,0xffff,0xe448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9408,0xb800,0xffff,
0xffff,0xffff,0xac48,0xa008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc040,0xffff,0xa800,0xa440,
0xffff,0xffff,0xe448,0xb040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd008,0xffff,0xb848,0xffff,
0xffff,0xc440,0xffff,0xac00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8048,0xffff,0xcc48,0xd000,0xffff,0xa800,
0xffff,0xd408,0xffff,0xffff,0xffff,0xffff,0x9448,0xffff,0xffff,0xffff,0xffff,0xffff,0xdc00,0x9800,0xffff,0xffff,
0xffff,0xc408,0xc040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xb000,0xffff,0xffff,0xd048,0xc440,0xffff,
0xc040,0xffff,0xffff,0xbc00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xec48,0x9848,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0x0c08,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c40,0xffff,0x0c48,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1c00,0xffff,0xffff,0xffff,0xffff,0xffff,0x1c48,0xffff,0x1c40,0xffff,
0xffff,0x3840,0xffff,0xffff,0x3448,0xffff,0x3440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2440,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3448,0x1008,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x2048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x7c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6000,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0x5840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4808,0xffff,0xffff,0x1c00,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1408,0xffff,0x6808,0xffff,0x6800,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9c08,0xffff,0x9c00,0xffff,0xffff,0xffff,0xe008,
0xffff,0xe848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf808,0xbc00,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x9400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc040,0xdc48,0xffff,0xffff,0xffff,
0xffff,0xffff,0xfc00,0xffff,0xffff,0xffff,0x8040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8048,0xffff,
0x3c48,0xcc40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xdc48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe848,0xffff,0xe840,0xe408,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf400,0xffff,0xffff,0xf840,0xffff,0xf848,0xffff},
{
0xffff,0x0840,0xffff,0xffff,0x3400,0xffff,0xffff,0xffff,0xffff,0x0848,0x2800,0x0408,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7800,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x3448,0x1400,0xffff,0x1000,0x0c08,0xffff,0xffff,0xffff,0x2c40,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5008,0xffff,0xffff,0x4040,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x0c08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x0840,0xffff,0x0400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4008,0x5c00,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x6408,0x7800,0xffff,0xffff,0xffff,0x3848,0xffff,0x6800,0xffff,0x7808,0x6840,0x7448,0xffff,0x3440,0xffff,0x3800,
0xdc40,0xffff,0x8c08,0xffff,0xffff,0xffff,0xac40,0xb048,0xc448,0xffff,0xc808,0xffff,0x8800,0x9408,0x8440,0xffff,
0xffff,0xffff,0x6c08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xfc48,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8840,0xffff,0xffff,0xffff,0xa808,0xffff,
0xffff,0xffff,0xffff,0xd848,0xffff,0xffff,0xffff,0xffff,0xe000,0xfc08,0xffff,0xf048,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8840,0xffff,0xffff,0xffff,0xffff,0xffff,0xa000,0xffff,0xffff,
0xffff,0xe848,0xc800,0xe408,0xffff,0xffff,0xffff,0xffff,0xffff,0xe440,0xffff,0xffff,0xffff,0xffff,0xd848,0xc440,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xb048,0xac40,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xfc48,0xe040,0xec48,0xffff,0xffff,0xffff,0xffff,0xffff,0xd848,0xffff,0xf840,0xd448,0xf400,0xd808},
{
0xffff,0xffff,0x3c40,0xffff,0xffff,0xffff,0xffff,0x0000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x4808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7040,0xffff,0xffff,0xffff,0xffff,0xffff,
0x4048,0xffff,0x4c08,0xffff,0xffff,0x2008,0xffff,0x2c48,0x5840,0xffff,0xffff,0x2400,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc400,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x5048,0xffff,0x5c08,0xffff,0xffff,0x4848,0x5440,0x6848,0x4440,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x6040,0xffff,0xffff,0xffff,0xffff,0x6c48,0x7040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x8448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9000,0xffff,
0xffff,0xf800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xa040,0xffff,0xac00,0xffff,0xffff,0xffff,0x8048,0x9c40,0xa048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xd000,0xcc08,0xdc40,0xc048,0x9c48,0xffff,0x9008,0xffff,0xd008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xb800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xb808,0xffff,0xffff,0xffff,
0xffff,0x9848,0xe408,0xffff,0xf408,0xe800,0xffff,0xffff,0xa048,0x8c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0x0440,0x2c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2c08,0x0408,0xffff,
0xffff,0xffff,0x2048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0800,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x4400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c48,0xffff,0x0800,0xffff,0xffff,0xffff,
0xffff,0x3440,0xffff,0xffff,0x7808,0xffff,0xffff,0xffff,0xffff,0x2c08,0x3408,0xffff,0x6040,0xffff,0xc008,0xffff,
0xffff,0xffff,0xffff,0xffff,0x2c00,0x4408,0xffff,0x4c08,0xffff,0xffff,0xffff,0xffff,0x0448,0xffff,0xffff,0xffff,
0xffff,0x1000,0x6000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4848,0x2040,0xffff,0xffff,0xffff,0xffff,
0x2408,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c00,0xffff,0xffff,0xffff,0xffff,
0x4c00,0x7408,0xffff,0x7c08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6440,0xffff,0x3008,0xffff,0xffff,
0xe400,0xffff,0xffff,0xffff,0xffff,0xa800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8840,0xb048,0xa800,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd808,0xffff,0x9408,0xffff,0xffff,0xffff,0xffff,0xd840,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x8c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa408,0xdc40,0xf440,0x9c48,
0x9008,0xf800,0xffff,0xa800,0xffff,0xffff,0xffff,0xffff,0xb840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xd040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc808,0xf000,0xffff,0xf848,
0xffff,0xdc08,0xffff,0xffff,0xb848,0xffff,0xffff,0xffff,0xffff,0xc440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x9440,0xec08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xd040,0xffff,0xc848,0xffff,0xffff,0xffff,0xffff,0xffff,0xf808,0xffff,0xffff,0x9848,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4800,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1848,0xffff,0xffff,0xffff,0x1440,0xffff,0xffff,
0x7440,0x0040,0x0000,0xffff,0xffff,0x2840,0xffff,0xd800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x7840,0xffff,0x0c00,0xffff,0xffff,0x2440,0xffff,0xffff,0xffff,0x3448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x6c00,0x3048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1c08,0x5840,0xffff,0xffff,0xffff,0x5448,0xffff,
0xffff,0xffff,0x2048,0xffff,0xffff,0x7c08,0x6848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x1c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7440,0xffff,0xffff,0x2800,0xffff,0xffff,
0xffff,0x8408,0xffff,0xffff,0xffff,0xffff,0xd848,0xffff,0xffff,0xffff,0xa448,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xa000,0xffff,0xffff,0xffff,0xffff,0x9848,0xffff,0xffff,0xd008,0xffff,0xffff,
0xffff,0xa808,0xa448,0xffff,0xffff,0xec08,0xffff,0xffff,0xffff,0xc000,0xffff,0xffff,0xffff,0xffff,0x9c40,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe840,0xffff,0xffff,0xa000,0xffff,0xffff,
0xffff,0xffff,0xc400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8808,0xffff,0xffff,0xffff,0x8400,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd840,0xffff,0xffff,0xffff,0xffff,0xf000,0xffff,
0xffff,0xe440,0xe800,0xffff,0xffff,0xffff,0xcc00,0xffff,0xffff,0xffff,0xd008,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xb800,0xffff,0xffff,0xffff,0xa808,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3808,0xffff,0xffff,
0x2c08,0xffff,0x3040,0xffff,0x5c48,0xffff,0xffff,0xffff,0xffff,0x2808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x2840,0xffff,0xffff,0x3440,0xffff,0xffff,0xffff,0xffff,0x2c08,0xffff,0x0040,0x2000,
0x3808,0xffff,0xffff,0x3400,0xffff,0x6808,0xffff,0xffff,0x3c40,0x6c08,0x1040,0xffff,0xffff,0xffff,0xffff,0xc000,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1008,0xffff,0xffff,0xffff,0xffff,0x0840,0xffff,0x4408,0xffff,
0x7c40,0xffff,0x5008,0x0040,0xffff,0xffff,0xffff,0xffff,0x0800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x7808,0xffff,0xffff,0x5408,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c48,0x5008,0xffff,
0x6840,0xffff,0xffff,0x5448,0xffff,0x3840,0xffff,0xffff,0x5c08,0xffff,0x4008,0xffff,0xffff,0xffff,0x3000,0xffff,
0xffff,0xffff,0xffff,0xffff,0x9848,0xffff,0xe448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xec08,0x9408,0xffff,
0xffff,0xa808,0xffff,0xb408,0xdc00,0xd800,0xffff,0xffff,0xffff,0xffff,0xa048,0xffff,0xffff,0xffff,0xd040,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf048,0xffff,0xac40,0xb800,0xffff,0xffff,
0xb840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe840,0xec40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xc800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8c40,0xc440,0xc040,
0xffff,0xffff,0xd040,0xd440,0xffff,0x8848,0xffff,0xffff,0xdc00,0xffff,0xf000,0xffff,0xffff,0xffff,0x8008,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xcc08,0xffff,0xffff,0xffff,
0xe808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0x6800,0xffff,0x4840,0xffff,0x1408,0xffff,0x3848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0400,0x0040,0x0c48,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3c08,0xffff,0xffff,0xffff,0xffff,0xffff,0x5048,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7040,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2440,0x2848,0xffff,0x3800,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0x1848,0x4808,0xffff,0xffff,0x6840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5048,
0xffff,0xffff,0xffff,0xffff,0xffff,0x4c40,0x5c00,0x5008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x4040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x2c40,0x7408,0x2408,0xffff,0xffff,0xffff,0xffff,0x4840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xbc48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd848,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9c40,
0x8048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa040,0xa400,0xa808,0xffff,0xffff,0xffff,0xffff,
0x8400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9040,0xffff,0xe800,0xffff,0xffff,
0x3c48,0xffff,0xffff,0xffff,0xffff,0xffff,0x8400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf408,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xec48,0xffff,0xffff,0xac00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xf840,0xf448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xcc40,0xffff,0xb400,0xb040,0xffff},
{
0xffff,0xffff,0xffff,0x5808,0x4408,0x0400,0x0808,0x2848,0xffff,0xffff,0xffff,0xffff,0xffff,0x0048,0xffff,0xffff,
0x4400,0x1448,0xffff,0x3848,0xffff,0xffff,0xe808,0xffff,0xffff,0x1000,0x1c08,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x0000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0400,0xffff,0xffff,0xffff,0x7440,0xffff,0xffff,
0xffff,0xffff,0x2848,0x0840,0x2440,0x6448,0xffff,0x7800,0xffff,0x2008,0xffff,0xffff,0xffff,0x5000,0x7c00,0xffff,
0xffff,0xffff,0xffff,0x6800,0xffff,0xffff,0xffff,0x1808,0x6040,0xffff,0x7c40,0xffff,0xffff,0x3008,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x6048,0x2008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5448,0x2848,0x7800,0xffff,0x2408,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x8448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xc448,0xc048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xc400,0xffff,0xffff,0xbc00,0xffff,0xffff,0xffff,0xffff,0xffff,0xb040,0xffff,0xcc40,
0xffff,0x9440,0xffff,0x8840,0xffff,0xffff,0xffff,0xf848,0xffff,0x8448,0xffff,0xffff,0xffff,0xf408,0xffff,0xffff,
0xffff,0xffff,0xffff,0x8808,0xf040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xa448,0xa000,0xe848,0xec48,0xffff,0xffff,0xffff,0xffff,0xffff,0xe008,0xb848,0xac08,
0xe000,0xf408,0xffff,0xd808,0xffff,0xffff,0xffff,0xffff,0xffff,0xd400,0xfc48,0xf848,0xa040,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6c08,0xf408,0xffff,0xffff,0xffff,0xffff,0x5448,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0808,0xffff,0xffff,0xffff,0x2408,0xffff,0xffff,0xffff,0xffff,
0x6448,0x3448,0xffff,0xffff,0xffff,0x3408,0xffff,0xffff,0x6048,0xffff,0xffff,0xffff,0xffff,0x3008,0x0808,0x2c48,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x4000,0xffff,0x6c40,0xffff,0xffff,0xffff,0xffff,0xffff,0x4400,0x6400,0x6840,
0xffff,0x3c00,0xffff,0x1040,0x7440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4800,0xffff,0x3440,0xffff,0xffff,
0xffff,0xffff,0xdc48,0xffff,0xffff,0xffff,0xc808,0xffff,0xa848,0xffff,0x8408,0xffff,0xffff,0xb008,0xcc08,0xac48,
0x9448,0xffff,0xffff,0xffff,0x9408,0xffff,0xffff,0xa048,0xffff,0xffff,0xffff,0xffff,0x9008,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe448,0xffff,0xf808,
0xffff,0xffff,0xffff,0xffff,0xffff,0xe848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xcc40,0xffff,0xffff,0xffff,0xec40,0xffff,0xd400,0xe840,0xc840,0xc400,
0xffff,0xffff,0xffff,0xffff,0xffff,0xd440,0xffff,0xf800,0xffff,0xffff,0xffff,0xe840,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xb400,0xffff,0xa800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0x0c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1048,0xffff,0xffff,0xffff,
0x2440,0x0848,0xffff,0xffff,0x4048,0xffff,0xffff,0xffff,0xffff,0xffff,0x5448,0x4840,0xffff,0xffff,0xffff,0xffff,
0x1c08,0xffff,0xffff,0xffff,0x2800,0xffff,0xffff,0xffff,0xffff,0x2048,0xffff,0xffff,0x6848,0x4440,0xffff,0xffff,
0xffff,0x7048,0xffff,0xffff,0xffff,0x0c40,0xffff,0xffff,0x2008,0x3c00,0xffff,0xffff,0xffff,0xffff,0x6c40,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7c08,
0xffff,0xac40,0xffff,0x5c00,0xffff,0xffff,0x0c00,0xffff,0xffff,0xffff,0x6c40,0x7048,0xffff,0xffff,0xffff,0xffff,
0x2800,0xffff,0x5c40,0x4048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6c00,0xffff,0xffff,0x3c00,0xffff,
0xffff,0xffff,0xffff,0x3000,0xffff,0xffff,0x7800,0xffff,0x1800,0xffff,0x6c40,0x7048,0xffff,0xffff,0xffff,0x4440,
0xffff,0xffff,0xffff,0xffff,0x8c08,0xffff,0xffff,0xffff,0xbc48,0x9040,0xffff,0xffff,0xffff,0xec48,0xffff,0xffff,
0xa840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd440,
0xffff,0xffff,0xffff,0xffff,0xa400,0xffff,0xf848,0xe440,0x8040,0xac48,0xffff,0xffff,0xe448,0xc840,0xffff,0xffff,
0x8c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xbc08,0xa000,0xe040,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xa808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xdc08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf040,0xec48,
0xffff,0xb808,0xffff,0xffff,0xffff,0x8c00,0xc040,0xffff,0xffff,0xffff,0xffff,0xbc08,0xffff,0xffff,0xec08,0xffff,
0xffff,0xffff,0x9008,0xbc00,0xffff,0xffff,0xf400,0xd808,0xffff,0xffff,0xffff,0xfc48,0xffff,0x9808,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0x4440,0xffff,0xffff,0xffff,0xffff,0xffff,0x4440,0x5848,0x0808,0xffff,0xffff,0x6c40,
0xffff,0x1c08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7048,0x5c40,0xffff,0xffff,0x1440,0xffff,0xffff,0xffff,
0xffff,0x7440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7c48,0x6040,
0xffff,0xffff,0xffff,0xffff,0x3808,0xffff,0xffff,0xffff,0x0848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x6000,0x4c08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4440,0xffff,
0xffff,0xffff,0xffff,0xffff,0x0000,0x1c08,0x7440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5808,0x7400,
0xffff,0xffff,0xffff,0x3808,0x9848,0xffff,0x6808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4440,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xb840,0xffff,0xffff,0xffff,0x8800,0xffff,0xffff,0xffff,0xffff,0xffff,0xe040,
0xffff,0x9008,0xd048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd040,0xffff,0xffff,0x9840,0xb448,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xb800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd840,0xffff,0xffff,0xffff,0xffff,0x8840,0xffff,0xffff,
0xffff,0xffff,0xffff,0xc008,0xffff,0xffff,0x8808,0xa400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc840,0xd448,
0xffff,0xffff,0xe840,0xf448,0xffff,0x9008,0xffff,0xffff,0xffff,0xffff,0xf408,0xd800,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xe800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc400,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0x6448,0xffff,0xffff,0xffff,0xffff,0xffff,0x3000,0xffff,0xffff,0xffff,0x5c40,0xffff,0xffff,0xffff,0x2848,
0xffff,0xffff,0x1408,0x2c00,0xffff,0xffff,0xffff,0x5840,0xffff,0x1440,0xffff,0x3448,0xffff,0xe040,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2408,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2440,0xffff,0xffff,
0x6808,0xffff,0x2848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7848,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6048,0xffff,0x2c48,0xffff,0xffff,0x1c08,0xffff,0xffff,0x7800,0xffff,
0x5c40,0xffff,0x5440,0xffff,0xffff,0xffff,0x0808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1040,0xffff,
0xffff,0xffff,0xffff,0xffff,0x6c40,0xffff,0x6440,0xffff,0xffff,0xffff,0xffff,0xffff,0x4408,0xffff,0xffff,0x2400,
0x2840,0x4048,0x3048,0x4800,0xffff,0xffff,0xffff,0xffff,0xffff,0x6800,0x1800,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd440,0xffff,0xffff,0xffff,0xffff,0xffff,0xbc00,0xd408,0xffff,0x8440,
0x8848,0xffff,0xffff,0xb040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9808,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xc448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa808,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe040,0xffff,0xffff,0xffff,0xffff,0xb440,0xffff,0xe008,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xcc40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9c40,
0xffff,0xe800,0xffff,0xf008,0xffff,0xffff,0xffff,0xffff,0xb800,0xffff,0xffff,0xd840,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc800,0xffff,0xffff,0xffff,0xffff,0xffff,0xd800,0xffff,0xd048,0xe840,
0xffff,0xffff,0xfc40,0xffff,0xffff,0xffff,0xa008,0xffff,0xffff,0xffff,0xe408,0xffff,0xffff,0xffff,0xffff,0xffff}
};


// rom 7638/7642
unsigned short enduroracer_decrypt_data4[16][256]=
{
{
0xffff,0xffff,0x7400,0x5808,0x3400,0x2808,0x9448,0x8840,0xffff,0x0848,0xffff,0x0408,0x3808,0x2400,0x3448,0x2840,
0xffff,0xac48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9848,0xffff,0xc800,0xffff,0xffff,0x6408,0xffff,0xffff,
0x9408,0x8800,0x9848,0xffff,0x1840,0x3448,0xffff,0xffff,0xffff,0x0c08,0xb048,0xac40,0xffff,0xffff,0xffff,0x7c08,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8048,0xffff,0xffff,0xa000,0xffff,0xffff,0xffff,0xffff,
0x2448,0x0840,0x2808,0x0400,0xc800,0xd408,0xc440,0xd848,0x3040,0x1c48,0xffff,0xffff,0x4008,0x5c00,0xffff,0xfc48,
0xffff,0xffff,0xffff,0xffff,0xffff,0x9040,0xb008,0xffff,0xffff,0xffff,0xffff,0xffff,0xa840,0xffff,0xffff,0xffff,
0x6408,0x7800,0xc440,0xd848,0x1440,0x3848,0xffff,0xffff,0x6400,0x7808,0x6840,0x7448,0x1848,0x3440,0x1408,0x3800,
0xdc40,0xf048,0xffff,0xffff,0x0c08,0x1000,0xac40,0xb048,0xc448,0xe840,0xffff,0xe400,0x8800,0xffff,0x8440,0x9848,
0xffff,0xffff,0x6c08,0x4000,0xffff,0xffff,0xffff,0xffff,0x6040,0x4c48,0xffff,0xffff,0xffff,0xffff,0xe040,0xffff,
0x2400,0x3808,0x2840,0x3448,0xf848,0xd440,0xffff,0xd800,0x2808,0x3400,0x8840,0x9448,0xf840,0xd448,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7040,0x5008,0x7c00,
0xffff,0xffff,0x2400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xc440,0xffff,0xffff,0xffff,0x7808,0xffff,0x7448,0x6840,0xffff,0xffff,0x9800,0xb408,0x7800,0xffff,0xd848,0xc440,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2c08,
0x5c00,0x4008,0xfc48,0xffff,0xffff,0xffff,0xbc00,0x9008,0xd408,0xc800,0xd848,0xc440,0xf840,0xffff,0xf400,0xffff},
{
0xffff,0xffff,0x4000,0x7000,0xffff,0xa008,0x4800,0x7800,0xffff,0xffff,0xffff,0xffff,0x3408,0xffff,0xb000,0xffff,
0x3c00,0xffff,0xffff,0xffff,0x3400,0xffff,0xffff,0xffff,0xffff,0xffff,0x7c00,0xffff,0xffff,0xb400,0xffff,0xffff,
0xffff,0xa408,0x7c00,0x4c00,0xffff,0xac08,0x7400,0x4400,0xffff,0x1400,0x2808,0xffff,0x3808,0xffff,0xffff,0xffff,
0x3000,0xffff,0xffff,0xffff,0x3800,0xffff,0xffff,0xffff,0x9408,0xffff,0x4000,0xf800,0xffff,0xb800,0xffff,0x5c08,
0xffff,0xffff,0xffff,0xfc40,0xffff,0x1c40,0xd048,0xffff,0xffff,0xffff,0xffff,0x4c48,0xffff,0xffff,0xffff,0x4448,
0xffff,0xd040,0x7c48,0xffff,0xffff,0xffff,0x2840,0x5040,0x3048,0xffff,0xd840,0xffff,0x3848,0x0848,0xd040,0xffff,
0x3c48,0x8448,0xffff,0xf040,0xffff,0x2040,0xdc48,0xffff,0x6840,0xffff,0xffff,0x4048,0xffff,0xffff,0x2848,0x4848,
0xffff,0xffff,0x7048,0xffff,0xffff,0x4848,0xffff,0x5c40,0x0c48,0x3c48,0xd440,0xffff,0x0448,0x3448,0xdc40,0xbc40,
0xffff,0x3400,0xc808,0xffff,0x1808,0xffff,0xffff,0xd400,0xffff,0x9c08,0xffff,0xffff,0xffff,0x9408,0xffff,0xffff,
0xb408,0xffff,0xffff,0xffff,0xffff,0x9800,0xffff,0xffff,0x0800,0xffff,0x7008,0xffff,0x0000,0xffff,0x7808,0x4808,
0xffff,0x3800,0xf408,0xffff,0xffff,0xffff,0x5000,0xe800,0xffff,0xffff,0xffff,0xffff,0xffff,0x9808,0xffff,0xffff,
0xb808,0xffff,0xffff,0xffff,0xffff,0x9400,0xffff,0xffff,0xffff,0xffff,0xffff,0x7c08,0x0c00,0xffff,0x4408,0x7408,
0x0040,0x3040,0xffff,0xffff,0x0840,0x3840,0xffff,0x7048,0xffff,0xffff,0xffff,0xd040,0xffff,0xffff,0xfc48,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe440,0xffff,0xb440,0xffff,0x5048,0xffff,0x1048,0xa848,0xffff,0x7c40,
0xffff,0x0c40,0xffff,0x7448,0x3440,0xffff,0xffff,0x7c48,0xffff,0xffff,0xffff,0xdc40,0xffff,0xffff,0xf048,0xffff,
0xffff,0xffff,0xe040,0xffff,0xffff,0xffff,0xe840,0xffff,0x8840,0x3040,0x5c48,0xffff,0x2c48,0x9448,0xffff,0x7040},
{
0x1400,0xffff,0x2448,0x5008,0xffff,0xffff,0xffff,0xffff,0xffff,0xc848,0xffff,0xffff,0x1408,0xffff,0xac40,0x4800,
0xffff,0x6848,0x3848,0xffff,0xffff,0xd840,0xffff,0xffff,0x7408,0xffff,0xffff,0xf008,0xffff,0xffff,0x1c48,0x5400,
0x2800,0xffff,0x1848,0xffff,0x5800,0xc840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2808,0x2448,0xffff,0x4400,
0x3400,0x6448,0x0448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xfc08,0x9800,0x3848,0x2048,0x5800,
0x2c48,0xffff,0x4c00,0xc440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2040,0x7000,0xffff,0x4048,
0x3048,0xcc00,0x5000,0x7448,0x8040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1800,0x5c48,
0x2048,0x4008,0xffff,0xf840,0xffff,0xffff,0xb400,0xffff,0xffff,0xffff,0xac08,0xffff,0x2c40,0x4c00,0xffff,0x7c48,
0x3c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xf408,0xffff,0xffff,0xffff,0xb008,0xffff,0xffff,0x5000,0x1400,0x6048,
0xb400,0xfc40,0x0c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7000,0x3008,0xe848,0x0040,0xffff,
0x0408,0xe040,0xbc40,0x8008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2c08,0xffff,0x1c40,0xd008,
0xffff,0xffff,0x3048,0xffff,0xffff,0xffff,0xffff,0xffff,0xf808,0xffff,0xffff,0xffff,0x0c08,0xe448,0x3c40,0xffff,
0x3808,0xec40,0x8040,0x8c08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6000,0x1008,0xffff,0x2040,0xdc08,
0xffff,0x5408,0xffff,0x6440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9808,0xffff,
0xa040,0xffff,0xffff,0x7840,0x0848,0xffff,0xffff,0xffff,0xffff,0xffff,0x3800,0xffff,0xffff,0x6c08,0x8408,0xd440,
0xffff,0x6808,0x9400,0x5840,0x1848,0xffff,0xffff,0xffff,0x0c40,0xffff,0xffff,0xffff,0xffff,0xe000,0x9408,0x5848,
0xac40,0x7408,0xffff,0x4440,0x0448,0xffff,0xffff,0xffff,0xffff,0xffff,0x3400,0xffff,0xe840,0x5008,0x8808,0xe840},
{
0xffff,0xffff,0xffff,0xffff,0xb400,0xffff,0xa840,0xffff,0x5c48,0x8808,0x7008,0x9448,0x3808,0xbc48,0x1448,0xffff,
0xffff,0xe840,0xffff,0xffff,0xffff,0x8c00,0xffff,0xa040,0xffff,0x4048,0xffff,0x5c08,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xe040,0xffff,0xffff,0xffff,0x9408,0xffff,0xb848,0xcc08,0xffff,0xffff,0xdc08,0xffff,
0xffff,0xffff,0xffff,0x0c40,0xa000,0x4440,0xbc40,0x6800,0xffff,0x1408,0xffff,0x0848,0xffff,0xffff,0xffff,0xffff,
0xe400,0xffff,0xf840,0xffff,0xffff,0xffff,0xffff,0xffff,0x1048,0xc408,0x3c08,0xd848,0x7408,0xffff,0x5848,0xffff,
0xffff,0xa440,0xffff,0x8800,0xb440,0xc000,0xffff,0xec40,0xffff,0xffff,0xffff,0xffff,0xffff,0x1048,0xffff,0x0c08,
0xb040,0xffff,0xac00,0xffff,0xffff,0xffff,0xffff,0xffff,0xd808,0xffff,0xf448,0xffff,0xffff,0xffff,0x9008,0xffff,
0xffff,0x6c00,0xffff,0xffff,0xec00,0x0840,0xf040,0x2400,0xffff,0xffff,0xffff,0xffff,0xffff,0x4408,0xffff,0x5848,
0x8000,0xc440,0x9c40,0xe800,0xffff,0xa000,0xffff,0x8c40,0xffff,0x8848,0xffff,0xffff,0xffff,0x3808,0xffff,0x2448,
0xcc40,0xffff,0xd000,0xffff,0xffff,0xffff,0xffff,0xffff,0x7048,0xffff,0x5c08,0xffff,0x1408,0xf048,0x3848,0xec08,
0xffff,0x0c00,0xc400,0xffff,0xffff,0x6840,0xffff,0xffff,0xffff,0xffff,0x2808,0xffff,0xffff,0x6c48,0xffff,0xffff,
0x9800,0xb040,0x8440,0xffff,0xffff,0xffff,0xffff,0xffff,0xb808,0xffff,0x9448,0x8008,0xffff,0xa808,0xf008,0xffff,
0xcc00,0x8840,0xd040,0xa400,0xf840,0xec00,0xffff,0xc040,0xffff,0x6808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8000,0xffff,0xffff,0xffff,0x1008,0xffff,0x5808,0xbc48,0x7448,0xffff,
0x9440,0x4000,0x8800,0x6c40,0xffff,0xffff,0xffff,0x0800,0xffff,0x3c48,0xffff,0xffff,0xffff,0xffff,0xffff,0x9048,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd440,0xffff,0xf408,0xffff,0xffff,0xffff,0x9048,0xe408,0xffff,0xf848},
{
0x2808,0x0848,0xffff,0x5008,0x3000,0xffff,0x9840,0xffff,0xffff,0x0808,0x2840,0xffff,0x3008,0xffff,0x3000,0x2040,
0x8000,0xffff,0xffff,0xa048,0xffff,0xffff,0xffff,0xffff,0x9000,0xffff,0xffff,0xe800,0xffff,0x6848,0xffff,0xffff,
0x9c08,0xffff,0xffff,0x8c40,0xffff,0x3408,0x1440,0xffff,0xffff,0x0c00,0xffff,0xa440,0xffff,0x2408,0x5c08,0xffff,
0x5448,0xffff,0xfc08,0xffff,0xffff,0x9c00,0xe400,0xffff,0x5440,0xffff,0xffff,0xffff,0xbc00,0xffff,0xbc08,0x9c48,
0xffff,0xffff,0xffff,0xffff,0x0840,0xffff,0xa000,0xffff,0xffff,0xffff,0x8048,0xffff,0xffff,0x1840,0x0808,0xffff,
0xffff,0x0848,0xffff,0xffff,0xffff,0xd008,0xc040,0xffff,0x3840,0xffff,0xffff,0x4040,0xffff,0x5008,0xffff,0xf848,
0xffff,0xb440,0xa408,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3440,0xffff,0xffff,0xffff,0x8c48,0xf448,0xffff,
0x6c08,0x7c48,0xc448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7c08,0x6c40,0xffff,0xffff,0x3448,0x1400,0xffff,
0xd048,0xffff,0xffff,0xa848,0xffff,0x1800,0xffff,0xb040,0xc048,0xffff,0xffff,0xe000,0x8808,0x9848,0x8800,0x9840,
0xffff,0x4840,0xffff,0xffff,0x4040,0xffff,0xffff,0x5008,0x6840,0xffff,0xffff,0x1040,0x4048,0xffff,0xe808,0xffff,
0x2408,0xffff,0xffff,0x3440,0xfc48,0xffff,0xffff,0xdc00,0x2400,0xffff,0x8c40,0xffff,0xffff,0xdc48,0xa448,0xffff,
0xffff,0x7c48,0xffff,0xd408,0xffff,0x6440,0xffff,0xffff,0xec40,0xffff,0xffff,0xfc08,0xffff,0x7440,0x5408,0xffff,
0x7808,0xffff,0xffff,0x0008,0xffff,0xffff,0xffff,0x8800,0xffff,0xffff,0x6848,0xffff,0xb000,0xa040,0xb008,0xffff,
0xffff,0xffff,0xc000,0xffff,0xffff,0x6808,0x7840,0xffff,0xffff,0xffff,0xffff,0xb800,0x7808,0xffff,0xd048,0xffff,
0xffff,0x0c40,0x1c08,0xffff,0xffff,0x7400,0x5448,0xffff,0x1c40,0xffff,0xb400,0xffff,0xffff,0x7408,0x0c08,0xffff,
0xffff,0x4408,0xffff,0xec48,0xffff,0xcc00,0xb400,0xffff,0xffff,0xc408,0xd440,0xffff,0xfc08,0xffff,0xfc00,0xffff},
{
0x4848,0x0008,0xffff,0xffff,0x0408,0x4048,0x7c40,0xffff,0x6c48,0x1408,0xffff,0xffff,0x1008,0x6448,0xffff,0x8c00,
0xffff,0x2000,0xdc08,0xffff,0xffff,0xffff,0xffff,0xc008,0xffff,0x3400,0xf808,0xffff,0xb800,0xffff,0xffff,0xffff,
0xffff,0xffff,0x2008,0x0448,0xffff,0xc040,0x0c48,0x2408,0xec40,0x6800,0xffff,0x1048,0xffff,0xe440,0x1848,0xffff,
0xffff,0xffff,0x4800,0xac40,0xffff,0xffff,0x2c40,0x5400,0xffff,0xffff,0x6c00,0xffff,0xffff,0xffff,0x3840,0x7000,
0x0c40,0x4800,0xffff,0xffff,0xc400,0x1c40,0xffff,0xffff,0x2840,0x5c00,0xffff,0xffff,0xd000,0x3840,0xffff,0xffff,
0xffff,0xe008,0x8c00,0xffff,0xe408,0xffff,0xffff,0x8800,0xffff,0xf408,0xa800,0xffff,0xf008,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xc840,0xffff,0x8448,0x4840,0xffff,0xb048,0xffff,0x5400,0xffff,0xffff,0xa048,0x5c40,0xffff,
0xffff,0xffff,0x0008,0xffff,0xffff,0xffff,0xe048,0x0408,0xffff,0xffff,0x2408,0xfc48,0xffff,0xffff,0xf448,0x2008,
0xc448,0x8c08,0xffff,0xf840,0x2400,0xffff,0xffff,0xffff,0xe048,0x9808,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c08,
0xffff,0xac00,0xffff,0xffff,0x8c08,0xf848,0xffff,0xffff,0xffff,0xb800,0x7408,0xffff,0x9808,0xdc48,0xe040,0xffff,
0xffff,0xffff,0xf000,0x2440,0xffff,0x4c40,0x8048,0xffff,0xffff,0xffff,0xd400,0x3040,0xffff,0x6840,0x9448,0xffff,
0x7040,0xffff,0xffff,0xffff,0xffff,0xffff,0xa040,0xd800,0xffff,0xffff,0xffff,0x9848,0xc008,0xffff,0xb440,0xfc00,
0xffff,0x6808,0x3400,0xffff,0x4800,0x9040,0xffff,0xffff,0xffff,0x7c08,0xffff,0xffff,0x5c00,0xb440,0xffff,0xffff,
0xb440,0xc000,0xffff,0xffff,0x6808,0xffff,0xffff,0xffff,0x9040,0xd400,0xffff,0xffff,0x7c08,0xffff,0xffff,0x2000,
0x1848,0xffff,0xffff,0x4440,0xffff,0xffff,0x6848,0xbc08,0x3c48,0xffff,0xffff,0x5040,0xffff,0xffff,0x7c48,0x9808,
0xffff,0xffff,0x8c08,0x6448,0xffff,0xffff,0xc040,0xffff,0xffff,0xffff,0xa808,0x7048,0xffff,0x1848,0xd440,0xffff},
{
0xffff,0x8408,0x5c00,0x6c00,0xffff,0x8c08,0x5400,0x6400,0xffff,0x3400,0xffff,0xffff,0x1808,0x6008,0xffff,0xffff,
0x1000,0xffff,0xffff,0xffff,0x1800,0xffff,0xffff,0xffff,0xb408,0xffff,0x6000,0xffff,0xffff,0x9800,0xc408,0x7c08,
0xffff,0x8808,0x6000,0x5000,0xffff,0x8008,0x6800,0x5800,0xffff,0x3800,0xffff,0xffff,0x1408,0xffff,0x9000,0xffff,
0x1c00,0xffff,0xffff,0x3408,0x1400,0x7400,0xffff,0xffff,0xffff,0xffff,0x5c00,0xe400,0xffff,0x9400,0xffff,0x4008,
0x1c48,0xa448,0xffff,0xd040,0xffff,0x0040,0xfc48,0xffff,0x4840,0xffff,0x0048,0xffff,0x4040,0xffff,0x0848,0x6848,
0xffff,0xffff,0xffff,0x2848,0xd048,0x6848,0xffff,0x7c40,0x2c48,0x1c48,0xf440,0xffff,0x2448,0xffff,0xfc40,0xffff,
0xffff,0xffff,0xffff,0xdc40,0x8440,0x3c40,0xf048,0xffff,0xffff,0xffff,0xffff,0x6c48,0x7c40,0xffff,0xffff,0x6448,
0xffff,0xf040,0x5c48,0xffff,0xffff,0xffff,0x0840,0x7040,0x1048,0x2048,0xf840,0xffff,0x1848,0x2848,0xf040,0xffff,
0xffff,0x1800,0xd408,0xffff,0xffff,0xffff,0x7000,0xc800,0xffff,0xffff,0xffff,0xffff,0xffff,0xb808,0xffff,0xffff,
0x9808,0xffff,0xffff,0xffff,0xffff,0xffff,0x1808,0xffff,0xffff,0xffff,0xffff,0x5c08,0x2c00,0xffff,0x6408,0x5408,
0xffff,0x1400,0xe808,0x5008,0x3808,0xffff,0xffff,0xffff,0xffff,0xbc08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x9408,0xffff,0xffff,0xffff,0xffff,0xb800,0x2408,0xffff,0x2800,0xffff,0x5008,0x6008,0x2000,0xffff,0x5808,0x6808,
0xffff,0x2c40,0xffff,0x5448,0x1440,0xffff,0xffff,0x5c48,0xffff,0xffff,0xffff,0xfc40,0xffff,0xffff,0xd048,0xffff,
0xffff,0xffff,0xc040,0xffff,0xffff,0xffff,0xc840,0xffff,0xa840,0x1040,0x7c48,0xffff,0x0c48,0xb448,0xffff,0x5040,
0x2040,0xffff,0xffff,0xffff,0x2840,0x1840,0xffff,0x5048,0xffff,0xffff,0xffff,0xf040,0xffff,0xffff,0xdc48,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x7c48,0xc440,0xffff,0x9440,0x2c40,0x7048,0xffff,0x3048,0x8848,0xffff,0x5c40},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0x1c00,0xffff,0x3040,0xffff,0xffff,0xffff,0xffff,0x1800,0xffff,0x3440,0xffff,
0xd040,0xffff,0xffff,0xffff,0xe448,0xac08,0xf808,0x8048,0xffff,0x5040,0xffff,0x4c00,0xa808,0xec48,0x8448,0xffff,
0x4c40,0xa800,0x5000,0x8440,0xf048,0xffff,0xec08,0xffff,0xb800,0xc040,0xffff,0xffff,0xffff,0xffff,0xffff,0xe808,
0xffff,0xffff,0xffff,0x2048,0xffff,0xffff,0xffff,0xffff,0x1c08,0xffff,0x3048,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x7000,0xffff,0x5c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5400,0xffff,0x7840,0xffff,
0x9c40,0xffff,0x8000,0xffff,0xa848,0xe008,0xffff,0xcc48,0xc408,0xffff,0xe848,0xac08,0xffff,0x0c40,0xffff,0x1000,
0xac48,0xffff,0xb008,0xffff,0x1040,0xc400,0x0c00,0xe840,0xf400,0xffff,0xd840,0x9000,0xffff,0xb848,0xffff,0xffff,
0xffff,0x4008,0xffff,0x6c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7008,0xffff,0xffff,0xffff,
0xffff,0xffff,0x8000,0xffff,0xffff,0x8008,0xffff,0xac48,0xffff,0xffff,0xffff,0x8800,0xffff,0xffff,0xb048,0x3408,
0xffff,0xffff,0xcc08,0xffff,0x6c40,0x2800,0x7000,0x0440,0xffff,0xd848,0xffff,0xc408,0x3400,0xec40,0x1840,0xf000,
0xc848,0x2008,0xd408,0x0c48,0xfc40,0xffff,0xe000,0xffff,0x2808,0xcc48,0x0448,0xd008,0xffff,0x7040,0xffff,0xffff,
0xffff,0x9c00,0xffff,0xb040,0x3448,0xffff,0xffff,0xffff,0x9400,0xffff,0xb840,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe048,0xf008,0x7448,0xdc48,0xffff,0xffff,0xffff,0xffff,0xffff,
0x3040,0x4400,0xffff,0x6840,0x8c48,0xffff,0x9008,0xffff,0xffff,0x9448,0xffff,0x8808,0x7800,0xa040,0x5440,0xbc00,
0x8448,0x6c08,0x9808,0x4048,0xb040,0xffff,0xffff,0xffff,0xffff,0x2c40,0xffff,0x3000,0x4408,0xffff,0x6848,0x8c08,
0xffff,0x8c08,0xffff,0xffff,0xffff,0xf000,0xc800,0xdc40,0xd800,0xffff,0xf440,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xd040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7408,0xf440,0x0448,0x5408,0x0808,0xffff,0x7440,0xffff,0x7800,
0xa008,0xffff,0xffff,0xffff,0xffff,0xa408,0x1c48,0xa848,0xffff,0x0c00,0xffff,0xffff,0x1000,0xffff,0x1c40,0xb040,
0xffff,0x3c00,0xffff,0xffff,0x3800,0xffff,0x3440,0x8040,0x9008,0xffff,0xffff,0xffff,0xffff,0x8c08,0x2c48,0x8048,
0xffff,0xffff,0x6408,0xffff,0xb848,0xcc40,0xffff,0xffff,0x6840,0xffff,0x6400,0xffff,0xffff,0xffff,0xffff,0x4408,
0xffff,0xffff,0xac08,0xffff,0xffff,0xffff,0xffff,0x8c00,0x0c48,0xffff,0xac00,0xffff,0x7040,0x0448,0xffff,0x0808,
0xffff,0x6408,0xc848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xdc40,0x6440,0xffff,0xd800,0xffff,0xffff,
0xf800,0xffff,0xf440,0x5440,0xffff,0xe800,0xffff,0xffff,0xa800,0x4c08,0xf848,0x4048,0x4408,0xac00,0x1440,0xffff,
0x3c48,0xffff,0x9c00,0xffff,0xffff,0xffff,0xffff,0xb008,0x1848,0xffff,0x1408,0xffff,0x6840,0x1c48,0xffff,0xbc00,
0xffff,0xffff,0x4000,0xffff,0xffff,0x4840,0xffff,0xe808,0x6840,0x9848,0xffff,0xffff,0xffff,0xe840,0xffff,0xe400,
0x0c08,0xffff,0xffff,0xffff,0xffff,0x0808,0xb048,0x0448,0xffff,0xa000,0xffff,0xffff,0xbc00,0xffff,0xb040,0x1c40,
0xffff,0x9000,0xffff,0xffff,0x9400,0xffff,0xffff,0x2c40,0x3c08,0xffff,0xffff,0xffff,0xd000,0x2008,0x8048,0x2c48,
0xffff,0xffff,0xf808,0xffff,0xffff,0xffff,0xffff,0x5c00,0xf440,0x0448,0xf800,0xffff,0xffff,0x7840,0xffff,0xd808,
0x3c48,0xffff,0xffff,0xffff,0xffff,0xb048,0xffff,0x1000,0x9048,0xffff,0xffff,0xffff,0xffff,0x9848,0x4c08,0x9408,
0xffff,0xc808,0x6448,0xc448,0xd808,0xffff,0xffff,0xffff,0x7c00,0xffff,0xffff,0xffff,0xffff,0x7400,0xffff,0xffff,
0x5400,0xffff,0x5840,0xf840,0xffff,0x4400,0xffff,0xffff,0xffff,0xe008,0x5448,0xec48,0xe808,0xffff,0xffff,0xffff,
0xa048,0xffff,0xffff,0xffff,0xffff,0x2048,0xffff,0xffff,0x8448,0xffff,0x8808,0xffff,0xf440,0xffff,0xf800,0x2000},
{
0xa408,0xffff,0x5800,0x2048,0xffff,0x6840,0xffff,0xffff,0xffff,0x4440,0xf800,0x8048,0x8808,0xffff,0xffff,0xffff,
0x6848,0x1048,0xffff,0x1c40,0xffff,0x0400,0xffff,0xffff,0xffff,0x1800,0xffff,0xffff,0x7448,0xffff,0x8040,0x6808,
0xffff,0xffff,0xffff,0xffff,0xe040,0x0808,0xffff,0xb440,0x9408,0x7c40,0xffff,0xffff,0xffff,0x5808,0xc408,0xffff,
0xffff,0xffff,0x8448,0xffff,0x7c48,0xffff,0xffff,0x4800,0xffff,0xffff,0xffff,0x6400,0xffff,0xa400,0xa848,0x4048,
0xffff,0xffff,0x6840,0xffff,0x2048,0xc800,0xffff,0x0408,0x5400,0xbc48,0xffff,0x1808,0xffff,0xffff,0xffff,0xffff,
0x5808,0xffff,0xffff,0xffff,0xffff,0xffff,0x7048,0xffff,0xffff,0xffff,0x5c48,0xffff,0xffff,0xffff,0xffff,0x9000,
0xffff,0x9c40,0xffff,0xffff,0x5008,0xffff,0xffff,0x0408,0x7c08,0xffff,0xffff,0xffff,0xffff,0xb040,0xdc40,0xffff,
0xd800,0xffff,0x3400,0xdc48,0xffff,0xb448,0xffff,0xffff,0xffff,0xa848,0xffff,0xffff,0xc400,0xffff,0x4048,0xffff,
0x4c08,0xa408,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c40,0x4440,0xffff,0xffff,0xffff,0xffff,0x8808,0xd408,0xac40,
0xd048,0xffff,0x0c48,0xe400,0xffff,0xbc00,0x2800,0xffff,0xffff,0xa000,0xffff,0xffff,0xcc48,0xffff,0x7800,0x9048,
0xffff,0xffff,0xffff,0xffff,0xffff,0xf048,0xffff,0x0c40,0x6c48,0x8400,0xffff,0x1040,0xffff,0xffff,0x7c08,0xffff,
0x5040,0x2808,0xffff,0x8448,0xffff,0xffff,0xffff,0xffff,0xf040,0x8808,0x6400,0xffff,0xffff,0xffff,0xffff,0xa848,
0xfc40,0xffff,0xd040,0xffff,0xd808,0xffff,0xc408,0xbc08,0xac40,0x4408,0xffff,0xa008,0x8808,0xffff,0xcc40,0xffff,
0xffff,0xffff,0xbc00,0xffff,0x7400,0xffff,0xffff,0x7048,0xffff,0xffff,0xffff,0x5c48,0xffff,0xac48,0x9000,0xffff,
0x9c40,0xffff,0xffff,0x2800,0xffff,0x5008,0xffff,0xffff,0xffff,0x7c08,0xf048,0x8800,0xb040,0xffff,0xffff,0xffff,
0x6000,0xffff,0xffff,0x2408,0x7448,0xffff,0xffff,0xffff,0xffff,0xffff,0x9c40,0xffff,0x7c00,0xffff,0xb808,0x5040},
{
0x2808,0x0848,0xffff,0x5008,0x3000,0xffff,0x9840,0xffff,0xffff,0x0808,0x2840,0xffff,0x3008,0xffff,0x3000,0x2040,
0x8000,0xffff,0xffff,0xa048,0xffff,0xffff,0xffff,0xffff,0x9000,0xffff,0xffff,0xe800,0xffff,0x6848,0xffff,0xffff,
0x9c08,0xffff,0x9c00,0x8c40,0xffff,0x3408,0x1440,0xffff,0xffff,0x0c00,0xffff,0xa440,0xffff,0x2408,0x5c08,0xffff,
0x5448,0xffff,0xfc08,0xffff,0xffff,0x9c00,0xe400,0xffff,0x5440,0xffff,0xffff,0x4408,0xbc00,0xffff,0xffff,0x9c48,
0x8048,0xffff,0xffff,0xf848,0x0840,0xffff,0xa000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1840,0x0808,0xffff,
0xffff,0x0848,0x2800,0xffff,0xffff,0xd008,0xc040,0xd000,0x3840,0xffff,0xffff,0x4040,0xffff,0x5008,0xffff,0xf848,
0xffff,0xffff,0xa408,0xffff,0xbc40,0xffff,0xffff,0xffff,0xffff,0x3440,0xffff,0xffff,0xac08,0xffff,0xf448,0xffff,
0x6c08,0x7c48,0xc448,0xffff,0x1400,0xffff,0xffff,0xffff,0xffff,0x7c08,0x6c40,0xffff,0xffff,0x3448,0x1400,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x1800,0xffff,0xb040,0xc048,0xffff,0xffff,0xe000,0x8808,0x9848,0x8800,0x9840,
0xffff,0x4840,0x6808,0xffff,0x4040,0xffff,0xffff,0x5008,0x6840,0xffff,0xffff,0x1040,0x4048,0xffff,0xe808,0xffff,
0x2408,0xffff,0xffff,0x3440,0xfc48,0xffff,0xffff,0xdc00,0x2400,0xffff,0x8c40,0xffff,0xffff,0xdc48,0xa448,0xffff,
0xffff,0x7c48,0xffff,0xd408,0xffff,0x6440,0x1c40,0xffff,0xec40,0xffff,0xffff,0xfc08,0xffff,0x7440,0x5408,0xffff,
0x7808,0xffff,0xffff,0x0008,0xffff,0x2040,0xffff,0x8800,0xffff,0x4800,0x6848,0xffff,0xb000,0xa040,0xb008,0xffff,
0xffff,0xe048,0xc000,0xffff,0xffff,0xffff,0x7840,0xffff,0xffff,0xe040,0xffff,0xffff,0x7808,0xffff,0xd048,0xffff,
0xffff,0xffff,0x1c08,0xffff,0xffff,0x7400,0x5448,0xffff,0xffff,0xffff,0xb400,0xffff,0xffff,0x7408,0xffff,0xffff,
0xffff,0x4408,0xffff,0xec48,0xffff,0xcc00,0xb400,0x9440,0xffff,0xffff,0xd440,0xffff,0xffff,0xffff,0xfc00,0xffff},
{
0xffff,0x5c48,0xffff,0xffff,0xffff,0xffff,0x0040,0xffff,0xd448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8840,
0x8400,0xffff,0x3c48,0xd400,0x9800,0x7048,0xffff,0xd808,0xffff,0x0c00,0x4c08,0xa440,0xe840,0x0008,0x5008,0xffff,
0x9400,0xffff,0x7400,0xffff,0xffff,0x3800,0xffff,0xffff,0xffff,0x1c00,0x0440,0xec08,0xa008,0x4840,0x4008,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x0848,0x1040,0xffff,0xc448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9840,
0xffff,0xffff,0xe800,0x9000,0xffff,0x4408,0xffff,0x1c00,0xffff,0xf808,0xffff,0xa000,0xffff,0x7408,0xffff,0xffff,
0x3048,0x4800,0xe848,0xffff,0x3c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c40,0xffff,0xd440,0xac08,
0xffff,0xffff,0xc848,0xffff,0xffff,0x6440,0xec48,0xffff,0x0840,0xffff,0xf848,0xffff,0x2c40,0xffff,0xffff,0xffff,
0xb848,0xc000,0xffff,0xffff,0xffff,0x6408,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c40,0x2408,
0xffff,0x0008,0xffff,0xffff,0xf440,0xffff,0xffff,0xd400,0xffff,0x3008,0x1048,0xffff,0xffff,0xffff,0xffff,0xe400,
0x7840,0xffff,0xa040,0xffff,0xffff,0xffff,0xac48,0xffff,0x4840,0xffff,0xffff,0xffff,0x4448,0x3c00,0x9c48,0xffff,
0xffff,0x2040,0xffff,0xffff,0xffff,0x0408,0x8c48,0xffff,0x6840,0xffff,0x9848,0xe000,0xcc00,0xffff,0xffff,0xffff,
0xffff,0x2008,0x2840,0xffff,0xffff,0xffff,0xffff,0xf400,0xffff,0x1008,0xffff,0xffff,0xcc48,0xb400,0xbc00,0xc400,
0x6c08,0x8440,0xd440,0xffff,0xffff,0x8848,0xc840,0x2008,0x1c48,0xf400,0xb440,0x5c40,0x0048,0xffff,0xb800,0x5048,
0xffff,0xffff,0xffff,0xffff,0x5000,0xffff,0xffff,0x1040,0xffff,0xffff,0x8408,0xffff,0xffff,0xd800,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x4000,0xffff,0xffff,0x5808,0xffff,0xffff,0x9408,0xffff,0xffff,0xc800,0xffff,0xffff,
0x2440,0xffff,0xc440,0xffff,0xffff,0x9848,0x8008,0x6840,0xffff,0xbc48,0xffff,0x4c40,0xffff,0xffff,0xf048,0x1800},
{
0xffff,0xffff,0x5408,0x6c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0440,0xffff,0x1408,0x6c40,0xa840,0xffff,
0x1000,0xffff,0xffff,0x0408,0xffff,0x7c40,0x3848,0x0040,0xffff,0xffff,0x6c00,0xffff,0xec48,0x9400,0xffff,0xffff,
0xffff,0xffff,0xffff,0x5c48,0xec08,0x8400,0x6008,0x5800,0x4840,0xffff,0xffff,0x8c40,0xffff,0xffff,0xffff,0x2040,
0xffff,0x7840,0x0c48,0x3440,0x1400,0xffff,0x0800,0x3008,0xb000,0xc848,0xffff,0xe400,0xffff,0xffff,0xffff,0x4800,
0x1c48,0xffff,0xa000,0xd848,0xffff,0xffff,0xffff,0xffff,0x4c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x5840,0x2008,0xd808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9000,0xffff,0x1848,0xfc40,0xffff,
0xffff,0x9448,0xa048,0xffff,0xffff,0x3848,0xfc48,0xffff,0xffff,0xffff,0xffff,0x6840,0x7800,0x4008,0x0400,0x6c08,
0xffff,0xfc08,0xffff,0xffff,0xffff,0x5008,0x0408,0x7c40,0x1440,0x2c48,0xf840,0xffff,0xffff,0xffff,0xfc08,0x9400,
0xffff,0xffff,0xffff,0x6400,0x3c00,0x4448,0xffff,0xc800,0xd040,0xffff,0x0c40,0xffff,0xffff,0xbc00,0x0808,0xffff,
0x9840,0xffff,0xb408,0x0c40,0xc440,0xffff,0xffff,0xa040,0xffff,0x4040,0xffff,0xffff,0x2c00,0xffff,0x6000,0x5808,
0x6048,0x1800,0xec00,0xffff,0xffff,0xffff,0x4000,0xffff,0xffff,0xffff,0xffff,0xffff,0xd440,0xbc48,0x3840,0x0048,
0x9808,0xe040,0x8440,0xffff,0xffff,0xffff,0x2840,0xffff,0x2800,0xffff,0xffff,0x6c08,0xffff,0xffff,0xffff,0xffff,
0x1448,0x2c40,0xffff,0x5040,0xffff,0xffff,0xffff,0xffff,0xc440,0x7c08,0xffff,0xf040,0xffff,0xd008,0xffff,0xffff,
0xffff,0xffff,0xc040,0xffff,0x7808,0x4000,0xffff,0xac00,0xffff,0x1448,0x7048,0x0800,0xffff,0xb848,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x2048,0x1840,0xffff,0x5440,0xf408,0xffff,0xffff,0xf008,0xffff,0xffff,0xffff,0xac08,
0x4c08,0x7400,0xffff,0xa800,0x4840,0xffff,0xc440,0xffff,0x9c48,0xffff,0xffff,0xffff,0x3048,0xffff,0x2c00,0xffff},
{
0xffff,0xffff,0x7400,0x5808,0x3400,0x2808,0x9448,0x8840,0xffff,0x0848,0xffff,0xffff,0x3808,0x2400,0x3448,0x2840,
0xffff,0xac48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9848,0xffff,0xc800,0xffff,0xffff,0x6408,0xffff,0xffff,
0x9408,0x8800,0x9848,0x8440,0x1840,0xffff,0xffff,0xffff,0xffff,0x0c08,0xb048,0xac40,0xffff,0x2c40,0x5000,0x7c08,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x8c40,0xa048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8048,0xac40,0x8c08,0xa000,0xffff,0xffff,0xffff,0xffff,
0x2448,0x0840,0x2808,0x0400,0xc800,0xd408,0xc440,0xd848,0x3040,0x1c48,0xffff,0xffff,0x4008,0x5c00,0xffff,0xfc48,
0xffff,0xffff,0xffff,0xffff,0xbc48,0xffff,0xb008,0xffff,0xffff,0xffff,0xffff,0xffff,0xa840,0x8448,0xffff,0xffff,
0x6408,0x7800,0xc440,0xd848,0x1440,0x3848,0xffff,0xffff,0x6400,0x7808,0x6840,0x7448,0x1848,0x3440,0x1408,0x3800,
0xdc40,0xf048,0xffff,0xffff,0x0c08,0x1000,0xac40,0xb048,0xc448,0xffff,0xffff,0xe400,0x8800,0x9408,0xffff,0x9848,
0x6048,0x4c40,0x6c08,0x4000,0xffff,0x5008,0xffff,0xffff,0xffff,0x4c48,0xffff,0x1c00,0xffff,0x5c00,0xe040,0xffff,
0x2400,0xffff,0x2840,0x3448,0xf848,0xffff,0xf408,0xd800,0x2808,0x3400,0x8840,0x9448,0xf840,0xd448,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x4440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5c48,0x7040,0x5008,0xffff,
0xffff,0xffff,0x2400,0x0808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x7808,0x6400,0x7448,0x6840,0xc848,0xffff,0x9800,0xb408,0x7800,0x6408,0xffff,0xc440,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0000,0x2c08,
0x5c00,0x4008,0xfc48,0xffff,0xffff,0xffff,0xbc00,0x9008,0xd408,0xc800,0xffff,0xc440,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0x2800,0x5000,0xffff,0xffff,0x3008,0x8808,0x9848,0x0800,0xffff,0xffff,0x2848,0xffff,0x3000,0x2048,0x3008,
0xffff,0x8008,0xa040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9008,0xffff,0xffff,0x6840,0xffff,0xffff,0xffff,
0xffff,0x9c00,0x8c48,0x9c08,0x3400,0xffff,0xffff,0x1448,0x0c08,0xffff,0xa448,0xffff,0x2400,0xffff,0xffff,0x5c00,
0xffff,0x5440,0xffff,0xfc00,0x9c08,0xffff,0xffff,0xe408,0xffff,0x5448,0xffff,0xffff,0xffff,0xbc08,0x9c40,0xbc00,
0xffff,0xffff,0xffff,0xffff,0xffff,0x0848,0xffff,0xa008,0xffff,0xffff,0xffff,0xffff,0x1848,0xffff,0xffff,0x0800,
0xffff,0x2800,0xffff,0x2808,0xd000,0xffff,0xd008,0xc048,0x1808,0x3848,0x4048,0xffff,0x5000,0xffff,0xf840,0xffff,
0xb448,0xffff,0xffff,0xa400,0xffff,0xffff,0xffff,0xffff,0x3448,0xffff,0x9c08,0xffff,0x8c40,0xac00,0xffff,0xf440,
0x7c40,0x6c00,0xffff,0xc440,0xffff,0xffff,0xffff,0xffff,0x7c00,0xffff,0xffff,0x6c48,0x3440,0xffff,0xffff,0x1408,
0xffff,0xffff,0xffff,0xffff,0x1808,0xffff,0xb048,0xffff,0xffff,0xc040,0xe008,0xffff,0xffff,0x8800,0x9848,0x8808,
0x4848,0xffff,0xffff,0x6800,0x5008,0x4048,0x5000,0xffff,0xffff,0x6848,0x1048,0xffff,0xffff,0x4040,0xffff,0xe800,
0xffff,0xffff,0x3448,0xffff,0xffff,0xfc40,0xdc08,0xffff,0xffff,0x2408,0xffff,0x8c48,0xdc40,0xffff,0xffff,0xa440,
0xffff,0xffff,0xd400,0xffff,0x6448,0xffff,0xffff,0xffff,0xffff,0xec48,0xfc00,0xffff,0x7448,0xffff,0xffff,0x5400,
0xffff,0x7800,0x0000,0xffff,0x2048,0xffff,0x8808,0xffff,0xffff,0xffff,0xffff,0x6840,0xa048,0xb008,0xffff,0xb000,
0xffff,0xffff,0xe048,0xc008,0xffff,0xffff,0xffff,0x7848,0xffff,0xc008,0xb808,0x9848,0x6840,0x7800,0xffff,0xd040,
0x0c48,0xffff,0xffff,0x1c00,0x7408,0xffff,0xffff,0xffff,0xffff,0x1c48,0xffff,0xb408,0x7400,0xffff,0xffff,0x0c00,
0x4400,0xffff,0xec40,0xffff,0xcc08,0xffff,0xffff,0xb408,0xffff,0xffff,0xffff,0xd448,0xffff,0xffff,0xffff,0xfc08},
{
0xffff,0xb400,0xffff,0x1c40,0xffff,0xc840,0xb848,0x6000,0xffff,0x1c08,0xffff,0xffff,0xffff,0xffff,0xffff,0x6008,
0xffff,0x6848,0xffff,0xffff,0xffff,0xffff,0x3c48,0x8448,0xffff,0xffff,0xffff,0x7808,0x3c00,0xffff,0xffff,0x9448,
0xffff,0x1808,0xf800,0xffff,0x1400,0xf448,0xffff,0xffff,0xb008,0x4048,0xffff,0xffff,0x5c48,0xac40,0xffff,0xac48,
0xd440,0xa408,0x7c00,0xffff,0xa800,0xffff,0x0040,0xd808,0x7c48,0xffff,0xffff,0xffff,0x0040,0xffff,0x0048,0xffff,
0xbc48,0xffff,0xffff,0xffff,0xffff,0xffff,0xc048,0xffff,0x1440,0x6408,0xbc00,0xffff,0x6800,0xffff,0xc040,0x1808,
0xffff,0xffff,0xe848,0xffff,0xffff,0xac40,0x0408,0xffff,0xf808,0xffff,0xffff,0x4048,0xffff,0xffff,0x1408,0xac08,
0xd008,0x2048,0xffff,0xffff,0xffff,0xffff,0x3c08,0xffff,0xffff,0x6848,0xffff,0x6840,0x6408,0x8440,0xffff,0xffff,
0xffff,0xdc08,0xffff,0xffff,0xffff,0xffff,0xffff,0xa008,0x0448,0x7400,0x0440,0xdc40,0xffff,0x0840,0x7848,0xa000,
0xffff,0xffff,0x5408,0xffff,0x2808,0xffff,0xffff,0xf048,0x7c48,0xffff,0xd408,0x8c48,0x0008,0xffff,0xa848,0xffff,
0x2800,0xffff,0xffff,0xc808,0xc440,0x2408,0xffff,0xffff,0xffff,0x8000,0xffff,0xd840,0x9c48,0xffff,0x9c40,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xb440,0x0c40,0xffff,0xffff,0x4800,0xe008,0xffff,0x0c08,0xffff,0xffff,
0xffff,0x3440,0xffff,0x3448,0xffff,0xffff,0xffff,0xffff,0xffff,0x1c08,0xec08,0xb448,0x9008,0xffff,0xffff,0xc808,
0xffff,0xdc08,0x2c08,0x7448,0x5008,0xa048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8848,0xffff,0xffff,
0x1040,0xffff,0xffff,0xe008,0xffff,0xffff,0xffff,0x0c00,0x5840,0xb840,0xffff,0xffff,0xb448,0x5400,0xffff,0xffff,
0xffff,0xffff,0x7048,0xd840,0x9c48,0xffff,0xffff,0x3400,0xffff,0xffff,0x7040,0xffff,0xffff,0xffff,0x9c00,0x2400,
0xbc48,0xffff,0xffff,0xffff,0xc008,0x3048,0x6848,0xffff,0x9400,0xffff,0x9408,0xffff,0xe808,0xffff,0xffff,0x3048}
};


void enduror_decode_data(data16_t *dest,data16_t *source,int size)
{
	system16_decode(dest,source,size,(unsigned short *)enduroracer_decrypt_data3);
}

void enduror_decode_data2(data16_t *dest,data16_t *source,int size)
{
	system16_decode(dest,source,size,(unsigned short *)enduroracer_decrypt_data4);
}


/***********************************************************************************
      Decryption Tables for Aurail
***********************************************************************************/

unsigned short aurail_decrypt_data[16][256]={
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc008,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x4408,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x5400,0xffff,0xffff,0xffff,0xffff,0xa808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xc008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xbc48,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x9c40,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xcc40,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x7c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa840,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x9000,0xffff,0x2848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9048,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0x8040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xd848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x5400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0x9448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xfc48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2848,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x7848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe040,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x9c48,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa840,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xe440,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xf848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xf008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x3848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf840},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3848,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x5c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2808,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0x1848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x8008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4008,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff}
};


unsigned short aurail_decrypt_opcode1[16][256]={
{
0xffff,0x0c48,0x1008,0x3c00,0x5008,0x1000,0x3040,0xffff,0xffff,0x1848,0x0408,0x2800,0xffff,0x3400,0x1440,0x4c48,
0x1848,0x1048,0xffff,0x2000,0x4c08,0x5008,0x2c40,0x2840,0xffff,0xffff,0xffff,0x3400,0x6808,0x7408,0x0840,0x0c40,
0xf040,0xdc48,0xc008,0x6400,0xffff,0xcc00,0xffff,0xffff,0xe440,0xc848,0xd408,0x7000,0xffff,0xe800,0xc840,0xffff,
0xffff,0x6c40,0xdc08,0xd408,0xd400,0xd000,0xffff,0xffff,0xffff,0x7840,0xffff,0xc008,0xf000,0xffff,0x8848,0x9448,
0x5c08,0xffff,0x2440,0xffff,0xffff,0xffff,0xf808,0x5c00,0x7808,0x2000,0x0040,0x4048,0xdc40,0xffff,0xffff,0xffff,
0x1c00,0x1800,0x6448,0x7848,0xd440,0x5440,0xe408,0xec08,0x3800,0x3c00,0x4048,0x5c48,0xc040,0x4040,0xffff,0xffff,
0x9808,0xd800,0xffff,0xa048,0xffff,0x3448,0x2808,0x0400,0xffff,0xfc00,0xdc40,0x8448,0x8440,0x2048,0x3c08,0xffff,
0xffff,0x9808,0xe440,0xe040,0xffff,0x2848,0x9800,0xffff,0xa008,0xbc08,0xffff,0xffff,0x3448,0x3c48,0xffff,0x0c00,
0x5048,0xffff,0xe800,0xc808,0x3400,0x7808,0x5448,0x0040,0x4448,0xec40,0xfc00,0xdc08,0xffff,0x5c08,0x7048,0xffff,
0xffff,0xe440,0x5808,0xd408,0x2800,0xffff,0x4848,0x4048,0xffff,0xf040,0x4c08,0xffff,0x0c00,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0x9c08,0xfc00,0xa808,0x8448,0xc840,0x1048,0xffff,0xffff,0x8808,0xd800,0x8c08,0xa048,0xec40,
0xffff,0x9448,0xffff,0x2c00,0xbc08,0xb408,0xc440,0xd440,0xffff,0x8048,0xffff,0xffff,0x9808,0x9008,0xffff,0xf040,
0x3400,0xffff,0xffff,0x0040,0x3c48,0x1c40,0x0c00,0xa408,0x1000,0xffff,0xffff,0x2440,0x2848,0x0840,0x1800,0xffff,
0xffff,0xffff,0xffff,0xffff,0x2048,0xffff,0x1000,0x1400,0x5008,0x5808,0x2840,0x3840,0x3448,0xb848,0xffff,0x0000,
0xfc00,0xb008,0x9c48,0xffff,0xffff,0xc040,0xd000,0xffff,0xd800,0x9408,0xb848,0xec40,0x7c48,0xd440,0xffff,0xe408,
0xe000,0xf000,0x8048,0x8848,0xd840,0xdc40,0x6008,0xec08,0xc400,0xd400,0xa448,0xac48,0xcc40,0xc840,0xffff,0xf808},
{
0x1008,0x6840,0x3400,0xd048,0x0808,0xffff,0x1c00,0xf848,0x1408,0x6c40,0x6c40,0x8808,0x0c08,0xffff,0x4440,0xffff,
0x7440,0x9c08,0xac48,0xd800,0x5c40,0xb408,0xb448,0xc000,0x7040,0x9808,0x0408,0x7040,0x5840,0xb008,0x1c08,0x6840,
0xffff,0xec40,0xffff,0xffff,0xffff,0xf440,0x7c00,0x9448,0x3048,0xffff,0xffff,0xffff,0x2848,0x5c00,0x7800,0xffff,
0x0040,0xe408,0xa048,0xd800,0x2840,0xcc08,0xffff,0xc000,0x5800,0xbc48,0xa448,0xdc00,0xffff,0xffff,0xffff,0xc400,
0xa008,0xffff,0x8800,0x6048,0xb808,0xffff,0xa000,0x4848,0x0848,0x7c00,0x8c00,0x6448,0x1048,0xffff,0xa400,0x4c48,
0xffff,0x2c08,0x1c48,0x6400,0xffff,0x0408,0x0448,0x7c00,0x9000,0x7448,0x1848,0x6000,0xb800,0x5c48,0xffff,0x7800,
0xac08,0xd440,0xfc00,0x1848,0xb408,0xffff,0xd400,0x3048,0xffff,0xffff,0xffff,0x4008,0xffff,0xffff,0xffff,0x6808,
0xffff,0x4008,0x9448,0xe000,0x8040,0xffff,0x8c48,0xffff,0xac40,0x4408,0x3c08,0x4840,0x8440,0x6c08,0x2408,0x5040,
0xa048,0xd800,0xc040,0xffff,0xb848,0xffff,0xffff,0xffff,0xa448,0xdc00,0x9800,0xffff,0xbc48,0xc400,0xb000,0x5448,
0x9400,0x7c48,0x9808,0xffff,0xffff,0x5448,0xffff,0xf440,0x9000,0x7848,0xffff,0x4400,0xb800,0xffff,0xffff,0xffff,
0xac48,0xffff,0xb440,0x5c08,0xb448,0xc000,0x9c40,0x7408,0xffff,0x7040,0xffff,0x5808,0x1c08,0x6840,0x9840,0xffff,
0xf400,0xffff,0xffff,0x6840,0xdc00,0x3848,0xffff,0x7040,0xac40,0xffff,0x1408,0xffff,0x8440,0xffff,0x0c08,0x7440,
0x9448,0xe000,0xffff,0x8008,0x8c48,0xf800,0xffff,0xffff,0xffff,0xffff,0x6c40,0x8408,0x2408,0x5040,0xffff,0xac08,
0x3c00,0xd848,0xffff,0xd440,0xffff,0xf048,0xb408,0xcc40,0xffff,0x8008,0xa808,0xd040,0x4c40,0xa808,0xb008,0xc840,
0x1c48,0xffff,0x0840,0xec08,0x0448,0xffff,0x2040,0xc408,0xffff,0x6000,0x5000,0xffff,0x0048,0xffff,0x7800,0x9c48,
0xffff,0xa048,0xa008,0xffff,0xffff,0x8848,0xffff,0xcc40,0xffff,0xffff,0x0848,0xffff,0xffff,0x8c48,0x1048,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0x4808,0xe000,0xe840,0xe800,0xffff,0x2c00,0xffff,0xffff,0xf848,0xffff,0xd840,0xd800,
0x3840,0x6048,0xffff,0xffff,0xd400,0xffff,0x8400,0x8440,0x4800,0x1008,0x0808,0x0848,0xffff,0xfc48,0xe400,0xe440,
0x6440,0x6400,0x4400,0xffff,0x1848,0x1808,0x3840,0xffff,0x5440,0xffff,0xf440,0x5c48,0x2848,0x2808,0xffff,0x2008,
0xffff,0xf840,0xffff,0xe000,0x1408,0x1448,0x5448,0x0c40,0xffff,0x9840,0xc848,0xffff,0x7408,0x7448,0x2408,0x7c00,
0x6400,0xcc08,0xffff,0xc440,0x1840,0xffff,0xb808,0xb848,0xd440,0xffff,0xffff,0xf440,0xa800,0xffff,0x8808,0x8848,
0x5808,0x0000,0x0840,0x0800,0xb448,0xffff,0xe448,0xffff,0xffff,0x7040,0x6840,0x6800,0xffff,0x9c00,0x8448,0xffff,
0x3408,0x3448,0x1448,0xffff,0x4800,0x4840,0x6808,0xc000,0xffff,0xffff,0xa408,0x0c00,0x7800,0xffff,0xffff,0x7040,
0x9848,0x9808,0xffff,0xffff,0x7440,0x7400,0x3400,0x6c08,0xffff,0xf808,0xa800,0xffff,0x1440,0x1400,0x4440,0x1c48,
0xe848,0xe808,0xa840,0xf048,0x0440,0xffff,0x4400,0x1c08,0x8848,0x8808,0xd800,0x8008,0x6440,0x6400,0x3440,0x6c48,
0x8408,0x8448,0xa448,0xffff,0xffff,0xf840,0xd808,0x7000,0xb408,0xb448,0xffff,0xbc00,0xffff,0xffff,0x6848,0xffff,
0x2808,0x7000,0x7840,0x7800,0xc448,0x9c40,0x9448,0x9408,0xffff,0xffff,0x1840,0x1800,0xffff,0xec00,0xf448,0xf408,
0xd400,0xffff,0x7400,0x7440,0xa840,0x0048,0xffff,0xffff,0xffff,0xcc48,0x4400,0x4440,0xffff,0xb008,0xffff,0xffff,
0x8800,0x8840,0xc808,0x9000,0xffff,0xffff,0x2448,0xffff,0xe800,0xe840,0xb848,0xffff,0xffff,0x0448,0xffff,0xffff,
0xd440,0xd400,0xffff,0xffff,0xffff,0xa808,0x8840,0xffff,0xe440,0xe400,0xffff,0xec48,0x9848,0x9808,0x3800,0x9008,
0x4840,0x1048,0x1808,0x1848,0xa400,0xffff,0xf400,0xf440,0x3800,0xffff,0x7808,0xffff,0xd440,0x8c48,0x9400,0x9440,
0xffff,0x2c40,0xffff,0x2408,0xf808,0xffff,0xffff,0xffff,0xffff,0x9c00,0x1448,0x1408,0xffff,0xe040,0x6840,0xffff},
{
0x1008,0x6840,0xffff,0xd048,0x0808,0xffff,0x1c00,0xf848,0x1408,0x6c40,0x6c40,0x8808,0x0c08,0x7440,0x4440,0xffff,
0x7440,0xffff,0xac48,0xd800,0x5c40,0xffff,0xb448,0xc000,0x7040,0x9808,0x0408,0x7040,0x5840,0xffff,0x1c08,0xffff,
0x9808,0xec40,0xffff,0xbc48,0xffff,0xf440,0xffff,0x9448,0x3048,0xffff,0x5000,0xffff,0x2848,0x5c00,0xffff,0xffff,
0x0040,0xffff,0xa048,0xd800,0xffff,0xcc08,0xffff,0xffff,0x5800,0xffff,0xffff,0xdc00,0xffff,0x9448,0xbc48,0xc400,
0xa008,0xffff,0x8800,0x6048,0xb808,0xffff,0xa000,0x4848,0x0848,0x7c00,0x8c00,0x6448,0x1048,0x6400,0xa400,0x4c48,
0xffff,0x2c08,0x1c48,0xffff,0xffff,0x0408,0x0448,0x7c00,0x9000,0x7448,0x1848,0x6000,0xb800,0x5c48,0xffff,0x7800,
0xac08,0xffff,0xfc00,0x1848,0xb408,0xffff,0xd400,0x3048,0xa808,0xffff,0xffff,0x4008,0xb008,0xffff,0x8c40,0x6808,
0xffff,0x4008,0x9448,0xe000,0x8040,0x6808,0x8c48,0xffff,0xac40,0x4408,0x3c08,0x4840,0x8440,0x6c08,0xffff,0x5040,
0xa048,0xd800,0xc040,0xffff,0xb848,0xffff,0xffff,0xffff,0xa448,0xffff,0x9800,0xffff,0xbc48,0xc400,0xb000,0xffff,
0x9400,0x7c48,0x9808,0xffff,0xffff,0x5448,0xffff,0xf440,0x9000,0xffff,0xffff,0x4400,0xb800,0x5048,0xffff,0x5c00,
0xac48,0xd800,0xffff,0x5c08,0xb448,0xc000,0x9c40,0x7408,0x0408,0x7040,0xb040,0x5808,0x1c08,0x6840,0x9840,0x7008,
0xf400,0xffff,0x1008,0xffff,0xdc00,0xffff,0xffff,0x7040,0xac40,0xffff,0x1408,0xffff,0x8440,0xffff,0x0c08,0x7440,
0x9448,0xe000,0x6840,0x8008,0x8c48,0xf800,0x4040,0xffff,0x3c08,0xffff,0xffff,0x8408,0x2408,0x5040,0xffff,0xac08,
0x3c00,0xd848,0xffff,0xd440,0xffff,0xf048,0xb408,0xcc40,0x6440,0x8008,0xffff,0xd040,0x4c40,0xa808,0xffff,0xc840,
0x1c48,0x6400,0x0840,0xec08,0x0448,0xffff,0x2040,0xc408,0xffff,0xffff,0x5000,0xffff,0xffff,0xffff,0x7800,0x9c48,
0xffff,0xa048,0xa008,0xffff,0x6000,0xffff,0xb808,0xcc40,0xffff,0xffff,0x0848,0xffff,0xffff,0x8c48,0x1048,0xffff},
{
0x9040,0x3448,0x7848,0x2040,0xe000,0x4808,0xffff,0xcc00,0x3808,0xffff,0xffff,0x9c08,0xffff,0xffff,0xffff,0xec48,
0xf840,0xd848,0xffff,0xc040,0x8400,0xffff,0xffff,0x2000,0xffff,0xffff,0xd400,0x7008,0x2c48,0x7840,0xffff,0x0c48,
0xffff,0x2408,0x2c08,0x6000,0x7440,0x5848,0xcc48,0xffff,0x7848,0x2040,0xffff,0x0848,0x9408,0xc000,0xd000,0x7808,
0xffff,0x4c08,0xcc08,0x9400,0xffff,0x3c48,0x2048,0x7440,0xffff,0xd440,0x4040,0x6048,0xffff,0x3800,0x3000,0x1c08,
0xffff,0x6848,0x1448,0x4c40,0xbc00,0x1408,0xffff,0xa000,0x5408,0x1800,0xffff,0xffff,0xb848,0xffff,0x9c40,0xb048,
0xffff,0x8448,0xe048,0xac40,0xffff,0xffff,0x0c08,0x4c00,0xffff,0xffff,0x8800,0x2c08,0x4048,0x1440,0xffff,0x5048,
0x5800,0xffff,0x4008,0xffff,0x2840,0x0448,0xa048,0xe040,0xffff,0x4c40,0xffff,0x5448,0xffff,0xac00,0x8c00,0x2408,
0xb400,0x1008,0xa008,0xffff,0xffff,0xffff,0x4c48,0xffff,0xffff,0xffff,0x1c40,0x3c48,0x1408,0xffff,0x6c00,0x4008,
0xb000,0xb848,0xa808,0xac40,0xc040,0xc408,0xffff,0x4000,0xb408,0xffff,0x3000,0xbc48,0x5848,0x4400,0xffff,0xcc08,
0x7440,0xf808,0x0048,0xffff,0xffff,0x8848,0xec08,0xf040,0xffff,0x1800,0xffff,0xfc08,0xfc08,0xf440,0x8400,0x8048,
0xffff,0xa808,0xfc48,0xec00,0x5400,0xffff,0xffff,0xffff,0xf448,0xffff,0xffff,0xffff,0xffff,0x1040,0xffff,0xffff,
0xffff,0x6c48,0x4008,0x4440,0xffff,0xffff,0xac48,0xa400,0xffff,0x5840,0xffff,0xec48,0xa848,0xb400,0x1040,0xffff,
0xec00,0xe448,0xc408,0xc040,0xffff,0xffff,0x2448,0x2c00,0xd808,0xc840,0x6c00,0xffff,0x3448,0x2800,0x1040,0xffff,
0x2840,0xa408,0xffff,0xffff,0x5400,0xd448,0xffff,0x9c40,0xffff,0xffff,0xa840,0xffff,0x9008,0x9840,0xd800,0xdc48,
0xffff,0xf408,0x9048,0x8000,0x0800,0x8848,0xffff,0x6c40,0x9848,0x9c00,0xffff,0x7408,0xffff,0x7c40,0x0000,0x0448,
0xffff,0xffff,0x2c08,0x2840,0x4440,0xffff,0xc048,0xc800,0xffff,0x3440,0x3c00,0xb048,0xc448,0xd800,0x4c40,0xcc08},
{
0x7048,0xffff,0x0848,0x4c08,0xb840,0xf000,0xffff,0x8400,0x6448,0x8008,0x1c48,0x6808,0x9c40,0xe400,0x7840,0xffff,
0x5008,0xd448,0x2808,0x3c48,0xdc00,0x5440,0xffff,0x2040,0xffff,0xf048,0xffff,0x1848,0xf800,0x4040,0x1c00,0x3440,
0xffff,0x3048,0xfc08,0xd448,0x2c00,0x0840,0xc400,0x7040,0xffff,0x1448,0xe808,0xf048,0xffff,0x1c40,0xe000,0x6440,
0x2c48,0x5408,0x5848,0xb008,0xffff,0x2800,0xb440,0x5000,0x3848,0x7008,0x4c48,0xffff,0x7840,0x3c00,0xffff,0x4400,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1800,0xffff,0xa408,0xffff,0xffff,0x3848,0xffff,0xa040,0x3c00,0xd840,
0x1448,0x9c08,0x6048,0x7808,0x8040,0xffff,0x6840,0xffff,0x0048,0xb808,0x7448,0x5c08,0xa440,0xffff,0x4c40,0xffff,
0xffff,0xffff,0xb448,0x9008,0xffff,0xffff,0xffff,0xbc00,0xd848,0x5c08,0xa048,0xb408,0x5440,0xdc00,0xb040,0xa800,
0xffff,0xffff,0x9408,0xe048,0x1400,0x6c40,0xf000,0x1840,0xffff,0x2c48,0x8008,0xc448,0x3000,0x7840,0xffff,0x0c40,
0xffff,0x2808,0x8448,0xc008,0x6800,0xd040,0x8c00,0xa440,0xe848,0xffff,0x9048,0xffff,0x4c00,0xc440,0xffff,0xb040,
0xdc08,0x5848,0xa408,0xb048,0xffff,0x7400,0xe840,0xffff,0xc808,0x7c48,0xb008,0x9448,0xffff,0x6000,0xcc40,0xffff,
0xa848,0xe008,0xdc48,0xffff,0xa000,0x8440,0x4800,0xfc40,0xbc48,0xffff,0xc848,0xffff,0xffff,0x9040,0x6c00,0xe840,
0x0c08,0xffff,0x7808,0xffff,0xd040,0xa400,0xffff,0xdc00,0xffff,0xa048,0x6c08,0x4448,0xf440,0xb000,0x1c40,0xc800,
0x9048,0x2808,0xe448,0xcc08,0xffff,0x3840,0x9400,0xffff,0x8448,0x0c08,0xf048,0xe808,0x5800,0xffff,0xb000,0xffff,
0x3408,0x4c48,0x4008,0xa848,0xffff,0xffff,0xe440,0x6000,0x2008,0x6848,0xffff,0xffff,0xffff,0x0c00,0xc040,0xffff,
0xffff,0xffff,0x3848,0x1c08,0xa000,0xe840,0xffff,0x9c40,0x5448,0xd008,0x2c48,0x3808,0x8400,0xfc40,0x6000,0x8840,
0x6008,0xffff,0x1808,0xffff,0xc440,0xffff,0x2040,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5800,0x0440,0x2c00},
{
0x3008,0xffff,0x1c40,0x6408,0x1440,0xfc40,0x0808,0x7040,0x3840,0xd040,0xbc40,0xffff,0x1c08,0xffff,0xffff,0xffff,
0xac48,0xd448,0x7048,0xffff,0xffff,0xffff,0x5400,0xffff,0xffff,0xffff,0x2048,0xc800,0xffff,0xffff,0x0400,0xec48,
0x4048,0xffff,0x1c08,0x6408,0x6400,0xffff,0x0840,0x7040,0x1048,0xf800,0x1440,0xffff,0x3400,0xdc48,0x0008,0xffff,
0x2c40,0x5408,0x1048,0xf848,0x3808,0xffff,0x3400,0xdc00,0xffff,0xf408,0x1800,0xf000,0x9808,0xe040,0x3c48,0xd448,
0x8040,0x6808,0xac40,0xd440,0xa408,0x4c40,0xb808,0xffff,0xffff,0x3808,0xa408,0xffff,0xffff,0x1c40,0xb040,0xffff,
0x1c48,0x6400,0xc000,0x2800,0x0800,0xffff,0xe448,0xffff,0xbc48,0xc400,0xc848,0x2048,0xa800,0xd048,0xec00,0x0400,
0xe040,0xffff,0x2c48,0xffff,0xffff,0x2c08,0x3800,0xffff,0xffff,0x0008,0x8c48,0xf400,0xcc40,0x2440,0xffff,0xffff,
0x1c00,0xffff,0xffff,0x5808,0x0848,0x7048,0x9408,0x7c40,0xffff,0x6c48,0xe040,0xffff,0x0000,0x7800,0xffff,0x2c40,
0xffff,0x3008,0xffff,0x5c48,0xfc40,0x1440,0x3048,0x4800,0xffff,0x3840,0x8400,0xfc48,0xf408,0xffff,0x9048,0xe800,
0xffff,0x6c48,0x8808,0xffff,0xffff,0x7800,0xffff,0x4408,0x1c00,0x6400,0xd808,0xffff,0x0848,0x7048,0xfc40,0xffff,
0xb808,0xffff,0xa408,0xdc08,0x9c40,0x7408,0xb040,0xc840,0xe808,0xffff,0xac40,0xd440,0xcc40,0xffff,0xffff,0xffff,
0xffff,0x6c48,0xf848,0x1048,0xffff,0xffff,0xffff,0xffff,0xb400,0xcc48,0xf000,0xffff,0xffff,0xd800,0xd448,0x3c48,
0xffff,0x9048,0x1440,0xffff,0xffff,0xb400,0x0008,0xffff,0x2800,0xc048,0xffff,0xffff,0x0c48,0xffff,0x0840,0x7040,
0x2408,0x5c40,0x2800,0xc000,0x3040,0xffff,0x0c48,0xe448,0xffff,0xfc40,0xffff,0xc848,0x9040,0xe808,0xffff,0xec00,
0x0840,0xe040,0xffff,0xffff,0x2c08,0xc408,0x0040,0x7808,0x0008,0xe808,0xffff,0xffff,0x2440,0xcc40,0xffff,0xd808,
0xffff,0xdc00,0xffff,0xa048,0xb048,0xc848,0x6c48,0x8400,0xac48,0xd448,0x1800,0xf048,0xb800,0xc000,0x3c48,0xd400},
{
0x4c40,0x5c00,0x3c08,0x2c48,0xfc48,0xec08,0x0c08,0x1c48,0xffff,0xe840,0x2800,0x0840,0xffff,0xffff,0x4800,0x6840,
0xffff,0xb048,0x7008,0x5048,0xf008,0xd048,0xffff,0x2040,0x7400,0xffff,0xffff,0x1408,0xffff,0x5440,0xffff,0xa400,
0xcc00,0xdc40,0x3c40,0x2c00,0xfc00,0xec40,0xffff,0x9c08,0xb808,0x9848,0x4800,0x6840,0xd808,0xf848,0x3808,0x1848,
0xffff,0xd048,0x0000,0x2040,0xffff,0xffff,0x6000,0x4040,0x7448,0xffff,0xffff,0xffff,0xc440,0xd400,0xffff,0xffff,
0x7848,0xffff,0x0848,0x1808,0xffff,0xffff,0xffff,0xffff,0x6c08,0x4c48,0x8c40,0xac00,0x1c00,0x3c40,0xec40,0xcc00,
0x3448,0x1408,0xd400,0xffff,0x5448,0x7408,0xa408,0x8448,0x4040,0x5000,0x3040,0x2000,0x7040,0x6000,0xffff,0xffff,
0xffff,0xe800,0x0848,0xffff,0xffff,0xffff,0xffff,0xa800,0xffff,0xffff,0xffff,0xcc48,0x7c48,0x5c08,0xffff,0xbc40,
0xffff,0x7440,0xa440,0x8400,0x2408,0x0448,0xc440,0xe400,0x4040,0xffff,0xb048,0xa008,0xffff,0xffff,0x8048,0x9008,
0x6840,0x7800,0xbc40,0xac00,0xd848,0xffff,0x8c40,0x9c00,0xffff,0xffff,0xa848,0x8808,0x6c08,0x4c48,0xc848,0xe808,
0xffff,0x3000,0xffff,0x8448,0x7040,0x5000,0xd400,0xf440,0xffff,0xe408,0xffff,0xffff,0xc448,0xd408,0x9040,0x8000,
0x4c48,0x5c08,0xffff,0xffff,0x7c48,0xffff,0xa848,0xb808,0x3840,0x1800,0x9c00,0xbc40,0x5840,0x7800,0xec08,0xcc48,
0xffff,0xffff,0x8048,0xa008,0x5400,0xffff,0xe048,0xffff,0x5048,0x4008,0xffff,0xffff,0xffff,0xf000,0xffff,0xffff,
0xffff,0xffff,0x8800,0x9840,0xec40,0xfc00,0xb800,0xffff,0xb808,0x9848,0x0c08,0x2c48,0xc800,0xe840,0x6c08,0x4c48,
0xb400,0x9440,0x0000,0x2040,0xd400,0xf440,0xffff,0x5048,0xc008,0xd048,0x1440,0x0400,0xf008,0xe048,0xa448,0xb408,
0x7808,0xffff,0xffff,0xffff,0xffff,0x5848,0x9c40,0x8c00,0x9c00,0xbc40,0x3808,0x1848,0xfc00,0xdc40,0xffff,0xffff,
0x8000,0xa040,0x2408,0xffff,0xf008,0xd048,0xffff,0xffff,0x6440,0xffff,0x3000,0x2040,0xd448,0xc408,0x0000,0x1040},
{
0xf840,0xdc00,0x1040,0xa400,0x5c48,0xffff,0x2848,0x0008,0xdc40,0xffff,0xffff,0xb000,0x4848,0xc008,0x3c48,0x2408,
0x8800,0xfc40,0x6000,0x8440,0xf808,0xffff,0x8c08,0x6448,0xffff,0xffff,0xffff,0xffff,0xec08,0xa448,0xffff,0x4048,
0xffff,0x2440,0x8800,0x5040,0xa408,0xffff,0xdc08,0x9848,0x4800,0x3040,0xac00,0x4440,0xb008,0xffff,0xc808,0xbc48,
0x0840,0x8000,0xffff,0xf400,0x8448,0x0008,0xffff,0xe808,0xffff,0xffff,0xc840,0xffff,0x9048,0x2408,0xffff,0xcc08,
0xa400,0x1c40,0x4000,0x6840,0xffff,0xac48,0x6008,0x4448,0x8000,0x0840,0xffff,0x7c40,0x0c08,0x8848,0x7408,0x6048,
0xffff,0xb800,0x2440,0xcc00,0xffff,0xffff,0x4048,0x3408,0xe440,0xac00,0xffff,0xd800,0x2c48,0xffff,0x5448,0x1008,
0x2440,0x6000,0xcc40,0xffff,0x6448,0x2c08,0x1048,0xffff,0x0040,0x7400,0xe840,0x0c00,0x7048,0x0808,0x0448,0xec08,
0x5400,0x4040,0xbc00,0x3840,0xffff,0x4848,0xffff,0xac48,0x7000,0xffff,0xffff,0x2c40,0xffff,0x6c48,0xa008,0x8848,
0x7440,0x5000,0xffff,0xffff,0x7c08,0x3448,0xffff,0xd048,0x5040,0x4400,0xb840,0xffff,0x6808,0x1048,0x1c08,0xf448,
0x0400,0x7040,0xffff,0xffff,0xd848,0x5008,0xac48,0xb408,0xffff,0x6440,0xc800,0xffff,0xcc48,0x7408,0xb848,0x9008,
0xbc40,0xffff,0xffff,0x7000,0xffff,0xfc48,0xffff,0x1448,0x9840,0x1000,0x7c40,0xffff,0x3c08,0xffff,0x4408,0xffff,
0xd800,0xa040,0xffff,0xd440,0xffff,0x8c08,0xffff,0x6408,0xfc00,0xb440,0xffff,0xc040,0xffff,0xffff,0x6448,0x4008,
0x7440,0x3c00,0x9040,0xffff,0x9408,0x2048,0xec08,0xc848,0xffff,0x2800,0xb440,0x5c00,0x8008,0xffff,0xf808,0xec48,
0x1000,0x9840,0xffff,0xec40,0xb448,0xffff,0xcc48,0xffff,0x3400,0xffff,0xd000,0xf840,0xffff,0x7408,0xd848,0x9c08,
0xa840,0xec00,0xffff,0xffff,0xffff,0xfc48,0x3008,0x1848,0x8c40,0xf800,0xffff,0xffff,0x5008,0xd848,0x2408,0x3c48,
0xffff,0xcc40,0x3000,0xffff,0xe048,0x9808,0x9448,0xffff,0xfc00,0xd840,0x1400,0xa040,0xf448,0xbc08,0x8048,0xffff},
{
0x4c40,0x5c00,0x3c08,0x2c48,0xfc48,0xec08,0x0c08,0x1c48,0xffff,0xe840,0x2800,0x0840,0xb808,0x9848,0x4800,0x6840,
0xffff,0xffff,0x7008,0x5048,0xf008,0xd048,0x0000,0x2040,0x7400,0xffff,0x0448,0x1408,0xffff,0x5440,0xb440,0xffff,
0xcc00,0xdc40,0xffff,0x2c00,0xfc00,0xffff,0xffff,0xffff,0xffff,0x9848,0x4800,0x6840,0xd808,0xf848,0x3808,0x1848,
0xf008,0xd048,0x0000,0x2040,0x8000,0xa040,0x6000,0x4040,0x7448,0xffff,0xffff,0x9448,0xc440,0xd400,0xffff,0xffff,
0x7848,0xffff,0x0848,0xffff,0xffff,0xd800,0xffff,0xffff,0x6c08,0x4c48,0x8c40,0xac00,0x1c00,0x3c40,0xec40,0xffff,
0x3448,0x1408,0xd400,0xf440,0x5448,0x7408,0xa408,0x8448,0x4040,0x5000,0x3040,0x2000,0x7040,0x6000,0x8048,0xffff,
0xf840,0xffff,0x0848,0xffff,0xffff,0xd800,0xffff,0xa800,0xffff,0x3c08,0xffff,0xffff,0x7c48,0x5c08,0xffff,0xbc40,
0xffff,0x7440,0xa440,0x8400,0x2408,0x0448,0xc440,0xe400,0x4040,0x5000,0xffff,0xffff,0xffff,0xffff,0x8048,0x9008,
0x6840,0x7800,0xbc40,0xac00,0xd848,0xffff,0x8c40,0x9c00,0xffff,0xffff,0xa848,0x8808,0x6c08,0x4c48,0xc848,0xe808,
0x1040,0xffff,0xa408,0x8448,0x7040,0x5000,0xd400,0xf440,0xffff,0xe408,0xffff,0x3008,0xc448,0xd408,0x9040,0x8000,
0x4c48,0x5c08,0xffff,0xffff,0x7c48,0x6c08,0xa848,0xb808,0x3840,0x1800,0xffff,0xbc40,0x5840,0x7800,0xec08,0xcc48,
0x2408,0xffff,0x8048,0xa008,0x5400,0xffff,0xe048,0xffff,0x5048,0x4008,0x0440,0x1400,0xe040,0xf000,0xffff,0x2400,
0xffff,0xffff,0x8800,0xffff,0xec40,0xfc00,0xb800,0xa840,0xb808,0x9848,0x0c08,0x2c48,0xc800,0xe840,0xffff,0x4c48,
0xb400,0x9440,0x0000,0x2040,0xd400,0xf440,0xffff,0x5048,0xffff,0xd048,0x1440,0x0400,0xf008,0xe048,0xa448,0xb408,
0x7808,0xffff,0x2c48,0xffff,0xffff,0x5848,0x9c40,0x8c00,0x9c00,0xbc40,0x3808,0x1848,0xfc00,0xdc40,0xffff,0x6840,
0x8000,0xa040,0x2408,0x0448,0xf008,0xd048,0x4408,0x6448,0x6440,0xffff,0x3000,0xffff,0xd448,0xc408,0x0000,0x1040},
{
0x8040,0xd448,0xf440,0xffff,0x9408,0xc000,0xe008,0xb448,0x5448,0xf008,0xb048,0x1440,0x7000,0xd440,0xffff,0x3008,
0x9008,0xffff,0xe408,0x1400,0x8440,0x7400,0xf040,0xffff,0xffff,0xffff,0xa000,0x5040,0x6048,0xffff,0xffff,0xffff,
0x9440,0x4040,0xe040,0x3408,0x8008,0x5408,0xf408,0x2040,0x1048,0xffff,0xffff,0x4048,0xffff,0xffff,0xd000,0x6400,
0xffff,0xf440,0xffff,0x8008,0x9040,0xe008,0xe440,0xffff,0x0000,0xe000,0xe400,0x0448,0x2448,0xc448,0xc048,0x2000,
0xc400,0x1000,0xb048,0x6400,0xd048,0x0448,0xa400,0x7048,0xffff,0xa408,0xffff,0x4008,0x3408,0xffff,0xffff,0xffff,
0x7000,0x0048,0x0448,0x7448,0x6448,0x1400,0x1000,0xffff,0x5440,0xb440,0xb008,0x5040,0x7008,0x9008,0x9440,0x7408,
0x5008,0x0400,0x2440,0x7000,0x4440,0x1048,0x3008,0x6448,0x4448,0xffff,0xa000,0xffff,0x6000,0xffff,0x8448,0x2040,
0xffff,0x1448,0x9040,0x6048,0xf040,0x0000,0xffff,0x7400,0xffff,0xffff,0xe400,0xffff,0x2400,0xffff,0xc048,0x3008,
0xffff,0x7c08,0xffff,0x9808,0xfc00,0x5840,0xffff,0xbc40,0xffff,0x5800,0x7840,0xffff,0xffff,0xffff,0x6c08,0xffff,
0x9c48,0x6c40,0x7800,0x8840,0xb800,0x4808,0xffff,0xac08,0xb808,0x4848,0xffff,0xffff,0xac40,0xffff,0xd808,0xffff,
0x8c40,0x3808,0x6808,0xffff,0xa808,0xffff,0x4c40,0xf840,0x9800,0x4c00,0xffff,0x3800,0x8c48,0xffff,0xffff,0x2c48,
0xffff,0x2840,0xffff,0xffff,0xec08,0xffff,0xffff,0xffff,0x2c00,0x5c48,0x5848,0x2848,0xffff,0x4800,0x4c00,0xffff,
0xffff,0xffff,0x6848,0xdc48,0xffff,0x1c48,0xffff,0xf800,0xc840,0x1c40,0xbc40,0xffff,0xdc08,0x0808,0xa808,0x7c40,
0xffff,0x7c00,0x7800,0x9848,0xffff,0xffff,0x5c48,0xbc00,0xd808,0xa840,0xffff,0xdc08,0xcc40,0xbc08,0xb840,0xc840,
0xc848,0xffff,0x2c48,0x8840,0xec00,0x4840,0x0800,0xac08,0xdc40,0x8848,0xa840,0xfc00,0xc808,0x9c00,0xbc08,0xe848,
0xffff,0xffff,0xffff,0xcc40,0xfc48,0x0c40,0x1848,0xe808,0xcc08,0x3c48,0xb808,0x4800,0xd840,0xffff,0xac40,0xffff},
{
0xffff,0xd440,0xc000,0x6040,0x5400,0x2c40,0x2000,0x1c40,0x4040,0xffff,0x2040,0x1c00,0xffff,0x5c00,0xcc40,0x6c00,
0xffff,0xffff,0xffff,0xd000,0x1440,0x3040,0x6040,0x0040,0x5c40,0x1840,0xffff,0xffff,0xf800,0xffff,0x8c00,0x7000,
0xffff,0xe840,0xcc00,0x5c40,0x5800,0xffff,0xffff,0x2040,0x4c40,0x9400,0x2c40,0x2000,0xffff,0x6000,0xc040,0x5000,
0xb000,0x5800,0xd000,0xec00,0xffff,0x0c40,0xffff,0x3c40,0x5040,0x2440,0x3040,0xffff,0xf400,0x7c00,0xffff,0x4c00,
0x3448,0xbc08,0x0448,0xffff,0xffff,0x4808,0x7848,0x2808,0x4408,0x5048,0x7408,0x2448,0xb008,0xa848,0x0408,0xc848,
0x2848,0xffff,0x1848,0xffff,0x7c08,0x5408,0xc808,0x3408,0x5808,0x1008,0x6808,0x6408,0x0048,0xb448,0xb448,0xffff,
0x0848,0xb008,0x3848,0xffff,0xf048,0x4408,0x4448,0x2408,0x7808,0x5c48,0x4808,0x2848,0xffff,0xa448,0x3808,0xffff,
0x1448,0xf048,0x2448,0x8448,0x4008,0x5808,0xffff,0x3808,0x6408,0x1c08,0x5408,0x6808,0x3c48,0xb848,0x8848,0xd848,
0x7800,0xffff,0xffff,0x4440,0x9800,0xffff,0xf800,0xbc40,0xffff,0xffff,0xe040,0xffff,0x7840,0x7400,0x1840,0xc000,
0xffff,0x6840,0xffff,0xffff,0x8400,0xb800,0xffff,0x0c00,0xd400,0x1800,0xa000,0x2800,0x6440,0xc440,0xffff,0x7040,
0x7400,0x4840,0xffff,0x7840,0x9400,0x3440,0xf400,0x8040,0x9840,0x3800,0xec40,0xffff,0x7440,0x4800,0xffff,0xfc00,
0x3440,0x5440,0x4040,0x6440,0x8800,0x8400,0xffff,0xffff,0xd800,0xffff,0xac00,0xffff,0x6840,0xf840,0xffff,0xffff,
0x1048,0x7008,0xa448,0x1008,0xffff,0x9008,0xffff,0xe408,0xffff,0xffff,0xd808,0xf048,0x1c08,0x7c48,0x2c08,0x0848,
0xa008,0xffff,0x1408,0x0c08,0xffff,0xd048,0x4048,0xa448,0xdc48,0xffff,0x6848,0xffff,0x0008,0x3c08,0x3008,0x4808,
0xffff,0xffff,0x9848,0x1c08,0xffff,0x9c08,0x6048,0xe808,0xffff,0xffff,0xe408,0xfc48,0x2008,0x7048,0x1008,0x0448,
0x9c08,0x6008,0x2808,0x0008,0xffff,0xdc48,0x7c48,0xffff,0xe048,0x8048,0xffff,0xffff,0xffff,0x3008,0xffff,0x4408},
{
0xffff,0xe808,0xffff,0xb808,0xf840,0x0848,0xf400,0x5848,0xffff,0xa008,0x1800,0xffff,0xffff,0x4c48,0xf840,0x4008,
0x1c48,0xec40,0xffff,0xffff,0xffff,0x9000,0xcc08,0x9c40,0x3848,0x4c40,0x3408,0xec40,0x4408,0x3c00,0x4848,0xffff,
0xffff,0x7040,0xffff,0xffff,0xfc08,0x0000,0xf048,0xffff,0x2048,0x5440,0xffff,0x5800,0xffff,0x2800,0xf008,0x2440,
0x7400,0x8808,0x2400,0xffff,0xffff,0x6448,0xc440,0xffff,0x3c00,0xd408,0x3040,0xffff,0xd040,0x3448,0xffff,0xffff,
0x3440,0xdc48,0x3800,0x8c48,0xffff,0x3c08,0xd440,0x6c08,0xffff,0x8048,0x2c40,0x8c08,0x9c00,0x6c08,0xffff,0x6048,
0xe808,0x9c00,0x4808,0xffff,0xffff,0xffff,0x3848,0xec00,0x4808,0xb800,0x4448,0x1800,0x3448,0xc840,0x3808,0x6840,
0xffff,0x8400,0xffff,0x2400,0x8c48,0xf440,0x8008,0x5440,0xd408,0x2400,0x7408,0x2840,0xa448,0x5840,0x0448,0x5400,
0x4040,0xffff,0x1040,0xa408,0xa000,0x4408,0xf000,0x4848,0x1c40,0xffff,0x1000,0xb048,0xffff,0x0008,0xfc40,0x5008,
0xb800,0x4408,0xb440,0x1408,0x5440,0xa448,0xffff,0xf448,0xe400,0xffff,0xb400,0xffff,0xffff,0xffff,0x5440,0xec08,
0x8048,0x7040,0x2048,0x7c00,0xf008,0xffff,0x5008,0xffff,0xa448,0xd040,0xa808,0x7040,0xd808,0xa000,0xd448,0xffff,
0xffff,0xec40,0x1008,0x4c40,0x6008,0x9c00,0x6c48,0x3c00,0xbc48,0xc840,0x1c48,0xffff,0xcc08,0xb400,0x6c08,0xb840,
0xd800,0x2408,0x8800,0xffff,0xffff,0xffff,0xffff,0xc408,0xffff,0xffff,0xffff,0x2808,0xffff,0x9848,0xffff,0xc848,
0x9840,0x7048,0xffff,0xffff,0x7400,0x9008,0xffff,0xc008,0xd040,0x2c48,0x8040,0x2008,0x3000,0xc008,0xffff,0xcc48,
0xffff,0x0000,0xd408,0x0c40,0x0448,0xffff,0xa448,0xffff,0xd408,0x2400,0xd848,0x8400,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1c08,0xc840,0x4808,0xb800,0xe808,0xffff,0x3848,0xc440,0xffff,0xc800,
0xec40,0x0448,0xbc40,0x0808,0x0c00,0xe808,0x5c00,0xe448,0xb040,0x4c48,0xbc00,0x1c48,0xffff,0xac08,0xffff,0xfc08},
{
0xffff,0xd400,0xffff,0xffff,0xffff,0xffff,0xe848,0xb448,0x5448,0xf848,0xffff,0x1000,0x7c48,0xffff,0x9800,0xffff,
0xffff,0x6408,0xec48,0x1c40,0x8000,0x7c08,0xf448,0x0440,0x4848,0xffff,0xffff,0x5008,0x6048,0xffff,0xffff,0x7808,
0xffff,0x4c08,0xe040,0x3440,0xffff,0x5408,0xf840,0x2c40,0x1440,0xffff,0xf008,0x4808,0x3c40,0x8840,0xd808,0x6008,
0xffff,0xfc00,0xfc40,0xffff,0xffff,0xffff,0xe440,0xffff,0x0840,0xe048,0xec08,0x0800,0xffff,0xffff,0xc408,0xffff,
0xffff,0xffff,0xb840,0x6c40,0xffff,0x0008,0xa040,0x7440,0xffff,0xa840,0xffff,0x4c08,0xffff,0xffff,0xdc08,0x6408,
0x7000,0x0408,0xffff,0x7040,0x6800,0x1c08,0x1048,0x6840,0x5c48,0xb440,0xb400,0x5008,0x7448,0x9c40,0x9c00,0x7808,
0x5800,0x0800,0x2048,0xffff,0x4000,0x1000,0x3848,0x6448,0xffff,0xffff,0xac00,0x0c00,0x6c48,0xffff,0x8400,0x2400,
0xffff,0x1400,0x9040,0x6048,0xffff,0xffff,0x8840,0x7848,0x0440,0xffff,0xec08,0x1000,0x2c40,0xffff,0xffff,0x3800,
0xffff,0xffff,0xffff,0xffff,0xffff,0x5840,0xffff,0xbc08,0x0008,0x5008,0x7840,0xffff,0xffff,0x4808,0x6040,0x3c40,
0x9c48,0x6c40,0x7400,0x8808,0xb448,0x4440,0x5c00,0xa008,0xffff,0x4c08,0xc848,0xffff,0xa800,0xffff,0xd048,0x2040,
0x8448,0x3048,0x6c00,0xffff,0xac48,0xffff,0x4400,0xffff,0x9800,0x4000,0xe048,0x3448,0x8000,0x5800,0xf848,0x2c48,
0xffff,0x2c48,0xffff,0xc800,0xffff,0x0448,0x0408,0xe000,0x2808,0x5c00,0x5040,0x2848,0xffff,0x4400,0x4840,0xffff,
0x8c48,0x3848,0xffff,0xd000,0xa448,0x1048,0xffff,0xf800,0xcc00,0x1400,0xb848,0xffff,0xffff,0x0c00,0xffff,0x7448,
0x9048,0xffff,0xffff,0x9008,0xb848,0xffff,0xffff,0xffff,0xd000,0xa408,0xffff,0xdc40,0xc800,0xbc08,0xbc48,0xc440,
0xcc40,0xffff,0x2808,0xffff,0xe440,0xffff,0x0008,0xa008,0xdc08,0x8c08,0xa840,0xf440,0xc408,0x9408,0xffff,0xec40,
0xd040,0x2048,0x3408,0xc800,0xf840,0x0848,0x1c08,0xffff,0xc008,0xffff,0xb440,0xffff,0xffff,0x2400,0xac40,0xffff},
{
0x4c00,0xffff,0x5c08,0xe040,0xfc08,0xffff,0xec00,0x9048,0xcc08,0x4008,0xec00,0x5000,0xffff,0x7008,0x8c00,0xffff,
0x0848,0x7448,0x1840,0xffff,0x3848,0x1448,0xffff,0x3440,0x7808,0x0440,0x5800,0x1448,0x0800,0xffff,0xffff,0xa440,
0x1808,0xffff,0xffff,0x2448,0xffff,0x7448,0xb808,0x5440,0x0848,0x1448,0x2840,0x0440,0x6848,0x2448,0x4840,0x3440,
0x5c08,0xb008,0x4c00,0xffff,0x6c08,0xd008,0x7c00,0xf000,0xffff,0x5048,0xffff,0x4040,0xffff,0xe040,0xec00,0xf048,
0xa800,0xd448,0xb808,0xffff,0xffff,0xa440,0x0800,0x8448,0x8c40,0x0040,0xac48,0xffff,0xffff,0xffff,0xcc48,0x2048,
0xffff,0x3400,0x5808,0x1408,0x7800,0x5400,0x6808,0x7408,0x6c08,0xffff,0x4c00,0xffff,0x1c00,0x5048,0x3c08,0x4040,
0xffff,0x1040,0xffff,0x3048,0x4c00,0x6048,0x5c08,0xffff,0x4800,0x5400,0x6808,0x4408,0x2800,0x6400,0x0808,0x7408,
0xffff,0xf040,0xffff,0xffff,0x2c40,0x9040,0x3c48,0xb048,0xa800,0xb448,0x8808,0xffff,0xd808,0xffff,0xffff,0x1448,
0x4800,0x5400,0x5808,0x7408,0x7800,0x3400,0x6808,0x1408,0xffff,0xc400,0x6840,0xffff,0xffff,0x7408,0xffff,0x6400,
0x8c40,0xf008,0xffff,0xd000,0xffff,0x8000,0xffff,0xa008,0xec40,0x0040,0xcc48,0xffff,0x8c40,0xffff,0xac48,0xffff,
0x1c40,0x9040,0x0c48,0xb048,0xffff,0xf040,0xffff,0xd048,0x8c40,0x9008,0xac48,0x8000,0xfc48,0xffff,0xdc40,0x3008,
0xd848,0xffff,0xc840,0xffff,0x6840,0xffff,0x7848,0x6400,0x2800,0x5400,0x0808,0x4408,0x4800,0x6400,0x6808,0x7408,
0x0848,0x1448,0x1840,0xffff,0x3848,0x7448,0x2840,0x5440,0x5c48,0x2000,0xffff,0x3008,0x2c40,0xffff,0xffff,0x8000,
0x6840,0xe408,0xffff,0xffff,0xd848,0x9400,0xc840,0xb408,0xac08,0xffff,0xffff,0xffff,0xcc08,0xffff,0xec00,0xffff,
0x5c08,0xd008,0xffff,0xf000,0xffff,0xb008,0xffff,0x9000,0x9840,0xffff,0xb848,0xffff,0xe848,0xc400,0xc840,0xd408,
0x3c48,0x2000,0x2c40,0xffff,0x8c40,0x5008,0x9c48,0xffff,0x6848,0x1448,0xffff,0x0440,0xffff,0x2448,0x2840,0x3440},
{
0x6c48,0x8000,0x1400,0x6848,0x9c00,0xe000,0x7400,0x9800,0x7400,0xffff,0x0c48,0x4000,0xffff,0xffff,0x5c48,0xffff,
0x4448,0xf800,0x3c00,0x1048,0xffff,0xffff,0x1c40,0x3040,0x5c00,0xd048,0x2448,0x3800,0xffff,0x5008,0x3408,0xffff,
0x9440,0x1840,0xec40,0xf040,0x0440,0x1808,0xec08,0xffff,0xffff,0xffff,0xf408,0xd808,0x2c08,0x0040,0xc440,0x7808,
0x3c00,0x7000,0x4400,0x9800,0x7c40,0x3008,0xffff,0x4840,0xffff,0x5848,0x5c48,0xffff,0x5408,0xffff,0xbc40,0xffff,
0xa448,0xd848,0xffff,0x3048,0xd408,0xa840,0x3c40,0xffff,0xffff,0xffff,0xffff,0x1800,0xfc40,0xb008,0xffff,0xffff,
0x0c08,0xb008,0xffff,0x5808,0xac08,0xffff,0x4440,0xffff,0x1440,0x9840,0x6c40,0x7040,0x8440,0x9808,0x6c08,0xe040,
0xffff,0x5048,0xa448,0xb800,0x5c08,0xd008,0xb408,0xffff,0xffff,0x7800,0xffff,0x9048,0x7440,0xffff,0x9c40,0xb040,
0xf400,0xffff,0x8c48,0xc000,0x3448,0x7848,0xdc48,0x0048,0xffff,0x0000,0x9400,0xe848,0x1c00,0xffff,0xffff,0x1800,
0xffff,0x0048,0x9448,0xe800,0x4400,0xc800,0xffff,0xb000,0xffff,0xffff,0x8c00,0xc048,0x6c48,0xffff,0x8448,0xa848,
0xffff,0x7848,0xbc48,0x9000,0xffff,0x6040,0xc440,0xffff,0xdc48,0x5000,0xa400,0xb848,0xffff,0x7808,0xec08,0x0008,
0xbc40,0xc040,0xc440,0xffff,0x8408,0x9840,0x6c40,0xe008,0xa408,0xe808,0xdc08,0x0008,0xac40,0x8008,0x4408,0xf840,
0xffff,0xa800,0xffff,0xffff,0xfc08,0xb040,0xffff,0xc808,0xffff,0x8048,0xffff,0x6848,0xd440,0xa808,0x3c08,0xd040,
0x8c48,0x0048,0xf448,0xe848,0x5440,0x2808,0xffff,0x5040,0xffff,0x2800,0xec00,0xc000,0x7c08,0x3040,0xffff,0x4808,
0x2408,0x6808,0xffff,0x8008,0x2c40,0x0008,0xc408,0xffff,0x3c40,0x4040,0xffff,0xa840,0x0408,0x1840,0xec40,0xffff,
0xffff,0xd000,0x2400,0x3848,0x8408,0xf808,0xffff,0x8008,0xffff,0xf848,0xffff,0x1000,0xac40,0xe040,0xffff,0x9840,
0xffff,0xa800,0x0c00,0x4048,0xec48,0xffff,0xffff,0x2848,0xffff,0x8048,0x1448,0x6800,0xc400,0x4800,0x2c00,0x3000}
};

unsigned short aurail_decrypt_opcode2[16][256]={
{
0x3040,0xd408,0xffff,0x6840,0x1408,0xffff,0x0808,0xffff,0x3808,0xffff,0xffff,0xffff,0x1c40,0xf808,0xffff,0xffff,
0xac48,0xffff,0x7000,0xffff,0xb800,0xffff,0x5448,0xffff,0xffff,0xffff,0x2c00,0xc800,0xffff,0xc400,0x0848,0xffff,
0x4048,0xffff,0x1c08,0x6840,0x6400,0xffff,0x0840,0xffff,0xffff,0xf848,0xffff,0x6008,0x3800,0xdc00,0xffff,0xffff,
0x2c08,0x5808,0xffff,0xf448,0x3840,0xffff,0x3448,0xd000,0xffff,0xf408,0x1848,0xfc00,0xffff,0xe040,0x3c00,0xd848,
0x8008,0xffff,0xac40,0xffff,0xffff,0x4040,0xb808,0xffff,0xdc08,0x3808,0xffff,0xffff,0xffff,0x1c40,0xb040,0xffff,
0x1c48,0x6848,0xffff,0xffff,0xffff,0xffff,0xe400,0x0048,0xb048,0xc448,0xc800,0xffff,0xa400,0xffff,0xec48,0xffff,
0xffff,0x0440,0x2c00,0x5800,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c08,0x8000,0xf400,0xffff,0x2840,0x9448,0xe048,
0xffff,0x6848,0xffff,0xffff,0xffff,0x7c00,0x9408,0x7008,0xffff,0xffff,0xffff,0x0840,0x0000,0x7448,0xc808,0x2c08,
0xffff,0xffff,0xffff,0xffff,0xffff,0x1440,0xffff,0x4800,0xdc08,0x3840,0x8448,0xffff,0xffff,0x1c08,0x9000,0xffff,
0x1848,0xffff,0x8408,0x6008,0xffff,0x7848,0xa040,0x4440,0xffff,0xffff,0xd808,0xffff,0x0448,0xffff,0xfc40,0xffff,
0xffff,0x5040,0xa808,0xffff,0xffff,0xffff,0xffff,0xffff,0xe840,0xffff,0xa040,0xffff,0xcc08,0xffff,0xb408,0xffff,
0xffff,0xffff,0xf400,0xffff,0xffff,0xffff,0xd048,0xffff,0xb400,0xffff,0xffff,0xffff,0xa048,0xffff,0xd800,0xffff,
0x7400,0x9000,0xffff,0xffff,0xffff,0xffff,0x0c08,0xffff,0x2800,0xcc00,0x1008,0xffff,0x0c48,0xffff,0x0440,0x7008,
0xffff,0x5c40,0x2448,0xc000,0x3c08,0x4808,0xffff,0xe448,0xffff,0xf040,0xffff,0xffff,0x9008,0xffff,0xffff,0xec00,
0xffff,0xe040,0xffff,0x6c08,0x2040,0xc408,0x0c40,0x7840,0x0c40,0xe808,0xffff,0xffff,0xffff,0xcc40,0xffff,0xd440,
0xffff,0xffff,0xffff,0xa048,0xffff,0xc800,0x6000,0x8400,0xffff,0xd400,0x1848,0xfc48,0xb400,0xffff,0x3c00,0xffff},
{
0xffff,0xffff,0xffff,0xffff,0xd448,0xffff,0xffff,0xa048,0x4040,0xffff,0x4048,0xffff,0xc848,0xe808,0xc840,0xe800,
0xffff,0xffff,0x8800,0xffff,0xffff,0xffff,0xffff,0x4048,0x8448,0xffff,0x2008,0xffff,0x6c08,0x4c48,0xffff,0x1808,
0xffff,0xd408,0xffff,0xd400,0xec40,0xfc00,0xec48,0xffff,0xf840,0xffff,0xffff,0xffff,0xe000,0xf040,0x4440,0xffff,
0x4000,0x6040,0xffff,0xffff,0xa840,0xb800,0x0c00,0xffff,0x5c00,0x7c40,0x5c08,0xffff,0x2408,0x3448,0x2400,0x3440,
0xffff,0xffff,0xffff,0xffff,0x7040,0x5000,0x2400,0x0440,0xffff,0xffff,0x7408,0x6448,0xffff,0x4c48,0xffff,0x4c40,
0xffff,0xffff,0xbc40,0xac00,0xffff,0xe400,0xffff,0xe408,0xb040,0xa000,0x1400,0xffff,0xffff,0xffff,0x9c40,0xbc00,
0x5008,0x7048,0x5000,0x7040,0xd800,0xffff,0xffff,0xffff,0x5c48,0x7c08,0x0808,0x2848,0xd408,0xffff,0x7048,0x6008,
0xe408,0xffff,0xffff,0x9008,0x9c48,0xffff,0xffff,0xffff,0xf840,0xffff,0xffff,0xffff,0xffff,0x0008,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c08,0xffff,0x0c00,
0xffff,0x2c48,0x3c00,0x2c40,0x8400,0xa440,0x8408,0xa448,0xffff,0xa000,0xffff,0x0440,0x9800,0xffff,0xcc40,0xec00,
0x1048,0xffff,0xffff,0xffff,0xffff,0x4800,0xffff,0x4808,0xffff,0xffff,0x5808,0xffff,0xffff,0xffff,0x7048,0xffff,
0xffff,0xffff,0xe048,0xc008,0xffff,0x8c08,0xffff,0xffff,0xb800,0x9840,0xb808,0x9848,0x9008,0xffff,0xffff,0x8040,
0xcc08,0xdc48,0xffff,0xffff,0x8448,0xa408,0xffff,0xf048,0xc000,0xd040,0xc008,0xffff,0xffff,0xa848,0x8800,0xa840,
0x0848,0x1808,0xffff,0x1800,0x2040,0xffff,0x2048,0xffff,0xffff,0xffff,0xffff,0x3048,0x3c08,0xffff,0xffff,0xffff,
0xb408,0xffff,0xb400,0xffff,0xffff,0x7c40,0xffff,0xffff,0xa840,0x8800,0xffff,0xdc40,0xe000,0xffff,0xffff,0xffff,
0x1000,0xffff,0xffff,0xffff,0xffff,0xb800,0x0c00,0xffff,0x1c40,0x3c00,0xffff,0x3c08,0xffff,0xb408,0xa440,0xb400},
{
0xffff,0xffff,0xffff,0x0400,0xf408,0xffff,0xb840,0xe808,0xffff,0x5c08,0xa048,0xffff,0xf040,0xffff,0xdc40,0xffff,
0xffff,0xffff,0xa440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0048,0x5000,0xbc00,0x1c00,
0x1008,0x3000,0x0c40,0xffff,0x6c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xb848,0x1800,0xffff,0xe808,0xffff,0x6440,
0xf040,0x5008,0xffff,0xffff,0xffff,0x2c48,0x0048,0x5000,0xffff,0xf408,0xffff,0x7808,0x5808,0xffff,0x2440,0x0400,
0xd800,0x7848,0x3448,0xffff,0xa440,0x0440,0xffff,0xffff,0x7c00,0xffff,0xffff,0xffff,0xffff,0xd000,0x8c08,0xffff,
0xb808,0xffff,0xffff,0x8448,0xc400,0xe440,0xffff,0xffff,0x8c40,0xffff,0x9008,0x3040,0xffff,0xffff,0xffff,0x4c48,
0x4040,0x6048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6400,0xffff,0x4848,0xffff,0x8840,0xffff,0xffff,
0xa008,0xffff,0x8c08,0xffff,0xffff,0x7c00,0xffff,0x3048,0xffff,0x9440,0x0848,0x2840,0x3840,0x7848,0x7408,0xffff,
0xa048,0xa848,0x8c00,0x8448,0xffff,0xd440,0x6040,0x6840,0x9c00,0x8408,0xffff,0xa840,0xffff,0x6848,0x5c08,0xffff,
0x6808,0xe048,0xffff,0xffff,0x1400,0x9c08,0xc800,0xffff,0xffff,0xffff,0xe840,0xffff,0xffff,0xd048,0x9400,0x9c48,
0xffff,0xffff,0xffff,0xffff,0x4448,0xffff,0x3800,0xffff,0xd400,0xffff,0x3800,0xffff,0xffff,0xffff,0x4408,0xffff,
0xffff,0x7808,0x6c08,0xffff,0xffff,0x0448,0xffff,0x8800,0xffff,0xffff,0xffff,0xf840,0x8008,0xffff,0xffff,0x8448,
0xf000,0xf800,0xec48,0xffff,0x8c40,0x8408,0x0008,0xffff,0xfc48,0xffff,0x7048,0xf808,0xffff,0x0800,0x0c40,0x8448,
0xffff,0xb000,0x4440,0xffff,0x4448,0xcc40,0xffff,0xb008,0x5440,0xffff,0xb808,0xffff,0xb800,0xffff,0xffff,0xcc00,
0xffff,0xe000,0xb408,0xffff,0xffff,0xffff,0x5848,0x4008,0xffff,0xbc00,0xffff,0xffff,0xffff,0xffff,0x1440,0x1c08,
0x2040,0x2840,0x0c40,0x0408,0xffff,0xffff,0xe048,0xffff,0x0c00,0x1408,0x2048,0xa808,0xffff,0xf800,0x5c08,0xffff},
{
0xffff,0xffff,0xd040,0xf000,0xffff,0xffff,0xffff,0xffff,0x9800,0xb840,0xffff,0xffff,0xffff,0xffff,0xe000,0xffff,
0x3048,0x1008,0x3040,0x1000,0xffff,0x3800,0x2848,0xffff,0xffff,0xffff,0xffff,0x4840,0x2400,0x3440,0x8040,0xffff,
0xffff,0xffff,0x4c00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8848,0xffff,0xdc08,
0xffff,0xffff,0xac48,0xbc08,0xffff,0x3008,0x4408,0x6448,0x8440,0xffff,0x8448,0xffff,0x0c48,0x2c08,0x0c40,0xffff,
0x2008,0x0048,0x7448,0xffff,0xffff,0x4808,0xffff,0xffff,0x3c40,0x1c00,0x3c48,0xffff,0xffff,0xffff,0xffff,0xc400,
0x9408,0xb448,0xffff,0xb440,0xffff,0xffff,0x1c08,0xffff,0x9848,0xb808,0xffff,0xffff,0x1008,0xffff,0xb448,0xffff,
0x7848,0x6808,0xffff,0x6800,0xffff,0xffff,0x0048,0x2008,0xffff,0x6400,0xd000,0xffff,0x0c00,0x2c40,0x5840,0x7800,
0xffff,0xffff,0x9840,0x8800,0xb440,0x9400,0xe000,0xffff,0xffff,0xa040,0xb008,0xffff,0xffff,0x8848,0xa800,0x8840,
0xffff,0x5048,0x2448,0xffff,0x5848,0x4808,0xffff,0xec48,0x7c00,0xffff,0xffff,0xffff,0x5408,0x4448,0xffff,0x4440,
0xd448,0xf408,0xffff,0xf400,0x9c40,0xffff,0x9c48,0x8c08,0xffff,0xe808,0x9c08,0xffff,0xffff,0x0048,0xffff,0xa408,
0xffff,0xe848,0xf800,0xe840,0x4000,0x6040,0x4008,0x6048,0xffff,0x6400,0xffff,0xc040,0xffff,0x7c40,0xffff,0xffff,
0xffff,0xffff,0xffff,0x8800,0xffff,0xc400,0xb000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xd400,0xf440,0x8040,0xa000,0xffff,0xffff,0xc800,0xffff,0xd840,0xf800,0xd848,0xf808,0xffff,0x7008,0xffff,0x7000,
0xffff,0xffff,0x7000,0xffff,0xa800,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1840,0xffff,0x3440,0xffff,0x9000,
0xffff,0xffff,0xcc40,0xdc00,0xe440,0xffff,0xe448,0xffff,0xffff,0xffff,0xe408,0xffff,0xf808,0xffff,0xac48,0xffff,
0xffff,0xffff,0xffff,0xbc08,0x4048,0xffff,0x1408,0xffff,0x0400,0xffff,0x0408,0x1448,0xffff,0x6c48,0x4c00,0x6c40},
{
0xc040,0x8c40,0x3048,0xffff,0xffff,0x6448,0x2840,0xffff,0x6800,0xc408,0x1848,0xffff,0xffff,0x4c48,0xffff,0x3c00,
0xffff,0xffff,0xffff,0xffff,0xffff,0x6400,0x1808,0xffff,0xffff,0xffff,0x1800,0x1440,0xffff,0x4c00,0xffff,0x3c48,
0xffff,0xffff,0xffff,0x5c48,0xffff,0xec48,0x5040,0xb408,0xffff,0xffff,0x3800,0xffff,0xffff,0x6c00,0xffff,0xffff,
0xe040,0xffff,0xffff,0xffff,0xc800,0xec00,0x6008,0xffff,0xe048,0xd408,0x3848,0xffff,0xc840,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x9c08,0xffff,0xffff,0xffff,0xec08,0xffff,0xffff,0xb848,0xffff,0x4808,0xffff,
0xffff,0xffff,0xffff,0x6448,0xffff,0xffff,0x2048,0xffff,0x9008,0xffff,0x6000,0xffff,0x8800,0x3400,0xffff,0xc408,
0xffff,0xffff,0x4008,0xffff,0xffff,0x1408,0xffff,0xffff,0x1840,0xffff,0xffff,0x6448,0xffff,0xffff,0x6840,0xffff,
0x9840,0xffff,0x4040,0xffff,0xffff,0xffff,0x5848,0xffff,0x1808,0xffff,0x4048,0xffff,0xffff,0xffff,0xffff,0x4c08,
0xffff,0xe400,0xffff,0xffff,0xb008,0x9c08,0xffff,0xffff,0x9040,0xffff,0xffff,0x4c48,0xe848,0xb440,0xffff,0xc440,
0xffff,0xd448,0xffff,0xffff,0xffff,0x9c40,0x7048,0x6c00,0x9008,0x9c48,0xffff,0x7c00,0xd800,0xffff,0xffff,0xffff,
0x1800,0x9c00,0x4008,0xffff,0x9040,0xffff,0x3800,0x4c00,0xffff,0xffff,0xffff,0x3448,0x9048,0xffff,0xffff,0x4c40,
0xffff,0xffff,0x4040,0xffff,0xa008,0x1440,0x0848,0xffff,0xffff,0xbc00,0xffff,0xffff,0xa000,0x9440,0xffff,0x4c08,
0xffff,0xffff,0xffff,0x3c08,0xffff,0xffff,0x7840,0xffff,0xffff,0x8400,0x9840,0x7408,0xd008,0xcc40,0xffff,0x3c00,
0x4000,0xffff,0xffff,0xffff,0xffff,0x6400,0xffff,0xffff,0x6848,0xb448,0x9808,0x4440,0xffff,0xcc08,0xffff,0x3c48,
0xffff,0xa440,0xffff,0xffff,0xffff,0xec48,0xffff,0x3400,0xe000,0xa448,0xffff,0x0c08,0xffff,0xec08,0xffff,0xffff,
0x6048,0x9408,0xb800,0xffff,0xffff,0xffff,0x3008,0x3448,0xe048,0xffff,0xb840,0xffff,0x9840,0xec40,0xffff,0xb448},
{
0xffff,0xec48,0xffff,0xf008,0xe400,0xffff,0xc840,0x4c00,0xffff,0x9c08,0xffff,0xffff,0xd040,0xffff,0xcc00,0xd440,
0xffff,0xa040,0xffff,0xffff,0xffff,0xffff,0xffff,0x8808,0xa840,0x2c00,0xb400,0xffff,0x1448,0xffff,0x0808,0x7c48,
0x5000,0xffff,0xffff,0xffff,0x2c08,0xffff,0xffff,0x1408,0xffff,0x5800,0xffff,0xffff,0xffff,0x3c08,0xffff,0xffff,
0xffff,0xf448,0xffff,0xffff,0x8800,0xffff,0xffff,0xdc00,0xffff,0xffff,0xffff,0xffff,0xffff,0x9800,0xffff,0xb440,
0xffff,0xffff,0xffff,0x1000,0xffff,0xb048,0xd848,0xac08,0xa848,0xffff,0xffff,0xffff,0x9c40,0xffff,0xffff,0xffff,
0x6400,0xffff,0x4840,0xffff,0xffff,0xd848,0xffff,0xc408,0xffff,0x3c08,0xffff,0x1048,0xffff,0x4000,0xffff,0x6c40,
0xffff,0xffff,0x6c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3840,0xffff,0xffff,0xd408,0x5c48,
0xffff,0xffff,0x8c48,0xffff,0xffff,0x8c40,0xffff,0x9000,0xffff,0xf400,0xffff,0xd840,0xac48,0x8808,0xffff,0xa448,
0x0400,0xffff,0x2840,0xffff,0x6008,0xffff,0x4c48,0xc408,0x6c40,0xffff,0x7000,0xffff,0xffff,0x6408,0xcc08,0x4848,
0xac08,0x2848,0x8048,0x3408,0xd000,0x9440,0xffff,0x8800,0xa848,0xffff,0xffff,0x9c48,0x9c40,0xd400,0x8000,0xf840,
0xc008,0xb848,0xec48,0xa408,0xa400,0xffff,0x8840,0x9000,0xffff,0xffff,0xffff,0xffff,0xffff,0xac00,0x9400,0x8040,
0xffff,0x7040,0xffff,0x6c00,0xffff,0xffff,0xffff,0xd008,0xfc40,0xffff,0xffff,0x5840,0xffff,0xffff,0xffff,0xffff,
0xffff,0xa040,0x6440,0xffff,0xffff,0x9448,0x0048,0x8808,0xffff,0x0808,0xffff,0xffff,0x3040,0x7400,0xffff,0x5840,
0xffff,0xc840,0x9040,0xd400,0xc008,0xffff,0xec48,0x6808,0xe448,0xffff,0xf808,0xd048,0xffff,0xffff,0xcc00,0xffff,
0xffff,0xffff,0xa048,0xe808,0xe800,0xffff,0xc440,0xdc00,0xffff,0xffff,0xffff,0xec40,0xffff,0xbc08,0x7408,0x9048,
0xffff,0x9048,0xffff,0xffff,0xffff,0x2c40,0x2440,0x3000,0xb040,0xffff,0xffff,0xffff,0xffff,0xffff,0x9808,0xffff},
{
0xffff,0xffff,0xec00,0xffff,0x7800,0x3040,0x0c00,0x0040,0x6c40,0xb400,0x0c40,0x0000,0xffff,0x4000,0xe040,0xffff,
0xffff,0x7800,0xf000,0xcc00,0xffff,0x2c40,0xffff,0x1c40,0xffff,0xffff,0x1040,0xb040,0xd400,0x5c00,0xffff,0xffff,
0xffff,0xffff,0xe000,0x4040,0x7400,0xffff,0xffff,0xffff,0x6040,0xffff,0xffff,0xffff,0x9840,0x7c00,0xec40,0xffff,
0xffff,0xffff,0xffff,0xffff,0x3440,0xffff,0x4040,0x2040,0x7c40,0x3840,0xffff,0xffff,0xd800,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x6408,0xffff,0x0408,0x5808,0x7c48,0x6808,0x0848,0xffff,0xffff,0xffff,0xffff,
0x3448,0xffff,0xffff,0xffff,0x6008,0x7808,0xffff,0x1808,0xffff,0x3c08,0xffff,0xffff,0x1c48,0x9848,0xa848,0xffff,
0xffff,0xffff,0xffff,0xe808,0xffff,0x6808,0x5848,0xffff,0x6408,0x7048,0x5408,0xffff,0xffff,0x8848,0x2408,0xffff,
0xffff,0xffff,0x3848,0xa848,0xffff,0x7408,0xffff,0xffff,0x7808,0x3008,0x4808,0x4408,0xffff,0x9448,0x9448,0xffff,
0x5400,0x6840,0xffff,0x5840,0xb400,0x1440,0xd400,0xffff,0xb840,0x1800,0xffff,0xffff,0x5440,0xffff,0xffff,0xdc00,
0x1440,0x7440,0x6040,0xffff,0xffff,0xa400,0xffff,0xffff,0xf800,0x0400,0xffff,0xffff,0x4840,0xffff,0x2840,0xffff,
0x5800,0x5440,0x2c00,0x6440,0xb800,0xffff,0xffff,0x9c40,0xb440,0xffff,0xc040,0x1400,0xffff,0xffff,0xffff,0xffff,
0x1840,0xffff,0xffff,0xffff,0xa400,0x9800,0xc400,0xffff,0xffff,0xffff,0x8000,0x0800,0x4440,0xffff,0xffff,0x5040,
0xffff,0xffff,0xffff,0xffff,0x7048,0xffff,0xffff,0xffff,0xffff,0xffff,0xc408,0xffff,0x0008,0x5048,0x3008,0x2448,
0xffff,0xffff,0x0808,0xffff,0xffff,0xffff,0xffff,0xffff,0xc048,0xffff,0xffff,0xffff,0x1c08,0xffff,0xffff,0xffff,
0x3048,0x5008,0x8448,0x3008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf808,0xd048,0x3c08,0x5c48,0x0c08,0x2848,
0x8008,0x4c08,0x3408,0x2c08,0xffff,0xf048,0xffff,0x8448,0xfc48,0xffff,0xffff,0xcc48,0xffff,0x1c08,0xffff,0xffff},
{
0x1400,0xe808,0xffff,0xffff,0xffff,0x0848,0xffff,0xffff,0x4800,0xffff,0x1800,0xac48,0xa840,0x4c48,0xffff,0x4008,
0x1c48,0xec40,0xbc48,0xffff,0xffff,0xffff,0xcc08,0x9c40,0x3848,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0x7040,0xffff,0xffff,0xfc08,0xffff,0xffff,0xffff,0x2048,0xffff,0xffff,0x5800,0xffff,0x2800,0xf008,0x2440,
0x7400,0xffff,0xffff,0xffff,0x9440,0x6448,0xffff,0xffff,0x3c00,0xffff,0x3040,0x8408,0xffff,0x3448,0xffff,0xffff,
0x3440,0xdc48,0xffff,0xffff,0xd800,0x3c08,0xd440,0xffff,0x7c40,0x8048,0x2c40,0x8c08,0xffff,0x6c08,0xffff,0x6048,
0xffff,0xffff,0x4808,0xffff,0x9848,0xffff,0xffff,0xffff,0x4808,0xb800,0x4448,0x1800,0xffff,0xc840,0x3808,0xffff,
0xffff,0x8400,0xfc48,0xffff,0x8c48,0xf440,0xffff,0x5440,0xd408,0x2400,0xffff,0x2840,0xa448,0x5840,0x0448,0x5400,
0x4040,0xa848,0x1040,0xa408,0xa000,0x4408,0xffff,0xffff,0x1c40,0xffff,0xffff,0xffff,0xffff,0x0008,0xffff,0xffff,
0xffff,0x4408,0xb440,0xffff,0x5440,0xffff,0xffff,0xf448,0xffff,0xffff,0xffff,0xffff,0x0440,0xffff,0x5440,0xec08,
0x8048,0x7040,0x2048,0x7c00,0xf008,0xffff,0x5008,0x0040,0xa448,0xd040,0xa808,0xffff,0xd808,0xa000,0xd448,0xffff,
0x1c48,0xec40,0x1008,0x4c40,0xffff,0x9c00,0x6c48,0x3c00,0xbc48,0xffff,0xffff,0xffff,0xcc08,0xffff,0xffff,0xb840,
0xffff,0xffff,0x8800,0x2848,0xffff,0xffff,0xffff,0xc408,0xffff,0x7808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0x9008,0x7840,0xc008,0xd040,0x2c48,0x8040,0xffff,0x3000,0xc008,0xffff,0xcc48,
0xffff,0x0000,0xffff,0xffff,0x0448,0xffff,0xa448,0xffff,0xd408,0x2400,0xd848,0xffff,0xffff,0xffff,0xffff,0xf440,
0xffff,0xffff,0xffff,0xffff,0x1048,0xffff,0xffff,0xc840,0xffff,0xb800,0xe808,0xffff,0xffff,0xffff,0xffff,0xffff,
0xec40,0x0448,0xffff,0xffff,0x0c00,0xe808,0x5c00,0xe448,0xb040,0x4c48,0xbc00,0xffff,0xffff,0xac08,0xffff,0xfc08},
{
0x0848,0x7000,0x4840,0x2048,0xffff,0x9440,0xffff,0xd448,0xffff,0x5848,0xffff,0x0800,0xffff,0xffff,0xffff,0xffff,
0xffff,0x8840,0xffff,0xd840,0x0440,0xffff,0x5440,0x2c08,0xffff,0xffff,0xffff,0xffff,0x2c08,0xffff,0xffff,0xffff,
0xffff,0x9c48,0xffff,0xbc08,0xffff,0xe840,0x7048,0xffff,0xffff,0x8400,0x1c08,0xffff,0x4840,0xf008,0x6800,0xffff,
0xffff,0xf440,0xffff,0xffff,0x3848,0xffff,0x1840,0xffff,0xd400,0xffff,0x7448,0xffff,0xffff,0xffff,0x0008,0x3800,
0x1048,0xffff,0x0808,0x6000,0xffff,0xffff,0xffff,0xffff,0x3800,0x4048,0x2040,0x4848,0x9448,0xfc40,0x9c48,0xffff,
0xffff,0x9040,0xffff,0xffff,0x4408,0xffff,0xffff,0x3408,0xc040,0xffff,0xffff,0xb040,0x6c40,0xffff,0x6408,0x1c40,
0xffff,0xffff,0xffff,0xffff,0xffff,0x0040,0xffff,0xffff,0xffff,0xc448,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x8c00,0xb408,0xffff,0xffff,0xffff,0x6800,0xffff,0xffff,0x9448,0xac40,0xffff,0xffff,0xffff,0xffff,0xffff,0x7848,
0xffff,0xffff,0x8400,0xbc08,0xffff,0xffff,0xffff,0xffff,0xbc08,0xffff,0x9c48,0xa440,0x4840,0x7048,0xe840,0xffff,
0xffff,0x7448,0xffff,0xffff,0xffff,0xffff,0x9848,0xffff,0xd448,0x6c00,0xffff,0xffff,0x2048,0xffff,0xffff,0xffff,
0xf800,0xffff,0xa848,0xd000,0xffff,0xffff,0x4c08,0xffff,0xffff,0xb840,0xffff,0xf848,0xffff,0xffff,0xffff,0xffff,
0x0008,0x6800,0xffff,0xffff,0xf440,0xffff,0xb400,0xffff,0xffff,0x4048,0xffff,0x0008,0xdc08,0xa440,0xffff,0xf440,
0xffff,0xffff,0xffff,0xfc40,0xffff,0xffff,0xffff,0xa040,0x5408,0xffff,0xffff,0xffff,0x0808,0xffff,0xffff,0xffff,
0x2400,0x9c48,0xac40,0xffff,0xffff,0xffff,0xffff,0xc800,0x3c48,0xffff,0xffff,0xffff,0x6000,0xffff,0xffff,0xd048,
0xffff,0xd040,0xb048,0xffff,0xffff,0xffff,0x0c40,0xffff,0xffff,0xf808,0x9800,0xe048,0x3c48,0xffff,0xffff,0xffff,
0x4040,0xffff,0xffff,0x3040,0xec40,0x9408,0xf448,0x9c40,0xffff,0xffff,0x6040,0xffff,0xc408,0xbc40,0xffff,0xffff},
{
0x2008,0xffff,0xffff,0x8840,0xffff,0xffff,0xf808,0xffff,0x9c48,0xffff,0xffff,0xb000,0xec08,0x4c40,0xffff,0xcc40,
0x1840,0xffff,0xffff,0xffff,0xffff,0xffff,0xac40,0xa048,0x6400,0xffff,0x2840,0xffff,0x8440,0xd408,0xffff,0xffff,
0xffff,0x7400,0x5848,0xf800,0x0448,0xffff,0x2808,0xffff,0xffff,0x4c40,0xe408,0xffff,0x3c08,0xffff,0x9448,0x3400,
0xffff,0xffff,0x9000,0xffff,0x3000,0x3c08,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5840,0xffff,0x0c00,0x5c48,
0x7c08,0xffff,0xffff,0xffff,0xffff,0xac00,0xffff,0xffff,0xc048,0xffff,0xe008,0xec00,0xffff,0xffff,0xffff,0xffff,
0xffff,0x2408,0xffff,0x2008,0xffff,0xc448,0xffff,0xffff,0x0800,0x5848,0xffff,0x4848,0xffff,0xffff,0xffff,0xa408,
0xffff,0x2800,0x0448,0xa400,0x5848,0x5440,0xffff,0xd440,0xffff,0xffff,0xb808,0x1840,0x6008,0x6c00,0xffff,0x6800,
0xb040,0xffff,0xffff,0xac48,0x5c00,0xffff,0xffff,0x4c08,0xffff,0xffff,0x8040,0xd008,0x3440,0x3848,0x6000,0xffff,
0xc040,0xcc48,0x8c00,0xffff,0xffff,0x2008,0x6c40,0x3c08,0xa800,0xa408,0xffff,0xa008,0x4440,0x4848,0x1000,0xffff,
0x9408,0x9800,0xffff,0xffff,0xffff,0xe440,0xc408,0xffff,0xac48,0xa040,0x0808,0xa840,0xd008,0xdc00,0xffff,0xffff,
0xffff,0xffff,0x5c00,0xffff,0xe400,0xb448,0xb040,0xffff,0x7800,0xffff,0xffff,0xffff,0xffff,0xc808,0xffff,0xffff,
0xffff,0x6c40,0x6848,0xffff,0xbc48,0xffff,0xffff,0xffff,0xffff,0xd000,0x5008,0x5c00,0xffff,0xa040,0xffff,0x2040,
0xffff,0xa048,0xffff,0xb048,0xffff,0xffff,0x0040,0xffff,0xc400,0xc808,0xffff,0xcc08,0x2840,0x2448,0xffff,0x2c48,
0xffff,0xc400,0xe848,0xffff,0xffff,0xffff,0x9808,0xffff,0xffff,0xffff,0xffff,0xf440,0x8c08,0xffff,0x2448,0xffff,
0xffff,0xffff,0x3000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5840,0x5448,0xf440,0xa408,0xffff,0xffff,
0x9008,0x3040,0xffff,0x3840,0xe048,0xffff,0xffff,0x4400,0xffff,0x8c00,0x0c08,0x0000,0x5c08,0xfc40,0xffff,0xffff},
{
0xffff,0xffff,0xffff,0x0c40,0xffff,0x5408,0xb408,0xe000,0x1408,0x5800,0xffff,0xffff,0xffff,0xffff,0xffff,0xf048,
0xffff,0xc448,0xffff,0xec40,0xffff,0xffff,0xffff,0x0c00,0xe008,0xffff,0xc800,0xffff,0xffff,0xffff,0xffff,0x1048,
0xffff,0xffff,0x0008,0xffff,0x6840,0x4448,0xe048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6408,
0xf400,0x5008,0xe008,0xffff,0x8840,0xffff,0x0c48,0xffff,0xffff,0xffff,0x5c40,0xffff,0x5408,0xffff,0x2c00,0xffff,
0xffff,0x7448,0x3848,0xffff,0xffff,0xffff,0xffff,0xffff,0x7808,0xffff,0xfc00,0xffff,0x9448,0xffff,0xffff,0xac48,
0xffff,0x9848,0xcc48,0xffff,0xffff,0xffff,0xffff,0x6000,0x8c08,0xffff,0xffff,0xffff,0x6c48,0x3840,0xe440,0x4c48,
0x4400,0x6408,0xffff,0x2000,0xffff,0x1848,0x8c48,0xcc40,0xffff,0x6040,0xffff,0x4848,0xd408,0xffff,0x9000,0xffff,
0xffff,0x0c08,0x8c08,0xffff,0xffff,0x7c48,0x6048,0x3440,0xffff,0x9440,0xffff,0xffff,0x3808,0xffff,0xffff,0x5c08,
0xac00,0xffff,0xffff,0x8040,0xffff,0xffff,0xffff,0x6c00,0x9808,0x8840,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x6840,0xffff,0x2c48,0xffff,0x1400,0x9448,0xffff,0xdc40,0x3048,0xffff,0xe840,0xffff,0xd008,0xffff,0x9800,0x9c48,
0xffff,0xffff,0xd048,0xc000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3408,0xffff,0xffff,0x4000,0x4448,
0x7800,0xffff,0x6c08,0x6840,0xffff,0x0008,0xffff,0x8800,0x6408,0x7440,0xffff,0xf048,0x8448,0xffff,0xffff,0x8c08,
0xffff,0xf848,0xe808,0xec40,0x8040,0x8408,0xffff,0x0000,0xf408,0xffff,0x7000,0xffff,0xffff,0x0400,0xffff,0x8c08,
0x3440,0xb808,0xffff,0xffff,0xffff,0xc848,0xffff,0xb040,0xffff,0xffff,0xffff,0xbc08,0xbc08,0xffff,0xc400,0xffff,
0xffff,0xe808,0xffff,0xac00,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x5040,0xffff,0xffff,
0x2400,0xffff,0xffff,0x0440,0xffff,0xffff,0xffff,0xffff,0xffff,0x1840,0xffff,0xac48,0xe848,0xf400,0xffff,0xffff},
{
0x3448,0xffff,0xffff,0xffff,0x4808,0xe000,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xf848,0xffff,0xd840,0xffff,
0xffff,0xffff,0xffff,0xffff,0xd400,0xffff,0xffff,0xffff,0x4800,0x1008,0x0808,0x0848,0xffff,0xffff,0xffff,0xe440,
0x6440,0xffff,0x4400,0xffff,0x1848,0x1808,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x2808,0xffff,0xffff,
0xf800,0xf840,0xffff,0xe000,0x1408,0xffff,0x5448,0x0c40,0x9800,0xffff,0xffff,0xffff,0x7408,0x7448,0x2408,0x7c00,
0xffff,0xffff,0xffff,0xffff,0xffff,0xb048,0xb808,0xffff,0xd440,0x7c48,0xffff,0xf440,0xffff,0xffff,0x8808,0x8848,
0x5808,0x0000,0xffff,0xffff,0xffff,0xffff,0xe448,0xffff,0x2848,0xffff,0x6840,0x6800,0xffff,0xffff,0x8448,0xffff,
0xffff,0xffff,0xffff,0xffff,0x4800,0xffff,0xffff,0xc000,0xffff,0xffff,0xa408,0x0c00,0xffff,0x7840,0xd848,0xffff,
0x9848,0x9808,0xffff,0xffff,0x7440,0x7400,0x3400,0x6c08,0xffff,0xf808,0xa800,0xffff,0xffff,0x1400,0xffff,0x1c48,
0xffff,0xe808,0xffff,0xf048,0xffff,0xffff,0xffff,0x1c08,0x8848,0x8808,0xffff,0x8008,0x6440,0x6400,0xffff,0xffff,
0x8408,0xffff,0xffff,0xffff,0xf800,0xffff,0xd808,0xffff,0xb408,0xffff,0xffff,0xffff,0xffff,0xffff,0x6848,0xffff,
0xffff,0xffff,0xffff,0x7800,0xffff,0x9c40,0x9448,0x9408,0xffff,0xffff,0x1840,0x1800,0xffff,0xec00,0xffff,0xffff,
0xd400,0xffff,0xffff,0x7440,0xa840,0xffff,0xffff,0x0848,0xffff,0xffff,0xffff,0xffff,0xffff,0xb008,0xffff,0xffff,
0x8800,0x8840,0xc808,0x9000,0xffff,0xffff,0x2448,0xffff,0xe800,0xe840,0xb848,0xffff,0xffff,0xffff,0x5408,0x0c00,
0xd440,0xffff,0xf400,0xffff,0xffff,0xa808,0xffff,0x2048,0xe440,0xe400,0xffff,0xffff,0xffff,0x9808,0x3800,0x9008,
0xffff,0xffff,0xffff,0x1848,0xa400,0xffff,0xffff,0xf440,0xffff,0xffff,0x7808,0xffff,0xd440,0xffff,0xffff,0xffff,
0xffff,0x2c40,0x2448,0x2408,0xf808,0x5000,0xffff,0xffff,0xffff,0x9c00,0xffff,0xffff,0xffff,0xe040,0xffff,0xffff},
{
0xffff,0x0808,0x2048,0xffff,0x3848,0x0c40,0xffff,0x4008,0xe040,0xffff,0xffff,0xffff,0x4040,0xffff,0xcc40,0xffff,
0x5840,0xffff,0xd408,0xffff,0xffff,0xffff,0xd040,0xffff,0xffff,0x3048,0x6848,0x1c48,0x2448,0xffff,0xffff,0x4c48,
0xffff,0x3840,0x2000,0x4408,0xffff,0xffff,0x2448,0x4040,0xffff,0xffff,0xffff,0xe808,0xffff,0xc408,0xffff,0xffff,
0xffff,0xffff,0xd440,0xb048,0xffff,0xffff,0xd008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xa000,0xffff,0x4c00,
0x7448,0x0048,0xffff,0x4c48,0xffff,0xffff,0xffff,0xffff,0xffff,0xac48,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,
0x8040,0xffff,0x9c40,0x2840,0xffff,0xa440,0x3c40,0xffff,0x3c00,0x5808,0xffff,0x7440,0x3848,0x5c40,0x4400,0xffff,
0xffff,0x0000,0xffff,0xffff,0x2400,0xffff,0x6800,0xffff,0xffff,0xac00,0x1440,0x2048,0xffff,0xffff,0xffff,0x2400,
0xffff,0xffff,0xac08,0xffff,0xffff,0xa408,0xffff,0xffff,0xffff,0x5840,0x7000,0xffff,0xffff,0x5c08,0x7448,0x4040,
0xffff,0x8c00,0xb400,0xc000,0x9800,0xffff,0xe400,0x9000,0xffff,0x5040,0xffff,0xffff,0x6000,0xffff,0xffff,0x7840,
0xffff,0xffff,0x4008,0xffff,0xfc08,0xffff,0xffff,0x6408,0xffff,0x3400,0xffff,0x8848,0x0440,0xffff,0xffff,0xffff,
0xffff,0xbc48,0xb448,0xc048,0xa848,0x1c48,0xe448,0x9048,0xffff,0xffff,0xffff,0x7c40,0xffff,0x6440,0xffff,0x7808,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x8800,0xffff,0x0000,0xffff,0x8c48,
0xf008,0xffff,0x7c40,0xffff,0xf440,0xffff,0xffff,0xffff,0xffff,0x2808,0x2008,0xffff,0xffff,0x7808,0xffff,0xffff,
0xffff,0x6040,0x1800,0x2c08,0xffff,0xffff,0x1c48,0x2840,0xa800,0xffff,0x4400,0xf000,0xffff,0x8c00,0xe400,0xffff,
0xf040,0xffff,0xffff,0x7800,0xf408,0xffff,0xffff,0xffff,0xffff,0x2840,0x1040,0xa440,0x0c40,0x7840,0xffff,0xffff,
0x0400,0x6008,0x2848,0xffff,0x0048,0xffff,0xffff,0x1808,0xa848,0xffff,0xffff,0xffff,0xf848,0xffff,0xffff,0xffff},
{
0xb008,0x9c00,0xffff,0xffff,0xffff,0xe008,0xffff,0xffff,0xffff,0xe048,0xffff,0x9808,0xffff,0x5c40,0xb008,0xffff,
0xc040,0xffff,0xffff,0xa408,0xffff,0xe840,0xffff,0xffff,0xe008,0xffff,0x0448,0x2840,0x8400,0xffff,0x7840,0x5448,
0xc808,0xe400,0xffff,0x1840,0xac00,0xffff,0xffff,0x6448,0x7840,0x6448,0xffff,0xffff,0xffff,0xffff,0x3408,0x2800,
0xcc40,0xd048,0xffff,0xffff,0xffff,0xffff,0x0808,0x1400,0xffff,0xffff,0xffff,0xffff,0xfc00,0xd008,0xffff,0x3448,
0xffff,0x3408,0xf040,0xffff,0xffff,0x4800,0xffff,0xb840,0xffff,0xd840,0xb008,0xac00,0x7840,0xffff,0x8400,0xffff,
0xffff,0xffff,0x8008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x6808,0xac40,0xffff,0x2008,0x0c00,0xd048,0xfc40,
0x6c00,0x4008,0xffff,0xffff,0xffff,0x2400,0xffff,0xffff,0xffff,0x5040,0xb008,0xac00,0xffff,0x6448,0x0c00,0xffff,
0xffff,0xe840,0xffff,0x1400,0x4840,0x5448,0x3c00,0xffff,0x2800,0x0408,0xffff,0xffff,0xffff,0x7800,0xffff,0xffff,
0xffff,0x4c08,0xffff,0xffff,0xffff,0x3000,0xffff,0xffff,0xffff,0xc040,0xffff,0x1408,0x6040,0x7c48,0x3c08,0xffff,
0xffff,0x5048,0x9808,0x8400,0x7848,0x6440,0xffff,0xffff,0x6c08,0x4000,0xffff,0xf848,0xffff,0xffff,0xffff,0xffff,
0x4408,0xffff,0xe440,0xc848,0xffff,0xffff,0x9848,0xb440,0xffff,0xe848,0xa808,0xb400,0xffff,0xdc40,0xffff,0xffff,
0xffff,0xf040,0xb000,0xffff,0x5040,0x4c48,0x8408,0xffff,0xffff,0x7c08,0xf048,0xdc40,0xffff,0x0000,0xffff,0xb848,
0xc808,0xffff,0x7c40,0xffff,0xb400,0xffff,0xffff,0x3440,0xffff,0xf848,0xffff,0x2000,0xffff,0xffff,0x0800,0xffff,
0xffff,0x6440,0xffff,0xffff,0xffff,0xffff,0x1c08,0x0000,0xc800,0xffff,0xffff,0xffff,0xac08,0xffff,0x0040,0x2c48,
0xe000,0xcc08,0xffff,0xffff,0x8408,0xa800,0xffff,0x1c48,0xc048,0xdc40,0xffff,0x8c08,0xf440,0xe848,0xffff,0x3000,
0xffff,0xc848,0xffff,0xffff,0xffff,0xffff,0xb000,0xac08,0xf808,0xd400,0xffff,0xffff,0xffff,0xffff,0xffff,0x1c40},
{
0x0c08,0xfc00,0x0048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x0c08,0xffff,0xdc48,0xffff,0x7c48,0xffff,
0x0840,0xf448,0x5840,0xf808,0xffff,0x1808,0xffff,0x1448,0xffff,0xa848,0xffff,0xf848,0xffff,0xffff,0xffff,0x1808,
0x6840,0xffff,0x6400,0xffff,0xffff,0xffff,0xffff,0x2408,0x3440,0xffff,0xffff,0xd008,0xd400,0x3008,0xffff,0x3c48,
0xffff,0x6000,0x3008,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xc408,0x1040,
0x7c48,0x0840,0x7008,0xffff,0xffff,0x7800,0x0c48,0xd800,0x5848,0xffff,0xffff,0xffff,0x2808,0xffff,0x8808,0xffff,
0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x3408,0xffff,0x9c08,0xffff,0xffff,0x8c40,0xffff,0xffff,0x2c48,
0xffff,0xa008,0xffff,0xf008,0xa440,0xffff,0xffff,0xffff,0x0000,0xfc08,0x5000,0xffff,0xffff,0xffff,0xffff,0x1c08,
0x6448,0xffff,0xffff,0xffff,0x1408,0xffff,0xb408,0xffff,0xffff,0x3440,0xc808,0xffff,0xffff,0x4400,0xb448,0xe400,
0x9008,0x6000,0x9c48,0xc000,0xffff,0xffff,0xffff,0xb040,0xffff,0xffff,0x9008,0x4840,0xffff,0xffff,0xffff,0xffff,
0xa440,0x5848,0xf440,0x5408,0x4400,0xb408,0xffff,0xb848,0xffff,0x0448,0xffff,0x5448,0x0000,0xe408,0xffff,0xffff,
0xc440,0xffff,0xc800,0xffff,0xffff,0xd808,0xffff,0xffff,0x9840,0xffff,0xc840,0xffff,0xffff,0x9c08,0xffff,0xffff,
0xffff,0xfc00,0xffff,0xf040,0xffff,0x8040,0xdc48,0x8c00,0x2808,0x5c00,0x2448,0xffff,0xffff,0x2c40,0x5808,0x8c40,
0xe048,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x4400,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0x1408,0xffff,
0x9000,0xffff,0xffff,0x7448,0xffff,0x9448,0x2040,0x9808,0xffff,0x3008,0xffff,0x6008,0xffff,0xd048,0xffff,0xffff,
0xe400,0x0c08,0xe840,0xffff,0x0840,0xec48,0x0400,0xffff,0xffff,0x5008,0xffff,0xffff,0x4c40,0xffff,0xffff,0xb008,
0xf848,0xffff,0xffff,0xffff,0xffff,0xf000,0x2808,0xfc40,0xffff,0xa840,0x5408,0xffff,0x2408,0xffff,0x2848,0xffff},
{
0xffff,0x0440,0xffff,0x2800,0xffff,0x0400,0xffff,0x2840,0xffff,0x5c00,0xbc00,0xffff,0xffff,0x0000,0x9800,0xffff,
0xffff,0x6000,0x9840,0xffff,0x8840,0xffff,0xffff,0x5800,0xffff,0x3840,0xffff,0x1400,0xffff,0xffff,0x3c40,0x5c00,
0xffff,0xffff,0xe040,0xec40,0xffff,0xffff,0x6400,0xe000,0xf800,0x9840,0xffff,0xffff,0xffff,0xc840,0xcc40,0xe400,
0xffff,0xa440,0xffff,0xffff,0xffff,0xffff,0xffff,0xffff,0xd840,0xfc00,0xc400,0xffff,0x7440,0xffff,0xffff,0xffff,
0x5008,0x6c08,0x7c48,0xffff,0x4448,0xffff,0xffff,0x7c08,0x5408,0xffff,0x7848,0xffff,0x1c08,0xffff,0xffff,0x7808,
0xffff,0xffff,0xffff,0xffff,0xffff,0x4008,0xffff,0x5c48,0xffff,0xffff,0x0808,0xffff,0xffff,0xffff,0x5408,0x5848,
0x9848,0xffff,0xb408,0x2408,0xffff,0xffff,0xffff,0x2448,0x9c48,0x9008,0xb008,0xffff,0xd848,0x3c08,0xf408,0xffff,
0xffff,0x9c08,0xffff,0xffff,0xe448,0xffff,0xffff,0xffff,0xffff,0x3448,0xc048,0xffff,0xffff,0x1c48,0x9048,0xffff,
0xf000,0x3c00,0xffff,0x1040,0xffff,0xffff,0xe000,0xffff,0x5840,0xffff,0xffff,0x1440,0xffff,0xffff,0xffff,0xffff,
0x5440,0xffff,0xffff,0x6000,0xdc00,0x4c00,0xffff,0xffff,0xfc00,0x4840,0xffff,0xffff,0xffff,0x1440,0xffff,0xffff,
0xa440,0xffff,0xb800,0xffff,0xa400,0xec00,0xb840,0xc040,0x0c00,0xffff,0xffff,0xffff,0xa000,0xb440,0xbc40,0x9800,
0x0000,0x8400,0xffff,0xffff,0x8440,0x8840,0xffff,0xa400,0xa840,0x8000,0xb400,0xffff,0x8040,0xffff,0xffff,0xfc40,
0xffff,0xffff,0xffff,0x2408,0xffff,0xb008,0xffff,0xac48,0xffff,0x3c48,0xffff,0xffff,0xffff,0xffff,0xffff,0x0408,
0xffff,0xffff,0x2048,0x0448,0xffff,0x1448,0x3408,0xffff,0xffff,0x1c08,0xffff,0xffff,0xffff,0xbc08,0x3008,0xa048,
0xac08,0x6008,0x8048,0xffff,0xffff,0xe448,0xffff,0xf808,0xf448,0xffff,0xd808,0xffff,0xa448,0xffff,0x8808,0x5048,
0xc848,0xffff,0xe408,0xffff,0xffff,0xffff,0xfc48,0xffff,0x9008,0x4448,0xffff,0xffff,0xffff,0xffff,0xffff,0xf408}
};

void aurail_decode_data(data16_t *dest,data16_t *source,int size)
{
	system16_decode(dest,source,size,(unsigned short *)aurail_decrypt_data);
}

void aurail_decode_opcode1(data16_t *dest,data16_t *source,int size)
{
	system16_decode(dest,source,size,(unsigned short *)aurail_decrypt_opcode1);
}

void aurail_decode_opcode2(data16_t *dest,data16_t *source,int size)
{
	system16_decode(dest,source,size,(unsigned short *)aurail_decrypt_opcode2);
}

/* sound */

static void sound_cause_nmi( int chip ){
	/* upd7759 callback */
	cpunum_set_input_line(1, INPUT_LINE_NMI, PULSE_LINE);
}

struct SEGAPCMinterface sys16_segapcm_interface_15k = {
	SEGAPCM_SAMPLE15K,
	BANK_256,
	REGION_SOUND1,		// memory region
	50
};
struct SEGAPCMinterface sys16_segapcm_interface_15k_512 = {
	SEGAPCM_SAMPLE15K,
	BANK_512,
	REGION_SOUND1,		// memory region
	50
};
struct SEGAPCMinterface sys16_segapcm_interface_32k = {
	SEGAPCM_SAMPLE32K,
	BANK_256,
	REGION_SOUND1,
	50
};


struct YM2151interface sys16_ym2151_interface = {
	1,			/* 1 chip */
	4000000,	/* 3.58 MHz ? */
	{ YM3012_VOL(40,MIXER_PAN_LEFT,40,MIXER_PAN_RIGHT) },
	{ 0 }
};

struct YM2203interface sys16_ym2203_interface =
{
	1,	/* 1 chips */
	4000000,	/* 3.58 MHz ? */
	{ YM2203_VOL(50,50) },
	{ 0 },
	{ 0 },
	{ 0 },
	{ 0 },
	{ 0 }
};

struct YM2203interface sys16_3xym2203_interface =
{
	3,	/* number of chips */
	4000000,	/* 3.58 MHz ? */
	{ YM2203_VOL(50,50),YM2203_VOL(50,50),YM2203_VOL(50,50) },
	{ 0 },
	{ 0 },
	{ 0 },
	{ 0 },
	{ 0 }
};

struct DACinterface sys16_7751_dac_interface =
{
	1,
	{ 100 }
};


struct UPD7759_interface sys16_upd7759_interface =
{
	1,			/* 1 chip */
	{ 60 }, 	/* volumes */
	{ REGION_CPU2 },			/* memory region 3 contains the sample data */
    UPD7759_SLAVE_MODE,
	{ sound_cause_nmi },
};

struct YM2413interface sys16_ym2413_interface= {
	1,
	3579545,	/* ??? */
	{ YM2413_VOL(100,MIXER_PAN_CENTER,100,MIXER_PAN_CENTER) }
};

struct RF5C68interface sys18_rf5c68_interface = {
  8000000,
  100
};

struct YM2612interface sys18_ym3438_interface =
{
	2,	/* 2 chips */
	8000000,
	{ YM3012_VOL(40,MIXER_PAN_CENTER,40,MIXER_PAN_CENTER),
			YM3012_VOL(40,MIXER_PAN_CENTER,40,MIXER_PAN_CENTER) },	/* Volume */
	{ 0 },	{ 0 },	{ 0 },	{ 0 }
};

int sys18_sound_info[4*2];

#pragma code_seg()
#pragma data_seg()
#pragma bss_seg()
#pragma const_seg()
