#include "neogeo.h"
// Neo Geo -- misc. support functions

unsigned char nNeoProtectionXor;
unsigned int nNeoNumSpriteRom;

extern void DisplayMessage(char* q);
extern const unsigned char *type0_t03;
extern const unsigned char *type0_t12;
extern const unsigned char *type1_t03;
extern const unsigned char *type1_t12;
extern const unsigned char *address_8_15_xor1;
extern const unsigned char *address_8_15_xor2;
extern const unsigned char *address_16_23_xor1;
extern const unsigned char *address_16_23_xor2;
extern const unsigned char *address_0_7_xor;

typedef struct 
{	
	int		rpos;
	UINT32	location;
} POSLOC;

static void decrypt(unsigned char *r0, unsigned char *r1,
		    unsigned char c0,  unsigned char c1,
		    const unsigned char *table0hi,
		    const unsigned char *table0lo,
		    const unsigned char *table1,
		    int base,
		    int invert)

{
	unsigned char tmp,xor0,xor1;
	tmp = table1[(base & 0xff) ^ address_0_7_xor[(base >> 8) & 0xff]];
	xor0 = (table0hi[(base >> 8) & 0xff] & 0xfe) | (tmp & 0x01);
	xor1 = (tmp & 0xfe) | (table0lo[(base >> 8) & 0xff] & 0x01);

	if(invert)
	{
		*r0 = c1 ^ xor0; //r0
		*r1 = c0 ^ xor1; //r1
	}
	else
	{
		*r0 = c0 ^ xor0; //r0
		*r1 = c1 ^ xor1; //r1
	}
}

int _cdecl compare (const void *val1, const void *val2)
{
	POSLOC *ploc1 = (POSLOC *)val1;
	POSLOC *ploc2 = (POSLOC *)val2;	

	if (ploc1->location > ploc2->location)
		return 1;
	else if (ploc1->location == ploc2->location)
		return 0;
	else
		return -1;
}

void neogeo_gfx_decrypt(int extra_xor, int rom_size)
{
	FILE *fpROM = NULL;
	FILE *fp = NULL;
	unsigned char *ROM = NULL;
	unsigned char *buf = NULL;
	int dwBytesDone = 0;
	int rpos;
	int rposreal=0;

	ROM = (unsigned char *)osd_malloc(0x800000);
	DeleteFile(DATAXOR);
	fpROM=fopen(SPRITEDUMP, "rb");
	fp=fopen(DATAXOR, "wb");
	// Data xor
	dwBytesDone = 0;

	while( dwBytesDone < rom_size)
	{
		buf = (unsigned char *)osd_malloc(0x800000);
		fseek(fpROM, dwBytesDone, SEEK_SET);
		fread(ROM, 0x800000, 1, fpROM);
 
		for (rpos = 0;rpos < (0x800000)/4 ;rpos++)
		{
			decrypt(buf+4*rpos+0, buf+4*rpos+3, ROM[4*rpos+0], ROM[4*rpos+3], type0_t03, type0_t12, type1_t03, rposreal, (rposreal>>8) & 1);
			decrypt(buf+4*rpos+1, buf+4*rpos+2, ROM[4*rpos+1], ROM[4*rpos+2], type0_t12, type0_t03, type1_t12, rposreal, ((rposreal>>16) ^ address_16_23_xor2[(rposreal>>8) & 0xff]) & 1);
			rposreal++;
		}
			
		fwrite(buf, 0x800000, 1, fp);
		dwBytesDone += 0x800000;
		free(buf);
	}

	fclose(fp);
	fclose(fpROM);
	free(ROM);

	// Address xor
	// Pre-process the sprite graphics
	InitSpritePaging(DATAXOR, rom_size, /*0x20000*/0x40000, /*200*/32);
	InitPageAndFrameTables();

	FILE *fp2 = fopen(ADDRESSXOR, "wb");
	fpROM = fopen(SPRITEDUMP, "rb");
	dwBytesDone = 0;
	rposreal = 0;

	while( dwBytesDone < rom_size)
	{
		ROM = (unsigned char *)osd_malloc(0x800000);
		// 1 meg is used below, we are going to need 1meg / 4 entries
		POSLOC *poslocList =(POSLOC *)osd_malloc(sizeof(POSLOC) * ((0x800000) / 4));
		fseek(fpROM, dwBytesDone, SEEK_SET);
		fread(ROM, 0x800000, 1, fpROM);
		for (rpos = 0;rpos < (0x800000)/4;rpos++)
		{
			int baser;
			baser = rposreal;
			baser ^= extra_xor;
			baser ^= address_8_15_xor1[(baser >> 16) & 0xff] << 8;
			baser ^= address_8_15_xor2[baser & 0xff] << 8;
			baser ^= address_16_23_xor1[baser & 0xff] << 16;
			baser ^= address_16_23_xor2[(baser >> 8) & 0xff] << 16;
			baser ^= address_0_7_xor[(baser >> 8) & 0xff];

			//special handling for games with 6 C ROMs 
			if (rom_size == 0x3000000)
			{
				if (rposreal < 0x2000000/4)
					baser &= (0x2000000/4)-1;
				else
					baser = 0x2000000/4 + (baser & ((0x1000000/4)-1));
			}
			else	//Clamp to the real rom size 
				baser &= (rom_size/4)-1;
			 
			poslocList[rpos].rpos		= rpos;
			poslocList[rpos].location	= (UINT32)baser * 4;

			rposreal++;

		}
		
		qsort(poslocList, (0x800000) / 4, sizeof(POSLOC), compare);
		for (int i = 0; i < (0x800000)/4; i++)
		{
			((UINT32*)ROM)[poslocList[i].rpos]  = (UINT32)ReadUWORDFromROM(poslocList[i].location);
		}
		
		fwrite(ROM, 0x800000, 1, fp2);
		dwBytesDone += 0x800000;
		free(ROM);
		free(poslocList);
	}

	fclose(fp2);
	fclose(fpROM);
	KillSpritePaging(TRUE);
}

// This function loads the 68K ROMs
int NeoLoadCode(int nOffset, int nNum, unsigned char* pDest)
{
	struct BurnRomInfo ri;

	for (int i = 0; i < nNum; i++) {
		ri.nLen = 0;
		BurnDrvGetRomInfo(&ri, nOffset + i);

		if ((BurnDrvGetHardwareCode() & HARDWARE_SNK_P32) && (i == 0))
		{
			if (BurnLoadRom(pDest + 0, nOffset + i + 0, 2)) return 1;
			if (BurnLoadRom(pDest + 1, nOffset + i + 1, 2)) return 1;
 
			for (unsigned int j = 0; j < ri.nLen << 1; j+=4)
				BurnByteswap(pDest + j + 1, 2);

			i++;
			pDest += ri.nLen << 1;
			continue;
		}

		if (BurnLoadRom(pDest, nOffset + i, 1)) {
			return 1;
		}

		if ((BurnDrvGetHardwareCode() & HARDWARE_SNK_SWAPP) && (i == 0)) {
			for (unsigned int j = 0; j < (ri.nLen / 2); j++) {
				int k = pDest[j];
				pDest[j] = pDest[j + (ri.nLen / 2)];
				pDest[j + (ri.nLen / 2)] = k;
			}
		}

		pDest += ri.nLen;
	}

	return 0;
}

// This function loads and pre-processes the sprite data
int NeoLoadSprites(int nOffset, int nNum, unsigned char* pDest, unsigned int nSpriteSize, int nTextOffset)
{
	//DisplayMessage("NeoLoadSprites Start");
	struct BurnRomInfo ri;
	ri.nType = 0;
	ri.nLen = 0;

	int ROM32MB = 0;
	unsigned int nRomSize = 0;
	
	nNeoNumSpriteRom = nNum;

	//if (BurnDrvGetHardwareCode() & (HARDWARE_SNK_ENCRYPTED_A | HARDWARE_SNK_ENCRYPTED_B)) {
	//	if (BurnDrvGetHardwareCode() & HARDWARE_SNK_ENCRYPTED_A) {
	//		DisplayMessage("HARDWARE_SNK_ENCRYPTED_A");
	//		NeoGfxDecryptCMC42Init();
	//	} else {
	//		if (BurnDrvGetHardwareCode() & HARDWARE_SNK_ENCRYPTED_B) {
	//			DisplayMessage("HARDWARE_SNK_ENCRYPTED_B");
	//			NeoGfxDecryptCMC50Init();
	//		}
	//	}

	//	nRomSize = ((nSpriteSize / nNum) & 0xf00000) ? 0x1000000 : 0x2000000;
	//	unsigned char* pBuf = (unsigned char *)osd_malloc( nRomSize );
	//	if (pBuf == NULL) {
	//		return 1;
	//	}

	//	for (int i = 0; i < (nNum + ROM32MB >> 1); i++) {
	//		if ((nSpriteSize / nNum) == 0x2000000) {		// svcpcb
	//			ROM32MB = 2;
	//			BurnLoadRom(pBuf, nOffset + i, 1);

	//			pcb_gfx_crypt(pBuf, 0);
	//		} else {						// standard
	//			BurnLoadRom(pBuf + 0, nOffset + 0 + (i << 1), 2);
	//			BurnLoadRom(pBuf + 1, nOffset + 1 + (i << 1), 2);

	//			if (nRomSize == 0x2000000) {			// ms5pcb, svcpcba, kf2k3pcb
	//				for (int j = 0; j < 0x2000000; j+=4)
	//					BurnByteswap(pBuf + j + 1, 2);

	//				pcb_gfx_crypt(pBuf, nNum & 2);
	//			}		
	//		}

	//		BurnUpdateProgress(1.0 / ((double)(nSpriteSize/0x800000) * 8.0 / (nRomSize / 0x400000) / 3.0), _T("Decrypting graphics..."), 0);
	//		NeoGfxDecryptDoBlock(nNeoProtectionXor, pBuf, nRomSize * i, nRomSize, nSpriteSize);
	//	}

	//	free(pBuf);

	//} else {
		//DisplayMessage("Not Encrypted");
		//struct BurnRomInfo ri;
		unsigned char* SpriteBuf = NULL;
		int dwBytesDone = 0;
		int dwLastBytes = 0;
		FILE *fp = NULL;
		FILE *fpPagefile = NULL;
		ri.nType = 0;
		ri.nLen = 0;
		DeleteFile(SPRITEDUMP);
		fp = fopen(SPRITEDUMP, "wb");
		nSpriteSize = 0;
		dwBytesDone = 0;

		// Compute correct size to gaps into account (Kizuna)
		for (int i = 0; i < nNum - 2; i++) {
			BurnDrvGetRomInfo(&ri, nOffset + i);
			if (ri.nLen > nRomSize) {
				nRomSize = ri.nLen;
			}
		}

		for (int i = 0; i < (nNum >> 1); i++) {
			BurnDrvGetRomInfo(&ri, nOffset + (i << 1));

			if (i < (nNum >> 1) - 1) {
				dwBytesDone += nRomSize << 1;
			} else {
				dwBytesDone += ri.nLen << 1;
			}

			SpriteBuf = (unsigned char *)osd_malloc(dwBytesDone - nSpriteSize);
			BurnLoadRom(SpriteBuf + 0, nOffset + (i << 1), 2);
			BurnLoadRom(SpriteBuf + 1, nOffset + 1 + (i << 1), 2);

			// If the ROMs combined are 0x800000 bytes large, place swap the 0x0400000 byte blocks
			if (BurnDrvGetHardwareCode() & HARDWARE_SNK_SWAPC && ri.nLen == 0x400000) {
				// j counts 16-bit words!
				for (int j = 0; j < 0x200000; j++) {
					short n = ((short*)(SpriteBuf))[j];
					((short*)(SpriteBuf))[j] = ((short*)(SpriteBuf))[j + 0x200000];
					((short*)(SpriteBuf))[j + 0x200000] = n;
				}
			}

			if ((!strcmp(BurnDrvGetTextA(DRV_NAME), "kog")) ||
				(!strcmp(BurnDrvGetTextA(DRV_NAME), "lans2004")) ||
				(!strcmp(BurnDrvGetTextA(DRV_NAME), "garoubl")) ||
				(!strcmp(BurnDrvGetTextA(DRV_NAME), "samsho5b"))) {
				unsigned char *tmp = (unsigned char*)osd_malloc(0x40);
				int tsize = dwBytesDone - nSpriteSize;
				if (tmp) {
					for (int z = 0; z < tsize; z+=0x80) {
						memcpy (tmp + 0, SpriteBuf + z + 0, 0x40);
						memcpy (SpriteBuf + z + 0, SpriteBuf + z + 0x40, 0x40);
						memcpy (SpriteBuf + z + 0x40, tmp + 0, 0x40);
					}
					free (tmp);
				}
			}

			if ((!strcmp(BurnDrvGetTextA(DRV_NAME), "svcboot")) ||
				(!strcmp(BurnDrvGetTextA(DRV_NAME), "svcplus")) ||
				(!strcmp(BurnDrvGetTextA(DRV_NAME), "svcplusa")) ||
				(!strcmp(BurnDrvGetTextA(DRV_NAME), "svcsplus"))) {
				DoPerm(1, SpriteBuf);
			}

			if ((!strcmp(BurnDrvGetTextA(DRV_NAME), "cthd2003")) ||
				(!strcmp(BurnDrvGetTextA(DRV_NAME), "matrimbl")) ||
				(!strcmp(BurnDrvGetTextA(DRV_NAME), "ct2k3sa")) ||
				(!strcmp(BurnDrvGetTextA(DRV_NAME), "ct2k3sp"))) {
				DoPerm(0, SpriteBuf);
			}
			
			if ((!strcmp(BurnDrvGetTextA(DRV_NAME), "kof2002b"))) {
				kof2002b_gfx_decrypt(SpriteBuf, (dwBytesDone - nSpriteSize));
			}

			fwrite(SpriteBuf, (dwBytesDone - nSpriteSize), 1, fp);

			if (i < (nNum >> 1) - 1) {
				nSpriteSize += nRomSize << 1;
			} else {
				nSpriteSize += ri.nLen << 1;
			}

			free(SpriteBuf);
		}

		fclose(fp);
		
		//DisplayMessage("Sprites done");
		// Swap data for viewpoin, aof, ssideki & kotm2
		if (BurnDrvGetHardwareCode() & HARDWARE_SNK_SWAPC) {
			//DisplayMessage("BurnDrvGetHardwareCode() & HARDWARE_SNK_SWAPC");
			BurnDrvGetRomInfo(&ri, nOffset);
			if (ri.nLen == 0x200000) {
				//failing here needs to use file
				unsigned char* pBuf = (unsigned char*)osd_malloc(0x600000);

				if (nNum < 4) {
					nSpriteSize = 0x600000;
				}

				unsigned char *ViewpointBuf = (unsigned char *)osd_malloc(0x600000);

				fp = fopen(SPRITEDUMP, "r+b");
				fread(ViewpointBuf,0x600000,1,fp);

				if (pBuf) {
					for (int i = 0x200000; i < 0x600000; i++) {
						pBuf[i] = ViewpointBuf[i];
					}
					for (int i = 0; i < 0x100000; i++) {
						((short*)(ViewpointBuf + 0x200000))[i] = ((short*)(pBuf + 0x400000))[i];
						((short*)(ViewpointBuf + 0x400000))[i] = ((short*)(pBuf + 0x200000))[i];
					}
					free(pBuf);
				} else {
					return 1;
				}
				fseek(fp, 0, SEEK_SET);
				fwrite(ViewpointBuf, 0x600000, 1, fp);
				fclose(fp);
				free(ViewpointBuf);
			}
		}

		if (BurnDrvGetHardwareCode() & HARDWARE_SNK_ENCRYPTED_A) {
			//DisplayMessage("HARDWARE_SNK_ENCRYPTED_A");
			NeoGfxDecryptCMC42Init();
			neogeo_gfx_decrypt(nNeoProtectionXor, nSpriteSize);
		} else {
			if (BurnDrvGetHardwareCode() & HARDWARE_SNK_ENCRYPTED_B) {
				//DisplayMessage("HARDWARE_SNK_ENCRYPTED_B");
				NeoGfxDecryptCMC50Init();
				neogeo_gfx_decrypt(nNeoProtectionXor, nSpriteSize);
			}
		}

		NeoTextROM = (unsigned char*)osd_malloc(nNeoTextROMSize + 0x020000);
		if (NeoTextROM == NULL) {
			//DisplayMessage("NeoTextROM == NULL");
			return 1;
		}

		// Load Text layer tiledata
		{
			// Load boardROM data
			BurnLoadRom(NeoTextROM,	0x00080 + 0x14, 1);

			if (nTextOffset != -1) {
				//DisplayMessage("Load S ROM data");
				// Load S ROM data
				BurnLoadRom(NeoTextROM + 0x020000, nTextOffset, 1);
			} else {
				if (!(BurnDrvGetHardwareCode() & (HARDWARE_SNK_ENCRYPTED_A | HARDWARE_SNK_ENCRYPTED_B))) {
					//DisplayMessage("CopyFile(SPRITEDUMP, ADDRESSXOR, false);");
					CopyFile(SPRITEDUMP, ADDRESSXOR, false);
				}
				//DisplayMessage("NeoExtractSData Start");
				NeoExtractSData(NULL, NeoTextROM + 0x020000, nSpriteSize, nNeoTextROMSize);
				//DisplayMessage("NeoExtractSData End");

				FILE *fp2;
				fp2 = fopen(SDUMP, "rb");
				fread(NeoTextROM + 0x020000, 1, nNeoTextROMSize, fp2);
				fclose(fp2);
			}
		}
	//}

	//DisplayMessage("NeoDecodeText(NeoTextROM, nNeoTextROMSize);");
	NeoDecodeText(NeoTextROM, nNeoTextROMSize);
	//DisplayMessage("NeoDecodeSprites(NULL,nSpriteSize);");
	NeoDecodeSprites(NULL,nSpriteSize);
	//DisplayMessage("DeleteFile");
	DeleteFile(SDUMP);
	DeleteFile(ADDRESSXOR);
	DeleteFile(DATAXOR);
	DeleteFile(SPRITEDUMP);
	//DisplayMessage("NeoLoadSprites End");
	return 0;
}

void NeoDecodeSprites(unsigned char* pDest, int nSpriteSize)
{	
	//DisplayMessage("NeoDecodeSprites Start");
	// function changed a little (1 file - 8 files before) - GogoAckman
	FILE *fp = NULL;
	FILE *fpPagefile = NULL;

		fp = fopen(SPRITEDUMP, "rb");

	// Pre-process the sprite graphics

	unsigned char *SpriteBuf2 = (unsigned char *)osd_malloc(0x800000);

	// Pre-process the sprite graphics

	fpPagefile = fopen(PAGEFILE, "wb");

	int dwBytesDone = 0;

	while(dwBytesDone < nSpriteSize) {
		fseek(fp, dwBytesDone, SEEK_SET);
		fread(SpriteBuf2, 0x800000, 1, fp);

		for (unsigned char* pTile = SpriteBuf2; pTile < SpriteBuf2 + (0x800000); pTile += 128) {
			unsigned int data[32];
			for (int y = 0; y < 16; y++) {
				unsigned int n = 0;
				for (int x = 0; x < 8; x++) {
					unsigned int m = ((pTile[67 + (y << 2)] >> x) & 1) << 3;
					m |= ((pTile[65 + (y << 2)] >> x) & 1) << 2;
					m |= ((pTile[66 + (y << 2)] >> x) & 1) << 1;
					m |= ((pTile[64 + (y << 2)] >> x) & 1) << 0;

					n |= m << (x << 2);
				}
				data[(y << 1) + 0] = n;

				n = 0;
				for (int x = 0; x < 8; x++) {
					unsigned int m = ((pTile[3 + (y << 2)] >> x) & 1) << 3;
					m |= ((pTile[1 + (y << 2)] >> x) & 1) << 2;
					m |= ((pTile[2 + (y << 2)] >> x) & 1) << 1;
					m |= ((pTile[0 + (y << 2)] >> x) & 1) << 0;

					n |= m << (x << 2);
				}
				data[(y << 1) + 1] = n;
			}
			for (int n = 0; n < 32; n++) {
				((unsigned int*)pTile)[n] = data[n];
			}
		}
		fwrite(SpriteBuf2, 0x800000, 1, fpPagefile);
		dwBytesDone += 0x800000;

	}
	free(SpriteBuf2);
	fclose(fp);
	fclose(fpPagefile);
	//DisplayMessage("NeoDecodeSprites End");
}

void NeoDecodeText(unsigned char* pDest, int nSize)
{
	//DisplayMessage("NeoDecodeText Start");
	// Pre-process the text layer graphics
	for (unsigned char* pTile = pDest; pTile < (pDest + 0x20000 + nSize); pTile += 32) {
		unsigned char data[32];
		for (int n = 0; n < 8; n++) {
			data[0 + n * 4] = pTile[16 + n];
			data[1 + n * 4] = pTile[24 + n];
			data[2 + n * 4] = pTile[ 0 + n];
			data[3 + n * 4] = pTile[ 8 + n];
		}

		for (int n = 0; n < 32; n++) {
			pTile[n] = data[n] << 4;
			pTile[n] |= data[n] >> 4;
		}
	}
	//DisplayMessage("NeoDecodeText End");
}

int NeoLoadADPCM(int nOffset, int nNum, unsigned char* pDest)
{
	struct BurnRomInfo ri;
	ri.nLen = 0;
	BurnDrvGetRomInfo(&ri, nOffset);

	for (int i = 0; i < nNum; i++) {
		BurnLoadRom(pDest, nOffset + i, 1);
		pDest += ri.nLen;
	}

	return 0;
}

// This function fills the screen with the first palette entry
void NeoClearScreen()
{
	unsigned int nColour = NeoPalette[0x0FFF];

	if (nColour) {
		switch (nBurnBpp) {
			case 4: {
				unsigned int* pClear = (unsigned int*)pBurnDraw;
				for (int i = 0; i < nNeoScreenWidth * 224 / 8; i++) {
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
				}
				break;
			}

			case 3: {
				unsigned char* pClear = pBurnDraw;
				unsigned char r = nColour;
				unsigned char g = (r >> 8) & 0xFF;
				unsigned char b = (r >> 16) & 0xFF;
				r &= 0xFF;
				for (int i = 0; i < nNeoScreenWidth * 224; i++) {
					*pClear++ = r;
					*pClear++ = g;
					*pClear++ = b;
				}
				break;
			}

			case 2: {
				unsigned int* pClear = (unsigned int*)pBurnDraw;
				nColour |= nColour << 16;
				for (int i = 0; i < nNeoScreenWidth * 224 / 16; i++) {
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
					*pClear++ = nColour;
				}
				break;
			}
		}
	} else {
		memset(pBurnDraw, 0, nNeoScreenWidth * 224 * nBurnBpp);
	}
}

