#include "GlobalExtern.h"

void ROMSelectInput() {
	ReadInput();

	if(analogScroll && !g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] && 
		!g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
			analogScroll = false;
			UpdatePreview(GameDatabase[GameSelected].name);
			return;
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		stopMovie();
		if(CustomSet) {
			GUIState = 13;
		}
		else if (CompanySet) {
			GUIState = 14;
		}
		else if (YearSet) {
			GUIState = 15;
		}
		else if (GenreSet) {
			GUIState = 16;
		}
		else {
			MenuSelected = 0;
			GUIState = MAIN_MENU;
			MenuBackground();
		}
		fadeOption = 0;
		fadeColor = 255;
		m_mp3player.pause(FALSE);
		//SetDelay();
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {  
		if(GameSelected == GameDatabase.size() - 1)
			return;
		if(!disableMenuSounds) ClickSound();
		GameSelected++; 
		if(GameSelected >= GameDatabase.size()) 
			GameSelected = GameDatabase.size() - 1;
		UpdatePreview(GameDatabase[GameSelected].name);
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  { 
		if(GameSelected == 0)
			return;
		if(!disableMenuSounds) ClickSound();
		GameSelected--; 
		if(GameSelected < 0) 
			GameSelected = 0;
		UpdatePreview(GameDatabase[GameSelected].name);
		return;
	}  

	if (g_Gamepads[DefaultController].fY2 < 0)  {
		ScrollSpeedCount++;
		if((ScrollSpeedCount % ScrollSpeed) == 0) {
			ScrollSpeedCount = 0;
			GameInfoDetailSelected += 1;
		}
		if(GameInfoDetailSelected >= GameInfoDetail.size()) 
			GameInfoDetailSelected = GameInfoDetail.size() - 1;
		return;
	}

	if (g_Gamepads[DefaultController].fY2 > 0)  {
		ScrollSpeedCount++;
		if((ScrollSpeedCount % ScrollSpeed) == 0) {
			ScrollSpeedCount = 0;
			GameInfoDetailSelected -= 1;
		}
		if(GameInfoDetailSelected < (GameInfoDetailNumLines / 2)) 
			GameInfoDetailSelected = (GameInfoDetailNumLines / 2);
		return;
	}  

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_LEFT  &&
		g_Gamepads[DefaultController].fX2 == 0 && 
		!(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && 
		!(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) {  
			char c = GameDatabase[GameSelected].displayName[0];	  
			c = tolower(c);
			for(int i = GameSelected; i > 0; i--) {
				char n = GameDatabase[i].displayName[0];
				n = tolower(n);
				if(n <  c) {
					GameSelected = i;
					UpdatePreview(GameDatabase[GameSelected].name);
					break;	
				}
			}
			return;
	} 

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_RIGHT &&
		g_Gamepads[DefaultController].fX2 == 0 && 
		!(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) && 
		!(g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER])) { 
			char c = GameDatabase[GameSelected].displayName[0];	  
			c = tolower(c);
			for(int i = GameSelected; i < GameDatabase.size(); i++) {
				char n = GameDatabase[i].displayName[0];
				n = tolower(n);
				if(n > c) {
					GameSelected = i;
					UpdatePreview(GameDatabase[GameSelected].name);
					break;
				}
			}
			return;
	} 		

	if (g_Gamepads[DefaultController].fX2 < 0)  {
		if(!PreviewSwitchValid())
			return;
		CyclePreview(-1);
		PreviewSwitch = true;
		UpdatePreview(GameDatabase[GameSelected].name);
		if(!TexPreview) {
			for(int i = 0; i < 7; i++) {
				CyclePreview(-1);
				PreviewSwitch = true;
				UpdatePreview(GameDatabase[GameSelected].name);
				if(TexPreview)
					break;
			}
		}
		return;
	}

	if (g_Gamepads[DefaultController].fX2 > 0)  {
		if(!PreviewSwitchValid())
			return;
		CyclePreview(1);
		PreviewSwitch = true;
		UpdatePreview(GameDatabase[GameSelected].name);
		if(!TexPreview) {
			for(int i = 0; i < 7; i++) {
				CyclePreview(1);
				PreviewSwitch = true;
				UpdatePreview(GameDatabase[GameSelected].name);
				if(TexPreview)
					break;
			}
		}
		return;
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_Y) {
		GameSelected = 0;
		UpdatePreview(GameDatabase[GameSelected].name);
		return;
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		if(_tcscmp("", GameDatabaseTemp[0].name.c_str()) == 0) {
			return;
		}
		ConfirmSound();
		m_mp3player.stop();
		stopMovie();
		fadeColor = 255;
		while(fadeColor > 0) {
			Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
			Device->SetTexture(0,TexOption);
			DrawBackground();
			Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			fade = true;
			fadeColor -=fadeSpeed;
			if(fadeColor < fadeSpeed) { fadeColor = 0; }
			Device->SetTexture(0,TexROMBrowser);
			DrawBackground();
			fade = false;
			Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			Device->Present(NULL,NULL,NULL,NULL);
		}
		DisplayMessage("Please wait...");
		//Emulation = true;
		dprintf("Save Ini\n");
		SaveIni();
		dprintf("LoadGameIni %s\n", GameDatabase[GameSelected].name.c_str());
		//LoadGameIni(GameDatabase[GameSelected].name);
		dprintf("CreateDirectories\n");
		CreateDirectories(GameDatabase[GameSelected].name.c_str());
		dprintf("SegaMain %s\n", GameDatabase[GameSelected].name.c_str());
		//SegaMain(GameDatabase[GameSelected].name);
		FILE *f;
		f = fopen("Z:\\game.txt", "w+");
		fprintf(f, "%s\n", GameDatabase[GameSelected].name.c_str());
		fclose(f);
		DisplayMessage("Please wait...");
		Device->PersistDisplay();
		PLAUNCH_DATA ldata ;
		memset( &ldata, 0, sizeof(PLAUNCH_DATA) ) ;
		XLaunchNewImage( "D:\\default.xbe", ldata ) ;
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_WHITE) {
		AddToFavorites();
		SaveFavorites();
		while(1) {
			ReadInput();
			if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
				CancelSound();
				//SetDelay();
				return;
			}

			Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
			Device->SetTexture(0,TexOption);
			DrawBackground();
			DisplayCenteredMsg("The following game has been added to the favorites list:", 190); 
			DisplayCenteredMsg((char*)GameDatabase[GameSelected].displayName.c_str(), 190 + vSpace); 
			DisplayCenteredMsg("Press \"B\" to return to the game list", 190 + (2 * vSpace));
			Device->Present(NULL,NULL,NULL,NULL);
		}
	}

	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
		if(GameSelected == GameDatabase.size() - 1)
			return;
		stopMovie();
		GameInfoDetail.clear();
		if(analogSpeed >= 1) { 
			analogSpeed = 0; 
		} 
		if(rightAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)rightAnalog/255.0f);
		GameSelected+=((int)analogSpeed); 
		if(GameSelected >= GameDatabase.size()) 
			GameSelected = GameDatabase.size() - 1;
		analogScroll = true;
		if(TexPreview) {
			TexPreview->Release();
			TexPreview = NULL;
		}
		return;
	}

	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
		if(GameSelected == 0)
			return;
		stopMovie();
		GameInfoDetail.clear();
		if(analogSpeed >= 1)  { 
			analogSpeed = 0;
		}
		if(leftAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)leftAnalog/255.0f);
		GameSelected-=((int)analogSpeed); if(GameSelected < 0) GameSelected = 0;
		analogScroll = true;
		if(TexPreview) {
			TexPreview->Release();
			TexPreview = NULL;
		}
		return;
	}
}

void DrawGameList() {
	DisplayCenteredMsg((char*)GameDatabase[GameSelected].displayName.c_str(), ROMPosY);
	int y = GameListY;
	DWORD color;
	int start = 0;

	if(GameSelected > (GameListCount / 2) && (GameDatabase.size() > GameListCount)) {
		start += (GameSelected  - (GameListCount / 2));
	}

	if((GameSelected > ((GameDatabase.size()-1) - (GameListCount / 2))) && (GameDatabase.size() > GameListCount)) {
		start = (GameDatabase.size() - GameListCount);
	}

	for(int i = start; i <  start + GameListCount; i++) {
		if(i == GameDatabase.size()) return;
		if(i ==GameSelected) color = 0xffff00; else color = 0xffffff; 
		WCHAR msg[1024]={0};

		std::string t = GameDatabase[i].displayName;
		for(int r = 0; r < 1024; r++) {
			if((t.c_str())[r] == '\0') {
				msg[r] = '\0';
				break;
			}
			msg[r] = (t.c_str())[r];
		}
		FontSetColour(color);
		FontText(msg,GameListX, y, GameListWidth);
		y+=vSpace;
	}
}

void DrawROMList(int Mode) {
	Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexROMBrowser);
	DrawBackground();

	if(fadeColor > 0) {
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		fade = true;
		fadeColor -=fadeSpeed;
		if(fadeColor < fadeSpeed) { fadeColor = 0; resumeGUI = false; }
		if(resumeGUI || CustomSet || CompanySet || YearSet || GenreSet) {
			Device->SetTexture(0,TexOption);
		}
		else {
			Device->SetTexture(0,TexMainMenu);
		}
		DrawBackground();
		fade = false;
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
		Device->Present(NULL,NULL,NULL,NULL);
		if(setDisplay) {
			setDisplay = false;
			Device->SetFlickerFilter(FlickerFilter);
			Device->SetSoftDisplayFilter(Soften);
		}
		return;
	}
	else {	
		if(TexPreview) {
			if(videoRender) {
				Device->SetTexture(0,TexPreview);
				if(SourceWidth < SourceHeight) {
					MakeVertexListPreviewVertical();
				}
				else {
					MakeVertexListPreview();
				}
				Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
				Device->SetTexture(0,TexPreviewBorder);
				if(SourceWidth < SourceHeight) {
					MakeVertexListPreviewBorderVertical();
				}
				else {
					MakeVertexListPreviewBorder();
				}
				Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
				Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
				Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			}
			else {
				Device->SetTexture(0,TexPreview);
				if(SourceWidth < SourceHeight) {
					MakeVertexListAlternatePreviewVertical();
				}
				else {
					MakeVertexListAlternatePreview();
				}
				Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
				Device->SetTexture(0,TexPreviewBorder);
				if(SourceWidth < SourceHeight) {
					MakeVertexListAlternatePreviewBorderVertical();
				}
				else {
					MakeVertexListAlternatePreviewBorder();
				}
				Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
				Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
				Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
			}
		}
		Device->SetTexture(0,TexROMBorder);
		MakeVertexListROMBorder();
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
		Device->SetTexture(0,TexSelectedBorder);
		MakeVertexListSelectedBorder();
		Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
		if(Mode)
			DrawGameFavoriteList();
		else
			DrawGameList();
		if(!analogScroll) {
			if(GameInfoDetailEnabled == 1 && GameInfoDetail.size() != 0) {
				Device->SetTexture(0,TexInfoBorder);
				MakeVertexListInfoBorder();
				Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
				Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
				Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
				DrawGameInformationDetail();
			}
			if(GameInfoEnabled == 1 || (GameInfoDetailEnabled == 1  && GameInfoDetail.size() == 0)) {
				Device->SetTexture(0,TexInfoBorderSimple);
				MakeVertexListInfoBorderSimple();
				Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
				Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
				Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
				if(Mode)
					DrawGameFavoriteInformation();
				else
					DrawGameInformation();
			}
		}
		if(videoRender) {
			drawMovie();
			Device->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
			Device->SetTexture(0,TexVideoBorder);
			MakeVertexListVideoBorder();
			Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
			Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
			Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
		}
		Device->SetTexture(0,TexAnimatedLogo);
		MakeVertexListAnimatedLogo(true);
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,TRUE);
		Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
		Device->SetRenderState(D3DRS_ALPHABLENDENABLE,FALSE);
	}
	Device->Present(NULL,NULL,NULL,NULL);
	if(setDisplay) {
		setDisplay = false;
		Device->SetFlickerFilter(FlickerFilter);
		Device->SetSoftDisplayFilter(Soften);
	}
}

void DrawROMSelectMenu() {
	DrawROMList(0);
}

void ROMSelectMenu() {
	DrawROMSelectMenu();
	ROMSelectInput();
}
