#include "GlobalExtern.h"

void GameOptionInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		//CancelSound();
		SaveIni();
		exitGameMenu = true;
		DxSoundPlay();
		//SetDelay();
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		if(!disableMenuSounds) ClickSound();
		GameOptionSelected++;
		if(GameOptionSelected > GameOptionItems.size() - 1)
			GameOptionSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		if(!disableMenuSounds) ClickSound();
		GameOptionSelected--;
		if(GameOptionSelected < 0)
			GameOptionSelected = GameOptionItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		if(GameOptionSelected == 0) {
			//ConfirmSound();
			SaveIni();
			exitGameMenu = true;
			DxSoundPlay();
			//SetDelay();
			return;
		}
		if(GameOptionSelected == 1) {
			ConfirmSound();
			std::string e;
			if(CurrentArtwork == 1) e = ArtworkPath1;
			if(CurrentArtwork == 2) e = ArtworkPath2;
			if(CurrentArtwork == 3) e = ArtworkPath3;
			if(CurrentArtwork == 4) e = ArtworkPath4;
			if(CurrentArtwork == 5) e = ArtworkPath5;
			if(CurrentArtwork == 6) e = ArtworkPath6;
			if(CurrentArtwork == 7) e = ArtworkPath7;
			if(CurrentArtwork == 8) e = ArtworkPath8;
			char fileName[260];
			sprintf(fileName,"%s%s%s%s", e.c_str(), "\\", BurnDrvGetTextA(0), ".png");
			MakeScreenShot(fileName);
			SaveIni();
			exitGameMenu = true;
			DxSoundPlay();
			//SetDelay();
			return;
		}

		if(GameOptionSelected == 2) {
			scale = true;
			while(scale == true) {
				OptionVideoScaleMenu();
			}
		}

		if(GameOptionSelected == 3) {
			
			ReturnToGUI();
		}
	}
}

void DrawGameOptionItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(GameOptionSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawGameOptionMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	SetupMatrices();
	DrawBackground();
	Device->SetTexture(0,TexScreen);
	exitEmulation = true;
	MakeVertexListExitGame();
	exitEmulation = false;
	D3DXMATRIX q;
	D3DXMatrixRotationZ(&q, RotationDegrees * (3.14/180));
	Device->SetTransform(D3DTS_WORLD, &q);
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	if(zoomOver >= 4) {
		for(int i = 0; i < GameOptionItems.size(); i++) {
			DrawGameOptionItem(i, (char*)GameOptionItems[i].c_str(), GameOptionPosX, GameOptionPosY + (i * vSpace));
		}
	}
	Device->Present(NULL,NULL,NULL,NULL);
}

void GameOptionMenu() {
	GUIState = 1;
	dprintf("GameOptionMenu\n");
	if(RotationDegrees == 0) {
		zLeftExitGame = zLeft0;
		zRightExitGame = zRight0;
		zTopExitGame = zTop0;
		zBottomExitGame = zBottom0;
	}
	if(RotationDegrees == 90) {
		zLeftExitGame = zLeft90;
		zRightExitGame = zRight90;
		zTopExitGame = zTop90;
		zBottomExitGame = zBottom90;
	}
	if(RotationDegrees == 180) {
		zLeftExitGame = zLeft180;
		zRightExitGame = zRight180;
		zTopExitGame = zTop180;
		zBottomExitGame = zBottom180;
	}
	if(RotationDegrees == 270) {
		zLeftExitGame = zLeft270;
		zRightExitGame = zRight270;
		zTopExitGame = zTop270;
		zBottomExitGame = zBottom270;
	}
	zLeftScale = zBaseLeft + zLeft;
	zRightScale = zBaseRight + zRight;
	zTopScale = zBaseTop + zTop;
	zBottomScale = zBaseBottom + zBottom;
	leftMove = ((zLeftExitGame - (zLeftScale)) / zoomSpeed);
	rightMove = (((zRightScale) - zRightExitGame) / zoomSpeed);
	topMove = (((zTopScale) - zTopExitGame) / zoomSpeed); 
	bottomMove = ((zBottomExitGame - (zBottomScale)) / zoomSpeed);
	zoomOver = 0;

	GameOptionSelected = 0;
	dprintf("Start while loop. GUIState: %d\n", GUIState);
	while(!exitGameMenu) {
		SetupMatrices();
		if(GUIState == 4) {
			OptionVideoMenu();
		}
		if(GUIState == 5) {
			OptionSoundMenu();
		}
		/*if(GUIState == 6) {
		OptionControllerMenu();
		}*/
		if(GUIState == 8) {
			OptionVideoScaleMenu();
		}
		//if(GUIState == 9) {
		//	OptionControllerButtonMenu();
		//}

		if(GUIState == 10) {
			OptionSaveStateMenu();
		}

		if(GUIState == 11) {
			OptionLoadStateMenu();
		}

		if(GUIState == 12) {
			GuideListMenu();
		}

		if(GUIState == 1 || GUIState == 2) {
			GameOptionInput();
			DrawGameOptionMenu();
		}
		updateEffect();
	}
	SetDelay();
	SetupMatricesEmulation();
	MakeVertexList();
	Device->SetTexture(0,TexScreen);
}