#include "GlobalExtern.h"

void OptionSoundInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 3;
		//SetDelay();
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  { 
		if(!disableMenuSounds) ClickSound();
		OptionSoundSelected++;
		if(OptionSoundSelected > OptionSoundItems.size() - 1)
			OptionSoundSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  { 
		if(!disableMenuSounds) ClickSound();
		OptionSoundSelected--;
		if(OptionSoundSelected < 0)
			OptionSoundSelected = OptionSoundItems.size() - 1;
	}  

	if (g_Gamepads[DefaultController].fY2 > 0)  {
		if(OptionSoundSelected == 3) {
			BackgroundMusicVolume+=1;
			m_mp3player.adjust_volume(BackgroundMusicVolume);
			std::ostringstream temp;
			temp << BackgroundMusicVolume;
			std::string temp2 = temp.str();
			OptionSoundValueItems[3] = temp2.c_str();
			return;
		}
	}  
	
	if (g_Gamepads[DefaultController].fY2 < 0)  {
		if(OptionSoundSelected == 3) {
			BackgroundMusicVolume-=1;
			m_mp3player.adjust_volume(BackgroundMusicVolume);
			std::ostringstream temp;
			temp << BackgroundMusicVolume;
			std::string temp2 = temp.str();
			OptionSoundValueItems[3] = temp2.c_str();
			return;
		}
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
		ConfirmSound();
		if(OptionSoundSelected == 3) {
			BackgroundMusicVolume--;
			m_mp3player.adjust_volume(BackgroundMusicVolume);
			std::ostringstream temp;
			temp << BackgroundMusicVolume;
			std::string temp2 = temp.str();
			OptionSoundValueItems[3] = temp2.c_str();
			return;
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionSoundSelected == 0) {
			if(nAudSampleRate == 11025)
				nAudSampleRate = 22050;
			else if (nAudSampleRate == 22050)
				nAudSampleRate = 44100;
			else if (nAudSampleRate == 44100)
				nAudSampleRate = 48000;
			else
				nAudSampleRate = 11025;
			if(nAudSampleRate == 11025)
				OptionSoundValueItems[0] = "11025";
			if(nAudSampleRate == 22050)
				OptionSoundValueItems[0] = "22050";
			if(nAudSampleRate == 44100)
				OptionSoundValueItems[0] = "44100";
			if(nAudSampleRate == 48000)
				OptionSoundValueItems[0] = "48000";
			return;
		}
		if(OptionSoundSelected == 1) {
			nAudDSPModule++;
			if(nAudDSPModule > 1)
				nAudDSPModule = 0;
			if(nAudDSPModule == 0)
				OptionSoundValueItems[1] = "Off";
			else
				OptionSoundValueItems[1] = "On";
			return;
		}
		if(OptionSoundSelected == 2) {
			disableMenuSounds++;
			if(disableMenuSounds > 1)
				disableMenuSounds = 0;
			if(disableMenuSounds == 0)
				OptionSoundValueItems[2] = "False";
			else
				OptionSoundValueItems[2] = "True";
			return;
		}
		if(OptionSoundSelected == 3) {
			BackgroundMusicVolume++;
			m_mp3player.adjust_volume(BackgroundMusicVolume);
			std::ostringstream temp;
			temp << BackgroundMusicVolume;
			std::string temp2 = temp.str();
			OptionSoundValueItems[3] = temp2.c_str();
			return;
		}

		if(OptionSoundSelected == 4) {
			if(nInterpolation == 1)
				nInterpolation = 3;
			else
				nInterpolation = 1;
			if(nInterpolation == 1)
				OptionSoundValueItems[4] = "Linear";
			else
				OptionSoundValueItems[4] = "Cubic";
			return;
		}

		if(OptionSoundSelected == 5) {
			if(nFMInterpolation == 0)
				nFMInterpolation = 3;
			else
				nFMInterpolation = 0;
			if(nFMInterpolation == 0)
				OptionSoundValueItems[5] = "Disabled";
			else
				OptionSoundValueItems[5] = "Enabled";
			}
			return;
		}
}

void DrawOptionSoundItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionSoundSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionSoundMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionSoundItems.size(); i++) {
		DrawOptionSoundItem(i, (char*)OptionSoundItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionSoundItem(i, (char*)OptionSoundValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Device->Present(NULL,NULL,NULL,NULL);
}

void OptionEmulationSoundInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 1;
		//SetDelay();
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		if(!disableMenuSounds) ClickSound();
		OptionEmulationSoundSelected++;
		if(OptionEmulationSoundSelected > OptionEmulationSoundItems.size() - 1)
			OptionEmulationSoundSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		if(!disableMenuSounds) ClickSound();
		OptionEmulationSoundSelected--;
		if(OptionEmulationSoundSelected < 0)
			OptionEmulationSoundSelected = OptionEmulationSoundItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionEmulationSoundSelected == 0) {
			nAudDSPModule++;
			if(nAudDSPModule > 1)
				nAudDSPModule = 0;
			if(nAudDSPModule == 0)
				OptionEmulationSoundValueItems[0] = "Off";
			else
				OptionEmulationSoundValueItems[0] = "On";
		}
		if(OptionEmulationSoundSelected == 1) {
			disableMenuSounds++;
			if(disableMenuSounds > 1)
				disableMenuSounds = 0;
			if(disableMenuSounds == 0)
				OptionEmulationSoundValueItems[1] = "False";
			else
				OptionEmulationSoundValueItems[1] = "True";
		}
		if(OptionEmulationSoundSelected == 2) {
			if(nInterpolation == 1)
				nInterpolation = 3;
			else
				nInterpolation = 1;
			if(nInterpolation == 1)
				OptionEmulationSoundValueItems[2] = "Linear";
			else
				OptionEmulationSoundValueItems[2] = "Cubic";
			return;
		}

		if(OptionEmulationSoundSelected == 3) {
			if(nFMInterpolation == 0)
				nFMInterpolation = 3;
			else
				nFMInterpolation = 0;
			if(nFMInterpolation == 0)
				OptionEmulationSoundValueItems[3] = "Disabled";
			else
				OptionEmulationSoundValueItems[3] = "Enabled";
			return;
		}
	}
}

void DrawOptionEmulationSoundItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionEmulationSoundSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionEmulationSoundMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionEmulationSoundItems.size(); i++) {
		DrawOptionEmulationSoundItem(i, (char*)OptionEmulationSoundItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionEmulationSoundItem(i, (char*)OptionEmulationSoundValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Device->Present(NULL,NULL,NULL,NULL);
}

void OptionSoundMenu() {
	if(Emulation) {
		OptionEmulationSoundInput();
		DrawOptionEmulationSoundMenu();
	}
	else {
		OptionSoundInput();
		DrawOptionSoundMenu();
	}
}
