// FB Alpha - Emulator for MC68000/Z80 based arcade games
//            Refer to the "license.txt" file for more info

// Main module

#include "burner.h"
#include <xtl.h>
#include <string>
#include <vector>

using namespace std;
int CreateROMInfo();
int MediaInit();
int DrvInit(int nDrvNum, bool bRestore);
int RunMessageLoop();
long int nMainThreadID;
int nAppThreadPriority = 0;
int nAppShowCmd;
static TCHAR szCmdLine[1024] = _T("");
int nAppVirtualFps = 6000;			// App fps * 100
TCHAR szAppBurnVer[16] = _T("");
bool bCmdOptUsed = 0;
bool bAlwaysProcessKeyboardInput = false;
bool bNoChangeNumLock = 0;
static bool bNumlockStatus;
bool bMonitorAutoCheck = true;
#include <string>
TCHAR szChoice[260] = _T("");
extern bool OutOfMemory;
extern "C" int dprintf(char *format, ...);
extern void AudioInit();
extern int ConfigCheatLoad();
extern bool bCheatsAllowed;
extern int StatedAuto(int bSave);
extern bool PrintDip();
extern int DipEnabled;
extern std::string ConfigPath;
extern "C" int dprintf(char *format, ...);
extern unsigned short CPUSpeed;
extern void SaveGameIni(std::string e);
extern vector<string> GeneralOptionsValueSettings;

TCHAR* ANSIToTCHAR(const char* pszInString, TCHAR* pszOutString, int /*nOutSize*/)
{
	if (pszOutString) {
		_tcscpy(pszOutString, pszInString);
		return pszOutString;
	}

	return (TCHAR*)pszInString;
}

char* TCHARToANSI(const TCHAR* pszInString, char* pszOutString, int /*nOutSize*/)
{
	if (pszOutString) {
		strcpy(pszOutString, pszInString);
		return pszOutString;
	}

	return (char*)pszInString;
}

// Main program entry point
int SegaMain(std::string game) {
	//dprintf("SegaMain Start\n");
	OutOfMemory = false;
	bCheatsAllowed = true;
	//dprintf("BurnLibInit Start\n");
	BurnLibInit();
	//dprintf("ComputeGammaLUT Start\n");
	ComputeGammaLUT();
	unsigned int i;
	bool bFullscreen = 1;
	bCmdOptUsed = 1;
	//dprintf("Find Game.\n");
	for (i = 0; i < nBurnDrvCount; i++) {
		nBurnDrvSelect = i;
		if (_tcscmp(BurnDrvGetText(DRV_NAME), game.c_str()) == 0) {	
			if ((_tcscmp(game.c_str(), "asurabld") == 0) || 
				(_tcscmp(game.c_str(), "asurabus") == 0)) {	
					DipEnabled = 0;
					GeneralOptionsValueSettings[1] = "False";
					SaveGameIni(BurnDrvGetTextA(0));
			}
			//dprintf("AudioInit\n");
			AudioInit();
			if(!DipEnabled) {
				if ((_tcscmp(game.c_str(), "forgottn") != 0) && 
					(_tcscmp(game.c_str(), "forgottnu") != 0) &&
					(_tcscmp(game.c_str(), "lostwrld") != 0)) {	
					char fileName[260];
					sprintf(fileName, "%s%s%s.ini", ConfigPath.c_str(), "\\games\\", BurnDrvGetText(DRV_NAME));
					DeleteFile(fileName);
				}
			}
			DrvInit(i, true);
			if(BurnDrvGetHardwareCode() != HARDWARE_SEGA_MEGADRIVE) {
				if(DipEnabled) {
					if(!PrintDip()) {
						DipEnabled = 0;
						GeneralOptionsValueSettings[1] = "False";
						SaveGameIni(BurnDrvGetTextA(0));
					}
				}
			}
			//dprintf("ConfigCheatLoad Start\n");
			ConfigCheatLoad();
			//dprintf("ConfigCheatLoad End\n");
			//dprintf("MediaInit Start\n");
			MediaInit();
			//dprintf("MediaInit End\n");
			bCheatsAllowed = true;
			//dprintf("StatedAuto(0); Start\n");
			StatedAuto(0);
			break;
		}
	}
	//dprintf("SegaMain End\n");
	nBurnCPUSpeedAdjust = CPUSpeed;
	RunMessageLoop();
	return 0;
}
