
#include "burnint.h"

#define XBOX

#define MAX_DUMP	4				// maximum amount of dump files

int universal_vmm_enabled[MAX_DUMP] = { 0, 0, 0, 0 };	// makes sure that non-vmm games don't crash

static unsigned int maximum_data_number[MAX_DUMP];	// maximum allowable datas
static unsigned int maximum_memory_size[MAX_DUMP];	// How much ram can we use?
static unsigned int maximum_slot_used[MAX_DUMP];

static unsigned int DataRAMAvailable[MAX_DUMP];		// How much RAM is still available for use

static unsigned int retain_n_frames[MAX_DUMP];		// How many frames worth of data should be keep

struct DataInfo {
	unsigned int data_offset;			// offset to data in dumped data
	unsigned int data_size;				// size of the data
	unsigned char *ptr;				// pointer to malloc

	unsigned int last_frame;			// last frame used (how long ago)
};

static struct DataInfo *DataInfoStruct[MAX_DUMP];	// Structure
static struct DataInfo *datanfo;			// pointer to structure

#ifdef XBOX
#define dump_path	"Z:\\"
#else
#define dump_path	""
#endif

char dump_name[128];					// hold name for dump file
FILE *data_dump[MAX_DUMP];				// pointer to dump file

static int vmm_data_select;				// which data dump are we using

static unsigned int data_offset[MAX_DUMP];		// offset inside file
static unsigned int data_length[MAX_DUMP];		// length of file

static inline void universal_vmm_read_data(unsigned int size, unsigned int offset)
{
	// get everything ready
	datanfo->ptr = (unsigned char*)malloc(size);
	datanfo->data_size = size;
	datanfo->data_offset = offset;
	datanfo->last_frame = nCurrentFrame;

	// seek file and set data offset
	if (offset != data_offset[vmm_data_select])
	{
		int ofst = offset - data_offset[vmm_data_select];
		fseek (data_dump[vmm_data_select], ofst, SEEK_CUR);
	}

	data_offset[vmm_data_select] = offset + size;

	fread (datanfo->ptr, size, 1, data_dump[vmm_data_select]);

	if (offset + size >= data_length[vmm_data_select]) {
		rewind (data_dump[vmm_data_select]);
		data_offset[vmm_data_select] = 0;
	}

	DataRAMAvailable[vmm_data_select] -= datanfo->data_size;
}

unsigned char *universal_vmm_get_slot_pointer(int slot, int select)
{
	vmm_data_select = select;

	if (!universal_vmm_enabled[vmm_data_select]) return NULL;

	datanfo = &DataInfoStruct[vmm_data_select][slot];

	datanfo->last_frame = nCurrentFrame;

	return datanfo->ptr; // success
}

void universal_vmm_get_data_single(unsigned int offset, unsigned int size, int slot, int select)
{
	vmm_data_select = select;

	if (!universal_vmm_enabled[vmm_data_select]) return;

	datanfo = &DataInfoStruct[vmm_data_select][slot];

	datanfo->last_frame = nCurrentFrame;

	if (datanfo->ptr == NULL) {
		datanfo->data_size = size;
		datanfo->data_offset = offset;
		datanfo->ptr = (unsigned char*)malloc(size);
	} else {
		if (datanfo->data_size != size) {
			free (datanfo->ptr);
			datanfo->data_size = size;
			datanfo->data_offset = offset;
			datanfo->ptr = (unsigned char*)malloc(size);
		} else {
			if (datanfo->data_offset == offset) {
				return;
			} else {
				datanfo->data_size = size;
				datanfo->data_offset = offset;
			}
		}
	}

	// seek file and set data offset
	if (offset != data_offset[vmm_data_select])
	{
		int ofst = offset - data_offset[vmm_data_select];
		fseek (data_dump[vmm_data_select], ofst, SEEK_CUR);
	}

	fread (datanfo->ptr, size, 1, data_dump[vmm_data_select]);

	data_offset[vmm_data_select] = offset + size;

	if (offset + size >= data_length[vmm_data_select]) {
		rewind (data_dump[vmm_data_select]);
		data_offset[vmm_data_select] = 0;
	}

	DataRAMAvailable[vmm_data_select] -= datanfo->data_size;
}


// function to actually read & free any necessary data
unsigned char *universal_vmm_get_data(unsigned int offset, unsigned int size, int select)
{
	// offset
	//	is most drawing routines offset is data_no * size_of_data
	//
	// size
	//	size is generally easy to find out, if a sprite is 16x16 pixels
	//	it will usually be 16 * 16 (256) bytes
	//
	// select
	//	chooses which dump we will be using at this point
	//

	vmm_data_select = select;

	if (!universal_vmm_enabled[vmm_data_select]) return NULL;

	// first, check to see if we even need to bother reading this or not
	if ((offset + size) > data_length[vmm_data_select] || !size)
	{
		return NULL; // failure
	}

	int struct_ofst = -1;

	unsigned int retain = nCurrentFrame - retain_n_frames[vmm_data_select];

	datanfo = &DataInfoStruct[vmm_data_select][0];

	// check if this size/offset is already available in struct
	// if the offset is there, but the size is too small, 
	// also see if we can find an empty slot
	for (unsigned int i = 0; i < maximum_slot_used[vmm_data_select]+1; i++)
	{
		if (datanfo->ptr)
		{
			if (datanfo->data_offset == offset)
			{
				if (datanfo->data_size < size) {
					free (datanfo->ptr);
					datanfo->ptr = NULL;
					DataRAMAvailable[vmm_data_select] += datanfo->data_size;

					universal_vmm_read_data(size, offset);
				}

				datanfo->last_frame = nCurrentFrame;

				if (maximum_slot_used[vmm_data_select] < (i+1)) {
					maximum_slot_used[vmm_data_select] = i+1;
					if ((maximum_slot_used[vmm_data_select]+1) > maximum_data_number[vmm_data_select]) {
						maximum_slot_used[vmm_data_select] = maximum_data_number[vmm_data_select];
					}
				}

				return datanfo->ptr; // success
			}

			// this hasn't been used in 'n' frames, free it
			if (datanfo->last_frame <= retain) {
				free (datanfo->ptr);
				datanfo->ptr = NULL;
	
				DataRAMAvailable[vmm_data_select] += datanfo->data_size;
			}
		}

		if (datanfo->ptr == NULL) {
			if (struct_ofst < 0) struct_ofst = i;
		}

		datanfo++;
	}

	// it's not already in the struct

	// check to see if we need to free up some ram
	if (DataRAMAvailable[vmm_data_select] < size || struct_ofst < 0)
	{
		datanfo = &DataInfoStruct[vmm_data_select][0];
		int t = retain_n_frames[vmm_data_select] - 1;

		for (unsigned int i = t; i > 0; i--)
		{
			retain = nCurrentFrame - i;

			for (unsigned int j = 0; j < maximum_slot_used[vmm_data_select]+1; j++)
			{
				if (datanfo->ptr)
				{
					// this hasn't been used in 'n' frames, free it
					if (datanfo->last_frame <= retain) {
						free (datanfo->ptr);
						datanfo->ptr = NULL;
	
						DataRAMAvailable[vmm_data_select] += datanfo->data_size;
						if (struct_ofst < 0) struct_ofst = j;
					}
				}
			}

			if (DataRAMAvailable[vmm_data_select] > size && struct_ofst != -1) break;
		}
	}

	// we're ready to start the process of putting the data into ram

	if (struct_ofst < 0) {
		return NULL; // failure
	} else {
		datanfo = &DataInfoStruct[vmm_data_select][struct_ofst];
	}

	if ((int)maximum_slot_used[vmm_data_select] < (struct_ofst+1)) {
		maximum_slot_used[vmm_data_select] = struct_ofst+1;

		if ((maximum_slot_used[vmm_data_select]+1) > maximum_data_number[vmm_data_select]) {
			maximum_slot_used[vmm_data_select] = maximum_data_number[vmm_data_select];
		}
	}

	universal_vmm_read_data(size, offset);

	return datanfo->ptr; // success
}


static int universal_vmm_init(int select, int maximum_mem, int maximum_data, int retain)
{
	vmm_data_select = select;

	DataInfoStruct[vmm_data_select] = (DataInfo*)malloc((maximum_data + 1) * sizeof (DataInfo));
	if (DataInfoStruct[vmm_data_select] == NULL) {
		return 1;
	}

	maximum_data_number[vmm_data_select]	= maximum_data;

	{
		datanfo = &DataInfoStruct[vmm_data_select][0];

		for (unsigned int j = 0; j < maximum_data_number[vmm_data_select]; j++) {
			datanfo->ptr = NULL;
			datanfo->data_offset = 0xfffffff;
			datanfo->last_frame = 0;
			datanfo->data_size = 0;
			datanfo++;
		}
	}

	if (maximum_mem <= 0) return 1;

	datanfo = &DataInfoStruct[vmm_data_select][0];
	maximum_memory_size[vmm_data_select]	= maximum_mem;
	DataRAMAvailable[vmm_data_select]	= maximum_memory_size[vmm_data_select];
	DataRAMAvailable[vmm_data_select]	-= maximum_data * sizeof (DataInfo);
	maximum_slot_used[vmm_data_select]	= 0;

	retain_n_frames[vmm_data_select]	= retain;
	data_offset[vmm_data_select]		= 0;

	universal_vmm_enabled[vmm_data_select] = 1;

	vmm_data_select = 0;

	return 0;
}

int UniversalVMMInitBlockStart(int select, int maximum_mem, int maximum_data, int retain)
{
	vmm_data_select = select;

	sprintf (dump_name, "%sDATA_DUMP%d.BIN", dump_path, vmm_data_select);

	data_dump[vmm_data_select] = fopen(dump_name, "wb");

	data_length[vmm_data_select] = 0;

	return universal_vmm_init(select, maximum_mem, maximum_data, retain);
}

int UniversalVMMInitBlockAdd(unsigned char *data, int select, int len)
{
	vmm_data_select = select;

	fwrite (data, len, 1, data_dump[vmm_data_select]);
	fflush (data_dump[vmm_data_select]);

	data_length[vmm_data_select] += len;

	return 0;
}

int UniversalVMMInitBlockFinish(int select)
{
	vmm_data_select = select;

	fclose (data_dump[vmm_data_select]);

	sprintf (dump_name, "%sDATA_DUMP%d.BIN", dump_path, vmm_data_select);

	data_dump[vmm_data_select] = fopen(dump_name, "rb");

	return 0;
}

// Dump the data to the hdd and initialize variables
int UniversalVMMInit(unsigned char *data, int select, int len, int maximum_mem, int maximum_data, int retain)
{
	// *data
	//	the pointer to the data we intend to use for the data dumping
	//
	// select
	//	chooses which dump we will be using at this point
	//
	// len
	//	the length of the data
	//
	// maximum_mem
	//	the maximum amount of memory (RAM) we will allow our data to use
	//	if memory use meets or exceeds this, memory will be freed depending on size and time (in frames)
	//	since it was last used.  maximum_mem also includes memory taken up by structure that contains
	// 	sizes, pointers, and age -- this is 16 * maximum_data
	//
	// maximum_data
	//	the maximum number of structures to allocate (maximum allowable datas)
	//	setting a high value for this speeds things up, but causes the structure to become larger
	//	and reduces the useable amount of RAM
	//
	// retain
	//	how many frames a data must go unused before it is freed 
	//	lower numbers reduce the amount of ram used, but decrease speed greatly
	//

	vmm_data_select = select;

	// catch silly mistakes
	if (data == NULL || len <= 0) {
		return 1;
	}

	sprintf (dump_name, "%sDATA_DUMP%d.BIN", dump_path, vmm_data_select);

	data_dump[vmm_data_select] = fopen(dump_name, "wb+");
	fwrite (data, len, 1, data_dump[vmm_data_select]);
	fclose (data_dump[vmm_data_select]);

	data_dump[vmm_data_select] = fopen(dump_name, "rb");

	data_length[vmm_data_select] = len;

	return universal_vmm_init(select, maximum_mem, maximum_data, retain);
}


// remove the dump file, free any used ram, and set vars to NULL
int UniversalVMMExit()
{
	for (int i = 0; i < MAX_DUMP; i++) {
		if (!universal_vmm_enabled[i]) continue;

		if (data_dump[i] != NULL) {
			fclose (data_dump[i]);
			sprintf (dump_name, "%sDATA_DUMP%d.BIN", dump_path, i);
			remove (dump_name);
			data_dump[i] = NULL;
		}

		datanfo = &DataInfoStruct[i][0];

		for (unsigned int j = 0; j < maximum_data_number[i]; j++) {
			if (datanfo->ptr != NULL) {
				free (datanfo->ptr);
			}
			datanfo->ptr = NULL;
			datanfo++;
		}

		free (DataInfoStruct[i]);
		DataInfoStruct[i] = NULL;

		vmm_data_select			= 0;
		universal_vmm_enabled[i]	= 0;
		maximum_data_number[i]		= 0;
		maximum_memory_size[i]		= 0;
		DataRAMAvailable[i]		= 0;
		data_length[i]			= 0;
		data_offset[i]			= 0;
		retain_n_frames[i]		= 0;
		maximum_slot_used[i]		= 0;
	}

	datanfo = NULL;

	return 0;
}

