#include "GlobalExtern.h"
#include "burn.h"

const float PI = 3.14159265358979323846f;

void CreateSaveDirectory(string game, int e) {
	string t = "\\Slot0";
	if(e == 0) t[5] = '0';
	if(e == 1) t[5] = '1';
	if(e == 2) t[5] = '2';
	if(e == 3) t[5] = '3';
	if(e == 4) t[5] = '4';
	if(e == 5) t[5] = '5';
	if(e == 6) t[5] = '6';
	if(e == 7) t[5] = '7';
	if(e == 8) t[5] = '8';
	if(e == 9) t[5] = '9';
	char dir[260];
	sprintf(dir,"%s%s%s%s", SaveStatePath.c_str(), "\\", game.c_str(), t.c_str());
	//////////dprintf("Dir: %s\n", dir);
	mkdir(dir);
}
void CreateDirectories(string game) {
	char dir[260];
	sprintf(dir,"%s%s%s", SaveStatePath.c_str(), "\\", game.c_str());
	//////////dprintf("Dir: %s\n", dir);
	mkdir(dir);
	for(int i = 0; i < 10; i++) {
		CreateSaveDirectory(game, i);
	}
}

void SaveStateInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 1;
		
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		SaveSlotSelected++;
		if(SaveSlotSelected > SaveStateItems.size() - 1)
			SaveSlotSelected = 0;
		if(TexPreview) {
			TexPreview->Release();
			TexPreview = NULL;
		}
		char fileName[260];
		sprintf(fileName,"%s%s%s%s%d%s%s%s", SaveStatePath.c_str(), "\\", BurnDrvGetTextA(0), "\\Slot", SaveSlotSelected, "\\", BurnDrvGetTextA(0), ".png");
		D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
			D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
			D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		SaveSlotSelected--;
		if(SaveSlotSelected < 0)
			SaveSlotSelected = SaveStateItems.size() - 1;
		if(TexPreview) {
			TexPreview->Release();
			TexPreview = NULL;
		}
		char fileName[260];
		sprintf(fileName,"%s%s%s%s%d%s%s%s", SaveStatePath.c_str(), "\\", BurnDrvGetTextA(0), "\\Slot", SaveSlotSelected, "\\", BurnDrvGetTextA(0), ".png");
		D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
			D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
			D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		GUIState = 1;
		
		if (_tcscmp(BurnDrvGetText(DRV_SYSTEM), "Neo Geo") != 0) {	
			char fileName1[260];
			char fileName2[260];
			sprintf(fileName1,"%s%s%s%s%d%s%s.fs", SaveStatePath.c_str(), "\\", BurnDrvGetTextA(0), "\\Slot", SaveSlotSelected, "\\", BurnDrvGetTextA(0));
			//////////dprintf("SaveState 1: %s\n", fileName1);
			sprintf(fileName2,"%s%s%s%s%d%s%s%s", SaveStatePath.c_str(), "\\", BurnDrvGetTextA(0), "\\Slot", SaveSlotSelected, "\\", BurnDrvGetTextA(0), ".png");
			MakeScreenShot(fileName2);
			//////////dprintf("SaveState 2: %s\n", fileName2);
			BurnStateSave(fileName1, 1);
			SaveGameIni(BurnDrvGetTextA(0));
		}
		exitGameMenu = true;
		DxSoundPlay();
		
	}
}

void LoadStateInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 1;
		
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		SaveSlotSelected++;
		if(SaveSlotSelected > LoadStateItems.size() - 1)
			SaveSlotSelected = 0;

		if(TexPreview) {
			TexPreview->Release();
			TexPreview = NULL;
		}

		char fileName[260];
		sprintf(fileName,"%s%s%s%s%d%s%s%s", SaveStatePath.c_str(), "\\", BurnDrvGetTextA(0), "\\Slot", SaveSlotSelected, "\\", BurnDrvGetTextA(0), ".png");
		D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
			D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
			D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		SaveSlotSelected--;
		if(SaveSlotSelected < 0)
			SaveSlotSelected = LoadStateItems.size() - 1;
		if(TexPreview) {
			TexPreview->Release();
			TexPreview = NULL;
		}
		char fileName[260];
		sprintf(fileName,"%s%s%s%s%d%s%s%s", SaveStatePath.c_str(), "\\", BurnDrvGetTextA(0), "\\Slot", SaveSlotSelected, "\\", BurnDrvGetTextA(0), ".png");
		D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
			D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
			D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		GUIState = 1;
		if (_tcscmp(BurnDrvGetText(DRV_SYSTEM), "Neo Geo") != 0) {	
			char fileName[260];
			sprintf(fileName,"%s%s%s%s%d%s%s.fs", SaveStatePath.c_str(), "\\", BurnDrvGetTextA(0), "\\Slot", SaveSlotSelected, "\\", BurnDrvGetTextA(0));
			
			//////////dprintf("Load State: %s\n", fileName);

			//////////dprintf("Before BurnStateLoad\n");
			BurnStateLoad(fileName, 1, NULL);
			//////////dprintf("After BurnStateLoad\n");
			SaveGameIni(BurnDrvGetTextA(0));
		}
		exitGameMenu = true;
		DxSoundPlay();
		
	}
}

void DrawLoadStateItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(SaveSlotSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawSaveStateItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(SaveSlotSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawSaveStateMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	SetupMatrices();
	DrawBackground();
	if(TexPreview) {
		Device->SetTexture(0,TexPreview);
		//exitEmulation = true;
		MakeVertexListExitGame();
		//exitEmulation = false;
		D3DXMATRIX q;
		D3DXMatrixRotationZ(&q, RotationDegrees * (PI/180));
		Device->SetTransform(D3DTS_WORLD, &q);
		Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	}
	for(int i = 0; i < SaveStateItems.size(); i++) {
		DrawSaveStateItem(i, (char*)SaveStateItems[i].c_str(), GameOptionPosX, GameOptionPosY + (i * vSpace));
	}
	Present();
}

void OptionSaveStateMenu() {
	SaveStateInput();
	DrawSaveStateMenu();
}

void OptionLoadStateMenu() {
	LoadStateInput();
	DrawSaveStateMenu();
}
