#include "GlobalExtern.h"

struct Turbo { 
	int turboA;
	int turboB;
	int turboX;
	int turboY;
	int turboLeft;
	int turboRight;
	int turboBlack;
	int turboWhite;
}; 
Turbo tButtons[4];

void ControllerInit() {
	for(int i = 0; i < 4; i++) {
		tButtons[i].turboA = 0;
		tButtons[i].turboB = 0;
		tButtons[i].turboX = 0;
		tButtons[i].turboY = 0;
		tButtons[i].turboLeft = 0;
		tButtons[i].turboRight = 0;
		tButtons[i].turboBlack = 0;
		tButtons[i].turboWhite = 0;
	}
}

void UpdateTurboButtons() {
	if(OptionControllerTurboSelected == 0) {turboControllerSelected++; if(turboControllerSelected > 3) turboControllerSelected = 0;}
	if(OptionControllerTurboSelected == 1) {tButtons[turboControllerSelected].turboA++; tButtons[turboControllerSelected].turboA &= 1; }
	if(OptionControllerTurboSelected == 2) {tButtons[turboControllerSelected].turboB++; tButtons[turboControllerSelected].turboB &= 1; }
	if(OptionControllerTurboSelected == 3) {tButtons[turboControllerSelected].turboX++; tButtons[turboControllerSelected].turboX &= 1; }
	if(OptionControllerTurboSelected == 4) {tButtons[turboControllerSelected].turboY++; tButtons[turboControllerSelected].turboY &= 1; }
	if(OptionControllerTurboSelected == 5) {tButtons[turboControllerSelected].turboLeft++; tButtons[turboControllerSelected].turboLeft &= 1; }
	if(OptionControllerTurboSelected == 6) {tButtons[turboControllerSelected].turboRight++; tButtons[turboControllerSelected].turboRight &= 1; }
	if(OptionControllerTurboSelected == 7) {tButtons[turboControllerSelected].turboBlack++; tButtons[turboControllerSelected].turboBlack &= 1; }
	if(OptionControllerTurboSelected == 8) {tButtons[turboControllerSelected].turboWhite++; tButtons[turboControllerSelected].turboWhite &= 1; }
	if(OptionControllerTurboSelected == 9) {turboSpeed++; if(turboSpeed > 100) turboSpeed = 1;}
	UpdateTurboDescriptions();	
}

void DrawOptionControllerTurboItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionControllerTurboSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionControllerTurboMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();

	for(int i = 0; i < OptionControllerTurboItems.size(); i++) {
		DrawOptionControllerTurboItem(i, (char*)OptionControllerTurboItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionControllerTurboItem(i, (char*)OptionControllerTurboValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();
}

std::string GetButtonName(int q) {
	if(q == -1) return "Not Assigned";
	if(q == 0) return "Xbox A";
	if(q == 1) return "Xbox B";
	if(q == 2) return "Xbox X";
	if(q == 3) return "Xbox Y";
	if(q == 4) return "Xbox Black";
	if(q == 5) return "Xbox White";
	if(q == 6) return "Xbox Left Trigger";
	if(q == 7) return "Xbox Right Trigger";
	if(q == 8) return "Xbox Back";
	if(q == 9) return "Xbox Start";
	return "";
}

void UpdateButtonDescriptions() {
	dprintf("UpdateButtonDescriptions Start\n");
	for(int q = 0; q < 4; q++) {
		for(int i =0; i < controllers[q].buttons.size(); i++) {
			(OptionControllerButtonValueItems[q])[i] = GetButtonName(controllers[q].buttons[i].ControllerButton);
		}
	}
	dprintf("UpdateButtonDescriptions End\n");
}

void SaveControllerIni() {
	dprintf("SaveControllerIni Start\n");
	FILE* f;
	char fileName[260];
	sprintf(fileName,"%s%s%s%s", IniPath.c_str(), "\\controller\\", BurnDrvGetTextA(0), ".ini");
	f = fopen(fileName , "w+");
	if(!f) {
		dprintf("SaveControllerIni Error\n");
		dprintf("Error opening %s\n", fileName);
		LD_LAUNCH_DASHBOARD launch;
		memset(&launch,0,sizeof(launch));
		launch.dwReason=XLD_LAUNCH_DASHBOARD_MAIN_MENU;
		XLaunchNewImage(NULL,(LAUNCH_DATA *)&launch);
	}
	for(int q = 0; q < 4; q++) {
		for(int i =0; i < controllers[q].buttons.size(); i++) {
			fprintf(f, "Controller %d Button %d=%d\n", q + 1, i + 1, controllers[q].buttons[i].ControllerButton);
		}
	}
	for(int q = 0; q < 4; q++) {
		fprintf(f, "Controller %d Button A=%d\n", q + 1, tButtons[q].turboA);
		fprintf(f, "Controller %d Button B=%d\n", q + 1, tButtons[q].turboB);
		fprintf(f, "Controller %d Button X=%d\n", q + 1, tButtons[q].turboX);
		fprintf(f, "Controller %d Button Y=%d\n", q + 1, tButtons[q].turboY);
		fprintf(f, "Controller %d Button Left=%d\n", q + 1, tButtons[q].turboLeft);
		fprintf(f, "Controller %d Button Right=%d\n", q + 1, tButtons[q].turboRight);
		fprintf(f, "Controller %d Button Black=%d\n", q + 1, tButtons[q].turboBlack);
		fprintf(f, "Controller %d Button White=%d\n", q + 1, tButtons[q].turboWhite);
	}
	fprintf(f, "Turbo=%d\n", turboSpeed);
	for(int q = 0; q < 4; q++) {
		int Count = 0;
		for(int w = 0; w < MacroSet[q].size(); w++) {
			if(MacroSet[q][w].enabled)
				Count++;
		}
		fprintf(f, "Macro Count=%d\n", Count);
		for(int n = 0; n < MacroSet[q].size(); n++) {
			if(MacroSet[q][n].enabled) {
				fprintf(f, "Macro Number=%d\n", n);
				fprintf(f, "Control=%d\n", MacroSet[q][n].buttonSet);
			}
		}
	}
	fclose(f);
	dprintf("SaveControllerIni End\n");
}

void ButtonUpdate(int q, int button) {
	controllers[q].buttons[button].ControllerButton++;
	if(controllers[q].buttons[button].ControllerButton > 9)
		controllers[q].buttons[button].ControllerButton = -1;
	(OptionControllerButtonValueItems[q])[button] = GetButtonName(controllers[q].buttons[button].ControllerButton);
	SaveControllerIni();
}

void LoadMacro() {
	std::vector<std::string> macro[4];
	for(int z = 0; z < 4; z++) {
		std::ifstream f;
		if(z == 0) f.open("D:\\info\\macro1.ini");
		if(z == 1) f.open("D:\\info\\macro2.ini");
		if(z == 2) f.open("D:\\info\\macro3.ini");
		if(z == 3) f.open("D:\\info\\macro4.ini");

		while(!f.eof()) {
			char line[2048];
			for(int i = 0; i < 2048; i++) line[i] = '\0';
			f.getline(line, 2048);
			std::string t = line;
			if(t.find(" + ", 0) != -1)
				macro[z].push_back(t);
		}
		f.close();

		for(int i = 0; i < macro[z].size(); i++) {
			Macro m;
			m.enabled = false;
			m.buttonSet = 7;
			m.desc = macro[z][i];
			if(macro[z][i].find("A", 0) != -1) { m.buttons.push_back(0); }
			if(macro[z][i].find("Y", 0) != -1) { m.buttons.push_back(3); }
			if(macro[z][i].find("X", 0) != -1) { m.buttons.push_back(2); }
			if(macro[z][i].find("B", 0) != -1) { m.buttons.push_back(1); }
			if(macro[z][i].find("CK", 0) != -1) { m.buttons.push_back(4); }
			if(macro[z][i].find("WT", 0) != -1) { m.buttons.push_back(5); }
			if(macro[z][i].find("LT", 0) != -1) { m.buttons.push_back(6); }
			if(macro[z][i].find("RT", 0) != -1) { m.buttons.push_back(7); }
			MacroSet[z].push_back(m);
		}
	}
}

void SetupControllers() {
	LoadMacro();
	for (unsigned int i = 0; i < nGameInpCount; i++) {
		if((GameInp + i)->nInput == GIT_KEYSLIDER) {
			Button q;
			q.code = (GameInp + i)->Input.Switch.nCode;
			if(q.code == 0x2F) {
				q.name = InputNumToName(i);
				q.name += " Up";
				q.ControllerButton = controller1Count;
				controller1Count++;
				q.ControllerButton &= 0x07;
				OptionControllerButtonItems[0].push_back(q.name);
				OptionControllerButtonValueItems[0].push_back(GetButtonName(q.ControllerButton));
				controllers[0].buttons.push_back(q);

				q.name = InputNumToName(i);
				q.name += " Down";
				q.code = 0x21;
				q.ControllerButton = controller1Count;
				controller1Count++;
				q.ControllerButton &= 0x07;
				OptionControllerButtonItems[0].push_back(q.name);
				OptionControllerButtonValueItems[0].push_back(GetButtonName(q.ControllerButton));
				controllers[0].buttons.push_back(q);
			}

			if(q.code == 0x3F) {
				q.name = InputNumToName(i);
				q.name += " Up";
				q.ControllerButton = controller2Count;
				controller2Count++;
				q.ControllerButton &= 0x07;
				OptionControllerButtonItems[1].push_back(q.name);
				OptionControllerButtonValueItems[1].push_back(GetButtonName(q.ControllerButton));
				controllers[1].buttons.push_back(q);

				q.name = InputNumToName(i);
				q.name += " Down";
				q.code = 0x31;
				q.ControllerButton = controller2Count;
				controller2Count++;
				q.ControllerButton &= 0x07;
				OptionControllerButtonItems[1].push_back(q.name);
				OptionControllerButtonValueItems[1].push_back(GetButtonName(q.ControllerButton));
				controllers[1].buttons.push_back(q);
			}
		}

		if((GameInp + i)->nInput == GIT_SWITCH) {
			Button q;
			q.name = InputNumToName(i);
			q.code = (GameInp + i)->Input.Switch.nCode;
			dprintf("Setting: %s\n", q.name.c_str());
			if((q.name.find("Diagnostic", 0) != std::string::npos) ||
				(q.name.find("Test", 0) != std::string::npos) ||
				(q.name.find("System", 0) != std::string::npos) ||
				(q.name.find("Dip", 0) != std::string::npos) ||
				(q.name.find("Slots", 0) != std::string::npos) ||
				(q.name.find("Debug", 0) != std::string::npos) ||
				(q.name.find("Tilt", 0) != std::string::npos) ||
				(q.name.find("Service", 0) != std::string::npos) ||
				(q.name.find("Select", 0) != std::string::npos)) {
					ArcadeSetting e;
					e.name = q.name;
					e.code = q.code;
					e.count = 0;
					arcadeSettings.push_back(e);
					dprintf("Arcade Setting: %s\n", q.name.c_str());
			}
			else {
				if((q.name.find("Up", 0) == std::string::npos) &&
					(q.name.find("Down", 0) == std::string::npos) &&
					(q.name.find("Left", 0) == std::string::npos) &&
					(q.name.find("Reset", 0) == std::string::npos) &&
					(q.name.find("Right", 0) == std::string::npos)) {
						dprintf("Controller 1 - 4: %s\n", q.name.c_str());
						if(q.name[1] == '1' || 
							(q.name.find("P1", 0) == std::string::npos &&
							q.name.find("P2", 0) == std::string::npos &&
							q.name.find("P3", 0) == std::string::npos &&
							q.name.find("P4", 0) == std::string::npos && 
							q.name.find("Coin 2", 0) == std::string::npos &&
							q.name.find("Coin 3", 0) == std::string::npos &&
							q.name.find("Coin 4", 0) == std::string::npos &&
							q.name.find("Start 2", 0) == std::string::npos &&
							q.name.find("Start 3", 0) == std::string::npos &&
							q.name.find("Start 4", 0) == std::string::npos) ||
							(q.name.find("Coin 1", 0) != std::string::npos) ||
							(q.name.find("Start 1", 0) != std::string::npos)) {
								if(q.code == 0x06) { //P1 Coin
									q.ControllerButton = 8;
								}
								else if(q.code == 0x02) { //P1 Start
									q.ControllerButton = 9;
								}
								else {
									q.ControllerButton = controller1Count;
									controller1Count++;
									q.ControllerButton &= 0x07;
								}
								OptionControllerButtonItems[0].push_back(q.name);
								OptionControllerButtonValueItems[0].push_back(GetButtonName(q.ControllerButton));
								controllers[0].buttons.push_back(q);
						}
						if(q.name[1] == '2' || 
							(q.name.find("Coin 2", 0) != std::string::npos) ||
							(q.name.find("Start 2", 0) != std::string::npos)) {
								if(q.code == 0x07) { //P2 Coin
									q.ControllerButton = 8;
								}
								else if(q.code == 0x03) { //P2 Start
									q.ControllerButton = 9;
								}
								else {
									q.ControllerButton = controller2Count;
									controller2Count++;
									q.ControllerButton &= 0x07;
								}
								OptionControllerButtonItems[1].push_back(q.name);
								OptionControllerButtonValueItems[1].push_back(GetButtonName(q.ControllerButton));
								controllers[1].buttons.push_back(q);
						}
						if(q.name[1] == '3' || 
							(q.name.find("Coin 3", 0) != std::string::npos) ||
							(q.name.find("Start 3", 0) != std::string::npos)) {
								if(q.code == 0x08) { //P3 Coin
									q.ControllerButton = 8;
								}
								else if(q.code == 0x04) { //P3 Start
									q.ControllerButton = 9;
								}
								else {
									q.ControllerButton = controller3Count;
									controller3Count++;
									q.ControllerButton &= 0x07;
								}
								OptionControllerButtonItems[2].push_back(q.name);
								OptionControllerButtonValueItems[2].push_back(GetButtonName(q.ControllerButton));
								controllers[2].buttons.push_back(q);
						}
						if(q.name[1] == '4' || 
							(q.name.find("Coin 4", 0) != std::string::npos) ||
							(q.name.find("Start 4", 0) != std::string::npos)) {
								if(q.code == 0x09) { //P4 Coin
									q.ControllerButton = 8;
								}
								else if(q.code == 0x05) { //P4 Start
									q.ControllerButton = 9;
								}
								else {
									q.ControllerButton = controller4Count;
									controller4Count++;
									q.ControllerButton &= 0x07;
								}
								OptionControllerButtonItems[3].push_back(q.name);
								OptionControllerButtonValueItems[3].push_back(GetButtonName(q.ControllerButton));
								controllers[3].buttons.push_back(q);
						}
				}
			}
		}
	}
}

void UpdateTurboDescriptions() {
	OptionControllerTurboValueItems[1] = "Off";
	OptionControllerTurboValueItems[2] = "Off";
	OptionControllerTurboValueItems[3] = "Off";
	OptionControllerTurboValueItems[4] = "Off";
	OptionControllerTurboValueItems[5] = "Off";
	OptionControllerTurboValueItems[6] = "Off";
	OptionControllerTurboValueItems[7] = "Off";
	OptionControllerTurboValueItems[8] = "Off";
	if(turboControllerSelected == 0)
		OptionControllerTurboValueItems[0] = "1";
	if(turboControllerSelected == 1)
		OptionControllerTurboValueItems[0] = "2";
	if(turboControllerSelected == 2)
		OptionControllerTurboValueItems[0] = "3";
	if(turboControllerSelected == 3)
		OptionControllerTurboValueItems[0] = "4";
	if(tButtons[turboControllerSelected].turboA)
		OptionControllerTurboValueItems[1] = "On";
	if(tButtons[turboControllerSelected].turboB)
		OptionControllerTurboValueItems[2] = "On";
	if(tButtons[turboControllerSelected].turboX)
		OptionControllerTurboValueItems[3] = "On";
	if(tButtons[turboControllerSelected].turboY)
		OptionControllerTurboValueItems[4] = "On";
	if(tButtons[turboControllerSelected].turboLeft)
		OptionControllerTurboValueItems[5] = "On";
	if(tButtons[turboControllerSelected].turboRight)
		OptionControllerTurboValueItems[6] = "On";
	if(tButtons[turboControllerSelected].turboBlack)
		OptionControllerTurboValueItems[7] = "On";
	if(tButtons[turboControllerSelected].turboWhite)
		OptionControllerTurboValueItems[8] = "On";
	OptionControllerTurboValueItems[9] = ConvertIntToString(turboSpeed);
	SaveControllerIni();
}

void LoadControllerIni() {
	dprintf("LoadControllerIni Start\n");
	SetupControllers();
	FILE* f;
	char fileName[260];
	sprintf(fileName,"%s%s%s%s", IniPath.c_str(), "\\controller\\", BurnDrvGetTextA(0), ".ini");
	dprintf("File: %s\n", fileName);
	f = fopen(fileName , "r");
	if(f) {
		dprintf("Found controller ini\n");
		for(int q = 0; q < 4; q++) {
			for(int i =0; i < controllers[q].buttons.size(); i++) {
				controllers[q].buttons[i].ControllerButton = GetFileInteger(f);
			}
		}
		UpdateButtonDescriptions();
		//dprintf("Turbo Start\n");
		for(int e = 0; e < 4; e++) {
			//dprintf("Reading Controller: %d\n", e + 1);
			tButtons[e].turboA = GetFileInteger(f);
			tButtons[e].turboB = GetFileInteger(f);
			tButtons[e].turboX = GetFileInteger(f);
			tButtons[e].turboY = GetFileInteger(f);
			tButtons[e].turboLeft = GetFileInteger(f);
			tButtons[e].turboRight = GetFileInteger(f);
			tButtons[e].turboBlack = GetFileInteger(f);
			tButtons[e].turboWhite = GetFileInteger(f);
		}

		OptionControllerTurboValueItems[1] = "Off";
		OptionControllerTurboValueItems[2] = "Off";
		OptionControllerTurboValueItems[3] = "Off";
		OptionControllerTurboValueItems[4] = "Off";
		OptionControllerTurboValueItems[5] = "Off";
		OptionControllerTurboValueItems[6] = "Off";
		OptionControllerTurboValueItems[7] = "Off";
		OptionControllerTurboValueItems[8] = "Off";
		if(turboControllerSelected == 0)
			OptionControllerTurboValueItems[0] = "1";
		if(turboControllerSelected == 1)
			OptionControllerTurboValueItems[0] = "2";
		if(turboControllerSelected == 2)
			OptionControllerTurboValueItems[0] = "3";
		if(turboControllerSelected == 3)
			OptionControllerTurboValueItems[0] = "4";
		if(tButtons[turboControllerSelected].turboA)
			OptionControllerTurboValueItems[1] = "On";
		if(tButtons[turboControllerSelected].turboB)
			OptionControllerTurboValueItems[2] = "On";
		if(tButtons[turboControllerSelected].turboX)
			OptionControllerTurboValueItems[3] = "On";
		if(tButtons[turboControllerSelected].turboY)
			OptionControllerTurboValueItems[4] = "On";
		if(tButtons[turboControllerSelected].turboLeft)
			OptionControllerTurboValueItems[5] = "On";
		if(tButtons[turboControllerSelected].turboRight)
			OptionControllerTurboValueItems[6] = "On";
		if(tButtons[turboControllerSelected].turboBlack)
			OptionControllerTurboValueItems[7] = "On";
		if(tButtons[turboControllerSelected].turboWhite)
			OptionControllerTurboValueItems[8] = "On";
		turboSpeed = GetFileInteger(f);
		for(int q = 0; q < 4; q++) {
			int Count = GetFileInteger(f);
			for(int w = 0; w < Count; w++) {
				int n = GetFileInteger(f);
				int Control = GetFileInteger(f);
				if(n < MacroSet[q].size()) {
					MacroSet[q][n].enabled = true;
					MacroSet[q][n].buttonSet = Control;
				}
			}
		}
		fclose(f);
		//dprintf("Turbo End\n");
	}
	else {
		dprintf("Error controller ini\n");
		SaveControllerIni();
	}
	dprintf("LoadControllerIni End\n");
}

bool OptionControllerInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		//SetDelay();
		return false;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		OptionControllerSelected++;
		if(OptionControllerSelected > OptionControllerItems.size() - 1)
			OptionControllerSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		OptionControllerSelected--;
		if(OptionControllerSelected < 0)
			OptionControllerSelected = OptionControllerItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		OptionControllerButtonSelected = 0;
		while(1) {
			updateEffect();
			if(!OptionControllerButtonInput())
				break;
			DrawOptionControllerButtonMenu();
		}
	}
	return true;
}

bool OptionControllerMacroInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		//SetDelay();
		return false;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		OptionControllerMacroSelected++;
		if(OptionControllerMacroSelected > OptionControllerMacroItems.size() - 1)
			OptionControllerMacroSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		OptionControllerMacroSelected--;
		if(OptionControllerMacroSelected < 0)
			OptionControllerMacroSelected = OptionControllerMacroItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		MacroSelected = 0;
		while(1) {
			updateEffect();
			if(!OptionMacroInput())
				break;
			DrawMacroMenu();
		}
	}
	return true;
}

void DrawOptionControllerItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionControllerSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontCenteredText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionControllerMacroItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionControllerMacroSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontCenteredText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionControllerMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionControllerItems.size(); i++) {
		DrawOptionControllerItem(i, (char*)OptionControllerItems[i].c_str(), MenuPosX, MenuPosY + (i * vSpace));
	}
	Present();
}

void DrawOptionControllerMacroMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionControllerMacroItems.size(); i++) {
		DrawOptionControllerMacroItem(i, (char*)OptionControllerMacroItems[i].c_str(), MenuPosX, MenuPosY + (i * vSpace));
	}
	Present();
}

bool OptionControllerButtonInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		//SetDelay();
		return false;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  { 
		ClickSound();
		OptionControllerButtonSelected++;
		if(OptionControllerButtonSelected > OptionControllerButtonItems[OptionControllerSelected].size() - 1)
			OptionControllerButtonSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		OptionControllerButtonSelected--;
		if(OptionControllerButtonSelected < 0)
			OptionControllerButtonSelected = OptionControllerButtonItems[OptionControllerSelected].size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionControllerButtonItems[OptionControllerSelected].size() > 0)
			ButtonUpdate(OptionControllerSelected, OptionControllerButtonSelected);
	}
	return true;
}
void DrawOptionControllerButtonItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionControllerButtonSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionControllerButtonMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	for(int i = 0; i < OptionControllerButtonItems[OptionControllerSelected].size(); i++) {
		DrawOptionControllerButtonItem(i, (char*)(OptionControllerButtonItems[OptionControllerSelected])[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawOptionControllerButtonItem(i, (char*)(OptionControllerButtonValueItems[OptionControllerSelected])[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
	Present();
}


bool OptionMacroInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		//SetDelay();
		return false;
	}
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		MacroSelected++; 
		if(MacroSelected >= MacroSet[OptionControllerMacroSelected].size()) 
			MacroSelected = MacroSet[OptionControllerMacroSelected].size() - 1;
	}
	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		MacroSelected--; 
		if(MacroSelected < 0) 
			MacroSelected = 0;
	}  
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		while(1) {
			updateEffect();
			ReadInput();
			if(g_Gamepads[0].Event == XBGAMEPAD_B) {
				CancelSound();
				break;          
			} 
			if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
				ClickSound();
				MacroModSelected++; 
				if(MacroModSelected >= 1) 
					MacroModSelected = 1;
			}
			if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
				ClickSound();
				MacroModSelected--; 
				if(MacroModSelected < 0) 
					MacroModSelected = 0;
			}  
			if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
				ConfirmSound();
				if(MacroModSelected == 0) {
					if(MacroSet[OptionControllerMacroSelected][MacroSelected].enabled == false)
						MacroSet[OptionControllerMacroSelected][MacroSelected].enabled = true;
					else
						MacroSet[OptionControllerMacroSelected][MacroSelected].enabled = false;
				}
				if(MacroModSelected == 1) {
					MacroSet[OptionControllerMacroSelected][MacroSelected].buttonSet++;
					if(MacroSet[OptionControllerMacroSelected][MacroSelected].buttonSet > 7)
						MacroSet[OptionControllerMacroSelected][MacroSelected].buttonSet = 0;
				}
				SaveControllerIni();
			}

			string d;
			if(MacroSet[OptionControllerMacroSelected][MacroSelected].enabled == false)
				d = "Enabled: False";	
			else
				d = "Enabled: True";
			string e = GetButtonName(MacroSet[OptionControllerMacroSelected][MacroSelected].buttonSet);
			Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
			Device->SetTexture(0,TexOption);
			DrawBackground();
			unsigned int c;
			if(MacroModSelected == 0) 
				c = 0xffff00; 
			else 
				c = 0xffffff;
			FontSetColour(c);
			FontCenteredText(ConvertCharStringToWCHAR((char*)d.c_str()), MenuPosX, MenuPosY, 640);
			if(MacroModSelected == 1) 
				c = 0xffff00; 
			else 
				c = 0xffffff;
			FontSetColour(c);
			FontCenteredText(ConvertCharStringToWCHAR((char*)e.c_str()), MenuPosX, MenuPosY + (1 * vSpace), 640);
			Present();
		}
	}
	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
		if(analogSpeed >= 1) { 
			analogSpeed = 0; 
		} 
		if(rightAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)rightAnalog/255.0f);
		MacroSelected+=((int)analogSpeed); 
		if(MacroSelected >= MacroSet[OptionControllerMacroSelected].size()) 
			MacroSelected = MacroSet[OptionControllerMacroSelected].size() - 1;
	}
	if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
		if(analogSpeed >= 1)  { 
			analogSpeed = 0;
		}
		if(leftAnalog == 255)
			analogSpeed = scrollSpeed;
		else
			analogSpeed += ((float)leftAnalog/255.0f);
		MacroSelected-=((int)analogSpeed); if(MacroSelected < 0) MacroSelected = 0;
	}
	return true;
}

void DrawMacroMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	int y = MenuPosY;
	DWORD color;
	int start = 0;
	if(MacroSelected > 7 && (MacroSet[OptionControllerMacroSelected].size() > 15)) {
		start += (MacroSelected  - 7);
	}
	if((MacroSelected > ((MacroSet[OptionControllerMacroSelected].size()-1) - 7)) &&
		(MacroSet[OptionControllerMacroSelected].size() > 15)) {
		start = (MacroSet[OptionControllerMacroSelected].size() - 15);
	}
	for(int i = start; i < start + 15; i++) {
		if(i == MacroSet[OptionControllerMacroSelected].size()) return;
		if(MacroSet[OptionControllerMacroSelected][i].enabled)
			color = 0x00ff00;
		else color = 0xffffff; 
		if(i == MacroSelected) color = 0xffff00; 
		WCHAR msg[1024]={0};
		std::string t = MacroSet[OptionControllerMacroSelected][i].desc;
		for(int r = 0; r < 1024; r++) {
			if((t.c_str())[r] == '\0') {
				msg[r] = '\0';
				break;
			}
			msg[r] = (t.c_str())[r];
		}
		FontSetColour(color);
		FontCenteredText(msg,MenuPosX, y, 600);
		y+=vSpace;
	}
	Present();
}