//-----------------------------------------------------------------------------
// File: XBInput.cpp
//
// Desc: Input helper functions for the XBox samples
//
// Hist: 12.15.00 - Separated from XBUtil.cpp for December XDK release
//       01.03.01 - Made changes for real Xbox controller
//
// Copyright (c) Microsoft Corporation. All rights reserved.
//-----------------------------------------------------------------------------
#include <xtl.h>
#include "XBInput.h"
extern "C" int dprintf(char *format, ...);
extern int DelayValid();


//-----------------------------------------------------------------------------
// Globals
//-----------------------------------------------------------------------------

// Deadzone for thumbsticks
float XBINPUT_DEADZONE = 0.54f;

// Global instance of XInput polling parameters
XINPUT_POLLING_PARAMETERS g_PollingParameters = 
{
    TRUE,
    FALSE,
    0,
    8,
    0,
    0,
};

// Global instance of input states
XINPUT_STATE g_InputStates[4];

// Global instance of custom gamepad devices
XBGAMEPAD g_Gamepads[4];
unsigned char leftAnalog = 0;
unsigned char rightAnalog = 0;
extern int DefaultController;
extern bool ButtonAPressed1;
extern bool ButtonBPressed1;
extern bool ButtonXPressed1;
extern bool ButtonYPressed1;
extern bool ButtonLeftPressed1;
extern bool ButtonRightPressed1;
extern bool ButtonBlackPressed1;
extern bool ButtonWhitePressed1;
extern bool ButtonAPressed2;
extern bool ButtonBPressed2;
extern bool ButtonXPressed2;
extern bool ButtonYPressed2;
extern bool ButtonLeftPressed2;
extern bool ButtonRightPressed2;
extern bool ButtonBlackPressed2;
extern bool ButtonWhitePressed2;
extern bool ButtonAPressed3;
extern bool ButtonBPressed3;
extern bool ButtonXPressed3;
extern bool ButtonYPressed3;
extern bool ButtonLeftPressed3;
extern bool ButtonRightPressed3;
extern bool ButtonBlackPressed3;
extern bool ButtonWhitePressed3;
extern bool ButtonAPressed4;
extern bool ButtonBPressed4;
extern bool ButtonXPressed4;
extern bool ButtonYPressed4;
extern bool ButtonLeftPressed4;
extern bool ButtonRightPressed4;
extern bool ButtonBlackPressed4;
extern bool ButtonWhitePressed4;


//-----------------------------------------------------------------------------
// Name: XBInput_CreateGamepads()
// Desc: Creates the gamepad devices
//-----------------------------------------------------------------------------
HRESULT XBInput_CreateGamepads( XBGAMEPAD** ppGamepads )
{
	XInitDevices( 0, NULL );
    
    // Get a mask of all currently available devices
    DWORD dwDeviceMask = XGetDevices( XDEVICE_TYPE_GAMEPAD );

    // Open the devices
    for( DWORD i=0; i < XGetPortCount(); i++ )
    {
        ZeroMemory( &g_InputStates[i], sizeof(XINPUT_STATE) );
        ZeroMemory( &g_Gamepads[i], sizeof(XBGAMEPAD) );
        if( dwDeviceMask & (1<<i) ) 
        {
            // Get a handle to the device
            g_Gamepads[i].hDevice = XInputOpen( XDEVICE_TYPE_GAMEPAD, i, 
                                                XDEVICE_NO_SLOT, &g_PollingParameters );

            // Store capabilities of the device
            XInputGetCapabilities( g_Gamepads[i].hDevice, &g_Gamepads[i].caps );

            // Initialize last pressed buttons
            XInputGetState( g_Gamepads[i].hDevice, &g_InputStates[i] );

            g_Gamepads[i].wLastButtons = g_InputStates[i].Gamepad.wButtons;

			

            for( DWORD b=0; b<8; b++ )
            {
                g_Gamepads[i].bLastAnalogButtons[b] =
                    // Turn the 8-bit polled value into a boolean value
                    ( g_InputStates[i].Gamepad.bAnalogButtons[b] > XINPUT_GAMEPAD_MAX_CROSSTALK );
            }
        }
    }

    // Created devices are kept global, but for those who prefer member
    // variables, they can get a pointer to the gamepads returned.
    if( ppGamepads )
        (*ppGamepads) = g_Gamepads;


//	g_Gamepads[0].Rumble.wLeftMotorSpeed   = 0;
//	g_Gamepads[0].Rumble.wRightMotorSpeed = 0;
	   
    return S_OK;
}




//-----------------------------------------------------------------------------
// Name: XBInput_RefreshDeviceList()
// Desc: Check for device removals and insertions
//-----------------------------------------------------------------------------
VOID XBInput_RefreshDeviceList( XBGAMEPAD* pGamepads )
{
    // If the user did not specify a list of gamepads, use the global list
    if( NULL == pGamepads )
        pGamepads = g_Gamepads;

    // TCR Controller Discovery
    // Get status about gamepad insertions and removals. Note that, in order to
    // not miss devices, we will check for removed device BEFORE checking for
    // insertions
    DWORD dwInsertions, dwRemovals;
    XGetDeviceChanges( XDEVICE_TYPE_GAMEPAD, &dwInsertions, &dwRemovals );

    // Loop through all gamepads
    for( DWORD i=0; i < XGetPortCount(); i++ )
    {
        // Handle removed devices.
        pGamepads[i].bRemoved = ( dwRemovals & (1<<i) ) ? TRUE : FALSE;
        if( pGamepads[i].bRemoved )
        {
            // If the controller was removed after XGetDeviceChanges but before
            // XInputOpen, the device handle will be NULL
            if( pGamepads[i].hDevice )
                XInputClose( pGamepads[i].hDevice );
            pGamepads[i].hDevice = NULL;
            pGamepads[i].Feedback.Rumble.wLeftMotorSpeed  = 0;
            pGamepads[i].Feedback.Rumble.wRightMotorSpeed = 0;
        }

        // Handle inserted devices
        pGamepads[i].bInserted = ( dwInsertions & (1<<i) ) ? TRUE : FALSE;
        if( pGamepads[i].bInserted ) 
        {
            // TCR Device Types
            pGamepads[i].hDevice = XInputOpen( XDEVICE_TYPE_GAMEPAD, i, 
                                               XDEVICE_NO_SLOT, &g_PollingParameters );

            // if the controller is removed after XGetDeviceChanges but before
            // XInputOpen, the device handle will be NULL
            if( pGamepads[i].hDevice )
            {
                XInputGetCapabilities( pGamepads[i].hDevice, &pGamepads[i].caps );

                // Initialize last pressed buttons
                XInputGetState( g_Gamepads[i].hDevice, &g_InputStates[i] );

                g_Gamepads[i].wLastButtons = g_InputStates[i].Gamepad.wButtons;

                for( DWORD b=0; b<8; b++ )
                {
                    g_Gamepads[i].bLastAnalogButtons[b] =
                        // Turn the 8-bit polled value into a boolean value
                        ( g_InputStates[i].Gamepad.bAnalogButtons[b] > XINPUT_GAMEPAD_MAX_CROSSTALK );
                }
            }
        }
    }
}

int gL = 0;
FLOAT      m_fLeftMotorSpeed = 0;
FLOAT      m_fRightMotorSpeed = 0;

unsigned char leftRumble;
unsigned char rightRumble;
int rumbleController;

void stopVibaration() {
	// If the user did not specify a list of gamepads, use the global list
	XBGAMEPAD* pGamepads =  g_Gamepads;
	// TCR Controller Discovery
	// Get status about gamepad insertions and removals.
	XBInput_RefreshDeviceList( pGamepads );

	// If we have a valid device, poll it's state and track button changes
	if( pGamepads[rumbleController].hDevice )
	{
		// Read the input state
		XInputGetState( pGamepads[rumbleController].hDevice, &g_InputStates[rumbleController] );


		m_fLeftMotorSpeed = 0;
		m_fRightMotorSpeed = 0;


		//while(pGamepads[rumbleController].Feedback.Header.dwStatus == ERROR_IO_PENDING) {
		//	XInputGetState( pGamepads[rumbleController].hDevice, &g_InputStates[rumbleController] );
		//	Sleep(1);
		//}

		if( pGamepads[rumbleController].Feedback.Header.dwStatus != ERROR_IO_PENDING )
		{
			// We can alter the motor values
			pGamepads[rumbleController].Feedback.Rumble.wLeftMotorSpeed  = WORD( m_fLeftMotorSpeed  * 65535.0f );
			pGamepads[rumbleController].Feedback.Rumble.wRightMotorSpeed = WORD( m_fRightMotorSpeed * 65535.0f );
			XInputSetState( pGamepads[rumbleController].hDevice, &pGamepads[rumbleController].Feedback );
		}	
	}
}

//-----------------------------------------------------------------------------
// Name: XBInput_GetInput()
// Desc: Processes input from the gamepads
//-----------------------------------------------------------------------------
VOID XBInput_GetInput( XBGAMEPAD* pGamepads )
{
    // If the user did not specify a list of gamepads, use the global list
    if( NULL == pGamepads )
        pGamepads = g_Gamepads;

    // TCR Controller Discovery
    // Get status about gamepad insertions and removals.
    XBInput_RefreshDeviceList( pGamepads );
    
    // Loop through all gamepads
    for( DWORD i=0; i < XGetPortCount(); i++ )
    {
        // If we have a valid device, poll it's state and track button changes
        if( pGamepads[i].hDevice )
        {
            // Read the input state
            XInputGetState( pGamepads[i].hDevice, &g_InputStates[i] );

			if(i == 0) {
				if(g_InputStates[0].Gamepad.bAnalogButtons[0] > XINPUT_GAMEPAD_MAX_CROSSTALK) {
					ButtonAPressed1 = true;
				}
				else {
					ButtonAPressed1 = false;
				}
				if(g_InputStates[0].Gamepad.bAnalogButtons[1] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonBPressed1 = true;
				else
					ButtonBPressed1 = false;
				if(g_InputStates[0].Gamepad.bAnalogButtons[2] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonXPressed1 = true;
				else
					ButtonXPressed1 = false;
				if(g_InputStates[0].Gamepad.bAnalogButtons[3] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonYPressed1 = true;
				else
					ButtonYPressed1 = false;
				if(g_InputStates[0].Gamepad.bAnalogButtons[4] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonBlackPressed1 = true;
				else
					ButtonBlackPressed1 = false;
				if(g_InputStates[0].Gamepad.bAnalogButtons[5] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonWhitePressed1 = true;
				else
					ButtonWhitePressed1 = false;
				if(g_InputStates[0].Gamepad.bAnalogButtons[6] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonLeftPressed1 = true;
				else
					ButtonLeftPressed1 = false;
				if(g_InputStates[0].Gamepad.bAnalogButtons[7] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonRightPressed1 = true;
				else
					ButtonRightPressed1 = false;
			}

			if(i == 1) {
				if(g_InputStates[1].Gamepad.bAnalogButtons[0] > XINPUT_GAMEPAD_MAX_CROSSTALK) {
					ButtonAPressed2 = true;
				}
				else {
					ButtonAPressed2 = false;
				}
				if(g_InputStates[1].Gamepad.bAnalogButtons[1] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonBPressed2 = true;
				else
					ButtonBPressed2 = false;
				if(g_InputStates[1].Gamepad.bAnalogButtons[2] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonXPressed2 = true;
				else
					ButtonXPressed2 = false;
				if(g_InputStates[1].Gamepad.bAnalogButtons[3] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonYPressed2 = true;
				else
					ButtonYPressed2 = false;
				if(g_InputStates[1].Gamepad.bAnalogButtons[4] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonBlackPressed2 = true;
				else
					ButtonBlackPressed2 = false;
				if(g_InputStates[1].Gamepad.bAnalogButtons[5] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonWhitePressed2 = true;
				else
					ButtonWhitePressed2 = false;
				if(g_InputStates[1].Gamepad.bAnalogButtons[6] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonLeftPressed2 = true;
				else
					ButtonLeftPressed2 = false;
				if(g_InputStates[1].Gamepad.bAnalogButtons[7] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonRightPressed2 = true;
				else
					ButtonRightPressed2 = false;
			}

			if(i == 2) {
				if(g_InputStates[2].Gamepad.bAnalogButtons[0] > XINPUT_GAMEPAD_MAX_CROSSTALK) {
					ButtonAPressed3 = true;
				}
				else {
					ButtonAPressed3 = false;
				}
				if(g_InputStates[2].Gamepad.bAnalogButtons[1] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonBPressed3 = true;
				else
					ButtonBPressed3 = false;
				if(g_InputStates[2].Gamepad.bAnalogButtons[2] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonXPressed3 = true;
				else
					ButtonXPressed3 = false;
				if(g_InputStates[2].Gamepad.bAnalogButtons[3] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonYPressed3 = true;
				else
					ButtonYPressed3 = false;
				if(g_InputStates[2].Gamepad.bAnalogButtons[4] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonBlackPressed3 = true;
				else
					ButtonBlackPressed3 = false;
				if(g_InputStates[2].Gamepad.bAnalogButtons[5] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonWhitePressed3 = true;
				else
					ButtonWhitePressed3 = false;
				if(g_InputStates[2].Gamepad.bAnalogButtons[6] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonLeftPressed3 = true;
				else
					ButtonLeftPressed3 = false;
				if(g_InputStates[2].Gamepad.bAnalogButtons[7] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonRightPressed3 = true;
				else
					ButtonRightPressed3 = false;
			}

			if(i == 3) {
				if(g_InputStates[3].Gamepad.bAnalogButtons[0] > XINPUT_GAMEPAD_MAX_CROSSTALK) {
					ButtonAPressed4 = true;
				}
				else {
					ButtonAPressed4 = false;
				}
				if(g_InputStates[3].Gamepad.bAnalogButtons[1] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonBPressed4 = true;
				else
					ButtonBPressed4 = false;
				if(g_InputStates[3].Gamepad.bAnalogButtons[2] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonXPressed4 = true;
				else
					ButtonXPressed4 = false;
				if(g_InputStates[3].Gamepad.bAnalogButtons[3] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonYPressed4 = true;
				else
					ButtonYPressed4 = false;
				if(g_InputStates[3].Gamepad.bAnalogButtons[4] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonBlackPressed4 = true;
				else
					ButtonBlackPressed4 = false;
				if(g_InputStates[3].Gamepad.bAnalogButtons[5] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonWhitePressed4 = true;
				else
					ButtonWhitePressed4 = false;
				if(g_InputStates[3].Gamepad.bAnalogButtons[6] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonLeftPressed4 = true;
				else
					ButtonLeftPressed4 = false;
				if(g_InputStates[3].Gamepad.bAnalogButtons[7] > XINPUT_GAMEPAD_MAX_CROSSTALK)
					ButtonRightPressed4 = true;
				else
					ButtonRightPressed4 = false;
			}

			if(i == DefaultController) {
				leftAnalog = g_InputStates[DefaultController].Gamepad.bAnalogButtons[6];
				rightAnalog = g_InputStates[DefaultController].Gamepad.bAnalogButtons[7];
			}

            // Copy gamepad to local structure
            memcpy( &pGamepads[i], &g_InputStates[i].Gamepad, sizeof(XINPUT_GAMEPAD) );

            // Put Xbox device input for the gamepad into our custom format
            FLOAT fX1 = (pGamepads[i].sThumbLX+0.5f)/32767.5f;
            pGamepads[i].fX1 = ( fX1 >= 0.0f ? 1.0f : -1.0f ) *
                               max( 0.0f, (fabsf(fX1)-XBINPUT_DEADZONE)/(1.0f-XBINPUT_DEADZONE) );

            FLOAT fY1 = (pGamepads[i].sThumbLY+0.5f)/32767.5f;
			if(i == 0) {
				gL = pGamepads[i].sThumbLY;
			}
            pGamepads[i].fY1 = ( fY1 >= 0.0f ? 1.0f : -1.0f ) *
                               max( 0.0f, (fabsf(fY1)-XBINPUT_DEADZONE)/(1.0f-XBINPUT_DEADZONE) );

            FLOAT fX2 = (pGamepads[i].sThumbRX+0.5f)/32767.5f;
            pGamepads[i].fX2 = ( fX2 >= 0.0f ? 1.0f : -1.0f ) *
                               max( 0.0f, (fabsf(fX2)-XBINPUT_DEADZONE)/(1.0f-XBINPUT_DEADZONE) );

            FLOAT fY2 = (pGamepads[i].sThumbRY+0.5f)/32767.5f;
            pGamepads[i].fY2 = ( fY2 >= 0.0f ? 1.0f : -1.0f ) *
                               max( 0.0f, (fabsf(fY2)-XBINPUT_DEADZONE)/(1.0f-XBINPUT_DEADZONE) );

            // Get the boolean buttons that have been pressed since the last
            // call. Each button is represented by one bit.
            pGamepads[i].wPressedButtons = ( pGamepads[i].wLastButtons ^ pGamepads[i].wButtons ) & pGamepads[i].wButtons;
            pGamepads[i].wLastButtons    = pGamepads[i].wButtons;

            BOOL bAnyButtonPressed = pGamepads[i].wPressedButtons != 0 ? TRUE : FALSE;

            // Get the analog buttons that have been pressed or released since
            // the last call.
            for( DWORD b=0; b<8; b++ )
            {
                // Turn the 8-bit polled value into a boolean value
                BOOL bPressed = ( pGamepads[i].bAnalogButtons[b] > XINPUT_GAMEPAD_MAX_CROSSTALK );

                if( bPressed )
                    pGamepads[i].bPressedAnalogButtons[b] = !pGamepads[i].bLastAnalogButtons[b];
                else
                    pGamepads[i].bPressedAnalogButtons[b] = FALSE;
                
                // Store the current state for the next time
                pGamepads[i].bLastAnalogButtons[b] = bPressed;

                bAnyButtonPressed |= bPressed;
            }

            // Cook the event
            pGamepads[i].Event = XBGAMEPAD_NONE;

            if( bAnyButtonPressed )
            {
                if( pGamepads[i].wPressedButtons & XINPUT_GAMEPAD_START )
                    pGamepads[i].Event = XBGAMEPAD_START;
                else if( pGamepads[i].wPressedButtons & XINPUT_GAMEPAD_BACK )
                    pGamepads[i].Event = XBGAMEPAD_BACK;
                else if( pGamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_A] )
                    pGamepads[i].Event = XBGAMEPAD_A;
                else if( pGamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_B] )
                    pGamepads[i].Event = XBGAMEPAD_B;
                else if( pGamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_X] )
                    pGamepads[i].Event = XBGAMEPAD_X;
                else if( pGamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_Y] )
                    pGamepads[i].Event = XBGAMEPAD_Y;
                else if( pGamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK] )
                    pGamepads[i].Event = XBGAMEPAD_BLACK;
                else if( pGamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_WHITE] )
                    pGamepads[i].Event = XBGAMEPAD_WHITE;
                else if( pGamepads[i].wPressedButtons & XINPUT_GAMEPAD_DPAD_UP )
                    pGamepads[i].Event = XBGAMEPAD_DPAD_UP;
                else if( pGamepads[i].wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN )
                    pGamepads[i].Event = XBGAMEPAD_DPAD_DOWN;
                else if( pGamepads[i].wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT )
                    pGamepads[i].Event = XBGAMEPAD_DPAD_LEFT;
                else if( pGamepads[i].wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT )
                    pGamepads[i].Event = XBGAMEPAD_DPAD_RIGHT;
                else if( pGamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] )
                    pGamepads[i].Event = XBGAMEPAD_LEFT_TRIGGER;
                else if( pGamepads[i].bPressedAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] )
                    pGamepads[i].Event = XBGAMEPAD_RIGHT_TRIGGER;
            }
        }	
    }
}

void InputInit() { 
	XBInput_CreateGamepads(NULL);
}

void ReadInput() {
	/*XBInput_RefreshDeviceList( g_Gamepads );
	for( DWORD i=0; i < XGetPortCount(); i++ ) {
        if( g_Gamepads[i].hDevice )
			g_Gamepads[i].Event = XBGAMEPAD_NONE;
	}*/
	if(DelayValid())
		XBInput_GetInput( NULL );
}

