
#include "cps3.h"

#define CPS3_VOICES		16

#define CPS3_SND_INT_RATE		(nBurnFPS / 100)
#define CPS3_SND_RATE			(42954500 / 3 / 384)
#define CPS3_SND_BUFFER_SIZE	(CPS3_SND_RATE / CPS3_SND_INT_RATE)
#define CPS3_SND_LINEAR_SHIFT	12

#ifdef SN_TARGET_PS3
#define AUDIO_SEGMENT_LENGTH 801
#endif

typedef struct {
	unsigned short regs[16];
	unsigned int pos;
	unsigned short frac;
} cps3_voice;

typedef struct {
	cps3_voice voice[CPS3_VOICES];
	unsigned short key;

	unsigned char * rombase;
	unsigned int delta;

} cps3snd_chip;

static cps3snd_chip * chip;

unsigned char __fastcall cps3SndReadByte(unsigned int addr)
{
	addr &= 0x000003ff;
#ifndef SN_TARGET_PS3
	bprintf(PRINT_NORMAL, _T("SND Attempt to read byte value of location %8x\n"), addr);
#endif
	return 0;
}

unsigned short __fastcall cps3SndReadWord(unsigned int addr)
{
#ifndef SN_TARGET_PS3
	addr &= 0x000003ff;
	
	if (addr < 0x200)	{
		return chip->voice[addr >> 5].regs[(addr>>1) & 0xf];
	} else
	if (addr == 0x200)	{
		return chip->key;
	}
   else
	   bprintf(PRINT_NORMAL, _T("SND Attempt to read word value of location %8x\n"), addr);
	return 0;
#else
int32_t cond;
addr &= 0x3ff;
int32_t chip_voice = chip->voice[addr >> 5].regs[(addr>>1) & 0xf];

int32_t cond_ = addr - 0x200;
cond = (cond_ | (-cond_)) >> 31;
unsigned short chip_key_res = chip->key & (~cond);

cond = (cond_) >> 31;
unsigned short res = (chip_key_res & (~cond)) | (chip_voice & cond);
return res;
#endif
}

unsigned int __fastcall cps3SndReadLong(unsigned int addr)
{
	addr &= 0x000003ff;
	
#ifndef SN_TARGET_PS3
	bprintf(PRINT_NORMAL, _T("SND Attempt to read long value of location %8x\n"), addr);
#endif
	return 0;
}

void __fastcall cps3SndWriteByte(unsigned int addr, unsigned char data)
{
	addr &= 0x000003ff;
#ifndef SN_TARGET_PS3
	bprintf(PRINT_NORMAL, _T("SND Attempt to write byte value %2x to location %8x\n"), data, addr);
#endif
}

void __fastcall cps3SndWriteWord(unsigned int addr, unsigned short data)
{
	addr &= 0x000003ff;
	
	if (addr < 0x200) {
		chip->voice[addr >> 5].regs[(addr>>1) & 0xf] = data;
		//bprintf(PRINT_NORMAL, _T("SND Attempt to write word value %4x to Chip[%02d][%02d] %s\n"), data, addr >> 5, (addr>>2) & 7, (addr & 0x02) ? "lo" : "hi" );
	} else
	if (addr == 0x200) {
		unsigned short key = data;
#ifdef SN_TARGET_PS3
//We unroll it mainly to avoid the shift by variable, which is microcoded on the PPU
         //0
			// Key off -> Key on
         int32_t mask0 = (((key & 1) && !(chip->key & 1)) | -((key & 1) && !(chip->key & 1))) >> 31;
         chip->voice[0].frac = (((0) & mask0) | (((chip->voice[0].frac) & (~mask0))));
         chip->voice[0].pos = (((0) & mask0) | (((chip->voice[0].pos) & (~mask0))));
#if 0
			if ((key & 1) && !(chip->key & 1))	{
				chip->voice[0].frac = 0;
				chip->voice[0].pos = 0;
			}
#endif

         int32_t mask1 = (((key & 2) && !(chip->key & 2)) | -((key & 2) && !(chip->key & 2))) >> 31;
         chip->voice[1].frac = (((0) & mask1) | (((chip->voice[1].frac) & (~mask1))));
         chip->voice[1].pos = (((0) & mask1) | (((chip->voice[1].pos) & (~mask1))));
#if 0
         //1
			// Key off -> Key on
			if ((key & 2) && !(chip->key & 2))	{
				chip->voice[1].frac = 0;
				chip->voice[1].pos = 0;
			}
#endif

         int32_t mask2 = (((key & 4) && !(chip->key & 4)) | -((key & 4) && !(chip->key & 4))) >> 31;
         chip->voice[2].frac = (((0) & mask2) | (((chip->voice[2].frac) & (~mask2))));
         chip->voice[2].pos = (((0) & mask2) | (((chip->voice[2].pos) & (~mask2))));
#if 0
         //2
			// Key off -> Key on
			if ((key & 4) && !(chip->key & 4))	{
				chip->voice[2].frac = 0;
				chip->voice[2].pos = 0;
			}
#endif

         int32_t mask3 = (((key & 8) && !(chip->key & 8)) | -((key & 8) && !(chip->key & 8))) >> 31;
         chip->voice[3].frac = (((0) & mask3) | (((chip->voice[3].frac) & (~mask3))));
         chip->voice[3].pos = (((0) & mask3) | (((chip->voice[3].pos) & (~mask3))));
#if 0
         //3
			// Key off -> Key on
			if ((key & 8) && !(chip->key & 8))	{
				chip->voice[3].frac = 0;
				chip->voice[3].pos = 0;
			}
#endif

         int32_t mask4 = (((key & 16) && !(chip->key & 16)) | -((key & 16) && !(chip->key & 16))) >> 31;
         chip->voice[4].frac = (((0) & mask4) | (((chip->voice[4].frac) & (~mask4))));
         chip->voice[4].pos = (((0) & mask4) | (((chip->voice[4].pos) & (~mask4))));
#if 0
         //4
			// Key off -> Key on
			if ((key & 16) && !(chip->key & 16))	{
				chip->voice[4].frac = 0;
				chip->voice[4].pos = 0;
			}
#endif

         int32_t mask5 = (((key & 32) && !(chip->key & 32)) | -((key & 32) && !(chip->key & 32))) >> 31;
         chip->voice[5].frac = (((0) & mask5) | (((chip->voice[5].frac) & (~mask5))));
         chip->voice[5].pos = (((0) & mask5) | (((chip->voice[5].pos) & (~mask5))));
#if 0
         //5
			// Key off -> Key on
			if ((key & 32) && !(chip->key & 32))	{
				chip->voice[5].frac = 0;
				chip->voice[5].pos = 0;
			}
#endif

         int32_t mask6 = (((key & 64) && !(chip->key & 64)) | -((key & 64) && !(chip->key & 64))) >> 31;
         chip->voice[6].frac = (((0) & mask6) | (((chip->voice[6].frac) & (~mask6))));
         chip->voice[6].pos = (((0) & mask6) | (((chip->voice[6].pos) & (~mask6))));
#if 0
         //6
			// Key off -> Key on
			if ((key & 64) && !(chip->key & 64))	{
				chip->voice[6].frac = 0;
				chip->voice[6].pos = 0;
			}
#endif

         int32_t mask7 = (((key & 128) && !(chip->key & 128)) | -((key & 128) && !(chip->key & 128))) >> 31;
         chip->voice[7].frac = (((0) & mask7) | (((chip->voice[7].frac) & (~mask7))));
         chip->voice[7].pos = (((0) & mask7) | (((chip->voice[7].pos) & (~mask7))));
#if 0
         //7
			// Key off -> Key on
			if ((key & 128) && !(chip->key & 128))	{
				chip->voice[7].frac = 0;
				chip->voice[7].pos = 0;
			}
#endif

         int32_t mask8 = (((key & 256) && !(chip->key & 256)) | -((key & 256) && !(chip->key & 256))) >> 31;
         chip->voice[8].frac = (((0) & mask8) | (((chip->voice[8].frac) & (~mask8))));
         chip->voice[8].pos = (((0) & mask8) | (((chip->voice[8].pos) & (~mask8))));
#if 0
         //8
			// Key off -> Key on
			if ((key & 256) && !(chip->key & 256))	{
				chip->voice[8].frac = 0;
				chip->voice[8].pos = 0;
			}
#endif

         int32_t mask9 = (((key & 512) && !(chip->key & 512)) | -((key & 512) && !(chip->key & 512))) >> 31;
         chip->voice[9].frac = (((0) & mask9) | (((chip->voice[9].frac) & (~mask9))));
         chip->voice[9].pos = (((0) & mask9) | (((chip->voice[9].pos) & (~mask9))));

#if 0
         //9
			// Key off -> Key on
			if ((key & 512) && !(chip->key & 512))	{
				chip->voice[9].frac = 0;
				chip->voice[9].pos = 0;
			}
#endif

         int32_t mask10 = (((key & 1024) && !(chip->key & 1024)) | -((key & 1024) && !(chip->key & 1024))) >> 31;
         chip->voice[10].frac = (((0) & mask10) | (((chip->voice[10].frac) & (~mask10))));
         chip->voice[10].pos = (((0) & mask10) | (((chip->voice[10].pos) & (~mask10))));

#if 0
         //10
			// Key off -> Key on
			if ((key & 1024) && !(chip->key & 1024))	{
				chip->voice[10].frac = 0;
				chip->voice[10].pos = 0;
			}
#endif

         int32_t mask11 = (((key & 2048) && !(chip->key & 2048)) | -((key & 2048) && !(chip->key & 2048))) >> 31;
         chip->voice[11].frac = (((0) & mask11) | (((chip->voice[11].frac) & (~mask11))));
         chip->voice[11].pos = (((0) & mask11) | (((chip->voice[11].pos) & (~mask11))));

#if 0
         //11
			// Key off -> Key on
			if ((key & 2048) && !(chip->key & 2048))	{
				chip->voice[11].frac = 0;
				chip->voice[11].pos = 0;
			}
#endif

         int32_t mask12 = (((key & 4096) && !(chip->key & 4096)) | -((key & 4096) && !(chip->key & 4096))) >> 31;
         chip->voice[12].frac = (((0) & mask12) | (((chip->voice[12].frac) & (~mask12))));
         chip->voice[12].pos = (((0) & mask12) | (((chip->voice[12].pos) & (~mask12))));

#if 0
         //12
			// Key off -> Key on
			if ((key & 4096) && !(chip->key & 4096))	{
				chip->voice[12].frac = 0;
				chip->voice[12].pos = 0;
			}
#endif

         int32_t mask13 = (((key & 8192) && !(chip->key & 8192)) | -((key & 8192) && !(chip->key & 8192))) >> 31;
         chip->voice[13].frac = (((0) & mask13) | (((chip->voice[13].frac) & (~mask13))));
         chip->voice[13].pos = (((0) & mask13) | (((chip->voice[13].pos) & (~mask13))));

#if 0
         //13
			// Key off -> Key on
			if ((key & 8192) && !(chip->key & 8192))	{
				chip->voice[13].frac = 0;
				chip->voice[13].pos = 0;
			}
#endif

         int32_t mask14 = (((key & 16384) && !(chip->key & 16384)) | -((key & 16384) && !(chip->key & 16384))) >> 31;
         chip->voice[14].frac = (((0) & mask14) | (((chip->voice[14].frac) & (~mask14))));
         chip->voice[14].pos = (((0) & mask14) | (((chip->voice[14].pos) & (~mask14))));

#if 0
         //14
			// Key off -> Key on
			if ((key & 16384) && !(chip->key & 16384))	{
				chip->voice[14].frac = 0;
				chip->voice[14].pos = 0;
			}
#endif

         int32_t mask15 = (((key & 32768) && !(chip->key & 32768)) | -((key & 32768) && !(chip->key & 32768))) >> 31;
         chip->voice[15].frac = (((0) & mask15) | (((chip->voice[15].frac) & (~mask15))));
         chip->voice[15].pos = (((0) & mask15) | (((chip->voice[15].pos) & (~mask15))));

#if 0
         //15
			// Key off -> Key on
			if ((key & 32768) && !(chip->key & 32768))	{
				chip->voice[15].frac = 0;
				chip->voice[15].pos = 0;
			}
#endif
		chip->key = key;
   }
#else
		for (int i = 0; i < CPS3_VOICES; i++) {
			// Key off -> Key on
			if ((key & (1 << i)) && !(chip->key & (1 << i)))	{
				chip->voice[i].frac = 0;
				chip->voice[i].pos = 0;
			}
		}
		chip->key = key;
	}
   else
		bprintf(PRINT_NORMAL, _T("SND Attempt to write word value %4x to location %8x\n"), data, addr);
#endif
}

void __fastcall cps3SndWriteLong(unsigned int addr, unsigned int data)
{
	//addr &= 0x000003ff;
#ifndef SN_TARGET_PS3
	bprintf(PRINT_NORMAL, _T("SND Attempt to write long value %8x to location %8x\n"), data, addr);
#endif
}

int cps3SndInit(unsigned char * sndrom)
{
	chip = (cps3snd_chip *) osd_malloc( sizeof(cps3snd_chip) );
	if ( chip ) {
		memset( chip, 0, sizeof(cps3snd_chip) );
		chip->rombase = sndrom;
		
		/* 
		 * CPS-3 Sound chip clock: 42954500 / 3 / 384 = 37286.89
		 * Sound interupt 80Hz 
		 */
		
		if (nBurnSoundRate) {
			//chip->delta = 37286.9 / nBurnSoundRate;
#ifdef SN_TARGET_PS3
			chip->delta = (CPS3_SND_BUFFER_SIZE << CPS3_SND_LINEAR_SHIFT) / AUDIO_SEGMENT_LENGTH;
#else
			chip->delta = (CPS3_SND_BUFFER_SIZE << CPS3_SND_LINEAR_SHIFT) / nBurnSoundLen;
#endif
			//bprintf(0, _T("BurnSnd %08x, %d, %d\n"), chip->delta, chip->burnlen, nBurnSoundLen);
		}
		
		return 0;
	}
	return 1;
}

void cps3SndReset()
{
}

void cps3SndExit()
{
	free( chip );
}

void cps3SndUpdate()
{
#ifndef SN_TARGET_PS3
	if (!pBurnSoundOut) {
		// TODO: ???
		// chip->key = 0;
		return;	
	}
#endif
	
#ifdef SN_TARGET_PS3
	__builtin_memset(pBurnSoundOut, 0, 3204);
#else
	memset(pBurnSoundOut, 0, nBurnSoundLen * 2 * 2 );
#endif
	signed char * base = (signed char *)chip->rombase;
	cps3_voice *vptr = &chip->voice[0];

	for(int i=0; i<CPS3_VOICES; i++, vptr++) {
		if (chip->key & (1 << i)) {
			
			unsigned int start = ((vptr->regs[ 3] << 16) | vptr->regs[ 2]) - 0x400000;
			unsigned int end   = ((vptr->regs[11] << 16) | vptr->regs[10]) - 0x400000;
			unsigned int loop  = ((vptr->regs[ 9] << 16) | vptr->regs[ 7]) - 0x400000;
			unsigned int step  = ( vptr->regs[ 6] * chip->delta ) >> CPS3_SND_LINEAR_SHIFT;

			//int vol_l = ((signed short)vptr->regs[15] * 12) >> 4;
			//int vol_r = ((signed short)vptr->regs[14] * 12) >> 4;
			int vol_l = (signed short)vptr->regs[15];
			int vol_r = (signed short)vptr->regs[14];

			unsigned int pos = vptr->pos;
			unsigned int frac = vptr->frac;
			
			/* Go through the buffer and add voice contributions */
			signed short * buffer = (signed short *)pBurnSoundOut;

#ifdef SN_TARGET_PS3
			for (int j=0; j<AUDIO_SEGMENT_LENGTH; j++) {
#else
			for (int j=0; j<nBurnSoundLen; j++) {
#endif
				signed int sample;

				pos += (frac >> 12);
				frac &= 0xfff;

				if (start + pos >= end) {
					if (vptr->regs[5]) {
						pos = loop - start;
					} else {
						chip->key &= ~(1 << i);
						break;
					}
				}

				// 8bit sample store with 16bit bigend ???
				sample = base[(start + pos) ^ 1];
				frac += step;

#if 1
				int sample_l;

#ifdef SN_TARGET_PS3
				sample_l = ((sample * vol_r) >> 8) + buffer[0];
            signed short sample_l_gt = sample_l > 32767;
            signed short sample_l_lt = sample_l < -32768;
            int mask_sample_l_gt = ((sample_l_gt) | -(sample_l_gt)) >> 31;
            int mask_sample_l_lt = ((sample_l_lt) | -(sample_l_lt)) >> 31;
            buffer[0] = (((32767) & mask_sample_l_gt) | (sample_l & (~mask_sample_l_gt)));
            buffer[0] = (((-32768) & (mask_sample_l_lt & (~mask_sample_l_gt))) | (buffer[0] & (~mask_sample_l_lt)));

				sample_l = ((sample * vol_l) >> 8) + buffer[1];
            signed short sample_l_gt_2 = sample_l > 32767;
            signed short sample_l_lt_2 = sample_l < -32768;
            int mask_sample_l_gt_2 = ((sample_l_gt_2) | -(sample_l_gt_2)) >> 31;
            int mask_sample_l_lt_2 = ((sample_l_lt_2) | -(sample_l_lt_2)) >> 31;
            buffer[1] = (((32767) & mask_sample_l_gt_2) | (sample_l & (~mask_sample_l_gt_2)));
            buffer[1] = (((-32768) & (mask_sample_l_lt_2 & (~mask_sample_l_gt_2))) | (buffer[1] & (~mask_sample_l_lt_2)));
#else
				sample_l = ((sample * vol_r) >> 8) + buffer[0];
				if (sample_l > 32767)		buffer[0] = 32767;
				else if (sample_l < -32768)	buffer[0] = -32768;
				else 						buffer[0] = sample_l;
				sample_l = ((sample * vol_l) >> 8) + buffer[1];
				if (sample_l > 32767)		buffer[1] = 32767;
				else if (sample_l < -32768)	buffer[1] = -32768;
				else 						buffer[1] = sample_l;
#endif
				
#else
				buffer[0] += (sample * (vol_l >> 8));
				buffer[1] += (sample * (vol_r >> 8));
#endif

				buffer += 2;
			}


			vptr->pos = pos;
			vptr->frac = frac;
		}
	}
	
}

int cps3SndScan(int nAction)
{
	if (nAction & ACB_DRIVER_DATA) {
		
		SCAN_VAR( chip->voice );
		SCAN_VAR( chip->key );
		
	}
	return 0;
}

