#include "GlobalExtern.h"

extern int ConfigGameSave(bool bSave);
extern "C" void HiscoreExit();

void DrawDipSwitchSettingItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(DipSwitchSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawDipSwitchMenu() {
	for(int i = 0; i < DipSwitchSettings.size(); i++) {
		DrawDipSwitchSettingItem(i, (char*)DipSwitchSettings[i].description.c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawDipSwitchSettingItem(i, (char*)DipSwitchSettings[i].value.c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
}

void DrawGeneralOptionItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(GeneralOptionsSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawGeneralOptionsMenu() {
	for(int i = 0; i < GeneralOptionsSettings.size(); i++) {
		DrawGeneralOptionItem(i, (char*)GeneralOptionsSettings[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
		DrawGeneralOptionItem(i, (char*)GeneralOptionsValueSettings[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
	}
}

void DipMenu() {
	DipSwitchSelected = 0;
	while(1) {
		updateEffect();
		ReadInput();
		if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
			CancelSound();
			g_Gamepads[DefaultController].Event = XBGAMEPAD_A;
			return;          
		} 
		if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
			if(DipSwitchSettings.size() != 0) {	
				ClickSound();
				DipSwitchSelected++; 
				if(DipSwitchSelected >= DipSwitchSettings.size()) 
					DipSwitchSelected = DipSwitchSettings.size() - 1;
			}
		}
		if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
			if(DipSwitchSettings.size() != 0) {	
				ClickSound();
				DipSwitchSelected--; 
				if(DipSwitchSelected < 0) 
					DipSwitchSelected = 0;
			}
		}  
		if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
			if(DipSwitchSettings.size() != 0) {		
				ConfirmSound();
				SetDip((char*)DipSwitchSettings[DipSwitchSelected].description.c_str(), 
					(char*)DipSwitchSettings[DipSwitchSelected].value.c_str());
			}
		}

		Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
		Device->SetTexture(0,TexOption);
		DrawBackground();
		if(DipSwitchSettings.size() == 0) {
			DisplayCenteredMsg("No Dip Switches found", 190); 
		}
		else {
			DrawDipSwitchMenu();
		}
		Present();
	}
}

void DrawArcadeInfo() {
	while(true) {
		updateEffect();
		ReadInput();
		if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
			CancelSound();
			SetFontHeight(FontSize);
			guide.clear();
			return;          
		} 
		if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
			ClickSound();
			if(guideGameSelectedText < 7) guideGameSelectedText = 7;
			guideGameSelectedText++; if(guideGameSelectedText >=guide.size()) guideGameSelectedText = guide.size()- 1;
		}
		if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {  
			ClickSound();
			guideGameSelectedText--; if(guideGameSelectedText < 7) guideGameSelectedText = 7;
		}  
		if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_RIGHT)  {
			if(guideGameSelectedText < 7) guideGameSelectedText = 7;
			guideGameSelectedText+=GameGuideLines; if(guideGameSelectedText >=guide.size()) guideGameSelectedText = guide.size()- 1;
		}
		if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_LEFT)  {  
			guideGameSelectedText-=GameGuideLines; if(guideGameSelectedText < 7) guideGameSelectedText = 7;
		}  
		if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
			if(slowGuide >= 1) { 
				slowGuide = 0; 
			} 
			if(rightAnalog == 255)
				slowGuide = scrollSpeed;
			else
				slowGuide += ((float)rightAnalog/255.0f);
			guideGameSelectedText+=((int)slowGuide); 
			if(guideGameSelectedText >= guide.size()) 
				guideGameSelectedText = guide.size() - 1;
		}
		if (g_Gamepads[DefaultController].fX1 < 0) {guideLeft-=2;  } // Left
		if (g_Gamepads[DefaultController].fX1 > 0) {guideLeft+=2;  }// Right
		if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
			if(slowGuide >= 1)  { 
				slowGuide = 0;
			}
			if(leftAnalog == 255)
				slowGuide = scrollSpeed;
			else
				slowGuide += ((float)leftAnalog/255.0f);
			guideGameSelectedText-=((int)slowGuide); 
			if(guideGameSelectedText < 7)
				guideGameSelectedText = 7;
		}
		Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
		SetFontHeight(GameGuideFontSize);
		DrawGuide();
		SetFontHeight(FontSize);
		Present();
	}
}

void GameOptionInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		//CancelSound();
//		SaveScreenIni();
		SaveGameIni(BurnDrvGetTextA(0));
		exitGameMenu = true;
		DxSoundPlay();
		SetDelay();
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
		ClickSound();
		GameOptionSelected++;
		if(GameOptionSelected > GameOptionItems.size() - 1)
			GameOptionSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
		ClickSound();
		GameOptionSelected--;
		if(GameOptionSelected < 0)
			GameOptionSelected = GameOptionItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		if(GameOptionSelected == 0) {
			//ConfirmSound();
			SaveGameIni(BurnDrvGetTextA(0));
			exitGameMenu = true;
			DxSoundPlay();
			SetDelay();
			return;
		}
		if(GameOptionSelected == 1) {
			ConfirmSound();
			resetGame = 10;
			SaveGameIni(BurnDrvGetTextA(0));
			exitGameMenu = true;
			DxSoundPlay();
			SetDelay();
			return;
		}

		if(GameOptionSelected == 2) {
			ConfirmSound();
			SaveSlotSelected = 0;
			char fileName[260];
			sprintf(fileName,"%s%s%s%s%s%s", SaveStatePath.c_str(), "\\", BurnDrvGetTextA(0), "\\Slot0\\", BurnDrvGetTextA(0), ".png");
			if(TexPreview) {
				TexPreview->Release();
				TexPreview = NULL;
			}
			D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
				D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
				D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
			GUIState = 10;
			return;
		}

		if(GameOptionSelected == 3) {
			ConfirmSound();
			SaveSlotSelected = 0;
			char fileName[260];
			sprintf(fileName,"%s%s%s%s%s%s", SaveStatePath.c_str(), "\\", BurnDrvGetTextA(0), "\\Slot0\\", BurnDrvGetTextA(0), ".png");
			if(TexPreview) {
				TexPreview->Release();
				TexPreview = NULL;
			}
			D3DXCreateTextureFromFileEx(Device, fileName, D3DX_DEFAULT,
				D3DX_DEFAULT,1,0,D3DFMT_A8R8G8B8,D3DPOOL_MANAGED,D3DX_DEFAULT,
				D3DX_DEFAULT,0,NULL,NULL,&TexPreview);
			GUIState = 11;
			return;
		}

		if(GameOptionSelected == 4) {
			ConfirmSound();
			std::string e;
			if(CurrentArtwork == 1) e = ArtworkPath1;
			if(CurrentArtwork == 2) e = ArtworkPath2;
			if(CurrentArtwork == 3) e = ArtworkPath3;
			if(CurrentArtwork == 4) e = ArtworkPath4;
			if(CurrentArtwork == 5) e = ArtworkPath5;
			if(CurrentArtwork == 6) e = ArtworkPath6;
			if(CurrentArtwork == 7) e = ArtworkPath7;
			if(CurrentArtwork == 8) e = ArtworkPath8;
			char fileName[260];
			sprintf(fileName,"%s%s%s%s", e.c_str(), "\\", BurnDrvGetTextA(0), ".png");
			MakeScreenShot(fileName);
			SaveGameIni(BurnDrvGetTextA(0));
			exitGameMenu = true;
			DxSoundPlay();
			SetDelay();			
			return;
		}

		if(GameOptionSelected == 5) {
			ConfirmSound();
			GUIState = 4;
			return;
		}
		if(GameOptionSelected == 6) {
			ConfirmSound();
			GUIState = 5;
			return;
		}

		if(GameOptionSelected == 7) {
			ConfirmSound();
			GeneralOptionsSelected = 0;
			while(1) {
				updateEffect();
				ReadInput();
				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
					CancelSound();
					SaveGameIni(BurnDrvGetTextA(0));
					ConfigGameSave(true);
					break;          
				} 
				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
					if(GeneralOptionsSettings.size() != 0) {	
						ClickSound();
						GeneralOptionsSelected++; 
						if(GeneralOptionsSelected >= GeneralOptionsSettings.size()) 
							GeneralOptionsSelected = GeneralOptionsSettings.size() - 1;
					}
				}
				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
					if(GeneralOptionsSettings.size() != 0) {	
						ClickSound();
						GeneralOptionsSelected--; 
						if(GeneralOptionsSelected < 0) 
							GeneralOptionsSelected = 0;
					}
				}  
				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
					if(GeneralOptionsSettings.size() != 0) {		
						ConfirmSound();
						if(GeneralOptionsSelected == 0) {
							HiScoreSaving ^= 1;
							if(HiScoreSaving == 1) {
								GeneralOptionsValueSettings[0] = "True";
							}
							else {
								GeneralOptionsValueSettings[0] = "False";
							}
						}
						if(GeneralOptionsSelected == 1) {
							DipEnabled ^= 1;
							if(DipEnabled == 1) 
								GeneralOptionsValueSettings[1] = "True";
							else
								GeneralOptionsValueSettings[1] = "False";
						}
						if(GeneralOptionsSelected == 2) {
							CPUSpeed += 32;
							if(CPUSpeed > 655360)
								CPUSpeed = 0x0100;
							nBurnCPUSpeedAdjust = CPUSpeed;
							std::ostringstream temp;
							temp << (float)(((float)CPUSpeed / 256) * 100) << "%";
							std::string temp2 = temp.str();
							GeneralOptionsValueSettings[2] = (char*)temp2.c_str();
						}
						if(GeneralOptionsSelected == 3) {
							SNKBIOS += 1;
							if(SNKBIOS > 0x16)
								SNKBIOS = 0;

							if(SNKBIOS == 0x00) GeneralOptionsValueSettings[3] = "MVS Asia/Europe ver. 6 (1 slot)";
							if(SNKBIOS == 0x01) GeneralOptionsValueSettings[3] = "MVS Asia/Europe ver. 5 (1 slot)";
							if(SNKBIOS == 0x02) GeneralOptionsValueSettings[3] = "MVS Asia/Europe ver. 3 (4 slot)";
							if(SNKBIOS == 0x03) GeneralOptionsValueSettings[3] = "MVS USA ver. 5 (2 slot)";
							if(SNKBIOS == 0x04) GeneralOptionsValueSettings[3] = "MVS USA ver. 5 (6 slot)";
							if(SNKBIOS == 0x05) GeneralOptionsValueSettings[3] = "MVS Japan ver. 6 (? slot)";
							if(SNKBIOS == 0x06) GeneralOptionsValueSettings[3] = "MVS Japan ver. 5 (? slot)";
							if(SNKBIOS == 0x07) GeneralOptionsValueSettings[3] = "MVS Japan ver. 3 (4 slot)";
							if(SNKBIOS == 0x08) GeneralOptionsValueSettings[3] = "NEO-MVH MV1C";
							if(SNKBIOS == 0x09) GeneralOptionsValueSettings[3] = "AES Japan";
							if(SNKBIOS == 0x0a) GeneralOptionsValueSettings[3] = "AES Asia";
							if(SNKBIOS == 0x0b) GeneralOptionsValueSettings[3] = "Development Kit";
							if(SNKBIOS == 0x0c) GeneralOptionsValueSettings[3] = "Deck ver. 6 (Git Ver 1.3)";
							if(SNKBIOS == 0x0d) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.3";
							if(SNKBIOS == 0x0e) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.3 (alt)";
							if(SNKBIOS == 0x0f) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.2";
							if(SNKBIOS == 0x10) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.1";
							if(SNKBIOS == 0x11) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.0";
							if(SNKBIOS == 0x12) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.3";
							if(SNKBIOS == 0x13) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.2";
							if(SNKBIOS == 0x14) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.2 (alt)";
							if(SNKBIOS == 0x15) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.1";
							if(SNKBIOS == 0x16) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.0";
						}
						if(GeneralOptionsSelected == 4) {
							neoGeoFree ^= 1;
							if(neoGeoFree == 1) {
								GeneralOptionsValueSettings[4] = "Enabled";
							}
							else {
								GeneralOptionsValueSettings[4] = "Disabled";
							}
						}
						if(GeneralOptionsSelected == 5) {
							XBINPUT_DEADZONE+=0.01;
							std::ostringstream temp;
							temp << XBINPUT_DEADZONE;
							std::string temp2 = temp.str();
							GeneralOptionsValueSettings[5] = (char*)temp2.c_str();
						}
					}
				}
				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
					if(GeneralOptionsSettings.size() != 0) {		
						ConfirmSound();
						if(GeneralOptionsSelected == 0) {
							HiScoreSaving ^= 1;
							if(HiScoreSaving == 1) {
								GeneralOptionsValueSettings[0] = "True";
							}
							else {
								GeneralOptionsValueSettings[0] = "False";
							}
						}
						if(GeneralOptionsSelected == 1) {
							DipEnabled ^= 1;
							if(DipEnabled == 1) 
								GeneralOptionsValueSettings[1] = "True";
							else
								GeneralOptionsValueSettings[1] = "False";
						}

						if(GeneralOptionsSelected == 2) {
							CPUSpeed -= 32;
							if(CPUSpeed < 0x0100)
								CPUSpeed = 0x0100;
							nBurnCPUSpeedAdjust = CPUSpeed;
							std::ostringstream temp;
							temp << (float)(((float)CPUSpeed / 256) * 100) << "%";
							std::string temp2 = temp.str();
							GeneralOptionsValueSettings[2] = (char*)temp2.c_str();
						}

						if(GeneralOptionsSelected == 3) {
							if(SNKBIOS == 0)
								SNKBIOS = 0x16;
							else
								SNKBIOS -= 1;

							if(SNKBIOS == 0x00) GeneralOptionsValueSettings[3] = "MVS Asia/Europe ver. 6 (1 slot)";
							if(SNKBIOS == 0x01) GeneralOptionsValueSettings[3] = "MVS Asia/Europe ver. 5 (1 slot)";
							if(SNKBIOS == 0x02) GeneralOptionsValueSettings[3] = "MVS Asia/Europe ver. 3 (4 slot)";
							if(SNKBIOS == 0x03) GeneralOptionsValueSettings[3] = "MVS USA ver. 5 (2 slot)";
							if(SNKBIOS == 0x04) GeneralOptionsValueSettings[3] = "MVS USA ver. 5 (6 slot)";
							if(SNKBIOS == 0x05) GeneralOptionsValueSettings[3] = "MVS Japan ver. 6 (? slot)";
							if(SNKBIOS == 0x06) GeneralOptionsValueSettings[3] = "MVS Japan ver. 5 (? slot)";
							if(SNKBIOS == 0x07) GeneralOptionsValueSettings[3] = "MVS Japan ver. 3 (4 slot)";
							if(SNKBIOS == 0x08) GeneralOptionsValueSettings[3] = "NEO-MVH MV1C";
							if(SNKBIOS == 0x09) GeneralOptionsValueSettings[3] = "AES Japan";
							if(SNKBIOS == 0x0a) GeneralOptionsValueSettings[3] = "AES Asia";
							if(SNKBIOS == 0x0b) GeneralOptionsValueSettings[3] = "Development Kit";
							if(SNKBIOS == 0x0c) GeneralOptionsValueSettings[3] = "Deck ver. 6 (Git Ver 1.3)";
							if(SNKBIOS == 0x0d) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.3";
							if(SNKBIOS == 0x0e) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.3 (alt)";
							if(SNKBIOS == 0x0f) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.2";
							if(SNKBIOS == 0x10) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.1";
							if(SNKBIOS == 0x11) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 2.0";
							if(SNKBIOS == 0x12) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.3";
							if(SNKBIOS == 0x13) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.2";
							if(SNKBIOS == 0x14) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.2 (alt)";
							if(SNKBIOS == 0x15) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.1";
							if(SNKBIOS == 0x16) GeneralOptionsValueSettings[3] = "Universe BIOS ver. 1.0";
						}

						if(GeneralOptionsSelected == 4) {
							neoGeoFree ^= 1;
							if(neoGeoFree == 1) {
								GeneralOptionsValueSettings[4] = "Enabled";
							}
							else {
								GeneralOptionsValueSettings[4] = "Disabled";
							}
						}

						if(GeneralOptionsSelected == 5) {
							XBINPUT_DEADZONE-=0.01;
							std::ostringstream temp;
							temp << XBINPUT_DEADZONE;
							std::string temp2 = temp.str();
							GeneralOptionsValueSettings[5] = (char*)temp2.c_str();
						}
					}
				}

				Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
				Device->SetTexture(0,TexOption);
				DrawBackground();
				DrawGeneralOptionsMenu();
				Present();
			}
		}
		if(GameOptionSelected == 8) {
			ConfirmSound();
			while(1) {
				updateEffect();
				ReadInput();
				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
					CancelSound();
					return;
				}

				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
					ClickSound();
					OptionGUIControllerItemsSelected++;
					if(OptionGUIControllerItemsSelected > OptionGUIControllerItems.size() - 1)
						OptionGUIControllerItemsSelected = 0;
				}

				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
					ClickSound();
					OptionGUIControllerItemsSelected--;
					if(OptionGUIControllerItemsSelected < 0)
						OptionGUIControllerItemsSelected = OptionGUIControllerItems.size() - 1;
				}  

				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
					ConfirmSound();
					if(OptionGUIControllerItemsSelected == 3) {
						CursorSpeed--;
						if(CursorSpeed < 1) 
							CursorSpeed = 1;
						std::ostringstream q0;
						q0 << CursorSpeed;
						std::string w0 = "Cursor Speed: ";
						w0 += q0.str();
						OptionGUIControllerItems[3] = (char*)w0.c_str();
					}
				}

				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
					ConfirmSound();
					if(OptionGUIControllerItemsSelected == 0) {
						OptionControllerItems.clear();
						if(OptionControllerButtonItems[0].size() != 0)
							OptionControllerItems.push_back("Controller 1 Configuration");
						if(OptionControllerButtonItems[1].size() != 0)
							OptionControllerItems.push_back("Controller 2 Configuration");
						if(OptionControllerButtonItems[2].size() != 0)
							OptionControllerItems.push_back("Controller 3 Configuration");
						if(OptionControllerButtonItems[3].size() != 0)
							OptionControllerItems.push_back("Controller 4 Configuration");
						while(1) {
							updateEffect();
							if(!OptionControllerInput())
								break;
							DrawOptionControllerMenu();
						}
					}
					if(OptionGUIControllerItemsSelected == 1) {
						while(1) {
							updateEffect();
							ReadInput();
							if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
								CancelSound();
								
								break;  
							}
							if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
								ClickSound();
								OptionControllerTurboSelected++;
								if(OptionControllerTurboSelected > OptionControllerTurboItems.size() - 1)
									OptionControllerTurboSelected = 0;
							}

							if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
								ClickSound();
								OptionControllerTurboSelected--;
								if(OptionControllerTurboSelected < 0)
									OptionControllerTurboSelected = OptionControllerTurboItems.size() - 1;
							}  

							if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
								ConfirmSound();
								if(OptionControllerTurboSelected == 9) {
									turboSpeed--; 
									if(turboSpeed < 1) 
										turboSpeed = 100; 
								}
								UpdateTurboDescriptions();	
							} 

							if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
								ConfirmSound();
								UpdateTurboButtons();
							} 

							DrawOptionControllerTurboMenu();
						}
					}

					if(OptionGUIControllerItemsSelected == 2) {
						OptionControllerMacroItems.clear();
						OptionControllerMacroItems.push_back("Controller 1 Macro Configuration");
						OptionControllerMacroItems.push_back("Controller 2 Macro Configuration");
						OptionControllerMacroItems.push_back("Controller 3 Macro Configuration");
						OptionControllerMacroItems.push_back("Controller 4 Macro Configuration");
						while(1) {
							updateEffect();
							if(!OptionControllerMacroInput())
								break;
							DrawOptionControllerMacroMenu();
						}
					}

					if(OptionGUIControllerItemsSelected == 3) {
						CursorSpeed++;
						std::ostringstream q0;
						q0 << CursorSpeed;
						std::string w0 = "Cursor Speed: ";
						w0 += q0.str();
						OptionGUIControllerItems[3] = (char*)w0.c_str();
					}
				}

				Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
				Device->SetTexture(0,TexOption);
				DrawBackground();
				for(int i = 0; i < OptionGUIControllerItems.size(); i++) {
					unsigned int c;
					if(OptionGUIControllerItemsSelected == i) 
						c = 0xffff00; 
					else 
						c = 0xffffff;
					FontSetColour(c);
					FontCenteredText(ConvertCharStringToWCHAR((char*)OptionGUIControllerItems[i].c_str()), MenuPosX, MenuPosY + (i * vSpace), 640);
				}
				Present();
			}
		}

		if(GameOptionSelected == 9) {
			ConfirmSound();
			SearchDirectoryText("D:\\guides\\");
			GUIState = 12;
			return;
		}

		if(GameOptionSelected == 10) {
			ConfirmSound();
			if(FbaCheats.size() == 0) {
				while(1) {
					updateEffect();
					ReadInput();
					if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
						CancelSound();
						return;          
					} 
					Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
					Device->SetTexture(0,TexOption);
					DrawBackground();
					DisplayCenteredMsg("No cheats found", 190); 
					Present();
				}
			}
			else {
				while(1) {
					updateEffect();
					ReadInput();
					if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
						CancelSound();
						return;          
					} 
					if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
						ClickSound();
						CheatSelected++; 
						if(CheatSelected >= FbaCheats.size()) 
							CheatSelected = FbaCheats.size() - 1;
					}
					if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
						ClickSound();
						CheatSelected--; 
						if(CheatSelected < 0) 
							CheatSelected = 0;
					}  
					if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A && FbaCheats[CheatSelected].enabled != -1) {
						ConfirmSound();
						CheatValueSelected = 0;
						while(1) {
							updateEffect();
							ReadInput();
							if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
								CancelSound();
								break;          
							} 
							if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
								ClickSound();
								CheatValueSelected++; 
								if(CheatValueSelected >= FbaCheats[CheatSelected].value.size()) 
									CheatValueSelected = FbaCheats[CheatSelected].value.size() - 1;
							}
							if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
								ClickSound();
								CheatValueSelected--; 
								if(CheatValueSelected < 0) 
									CheatValueSelected = 0;
							}  
							if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
								////////////dprintf("FbaCheats[CheatSelected].cheat: %d, CheatValueSelected: %d\n", FbaCheats[CheatSelected].cheat, CheatValueSelected);
								ConfirmSound();
								FbaCheats[CheatSelected].enabled = CheatValueSelected;
								CheatEnable(CheatSelected, CheatValueSelected);
								break;
							}
							if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
								if(analogSpeed >= 1) { 
									analogSpeed = 0; 
								} 
								if(rightAnalog == 255)
									analogSpeed = scrollSpeed;
								else
									analogSpeed += ((float)rightAnalog/255.0f);
								CheatValueSelected+=((int)analogSpeed); 
								if(CheatValueSelected >= FbaCheats[CheatSelected].value.size()) 
									CheatValueSelected = FbaCheats[CheatSelected].value.size() - 1;
							}
							if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
								if(analogSpeed >= 1)  { 
									analogSpeed = 0;
								}
								if(leftAnalog == 255)
									analogSpeed = scrollSpeed;
								else
									analogSpeed += ((float)leftAnalog/255.0f);
								CheatValueSelected-=((int)analogSpeed); if(CheatValueSelected < 0) CheatValueSelected = 0;
							}
							Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
							Device->SetTexture(0,TexOption);
							DrawBackground();
							DrawCheatDetailMenu();
							Present();

						}
					}

					if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]) {
						if(analogSpeed >= 1) { 
							analogSpeed = 0; 
						} 
						if(rightAnalog == 255)
							analogSpeed = scrollSpeed;
						else
							analogSpeed += ((float)rightAnalog/255.0f);
						CheatSelected+=((int)analogSpeed); 
						if(CheatSelected >= FbaCheats.size()) 
							CheatSelected = FbaCheats.size() - 1;
					}
					if( g_Gamepads[DefaultController].bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]) {
						if(analogSpeed >= 1)  { 
							analogSpeed = 0;
						}
						if(leftAnalog == 255)
							analogSpeed = scrollSpeed;
						else
							analogSpeed += ((float)leftAnalog/255.0f);
						CheatSelected-=((int)analogSpeed); if(CheatSelected < 0) CheatSelected = 0;
					}
					Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
					Device->SetTexture(0,TexOption);
					DrawBackground();
					DrawCheatMenu();
					Present();
				}
			}
		}

		if(GameOptionSelected == 11) {
			ConfirmSound();
			char fileName[260];
			sprintf(fileName,"%s%s%s", "D:\\info\\emulation\\", BurnDrvGetTextA(0), ".ini");
			LoadGuide(fileName, BurnDrvGetTextA(0));
			DrawArcadeInfo();
		}

		if(GameOptionSelected == 12) {
			ConfirmSound();
			while(1) {
				updateEffect();
				ReadInput();
				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
					CancelSound();
					break;          
				} 
				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  {
					if(arcadeSettings.size() > 0) {	
						ClickSound();
						ArcadeSettingSelected++; 
						if(ArcadeSettingSelected >= arcadeSettings.size()) 
							ArcadeSettingSelected = arcadeSettings.size() - 1;
					}
				}
				if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {
					if(arcadeSettings.size() != 0) {	
						ClickSound();
						ArcadeSettingSelected--; 
						if(ArcadeSettingSelected < 0) 
							ArcadeSettingSelected = 0;
					}
				}  
				if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
					if(arcadeSettings.size() != 0) {	
						ConfirmSound();
						if(ArcadeSettingSelected == 0) {
							DipMenu();
						}
						else {
							//////////dprintf("Setting: %s, Value: %d\n", arcadeSettings[ArcadeSettingSelected].name.c_str(), arcadeSettings[ArcadeSettingSelected].code); 
							arcadeSettings[ArcadeSettingSelected].count = 10;
							SaveGameIni(BurnDrvGetTextA(0));
							exitGameMenu = true;
							DxSoundPlay();
							SetDelay();
							return;
						}
						
					}
				}

				Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
				Device->SetTexture(0,TexOption);
				DrawBackground();
				if(arcadeSettings.size() == 0) {
					DisplayCenteredMsg("No arcade settings found", 190); 
				}
				else {
					DrawArcadeSettingsMenu();
				}
				Present();
			}
		}

		if(GameOptionSelected == 13) {
//			SaveScreenIni();
			//////////dprintf("SaveGameIni\n");
			SaveGameIni(BurnDrvGetTextA(0));
			//////////dprintf("StatedAuto\n");
			StatedAuto(1);
			//////////dprintf("HiscoreExit\n");
			HiscoreExit();
			//////////dprintf("ReturnToGUI\n");
			ReturnToGUI();
		}
	}
}

void DrawGameOptionItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(GameOptionSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawGameOptionMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	SetupMatrices();
	DrawBackground();
	Device->SetTexture(0,TexScreen);
	exitEmulation = true;
	MakeVertexListExitGame();
	exitEmulation = false;
	D3DXMATRIX q;
	D3DXMatrixRotationZ(&q, RotationDegrees * (3.14/180));
	Device->SetTransform(D3DTS_WORLD, &q);
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	if(zoomOver >= 4) {
		for(int i = 0; i < GameOptionItems.size(); i++) {
			DrawGameOptionItem(i, (char*)GameOptionItems[i].c_str(), GameOptionPosX, GameOptionPosY + (i * vSpace));
		}
	}
	Present();
}

void GameOptionMenu() {
	ResetScreenSaver();
	if(RotationDegrees == 0) {
		zLeftExitGame = zLeft0;
		zRightExitGame = zRight0;
		zTopExitGame = zTop0;
		zBottomExitGame = zBottom0;
	}
	if(RotationDegrees == 90) {
		zLeftExitGame = zLeft90;
		zRightExitGame = zRight90;
		zTopExitGame = zTop90;
		zBottomExitGame = zBottom90;
	}
	if(RotationDegrees == 180) {
		zLeftExitGame = zLeft180;
		zRightExitGame = zRight180;
		zTopExitGame = zTop180;
		zBottomExitGame = zBottom180;
	}
	if(RotationDegrees == 270) {
		zLeftExitGame = zLeft270;
		zRightExitGame = zRight270;
		zTopExitGame = zTop270;
		zBottomExitGame = zBottom270;
	}
	zLeftScale = zBaseLeft + zLeft;
	zRightScale = zBaseRight + zRight;
	zTopScale = zBaseTop + zTop;
	zBottomScale = zBaseBottom + zBottom;
	leftMove = ((zLeftExitGame - (zLeftScale)) / zoomSpeed);
	rightMove = (((zRightScale) - zRightExitGame) / zoomSpeed);
	topMove = (((zTopScale) - zTopExitGame) / zoomSpeed); 
	bottomMove = ((zBottomExitGame - (zBottomScale)) / zoomSpeed);
	zoomOver = 0;

	GameOptionSelected = 0;
	while(!exitGameMenu) {
		SetupMatrices();
		if(GUIState == 4) {
			OptionVideoMenu();
		}
		if(GUIState == 5) {
			OptionSoundMenu();
		}
		/*if(GUIState == 6) {
		OptionControllerMenu();
		}*/
		if(GUIState == 8) {
			OptionVideoScaleMenu();
		}
		//if(GUIState == 9) {
		//	OptionControllerButtonMenu();
		//}

		if(GUIState == 10) {
			OptionSaveStateMenu();
		}

		if(GUIState == 11) {
			OptionLoadStateMenu();
		}

		if(GUIState == 12) {
			GuideListMenu();
		}

		if(GUIState == 1 || GUIState == 2) {
			GameOptionInput();
			DrawGameOptionMenu();
		}
		updateEffect();
	}
	SetupMatricesEmulation();
	MakeVertexList();
	Device->SetTexture(0,TexScreen);
}