// Irem M92 system games:
//
// port from MAME by OopsWare
//

#include "burnint.h"

extern unsigned char m92Button[];
extern unsigned char m92Joy1[];
extern unsigned char m92Joy2[];
extern unsigned char m92Joy3[];
extern unsigned char m92Joy4[];
extern unsigned char m92Input[];

extern unsigned char bRecalcPalette;
extern unsigned char m92Reset;


int hookInit();
int hookExit();
int hookFrame();

int inthuntInit();
int inthuntFrame();

int rtypeleoInit();
int rtypeleoExit();
int rtypeleoFrame();

int DrvScan(int nAction,int *pnMin);



static struct BurnInputInfo hookInputList[] = {
	{"P1 Coin",		BIT_DIGITAL,	m92Button + 2,	"p1 coin"},
	{"P1 Start",	BIT_DIGITAL,	m92Button + 0,	"p1 start"},

	{"P1 Up",		BIT_DIGITAL,	m92Joy1 + 3,	"p1 up"},
	{"P1 Down",		BIT_DIGITAL,	m92Joy1 + 2,	"p1 down"},
	{"P1 Left",		BIT_DIGITAL,	m92Joy1 + 1,	"p1 left"},
	{"P1 Right",	BIT_DIGITAL,	m92Joy1 + 0,	"p1 right"},
	{"P1 Button 1",	BIT_DIGITAL,	m92Joy1 + 7,	"p1 fire 1"},
	{"P1 Button 2",	BIT_DIGITAL,	m92Joy1 + 6,	"p1 fire 2"},

	{"P2 Coin",		BIT_DIGITAL,	m92Button + 3,	"p2 coin"},
	{"P2 Start",	BIT_DIGITAL,	m92Button + 1,	"p2 start"},

	{"P2 Up",		BIT_DIGITAL,	m92Joy2 + 3,	"p2 up"},
	{"P2 Down",		BIT_DIGITAL,	m92Joy2 + 2,	"p2 down"},
	{"P2 Left",		BIT_DIGITAL,	m92Joy2 + 1,	"p2 left"},
	{"P2 Right",	BIT_DIGITAL,	m92Joy2 + 0,	"p2 right"},
	{"P2 Button 1",	BIT_DIGITAL,	m92Joy2 + 7,	"p2 fire 1"},
	{"P2 Button 2",	BIT_DIGITAL,	m92Joy2 + 6,	"p2 fire 2"},

	{"P3 Coin",		BIT_DIGITAL,	m92Joy3 + 5,	"p3 coin"},
	{"P3 Start",	BIT_DIGITAL,	m92Joy3 + 4,	"p3 start"},

	{"P3 Up",		BIT_DIGITAL,	m92Joy3 + 3,	"p3 up"},
	{"P3 Down",		BIT_DIGITAL,	m92Joy3 + 2,	"p3 down"},
	{"P3 Left",		BIT_DIGITAL,	m92Joy3 + 1,	"p3 left"},
	{"P3 Right",	BIT_DIGITAL,	m92Joy3 + 0,	"p3 right"},
	{"P3 Button 1",	BIT_DIGITAL,	m92Joy3 + 7,	"p3 fire 1"},
	{"P3 Button 2",	BIT_DIGITAL,	m92Joy3 + 6,	"p3 fire 2"},

	{"P4 Coin",		BIT_DIGITAL,	m92Joy4 + 5,	"p4 coin"},
	{"P4 Start",	BIT_DIGITAL,	m92Joy4 + 4,	"p4 start"},

	{"P4 Up",		BIT_DIGITAL,	m92Joy4 + 3,	"p4 up"},
	{"P4 Down",		BIT_DIGITAL,	m92Joy4 + 2,	"p4 down"},
	{"P4 Left",		BIT_DIGITAL,	m92Joy4 + 1,	"p4 left"},
	{"P4 Right",	BIT_DIGITAL,	m92Joy4 + 0,	"p4 right"},
	{"P4 Button 1",	BIT_DIGITAL,	m92Joy4 + 7,	"p4 fire 1"},
	{"P4 Button 2",	BIT_DIGITAL,	m92Joy4 + 6,	"p4 fire 2"},

	{"Reset",		BIT_DIGITAL,	&m92Reset,		"reset"},
	{"Dip A",		BIT_DIPSWITCH,	m92Input + 5,	"dip"},
	{"Dip B",		BIT_DIPSWITCH,	m92Input + 6,	"dip"},
	{"Dip C",		BIT_DIPSWITCH,	m92Input + 7,	"dip"},
};

STDINPUTINFO(hook)

static struct BurnDIPInfo hookDIPList[] = {

	// Defaults
	{0x21,	0xFF, 0xFF,	0x00, NULL},
	{0x22,	0xFF, 0xFF,	0x00, NULL},
	{0x23,	0xFF, 0xFF,	0x00, NULL},

	{0,		0xFE, 0,	2,	  "Flip Screen"},
	{0x21,	0x01, 0x01,	0x00, "Off"},
	{0x21,	0x01, 0x01,	0x01, "On"},
	{0,		0xFE, 0,	2,	  "Cabinet"},
	{0x21,	0x01, 0x02,	0x00, "2 Players"},
	{0x21,	0x01, 0x02,	0x02, "4 Players"},
	{0,		0xFE, 0,	2,	  "Coin Slots"},
	{0x21,	0x01, 0x04,	0x00, "Common"},
	{0x21,	0x01, 0x04,	0x04, "Separate"},
	{0,		0xFE, 0,	2,	  "Coin Mode"},
	{0x21,	0x01, 0x08,	0x00, "1"},
	{0x21,	0x01, 0x08,	0x08, "2"},
	{0,		0xFE, 0,	16,	  "Coinage"},
	{0x21,	0x01, 0xf0,	0x00, "1C_1C"},
	{0x21,	0x01, 0xf0,	0x10, "2C_1C"},
	{0x21,	0x01, 0xf0,	0x20, "3C_1C"},
	{0x21,	0x01, 0xf0,	0x30, "4C_1C"},
	{0x21,	0x01, 0xf0,	0x40, "5C_1C"},
	{0x21,	0x01, 0xf0,	0x50, "6C_1C"},
	{0x21,	0x01, 0xf0,	0x60, "1C_2C"},
	{0x21,	0x01, 0xf0,	0x70, "1C_3C"},
	{0x21,	0x01, 0xf0,	0x80, "1C_4C"},
	{0x21,	0x01, 0xf0,	0x90, "1C_5C"},
	{0x21,	0x01, 0xf0,	0xa0, "1C_6C"},
	{0x21,	0x01, 0xf0,	0xb0, "2C_3C"},
	{0x21,	0x01, 0xf0,	0xc0, "3C_2C"},
	{0x21,	0x01, 0xf0,	0xd0, "4C_3C"},
	{0x21,	0x01, 0xf0,	0xe0, "2 Coins to Start, 1 to Continue"},
	{0x21,	0x01, 0xf0,	0xf0, "Free Play"},

	// DIP 2
	{0,		0xFE, 0,	4,	  "Lives"},
	{0x22,	0x01, 0x03, 0x00, "2"},
	{0x22,	0x01, 0x03, 0x01, "3"},
	{0x22,	0x01, 0x03, 0x02, "4"},
	{0x22,	0x01, 0x03, 0x03, "1"},
	{0,		0xFE, 0,	4,	  "Difficulty"},
	{0x22,	0x01, 0x0C, 0x00, "Normal"},
	{0x22,	0x01, 0x0C, 0x04, "Easy"},
	{0x22,	0x01, 0x0C, 0x08, "Hard"},
	{0x22,	0x01, 0x0C, 0x0C, "Very Easy"},
	{0,		0xFE, 0,	2,	  "Any Button to Start"},
	{0x22,	0x01, 0x20, 0x00, "Yes"},
	{0x22,	0x01, 0x20, 0x20, "No"},
	{0,		0xFE, 0,	2,	  "Demo Sounds"},
	{0x22,	0x01, 0x40, 0x00, "Off"},
	{0x22,	0x01, 0x40, 0x40, "On"},
	{0,		0xFE, 0,	2,	  "Service"},
	{0x22,	0x01, 0x80, 0x00, "Off"},
	{0x22,	0x01, 0x80, 0x80, "On"},

};

STDDIPINFO(hook)


static struct BurnInputInfo inthuntInputList[] = {
	{"P1 Coin",		BIT_DIGITAL,	m92Button + 2,	"p1 coin"},
	{"P1 Start",	BIT_DIGITAL,	m92Button + 0,	"p1 start"},

	{"P1 Up",		BIT_DIGITAL,	m92Joy1 + 3,	"p1 up"},
	{"P1 Down",		BIT_DIGITAL,	m92Joy1 + 2,	"p1 down"},
	{"P1 Left",		BIT_DIGITAL,	m92Joy1 + 1,	"p1 left"},
	{"P1 Right",	BIT_DIGITAL,	m92Joy1 + 0,	"p1 right"},
	{"P1 Button 1",	BIT_DIGITAL,	m92Joy1 + 7,	"p1 fire 1"},
	{"P1 Button 2",	BIT_DIGITAL,	m92Joy1 + 6,	"p1 fire 2"},

	{"P2 Coin",		BIT_DIGITAL,	m92Button + 3,	"p2 coin"},
	{"P2 Start",	BIT_DIGITAL,	m92Button + 1,	"p2 start"},

	{"P2 Up",		BIT_DIGITAL,	m92Joy2 + 3,	"p2 up"},
	{"P2 Down",		BIT_DIGITAL,	m92Joy2 + 2,	"p2 down"},
	{"P2 Left",		BIT_DIGITAL,	m92Joy2 + 1,	"p2 left"},
	{"P2 Right",	BIT_DIGITAL,	m92Joy2 + 0,	"p2 right"},
	{"P2 Button 1",	BIT_DIGITAL,	m92Joy2 + 7,	"p2 fire 1"},
	{"P2 Button 2",	BIT_DIGITAL,	m92Joy2 + 6,	"p2 fire 2"},

	{"Reset",		BIT_DIGITAL,	&m92Reset,		"reset"},
	{"Dip A",		BIT_DIPSWITCH,	m92Input + 5,	"dip"},
	{"Dip B",		BIT_DIPSWITCH,	m92Input + 6,	"dip"},
	{"Dip C",		BIT_DIPSWITCH,	m92Input + 7,	"dip"},
};

STDINPUTINFO(inthunt)

static struct BurnDIPInfo inthuntDIPList[] = {

	// Defaults
	{0x11,	0xFF, 0xFF,	0x00, NULL},
	{0x12,	0xFF, 0xFF,	0x00, NULL},
	{0x13,	0xFF, 0xFF,	0x00, NULL},

	{0,		0xFE, 0,	2,	  "Flip Screen"},
	{0x11,	0x01, 0x01,	0x00, "Off"},
	{0x11,	0x01, 0x01,	0x01, "On"},
//	{0,		0xFE, 0,	2,	  "Unknown"},
//	{0x11,	0x01, 0x02,	0x00, "Off"},
//	{0x11,	0x01, 0x02,	0x02, "On"},
	{0,		0xFE, 0,	2,	  "Coin Slots"},
	{0x11,	0x01, 0x04,	0x00, "Common"},
	{0x11,	0x01, 0x04,	0x04, "Separate"},
	{0,		0xFE, 0,	2,	  "Coin Mode"},
	{0x11,	0x01, 0x08,	0x00, "1"},
	{0x11,	0x01, 0x08,	0x08, "2"},
	{0,		0xFE, 0,	16,	  "Coinage"},
	{0x11,	0x01, 0xf0,	0x00, "1C_1C"},
	{0x11,	0x01, 0xf0,	0x10, "2C_1C"},
	{0x11,	0x01, 0xf0,	0x20, "3C_1C"},
	{0x11,	0x01, 0xf0,	0x30, "4C_1C"},
	{0x11,	0x01, 0xf0,	0x40, "5C_1C"},
	{0x11,	0x01, 0xf0,	0x50, "6C_1C"},
	{0x11,	0x01, 0xf0,	0x60, "1C_2C"},
	{0x11,	0x01, 0xf0,	0x70, "1C_3C"},
	{0x11,	0x01, 0xf0,	0x80, "1C_4C"},
	{0x11,	0x01, 0xf0,	0x90, "1C_5C"},
	{0x11,	0x01, 0xf0,	0xa0, "1C_6C"},
	{0x11,	0x01, 0xf0,	0xb0, "2C_3C"},
	{0x11,	0x01, 0xf0,	0xc0, "3C_2C"},
	{0x11,	0x01, 0xf0,	0xd0, "4C_3C"},
	{0x11,	0x01, 0xf0,	0xe0, "2 Coins to Start, 1 to Continue"},
	{0x11,	0x01, 0xf0,	0xf0, "Free Play"},

	// DIP 2
	{0,		0xFE, 0,	4,	  "Lives"},
	{0x12,	0x01, 0x03, 0x00, "2"},
	{0x12,	0x01, 0x03, 0x01, "3"},
	{0x12,	0x01, 0x03, 0x02, "4"},
	{0x12,	0x01, 0x03, 0x03, "1"},
	{0,		0xFE, 0,	4,	  "Difficulty"},
	{0x12,	0x01, 0x0C, 0x00, "Normal"},
	{0x12,	0x01, 0x0C, 0x04, "Easy"},
	{0x12,	0x01, 0x0C, 0x08, "Hard"},
	{0x12,	0x01, 0x0C, 0x0C, "Very Easy"},
	{0,		0xFE, 0,	2,	  "Any Button to Start"},
	{0x12,	0x01, 0x20, 0x00, "Yes"},
	{0x12,	0x01, 0x20, 0x20, "No"},
	{0,		0xFE, 0,	2,	  "Demo Sounds"},
	{0x12,	0x01, 0x40, 0x00, "Off"},
	{0x12,	0x01, 0x40, 0x40, "On"},
	{0,		0xFE, 0,	2,	  "Service"},
	{0x12,	0x01, 0x80, 0x00, "Off"},
	{0x12,	0x01, 0x80, 0x80, "On"},

};

STDDIPINFO(inthunt)

// Rom information

static struct BurnRomInfo hookRomDesc[] = {
	{ "h-h0-d.3h",		0x040000, 0x40189ff6, BRF_ESS | BRF_PRG },	// CPU 0, V33
	{ "h-l0-d.3h",		0x040000, 0x14567690, BRF_ESS | BRF_PRG },
	{ "h-h1.rom",		0x020000, 0x264ba1f0, BRF_ESS | BRF_PRG },
	{ "h-l1.rom",		0x020000, 0xf9913731, BRF_ESS | BRF_PRG },

	{ "h-sh0.rom",		0x010000, 0x86a4e56e, BRF_ESS | BRF_PRG },	// CPU 1, V30
	{ "h-sl0.rom",		0x010000, 0x10fd9676, BRF_ESS | BRF_PRG },

	{ "hook-c0.rom",	0x040000, 0xdec63dcf, BRF_GRA }, 			// Tiles
	{ "hook-c1.rom",	0x040000, 0xe4eb0b92, BRF_GRA },
	{ "hook-c2.rom",	0x040000, 0xa52b320b, BRF_GRA },
	{ "hook-c3.rom",	0x040000, 0x7ef67731, BRF_GRA },

	{ "hook-000.rom",	0x100000, 0xccceac30, BRF_GRA },        	// Sprites
	{ "hook-010.rom",	0x100000, 0x8ac8da67, BRF_GRA },
	{ "hook-020.rom",	0x100000, 0x8847af9a, BRF_GRA },
	{ "hook-030.rom",	0x100000, 0x239e877e, BRF_GRA },

	{ "hook-da.rom",	0x080000, 0x88cd0212, BRF_SND }, 			// Sound
};

STD_ROM_PICK(hook)
STD_ROM_FN(hook)

static struct BurnRomInfo hookuRomDesc[] = {
	{ "h-h0-c.3h",		0x040000, 0x84cc239e, BRF_ESS | BRF_PRG },	// CPU 0, V33
	{ "h-l0-c.5h",		0x040000, 0x45e194fe, BRF_ESS | BRF_PRG },
	{ "h-h1.rom",		0x020000, 0x264ba1f0, BRF_ESS | BRF_PRG },
	{ "h-l1.rom",		0x020000, 0xf9913731, BRF_ESS | BRF_PRG },

	{ "h-sh0.rom",		0x010000, 0x86a4e56e, BRF_ESS | BRF_PRG },	// CPU 1, V30
	{ "h-sl0.rom",		0x010000, 0x10fd9676, BRF_ESS | BRF_PRG },

	{ "hook-c0.rom",	0x040000, 0xdec63dcf, BRF_GRA }, 			// Tiles
	{ "hook-c1.rom",	0x040000, 0xe4eb0b92, BRF_GRA },
	{ "hook-c2.rom",	0x040000, 0xa52b320b, BRF_GRA },
	{ "hook-c3.rom",	0x040000, 0x7ef67731, BRF_GRA },

	{ "hook-000.rom",	0x100000, 0xccceac30, BRF_GRA },        	// Sprites
	{ "hook-010.rom",	0x100000, 0x8ac8da67, BRF_GRA },
	{ "hook-020.rom",	0x100000, 0x8847af9a, BRF_GRA },
	{ "hook-030.rom",	0x100000, 0x239e877e, BRF_GRA },

	{ "hook-da.rom",	0x080000, 0x88cd0212, BRF_SND }, 			// Sound
};

STD_ROM_PICK(hooku)
STD_ROM_FN(hooku)

static struct BurnRomInfo hookjRomDesc[] = {
	{ "h-h0-g.3h",		0x040000, 0x5964c886, BRF_ESS | BRF_PRG },	// CPU 0, V33
	{ "h-l0-g.5h",		0x040000, 0x7f7433f2, BRF_ESS | BRF_PRG },
	{ "h-h1.rom",		0x020000, 0x264ba1f0, BRF_ESS | BRF_PRG },
	{ "h-l1.rom",		0x020000, 0xf9913731, BRF_ESS | BRF_PRG },

	{ "h-sh0-a.3l",		0x010000, 0xbd3d1f61, BRF_ESS | BRF_PRG },	// CPU 1, V30
	{ "h-sl0-a.3n",		0x010000, 0x76371def, BRF_ESS | BRF_PRG },

	{ "hook-c0.rom",	0x040000, 0xdec63dcf, BRF_GRA }, 			// Tiles
	{ "hook-c1.rom",	0x040000, 0xe4eb0b92, BRF_GRA },
	{ "hook-c2.rom",	0x040000, 0xa52b320b, BRF_GRA },
	{ "hook-c3.rom",	0x040000, 0x7ef67731, BRF_GRA },

	{ "hook-000.rom",	0x100000, 0xccceac30, BRF_GRA },        	// Sprites
	{ "hook-010.rom",	0x100000, 0x8ac8da67, BRF_GRA },
	{ "hook-020.rom",	0x100000, 0x8847af9a, BRF_GRA },
	{ "hook-030.rom",	0x100000, 0x239e877e, BRF_GRA },

	{ "hook-da.rom",	0x080000, 0x88cd0212, BRF_SND }, 			// Sound
};

STD_ROM_PICK(hookj)
STD_ROM_FN(hookj)

static struct BurnRomInfo inthuntRomDesc[] = {
	{ "ith-h0-d.bin",	0x040000, 0x52f8e7a6, BRF_ESS | BRF_PRG },	// CPU 0, V33
	{ "ith-l0-d.bin",	0x040000, 0x5db79eb7, BRF_ESS | BRF_PRG },
	{ "ith-h1-b.bin",	0x020000, 0xfc2899df, BRF_ESS | BRF_PRG },
	{ "ith-l1-b.bin",	0x020000, 0x955a605a, BRF_ESS | BRF_PRG },

	{ "ith-sh0.rom",	0x010000, 0x209c8b7f, BRF_ESS | BRF_PRG },	// CPU 1, V30
	{ "ith-sl0.rom",	0x010000, 0x18472d65, BRF_ESS | BRF_PRG },

	{ "ith_ic26.rom",	0x080000, 0x4c1818cf, BRF_GRA }, 			// Tiles
	{ "ith_ic25.rom",	0x080000, 0x91145bae, BRF_GRA },
	{ "ith_ic24.rom",	0x080000, 0xfc03fe3b, BRF_GRA },
	{ "ith_ic23.rom",	0x080000, 0xee156a0a, BRF_GRA },

	{ "ith_ic34.rom",	0x100000, 0xa019766e, BRF_GRA },        	// Sprites
	{ "ith_ic35.rom",	0x100000, 0x3fca3073, BRF_GRA },
	{ "ith_ic36.rom",	0x100000, 0x20d1b28b, BRF_GRA },
	{ "ith_ic37.rom",	0x100000, 0x90b6fd4b, BRF_GRA },

	{ "ith_ic9.rom",	0x080000, 0x318ee71a, BRF_SND }, 			// Sound
};

STD_ROM_PICK(inthunt)
STD_ROM_FN(inthunt)

static struct BurnRomInfo inthuntuRomDesc[] = {
	{ "ith-h0-c.bin",	0x040000, 0x563dcec0, BRF_ESS | BRF_PRG },	// CPU 0, V33
	{ "ith-l0-c.bin",	0x040000, 0x1638c705, BRF_ESS | BRF_PRG },
	{ "ith-h1-a.bin",	0x020000, 0x0253065f, BRF_ESS | BRF_PRG },
	{ "ith-l1-a.bin",	0x020000, 0xa57d688d, BRF_ESS | BRF_PRG },

	{ "ith-sh0.rom",	0x010000, 0x209c8b7f, BRF_ESS | BRF_PRG },	// CPU 1, V30
	{ "ith-sl0.rom",	0x010000, 0x18472d65, BRF_ESS | BRF_PRG },

	{ "ith_ic26.rom",	0x080000, 0x4c1818cf, BRF_GRA }, 			// Tiles
	{ "ith_ic25.rom",	0x080000, 0x91145bae, BRF_GRA },
	{ "ith_ic24.rom",	0x080000, 0xfc03fe3b, BRF_GRA },
	{ "ith_ic23.rom",	0x080000, 0xee156a0a, BRF_GRA },

	{ "ith_ic34.rom",	0x100000, 0xa019766e, BRF_GRA },        	// Sprites
	{ "ith_ic35.rom",	0x100000, 0x3fca3073, BRF_GRA },
	{ "ith_ic36.rom",	0x100000, 0x20d1b28b, BRF_GRA },
	{ "ith_ic37.rom",	0x100000, 0x90b6fd4b, BRF_GRA },

	{ "ith_ic9.rom",	0x080000, 0x318ee71a, BRF_SND }, 			// Sound
};

STD_ROM_PICK(inthuntu)
STD_ROM_FN(inthuntu)

static struct BurnRomInfo kaiteidsRomDesc[] = {
	{ "ith-h0j.bin",	0x040000, 0xdc1dec36, BRF_ESS | BRF_PRG },	// CPU 0, V33
	{ "ith-l0j.bin",	0x040000, 0x8835d704, BRF_ESS | BRF_PRG },
	{ "ith-h1j.bin",	0x020000, 0x5a7b212d, BRF_ESS | BRF_PRG },
	{ "ith-l1j.bin",	0x020000, 0x4c084494, BRF_ESS | BRF_PRG },

	{ "ith-sh0.rom",	0x010000, 0x209c8b7f, BRF_ESS | BRF_PRG },	// CPU 1, V30
	{ "ith-sl0.rom",	0x010000, 0x18472d65, BRF_ESS | BRF_PRG },

	{ "ith_ic26.rom",	0x080000, 0x4c1818cf, BRF_GRA }, 			// Tiles
	{ "ith_ic25.rom",	0x080000, 0x91145bae, BRF_GRA },
	{ "ith_ic24.rom",	0x080000, 0xfc03fe3b, BRF_GRA },
	{ "ith_ic23.rom",	0x080000, 0xee156a0a, BRF_GRA },

	{ "ith_ic34.rom",	0x100000, 0xa019766e, BRF_GRA },        	// Sprites
	{ "ith_ic35.rom",	0x100000, 0x3fca3073, BRF_GRA },
	{ "ith_ic36.rom",	0x100000, 0x20d1b28b, BRF_GRA },
	{ "ith_ic37.rom",	0x100000, 0x90b6fd4b, BRF_GRA },

	{ "ith_ic9.rom",	0x080000, 0x318ee71a, BRF_SND }, 			// Sound
};

STD_ROM_PICK(kaiteids)
STD_ROM_FN(kaiteids)

/*static struct BurnRomInfo rtypeleoRomDesc[] = {
	{ "rtl-h0-c.bin",	0x040000, 0x5fef7fa1, BRF_ESS | BRF_PRG },	// CPU 0, V33
	{ "rtl-l0-c.bin",	0x040000, 0x8156456b, BRF_ESS | BRF_PRG },
	{ "rtl-h1-d.bin",	0x020000, 0x352ff444, BRF_ESS | BRF_PRG },
	{ "rtl-l1-d.bin",	0x020000, 0xfd34ea46, BRF_ESS | BRF_PRG },

	{ "rtl-sh0a.bin",	0x010000, 0xe518b4e3, BRF_ESS | BRF_PRG },	// CPU 1, V30
	{ "rtl-sl0a.bin",	0x010000, 0x896f0d36, BRF_ESS | BRF_PRG },

	{ "rtl-c0.bin",		0x080000, 0xfb588d7c, BRF_GRA }, 			// Tiles
	{ "rtl-c1.bin",		0x080000, 0xe5541bff, BRF_GRA },
	{ "rtl-c2.bin",		0x080000, 0xfaa9ae27, BRF_GRA },
	{ "rtl-c3.bin",		0x080000, 0x3a2343f6, BRF_GRA },

	{ "rtl-000.bin",	0x100000, 0x82a06870, BRF_GRA },        	// Sprites
	{ "rtl-010.bin",	0x100000, 0x417e7a56, BRF_GRA },
	{ "rtl-020.bin",	0x100000, 0xf9a3f3a1, BRF_GRA },
	{ "rtl-030.bin",	0x100000, 0x03528d95, BRF_GRA },

	{ "rtl-da.bin",		0x080000, 0xdbebd1ff, BRF_SND }, 			// Sound
};

STD_ROM_PICK(rtypeleo)
STD_ROM_FN(rtypeleo)

static struct BurnRomInfo rtypelejRomDesc[] = {
	{ "rtl-h0-d.bin",	0x040000, 0x3dbac89f, BRF_ESS | BRF_PRG },	// CPU 0, V33
	{ "rtl-l0-d.bin",	0x040000, 0xf85a2537, BRF_ESS | BRF_PRG },
	{ "rtl-h1-d.bin",	0x020000, 0x352ff444, BRF_ESS | BRF_PRG },
	{ "rtl-l1-d.bin",	0x020000, 0xfd34ea46, BRF_ESS | BRF_PRG },

	{ "rtl-sh0a.bin",	0x010000, 0xe518b4e3, BRF_ESS | BRF_PRG },	// CPU 1, V30
	{ "rtl-sl0a.bin",	0x010000, 0x896f0d36, BRF_ESS | BRF_PRG },

	{ "rtl-c0.bin",		0x080000, 0xfb588d7c, BRF_GRA }, 			// Tiles
	{ "rtl-c1.bin",		0x080000, 0xe5541bff, BRF_GRA },
	{ "rtl-c2.bin",		0x080000, 0xfaa9ae27, BRF_GRA },
	{ "rtl-c3.bin",		0x080000, 0x3a2343f6, BRF_GRA },

	{ "rtl-000.bin",	0x100000, 0x82a06870, BRF_GRA },        	// Sprites
	{ "rtl-010.bin",	0x100000, 0x417e7a56, BRF_GRA },
	{ "rtl-020.bin",	0x100000, 0xf9a3f3a1, BRF_GRA },
	{ "rtl-030.bin",	0x100000, 0x03528d95, BRF_GRA },

	{ "rtl-da.bin",		0x080000, 0xdbebd1ff, BRF_SND }, 			// Sound
};

STD_ROM_PICK(rtypelej)
STD_ROM_FN(rtypelej)*/

struct BurnDriver BurnDrvHook = {
	"hook", NULL, NULL, NULL, "1992",
	"Hook (World)\0", "Preliminary driver", "Irem", "M92 Old",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 4, HARDWARE_MISC_POST90S, GBF_SCRFIGHT, 0,
	NULL, hookRomInfo, hookRomName, NULL, NULL, hookInputInfo, hookDIPInfo,
	hookInit, hookExit, hookFrame, NULL, DrvScan, &bRecalcPalette, 0x1000,
	320, 240, 4, 3
};

struct BurnDriver BurnDrvHooku = {
	"hooku", "hook", NULL, NULL, "1992",
	"Hook (US)\0", "Preliminary driver", "Irem America", "M92 Old",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_16BIT_ONLY, 4, HARDWARE_MISC_POST90S, GBF_SCRFIGHT, 0,
	NULL, hookuRomInfo, hookuRomName, NULL, NULL, hookInputInfo, hookDIPInfo,
	hookInit, hookExit, hookFrame, NULL, DrvScan, &bRecalcPalette, 0x1000,
	320, 240, 4, 3
};

struct BurnDriver BurnDrvHookj = {
	"hookj", "hook", NULL, NULL, "1992",
	"Hook (Japan)\0", "Preliminary driver", "Irem", "M92 Old",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_16BIT_ONLY, 4, HARDWARE_MISC_POST90S, GBF_SCRFIGHT, 0,
	NULL, hookjRomInfo, hookjRomName, NULL, NULL, hookInputInfo, hookDIPInfo,
	hookInit, hookExit, hookFrame, NULL, DrvScan, &bRecalcPalette, 0x1000,
	320, 240, 4, 3
};

struct BurnDriver BurnDrvInthunt = {
	"inthunt", NULL, NULL, NULL, "1993",
	"In The Hunt (World)\0", "Preliminary driver", "Irem", "M92 Old",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_MISC_POST90S, GBF_HORSHOOT, 0,
	NULL, inthuntRomInfo, inthuntRomName, NULL, NULL, inthuntInputInfo, inthuntDIPInfo,
	inthuntInit, hookExit, inthuntFrame, NULL, DrvScan, &bRecalcPalette, 0x1000,
	320, 240, 4, 3
};

struct BurnDriver BurnDrvInthuntu = {
	"inthuntu", "inthunt", NULL, NULL, "1993",
	"In The Hunt (US)\0", "Preliminary driver", "Irem America", "M92 Old",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_16BIT_ONLY, 2, HARDWARE_MISC_POST90S, GBF_HORSHOOT, 0,
	NULL, inthuntuRomInfo, inthuntuRomName, NULL, NULL, inthuntInputInfo, inthuntDIPInfo,
	inthuntInit, hookExit, inthuntFrame, NULL, DrvScan, &bRecalcPalette, 0x1000,
	320, 240, 4, 3
};

struct BurnDriver BurnDrvKaiteids = {
	"kaiteids", "inthunt", NULL, NULL, "1993",
	"Kaitei Daisensou (Japan)\0", "Preliminary driver", "Irem", "M92 Old",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_CLONE | BDF_16BIT_ONLY, 2, HARDWARE_MISC_POST90S, GBF_HORSHOOT, 0,
	NULL, kaiteidsRomInfo, kaiteidsRomName, NULL, NULL, inthuntInputInfo, inthuntDIPInfo,
	inthuntInit, hookExit, inthuntFrame, NULL, DrvScan, &bRecalcPalette, 0x1000,
	320, 240, 4, 3
};

/*struct BurnDriverD BurnDrvRtypeleo = {
	"rtypeleo", NULL, NULL, "1992",
	"R-Type Leo (World)\0", "Preliminary driver", "Irem", "Miscellaneous",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_MISC_POST90S, GBF_HORSHOOT, 0,
	NULL, rtypeleoRomInfo, rtypeleoRomName, inthuntInputInfo, inthuntDIPInfo,
	rtypeleoInit, rtypeleoExit, rtypeleoFrame, NULL, DrvScan, 0, NULL, NULL, NULL, &bRecalcPalette, 0x1000,
	320, 240, 4, 3
};

struct BurnDriverD BurnDrvRtypelej = {
	"rtypeleoj", "rtypeleo", NULL, "1992",
	"R-Type Leo (Japan)\0", "Preliminary driver", "Irem", "Miscellaneous",
	NULL, NULL, NULL, NULL,
	BDF_CLONE | BDF_16BIT_ONLY, 2, HARDWARE_MISC_POST90S, GBF_HORSHOOT, 0,
	NULL, rtypelejRomInfo, rtypelejRomName, inthuntInputInfo, inthuntDIPInfo,
	rtypeleoInit, rtypeleoExit, rtypeleoFrame, NULL, DrvScan, 0, NULL, NULL, NULL, &bRecalcPalette, 0x1000,
	320, 240, 4, 3
};*/
