#include "megadrive.h"
#include "burnint.h"

// Driver generated by database on http://www.barryharris.me.uk

static struct BurnInputInfo MegadriveInputList[] = {
	{"P1 Start",		BIT_DIGITAL,	MegadriveJoy1 +  7, "p1 start"  },
	{"P1 Up",		BIT_DIGITAL,	MegadriveJoy1 +  0, "p1 up"     },
	{"P1 Down",		BIT_DIGITAL,	MegadriveJoy1 +  1, "p1 down"   },
	{"P1 Left",		BIT_DIGITAL,	MegadriveJoy1 +  2, "p1 left"   },
	{"P1 Right",		BIT_DIGITAL,	MegadriveJoy1 +  3, "p1 right"  },
	{"P1 Button A",		BIT_DIGITAL,	MegadriveJoy1 +  6, "p1 fire 1" },
	{"P1 Button B",		BIT_DIGITAL,	MegadriveJoy1 +  4, "p1 fire 2" },
	{"P1 Button C",		BIT_DIGITAL,	MegadriveJoy1 +  5, "p1 fire 3" },
	{"P1 Button X",		BIT_DIGITAL,	MegadriveJoy1 + 10, "p1 fire 4" },
	{"P1 Button Y",		BIT_DIGITAL,	MegadriveJoy1 +  9, "p1 fire 5" },
	{"P1 Button Z",		BIT_DIGITAL,	MegadriveJoy1 +  8, "p1 fire 6" },
	{"P1 Mode",		BIT_DIGITAL,	MegadriveJoy1 + 11, "p1 select" },

	{"P2 Start",		BIT_DIGITAL,	MegadriveJoy2 +  7, "p2 start"  },
	{"P2 Up",		BIT_DIGITAL,	MegadriveJoy2 +  0, "p2 up"     },
	{"P2 Down",		BIT_DIGITAL,	MegadriveJoy2 +  1, "p2 down"   },
	{"P2 Left",		BIT_DIGITAL,	MegadriveJoy2 +  2, "p2 left"   },
	{"P2 Right",		BIT_DIGITAL,	MegadriveJoy2 +  3, "p2 right"  },
	{"P2 Button A",		BIT_DIGITAL,	MegadriveJoy2 +  6, "p2 fire 1" },
	{"P2 Button B",		BIT_DIGITAL,	MegadriveJoy2 +  4, "p2 fire 2" },
	{"P2 Button C",		BIT_DIGITAL,	MegadriveJoy2 +  5, "p2 fire 3" },
	{"P2 Button X",		BIT_DIGITAL,	MegadriveJoy2 + 10, "p2 fire 4" },
	{"P2 Button Y",		BIT_DIGITAL,	MegadriveJoy2 +  9, "p2 fire 5" },
	{"P2 Button Z",		BIT_DIGITAL,	MegadriveJoy2 +  8, "p2 fire 6" },
	{"P2 Mode",		BIT_DIGITAL,	MegadriveJoy2 + 11, "p2 select" },

	{"Reset",		BIT_DIGITAL,	&MegadriveReset,     "reset"    },
	{"Dip A",		BIT_DIPSWITCH,	MegadriveDIP  + 0,   "dip"      },
	{"Dip B",		BIT_DIPSWITCH,	MegadriveDIP  + 1,   "dip"      },
};

STDINPUTINFO(Megadrive)

static struct BurnDIPInfo MegadriveDIPList[] = {
	{0x1a,	0xff, 0xff, 0x01,  NULL               },

	{0,	0xfe, 0,       5, "Hardware"          },
	{0x19,	0x01, 0xc1, 0x01, "Auto Detect"       },
	{0x19,	0x01, 0xc1, 0x00, "Japan NTSC"        },
	{0x19,	0x01, 0xc1, 0x40, "Japan PAL"         },
	{0x19,	0x01, 0xc1, 0x80, "USA"               },
	{0x19,	0x01, 0xc1, 0xc0, "Europe"            },

	{0,	0xfe, 0,       2, "CD-ROM"            },
	{0x19,	0x01, 0x20, 0x20, "No"                },
	{0x19,	0x01, 0x20, 0x00, "Yes"               },

	{0,	0xfe, 0,       3, "32-Col Mode Draw"  },
	{0x1a,	0x01, 0x03, 0x00, "No Change"         },
	{0x1a,	0x01, 0x03, 0x01, "Center"            },
	{0x1a,	0x01, 0x03, 0x02, "Inner Zoom"        },
};

static struct BurnDIPInfo AutoDetectRegionDIPList[] = {
	{0x19,	0xff,  0xff,	0x21,   NULL},
};

static struct BurnDIPInfo EuropeRegionDIPList[] = {
	{0x19,	0xff,  0xff,	0xe0,   NULL},
};

//static struct BurnDIPInfo JapanRegionDIPList[] = {
//	{0x19,	0xff,  0xff,	0x20,   NULL},
//};

//static struct BurnDIPInfo JapanPALRegionDIPList[] = {
//	{0x19,	0xff,  0xff,	0x60,   NULL},
//};

static struct BurnDIPInfo USARegionDIPList[] = {
	{0x19,	0xff,  0xff,	0xa0,   NULL},
};

STDDIPINFOEXT(Megadrive, AutoDetectRegion, Megadrive)
STDDIPINFOEXT(MegadriveEurope, EuropeRegion, Megadrive)
//STDDIPINFOEXT(MegadriveJapan, JapanRegion, Megadrive)
//STDDIPINFOEXT(MegadriveJapanPAL, JapanPALRegion, Megadrive)
STDDIPINFOEXT(MegadriveUSA, USARegion, Megadrive)

// 007 Shitou - The Duel (Japan)
static struct BurnRomInfo g_007shiRomDesc[] = {
	{ "007 shitou - the duel (japan).md", 0x80000, 0xaeb4b262, BRF_PRG },
};

STD_ROM_PICK(g_007shi)
STD_ROM_FN(g_007shi)

struct BurnDriverD BurnDrvMDg_007shi = {
	"g_007shi", "g_jb007", NULL, "1993",
	"007 Shitou - The Duel (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_007shiRomInfo, g_007shiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 12-in-1 (Unl) [!]
static struct BurnRomInfo g_12inunRomDesc[] = {
	{ "12-in-1 (unl) [!].md", 0x200000, 0xa98bf454, BRF_PRG },
};

STD_ROM_PICK(g_12inun)
STD_ROM_FN(g_12inun)

struct BurnDriver BurnDrvMDg_12inun = {
	"g_12inun", NULL, NULL, "19??",
	"12-in-1 (Unl) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_12inunRomInfo, g_12inunRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 16 Ton (SN) (GNKO) (J) [!]
static struct BurnRomInfo g_16tonsRomDesc[] = {
	{ "16 ton (sn) (gnko) (j) [!].md", 0x40000, 0x98149eaf, BRF_PRG },
};

STD_ROM_PICK(g_16tons)
STD_ROM_FN(g_16tons)

struct BurnDriver BurnDrvMDg_16tons = {
	"g_16tons", NULL, NULL, "1991",
	"16 Ton (SN) (GNKO) (J) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_16tonsRomInfo, g_16tonsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 16 Zhang Ma Jiang (China) (Unl)
static struct BurnRomInfo g_16zhanRomDesc[] = {
	{ "16 zhang ma jiang (china) (unl).md", 0x100000, 0x36407c82, BRF_PRG },
};

STD_ROM_PICK(g_16zhan)
STD_ROM_FN(g_16zhan)

struct BurnDriver BurnDrvMDg_16zhan = {
	"g_16zhan", NULL, NULL, "19??",
	"16 Zhang Ma Jiang (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_16zhanRomInfo, g_16zhanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 16t (Japan) (SegaNet)
static struct BurnRomInfo g_16tjapRomDesc[] = {
	{ "16t (japan) (seganet).md", 0x40000, 0x537f04b6, BRF_PRG },
};

STD_ROM_PICK(g_16tjap)
STD_ROM_FN(g_16tjap)

struct BurnDriver BurnDrvMDg_16tjap = {
	"g_16tjap", NULL, NULL, "1991",
	"16t (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_16tjapRomInfo, g_16tjapRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 2020 Toshi Super Baseball (Japan)
static struct BurnRomInfo g_2020toRomDesc[] = {
	{ "2020 toshi super baseball (japan).md", 0x200000, 0x2bbee127, BRF_PRG },
};

STD_ROM_PICK(g_2020to)
STD_ROM_FN(g_2020to)

struct BurnDriver BurnDrvMDg_2020to = {
	"g_2020to", "g_sb2020", NULL, "1900",
	"2020 Toshi Super Baseball (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_2020toRomInfo, g_2020toRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 3 Ninjas Kick Back (USA)
static struct BurnRomInfo g_3ninjaRomDesc[] = {
	{ "3 ninjas kick back (usa).md", 0x200000, 0xe5a24999, BRF_PRG },
};

STD_ROM_PICK(g_3ninja)
STD_ROM_FN(g_3ninja)

struct BurnDriver BurnDrvMDg_3ninja = {
	"g_3ninja", NULL, NULL, "1994",
	"3 Ninjas Kick Back (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_3ninjaRomInfo, g_3ninjaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 3-in-1 Flashback - World Champ. Soccer - Tecmo World Cup 92 [p1][!]
static struct BurnRomInfo g_3in1flRomDesc[] = {
	{ "3-in-1 flashback - world champ. soccer - tecmo world cup 92 [p1][!].md", 0x200000, 0xa8fd28d7, BRF_PRG },
};

STD_ROM_PICK(g_3in1fl)
STD_ROM_FN(g_3in1fl)

struct BurnDriverD BurnDrvMDg_3in1fl = {
	"g_3in1fl", NULL, NULL, "",
	"3-in-1 Flashback - World Champ. Soccer - Tecmo World Cup 92 [p1][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_3in1flRomInfo, g_3in1flRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 3-in-1 Road Rash - Ms. Pac-Man - Block Out [p1][!]
static struct BurnRomInfo g_3in1roRomDesc[] = {
	{ "3-in-1 road rash - ms. pac-man - block out [p1][!].md", 0x100000, 0x13c96154, BRF_PRG },
};

STD_ROM_PICK(g_3in1ro)
STD_ROM_FN(g_3in1ro)

struct BurnDriverD BurnDrvMDg_3in1ro = {
	"g_3in1ro", NULL, NULL, "",
	"3-in-1 Road Rash - Ms. Pac-Man - Block Out [p1][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_3in1roRomInfo, g_3in1roRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 4-in-1 [p1][!]
static struct BurnRomInfo g_4in1pbRomDesc[] = {
	{ "4-in-1 [p1][!].md", 0x200000, 0xbe72857b, BRF_PRG },
};

STD_ROM_PICK(g_4in1pb)
STD_ROM_FN(g_4in1pb)

struct BurnDriver BurnDrvMDg_4in1pb = {
	"g_4in1pb", NULL, NULL, "19??",
	"4-in-1 [p1][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_4in1pbRomInfo, g_4in1pbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 6-Pak (USA)
static struct BurnRomInfo g_6pakusRomDesc[] = {
	{ "6-pak (usa).md", 0x300000, 0x1a6f45dc, BRF_PRG },
};

STD_ROM_PICK(g_6pakus)
STD_ROM_FN(g_6pakus)

struct BurnDriver BurnDrvMDg_6pakus = {
	"g_6pakus", NULL, NULL, "199?",
	"6-Pak (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_6pakusRomInfo, g_6pakusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// 688 Attack Sub (USA, Europe)
static struct BurnRomInfo g_688attRomDesc[] = {
	{ "688 attack sub (usa, europe).md", 0x100000, 0xf2c58bf7, BRF_PRG },
};

STD_ROM_PICK(g_688att)
STD_ROM_FN(g_688att)

struct BurnDriver BurnDrvMDg_688att = {
	"g_688att", NULL, NULL, "1991",
	"688 Attack Sub (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_688attRomInfo, g_688attRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// A Ressha de Ikou MD (Japan)
static struct BurnRomInfo g_aresshRomDesc[] = {
	{ "a ressha de ikou md (japan).md", 0x80000, 0x3d45de4f, BRF_PRG },
};

STD_ROM_PICK(g_aressh)
STD_ROM_FN(g_aressh)

struct BurnDriver BurnDrvMDg_aressh = {
	"g_aressh", NULL, NULL, "1991",
	"A Ressha de Ikou MD (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aresshRomInfo, g_aresshRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aa Harimanada (Japan)
static struct BurnRomInfo g_aahariRomDesc[] = {
	{ "aa harimanada (japan).md", 0x200000, 0x065f6021, BRF_PRG },
};

STD_ROM_PICK(g_aahari)
STD_ROM_FN(g_aahari)

struct BurnDriver BurnDrvMDg_aahari = {
	"g_aahari", NULL, NULL, "1993",
	"Aa Harimanada (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_VSFIGHT, 0,
	NULL, g_aahariRomInfo, g_aahariRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// AAAHH!!! Real Monsters (Europe)
static struct BurnRomInfo g_aaahhrRomDesc[] = {
	{ "aaahh!!! real monsters (europe).md", 0x200000, 0x7ad115ff, BRF_PRG },
};

STD_ROM_PICK(g_aaahhr)
STD_ROM_FN(g_aaahhr)

struct BurnDriver BurnDrvMDg_aaahhr = {
	"g_aaahhr", NULL, NULL, "1995",
	"AAAHH!!! Real Monsters (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aaahhrRomInfo, g_aaahhrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// AAAHH!!! Real Monsters (USA)
static struct BurnRomInfo g_aaahh1RomDesc[] = {
	{ "aaahh!!! real monsters (usa).md", 0x200000, 0xfdc80bfc, BRF_PRG },
};

STD_ROM_PICK(g_aaahh1)
STD_ROM_FN(g_aaahh1)

struct BurnDriver BurnDrvMDg_aaahh1 = {
	"g_aaahh1", "g_aaahhr", NULL, "1995",
	"AAAHH!!! Real Monsters (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aaahh1RomInfo, g_aaahh1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Action 52 (USA) (Alt) (Unl)
static struct BurnRomInfo g_actionRomDesc[] = {
	{ "action 52 (usa) (alt) (unl).md", 0x200000, 0x8809d666, BRF_PRG },
};

STD_ROM_PICK(g_action)
STD_ROM_FN(g_action)

struct BurnDriverD BurnDrvMDg_action = {
	"g_action", NULL, NULL, "",
	"Action 52 (USA) (Alt) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_actionRomInfo, g_actionRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Action 52 (USA) (Unl)
static struct BurnRomInfo g_actio1RomDesc[] = {
	{ "action 52 (usa) (unl).md", 0x200000, 0x29ff58ae, BRF_PRG },
};

STD_ROM_PICK(g_actio1)
STD_ROM_FN(g_actio1)

struct BurnDriverD BurnDrvMDg_actio1 = {
	"g_actio1", "g_action", NULL, "",
	"Action 52 (USA) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_actio1RomInfo, g_actio1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Action Replay (Europe) (Program)
static struct BurnRomInfo g_actrpRomDesc[] = {
	{ "action replay (europe) (program).md", 0x8000, 0x95ff7c3e, BRF_PRG },
};

STD_ROM_PICK(g_actrp)
STD_ROM_FN(g_actrp)

struct BurnDriverD BurnDrvMDg_actrp = {
	"g_actrp", NULL, NULL, "",
	"Action Replay (Europe) (Program)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_actrpRomInfo, g_actrpRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Addams Family Values (Europe) (En,Fr,De)
static struct BurnRomInfo g_afvRomDesc[] = {
	{ "addams family values (europe) (en,fr,de).md", 0x200000, 0xb906b992, BRF_PRG },
};

STD_ROM_PICK(g_afv)
STD_ROM_FN(g_afv)

struct BurnDriver BurnDrvMDg_afv = {
	"g_afv", "g_addam", NULL, "1994",
	"Addams Family Values (Europe) (En,Fr,De)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_afvRomInfo, g_afvRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Addams Family, The (USA) (Beta) (Alt)
static struct BurnRomInfo g_addam1RomDesc[] = {
	{ "addams family, the (usa) (beta) (alt).md", 0x100000, 0x3a173e1f, BRF_PRG },
};

STD_ROM_PICK(g_addam1)
STD_ROM_FN(g_addam1)

struct BurnDriverD BurnDrvMDg_addam1 = {
	"g_addam1", "g_addam", NULL, "",
	"Addams Family, The (USA) (Beta) (Alt)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_addam1RomInfo, g_addam1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Addams Family, The (USA) (Beta)
static struct BurnRomInfo g_addam2RomDesc[] = {
	{ "addams family, the (usa) (beta).md", 0x100000, 0x2803a5ca, BRF_PRG },
};

STD_ROM_PICK(g_addam2)
STD_ROM_FN(g_addam2)

struct BurnDriver BurnDrvMDg_addam2 = {
	"g_addam2", "g_addam", NULL, "1993",
	"Addams Family, The (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_addam2RomInfo, g_addam2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Addams Family, The (USA, Europe)
static struct BurnRomInfo g_addamRomDesc[] = {
	{ "addams family, the (usa, europe).md", 0x100000, 0x71f58614, BRF_PRG },
};

STD_ROM_PICK(g_addam)
STD_ROM_FN(g_addam)

struct BurnDriver BurnDrvMDg_addam = {
	"g_addam", NULL, NULL, "1900",
	"Addams Family, The (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_addamRomInfo, g_addamRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Advanced Busterhawk Gleylancer (Japan)
static struct BurnRomInfo g_advancRomDesc[] = {
	{ "advanced busterhawk gleylancer (japan).md", 0x100000, 0x42cf9b5b, BRF_PRG },
};

STD_ROM_PICK(g_advanc)
STD_ROM_FN(g_advanc)

struct BurnDriverD BurnDrvMDg_advanc = {
	"g_advanc", NULL, NULL, "1900",
	"Advanced Busterhawk Gleylancer (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_advancRomInfo, g_advancRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Advanced Daisenryaku - Deutsch Dengeki Sakusen (Japan) (Rev A)
static struct BurnRomInfo g_advdaiRomDesc[] = {
	{ "advanced daisenryaku - deutsch dengeki sakusen (japan) (rev a).md", 0x100000, 0xe0d5e18a, BRF_PRG },
};

STD_ROM_PICK(g_advdai)
STD_ROM_FN(g_advdai)

struct BurnDriverD BurnDrvMDg_advdai = {
	"g_advdai", NULL, NULL, "",
	"Advanced Daisenryaku - Deutsch Dengeki Sakusen (Japan) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_advdaiRomInfo, g_advdaiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Europe)
static struct BurnRomInfo g_adventRomDesc[] = {
	{ "adventures of batman & robin, the (europe).md", 0x200000, 0x355e8c39, BRF_PRG },
};

STD_ROM_PICK(g_advent)
STD_ROM_FN(g_advent)

struct BurnDriver BurnDrvMDg_advent = {
	"g_advent", NULL, NULL, "1995",
	"Adventures of Batman & Robin, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_adventRomInfo, g_adventRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (USA)
static struct BurnRomInfo g_adven1RomDesc[] = {
	{ "adventures of batman & robin, the (usa).md", 0x200000, 0x0caaa4ac, BRF_PRG },
};

STD_ROM_PICK(g_adven1)
STD_ROM_FN(g_adven1)

struct BurnDriver BurnDrvMDg_adven1 = {
	"g_adven1", "g_advent", NULL, "1995",
	"Adventures of Batman & Robin, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_adven1RomInfo, g_adven1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - Apr 06, 1995)
static struct BurnRomInfo g_adven2RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 06, 1995).md", 0x200000, 0xf05cf389, BRF_PRG },
};

STD_ROM_PICK(g_adven2)
STD_ROM_FN(g_adven2)

struct BurnDriverD BurnDrvMDg_adven2 = {
	"g_adven2", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - Apr 06, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adven2RomInfo, g_adven2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - Apr 10, 1995)
static struct BurnRomInfo g_adven3RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 10, 1995).md", 0x200000, 0xd4f3a070, BRF_PRG },
};

STD_ROM_PICK(g_adven3)
STD_ROM_FN(g_adven3)

struct BurnDriverD BurnDrvMDg_adven3 = {
	"g_adven3", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - Apr 10, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adven3RomInfo, g_adven3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - Apr 11, 1995)
static struct BurnRomInfo g_adven4RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 11, 1995).md", 0x200000, 0xb5b5a290, BRF_PRG },
};

STD_ROM_PICK(g_adven4)
STD_ROM_FN(g_adven4)

struct BurnDriverD BurnDrvMDg_adven4 = {
	"g_adven4", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - Apr 11, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adven4RomInfo, g_adven4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - Apr 18, 1995)
static struct BurnRomInfo g_adven5RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 18, 1995).md", 0x200000, 0x6874142b, BRF_PRG },
};

STD_ROM_PICK(g_adven5)
STD_ROM_FN(g_adven5)

struct BurnDriverD BurnDrvMDg_adven5 = {
	"g_adven5", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - Apr 18, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adven5RomInfo, g_adven5RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - Apr 19, 1995)
static struct BurnRomInfo g_adven6RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 19, 1995).md", 0x200000, 0x7002da56, BRF_PRG },
};

STD_ROM_PICK(g_adven6)
STD_ROM_FN(g_adven6)

struct BurnDriverD BurnDrvMDg_adven6 = {
	"g_adven6", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - Apr 19, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adven6RomInfo, g_adven6RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - Apr 21, 1995)
static struct BurnRomInfo g_adven7RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 21, 1995).md", 0x200000, 0x61f02f13, BRF_PRG },
};

STD_ROM_PICK(g_adven7)
STD_ROM_FN(g_adven7)

struct BurnDriverD BurnDrvMDg_adven7 = {
	"g_adven7", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - Apr 21, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adven7RomInfo, g_adven7RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - Apr 22, 1995)
static struct BurnRomInfo g_adven8RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 22, 1995).md", 0x200000, 0xeb8236b2, BRF_PRG },
};

STD_ROM_PICK(g_adven8)
STD_ROM_FN(g_adven8)

struct BurnDriverD BurnDrvMDg_adven8 = {
	"g_adven8", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - Apr 22, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adven8RomInfo, g_adven8RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - Apr 24, 1995)
static struct BurnRomInfo g_adven9RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 24, 1995).md", 0x200000, 0x253947f8, BRF_PRG },
};

STD_ROM_PICK(g_adven9)
STD_ROM_FN(g_adven9)

struct BurnDriverD BurnDrvMDg_adven9 = {
	"g_adven9", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - Apr 24, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adven9RomInfo, g_adven9RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - Apr 26, 1995)
static struct BurnRomInfo g_adve10RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 26, 1995).md", 0x200000, 0xbc79f7ee, BRF_PRG },
};

STD_ROM_PICK(g_adve10)
STD_ROM_FN(g_adve10)

struct BurnDriverD BurnDrvMDg_adve10 = {
	"g_adve10", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - Apr 26, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adve10RomInfo, g_adve10RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - Apr 27, 1995)
static struct BurnRomInfo g_adve11RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 27, 1995).md", 0x200000, 0xfdac8190, BRF_PRG },
};

STD_ROM_PICK(g_adve11)
STD_ROM_FN(g_adve11)

struct BurnDriverD BurnDrvMDg_adve11 = {
	"g_adve11", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - Apr 27, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adve11RomInfo, g_adve11RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - Apr 28, 1995)
static struct BurnRomInfo g_adve12RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - apr 28, 1995).md", 0x200000, 0x27a1524b, BRF_PRG },
};

STD_ROM_PICK(g_adve12)
STD_ROM_FN(g_adve12)

struct BurnDriverD BurnDrvMDg_adve12 = {
	"g_adve12", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - Apr 28, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adve12RomInfo, g_adve12RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Batman & Robin, The (Prototype - May 01, 1995)
static struct BurnRomInfo g_adve13RomDesc[] = {
	{ "adventures of batman & robin, the (prototype - may 01, 1995).md", 0x200000, 0x589aa203, BRF_PRG },
};

STD_ROM_PICK(g_adve13)
STD_ROM_FN(g_adve13)

struct BurnDriverD BurnDrvMDg_adve13 = {
	"g_adve13", "g_advent", NULL, "",
	"Adventures of Batman & Robin, The (Prototype - May 01, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adve13RomInfo, g_adve13RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Mighty Max, The (Europe)
static struct BurnRomInfo g_advemmRomDesc[] = {
	{ "adventures of mighty max, the (europe).md", 0x100000, 0x24f1a3bb, BRF_PRG },
};

STD_ROM_PICK(g_advemm)
STD_ROM_FN(g_advemm)

struct BurnDriver BurnDrvMDg_advemm = {
	"g_advemm", NULL, NULL, "1994",
	"Adventures of Mighty Max, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_advemmRomInfo, g_advemmRomName, MegadriveInputInfo, MegadriveEuropeDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Mighty Max, The (USA)
static struct BurnRomInfo g_advem1RomDesc[] = {
	{ "adventures of mighty max, the (usa).md", 0x100000, 0x55f13a00, BRF_PRG },
};

STD_ROM_PICK(g_advem1)
STD_ROM_FN(g_advem1)

struct BurnDriver BurnDrvMDg_advem1 = {
	"g_advem1", "g_advemm", NULL, "1994",
	"Adventures of Mighty Max, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_advem1RomInfo, g_advem1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventures of Rocky and Bullwinkle and Friends, The (USA)
static struct BurnRomInfo g_adverbRomDesc[] = {
	{ "adventures of rocky and bullwinkle and friends, the (usa).md", 0x100000, 0xef02d57b, BRF_PRG },
};

STD_ROM_PICK(g_adverb)
STD_ROM_FN(g_adverb)

struct BurnDriverD BurnDrvMDg_adverb = {
	"g_adverb", NULL, NULL, "1900",
	"Adventures of Rocky and Bullwinkle and Friends, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_adverbRomInfo, g_adverbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Adventurous Boy - Mao Xian Xiao Zi (China) (Unl)
static struct BurnRomInfo g_advebyRomDesc[] = {
	{ "adventurous boy - mao xian xiao zi (china) (unl).md", 0x80000, 0xd4403913, BRF_PRG },
};

STD_ROM_PICK(g_adveby)
STD_ROM_FN(g_adveby)

struct BurnDriverD BurnDrvMDg_adveby = {
	"g_adveby", NULL, NULL, "",
	"Adventurous Boy - Mao Xian Xiao Zi (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_advebyRomInfo, g_advebyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero Blasters (Japan)
static struct BurnRomInfo g_aeroblRomDesc[] = {
	{ "aero blasters (japan).md", 0x80000, 0xa00da987, BRF_PRG },
};

STD_ROM_PICK(g_aerobl)
STD_ROM_FN(g_aerobl)

struct BurnDriver BurnDrvMDg_aerobl = {
	"g_aerobl", "g_airbus", NULL, "1991",
	"Aero Blasters (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_HORSHOOT, 0,
	NULL, g_aeroblRomInfo, g_aeroblRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero the Acro-Bat (Beta)
static struct BurnRomInfo g_aerot1RomDesc[] = {
	{ "aero the acro-bat (beta).md", 0x100000, 0xdcd14b10, BRF_PRG },
};

STD_ROM_PICK(g_aerot1)
STD_ROM_FN(g_aerot1)

struct BurnDriverD BurnDrvMDg_aerot1 = {
	"g_aerot1", "g_aeroth", NULL, "",
	"Aero the Acro-Bat (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aerot1RomInfo, g_aerot1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero the Acro-Bat (Europe)
static struct BurnRomInfo g_aerothRomDesc[] = {
	{ "aero the acro-bat (europe).md", 0x100000, 0x1a3eaf57, BRF_PRG },
};

STD_ROM_PICK(g_aeroth)
STD_ROM_FN(g_aeroth)

struct BurnDriver BurnDrvMDg_aeroth = {
	"g_aeroth", NULL, NULL, "1993",
	"Aero the Acro-Bat (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aerothRomInfo, g_aerothRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero the Acro-Bat (USA)
static struct BurnRomInfo g_aerot2RomDesc[] = {
	{ "aero the acro-bat (usa).md", 0x100000, 0xa3a7a8b5, BRF_PRG },
};

STD_ROM_PICK(g_aerot2)
STD_ROM_FN(g_aerot2)

struct BurnDriver BurnDrvMDg_aerot2 = {
	"g_aerot2", "g_aeroth", NULL, "1993",
	"Aero the Acro-Bat (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_aerot2RomInfo, g_aerot2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero the Acro-Bat 2 (Europe)
static struct BurnRomInfo g_aero2RomDesc[] = {
	{ "aero the acro-bat 2 (europe).md", 0x200000, 0xa451f9a1, BRF_PRG },
};

STD_ROM_PICK(g_aero2)
STD_ROM_FN(g_aero2)

struct BurnDriver BurnDrvMDg_aero2 = {
	"g_aero2", NULL, NULL, "1994",
	"Aero the Acro-Bat 2 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aero2RomInfo, g_aero2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aero the Acro-Bat 2 (USA)
static struct BurnRomInfo g_aero2uRomDesc[] = {
	{ "aero the acro-bat 2 (usa).md", 0x200000, 0x39eb74eb, BRF_PRG },
};

STD_ROM_PICK(g_aero2u)
STD_ROM_FN(g_aero2u)

struct BurnDriver BurnDrvMDg_aero2u = {
	"g_aero2u", "g_aero2", NULL, "1994",
	"Aero the Acro-Bat 2 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_aero2uRomInfo, g_aero2uRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aerobiz (USA)
static struct BurnRomInfo g_aerobiRomDesc[] = {
	{ "aerobiz (usa).md", 0x100000, 0xcfaa9bce, BRF_PRG },
};

STD_ROM_PICK(g_aerobi)
STD_ROM_FN(g_aerobi)

struct BurnDriver BurnDrvMDg_aerobi = {
	"g_aerobi", NULL, NULL, "1900",
	"Aerobiz (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aerobiRomInfo, g_aerobiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aerobiz Supersonic (USA)
static struct BurnRomInfo g_aerobsRomDesc[] = {
	{ "aerobiz supersonic (usa).md", 0x100000, 0x9377f1b5, BRF_PRG },
};

STD_ROM_PICK(g_aerobs)
STD_ROM_FN(g_aerobs)

struct BurnDriver BurnDrvMDg_aerobs = {
	"g_aerobs", NULL, NULL, "1994",
	"Aerobiz Supersonic (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aerobsRomInfo, g_aerobsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// After Burner II (Japan)
static struct BurnRomInfo g_abur2jRomDesc[] = {
	{ "after burner ii (japan).md", 0x80000, 0x4ff37e66, BRF_PRG },
};

STD_ROM_PICK(g_abur2j)
STD_ROM_FN(g_abur2j)

struct BurnDriverD BurnDrvMDg_abur2j = {
	"g_abur2j", "g_abur2", NULL, "1990",
	"After Burner II (Japan)\0", "Sound Problems", "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_abur2jRomInfo, g_abur2jRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// After Burner II (USA, Europe)
static struct BurnRomInfo g_abur2RomDesc[] = {
	{ "after burner ii (usa, europe).md", 0x80000, 0xccafe00e, BRF_PRG },
};

STD_ROM_PICK(g_abur2)
STD_ROM_FN(g_abur2)

struct BurnDriverD BurnDrvMDg_abur2 = {
	"g_abur2", NULL, NULL, "1990",
	"After Burner II (USA, Europe)\0", "Sound Problems", "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_abur2RomInfo, g_abur2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Air Buster (USA)
static struct BurnRomInfo g_airbusRomDesc[] = {
	{ "air buster (usa).md", 0x80000, 0xf3d65baa, BRF_PRG },
};

STD_ROM_PICK(g_airbus)
STD_ROM_FN(g_airbus)

struct BurnDriver BurnDrvMDg_airbus = {
	"g_airbus", NULL, NULL, "1991",
	"Air Buster (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_HORSHOOT, 0,
	NULL, g_airbusRomInfo, g_airbusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Air Diver (Japan)
static struct BurnRomInfo g_airdvjRomDesc[] = {
	{ "air diver (japan).md", 0x80000, 0x9e2d5b91, BRF_PRG },
};

STD_ROM_PICK(g_airdvj)
STD_ROM_FN(g_airdvj)

struct BurnDriver BurnDrvMDg_airdvj = {
	"g_airdvj", "g_airdv", NULL, "1900",
	"Air Diver (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_airdvjRomInfo, g_airdvjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Air Diver (USA)
static struct BurnRomInfo g_airdvRomDesc[] = {
	{ "air diver (usa).md", 0x80000, 0x2041885e, BRF_PRG },
};

STD_ROM_PICK(g_airdv)
STD_ROM_FN(g_airdv)

struct BurnDriver BurnDrvMDg_airdv = {
	"g_airdv", NULL, NULL, "1990",
	"Air Diver (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_airdvRomInfo, g_airdvRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Air Management - Oozora ni Kakeru (Japan)
static struct BurnRomInfo g_airmanRomDesc[] = {
	{ "air management - oozora ni kakeru (japan).md", 0x100000, 0xb3db0c71, BRF_PRG },
};

STD_ROM_PICK(g_airman)
STD_ROM_FN(g_airman)

struct BurnDriver BurnDrvMDg_airman = {
	"g_airman", "g_aerobi", NULL, "1900",
	"Air Management - Oozora ni Kakeru (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_airmanRomInfo, g_airmanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Air Management II - Koukuuou o Mezase (Japan)
static struct BurnRomInfo g_airmasRomDesc[] = {
	{ "air management ii - koukuuou o mezase (japan).md", 0x100000, 0x4582817b, BRF_PRG },
};

STD_ROM_PICK(g_airmas)
STD_ROM_FN(g_airmas)

struct BurnDriver BurnDrvMDg_airmas = {
	"g_airmas", "g_aerobs", NULL, "1994",
	"Air Management II - Koukuuou o Mezase (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_airmasRomInfo, g_airmasRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Akumajou Dracula - Vampire Killer (Japan)
static struct BurnRomInfo g_akumajRomDesc[] = {
	{ "akumajou dracula - vampire killer (japan).md", 0x100000, 0x91b57d2b, BRF_PRG },
};

STD_ROM_PICK(g_akumaj)
STD_ROM_FN(g_akumaj)

struct BurnDriverD BurnDrvMDg_akumaj = {
	"g_akumaj", "g_cvania", NULL, "1994",
	"Akumajou Dracula - Vampire Killer (Japan)\0", NULL, "Konami", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_akumajRomInfo, g_akumajRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aladdin (Europe)
static struct BurnRomInfo g_aladdiRomDesc[] = {
	{ "aladdin (europe).md", 0x200000, 0xd1845e8f, BRF_PRG },
};

STD_ROM_PICK(g_aladdi)
STD_ROM_FN(g_aladdi)

struct BurnDriver BurnDrvMDg_aladdi = {
	"g_aladdi", NULL, NULL, "1993",
	"Aladdin (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aladdiRomInfo, g_aladdiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aladdin (Japan)
static struct BurnRomInfo g_aladd1RomDesc[] = {
	{ "aladdin (japan).md", 0x200000, 0xfb5aacf0, BRF_PRG },
};

STD_ROM_PICK(g_aladd1)
STD_ROM_FN(g_aladd1)

struct BurnDriver BurnDrvMDg_aladd1 = {
	"g_aladd1", "g_aladdi", NULL, "1993",
	"Aladdin (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aladd1RomInfo, g_aladd1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aladdin (USA) (Beta)
static struct BurnRomInfo g_aladd2RomDesc[] = {
	{ "aladdin (usa) (beta).md", 0x200000, 0x8c60ef73, BRF_PRG },
};

STD_ROM_PICK(g_aladd2)
STD_ROM_FN(g_aladd2)

struct BurnDriver BurnDrvMDg_aladd2 = {
	"g_aladd2", "g_aladdi", NULL, "1993",
	"Aladdin (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aladd2RomInfo, g_aladd2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aladdin (USA)
static struct BurnRomInfo g_aladd3RomDesc[] = {
	{ "aladdin (usa).md", 0x200000, 0xed427ea9, BRF_PRG },
};

STD_ROM_PICK(g_aladd3)
STD_ROM_FN(g_aladd3)

struct BurnDriver BurnDrvMDg_aladd3 = {
	"g_aladd3", "g_aladdi", NULL, "1993",
	"Aladdin (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aladd3RomInfo, g_aladd3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aladdin II (Unl)
static struct BurnRomInfo g_alad2RomDesc[] = {
	{ "aladdin ii (unl).md", 0x200000, 0xbe5f9397, BRF_PRG },
};

STD_ROM_PICK(g_alad2)
STD_ROM_FN(g_alad2)

struct BurnDriver BurnDrvMDg_alad2 = {
	"g_alad2", NULL, NULL, "19??",
	"Aladdin II (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_alad2RomInfo, g_alad2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alex Kidd - Cheongong Maseong (Korea)
static struct BurnRomInfo g_alexk2RomDesc[] = {
	{ "alex kidd - cheongong maseong (korea).md", 0x40000, 0x5b0678fb, BRF_PRG },
};

STD_ROM_PICK(g_alexk2)
STD_ROM_FN(g_alexk2)

struct BurnDriver BurnDrvMDg_alexk2 = {
	"g_alexk2", "g_alexkd", NULL, "1989",
	"Alex Kidd - Cheongong Maseong (Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_alexk2RomInfo, g_alexk2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alex Kidd - Tenkuu Majou (Japan)
static struct BurnRomInfo g_alexk1RomDesc[] = {
	{ "alex kidd - tenkuu majou (japan).md", 0x40000, 0x8a5ed856, BRF_PRG },
};

STD_ROM_PICK(g_alexk1)
STD_ROM_FN(g_alexk1)

struct BurnDriver BurnDrvMDg_alexk1 = {
	"g_alexk1", "g_alexkd", NULL, "1989",
	"Alex Kidd - Tenkuu Majou (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_alexk1RomInfo, g_alexk1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alex Kidd in the Enchanted Castle (Europe) (Rev A)
static struct BurnRomInfo g_alexkdRomDesc[] = {
	{ "alex kidd in the enchanted castle (europe) (rev a).md", 0x40000, 0x778a0f00, BRF_PRG },
};

STD_ROM_PICK(g_alexkd)
STD_ROM_FN(g_alexkd)

struct BurnDriver BurnDrvMDg_alexkd = {
	"g_alexkd", NULL, NULL, "1989",
	"Alex Kidd in the Enchanted Castle (Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_alexkdRomInfo, g_alexkdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alex Kidd in the Enchanted Castle (Europe)
static struct BurnRomInfo g_alexk3RomDesc[] = {
	{ "alex kidd in the enchanted castle (europe).md", 0x40000, 0xc3a52529, BRF_PRG },
};

STD_ROM_PICK(g_alexk3)
STD_ROM_FN(g_alexk3)

struct BurnDriver BurnDrvMDg_alexk3 = {
	"g_alexk3", "g_alexkd", NULL, "1989",
	"Alex Kidd in the Enchanted Castle (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_alexk3RomInfo, g_alexk3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alex Kidd in the Enchanted Castle (USA)
static struct BurnRomInfo g_alexk4RomDesc[] = {
	{ "alex kidd in the enchanted castle (usa).md", 0x40000, 0x47dba0ac, BRF_PRG },
};

STD_ROM_PICK(g_alexk4)
STD_ROM_FN(g_alexk4)

struct BurnDriver BurnDrvMDg_alexk4 = {
	"g_alexk4", "g_alexkd", NULL, "1989",
	"Alex Kidd in the Enchanted Castle (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_alexk4RomInfo, g_alexk4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alien 3 (USA, Europe) (Rev A)
static struct BurnRomInfo g_alienuRomDesc[] = {
	{ "alien 3 (usa, europe) (rev a).md", 0x80000, 0xb327fd1b, BRF_PRG },
};

STD_ROM_PICK(g_alienu)
STD_ROM_FN(g_alienu)

struct BurnDriver BurnDrvMDg_alienu = {
	"g_alienu", NULL, NULL, "1900",
	"Alien 3 (USA, Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SHOOT, 0,
	NULL, g_alienuRomInfo, g_alienuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alien 3 (USA, Europe)
static struct BurnRomInfo g_alien1RomDesc[] = {
	{ "alien 3 (usa, europe).md", 0x80000, 0xa3b00d6e, BRF_PRG },
};

STD_ROM_PICK(g_alien1)
STD_ROM_FN(g_alien1)

struct BurnDriver BurnDrvMDg_alien1 = {
	"g_alien1", "g_alienu", NULL, "1900",
	"Alien 3 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SHOOT, 0,
	NULL, g_alien1RomInfo, g_alien1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alien Soldier (Europe)
static struct BurnRomInfo g_aliensRomDesc[] = {
	{ "alien soldier (europe).md", 0x200000, 0x0496e06c, BRF_PRG },
};

STD_ROM_PICK(g_aliens)
STD_ROM_FN(g_aliens)

struct BurnDriver BurnDrvMDg_aliens = {
	"g_aliens", NULL, NULL, "1995",
	"Alien Soldier (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_VERSHOOT, 0,
	NULL, g_aliensRomInfo, g_aliensRomName, MegadriveInputInfo, MegadriveEuropeDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alien Soldier (Japan)
static struct BurnRomInfo g_alien2RomDesc[] = {
	{ "alien soldier (japan).md", 0x200000, 0x90fa1539, BRF_PRG },
};

STD_ROM_PICK(g_alien2)
STD_ROM_FN(g_alien2)

struct BurnDriver BurnDrvMDg_alien2 = {
	"g_alien2", "g_aliens", NULL, "1995",
	"Alien Soldier (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_alien2RomInfo, g_alien2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alien Storm (World)
static struct BurnRomInfo g_alstmRomDesc[] = {
	{ "alien storm (world).md", 0x80000, 0xf5ac8de5, BRF_PRG },
};

STD_ROM_PICK(g_alstm)
STD_ROM_FN(g_alstm)

struct BurnDriver BurnDrvMDg_alstm = {
	"g_alstm", NULL, NULL, "1991",
	"Alien Storm (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_alstmRomInfo, g_alstmRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alisia Dragoon (Europe)
static struct BurnRomInfo g_alisiaRomDesc[] = {
	{ "alisia dragoon (europe).md", 0x100000, 0x28165bd1, BRF_PRG },
};

STD_ROM_PICK(g_alisia)
STD_ROM_FN(g_alisia)

struct BurnDriver BurnDrvMDg_alisia = {
	"g_alisia", NULL, NULL, "1992",
	"Alisia Dragoon (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_alisiaRomInfo, g_alisiaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alisia Dragoon (Japan)
static struct BurnRomInfo g_alisi1RomDesc[] = {
	{ "alisia dragoon (japan).md", 0x100000, 0x4d476722, BRF_PRG },
};

STD_ROM_PICK(g_alisi1)
STD_ROM_FN(g_alisi1)

struct BurnDriver BurnDrvMDg_alisi1 = {
	"g_alisi1", "g_alisia", NULL, "1992",
	"Alisia Dragoon (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_alisi1RomInfo, g_alisi1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Alisia Dragoon (USA)
static struct BurnRomInfo g_alisi2RomDesc[] = {
	{ "alisia dragoon (usa).md", 0x100000, 0xd28d5c40, BRF_PRG },
};

STD_ROM_PICK(g_alisi2)
STD_ROM_FN(g_alisi2)

struct BurnDriver BurnDrvMDg_alisi2 = {
	"g_alisi2", "g_alisia", NULL, "1992",
	"Alisia Dragoon (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_alisi2RomInfo, g_alisi2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Altered Beast (USA, Europe)
static struct BurnRomInfo g_altereRomDesc[] = {
	{ "altered beast (usa, europe).md", 0x80000, 0x154d59bb, BRF_PRG },
};

STD_ROM_PICK(g_altere)
STD_ROM_FN(g_altere)

struct BurnDriver BurnDrvMDg_altere = {
	"g_altere", NULL, NULL, "1988",
	"Altered Beast (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_altereRomInfo, g_altereRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// American Gladiators (USA)
static struct BurnRomInfo g_americRomDesc[] = {
	{ "american gladiators (usa).md", 0x100000, 0x9952fa85, BRF_PRG },
};

STD_ROM_PICK(g_americ)
STD_ROM_FN(g_americ)

struct BurnDriver BurnDrvMDg_americ = {
	"g_americ", NULL, NULL, "1992",
	"American Gladiators (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_americRomInfo, g_americRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Andre Agassi Tennis (Europe)
static struct BurnRomInfo g_andreaRomDesc[] = {
	{ "andre agassi tennis (europe).md", 0x80000, 0x224256c7, BRF_PRG },
};

STD_ROM_PICK(g_andrea)
STD_ROM_FN(g_andrea)

struct BurnDriver BurnDrvMDg_andrea = {
	"g_andrea", NULL, NULL, "1993",
	"Andre Agassi Tennis (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_andreaRomInfo, g_andreaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Andre Agassi Tennis (USA) (Beta)
static struct BurnRomInfo g_andre1RomDesc[] = {
	{ "andre agassi tennis (usa) (beta).md", 0x80000, 0x3bbf700d, BRF_PRG },
};

STD_ROM_PICK(g_andre1)
STD_ROM_FN(g_andre1)

struct BurnDriver BurnDrvMDg_andre1 = {
	"g_andre1", "g_andrea", NULL, "1992",
	"Andre Agassi Tennis (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_andre1RomInfo, g_andre1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Andre Agassi Tennis (USA)
static struct BurnRomInfo g_andre2RomDesc[] = {
	{ "andre agassi tennis (usa).md", 0x80000, 0xe755dd51, BRF_PRG },
};

STD_ROM_PICK(g_andre2)
STD_ROM_FN(g_andre2)

struct BurnDriver BurnDrvMDg_andre2 = {
	"g_andre2", "g_andrea", NULL, "1992",
	"Andre Agassi Tennis (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_andre2RomInfo, g_andre2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Animaniacs (Europe) (En,Fr,De)
static struct BurnRomInfo g_animanRomDesc[] = {
	{ "animaniacs (europe) (en,fr,de).md", 0x100000, 0x92b6f255, BRF_PRG },
};

STD_ROM_PICK(g_animan)
STD_ROM_FN(g_animan)

struct BurnDriver BurnDrvMDg_animan = {
	"g_animan", NULL, NULL, "1994",
	"Animaniacs (Europe) (En,Fr,De)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_animanRomInfo, g_animanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Animaniacs (USA)
static struct BurnRomInfo g_anima1RomDesc[] = {
	{ "animaniacs (usa).md", 0x100000, 0x86224d86, BRF_PRG },
};

STD_ROM_PICK(g_anima1)
STD_ROM_FN(g_anima1)

struct BurnDriver BurnDrvMDg_anima1 = {
	"g_anima1", "g_animan", NULL, "1994",
	"Animaniacs (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_anima1RomInfo, g_anima1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Another World (Europe)
static struct BurnRomInfo g_anotheRomDesc[] = {
	{ "another world (europe).md", 0x100000, 0xe9742041, BRF_PRG },
};

STD_ROM_PICK(g_anothe)
STD_ROM_FN(g_anothe)

struct BurnDriverD BurnDrvMDg_anothe = {
	"g_anothe", NULL, NULL, "1992",
	"Another World (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_anotheRomInfo, g_anotheRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aoki Ookami to Shiroki Meshika - Genchou Hishi (Japan)
static struct BurnRomInfo g_aokiooRomDesc[] = {
	{ "aoki ookami to shiroki meshika - genchou hishi (japan).md", 0x140000, 0x10be1d93, BRF_PRG },
};

STD_ROM_PICK(g_aokioo)
STD_ROM_FN(g_aokioo)

struct BurnDriver BurnDrvMDg_aokioo = {
	"g_aokioo", NULL, NULL, "1900",
	"Aoki Ookami to Shiroki Meshika - Genchou Hishi (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aokiooRomInfo, g_aokiooRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aq Renkan Awa (China) (Unl)
static struct BurnRomInfo g_aqrenkRomDesc[] = {
	{ "aq renkan awa (china) (unl).md", 0x100000, 0x2c6cbd77, BRF_PRG },
};

STD_ROM_PICK(g_aqrenk)
STD_ROM_FN(g_aqrenk)

struct BurnDriverD BurnDrvMDg_aqrenk = {
	"g_aqrenk", NULL, NULL, "",
	"Aq Renkan Awa (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aqrenkRomInfo, g_aqrenkRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aquatic Games Starring James Pond and the Aquabats, The (USA, Europe)
static struct BurnRomInfo g_aquatiRomDesc[] = {
	{ "aquatic games starring james pond and the aquabats, the (usa, europe).md", 0x80000, 0x400f4ba7, BRF_PRG },
};

STD_ROM_PICK(g_aquati)
STD_ROM_FN(g_aquati)

struct BurnDriver BurnDrvMDg_aquati = {
	"g_aquati", NULL, NULL, "1992",
	"Aquatic Games Starring James Pond and the Aquabats, The (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aquatiRomInfo, g_aquatiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arcade Classics (USA, Europe)
static struct BurnRomInfo g_arcadeRomDesc[] = {
	{ "arcade classics (usa, europe).md", 0x80000, 0x8aed2090, BRF_PRG },
};

STD_ROM_PICK(g_arcade)
STD_ROM_FN(g_arcade)

struct BurnDriver BurnDrvMDg_arcade = {
	"g_arcade", NULL, NULL, "1900",
	"Arcade Classics (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_arcadeRomInfo, g_arcadeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arch Rivals - The Arcade Game (USA, Europe)
static struct BurnRomInfo g_archriRomDesc[] = {
	{ "arch rivals - the arcade game (usa, europe).md", 0x80000, 0xe389d7e7, BRF_PRG },
};

STD_ROM_PICK(g_archri)
STD_ROM_FN(g_archri)

struct BurnDriver BurnDrvMDg_archri = {
	"g_archri", NULL, NULL, "1900",
	"Arch Rivals - The Arcade Game (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_archriRomInfo, g_archriRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arcus Odyssey (Japan)
static struct BurnRomInfo g_arcusjRomDesc[] = {
	{ "arcus odyssey (japan).md", 0x100000, 0x41c5fb4f, BRF_PRG },
};

STD_ROM_PICK(g_arcusj)
STD_ROM_FN(g_arcusj)

struct BurnDriver BurnDrvMDg_arcusj = {
	"g_arcusj", "g_arcus", NULL, "1900",
	"Arcus Odyssey (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_arcusjRomInfo, g_arcusjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arcus Odyssey (USA)
static struct BurnRomInfo g_arcusRomDesc[] = {
	{ "arcus odyssey (usa).md", 0x100000, 0xbc4d9b20, BRF_PRG },
};

STD_ROM_PICK(g_arcus)
STD_ROM_FN(g_arcus)

struct BurnDriver BurnDrvMDg_arcus = {
	"g_arcus", NULL, NULL, "1900",
	"Arcus Odyssey (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_arcusRomInfo, g_arcusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ariel the Little Mermaid (USA, Europe)
static struct BurnRomInfo g_arieltRomDesc[] = {
	{ "ariel the little mermaid (usa, europe).md", 0x80000, 0x58e297df, BRF_PRG },
};

STD_ROM_PICK(g_arielt)
STD_ROM_FN(g_arielt)

struct BurnDriver BurnDrvMDg_arielt = {
	"g_arielt", NULL, NULL, "1992",
	"Ariel the Little Mermaid (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SHOOT, 0,
	NULL, g_arieltRomInfo, g_arieltRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arnold Palmer Tournament Golf (USA, Europe)
static struct BurnRomInfo g_arnoldRomDesc[] = {
	{ "arnold palmer tournament golf (usa, europe).md", 0x80000, 0x35b995ef, BRF_PRG },
};

STD_ROM_PICK(g_arnold)
STD_ROM_FN(g_arnold)

struct BurnDriver BurnDrvMDg_arnold = {
	"g_arnold", NULL, NULL, "1900",
	"Arnold Palmer Tournament Golf (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_arnoldRomInfo, g_arnoldRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arrow Flash (Japan)
static struct BurnRomInfo g_arrowjRomDesc[] = {
	{ "arrow flash (japan).md", 0x80000, 0xd49f8444, BRF_PRG },
};

STD_ROM_PICK(g_arrowj)
STD_ROM_FN(g_arrowj)

struct BurnDriver BurnDrvMDg_arrowj = {
	"g_arrowj", "g_arrow", NULL, "1990",
	"Arrow Flash (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_HORSHOOT, 0,
	NULL, g_arrowjRomInfo, g_arrowjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Arrow Flash (USA, Europe)
static struct BurnRomInfo g_arrowRomDesc[] = {
	{ "arrow flash (usa, europe).md", 0x80000, 0x4d89e66b, BRF_PRG },
};

STD_ROM_PICK(g_arrow)
STD_ROM_FN(g_arrow)

struct BurnDriver BurnDrvMDg_arrow = {
	"g_arrow", NULL, NULL, "1990",
	"Arrow Flash (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_HORSHOOT, 0,
	NULL, g_arrowRomInfo, g_arrowRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Art Alive (World)
static struct BurnRomInfo g_artaliRomDesc[] = {
	{ "art alive (world).md", 0x20000, 0xf1b72cdd, BRF_PRG },
};

STD_ROM_PICK(g_artali)
STD_ROM_FN(g_artali)

struct BurnDriver BurnDrvMDg_artali = {
	"g_artali", NULL, NULL, "1991",
	"Art Alive (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 1, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_artaliRomInfo, g_artaliRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Art of Fighting (Europe)
static struct BurnRomInfo g_artoffRomDesc[] = {
	{ "art of fighting (europe).md", 0x200000, 0x9970c422, BRF_PRG },
};

STD_ROM_PICK(g_artoff)
STD_ROM_FN(g_artoff)

struct BurnDriver BurnDrvMDg_artoff = {
	"g_artoff", NULL, NULL, "1994",
	"Art of Fighting (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_artoffRomInfo, g_artoffRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Art of Fighting (Prototype - Jul 11, 1994)
static struct BurnRomInfo g_artof1RomDesc[] = {
	{ "art of fighting (prototype - jul 11, 1994).md", 0x200000, 0x19ce567d, BRF_PRG },
};

STD_ROM_PICK(g_artof1)
STD_ROM_FN(g_artof1)

struct BurnDriverD BurnDrvMDg_artof1 = {
	"g_artof1", "g_artoff", NULL, "",
	"Art of Fighting (Prototype - Jul 11, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_artof1RomInfo, g_artof1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Art of Fighting (USA)
static struct BurnRomInfo g_artof2RomDesc[] = {
	{ "art of fighting (usa).md", 0x200000, 0xc9a57e07, BRF_PRG },
};

STD_ROM_PICK(g_artof2)
STD_ROM_FN(g_artof2)

struct BurnDriver BurnDrvMDg_artof2 = {
	"g_artof2", "g_artoff", NULL, "1994",
	"Art of Fighting (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_artof2RomInfo, g_artof2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Assault Suit Leynos (Japan)
static struct BurnRomInfo g_assaulRomDesc[] = {
	{ "assault suit leynos (japan).md", 0x80000, 0x81a2c800, BRF_PRG },
};

STD_ROM_PICK(g_assaul)
STD_ROM_FN(g_assaul)

struct BurnDriverD BurnDrvMDg_assaul = {
	"g_assaul", "g_target", NULL, "1900",
	"Assault Suit Leynos (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_assaulRomInfo, g_assaulRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Asterix and the Great Rescue (Europe) (En,Fr,De,Es,It)
static struct BurnRomInfo g_asteriRomDesc[] = {
	{ "asterix and the great rescue (europe) (en,fr,de,es,it).md", 0x200000, 0x4735fee6, BRF_PRG },
};

STD_ROM_PICK(g_asteri)
STD_ROM_FN(g_asteri)

struct BurnDriver BurnDrvMDg_asteri = {
	"g_asteri", NULL, NULL, "1993",
	"Asterix and the Great Rescue (Europe) (En,Fr,De,Es,It)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_asteriRomInfo, g_asteriRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Asterix and the Great Rescue (USA)
static struct BurnRomInfo g_aster1RomDesc[] = {
	{ "asterix and the great rescue (usa).md", 0x200000, 0x7f112cd8, BRF_PRG },
};

STD_ROM_PICK(g_aster1)
STD_ROM_FN(g_aster1)

struct BurnDriver BurnDrvMDg_aster1 = {
	"g_aster1", "g_asteri", NULL, "1993",
	"Asterix and the Great Rescue (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_aster1RomInfo, g_aster1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Asterix and the Power of the Gods (Europe) (Beta)
static struct BurnRomInfo g_astepbRomDesc[] = {
	{ "asterix and the power of the gods (europe) (beta).md", 0x200000, 0x45c8b5b7, BRF_PRG },
};

STD_ROM_PICK(g_astepb)
STD_ROM_FN(g_astepb)

struct BurnDriverD BurnDrvMDg_astepb = {
	"g_astepb", "g_astepg", NULL, "",
	"Asterix and the Power of the Gods (Europe) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_astepbRomInfo, g_astepbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Asterix and the Power of the Gods (Europe) (En,Fr,De,Es)
static struct BurnRomInfo g_astepgRomDesc[] = {
	{ "asterix and the power of the gods (europe) (en,fr,de,es).md", 0x200000, 0x4ff1d83f, BRF_PRG },
};

STD_ROM_PICK(g_astepg)
STD_ROM_FN(g_astepg)

struct BurnDriver BurnDrvMDg_astepg = {
	"g_astepg", NULL, NULL, "1995",
	"Asterix and the Power of the Gods (Europe) (En,Fr,De,Es)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_astepgRomInfo, g_astepgRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Atomic Robo-Kid (Japan)
static struct BurnRomInfo g_arobojRomDesc[] = {
	{ "atomic robo-kid (japan).md", 0x80000, 0xe833067e, BRF_PRG },
};

STD_ROM_PICK(g_aroboj)
STD_ROM_FN(g_aroboj)

struct BurnDriver BurnDrvMDg_aroboj = {
	"g_aroboj", "g_arobo", NULL, "1900",
	"Atomic Robo-Kid (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_arobojRomInfo, g_arobojRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Atomic Robo-Kid (USA)
static struct BurnRomInfo g_aroboRomDesc[] = {
	{ "atomic robo-kid (usa).md", 0x80000, 0x7cd8169e, BRF_PRG },
};

STD_ROM_PICK(g_arobo)
STD_ROM_FN(g_arobo)

struct BurnDriver BurnDrvMDg_arobo = {
	"g_arobo", NULL, NULL, "1900",
	"Atomic Robo-Kid (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aroboRomInfo, g_aroboRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Atomic Runner (Europe)
static struct BurnRomInfo g_atomrnRomDesc[] = {
	{ "atomic runner (europe).md", 0x100000, 0xb3c05418, BRF_PRG },
};

STD_ROM_PICK(g_atomrn)
STD_ROM_FN(g_atomrn)

struct BurnDriver BurnDrvMDg_atomrn = {
	"g_atomrn", NULL, NULL, "1992",
	"Atomic Runner (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_VERSHOOT, 0,
	NULL, g_atomrnRomInfo, g_atomrnRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Atomic Runner (USA)
static struct BurnRomInfo g_atomr1RomDesc[] = {
	{ "atomic runner (usa).md", 0x100000, 0x0677c210, BRF_PRG },
};

STD_ROM_PICK(g_atomr1)
STD_ROM_FN(g_atomr1)

struct BurnDriver BurnDrvMDg_atomr1 = {
	"g_atomr1", "g_atomrn", NULL, "1992",
	"Atomic Runner (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_HORSHOOT, 0,
	NULL, g_atomr1RomInfo, g_atomr1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour (Europe)
static struct BurnRomInfo g_atptouRomDesc[] = {
	{ "atp tour (europe).md", 0x200000, 0x1a3da8c5, BRF_PRG },
};

STD_ROM_PICK(g_atptou)
STD_ROM_FN(g_atptou)

struct BurnDriver BurnDrvMDg_atptou = {
	"g_atptou", NULL, NULL, "1994",
	"ATP Tour (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_atptouRomInfo, g_atptouRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype - Aug 02, 1994)
static struct BurnRomInfo g_atpto1RomDesc[] = {
	{ "atp tour championship tennis (prototype - aug 02, 1994).md", 0x200000, 0x686a9fa1, BRF_PRG },
};

STD_ROM_PICK(g_atpto1)
STD_ROM_FN(g_atpto1)

struct BurnDriverD BurnDrvMDg_atpto1 = {
	"g_atpto1", "g_atptou", NULL, "",
	"ATP Tour Championship Tennis (Prototype - Aug 02, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_atpto1RomInfo, g_atpto1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype - Aug 05, 1994)
static struct BurnRomInfo g_atpto2RomDesc[] = {
	{ "atp tour championship tennis (prototype - aug 05, 1994).md", 0x200000, 0xa1fef967, BRF_PRG },
};

STD_ROM_PICK(g_atpto2)
STD_ROM_FN(g_atpto2)

struct BurnDriverD BurnDrvMDg_atpto2 = {
	"g_atpto2", "g_atptou", NULL, "",
	"ATP Tour Championship Tennis (Prototype - Aug 05, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_atpto2RomInfo, g_atpto2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype - Aug 08, 1994)
static struct BurnRomInfo g_atpto3RomDesc[] = {
	{ "atp tour championship tennis (prototype - aug 08, 1994).md", 0x200000, 0xe6398864, BRF_PRG },
};

STD_ROM_PICK(g_atpto3)
STD_ROM_FN(g_atpto3)

struct BurnDriverD BurnDrvMDg_atpto3 = {
	"g_atpto3", "g_atptou", NULL, "",
	"ATP Tour Championship Tennis (Prototype - Aug 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_atpto3RomInfo, g_atpto3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype - Jul 19, 1994)
static struct BurnRomInfo g_atpto4RomDesc[] = {
	{ "atp tour championship tennis (prototype - jul 19, 1994).md", 0x200000, 0xcb927488, BRF_PRG },
};

STD_ROM_PICK(g_atpto4)
STD_ROM_FN(g_atpto4)

struct BurnDriverD BurnDrvMDg_atpto4 = {
	"g_atpto4", "g_atptou", NULL, "",
	"ATP Tour Championship Tennis (Prototype - Jul 19, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_atpto4RomInfo, g_atpto4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype - Jul 23, 1994)
static struct BurnRomInfo g_atpto5RomDesc[] = {
	{ "atp tour championship tennis (prototype - jul 23, 1994).md", 0x200000, 0xa15d5051, BRF_PRG },
};

STD_ROM_PICK(g_atpto5)
STD_ROM_FN(g_atpto5)

struct BurnDriverD BurnDrvMDg_atpto5 = {
	"g_atpto5", "g_atptou", NULL, "",
	"ATP Tour Championship Tennis (Prototype - Jul 23, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_atpto5RomInfo, g_atpto5RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype - Jul 25, 1994)
static struct BurnRomInfo g_atpto6RomDesc[] = {
	{ "atp tour championship tennis (prototype - jul 25, 1994).md", 0x200000, 0xa15d5051, BRF_PRG },
};

STD_ROM_PICK(g_atpto6)
STD_ROM_FN(g_atpto6)

struct BurnDriverD BurnDrvMDg_atpto6 = {
	"g_atpto6", "g_atptou", NULL, "",
	"ATP Tour Championship Tennis (Prototype - Jul 25, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_atpto6RomInfo, g_atpto6RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype - May 09, 1994)
static struct BurnRomInfo g_atpto7RomDesc[] = {
	{ "atp tour championship tennis (prototype - may 09, 1994).md", 0x200000, 0xb17a8dbc, BRF_PRG },
};

STD_ROM_PICK(g_atpto7)
STD_ROM_FN(g_atpto7)

struct BurnDriverD BurnDrvMDg_atpto7 = {
	"g_atpto7", "g_atptou", NULL, "",
	"ATP Tour Championship Tennis (Prototype - May 09, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_atpto7RomInfo, g_atpto7RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (Prototype - Sep 08, 1994)
static struct BurnRomInfo g_atpto8RomDesc[] = {
	{ "atp tour championship tennis (prototype - sep 08, 1994).md", 0x200000, 0xb83f4ca4, BRF_PRG },
};

STD_ROM_PICK(g_atpto8)
STD_ROM_FN(g_atpto8)

struct BurnDriverD BurnDrvMDg_atpto8 = {
	"g_atpto8", "g_atptou", NULL, "",
	"ATP Tour Championship Tennis (Prototype - Sep 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_atpto8RomInfo, g_atpto8RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ATP Tour Championship Tennis (USA)
static struct BurnRomInfo g_atpto9RomDesc[] = {
	{ "atp tour championship tennis (usa).md", 0x200000, 0x8c822884, BRF_PRG },
};

STD_ROM_PICK(g_atpto9)
STD_ROM_FN(g_atpto9)

struct BurnDriver BurnDrvMDg_atpto9 = {
	"g_atpto9", "g_atptou", NULL, "1994",
	"ATP Tour Championship Tennis (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_atpto9RomInfo, g_atpto9RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Australian Rugby League (Europe)
static struct BurnRomInfo g_austraRomDesc[] = {
	{ "australian rugby league (europe).md", 0x200000, 0xac5bc26a, BRF_PRG },
};

STD_ROM_PICK(g_austra)
STD_ROM_FN(g_austra)

struct BurnDriver BurnDrvMDg_austra = {
	"g_austra", NULL, NULL, "1995",
	"Australian Rugby League (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_austraRomInfo, g_austraRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Awesome Possum (USA) (Beta)
static struct BurnRomInfo g_awesobRomDesc[] = {
	{ "awesome possum (usa) (beta).md", 0x200000, 0x0158dc53, BRF_PRG },
};

STD_ROM_PICK(g_awesob)
STD_ROM_FN(g_awesob)

struct BurnDriver BurnDrvMDg_awesob = {
	"g_awesob", "g_atomrn", NULL, "1993",
	"Awesome Possum (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 1, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_awesobRomInfo, g_awesobRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Awesome Possum (USA)
static struct BurnRomInfo g_awesoRomDesc[] = {
	{ "awesome possum (usa).md", 0x200000, 0x1f07577f, BRF_PRG },
};

STD_ROM_PICK(g_aweso)
STD_ROM_FN(g_aweso)

struct BurnDriver BurnDrvMDg_aweso = {
	"g_aweso", NULL, NULL, "1993",
	"Awesome Possum (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_awesoRomInfo, g_awesoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Aworg (Japan) (SegaNet)
static struct BurnRomInfo g_aworgjRomDesc[] = {
	{ "aworg (japan) (seganet).md", 0x40000, 0x069c27c1, BRF_PRG },
};

STD_ROM_PICK(g_aworgj)
STD_ROM_FN(g_aworgj)

struct BurnDriver BurnDrvMDg_aworgj = {
	"g_aworgj", NULL, NULL, "1991",
	"Aworg (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_aworgjRomInfo, g_aworgjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// AWS Pro Moves Soccer (USA)
static struct BurnRomInfo g_awsproRomDesc[] = {
	{ "aws pro moves soccer (usa).md", 0x80000, 0x707017e5, BRF_PRG },
};

STD_ROM_PICK(g_awspro)
STD_ROM_FN(g_awspro)

struct BurnDriver BurnDrvMDg_awspro = {
	"g_awspro", NULL, NULL, "1993",
	"AWS Pro Moves Soccer (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSFOOTBALL, 0,
	NULL, g_awsproRomInfo, g_awsproRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ayrton Senna's Super Monaco GP II (Japan, Europe) (En,Ja)
static struct BurnRomInfo g_asmgpjRomDesc[] = {
	{ "ayrton senna's super monaco gp ii (japan, europe) (en,ja).md", 0x100000, 0x60af0f76, BRF_PRG },
};

STD_ROM_PICK(g_asmgpj)
STD_ROM_FN(g_asmgpj)

struct BurnDriver BurnDrvMDg_asmgpj = {
	"g_asmgpj", "g_asmgp", NULL, "1900",
	"Ayrton Senna's Super Monaco GP II (Japan, Europe) (En,Ja)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_asmgpjRomInfo, g_asmgpjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ayrton Senna's Super Monaco GP II (USA) (En,Ja)
static struct BurnRomInfo g_asmgpRomDesc[] = {
	{ "ayrton senna's super monaco gp ii (usa) (en,ja).md", 0x100000, 0xeac8ded6, BRF_PRG },
};

STD_ROM_PICK(g_asmgp)
STD_ROM_FN(g_asmgp)

struct BurnDriver BurnDrvMDg_asmgp = {
	"g_asmgp", NULL, NULL, "1900",
	"Ayrton Senna's Super Monaco GP II (USA) (En,Ja)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_asmgpRomInfo, g_asmgpRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// B.O.B. (USA) (Beta)
static struct BurnRomInfo g_bobbRomDesc[] = {
	{ "b.o.b. (usa) (beta).md", 0x100000, 0xe3e8421e, BRF_PRG },
};

STD_ROM_PICK(g_bobb)
STD_ROM_FN(g_bobb)

struct BurnDriverD BurnDrvMDg_bobb = {
	"g_bobb", "g_bob", NULL, "",
	"B.O.B. (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bobbRomInfo, g_bobbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// B.O.B. (USA, Europe)
static struct BurnRomInfo g_bobRomDesc[] = {
	{ "b.o.b. (usa, europe).md", 0x100000, 0xeaa2acb7, BRF_PRG },
};

STD_ROM_PICK(g_bob)
STD_ROM_FN(g_bob)

struct BurnDriver BurnDrvMDg_bob = {
	"g_bob", NULL, NULL, "1993",
	"B.O.B. (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bobRomInfo, g_bobRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Baby Boom (Prototype - Aug 11, 1994)
static struct BurnRomInfo g_babyboRomDesc[] = {
	{ "baby boom (prototype - aug 11, 1994).md", 0x200000, 0xbd697054, BRF_PRG },
};

STD_ROM_PICK(g_babybo)
STD_ROM_FN(g_babybo)

struct BurnDriverD BurnDrvMDg_babybo = {
	"g_babybo", NULL, NULL, "",
	"Baby Boom (Prototype - Aug 11, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_babyboRomInfo, g_babyboRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Baby Boom (Prototype - Jun 03, 1994)
static struct BurnRomInfo g_babyb1RomDesc[] = {
	{ "baby boom (prototype - jun 03, 1994).md", 0x200000, 0xc0d97f6f, BRF_PRG },
};

STD_ROM_PICK(g_babyb1)
STD_ROM_FN(g_babyb1)

struct BurnDriverD BurnDrvMDg_babyb1 = {
	"g_babyb1", "g_babybo", NULL, "",
	"Baby Boom (Prototype - Jun 03, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_babyb1RomInfo, g_babyb1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Baby Boom (Prototype - Jun 06, 1994)
static struct BurnRomInfo g_babyb2RomDesc[] = {
	{ "baby boom (prototype - jun 06, 1994).md", 0x200000, 0x6e0cf48d, BRF_PRG },
};

STD_ROM_PICK(g_babyb2)
STD_ROM_FN(g_babyb2)

struct BurnDriverD BurnDrvMDg_babyb2 = {
	"g_babyb2", "g_babybo", NULL, "",
	"Baby Boom (Prototype - Jun 06, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_babyb2RomInfo, g_babyb2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Baby's Day Out (USA) (Proto) (Earlier)
static struct BurnRomInfo g_babydoRomDesc[] = {
	{ "baby's day out (usa) (proto) (earlier).md", 0x100000, 0x459b891c, BRF_PRG },
};

STD_ROM_PICK(g_babydo)
STD_ROM_FN(g_babydo)

struct BurnDriverD BurnDrvMDg_babydo = {
	"g_babydo", "g_babyd", NULL, "",
	"Baby's Day Out (USA) (Proto) (Earlier)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_babydoRomInfo, g_babydoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Baby's Day Out (USA) (Proto)
static struct BurnRomInfo g_babydRomDesc[] = {
	{ "baby's day out (usa) (proto).md", 0x100000, 0xb2e7cc49, BRF_PRG },
};

STD_ROM_PICK(g_babyd)
STD_ROM_FN(g_babyd)

struct BurnDriver BurnDrvMDg_babyd = {
	"g_babyd", NULL, NULL, "1994",
	"Baby's Day Out (USA) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_babydRomInfo, g_babydRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Back to the Future Part III (Europe)
static struct BurnRomInfo g_backtoRomDesc[] = {
	{ "back to the future part iii (europe).md", 0x80000, 0x2737f92e, BRF_PRG },
};

STD_ROM_PICK(g_backto)
STD_ROM_FN(g_backto)

struct BurnDriver BurnDrvMDg_backto = {
	"g_backto", NULL, NULL, "1991",
	"Back to the Future Part III (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_backtoRomInfo, g_backtoRomName, MegadriveInputInfo, MegadriveEuropeDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Back to the Future Part III (USA)
static struct BurnRomInfo g_backt1RomDesc[] = {
	{ "back to the future part iii (usa).md", 0x80000, 0x66a388c3, BRF_PRG },
};

STD_ROM_PICK(g_backt1)
STD_ROM_FN(g_backt1)

struct BurnDriver BurnDrvMDg_backt1 = {
	"g_backt1", "g_backto", NULL, "1991",
	"Back to the Future Part III (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 1, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_backt1RomInfo, g_backt1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bad Omen (Japan, Korea)
static struct BurnRomInfo g_badomeRomDesc[] = {
	{ "bad omen (japan, korea).md", 0x80000, 0x975693ce, BRF_PRG },
};

STD_ROM_PICK(g_badome)
STD_ROM_FN(g_badome)

struct BurnDriverD BurnDrvMDg_badome = {
	"g_badome", "g_devili", NULL, "1992",
	"Bad Omen (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_badomeRomInfo, g_badomeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bahamut Senki (Japan)
static struct BurnRomInfo g_bahamuRomDesc[] = {
	{ "bahamut senki (japan).md", 0x80000, 0xb1e268da, BRF_PRG },
};

STD_ROM_PICK(g_bahamu)
STD_ROM_FN(g_bahamu)

struct BurnDriver BurnDrvMDg_bahamu = {
	"g_bahamu", NULL, NULL, "1900",
	"Bahamut Senki (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bahamuRomInfo, g_bahamuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ball Jacks (Japan, Europe)
static struct BurnRomInfo g_balljaRomDesc[] = {
	{ "ball jacks (japan, europe).md", 0x40000, 0xf5c3c54f, BRF_PRG },
};

STD_ROM_PICK(g_ballja)
STD_ROM_FN(g_ballja)

struct BurnDriver BurnDrvMDg_ballja = {
	"g_ballja", NULL, NULL, "1993",
	"Ball Jacks (Japan, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_balljaRomInfo, g_balljaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ballz 3D - Fighting at Its Ballziest (USA, Europe)
static struct BurnRomInfo g_ballzdRomDesc[] = {
	{ "ballz 3d - fighting at its ballziest (usa, europe).md", 0x200000, 0xb362b705, BRF_PRG },
};

STD_ROM_PICK(g_ballzd)
STD_ROM_FN(g_ballzd)

struct BurnDriver BurnDrvMDg_ballzd = {
	"g_ballzd", NULL, NULL, "1900",
	"Ballz 3D - Fighting at Its Ballziest (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ballzdRomInfo, g_ballzdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barbie Super Model (USA)
static struct BurnRomInfo g_barbieRomDesc[] = {
	{ "barbie super model (usa).md", 0x100000, 0x81c9662b, BRF_PRG },
};

STD_ROM_PICK(g_barbie)
STD_ROM_FN(g_barbie)

struct BurnDriver BurnDrvMDg_barbie = {
	"g_barbie", NULL, NULL, "1993",
	"Barbie Super Model (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_barbieRomInfo, g_barbieRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barbie Vacation Adventure (USA) (Proto)
static struct BurnRomInfo g_barbi1RomDesc[] = {
	{ "barbie vacation adventure (usa) (proto).md", 0x100000, 0x10e0ba69, BRF_PRG },
};

STD_ROM_PICK(g_barbi1)
STD_ROM_FN(g_barbi1)

struct BurnDriver BurnDrvMDg_barbi1 = {
	"g_barbi1", NULL, NULL, "1994",
	"Barbie Vacation Adventure (USA) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_barbi1RomInfo, g_barbi1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Streets of Rage ~ Bare Knuckle - Ikari no Tetsuken (World) (Rev A)
static struct BurnRomInfo g_sorRomDesc[] = {
	{ "streets of rage ~ bare knuckle - ikari no tetsuken (world) (rev a).md", 0x80000, 0x4052e845, BRF_PRG },
};

STD_ROM_PICK(g_sor)
STD_ROM_FN(g_sor)

struct BurnDriver BurnDrvMDg_sor = {
	"g_sor", NULL, NULL, "1991",
	"Streets of Rage ~ Bare Knuckle - Ikari no Tetsuken (World) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_sorRomInfo, g_sorRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Streets of Rage ~ Bare Knuckle - Ikari no Tetsuken (World)
static struct BurnRomInfo g_soraRomDesc[] = {
	{ "streets of rage ~ bare knuckle - ikari no tetsuken (world).md", 0x80000, 0xbff227c6, BRF_PRG },
};

STD_ROM_PICK(g_sora)
STD_ROM_FN(g_sora)

struct BurnDriver BurnDrvMDg_sora = {
	"g_sora", "g_sor", NULL, "1991",
	"Streets of Rage ~ Bare Knuckle - Ikari no Tetsuken (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_soraRomInfo, g_soraRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bare Knuckle II (Japan) (Beta)
static struct BurnRomInfo g_bk2bRomDesc[] = {
	{ "bare knuckle ii (japan) (beta).md", 0x130000, 0x0cf2acbe, BRF_PRG },
};

STD_ROM_PICK(g_bk2b)
STD_ROM_FN(g_bk2b)

struct BurnDriver BurnDrvMDg_bk2b = {
	"g_bk2b", "g_sor2", NULL, "1992",
	"Bare Knuckle II (Japan) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bk2bRomInfo, g_bk2bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bare Knuckle II - Shitou heno Chingonka ~ Streets of Rage II (Japan, Europe)
static struct BurnRomInfo g_bk2RomDesc[] = {
	{ "bare knuckle ii - shitou heno chingonka ~ streets of rage ii (japan, europe).md", 0x200000, 0x42e3efdc, BRF_PRG },
};

STD_ROM_PICK(g_bk2)
STD_ROM_FN(g_bk2)

struct BurnDriver BurnDrvMDg_bk2 = {
	"g_bk2", "g_sor2", NULL, "1992",
	"Bare Knuckle II - Shitou heno Chingonka ~ Streets of Rage II (Japan, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bk2RomInfo, g_bk2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bare Knuckle III (Beta)
static struct BurnRomInfo g_bk3bRomDesc[] = {
	{ "bare knuckle iii (beta).md", 0x300000, 0xe7ff99db, BRF_PRG },
};

STD_ROM_PICK(g_bk3b)
STD_ROM_FN(g_bk3b)

struct BurnDriverD BurnDrvMDg_bk3b = {
	"g_bk3b", "g_sor3", NULL, "",
	"Bare Knuckle III (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bk3bRomInfo, g_bk3bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bare Knuckle III (Japan)
static struct BurnRomInfo g_bk3RomDesc[] = {
	{ "bare knuckle iii (japan).md", 0x300000, 0x5d09236f, BRF_PRG },
};

STD_ROM_PICK(g_bk3)
STD_ROM_FN(g_bk3)

struct BurnDriver BurnDrvMDg_bk3 = {
	"g_bk3", "g_sor3", NULL, "1994",
	"Bare Knuckle III (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bk3RomInfo, g_bk3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barkley Shut Up and Jam! (USA, Europe)
static struct BurnRomInfo g_barkleRomDesc[] = {
	{ "barkley shut up and jam! (usa, europe).md", 0x100000, 0x63fbf497, BRF_PRG },
};

STD_ROM_PICK(g_barkle)
STD_ROM_FN(g_barkle)

struct BurnDriverD BurnDrvMDg_barkle = {
	"g_barkle", NULL, NULL, "1994",
	"Barkley Shut Up and Jam! (USA, Europe)\0", "Gfx Problems", "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_barkleRomInfo, g_barkleRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barkley Shut Up and Jam! 2 (USA) (Beta)
static struct BurnRomInfo g_bark2bRomDesc[] = {
	{ "barkley shut up and jam! 2 (usa) (beta).md", 0x200000, 0xde27357b, BRF_PRG },
};

STD_ROM_PICK(g_bark2b)
STD_ROM_FN(g_bark2b)

struct BurnDriverD BurnDrvMDg_bark2b = {
	"g_bark2b", "g_bark2", NULL, "",
	"Barkley Shut Up and Jam! 2 (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bark2bRomInfo, g_bark2bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barkley Shut Up and Jam! 2 (USA)
static struct BurnRomInfo g_bark2RomDesc[] = {
	{ "barkley shut up and jam! 2 (usa).md", 0x200000, 0x321bb6bd, BRF_PRG },
};

STD_ROM_PICK(g_bark2)
STD_ROM_FN(g_bark2)

struct BurnDriverD BurnDrvMDg_bark2 = {
	"g_bark2", NULL, NULL, "1995",
	"Barkley Shut Up and Jam! 2 (USA)\0", "Gfx Problems", "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_bark2RomInfo, g_bark2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barney's Hide & Seek Game (USA)
static struct BurnRomInfo g_barneyRomDesc[] = {
	{ "barney's hide & seek game (usa).md", 0x100000, 0x1efa9d53, BRF_PRG },
};

STD_ROM_PICK(g_barney)
STD_ROM_FN(g_barney)

struct BurnDriver BurnDrvMDg_barney = {
	"g_barney", NULL, NULL, "1993",
	"Barney's Hide & Seek Game (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_barneyRomInfo, g_barneyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Barver Battle Saga - Tai Kong Zhan Shi (China) (Unl)
static struct BurnRomInfo g_barverRomDesc[] = {
	{ "barver battle saga - tai kong zhan shi (china) (unl).md", 0x200000, 0xd37a37c6, BRF_PRG },
};

STD_ROM_PICK(g_barver)
STD_ROM_FN(g_barver)

struct BurnDriverD BurnDrvMDg_barver = {
	"g_barver", NULL, NULL, "",
	"Barver Battle Saga - Tai Kong Zhan Shi (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_barverRomInfo, g_barverRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bass Masters Classic (USA)
static struct BurnRomInfo g_bassmaRomDesc[] = {
	{ "bass masters classic (usa).md", 0x200000, 0xcf1ff00a, BRF_PRG },
};

STD_ROM_PICK(g_bassma)
STD_ROM_FN(g_bassma)

struct BurnDriver BurnDrvMDg_bassma = {
	"g_bassma", NULL, NULL, "1994",
	"Bass Masters Classic (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 1, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bassmaRomInfo, g_bassmaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bass Masters Classic - Pro Edition (USA)
static struct BurnRomInfo g_bassmpRomDesc[] = {
	{ "bass masters classic - pro edition (usa).md", 0x200000, 0x9eddeb3d, BRF_PRG },
};

STD_ROM_PICK(g_bassmp)
STD_ROM_FN(g_bassmp)

struct BurnDriverD BurnDrvMDg_bassmp = {
	"g_bassmp", NULL, NULL, "1996",
	"Bass Masters Classic - Pro Edition (USA)\0", "Gfx Problems", "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bassmpRomInfo, g_bassmpRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman (Europe)
static struct BurnRomInfo g_batmanRomDesc[] = {
	{ "batman (europe).md", 0x80000, 0x61c60c35, BRF_PRG },
};

STD_ROM_PICK(g_batman)
STD_ROM_FN(g_batman)

struct BurnDriver BurnDrvMDg_batman = {
	"g_batman", NULL, NULL, "1991",
	"Batman (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_batmanRomInfo, g_batmanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman (Japan)
static struct BurnRomInfo g_batma1RomDesc[] = {
	{ "batman (japan).md", 0x80000, 0xd7b4febf, BRF_PRG },
};

STD_ROM_PICK(g_batma1)
STD_ROM_FN(g_batma1)

struct BurnDriver BurnDrvMDg_batma1 = {
	"g_batma1", "g_batman", NULL, "1990",
	"Batman (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_batma1RomInfo, g_batma1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman (USA)
static struct BurnRomInfo g_batma2RomDesc[] = {
	{ "batman (usa).md", 0x80000, 0x017410ae, BRF_PRG },
};

STD_ROM_PICK(g_batma2)
STD_ROM_FN(g_batma2)

struct BurnDriver BurnDrvMDg_batma2 = {
	"g_batma2", "g_batman", NULL, "1991",
	"Batman (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_batma2RomInfo, g_batma2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman - Revenge of the Joker (USA)
static struct BurnRomInfo g_batmrdRomDesc[] = {
	{ "batman - revenge of the joker (usa).md", 0x100000, 0xcaa044a1, BRF_PRG },
};

STD_ROM_PICK(g_batmrd)
STD_ROM_FN(g_batmrd)

struct BurnDriver BurnDrvMDg_batmrd = {
	"g_batmrd", NULL, NULL, "1992",
	"Batman - Revenge of the Joker (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_batmrdRomInfo, g_batmrdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman Forever (World)
static struct BurnRomInfo g_batmfrRomDesc[] = {
	{ "batman forever (world).md", 0x300000, 0x8b723d01, BRF_PRG },
};

STD_ROM_PICK(g_batmfr)
STD_ROM_FN(g_batmfr)

struct BurnDriver BurnDrvMDg_batmfr = {
	"g_batmfr", NULL, NULL, "1995",
	"Batman Forever (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_batmfrRomInfo, g_batmfrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Batman Returns (World)
static struct BurnRomInfo g_batmrtRomDesc[] = {
	{ "batman returns (world).md", 0x100000, 0x4a3225c0, BRF_PRG },
};

STD_ROM_PICK(g_batmrt)
STD_ROM_FN(g_batmrt)

struct BurnDriver BurnDrvMDg_batmrt = {
	"g_batmrt", NULL, NULL, "1992",
	"Batman Returns (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_batmrtRomInfo, g_batmrtRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battle Golfer Yui (Japan)
static struct BurnRomInfo g_battleRomDesc[] = {
	{ "battle golfer yui (japan).md", 0x80000, 0x4aa03e4e, BRF_PRG },
};

STD_ROM_PICK(g_battle)
STD_ROM_FN(g_battle)

struct BurnDriver BurnDrvMDg_battle = {
	"g_battle", NULL, NULL, "1991",
	"Battle Golfer Yui (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_battleRomInfo, g_battleRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battle Mania (Japan)
static struct BurnRomInfo g_battmaRomDesc[] = {
	{ "battle mania (japan).md", 0x80000, 0xa76c4a29, BRF_PRG },
};

STD_ROM_PICK(g_battma)
STD_ROM_FN(g_battma)

struct BurnDriverD BurnDrvMDg_battma = {
	"g_battma", "g_troubl", NULL, "1900",
	"Battle Mania (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_battmaRomInfo, g_battmaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battle Mania Daiginjou (Japan, Korea)
static struct BurnRomInfo g_battmdRomDesc[] = {
	{ "battle mania daiginjou (japan, korea).md", 0x100000, 0x312fa0f2, BRF_PRG },
};

STD_ROM_PICK(g_battmd)
STD_ROM_FN(g_battmd)

struct BurnDriver BurnDrvMDg_battmd = {
	"g_battmd", NULL, NULL, "1993",
	"Battle Mania Daiginjou (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_VERSHOOT, 0,
	NULL, g_battmdRomInfo, g_battmdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battle Squadron (USA, Europe)
static struct BurnRomInfo g_battsqRomDesc[] = {
	{ "battle squadron (usa, europe).md", 0x80000, 0x0feaa8bf, BRF_PRG },
};

STD_ROM_PICK(g_battsq)
STD_ROM_FN(g_battsq)

struct BurnDriverD BurnDrvMDg_battsq = {
	"g_battsq", NULL, NULL, "1990",
	"Battle Squadron (USA, Europe)\0", "Sound Problems", "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_VERSHOOT, 0,
	NULL, g_battsqRomInfo, g_battsqRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battlemaster (USA)
static struct BurnRomInfo g_battmsRomDesc[] = {
	{ "battlemaster (usa).md", 0x80000, 0xfd2b35e3, BRF_PRG },
};

STD_ROM_PICK(g_battms)
STD_ROM_FN(g_battms)

struct BurnDriverD BurnDrvMDg_battms = {
	"g_battms", NULL, NULL, "1900",
	"Battlemaster (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_battmsRomInfo, g_battmsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// BattleTech - A Game of Armored Combat (USA)
static struct BurnRomInfo g_batttcRomDesc[] = {
	{ "battletech - a game of armored combat (usa).md", 0x200000, 0x409e5d14, BRF_PRG },
};

STD_ROM_PICK(g_batttc)
STD_ROM_FN(g_batttc)

struct BurnDriver BurnDrvMDg_batttc = {
	"g_batttc", NULL, NULL, "1994",
	"BattleTech - A Game of Armored Combat (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SHOOT, 0,
	NULL, g_batttcRomInfo, g_batttcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battletoads & Double Dragon (USA)
static struct BurnRomInfo g_btoaddRomDesc[] = {
	{ "battletoads & double dragon (usa).md", 0x100000, 0x8239dd17, BRF_PRG },
};

STD_ROM_PICK(g_btoadd)
STD_ROM_FN(g_btoadd)

struct BurnDriver BurnDrvMDg_btoadd = {
	"g_btoadd", NULL, NULL, "1993",
	"Battletoads & Double Dragon (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_btoaddRomInfo, g_btoaddRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Battletoads (World)
static struct BurnRomInfo g_btoadsRomDesc[] = {
	{ "battletoads (world).md", 0x80000, 0xd10e103a, BRF_PRG },
};

STD_ROM_PICK(g_btoads)
STD_ROM_FN(g_btoads)

struct BurnDriver BurnDrvMDg_btoads = {
	"g_btoads", NULL, NULL, "1991",
	"Battletoads (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_btoadsRomInfo, g_btoadsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beast Warriors (Japan)
static struct BurnRomInfo g_beaswjRomDesc[] = {
	{ "beast warriors (japan).md", 0x100000, 0x4646c694, BRF_PRG },
};

STD_ROM_PICK(g_beaswj)
STD_ROM_FN(g_beaswj)

struct BurnDriverD BurnDrvMDg_beaswj = {
	"g_beaswj", "g_beasw", NULL, "1900",
	"Beast Warriors (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beaswjRomInfo, g_beaswjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beast Wrestler (USA)
static struct BurnRomInfo g_beaswRomDesc[] = {
	{ "beast wrestler (usa).md", 0x100000, 0x0ca5bb64, BRF_PRG },
};

STD_ROM_PICK(g_beasw)
STD_ROM_FN(g_beasw)

struct BurnDriver BurnDrvMDg_beasw = {
	"g_beasw", NULL, NULL, "1991",
	"Beast Wrestler (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_beaswRomInfo, g_beaswRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beauty and the Beast - Belle's Quest (USA)
static struct BurnRomInfo g_beautyRomDesc[] = {
	{ "beauty and the beast - belle's quest (usa).md", 0x100000, 0xbefb6fae, BRF_PRG },
};

STD_ROM_PICK(g_beauty)
STD_ROM_FN(g_beauty)

struct BurnDriver BurnDrvMDg_beauty = {
	"g_beauty", NULL, NULL, "1993",
	"Beauty and the Beast - Belle's Quest (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beautyRomInfo, g_beautyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beauty and the Beast - Roar of the Beast (USA)
static struct BurnRomInfo g_beaurbRomDesc[] = {
	{ "beauty and the beast - roar of the beast (usa).md", 0x100000, 0x13e7b519, BRF_PRG },
};

STD_ROM_PICK(g_beaurb)
STD_ROM_FN(g_beaurb)

struct BurnDriver BurnDrvMDg_beaurb = {
	"g_beaurb", NULL, NULL, "1993",
	"Beauty and the Beast - Roar of the Beast (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_beaurbRomInfo, g_beaurbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beavis and Butt-Head (Europe)
static struct BurnRomInfo g_beavisRomDesc[] = {
	{ "beavis and butt-head (europe).md", 0x200000, 0xc7b6435e, BRF_PRG },
};

STD_ROM_PICK(g_beavis)
STD_ROM_FN(g_beavis)

struct BurnDriver BurnDrvMDg_beavis = {
	"g_beavis", NULL, NULL, "1994",
	"Beavis and Butt-Head (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_beavisRomInfo, g_beavisRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beavis and Butt-Head (USA) (Beta)
static struct BurnRomInfo g_beavi1RomDesc[] = {
	{ "beavis and butt-head (usa) (beta).md", 0x200000, 0x81ed5335, BRF_PRG },
};

STD_ROM_PICK(g_beavi1)
STD_ROM_FN(g_beavi1)

struct BurnDriverD BurnDrvMDg_beavi1 = {
	"g_beavi1", "g_beavis", NULL, "1900",
	"Beavis and Butt-Head (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beavi1RomInfo, g_beavi1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beavis and Butt-Head (USA)
static struct BurnRomInfo g_beavi2RomDesc[] = {
	{ "beavis and butt-head (usa).md", 0x200000, 0xf5d7b948, BRF_PRG },
};

STD_ROM_PICK(g_beavi2)
STD_ROM_FN(g_beavi2)

struct BurnDriver BurnDrvMDg_beavi2 = {
	"g_beavi2", "g_beavis", NULL, "1994",
	"Beavis and Butt-Head (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_beavi2RomInfo, g_beavi2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (USA)
static struct BurnRomInfo g_berensRomDesc[] = {
	{ "berenstain bears' camping adventure, the (usa).md", 0x100000, 0x1f86237b, BRF_PRG },
};

STD_ROM_PICK(g_berens)
STD_ROM_FN(g_berens)

struct BurnDriver BurnDrvMDg_berens = {
	"g_berens", NULL, NULL, "1994",
	"Berenstain Bears' Camping Adventure, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_berensRomInfo, g_berensRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Apr 28, 1994)
static struct BurnRomInfo g_beren1RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - apr 28, 1994).md", 0x100000, 0xf222e946, BRF_PRG },
};

STD_ROM_PICK(g_beren1)
STD_ROM_FN(g_beren1)

struct BurnDriverD BurnDrvMDg_beren1 = {
	"g_beren1", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Apr 28, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beren1RomInfo, g_beren1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Apr 29, 1994)
static struct BurnRomInfo g_beren2RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - apr 29, 1994).md", 0x100000, 0xe21493b4, BRF_PRG },
};

STD_ROM_PICK(g_beren2)
STD_ROM_FN(g_beren2)

struct BurnDriverD BurnDrvMDg_beren2 = {
	"g_beren2", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Apr 29, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beren2RomInfo, g_beren2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Aug 01, 1994)
static struct BurnRomInfo g_beren3RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - aug 01, 1994).md", 0x100000, 0xb7cd465c, BRF_PRG },
};

STD_ROM_PICK(g_beren3)
STD_ROM_FN(g_beren3)

struct BurnDriverD BurnDrvMDg_beren3 = {
	"g_beren3", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Aug 01, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beren3RomInfo, g_beren3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Aug 02, 1994)
static struct BurnRomInfo g_beren4RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - aug 02, 1994).md", 0x100000, 0x383ad564, BRF_PRG },
};

STD_ROM_PICK(g_beren4)
STD_ROM_FN(g_beren4)

struct BurnDriverD BurnDrvMDg_beren4 = {
	"g_beren4", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Aug 02, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beren4RomInfo, g_beren4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Aug 03, 1994)
static struct BurnRomInfo g_beren5RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - aug 03, 1994).md", 0x100000, 0x18f268a6, BRF_PRG },
};

STD_ROM_PICK(g_beren5)
STD_ROM_FN(g_beren5)

struct BurnDriverD BurnDrvMDg_beren5 = {
	"g_beren5", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Aug 03, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beren5RomInfo, g_beren5RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Aug 05, 1994)
static struct BurnRomInfo g_beren6RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - aug 05, 1994).md", 0x100000, 0x24159b6f, BRF_PRG },
};

STD_ROM_PICK(g_beren6)
STD_ROM_FN(g_beren6)

struct BurnDriverD BurnDrvMDg_beren6 = {
	"g_beren6", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Aug 05, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beren6RomInfo, g_beren6RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Aug 08, 1994)
static struct BurnRomInfo g_beren7RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - aug 08, 1994).md", 0x100000, 0x58b6b0fc, BRF_PRG },
};

STD_ROM_PICK(g_beren7)
STD_ROM_FN(g_beren7)

struct BurnDriverD BurnDrvMDg_beren7 = {
	"g_beren7", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Aug 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beren7RomInfo, g_beren7RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Jul 09, 1994)
static struct BurnRomInfo g_beren8RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - jul 09, 1994).md", 0x100000, 0xbf6aa405, BRF_PRG },
};

STD_ROM_PICK(g_beren8)
STD_ROM_FN(g_beren8)

struct BurnDriverD BurnDrvMDg_beren8 = {
	"g_beren8", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Jul 09, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beren8RomInfo, g_beren8RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Jul 16, 1994)
static struct BurnRomInfo g_beren9RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - jul 16, 1994).md", 0x100000, 0xc84aad8e, BRF_PRG },
};

STD_ROM_PICK(g_beren9)
STD_ROM_FN(g_beren9)

struct BurnDriverD BurnDrvMDg_beren9 = {
	"g_beren9", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Jul 16, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beren9RomInfo, g_beren9RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Jul 20, 1994)
static struct BurnRomInfo g_bere10RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - jul 20, 1994).md", 0x100000, 0xabee4c5e, BRF_PRG },
};

STD_ROM_PICK(g_bere10)
STD_ROM_FN(g_bere10)

struct BurnDriverD BurnDrvMDg_bere10 = {
	"g_bere10", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Jul 20, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bere10RomInfo, g_bere10RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Jun 02, 1994)
static struct BurnRomInfo g_bere11RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - jun 02, 1994).md", 0x100000, 0x83cf19e4, BRF_PRG },
};

STD_ROM_PICK(g_bere11)
STD_ROM_FN(g_bere11)

struct BurnDriverD BurnDrvMDg_bere11 = {
	"g_bere11", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Jun 02, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bere11RomInfo, g_bere11RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Jun 10, 1994)
static struct BurnRomInfo g_bere12RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - jun 10, 1994).md", 0x100000, 0xa748e2cf, BRF_PRG },
};

STD_ROM_PICK(g_bere12)
STD_ROM_FN(g_bere12)

struct BurnDriverD BurnDrvMDg_bere12 = {
	"g_bere12", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Jun 10, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bere12RomInfo, g_bere12RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - Mar 23, 1994)
static struct BurnRomInfo g_bere13RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - mar 23, 1994).md", 0x100000, 0xbfbcd7cc, BRF_PRG },
};

STD_ROM_PICK(g_bere13)
STD_ROM_FN(g_bere13)

struct BurnDriverD BurnDrvMDg_bere13 = {
	"g_bere13", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - Mar 23, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bere13RomInfo, g_bere13RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - May 06, 1994)
static struct BurnRomInfo g_bere14RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 06, 1994).md", 0x100000, 0x713c14d8, BRF_PRG },
};

STD_ROM_PICK(g_bere14)
STD_ROM_FN(g_bere14)

struct BurnDriverD BurnDrvMDg_bere14 = {
	"g_bere14", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - May 06, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bere14RomInfo, g_bere14RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - May 11, 1994)
static struct BurnRomInfo g_bere15RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 11, 1994).md", 0x100000, 0xf7b81c6a, BRF_PRG },
};

STD_ROM_PICK(g_bere15)
STD_ROM_FN(g_bere15)

struct BurnDriverD BurnDrvMDg_bere15 = {
	"g_bere15", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - May 11, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bere15RomInfo, g_bere15RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - May 17, 1994)
static struct BurnRomInfo g_bere16RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 17, 1994).md", 0x100000, 0xe1855ade, BRF_PRG },
};

STD_ROM_PICK(g_bere16)
STD_ROM_FN(g_bere16)

struct BurnDriverD BurnDrvMDg_bere16 = {
	"g_bere16", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - May 17, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bere16RomInfo, g_bere16RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - May 19, 1994)
static struct BurnRomInfo g_bere17RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 19, 1994).md", 0x100000, 0x07c9f71f, BRF_PRG },
};

STD_ROM_PICK(g_bere17)
STD_ROM_FN(g_bere17)

struct BurnDriverD BurnDrvMDg_bere17 = {
	"g_bere17", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - May 19, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bere17RomInfo, g_bere17RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - May 23, 1994)
static struct BurnRomInfo g_bere18RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 23, 1994).md", 0x100000, 0x913887b7, BRF_PRG },
};

STD_ROM_PICK(g_bere18)
STD_ROM_FN(g_bere18)

struct BurnDriverD BurnDrvMDg_bere18 = {
	"g_bere18", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - May 23, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bere18RomInfo, g_bere18RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - May 26, 1994)
static struct BurnRomInfo g_bere19RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 26, 1994).md", 0x100000, 0xd33c0fa4, BRF_PRG },
};

STD_ROM_PICK(g_bere19)
STD_ROM_FN(g_bere19)

struct BurnDriverD BurnDrvMDg_bere19 = {
	"g_bere19", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - May 26, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bere19RomInfo, g_bere19RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Berenstain Bears' Camping Adventure, The (Prototype - May 30, 1994)
static struct BurnRomInfo g_bere20RomDesc[] = {
	{ "berenstain bears' camping adventure, the (prototype - may 30, 1994).md", 0x100000, 0x9c3bf429, BRF_PRG },
};

STD_ROM_PICK(g_bere20)
STD_ROM_FN(g_bere20)

struct BurnDriverD BurnDrvMDg_bere20 = {
	"g_bere20", "g_berens", NULL, "",
	"Berenstain Bears' Camping Adventure, The (Prototype - May 30, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bere20RomInfo, g_bere20RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Best of the Best - Championship Karate (Europe)
static struct BurnRomInfo g_bestofRomDesc[] = {
	{ "best of the best - championship karate (europe).md", 0x100000, 0xf842240b, BRF_PRG },
};

STD_ROM_PICK(g_bestof)
STD_ROM_FN(g_bestof)

struct BurnDriver BurnDrvMDg_bestof = {
	"g_bestof", NULL, NULL, "1992",
	"Best of the Best - Championship Karate (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_bestofRomInfo, g_bestofRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Best of the Best - Championship Karate (USA)
static struct BurnRomInfo g_besto1RomDesc[] = {
	{ "best of the best - championship karate (usa).md", 0x100000, 0xc3d6a5d4, BRF_PRG },
};

STD_ROM_PICK(g_besto1)
STD_ROM_FN(g_besto1)

struct BurnDriver BurnDrvMDg_besto1 = {
	"g_besto1", "g_bestof", NULL, "1993",
	"Best of the Best - Championship Karate (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_besto1RomInfo, g_besto1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beyond Oasis (Prototype - Nov 01, 1994)
static struct BurnRomInfo g_beyonpRomDesc[] = {
	{ "beyond oasis (prototype - nov 01, 1994).md", 0x300000, 0xfa59f847, BRF_PRG },
};

STD_ROM_PICK(g_beyonp)
STD_ROM_FN(g_beyonp)

struct BurnDriverD BurnDrvMDg_beyonp = {
	"g_beyonp", "g_storyo", NULL, "",
	"Beyond Oasis (Prototype - Nov 01, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beyonpRomInfo, g_beyonpRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beyond Oasis (USA)
static struct BurnRomInfo g_beyonuRomDesc[] = {
	{ "beyond oasis (usa).md", 0x300000, 0xc4728225, BRF_PRG },
};

STD_ROM_PICK(g_beyonu)
STD_ROM_FN(g_beyonu)

struct BurnDriver BurnDrvMDg_beyonu = {
	"g_beyonu", "g_storyo", NULL, "1995",
	"Beyond Oasis (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beyonuRomInfo, g_beyonuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Beyond Zero Tolerance (USA) (Proto)
static struct BurnRomInfo g_beyztRomDesc[] = {
	{ "beyond zero tolerance (usa) (proto).md", 0x200000, 0xc61ed2ed, BRF_PRG },
};

STD_ROM_PICK(g_beyzt)
STD_ROM_FN(g_beyzt)

struct BurnDriverD BurnDrvMDg_beyzt = {
	"g_beyzt", NULL, NULL, "",
	"Beyond Zero Tolerance (USA) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_beyztRomInfo, g_beyztRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bible Adventures (USA) (Unl)
static struct BurnRomInfo g_bibleaRomDesc[] = {
	{ "bible adventures (usa) (unl).md", 0x80000, 0x64446b77, BRF_PRG },
};

STD_ROM_PICK(g_biblea)
STD_ROM_FN(g_biblea)

struct BurnDriverD BurnDrvMDg_biblea = {
	"g_biblea", NULL, NULL, "",
	"Bible Adventures (USA) (Unl)\0", NULL, "Wisdom Tree", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bibleaRomInfo, g_bibleaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bill Walsh College Football (USA, Europe)
static struct BurnRomInfo g_billwaRomDesc[] = {
	{ "bill walsh college football (usa, europe).md", 0x100000, 0x3ed83362, BRF_PRG },
};

STD_ROM_PICK(g_billwa)
STD_ROM_FN(g_billwa)

struct BurnDriver BurnDrvMDg_billwa = {
	"g_billwa", NULL, NULL, "1993",
	"Bill Walsh College Football (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_billwaRomInfo, g_billwaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bill Walsh College Football 95 (USA)
static struct BurnRomInfo g_bill95RomDesc[] = {
	{ "bill walsh college football 95 (usa).md", 0x200000, 0xa582f45a, BRF_PRG },
};

STD_ROM_PICK(g_bill95)
STD_ROM_FN(g_bill95)

struct BurnDriver BurnDrvMDg_bill95 = {
	"g_bill95", NULL, NULL, "1994",
	"Bill Walsh College Football 95 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_bill95RomInfo, g_bill95RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bimini Run (USA)
static struct BurnRomInfo g_biminiRomDesc[] = {
	{ "bimini run (usa).md", 0x80000, 0xd4dc5188, BRF_PRG },
};

STD_ROM_PICK(g_bimini)
STD_ROM_FN(g_bimini)

struct BurnDriver BurnDrvMDg_bimini = {
	"g_bimini", NULL, NULL, "1990",
	"Bimini Run (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SHOOT, 0,
	NULL, g_biminiRomInfo, g_biminiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bio Hazard Battle (USA) (Beta)
static struct BurnRomInfo g_biohzbRomDesc[] = {
	{ "bio hazard battle (usa) (beta).md", 0x100000, 0xdd10dd1a, BRF_PRG },
};

STD_ROM_PICK(g_biohzb)
STD_ROM_FN(g_biohzb)

struct BurnDriver BurnDrvMDg_biohzb = {
	"g_biohzb", "g_biohz", NULL, "1992",
	"Bio Hazard Battle (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_HORSHOOT, 0,
	NULL, g_biohzbRomInfo, g_biohzbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bio Hazard Battle (USA, Europe)
static struct BurnRomInfo g_biohzRomDesc[] = {
	{ "bio hazard battle (usa, europe).md", 0x100000, 0x95b0ea2b, BRF_PRG },
};

STD_ROM_PICK(g_biohz)
STD_ROM_FN(g_biohz)

struct BurnDriver BurnDrvMDg_biohz = {
	"g_biohz", NULL, NULL, "1992",
	"Bio Hazard Battle (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_HORSHOOT, 0,
	NULL, g_biohzRomInfo, g_biohzRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bishoujo Senshi Sailor Moon (Japan)
static struct BurnRomInfo g_bishouRomDesc[] = {
	{ "bishoujo senshi sailor moon (japan).md", 0x200000, 0x5e246938, BRF_PRG },
};

STD_ROM_PICK(g_bishou)
STD_ROM_FN(g_bishou)

struct BurnDriver BurnDrvMDg_bishou = {
	"g_bishou", NULL, NULL, "1994",
	"Bishoujo Senshi Sailor Moon (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_bishouRomInfo, g_bishouRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blades of Vengeance (USA, Europe)
static struct BurnRomInfo g_bladesRomDesc[] = {
	{ "blades of vengeance (usa, europe).md", 0x100000, 0x74c65a49, BRF_PRG },
};

STD_ROM_PICK(g_blades)
STD_ROM_FN(g_blades)

struct BurnDriver BurnDrvMDg_blades = {
	"g_blades", NULL, NULL, "1993",
	"Blades of Vengeance (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_bladesRomInfo, g_bladesRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blaster Master 2 (USA) (Beta)
static struct BurnRomInfo g_blastbRomDesc[] = {
	{ "blaster master 2 (usa) (beta).md", 0x100000, 0x08f78c70, BRF_PRG },
};

STD_ROM_PICK(g_blastb)
STD_ROM_FN(g_blastb)

struct BurnDriver BurnDrvMDg_blastb = {
	"g_blastb", "g_blast", NULL, "1993",
	"Blaster Master 2 (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_VERSHOOT, 0,
	NULL, g_blastbRomInfo, g_blastbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blaster Master 2 (USA)
static struct BurnRomInfo g_blastRomDesc[] = {
	{ "blaster master 2 (usa).md", 0x100000, 0xc11e4ba1, BRF_PRG },
};

STD_ROM_PICK(g_blast)
STD_ROM_FN(g_blast)

struct BurnDriver BurnDrvMDg_blast = {
	"g_blast", NULL, NULL, "1993",
	"Blaster Master 2 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_VERSHOOT, 0,
	NULL, g_blastRomInfo, g_blastRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blockbuster World Video Game Championship II (USA)
static struct BurnRomInfo g_blockbRomDesc[] = {
	{ "blockbuster world video game championship ii (usa).md", 0x400000, 0x4385e366, BRF_PRG },
};

STD_ROM_PICK(g_blockb)
STD_ROM_FN(g_blockb)

struct BurnDriverD BurnDrvMDg_blockb = {
	"g_blockb", NULL, NULL, "1900",
	"Blockbuster World Video Game Championship II (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_blockbRomInfo, g_blockbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blockout (World)
static struct BurnRomInfo g_blockoRomDesc[] = {
	{ "blockout (world).md", 0x20000, 0x5e2966f1, BRF_PRG },
};

STD_ROM_PICK(g_blocko)
STD_ROM_FN(g_blocko)

struct BurnDriver BurnDrvMDg_blocko = {
	"g_blocko", NULL, NULL, "1991",
	"Blockout (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PUZZLE, 0,
	NULL, g_blockoRomInfo, g_blockoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bloodshot (Europe) (En,Fr,De,Es)
static struct BurnRomInfo g_bloodsRomDesc[] = {
	{ "bloodshot (europe) (en,fr,de,es).md", 0x200000, 0xf9f2bceb, BRF_PRG },
};

STD_ROM_PICK(g_bloods)
STD_ROM_FN(g_bloods)

struct BurnDriverD BurnDrvMDg_bloods = {
	"g_bloods", NULL, NULL, "1994",
	"Bloodshot (Europe) (En,Fr,De,Es)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bloodsRomInfo, g_bloodsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Blue Almanac (Japan)
static struct BurnRomInfo g_bluealRomDesc[] = {
	{ "blue almanac (japan).md", 0x100000, 0x7222ebb3, BRF_PRG },
};

STD_ROM_PICK(g_blueal)
STD_ROM_FN(g_blueal)

struct BurnDriverD BurnDrvMDg_blueal = {
	"g_blueal", NULL, NULL, "",
	"Blue Almanac (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bluealRomInfo, g_bluealRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Europe) (En,Fr,De,Es,It) (Beta)
static struct BurnRomInfo g_bodycaRomDesc[] = {
	{ "body count (europe) (en,fr,de,es,it) (beta).md", 0x100000, 0xb4ffb6ce, BRF_PRG },
};

STD_ROM_PICK(g_bodyca)
STD_ROM_FN(g_bodyca)

struct BurnDriverD BurnDrvMDg_bodyca = {
	"g_bodyca", "g_bodyc", NULL, "1900",
	"Body Count (Europe) (En,Fr,De,Es,It) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bodycaRomInfo, g_bodycaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Europe) (En,Fr,De,Es,It)
static struct BurnRomInfo g_bodycRomDesc[] = {
	{ "body count (europe) (en,fr,de,es,it).md", 0x100000, 0x3575a030, BRF_PRG },
};

STD_ROM_PICK(g_bodyc)
STD_ROM_FN(g_bodyc)

struct BurnDriverD BurnDrvMDg_bodyc = {
	"g_bodyc", NULL, NULL, "1900",
	"Body Count (Europe) (En,Fr,De,Es,It)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bodycRomInfo, g_bodycRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype - Feb 08, 1994)
static struct BurnRomInfo g_bodycbRomDesc[] = {
	{ "body count (prototype - feb 08, 1994).md", 0xff900, 0xc5fed897, BRF_PRG },
};

STD_ROM_PICK(g_bodycb)
STD_ROM_FN(g_bodycb)

struct BurnDriverD BurnDrvMDg_bodycb = {
	"g_bodycb", "g_bodyc", NULL, "",
	"Body Count (Prototype - Feb 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bodycbRomInfo, g_bodycbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype - Feb 28, 1994 - U)
static struct BurnRomInfo g_bodyccRomDesc[] = {
	{ "body count (prototype - feb 28, 1994 - u).md", 0xff900, 0xc5fed897, BRF_PRG },
};

STD_ROM_PICK(g_bodycc)
STD_ROM_FN(g_bodycc)

struct BurnDriverD BurnDrvMDg_bodycc = {
	"g_bodycc", "g_bodyc", NULL, "",
	"Body Count (Prototype - Feb 28, 1994 - U)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bodyccRomInfo, g_bodyccRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype - Jan 27, 1994)
static struct BurnRomInfo g_bodycdRomDesc[] = {
	{ "body count (prototype - jan 27, 1994).md", 0x100000, 0x66ca4e71, BRF_PRG },
};

STD_ROM_PICK(g_bodycd)
STD_ROM_FN(g_bodycd)

struct BurnDriverD BurnDrvMDg_bodycd = {
	"g_bodycd", "g_bodyc", NULL, "",
	"Body Count (Prototype - Jan 27, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bodycdRomInfo, g_bodycdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype - Mar 03, 1994)
static struct BurnRomInfo g_bodyceRomDesc[] = {
	{ "body count (prototype - mar 03, 1994).md", 0x100000, 0x6abc6e77, BRF_PRG },
};

STD_ROM_PICK(g_bodyce)
STD_ROM_FN(g_bodyce)

struct BurnDriverD BurnDrvMDg_bodyce = {
	"g_bodyce", "g_bodyc", NULL, "",
	"Body Count (Prototype - Mar 03, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bodyceRomInfo, g_bodyceRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype - Mar 08, 1994 - A)
static struct BurnRomInfo g_bodycfRomDesc[] = {
	{ "body count (prototype - mar 08, 1994 - a).md", 0x100000, 0x8965213f, BRF_PRG },
};

STD_ROM_PICK(g_bodycf)
STD_ROM_FN(g_bodycf)

struct BurnDriverD BurnDrvMDg_bodycf = {
	"g_bodycf", "g_bodyc", NULL, "",
	"Body Count (Prototype - Mar 08, 1994 - A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bodycfRomInfo, g_bodycfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype - Mar 08, 1994)
static struct BurnRomInfo g_bodycgRomDesc[] = {
	{ "body count (prototype - mar 08, 1994).md", 0x100000, 0x8965213f, BRF_PRG },
};

STD_ROM_PICK(g_bodycg)
STD_ROM_FN(g_bodycg)

struct BurnDriverD BurnDrvMDg_bodycg = {
	"g_bodycg", "g_bodyc", NULL, "",
	"Body Count (Prototype - Mar 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bodycgRomInfo, g_bodycgRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Body Count (Prototype - Mar 09, 1994)
static struct BurnRomInfo g_bodychRomDesc[] = {
	{ "body count (prototype - mar 09, 1994).md", 0x100000, 0x649607d1, BRF_PRG },
};

STD_ROM_PICK(g_bodych)
STD_ROM_FN(g_bodych)

struct BurnDriverD BurnDrvMDg_bodych = {
	"g_bodych", "g_bodyc", NULL, "",
	"Body Count (Prototype - Mar 09, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bodychRomInfo, g_bodychRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonanza Bros. (Japan, Europe) (Rev A)
static struct BurnRomInfo g_bonanzRomDesc[] = {
	{ "bonanza bros. (japan, europe) (rev a).md", 0x80000, 0xc6aac589, BRF_PRG },
};

STD_ROM_PICK(g_bonanz)
STD_ROM_FN(g_bonanz)

struct BurnDriverD BurnDrvMDg_bonanz = {
	"g_bonanz", NULL, NULL, "1900",
	"Bonanza Bros. (Japan, Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bonanzRomInfo, g_bonanzRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonanza Bros. (Japan, Europe)
static struct BurnRomInfo g_bonan1RomDesc[] = {
	{ "bonanza bros. (japan, europe).md", 0x80000, 0xadf6476c, BRF_PRG },
};

STD_ROM_PICK(g_bonan1)
STD_ROM_FN(g_bonan1)

struct BurnDriverD BurnDrvMDg_bonan1 = {
	"g_bonan1", "g_bonanz", NULL, "1900",
	"Bonanza Bros. (Japan, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bonan1RomInfo, g_bonan1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonanza Bros. (USA, Korea)
static struct BurnRomInfo g_bonan2RomDesc[] = {
	{ "bonanza bros. (usa, korea).md", 0x80000, 0x20d1ad4c, BRF_PRG },
};

STD_ROM_PICK(g_bonan2)
STD_ROM_FN(g_bonan2)

struct BurnDriverD BurnDrvMDg_bonan2 = {
	"g_bonan2", "g_bonanz", NULL, "1900",
	"Bonanza Bros. (USA, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bonan2RomInfo, g_bonan2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (Prototype - Mar 28, 1994)
static struct BurnRomInfo g_bonkraRomDesc[] = {
	{ "bonkers (prototype - mar 28, 1994).md", 0x100000, 0xcd67c588, BRF_PRG },
};

STD_ROM_PICK(g_bonkra)
STD_ROM_FN(g_bonkra)

struct BurnDriverD BurnDrvMDg_bonkra = {
	"g_bonkra", "g_bonkr", NULL, "",
	"Bonkers (Prototype - Mar 28, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bonkraRomInfo, g_bonkraRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (Prototype - May 03, 1994)
static struct BurnRomInfo g_bonkrbRomDesc[] = {
	{ "bonkers (prototype - may 03, 1994).md", 0x100000, 0xe4cd0d61, BRF_PRG },
};

STD_ROM_PICK(g_bonkrb)
STD_ROM_FN(g_bonkrb)

struct BurnDriverD BurnDrvMDg_bonkrb = {
	"g_bonkrb", "g_bonkr", NULL, "",
	"Bonkers (Prototype - May 03, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bonkrbRomInfo, g_bonkrbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (Prototype - Oct 04, 1994)
static struct BurnRomInfo g_bonkrcRomDesc[] = {
	{ "bonkers (prototype - oct 04, 1994).md", 0x100000, 0x913cc834, BRF_PRG },
};

STD_ROM_PICK(g_bonkrc)
STD_ROM_FN(g_bonkrc)

struct BurnDriverD BurnDrvMDg_bonkrc = {
	"g_bonkrc", "g_bonkr", NULL, "",
	"Bonkers (Prototype - Oct 04, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bonkrcRomInfo, g_bonkrcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (Prototype - Oct 25, 1994)
static struct BurnRomInfo g_bonkrdRomDesc[] = {
	{ "bonkers (prototype - oct 25, 1994).md", 0x100000, 0x3e5edc4f, BRF_PRG },
};

STD_ROM_PICK(g_bonkrd)
STD_ROM_FN(g_bonkrd)

struct BurnDriverD BurnDrvMDg_bonkrd = {
	"g_bonkrd", "g_bonkr", NULL, "",
	"Bonkers (Prototype - Oct 25, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bonkrdRomInfo, g_bonkrdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (Prototype - Oct 29, 1994)
static struct BurnRomInfo g_bonkreRomDesc[] = {
	{ "bonkers (prototype - oct 29, 1994).md", 0x100000, 0x7b84793e, BRF_PRG },
};

STD_ROM_PICK(g_bonkre)
STD_ROM_FN(g_bonkre)

struct BurnDriverD BurnDrvMDg_bonkre = {
	"g_bonkre", "g_bonkr", NULL, "",
	"Bonkers (Prototype - Oct 29, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bonkreRomInfo, g_bonkreRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bonkers (USA, Europe)
static struct BurnRomInfo g_bonkrRomDesc[] = {
	{ "bonkers (usa, europe).md", 0x100000, 0xd1e66017, BRF_PRG },
};

STD_ROM_PICK(g_bonkr)
STD_ROM_FN(g_bonkr)

struct BurnDriverD BurnDrvMDg_bonkr = {
	"g_bonkr", NULL, NULL, "1900",
	"Bonkers (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bonkrRomInfo, g_bonkrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Boogerman - A Pick and Flick Adventure (Europe)
static struct BurnRomInfo g_boogerRomDesc[] = {
	{ "boogerman - a pick and flick adventure (europe).md", 0x300000, 0xdbc4340c, BRF_PRG },
};

STD_ROM_PICK(g_booger)
STD_ROM_FN(g_booger)

struct BurnDriverD BurnDrvMDg_booger = {
	"g_booger", NULL, NULL, "1900",
	"Boogerman - A Pick and Flick Adventure (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_boogerRomInfo, g_boogerRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Boogerman - A Pick and Flick Adventure (USA)
static struct BurnRomInfo g_booge1RomDesc[] = {
	{ "boogerman - a pick and flick adventure (usa).md", 0x300000, 0x1a7a2bec, BRF_PRG },
};

STD_ROM_PICK(g_booge1)
STD_ROM_FN(g_booge1)

struct BurnDriverD BurnDrvMDg_booge1 = {
	"g_booge1", "g_booger", NULL, "1900",
	"Boogerman - A Pick and Flick Adventure (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_booge1RomInfo, g_booge1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Boogie Woogie Bowling (Japan)
static struct BurnRomInfo g_boogieRomDesc[] = {
	{ "boogie woogie bowling (japan).md", 0x80000, 0xccf52828, BRF_PRG },
};

STD_ROM_PICK(g_boogie)
STD_ROM_FN(g_boogie)

struct BurnDriverD BurnDrvMDg_boogie = {
	"g_boogie", "g_champ1", NULL, "1900",
	"Boogie Woogie Bowling (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_boogieRomInfo, g_boogieRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Boxing Legends of the Ring (USA)
static struct BurnRomInfo g_boxingRomDesc[] = {
	{ "boxing legends of the ring (usa).md", 0x100000, 0x00f225ac, BRF_PRG },
};

STD_ROM_PICK(g_boxing)
STD_ROM_FN(g_boxing)

struct BurnDriverD BurnDrvMDg_boxing = {
	"g_boxing", NULL, NULL, "1900",
	"Boxing Legends of the Ring (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_boxingRomInfo, g_boxingRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bram Stoker's Dracula (Europe)
static struct BurnRomInfo g_bramstRomDesc[] = {
	{ "bram stoker's dracula (europe).md", 0x100000, 0x9ba5a063, BRF_PRG },
};

STD_ROM_PICK(g_bramst)
STD_ROM_FN(g_bramst)

struct BurnDriverD BurnDrvMDg_bramst = {
	"g_bramst", NULL, NULL, "1994",
	"Bram Stoker's Dracula (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bramstRomInfo, g_bramstRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bram Stoker's Dracula (USA)
static struct BurnRomInfo g_brams1RomDesc[] = {
	{ "bram stoker's dracula (usa).md", 0x100000, 0x077084a6, BRF_PRG },
};

STD_ROM_PICK(g_brams1)
STD_ROM_FN(g_brams1)

struct BurnDriverD BurnDrvMDg_brams1 = {
	"g_brams1", "g_bramst", NULL, "1994",
	"Bram Stoker's Dracula (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_brams1RomInfo, g_brams1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brett Hull Hockey '95 (USA)
static struct BurnRomInfo g_bretthRomDesc[] = {
	{ "brett hull hockey '95 (usa).md", 0x200000, 0xf7775a09, BRF_PRG },
};

STD_ROM_PICK(g_bretth)
STD_ROM_FN(g_bretth)

struct BurnDriverD BurnDrvMDg_bretth = {
	"g_bretth", NULL, NULL, "1900",
	"Brett Hull Hockey '95 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bretthRomInfo, g_bretthRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brian Lara Cricket (Europe) (June 1995)
static struct BurnRomInfo g_brianlRomDesc[] = {
	{ "brian lara cricket (europe) (june 1995).md", 0x100000, 0x408cf5c3, BRF_PRG },
};

STD_ROM_PICK(g_brianl)
STD_ROM_FN(g_brianl)

struct BurnDriverD BurnDrvMDg_brianl = {
	"g_brianl", NULL, NULL, "1900",
	"Brian Lara Cricket (Europe) (June 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_brianlRomInfo, g_brianlRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brian Lara Cricket (Europe) (March 1995)
static struct BurnRomInfo g_brian1RomDesc[] = {
	{ "brian lara cricket (europe) (march 1995).md", 0x100000, 0x90f5c2b7, BRF_PRG },
};

STD_ROM_PICK(g_brian1)
STD_ROM_FN(g_brian1)

struct BurnDriverD BurnDrvMDg_brian1 = {
	"g_brian1", "g_brianl", NULL, "1900",
	"Brian Lara Cricket (Europe) (March 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_brian1RomInfo, g_brian1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brian Lara Cricket 96 (Europe) (April 1996)
static struct BurnRomInfo g_bri96RomDesc[] = {
	{ "brian lara cricket 96 (europe) (april 1996).md", 0x100000, 0xfe52f7e1, BRF_PRG },
};

STD_ROM_PICK(g_bri96)
STD_ROM_FN(g_bri96)

struct BurnDriverD BurnDrvMDg_bri96 = {
	"g_bri96", NULL, NULL, "1900",
	"Brian Lara Cricket 96 (Europe) (April 1996)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bri96RomInfo, g_bri96RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brian Lara Cricket 96 (Europe) (March 1996)
static struct BurnRomInfo g_bri96aRomDesc[] = {
	{ "brian lara cricket 96 (europe) (march 1996).md", 0x100000, 0xfa3024af, BRF_PRG },
};

STD_ROM_PICK(g_bri96a)
STD_ROM_FN(g_bri96a)

struct BurnDriverD BurnDrvMDg_bri96a = {
	"g_bri96a", "g_bri96", NULL, "1900",
	"Brian Lara Cricket 96 (Europe) (March 1996)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bri96aRomInfo, g_bri96aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brutal - Paws of Fury (Europe)
static struct BurnRomInfo g_brutalRomDesc[] = {
	{ "brutal - paws of fury (europe).md", 0x200000, 0x7e9a8d32, BRF_PRG },
};

STD_ROM_PICK(g_brutal)
STD_ROM_FN(g_brutal)

struct BurnDriverD BurnDrvMDg_brutal = {
	"g_brutal", NULL, NULL, "1900",
	"Brutal - Paws of Fury (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_brutalRomInfo, g_brutalRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Brutal - Paws of Fury (USA)
static struct BurnRomInfo g_bruta1RomDesc[] = {
	{ "brutal - paws of fury (usa).md", 0x200000, 0x98d502cd, BRF_PRG },
};

STD_ROM_PICK(g_bruta1)
STD_ROM_FN(g_bruta1)

struct BurnDriverD BurnDrvMDg_bruta1 = {
	"g_bruta1", "g_brutal", NULL, "1900",
	"Brutal - Paws of Fury (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bruta1RomInfo, g_bruta1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubba'n'Stix (Europe) (Beta)
static struct BurnRomInfo g_bubbabRomDesc[] = {
	{ "bubba'n'stix (europe) (beta).md", 0x100000, 0xa8731cb4, BRF_PRG },
};

STD_ROM_PICK(g_bubbab)
STD_ROM_FN(g_bubbab)

struct BurnDriverD BurnDrvMDg_bubbab = {
	"g_bubbab", "g_bubba", NULL, "1900",
	"Bubba'n'Stix (Europe) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bubbabRomInfo, g_bubbabRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubba'n'Stix (Europe)
static struct BurnRomInfo g_bubbaRomDesc[] = {
	{ "bubba'n'stix (europe).md", 0x100000, 0xb467432e, BRF_PRG },
};

STD_ROM_PICK(g_bubba)
STD_ROM_FN(g_bubba)

struct BurnDriverD BurnDrvMDg_bubba = {
	"g_bubba", NULL, NULL, "1900",
	"Bubba'n'Stix (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bubbaRomInfo, g_bubbaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubba'n'Stix - A Strategy Adventure (USA)
static struct BurnRomInfo g_bubbauRomDesc[] = {
	{ "bubba'n'stix - a strategy adventure (usa).md", 0x100000, 0xd45cb46f, BRF_PRG },
};

STD_ROM_PICK(g_bubbau)
STD_ROM_FN(g_bubbau)

struct BurnDriverD BurnDrvMDg_bubbau = {
	"g_bubbau", "g_bubba", NULL, "1900",
	"Bubba'n'Stix - A Strategy Adventure (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bubbauRomInfo, g_bubbauRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubble and Squeak (Europe)
static struct BurnRomInfo g_bubbleRomDesc[] = {
	{ "bubble and squeak (europe).md", 0x80000, 0x86151bf1, BRF_PRG },
};

STD_ROM_PICK(g_bubble)
STD_ROM_FN(g_bubble)

struct BurnDriverD BurnDrvMDg_bubble = {
	"g_bubble", NULL, NULL, "",
	"Bubble and Squeak (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bubbleRomInfo, g_bubbleRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubble and Squeak (USA)
static struct BurnRomInfo g_bubbl1RomDesc[] = {
	{ "bubble and squeak (usa).md", 0x80000, 0x28c4a006, BRF_PRG },
};

STD_ROM_PICK(g_bubbl1)
STD_ROM_FN(g_bubbl1)

struct BurnDriverD BurnDrvMDg_bubbl1 = {
	"g_bubbl1", "g_bubble", NULL, "1900",
	"Bubble and Squeak (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bubbl1RomInfo, g_bubbl1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubsy II (USA, Europe)
static struct BurnRomInfo g_bubsy2RomDesc[] = {
	{ "bubsy ii (usa, europe).md", 0x200000, 0xf8beff56, BRF_PRG },
};

STD_ROM_PICK(g_bubsy2)
STD_ROM_FN(g_bubsy2)

struct BurnDriver BurnDrvMDg_bubsy2 = {
	"g_bubsy2", NULL, NULL, "1900",
	"Bubsy II (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bubsy2RomInfo, g_bubsy2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bubsy in Claws Encounters of the Furred Kind (USA, Europe)
static struct BurnRomInfo g_bubsyRomDesc[] = {
	{ "bubsy in claws encounters of the furred kind (usa, europe).md", 0x200000, 0x3e30d365, BRF_PRG },
};

STD_ROM_PICK(g_bubsy)
STD_ROM_FN(g_bubsy)

struct BurnDriver BurnDrvMDg_bubsy = {
	"g_bubsy", NULL, NULL, "1900",
	"Bubsy in Claws Encounters of the Furred Kind (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bubsyRomInfo, g_bubsyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Buck Rogers - Countdown to Doomsday (USA, Europe)
static struct BurnRomInfo g_buckroRomDesc[] = {
	{ "buck rogers - countdown to doomsday (usa, europe).md", 0x100000, 0x44e3bfff, BRF_PRG },
};

STD_ROM_PICK(g_buckro)
STD_ROM_FN(g_buckro)

struct BurnDriver BurnDrvMDg_buckro = {
	"g_buckro", NULL, NULL, "1900",
	"Buck Rogers - Countdown to Doomsday (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_buckroRomInfo, g_buckroRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Budokan - The Martial Spirit (Europe)
static struct BurnRomInfo g_budokaRomDesc[] = {
	{ "budokan - the martial spirit (europe).md", 0x80000, 0x97add5bd, BRF_PRG },
};

STD_ROM_PICK(g_budoka)
STD_ROM_FN(g_budoka)

struct BurnDriverD BurnDrvMDg_budoka = {
	"g_budoka", NULL, NULL, "1900",
	"Budokan - The Martial Spirit (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_budokaRomInfo, g_budokaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Budokan - The Martial Spirit (USA)
static struct BurnRomInfo g_budok1RomDesc[] = {
	{ "budokan - the martial spirit (usa).md", 0x80000, 0xacd9f5fc, BRF_PRG },
};

STD_ROM_PICK(g_budok1)
STD_ROM_FN(g_budok1)

struct BurnDriverD BurnDrvMDg_budok1 = {
	"g_budok1", "g_budoka", NULL, "1900",
	"Budokan - The Martial Spirit (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_budok1RomInfo, g_budok1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bug's Life, A (Unl) [!]
static struct BurnRomInfo g_bugsliRomDesc[] = {
	{ "bug's life, a (unl) [!].md", 0x100000, 0x10458e09, BRF_PRG },
};

STD_ROM_PICK(g_bugsli)
STD_ROM_FN(g_bugsli)

struct BurnDriverD BurnDrvMDg_bugsli = {
	"g_bugsli", NULL, NULL, "",
	"Bug's Life, A (Unl) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bugsliRomInfo, g_bugsliRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bugs Bunny in Double Trouble (USA)
static struct BurnRomInfo g_bugsbuRomDesc[] = {
	{ "bugs bunny in double trouble (usa).md", 0x200000, 0x365305a2, BRF_PRG },
};

STD_ROM_PICK(g_bugsbu)
STD_ROM_FN(g_bugsbu)

struct BurnDriverD BurnDrvMDg_bugsbu = {
	"g_bugsbu", NULL, NULL, "1900",
	"Bugs Bunny in Double Trouble (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bugsbuRomInfo, g_bugsbuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bulls versus Blazers and the NBA Playoffs (USA, Europe)
static struct BurnRomInfo g_bullsvRomDesc[] = {
	{ "bulls versus blazers and the nba playoffs (usa, europe).md", 0x100000, 0xd4e4b4e8, BRF_PRG },
};

STD_ROM_PICK(g_bullsv)
STD_ROM_FN(g_bullsv)

struct BurnDriverD BurnDrvMDg_bullsv = {
	"g_bullsv", NULL, NULL, "1993",
	"Bulls versus Blazers and the NBA Playoffs (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bullsvRomInfo, g_bullsvRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Bulls Vs Lakers and the NBA Playoffs (USA, Europe)
static struct BurnRomInfo g_bulllaRomDesc[] = {
	{ "bulls vs lakers and the nba playoffs (usa, europe).md", 0x100000, 0xe56023a0, BRF_PRG },
};

STD_ROM_PICK(g_bullla)
STD_ROM_FN(g_bullla)

struct BurnDriverD BurnDrvMDg_bullla = {
	"g_bullla", NULL, NULL, "1991",
	"Bulls Vs Lakers and the NBA Playoffs (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_bulllaRomInfo, g_bulllaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Burning Force (Europe)
static struct BurnRomInfo g_burninRomDesc[] = {
	{ "burning force (europe).md", 0x80000, 0x776ff6ff, BRF_PRG },
};

STD_ROM_PICK(g_burnin)
STD_ROM_FN(g_burnin)

struct BurnDriverD BurnDrvMDg_burnin = {
	"g_burnin", NULL, NULL, "1900",
	"Burning Force (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_burninRomInfo, g_burninRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Burning Force (Japan)
static struct BurnRomInfo g_burni1RomDesc[] = {
	{ "burning force (japan).md", 0x80000, 0x0c1deb47, BRF_PRG },
};

STD_ROM_PICK(g_burni1)
STD_ROM_FN(g_burni1)

struct BurnDriverD BurnDrvMDg_burni1 = {
	"g_burni1", "g_burnin", NULL, "1900",
	"Burning Force (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_burni1RomInfo, g_burni1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Burning Force (USA)
static struct BurnRomInfo g_burni2RomDesc[] = {
	{ "burning force (usa).md", 0x80000, 0xbdc8f02c, BRF_PRG },
};

STD_ROM_PICK(g_burni2)
STD_ROM_FN(g_burni2)

struct BurnDriverD BurnDrvMDg_burni2 = {
	"g_burni2", "g_burnin", NULL, "1900",
	"Burning Force (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_burni2RomInfo, g_burni2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cadash (USA, Asia)
static struct BurnRomInfo g_cadashRomDesc[] = {
	{ "cadash (usa, asia).md", 0x80000, 0x13bdf374, BRF_PRG },
};

STD_ROM_PICK(g_cadash)
STD_ROM_FN(g_cadash)

struct BurnDriverD BurnDrvMDg_cadash = {
	"g_cadash", NULL, NULL, "1900",
	"Cadash (USA, Asia)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cadashRomInfo, g_cadashRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Caesar no Yabou (Japan)
static struct BurnRomInfo g_caesarRomDesc[] = {
	{ "caesar no yabou (japan).md", 0x100000, 0x69796e93, BRF_PRG },
};

STD_ROM_PICK(g_caesar)
STD_ROM_FN(g_caesar)

struct BurnDriverD BurnDrvMDg_caesar = {
	"g_caesar", NULL, NULL, "1991",
	"Caesar no Yabou (Japan)\0", NULL, "Micronet", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_caesarRomInfo, g_caesarRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Caesar no Yabou II (Japan)
static struct BurnRomInfo g_caes2RomDesc[] = {
	{ "caesar no yabou ii (japan).md", 0x100000, 0x4f327b3a, BRF_PRG },
};

STD_ROM_PICK(g_caes2)
STD_ROM_FN(g_caes2)

struct BurnDriver BurnDrvMDg_caes2 = {
	"g_caes2", NULL, NULL, "1992",
	"Caesar no Yabou II (Japan)\0", NULL, "Micronet", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_caes2RomInfo, g_caes2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x2000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Caesars Palace (USA)
static struct BurnRomInfo g_caesplRomDesc[] = {
	{ "caesars palace (usa).md", 0x80000, 0x8fdaa9bb, BRF_PRG },
};

STD_ROM_PICK(g_caespl)
STD_ROM_FN(g_caespl)

struct BurnDriverD BurnDrvMDg_caespl = {
	"g_caespl", NULL, NULL, "1900",
	"Caesars Palace (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_caesplRomInfo, g_caesplRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cal Ripken Jr. Baseball (USA)
static struct BurnRomInfo g_calripRomDesc[] = {
	{ "cal ripken jr. baseball (usa).md", 0x100000, 0x9b1c96c0, BRF_PRG },
};

STD_ROM_PICK(g_calrip)
STD_ROM_FN(g_calrip)

struct BurnDriverD BurnDrvMDg_calrip = {
	"g_calrip", NULL, NULL, "1900",
	"Cal Ripken Jr. Baseball (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_calripRomInfo, g_calripRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Caliber .50 (USA)
static struct BurnRomInfo g_calibeRomDesc[] = {
	{ "caliber .50 (usa).md", 0x100000, 0x44f4fa05, BRF_PRG },
};

STD_ROM_PICK(g_calibe)
STD_ROM_FN(g_calibe)

struct BurnDriverD BurnDrvMDg_calibe = {
	"g_calibe", NULL, NULL, "1900",
	"Caliber .50 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_calibeRomInfo, g_calibeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// California Games (USA, Europe)
static struct BurnRomInfo g_califoRomDesc[] = {
	{ "california games (usa, europe).md", 0x80000, 0x43b1b672, BRF_PRG },
};

STD_ROM_PICK(g_califo)
STD_ROM_FN(g_califo)

struct BurnDriver BurnDrvMDg_califo = {
	"g_califo", NULL, NULL, "1900",
	"California Games (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_califoRomInfo, g_califoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cannon Fodder (Europe)
static struct BurnRomInfo g_cannonRomDesc[] = {
	{ "cannon fodder (europe).md", 0x180000, 0xad217654, BRF_PRG },
};

STD_ROM_PICK(g_cannon)
STD_ROM_FN(g_cannon)

struct BurnDriverD BurnDrvMDg_cannon = {
	"g_cannon", NULL, NULL, "1900",
	"Cannon Fodder (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cannonRomInfo, g_cannonRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Captain America and the Avengers (Europe)
static struct BurnRomInfo g_captaiRomDesc[] = {
	{ "captain america and the avengers (europe).md", 0x100000, 0x43225612, BRF_PRG },
};

STD_ROM_PICK(g_captai)
STD_ROM_FN(g_captai)

struct BurnDriverD BurnDrvMDg_captai = {
	"g_captai", NULL, NULL, "1900",
	"Captain America and the Avengers (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_captaiRomInfo, g_captaiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Captain America and the Avengers (USA) (Beta)
static struct BurnRomInfo g_capta1RomDesc[] = {
	{ "captain america and the avengers (usa) (beta).md", 0x100000, 0xbaac59c0, BRF_PRG },
};

STD_ROM_PICK(g_capta1)
STD_ROM_FN(g_capta1)

struct BurnDriverD BurnDrvMDg_capta1 = {
	"g_capta1", "g_captai", NULL, "1900",
	"Captain America and the Avengers (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_capta1RomInfo, g_capta1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Captain America and the Avengers (USA)
static struct BurnRomInfo g_capta2RomDesc[] = {
	{ "captain america and the avengers (usa).md", 0x100000, 0xe0639ca2, BRF_PRG },
};

STD_ROM_PICK(g_capta2)
STD_ROM_FN(g_capta2)

struct BurnDriverD BurnDrvMDg_capta2 = {
	"g_capta2", "g_captai", NULL, "1900",
	"Captain America and the Avengers (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_capta2RomInfo, g_capta2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Captain Planet and the Planeteers (Europe)
static struct BurnRomInfo g_captplRomDesc[] = {
	{ "captain planet and the planeteers (europe).md", 0x80000, 0x7672efa5, BRF_PRG },
};

STD_ROM_PICK(g_captpl)
STD_ROM_FN(g_captpl)

struct BurnDriverD BurnDrvMDg_captpl = {
	"g_captpl", NULL, NULL, "1900",
	"Captain Planet and the Planeteers (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_captplRomInfo, g_captplRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Captain Planet and the Planeteers (USA)
static struct BurnRomInfo g_captp1RomDesc[] = {
	{ "captain planet and the planeteers (usa).md", 0x80000, 0xbf2cbd3a, BRF_PRG },
};

STD_ROM_PICK(g_captp1)
STD_ROM_FN(g_captp1)

struct BurnDriverD BurnDrvMDg_captp1 = {
	"g_captp1", "g_captpl", NULL, "1900",
	"Captain Planet and the Planeteers (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_captp1RomInfo, g_captp1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Castle of Illusion - Fushigi no Oshiro Daibouken (Japan)
static struct BurnRomInfo g_castljRomDesc[] = {
	{ "castle of illusion - fushigi no oshiro daibouken (japan).md", 0x80000, 0xce8333c6, BRF_PRG },
};

STD_ROM_PICK(g_castlj)
STD_ROM_FN(g_castlj)

struct BurnDriver BurnDrvMDg_castlj = {
	"g_castlj", "g_castl", NULL, "1990",
	"Castle of Illusion - Fushigi no Oshiro Daibouken (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_castljRomInfo, g_castljRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Castle of Illusion Starring Mickey Mouse (USA, Europe)
static struct BurnRomInfo g_castlRomDesc[] = {
	{ "castle of illusion starring mickey mouse (usa, europe).md", 0x80000, 0xba4e9fd0, BRF_PRG },
};

STD_ROM_PICK(g_castl)
STD_ROM_FN(g_castl)

struct BurnDriver BurnDrvMDg_castl = {
	"g_castl", NULL, NULL, "1990",
	"Castle of Illusion Starring Mickey Mouse (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_castlRomInfo, g_castlRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Castlevania - Bloodlines (USA)
static struct BurnRomInfo g_cvaniaRomDesc[] = {
	{ "castlevania - bloodlines (usa).md", 0x100000, 0xfb1ea6df, BRF_PRG },
};

STD_ROM_PICK(g_cvania)
STD_ROM_FN(g_cvania)

struct BurnDriverD BurnDrvMDg_cvania = {
	"g_cvania", NULL, NULL, "1994",
	"Castlevania - Bloodlines (USA)\0", NULL, "Konami", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cvaniaRomInfo, g_cvaniaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Castlevania - The New Generation (Europe) (Beta)
static struct BurnRomInfo g_cvani1RomDesc[] = {
	{ "castlevania - the new generation (europe) (beta).md", 0x100000, 0x84cd103a, BRF_PRG },
};

STD_ROM_PICK(g_cvani1)
STD_ROM_FN(g_cvani1)

struct BurnDriverD BurnDrvMDg_cvani1 = {
	"g_cvani1", "g_cvania", NULL, "1994",
	"Castlevania - The New Generation (Europe) (Beta)\0", NULL, "Konami", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cvani1RomInfo, g_cvani1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Castlevania - The New Generation (Europe)
static struct BurnRomInfo g_cvani2RomDesc[] = {
	{ "castlevania - the new generation (europe).md", 0x100000, 0x4dd4e4a5, BRF_PRG },
};

STD_ROM_PICK(g_cvani2)
STD_ROM_FN(g_cvani2)

struct BurnDriverD BurnDrvMDg_cvani2 = {
	"g_cvani2", "g_cvania", NULL, "1994",
	"Castlevania - The New Generation (Europe)\0", NULL, "Konami", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cvani2RomInfo, g_cvani2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Centurion - Defender of Rome (USA, Europe)
static struct BurnRomInfo g_centurRomDesc[] = {
	{ "centurion - defender of rome (usa, europe).md", 0xc0000, 0x21283b14, BRF_PRG },
};

STD_ROM_PICK(g_centur)
STD_ROM_FN(g_centur)

struct BurnDriverD BurnDrvMDg_centur = {
	"g_centur", NULL, NULL, "1900",
	"Centurion - Defender of Rome (USA, Europe)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_centurRomInfo, g_centurRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chakan (USA, Europe)
static struct BurnRomInfo g_chakanRomDesc[] = {
	{ "chakan (usa, europe).md", 0x100000, 0x046a48de, BRF_PRG },
};

STD_ROM_PICK(g_chakan)
STD_ROM_FN(g_chakan)

struct BurnDriverD BurnDrvMDg_chakan = {
	"g_chakan", NULL, NULL, "1900",
	"Chakan (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chakanRomInfo, g_chakanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chameleon Kid (Japan)
static struct BurnRomInfo g_chamelRomDesc[] = {
	{ "chameleon kid (japan).md", 0x100000, 0x50217c80, BRF_PRG },
};

STD_ROM_PICK(g_chamel)
STD_ROM_FN(g_chamel)

struct BurnDriverD BurnDrvMDg_chamel = {
	"g_chamel", "g_kidcha", NULL, "1994",
	"Chameleon Kid (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chamelRomInfo, g_chamelRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Champions World Class Soccer (World) (En,Fr,De,Es)
static struct BurnRomInfo g_champiRomDesc[] = {
	{ "champions world class soccer (world) (en,fr,de,es).md", 0x100000, 0x883e33db, BRF_PRG },
};

STD_ROM_PICK(g_champi)
STD_ROM_FN(g_champi)

struct BurnDriverD BurnDrvMDg_champi = {
	"g_champi", NULL, NULL, "1900",
	"Champions World Class Soccer (World) (En,Fr,De,Es)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_champiRomInfo, g_champiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Championship Bowling (USA)
static struct BurnRomInfo g_champ1RomDesc[] = {
	{ "championship bowling (usa).md", 0x80000, 0x1bf92520, BRF_PRG },
};

STD_ROM_PICK(g_champ1)
STD_ROM_FN(g_champ1)

struct BurnDriverD BurnDrvMDg_champ1 = {
	"g_champ1", NULL, NULL, "1900",
	"Championship Bowling (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_champ1RomInfo, g_champ1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Championship Pool (USA)
static struct BurnRomInfo g_champlRomDesc[] = {
	{ "championship pool (usa).md", 0x100000, 0x253512cf, BRF_PRG },
};

STD_ROM_PICK(g_champl)
STD_ROM_FN(g_champl)

struct BurnDriverD BurnDrvMDg_champl = {
	"g_champl", NULL, NULL, "1900",
	"Championship Pool (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_champlRomInfo, g_champlRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Championship Pro-Am (USA)
static struct BurnRomInfo g_cpamRomDesc[] = {
	{ "championship pro-am (usa).md", 0x40000, 0xb496de28, BRF_PRG },
};

STD_ROM_PICK(g_cpam)
STD_ROM_FN(g_cpam)

struct BurnDriverD BurnDrvMDg_cpam = {
	"g_cpam", NULL, NULL, "",
	"Championship Pro-Am (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cpamRomInfo, g_cpamRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chao Ji Da Fu Weng (China) (Unl)
static struct BurnRomInfo g_chaojiRomDesc[] = {
	{ "chao ji da fu weng (china) (unl).md", 0x100000, 0x2e2ea687, BRF_PRG },
};

STD_ROM_PICK(g_chaoji)
STD_ROM_FN(g_chaoji)

struct BurnDriverD BurnDrvMDg_chaoji = {
	"g_chaoji", NULL, NULL, "",
	"Chao Ji Da Fu Weng (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chaojiRomInfo, g_chaojiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chaos Engine 2, The (Europe) (Proto)
static struct BurnRomInfo g_chao2pRomDesc[] = {
	{ "chaos engine 2, the (europe) (proto).md", 0x100000, 0x3fb045c2, BRF_PRG },
};

STD_ROM_PICK(g_chao2p)
STD_ROM_FN(g_chao2p)

struct BurnDriverD BurnDrvMDg_chao2p = {
	"g_chao2p", NULL, NULL, "1900",
	"Chaos Engine 2, The (Europe) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chao2pRomInfo, g_chao2pRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chaos Engine, The (Europe)
static struct BurnRomInfo g_chaoseRomDesc[] = {
	{ "chaos engine, the (europe).md", 0x180000, 0xbd9eecf4, BRF_PRG },
};

STD_ROM_PICK(g_chaose)
STD_ROM_FN(g_chaose)

struct BurnDriverD BurnDrvMDg_chaose = {
	"g_chaose", NULL, NULL, "1900",
	"Chaos Engine, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chaoseRomInfo, g_chaoseRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chase H.Q. II (USA)
static struct BurnRomInfo g_chasehRomDesc[] = {
	{ "chase h.q. ii (usa).md", 0x80000, 0xf39e4bf2, BRF_PRG },
};

STD_ROM_PICK(g_chaseh)
STD_ROM_FN(g_chaseh)

struct BurnDriverD BurnDrvMDg_chaseh = {
	"g_chaseh", NULL, NULL, "1900",
	"Chase H.Q. II (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chasehRomInfo, g_chasehRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chavez II (USA)
static struct BurnRomInfo g_chavezRomDesc[] = {
	{ "chavez ii (usa).md", 0x100000, 0x5bc0dbb8, BRF_PRG },
};

STD_ROM_PICK(g_chavez)
STD_ROM_FN(g_chavez)

struct BurnDriverD BurnDrvMDg_chavez = {
	"g_chavez", "g_boxing", NULL, "1900",
	"Chavez II (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chavezRomInfo, g_chavezRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cheese Cat-Astrophe Starring Speedy Gonzales (Europe)
static struct BurnRomInfo g_cheeseRomDesc[] = {
	{ "cheese cat-astrophe starring speedy gonzales (europe).md", 0x200000, 0xff634b28, BRF_PRG },
};

STD_ROM_PICK(g_cheese)
STD_ROM_FN(g_cheese)

struct BurnDriverD BurnDrvMDg_cheese = {
	"g_cheese", NULL, NULL, "1900",
	"Cheese Cat-Astrophe Starring Speedy Gonzales (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cheeseRomInfo, g_cheeseRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chelnov (Japan)
static struct BurnRomInfo g_chelnoRomDesc[] = {
	{ "chelnov (japan).md", 0x100000, 0xb2fe74d8, BRF_PRG },
};

STD_ROM_PICK(g_chelno)
STD_ROM_FN(g_chelno)

struct BurnDriver BurnDrvMDg_chelno = {
	"g_chelno", NULL, NULL, "1992",
	"Chelnov (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_VERSHOOT, 0,
	NULL, g_chelnoRomInfo, g_chelnoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chess (Unl) [!]
static struct BurnRomInfo g_chessuRomDesc[] = {
	{ "chess (unl) [!].md", 0x80000, 0x47380edd, BRF_PRG },
};

STD_ROM_PICK(g_chessu)
STD_ROM_FN(g_chessu)

struct BurnDriverD BurnDrvMDg_chessu = {
	"g_chessu", NULL, NULL, "",
	"Chess (Unl) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chessuRomInfo, g_chessuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chester Cheetah - Too Cool to Fool (USA)
static struct BurnRomInfo g_chesteRomDesc[] = {
	{ "chester cheetah - too cool to fool (usa).md", 0x100000, 0x250e3ec3, BRF_PRG },
};

STD_ROM_PICK(g_cheste)
STD_ROM_FN(g_cheste)

struct BurnDriverD BurnDrvMDg_cheste = {
	"g_cheste", NULL, NULL, "1900",
	"Chester Cheetah - Too Cool to Fool (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chesteRomInfo, g_chesteRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chester Cheetah - Wild Wild Quest (USA)
static struct BurnRomInfo g_chestwRomDesc[] = {
	{ "chester cheetah - wild wild quest (usa).md", 0x100000, 0xb97b735d, BRF_PRG },
};

STD_ROM_PICK(g_chestw)
STD_ROM_FN(g_chestw)

struct BurnDriverD BurnDrvMDg_chestw = {
	"g_chestw", NULL, NULL, "1900",
	"Chester Cheetah - Wild Wild Quest (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chestwRomInfo, g_chestwRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chi Chi's Pro Challenge Golf (USA)
static struct BurnRomInfo g_chichiRomDesc[] = {
	{ "chi chi's pro challenge golf (usa).md", 0x100000, 0x9c3973a4, BRF_PRG },
};

STD_ROM_PICK(g_chichi)
STD_ROM_FN(g_chichi)

struct BurnDriverD BurnDrvMDg_chichi = {
	"g_chichi", NULL, NULL, "1900",
	"Chi Chi's Pro Challenge Golf (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chichiRomInfo, g_chichiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chibi Maruko-chan - Wakuwaku Shopping (Japan)
static struct BurnRomInfo g_chibimRomDesc[] = {
	{ "chibi maruko-chan - wakuwaku shopping (japan).md", 0x80000, 0x91a144b8, BRF_PRG },
};

STD_ROM_PICK(g_chibim)
STD_ROM_FN(g_chibim)

struct BurnDriverD BurnDrvMDg_chibim = {
	"g_chibim", NULL, NULL, "1900",
	"Chibi Maruko-chan - Wakuwaku Shopping (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chibimRomInfo, g_chibimRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chiki Chiki Boys (Japan, Korea)
static struct BurnRomInfo g_chikijRomDesc[] = {
	{ "chiki chiki boys (japan, korea).md", 0x100000, 0x06918c17, BRF_PRG },
};

STD_ROM_PICK(g_chikij)
STD_ROM_FN(g_chikij)

struct BurnDriverD BurnDrvMDg_chikij = {
	"g_chikij", "g_chiki", NULL, "1900",
	"Chiki Chiki Boys (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chikijRomInfo, g_chikijRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chiki Chiki Boys (USA, Europe)
static struct BurnRomInfo g_chikiRomDesc[] = {
	{ "chiki chiki boys (usa, europe).md", 0x100000, 0x813a7d62, BRF_PRG },
};

STD_ROM_PICK(g_chiki)
STD_ROM_FN(g_chiki)

struct BurnDriverD BurnDrvMDg_chiki = {
	"g_chiki", NULL, NULL, "1900",
	"Chiki Chiki Boys (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chikiRomInfo, g_chikiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chinese Chess (Unl)
static struct BurnRomInfo g_chinesRomDesc[] = {
	{ "chinese chess (unl).md", 0x80000, 0x475215a0, BRF_PRG },
};

STD_ROM_PICK(g_chines)
STD_ROM_FN(g_chines)

struct BurnDriverD BurnDrvMDg_chines = {
	"g_chines", NULL, NULL, "",
	"Chinese Chess (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chinesRomInfo, g_chinesRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chinese Fighter III (Unl) (bootleg)
static struct BurnRomInfo g_chinfbRomDesc[] = {
	{ "chinese fighter iii (unl) (bootleg).md", 0x200000, 0x6f98247d, BRF_PRG },
};

STD_ROM_PICK(g_chinfb)
STD_ROM_FN(g_chinfb)

struct BurnDriverD BurnDrvMDg_chinfb = {
	"g_chinfb", "g_chinf", NULL, "",
	"Chinese Fighter III (Unl) (bootleg)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chinfbRomInfo, g_chinfbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chinese Fighter III (Unl)
static struct BurnRomInfo g_chinfRomDesc[] = {
	{ "chinese fighter iii (unl).md", 0x200000, 0xe833bc6e, BRF_PRG },
};

STD_ROM_PICK(g_chinf)
STD_ROM_FN(g_chinf)

struct BurnDriverD BurnDrvMDg_chinf = {
	"g_chinf", NULL, NULL, "",
	"Chinese Fighter III (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chinfRomInfo, g_chinfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chou Kyuukai Miracle Nine (Japan)
static struct BurnRomInfo g_choukyRomDesc[] = {
	{ "chou kyuukai miracle nine (japan).md", 0x200000, 0x6d8c2206, BRF_PRG },
};

STD_ROM_PICK(g_chouky)
STD_ROM_FN(g_chouky)

struct BurnDriver BurnDrvMDg_chouky = {
	"g_chouky", NULL, NULL, "1900",
	"Chou Kyuukai Miracle Nine (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_choukyRomInfo, g_choukyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chou Touryuu Retsuden Dino Land (Japan)
static struct BurnRomInfo g_choutoRomDesc[] = {
	{ "chou touryuu retsuden dino land (japan).md", 0x80000, 0x81f939de, BRF_PRG },
};

STD_ROM_PICK(g_chouto)
STD_ROM_FN(g_chouto)

struct BurnDriverD BurnDrvMDg_chouto = {
	"g_chouto", NULL, NULL, "1900",
	"Chou Touryuu Retsuden Dino Land (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_choutoRomInfo, g_choutoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock (Europe)
static struct BurnRomInfo g_chuckrRomDesc[] = {
	{ "chuck rock (europe).md", 0x100000, 0x7cd40bea, BRF_PRG },
};

STD_ROM_PICK(g_chuckr)
STD_ROM_FN(g_chuckr)

struct BurnDriverD BurnDrvMDg_chuckr = {
	"g_chuckr", NULL, NULL, "1900",
	"Chuck Rock (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chuckrRomInfo, g_chuckrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock (USA)
static struct BurnRomInfo g_chuck1RomDesc[] = {
	{ "chuck rock (usa).md", 0x100000, 0xf8ac454a, BRF_PRG },
};

STD_ROM_PICK(g_chuck1)
STD_ROM_FN(g_chuck1)

struct BurnDriverD BurnDrvMDg_chuck1 = {
	"g_chuck1", "g_chuckr", NULL, "1900",
	"Chuck Rock (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chuck1RomInfo, g_chuck1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock II (Japan)
static struct BurnRomInfo g_chuk21RomDesc[] = {
	{ "chuck rock ii (japan).md", 0x100000, 0xbfd24be8, BRF_PRG },
};

STD_ROM_PICK(g_chuk21)
STD_ROM_FN(g_chuk21)

struct BurnDriverD BurnDrvMDg_chuk21 = {
	"g_chuk21", "g_chuk2", NULL, "1900",
	"Chuck Rock II (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chuk21RomInfo, g_chuk21RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock II - Son of Chuck (Europe)
static struct BurnRomInfo g_chuk2RomDesc[] = {
	{ "chuck rock ii - son of chuck (europe).md", 0x100000, 0x1ade9488, BRF_PRG },
};

STD_ROM_PICK(g_chuk2)
STD_ROM_FN(g_chuk2)

struct BurnDriverD BurnDrvMDg_chuk2 = {
	"g_chuk2", NULL, NULL, "1900",
	"Chuck Rock II - Son of Chuck (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chuk2RomInfo, g_chuk2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock II - Son of Chuck (USA) (Beta)
static struct BurnRomInfo g_chuk22RomDesc[] = {
	{ "chuck rock ii - son of chuck (usa) (beta).md", 0x100000, 0xd6a3b324, BRF_PRG },
};

STD_ROM_PICK(g_chuk22)
STD_ROM_FN(g_chuk22)

struct BurnDriverD BurnDrvMDg_chuk22 = {
	"g_chuk22", "g_chuk2", NULL, "1900",
	"Chuck Rock II - Son of Chuck (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chuk22RomInfo, g_chuk22RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck Rock II - Son of Chuck (USA)
static struct BurnRomInfo g_chuk23RomDesc[] = {
	{ "chuck rock ii - son of chuck (usa).md", 0x100000, 0x408b1cdb, BRF_PRG },
};

STD_ROM_PICK(g_chuk23)
STD_ROM_FN(g_chuk23)

struct BurnDriverD BurnDrvMDg_chuk23 = {
	"g_chuk23", "g_chuk2", NULL, "1900",
	"Chuck Rock II - Son of Chuck (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chuk23RomInfo, g_chuk23RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Chuck's Excellent Art Tool Animator (U)
static struct BurnRomInfo g_chucksRomDesc[] = {
	{ "chuck's excellent art tool animator (u).md", 0x60000, 0x6360ee58, BRF_PRG },
};

STD_ROM_PICK(g_chucks)
STD_ROM_FN(g_chucks)

struct BurnDriverD BurnDrvMDg_chucks = {
	"g_chucks", NULL, NULL, "1900",
	"Chuck's Excellent Art Tool Animator (U)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_chucksRomInfo, g_chucksRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Classic Collection (Europe)
static struct BurnRomInfo g_classiRomDesc[] = {
	{ "classic collection (europe).md", 0x200000, 0x73f948b1, BRF_PRG },
};

STD_ROM_PICK(g_classi)
STD_ROM_FN(g_classi)

struct BurnDriver BurnDrvMDg_classi = {
	"g_classi", NULL, NULL, "199?",
	"Classic Collection (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_classiRomInfo, g_classiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Clay Fighter (Europe)
static struct BurnRomInfo g_clayRomDesc[] = {
	{ "clay fighter (europe).md", 0x200000, 0x1aaf7707, BRF_PRG },
};

STD_ROM_PICK(g_clay)
STD_ROM_FN(g_clay)

struct BurnDriver BurnDrvMDg_clay = {
	"g_clay", NULL, NULL, "1994",
	"Clay Fighter (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_clayRomInfo, g_clayRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Clay Fighter (USA)
static struct BurnRomInfo g_clayuRomDesc[] = {
	{ "clay fighter (usa).md", 0x200000, 0xb12c1bc1, BRF_PRG },
};

STD_ROM_PICK(g_clayu)
STD_ROM_FN(g_clayu)

struct BurnDriver BurnDrvMDg_clayu = {
	"g_clayu", "g_clay", NULL, "1900",
	"Clay Fighter (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_clayuRomInfo, g_clayuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cliffhanger (Beta)
static struct BurnRomInfo g_cliffbRomDesc[] = {
	{ "cliffhanger (beta).md", 0x100000, 0x628251fd, BRF_PRG },
};

STD_ROM_PICK(g_cliffb)
STD_ROM_FN(g_cliffb)

struct BurnDriverD BurnDrvMDg_cliffb = {
	"g_cliffb", "g_cliff", NULL, "1900",
	"Cliffhanger (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cliffbRomInfo, g_cliffbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cliffhanger (Europe)
static struct BurnRomInfo g_cliffRomDesc[] = {
	{ "cliffhanger (europe).md", 0x100000, 0x35bff1fd, BRF_PRG },
};

STD_ROM_PICK(g_cliff)
STD_ROM_FN(g_cliff)

struct BurnDriverD BurnDrvMDg_cliff = {
	"g_cliff", NULL, NULL, "1900",
	"Cliffhanger (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cliffRomInfo, g_cliffRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cliffhanger (USA)
static struct BurnRomInfo g_cliffuRomDesc[] = {
	{ "cliffhanger (usa).md", 0x100000, 0x9cbf44d3, BRF_PRG },
};

STD_ROM_PICK(g_cliffu)
STD_ROM_FN(g_cliffu)

struct BurnDriverD BurnDrvMDg_cliffu = {
	"g_cliffu", "g_cliff", NULL, "1900",
	"Cliffhanger (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cliffuRomInfo, g_cliffuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Clue (USA)
static struct BurnRomInfo g_clueusRomDesc[] = {
	{ "clue (usa).md", 0x80000, 0x7753a296, BRF_PRG },
};

STD_ROM_PICK(g_clueus)
STD_ROM_FN(g_clueus)

struct BurnDriverD BurnDrvMDg_clueus = {
	"g_clueus", NULL, NULL, "1900",
	"Clue (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_clueusRomInfo, g_clueusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Coach K College Basketball (USA)
static struct BurnRomInfo g_coachkRomDesc[] = {
	{ "coach k college basketball (usa).md", 0x200000, 0x67c309c6, BRF_PRG },
};

STD_ROM_PICK(g_coachk)
STD_ROM_FN(g_coachk)

struct BurnDriver BurnDrvMDg_coachk = {
	"g_coachk", NULL, NULL, "1900",
	"Coach K College Basketball (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coachkRomInfo, g_coachkRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football USA 96 (USA)
static struct BurnRomInfo g_collegRomDesc[] = {
	{ "college football usa 96 (usa).md", 0x200000, 0xb9075385, BRF_PRG },
};

STD_ROM_PICK(g_colleg)
STD_ROM_FN(g_colleg)

struct BurnDriver BurnDrvMDg_colleg = {
	"g_colleg", NULL, NULL, "1900",
	"College Football USA 96 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_collegRomInfo, g_collegRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football USA 97 (USA)
static struct BurnRomInfo g_coll97RomDesc[] = {
	{ "college football usa 97 (usa).md", 0x200000, 0x2ebb90a3, BRF_PRG },
};

STD_ROM_PICK(g_coll97)
STD_ROM_FN(g_coll97)

struct BurnDriver BurnDrvMDg_coll97 = {
	"g_coll97", NULL, NULL, "1900",
	"College Football USA 97 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll97RomInfo, g_coll97RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Apr 13, 1994)
static struct BurnRomInfo g_colle2RomDesc[] = {
	{ "college football's national championship (prototype - apr 13, 1994).md", 0x200000, 0xd9772def, BRF_PRG },
};

STD_ROM_PICK(g_colle2)
STD_ROM_FN(g_colle2)

struct BurnDriverD BurnDrvMDg_colle2 = {
	"g_colle2", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Apr 13, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_colle2RomInfo, g_colle2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Apr 18, 1994)
static struct BurnRomInfo g_colle3RomDesc[] = {
	{ "college football's national championship (prototype - apr 18, 1994).md", 0x200000, 0xe0a1705f, BRF_PRG },
};

STD_ROM_PICK(g_colle3)
STD_ROM_FN(g_colle3)

struct BurnDriverD BurnDrvMDg_colle3 = {
	"g_colle3", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Apr 18, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_colle3RomInfo, g_colle3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Apr 19, 1994)
static struct BurnRomInfo g_colle4RomDesc[] = {
	{ "college football's national championship (prototype - apr 19, 1994).md", 0x200000, 0xd5fe66c3, BRF_PRG },
};

STD_ROM_PICK(g_colle4)
STD_ROM_FN(g_colle4)

struct BurnDriverD BurnDrvMDg_colle4 = {
	"g_colle4", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Apr 19, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_colle4RomInfo, g_colle4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Apr 29, 1994)
static struct BurnRomInfo g_colle5RomDesc[] = {
	{ "college football's national championship (prototype - apr 29, 1994).md", 0x200000, 0x99da1973, BRF_PRG },
};

STD_ROM_PICK(g_colle5)
STD_ROM_FN(g_colle5)

struct BurnDriverD BurnDrvMDg_colle5 = {
	"g_colle5", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Apr 29, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_colle5RomInfo, g_colle5RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Jun 01, 1994)
static struct BurnRomInfo g_colle6RomDesc[] = {
	{ "college football's national championship (prototype - jun 01, 1994).md", 0x200000, 0x994dbc8f, BRF_PRG },
};

STD_ROM_PICK(g_colle6)
STD_ROM_FN(g_colle6)

struct BurnDriverD BurnDrvMDg_colle6 = {
	"g_colle6", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Jun 01, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_colle6RomInfo, g_colle6RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Jun 03, 1994)
static struct BurnRomInfo g_colle7RomDesc[] = {
	{ "college football's national championship (prototype - jun 03, 1994).md", 0x200000, 0x9ca29321, BRF_PRG },
};

STD_ROM_PICK(g_colle7)
STD_ROM_FN(g_colle7)

struct BurnDriverD BurnDrvMDg_colle7 = {
	"g_colle7", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Jun 03, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_colle7RomInfo, g_colle7RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Jun 07, 1994)
static struct BurnRomInfo g_colle8RomDesc[] = {
	{ "college football's national championship (prototype - jun 07, 1994).md", 0x200000, 0xb40b791e, BRF_PRG },
};

STD_ROM_PICK(g_colle8)
STD_ROM_FN(g_colle8)

struct BurnDriverD BurnDrvMDg_colle8 = {
	"g_colle8", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Jun 07, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_colle8RomInfo, g_colle8RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Jun 08, 1994)
static struct BurnRomInfo g_colle9RomDesc[] = {
	{ "college football's national championship (prototype - jun 08, 1994).md", 0x200000, 0xd008debc, BRF_PRG },
};

STD_ROM_PICK(g_colle9)
STD_ROM_FN(g_colle9)

struct BurnDriverD BurnDrvMDg_colle9 = {
	"g_colle9", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Jun 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_colle9RomInfo, g_colle9RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Jun 14, 1994)
static struct BurnRomInfo g_coll10RomDesc[] = {
	{ "college football's national championship (prototype - jun 14, 1994).md", 0x200000, 0xecef7de7, BRF_PRG },
};

STD_ROM_PICK(g_coll10)
STD_ROM_FN(g_coll10)

struct BurnDriverD BurnDrvMDg_coll10 = {
	"g_coll10", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Jun 14, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll10RomInfo, g_coll10RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Jun 15, 1994)
static struct BurnRomInfo g_coll11RomDesc[] = {
	{ "college football's national championship (prototype - jun 15, 1994).md", 0x200000, 0xc7e5a998, BRF_PRG },
};

STD_ROM_PICK(g_coll11)
STD_ROM_FN(g_coll11)

struct BurnDriverD BurnDrvMDg_coll11 = {
	"g_coll11", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Jun 15, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll11RomInfo, g_coll11RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Jun 18, 1994)
static struct BurnRomInfo g_coll12RomDesc[] = {
	{ "college football's national championship (prototype - jun 18, 1994).md", 0x200000, 0x74988a9d, BRF_PRG },
};

STD_ROM_PICK(g_coll12)
STD_ROM_FN(g_coll12)

struct BurnDriverD BurnDrvMDg_coll12 = {
	"g_coll12", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Jun 18, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll12RomInfo, g_coll12RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - Jun 20, 1994)
static struct BurnRomInfo g_coll13RomDesc[] = {
	{ "college football's national championship (prototype - jun 20, 1994).md", 0x200000, 0x898c17fa, BRF_PRG },
};

STD_ROM_PICK(g_coll13)
STD_ROM_FN(g_coll13)

struct BurnDriverD BurnDrvMDg_coll13 = {
	"g_coll13", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - Jun 20, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll13RomInfo, g_coll13RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - May 03, 1994)
static struct BurnRomInfo g_coll14RomDesc[] = {
	{ "college football's national championship (prototype - may 03, 1994).md", 0x200000, 0xdb1a3f66, BRF_PRG },
};

STD_ROM_PICK(g_coll14)
STD_ROM_FN(g_coll14)

struct BurnDriverD BurnDrvMDg_coll14 = {
	"g_coll14", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - May 03, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll14RomInfo, g_coll14RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - May 06, 1994)
static struct BurnRomInfo g_coll15RomDesc[] = {
	{ "college football's national championship (prototype - may 06, 1994).md", 0x200000, 0x0a538e75, BRF_PRG },
};

STD_ROM_PICK(g_coll15)
STD_ROM_FN(g_coll15)

struct BurnDriverD BurnDrvMDg_coll15 = {
	"g_coll15", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - May 06, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll15RomInfo, g_coll15RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - May 11, 1994 - A)
static struct BurnRomInfo g_coll16RomDesc[] = {
	{ "college football's national championship (prototype - may 11, 1994 - a).md", 0x200000, 0xce65b294, BRF_PRG },
};

STD_ROM_PICK(g_coll16)
STD_ROM_FN(g_coll16)

struct BurnDriverD BurnDrvMDg_coll16 = {
	"g_coll16", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - May 11, 1994 - A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll16RomInfo, g_coll16RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - May 17, 1994 - A)
static struct BurnRomInfo g_coll17RomDesc[] = {
	{ "college football's national championship (prototype - may 17, 1994 - a).md", 0x200000, 0x8cfd4c86, BRF_PRG },
};

STD_ROM_PICK(g_coll17)
STD_ROM_FN(g_coll17)

struct BurnDriverD BurnDrvMDg_coll17 = {
	"g_coll17", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - May 17, 1994 - A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll17RomInfo, g_coll17RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - May 20, 1994)
static struct BurnRomInfo g_coll18RomDesc[] = {
	{ "college football's national championship (prototype - may 20, 1994).md", 0x200000, 0xf285385e, BRF_PRG },
};

STD_ROM_PICK(g_coll18)
STD_ROM_FN(g_coll18)

struct BurnDriverD BurnDrvMDg_coll18 = {
	"g_coll18", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - May 20, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll18RomInfo, g_coll18RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - May 25, 1994)
static struct BurnRomInfo g_coll19RomDesc[] = {
	{ "college football's national championship (prototype - may 25, 1994).md", 0x200000, 0x482e334a, BRF_PRG },
};

STD_ROM_PICK(g_coll19)
STD_ROM_FN(g_coll19)

struct BurnDriverD BurnDrvMDg_coll19 = {
	"g_coll19", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - May 25, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll19RomInfo, g_coll19RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (Prototype - May 31, 1994)
static struct BurnRomInfo g_coll20RomDesc[] = {
	{ "college football's national championship (prototype - may 31, 1994).md", 0x200000, 0xc6766745, BRF_PRG },
};

STD_ROM_PICK(g_coll20)
STD_ROM_FN(g_coll20)

struct BurnDriverD BurnDrvMDg_coll20 = {
	"g_coll20", "g_collnc", NULL, "",
	"College Football's National Championship (Prototype - May 31, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coll20RomInfo, g_coll20RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship (USA)
static struct BurnRomInfo g_collncRomDesc[] = {
	{ "college football's national championship (usa).md", 0x200000, 0x172c5dbb, BRF_PRG },
};

STD_ROM_PICK(g_collnc)
STD_ROM_FN(g_collnc)

struct BurnDriver BurnDrvMDg_collnc = {
	"g_collnc", NULL, NULL, "1994",
	"College Football's National Championship (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_collncRomInfo, g_collncRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Football's National Championship II (USA)
static struct BurnRomInfo g_colln2RomDesc[] = {
	{ "college football's national championship ii (usa).md", 0x200000, 0x65b64413, BRF_PRG },
};

STD_ROM_PICK(g_colln2)
STD_ROM_FN(g_colln2)

struct BurnDriver BurnDrvMDg_colln2 = {
	"g_colln2", NULL, NULL, "1995",
	"College Football's National Championship II (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_colln2RomInfo, g_colln2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// College Slam (USA)
static struct BurnRomInfo g_cslamRomDesc[] = {
	{ "college slam (usa).md", 0x400000, 0x96a42431, BRF_PRG },
};

STD_ROM_PICK(g_cslam)
STD_ROM_FN(g_cslam)

struct BurnDriverD BurnDrvMDg_cslam = {
	"g_cslam", NULL, NULL, "1900",
	"College Slam (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cslamRomInfo, g_cslamRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Columns (World) (v1.1)
static struct BurnRomInfo g_columnRomDesc[] = {
	{ "columns (world) (v1.1).md", 0x20000, 0xd783c244, BRF_PRG },
};

STD_ROM_PICK(g_column)
STD_ROM_FN(g_column)

struct BurnDriver BurnDrvMDg_column = {
	"g_column", NULL, NULL, "1994",
	"Columns (World) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_columnRomInfo, g_columnRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Columns (World)
static struct BurnRomInfo g_colum1RomDesc[] = {
	{ "columns (world).md", 0x20000, 0x03163d7a, BRF_PRG },
};

STD_ROM_PICK(g_colum1)
STD_ROM_FN(g_colum1)

struct BurnDriver BurnDrvMDg_colum1 = {
	"g_colum1", "g_column", NULL, "1994",
	"Columns (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_colum1RomInfo, g_colum1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Columns III - Revenge of Columns (USA)
static struct BurnRomInfo g_cols3RomDesc[] = {
	{ "columns iii - revenge of columns (usa).md", 0x80000, 0xdc678f6d, BRF_PRG },
};

STD_ROM_PICK(g_cols3)
STD_ROM_FN(g_cols3)

struct BurnDriver BurnDrvMDg_cols3 = {
	"g_cols3", NULL, NULL, "1994",
	"Columns III - Revenge of Columns (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cols3RomInfo, g_cols3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Columns III - Taiketsu! Columns World (Japan, Korea)
static struct BurnRomInfo g_cols3aRomDesc[] = {
	{ "columns iii - taiketsu! columns world (japan, korea).md", 0x80000, 0xcd07462f, BRF_PRG },
};

STD_ROM_PICK(g_cols3a)
STD_ROM_FN(g_cols3a)

struct BurnDriver BurnDrvMDg_cols3a = {
	"g_cols3a", "g_cols3", NULL, "1994",
	"Columns III - Taiketsu! Columns World (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cols3aRomInfo, g_cols3aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Combat Aces (Beta)
static struct BurnRomInfo g_combatRomDesc[] = {
	{ "combat aces (beta).md", 0x80000, 0x84560d5a, BRF_PRG },
};

STD_ROM_PICK(g_combat)
STD_ROM_FN(g_combat)

struct BurnDriverD BurnDrvMDg_combat = {
	"g_combat", NULL, NULL, "1900",
	"Combat Aces (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_combatRomInfo, g_combatRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Combat Cars (USA, Europe)
static struct BurnRomInfo g_combcaRomDesc[] = {
	{ "combat cars (usa, europe).md", 0x100000, 0xe439b101, BRF_PRG },
};

STD_ROM_PICK(g_combca)
STD_ROM_FN(g_combca)

struct BurnDriverD BurnDrvMDg_combca = {
	"g_combca", NULL, NULL, "1900",
	"Combat Cars (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_combcaRomInfo, g_combcaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (E) (Prototype - Jun 28, 1995)
static struct BurnRomInfo g_comix1RomDesc[] = {
	{ "comix zone (e) (prototype - jun 28, 1995).md", 0x200000, 0x939efd4c, BRF_PRG },
};

STD_ROM_PICK(g_comix1)
STD_ROM_FN(g_comix1)

struct BurnDriverD BurnDrvMDg_comix1 = {
	"g_comix1", "g_comix", NULL, "",
	"Comix Zone (E) (Prototype - Jun 28, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comix1RomInfo, g_comix1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Europe)
static struct BurnRomInfo g_comixRomDesc[] = {
	{ "comix zone (europe).md", 0x200000, 0x1318e923, BRF_PRG },
};

STD_ROM_PICK(g_comix)
STD_ROM_FN(g_comix)

struct BurnDriverD BurnDrvMDg_comix = {
	"g_comix", NULL, NULL, "1995",
	"Comix Zone (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comixRomInfo, g_comixRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Japan)
static struct BurnRomInfo g_comix2RomDesc[] = {
	{ "comix zone (japan).md", 0x200000, 0x7a6027b8, BRF_PRG },
};

STD_ROM_PICK(g_comix2)
STD_ROM_FN(g_comix2)

struct BurnDriverD BurnDrvMDg_comix2 = {
	"g_comix2", "g_comix", NULL, "1995",
	"Comix Zone (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comix2RomInfo, g_comix2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (K) (Prototype - Jun 09, 1995)
static struct BurnRomInfo g_comix3RomDesc[] = {
	{ "comix zone (k) (prototype - jun 09, 1995).md", 0x200000, 0xe45a15f4, BRF_PRG },
};

STD_ROM_PICK(g_comix3)
STD_ROM_FN(g_comix3)

struct BurnDriverD BurnDrvMDg_comix3 = {
	"g_comix3", "g_comix", NULL, "",
	"Comix Zone (K) (Prototype - Jun 09, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comix3RomInfo, g_comix3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype - Jul 12, 1995 - FULSCR)
static struct BurnRomInfo g_comix4RomDesc[] = {
	{ "comix zone (prototype - jul 12, 1995 - fulscr).md", 0x200000, 0xe28c89c1, BRF_PRG },
};

STD_ROM_PICK(g_comix4)
STD_ROM_FN(g_comix4)

struct BurnDriverD BurnDrvMDg_comix4 = {
	"g_comix4", "g_comix", NULL, "",
	"Comix Zone (Prototype - Jul 12, 1995 - FULSCR)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comix4RomInfo, g_comix4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype - Jul 12, 1995)
static struct BurnRomInfo g_comix5RomDesc[] = {
	{ "comix zone (prototype - jul 12, 1995).md", 0x200000, 0xe28c89c1, BRF_PRG },
};

STD_ROM_PICK(g_comix5)
STD_ROM_FN(g_comix5)

struct BurnDriverD BurnDrvMDg_comix5 = {
	"g_comix5", "g_comix", NULL, "",
	"Comix Zone (Prototype - Jul 12, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comix5RomInfo, g_comix5RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype - Jun 01, 1995 - B)
static struct BurnRomInfo g_comix6RomDesc[] = {
	{ "comix zone (prototype - jun 01, 1995 - b).md", 0x200000, 0xbbe03cb6, BRF_PRG },
};

STD_ROM_PICK(g_comix6)
STD_ROM_FN(g_comix6)

struct BurnDriverD BurnDrvMDg_comix6 = {
	"g_comix6", "g_comix", NULL, "",
	"Comix Zone (Prototype - Jun 01, 1995 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comix6RomInfo, g_comix6RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype - Jun 01, 1995 - C)
static struct BurnRomInfo g_comix7RomDesc[] = {
	{ "comix zone (prototype - jun 01, 1995 - c).md", 0x200000, 0x413b9a94, BRF_PRG },
};

STD_ROM_PICK(g_comix7)
STD_ROM_FN(g_comix7)

struct BurnDriverD BurnDrvMDg_comix7 = {
	"g_comix7", "g_comix", NULL, "",
	"Comix Zone (Prototype - Jun 01, 1995 - C)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comix7RomInfo, g_comix7RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype - Jun 01, 1995 - D)
static struct BurnRomInfo g_comix8RomDesc[] = {
	{ "comix zone (prototype - jun 01, 1995 - d).md", 0x200000, 0x9ae93c9d, BRF_PRG },
};

STD_ROM_PICK(g_comix8)
STD_ROM_FN(g_comix8)

struct BurnDriverD BurnDrvMDg_comix8 = {
	"g_comix8", "g_comix", NULL, "",
	"Comix Zone (Prototype - Jun 01, 1995 - D)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comix8RomInfo, g_comix8RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype - Jun 01, 1995)
static struct BurnRomInfo g_comix9RomDesc[] = {
	{ "comix zone (prototype - jun 01, 1995).md", 0x200000, 0xba506835, BRF_PRG },
};

STD_ROM_PICK(g_comix9)
STD_ROM_FN(g_comix9)

struct BurnDriverD BurnDrvMDg_comix9 = {
	"g_comix9", "g_comix", NULL, "",
	"Comix Zone (Prototype - Jun 01, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comix9RomInfo, g_comix9RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype - Jun 02, 1995 - B)
static struct BurnRomInfo g_comi10RomDesc[] = {
	{ "comix zone (prototype - jun 02, 1995 - b).md", 0x200000, 0xb5f0dae5, BRF_PRG },
};

STD_ROM_PICK(g_comi10)
STD_ROM_FN(g_comi10)

struct BurnDriverD BurnDrvMDg_comi10 = {
	"g_comi10", "g_comix", NULL, "",
	"Comix Zone (Prototype - Jun 02, 1995 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comi10RomInfo, g_comi10RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype - Jun 02, 1995)
static struct BurnRomInfo g_comi11RomDesc[] = {
	{ "comix zone (prototype - jun 02, 1995).md", 0x200000, 0x1a4abcf3, BRF_PRG },
};

STD_ROM_PICK(g_comi11)
STD_ROM_FN(g_comi11)

struct BurnDriverD BurnDrvMDg_comi11 = {
	"g_comi11", "g_comix", NULL, "",
	"Comix Zone (Prototype - Jun 02, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comi11RomInfo, g_comi11RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype - Jun 03, 1995)
static struct BurnRomInfo g_comi12RomDesc[] = {
	{ "comix zone (prototype - jun 03, 1995).md", 0x200000, 0xaff32614, BRF_PRG },
};

STD_ROM_PICK(g_comi12)
STD_ROM_FN(g_comi12)

struct BurnDriverD BurnDrvMDg_comi12 = {
	"g_comi12", "g_comix", NULL, "",
	"Comix Zone (Prototype - Jun 03, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comi12RomInfo, g_comi12RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype - May 26, 1995)
static struct BurnRomInfo g_comi13RomDesc[] = {
	{ "comix zone (prototype - may 26, 1995).md", 0x200000, 0x36029a1f, BRF_PRG },
};

STD_ROM_PICK(g_comi13)
STD_ROM_FN(g_comi13)

struct BurnDriverD BurnDrvMDg_comi13 = {
	"g_comi13", "g_comix", NULL, "",
	"Comix Zone (Prototype - May 26, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comi13RomInfo, g_comi13RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Prototype - May 30, 1995)
static struct BurnRomInfo g_comi14RomDesc[] = {
	{ "comix zone (prototype - may 30, 1995).md", 0x200000, 0xa72eca2c, BRF_PRG },
};

STD_ROM_PICK(g_comi14)
STD_ROM_FN(g_comi14)

struct BurnDriverD BurnDrvMDg_comi14 = {
	"g_comi14", "g_comix", NULL, "",
	"Comix Zone (Prototype - May 30, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comi14RomInfo, g_comi14RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (Sega Channel) (Prototype - Jun 12, 1995)
static struct BurnRomInfo g_comi15RomDesc[] = {
	{ "comix zone (sega channel) (prototype - jun 12, 1995).md", 0x200000, 0xc77db9e1, BRF_PRG },
};

STD_ROM_PICK(g_comi15)
STD_ROM_FN(g_comi15)

struct BurnDriverD BurnDrvMDg_comi15 = {
	"g_comi15", "g_comix", NULL, "",
	"Comix Zone (Sega Channel) (Prototype - Jun 12, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comi15RomInfo, g_comi15RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (USA) (Beta)
static struct BurnRomInfo g_comi16RomDesc[] = {
	{ "comix zone (usa) (beta).md", 0x200000, 0x2efcb6ee, BRF_PRG },
};

STD_ROM_PICK(g_comi16)
STD_ROM_FN(g_comi16)

struct BurnDriverD BurnDrvMDg_comi16 = {
	"g_comi16", "g_comix", NULL, "1995",
	"Comix Zone (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comi16RomInfo, g_comi16RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Comix Zone (USA)
static struct BurnRomInfo g_comi17RomDesc[] = {
	{ "comix zone (usa).md", 0x200000, 0x17da0354, BRF_PRG },
};

STD_ROM_PICK(g_comi17)
STD_ROM_FN(g_comi17)

struct BurnDriverD BurnDrvMDg_comi17 = {
	"g_comi17", "g_comix", NULL, "1995",
	"Comix Zone (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_comi17RomInfo, g_comi17RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Congo (Unknown) (Proto)
static struct BurnRomInfo g_congouRomDesc[] = {
	{ "congo (unknown) (proto).md", 0xf7d36, 0x13746716, BRF_PRG },
};

STD_ROM_PICK(g_congou)
STD_ROM_FN(g_congou)

struct BurnDriverD BurnDrvMDg_congou = {
	"g_congou", NULL, NULL, "1900",
	"Congo (Unknown) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_congouRomInfo, g_congouRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Contra - Hard Corps (USA, Korea)
static struct BurnRomInfo g_contraRomDesc[] = {
	{ "contra - hard corps (usa, korea).md", 0x200000, 0xc579f45e, BRF_PRG },
};

STD_ROM_PICK(g_contra)
STD_ROM_FN(g_contra)

struct BurnDriverD BurnDrvMDg_contra = {
	"g_contra", "g_probot", NULL, "1994",
	"Contra - Hard Corps (USA, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_contraRomInfo, g_contraRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Contra - The Hard Corps (Japan)
static struct BurnRomInfo g_contr1RomDesc[] = {
	{ "contra - the hard corps (japan).md", 0x200000, 0x2ab26380, BRF_PRG },
};

STD_ROM_PICK(g_contr1)
STD_ROM_FN(g_contr1)

struct BurnDriverD BurnDrvMDg_contr1 = {
	"g_contr1", "g_probot", NULL, "1994",
	"Contra - The Hard Corps (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_contr1RomInfo, g_contr1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cool Spot (Europe)
static struct BurnRomInfo g_coolspRomDesc[] = {
	{ "cool spot (europe).md", 0x100000, 0x5f09fa41, BRF_PRG },
};

STD_ROM_PICK(g_coolsp)
STD_ROM_FN(g_coolsp)

struct BurnDriver BurnDrvMDg_coolsp = {
	"g_coolsp", NULL, NULL, "1900",
	"Cool Spot (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_coolspRomInfo, g_coolspRomName, MegadriveInputInfo, MegadriveEuropeDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cool Spot (Japan, Korea)
static struct BurnRomInfo g_cools1RomDesc[] = {
	{ "cool spot (japan, korea).md", 0x100000, 0xe869efb1, BRF_PRG },
};

STD_ROM_PICK(g_cools1)
STD_ROM_FN(g_cools1)

struct BurnDriverD BurnDrvMDg_cools1 = {
	"g_cools1", "g_coolsp", NULL, "",
	"Cool Spot (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cools1RomInfo, g_cools1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cool Spot (USA) (Beta)
static struct BurnRomInfo g_cools2RomDesc[] = {
	{ "cool spot (usa) (beta).md", 0x100000, 0x0ebaa4a8, BRF_PRG },
};

STD_ROM_PICK(g_cools2)
STD_ROM_FN(g_cools2)

struct BurnDriver BurnDrvMDg_cools2 = {
	"g_cools2", "g_coolsp", NULL, "1900",
	"Cool Spot (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cools2RomInfo, g_cools2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cool Spot (USA)
static struct BurnRomInfo g_cools3RomDesc[] = {
	{ "cool spot (usa).md", 0x100000, 0xf024c1a1, BRF_PRG },
};

STD_ROM_PICK(g_cools3)
STD_ROM_FN(g_cools3)

struct BurnDriver BurnDrvMDg_cools3 = {
	"g_cools3", "g_coolsp", NULL, "1900",
	"Cool Spot (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cools3RomInfo, g_cools3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Corporation (Europe)
static struct BurnRomInfo g_corporRomDesc[] = {
	{ "corporation (europe).md", 0x100000, 0xa80d18aa, BRF_PRG },
};

STD_ROM_PICK(g_corpor)
STD_ROM_FN(g_corpor)

struct BurnDriverD BurnDrvMDg_corpor = {
	"g_corpor", NULL, NULL, "1994",
	"Corporation (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_corporRomInfo, g_corporRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cosmic Spacehead (USA, Europe) (En,Fr,De,Es)
static struct BurnRomInfo g_cosmicRomDesc[] = {
	{ "cosmic spacehead (usa, europe) (en,fr,de,es).md", 0x100000, 0xc593d31c, BRF_PRG },
};

STD_ROM_PICK(g_cosmic)
STD_ROM_FN(g_cosmic)

struct BurnDriverD BurnDrvMDg_cosmic = {
	"g_cosmic", NULL, NULL, "1900",
	"Cosmic Spacehead (USA, Europe) (En,Fr,De,Es)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cosmicRomInfo, g_cosmicRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crack Down (Japan, Europe) (Rev A)
static struct BurnRomInfo g_crackdRomDesc[] = {
	{ "crack down (japan, europe) (rev a).md", 0x80000, 0xd012a47a, BRF_PRG },
};

STD_ROM_PICK(g_crackd)
STD_ROM_FN(g_crackd)

struct BurnDriverD BurnDrvMDg_crackd = {
	"g_crackd", NULL, NULL, "1900",
	"Crack Down (Japan, Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crackdRomInfo, g_crackdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crack Down (Japan, Europe)
static struct BurnRomInfo g_crack1RomDesc[] = {
	{ "crack down (japan, europe).md", 0x80000, 0x538aaa5d, BRF_PRG },
};

STD_ROM_PICK(g_crack1)
STD_ROM_FN(g_crack1)

struct BurnDriverD BurnDrvMDg_crack1 = {
	"g_crack1", "g_crackd", NULL, "1900",
	"Crack Down (Japan, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crack1RomInfo, g_crack1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crack Down (USA)
static struct BurnRomInfo g_crack2RomDesc[] = {
	{ "crack down (usa).md", 0x80000, 0xb9ce9051, BRF_PRG },
};

STD_ROM_PICK(g_crack2)
STD_ROM_FN(g_crack2)

struct BurnDriverD BurnDrvMDg_crack2 = {
	"g_crack2", "g_crackd", NULL, "1900",
	"Crack Down (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crack2RomInfo, g_crack2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crayon Shin-chan - Arashi o Yobu Enji (Japan)
static struct BurnRomInfo g_crayonRomDesc[] = {
	{ "crayon shin-chan - arashi o yobu enji (japan).md", 0x200000, 0x97fc42d2, BRF_PRG },
};

STD_ROM_PICK(g_crayon)
STD_ROM_FN(g_crayon)

struct BurnDriverD BurnDrvMDg_crayon = {
	"g_crayon", NULL, NULL, "",
	"Crayon Shin-chan - Arashi o Yobu Enji (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crayonRomInfo, g_crayonRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cross Fire (USA)
static struct BurnRomInfo g_crossfRomDesc[] = {
	{ "cross fire (usa).md", 0x80000, 0xcc73f3a9, BRF_PRG },
};

STD_ROM_PICK(g_crossf)
STD_ROM_FN(g_crossf)

struct BurnDriverD BurnDrvMDg_crossf = {
	"g_crossf", NULL, NULL, "1991",
	"Cross Fire (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crossfRomInfo, g_crossfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crude Buster (Japan)
static struct BurnRomInfo g_crudebRomDesc[] = {
	{ "crude buster (japan).md", 0x100000, 0xaffb4b00, BRF_PRG },
};

STD_ROM_PICK(g_crudeb)
STD_ROM_FN(g_crudeb)

struct BurnDriver BurnDrvMDg_crudeb = {
	"g_crudeb", "g_twocru", NULL, "1900",
	"Crude Buster (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crudebRomInfo, g_crudebRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crue Ball (Japan)
static struct BurnRomInfo g_cruejRomDesc[] = {
	{ "crue ball (japan).md", 0x80000, 0x514c53e2, BRF_PRG },
};

STD_ROM_PICK(g_cruej)
STD_ROM_FN(g_cruej)

struct BurnDriverD BurnDrvMDg_cruej = {
	"g_cruej", "g_crue", NULL, "",
	"Crue Ball (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cruejRomInfo, g_cruejRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crue Ball - Heavy Metal Pinball (USA, Europe)
static struct BurnRomInfo g_crueRomDesc[] = {
	{ "crue ball - heavy metal pinball (usa, europe).md", 0x80000, 0x4b195fc0, BRF_PRG },
};

STD_ROM_PICK(g_crue)
STD_ROM_FN(g_crue)

struct BurnDriverD BurnDrvMDg_crue = {
	"g_crue", NULL, NULL, "",
	"Crue Ball - Heavy Metal Pinball (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crueRomInfo, g_crueRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crusader of Centy (USA)
static struct BurnRomInfo g_crusadRomDesc[] = {
	{ "crusader of centy (usa).md", 0x200000, 0x41858f6f, BRF_PRG },
};

STD_ROM_PICK(g_crusad)
STD_ROM_FN(g_crusad)

struct BurnDriver BurnDrvMDg_crusad = {
	"g_crusad", "g_soleil", NULL, "1994",
	"Crusader of Centy (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crusadRomInfo, g_crusadRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crying - Aseimei Sensou (Japan)
static struct BurnRomInfo g_cryingRomDesc[] = {
	{ "crying - aseimei sensou (japan).md", 0x100000, 0x4aba1d6a, BRF_PRG },
};

STD_ROM_PICK(g_crying)
STD_ROM_FN(g_crying)

struct BurnDriver BurnDrvMDg_crying = {
	"g_crying", "g_biohz", NULL, "1992",
	"Crying - Aseimei Sensou (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_HORSHOOT, 0,
	NULL, g_cryingRomInfo, g_cryingRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jul 01, 1994)
static struct BurnRomInfo g_cryst0RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 01, 1994).md", 0x100000, 0x16ac2e4f, BRF_PRG },
};

STD_ROM_PICK(g_cryst0)
STD_ROM_FN(g_cryst0)

struct BurnDriverD BurnDrvMDg_cryst0 = {
	"g_cryst0", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jul 01, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cryst0RomInfo, g_cryst0RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jul 02, 1994)
static struct BurnRomInfo g_cryst1RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 02, 1994).md", 0x100000, 0x24bc4354, BRF_PRG },
};

STD_ROM_PICK(g_cryst1)
STD_ROM_FN(g_cryst1)

struct BurnDriverD BurnDrvMDg_cryst1 = {
	"g_cryst1", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jul 02, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cryst1RomInfo, g_cryst1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jul 03, 1994)
static struct BurnRomInfo g_cryst2RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 03, 1994).md", 0x100000, 0x6d67a87c, BRF_PRG },
};

STD_ROM_PICK(g_cryst2)
STD_ROM_FN(g_cryst2)

struct BurnDriverD BurnDrvMDg_cryst2 = {
	"g_cryst2", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jul 03, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cryst2RomInfo, g_cryst2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jul 12, 1994 - B)
static struct BurnRomInfo g_cryst3RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 12, 1994 - b).md", 0x100000, 0x3577dc72, BRF_PRG },
};

STD_ROM_PICK(g_cryst3)
STD_ROM_FN(g_cryst3)

struct BurnDriverD BurnDrvMDg_cryst3 = {
	"g_cryst3", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jul 12, 1994 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cryst3RomInfo, g_cryst3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jul 12, 1994)
static struct BurnRomInfo g_cryst4RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 12, 1994).md", 0xff554, 0x2bfc0a53, BRF_PRG },
};

STD_ROM_PICK(g_cryst4)
STD_ROM_FN(g_cryst4)

struct BurnDriverD BurnDrvMDg_cryst4 = {
	"g_cryst4", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jul 12, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cryst4RomInfo, g_cryst4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jul 13, 1994)
static struct BurnRomInfo g_cryst5RomDesc[] = {
	{ "crystal's pony tale (prototype - jul 13, 1994).md", 0x100000, 0xc67b6dba, BRF_PRG },
};

STD_ROM_PICK(g_cryst5)
STD_ROM_FN(g_cryst5)

struct BurnDriverD BurnDrvMDg_cryst5 = {
	"g_cryst5", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jul 13, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cryst5RomInfo, g_cryst5RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jun 01, 1994)
static struct BurnRomInfo g_cryst6RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 01, 1994).md", 0x100000, 0x14c6347c, BRF_PRG },
};

STD_ROM_PICK(g_cryst6)
STD_ROM_FN(g_cryst6)

struct BurnDriverD BurnDrvMDg_cryst6 = {
	"g_cryst6", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jun 01, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cryst6RomInfo, g_cryst6RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jun 06, 1994)
static struct BurnRomInfo g_cryst7RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 06, 1994).md", 0x100000, 0x83e8cac9, BRF_PRG },
};

STD_ROM_PICK(g_cryst7)
STD_ROM_FN(g_cryst7)

struct BurnDriverD BurnDrvMDg_cryst7 = {
	"g_cryst7", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jun 06, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cryst7RomInfo, g_cryst7RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jun 10, 1994)
static struct BurnRomInfo g_cryst8RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 10, 1994).md", 0x100000, 0x9e1dd267, BRF_PRG },
};

STD_ROM_PICK(g_cryst8)
STD_ROM_FN(g_cryst8)

struct BurnDriverD BurnDrvMDg_cryst8 = {
	"g_cryst8", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jun 10, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cryst8RomInfo, g_cryst8RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jun 23, 1994)
static struct BurnRomInfo g_cryst9RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 23, 1994).md", 0x100000, 0x4ccc19af, BRF_PRG },
};

STD_ROM_PICK(g_cryst9)
STD_ROM_FN(g_cryst9)

struct BurnDriverD BurnDrvMDg_cryst9 = {
	"g_cryst9", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jun 23, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cryst9RomInfo, g_cryst9RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jun 28, 1994)
static struct BurnRomInfo g_crys10RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 28, 1994).md", 0x100000, 0x03be7f66, BRF_PRG },
};

STD_ROM_PICK(g_crys10)
STD_ROM_FN(g_crys10)

struct BurnDriverD BurnDrvMDg_crys10 = {
	"g_crys10", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jun 28, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crys10RomInfo, g_crys10RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - Jun 30, 1994)
static struct BurnRomInfo g_crys11RomDesc[] = {
	{ "crystal's pony tale (prototype - jun 30, 1994).md", 0x100000, 0xdd8c73fb, BRF_PRG },
};

STD_ROM_PICK(g_crys11)
STD_ROM_FN(g_crys11)

struct BurnDriverD BurnDrvMDg_crys11 = {
	"g_crys11", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - Jun 30, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crys11RomInfo, g_crys11RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - May 11, 1994)
static struct BurnRomInfo g_crys12RomDesc[] = {
	{ "crystal's pony tale (prototype - may 11, 1994).md", 0x100000, 0xeac9d74b, BRF_PRG },
};

STD_ROM_PICK(g_crys12)
STD_ROM_FN(g_crys12)

struct BurnDriverD BurnDrvMDg_crys12 = {
	"g_crys12", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - May 11, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crys12RomInfo, g_crys12RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - May 19, 1994)
static struct BurnRomInfo g_crys13RomDesc[] = {
	{ "crystal's pony tale (prototype - may 19, 1994).md", 0x100000, 0xdc50b741, BRF_PRG },
};

STD_ROM_PICK(g_crys13)
STD_ROM_FN(g_crys13)

struct BurnDriverD BurnDrvMDg_crys13 = {
	"g_crys13", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - May 19, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crys13RomInfo, g_crys13RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (Prototype - May 26, 1994)
static struct BurnRomInfo g_crys14RomDesc[] = {
	{ "crystal's pony tale (prototype - may 26, 1994).md", 0x100000, 0xa2eaba55, BRF_PRG },
};

STD_ROM_PICK(g_crys14)
STD_ROM_FN(g_crys14)

struct BurnDriverD BurnDrvMDg_crys14 = {
	"g_crys14", "g_crysta", NULL, "",
	"Crystal's Pony Tale (Prototype - May 26, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crys14RomInfo, g_crys14RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Crystal's Pony Tale (USA)
static struct BurnRomInfo g_crystaRomDesc[] = {
	{ "crystal's pony tale (usa).md", 0x100000, 0x6cf7a4df, BRF_PRG },
};

STD_ROM_PICK(g_crysta)
STD_ROM_FN(g_crysta)

struct BurnDriverD BurnDrvMDg_crysta = {
	"g_crysta", NULL, NULL, "1900",
	"Crystal's Pony Tale (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_crystaRomInfo, g_crystaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Curse (Japan)
static struct BurnRomInfo g_cursejRomDesc[] = {
	{ "curse (japan).md", 0x80000, 0xa4fbf9a9, BRF_PRG },
};

STD_ROM_PICK(g_cursej)
STD_ROM_FN(g_cursej)

struct BurnDriverD BurnDrvMDg_cursej = {
	"g_cursej", NULL, NULL, "1900",
	"Curse (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cursejRomInfo, g_cursejRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cutie Suzuki no Ringside Angel (Japan)
static struct BurnRomInfo g_cutiesRomDesc[] = {
	{ "cutie suzuki no ringside angel (japan).md", 0x80000, 0x13795dca, BRF_PRG },
};

STD_ROM_PICK(g_cuties)
STD_ROM_FN(g_cuties)

struct BurnDriverD BurnDrvMDg_cuties = {
	"g_cuties", NULL, NULL, "1900",
	"Cutie Suzuki no Ringside Angel (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cutiesRomInfo, g_cutiesRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// CutThroat Island (USA, Europe)
static struct BurnRomInfo g_cutthrRomDesc[] = {
	{ "cutthroat island (usa, europe).md", 0x200000, 0xebabbc70, BRF_PRG },
};

STD_ROM_PICK(g_cutthr)
STD_ROM_FN(g_cutthr)

struct BurnDriverD BurnDrvMDg_cutthr = {
	"g_cutthr", NULL, NULL, "1900",
	"CutThroat Island (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cutthrRomInfo, g_cutthrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cyber Police ESWAT (Japan)
static struct BurnRomInfo g_cyberpRomDesc[] = {
	{ "cyber police eswat (japan).md", 0x80000, 0x87b636a2, BRF_PRG },
};

STD_ROM_PICK(g_cyberp)
STD_ROM_FN(g_cyberp)

struct BurnDriver BurnDrvMDg_cyberp = {
	"g_cyberp", "g_eswatc", NULL, "1990",
	"Cyber Police ESWAT (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_cyberpRomInfo, g_cyberpRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cyber-Cop (USA)
static struct BurnRomInfo g_cybercRomDesc[] = {
	{ "cyber-cop (usa).md", 0x100000, 0x01e719c8, BRF_PRG },
};

STD_ROM_PICK(g_cyberc)
STD_ROM_FN(g_cyberc)

struct BurnDriverD BurnDrvMDg_cyberc = {
	"g_cyberc", NULL, NULL, "1994",
	"Cyber-Cop (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cybercRomInfo, g_cybercRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// CyberBall (World)
static struct BurnRomInfo g_cyberbRomDesc[] = {
	{ "cyberball (world).md", 0x80000, 0x76120e96, BRF_PRG },
};

STD_ROM_PICK(g_cyberb)
STD_ROM_FN(g_cyberb)

struct BurnDriverD BurnDrvMDg_cyberb = {
	"g_cyberb", NULL, NULL, "1900",
	"CyberBall (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cyberbRomInfo, g_cyberbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cyborg Justice (Beta)
static struct BurnRomInfo g_cyborbRomDesc[] = {
	{ "cyborg justice (beta).md", 0x80000, 0x91daf11e, BRF_PRG },
};

STD_ROM_PICK(g_cyborb)
STD_ROM_FN(g_cyborb)

struct BurnDriverD BurnDrvMDg_cyborb = {
	"g_cyborb", "g_cybor", NULL, "1993",
	"Cyborg Justice (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cyborbRomInfo, g_cyborbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Cyborg Justice (USA, Europe)
static struct BurnRomInfo g_cyborRomDesc[] = {
	{ "cyborg justice (usa, europe).md", 0x80000, 0xab0d1269, BRF_PRG },
};

STD_ROM_PICK(g_cybor)
STD_ROM_FN(g_cybor)

struct BurnDriverD BurnDrvMDg_cybor = {
	"g_cybor", NULL, NULL, "1993",
	"Cyborg Justice (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_cyborRomInfo, g_cyborRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Daffy Duck in Hollywood (Europe) (Beta)
static struct BurnRomInfo g_daffybRomDesc[] = {
	{ "daffy duck in hollywood (europe) (beta).md", 0x200000, 0x0eaa4740, BRF_PRG },
};

STD_ROM_PICK(g_daffyb)
STD_ROM_FN(g_daffyb)

struct BurnDriverD BurnDrvMDg_daffyb = {
	"g_daffyb", "g_daffy", NULL, "1900",
	"Daffy Duck in Hollywood (Europe) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_daffybRomInfo, g_daffybRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Daffy Duck in Hollywood (Europe) (En,Fr,De,Es,It)
static struct BurnRomInfo g_daffyRomDesc[] = {
	{ "daffy duck in hollywood (europe) (en,fr,de,es,it).md", 0x200000, 0x1fdc66b0, BRF_PRG },
};

STD_ROM_PICK(g_daffy)
STD_ROM_FN(g_daffy)

struct BurnDriverD BurnDrvMDg_daffy = {
	"g_daffy", NULL, NULL, "1900",
	"Daffy Duck in Hollywood (Europe) (En,Fr,De,Es,It)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_daffyRomInfo, g_daffyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dahna (Korea)
static struct BurnRomInfo g_dahnakRomDesc[] = {
	{ "dahna (korea).md", 0x100000, 0x10829ea1, BRF_PRG },
};

STD_ROM_PICK(g_dahnak)
STD_ROM_FN(g_dahnak)

struct BurnDriverD BurnDrvMDg_dahnak = {
	"g_dahnak", "g_dahnam", NULL, "",
	"Dahna (Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dahnakRomInfo, g_dahnakRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dahna Megami Tanjou (Japan)
static struct BurnRomInfo g_dahnamRomDesc[] = {
	{ "dahna megami tanjou (japan).md", 0x100000, 0x4602584f, BRF_PRG },
};

STD_ROM_PICK(g_dahnam)
STD_ROM_FN(g_dahnam)

struct BurnDriverD BurnDrvMDg_dahnam = {
	"g_dahnam", NULL, NULL, "1991",
	"Dahna Megami Tanjou (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dahnamRomInfo, g_dahnamRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dai Makaimura (Japan)
static struct BurnRomInfo g_daimakRomDesc[] = {
	{ "dai makaimura (japan).md", 0xa0000, 0x5659f379, BRF_PRG },
};

STD_ROM_PICK(g_daimak)
STD_ROM_FN(g_daimak)

struct BurnDriverD BurnDrvMDg_daimak = {
	"g_daimak", "g_ghouls", NULL, "1989",
	"Dai Makaimura (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_daimakRomInfo, g_daimakRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Daikoukai Jidai (Japan)
static struct BurnRomInfo g_daikRomDesc[] = {
	{ "daikoukai jidai (japan).md", 0x100000, 0x5a652458, BRF_PRG },
};

STD_ROM_PICK(g_daik)
STD_ROM_FN(g_daik)

struct BurnDriverD BurnDrvMDg_daik = {
	"g_daik", "g_unchw", NULL, "1900",
	"Daikoukai Jidai (Japan)\0", NULL, "Koei", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_daikRomInfo, g_daikRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Daikoukai Jidai II (Japan)
static struct BurnRomInfo g_daik2RomDesc[] = {
	{ "daikoukai jidai ii (japan).md", 0x200000, 0xe040f0da, BRF_PRG },
};

STD_ROM_PICK(g_daik2)
STD_ROM_FN(g_daik2)

struct BurnDriver BurnDrvMDg_daik2 = {
	"g_daik2", "g_unchw2", NULL, "1900",
	"Daikoukai Jidai II (Japan)\0", NULL, "Koei", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_daik2RomInfo, g_daik2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Daisenpuu ~ Twin Hawk (Japan, Europe)
static struct BurnRomInfo g_daisenRomDesc[] = {
	{ "daisenpuu ~ twin hawk (japan, europe).md", 0x80000, 0xa2ec8c67, BRF_PRG },
};

STD_ROM_PICK(g_daisen)
STD_ROM_FN(g_daisen)

struct BurnDriverD BurnDrvMDg_daisen = {
	"g_daisen", NULL, NULL, "1900",
	"Daisenpuu ~ Twin Hawk (Japan, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_daisenRomInfo, g_daisenRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dangerous Seed (Japan)
static struct BurnRomInfo g_dangerRomDesc[] = {
	{ "dangerous seed (japan).md", 0x80000, 0xa2990031, BRF_PRG },
};

STD_ROM_PICK(g_danger)
STD_ROM_FN(g_danger)

struct BurnDriverD BurnDrvMDg_danger = {
	"g_danger", NULL, NULL, "1900",
	"Dangerous Seed (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dangerRomInfo, g_dangerRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Darius II (J) [a1]
static struct BurnRomInfo g_dariusRomDesc[] = {
	{ "darius ii (j) [a1].md", 0x100000, 0x0140ab58, BRF_PRG },
};

STD_ROM_PICK(g_darius)
STD_ROM_FN(g_darius)

struct BurnDriverD BurnDrvMDg_darius = {
	"g_darius", "g_sagaia", NULL, "1900",
	"Darius II (J) [a1]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dariusRomInfo, g_dariusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Darius II (Japan)
static struct BurnRomInfo g_dariu1RomDesc[] = {
	{ "darius ii (japan).md", 0x100000, 0x25dfe62a, BRF_PRG },
};

STD_ROM_PICK(g_dariu1)
STD_ROM_FN(g_dariu1)

struct BurnDriverD BurnDrvMDg_dariu1 = {
	"g_dariu1", "g_sagaia", NULL, "1900",
	"Darius II (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dariu1RomInfo, g_dariu1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dark Castle (USA, Europe)
static struct BurnRomInfo g_darkcaRomDesc[] = {
	{ "dark castle (usa, europe).md", 0x80000, 0x0464aca4, BRF_PRG },
};

STD_ROM_PICK(g_darkca)
STD_ROM_FN(g_darkca)

struct BurnDriverD BurnDrvMDg_darkca = {
	"g_darkca", NULL, NULL, "1900",
	"Dark Castle (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_darkcaRomInfo, g_darkcaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Darwin 4081 (Japan, Korea)
static struct BurnRomInfo g_darwinRomDesc[] = {
	{ "darwin 4081 (japan, korea).md", 0x80000, 0x7a33b0cb, BRF_PRG },
};

STD_ROM_PICK(g_darwin)
STD_ROM_FN(g_darwin)

struct BurnDriver BurnDrvMDg_darwin = {
	"g_darwin", NULL, NULL, "1900",
	"Darwin 4081 (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_darwinRomInfo, g_darwinRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dashin' Desperadoes (Beta)
static struct BurnRomInfo g_dashbaRomDesc[] = {
	{ "dashin' desperadoes (beta).md", 0x100000, 0xadaffc3f, BRF_PRG },
};

STD_ROM_PICK(g_dashba)
STD_ROM_FN(g_dashba)

struct BurnDriverD BurnDrvMDg_dashba = {
	"g_dashba", "g_dash", NULL, "1900",
	"Dashin' Desperadoes (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dashbaRomInfo, g_dashbaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dashin' Desperadoes (USA) (Beta)
static struct BurnRomInfo g_dashbRomDesc[] = {
	{ "dashin' desperadoes (usa) (beta).md", 0x100000, 0x98d224a5, BRF_PRG },
};

STD_ROM_PICK(g_dashb)
STD_ROM_FN(g_dashb)

struct BurnDriverD BurnDrvMDg_dashb = {
	"g_dashb", "g_dash", NULL, "",
	"Dashin' Desperadoes (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dashbRomInfo, g_dashbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dashin' Desperadoes (USA)
static struct BurnRomInfo g_dashRomDesc[] = {
	{ "dashin' desperadoes (usa).md", 0x100000, 0xdcb76fb7, BRF_PRG },
};

STD_ROM_PICK(g_dash)
STD_ROM_FN(g_dash)

struct BurnDriverD BurnDrvMDg_dash = {
	"g_dash", NULL, NULL, "",
	"Dashin' Desperadoes (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dashRomInfo, g_dashRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// David Crane's Amazing Tennis (USA)
static struct BurnRomInfo g_davidcRomDesc[] = {
	{ "david crane's amazing tennis (usa).md", 0x100000, 0x9177088c, BRF_PRG },
};

STD_ROM_PICK(g_davidc)
STD_ROM_FN(g_davidc)

struct BurnDriverD BurnDrvMDg_davidc = {
	"g_davidc", NULL, NULL, "1900",
	"David Crane's Amazing Tennis (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_davidcRomInfo, g_davidcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// David Robinson Basketball (Japan)
static struct BurnRomInfo g_drscjRomDesc[] = {
	{ "david robinson basketball (japan).md", 0x80000, 0x56164b00, BRF_PRG },
};

STD_ROM_PICK(g_drscj)
STD_ROM_FN(g_drscj)

struct BurnDriverD BurnDrvMDg_drscj = {
	"g_drscj", "g_drsc", NULL, "1900",
	"David Robinson Basketball (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_drscjRomInfo, g_drscjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// David Robinson's Supreme Court (USA, Europe)
static struct BurnRomInfo g_drscRomDesc[] = {
	{ "david robinson's supreme court (usa, europe).md", 0x80000, 0x512b7599, BRF_PRG },
};

STD_ROM_PICK(g_drsc)
STD_ROM_FN(g_drsc)

struct BurnDriverD BurnDrvMDg_drsc = {
	"g_drsc", NULL, NULL, "",
	"David Robinson's Supreme Court (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_drscRomInfo, g_drscRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Davis Cup II (USA) (Proto)
static struct BurnRomInfo g_dcup2aRomDesc[] = {
	{ "davis cup ii (usa) (proto).md", 0x200000, 0x76f2bed8, BRF_PRG },
};

STD_ROM_PICK(g_dcup2a)
STD_ROM_FN(g_dcup2a)

struct BurnDriverD BurnDrvMDg_dcup2a = {
	"g_dcup2a", "g_dcup2", NULL, "1900",
	"Davis Cup II (USA) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dcup2aRomInfo, g_dcup2aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Davis Cup World Tour (USA, Europe) (July 1993)
static struct BurnRomInfo g_dcupRomDesc[] = {
	{ "davis cup world tour (usa, europe) (july 1993).md", 0x100000, 0x894686f0, BRF_PRG },
};

STD_ROM_PICK(g_dcup)
STD_ROM_FN(g_dcup)

struct BurnDriverD BurnDrvMDg_dcup = {
	"g_dcup", NULL, NULL, "1900",
	"Davis Cup World Tour (USA, Europe) (July 1993)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dcupRomInfo, g_dcupRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Davis Cup World Tour (USA, Europe) (June 1993)
static struct BurnRomInfo g_dcupaRomDesc[] = {
	{ "davis cup world tour (usa, europe) (june 1993).md", 0x100000, 0x7c6b0646, BRF_PRG },
};

STD_ROM_PICK(g_dcupa)
STD_ROM_FN(g_dcupa)

struct BurnDriverD BurnDrvMDg_dcupa = {
	"g_dcupa", "g_dcup", NULL, "1900",
	"Davis Cup World Tour (USA, Europe) (June 1993)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dcupaRomInfo, g_dcupaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Davis Cup World Tour Tennis 2 (Beta 1)
static struct BurnRomInfo g_dcup2RomDesc[] = {
	{ "davis cup world tour tennis 2 (beta 1).md", 0x200000, 0x6f4183c0, BRF_PRG },
};

STD_ROM_PICK(g_dcup2)
STD_ROM_FN(g_dcup2)

struct BurnDriverD BurnDrvMDg_dcup2 = {
	"g_dcup2", NULL, NULL, "1900",
	"Davis Cup World Tour Tennis 2 (Beta 1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dcup2RomInfo, g_dcup2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Daze Before Christmas (Australia) (Beta)
static struct BurnRomInfo g_dazebRomDesc[] = {
	{ "daze before christmas (australia) (beta).md", 0x200000, 0x317c9491, BRF_PRG },
};

STD_ROM_PICK(g_dazeb)
STD_ROM_FN(g_dazeb)

struct BurnDriverD BurnDrvMDg_dazeb = {
	"g_dazeb", "g_daze", NULL, "",
	"Daze Before Christmas (Australia) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dazebRomInfo, g_dazebRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Daze Before Christmas (Australia)
static struct BurnRomInfo g_dazeRomDesc[] = {
	{ "daze before christmas (australia).md", 0x200000, 0xb95e25c9, BRF_PRG },
};

STD_ROM_PICK(g_daze)
STD_ROM_FN(g_daze)

struct BurnDriverD BurnDrvMDg_daze = {
	"g_daze", NULL, NULL, "",
	"Daze Before Christmas (Australia)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dazeRomInfo, g_dazeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Deadly Moves (USA)
static struct BurnRomInfo g_deadlyRomDesc[] = {
	{ "deadly moves (usa).md", 0x100000, 0x35cbd237, BRF_PRG },
};

STD_ROM_PICK(g_deadly)
STD_ROM_FN(g_deadly)

struct BurnDriverD BurnDrvMDg_deadly = {
	"g_deadly", NULL, NULL, "1900",
	"Deadly Moves (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deadlyRomInfo, g_deadlyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Death and Return of Superman, The (USA)
static struct BurnRomInfo g_deathaRomDesc[] = {
	{ "death and return of superman, the (usa).md", 0x200000, 0x982242d3, BRF_PRG },
};

STD_ROM_PICK(g_deatha)
STD_ROM_FN(g_deatha)

struct BurnDriverD BurnDrvMDg_deatha = {
	"g_deatha", NULL, NULL, "1900",
	"Death and Return of Superman, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deathaRomInfo, g_deathaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Death Duel (USA)
static struct BurnRomInfo g_deathdRomDesc[] = {
	{ "death duel (usa).md", 0x100000, 0xa9804dcc, BRF_PRG },
};

STD_ROM_PICK(g_deathd)
STD_ROM_FN(g_deathd)

struct BurnDriverD BurnDrvMDg_deathd = {
	"g_deathd", NULL, NULL, "1900",
	"Death Duel (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deathdRomInfo, g_deathdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// DEBUG - Charles Window Bug Example (PD)
static struct BurnRomInfo g_debugcRomDesc[] = {
	{ "debug - charles window bug example (pd).md", 0x4000, 0x75582ddb, BRF_PRG },
};

STD_ROM_PICK(g_debugc)
STD_ROM_FN(g_debugc)

struct BurnDriverD BurnDrvMDg_debugc = {
	"g_debugc", NULL, NULL, "1900",
	"DEBUG - Charles Window Bug Example (PD)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_debugcRomInfo, g_debugcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// DecapAttack (USA, Europe)
static struct BurnRomInfo g_decapaRomDesc[] = {
	{ "decapattack (usa, europe).md", 0x80000, 0x73dc0dd8, BRF_PRG },
};

STD_ROM_PICK(g_decapa)
STD_ROM_FN(g_decapa)

struct BurnDriverD BurnDrvMDg_decapa = {
	"g_decapa", NULL, NULL, "1900",
	"DecapAttack (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_decapaRomInfo, g_decapaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Demolition Man (USA) (Beta)
static struct BurnRomInfo g_demobRomDesc[] = {
	{ "demolition man (usa) (beta).md", 0x200000, 0x57ffad7a, BRF_PRG },
};

STD_ROM_PICK(g_demob)
STD_ROM_FN(g_demob)

struct BurnDriverD BurnDrvMDg_demob = {
	"g_demob", "g_demo", NULL, "1900",
	"Demolition Man (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_demobRomInfo, g_demobRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Demolition Man (USA, Europe)
static struct BurnRomInfo g_demoRomDesc[] = {
	{ "demolition man (usa, europe).md", 0x200000, 0x5ff71877, BRF_PRG },
};

STD_ROM_PICK(g_demo)
STD_ROM_FN(g_demo)

struct BurnDriverD BurnDrvMDg_demo = {
	"g_demo", NULL, NULL, "",
	"Demolition Man (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_demoRomInfo, g_demoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype - Dec 06, 1994)
static struct BurnRomInfo g_deser0RomDesc[] = {
	{ "desert demolition (prototype - dec 06, 1994).md", 0xed0ad, 0xd27fe9e5, BRF_PRG },
};

STD_ROM_PICK(g_deser0)
STD_ROM_FN(g_deser0)

struct BurnDriverD BurnDrvMDg_deser0 = {
	"g_deser0", "g_desert", NULL, "",
	"Desert Demolition (Prototype - Dec 06, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deser0RomInfo, g_deser0RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype - Dec 08, 1994)
static struct BurnRomInfo g_deser1RomDesc[] = {
	{ "desert demolition (prototype - dec 08, 1994).md", 0xfdfb8, 0x69aaeab6, BRF_PRG },
};

STD_ROM_PICK(g_deser1)
STD_ROM_FN(g_deser1)

struct BurnDriverD BurnDrvMDg_deser1 = {
	"g_deser1", "g_desert", NULL, "",
	"Desert Demolition (Prototype - Dec 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deser1RomInfo, g_deser1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype - Dec 12, 1994 - B)
static struct BurnRomInfo g_deser2RomDesc[] = {
	{ "desert demolition (prototype - dec 12, 1994 - b).md", 0x100000, 0x16f19283, BRF_PRG },
};

STD_ROM_PICK(g_deser2)
STD_ROM_FN(g_deser2)

struct BurnDriverD BurnDrvMDg_deser2 = {
	"g_deser2", "g_desert", NULL, "",
	"Desert Demolition (Prototype - Dec 12, 1994 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deser2RomInfo, g_deser2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype - Dec 12, 1994)
static struct BurnRomInfo g_deser3RomDesc[] = {
	{ "desert demolition (prototype - dec 12, 1994).md", 0xec988, 0x5dad49d7, BRF_PRG },
};

STD_ROM_PICK(g_deser3)
STD_ROM_FN(g_deser3)

struct BurnDriverD BurnDrvMDg_deser3 = {
	"g_deser3", "g_desert", NULL, "",
	"Desert Demolition (Prototype - Dec 12, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deser3RomInfo, g_deser3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype - Dec 13, 1994)
static struct BurnRomInfo g_deser4RomDesc[] = {
	{ "desert demolition (prototype - dec 13, 1994).md", 0xfde9c, 0x375dee15, BRF_PRG },
};

STD_ROM_PICK(g_deser4)
STD_ROM_FN(g_deser4)

struct BurnDriverD BurnDrvMDg_deser4 = {
	"g_deser4", "g_desert", NULL, "",
	"Desert Demolition (Prototype - Dec 13, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deser4RomInfo, g_deser4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype - Dec 14, 1994)
static struct BurnRomInfo g_deser5RomDesc[] = {
	{ "desert demolition (prototype - dec 14, 1994).md", 0xfde9c, 0x39f9f304, BRF_PRG },
};

STD_ROM_PICK(g_deser5)
STD_ROM_FN(g_deser5)

struct BurnDriverD BurnDrvMDg_deser5 = {
	"g_deser5", "g_desert", NULL, "",
	"Desert Demolition (Prototype - Dec 14, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deser5RomInfo, g_deser5RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype - Dec 15, 1994)
static struct BurnRomInfo g_deser6RomDesc[] = {
	{ "desert demolition (prototype - dec 15, 1994).md", 0xfde9c, 0x5109736a, BRF_PRG },
};

STD_ROM_PICK(g_deser6)
STD_ROM_FN(g_deser6)

struct BurnDriverD BurnDrvMDg_deser6 = {
	"g_deser6", "g_desert", NULL, "",
	"Desert Demolition (Prototype - Dec 15, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deser6RomInfo, g_deser6RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype - Dec 16, 1994)
static struct BurnRomInfo g_deser7RomDesc[] = {
	{ "desert demolition (prototype - dec 16, 1994).md", 0x100000, 0x573fabfb, BRF_PRG },
};

STD_ROM_PICK(g_deser7)
STD_ROM_FN(g_deser7)

struct BurnDriverD BurnDrvMDg_deser7 = {
	"g_deser7", "g_desert", NULL, "",
	"Desert Demolition (Prototype - Dec 16, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deser7RomInfo, g_deser7RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition (Prototype - Dec 19, 1994)
static struct BurnRomInfo g_deser8RomDesc[] = {
	{ "desert demolition (prototype - dec 19, 1994).md", 0xfde9c, 0xb0ece758, BRF_PRG },
};

STD_ROM_PICK(g_deser8)
STD_ROM_FN(g_deser8)

struct BurnDriverD BurnDrvMDg_deser8 = {
	"g_deser8", "g_desert", NULL, "",
	"Desert Demolition (Prototype - Dec 19, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deser8RomInfo, g_deser8RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Demolition Starring Road Runner and Wile E. Coyote (USA, Europe)
static struct BurnRomInfo g_desertRomDesc[] = {
	{ "desert demolition starring road runner and wile e. coyote (usa, europe).md", 0x100000, 0xc287343d, BRF_PRG },
};

STD_ROM_PICK(g_desert)
STD_ROM_FN(g_desert)

struct BurnDriverD BurnDrvMDg_desert = {
	"g_desert", NULL, NULL, "1900",
	"Desert Demolition Starring Road Runner and Wile E. Coyote (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_desertRomInfo, g_desertRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Strike (Japan, Korea)
static struct BurnRomInfo g_dstrkjRomDesc[] = {
	{ "desert strike (japan, korea).md", 0x100000, 0x1e740145, BRF_PRG },
};

STD_ROM_PICK(g_dstrkj)
STD_ROM_FN(g_dstrkj)

struct BurnDriverD BurnDrvMDg_dstrkj = {
	"g_dstrkj", "g_dstrk", NULL, "",
	"Desert Strike (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dstrkjRomInfo, g_dstrkjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Desert Strike (USA, Europe)
static struct BurnRomInfo g_dstrkRomDesc[] = {
	{ "desert strike (usa, europe).md", 0x100000, 0x67a9860b, BRF_PRG },
};

STD_ROM_PICK(g_dstrk)
STD_ROM_FN(g_dstrk)

struct BurnDriver BurnDrvMDg_dstrk = {
	"g_dstrk", NULL, NULL, "1900",
	"Desert Strike (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dstrkRomInfo, g_dstrkRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Devil Crash MD (Japan)
static struct BurnRomInfo g_devilcRomDesc[] = {
	{ "devil crash md (japan).md", 0x80000, 0x4c4caad8, BRF_PRG },
};

STD_ROM_PICK(g_devilc)
STD_ROM_FN(g_devilc)

struct BurnDriverD BurnDrvMDg_devilc = {
	"g_devilc", NULL, NULL, "1992",
	"Devil Crash MD (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_devilcRomInfo, g_devilcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Devilish - The Next Possession (USA)
static struct BurnRomInfo g_deviliRomDesc[] = {
	{ "devilish - the next possession (usa).md", 0x80000, 0xd3f300ac, BRF_PRG },
};

STD_ROM_PICK(g_devili)
STD_ROM_FN(g_devili)

struct BurnDriverD BurnDrvMDg_devili = {
	"g_devili", NULL, NULL, "1992",
	"Devilish - The Next Possession (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_deviliRomInfo, g_deviliRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dial Q o Mawase! (Japan) (Unl)
static struct BurnRomInfo g_dialqoRomDesc[] = {
	{ "dial q o mawase! (japan) (unl).md", 0x100000, 0xc632e5af, BRF_PRG },
};

STD_ROM_PICK(g_dialqo)
STD_ROM_FN(g_dialqo)

struct BurnDriverD BurnDrvMDg_dialqo = {
	"g_dialqo", NULL, NULL, "",
	"Dial Q o Mawase! (Japan) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dialqoRomInfo, g_dialqoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dick Tracy (World)
static struct BurnRomInfo g_dicktrRomDesc[] = {
	{ "dick tracy (world).md", 0x80000, 0xef887533, BRF_PRG },
};

STD_ROM_PICK(g_dicktr)
STD_ROM_FN(g_dicktr)

struct BurnDriverD BurnDrvMDg_dicktr = {
	"g_dicktr", NULL, NULL, "1900",
	"Dick Tracy (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dicktrRomInfo, g_dicktrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dick Vitale's 'Awesome, Baby!' College Hoops (USA)
static struct BurnRomInfo g_dickviRomDesc[] = {
	{ "dick vitale's 'awesome, baby!' college hoops (usa).md", 0x200000, 0x1312cf22, BRF_PRG },
};

STD_ROM_PICK(g_dickvi)
STD_ROM_FN(g_dickvi)

struct BurnDriverD BurnDrvMDg_dickvi = {
	"g_dickvi", NULL, NULL, "1900",
	"Dick Vitale's 'Awesome, Baby!' College Hoops (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dickviRomInfo, g_dickviRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dino Dini's Soccer (Europe)
static struct BurnRomInfo g_dinodiRomDesc[] = {
	{ "dino dini's soccer (europe).md", 0x100000, 0x4608f53a, BRF_PRG },
};

STD_ROM_PICK(g_dinodi)
STD_ROM_FN(g_dinodi)

struct BurnDriver BurnDrvMDg_dinodi = {
	"g_dinodi", NULL, NULL, "1994",
	"Dino Dini's Soccer (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dinodiRomInfo, g_dinodiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x2000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dino Land (USA)
static struct BurnRomInfo g_dinolaRomDesc[] = {
	{ "dino land (usa).md", 0x80000, 0x5fe351b8, BRF_PRG },
};

STD_ROM_PICK(g_dinola)
STD_ROM_FN(g_dinola)

struct BurnDriverD BurnDrvMDg_dinola = {
	"g_dinola", NULL, NULL, "1900",
	"Dino Land (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dinolaRomInfo, g_dinolaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dinosaur's Tale, A (USA)
static struct BurnRomInfo g_dinosaRomDesc[] = {
	{ "dinosaur's tale, a (usa).md", 0x100000, 0x70155b5b, BRF_PRG },
};

STD_ROM_PICK(g_dinosa)
STD_ROM_FN(g_dinosa)

struct BurnDriverD BurnDrvMDg_dinosa = {
	"g_dinosa", NULL, NULL, "1900",
	"Dinosaur's Tale, A (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dinosaRomInfo, g_dinosaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dinosaurs for Hire (Prototype - Apr 26, 1993)
static struct BurnRomInfo d_hireaRomDesc[] = {
	{ "dinosaurs for hire (prototype - apr 26, 1993).md", 0x100000, 0x54c77d3e, BRF_PRG },
};

STD_ROM_PICK(d_hirea)
STD_ROM_FN(d_hirea)

struct BurnDriver BurnDrvMDd_hirea = {
	"d_hirea", "d_hire", NULL, "1993",
	"Dinosaurs for Hire (Prototype - Apr 26, 1993)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, d_hireaRomInfo, d_hireaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dinosaurs for Hire (Prototype - Apr 27, 1993)
static struct BurnRomInfo d_hirebRomDesc[] = {
	{ "dinosaurs for hire (prototype - apr 27, 1993).md", 0x100000, 0x16000453, BRF_PRG },
};

STD_ROM_PICK(d_hireb)
STD_ROM_FN(d_hireb)

struct BurnDriver BurnDrvMDd_hireb = {
	"d_hireb", "d_hire", NULL, "1993",
	"Dinosaurs for Hire (Prototype - Apr 27, 1993)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, d_hirebRomInfo, d_hirebRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dinosaurs for Hire (Prototype - May 02, 1993)
static struct BurnRomInfo d_hirecRomDesc[] = {
	{ "dinosaurs for hire (prototype - may 02, 1993).md", 0x100000, 0x8954dee9, BRF_PRG },
};

STD_ROM_PICK(d_hirec)
STD_ROM_FN(d_hirec)

struct BurnDriver BurnDrvMDd_hirec = {
	"d_hirec", "d_hire", NULL, "1993",
	"Dinosaurs for Hire (Prototype - May 02, 1993)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, d_hirecRomInfo, d_hirecRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dinosaurs for Hire (USA)
static struct BurnRomInfo d_hireRomDesc[] = {
	{ "dinosaurs for hire (usa).md", 0x100000, 0x39351146, BRF_PRG },
};

STD_ROM_PICK(d_hire)
STD_ROM_FN(d_hire)

struct BurnDriver BurnDrvMDd_hire = {
	"d_hire", NULL, NULL, "1993",
	"Dinosaurs for Hire (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, d_hireRomInfo, d_hireRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Disney Collection, The (Europe)
static struct BurnRomInfo g_disneyRomDesc[] = {
	{ "disney collection, the (europe).md", 0x100000, 0xadfde883, BRF_PRG },
};

STD_ROM_PICK(g_disney)
STD_ROM_FN(g_disney)

struct BurnDriver BurnDrvMDg_disney = {
	"g_disney", NULL, NULL, "1991",
	"Disney Collection, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_disneyRomInfo, g_disneyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Divine Sealing (Japan) (Unl)
static struct BurnRomInfo g_divineRomDesc[] = {
	{ "divine sealing (japan) (unl).md", 0x100000, 0xca72973c, BRF_PRG },
};

STD_ROM_PICK(g_divine)
STD_ROM_FN(g_divine)

struct BurnDriverD BurnDrvMDg_divine = {
	"g_divine", NULL, NULL, "",
	"Divine Sealing (Japan) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_divineRomInfo, g_divineRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// DJ Boy (Europe)
static struct BurnRomInfo g_djboyeRomDesc[] = {
	{ "dj boy (europe).md", 0x80000, 0x860e749a, BRF_PRG },
};

STD_ROM_PICK(g_djboye)
STD_ROM_FN(g_djboye)

struct BurnDriverD BurnDrvMDg_djboye = {
	"g_djboye", NULL, NULL, "1900",
	"DJ Boy (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_djboyeRomInfo, g_djboyeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// DJ Boy (Japan)
static struct BurnRomInfo g_djboyjRomDesc[] = {
	{ "dj boy (japan).md", 0x80000, 0x202abaa8, BRF_PRG },
};

STD_ROM_PICK(g_djboyj)
STD_ROM_FN(g_djboyj)

struct BurnDriverD BurnDrvMDg_djboyj = {
	"g_djboyj", "g_djboye", NULL, "1900",
	"DJ Boy (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_djboyjRomInfo, g_djboyjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// DJ Boy (USA)
static struct BurnRomInfo g_djboyuRomDesc[] = {
	{ "dj boy (usa).md", 0x80000, 0xdc9f02db, BRF_PRG },
};

STD_ROM_PICK(g_djboyu)
STD_ROM_FN(g_djboyu)

struct BurnDriverD BurnDrvMDg_djboyu = {
	"g_djboyu", "g_djboye", NULL, "1900",
	"DJ Boy (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_djboyuRomInfo, g_djboyuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Doki Doki Penguin Land MD (SN) (GNKO) (J) [!]
static struct BurnRomInfo g_dokidoRomDesc[] = {
	{ "doki doki penguin land md (sn) (gnko) (j) [!].md", 0x40000, 0x22736650, BRF_PRG },
};

STD_ROM_PICK(g_dokido)
STD_ROM_FN(g_dokido)

struct BurnDriverD BurnDrvMDg_dokido = {
	"g_dokido", NULL, NULL, "",
	"Doki Doki Penguin Land MD (SN) (GNKO) (J) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dokidoRomInfo, g_dokidoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Domino (Unl)
static struct BurnRomInfo g_dominoRomDesc[] = {
	{ "domino (unl).md", 0x100000, 0xa64409be, BRF_PRG },
};

STD_ROM_PICK(g_domino)
STD_ROM_FN(g_domino)

struct BurnDriverD BurnDrvMDg_domino = {
	"g_domino", NULL, NULL, "",
	"Domino (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dominoRomInfo, g_dominoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dominus (USA) (Proto)
static struct BurnRomInfo g_dominuRomDesc[] = {
	{ "dominus (usa) (proto).md", 0xc0000, 0x30006ebd, BRF_PRG },
};

STD_ROM_PICK(g_dominu)
STD_ROM_FN(g_dominu)

struct BurnDriverD BurnDrvMDg_dominu = {
	"g_dominu", NULL, NULL, "",
	"Dominus (USA) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dominuRomInfo, g_dominuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Donald in Maui Mallard (Europe)
static struct BurnRomInfo g_donaldRomDesc[] = {
	{ "donald in maui mallard (europe).md", 0x300000, 0xb2dd857f, BRF_PRG },
};

STD_ROM_PICK(g_donald)
STD_ROM_FN(g_donald)

struct BurnDriverD BurnDrvMDg_donald = {
	"g_donald", NULL, NULL, "1900",
	"Donald in Maui Mallard (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_donaldRomInfo, g_donaldRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dong Gu Ri Te Chi Jak Jeon (Korea)
static struct BurnRomInfo g_dongguRomDesc[] = {
	{ "dong gu ri te chi jak jeon (korea).md", 0x100000, 0xe32f0b1c, BRF_PRG },
};

STD_ROM_PICK(g_donggu)
STD_ROM_FN(g_donggu)

struct BurnDriverD BurnDrvMDg_donggu = {
	"g_donggu", NULL, NULL, "",
	"Dong Gu Ri Te Chi Jak Jeon (Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dongguRomInfo, g_dongguRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Doom Troopers - The Mutant Chronicles (USA)
static struct BurnRomInfo g_doomtrRomDesc[] = {
	{ "doom troopers - the mutant chronicles (usa).md", 0x200000, 0x11194414, BRF_PRG },
};

STD_ROM_PICK(g_doomtr)
STD_ROM_FN(g_doomtr)

struct BurnDriverD BurnDrvMDg_doomtr = {
	"g_doomtr", NULL, NULL, "1900",
	"Doom Troopers - The Mutant Chronicles (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_doomtrRomInfo, g_doomtrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Doraemon - Yume Dorobou to 7 Nin no Gozans (Japan)
static struct BurnRomInfo g_doraemRomDesc[] = {
	{ "doraemon - yume dorobou to 7 nin no gozans (japan).md", 0x80000, 0xeeed1130, BRF_PRG },
};

STD_ROM_PICK(g_doraem)
STD_ROM_FN(g_doraem)

struct BurnDriverD BurnDrvMDg_doraem = {
	"g_doraem", NULL, NULL, "1900",
	"Doraemon - Yume Dorobou to 7 Nin no Gozans (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_doraemRomInfo, g_doraemRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Clutch (Europe)
static struct BurnRomInfo g_doubleRomDesc[] = {
	{ "double clutch (europe).md", 0x40000, 0xd98c623c, BRF_PRG },
};

STD_ROM_PICK(g_double)
STD_ROM_FN(g_double)

struct BurnDriverD BurnDrvMDg_double = {
	"g_double", NULL, NULL, "1900",
	"Double Clutch (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_doubleRomInfo, g_doubleRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Dragon (USA, Europe)
static struct BurnRomInfo g_ddRomDesc[] = {
	{ "double dragon (usa, europe).md", 0x80000, 0x054f5d53, BRF_PRG },
};

STD_ROM_PICK(g_dd)
STD_ROM_FN(g_dd)

struct BurnDriver BurnDrvMDg_dd = {
	"g_dd", NULL, NULL, "1900",
	"Double Dragon (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ddRomInfo, g_ddRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Dragon 3 - The Arcade Game (USA, Europe)
static struct BurnRomInfo g_dd3RomDesc[] = {
	{ "double dragon 3 - the arcade game (usa, europe).md", 0x100000, 0xb36ab75c, BRF_PRG },
};

STD_ROM_PICK(g_dd3)
STD_ROM_FN(g_dd3)

struct BurnDriverD BurnDrvMDg_dd3 = {
	"g_dd3", NULL, NULL, "1900",
	"Double Dragon 3 - The Arcade Game (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dd3RomInfo, g_dd3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Dragon II - The Revenge (Japan)
static struct BurnRomInfo g_dd2RomDesc[] = {
	{ "double dragon ii - the revenge (japan).md", 0x80000, 0xa8bfdbd6, BRF_PRG },
};

STD_ROM_PICK(g_dd2)
STD_ROM_FN(g_dd2)

struct BurnDriverD BurnDrvMDg_dd2 = {
	"g_dd2", NULL, NULL, "1900",
	"Double Dragon II - The Revenge (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dd2RomInfo, g_dd2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Dragon V - The Shadow Falls (USA)
static struct BurnRomInfo g_dd5RomDesc[] = {
	{ "double dragon v - the shadow falls (usa).md", 0x300000, 0x27e59e35, BRF_PRG },
};

STD_ROM_PICK(g_dd5)
STD_ROM_FN(g_dd5)

struct BurnDriverD BurnDrvMDg_dd5 = {
	"g_dd5", NULL, NULL, "1900",
	"Double Dragon V - The Shadow Falls (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dd5RomInfo, g_dd5RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Double Dribble - The Playoff Edition (USA)
static struct BurnRomInfo g_ddriblRomDesc[] = {
	{ "double dribble - the playoff edition (usa).md", 0x200000, 0x8352b1d0, BRF_PRG },
};

STD_ROM_PICK(g_ddribl)
STD_ROM_FN(g_ddribl)

struct BurnDriverD BurnDrvMDg_ddribl = {
	"g_ddribl", NULL, NULL, "1900",
	"Double Dribble - The Playoff Edition (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ddriblRomInfo, g_ddriblRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dr. Robotnik's Mean Bean Machine (Europe)
static struct BurnRomInfo g_drroboRomDesc[] = {
	{ "dr. robotnik's mean bean machine (europe).md", 0x100000, 0x70680706, BRF_PRG },
};

STD_ROM_PICK(g_drrobo)
STD_ROM_FN(g_drrobo)

struct BurnDriver BurnDrvMDg_drrobo = {
	"g_drrobo", NULL, NULL, "1900",
	"Dr. Robotnik's Mean Bean Machine (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_drroboRomInfo, g_drroboRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dr. Robotnik's Mean Bean Machine (USA) (Beta)
static struct BurnRomInfo g_drrob1RomDesc[] = {
	{ "dr. robotnik's mean bean machine (usa) (beta).md", 0x100000, 0x4d0e5273, BRF_PRG },
};

STD_ROM_PICK(g_drrob1)
STD_ROM_FN(g_drrob1)

struct BurnDriver BurnDrvMDg_drrob1 = {
	"g_drrob1", "g_drrobo", NULL, "1900",
	"Dr. Robotnik's Mean Bean Machine (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_drrob1RomInfo, g_drrob1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dr. Robotnik's Mean Bean Machine (USA)
static struct BurnRomInfo g_drrob2RomDesc[] = {
	{ "dr. robotnik's mean bean machine (usa).md", 0x100000, 0xc7ca517f, BRF_PRG },
};

STD_ROM_PICK(g_drrob2)
STD_ROM_FN(g_drrob2)

struct BurnDriver BurnDrvMDg_drrob2 = {
	"g_drrob2", "g_drrobo", NULL, "1900",
	"Dr. Robotnik's Mean Bean Machine (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_drrob2RomInfo, g_drrob2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon - The Bruce Lee Story (Europe)
static struct BurnRomInfo g_dragonRomDesc[] = {
	{ "dragon - the bruce lee story (europe).md", 0x200000, 0xfdeed51d, BRF_PRG },
};

STD_ROM_PICK(g_dragon)
STD_ROM_FN(g_dragon)

struct BurnDriverD BurnDrvMDg_dragon = {
	"g_dragon", NULL, NULL, "1900",
	"Dragon - The Bruce Lee Story (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dragonRomInfo, g_dragonRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon - The Bruce Lee Story (USA)
static struct BurnRomInfo g_drago1RomDesc[] = {
	{ "dragon - the bruce lee story (usa).md", 0x200000, 0xefe850e5, BRF_PRG },
};

STD_ROM_PICK(g_drago1)
STD_ROM_FN(g_drago1)

struct BurnDriverD BurnDrvMDg_drago1 = {
	"g_drago1", "g_dragon", NULL, "1900",
	"Dragon - The Bruce Lee Story (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_drago1RomInfo, g_drago1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon Ball Z - Buyuu Retsuden (Japan)
static struct BurnRomInfo g_dbzRomDesc[] = {
	{ "dragon ball z - buyuu retsuden (japan).md", 0x200000, 0xaf8f3371, BRF_PRG },
};

STD_ROM_PICK(g_dbz)
STD_ROM_FN(g_dbz)

struct BurnDriverD BurnDrvMDg_dbz = {
	"g_dbz", NULL, NULL, "1900",
	"Dragon Ball Z - Buyuu Retsuden (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dbzRomInfo, g_dbzRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon Ball Z - L'Appel du Destin (France)
static struct BurnRomInfo g_dbzfRomDesc[] = {
	{ "dragon ball z - l'appel du destin (france).md", 0x200000, 0xf035c737, BRF_PRG },
};

STD_ROM_PICK(g_dbzf)
STD_ROM_FN(g_dbzf)

struct BurnDriverD BurnDrvMDg_dbzf = {
	"g_dbzf", "g_dbz", NULL, "1900",
	"Dragon Ball Z - L'Appel du Destin (France)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dbzfRomInfo, g_dbzfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon Slayer - Eiyuu Densetsu (Japan)
static struct BurnRomInfo g_dslayRomDesc[] = {
	{ "dragon slayer - eiyuu densetsu (japan).md", 0x200000, 0x01bc1604, BRF_PRG },
};

STD_ROM_PICK(g_dslay)
STD_ROM_FN(g_dslay)

struct BurnDriverD BurnDrvMDg_dslay = {
	"g_dslay", NULL, NULL, "",
	"Dragon Slayer - Eiyuu Densetsu (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dslayRomInfo, g_dslayRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon Slayer - Eiyuu Densetsu II (Japan)
static struct BurnRomInfo g_dslay2RomDesc[] = {
	{ "dragon slayer - eiyuu densetsu ii (japan).md", 0x200000, 0x46924dc3, BRF_PRG },
};

STD_ROM_PICK(g_dslay2)
STD_ROM_FN(g_dslay2)

struct BurnDriverD BurnDrvMDg_dslay2 = {
	"g_dslay2", NULL, NULL, "",
	"Dragon Slayer - Eiyuu Densetsu II (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dslay2RomInfo, g_dslay2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon's Eye Plus - Shanghai III (Japan)
static struct BurnRomInfo g_shai3RomDesc[] = {
	{ "dragon's eye plus - shanghai iii (japan).md", 0x40000, 0x81f0c3cf, BRF_PRG },
};

STD_ROM_PICK(g_shai3)
STD_ROM_FN(g_shai3)

struct BurnDriverD BurnDrvMDg_shai3 = {
	"g_shai3", NULL, NULL, "1900",
	"Dragon's Eye Plus - Shanghai III (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_shai3RomInfo, g_shai3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon's Fury (USA, Europe)
static struct BurnRomInfo g_dfuryRomDesc[] = {
	{ "dragon's fury (usa, europe).md", 0x80000, 0x58037bc6, BRF_PRG },
};

STD_ROM_PICK(g_dfury)
STD_ROM_FN(g_dfury)

struct BurnDriverD BurnDrvMDg_dfury = {
	"g_dfury", NULL, NULL, "1992",
	"Dragon's Fury (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dfuryRomInfo, g_dfuryRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dragon's Revenge (USA, Europe)
static struct BurnRomInfo g_dragrvRomDesc[] = {
	{ "dragon's revenge (usa, europe).md", 0x100000, 0x841edbc0, BRF_PRG },
};

STD_ROM_PICK(g_dragrv)
STD_ROM_FN(g_dragrv)

struct BurnDriverD BurnDrvMDg_dragrv = {
	"g_dragrv", NULL, NULL, "1900",
	"Dragon's Revenge (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dragrvRomInfo, g_dragrvRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dream Team USA (Japan)
static struct BurnRomInfo g_dreamtRomDesc[] = {
	{ "dream team usa (japan).md", 0x100000, 0xe2e21b72, BRF_PRG },
};

STD_ROM_PICK(g_dreamt)
STD_ROM_FN(g_dreamt)

struct BurnDriverD BurnDrvMDg_dreamt = {
	"g_dreamt", "g_teamus", NULL, "1900",
	"Dream Team USA (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dreamtRomInfo, g_dreamtRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Duke Nukem 3D (Brazil)
static struct BurnRomInfo g_dukenuRomDesc[] = {
	{ "duke nukem 3d (brazil).md", 0x400000, 0x6bd2accb, BRF_PRG },
};

STD_ROM_PICK(g_dukenu)
STD_ROM_FN(g_dukenu)

struct BurnDriver BurnDrvMDg_dukenu = {
	"g_dukenu", NULL, NULL, "1900",
	"Duke Nukem 3D (Brazil)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dukenuRomInfo, g_dukenuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dune - The Battle for Arrakis (USA)
static struct BurnRomInfo g_dunethRomDesc[] = {
	{ "dune - the battle for arrakis (usa).md", 0x100000, 0x4dea40ba, BRF_PRG },
};

STD_ROM_PICK(g_duneth)
STD_ROM_FN(g_duneth)

struct BurnDriverD BurnDrvMDg_duneth = {
	"g_duneth", "g_dune2a", NULL, "1900",
	"Dune - The Battle for Arrakis (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dunethRomInfo, g_dunethRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dune II - Kampf um den Wustenplaneten (Germany)
static struct BurnRomInfo g_dune2RomDesc[] = {
	{ "dune ii - kampf um den wustenplaneten (germany).md", 0x100000, 0x39790728, BRF_PRG },
};

STD_ROM_PICK(g_dune2)
STD_ROM_FN(g_dune2)

struct BurnDriverD BurnDrvMDg_dune2 = {
	"g_dune2", "g_dune2a", NULL, "1900",
	"Dune II - Kampf um den Wustenplaneten (Germany)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dune2RomInfo, g_dune2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dune II - The Battle for Arrakis (Europe)
static struct BurnRomInfo g_dune2aRomDesc[] = {
	{ "dune ii - the battle for arrakis (europe).md", 0x100000, 0xb58ae71d, BRF_PRG },
};

STD_ROM_PICK(g_dune2a)
STD_ROM_FN(g_dune2a)

struct BurnDriverD BurnDrvMDg_dune2a = {
	"g_dune2a", NULL, NULL, "1900",
	"Dune II - The Battle for Arrakis (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dune2aRomInfo, g_dune2aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dungeons & Dragons - Warriors of the Eternal Sun (USA, Europe)
static struct BurnRomInfo g_dungeoRomDesc[] = {
	{ "dungeons & dragons - warriors of the eternal sun (usa, europe).md", 0x100000, 0xaf4a9cd7, BRF_PRG },
};

STD_ROM_PICK(g_dungeo)
STD_ROM_FN(g_dungeo)

struct BurnDriver BurnDrvMDg_dungeo = {
	"g_dungeo", NULL, NULL, "1900",
	"Dungeons & Dragons - Warriors of the Eternal Sun (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dungeoRomInfo, g_dungeoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dyna Brothers (Japan)
static struct BurnRomInfo g_dynabrRomDesc[] = {
	{ "dyna brothers (japan).md", 0x100000, 0x360c1b20, BRF_PRG },
};

STD_ROM_PICK(g_dynabr)
STD_ROM_FN(g_dynabr)

struct BurnDriverD BurnDrvMDg_dynabr = {
	"g_dynabr", NULL, NULL, "",
	"Dyna Brothers (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dynabrRomInfo, g_dynabrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dyna Brothers 2 (Japan)
static struct BurnRomInfo g_dyna2RomDesc[] = {
	{ "dyna brothers 2 (japan).md", 0x200000, 0x47e0a64e, BRF_PRG },
};

STD_ROM_PICK(g_dyna2)
STD_ROM_FN(g_dyna2)

struct BurnDriverD BurnDrvMDg_dyna2 = {
	"g_dyna2", NULL, NULL, "1900",
	"Dyna Brothers 2 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dyna2RomInfo, g_dyna2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Duke (World) (Rev A)
static struct BurnRomInfo g_dynamiRomDesc[] = {
	{ "dynamite duke (world) (rev a).md", 0x80000, 0x246f0bda, BRF_PRG },
};

STD_ROM_PICK(g_dynami)
STD_ROM_FN(g_dynami)

struct BurnDriverD BurnDrvMDg_dynami = {
	"g_dynami", NULL, NULL, "1900",
	"Dynamite Duke (World) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dynamiRomInfo, g_dynamiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Duke (World)
static struct BurnRomInfo g_dynam1RomDesc[] = {
	{ "dynamite duke (world).md", 0x80000, 0x39d01c8c, BRF_PRG },
};

STD_ROM_PICK(g_dynam1)
STD_ROM_FN(g_dynam1)

struct BurnDriverD BurnDrvMDg_dynam1 = {
	"g_dynam1", "g_dynami", NULL, "1900",
	"Dynamite Duke (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dynam1RomInfo, g_dynam1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Japan) (Beta)
static struct BurnRomInfo g_dheadaRomDesc[] = {
	{ "dynamite headdy (japan) (beta).md", 0x200000, 0x5c25e934, BRF_PRG },
};

STD_ROM_PICK(g_dheada)
STD_ROM_FN(g_dheada)

struct BurnDriverD BurnDrvMDg_dheada = {
	"g_dheada", "g_dhead", NULL, "1900",
	"Dynamite Headdy (Japan) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dheadaRomInfo, g_dheadaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Japan)
static struct BurnRomInfo g_dheadjRomDesc[] = {
	{ "dynamite headdy (japan).md", 0x200000, 0xd03cdb53, BRF_PRG },
};

STD_ROM_PICK(g_dheadj)
STD_ROM_FN(g_dheadj)

struct BurnDriverD BurnDrvMDg_dheadj = {
	"g_dheadj", "g_dhead", NULL, "1900",
	"Dynamite Headdy (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dheadjRomInfo, g_dheadjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Prototype - Jun 14, 1994 - CABEZA)
static struct BurnRomInfo g_dheadbRomDesc[] = {
	{ "dynamite headdy (prototype - jun 14, 1994 - cabeza).md", 0x200000, 0x971ef24c, BRF_PRG },
};

STD_ROM_PICK(g_dheadb)
STD_ROM_FN(g_dheadb)

struct BurnDriverD BurnDrvMDg_dheadb = {
	"g_dheadb", "g_dhead", NULL, "",
	"Dynamite Headdy (Prototype - Jun 14, 1994 - CABEZA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dheadbRomInfo, g_dheadbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Prototype - Jun 15, 1994)
static struct BurnRomInfo g_dheadcRomDesc[] = {
	{ "dynamite headdy (prototype - jun 15, 1994).md", 0x200000, 0x971ef24c, BRF_PRG },
};

STD_ROM_PICK(g_dheadc)
STD_ROM_FN(g_dheadc)

struct BurnDriverD BurnDrvMDg_dheadc = {
	"g_dheadc", "g_dhead", NULL, "",
	"Dynamite Headdy (Prototype - Jun 15, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dheadcRomInfo, g_dheadcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Prototype - Jun 16, 1994)
static struct BurnRomInfo g_dheaddRomDesc[] = {
	{ "dynamite headdy (prototype - jun 16, 1994).md", 0x200000, 0xf8a96719, BRF_PRG },
};

STD_ROM_PICK(g_dheadd)
STD_ROM_FN(g_dheadd)

struct BurnDriverD BurnDrvMDg_dheadd = {
	"g_dheadd", "g_dhead", NULL, "",
	"Dynamite Headdy (Prototype - Jun 16, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dheaddRomInfo, g_dheaddRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (Prototype - Jun 22, 1994)
static struct BurnRomInfo g_dheadeRomDesc[] = {
	{ "dynamite headdy (prototype - jun 22, 1994).md", 0x200000, 0x61001ec8, BRF_PRG },
};

STD_ROM_PICK(g_dheade)
STD_ROM_FN(g_dheade)

struct BurnDriverD BurnDrvMDg_dheade = {
	"g_dheade", "g_dhead", NULL, "",
	"Dynamite Headdy (Prototype - Jun 22, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dheadeRomInfo, g_dheadeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Dynamite Headdy (USA, Europe)
static struct BurnRomInfo g_dheadRomDesc[] = {
	{ "dynamite headdy (usa, europe).md", 0x200000, 0x3dfeeb77, BRF_PRG },
};

STD_ROM_PICK(g_dhead)
STD_ROM_FN(g_dhead)

struct BurnDriverD BurnDrvMDg_dhead = {
	"g_dhead", NULL, NULL, "1900",
	"Dynamite Headdy (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_dheadRomInfo, g_dheadRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// EA Hockey (Europe)
static struct BurnRomInfo g_eahockRomDesc[] = {
	{ "ea hockey (europe).md", 0x80000, 0x9bfc279c, BRF_PRG },
};

STD_ROM_PICK(g_eahock)
STD_ROM_FN(g_eahock)

struct BurnDriver BurnDrvMDg_eahock = {
	"g_eahock", NULL, NULL, "1900",
	"EA Hockey (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_eahockRomInfo, g_eahockRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// EA Hockey (Japan)
static struct BurnRomInfo g_eahoc1RomDesc[] = {
	{ "ea hockey (japan).md", 0x80000, 0x9dcdc894, BRF_PRG },
};

STD_ROM_PICK(g_eahoc1)
STD_ROM_FN(g_eahoc1)

struct BurnDriver BurnDrvMDg_eahoc1 = {
	"g_eahoc1", "g_eahock", NULL, "1900",
	"EA Hockey (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_eahoc1RomInfo, g_eahoc1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// EA Sports Double Header (Europe)
static struct BurnRomInfo g_easporRomDesc[] = {
	{ "ea sports double header (europe).md", 0x100000, 0xa0b54cbc, BRF_PRG },
};

STD_ROM_PICK(g_easpor)
STD_ROM_FN(g_easpor)

struct BurnDriver BurnDrvMDg_easpor = {
	"g_easpor", NULL, NULL, "1900",
	"EA Sports Double Header (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_easporRomInfo, g_easporRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Earnest Evans (USA)
static struct BurnRomInfo g_earnesRomDesc[] = {
	{ "earnest evans (usa).md", 0x100000, 0xa243816d, BRF_PRG },
};

STD_ROM_PICK(g_earnes)
STD_ROM_FN(g_earnes)

struct BurnDriverD BurnDrvMDg_earnes = {
	"g_earnes", NULL, NULL, "1900",
	"Earnest Evans (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_earnesRomInfo, g_earnesRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Earth Defense (USA) (Unl)
static struct BurnRomInfo g_earthdRomDesc[] = {
	{ "earth defense (usa) (unl).md", 0x80000, 0x3519c422, BRF_PRG },
};

STD_ROM_PICK(g_earthd)
STD_ROM_FN(g_earthd)

struct BurnDriverD BurnDrvMDg_earthd = {
	"g_earthd", NULL, NULL, "",
	"Earth Defense (USA) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_earthdRomInfo, g_earthdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Earthworm Jim (Europe)
static struct BurnRomInfo g_ejimRomDesc[] = {
	{ "earthworm jim (europe).md", 0x300000, 0x1c07b337, BRF_PRG },
};

STD_ROM_PICK(g_ejim)
STD_ROM_FN(g_ejim)

struct BurnDriver BurnDrvMDg_ejim = {
	"g_ejim", NULL, NULL, "1900",
	"Earthworm Jim (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ejimRomInfo, g_ejimRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Earthworm Jim (USA)
static struct BurnRomInfo g_ejimuRomDesc[] = {
	{ "earthworm jim (usa).md", 0x300000, 0xdf3acf59, BRF_PRG },
};

STD_ROM_PICK(g_ejimu)
STD_ROM_FN(g_ejimu)

struct BurnDriver BurnDrvMDg_ejimu = {
	"g_ejimu", "g_ejim", NULL, "1900",
	"Earthworm Jim (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ejimuRomInfo, g_ejimuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Earthworm Jim 2 (Europe)
static struct BurnRomInfo g_ejim2RomDesc[] = {
	{ "earthworm jim 2 (europe).md", 0x300000, 0xaf235fdf, BRF_PRG },
};

STD_ROM_PICK(g_ejim2)
STD_ROM_FN(g_ejim2)

struct BurnDriver BurnDrvMDg_ejim2 = {
	"g_ejim2", NULL, NULL, "1900",
	"Earthworm Jim 2 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ejim2RomInfo, g_ejim2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Earthworm Jim 2 (USA)
static struct BurnRomInfo g_ejim2uRomDesc[] = {
	{ "earthworm jim 2 (usa).md", 0x300000, 0xd57f8ba7, BRF_PRG },
};

STD_ROM_PICK(g_ejim2u)
STD_ROM_FN(g_ejim2u)

struct BurnDriver BurnDrvMDg_ejim2u = {
	"g_ejim2u", "g_ejim2", NULL, "1900",
	"Earthworm Jim 2 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ejim2uRomInfo, g_ejim2uRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco - The Tides of Time (Beta)
static struct BurnRomInfo g_ecco2bRomDesc[] = {
	{ "ecco - the tides of time (beta).md", 0x200000, 0x1d1470ea, BRF_PRG },
};

STD_ROM_PICK(g_ecco2b)
STD_ROM_FN(g_ecco2b)

struct BurnDriver BurnDrvMDg_ecco2b = {
	"g_ecco2b", "g_ecco2", NULL, "1994",
	"Ecco - The Tides of Time (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ecco2bRomInfo, g_ecco2bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco - The Tides of Time (Europe)
static struct BurnRomInfo g_ecco2RomDesc[] = {
	{ "ecco - the tides of time (europe).md", 0x200000, 0x7b1bf89c, BRF_PRG },
};

STD_ROM_PICK(g_ecco2)
STD_ROM_FN(g_ecco2)

struct BurnDriver BurnDrvMDg_ecco2 = {
	"g_ecco2", NULL, NULL, "1994",
	"Ecco - The Tides of Time (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ecco2RomInfo, g_ecco2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco - The Tides of Time (Prototype X11 - Apr 13, 1994)
static struct BurnRomInfo g_ecco2xRomDesc[] = {
	{ "ecco - the tides of time (prototype x11 - apr 13, 1994).md", 0x200000, 0xb5d64817, BRF_PRG },
};

STD_ROM_PICK(g_ecco2x)
STD_ROM_FN(g_ecco2x)

struct BurnDriverD BurnDrvMDg_ecco2x = {
	"g_ecco2x", "g_ecco2", NULL, "",
	"Ecco - The Tides of Time (Prototype X11 - Apr 13, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ecco2xRomInfo, g_ecco2xRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco - The Tides of Time (USA) (Beta)
static struct BurnRomInfo g_ecco2pRomDesc[] = {
	{ "ecco - the tides of time (usa) (beta).md", 0x200000, 0x8db60749, BRF_PRG },
};

STD_ROM_PICK(g_ecco2p)
STD_ROM_FN(g_ecco2p)

struct BurnDriverD BurnDrvMDg_ecco2p = {
	"g_ecco2p", "g_ecco2", NULL, "",
	"Ecco - The Tides of Time (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ecco2pRomInfo, g_ecco2pRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco - The Tides of Time (USA)
static struct BurnRomInfo g_ecco2uRomDesc[] = {
	{ "ecco - the tides of time (usa).md", 0x200000, 0xccb21f98, BRF_PRG },
};

STD_ROM_PICK(g_ecco2u)
STD_ROM_FN(g_ecco2u)

struct BurnDriver BurnDrvMDg_ecco2u = {
	"g_ecco2u", "g_ecco2", NULL, "1994",
	"Ecco - The Tides of Time (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ecco2uRomInfo, g_ecco2uRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco Jr. (USA, Australia) (February 1995)
static struct BurnRomInfo g_eccojrRomDesc[] = {
	{ "ecco jr. (usa, australia) (february 1995).md", 0x100000, 0x6c6f4b89, BRF_PRG },
};

STD_ROM_PICK(g_eccojr)
STD_ROM_FN(g_eccojr)

struct BurnDriver BurnDrvMDg_eccojr = {
	"g_eccojr", NULL, NULL, "1995",
	"Ecco Jr. (USA, Australia) (February 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_eccojrRomInfo, g_eccojrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco Jr. (USA, Australia) (March 1995)
static struct BurnRomInfo g_eccoj1RomDesc[] = {
	{ "ecco jr. (usa, australia) (march 1995).md", 0x100000, 0x3c517975, BRF_PRG },
};

STD_ROM_PICK(g_eccoj1)
STD_ROM_FN(g_eccoj1)

struct BurnDriver BurnDrvMDg_eccoj1 = {
	"g_eccoj1", "g_eccojr", NULL, "1995",
	"Ecco Jr. (USA, Australia) (March 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_eccoj1RomInfo, g_eccoj1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco the Dolphin (Japan)
static struct BurnRomInfo g_eccojRomDesc[] = {
	{ "ecco the dolphin (japan).md", 0x100000, 0x6520304d, BRF_PRG },
};

STD_ROM_PICK(g_eccoj)
STD_ROM_FN(g_eccoj)

struct BurnDriver BurnDrvMDg_eccoj = {
	"g_eccoj", "g_ecco", NULL, "199?",
	"Ecco the Dolphin (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_eccojRomInfo, g_eccojRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco the Dolphin (USA, Europe)
static struct BurnRomInfo g_eccoRomDesc[] = {
	{ "ecco the dolphin (usa, europe).md", 0x100000, 0x45547390, BRF_PRG },
};

STD_ROM_PICK(g_ecco)
STD_ROM_FN(g_ecco)

struct BurnDriver BurnDrvMDg_ecco = {
	"g_ecco", NULL, NULL, "19??",
	"Ecco the Dolphin (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_eccoRomInfo, g_eccoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ecco the Dolphin II (Japan)
static struct BurnRomInfo g_ecco2jRomDesc[] = {
	{ "ecco the dolphin ii (japan).md", 0x200000, 0x062d439c, BRF_PRG },
};

STD_ROM_PICK(g_ecco2j)
STD_ROM_FN(g_ecco2j)

struct BurnDriver BurnDrvMDg_ecco2j = {
	"g_ecco2j", "g_ecco2", NULL, "1994",
	"Ecco the Dolphin II (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ecco2jRomInfo, g_ecco2jRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// El Viento (Japan)
static struct BurnRomInfo g_elvinjRomDesc[] = {
	{ "el viento (japan).md", 0x100000, 0x6091c36e, BRF_PRG },
};

STD_ROM_PICK(g_elvinj)
STD_ROM_FN(g_elvinj)

struct BurnDriver BurnDrvMDg_elvinj = {
	"g_elvinj", "g_elvin", NULL, "1991",
	"El Viento (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_elvinjRomInfo, g_elvinjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// El Viento (USA)
static struct BurnRomInfo g_elvinRomDesc[] = {
	{ "el viento (usa).md", 0x100000, 0x070a1ceb, BRF_PRG },
};

STD_ROM_PICK(g_elvin)
STD_ROM_FN(g_elvin)

struct BurnDriver BurnDrvMDg_elvin = {
	"g_elvin", NULL, NULL, "1991",
	"El Viento (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_elvinRomInfo, g_elvinRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Elemental Master (Japan)
static struct BurnRomInfo g_elemsjRomDesc[] = {
	{ "elemental master (japan).md", 0x80000, 0x5f553e29, BRF_PRG },
};

STD_ROM_PICK(g_elemsj)
STD_ROM_FN(g_elemsj)

struct BurnDriver BurnDrvMDg_elemsj = {
	"g_elemsj", "g_elems", NULL, "1990",
	"Elemental Master (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 1, HARDWARE_SEGA_MEGADRIVE, GBF_VERSHOOT, 0,
	NULL, g_elemsjRomInfo, g_elemsjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Elemental Master (USA)
static struct BurnRomInfo g_elemsRomDesc[] = {
	{ "elemental master (usa).md", 0x80000, 0x390918c6, BRF_PRG },
};

STD_ROM_PICK(g_elems)
STD_ROM_FN(g_elems)

struct BurnDriver BurnDrvMDg_elems = {
	"g_elems", NULL, NULL, "1993",
	"Elemental Master (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 1, HARDWARE_SEGA_MEGADRIVE, GBF_VERSHOOT, 0,
	NULL, g_elemsRomInfo, g_elemsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Elf Wor (China) (Unl)
static struct BurnRomInfo g_elfworRomDesc[] = {
	{ "elf wor (china) (unl).md", 0x100000, 0xe24ac6b2, BRF_PRG },
};

STD_ROM_PICK(g_elfwor)
STD_ROM_FN(g_elfwor)

struct BurnDriverD BurnDrvMDg_elfwor = {
	"g_elfwor", NULL, NULL, "",
	"Elf Wor (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_elfworRomInfo, g_elfworRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eliminate Down (Japan)
static struct BurnRomInfo g_eliminRomDesc[] = {
	{ "eliminate down (japan).md", 0x100000, 0x48467542, BRF_PRG },
};

STD_ROM_PICK(g_elimin)
STD_ROM_FN(g_elimin)

struct BurnDriver BurnDrvMDg_elimin = {
	"g_elimin", NULL, NULL, "1993",
	"Eliminate Down (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_HORSHOOT, 0,
	NULL, g_eliminRomInfo, g_eliminRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Elitserien 95 (Sweden)
static struct BurnRomInfo g_elit95RomDesc[] = {
	{ "elitserien 95 (sweden).md", 0x200000, 0xe10a25c0, BRF_PRG },
};

STD_ROM_PICK(g_elit95)
STD_ROM_FN(g_elit95)

struct BurnDriver BurnDrvMDg_elit95 = {
	"g_elit95", NULL, NULL, "1900",
	"Elitserien 95 (Sweden)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_elit95RomInfo, g_elit95RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Elitserien 96 (Sweden)
static struct BurnRomInfo g_elit96RomDesc[] = {
	{ "elitserien 96 (sweden).md", 0x200000, 0x9821d0a3, BRF_PRG },
};

STD_ROM_PICK(g_elit96)
STD_ROM_FN(g_elit96)

struct BurnDriver BurnDrvMDg_elit96 = {
	"g_elit96", NULL, NULL, "1900",
	"Elitserien 96 (Sweden)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_elit96RomInfo, g_elit96RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Empire of Steel (Europe)
static struct BurnRomInfo g_empireRomDesc[] = {
	{ "empire of steel (europe).md", 0x100000, 0xe5517b77, BRF_PRG },
};

STD_ROM_PICK(g_empire)
STD_ROM_FN(g_empire)

struct BurnDriverD BurnDrvMDg_empire = {
	"g_empire", NULL, NULL, "1994",
	"Empire of Steel (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_empireRomInfo, g_empireRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype - Apr 18, 1994)
static struct BurnRomInfo g_tazemaRomDesc[] = {
	{ "taz in escape from mars (prototype - apr 18, 1994).md", 0x200000, 0xbfa776ec, BRF_PRG },
};

STD_ROM_PICK(g_tazema)
STD_ROM_FN(g_tazema)

struct BurnDriverD BurnDrvMDg_tazema = {
	"g_tazema", "g_tazem", NULL, "",
	"Taz in Escape from Mars (Prototype - Apr 18, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tazemaRomInfo, g_tazemaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype - Jun 02, 1994)
static struct BurnRomInfo g_tazembRomDesc[] = {
	{ "taz in escape from mars (prototype - jun 02, 1994).md", 0x200000, 0x39f345c2, BRF_PRG },
};

STD_ROM_PICK(g_tazemb)
STD_ROM_FN(g_tazemb)

struct BurnDriverD BurnDrvMDg_tazemb = {
	"g_tazemb", "g_tazem", NULL, "",
	"Taz in Escape from Mars (Prototype - Jun 02, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tazembRomInfo, g_tazembRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype - Jun 07, 1994)
static struct BurnRomInfo g_tazemcRomDesc[] = {
	{ "taz in escape from mars (prototype - jun 07, 1994).md", 0x200000, 0x3481e709, BRF_PRG },
};

STD_ROM_PICK(g_tazemc)
STD_ROM_FN(g_tazemc)

struct BurnDriverD BurnDrvMDg_tazemc = {
	"g_tazemc", "g_tazem", NULL, "",
	"Taz in Escape from Mars (Prototype - Jun 07, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tazemcRomInfo, g_tazemcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype - Jun 10, 1994)
static struct BurnRomInfo g_tazemdRomDesc[] = {
	{ "taz in escape from mars (prototype - jun 10, 1994).md", 0x200000, 0x832f4cb4, BRF_PRG },
};

STD_ROM_PICK(g_tazemd)
STD_ROM_FN(g_tazemd)

struct BurnDriverD BurnDrvMDg_tazemd = {
	"g_tazemd", "g_tazem", NULL, "",
	"Taz in Escape from Mars (Prototype - Jun 10, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tazemdRomInfo, g_tazemdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype - Jun 14, 1994)
static struct BurnRomInfo g_tazemeRomDesc[] = {
	{ "taz in escape from mars (prototype - jun 14, 1994).md", 0x200000, 0x2badb65b, BRF_PRG },
};

STD_ROM_PICK(g_tazeme)
STD_ROM_FN(g_tazeme)

struct BurnDriverD BurnDrvMDg_tazeme = {
	"g_tazeme", "g_tazem", NULL, "",
	"Taz in Escape from Mars (Prototype - Jun 14, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tazemeRomInfo, g_tazemeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype - Jun 18, 1994 - A)
static struct BurnRomInfo g_tazemfRomDesc[] = {
	{ "taz in escape from mars (prototype - jun 18, 1994 - a).md", 0x200000, 0x3c4b1e9c, BRF_PRG },
};

STD_ROM_PICK(g_tazemf)
STD_ROM_FN(g_tazemf)

struct BurnDriverD BurnDrvMDg_tazemf = {
	"g_tazemf", "g_tazem", NULL, "",
	"Taz in Escape from Mars (Prototype - Jun 18, 1994 - A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tazemfRomInfo, g_tazemfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype - Jun 20, 1994)
static struct BurnRomInfo g_tazemgRomDesc[] = {
	{ "taz in escape from mars (prototype - jun 20, 1994).md", 0x200000, 0xf00f4203, BRF_PRG },
};

STD_ROM_PICK(g_tazemg)
STD_ROM_FN(g_tazemg)

struct BurnDriverD BurnDrvMDg_tazemg = {
	"g_tazemg", "g_tazem", NULL, "",
	"Taz in Escape from Mars (Prototype - Jun 20, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tazemgRomInfo, g_tazemgRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype - Mar 09, 1994)
static struct BurnRomInfo g_tazemhRomDesc[] = {
	{ "taz in escape from mars (prototype - mar 09, 1994).md", 0x1d9936, 0xe3c2271e, BRF_PRG },
};

STD_ROM_PICK(g_tazemh)
STD_ROM_FN(g_tazemh)

struct BurnDriverD BurnDrvMDg_tazemh = {
	"g_tazemh", "g_tazem", NULL, "",
	"Taz in Escape from Mars (Prototype - Mar 09, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tazemhRomInfo, g_tazemhRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype - May 09, 1994)
static struct BurnRomInfo g_tazemiRomDesc[] = {
	{ "taz in escape from mars (prototype - may 09, 1994).md", 0x200000, 0x11727086, BRF_PRG },
};

STD_ROM_PICK(g_tazemi)
STD_ROM_FN(g_tazemi)

struct BurnDriverD BurnDrvMDg_tazemi = {
	"g_tazemi", "g_tazem", NULL, "",
	"Taz in Escape from Mars (Prototype - May 09, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tazemiRomInfo, g_tazemiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype - May 18, 1994)
static struct BurnRomInfo g_tazemjRomDesc[] = {
	{ "taz in escape from mars (prototype - may 18, 1994).md", 0xb9584, 0x6e2666de, BRF_PRG },
};

STD_ROM_PICK(g_tazemj)
STD_ROM_FN(g_tazemj)

struct BurnDriverD BurnDrvMDg_tazemj = {
	"g_tazemj", "g_tazem", NULL, "",
	"Taz in Escape from Mars (Prototype - May 18, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tazemjRomInfo, g_tazemjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Taz in Escape from Mars (Prototype - May 23, 1994)
static struct BurnRomInfo g_tazemkRomDesc[] = {
	{ "taz in escape from mars (prototype - may 23, 1994).md", 0x200000, 0xea344fd2, BRF_PRG },
};

STD_ROM_PICK(g_tazemk)
STD_ROM_FN(g_tazemk)

struct BurnDriverD BurnDrvMDg_tazemk = {
	"g_tazemk", "g_tazem", NULL, "",
	"Taz in Escape from Mars (Prototype - May 23, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tazemkRomInfo, g_tazemkRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN Baseball Tonight (USA)
static struct BurnRomInfo g_espnbaRomDesc[] = {
	{ "espn baseball tonight (usa).md", 0x200000, 0x96d8440c, BRF_PRG },
};

STD_ROM_PICK(g_espnba)
STD_ROM_FN(g_espnba)

struct BurnDriver BurnDrvMDg_espnba = {
	"g_espnba", NULL, NULL, "1994",
	"ESPN Baseball Tonight (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_espnbaRomInfo, g_espnbaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN National Hockey Night (USA) (Beta)
static struct BurnRomInfo g_esphnaRomDesc[] = {
	{ "espn national hockey night (usa) (beta).md", 0x200000, 0xa427814a, BRF_PRG },
};

STD_ROM_PICK(g_esphna)
STD_ROM_FN(g_esphna)

struct BurnDriverD BurnDrvMDg_esphna = {
	"g_esphna", "g_esphn", NULL, "1994",
	"ESPN National Hockey Night (USA) (Beta)\0", "Gfx Problems", "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_esphnaRomInfo, g_esphnaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN National Hockey Night (USA)
static struct BurnRomInfo g_esphnRomDesc[] = {
	{ "espn national hockey night (usa).md", 0x200000, 0x1d08828c, BRF_PRG },
};

STD_ROM_PICK(g_esphn)
STD_ROM_FN(g_esphn)

struct BurnDriverD BurnDrvMDg_esphn = {
	"g_esphn", NULL, NULL, "1994",
	"ESPN National Hockey Night (USA)\0", "Gfx Problems", "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_esphnRomInfo, g_esphnRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN Speed World (USA) (Beta)
static struct BurnRomInfo g_espspbRomDesc[] = {
	{ "espn speed world (usa) (beta).md", 0x200000, 0xab12849a, BRF_PRG },
};

STD_ROM_PICK(g_espspb)
STD_ROM_FN(g_espspb)

struct BurnDriverD BurnDrvMDg_espspb = {
	"g_espspb", "g_espsp", NULL, "",
	"ESPN Speed World (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_espspbRomInfo, g_espspbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN Speed World (USA)
static struct BurnRomInfo g_espspRomDesc[] = {
	{ "espn speed world (usa).md", 0x200000, 0xf50be478, BRF_PRG },
};

STD_ROM_PICK(g_espsp)
STD_ROM_FN(g_espsp)

struct BurnDriver BurnDrvMDg_espsp = {
	"g_espsp", NULL, NULL, "1994",
	"ESPN Speed World (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_RACING, 0,
	NULL, g_espspRomInfo, g_espspRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN Sunday Night NFL (USA) (Beta)
static struct BurnRomInfo g_espnfbRomDesc[] = {
	{ "espn sunday night nfl (usa) (beta).md", 0x200000, 0xd13aecdc, BRF_PRG },
};

STD_ROM_PICK(g_espnfb)
STD_ROM_FN(g_espnfb)

struct BurnDriverD BurnDrvMDg_espnfb = {
	"g_espnfb", "g_espnf", NULL, "",
	"ESPN Sunday Night NFL (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_espnfbRomInfo, g_espnfbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESPN Sunday Night NFL (USA)
static struct BurnRomInfo g_espnfRomDesc[] = {
	{ "espn sunday night nfl (usa).md", 0x200000, 0x61e9c309, BRF_PRG },
};

STD_ROM_PICK(g_espnf)
STD_ROM_FN(g_espnf)

struct BurnDriver BurnDrvMDg_espnf = {
	"g_espnf", NULL, NULL, "1994",
	"ESPN Sunday Night NFL (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSFOOTBALL, 0,
	NULL, g_espnfRomInfo, g_espnfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// ESWAT - City Under Siege (USA)
static struct BurnRomInfo g_eswatcRomDesc[] = {
	{ "eswat - city under siege (usa).md", 0x80000, 0xe72f8a36, BRF_PRG },
};

STD_ROM_PICK(g_eswatc)
STD_ROM_FN(g_eswatc)

struct BurnDriver BurnDrvMDg_eswatc = {
	"g_eswatc", NULL, NULL, "1990",
	"ESWAT - City Under Siege (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SCRFIGHT, 0,
	NULL, g_eswatcRomInfo, g_eswatcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eternal Champions (Europe) (Beta)
static struct BurnRomInfo g_eternbRomDesc[] = {
	{ "eternal champions (europe) (beta).md", 0x300000, 0xe0665f06, BRF_PRG },
};

STD_ROM_PICK(g_eternb)
STD_ROM_FN(g_eternb)

struct BurnDriver BurnDrvMDg_eternb = {
	"g_eternb", "g_etern", NULL, "1900",
	"Eternal Champions (Europe) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_eternbRomInfo, g_eternbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eternal Champions (Europe)
static struct BurnRomInfo g_eternRomDesc[] = {
	{ "eternal champions (europe).md", 0x300000, 0xb9512f5e, BRF_PRG },
};

STD_ROM_PICK(g_etern)
STD_ROM_FN(g_etern)

struct BurnDriver BurnDrvMDg_etern = {
	"g_etern", NULL, NULL, "1900",
	"Eternal Champions (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_eternRomInfo, g_eternRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eternal Champions (J) (Prototype - Nov 17, 1993)
static struct BurnRomInfo g_eternpRomDesc[] = {
	{ "eternal champions (j) (prototype - nov 17, 1993).md", 0x2ff4b0, 0xc486b439, BRF_PRG },
};

STD_ROM_PICK(g_eternp)
STD_ROM_FN(g_eternp)

struct BurnDriverD BurnDrvMDg_eternp = {
	"g_eternp", "g_etern", NULL, "",
	"Eternal Champions (J) (Prototype - Nov 17, 1993)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_eternpRomInfo, g_eternpRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eternal Champions (Japan, Korea)
static struct BurnRomInfo g_eternjRomDesc[] = {
	{ "eternal champions (japan, korea).md", 0x300000, 0x66aa3c64, BRF_PRG },
};

STD_ROM_PICK(g_eternj)
STD_ROM_FN(g_eternj)

struct BurnDriver BurnDrvMDg_eternj = {
	"g_eternj", "g_etern", NULL, "1900",
	"Eternal Champions (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_eternjRomInfo, g_eternjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Eternal Champions (USA)
static struct BurnRomInfo g_eternuRomDesc[] = {
	{ "eternal champions (usa).md", 0x300000, 0x48f1a42e, BRF_PRG },
};

STD_ROM_PICK(g_eternu)
STD_ROM_FN(g_eternu)

struct BurnDriver BurnDrvMDg_eternu = {
	"g_eternu", "g_etern", NULL, "1900",
	"Eternal Champions (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_eternuRomInfo, g_eternuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Europa Sensen (Japan)
static struct BurnRomInfo g_europaRomDesc[] = {
	{ "europa sensen (japan).md", 0x100000, 0xb0416c60, BRF_PRG },
};

STD_ROM_PICK(g_europa)
STD_ROM_FN(g_europa)

struct BurnDriver BurnDrvMDg_europa = {
	"g_europa", "g_operat", NULL, "1900",
	"Europa Sensen (Japan)\0", NULL, "Koei", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_europaRomInfo, g_europaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// European Club Soccer (Europe)
static struct BurnRomInfo g_europeRomDesc[] = {
	{ "european club soccer (europe).md", 0x80000, 0x6a5cf104, BRF_PRG },
};

STD_ROM_PICK(g_europe)
STD_ROM_FN(g_europe)

struct BurnDriver BurnDrvMDg_europe = {
	"g_europe", NULL, NULL, "1900",
	"European Club Soccer (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_europeRomInfo, g_europeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Evander Holyfield's 'Real Deal' Boxing (World)
static struct BurnRomInfo g_evandeRomDesc[] = {
	{ "evander holyfield's 'real deal' boxing (world).md", 0x80000, 0x4fef37c8, BRF_PRG },
};

STD_ROM_PICK(g_evande)
STD_ROM_FN(g_evande)

struct BurnDriver BurnDrvMDg_evande = {
	"g_evande", NULL, NULL, "1992",
	"Evander Holyfield's 'Real Deal' Boxing (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_evandeRomInfo, g_evandeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ex-Mutants (USA, Europe)
static struct BurnRomInfo g_exmutaRomDesc[] = {
	{ "ex-mutants (usa, europe).md", 0x100000, 0x33b1979f, BRF_PRG },
};

STD_ROM_PICK(g_exmuta)
STD_ROM_FN(g_exmuta)

struct BurnDriverD BurnDrvMDg_exmuta = {
	"g_exmuta", NULL, NULL, "1992",
	"Ex-Mutants (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_exmutaRomInfo, g_exmutaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ex-Ranza (Japan) (Beta)
static struct BurnRomInfo g_exranbRomDesc[] = {
	{ "ex-ranza (japan) (beta).md", 0x100000, 0xc642fdf4, BRF_PRG },
};

STD_ROM_PICK(g_exranb)
STD_ROM_FN(g_exranb)

struct BurnDriverD BurnDrvMDg_exranb = {
	"g_exranb", "g_ranger", NULL, "1993",
	"Ex-Ranza (Japan) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_exranbRomInfo, g_exranbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ex-Ranza (Japan)
static struct BurnRomInfo g_exranRomDesc[] = {
	{ "ex-ranza (japan).md", 0x100000, 0x349bb68d, BRF_PRG },
};

STD_ROM_PICK(g_exran)
STD_ROM_FN(g_exran)

struct BurnDriverD BurnDrvMDg_exran = {
	"g_exran", "g_ranger", NULL, "1993",
	"Ex-Ranza (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_exranRomInfo, g_exranRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exile (USA)
static struct BurnRomInfo g_exileuRomDesc[] = {
	{ "exile (usa).md", 0x100000, 0x1b569dc2, BRF_PRG },
};

STD_ROM_PICK(g_exileu)
STD_ROM_FN(g_exileu)

struct BurnDriverD BurnDrvMDg_exileu = {
	"g_exileu", NULL, NULL, "1900",
	"Exile (USA)\0", "Gfx Problems", "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_exileuRomInfo, g_exileuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exile - Toki no Hazama he (Japan)
static struct BurnRomInfo g_exiletRomDesc[] = {
	{ "exile - toki no hazama he (japan).md", 0x100000, 0x880bf311, BRF_PRG },
};

STD_ROM_PICK(g_exilet)
STD_ROM_FN(g_exilet)

struct BurnDriverD BurnDrvMDg_exilet = {
	"g_exilet", "g_exileu", NULL, "1900",
	"Exile - Toki no Hazama he (Japan)\0", "Gfx Problems", "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_exiletRomInfo, g_exiletRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exo Squad (Europe)
static struct BurnRomInfo g_exosquRomDesc[] = {
	{ "exo squad (europe).md", 0x100000, 0xb599b9f9, BRF_PRG },
};

STD_ROM_PICK(g_exosqu)
STD_ROM_FN(g_exosqu)

struct BurnDriver BurnDrvMDg_exosqu = {
	"g_exosqu", NULL, NULL, "1995",
	"Exo Squad (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_exosquRomInfo, g_exosquRomName, MegadriveInputInfo, MegadriveEuropeDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exo Squad (USA) (Beta)
static struct BurnRomInfo g_exosq1RomDesc[] = {
	{ "exo squad (usa) (beta).md", 0x100000, 0x70edf964, BRF_PRG },
};

STD_ROM_PICK(g_exosq1)
STD_ROM_FN(g_exosq1)

struct BurnDriver BurnDrvMDg_exosq1 = {
	"g_exosq1", "g_exosqu", NULL, "1995",
	"Exo Squad (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_exosq1RomInfo, g_exosq1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exo Squad (USA)
static struct BurnRomInfo g_exosq2RomDesc[] = {
	{ "exo squad (usa).md", 0x100000, 0x10ec03f3, BRF_PRG },
};

STD_ROM_PICK(g_exosq2)
STD_ROM_FN(g_exosq2)

struct BurnDriver BurnDrvMDg_exosq2 = {
	"g_exosq2", "g_exosqu", NULL, "1995",
	"Exo Squad (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_exosq2RomInfo, g_exosq2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Exodus - Journey to the Promised Land (USA) (Unl)
static struct BurnRomInfo g_exodusRomDesc[] = {
	{ "exodus - journey to the promised land (usa) (unl).md", 0x80000, 0x22e6fc04, BRF_PRG },
};

STD_ROM_PICK(g_exodus)
STD_ROM_FN(g_exodus)

struct BurnDriverD BurnDrvMDg_exodus = {
	"g_exodus", NULL, NULL, "",
	"Exodus - Journey to the Promised Land (USA) (Unl)\0", NULL, "Wisdom Tree", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_exodusRomInfo, g_exodusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-117 Night Storm (USA, Europe)
static struct BurnRomInfo g_f117niRomDesc[] = {
	{ "f-117 night storm (usa, europe).md", 0x200000, 0x1bf67a07, BRF_PRG },
};

STD_ROM_PICK(g_f117ni)
STD_ROM_FN(g_f117ni)

struct BurnDriverD BurnDrvMDg_f117ni = {
	"g_f117ni", NULL, NULL, "1900",
	"F-117 Night Storm (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f117niRomInfo, g_f117niRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-117 Stealth - Operation Night Storm (Japan)
static struct BurnRomInfo g_f117stRomDesc[] = {
	{ "f-117 stealth - operation night storm (japan).md", 0x200000, 0xea6e421a, BRF_PRG },
};

STD_ROM_PICK(g_f117st)
STD_ROM_FN(g_f117st)

struct BurnDriverD BurnDrvMDg_f117st = {
	"g_f117st", "g_f117ni", NULL, "1900",
	"F-117 Stealth - Operation Night Storm (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f117stRomInfo, g_f117stRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-15 Strike Eagle II (Europe)
static struct BurnRomInfo g_f15strRomDesc[] = {
	{ "f-15 strike eagle ii (europe).md", 0x100000, 0xe98ee370, BRF_PRG },
};

STD_ROM_PICK(g_f15str)
STD_ROM_FN(g_f15str)

struct BurnDriverD BurnDrvMDg_f15str = {
	"g_f15str", NULL, NULL, "1900",
	"F-15 Strike Eagle II (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f15strRomInfo, g_f15strRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-15 Strike Eagle II (USA) (Beta)
static struct BurnRomInfo g_f15st1RomDesc[] = {
	{ "f-15 strike eagle ii (usa) (beta).md", 0x100000, 0xfd4f5a01, BRF_PRG },
};

STD_ROM_PICK(g_f15st1)
STD_ROM_FN(g_f15st1)

struct BurnDriverD BurnDrvMDg_f15st1 = {
	"g_f15st1", "g_f15str", NULL, "1900",
	"F-15 Strike Eagle II (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f15st1RomInfo, g_f15st1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-15 Strike Eagle II (USA)
static struct BurnRomInfo g_f15st2RomDesc[] = {
	{ "f-15 strike eagle ii (usa).md", 0x100000, 0x412c4d60, BRF_PRG },
};

STD_ROM_PICK(g_f15st2)
STD_ROM_FN(g_f15st2)

struct BurnDriverD BurnDrvMDg_f15st2 = {
	"g_f15st2", "g_f15str", NULL, "1900",
	"F-15 Strike Eagle II (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f15st2RomInfo, g_f15st2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-22 Interceptor (Japan)
static struct BurnRomInfo g_f22jRomDesc[] = {
	{ "f-22 interceptor (japan).md", 0xc0000, 0xfb55c785, BRF_PRG },
};

STD_ROM_PICK(g_f22j)
STD_ROM_FN(g_f22j)

struct BurnDriverD BurnDrvMDg_f22j = {
	"g_f22j", "g_f22", NULL, "1991",
	"F-22 Interceptor (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f22jRomInfo, g_f22jRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-22 Interceptor (U) (Sep 1991) [a1][c][!]
static struct BurnRomInfo g_f22uRomDesc[] = {
	{ "f-22 interceptor (u) (sep 1991) [a1][c][!].md", 0xc0000, 0x31e9d1a5, BRF_PRG },
};

STD_ROM_PICK(g_f22u)
STD_ROM_FN(g_f22u)

struct BurnDriverD BurnDrvMDg_f22u = {
	"g_f22u", "g_f22", NULL, "1991",
	"F-22 Interceptor (U) (Sep 1991) [a1][c][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f22uRomInfo, g_f22uRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-22 Interceptor (USA) (Beta)
static struct BurnRomInfo g_f22ubRomDesc[] = {
	{ "f-22 interceptor (usa) (beta).md", 0xc0000, 0xd6a880a4, BRF_PRG },
};

STD_ROM_PICK(g_f22ub)
STD_ROM_FN(g_f22ub)

struct BurnDriverD BurnDrvMDg_f22ub = {
	"g_f22ub", "g_f22", NULL, "1991",
	"F-22 Interceptor (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f22ubRomInfo, g_f22ubRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-22 Interceptor (USA, Europe) (June 1992)
static struct BurnRomInfo g_f22oRomDesc[] = {
	{ "f-22 interceptor (usa, europe) (june 1992).md", 0xc0000, 0xdd19b2b3, BRF_PRG },
};

STD_ROM_PICK(g_f22o)
STD_ROM_FN(g_f22o)

struct BurnDriverD BurnDrvMDg_f22o = {
	"g_f22o", "g_f22", NULL, "1991",
	"F-22 Interceptor (USA, Europe) (June 1992)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f22oRomInfo, g_f22oRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F-22 Interceptor (USA, Europe) (September 1991)
static struct BurnRomInfo g_f22RomDesc[] = {
	{ "f-22 interceptor (usa, europe) (september 1991).md", 0xc0000, 0x9cf552c2, BRF_PRG },
};

STD_ROM_PICK(g_f22)
STD_ROM_FN(g_f22)

struct BurnDriver BurnDrvMDg_f22 = {
	"g_f22", NULL, NULL, "1991",
	"F-22 Interceptor (USA, Europe) (September 1991)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f22RomInfo, g_f22RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F1 (Europe)
static struct BurnRomInfo g_f1euroRomDesc[] = {
	{ "f1 (europe).md", 0x100000, 0xfbdd4520, BRF_PRG },
};

STD_ROM_PICK(g_f1euro)
STD_ROM_FN(g_f1euro)

struct BurnDriverD BurnDrvMDg_f1euro = {
	"g_f1euro", NULL, NULL, "1900",
	"F1 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f1euroRomInfo, g_f1euroRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F1 - World Championship Edition (Europe) (Beta)
static struct BurnRomInfo g_f1wcbRomDesc[] = {
	{ "f1 - world championship edition (europe) (beta).md", 0x200000, 0x2269ed6b, BRF_PRG },
};

STD_ROM_PICK(g_f1wcb)
STD_ROM_FN(g_f1wcb)

struct BurnDriver BurnDrvMDg_f1wcb = {
	"g_f1wcb", "g_f1wc", NULL, "1900",
	"F1 - World Championship Edition (Europe) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f1wcbRomInfo, g_f1wcbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F1 - World Championship Edition (Europe)
static struct BurnRomInfo g_f1wcRomDesc[] = {
	{ "f1 - world championship edition (europe).md", 0x200000, 0x74cee0a7, BRF_PRG },
};

STD_ROM_PICK(g_f1wc)
STD_ROM_FN(g_f1wc)

struct BurnDriver BurnDrvMDg_f1wc = {
	"g_f1wc", NULL, NULL, "1900",
	"F1 - World Championship Edition (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f1wcRomInfo, g_f1wcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// F1 Circus MD (Japan)
static struct BurnRomInfo g_f1circRomDesc[] = {
	{ "f1 circus md (japan).md", 0x80000, 0x5d30befb, BRF_PRG },
};

STD_ROM_PICK(g_f1circ)
STD_ROM_FN(g_f1circ)

struct BurnDriver BurnDrvMDg_f1circ = {
	"g_f1circ", NULL, NULL, "1900",
	"F1 Circus MD (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_f1circRomInfo, g_f1circRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Faery Tale Adventure, The (USA, Europe)
static struct BurnRomInfo g_faerytRomDesc[] = {
	{ "faery tale adventure, the (usa, europe).md", 0x80000, 0x963f4969, BRF_PRG },
};

STD_ROM_PICK(g_faeryt)
STD_ROM_FN(g_faeryt)

struct BurnDriverD BurnDrvMDg_faeryt = {
	"g_faeryt", NULL, NULL, "1900",
	"Faery Tale Adventure, The (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_faerytRomInfo, g_faerytRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Family Feud (USA)
static struct BurnRomInfo g_familyRomDesc[] = {
	{ "family feud (usa).md", 0x80000, 0x1aa628b0, BRF_PRG },
};

STD_ROM_PICK(g_family)
STD_ROM_FN(g_family)

struct BurnDriverD BurnDrvMDg_family = {
	"g_family", NULL, NULL, "1900",
	"Family Feud (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_familyRomInfo, g_familyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fantasia (U) (REV00) [!]
static struct BurnRomInfo g_fantasRomDesc[] = {
	{ "fantasia (u) (rev00) [!].md", 0x80000, 0x34e04627, BRF_PRG },
};

STD_ROM_PICK(g_fantas)
STD_ROM_FN(g_fantas)

struct BurnDriverD BurnDrvMDg_fantas = {
	"g_fantas", NULL, NULL, "1900",
	"Fantasia (U) (REV00) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fantasRomInfo, g_fantasRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fantasia (World) (Rev A)
static struct BurnRomInfo g_fanta1RomDesc[] = {
	{ "fantasia (world) (rev a).md", 0x80000, 0xfc43df2d, BRF_PRG },
};

STD_ROM_PICK(g_fanta1)
STD_ROM_FN(g_fanta1)

struct BurnDriverD BurnDrvMDg_fanta1 = {
	"g_fanta1", "g_fantas", NULL, "1900",
	"Fantasia (World) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fanta1RomInfo, g_fanta1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fantasia (World)
static struct BurnRomInfo g_fanta2RomDesc[] = {
	{ "fantasia (world).md", 0x80000, 0xd351b242, BRF_PRG },
};

STD_ROM_PICK(g_fanta2)
STD_ROM_FN(g_fanta2)

struct BurnDriverD BurnDrvMDg_fanta2 = {
	"g_fanta2", "g_fantas", NULL, "1900",
	"Fantasia (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fanta2RomInfo, g_fanta2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fantastic Dizzy (UE) (M5) [a1]
static struct BurnRomInfo g_fantdzRomDesc[] = {
	{ "fantastic dizzy (ue) (m5) [a1].md", 0x80000, 0x86b2a235, BRF_PRG },
};

STD_ROM_PICK(g_fantdz)
STD_ROM_FN(g_fantdz)

struct BurnDriverD BurnDrvMDg_fantdz = {
	"g_fantdz", NULL, NULL, "1900",
	"Fantastic Dizzy (UE) (M5) [a1]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fantdzRomInfo, g_fantdzRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fantastic Dizzy (USA, Europe) (En,Fr,De,Es,It)
static struct BurnRomInfo g_fantd1RomDesc[] = {
	{ "fantastic dizzy (usa, europe) (en,fr,de,es,it).md", 0x80000, 0x46447e7a, BRF_PRG },
};

STD_ROM_PICK(g_fantd1)
STD_ROM_FN(g_fantd1)

struct BurnDriverD BurnDrvMDg_fantd1 = {
	"g_fantd1", "g_fantdz", NULL, "1900",
	"Fantastic Dizzy (USA, Europe) (En,Fr,De,Es,It)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fantd1RomInfo, g_fantd1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fastest 1 (Japan)
static struct BurnRomInfo g_fastesRomDesc[] = {
	{ "fastest 1 (japan).md", 0x80000, 0xbb43f0de, BRF_PRG },
};

STD_ROM_PICK(g_fastes)
STD_ROM_FN(g_fastes)

struct BurnDriver BurnDrvMDg_fastes = {
	"g_fastes", NULL, NULL, "1900",
	"Fastest 1 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fastesRomInfo, g_fastesRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatal Fury (Europe)
static struct BurnRomInfo g_fatalfRomDesc[] = {
	{ "fatal fury (europe).md", 0x180000, 0x2e730a91, BRF_PRG },
};

STD_ROM_PICK(g_fatalf)
STD_ROM_FN(g_fatalf)

struct BurnDriverD BurnDrvMDg_fatalf = {
	"g_fatalf", NULL, NULL, "1993",
	"Fatal Fury (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fatalfRomInfo, g_fatalfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatal Fury (USA)
static struct BurnRomInfo g_fatal1RomDesc[] = {
	{ "fatal fury (usa).md", 0x180000, 0x98d49170, BRF_PRG },
};

STD_ROM_PICK(g_fatal1)
STD_ROM_FN(g_fatal1)

struct BurnDriverD BurnDrvMDg_fatal1 = {
	"g_fatal1", "g_fatalf", NULL, "1993",
	"Fatal Fury (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fatal1RomInfo, g_fatal1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatal Fury 2 (USA, Korea)
static struct BurnRomInfo g_fatal2RomDesc[] = {
	{ "fatal fury 2 (usa, korea).md", 0x300000, 0x1b1754cb, BRF_PRG },
};

STD_ROM_PICK(g_fatal2)
STD_ROM_FN(g_fatal2)

struct BurnDriverD BurnDrvMDg_fatal2 = {
	"g_fatal2", NULL, NULL, "1994",
	"Fatal Fury 2 (USA, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fatal2RomInfo, g_fatal2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatal Labirynth (GNKO) (J) [!]
static struct BurnRomInfo g_fatlbxRomDesc[] = {
	{ "fatal labirynth (gnko) (j) [!].md", 0x20000, 0x40c44cd3, BRF_PRG },
};

STD_ROM_PICK(g_fatlbx)
STD_ROM_FN(g_fatlbx)

struct BurnDriverD BurnDrvMDg_fatlbx = {
	"g_fatlbx", "g_fatlb", NULL, "",
	"Fatal Labirynth (GNKO) (J) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fatlbxRomInfo, g_fatlbxRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatal Labyrinth (USA, Europe)
static struct BurnRomInfo g_fatlbRomDesc[] = {
	{ "fatal labyrinth (usa, europe).md", 0x20000, 0x5f0bd984, BRF_PRG },
};

STD_ROM_PICK(g_fatlb)
STD_ROM_FN(g_fatlb)

struct BurnDriverD BurnDrvMDg_fatlb = {
	"g_fatlb", NULL, NULL, "1900",
	"Fatal Labyrinth (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fatlbRomInfo, g_fatlbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatal Rewind (USA, Europe)
static struct BurnRomInfo g_fatalrRomDesc[] = {
	{ "fatal rewind (usa, europe).md", 0x80000, 0xe91aed05, BRF_PRG },
};

STD_ROM_PICK(g_fatalr)
STD_ROM_FN(g_fatalr)

struct BurnDriverD BurnDrvMDg_fatalr = {
	"g_fatalr", NULL, NULL, "1991",
	"Fatal Rewind (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fatalrRomInfo, g_fatalrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fatman (Japan)
static struct BurnRomInfo g_fatmanRomDesc[] = {
	{ "fatman (japan).md", 0xa0000, 0x7867da3a, BRF_PRG },
};

STD_ROM_PICK(g_fatman)
STD_ROM_FN(g_fatman)

struct BurnDriverD BurnDrvMDg_fatman = {
	"g_fatman", "g_slaugh", NULL, "1900",
	"Fatman (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fatmanRomInfo, g_fatmanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Feng Kuang Tao Hua Yuan (China) (Unl)
static struct BurnRomInfo g_fengkuRomDesc[] = {
	{ "feng kuang tao hua yuan (china) (unl).md", 0x100000, 0x8d40d64f, BRF_PRG },
};

STD_ROM_PICK(g_fengku)
STD_ROM_FN(g_fengku)

struct BurnDriverD BurnDrvMDg_fengku = {
	"g_fengku", NULL, NULL, "",
	"Feng Kuang Tao Hua Yuan (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fengkuRomInfo, g_fengkuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Feng Shen Ying Jie Chuan (China) (Unl)
static struct BurnRomInfo g_fengshRomDesc[] = {
	{ "feng shen ying jie chuan (china) (unl).md", 0x200000, 0x6a382b60, BRF_PRG },
};

STD_ROM_PICK(g_fengsh)
STD_ROM_FN(g_fengsh)

struct BurnDriverD BurnDrvMDg_fengsh = {
	"g_fengsh", NULL, NULL, "",
	"Feng Shen Ying Jie Chuan (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fengshRomInfo, g_fengshRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ferias Frustradas do Pica-Pau (Brazil)
static struct BurnRomInfo g_feriasRomDesc[] = {
	{ "ferias frustradas do pica-pau (brazil).md", 0x100000, 0x7b2e416d, BRF_PRG },
};

STD_ROM_PICK(g_ferias)
STD_ROM_FN(g_ferias)

struct BurnDriverD BurnDrvMDg_ferias = {
	"g_ferias", NULL, NULL, "",
	"Ferias Frustradas do Pica-Pau (Brazil)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_feriasRomInfo, g_feriasRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ferrari Grand Prix Challenge (Beta)
static struct BurnRomInfo g_ferrbRomDesc[] = {
	{ "ferrari grand prix challenge (beta).md", 0x100000, 0xd48d02d4, BRF_PRG },
};

STD_ROM_PICK(g_ferrb)
STD_ROM_FN(g_ferrb)

struct BurnDriverD BurnDrvMDg_ferrb = {
	"g_ferrb", "g_ferr", NULL, "1900",
	"Ferrari Grand Prix Challenge (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ferrbRomInfo, g_ferrbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ferrari Grand Prix Challenge (Europe) (Rev A)
static struct BurnRomInfo g_ferrRomDesc[] = {
	{ "ferrari grand prix challenge (europe) (rev a).md", 0x100000, 0x250111df, BRF_PRG },
};

STD_ROM_PICK(g_ferr)
STD_ROM_FN(g_ferr)

struct BurnDriverD BurnDrvMDg_ferr = {
	"g_ferr", NULL, NULL, "",
	"Ferrari Grand Prix Challenge (Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ferrRomInfo, g_ferrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ferrari Grand Prix Challenge (USA)
static struct BurnRomInfo g_ferruRomDesc[] = {
	{ "ferrari grand prix challenge (usa).md", 0x100000, 0xf73f6bec, BRF_PRG },
};

STD_ROM_PICK(g_ferru)
STD_ROM_FN(g_ferru)

struct BurnDriverD BurnDrvMDg_ferru = {
	"g_ferru", "g_ferr", NULL, "1900",
	"Ferrari Grand Prix Challenge (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ferruRomInfo, g_ferruRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fever Pitch Soccer (Europe) (En,Fr,De,Es,It)
static struct BurnRomInfo g_feverpRomDesc[] = {
	{ "fever pitch soccer (europe) (en,fr,de,es,it).md", 0x200000, 0xfac29677, BRF_PRG },
};

STD_ROM_PICK(g_feverp)
STD_ROM_FN(g_feverp)

struct BurnDriverD BurnDrvMDg_feverp = {
	"g_feverp", NULL, NULL, "1900",
	"Fever Pitch Soccer (Europe) (En,Fr,De,Es,It)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_feverpRomInfo, g_feverpRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fido Dido (USA) (Proto)
static struct BurnRomInfo g_fidodiRomDesc[] = {
	{ "fido dido (usa) (proto).md", 0x100000, 0xc6d4a240, BRF_PRG },
};

STD_ROM_PICK(g_fidodi)
STD_ROM_FN(g_fidodi)

struct BurnDriverD BurnDrvMDg_fidodi = {
	"g_fidodi", NULL, NULL, "1900",
	"Fido Dido (USA) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fidodiRomInfo, g_fidodiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA 98 - Road to World Cup (Europe) (En,Fr,Es,It,Sv)
static struct BurnRomInfo g_fi98RomDesc[] = {
	{ "fifa 98 - road to world cup (europe) (en,fr,es,it,sv).md", 0x200000, 0x96947f57, BRF_PRG },
};

STD_ROM_PICK(g_fi98)
STD_ROM_FN(g_fi98)

struct BurnDriver BurnDrvMDg_fi98 = {
	"g_fi98", NULL, NULL, "1900",
	"FIFA 98 - Road to World Cup (Europe) (En,Fr,Es,It,Sv)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fi98RomInfo, g_fi98RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA International Soccer (USA, Europe) (En,Fr,De,Es)
static struct BurnRomInfo g_fifaRomDesc[] = {
	{ "fifa international soccer (usa, europe) (en,fr,de,es).md", 0x200000, 0xbddbb763, BRF_PRG },
};

STD_ROM_PICK(g_fifa)
STD_ROM_FN(g_fifa)

struct BurnDriver BurnDrvMDg_fifa = {
	"g_fifa", NULL, NULL, "1993",
	"FIFA International Soccer (USA, Europe) (En,Fr,De,Es)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fifaRomInfo, g_fifaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA Soccer 2000 Gold Edition (Unl) (M6) [!]
static struct BurnRomInfo g_fi2kRomDesc[] = {
	{ "fifa soccer 2000 gold edition (unl) (m6) [!].md", 0x200000, 0x647df504, BRF_PRG },
};

STD_ROM_PICK(g_fi2k)
STD_ROM_FN(g_fi2k)

struct BurnDriver BurnDrvMDg_fi2k = {
	"g_fi2k", "g_fi97", NULL, "2000",
	"FIFA Soccer 2000 Gold Edition (Unl) (M6) [!]\0", NULL, "unlicensed", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fi2kRomInfo, g_fi2kRomName, MegadriveInputInfo, MegadriveUSADIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA Soccer 95 (Korea) (En,Fr,De,Es)
static struct BurnRomInfo g_fi95kRomDesc[] = {
	{ "fifa soccer 95 (korea) (en,fr,de,es).md", 0x200000, 0x012591f9, BRF_PRG },
};

STD_ROM_PICK(g_fi95k)
STD_ROM_FN(g_fi95k)

struct BurnDriverD BurnDrvMDg_fi95k = {
	"g_fi95k", "g_fi95", NULL, "",
	"FIFA Soccer 95 (Korea) (En,Fr,De,Es)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fi95kRomInfo, g_fi95kRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA Soccer 95 (USA, Europe) (En,Fr,De,Es)
static struct BurnRomInfo g_fi95RomDesc[] = {
	{ "fifa soccer 95 (usa, europe) (en,fr,de,es).md", 0x200000, 0xb389d036, BRF_PRG },
};

STD_ROM_PICK(g_fi95)
STD_ROM_FN(g_fi95)

struct BurnDriver BurnDrvMDg_fi95 = {
	"g_fi95", NULL, NULL, "1994",
	"FIFA Soccer 95 (USA, Europe) (En,Fr,De,Es)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fi95RomInfo, g_fi95RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA Soccer 96 (USA, Europe) (En,Fr,De,Es,It,Sv)
static struct BurnRomInfo g_fi96RomDesc[] = {
	{ "fifa soccer 96 (usa, europe) (en,fr,de,es,it,sv).md", 0x200000, 0xbad30ffa, BRF_PRG },
};

STD_ROM_PICK(g_fi96)
STD_ROM_FN(g_fi96)

struct BurnDriver BurnDrvMDg_fi96 = {
	"g_fi96", NULL, NULL, "1995",
	"FIFA Soccer 96 (USA, Europe) (En,Fr,De,Es,It,Sv)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fi96RomInfo, g_fi96RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA Soccer 97 (USA, Europe) (En,Fr,De,Es,It,Sv)
static struct BurnRomInfo g_fi97RomDesc[] = {
	{ "fifa soccer 97 (usa, europe) (en,fr,de,es,it,sv).md", 0x200000, 0xa33d5803, BRF_PRG },
};

STD_ROM_PICK(g_fi97)
STD_ROM_FN(g_fi97)

struct BurnDriver BurnDrvMDg_fi97 = {
	"g_fi97", NULL, NULL, "1996",
	"FIFA Soccer 97 (USA, Europe) (En,Fr,De,Es,It,Sv)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fi97RomInfo, g_fi97RomName, MegadriveInputInfo, MegadriveEuropeDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FIFA Soccer 99 (R) [!]
static struct BurnRomInfo g_fi99RomDesc[] = {
	{ "fifa soccer 99 (r) [!].md", 0x200000, 0xc5c5a4b0, BRF_PRG },
};

STD_ROM_PICK(g_fi99)
STD_ROM_FN(g_fi99)

struct BurnDriver BurnDrvMDg_fi99 = {
	"g_fi99", "g_fi96", NULL, "1900",
	"FIFA Soccer 99 (R) [!]\0", NULL, "unlicensed", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fi99RomInfo, g_fi99RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fighting Masters (Japan, Korea)
static struct BurnRomInfo g_fightjRomDesc[] = {
	{ "fighting masters (japan, korea).md", 0x80000, 0x39be80ec, BRF_PRG },
};

STD_ROM_PICK(g_fightj)
STD_ROM_FN(g_fightj)

struct BurnDriverD BurnDrvMDg_fightj = {
	"g_fightj", "g_fghtm", NULL, "1900",
	"Fighting Masters (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fightjRomInfo, g_fightjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fighting Masters (USA)
static struct BurnRomInfo g_fghtmRomDesc[] = {
	{ "fighting masters (usa).md", 0x80000, 0x5f51983b, BRF_PRG },
};

STD_ROM_PICK(g_fghtm)
STD_ROM_FN(g_fghtm)

struct BurnDriverD BurnDrvMDg_fghtm = {
	"g_fghtm", NULL, NULL, "1900",
	"Fighting Masters (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fghtmRomInfo, g_fghtmRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Final Blow (Japan)
static struct BurnRomInfo g_finalbRomDesc[] = {
	{ "final blow (japan).md", 0x80000, 0x48ad505d, BRF_PRG },
};

STD_ROM_PICK(g_finalb)
STD_ROM_FN(g_finalb)

struct BurnDriverD BurnDrvMDg_finalb = {
	"g_finalb", "g_jamesb", NULL, "1900",
	"Final Blow (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_finalbRomInfo, g_finalbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fire Mustang (Japan)
static struct BurnRomInfo g_firemuRomDesc[] = {
	{ "fire mustang (japan).md", 0x80000, 0xeb7e36c3, BRF_PRG },
};

STD_ROM_PICK(g_firemu)
STD_ROM_FN(g_firemu)

struct BurnDriverD BurnDrvMDg_firemu = {
	"g_firemu", NULL, NULL, "1900",
	"Fire Mustang (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_firemuRomInfo, g_firemuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fire Shark (Europe)
static struct BurnRomInfo g_fireshRomDesc[] = {
	{ "fire shark (europe).md", 0x80000, 0x2351ce61, BRF_PRG },
};

STD_ROM_PICK(g_firesh)
STD_ROM_FN(g_firesh)

struct BurnDriverD BurnDrvMDg_firesh = {
	"g_firesh", NULL, NULL, "1900",
	"Fire Shark (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fireshRomInfo, g_fireshRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fire Shark (U) [!]
static struct BurnRomInfo g_fires1RomDesc[] = {
	{ "fire shark (u) [!].md", 0x80000, 0x9c175146, BRF_PRG },
};

STD_ROM_PICK(g_fires1)
STD_ROM_FN(g_fires1)

struct BurnDriverD BurnDrvMDg_fires1 = {
	"g_fires1", "g_firesh", NULL, "1900",
	"Fire Shark (U) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fires1RomInfo, g_fires1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fire Shark (USA)
static struct BurnRomInfo g_fires2RomDesc[] = {
	{ "fire shark (usa).md", 0x80000, 0x570b5024, BRF_PRG },
};

STD_ROM_PICK(g_fires2)
STD_ROM_FN(g_fires2)

struct BurnDriverD BurnDrvMDg_fires2 = {
	"g_fires2", "g_firesh", NULL, "1900",
	"Fire Shark (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fires2RomInfo, g_fires2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flashback (Europe) (Rev A)
static struct BurnRomInfo g_flashbRomDesc[] = {
	{ "flashback (europe) (rev a).md", 0x180000, 0x6f311c83, BRF_PRG },
};

STD_ROM_PICK(g_flashb)
STD_ROM_FN(g_flashb)

struct BurnDriverD BurnDrvMDg_flashb = {
	"g_flashb", NULL, NULL, "1993",
	"Flashback (Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_flashbRomInfo, g_flashbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flashback (Japan)
static struct BurnRomInfo g_flash1RomDesc[] = {
	{ "flashback (japan).md", 0x180000, 0xb790e3b4, BRF_PRG },
};

STD_ROM_PICK(g_flash1)
STD_ROM_FN(g_flash1)

struct BurnDriverD BurnDrvMDg_flash1 = {
	"g_flash1", "g_flashb", NULL, "1993",
	"Flashback (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_flash1RomInfo, g_flash1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flashback - The Quest for Identity (USA) (Alt)
static struct BurnRomInfo g_flash2RomDesc[] = {
	{ "flashback - the quest for identity (usa) (alt).md", 0x180000, 0x33cd2b65, BRF_PRG },
};

STD_ROM_PICK(g_flash2)
STD_ROM_FN(g_flash2)

struct BurnDriverD BurnDrvMDg_flash2 = {
	"g_flash2", "g_flashb", NULL, "1993",
	"Flashback - The Quest for Identity (USA) (Alt)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_flash2RomInfo, g_flash2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flashback - The Quest for Identity (USA)
static struct BurnRomInfo g_flash3RomDesc[] = {
	{ "flashback - the quest for identity (usa).md", 0x180000, 0x23a9616d, BRF_PRG },
};

STD_ROM_PICK(g_flash3)
STD_ROM_FN(g_flash3)

struct BurnDriverD BurnDrvMDg_flash3 = {
	"g_flash3", "g_flashb", NULL, "1993",
	"Flashback - The Quest for Identity (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_flash3RomInfo, g_flash3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// DEBUG Flavio's DMA Test (PD)
static struct BurnRomInfo g_flavioRomDesc[] = {
	{ "debug flavio's dma test (pd).md", 0x4000, 0x549cebf4, BRF_PRG },
};

STD_ROM_PICK(g_flavio)
STD_ROM_FN(g_flavio)

struct BurnDriverD BurnDrvMDg_flavio = {
	"g_flavio", NULL, NULL, "1900",
	"DEBUG Flavio's DMA Test (PD)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_flavioRomInfo, g_flavioRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flicky (USA, Europe)
static struct BurnRomInfo g_flickyRomDesc[] = {
	{ "flicky (usa, europe).md", 0x20000, 0x4291c8ab, BRF_PRG },
};

STD_ROM_PICK(g_flicky)
STD_ROM_FN(g_flicky)

struct BurnDriverD BurnDrvMDg_flicky = {
	"g_flicky", NULL, NULL, "1900",
	"Flicky (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_flickyRomInfo, g_flickyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// The Misadventures of Flink (Europe)
static struct BurnRomInfo g_flinkeRomDesc[] = {
	{ "the misadventures of flink (europe).md", 0x100000, 0xbef9a4f4, BRF_PRG },
};

STD_ROM_PICK(g_flinke)
STD_ROM_FN(g_flinke)

struct BurnDriverD BurnDrvMDg_flinke = {
	"g_flinke", NULL, NULL, "1900",
	"The Misadventures of Flink (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_flinkeRomInfo, g_flinkeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flintstone (Japan)
static struct BurnRomInfo g_flintjRomDesc[] = {
	{ "flintstone (japan).md", 0x80000, 0x920a3031, BRF_PRG },
};

STD_ROM_PICK(g_flintj)
STD_ROM_FN(g_flintj)

struct BurnDriverD BurnDrvMDg_flintj = {
	"g_flintj", "g_flint", NULL, "1900",
	"Flintstone (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_flintjRomInfo, g_flintjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flintstones, The (Europe)
static struct BurnRomInfo g_flintRomDesc[] = {
	{ "flintstones, the (europe).md", 0x80000, 0x21845d61, BRF_PRG },
};

STD_ROM_PICK(g_flint)
STD_ROM_FN(g_flint)

struct BurnDriverD BurnDrvMDg_flint = {
	"g_flint", NULL, NULL, "1900",
	"Flintstones, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_flintRomInfo, g_flintRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flintstones, The (USA)
static struct BurnRomInfo g_flintuRomDesc[] = {
	{ "flintstones, the (usa).md", 0x80000, 0x7c982c59, BRF_PRG },
};

STD_ROM_PICK(g_flintu)
STD_ROM_FN(g_flintu)

struct BurnDriverD BurnDrvMDg_flintu = {
	"g_flintu", "g_flint", NULL, "1900",
	"Flintstones, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_flintuRomInfo, g_flintuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Flux (Europe) (Requires MegaCD) (Program)
static struct BurnRomInfo g_fluxeuRomDesc[] = {
	{ "flux (europe) (requires megacd) (program).md", 0x40000, 0x2a1da08c, BRF_PRG },
};

STD_ROM_PICK(g_fluxeu)
STD_ROM_FN(g_fluxeu)

struct BurnDriverD BurnDrvMDg_fluxeu = {
	"g_fluxeu", NULL, NULL, "",
	"Flux (Europe) (Requires MegaCD) (Program)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fluxeuRomInfo, g_fluxeuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Foreman for Real (World)
static struct BurnRomInfo g_foremaRomDesc[] = {
	{ "foreman for real (world).md", 0x300000, 0x36248f90, BRF_PRG },
};

STD_ROM_PICK(g_forema)
STD_ROM_FN(g_forema)

struct BurnDriverD BurnDrvMDg_forema = {
	"g_forema", NULL, NULL, "1900",
	"Foreman for Real (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_foremaRomInfo, g_foremaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Forgotten Worlds (World) (v1.1)
static struct BurnRomInfo g_forgotRomDesc[] = {
	{ "forgotten worlds (world) (v1.1).md", 0x80000, 0x95513985, BRF_PRG },
};

STD_ROM_PICK(g_forgot)
STD_ROM_FN(g_forgot)

struct BurnDriverD BurnDrvMDg_forgot = {
	"g_forgot", NULL, NULL, "1900",
	"Forgotten Worlds (World) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_forgotRomInfo, g_forgotRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Forgotten Worlds (World)
static struct BurnRomInfo g_forgo1RomDesc[] = {
	{ "forgotten worlds (world).md", 0x80000, 0xd0ee6434, BRF_PRG },
};

STD_ROM_PICK(g_forgo1)
STD_ROM_FN(g_forgo1)

struct BurnDriverD BurnDrvMDg_forgo1 = {
	"g_forgo1", "g_forgot", NULL, "1900",
	"Forgotten Worlds (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_forgo1RomInfo, g_forgo1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Formula One (USA)
static struct BurnRomInfo g_formulRomDesc[] = {
	{ "formula one (usa).md", 0x100000, 0xccd73738, BRF_PRG },
};

STD_ROM_PICK(g_formul)
STD_ROM_FN(g_formul)

struct BurnDriverD BurnDrvMDg_formul = {
	"g_formul", NULL, NULL, "1900",
	"Formula One (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_formulRomInfo, g_formulRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Frank Thomas Big Hurt Baseball (USA, Europe)
static struct BurnRomInfo g_franktRomDesc[] = {
	{ "frank thomas big hurt baseball (usa, europe).md", 0x400000, 0x863e0950, BRF_PRG },
};

STD_ROM_PICK(g_frankt)
STD_ROM_FN(g_frankt)

struct BurnDriverD BurnDrvMDg_frankt = {
	"g_frankt", NULL, NULL, "1900",
	"Frank Thomas Big Hurt Baseball (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_franktRomInfo, g_franktRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Frogger (USA)
static struct BurnRomInfo g_froggeRomDesc[] = {
	{ "frogger (usa).md", 0x80000, 0xea2e48c0, BRF_PRG },
};

STD_ROM_PICK(g_frogge)
STD_ROM_FN(g_frogge)

struct BurnDriverD BurnDrvMDg_frogge = {
	"g_frogge", NULL, NULL, "1900",
	"Frogger (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_froggeRomInfo, g_froggeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// From TV Animation Slam Dunk - Kyougou Makkou Taiketsu! (Japan)
static struct BurnRomInfo g_fromtvRomDesc[] = {
	{ "from tv animation slam dunk - kyougou makkou taiketsu! (japan).md", 0x200000, 0xcdf5678f, BRF_PRG },
};

STD_ROM_PICK(g_fromtv)
STD_ROM_FN(g_fromtv)

struct BurnDriverD BurnDrvMDg_fromtv = {
	"g_fromtv", NULL, NULL, "1900",
	"From TV Animation Slam Dunk - Kyougou Makkou Taiketsu! (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fromtvRomInfo, g_fromtvRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fun 'N' Games (Europe)
static struct BurnRomInfo g_funngaRomDesc[] = {
	{ "fun 'n' games (europe).md", 0x100000, 0xda4ab3cd, BRF_PRG },
};

STD_ROM_PICK(g_funnga)
STD_ROM_FN(g_funnga)

struct BurnDriverD BurnDrvMDg_funnga = {
	"g_funnga", NULL, NULL, "1900",
	"Fun 'N' Games (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_funngaRomInfo, g_funngaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fun 'N' Games (USA)
static struct BurnRomInfo g_funng1RomDesc[] = {
	{ "fun 'n' games (usa).md", 0x100000, 0xb5ae351d, BRF_PRG },
};

STD_ROM_PICK(g_funng1)
STD_ROM_FN(g_funng1)

struct BurnDriverD BurnDrvMDg_funng1 = {
	"g_funng1", "g_funnga", NULL, "1900",
	"Fun 'N' Games (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_funng1RomInfo, g_funng1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fun Car Rally (USA) (Proto)
static struct BurnRomInfo g_funcarRomDesc[] = {
	{ "fun car rally (usa) (proto).md", 0x100000, 0x42e27845, BRF_PRG },
};

STD_ROM_PICK(g_funcar)
STD_ROM_FN(g_funcar)

struct BurnDriverD BurnDrvMDg_funcar = {
	"g_funcar", NULL, NULL, "1900",
	"Fun Car Rally (USA) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_funcarRomInfo, g_funcarRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Funny World & Balloon Boy (USA) (Unl)
static struct BurnRomInfo g_funnywRomDesc[] = {
	{ "funny world & balloon boy (usa) (unl).md", 0x80000, 0xa82f05f0, BRF_PRG },
};

STD_ROM_PICK(g_funnyw)
STD_ROM_FN(g_funnyw)

struct BurnDriverD BurnDrvMDg_funnyw = {
	"g_funnyw", NULL, NULL, "",
	"Funny World & Balloon Boy (USA) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_funnywRomInfo, g_funnywRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Fushigi no Umi no Nadia (Japan)
static struct BurnRomInfo g_fushigRomDesc[] = {
	{ "fushigi no umi no nadia (japan).md", 0x100000, 0x4762062a, BRF_PRG },
};

STD_ROM_PICK(g_fushig)
STD_ROM_FN(g_fushig)

struct BurnDriverD BurnDrvMDg_fushig = {
	"g_fushig", NULL, NULL, "",
	"Fushigi no Umi no Nadia (Japan)\0", NULL, "Namcot", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fushigRomInfo, g_fushigRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Futbol Argentino 98 - Pasion de Multitudes (Unl)
static struct BurnRomInfo g_futbolRomDesc[] = {
	{ "futbol argentino 98 - pasion de multitudes (unl).md", 0x200000, 0x5c015888, BRF_PRG },
};

STD_ROM_PICK(g_futbol)
STD_ROM_FN(g_futbol)

struct BurnDriver BurnDrvMDg_futbol = {
	"g_futbol", "g_fi95", NULL, "1900",
	"Futbol Argentino 98 - Pasion de Multitudes (Unl)\0", NULL, "unlicensed", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_futbolRomInfo, g_futbolRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// FZ Senki Axis ~ Final Zone (Japan, USA)
static struct BurnRomInfo g_fzsenkRomDesc[] = {
	{ "fz senki axis ~ final zone (japan, usa).md", 0x80000, 0x731fa4a1, BRF_PRG },
};

STD_ROM_PICK(g_fzsenk)
STD_ROM_FN(g_fzsenk)

struct BurnDriverD BurnDrvMDg_fzsenk = {
	"g_fzsenk", NULL, NULL, "1900",
	"FZ Senki Axis ~ Final Zone (Japan, USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_fzsenkRomInfo, g_fzsenkRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// G-LOC Air Battle (World) (Beta)
static struct BurnRomInfo g_glocbRomDesc[] = {
	{ "g-loc air battle (world) (beta).md", 0x100000, 0x175c7e63, BRF_PRG },
};

STD_ROM_PICK(g_glocb)
STD_ROM_FN(g_glocb)

struct BurnDriverD BurnDrvMDg_glocb = {
	"g_glocb", "g_gloc", NULL, "",
	"G-LOC Air Battle (World) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_glocbRomInfo, g_glocbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// G-LOC Air Battle (World)
static struct BurnRomInfo g_glocRomDesc[] = {
	{ "g-loc air battle (world).md", 0x100000, 0xf2af886e, BRF_PRG },
};

STD_ROM_PICK(g_gloc)
STD_ROM_FN(g_gloc)

struct BurnDriverD BurnDrvMDg_gloc = {
	"g_gloc", NULL, NULL, "",
	"G-LOC Air Battle (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_glocRomInfo, g_glocRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gadget Twins (USA)
static struct BurnRomInfo g_gadgetRomDesc[] = {
	{ "gadget twins (usa).md", 0x100000, 0x7ae5e248, BRF_PRG },
};

STD_ROM_PICK(g_gadget)
STD_ROM_FN(g_gadget)

struct BurnDriverD BurnDrvMDg_gadget = {
	"g_gadget", NULL, NULL, "1900",
	"Gadget Twins (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gadgetRomInfo, g_gadgetRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gaiares (Japan, USA)
static struct BurnRomInfo g_gaiareRomDesc[] = {
	{ "gaiares (japan, usa).md", 0x100000, 0x5d8bf68b, BRF_PRG },
};

STD_ROM_PICK(g_gaiare)
STD_ROM_FN(g_gaiare)

struct BurnDriverD BurnDrvMDg_gaiare = {
	"g_gaiare", NULL, NULL, "1900",
	"Gaiares (Japan, USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gaiareRomInfo, g_gaiareRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gain Ground (World) (Alt)
static struct BurnRomInfo g_gaingrRomDesc[] = {
	{ "gain ground (world) (alt).md", 0x80000, 0x83e7b8ae, BRF_PRG },
};

STD_ROM_PICK(g_gaingr)
STD_ROM_FN(g_gaingr)

struct BurnDriverD BurnDrvMDg_gaingr = {
	"g_gaingr", NULL, NULL, "1900",
	"Gain Ground (World) (Alt)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gaingrRomInfo, g_gaingrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gain Ground (World)
static struct BurnRomInfo g_gaing1RomDesc[] = {
	{ "gain ground (world).md", 0x80000, 0x8641a2ab, BRF_PRG },
};

STD_ROM_PICK(g_gaing1)
STD_ROM_FN(g_gaing1)

struct BurnDriverD BurnDrvMDg_gaing1 = {
	"g_gaing1", "g_gaingr", NULL, "1900",
	"Gain Ground (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gaing1RomInfo, g_gaing1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Galaxy Force II (World) (Rev B)
static struct BurnRomInfo g_galaxyRomDesc[] = {
	{ "galaxy force ii (world) (rev b).md", 0x100000, 0xd15f5c3c, BRF_PRG },
};

STD_ROM_PICK(g_galaxy)
STD_ROM_FN(g_galaxy)

struct BurnDriverD BurnDrvMDg_galaxy = {
	"g_galaxy", NULL, NULL, "1900",
	"Galaxy Force II (World) (Rev B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_galaxyRomInfo, g_galaxyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Galaxy Force II (World)
static struct BurnRomInfo g_galax1RomDesc[] = {
	{ "galaxy force ii (world).md", 0x100000, 0xcae883c5, BRF_PRG },
};

STD_ROM_PICK(g_galax1)
STD_ROM_FN(g_galax1)

struct BurnDriverD BurnDrvMDg_galax1 = {
	"g_galax1", "g_galaxy", NULL, "1900",
	"Galaxy Force II (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_galax1RomInfo, g_galax1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gambler Jiko Chuushinha - Katayama Masayuki no Mahjong Doujou (Japan)
static struct BurnRomInfo g_gambleRomDesc[] = {
	{ "gambler jiko chuushinha - katayama masayuki no mahjong doujou (japan).md", 0x80000, 0x05650b7a, BRF_PRG },
};

STD_ROM_PICK(g_gamble)
STD_ROM_FN(g_gamble)

struct BurnDriverD BurnDrvMDg_gamble = {
	"g_gamble", NULL, NULL, "1900",
	"Gambler Jiko Chuushinha - Katayama Masayuki no Mahjong Doujou (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gambleRomInfo, g_gambleRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Game Genie (USA, Europe) (Program)
static struct BurnRomInfo g_gamegeRomDesc[] = {
	{ "game genie (usa, europe) (program).md", 0x8000, 0x5f293e4c, BRF_PRG },
};

STD_ROM_PICK(g_gamege)
STD_ROM_FN(g_gamege)

struct BurnDriverD BurnDrvMDg_gamege = {
	"g_gamege", NULL, NULL, "",
	"Game Genie (USA, Europe) (Program)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gamegeRomInfo, g_gamegeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Game Genie (USA, Europe) (Rev A) (Program)
static struct BurnRomInfo g_gameg1RomDesc[] = {
	{ "game genie (usa, europe) (rev a) (program).md", 0x8000, 0x14dbce4a, BRF_PRG },
};

STD_ROM_PICK(g_gameg1)
STD_ROM_FN(g_gameg1)

struct BurnDriverD BurnDrvMDg_gameg1 = {
	"g_gameg1", "g_gamege", NULL, "",
	"Game Genie (USA, Europe) (Rev A) (Program)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gameg1RomInfo, g_gameg1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Game no Kandume Otokuyou (Japan)
static struct BurnRomInfo g_gamenoRomDesc[] = {
	{ "game no kandume otokuyou (japan).md", 0x300000, 0xcdad7e6b, BRF_PRG },
};

STD_ROM_PICK(g_gameno)
STD_ROM_FN(g_gameno)

struct BurnDriverD BurnDrvMDg_gameno = {
	"g_gameno", NULL, NULL, "",
	"Game no Kandume Otokuyou (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gamenoRomInfo, g_gamenoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Game Toshokan (Japan) (Rev A) (Program)
static struct BurnRomInfo g_gametoRomDesc[] = {
	{ "game toshokan (japan) (rev a) (program).md", 0x20000, 0xc185c819, BRF_PRG },
};

STD_ROM_PICK(g_gameto)
STD_ROM_FN(g_gameto)

struct BurnDriverD BurnDrvMDg_gameto = {
	"g_gameto", NULL, NULL, "",
	"Game Toshokan (Japan) (Rev A) (Program)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gametoRomInfo, g_gametoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Garfield - Caught in the Act (USA, Europe)
static struct BurnRomInfo g_garfieRomDesc[] = {
	{ "garfield - caught in the act (usa, europe).md", 0x200000, 0xf0ff078e, BRF_PRG },
};

STD_ROM_PICK(g_garfie)
STD_ROM_FN(g_garfie)

struct BurnDriverD BurnDrvMDg_garfie = {
	"g_garfie", NULL, NULL, "1900",
	"Garfield - Caught in the Act (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_garfieRomInfo, g_garfieRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gargoyles (USA)
static struct BurnRomInfo g_gargoyRomDesc[] = {
	{ "gargoyles (usa).md", 0x300000, 0x2d965364, BRF_PRG },
};

STD_ROM_PICK(g_gargoy)
STD_ROM_FN(g_gargoy)

struct BurnDriverD BurnDrvMDg_gargoy = {
	"g_gargoy", NULL, NULL, "1995",
	"Gargoyles (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gargoyRomInfo, g_gargoyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Garou Densetsu - Shukumei no Tatakai (Japan)
static struct BurnRomInfo g_garoudRomDesc[] = {
	{ "garou densetsu - shukumei no tatakai (japan).md", 0x180000, 0xbf3e3fa4, BRF_PRG },
};

STD_ROM_PICK(g_garoud)
STD_ROM_FN(g_garoud)

struct BurnDriverD BurnDrvMDg_garoud = {
	"g_garoud", "g_fatalf", NULL, "1993",
	"Garou Densetsu - Shukumei no Tatakai (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_garoudRomInfo, g_garoudRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Garou Densetsu 2 - Aratanaru Tatakai (Japan)
static struct BurnRomInfo g_garou2RomDesc[] = {
	{ "garou densetsu 2 - aratanaru tatakai (japan).md", 0x300000, 0x2af4427f, BRF_PRG },
};

STD_ROM_PICK(g_garou2)
STD_ROM_FN(g_garou2)

struct BurnDriverD BurnDrvMDg_garou2 = {
	"g_garou2", "g_fatal2", NULL, "1994",
	"Garou Densetsu 2 - Aratanaru Tatakai (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_garou2RomInfo, g_garou2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gauntlet (Japan) (En,Ja)
static struct BurnRomInfo g_gauntjRomDesc[] = {
	{ "gauntlet (japan) (en,ja).md", 0x100000, 0xf9872055, BRF_PRG },
};

STD_ROM_PICK(g_gauntj)
STD_ROM_FN(g_gauntj)

struct BurnDriverD BurnDrvMDg_gauntj = {
	"g_gauntj", "g_gaunt", NULL, "1994",
	"Gauntlet (Japan) (En,Ja)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gauntjRomInfo, g_gauntjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gauntlet IV (USA, Europe) (En,Ja) (August 1993)
static struct BurnRomInfo g_gauntoRomDesc[] = {
	{ "gauntlet iv (usa, europe) (en,ja) (august 1993).md", 0x100000, 0x3bf46dce, BRF_PRG },
};

STD_ROM_PICK(g_gaunto)
STD_ROM_FN(g_gaunto)

struct BurnDriverD BurnDrvMDg_gaunto = {
	"g_gaunto", "g_gaunt", NULL, "1994",
	"Gauntlet IV (USA, Europe) (En,Ja) (August 1993)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gauntoRomInfo, g_gauntoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gauntlet IV (USA, Europe) (En,Ja) (September 1993)
static struct BurnRomInfo g_gauntRomDesc[] = {
	{ "gauntlet iv (usa, europe) (en,ja) (september 1993).md", 0x100000, 0xf9d60510, BRF_PRG },
};

STD_ROM_PICK(g_gaunt)
STD_ROM_FN(g_gaunt)

struct BurnDriverD BurnDrvMDg_gaunt = {
	"g_gaunt", NULL, NULL, "1994",
	"Gauntlet IV (USA, Europe) (En,Ja) (September 1993)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gauntRomInfo, g_gauntRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gemfire (USA)
static struct BurnRomInfo g_gemfirRomDesc[] = {
	{ "gemfire (usa).md", 0x100000, 0x3d36135b, BRF_PRG },
};

STD_ROM_PICK(g_gemfir)
STD_ROM_FN(g_gemfir)

struct BurnDriver BurnDrvMDg_gemfir = {
	"g_gemfir", NULL, NULL, "1900",
	"Gemfire (USA)\0", NULL, "Koei", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gemfirRomInfo, g_gemfirRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// General Chaos (USA, Europe)
static struct BurnRomInfo g_generaRomDesc[] = {
	{ "general chaos (usa, europe).md", 0x100000, 0xf1ecc4df, BRF_PRG },
};

STD_ROM_PICK(g_genera)
STD_ROM_FN(g_genera)

struct BurnDriverD BurnDrvMDg_genera = {
	"g_genera", NULL, NULL, "1900",
	"General Chaos (USA, Europe)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_generaRomInfo, g_generaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// General Chaos Daikonsen (Japan)
static struct BurnRomInfo g_gener1RomDesc[] = {
	{ "general chaos daikonsen (japan).md", 0x100000, 0x05cc7369, BRF_PRG },
};

STD_ROM_PICK(g_gener1)
STD_ROM_FN(g_gener1)

struct BurnDriverD BurnDrvMDg_gener1 = {
	"g_gener1", "g_genera", NULL, "1900",
	"General Chaos Daikonsen (Japan)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gener1RomInfo, g_gener1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Generations Lost (USA, Europe)
static struct BurnRomInfo g_geneloRomDesc[] = {
	{ "generations lost (usa, europe).md", 0x100000, 0x131f36a6, BRF_PRG },
};

STD_ROM_PICK(g_genelo)
STD_ROM_FN(g_genelo)

struct BurnDriverD BurnDrvMDg_genelo = {
	"g_genelo", NULL, NULL, "1900",
	"Generations Lost (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_geneloRomInfo, g_geneloRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Genghis Khan II - Clan of the Gray Wolf (USA)
static struct BurnRomInfo g_genghiRomDesc[] = {
	{ "genghis khan ii - clan of the gray wolf (usa).md", 0x100000, 0x87a281ae, BRF_PRG },
};

STD_ROM_PICK(g_genghi)
STD_ROM_FN(g_genghi)

struct BurnDriver BurnDrvMDg_genghi = {
	"g_genghi", NULL, NULL, "1900",
	"Genghis Khan II - Clan of the Gray Wolf (USA)\0", NULL, "Koei", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_genghiRomInfo, g_genghiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// George Foreman's KO Boxing (Europe)
static struct BurnRomInfo g_georgeRomDesc[] = {
	{ "george foreman's ko boxing (europe).md", 0x100000, 0xbd556381, BRF_PRG },
};

STD_ROM_PICK(g_george)
STD_ROM_FN(g_george)

struct BurnDriverD BurnDrvMDg_george = {
	"g_george", NULL, NULL, "1900",
	"George Foreman's KO Boxing (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_georgeRomInfo, g_georgeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// George Foreman's KO Boxing (USA)
static struct BurnRomInfo g_georg1RomDesc[] = {
	{ "george foreman's ko boxing (usa).md", 0x100000, 0xe1fdc787, BRF_PRG },
};

STD_ROM_PICK(g_georg1)
STD_ROM_FN(g_georg1)

struct BurnDriverD BurnDrvMDg_georg1 = {
	"g_georg1", "g_george", NULL, "1900",
	"George Foreman's KO Boxing (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_georg1RomInfo, g_georg1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ghostbusters (World) (v1.1)
static struct BurnRomInfo g_ghostbRomDesc[] = {
	{ "ghostbusters (world) (v1.1).md", 0x80000, 0x792df93b, BRF_PRG },
};

STD_ROM_PICK(g_ghostb)
STD_ROM_FN(g_ghostb)

struct BurnDriverD BurnDrvMDg_ghostb = {
	"g_ghostb", NULL, NULL, "1900",
	"Ghostbusters (World) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ghostbRomInfo, g_ghostbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ghostbusters (World)
static struct BurnRomInfo g_ghost1RomDesc[] = {
	{ "ghostbusters (world).md", 0x80000, 0x00419da3, BRF_PRG },
};

STD_ROM_PICK(g_ghost1)
STD_ROM_FN(g_ghost1)

struct BurnDriverD BurnDrvMDg_ghost1 = {
	"g_ghost1", "g_ghostb", NULL, "1900",
	"Ghostbusters (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ghost1RomInfo, g_ghost1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ghouls 'n Ghosts (USA, Europe) (Rev A)
static struct BurnRomInfo g_ghoulsRomDesc[] = {
	{ "ghouls 'n ghosts (usa, europe) (rev a).md", 0xa0000, 0x4f2561d5, BRF_PRG },
};

STD_ROM_PICK(g_ghouls)
STD_ROM_FN(g_ghouls)

struct BurnDriverD BurnDrvMDg_ghouls = {
	"g_ghouls", NULL, NULL, "1989",
	"Ghouls 'n Ghosts (USA, Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ghoulsRomInfo, g_ghoulsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ghouls 'n Ghosts (USA, Europe)
static struct BurnRomInfo g_ghoul1RomDesc[] = {
	{ "ghouls 'n ghosts (usa, europe).md", 0xa0000, 0xd31bd910, BRF_PRG },
};

STD_ROM_PICK(g_ghoul1)
STD_ROM_FN(g_ghoul1)

struct BurnDriverD BurnDrvMDg_ghoul1 = {
	"g_ghoul1", "g_ghouls", NULL, "1989",
	"Ghouls 'n Ghosts (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ghoul1RomInfo, g_ghoul1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Global Gladiators (Europe)
static struct BurnRomInfo g_globalRomDesc[] = {
	{ "global gladiators (europe).md", 0x100000, 0x5c218c6a, BRF_PRG },
};

STD_ROM_PICK(g_global)
STD_ROM_FN(g_global)

struct BurnDriverD BurnDrvMDg_global = {
	"g_global", NULL, NULL, "1994",
	"Global Gladiators (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_globalRomInfo, g_globalRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gods (Europe)
static struct BurnRomInfo g_godsRomDesc[] = {
	{ "gods (europe).md", 0x100000, 0x6c415016, BRF_PRG },
};

STD_ROM_PICK(g_gods)
STD_ROM_FN(g_gods)

struct BurnDriverD BurnDrvMDg_gods = {
	"g_gods", NULL, NULL, "1900",
	"Gods (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_godsRomInfo, g_godsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gods (Japan)
static struct BurnRomInfo g_godsjRomDesc[] = {
	{ "gods (japan).md", 0x100000, 0xe4f50206, BRF_PRG },
};

STD_ROM_PICK(g_godsj)
STD_ROM_FN(g_godsj)

struct BurnDriverD BurnDrvMDg_godsj = {
	"g_godsj", "g_gods", NULL, "",
	"Gods (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_godsjRomInfo, g_godsjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gods (USA) (Beta)
static struct BurnRomInfo g_godsubRomDesc[] = {
	{ "gods (usa) (beta).md", 0x100000, 0x2c06bb64, BRF_PRG },
};

STD_ROM_PICK(g_godsub)
STD_ROM_FN(g_godsub)

struct BurnDriverD BurnDrvMDg_godsub = {
	"g_godsub", "g_gods", NULL, "1900",
	"Gods (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_godsubRomInfo, g_godsubRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gods (USA)
static struct BurnRomInfo g_godsuRomDesc[] = {
	{ "gods (usa).md", 0x100000, 0xfd234ccd, BRF_PRG },
};

STD_ROM_PICK(g_godsu)
STD_ROM_FN(g_godsu)

struct BurnDriverD BurnDrvMDg_godsu = {
	"g_godsu", "g_gods", NULL, "1900",
	"Gods (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_godsuRomInfo, g_godsuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden 10-in-1 (bad dump)
static struct BurnRomInfo g_goldenRomDesc[] = {
	{ "golden 10-in-1 (bad dump).md", 0x100000, 0x4fa3f82b, BRF_PRG },
};

STD_ROM_PICK(g_golden)
STD_ROM_FN(g_golden)

struct BurnDriverD BurnDrvMDg_golden = {
	"g_golden", NULL, NULL, "",
	"Golden 10-in-1 (bad dump)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_goldenRomInfo, g_goldenRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden 10-in-1 (Unl) [!]
static struct BurnRomInfo g_golde1RomDesc[] = {
	{ "golden 10-in-1 (unl) [!].md", 0x100000, 0x4fa3f82b, BRF_PRG },
};

STD_ROM_PICK(g_golde1)
STD_ROM_FN(g_golde1)

struct BurnDriverD BurnDrvMDg_golde1 = {
	"g_golde1", "g_golden", NULL, "",
	"Golden 10-in-1 (Unl) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_golde1RomInfo, g_golde1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden Axe (World) (v1.1)
static struct BurnRomInfo g_gaxeRomDesc[] = {
	{ "golden axe (world) (v1.1).md", 0x80000, 0x665d7df9, BRF_PRG },
};

STD_ROM_PICK(g_gaxe)
STD_ROM_FN(g_gaxe)

struct BurnDriverD BurnDrvMDg_gaxe = {
	"g_gaxe", NULL, NULL, "1900",
	"Golden Axe (World) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gaxeRomInfo, g_gaxeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden Axe (World)
static struct BurnRomInfo g_gaxeaRomDesc[] = {
	{ "golden axe (world).md", 0x80000, 0xe8182b90, BRF_PRG },
};

STD_ROM_PICK(g_gaxea)
STD_ROM_FN(g_gaxea)

struct BurnDriverD BurnDrvMDg_gaxea = {
	"g_gaxea", "g_gaxe", NULL, "1900",
	"Golden Axe (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gaxeaRomInfo, g_gaxeaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden Axe II (World) (Beta)
static struct BurnRomInfo g_gaxe2bRomDesc[] = {
	{ "golden axe ii (world) (beta).md", 0x80000, 0xe62ea1bb, BRF_PRG },
};

STD_ROM_PICK(g_gaxe2b)
STD_ROM_FN(g_gaxe2b)

struct BurnDriverD BurnDrvMDg_gaxe2b = {
	"g_gaxe2b", "g_gaxe2", NULL, "1900",
	"Golden Axe II (World) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gaxe2bRomInfo, g_gaxe2bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden Axe II (World)
static struct BurnRomInfo g_gaxe2RomDesc[] = {
	{ "golden axe ii (world).md", 0x80000, 0x725e0a18, BRF_PRG },
};

STD_ROM_PICK(g_gaxe2)
STD_ROM_FN(g_gaxe2)

struct BurnDriverD BurnDrvMDg_gaxe2 = {
	"g_gaxe2", NULL, NULL, "1900",
	"Golden Axe II (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gaxe2RomInfo, g_gaxe2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Golden Axe III (Japan)
static struct BurnRomInfo g_gaxe3RomDesc[] = {
	{ "golden axe iii (japan).md", 0x100000, 0xc7862ea3, BRF_PRG },
};

STD_ROM_PICK(g_gaxe3)
STD_ROM_FN(g_gaxe3)

struct BurnDriverD BurnDrvMDg_gaxe3 = {
	"g_gaxe3", NULL, NULL, "1900",
	"Golden Axe III (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gaxe3RomInfo, g_gaxe3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Goofy's Hysterical History Tour (USA)
static struct BurnRomInfo g_goofysRomDesc[] = {
	{ "goofy's hysterical history tour (usa).md", 0x100000, 0x4e1cc833, BRF_PRG },
};

STD_ROM_PICK(g_goofys)
STD_ROM_FN(g_goofys)

struct BurnDriverD BurnDrvMDg_goofys = {
	"g_goofys", NULL, NULL, "1900",
	"Goofy's Hysterical History Tour (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_goofysRomInfo, g_goofysRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gouketsuji Ichizoku (Japan)
static struct BurnRomInfo g_gouketRomDesc[] = {
	{ "gouketsuji ichizoku (japan).md", 0x300000, 0xabe9c415, BRF_PRG },
};

STD_ROM_PICK(g_gouket)
STD_ROM_FN(g_gouket)

struct BurnDriverD BurnDrvMDg_gouket = {
	"g_gouket", NULL, NULL, "1900",
	"Gouketsuji Ichizoku (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gouketRomInfo, g_gouketRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Granada (Japan, USA) (v1.1)
static struct BurnRomInfo g_granadRomDesc[] = {
	{ "granada (japan, usa) (v1.1).md", 0x80000, 0xe89d1e66, BRF_PRG },
};

STD_ROM_PICK(g_granad)
STD_ROM_FN(g_granad)

struct BurnDriverD BurnDrvMDg_granad = {
	"g_granad", NULL, NULL, "1900",
	"Granada (Japan, USA) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_granadRomInfo, g_granadRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Granada (Japan, USA)
static struct BurnRomInfo g_grana1RomDesc[] = {
	{ "granada (japan, usa).md", 0x80000, 0x7f45719b, BRF_PRG },
};

STD_ROM_PICK(g_grana1)
STD_ROM_FN(g_grana1)

struct BurnDriverD BurnDrvMDg_grana1 = {
	"g_grana1", "g_granad", NULL, "1900",
	"Granada (Japan, USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_grana1RomInfo, g_grana1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// GrandSlam - The Tennis Tournament '92 (Japan)
static struct BurnRomInfo g_grandsRomDesc[] = {
	{ "grandslam - the tennis tournament '92 (japan).md", 0x80000, 0x30cf37d0, BRF_PRG },
};

STD_ROM_PICK(g_grands)
STD_ROM_FN(g_grands)

struct BurnDriverD BurnDrvMDg_grands = {
	"g_grands", NULL, NULL, "1900",
	"GrandSlam - The Tennis Tournament '92 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_grandsRomInfo, g_grandsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// GrandSlam - The Tennis Tournament (Europe)
static struct BurnRomInfo g_grand1RomDesc[] = {
	{ "grandslam - the tennis tournament (europe).md", 0x80000, 0x8c2670de, BRF_PRG },
};

STD_ROM_PICK(g_grand1)
STD_ROM_FN(g_grand1)

struct BurnDriverD BurnDrvMDg_grand1 = {
	"g_grand1", "g_grands", NULL, "1900",
	"GrandSlam - The Tennis Tournament (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_grand1RomInfo, g_grand1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Great Circus Mystery - Mickey to Minnie Magical Adventure 2 (Japan)
static struct BurnRomInfo g_greatcRomDesc[] = {
	{ "great circus mystery - mickey to minnie magical adventure 2 (japan).md", 0x200000, 0x5aa0f3a0, BRF_PRG },
};

STD_ROM_PICK(g_greatc)
STD_ROM_FN(g_greatc)

struct BurnDriverD BurnDrvMDg_greatc = {
	"g_greatc", NULL, NULL, "1994",
	"Great Circus Mystery - Mickey to Minnie Magical Adventure 2 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_greatcRomInfo, g_greatcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Great Circus Mystery Starring Mickey & Minnie, The (USA)
static struct BurnRomInfo g_great1RomDesc[] = {
	{ "great circus mystery starring mickey & minnie, the (usa).md", 0x200000, 0x14744883, BRF_PRG },
};

STD_ROM_PICK(g_great1)
STD_ROM_FN(g_great1)

struct BurnDriverD BurnDrvMDg_great1 = {
	"g_great1", "g_greatc", NULL, "1994",
	"Great Circus Mystery Starring Mickey & Minnie, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_great1RomInfo, g_great1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Great Waldo Search, The (USA)
static struct BurnRomInfo g_greatwRomDesc[] = {
	{ "great waldo search, the (usa).md", 0x100000, 0x8c5c93b8, BRF_PRG },
};

STD_ROM_PICK(g_greatw)
STD_ROM_FN(g_greatw)

struct BurnDriverD BurnDrvMDg_greatw = {
	"g_greatw", NULL, NULL, "1900",
	"Great Waldo Search, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_greatwRomInfo, g_greatwRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Greatest Heavyweights (Europe)
static struct BurnRomInfo g_ghwRomDesc[] = {
	{ "greatest heavyweights (europe).md", 0x200000, 0x9778c181, BRF_PRG },
};

STD_ROM_PICK(g_ghw)
STD_ROM_FN(g_ghw)

struct BurnDriverD BurnDrvMDg_ghw = {
	"g_ghw", NULL, NULL, "",
	"Greatest Heavyweights (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ghwRomInfo, g_ghwRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Greatest Heavyweights (Japan)
static struct BurnRomInfo g_ghwjRomDesc[] = {
	{ "greatest heavyweights (japan).md", 0x200000, 0x7ef8b162, BRF_PRG },
};

STD_ROM_PICK(g_ghwj)
STD_ROM_FN(g_ghwj)

struct BurnDriverD BurnDrvMDg_ghwj = {
	"g_ghwj", "g_ghw", NULL, "1900",
	"Greatest Heavyweights (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ghwjRomInfo, g_ghwjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Greatest Heavyweights (USA)
static struct BurnRomInfo g_ghwuRomDesc[] = {
	{ "greatest heavyweights (usa).md", 0x200000, 0x6e3621d5, BRF_PRG },
};

STD_ROM_PICK(g_ghwu)
STD_ROM_FN(g_ghwu)

struct BurnDriverD BurnDrvMDg_ghwu = {
	"g_ghwu", "g_ghw", NULL, "1900",
	"Greatest Heavyweights (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ghwuRomInfo, g_ghwuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Greendog - The Beached Surfer Dude! (USA, Europe)
static struct BurnRomInfo g_greendRomDesc[] = {
	{ "greendog - the beached surfer dude! (usa, europe).md", 0x80000, 0xc4820a03, BRF_PRG },
};

STD_ROM_PICK(g_greend)
STD_ROM_FN(g_greend)

struct BurnDriverD BurnDrvMDg_greend = {
	"g_greend", NULL, NULL, "1900",
	"Greendog - The Beached Surfer Dude! (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_greendRomInfo, g_greendRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Grind Stormer (USA)
static struct BurnRomInfo g_grindsRomDesc[] = {
	{ "grind stormer (usa).md", 0x100000, 0x7e6bef15, BRF_PRG },
};

STD_ROM_PICK(g_grinds)
STD_ROM_FN(g_grinds)

struct BurnDriverD BurnDrvMDg_grinds = {
	"g_grinds", NULL, NULL, "1900",
	"Grind Stormer (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_grindsRomInfo, g_grindsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Growl (USA)
static struct BurnRomInfo g_growluRomDesc[] = {
	{ "growl (usa).md", 0x80000, 0xf60ef143, BRF_PRG },
};

STD_ROM_PICK(g_growlu)
STD_ROM_FN(g_growlu)

struct BurnDriverD BurnDrvMDg_growlu = {
	"g_growlu", NULL, NULL, "1900",
	"Growl (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_growluRomInfo, g_growluRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gunship (Europe)
static struct BurnRomInfo g_gunshiRomDesc[] = {
	{ "gunship (europe).md", 0x100000, 0xda1440c9, BRF_PRG },
};

STD_ROM_PICK(g_gunshi)
STD_ROM_FN(g_gunshi)

struct BurnDriverD BurnDrvMDg_gunshi = {
	"g_gunshi", NULL, NULL, "1900",
	"Gunship (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gunshiRomInfo, g_gunshiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gunstar Heroes (Europe)
static struct BurnRomInfo g_gunstaRomDesc[] = {
	{ "gunstar heroes (europe).md", 0x100000, 0x866ed9d0, BRF_PRG },
};

STD_ROM_PICK(g_gunsta)
STD_ROM_FN(g_gunsta)

struct BurnDriverD BurnDrvMDg_gunsta = {
	"g_gunsta", NULL, NULL, "1993",
	"Gunstar Heroes (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gunstaRomInfo, g_gunstaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gunstar Heroes (Japan) (Sample)
static struct BurnRomInfo g_gunst1RomDesc[] = {
	{ "gunstar heroes (japan) (sample).md", 0x100000, 0x6f90b502, BRF_PRG },
};

STD_ROM_PICK(g_gunst1)
STD_ROM_FN(g_gunst1)

struct BurnDriverD BurnDrvMDg_gunst1 = {
	"g_gunst1", "g_gunsta", NULL, "1993",
	"Gunstar Heroes (Japan) (Sample)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gunst1RomInfo, g_gunst1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gunstar Heroes (Japan)
static struct BurnRomInfo g_gunst2RomDesc[] = {
	{ "gunstar heroes (japan).md", 0x100000, 0x1cfd0383, BRF_PRG },
};

STD_ROM_PICK(g_gunst2)
STD_ROM_FN(g_gunst2)

struct BurnDriverD BurnDrvMDg_gunst2 = {
	"g_gunst2", "g_gunsta", NULL, "1993",
	"Gunstar Heroes (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gunst2RomInfo, g_gunst2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gunstar Heroes (USA)
static struct BurnRomInfo g_gunst3RomDesc[] = {
	{ "gunstar heroes (usa).md", 0x100000, 0xb813cf0d, BRF_PRG },
};

STD_ROM_PICK(g_gunst3)
STD_ROM_FN(g_gunst3)

struct BurnDriverD BurnDrvMDg_gunst3 = {
	"g_gunst3", "g_gunsta", NULL, "1993",
	"Gunstar Heroes (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gunst3RomInfo, g_gunst3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gynoug (Europe)
static struct BurnRomInfo g_gynougRomDesc[] = {
	{ "gynoug (europe).md", 0x80000, 0x03405102, BRF_PRG },
};

STD_ROM_PICK(g_gynoug)
STD_ROM_FN(g_gynoug)

struct BurnDriverD BurnDrvMDg_gynoug = {
	"g_gynoug", NULL, NULL, "1991",
	"Gynoug (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gynougRomInfo, g_gynougRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Gynoug (Japan)
static struct BurnRomInfo g_gynou1RomDesc[] = {
	{ "gynoug (japan).md", 0x80000, 0x1b69241f, BRF_PRG },
};

STD_ROM_PICK(g_gynou1)
STD_ROM_FN(g_gynou1)

struct BurnDriverD BurnDrvMDg_gynou1 = {
	"g_gynou1", "g_gynoug", NULL, "1991",
	"Gynoug (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_gynou1RomInfo, g_gynou1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hard Drivin' (World)
static struct BurnRomInfo g_harddrRomDesc[] = {
	{ "hard drivin' (world).md", 0x40000, 0x3225baaf, BRF_PRG },
};

STD_ROM_PICK(g_harddr)
STD_ROM_FN(g_harddr)

struct BurnDriverD BurnDrvMDg_harddr = {
	"g_harddr", NULL, NULL, "1990",
	"Hard Drivin' (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_harddrRomInfo, g_harddrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// HardBall '94 (USA, Europe)
static struct BurnRomInfo g_hard94RomDesc[] = {
	{ "hardball '94 (usa, europe).md", 0x200000, 0xea9c4878, BRF_PRG },
};

STD_ROM_PICK(g_hard94)
STD_ROM_FN(g_hard94)

struct BurnDriver BurnDrvMDg_hard94 = {
	"g_hard94", NULL, NULL, "1900",
	"HardBall '94 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hard94RomInfo, g_hard94RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// HardBall '95 (USA)
static struct BurnRomInfo g_hard95RomDesc[] = {
	{ "hardball '95 (usa).md", 0x300000, 0xed10bc9e, BRF_PRG },
};

STD_ROM_PICK(g_hard95)
STD_ROM_FN(g_hard95)

struct BurnDriver BurnDrvMDg_hard95 = {
	"g_hard95", NULL, NULL, "1900",
	"HardBall '95 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hard95RomInfo, g_hard95RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x300000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// HardBall III (USA)
static struct BurnRomInfo g_hard3RomDesc[] = {
	{ "hardball iii (usa).md", 0x200000, 0xa4f2f011, BRF_PRG },
};

STD_ROM_PICK(g_hard3)
STD_ROM_FN(g_hard3)

struct BurnDriver BurnDrvMDg_hard3 = {
	"g_hard3", NULL, NULL, "1900",
	"HardBall III (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hard3RomInfo, g_hard3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// HardBall! (USA)
static struct BurnRomInfo g_hardbRomDesc[] = {
	{ "hardball! (usa).md", 0x100000, 0xbd1b9a04, BRF_PRG },
};

STD_ROM_PICK(g_hardb)
STD_ROM_FN(g_hardb)

struct BurnDriverD BurnDrvMDg_hardb = {
	"g_hardb", NULL, NULL, "1900",
	"HardBall! (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hardbRomInfo, g_hardbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Haunting Starring Polterguy (USA, Europe)
static struct BurnRomInfo g_hauntiRomDesc[] = {
	{ "haunting starring polterguy (usa, europe).md", 0x200000, 0xc9fc876d, BRF_PRG },
};

STD_ROM_PICK(g_haunti)
STD_ROM_FN(g_haunti)

struct BurnDriverD BurnDrvMDg_haunti = {
	"g_haunti", NULL, NULL, "1900",
	"Haunting Starring Polterguy (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hauntiRomInfo, g_hauntiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Capt'n Havoc (Europe)
static struct BurnRomInfo g_havoceRomDesc[] = {
	{ "capt'n havoc (europe).md", 0x100000, 0x76e6d20d, BRF_PRG },
};

STD_ROM_PICK(g_havoce)
STD_ROM_FN(g_havoce)

struct BurnDriverD BurnDrvMDg_havoce = {
	"g_havoce", NULL, NULL, "1994",
	"Capt'n Havoc (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_havoceRomInfo, g_havoceRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Head-On Soccer (USA)
static struct BurnRomInfo g_headonRomDesc[] = {
	{ "head-on soccer (usa).md", 0x200000, 0xdcffa327, BRF_PRG },
};

STD_ROM_PICK(g_headon)
STD_ROM_FN(g_headon)

struct BurnDriverD BurnDrvMDg_headon = {
	"g_headon", "g_feverp", NULL, "1900",
	"Head-On Soccer (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_headonRomInfo, g_headonRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Heavy Nova (USA)
static struct BurnRomInfo g_heavynRomDesc[] = {
	{ "heavy nova (usa).md", 0x100000, 0xf6b6a9d8, BRF_PRG },
};

STD_ROM_PICK(g_heavyn)
STD_ROM_FN(g_heavyn)

struct BurnDriverD BurnDrvMDg_heavyn = {
	"g_heavyn", NULL, NULL, "1900",
	"Heavy Nova (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_heavynRomInfo, g_heavynRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Heavy Unit - Mega Drive Special (Japan)
static struct BurnRomInfo g_heavyuRomDesc[] = {
	{ "heavy unit - mega drive special (japan).md", 0x80000, 0x1acbe608, BRF_PRG },
};

STD_ROM_PICK(g_heavyu)
STD_ROM_FN(g_heavyu)

struct BurnDriverD BurnDrvMDg_heavyu = {
	"g_heavyu", NULL, NULL, "1900",
	"Heavy Unit - Mega Drive Special (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_heavyuRomInfo, g_heavyuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hei Tao 2 - Super Big 2 (China) (Unl)
static struct BurnRomInfo g_heitaoRomDesc[] = {
	{ "hei tao 2 - super big 2 (china) (unl).md", 0x100000, 0x31449113, BRF_PRG },
};

STD_ROM_PICK(g_heitao)
STD_ROM_FN(g_heitao)

struct BurnDriverD BurnDrvMDg_heitao = {
	"g_heitao", NULL, NULL, "",
	"Hei Tao 2 - Super Big 2 (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_heitaoRomInfo, g_heitaoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hellfire (Europe)
static struct BurnRomInfo g_hellfiRomDesc[] = {
	{ "hellfire (europe).md", 0x80000, 0xcf30acec, BRF_PRG },
};

STD_ROM_PICK(g_hellfi)
STD_ROM_FN(g_hellfi)

struct BurnDriverD BurnDrvMDg_hellfi = {
	"g_hellfi", NULL, NULL, "1900",
	"Hellfire (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hellfiRomInfo, g_hellfiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hellfire (Japan)
static struct BurnRomInfo g_hellf1RomDesc[] = {
	{ "hellfire (japan).md", 0x80000, 0x8e5e13ba, BRF_PRG },
};

STD_ROM_PICK(g_hellf1)
STD_ROM_FN(g_hellf1)

struct BurnDriverD BurnDrvMDg_hellf1 = {
	"g_hellf1", "g_hellfi", NULL, "1900",
	"Hellfire (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hellf1RomInfo, g_hellf1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hellfire (USA)
static struct BurnRomInfo g_hellf2RomDesc[] = {
	{ "hellfire (usa).md", 0x80000, 0x184018f9, BRF_PRG },
};

STD_ROM_PICK(g_hellf2)
STD_ROM_FN(g_hellf2)

struct BurnDriverD BurnDrvMDg_hellf2 = {
	"g_hellf2", "g_hellfi", NULL, "1900",
	"Hellfire (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hellf2RomInfo, g_hellf2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hercules (Unl) [!]
static struct BurnRomInfo g_herculRomDesc[] = {
	{ "hercules (unl) [!].md", 0x100000, 0xff75d9d0, BRF_PRG },
};

STD_ROM_PICK(g_hercul)
STD_ROM_FN(g_hercul)

struct BurnDriverD BurnDrvMDg_hercul = {
	"g_hercul", "g_dahnam", NULL, "1900",
	"Hercules (Unl) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_herculRomInfo, g_herculRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hercules 2 (Unl)
static struct BurnRomInfo g_herc2RomDesc[] = {
	{ "hercules 2 (unl).md", 0x200000, 0x292623db, BRF_PRG },
};

STD_ROM_PICK(g_herc2)
STD_ROM_FN(g_herc2)

struct BurnDriverD BurnDrvMDg_herc2 = {
	"g_herc2", NULL, NULL, "",
	"Hercules 2 (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_herc2RomInfo, g_herc2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Herzog Zwei (Japan)
static struct BurnRomInfo g_herzjRomDesc[] = {
	{ "herzog zwei (japan).md", 0x80000, 0x4cf676b3, BRF_PRG },
};

STD_ROM_PICK(g_herzj)
STD_ROM_FN(g_herzj)

struct BurnDriverD BurnDrvMDg_herzj = {
	"g_herzj", "g_herz", NULL, "1900",
	"Herzog Zwei (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_herzjRomInfo, g_herzjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Herzog Zwei (USA, Europe)
static struct BurnRomInfo g_herzRomDesc[] = {
	{ "herzog zwei (usa, europe).md", 0x80000, 0xa605b65b, BRF_PRG },
};

STD_ROM_PICK(g_herz)
STD_ROM_FN(g_herz)

struct BurnDriverD BurnDrvMDg_herz = {
	"g_herz", NULL, NULL, "",
	"Herzog Zwei (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_herzRomInfo, g_herzRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// High Seas Havoc (USA)
static struct BurnRomInfo g_highseRomDesc[] = {
	{ "high seas havoc (usa).md", 0x100000, 0x17be551c, BRF_PRG },
};

STD_ROM_PICK(g_highse)
STD_ROM_FN(g_highse)

struct BurnDriverD BurnDrvMDg_highse = {
	"g_highse", "g_havoce", NULL, "1993",
	"High Seas Havoc (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_highseRomInfo, g_highseRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hit the Ice (USA)
static struct BurnRomInfo g_hittheRomDesc[] = {
	{ "hit the ice (usa).md", 0x80000, 0x85b23606, BRF_PRG },
};

STD_ROM_PICK(g_hitthe)
STD_ROM_FN(g_hitthe)

struct BurnDriverD BurnDrvMDg_hitthe = {
	"g_hitthe", NULL, NULL, "1900",
	"Hit the Ice (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hittheRomInfo, g_hittheRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hokuto no Ken - Shin Seikimatsu Kyuuseishu Densetsu (Japan)
static struct BurnRomInfo g_hokutoRomDesc[] = {
	{ "hokuto no ken - shin seikimatsu kyuuseishu densetsu (japan).md", 0x80000, 0x1b6585e7, BRF_PRG },
};

STD_ROM_PICK(g_hokuto)
STD_ROM_FN(g_hokuto)

struct BurnDriverD BurnDrvMDg_hokuto = {
	"g_hokuto", "g_lastba", NULL, "1900",
	"Hokuto no Ken - Shin Seikimatsu Kyuuseishu Densetsu (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hokutoRomInfo, g_hokutoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Home Alone (USA) (Beta)
static struct BurnRomInfo g_homeabRomDesc[] = {
	{ "home alone (usa) (beta).md", 0x100000, 0x3a235fb9, BRF_PRG },
};

STD_ROM_PICK(g_homeab)
STD_ROM_FN(g_homeab)

struct BurnDriverD BurnDrvMDg_homeab = {
	"g_homeab", "g_homea", NULL, "1900",
	"Home Alone (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_homeabRomInfo, g_homeabRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Home Alone (USA, Europe)
static struct BurnRomInfo g_homeaRomDesc[] = {
	{ "home alone (usa, europe).md", 0x80000, 0xaa0d4387, BRF_PRG },
};

STD_ROM_PICK(g_homea)
STD_ROM_FN(g_homea)

struct BurnDriverD BurnDrvMDg_homea = {
	"g_homea", NULL, NULL, "1900",
	"Home Alone (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_homeaRomInfo, g_homeaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Home Alone 2 - Lost in New York (USA)
static struct BurnRomInfo g_homea2RomDesc[] = {
	{ "home alone 2 - lost in new york (usa).md", 0x80000, 0xcbf87c14, BRF_PRG },
};

STD_ROM_PICK(g_homea2)
STD_ROM_FN(g_homea2)

struct BurnDriverD BurnDrvMDg_homea2 = {
	"g_homea2", NULL, NULL, "1900",
	"Home Alone 2 - Lost in New York (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_homea2RomInfo, g_homea2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Honoo no Toukyuuji Dodge Danpei (Japan)
static struct BurnRomInfo g_honoonRomDesc[] = {
	{ "honoo no toukyuuji dodge danpei (japan).md", 0x80000, 0x630f07c6, BRF_PRG },
};

STD_ROM_PICK(g_honoon)
STD_ROM_FN(g_honoon)

struct BurnDriverD BurnDrvMDg_honoon = {
	"g_honoon", NULL, NULL, "1900",
	"Honoo no Toukyuuji Dodge Danpei (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_honoonRomInfo, g_honoonRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hook (USA)
static struct BurnRomInfo g_hookusRomDesc[] = {
	{ "hook (usa).md", 0x100000, 0x2c48e712, BRF_PRG },
};

STD_ROM_PICK(g_hookus)
STD_ROM_FN(g_hookus)

struct BurnDriverD BurnDrvMDg_hookus = {
	"g_hookus", NULL, NULL, "1900",
	"Hook (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hookusRomInfo, g_hookusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hua Mu Lan - Mulan (China) (Unl)
static struct BurnRomInfo g_huamulRomDesc[] = {
	{ "hua mu lan - mulan (china) (unl).md", 0x200000, 0x796882b8, BRF_PRG },
};

STD_ROM_PICK(g_huamul)
STD_ROM_FN(g_huamul)

struct BurnDriverD BurnDrvMDg_huamul = {
	"g_huamul", NULL, NULL, "",
	"Hua Mu Lan - Mulan (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_huamulRomInfo, g_huamulRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Huan Le Tao Qi Shu - Smart Mouse (China) (Unl)
static struct BurnRomInfo g_huanleRomDesc[] = {
	{ "huan le tao qi shu - smart mouse (china) (unl).md", 0x80000, 0xdecdf740, BRF_PRG },
};

STD_ROM_PICK(g_huanle)
STD_ROM_FN(g_huanle)

struct BurnDriverD BurnDrvMDg_huanle = {
	"g_huanle", NULL, NULL, "",
	"Huan Le Tao Qi Shu - Smart Mouse (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_huanleRomInfo, g_huanleRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Humans, The (USA)
static struct BurnRomInfo g_humansRomDesc[] = {
	{ "humans, the (usa).md", 0x100000, 0xa0cf4366, BRF_PRG },
};

STD_ROM_PICK(g_humans)
STD_ROM_FN(g_humans)

struct BurnDriverD BurnDrvMDg_humans = {
	"g_humans", NULL, NULL, "1900",
	"Humans, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_humansRomInfo, g_humansRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hurricanes (Europe)
static struct BurnRomInfo g_hurricRomDesc[] = {
	{ "hurricanes (europe).md", 0x200000, 0xdeccc874, BRF_PRG },
};

STD_ROM_PICK(g_hurric)
STD_ROM_FN(g_hurric)

struct BurnDriverD BurnDrvMDg_hurric = {
	"g_hurric", NULL, NULL, "1900",
	"Hurricanes (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hurricRomInfo, g_hurricRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hybrid Front, The (Japan) (Beta)
static struct BurnRomInfo g_hybribRomDesc[] = {
	{ "hybrid front, the (japan) (beta).md", 0x300000, 0x04f02687, BRF_PRG },
};

STD_ROM_PICK(g_hybrib)
STD_ROM_FN(g_hybrib)

struct BurnDriverD BurnDrvMDg_hybrib = {
	"g_hybrib", "g_hybri", NULL, "1900",
	"Hybrid Front, The (Japan) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hybribRomInfo, g_hybribRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hybrid Front, The (Japan)
static struct BurnRomInfo g_hybriRomDesc[] = {
	{ "hybrid front, the (japan).md", 0x200000, 0xa1f1cfe7, BRF_PRG },
};

STD_ROM_PICK(g_hybri)
STD_ROM_FN(g_hybri)

struct BurnDriver BurnDrvMDg_hybri = {
	"g_hybri", NULL, NULL, "1900",
	"Hybrid Front, The (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hybriRomInfo, g_hybriRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyokkori Hyoutanjima - Daitouryou wo Mezase! (Japan)
static struct BurnRomInfo g_hyokkoRomDesc[] = {
	{ "hyokkori hyoutanjima - daitouryou wo mezase! (japan).md", 0x80000, 0x72253bdb, BRF_PRG },
};

STD_ROM_PICK(g_hyokko)
STD_ROM_FN(g_hyokko)

struct BurnDriverD BurnDrvMDg_hyokko = {
	"g_hyokko", NULL, NULL, "1900",
	"Hyokkori Hyoutanjima - Daitouryou wo Mezase! (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hyokkoRomInfo, g_hyokkoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyper Dunk (Europe)
static struct BurnRomInfo g_hyperdRomDesc[] = {
	{ "hyper dunk (europe).md", 0x200000, 0xf27c576a, BRF_PRG },
};

STD_ROM_PICK(g_hyperd)
STD_ROM_FN(g_hyperd)

struct BurnDriverD BurnDrvMDg_hyperd = {
	"g_hyperd", NULL, NULL, "1900",
	"Hyper Dunk (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hyperdRomInfo, g_hyperdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyper Dunk - The Playoff Edition (Japan) (Beta)
static struct BurnRomInfo g_hyper1RomDesc[] = {
	{ "hyper dunk - the playoff edition (japan) (beta).md", 0x200000, 0xdb124bbb, BRF_PRG },
};

STD_ROM_PICK(g_hyper1)
STD_ROM_FN(g_hyper1)

struct BurnDriverD BurnDrvMDg_hyper1 = {
	"g_hyper1", "g_hyperd", NULL, "1900",
	"Hyper Dunk - The Playoff Edition (Japan) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hyper1RomInfo, g_hyper1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyper Dunk - The Playoff Edition (Japan)
static struct BurnRomInfo g_hyper2RomDesc[] = {
	{ "hyper dunk - the playoff edition (japan).md", 0x200000, 0x5baf53d7, BRF_PRG },
};

STD_ROM_PICK(g_hyper2)
STD_ROM_FN(g_hyper2)

struct BurnDriverD BurnDrvMDg_hyper2 = {
	"g_hyper2", "g_hyperd", NULL, "1900",
	"Hyper Dunk - The Playoff Edition (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hyper2RomInfo, g_hyper2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyper Marbles (Japan) (SegaNet)
static struct BurnRomInfo g_hypemRomDesc[] = {
	{ "hyper marbles (japan) (seganet).md", 0x40000, 0x83bb2799, BRF_PRG },
};

STD_ROM_PICK(g_hypem)
STD_ROM_FN(g_hypem)

struct BurnDriverD BurnDrvMDg_hypem = {
	"g_hypem", NULL, NULL, "1994",
	"Hyper Marbles (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hypemRomInfo, g_hypemRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Hyper Marbles (SN) (GNKO) (J) [!]
static struct BurnRomInfo g_hypemaRomDesc[] = {
	{ "hyper marbles (sn) (gnko) (j) [!].md", 0x40000, 0x9ed72146, BRF_PRG },
};

STD_ROM_PICK(g_hypema)
STD_ROM_FN(g_hypema)

struct BurnDriverD BurnDrvMDg_hypema = {
	"g_hypema", "g_hypem", NULL, "",
	"Hyper Marbles (SN) (GNKO) (J) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_hypemaRomInfo, g_hypemaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ikazuse! Koi no Doki Doki Penguin Land MD (Japan) (SegaNet)
static struct BurnRomInfo g_ikazusRomDesc[] = {
	{ "ikazuse! koi no doki doki penguin land md (japan) (seganet).md", 0x40000, 0x0053bfd6, BRF_PRG },
};

STD_ROM_PICK(g_ikazus)
STD_ROM_FN(g_ikazus)

struct BurnDriverD BurnDrvMDg_ikazus = {
	"g_ikazus", "g_dokido", NULL, "1994",
	"Ikazuse! Koi no Doki Doki Penguin Land MD (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ikazusRomInfo, g_ikazusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// IMG International Tour Tennis (USA, Europe)
static struct BurnRomInfo g_imgintRomDesc[] = {
	{ "img international tour tennis (usa, europe).md", 0x200000, 0xe04ffc2b, BRF_PRG },
};

STD_ROM_PICK(g_imgint)
STD_ROM_FN(g_imgint)

struct BurnDriverD BurnDrvMDg_imgint = {
	"g_imgint", NULL, NULL, "1900",
	"IMG International Tour Tennis (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_imgintRomInfo, g_imgintRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Immortal, The (USA, Europe)
static struct BurnRomInfo g_immortRomDesc[] = {
	{ "immortal, the (usa, europe).md", 0x100000, 0xf653c508, BRF_PRG },
};

STD_ROM_PICK(g_immort)
STD_ROM_FN(g_immort)

struct BurnDriverD BurnDrvMDg_immort = {
	"g_immort", NULL, NULL, "1900",
	"Immortal, The (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_immortRomInfo, g_immortRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Incredible Crash Dummies, The (USA) (Beta)
static struct BurnRomInfo g_ictdbRomDesc[] = {
	{ "incredible crash dummies, the (usa) (beta).md", 0x100000, 0x623a920f, BRF_PRG },
};

STD_ROM_PICK(g_ictdb)
STD_ROM_FN(g_ictdb)

struct BurnDriverD BurnDrvMDg_ictdb = {
	"g_ictdb", "g_ictd", NULL, "1900",
	"Incredible Crash Dummies, The (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ictdbRomInfo, g_ictdbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Incredible Crash Dummies, The (USA, Europe)
static struct BurnRomInfo g_ictdRomDesc[] = {
	{ "incredible crash dummies, the (usa, europe).md", 0x100000, 0x1f6e574a, BRF_PRG },
};

STD_ROM_PICK(g_ictd)
STD_ROM_FN(g_ictd)

struct BurnDriverD BurnDrvMDg_ictd = {
	"g_ictd", NULL, NULL, "1900",
	"Incredible Crash Dummies, The (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ictdRomInfo, g_ictdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Incredible Hulk, The (USA, Europe)
static struct BurnRomInfo g_inhulkRomDesc[] = {
	{ "incredible hulk, the (usa, europe).md", 0x200000, 0x84a5a2dc, BRF_PRG },
};

STD_ROM_PICK(g_inhulk)
STD_ROM_FN(g_inhulk)

struct BurnDriverD BurnDrvMDg_inhulk = {
	"g_inhulk", NULL, NULL, "1900",
	"Incredible Hulk, The (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_inhulkRomInfo, g_inhulkRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Indiana Jones and the Last Crusade (Europe)
static struct BurnRomInfo g_indianRomDesc[] = {
	{ "indiana jones and the last crusade (europe).md", 0x100000, 0xeb8f4374, BRF_PRG },
};

STD_ROM_PICK(g_indian)
STD_ROM_FN(g_indian)

struct BurnDriverD BurnDrvMDg_indian = {
	"g_indian", NULL, NULL, "1900",
	"Indiana Jones and the Last Crusade (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_indianRomInfo, g_indianRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Indiana Jones and the Last Crusade (USA)
static struct BurnRomInfo g_india1RomDesc[] = {
	{ "indiana jones and the last crusade (usa).md", 0x100000, 0x3599a3fd, BRF_PRG },
};

STD_ROM_PICK(g_india1)
STD_ROM_FN(g_india1)

struct BurnDriverD BurnDrvMDg_india1 = {
	"g_india1", "g_indian", NULL, "1900",
	"Indiana Jones and the Last Crusade (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_india1RomInfo, g_india1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Indiana Jones' Greatest Adventures (Release Candidate)
static struct BurnRomInfo g_indyRomDesc[] = {
	{ "indiana jones' greatest adventures (release candidate).md", 0x200000, 0x9a01974e, BRF_PRG },
};

STD_ROM_PICK(g_indy)
STD_ROM_FN(g_indy)

struct BurnDriverD BurnDrvMDg_indy = {
	"g_indy", NULL, NULL, "",
	"Indiana Jones' Greatest Adventures (Release Candidate)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_indyRomInfo, g_indyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Insector X (Japan, Korea)
static struct BurnRomInfo g_insecjRomDesc[] = {
	{ "insector x (japan, korea).md", 0x80000, 0x9625c434, BRF_PRG },
};

STD_ROM_PICK(g_insecj)
STD_ROM_FN(g_insecj)

struct BurnDriverD BurnDrvMDg_insecj = {
	"g_insecj", "g_insec", NULL, "1900",
	"Insector X (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_insecjRomInfo, g_insecjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Insector X (USA)
static struct BurnRomInfo g_insecRomDesc[] = {
	{ "insector x (usa).md", 0x80000, 0x70626304, BRF_PRG },
};

STD_ROM_PICK(g_insec)
STD_ROM_FN(g_insec)

struct BurnDriverD BurnDrvMDg_insec = {
	"g_insec", NULL, NULL, "1900",
	"Insector X (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_insecRomInfo, g_insecRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (USA) (Beta)
static struct BurnRomInfo g_instbRomDesc[] = {
	{ "instruments of chaos starring young indiana jones (usa) (beta).md", 0x180000, 0xad6c2050, BRF_PRG },
};

STD_ROM_PICK(g_instb)
STD_ROM_FN(g_instb)

struct BurnDriverD BurnDrvMDg_instb = {
	"g_instb", "g_inst", NULL, "1900",
	"Instruments of Chaos Starring Young Indiana Jones (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_instbRomInfo, g_instbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Instruments of Chaos Starring Young Indiana Jones (USA)
static struct BurnRomInfo g_instRomDesc[] = {
	{ "instruments of chaos starring young indiana jones (usa).md", 0x100000, 0x4e384ef0, BRF_PRG },
};

STD_ROM_PICK(g_inst)
STD_ROM_FN(g_inst)

struct BurnDriverD BurnDrvMDg_inst = {
	"g_inst", NULL, NULL, "1900",
	"Instruments of Chaos Starring Young Indiana Jones (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_instRomInfo, g_instRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// International Rugby (Europe)
static struct BurnRomInfo g_internRomDesc[] = {
	{ "international rugby (europe).md", 0x80000, 0xd97d1699, BRF_PRG },
};

STD_ROM_PICK(g_intern)
STD_ROM_FN(g_intern)

struct BurnDriverD BurnDrvMDg_intern = {
	"g_intern", NULL, NULL, "1900",
	"International Rugby (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_internRomInfo, g_internRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// International Superstar Soccer Deluxe (Europe)
static struct BurnRomInfo g_inter1RomDesc[] = {
	{ "international superstar soccer deluxe (europe).md", 0x200000, 0x9bb3b180, BRF_PRG },
};

STD_ROM_PICK(g_inter1)
STD_ROM_FN(g_inter1)

struct BurnDriverD BurnDrvMDg_inter1 = {
	"g_inter1", NULL, NULL, "1996",
	"International Superstar Soccer Deluxe (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_inter1RomInfo, g_inter1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Iraq War 2003 (Unl)
static struct BurnRomInfo g_iraqwaRomDesc[] = {
	{ "iraq war 2003 (unl).md", 0x100000, 0x49dd6f52, BRF_PRG },
};

STD_ROM_PICK(g_iraqwa)
STD_ROM_FN(g_iraqwa)

struct BurnDriverD BurnDrvMDg_iraqwa = {
	"g_iraqwa", NULL, NULL, "",
	"Iraq War 2003 (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_iraqwaRomInfo, g_iraqwaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ishido - The Way of Stones (USA)
static struct BurnRomInfo g_ishidoRomDesc[] = {
	{ "ishido - the way of stones (usa).md", 0x20000, 0xb1de7d5e, BRF_PRG },
};

STD_ROM_PICK(g_ishido)
STD_ROM_FN(g_ishido)

struct BurnDriverD BurnDrvMDg_ishido = {
	"g_ishido", NULL, NULL, "1900",
	"Ishido - The Way of Stones (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ishidoRomInfo, g_ishidoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// It Came from the Desert (USA)
static struct BurnRomInfo g_itcameRomDesc[] = {
	{ "it came from the desert (usa).md", 0x80000, 0x25afb4f7, BRF_PRG },
};

STD_ROM_PICK(g_itcame)
STD_ROM_FN(g_itcame)

struct BurnDriverD BurnDrvMDg_itcame = {
	"g_itcame", NULL, NULL, "1900",
	"It Came from the Desert (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_itcameRomInfo, g_itcameRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Itchy and Scratchy Game, The (USA) (Proto)
static struct BurnRomInfo g_itchyaRomDesc[] = {
	{ "itchy and scratchy game, the (usa) (proto).md", 0x100000, 0x81b7725d, BRF_PRG },
};

STD_ROM_PICK(g_itchya)
STD_ROM_FN(g_itchya)

struct BurnDriverD BurnDrvMDg_itchya = {
	"g_itchya", NULL, NULL, "1900",
	"Itchy and Scratchy Game, The (USA) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_itchyaRomInfo, g_itchyaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Izzy's Quest for the Olympic Rings (USA, Europe)
static struct BurnRomInfo g_izzysqRomDesc[] = {
	{ "izzy's quest for the olympic rings (usa, europe).md", 0x200000, 0x77b416e4, BRF_PRG },
};

STD_ROM_PICK(g_izzysq)
STD_ROM_FN(g_izzysq)

struct BurnDriverD BurnDrvMDg_izzysq = {
	"g_izzysq", NULL, NULL, "1900",
	"Izzy's Quest for the Olympic Rings (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_izzysqRomInfo, g_izzysqRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// J. League Champion Soccer (Japan)
static struct BurnRomInfo g_jlRomDesc[] = {
	{ "j. league champion soccer (japan).md", 0x80000, 0x453c405e, BRF_PRG },
};

STD_ROM_PICK(g_jl)
STD_ROM_FN(g_jl)

struct BurnDriver BurnDrvMDg_jl = {
	"g_jl", NULL, NULL, "1900",
	"J. League Champion Soccer (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jlRomInfo, g_jlRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// J. League Pro Striker (Japan) (v1.0)
static struct BurnRomInfo g_jl_psRomDesc[] = {
	{ "j. league pro striker (japan) (v1.0).md", 0x100000, 0xec229156, BRF_PRG },
};

STD_ROM_PICK(g_jl_ps)
STD_ROM_FN(g_jl_ps)

struct BurnDriver BurnDrvMDg_jl_ps = {
	"g_jl_ps", NULL, NULL, "1900",
	"J. League Pro Striker (Japan) (v1.0)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jl_psRomInfo, g_jl_psRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// J. League Pro Striker (Japan) (v1.3)
static struct BurnRomInfo g_jl_psaRomDesc[] = {
	{ "j. league pro striker (japan) (v1.3).md", 0x100000, 0x2d5b7a11, BRF_PRG },
};

STD_ROM_PICK(g_jl_psa)
STD_ROM_FN(g_jl_psa)

struct BurnDriver BurnDrvMDg_jl_psa = {
	"g_jl_psa", "g_jl_ps", NULL, "1900",
	"J. League Pro Striker (Japan) (v1.3)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jl_psaRomInfo, g_jl_psaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// J. League Pro Striker 2 (Japan)
static struct BurnRomInfo g_jl_ps2RomDesc[] = {
	{ "j. league pro striker 2 (japan).md", 0x200000, 0x9fe71002, BRF_PRG },
};

STD_ROM_PICK(g_jl_ps2)
STD_ROM_FN(g_jl_ps2)

struct BurnDriver BurnDrvMDg_jl_ps2 = {
	"g_jl_ps2", NULL, NULL, "1900",
	"J. League Pro Striker 2 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jl_ps2RomInfo, g_jl_ps2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// J. League Pro Striker Final Stage (Japan)
static struct BurnRomInfo g_jl_fsRomDesc[] = {
	{ "j. league pro striker final stage (japan).md", 0x200000, 0xe35e25fb, BRF_PRG },
};

STD_ROM_PICK(g_jl_fs)
STD_ROM_FN(g_jl_fs)

struct BurnDriver BurnDrvMDg_jl_fs = {
	"g_jl_fs", NULL, NULL, "1900",
	"J. League Pro Striker Final Stage (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jl_fsRomInfo, g_jl_fsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// J. League Pro Striker Perfect (Japan)
static struct BurnRomInfo g_jl_pfRomDesc[] = {
	{ "j. league pro striker perfect (japan).md", 0x100000, 0x0abed379, BRF_PRG },
};

STD_ROM_PICK(g_jl_pf)
STD_ROM_FN(g_jl_pf)

struct BurnDriver BurnDrvMDg_jl_pf = {
	"g_jl_pf", NULL, NULL, "1900",
	"J. League Pro Striker Perfect (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jl_pfRomInfo, g_jl_pfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jack Nicklaus' Power Challenge Golf (USA, Europe)
static struct BurnRomInfo g_jackniRomDesc[] = {
	{ "jack nicklaus' power challenge golf (usa, europe).md", 0x100000, 0x5545e909, BRF_PRG },
};

STD_ROM_PICK(g_jackni)
STD_ROM_FN(g_jackni)

struct BurnDriver BurnDrvMDg_jackni = {
	"g_jackni", NULL, NULL, "1900",
	"Jack Nicklaus' Power Challenge Golf (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jackniRomInfo, g_jackniRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x800_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James 'Buster' Douglas Knockout Boxing (USA, Europe)
static struct BurnRomInfo g_jamesbRomDesc[] = {
	{ "james 'buster' douglas knockout boxing (usa, europe).md", 0x80000, 0x87bbcf2a, BRF_PRG },
};

STD_ROM_PICK(g_jamesb)
STD_ROM_FN(g_jamesb)

struct BurnDriverD BurnDrvMDg_jamesb = {
	"g_jamesb", NULL, NULL, "1900",
	"James 'Buster' Douglas Knockout Boxing (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jamesbRomInfo, g_jamesbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Bond 007 - The Duel (Europe) (Rev A)
static struct BurnRomInfo g_jb007RomDesc[] = {
	{ "james bond 007 - the duel (europe) (rev a).md", 0x80000, 0x291a3e4b, BRF_PRG },
};

STD_ROM_PICK(g_jb007)
STD_ROM_FN(g_jb007)

struct BurnDriverD BurnDrvMDg_jb007 = {
	"g_jb007", NULL, NULL, "1993",
	"James Bond 007 - The Duel (Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jb007RomInfo, g_jb007RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Bond 007 - The Duel (USA)
static struct BurnRomInfo g_jb007aRomDesc[] = {
	{ "james bond 007 - the duel (usa).md", 0x80000, 0x4e614548, BRF_PRG },
};

STD_ROM_PICK(g_jb007a)
STD_ROM_FN(g_jb007a)

struct BurnDriverD BurnDrvMDg_jb007a = {
	"g_jb007a", "g_jb007", NULL, "1993",
	"James Bond 007 - The Duel (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jb007aRomInfo, g_jb007aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Pond - Underwater Agent (USA, Europe)
static struct BurnRomInfo g_jamespRomDesc[] = {
	{ "james pond - underwater agent (usa, europe).md", 0x80000, 0xd0e7b466, BRF_PRG },
};

STD_ROM_PICK(g_jamesp)
STD_ROM_FN(g_jamesp)

struct BurnDriverD BurnDrvMDg_jamesp = {
	"g_jamesp", NULL, NULL, "1991",
	"James Pond - Underwater Agent (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jamespRomInfo, g_jamespRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Pond 3 - Operation Starfish (USA, Europe)
static struct BurnRomInfo g_james3RomDesc[] = {
	{ "james pond 3 - operation starfish (usa, europe).md", 0x200000, 0x26f64b2a, BRF_PRG },
};

STD_ROM_PICK(g_james3)
STD_ROM_FN(g_james3)

struct BurnDriverD BurnDrvMDg_james3 = {
	"g_james3", NULL, NULL, "1993",
	"James Pond 3 - Operation Starfish (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_james3RomInfo, g_james3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Pond II - Codename Robocod (Japan, Korea)
static struct BurnRomInfo g_jrobojRomDesc[] = {
	{ "james pond ii - codename robocod (japan, korea).md", 0x80000, 0x98794702, BRF_PRG },
};

STD_ROM_PICK(g_jroboj)
STD_ROM_FN(g_jroboj)

struct BurnDriver BurnDrvMDg_jroboj = {
	"g_jroboj", "g_jrobo", NULL, "1991",
	"James Pond II - Codename Robocod (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jrobojRomInfo, g_jrobojRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// James Pond II - Codename Robocod (USA, Europe)
static struct BurnRomInfo g_jroboRomDesc[] = {
	{ "james pond ii - codename robocod (usa, europe).md", 0x80000, 0xf4abedba, BRF_PRG },
};

STD_ROM_PICK(g_jrobo)
STD_ROM_FN(g_jrobo)

struct BurnDriver BurnDrvMDg_jrobo = {
	"g_jrobo", NULL, NULL, "1991",
	"James Pond II - Codename Robocod (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jroboRomInfo, g_jroboRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jammit (USA)
static struct BurnRomInfo g_jammitRomDesc[] = {
	{ "jammit (usa).md", 0x200000, 0xd91b52b8, BRF_PRG },
};

STD_ROM_PICK(g_jammit)
STD_ROM_FN(g_jammit)

struct BurnDriverD BurnDrvMDg_jammit = {
	"g_jammit", NULL, NULL, "1900",
	"Jammit (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jammitRomInfo, g_jammitRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Janou Touryumon (J) [!]
static struct BurnRomInfo g_janoutRomDesc[] = {
	{ "janou touryumon (j) [!].md", 0x100000, 0x7011e8eb, BRF_PRG },
};

STD_ROM_PICK(g_janout)
STD_ROM_FN(g_janout)

struct BurnDriver BurnDrvMDg_janout = {
	"g_janout", NULL, NULL, "1900",
	"Janou Touryumon (J) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_janoutRomInfo, g_janoutRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Janou Touryuumon (Japan)
static struct BurnRomInfo g_janou1RomDesc[] = {
	{ "janou touryuumon (japan).md", 0x100000, 0xb5ef97c6, BRF_PRG },
};

STD_ROM_PICK(g_janou1)
STD_ROM_FN(g_janou1)

struct BurnDriver BurnDrvMDg_janou1 = {
	"g_janou1", "g_janout", NULL, "1900",
	"Janou Touryuumon (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_janou1RomInfo, g_janou1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jantei Monogatari (Japan)
static struct BurnRomInfo g_janteiRomDesc[] = {
	{ "jantei monogatari (japan).md", 0x100000, 0x8a1b19ad, BRF_PRG },
};

STD_ROM_PICK(g_jantei)
STD_ROM_FN(g_jantei)

struct BurnDriverD BurnDrvMDg_jantei = {
	"g_jantei", NULL, NULL, "1900",
	"Jantei Monogatari (Japan)\0", NULL, "Telnet Japan / Atlus", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_janteiRomInfo, g_janteiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jashin Draxos (Japan, Korea)
static struct BurnRomInfo g_jashinRomDesc[] = {
	{ "jashin draxos (japan, korea).md", 0x100000, 0x1ea07af2, BRF_PRG },
};

STD_ROM_PICK(g_jashin)
STD_ROM_FN(g_jashin)

struct BurnDriverD BurnDrvMDg_jashin = {
	"g_jashin", "g_riskyw", NULL, "1900",
	"Jashin Draxos (Japan, Korea)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jashinRomInfo, g_jashinRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jelly Boy (Europe) (Proto)
static struct BurnRomInfo g_jellybRomDesc[] = {
	{ "jelly boy (europe) (proto).md", 0x100000, 0x7cfadc16, BRF_PRG },
};

STD_ROM_PICK(g_jellyb)
STD_ROM_FN(g_jellyb)

struct BurnDriverD BurnDrvMDg_jellyb = {
	"g_jellyb", NULL, NULL, "1900",
	"Jelly Boy (Europe) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jellybRomInfo, g_jellybRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jennifer Capriati Tennis (USA)
static struct BurnRomInfo g_jennifRomDesc[] = {
	{ "jennifer capriati tennis (usa).md", 0x80000, 0xab2abc8e, BRF_PRG },
};

STD_ROM_PICK(g_jennif)
STD_ROM_FN(g_jennif)

struct BurnDriverD BurnDrvMDg_jennif = {
	"g_jennif", "g_grands", NULL, "1900",
	"Jennifer Capriati Tennis (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jennifRomInfo, g_jennifRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jeopardy! (USA)
static struct BurnRomInfo g_jeoparRomDesc[] = {
	{ "jeopardy! (usa).md", 0x80000, 0x56cff3f1, BRF_PRG },
};

STD_ROM_PICK(g_jeopar)
STD_ROM_FN(g_jeopar)

struct BurnDriverD BurnDrvMDg_jeopar = {
	"g_jeopar", NULL, NULL, "1900",
	"Jeopardy! (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jeoparRomInfo, g_jeoparRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jeopardy! Deluxe (USA)
static struct BurnRomInfo g_jeopa1RomDesc[] = {
	{ "jeopardy! deluxe (usa).md", 0x80000, 0x25e2f9d2, BRF_PRG },
};

STD_ROM_PICK(g_jeopa1)
STD_ROM_FN(g_jeopa1)

struct BurnDriverD BurnDrvMDg_jeopa1 = {
	"g_jeopa1", NULL, NULL, "1900",
	"Jeopardy! Deluxe (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jeopa1RomInfo, g_jeopa1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jeopardy! Sports Edition (USA)
static struct BurnRomInfo g_jeopa2RomDesc[] = {
	{ "jeopardy! sports edition (usa).md", 0x80000, 0x13f924d2, BRF_PRG },
};

STD_ROM_PICK(g_jeopa2)
STD_ROM_FN(g_jeopa2)

struct BurnDriverD BurnDrvMDg_jeopa2 = {
	"g_jeopa2", NULL, NULL, "1900",
	"Jeopardy! Sports Edition (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jeopa2RomInfo, g_jeopa2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jerry Glanville's Pigskin Footbrawl (USA)
static struct BurnRomInfo g_jerrygRomDesc[] = {
	{ "jerry glanville's pigskin footbrawl (usa).md", 0x100000, 0xe7f48d30, BRF_PRG },
};

STD_ROM_PICK(g_jerryg)
STD_ROM_FN(g_jerryg)

struct BurnDriverD BurnDrvMDg_jerryg = {
	"g_jerryg", NULL, NULL, "1900",
	"Jerry Glanville's Pigskin Footbrawl (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jerrygRomInfo, g_jerrygRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jewel Master (Japan)
static struct BurnRomInfo g_jwlmsjRomDesc[] = {
	{ "jewel master (japan).md", 0x80000, 0x2cf6926c, BRF_PRG },
};

STD_ROM_PICK(g_jwlmsj)
STD_ROM_FN(g_jwlmsj)

struct BurnDriverD BurnDrvMDg_jwlmsj = {
	"g_jwlmsj", "g_jwlms", NULL, "1900",
	"Jewel Master (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jwlmsjRomInfo, g_jwlmsjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jewel Master (USA, Europe) (Rev A)
static struct BurnRomInfo g_jwlmsRomDesc[] = {
	{ "jewel master (usa, europe) (rev a).md", 0x80000, 0xcee98813, BRF_PRG },
};

STD_ROM_PICK(g_jwlms)
STD_ROM_FN(g_jwlms)

struct BurnDriverD BurnDrvMDg_jwlms = {
	"g_jwlms", NULL, NULL, "1900",
	"Jewel Master (USA, Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jwlmsRomInfo, g_jwlmsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jim Power - The Arcade Game (USA) (Proto) [b]
static struct BurnRomInfo g_jimpowRomDesc[] = {
	{ "jim power - the arcade game (usa) (proto) [b].md", 0x100000, 0x1cf3238b, BRF_PRG },
};

STD_ROM_PICK(g_jimpow)
STD_ROM_FN(g_jimpow)

struct BurnDriverD BurnDrvMDg_jimpow = {
	"g_jimpow", NULL, NULL, "1900",
	"Jim Power - The Arcade Game (USA) (Proto) [b]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jimpowRomInfo, g_jimpowRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jimmy White's Whirlwind Snooker (Europe)
static struct BurnRomInfo g_jimmywRomDesc[] = {
	{ "jimmy white's whirlwind snooker (europe).md", 0x80000, 0x0aef5b1f, BRF_PRG },
};

STD_ROM_PICK(g_jimmyw)
STD_ROM_FN(g_jimmyw)

struct BurnDriverD BurnDrvMDg_jimmyw = {
	"g_jimmyw", NULL, NULL, "1900",
	"Jimmy White's Whirlwind Snooker (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jimmywRomInfo, g_jimmywRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jiu Ji Ma Jiang II - Ye Yan Bian (China) (Unl)
static struct BurnRomInfo g_jiujimRomDesc[] = {
	{ "jiu ji ma jiang ii - ye yan bian (china) (unl).md", 0x100000, 0xe9829b22, BRF_PRG },
};

STD_ROM_PICK(g_jiujim)
STD_ROM_FN(g_jiujim)

struct BurnDriverD BurnDrvMDg_jiujim = {
	"g_jiujim", NULL, NULL, "",
	"Jiu Ji Ma Jiang II - Ye Yan Bian (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jiujimRomInfo, g_jiujimRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Joe & Mac (USA)
static struct BurnRomInfo g_joemacRomDesc[] = {
	{ "joe & mac (usa).md", 0x100000, 0x85bcc1c7, BRF_PRG },
};

STD_ROM_PICK(g_joemac)
STD_ROM_FN(g_joemac)

struct BurnDriverD BurnDrvMDg_joemac = {
	"g_joemac", NULL, NULL, "1900",
	"Joe & Mac (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_joemacRomInfo, g_joemacRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Joe Montana Football (World)
static struct BurnRomInfo g_joemonRomDesc[] = {
	{ "joe montana football (world).md", 0x80000, 0x8aa6a1dd, BRF_PRG },
};

STD_ROM_PICK(g_joemon)
STD_ROM_FN(g_joemon)

struct BurnDriverD BurnDrvMDg_joemon = {
	"g_joemon", NULL, NULL, "1900",
	"Joe Montana Football (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_joemonRomInfo, g_joemonRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Joe Montana II Sports Talk Football (World) (Rev A)
static struct BurnRomInfo g_joem2RomDesc[] = {
	{ "joe montana ii sports talk football (world) (rev a).md", 0x100000, 0xa45da893, BRF_PRG },
};

STD_ROM_PICK(g_joem2)
STD_ROM_FN(g_joem2)

struct BurnDriver BurnDrvMDg_joem2 = {
	"g_joem2", NULL, NULL, "1900",
	"Joe Montana II Sports Talk Football (World) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_joem2RomInfo, g_joem2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Joe Montana II Sports Talk Football (World)
static struct BurnRomInfo g_joem2aRomDesc[] = {
	{ "joe montana ii sports talk football (world).md", 0x100000, 0xf2363a4a, BRF_PRG },
};

STD_ROM_PICK(g_joem2a)
STD_ROM_FN(g_joem2a)

struct BurnDriver BurnDrvMDg_joem2a = {
	"g_joem2a", "g_joem2", NULL, "1900",
	"Joe Montana II Sports Talk Football (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_joem2aRomInfo, g_joem2aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// John Madden Football '92 (USA, Europe)
static struct BurnRomInfo g_ma92RomDesc[] = {
	{ "john madden football '92 (usa, europe).md", 0x80000, 0x046e3945, BRF_PRG },
};

STD_ROM_PICK(g_ma92)
STD_ROM_FN(g_ma92)

struct BurnDriverD BurnDrvMDg_ma92 = {
	"g_ma92", NULL, NULL, "",
	"John Madden Football '92 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ma92RomInfo, g_ma92RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// John Madden Football '93 (USA, Europe)
static struct BurnRomInfo g_ma93RomDesc[] = {
	{ "john madden football '93 (usa, europe).md", 0x100000, 0xca323b3e, BRF_PRG },
};

STD_ROM_PICK(g_ma93)
STD_ROM_FN(g_ma93)

struct BurnDriverD BurnDrvMDg_ma93 = {
	"g_ma93", NULL, NULL, "",
	"John Madden Football '93 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ma93RomInfo, g_ma93RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// John Madden Football '93 - Championship Edition (USA)
static struct BurnRomInfo g_ma93ceRomDesc[] = {
	{ "john madden football '93 - championship edition (usa).md", 0x100000, 0xca534b1a, BRF_PRG },
};

STD_ROM_PICK(g_ma93ce)
STD_ROM_FN(g_ma93ce)

struct BurnDriver BurnDrvMDg_ma93ce = {
	"g_ma93ce", NULL, NULL, "1900",
	"John Madden Football '93 - Championship Edition (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ma93ceRomInfo, g_ma93ceRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// John Madden Football (USA, Europe)
static struct BurnRomInfo g_maRomDesc[] = {
	{ "john madden football (usa, europe).md", 0x80000, 0x90fb8818, BRF_PRG },
};

STD_ROM_PICK(g_ma)
STD_ROM_FN(g_ma)

struct BurnDriver BurnDrvMDg_ma = {
	"g_ma", NULL, NULL, "1990",
	"John Madden Football (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_maRomInfo, g_maRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// John Madden Football - Pro Football (Japan)
static struct BurnRomInfo g_majRomDesc[] = {
	{ "john madden football - pro football (japan).md", 0x80000, 0x0460611c, BRF_PRG },
};

STD_ROM_PICK(g_maj)
STD_ROM_FN(g_maj)

struct BurnDriver BurnDrvMDg_maj = {
	"g_maj", "g_ma", NULL, "1900",
	"John Madden Football - Pro Football (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_majRomInfo, g_majRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jordan Vs Bird (USA, Europe) (v1.1)
static struct BurnRomInfo g_jordanRomDesc[] = {
	{ "jordan vs bird (usa, europe) (v1.1).md", 0x80000, 0x4d3ddd7c, BRF_PRG },
};

STD_ROM_PICK(g_jordan)
STD_ROM_FN(g_jordan)

struct BurnDriverD BurnDrvMDg_jordan = {
	"g_jordan", NULL, NULL, "1900",
	"Jordan Vs Bird (USA, Europe) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jordanRomInfo, g_jordanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jordan Vs Bird (USA, Europe)
static struct BurnRomInfo g_jorda1RomDesc[] = {
	{ "jordan vs bird (usa, europe).md", 0x80000, 0x22d77e6d, BRF_PRG },
};

STD_ROM_PICK(g_jorda1)
STD_ROM_FN(g_jorda1)

struct BurnDriverD BurnDrvMDg_jorda1 = {
	"g_jorda1", "g_jordan", NULL, "1900",
	"Jordan Vs Bird (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jorda1RomInfo, g_jorda1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jordan Vs Bird - One on One (Japan)
static struct BurnRomInfo g_jorda2RomDesc[] = {
	{ "jordan vs bird - one on one (japan).md", 0x80000, 0x8837e896, BRF_PRG },
};

STD_ROM_PICK(g_jorda2)
STD_ROM_FN(g_jorda2)

struct BurnDriverD BurnDrvMDg_jorda2 = {
	"g_jorda2", "g_jordan", NULL, "1900",
	"Jordan Vs Bird - One on One (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jorda2RomInfo, g_jorda2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Joshua & The Battle of Jericho (USA) (Unl)
static struct BurnRomInfo g_joshuaRomDesc[] = {
	{ "joshua & the battle of jericho (usa) (unl).md", 0x40000, 0xda9e25aa, BRF_PRG },
};

STD_ROM_PICK(g_joshua)
STD_ROM_FN(g_joshua)

struct BurnDriverD BurnDrvMDg_joshua = {
	"g_joshua", NULL, NULL, "",
	"Joshua & The Battle of Jericho (USA) (Unl)\0", NULL, "Wisdom Tree", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_joshuaRomInfo, g_joshuaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Judge Dredd (USA) (Beta) (Alt)
static struct BurnRomInfo g_judgeaRomDesc[] = {
	{ "judge dredd (usa) (beta) (alt).md", 0x200000, 0xe649f784, BRF_PRG },
};

STD_ROM_PICK(g_judgea)
STD_ROM_FN(g_judgea)

struct BurnDriverD BurnDrvMDg_judgea = {
	"g_judgea", "g_judge", NULL, "1995",
	"Judge Dredd (USA) (Beta) (Alt)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_judgeaRomInfo, g_judgeaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Judge Dredd (USA) (Beta)
static struct BurnRomInfo g_judgebRomDesc[] = {
	{ "judge dredd (usa) (beta).md", 0x200000, 0x8d46f4da, BRF_PRG },
};

STD_ROM_PICK(g_judgeb)
STD_ROM_FN(g_judgeb)

struct BurnDriverD BurnDrvMDg_judgeb = {
	"g_judgeb", "g_judge", NULL, "1995",
	"Judge Dredd (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_judgebRomInfo, g_judgebRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Judge Dredd (World)
static struct BurnRomInfo g_judgeRomDesc[] = {
	{ "judge dredd (world).md", 0x200000, 0xea342ed8, BRF_PRG },
};

STD_ROM_PICK(g_judge)
STD_ROM_FN(g_judge)

struct BurnDriverD BurnDrvMDg_judge = {
	"g_judge", NULL, NULL, "1995",
	"Judge Dredd (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_judgeRomInfo, g_judgeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// JuJu Densetsu ~ Toki - Going Ape Spit (World) (Rev A)
static struct BurnRomInfo g_jujudeRomDesc[] = {
	{ "juju densetsu ~ toki - going ape spit (world) (rev a).md", 0x80000, 0x7362c3f4, BRF_PRG },
};

STD_ROM_PICK(g_jujude)
STD_ROM_FN(g_jujude)

struct BurnDriverD BurnDrvMDg_jujude = {
	"g_jujude", NULL, NULL, "1900",
	"JuJu Densetsu ~ Toki - Going Ape Spit (World) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jujudeRomInfo, g_jujudeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// JuJu Densetsu ~ Toki - Going Ape Spit (World)
static struct BurnRomInfo g_jujud1RomDesc[] = {
	{ "juju densetsu ~ toki - going ape spit (world).md", 0x80000, 0xd09b1ef1, BRF_PRG },
};

STD_ROM_PICK(g_jujud1)
STD_ROM_FN(g_jujud1)

struct BurnDriverD BurnDrvMDg_jujud1 = {
	"g_jujud1", "g_jujude", NULL, "1900",
	"JuJu Densetsu ~ Toki - Going Ape Spit (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jujud1RomInfo, g_jujud1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Junction (Japan, USA)
static struct BurnRomInfo g_junctiRomDesc[] = {
	{ "junction (japan, usa).md", 0x80000, 0x94cdce8d, BRF_PRG },
};

STD_ROM_PICK(g_juncti)
STD_ROM_FN(g_juncti)

struct BurnDriverD BurnDrvMDg_juncti = {
	"g_juncti", NULL, NULL, "1900",
	"Junction (Japan, USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_junctiRomInfo, g_junctiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jungle Book, The (Europe)
static struct BurnRomInfo g_jungleRomDesc[] = {
	{ "jungle book, the (europe).md", 0x200000, 0xb9709a99, BRF_PRG },
};

STD_ROM_PICK(g_jungle)
STD_ROM_FN(g_jungle)

struct BurnDriverD BurnDrvMDg_jungle = {
	"g_jungle", NULL, NULL, "1900",
	"Jungle Book, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jungleRomInfo, g_jungleRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jungle Book, The (USA)
static struct BurnRomInfo g_jungl1RomDesc[] = {
	{ "jungle book, the (usa).md", 0x200000, 0x3fb6d92e, BRF_PRG },
};

STD_ROM_PICK(g_jungl1)
STD_ROM_FN(g_jungl1)

struct BurnDriverD BurnDrvMDg_jungl1 = {
	"g_jungl1", "g_jungle", NULL, "1900",
	"Jungle Book, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jungl1RomInfo, g_jungl1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jungle Strike (USA) (Beta)
static struct BurnRomInfo g_jstriaRomDesc[] = {
	{ "jungle strike (usa) (beta).md", 0x200000, 0x0cd540d4, BRF_PRG },
};

STD_ROM_PICK(g_jstria)
STD_ROM_FN(g_jstria)

struct BurnDriver BurnDrvMDg_jstria = {
	"g_jstria", "g_jstrik", NULL, "1900",
	"Jungle Strike (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jstriaRomInfo, g_jstriaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jungle Strike (USA, Europe)
static struct BurnRomInfo g_jstrikRomDesc[] = {
	{ "jungle strike (usa, europe).md", 0x200000, 0xa5d29735, BRF_PRG },
};

STD_ROM_PICK(g_jstrik)
STD_ROM_FN(g_jstrik)

struct BurnDriver BurnDrvMDg_jstrik = {
	"g_jstrik", NULL, NULL, "1900",
	"Jungle Strike (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jstrikRomInfo, g_jstrikRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jungle Strike - Uketsugareta Kyouki (Japan)
static struct BurnRomInfo g_jstribRomDesc[] = {
	{ "jungle strike - uketsugareta kyouki (japan).md", 0x200000, 0xba7a870b, BRF_PRG },
};

STD_ROM_PICK(g_jstrib)
STD_ROM_FN(g_jstrib)

struct BurnDriver BurnDrvMDg_jstrib = {
	"g_jstrib", "g_jstrik", NULL, "1900",
	"Jungle Strike - Uketsugareta Kyouki (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jstribRomInfo, g_jstribRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Junker's High (Japan) (Beta) [b]
static struct BurnRomInfo g_junkerRomDesc[] = {
	{ "junker's high (japan) (beta) [b].md", 0x100000, 0x23534949, BRF_PRG },
};

STD_ROM_PICK(g_junker)
STD_ROM_FN(g_junker)

struct BurnDriverD BurnDrvMDg_junker = {
	"g_junker", "g_o2019", NULL, "1992",
	"Junker's High (Japan) (Beta) [b]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_junkerRomInfo, g_junkerRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park (Europe)
static struct BurnRomInfo g_jurassRomDesc[] = {
	{ "jurassic park (europe).md", 0x200000, 0x448341f6, BRF_PRG },
};

STD_ROM_PICK(g_jurass)
STD_ROM_FN(g_jurass)

struct BurnDriverD BurnDrvMDg_jurass = {
	"g_jurass", NULL, NULL, "1900",
	"Jurassic Park (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jurassRomInfo, g_jurassRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park (Japan)
static struct BurnRomInfo g_juras1RomDesc[] = {
	{ "jurassic park (japan).md", 0x200000, 0xec8e5783, BRF_PRG },
};

STD_ROM_PICK(g_juras1)
STD_ROM_FN(g_juras1)

struct BurnDriverD BurnDrvMDg_juras1 = {
	"g_juras1", "g_jurass", NULL, "1900",
	"Jurassic Park (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_juras1RomInfo, g_juras1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park (USA) (Beta)
static struct BurnRomInfo g_juras2RomDesc[] = {
	{ "jurassic park (usa) (beta).md", 0x200000, 0xcf890eed, BRF_PRG },
};

STD_ROM_PICK(g_juras2)
STD_ROM_FN(g_juras2)

struct BurnDriverD BurnDrvMDg_juras2 = {
	"g_juras2", "g_jurass", NULL, "1900",
	"Jurassic Park (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_juras2RomInfo, g_juras2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park (USA)
static struct BurnRomInfo g_juras3RomDesc[] = {
	{ "jurassic park (usa).md", 0x200000, 0x7b31deef, BRF_PRG },
};

STD_ROM_PICK(g_juras3)
STD_ROM_FN(g_juras3)

struct BurnDriverD BurnDrvMDg_juras3 = {
	"g_juras3", "g_jurass", NULL, "1900",
	"Jurassic Park (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_juras3RomInfo, g_juras3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype - Jul 08, 1994)
static struct BurnRomInfo g_jprmpaRomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 08, 1994).md", 0x200000, 0xf4c78bd0, BRF_PRG },
};

STD_ROM_PICK(g_jprmpa)
STD_ROM_FN(g_jprmpa)

struct BurnDriverD BurnDrvMDg_jprmpa = {
	"g_jprmpa", "g_jprmp", NULL, "",
	"Jurassic Park - Rampage Edition (Prototype - Jul 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jprmpaRomInfo, g_jprmpaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype - Jul 13, 1994)
static struct BurnRomInfo g_jprmpbRomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 13, 1994).md", 0x200000, 0x8475a105, BRF_PRG },
};

STD_ROM_PICK(g_jprmpb)
STD_ROM_FN(g_jprmpb)

struct BurnDriverD BurnDrvMDg_jprmpb = {
	"g_jprmpb", "g_jprmp", NULL, "",
	"Jurassic Park - Rampage Edition (Prototype - Jul 13, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jprmpbRomInfo, g_jprmpbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype - Jul 14, 1994)
static struct BurnRomInfo g_jprmpcRomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 14, 1994).md", 0x200000, 0x9bf0e28d, BRF_PRG },
};

STD_ROM_PICK(g_jprmpc)
STD_ROM_FN(g_jprmpc)

struct BurnDriverD BurnDrvMDg_jprmpc = {
	"g_jprmpc", "g_jprmp", NULL, "",
	"Jurassic Park - Rampage Edition (Prototype - Jul 14, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jprmpcRomInfo, g_jprmpcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype - Jul 15, 1994)
static struct BurnRomInfo g_jprmpdRomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 15, 1994).md", 0x200000, 0xd2202be5, BRF_PRG },
};

STD_ROM_PICK(g_jprmpd)
STD_ROM_FN(g_jprmpd)

struct BurnDriverD BurnDrvMDg_jprmpd = {
	"g_jprmpd", "g_jprmp", NULL, "",
	"Jurassic Park - Rampage Edition (Prototype - Jul 15, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jprmpdRomInfo, g_jprmpdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype - Jul 17, 1994)
static struct BurnRomInfo g_jprmpeRomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 17, 1994).md", 0x200000, 0x2eae6140, BRF_PRG },
};

STD_ROM_PICK(g_jprmpe)
STD_ROM_FN(g_jprmpe)

struct BurnDriverD BurnDrvMDg_jprmpe = {
	"g_jprmpe", "g_jprmp", NULL, "",
	"Jurassic Park - Rampage Edition (Prototype - Jul 17, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jprmpeRomInfo, g_jprmpeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype - Jul 18, 1994)
static struct BurnRomInfo g_jprmpfRomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jul 18, 1994).md", 0x200000, 0x1a62b826, BRF_PRG },
};

STD_ROM_PICK(g_jprmpf)
STD_ROM_FN(g_jprmpf)

struct BurnDriverD BurnDrvMDg_jprmpf = {
	"g_jprmpf", "g_jprmp", NULL, "",
	"Jurassic Park - Rampage Edition (Prototype - Jul 18, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jprmpfRomInfo, g_jprmpfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype - Jun 20, 1994)
static struct BurnRomInfo g_jprmpgRomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jun 20, 1994).md", 0x1f6e60, 0x1280fa5c, BRF_PRG },
};

STD_ROM_PICK(g_jprmpg)
STD_ROM_FN(g_jprmpg)

struct BurnDriverD BurnDrvMDg_jprmpg = {
	"g_jprmpg", "g_jprmp", NULL, "",
	"Jurassic Park - Rampage Edition (Prototype - Jun 20, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jprmpgRomInfo, g_jprmpgRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype - Jun 22, 1994)
static struct BurnRomInfo g_jprmphRomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jun 22, 1994).md", 0x200000, 0x53582f2b, BRF_PRG },
};

STD_ROM_PICK(g_jprmph)
STD_ROM_FN(g_jprmph)

struct BurnDriverD BurnDrvMDg_jprmph = {
	"g_jprmph", "g_jprmp", NULL, "",
	"Jurassic Park - Rampage Edition (Prototype - Jun 22, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jprmphRomInfo, g_jprmphRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (Prototype - Jun 30, 1994)
static struct BurnRomInfo g_jprmpiRomDesc[] = {
	{ "jurassic park - rampage edition (prototype - jun 30, 1994).md", 0x200000, 0xbff4b396, BRF_PRG },
};

STD_ROM_PICK(g_jprmpi)
STD_ROM_FN(g_jprmpi)

struct BurnDriverD BurnDrvMDg_jprmpi = {
	"g_jprmpi", "g_jprmp", NULL, "",
	"Jurassic Park - Rampage Edition (Prototype - Jun 30, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jprmpiRomInfo, g_jprmpiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Jurassic Park - Rampage Edition (USA, Europe)
static struct BurnRomInfo g_jprmpRomDesc[] = {
	{ "jurassic park - rampage edition (usa, europe).md", 0x200000, 0x98b4aa1b, BRF_PRG },
};

STD_ROM_PICK(g_jprmp)
STD_ROM_FN(g_jprmp)

struct BurnDriverD BurnDrvMDg_jprmp = {
	"g_jprmp", NULL, NULL, "1900",
	"Jurassic Park - Rampage Edition (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_jprmpRomInfo, g_jprmpRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Justice League Task Force (World)
static struct BurnRomInfo g_justicRomDesc[] = {
	{ "justice league task force (world).md", 0x300000, 0x2a60ebe9, BRF_PRG },
};

STD_ROM_PICK(g_justic)
STD_ROM_FN(g_justic)

struct BurnDriverD BurnDrvMDg_justic = {
	"g_justic", NULL, NULL, "1900",
	"Justice League Task Force (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_justicRomInfo, g_justicRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Juuouki (Japan) (v1.1)
static struct BurnRomInfo g_juuoukRomDesc[] = {
	{ "juuouki (japan) (v1.1).md", 0x80000, 0xb2233e87, BRF_PRG },
};

STD_ROM_PICK(g_juuouk)
STD_ROM_FN(g_juuouk)

struct BurnDriver BurnDrvMDg_juuouk = {
	"g_juuouk", "g_altere", NULL, "1988",
	"Juuouki (Japan) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_juuoukRomInfo, g_juuoukRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Juuouki (Japan)
static struct BurnRomInfo g_juuou1RomDesc[] = {
	{ "juuouki (japan).md", 0x80000, 0x1b7c96c0, BRF_PRG },
};

STD_ROM_PICK(g_juuou1)
STD_ROM_FN(g_juuou1)

struct BurnDriver BurnDrvMDg_juuou1 = {
	"g_juuou1", "g_altere", NULL, "1988",
	"Juuouki (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_juuou1RomInfo, g_juuou1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ka-Ge-Ki (Japan)
static struct BurnRomInfo g_kagekjRomDesc[] = {
	{ "ka-ge-ki (japan).md", 0x100000, 0x391866a1, BRF_PRG },
};

STD_ROM_PICK(g_kagekj)
STD_ROM_FN(g_kagekj)

struct BurnDriverD BurnDrvMDg_kagekj = {
	"g_kagekj", "g_kagek", NULL, "1900",
	"Ka-Ge-Ki (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kagekjRomInfo, g_kagekjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ka-Ge-Ki - Fists of Steel (USA)
static struct BurnRomInfo g_kagekRomDesc[] = {
	{ "ka-ge-ki - fists of steel (usa).md", 0x100000, 0xeffc0fa6, BRF_PRG },
};

STD_ROM_PICK(g_kagek)
STD_ROM_FN(g_kagek)

struct BurnDriverD BurnDrvMDg_kagek = {
	"g_kagek", NULL, NULL, "1900",
	"Ka-Ge-Ki - Fists of Steel (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kagekRomInfo, g_kagekRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kawasaki Superbike Challenge (USA) (Beta)
static struct BurnRomInfo g_kawabRomDesc[] = {
	{ "kawasaki superbike challenge (usa) (beta).md", 0x100000, 0x55934d1b, BRF_PRG },
};

STD_ROM_PICK(g_kawab)
STD_ROM_FN(g_kawab)

struct BurnDriverD BurnDrvMDg_kawab = {
	"g_kawab", "g_kawa", NULL, "",
	"Kawasaki Superbike Challenge (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kawabRomInfo, g_kawabRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kawasaki Superbike Challenge (USA, Europe)
static struct BurnRomInfo g_kawaRomDesc[] = {
	{ "kawasaki superbike challenge (usa, europe).md", 0x100000, 0x631cc8e9, BRF_PRG },
};

STD_ROM_PICK(g_kawa)
STD_ROM_FN(g_kawa)

struct BurnDriverD BurnDrvMDg_kawa = {
	"g_kawa", NULL, NULL, "",
	"Kawasaki Superbike Challenge (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kawaRomInfo, g_kawaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kick Boxing, The (Japan, Korea)
static struct BurnRomInfo g_kickboRomDesc[] = {
	{ "kick boxing, the (japan, korea).md", 0x100000, 0x9bdc230c, BRF_PRG },
};

STD_ROM_PICK(g_kickbo)
STD_ROM_FN(g_kickbo)

struct BurnDriver BurnDrvMDg_kickbo = {
	"g_kickbo", "g_bestof", NULL, "1992",
	"Kick Boxing, The (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_SPORTSMISC, 0,
	NULL, g_kickboRomInfo, g_kickboRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kick Off 3 - European Challenge (Europe)
static struct BurnRomInfo g_kickofRomDesc[] = {
	{ "kick off 3 - european challenge (europe).md", 0x100000, 0xbc37401a, BRF_PRG },
};

STD_ROM_PICK(g_kickof)
STD_ROM_FN(g_kickof)

struct BurnDriverD BurnDrvMDg_kickof = {
	"g_kickof", NULL, NULL, "1900",
	"Kick Off 3 - European Challenge (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kickofRomInfo, g_kickofRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kid Chameleon (USA, Europe)
static struct BurnRomInfo g_kidchaRomDesc[] = {
	{ "kid chameleon (usa, europe).md", 0x100000, 0xce36e6cc, BRF_PRG },
};

STD_ROM_PICK(g_kidcha)
STD_ROM_FN(g_kidcha)

struct BurnDriverD BurnDrvMDg_kidcha = {
	"g_kidcha", NULL, NULL, "1994",
	"Kid Chameleon (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kidchaRomInfo, g_kidchaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kidou Keisatsu Patlabor - 98-Shiki Kidou Seyo! (Japan)
static struct BurnRomInfo g_kidoukRomDesc[] = {
	{ "kidou keisatsu patlabor - 98-shiki kidou seyo! (japan).md", 0x80000, 0x21a0e749, BRF_PRG },
};

STD_ROM_PICK(g_kidouk)
STD_ROM_FN(g_kidouk)

struct BurnDriver BurnDrvMDg_kidouk = {
	"g_kidouk", NULL, NULL, "1900",
	"Kidou Keisatsu Patlabor - 98-Shiki Kidou Seyo! (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kidoukRomInfo, g_kidoukRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Killing Game Show, The (J)
static struct BurnRomInfo g_killinRomDesc[] = {
	{ "killing game show, the (j).md", 0x80000, 0x21dbb69d, BRF_PRG },
};

STD_ROM_PICK(g_killin)
STD_ROM_FN(g_killin)

struct BurnDriverD BurnDrvMDg_killin = {
	"g_killin", "g_fatalr", NULL, "1991",
	"Killing Game Show, The (J)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_killinRomInfo, g_killinRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Killing Game Show, The (Japan)
static struct BurnRomInfo g_killi1RomDesc[] = {
	{ "killing game show, the (japan).md", 0x100000, 0xb8e7668a, BRF_PRG },
};

STD_ROM_PICK(g_killi1)
STD_ROM_FN(g_killi1)

struct BurnDriverD BurnDrvMDg_killi1 = {
	"g_killi1", "g_fatalr", NULL, "1993",
	"Killing Game Show, The (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_killi1RomInfo, g_killi1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King of Fighters '98, The (Unl) [!]
static struct BurnRomInfo g_kof98RomDesc[] = {
	{ "king of fighters '98, the (unl) [!].md", 0x200000, 0xcbc38eea, BRF_PRG },
};

STD_ROM_PICK(g_kof98)
STD_ROM_FN(g_kof98)

struct BurnDriverD BurnDrvMDg_kof98 = {
	"g_kof98", NULL, NULL, "",
	"King of Fighters '98, The (Unl) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kof98RomInfo, g_kof98RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King of Fighters '98, The (Unl) [p1][!]
static struct BurnRomInfo g_kof98aRomDesc[] = {
	{ "king of fighters '98, the (unl) [p1][!].md", 0x200000, 0xc79e1074, BRF_PRG },
};

STD_ROM_PICK(g_kof98a)
STD_ROM_FN(g_kof98a)

struct BurnDriverD BurnDrvMDg_kof98a = {
	"g_kof98a", "g_kof98", NULL, "",
	"King of Fighters '98, The (Unl) [p1][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kof98aRomInfo, g_kof98aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King of the Monsters (Europe)
static struct BurnRomInfo g_kotmRomDesc[] = {
	{ "king of the monsters (europe).md", 0x100000, 0x7a94fd49, BRF_PRG },
};

STD_ROM_PICK(g_kotm)
STD_ROM_FN(g_kotm)

struct BurnDriverD BurnDrvMDg_kotm = {
	"g_kotm", NULL, NULL, "1900",
	"King of the Monsters (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kotmRomInfo, g_kotmRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King of the Monsters (USA)
static struct BurnRomInfo g_kotmuRomDesc[] = {
	{ "king of the monsters (usa).md", 0x100000, 0xf390d406, BRF_PRG },
};

STD_ROM_PICK(g_kotmu)
STD_ROM_FN(g_kotmu)

struct BurnDriverD BurnDrvMDg_kotmu = {
	"g_kotmu", "g_kotm", NULL, "1900",
	"King of the Monsters (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kotmuRomInfo, g_kotmuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King of the Monsters 2 (USA)
static struct BurnRomInfo g_kotm2RomDesc[] = {
	{ "king of the monsters 2 (usa).md", 0x200000, 0xee1638ac, BRF_PRG },
};

STD_ROM_PICK(g_kotm2)
STD_ROM_FN(g_kotm2)

struct BurnDriverD BurnDrvMDg_kotm2 = {
	"g_kotm2", NULL, NULL, "1900",
	"King of the Monsters 2 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kotm2RomInfo, g_kotm2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King Salmon (Japan)
static struct BurnRomInfo g_kingsjRomDesc[] = {
	{ "king salmon (japan).md", 0x80000, 0x2cfc9f61, BRF_PRG },
};

STD_ROM_PICK(g_kingsj)
STD_ROM_FN(g_kingsj)

struct BurnDriverD BurnDrvMDg_kingsj = {
	"g_kingsj", "g_kings", NULL, "1900",
	"King Salmon (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kingsjRomInfo, g_kingsjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King Salmon - The Big Catch (USA)
static struct BurnRomInfo g_kingsRomDesc[] = {
	{ "king salmon - the big catch (usa).md", 0x80000, 0xf516e7d9, BRF_PRG },
};

STD_ROM_PICK(g_kings)
STD_ROM_FN(g_kings)

struct BurnDriverD BurnDrvMDg_kings = {
	"g_kings", NULL, NULL, "1900",
	"King Salmon - The Big Catch (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kingsRomInfo, g_kingsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// King's Bounty - The Conqueror's Quest (USA, Europe)
static struct BurnRomInfo g_kingsbRomDesc[] = {
	{ "king's bounty - the conqueror's quest (usa, europe).md", 0x80000, 0xaa68a92e, BRF_PRG },
};

STD_ROM_PICK(g_kingsb)
STD_ROM_FN(g_kingsb)

struct BurnDriverD BurnDrvMDg_kingsb = {
	"g_kingsb", NULL, NULL, "1900",
	"King's Bounty - The Conqueror's Quest (USA, Europe)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kingsbRomInfo, g_kingsbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kishi Densetsu (Japan)
static struct BurnRomInfo g_kishidRomDesc[] = {
	{ "kishi densetsu (japan).md", 0x180000, 0x22e1f04a, BRF_PRG },
};

STD_ROM_PICK(g_kishid)
STD_ROM_FN(g_kishid)

struct BurnDriver BurnDrvMDg_kishid = {
	"g_kishid", NULL, NULL, "1900",
	"Kishi Densetsu (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kishidRomInfo, g_kishidRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kiss Shot (Japan) (SegaNet)
static struct BurnRomInfo g_kissshRomDesc[] = {
	{ "kiss shot (japan) (seganet).md", 0x40000, 0xe487088c, BRF_PRG },
};

STD_ROM_PICK(g_kisssh)
STD_ROM_FN(g_kisssh)

struct BurnDriverD BurnDrvMDg_kisssh = {
	"g_kisssh", NULL, NULL, "",
	"Kiss Shot (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kissshRomInfo, g_kissshRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Klax (Japan)
static struct BurnRomInfo g_klaxjaRomDesc[] = {
	{ "klax (japan).md", 0x40000, 0x1afcc1da, BRF_PRG },
};

STD_ROM_PICK(g_klaxja)
STD_ROM_FN(g_klaxja)

struct BurnDriverD BurnDrvMDg_klaxja = {
	"g_klaxja", "g_klaxus", NULL, "1900",
	"Klax (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_klaxjaRomInfo, g_klaxjaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Klax (USA, Europe)
static struct BurnRomInfo g_klaxusRomDesc[] = {
	{ "klax (usa, europe).md", 0x40000, 0x248cd09e, BRF_PRG },
};

STD_ROM_PICK(g_klaxus)
STD_ROM_FN(g_klaxus)

struct BurnDriverD BurnDrvMDg_klaxus = {
	"g_klaxus", NULL, NULL, "1900",
	"Klax (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_klaxusRomInfo, g_klaxusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Knuckles in Sonic 2 (Prototype 0524 - May 27, 1994, 10.46)
static struct BurnRomInfo g_knucklRomDesc[] = {
	{ "knuckles in sonic 2 (prototype 0524 - may 27, 1994, 10.46).md", 0x400000, 0x8878c1a8, BRF_PRG },
};

STD_ROM_PICK(g_knuckl)
STD_ROM_FN(g_knuckl)

struct BurnDriver BurnDrvMDg_knuckl = {
	"g_knuckl", "g_sks2", NULL, "1994",
	"Knuckles in Sonic 2 (Prototype 0524 - May 27, 1994, 10.46)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_knucklRomInfo, g_knucklRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Koutetsu Teikoku (Japan)
static struct BurnRomInfo g_koutetRomDesc[] = {
	{ "koutetsu teikoku (japan).md", 0x100000, 0x755d0b8a, BRF_PRG },
};

STD_ROM_PICK(g_koutet)
STD_ROM_FN(g_koutet)

struct BurnDriverD BurnDrvMDg_koutet = {
	"g_koutet", NULL, NULL, "1994",
	"Koutetsu Teikoku (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_koutetRomInfo, g_koutetRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Krusty's Super Fun House (USA, Europe) (v1.1)
static struct BurnRomInfo g_krustyRomDesc[] = {
	{ "krusty's super fun house (usa, europe) (v1.1).md", 0x80000, 0x56976261, BRF_PRG },
};

STD_ROM_PICK(g_krusty)
STD_ROM_FN(g_krusty)

struct BurnDriverD BurnDrvMDg_krusty = {
	"g_krusty", NULL, NULL, "1900",
	"Krusty's Super Fun House (USA, Europe) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_krustyRomInfo, g_krustyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Krusty's Super Fun House (USA, Europe)
static struct BurnRomInfo g_krust1RomDesc[] = {
	{ "krusty's super fun house (usa, europe).md", 0x80000, 0xf764005e, BRF_PRG },
};

STD_ROM_PICK(g_krust1)
STD_ROM_FN(g_krust1)

struct BurnDriverD BurnDrvMDg_krust1 = {
	"g_krust1", "g_krusty", NULL, "1900",
	"Krusty's Super Fun House (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_krust1RomInfo, g_krust1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kujaku Ou 2 - Geneijou (Japan)
static struct BurnRomInfo g_kujakuRomDesc[] = {
	{ "kujaku ou 2 - geneijou (japan).md", 0x60000, 0xaffd56bc, BRF_PRG },
};

STD_ROM_PICK(g_kujaku)
STD_ROM_FN(g_kujaku)

struct BurnDriverD BurnDrvMDg_kujaku = {
	"g_kujaku", "g_mystic", NULL, "1900",
	"Kujaku Ou 2 - Geneijou (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kujakuRomInfo, g_kujakuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kuuga - Operation Code 'Vapor Trail' (Japan)
static struct BurnRomInfo g_kuugaoRomDesc[] = {
	{ "kuuga - operation code 'vapor trail' (japan).md", 0x100000, 0x83b6b6ba, BRF_PRG },
};

STD_ROM_PICK(g_kuugao)
STD_ROM_FN(g_kuugao)

struct BurnDriverD BurnDrvMDg_kuugao = {
	"g_kuugao", "g_vaport", NULL, "1900",
	"Kuuga - Operation Code 'Vapor Trail' (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kuugaoRomInfo, g_kuugaoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kyuukai Douchuuki (Japan)
static struct BurnRomInfo g_kyuukaRomDesc[] = {
	{ "kyuukai douchuuki (japan).md", 0x80000, 0xde48dce3, BRF_PRG },
};

STD_ROM_PICK(g_kyuuka)
STD_ROM_FN(g_kyuuka)

struct BurnDriverD BurnDrvMDg_kyuuka = {
	"g_kyuuka", NULL, NULL, "1900",
	"Kyuukai Douchuuki (Japan)\0", NULL, "Namcot", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kyuukaRomInfo, g_kyuukaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Kyuukyoku Tiger (Japan)
static struct BurnRomInfo g_kyuukyRomDesc[] = {
	{ "kyuukyoku tiger (japan).md", 0xa0000, 0x61276d21, BRF_PRG },
};

STD_ROM_PICK(g_kyuuky)
STD_ROM_FN(g_kyuuky)

struct BurnDriverD BurnDrvMDg_kyuuky = {
	"g_kyuuky", "g_twinco", NULL, "1900",
	"Kyuukyoku Tiger (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_kyuukyRomInfo, g_kyuukyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// La Russa Baseball 95 (USA, Australia)
static struct BurnRomInfo g_larussRomDesc[] = {
	{ "la russa baseball 95 (usa, australia).md", 0x200000, 0x3f848a92, BRF_PRG },
};

STD_ROM_PICK(g_laruss)
STD_ROM_FN(g_laruss)

struct BurnDriver BurnDrvMDg_laruss = {
	"g_laruss", NULL, NULL, "1900",
	"La Russa Baseball 95 (USA, Australia)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_larussRomInfo, g_larussRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lakers versus Celtics and the NBA Playoffs (USA)
static struct BurnRomInfo g_lakersRomDesc[] = {
	{ "lakers versus celtics and the nba playoffs (usa).md", 0x80000, 0x0e33fc75, BRF_PRG },
};

STD_ROM_PICK(g_lakers)
STD_ROM_FN(g_lakers)

struct BurnDriverD BurnDrvMDg_lakers = {
	"g_lakers", NULL, NULL, "1990",
	"Lakers versus Celtics and the NBA Playoffs (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lakersRomInfo, g_lakersRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker (USA) (Beta)
static struct BurnRomInfo g_landstRomDesc[] = {
	{ "landstalker (usa) (beta).md", 0x200000, 0x70483d03, BRF_PRG },
};

STD_ROM_PICK(g_landst)
STD_ROM_FN(g_landst)

struct BurnDriver BurnDrvMDg_landst = {
	"g_landst", "g_lands1", NULL, "1994",
	"Landstalker (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_landstRomInfo, g_landstRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker (USA)
static struct BurnRomInfo g_lands1RomDesc[] = {
	{ "landstalker (usa).md", 0x200000, 0xfbbb5b97, BRF_PRG },
};

STD_ROM_PICK(g_lands1)
STD_ROM_FN(g_lands1)

struct BurnDriver BurnDrvMDg_lands1 = {
	"g_lands1", NULL, NULL, "1994",
	"Landstalker (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lands1RomInfo, g_lands1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker - Die Schatze von Konig Nolo (Germany)
static struct BurnRomInfo g_lands2RomDesc[] = {
	{ "landstalker - die schatze von konig nolo (germany).md", 0x200000, 0x10fedb8f, BRF_PRG },
};

STD_ROM_PICK(g_lands2)
STD_ROM_FN(g_lands2)

struct BurnDriver BurnDrvMDg_lands2 = {
	"g_lands2", "g_lands1", NULL, "1994",
	"Landstalker - Die Schatze von Konig Nolo (Germany)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lands2RomInfo, g_lands2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker - Koutei no Zaihou (Japan)
static struct BurnRomInfo g_lands3RomDesc[] = {
	{ "landstalker - koutei no zaihou (japan).md", 0x200000, 0x60d4cedb, BRF_PRG },
};

STD_ROM_PICK(g_lands3)
STD_ROM_FN(g_lands3)

struct BurnDriver BurnDrvMDg_lands3 = {
	"g_lands3", "g_lands1", NULL, "1994",
	"Landstalker - Koutei no Zaihou (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lands3RomInfo, g_lands3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker - Le Tresor du Roi Nole (France)
static struct BurnRomInfo g_lands4RomDesc[] = {
	{ "landstalker - le tresor du roi nole (france).md", 0x200000, 0x5de7d917, BRF_PRG },
};

STD_ROM_PICK(g_lands4)
STD_ROM_FN(g_lands4)

struct BurnDriver BurnDrvMDg_lands4 = {
	"g_lands4", "g_lands1", NULL, "1994",
	"Landstalker - Le Tresor du Roi Nole (France)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lands4RomInfo, g_lands4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Landstalker - The Treasures of King Nole (Europe)
static struct BurnRomInfo g_lands5RomDesc[] = {
	{ "landstalker - the treasures of king nole (europe).md", 0x200000, 0xe3c65277, BRF_PRG },
};

STD_ROM_PICK(g_lands5)
STD_ROM_FN(g_lands5)

struct BurnDriver BurnDrvMDg_lands5 = {
	"g_lands5", "g_lands1", NULL, "1994",
	"Landstalker - The Treasures of King Nole (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lands5RomInfo, g_lands5RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Langrisser (Japan)
static struct BurnRomInfo g_langriRomDesc[] = {
	{ "langrisser (japan).md", 0x80000, 0xb6ea5016, BRF_PRG },
};

STD_ROM_PICK(g_langri)
STD_ROM_FN(g_langri)

struct BurnDriver BurnDrvMDg_langri = {
	"g_langri", NULL, NULL, "1900",
	"Langrisser (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_langriRomInfo, g_langriRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Langrisser II (Japan) (v1.1)
static struct BurnRomInfo g_lang2aRomDesc[] = {
	{ "langrisser ii (japan) (v1.1).md", 0x200000, 0x0caa0593, BRF_PRG },
};

STD_ROM_PICK(g_lang2a)
STD_ROM_FN(g_lang2a)

struct BurnDriver BurnDrvMDg_lang2a = {
	"g_lang2a", "g_lang2", NULL, "1900",
	"Langrisser II (Japan) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lang2aRomInfo, g_lang2aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Langrisser II (Japan) (v1.2)
static struct BurnRomInfo g_lang2RomDesc[] = {
	{ "langrisser ii (japan) (v1.2).md", 0x200000, 0x4967c9f9, BRF_PRG },
};

STD_ROM_PICK(g_lang2)
STD_ROM_FN(g_lang2)

struct BurnDriver BurnDrvMDg_lang2 = {
	"g_lang2", NULL, NULL, "1900",
	"Langrisser II (Japan) (v1.2)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lang2RomInfo, g_lang2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Langrisser II (Japan)
static struct BurnRomInfo g_lang2bRomDesc[] = {
	{ "langrisser ii (japan).md", 0x200000, 0x7f891dfc, BRF_PRG },
};

STD_ROM_PICK(g_lang2b)
STD_ROM_FN(g_lang2b)

struct BurnDriver BurnDrvMDg_lang2b = {
	"g_lang2b", "g_lang2", NULL, "1900",
	"Langrisser II (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lang2bRomInfo, g_lang2bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Last Action Hero (USA, Europe)
static struct BurnRomInfo g_lastacRomDesc[] = {
	{ "last action hero (usa, europe).md", 0x100000, 0x15357dde, BRF_PRG },
};

STD_ROM_PICK(g_lastac)
STD_ROM_FN(g_lastac)

struct BurnDriverD BurnDrvMDg_lastac = {
	"g_lastac", NULL, NULL, "1900",
	"Last Action Hero (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lastacRomInfo, g_lastacRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Last Battle (USA, Europe)
static struct BurnRomInfo g_lastbaRomDesc[] = {
	{ "last battle (usa, europe).md", 0x80000, 0xbbfaad77, BRF_PRG },
};

STD_ROM_PICK(g_lastba)
STD_ROM_FN(g_lastba)

struct BurnDriverD BurnDrvMDg_lastba = {
	"g_lastba", NULL, NULL, "1900",
	"Last Battle (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lastbaRomInfo, g_lastbaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lawnmower Man, The (USA, Europe)
static struct BurnRomInfo g_lawnmoRomDesc[] = {
	{ "lawnmower man, the (usa, europe).md", 0x100000, 0xa7cacd59, BRF_PRG },
};

STD_ROM_PICK(g_lawnmo)
STD_ROM_FN(g_lawnmo)

struct BurnDriverD BurnDrvMDg_lawnmo = {
	"g_lawnmo", NULL, NULL, "1900",
	"Lawnmower Man, The (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lawnmoRomInfo, g_lawnmoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Legend of Galahad, The (USA, Europe)
static struct BurnRomInfo g_legendRomDesc[] = {
	{ "legend of galahad, the (usa, europe).md", 0x100000, 0x679557bc, BRF_PRG },
};

STD_ROM_PICK(g_legend)
STD_ROM_FN(g_legend)

struct BurnDriverD BurnDrvMDg_legend = {
	"g_legend", NULL, NULL, "1900",
	"Legend of Galahad, The (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_legendRomInfo, g_legendRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Legende de Thor, La (France)
static struct BurnRomInfo g_legen1RomDesc[] = {
	{ "legende de thor, la (france).md", 0x300000, 0xb97cca1c, BRF_PRG },
};

STD_ROM_PICK(g_legen1)
STD_ROM_FN(g_legen1)

struct BurnDriver BurnDrvMDg_legen1 = {
	"g_legen1", "g_storyo", NULL, "1995",
	"Legende de Thor, La (France)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_legen1RomInfo, g_legen1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lemmings (Europe)
static struct BurnRomInfo g_lemsRomDesc[] = {
	{ "lemmings (europe).md", 0x100000, 0x6a1a4579, BRF_PRG },
};

STD_ROM_PICK(g_lems)
STD_ROM_FN(g_lems)

struct BurnDriverD BurnDrvMDg_lems = {
	"g_lems", NULL, NULL, "1992",
	"Lemmings (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lemsRomInfo, g_lemsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lemmings (Japan, USA) (v1.1)
static struct BurnRomInfo g_lemsaRomDesc[] = {
	{ "lemmings (japan, usa) (v1.1).md", 0x100000, 0x68c70362, BRF_PRG },
};

STD_ROM_PICK(g_lemsa)
STD_ROM_FN(g_lemsa)

struct BurnDriverD BurnDrvMDg_lemsa = {
	"g_lemsa", "g_lems", NULL, "1992",
	"Lemmings (Japan, USA) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lemsaRomInfo, g_lemsaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lemmings (Japan, USA)
static struct BurnRomInfo g_lemsbRomDesc[] = {
	{ "lemmings (japan, usa).md", 0x100000, 0xf015c2ad, BRF_PRG },
};

STD_ROM_PICK(g_lemsb)
STD_ROM_FN(g_lemsb)

struct BurnDriverD BurnDrvMDg_lemsb = {
	"g_lemsb", "g_lems", NULL, "1992",
	"Lemmings (Japan, USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lemsbRomInfo, g_lemsbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lemmings 2 - The Tribes (Europe)
static struct BurnRomInfo g_lems2RomDesc[] = {
	{ "lemmings 2 - the tribes (europe).md", 0x200000, 0x741eb624, BRF_PRG },
};

STD_ROM_PICK(g_lems2)
STD_ROM_FN(g_lems2)

struct BurnDriverD BurnDrvMDg_lems2 = {
	"g_lems2", NULL, NULL, "1900",
	"Lemmings 2 - The Tribes (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lems2RomInfo, g_lems2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lemmings 2 - The Tribes (USA)
static struct BurnRomInfo g_lems2aRomDesc[] = {
	{ "lemmings 2 - the tribes (usa).md", 0x200000, 0xde59a3a3, BRF_PRG },
};

STD_ROM_PICK(g_lems2a)
STD_ROM_FN(g_lems2a)

struct BurnDriverD BurnDrvMDg_lems2a = {
	"g_lems2a", "g_lems2", NULL, "1900",
	"Lemmings 2 - The Tribes (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lems2aRomInfo, g_lems2aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lethal Enforcers (Europe)
static struct BurnRomInfo g_leRomDesc[] = {
	{ "lethal enforcers (europe).md", 0x200000, 0xca2bf99d, BRF_PRG },
};

STD_ROM_PICK(g_le)
STD_ROM_FN(g_le)

struct BurnDriverD BurnDrvMDg_le = {
	"g_le", NULL, NULL, "1900",
	"Lethal Enforcers (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_leRomInfo, g_leRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lethal Enforcers (Japan)
static struct BurnRomInfo g_lejRomDesc[] = {
	{ "lethal enforcers (japan).md", 0x200000, 0xf25f1e49, BRF_PRG },
};

STD_ROM_PICK(g_lej)
STD_ROM_FN(g_lej)

struct BurnDriverD BurnDrvMDg_lej = {
	"g_lej", "g_le", NULL, "1900",
	"Lethal Enforcers (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lejRomInfo, g_lejRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lethal Enforcers (USA)
static struct BurnRomInfo g_leuRomDesc[] = {
	{ "lethal enforcers (usa).md", 0x200000, 0x51d9a84a, BRF_PRG },
};

STD_ROM_PICK(g_leu)
STD_ROM_FN(g_leu)

struct BurnDriverD BurnDrvMDg_leu = {
	"g_leu", "g_le", NULL, "1900",
	"Lethal Enforcers (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_leuRomInfo, g_leuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lethal Enforcers II - Gun Fighters (Europe)
static struct BurnRomInfo g_le2RomDesc[] = {
	{ "lethal enforcers ii - gun fighters (europe).md", 0x200000, 0x4bfe045c, BRF_PRG },
};

STD_ROM_PICK(g_le2)
STD_ROM_FN(g_le2)

struct BurnDriverD BurnDrvMDg_le2 = {
	"g_le2", NULL, NULL, "1900",
	"Lethal Enforcers II - Gun Fighters (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_le2RomInfo, g_le2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lethal Enforcers II - Gun Fighters (USA)
static struct BurnRomInfo g_le2uRomDesc[] = {
	{ "lethal enforcers ii - gun fighters (usa).md", 0x200000, 0xe5fdd28b, BRF_PRG },
};

STD_ROM_PICK(g_le2u)
STD_ROM_FN(g_le2u)

struct BurnDriverD BurnDrvMDg_le2u = {
	"g_le2u", "g_le2", NULL, "1900",
	"Lethal Enforcers II - Gun Fighters (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_le2uRomInfo, g_le2uRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// LHX Attack Chopper (Japan)
static struct BurnRomInfo g_lhxjRomDesc[] = {
	{ "lhx attack chopper (japan).md", 0x100000, 0x224ff103, BRF_PRG },
};

STD_ROM_PICK(g_lhxj)
STD_ROM_FN(g_lhxj)

struct BurnDriverD BurnDrvMDg_lhxj = {
	"g_lhxj", "g_lhx", NULL, "",
	"LHX Attack Chopper (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lhxjRomInfo, g_lhxjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// LHX Attack Chopper (USA, Europe)
static struct BurnRomInfo g_lhxRomDesc[] = {
	{ "lhx attack chopper (usa, europe).md", 0x100000, 0x70c3428d, BRF_PRG },
};

STD_ROM_PICK(g_lhx)
STD_ROM_FN(g_lhx)

struct BurnDriverD BurnDrvMDg_lhx = {
	"g_lhx", NULL, NULL, "",
	"LHX Attack Chopper (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lhxRomInfo, g_lhxRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Liberty or Death (USA)
static struct BurnRomInfo g_libertRomDesc[] = {
	{ "liberty or death (usa).md", 0x200000, 0x2adb0364, BRF_PRG },
};

STD_ROM_PICK(g_libert)
STD_ROM_FN(g_libert)

struct BurnDriver BurnDrvMDg_libert = {
	"g_libert", NULL, NULL, "1993",
	"Liberty or Death (USA)\0", NULL, "Koei", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_libertRomInfo, g_libertRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Light Crusader (Europe) (En,Fr,De,Es)
static struct BurnRomInfo g_lightcRomDesc[] = {
	{ "light crusader (europe) (en,fr,de,es).md", 0x200000, 0x52c7252b, BRF_PRG },
};

STD_ROM_PICK(g_lightc)
STD_ROM_FN(g_lightc)

struct BurnDriver BurnDrvMDg_lightc = {
	"g_lightc", NULL, NULL, "1995",
	"Light Crusader (Europe) (En,Fr,De,Es)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lightcRomInfo, g_lightcRomName, MegadriveInputInfo, MegadriveEuropeDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Light Crusader (Japan)
static struct BurnRomInfo g_light1RomDesc[] = {
	{ "light crusader (japan).md", 0x200000, 0x237076a4, BRF_PRG },
};

STD_ROM_PICK(g_light1)
STD_ROM_FN(g_light1)

struct BurnDriver BurnDrvMDg_light1 = {
	"g_light1", "g_lightc", NULL, "1900",
	"Light Crusader (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_light1RomInfo, g_light1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Light Crusader (Korea) (En,Ko)
static struct BurnRomInfo g_light2RomDesc[] = {
	{ "light crusader (korea) (en,ko).md", 0x200000, 0x6d0cbcb2, BRF_PRG },
};

STD_ROM_PICK(g_light2)
STD_ROM_FN(g_light2)

struct BurnDriver BurnDrvMDg_light2 = {
	"g_light2", "g_lightc", NULL, "1900",
	"Light Crusader (Korea) (En,Ko)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_light2RomInfo, g_light2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Light Crusader (Prototype - Jun 08, 1995)
static struct BurnRomInfo g_light3RomDesc[] = {
	{ "light crusader (prototype - jun 08, 1995).md", 0x200000, 0xe350ccfa, BRF_PRG },
};

STD_ROM_PICK(g_light3)
STD_ROM_FN(g_light3)

struct BurnDriverD BurnDrvMDg_light3 = {
	"g_light3", "g_lightc", NULL, "",
	"Light Crusader (Prototype - Jun 08, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_light3RomInfo, g_light3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Light Crusader (USA)
static struct BurnRomInfo g_light4RomDesc[] = {
	{ "light crusader (usa).md", 0x200000, 0xbeb715dc, BRF_PRG },
};

STD_ROM_PICK(g_light4)
STD_ROM_FN(g_light4)

struct BurnDriver BurnDrvMDg_light4 = {
	"g_light4", "g_lightc", NULL, "1900",
	"Light Crusader (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_light4RomInfo, g_light4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lightening Force - Quest for the Darkstar (USA)
static struct BurnRomInfo g_lighteRomDesc[] = {
	{ "lightening force - quest for the darkstar (usa).md", 0x100000, 0xc8f8c0e0, BRF_PRG },
};

STD_ROM_PICK(g_lighte)
STD_ROM_FN(g_lighte)

struct BurnDriverD BurnDrvMDg_lighte = {
	"g_lighte", "g_tfiv", NULL, "1992",
	"Lightening Force - Quest for the Darkstar (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lighteRomInfo, g_lighteRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lion King 3 (Unl)
static struct BurnRomInfo g_lion3RomDesc[] = {
	{ "lion king 3 (unl).md", 0x200000, 0xc004219d, BRF_PRG },
};

STD_ROM_PICK(g_lion3)
STD_ROM_FN(g_lion3)

struct BurnDriverD BurnDrvMDg_lion3 = {
	"g_lion3", NULL, NULL, "",
	"Lion King 3 (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lion3RomInfo, g_lion3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lion King II, The (Unl) [!]
static struct BurnRomInfo g_lionk1RomDesc[] = {
	{ "lion king ii, the (unl) [!].md", 0x200000, 0xaff46765, BRF_PRG },
};

STD_ROM_PICK(g_lionk1)
STD_ROM_FN(g_lionk1)

struct BurnDriverD BurnDrvMDg_lionk1 = {
	"g_lionk1", NULL, NULL, "",
	"Lion King II, The (Unl) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lionk1RomInfo, g_lionk1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lion King II, The (Unl) [p1][!]
static struct BurnRomInfo g_lionk2RomDesc[] = {
	{ "lion king ii, the (unl) [p1][!].md", 0x200000, 0x721b4981, BRF_PRG },
};

STD_ROM_PICK(g_lionk2)
STD_ROM_FN(g_lionk2)

struct BurnDriverD BurnDrvMDg_lionk2 = {
	"g_lionk2", "g_lionk1", NULL, "",
	"Lion King II, The (Unl) [p1][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lionk2RomInfo, g_lionk2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lion King, The (World)
static struct BurnRomInfo g_lionkRomDesc[] = {
	{ "lion king, the (world).md", 0x300000, 0x5696a5bc, BRF_PRG },
};

STD_ROM_PICK(g_lionk)
STD_ROM_FN(g_lionk)

struct BurnDriverD BurnDrvMDg_lionk = {
	"g_lionk", NULL, NULL, "1900",
	"Lion King, The (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lionkRomInfo, g_lionkRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lobo (USA) (Proto)
static struct BurnRomInfo g_lobousRomDesc[] = {
	{ "lobo (usa) (proto).md", 0x300000, 0xb5e09338, BRF_PRG },
};

STD_ROM_PICK(g_lobous)
STD_ROM_FN(g_lobous)

struct BurnDriverD BurnDrvMDg_lobous = {
	"g_lobous", NULL, NULL, "",
	"Lobo (USA) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lobousRomInfo, g_lobousRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Long (China) (Unl)
static struct BurnRomInfo g_longchRomDesc[] = {
	{ "long (china) (unl).md", 0x40000, 0x1b86e623, BRF_PRG },
};

STD_ROM_PICK(g_longch)
STD_ROM_FN(g_longch)

struct BurnDriverD BurnDrvMDg_longch = {
	"g_longch", NULL, NULL, "",
	"Long (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_longchRomInfo, g_longchRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lord Monarch - Tokoton Sentou Densetsu (Japan)
static struct BurnRomInfo g_lordmoRomDesc[] = {
	{ "lord monarch - tokoton sentou densetsu (japan).md", 0x200000, 0x238bf5db, BRF_PRG },
};

STD_ROM_PICK(g_lordmo)
STD_ROM_FN(g_lordmo)

struct BurnDriverD BurnDrvMDg_lordmo = {
	"g_lordmo", NULL, NULL, "",
	"Lord Monarch - Tokoton Sentou Densetsu (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lordmoRomInfo, g_lordmoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lost Vikings, The (Europe) (Beta)
static struct BurnRomInfo g_lvikbRomDesc[] = {
	{ "lost vikings, the (europe) (beta).md", 0x100000, 0x17bed25f, BRF_PRG },
};

STD_ROM_PICK(g_lvikb)
STD_ROM_FN(g_lvikb)

struct BurnDriverD BurnDrvMDg_lvikb = {
	"g_lvikb", "g_lvik", NULL, "1900",
	"Lost Vikings, The (Europe) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lvikbRomInfo, g_lvikbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lost Vikings, The (Europe)
static struct BurnRomInfo g_lvikRomDesc[] = {
	{ "lost vikings, the (europe).md", 0x100000, 0x1f14efc6, BRF_PRG },
};

STD_ROM_PICK(g_lvik)
STD_ROM_FN(g_lvik)

struct BurnDriverD BurnDrvMDg_lvik = {
	"g_lvik", NULL, NULL, "1900",
	"Lost Vikings, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lvikRomInfo, g_lvikRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lost Vikings, The (USA)
static struct BurnRomInfo g_lvikuRomDesc[] = {
	{ "lost vikings, the (usa).md", 0x100000, 0x7ba49edb, BRF_PRG },
};

STD_ROM_PICK(g_lviku)
STD_ROM_FN(g_lviku)

struct BurnDriverD BurnDrvMDg_lviku = {
	"g_lviku", "g_lvik", NULL, "1900",
	"Lost Vikings, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lvikuRomInfo, g_lvikuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lost World, The - Jurassic Park (USA, Europe)
static struct BurnRomInfo g_lostwoRomDesc[] = {
	{ "lost world, the - jurassic park (usa, europe).md", 0x400000, 0x140a284c, BRF_PRG },
};

STD_ROM_PICK(g_lostwo)
STD_ROM_FN(g_lostwo)

struct BurnDriverD BurnDrvMDg_lostwo = {
	"g_lostwo", NULL, NULL, "1998",
	"Lost World, The - Jurassic Park (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lostwoRomInfo, g_lostwoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lotus II (USA) (Beta)
static struct BurnRomInfo g_lot2bRomDesc[] = {
	{ "lotus ii (usa) (beta).md", 0x100000, 0x2997b7d4, BRF_PRG },
};

STD_ROM_PICK(g_lot2b)
STD_ROM_FN(g_lot2b)

struct BurnDriverD BurnDrvMDg_lot2b = {
	"g_lot2b", "g_lot2", NULL, "1900",
	"Lotus II (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lot2bRomInfo, g_lot2bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lotus II (USA, Europe)
static struct BurnRomInfo g_lot2RomDesc[] = {
	{ "lotus ii (usa, europe).md", 0x100000, 0x1d8ee010, BRF_PRG },
};

STD_ROM_PICK(g_lot2)
STD_ROM_FN(g_lot2)

struct BurnDriverD BurnDrvMDg_lot2 = {
	"g_lot2", NULL, NULL, "",
	"Lotus II (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lot2RomInfo, g_lot2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Lotus Turbo Challenge (USA, Europe)
static struct BurnRomInfo g_lotustRomDesc[] = {
	{ "lotus turbo challenge (usa, europe).md", 0x100000, 0xa3cf6e9c, BRF_PRG },
};

STD_ROM_PICK(g_lotust)
STD_ROM_FN(g_lotust)

struct BurnDriverD BurnDrvMDg_lotust = {
	"g_lotust", NULL, NULL, "1992",
	"Lotus Turbo Challenge (USA, Europe)\0", "Gfx and Sound Problems", "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_lotustRomInfo, g_lotustRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// M-1 Abrams Battle Tank (USA, Europe)
static struct BurnRomInfo g_m1abraRomDesc[] = {
	{ "m-1 abrams battle tank (usa, europe).md", 0x80000, 0x1e2f74cf, BRF_PRG },
};

STD_ROM_PICK(g_m1abra)
STD_ROM_FN(g_m1abra)

struct BurnDriverD BurnDrvMDg_m1abra = {
	"g_m1abra", NULL, NULL, "1900",
	"M-1 Abrams Battle Tank (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_m1abraRomInfo, g_m1abraRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ma Jiang Qing Ren - Ji Ma Jiang Zhi (China) (Unl)
static struct BurnRomInfo g_majianRomDesc[] = {
	{ "ma jiang qing ren - ji ma jiang zhi (china) (unl).md", 0x100000, 0xddd02ba4, BRF_PRG },
};

STD_ROM_PICK(g_majian)
STD_ROM_FN(g_majian)

struct BurnDriverD BurnDrvMDg_majian = {
	"g_majian", NULL, NULL, "",
	"Ma Jiang Qing Ren - Ji Ma Jiang Zhi (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_majianRomInfo, g_majianRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ma Qiao E Mo Ta - Devilish Mahjong Tower (China) (Unl)
static struct BurnRomInfo g_maqiaoRomDesc[] = {
	{ "ma qiao e mo ta - devilish mahjong tower (china) (unl).md", 0x100000, 0x12e35994, BRF_PRG },
};

STD_ROM_PICK(g_maqiao)
STD_ROM_FN(g_maqiao)

struct BurnDriverD BurnDrvMDg_maqiao = {
	"g_maqiao", NULL, NULL, "",
	"Ma Qiao E Mo Ta - Devilish Mahjong Tower (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_maqiaoRomInfo, g_maqiaoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madden NFL '94 (USA, Europe)
static struct BurnRomInfo g_maddenRomDesc[] = {
	{ "madden nfl '94 (usa, europe).md", 0x200000, 0xd14b811b, BRF_PRG },
};

STD_ROM_PICK(g_madden)
STD_ROM_FN(g_madden)

struct BurnDriver BurnDrvMDg_madden = {
	"g_madden", NULL, NULL, "1900",
	"Madden NFL '94 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_maddenRomInfo, g_maddenRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madden NFL 95 (USA, Europe)
static struct BurnRomInfo g_mad95RomDesc[] = {
	{ "madden nfl 95 (usa, europe).md", 0x200000, 0xdb0be0c2, BRF_PRG },
};

STD_ROM_PICK(g_mad95)
STD_ROM_FN(g_mad95)

struct BurnDriver BurnDrvMDg_mad95 = {
	"g_mad95", NULL, NULL, "1900",
	"Madden NFL 95 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mad95RomInfo, g_mad95RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madden NFL 96 (USA, Europe)
static struct BurnRomInfo g_mad96RomDesc[] = {
	{ "madden nfl 96 (usa, europe).md", 0x200000, 0xf126918b, BRF_PRG },
};

STD_ROM_PICK(g_mad96)
STD_ROM_FN(g_mad96)

struct BurnDriver BurnDrvMDg_mad96 = {
	"g_mad96", NULL, NULL, "1900",
	"Madden NFL 96 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mad96RomInfo, g_mad96RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madden NFL 97 (USA, Europe)
static struct BurnRomInfo g_mad97RomDesc[] = {
	{ "madden nfl 97 (usa, europe).md", 0x200000, 0xc4b4e112, BRF_PRG },
};

STD_ROM_PICK(g_mad97)
STD_ROM_FN(g_mad97)

struct BurnDriver BurnDrvMDg_mad97 = {
	"g_mad97", NULL, NULL, "1900",
	"Madden NFL 97 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mad97RomInfo, g_mad97RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madden NFL 98 (USA)
static struct BurnRomInfo g_mad98RomDesc[] = {
	{ "madden nfl 98 (usa).md", 0x200000, 0xe051ea62, BRF_PRG },
};

STD_ROM_PICK(g_mad98)
STD_ROM_FN(g_mad98)

struct BurnDriver BurnDrvMDg_mad98 = {
	"g_mad98", NULL, NULL, "1900",
	"Madden NFL 98 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mad98RomInfo, g_mad98RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Madou Monogatari I (Japan)
static struct BurnRomInfo g_madoumRomDesc[] = {
	{ "madou monogatari i (japan).md", 0x200000, 0xdd82c401, BRF_PRG },
};

STD_ROM_PICK(g_madoum)
STD_ROM_FN(g_madoum)

struct BurnDriver BurnDrvMDg_madoum = {
	"g_madoum", NULL, NULL, "1900",
	"Madou Monogatari I (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_madoumRomInfo, g_madoumRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - Apr 11, 1995)
static struct BurnRomInfo g_msbpaRomDesc[] = {
	{ "magic school bus, the (prototype - apr 11, 1995).md", 0xfdfbc, 0x883023bc, BRF_PRG },
};

STD_ROM_PICK(g_msbpa)
STD_ROM_FN(g_msbpa)

struct BurnDriverD BurnDrvMDg_msbpa = {
	"g_msbpa", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - Apr 11, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbpaRomInfo, g_msbpaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - Apr 21, 1995)
static struct BurnRomInfo g_msbpbRomDesc[] = {
	{ "magic school bus, the (prototype - apr 21, 1995).md", 0xfcfdc, 0x7844b7ad, BRF_PRG },
};

STD_ROM_PICK(g_msbpb)
STD_ROM_FN(g_msbpb)

struct BurnDriverD BurnDrvMDg_msbpb = {
	"g_msbpb", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - Apr 21, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbpbRomInfo, g_msbpbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - Apr 25, 1995)
static struct BurnRomInfo g_msbpcRomDesc[] = {
	{ "magic school bus, the (prototype - apr 25, 1995).md", 0xfd5e0, 0xb6bd2d87, BRF_PRG },
};

STD_ROM_PICK(g_msbpc)
STD_ROM_FN(g_msbpc)

struct BurnDriverD BurnDrvMDg_msbpc = {
	"g_msbpc", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - Apr 25, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbpcRomInfo, g_msbpcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - Apr 28, 1995)
static struct BurnRomInfo g_msbpdRomDesc[] = {
	{ "magic school bus, the (prototype - apr 28, 1995).md", 0xfe89c, 0x9b6bae87, BRF_PRG },
};

STD_ROM_PICK(g_msbpd)
STD_ROM_FN(g_msbpd)

struct BurnDriverD BurnDrvMDg_msbpd = {
	"g_msbpd", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - Apr 28, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbpdRomInfo, g_msbpdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - Feb 02, 1995)
static struct BurnRomInfo g_msbpeRomDesc[] = {
	{ "magic school bus, the (prototype - feb 02, 1995).md", 0x100000, 0x7805b5c9, BRF_PRG },
};

STD_ROM_PICK(g_msbpe)
STD_ROM_FN(g_msbpe)

struct BurnDriverD BurnDrvMDg_msbpe = {
	"g_msbpe", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - Feb 02, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbpeRomInfo, g_msbpeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - Feb 17, 1995)
static struct BurnRomInfo g_msbpfRomDesc[] = {
	{ "magic school bus, the (prototype - feb 17, 1995).md", 0xdf6bc, 0x2b7a88c0, BRF_PRG },
};

STD_ROM_PICK(g_msbpf)
STD_ROM_FN(g_msbpf)

struct BurnDriverD BurnDrvMDg_msbpf = {
	"g_msbpf", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - Feb 17, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbpfRomInfo, g_msbpfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - Jan 12, 1995)
static struct BurnRomInfo g_msbpgRomDesc[] = {
	{ "magic school bus, the (prototype - jan 12, 1995).md", 0xeb2e4, 0x946346f9, BRF_PRG },
};

STD_ROM_PICK(g_msbpg)
STD_ROM_FN(g_msbpg)

struct BurnDriverD BurnDrvMDg_msbpg = {
	"g_msbpg", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - Jan 12, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbpgRomInfo, g_msbpgRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - Mar 07, 1995)
static struct BurnRomInfo g_msbphRomDesc[] = {
	{ "magic school bus, the (prototype - mar 07, 1995).md", 0xe9aa8, 0x26c71eb8, BRF_PRG },
};

STD_ROM_PICK(g_msbph)
STD_ROM_FN(g_msbph)

struct BurnDriverD BurnDrvMDg_msbph = {
	"g_msbph", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - Mar 07, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbphRomInfo, g_msbphRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - Mar 14, 1995)
static struct BurnRomInfo g_msbpiRomDesc[] = {
	{ "magic school bus, the (prototype - mar 14, 1995).md", 0xf1c30, 0x37a6a1af, BRF_PRG },
};

STD_ROM_PICK(g_msbpi)
STD_ROM_FN(g_msbpi)

struct BurnDriverD BurnDrvMDg_msbpi = {
	"g_msbpi", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - Mar 14, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbpiRomInfo, g_msbpiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - Mar 27, 1995)
static struct BurnRomInfo g_msbpjRomDesc[] = {
	{ "magic school bus, the (prototype - mar 27, 1995).md", 0xf52e8, 0xb065da40, BRF_PRG },
};

STD_ROM_PICK(g_msbpj)
STD_ROM_FN(g_msbpj)

struct BurnDriverD BurnDrvMDg_msbpj = {
	"g_msbpj", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - Mar 27, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbpjRomInfo, g_msbpjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - Mar 31, 1995)
static struct BurnRomInfo g_msbpkRomDesc[] = {
	{ "magic school bus, the (prototype - mar 31, 1995).md", 0xf93c0, 0xcd788def, BRF_PRG },
};

STD_ROM_PICK(g_msbpk)
STD_ROM_FN(g_msbpk)

struct BurnDriverD BurnDrvMDg_msbpk = {
	"g_msbpk", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - Mar 31, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbpkRomInfo, g_msbpkRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (Prototype - May 05, 1995)
static struct BurnRomInfo g_msbplRomDesc[] = {
	{ "magic school bus, the (prototype - may 05, 1995).md", 0xfea00, 0xa2315f1c, BRF_PRG },
};

STD_ROM_PICK(g_msbpl)
STD_ROM_FN(g_msbpl)

struct BurnDriverD BurnDrvMDg_msbpl = {
	"g_msbpl", "g_msb", NULL, "",
	"Magic School Bus, The (Prototype - May 05, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbplRomInfo, g_msbplRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magic School Bus, The (USA)
static struct BurnRomInfo g_msbRomDesc[] = {
	{ "magic school bus, the (usa).md", 0x100000, 0x1a5d4412, BRF_PRG },
};

STD_ROM_PICK(g_msb)
STD_ROM_FN(g_msb)

struct BurnDriverD BurnDrvMDg_msb = {
	"g_msb", NULL, NULL, "1900",
	"Magic School Bus, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_msbRomInfo, g_msbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magical Hat no Buttobi Turbo! Daibouken (Japan)
static struct BurnRomInfo g_mhatRomDesc[] = {
	{ "magical hat no buttobi turbo! daibouken (japan).md", 0x80000, 0xe43e853d, BRF_PRG },
};

STD_ROM_PICK(g_mhat)
STD_ROM_FN(g_mhat)

struct BurnDriverD BurnDrvMDg_mhat = {
	"g_mhat", NULL, NULL, "",
	"Magical Hat no Buttobi Turbo! Daibouken (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mhatRomInfo, g_mhatRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Magical Taruruuto-kun (Japan)
static struct BurnRomInfo g_mtaruRomDesc[] = {
	{ "magical taruruuto-kun (japan).md", 0x80000, 0xf11060a5, BRF_PRG },
};

STD_ROM_PICK(g_mtaru)
STD_ROM_FN(g_mtaru)

struct BurnDriverD BurnDrvMDg_mtaru = {
	"g_mtaru", NULL, NULL, "1900",
	"Magical Taruruuto-kun (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mtaruRomInfo, g_mtaruRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mahjong Cop Ryuu - Shiro Ookami no Yabou (Japan)
static struct BurnRomInfo g_mahjonRomDesc[] = {
	{ "mahjong cop ryuu - shiro ookami no yabou (japan).md", 0x40000, 0x1ccbc782, BRF_PRG },
};

STD_ROM_PICK(g_mahjon)
STD_ROM_FN(g_mahjon)

struct BurnDriverD BurnDrvMDg_mahjon = {
	"g_mahjon", NULL, NULL, "1900",
	"Mahjong Cop Ryuu - Shiro Ookami no Yabou (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mahjonRomInfo, g_mahjonRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mamono Hunter Youko - Dai 7 no Keishou (Japan)
static struct BurnRomInfo g_mamonoRomDesc[] = {
	{ "mamono hunter youko - dai 7 no keishou (japan).md", 0x80000, 0x10bb359b, BRF_PRG },
};

STD_ROM_PICK(g_mamono)
STD_ROM_FN(g_mamono)

struct BurnDriverD BurnDrvMDg_mamono = {
	"g_mamono", NULL, NULL, "1900",
	"Mamono Hunter Youko - Dai 7 no Keishou (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mamonoRomInfo, g_mamonoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Man Overboard! (Europe)
static struct BurnRomInfo g_manoveRomDesc[] = {
	{ "man overboard! (europe).md", 0x100000, 0xcae0e3a6, BRF_PRG },
};

STD_ROM_PICK(g_manove)
STD_ROM_FN(g_manove)

struct BurnDriverD BurnDrvMDg_manove = {
	"g_manove", NULL, NULL, "1900",
	"Man Overboard! (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_manoveRomInfo, g_manoveRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Maou Renjishi (Japan)
static struct BurnRomInfo g_maoureRomDesc[] = {
	{ "maou renjishi (japan).md", 0x80000, 0x24a7f28c, BRF_PRG },
};

STD_ROM_PICK(g_maoure)
STD_ROM_FN(g_maoure)

struct BurnDriverD BurnDrvMDg_maoure = {
	"g_maoure", NULL, NULL, "1900",
	"Maou Renjishi (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_maoureRomInfo, g_maoureRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marble Madness (USA, Europe)
static struct BurnRomInfo g_marbleRomDesc[] = {
	{ "marble madness (usa, europe).md", 0x80000, 0x79eba28a, BRF_PRG },
};

STD_ROM_PICK(g_marble)
STD_ROM_FN(g_marble)

struct BurnDriverD BurnDrvMDg_marble = {
	"g_marble", NULL, NULL, "1900",
	"Marble Madness (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_marbleRomInfo, g_marbleRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mario Andretti Racing (USA, Europe)
static struct BurnRomInfo g_marioaRomDesc[] = {
	{ "mario andretti racing (usa, europe).md", 0x200000, 0x7f1dc0aa, BRF_PRG },
};

STD_ROM_PICK(g_marioa)
STD_ROM_FN(g_marioa)

struct BurnDriverD BurnDrvMDg_marioa = {
	"g_marioa", NULL, NULL, "1900",
	"Mario Andretti Racing (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_marioaRomInfo, g_marioaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mario Lemieux Hockey (USA, Europe)
static struct BurnRomInfo g_mariolRomDesc[] = {
	{ "mario lemieux hockey (usa, europe).md", 0x80000, 0xf664eb6c, BRF_PRG },
};

STD_ROM_PICK(g_mariol)
STD_ROM_FN(g_mariol)

struct BurnDriverD BurnDrvMDg_mariol = {
	"g_mariol", NULL, NULL, "1900",
	"Mario Lemieux Hockey (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mariolRomInfo, g_mariolRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marko's Magic Football (Europe) (En,Fr,De,Es) (Beta)
static struct BurnRomInfo g_markobRomDesc[] = {
	{ "marko's magic football (europe) (en,fr,de,es) (beta).md", 0x200000, 0x0273e564, BRF_PRG },
};

STD_ROM_PICK(g_markob)
STD_ROM_FN(g_markob)

struct BurnDriverD BurnDrvMDg_markob = {
	"g_markob", "g_marko", NULL, "1900",
	"Marko's Magic Football (Europe) (En,Fr,De,Es) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_markobRomInfo, g_markobRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marko's Magic Football (Europe) (En,Fr,De,Es)
static struct BurnRomInfo g_markoRomDesc[] = {
	{ "marko's magic football (europe) (en,fr,de,es).md", 0x200000, 0x2307b905, BRF_PRG },
};

STD_ROM_PICK(g_marko)
STD_ROM_FN(g_marko)

struct BurnDriverD BurnDrvMDg_marko = {
	"g_marko", NULL, NULL, "1900",
	"Marko's Magic Football (Europe) (En,Fr,De,Es)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_markoRomInfo, g_markoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marko's Magic Football (USA)
static struct BurnRomInfo g_markouRomDesc[] = {
	{ "marko's magic football (usa).md", 0x200000, 0x2b8c8cce, BRF_PRG },
};

STD_ROM_PICK(g_markou)
STD_ROM_FN(g_markou)

struct BurnDriverD BurnDrvMDg_markou = {
	"g_markou", "g_marko", NULL, "1900",
	"Marko's Magic Football (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_markouRomInfo, g_markouRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marsupilami (Europe) (En,Fr,De,Es,It)
static struct BurnRomInfo g_marsupRomDesc[] = {
	{ "marsupilami (europe) (en,fr,de,es,it).md", 0x200000, 0xe09bbd70, BRF_PRG },
};

STD_ROM_PICK(g_marsup)
STD_ROM_FN(g_marsup)

struct BurnDriverD BurnDrvMDg_marsup = {
	"g_marsup", NULL, NULL, "1900",
	"Marsupilami (Europe) (En,Fr,De,Es,It)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_marsupRomInfo, g_marsupRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marsupilami (USA) (En,Fr,De,Es,It)
static struct BurnRomInfo g_marsu1RomDesc[] = {
	{ "marsupilami (usa) (en,fr,de,es,it).md", 0x200000, 0xc76558df, BRF_PRG },
};

STD_ROM_PICK(g_marsu1)
STD_ROM_FN(g_marsu1)

struct BurnDriverD BurnDrvMDg_marsu1 = {
	"g_marsu1", "g_marsup", NULL, "1900",
	"Marsupilami (USA) (En,Fr,De,Es,It)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_marsu1RomInfo, g_marsu1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marvel Land (Japan)
static struct BurnRomInfo g_mvlndjRomDesc[] = {
	{ "marvel land (japan).md", 0x100000, 0x5d162d21, BRF_PRG },
};

STD_ROM_PICK(g_mvlndj)
STD_ROM_FN(g_mvlndj)

struct BurnDriverD BurnDrvMDg_mvlndj = {
	"g_mvlndj", "g_talmit", NULL, "1900",
	"Marvel Land (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mvlndjRomInfo, g_mvlndjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Marvel Land (USA)
static struct BurnRomInfo g_mvlndRomDesc[] = {
	{ "marvel land (usa).md", 0x100000, 0xcd7eeeb7, BRF_PRG },
};

STD_ROM_PICK(g_mvlnd)
STD_ROM_FN(g_mvlnd)

struct BurnDriverD BurnDrvMDg_mvlnd = {
	"g_mvlnd", "g_talmit", NULL, "1900",
	"Marvel Land (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mvlndRomInfo, g_mvlndRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mary Shelley's Frankenstein (USA)
static struct BurnRomInfo g_maryshRomDesc[] = {
	{ "mary shelley's frankenstein (usa).md", 0x200000, 0x48993dc3, BRF_PRG },
};

STD_ROM_PICK(g_marysh)
STD_ROM_FN(g_marysh)

struct BurnDriverD BurnDrvMDg_marysh = {
	"g_marysh", NULL, NULL, "1900",
	"Mary Shelley's Frankenstein (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_maryshRomInfo, g_maryshRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Master of Monsters (Japan)
static struct BurnRomInfo g_masterRomDesc[] = {
	{ "master of monsters (japan).md", 0x80000, 0xd51ee8c2, BRF_PRG },
};

STD_ROM_PICK(g_master)
STD_ROM_FN(g_master)

struct BurnDriver BurnDrvMDg_master = {
	"g_master", NULL, NULL, "1900",
	"Master of Monsters (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_masterRomInfo, g_masterRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Master of Monsters (USA)
static struct BurnRomInfo g_maste1RomDesc[] = {
	{ "master of monsters (usa).md", 0x80000, 0x91354820, BRF_PRG },
};

STD_ROM_PICK(g_maste1)
STD_ROM_FN(g_maste1)

struct BurnDriver BurnDrvMDg_maste1 = {
	"g_maste1", "g_master", NULL, "1900",
	"Master of Monsters (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_maste1RomInfo, g_maste1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Master of Weapon (Japan)
static struct BurnRomInfo g_mweapRomDesc[] = {
	{ "master of weapon (japan).md", 0x80000, 0x12ad6178, BRF_PRG },
};

STD_ROM_PICK(g_mweap)
STD_ROM_FN(g_mweap)

struct BurnDriverD BurnDrvMDg_mweap = {
	"g_mweap", NULL, NULL, "1900",
	"Master of Weapon (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mweapRomInfo, g_mweapRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Maten no Soumetsu (Japan)
static struct BurnRomInfo g_matennRomDesc[] = {
	{ "maten no soumetsu (japan).md", 0x100000, 0xb804a105, BRF_PRG },
};

STD_ROM_PICK(g_matenn)
STD_ROM_FN(g_matenn)

struct BurnDriver BurnDrvMDg_matenn = {
	"g_matenn", NULL, NULL, "1900",
	"Maten no Soumetsu (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_matennRomInfo, g_matennRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Math Blaster - Episode 1 (USA)
static struct BurnRomInfo g_mathblRomDesc[] = {
	{ "math blaster - episode 1 (usa).md", 0x100000, 0xd055a462, BRF_PRG },
};

STD_ROM_PICK(g_mathbl)
STD_ROM_FN(g_mathbl)

struct BurnDriverD BurnDrvMDg_mathbl = {
	"g_mathbl", NULL, NULL, "1900",
	"Math Blaster - Episode 1 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mathblRomInfo, g_mathblRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mazin Saga (Asia)
static struct BurnRomInfo g_mazinsRomDesc[] = {
	{ "mazin saga (asia).md", 0x100000, 0x36459b59, BRF_PRG },
};

STD_ROM_PICK(g_mazins)
STD_ROM_FN(g_mazins)

struct BurnDriverD BurnDrvMDg_mazins = {
	"g_mazins", NULL, NULL, "1993",
	"Mazin Saga (Asia)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mazinsRomInfo, g_mazinsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mazin Saga (Japan, Korea)
static struct BurnRomInfo g_mazin1RomDesc[] = {
	{ "mazin saga (japan, korea).md", 0x100000, 0x45b3a34b, BRF_PRG },
};

STD_ROM_PICK(g_mazin1)
STD_ROM_FN(g_mazin1)

struct BurnDriverD BurnDrvMDg_mazin1 = {
	"g_mazin1", "g_mazins", NULL, "1993",
	"Mazin Saga (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mazin1RomInfo, g_mazin1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mazin Saga Mutant Fighter (USA)
static struct BurnRomInfo g_mazin2RomDesc[] = {
	{ "mazin saga mutant fighter (usa).md", 0x100000, 0x1bd9fef1, BRF_PRG },
};

STD_ROM_PICK(g_mazin2)
STD_ROM_FN(g_mazin2)

struct BurnDriverD BurnDrvMDg_mazin2 = {
	"g_mazin2", "g_mazins", NULL, "1993",
	"Mazin Saga Mutant Fighter (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mazin2RomInfo, g_mazin2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mazin Wars (Europe)
static struct BurnRomInfo g_mazinwRomDesc[] = {
	{ "mazin wars (europe).md", 0x100000, 0x4b07a105, BRF_PRG },
};

STD_ROM_PICK(g_mazinw)
STD_ROM_FN(g_mazinw)

struct BurnDriverD BurnDrvMDg_mazinw = {
	"g_mazinw", "g_mazins", NULL, "1993",
	"Mazin Wars (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mazinwRomInfo, g_mazinwRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// McDonald's Treasure Land Adventure (Europe)
static struct BurnRomInfo g_mcdonaRomDesc[] = {
	{ "mcdonald's treasure land adventure (europe).md", 0x100000, 0x6ab6a8da, BRF_PRG },
};

STD_ROM_PICK(g_mcdona)
STD_ROM_FN(g_mcdona)

struct BurnDriverD BurnDrvMDg_mcdona = {
	"g_mcdona", NULL, NULL, "1993",
	"McDonald's Treasure Land Adventure (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mcdonaRomInfo, g_mcdonaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// McDonald's Treasure Land Adventure (Japan) (Beta)
static struct BurnRomInfo g_mcdon1RomDesc[] = {
	{ "mcdonald's treasure land adventure (japan) (beta).md", 0x100000, 0x7bf477e8, BRF_PRG },
};

STD_ROM_PICK(g_mcdon1)
STD_ROM_FN(g_mcdon1)

struct BurnDriverD BurnDrvMDg_mcdon1 = {
	"g_mcdon1", "g_mcdona", NULL, "1993",
	"McDonald's Treasure Land Adventure (Japan) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mcdon1RomInfo, g_mcdon1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// McDonald's Treasure Land Adventure (Japan)
static struct BurnRomInfo g_mcdon2RomDesc[] = {
	{ "mcdonald's treasure land adventure (japan).md", 0x100000, 0xfebcfd06, BRF_PRG },
};

STD_ROM_PICK(g_mcdon2)
STD_ROM_FN(g_mcdon2)

struct BurnDriverD BurnDrvMDg_mcdon2 = {
	"g_mcdon2", "g_mcdona", NULL, "1993",
	"McDonald's Treasure Land Adventure (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mcdon2RomInfo, g_mcdon2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// McDonald's Treasure Land Adventure (USA)
static struct BurnRomInfo g_mcdon3RomDesc[] = {
	{ "mcdonald's treasure land adventure (usa).md", 0x100000, 0x04ef4899, BRF_PRG },
};

STD_ROM_PICK(g_mcdon3)
STD_ROM_FN(g_mcdon3)

struct BurnDriverD BurnDrvMDg_mcdon3 = {
	"g_mcdon3", "g_mcdona", NULL, "1993",
	"McDonald's Treasure Land Adventure (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mcdon3RomInfo, g_mcdon3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Medal City (Japan) (SegaNet)
static struct BurnRomInfo g_medalcRomDesc[] = {
	{ "medal city (japan) (seganet).md", 0x40000, 0x3ef4135d, BRF_PRG },
};

STD_ROM_PICK(g_medalc)
STD_ROM_FN(g_medalc)

struct BurnDriverD BurnDrvMDg_medalc = {
	"g_medalc", NULL, NULL, "",
	"Medal City (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_medalcRomInfo, g_medalcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Anser (Japan) (Program)
static struct BurnRomInfo g_megaanRomDesc[] = {
	{ "mega anser (japan) (program).md", 0x80000, 0x08ece367, BRF_PRG },
};

STD_ROM_PICK(g_megaan)
STD_ROM_FN(g_megaan)

struct BurnDriverD BurnDrvMDg_megaan = {
	"g_megaan", NULL, NULL, "1900",
	"Mega Anser (Japan) (Program)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megaanRomInfo, g_megaanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Bomberman (Europe)
static struct BurnRomInfo g_megaboRomDesc[] = {
	{ "mega bomberman (europe).md", 0x100000, 0x54ab3beb, BRF_PRG },
};

STD_ROM_PICK(g_megabo)
STD_ROM_FN(g_megabo)

struct BurnDriverD BurnDrvMDg_megabo = {
	"g_megabo", NULL, NULL, "1900",
	"Mega Bomberman (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megaboRomInfo, g_megaboRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Bomberman (USA)
static struct BurnRomInfo g_megab1RomDesc[] = {
	{ "mega bomberman (usa).md", 0x100000, 0x4bd6667d, BRF_PRG },
};

STD_ROM_PICK(g_megab1)
STD_ROM_FN(g_megab1)

struct BurnDriverD BurnDrvMDg_megab1 = {
	"g_megab1", "g_megabo", NULL, "1900",
	"Mega Bomberman (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megab1RomInfo, g_megab1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Bomberman - 8 Player Demo (Unl)
static struct BurnRomInfo g_mbm8RomDesc[] = {
	{ "mega bomberman - 8 player demo (unl).md", 0x100000, 0xd41c0d81, BRF_PRG },
};

STD_ROM_PICK(g_mbm8)
STD_ROM_FN(g_mbm8)

struct BurnDriverD BurnDrvMDg_mbm8 = {
	"g_mbm8", NULL, NULL, "1900",
	"Mega Bomberman - 8 Player Demo (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mbm8RomInfo, g_mbm8RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 10 (Brazil)
static struct BurnRomInfo g_megagaRomDesc[] = {
	{ "mega games 10 (brazil).md", 0x400000, 0xc19ae368, BRF_PRG },
};

STD_ROM_PICK(g_megaga)
STD_ROM_FN(g_megaga)

struct BurnDriverD BurnDrvMDg_megaga = {
	"g_megaga", NULL, NULL, "199?",
	"Mega Games 10 (Brazil)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megagaRomInfo, g_megagaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 2 (Europe)
static struct BurnRomInfo g_megag1RomDesc[] = {
	{ "mega games 2 (europe).md", 0x200000, 0x30d59f2f, BRF_PRG },
};

STD_ROM_PICK(g_megag1)
STD_ROM_FN(g_megag1)

struct BurnDriverD BurnDrvMDg_megag1 = {
	"g_megag1", NULL, NULL, "199?",
	"Mega Games 2 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megag1RomInfo, g_megag1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 3 (Europe)
static struct BurnRomInfo g_megag2RomDesc[] = {
	{ "mega games 3 (europe).md", 0x200000, 0xb4247d98, BRF_PRG },
};

STD_ROM_PICK(g_megag2)
STD_ROM_FN(g_megag2)

struct BurnDriverD BurnDrvMDg_megag2 = {
	"g_megag2", NULL, NULL, "199?",
	"Mega Games 3 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megag2RomInfo, g_megag2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 6 Vol. 1 (Europe)
static struct BurnRomInfo g_megag3RomDesc[] = {
	{ "mega games 6 vol. 1 (europe).md", 0x300000, 0xb66fb80d, BRF_PRG },
};

STD_ROM_PICK(g_megag3)
STD_ROM_FN(g_megag3)

struct BurnDriverD BurnDrvMDg_megag3 = {
	"g_megag3", NULL, NULL, "199?",
	"Mega Games 6 Vol. 1 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megag3RomInfo, g_megag3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 6 Vol. 2 (Europe)
static struct BurnRomInfo g_megag4RomDesc[] = {
	{ "mega games 6 vol. 2 (europe).md", 0x300000, 0xe8d10db9, BRF_PRG },
};

STD_ROM_PICK(g_megag4)
STD_ROM_FN(g_megag4)

struct BurnDriverD BurnDrvMDg_megag4 = {
	"g_megag4", NULL, NULL, "199?",
	"Mega Games 6 Vol. 2 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megag4RomInfo, g_megag4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games 6 Vol. 3 (Europe)
static struct BurnRomInfo g_megag5RomDesc[] = {
	{ "mega games 6 vol. 3 (europe).md", 0x300000, 0xfe3e7e4f, BRF_PRG },
};

STD_ROM_PICK(g_megag5)
STD_ROM_FN(g_megag5)

struct BurnDriverD BurnDrvMDg_megag5 = {
	"g_megag5", NULL, NULL, "199?",
	"Mega Games 6 Vol. 3 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megag5RomInfo, g_megag5RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Games I (Europe)
static struct BurnRomInfo g_megag6RomDesc[] = {
	{ "mega games i (europe).md", 0x100000, 0xdb753224, BRF_PRG },
};

STD_ROM_PICK(g_megag6)
STD_ROM_FN(g_megag6)

struct BurnDriverD BurnDrvMDg_megag6 = {
	"g_megag6", NULL, NULL, "199?",
	"Mega Games I (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megag6RomInfo, g_megag6RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Man - The Wily Wars (Europe)
static struct BurnRomInfo g_megamaRomDesc[] = {
	{ "mega man - the wily wars (europe).md", 0x200000, 0xdcf6e8b2, BRF_PRG },
};

STD_ROM_PICK(g_megama)
STD_ROM_FN(g_megama)

struct BurnDriverD BurnDrvMDg_megama = {
	"g_megama", NULL, NULL, "1900",
	"Mega Man - The Wily Wars (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megamaRomInfo, g_megamaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega SWIV (E) [p1][!]
static struct BurnRomInfo g_mswivbRomDesc[] = {
	{ "mega swiv (e) [p1][!].md", 0x100000, 0x1ec66bf7, BRF_PRG },
};

STD_ROM_PICK(g_mswivb)
STD_ROM_FN(g_mswivb)

struct BurnDriverD BurnDrvMDg_mswivb = {
	"g_mswivb", "g_mswiv", NULL, "1900",
	"Mega SWIV (E) [p1][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mswivbRomInfo, g_mswivbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega SWIV (Europe)
static struct BurnRomInfo g_mswivRomDesc[] = {
	{ "mega swiv (europe).md", 0x100000, 0x78c2f046, BRF_PRG },
};

STD_ROM_PICK(g_mswiv)
STD_ROM_FN(g_mswiv)

struct BurnDriverD BurnDrvMDg_mswiv = {
	"g_mswiv", NULL, NULL, "1900",
	"Mega SWIV (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mswivRomInfo, g_mswivRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Turrican (Europe)
static struct BurnRomInfo g_megatuRomDesc[] = {
	{ "mega turrican (europe).md", 0x100000, 0xb1d15d0f, BRF_PRG },
};

STD_ROM_PICK(g_megatu)
STD_ROM_FN(g_megatu)

struct BurnDriverD BurnDrvMDg_megatu = {
	"g_megatu", NULL, NULL, "1994",
	"Mega Turrican (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megatuRomInfo, g_megatuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega Turrican (USA)
static struct BurnRomInfo g_megat1RomDesc[] = {
	{ "mega turrican (usa).md", 0x100000, 0xfe898cc9, BRF_PRG },
};

STD_ROM_PICK(g_megat1)
STD_ROM_FN(g_megat1)

struct BurnDriverD BurnDrvMDg_megat1 = {
	"g_megat1", "g_megatu", NULL, "1994",
	"Mega Turrican (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megat1RomInfo, g_megat1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega-Lo-Mania (Europe) (v1.1)
static struct BurnRomInfo g_megaloRomDesc[] = {
	{ "mega-lo-mania (europe) (v1.1).md", 0x100000, 0xab9fed30, BRF_PRG },
};

STD_ROM_PICK(g_megalo)
STD_ROM_FN(g_megalo)

struct BurnDriverD BurnDrvMDg_megalo = {
	"g_megalo", NULL, NULL, "1994",
	"Mega-Lo-Mania (Europe) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megaloRomInfo, g_megaloRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega-Lo-Mania (Europe)
static struct BurnRomInfo g_megal1RomDesc[] = {
	{ "mega-lo-mania (europe).md", 0x100000, 0x2148d56d, BRF_PRG },
};

STD_ROM_PICK(g_megal1)
STD_ROM_FN(g_megal1)

struct BurnDriverD BurnDrvMDg_megal1 = {
	"g_megal1", "g_megalo", NULL, "1994",
	"Mega-Lo-Mania (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megal1RomInfo, g_megal1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega-Lo-Mania (France)
static struct BurnRomInfo g_megal2RomDesc[] = {
	{ "mega-lo-mania (france).md", 0x100000, 0x3b3231ed, BRF_PRG },
};

STD_ROM_PICK(g_megal2)
STD_ROM_FN(g_megal2)

struct BurnDriverD BurnDrvMDg_megal2 = {
	"g_megal2", "g_megalo", NULL, "",
	"Mega-Lo-Mania (France)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megal2RomInfo, g_megal2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mega-Lo-Mania (Japan)
static struct BurnRomInfo g_megal3RomDesc[] = {
	{ "mega-lo-mania (japan).md", 0x100000, 0xa60d8619, BRF_PRG },
};

STD_ROM_PICK(g_megal3)
STD_ROM_FN(g_megal3)

struct BurnDriverD BurnDrvMDg_megal3 = {
	"g_megal3", "g_megalo", NULL, "1994",
	"Mega-Lo-Mania (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megal3RomInfo, g_megal3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MegaMind (Japan) (SegaNet)
static struct BurnRomInfo g_megamiRomDesc[] = {
	{ "megamind (japan) (seganet).md", 0x40000, 0x76df2ae2, BRF_PRG },
};

STD_ROM_PICK(g_megami)
STD_ROM_FN(g_megami)

struct BurnDriverD BurnDrvMDg_megami = {
	"g_megami", NULL, NULL, "1900",
	"MegaMind (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megamiRomInfo, g_megamiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MegaNet (Brazil) (Program)
static struct BurnRomInfo g_meganeRomDesc[] = {
	{ "meganet (brazil) (program).md", 0x40000, 0xfab33cc2, BRF_PRG },
};

STD_ROM_PICK(g_megane)
STD_ROM_FN(g_megane)

struct BurnDriverD BurnDrvMDg_megane = {
	"g_megane", NULL, NULL, "",
	"MegaNet (Brazil) (Program)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_meganeRomInfo, g_meganeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MegaPanel (Japan)
static struct BurnRomInfo g_megapaRomDesc[] = {
	{ "megapanel (japan).md", 0x40000, 0x6240f579, BRF_PRG },
};

STD_ROM_PICK(g_megapa)
STD_ROM_FN(g_megapa)

struct BurnDriverD BurnDrvMDg_megapa = {
	"g_megapa", NULL, NULL, "1900",
	"MegaPanel (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megapaRomInfo, g_megapaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MegaTrax (Japan)
static struct BurnRomInfo g_megatrRomDesc[] = {
	{ "megatrax (japan).md", 0x80000, 0xa0837741, BRF_PRG },
};

STD_ROM_PICK(g_megatr)
STD_ROM_FN(g_megatr)

struct BurnDriverD BurnDrvMDg_megatr = {
	"g_megatr", "g_quadch", NULL, "1900",
	"MegaTrax (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_megatrRomInfo, g_megatrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Menacer 6-Game Cartridge (USA, Europe)
static struct BurnRomInfo g_menaceRomDesc[] = {
	{ "menacer 6-game cartridge (usa, europe).md", 0x100000, 0x936b85f7, BRF_PRG },
};

STD_ROM_PICK(g_menace)
STD_ROM_FN(g_menace)

struct BurnDriverD BurnDrvMDg_menace = {
	"g_menace", NULL, NULL, "",
	"Menacer 6-Game Cartridge (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_menaceRomInfo, g_menaceRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Meng Huan Shui Guo Pan - 777 Casino (China) (Unl)
static struct BurnRomInfo g_menghuRomDesc[] = {
	{ "meng huan shui guo pan - 777 casino (china) (unl).md", 0x100000, 0x42dc03e4, BRF_PRG },
};

STD_ROM_PICK(g_menghu)
STD_ROM_FN(g_menghu)

struct BurnDriverD BurnDrvMDg_menghu = {
	"g_menghu", NULL, NULL, "",
	"Meng Huan Shui Guo Pan - 777 Casino (China) (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_menghuRomInfo, g_menghuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Metal Fangs (Japan)
static struct BurnRomInfo g_metalfRomDesc[] = {
	{ "metal fangs (japan).md", 0x80000, 0xa8df1c4c, BRF_PRG },
};

STD_ROM_PICK(g_metalf)
STD_ROM_FN(g_metalf)

struct BurnDriverD BurnDrvMDg_metalf = {
	"g_metalf", NULL, NULL, "1900",
	"Metal Fangs (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_metalfRomInfo, g_metalfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Michael Jackson's Moonwalker (World) (Rev A)
static struct BurnRomInfo g_michaeRomDesc[] = {
	{ "michael jackson's moonwalker (world) (rev a).md", 0x80000, 0x11ce1f9e, BRF_PRG },
};

STD_ROM_PICK(g_michae)
STD_ROM_FN(g_michae)

struct BurnDriver BurnDrvMDg_michae = {
	"g_michae", NULL, NULL, "1900",
	"Michael Jackson's Moonwalker (World) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_michaeRomInfo, g_michaeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Michael Jackson's Moonwalker (World)
static struct BurnRomInfo g_micha1RomDesc[] = {
	{ "michael jackson's moonwalker (world).md", 0x80000, 0x6a70791b, BRF_PRG },
};

STD_ROM_PICK(g_micha1)
STD_ROM_FN(g_micha1)

struct BurnDriver BurnDrvMDg_micha1 = {
	"g_micha1", "g_michae", NULL, "1900",
	"Michael Jackson's Moonwalker (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_micha1RomInfo, g_micha1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mick & Mack as the Global Gladiators (USA) (Beta)
static struct BurnRomInfo g_mickmbRomDesc[] = {
	{ "mick & mack as the global gladiators (usa) (beta).md", 0x100000, 0x08c2af21, BRF_PRG },
};

STD_ROM_PICK(g_mickmb)
STD_ROM_FN(g_mickmb)

struct BurnDriverD BurnDrvMDg_mickmb = {
	"g_mickmb", "g_global", NULL, "1994",
	"Mick & Mack as the Global Gladiators (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mickmbRomInfo, g_mickmbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mick & Mack as the Global Gladiators (USA)
static struct BurnRomInfo g_mickmRomDesc[] = {
	{ "mick & mack as the global gladiators (usa).md", 0x100000, 0x40f17bb3, BRF_PRG },
};

STD_ROM_PICK(g_mickm)
STD_ROM_FN(g_mickm)

struct BurnDriverD BurnDrvMDg_mickm = {
	"g_mickm", "g_global", NULL, "1994",
	"Mick & Mack as the Global Gladiators (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mickmRomInfo, g_mickmRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mickey Mania - The Timeless Adventures of Mickey Mouse (Europe)
static struct BurnRomInfo g_mickeyRomDesc[] = {
	{ "mickey mania - the timeless adventures of mickey mouse (europe).md", 0x200000, 0xcb5a8b85, BRF_PRG },
};

STD_ROM_PICK(g_mickey)
STD_ROM_FN(g_mickey)

struct BurnDriverD BurnDrvMDg_mickey = {
	"g_mickey", NULL, NULL, "1994",
	"Mickey Mania - The Timeless Adventures of Mickey Mouse (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mickeyRomInfo, g_mickeyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mickey Mania - The Timeless Adventures of Mickey Mouse (Japan)
static struct BurnRomInfo g_micke1RomDesc[] = {
	{ "mickey mania - the timeless adventures of mickey mouse (japan).md", 0x200000, 0x23180cf7, BRF_PRG },
};

STD_ROM_PICK(g_micke1)
STD_ROM_FN(g_micke1)

struct BurnDriverD BurnDrvMDg_micke1 = {
	"g_micke1", "g_mickey", NULL, "1994",
	"Mickey Mania - The Timeless Adventures of Mickey Mouse (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_micke1RomInfo, g_micke1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mickey Mania - The Timeless Adventures of Mickey Mouse (USA) (Beta)
static struct BurnRomInfo g_micke2RomDesc[] = {
	{ "mickey mania - the timeless adventures of mickey mouse (usa) (beta).md", 0x200000, 0x7fc1bdf0, BRF_PRG },
};

STD_ROM_PICK(g_micke2)
STD_ROM_FN(g_micke2)

struct BurnDriverD BurnDrvMDg_micke2 = {
	"g_micke2", "g_mickey", NULL, "1994",
	"Mickey Mania - The Timeless Adventures of Mickey Mouse (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_micke2RomInfo, g_micke2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mickey Mania - The Timeless Adventures of Mickey Mouse (USA)
static struct BurnRomInfo g_micke3RomDesc[] = {
	{ "mickey mania - the timeless adventures of mickey mouse (usa).md", 0x200000, 0x629e5963, BRF_PRG },
};

STD_ROM_PICK(g_micke3)
STD_ROM_FN(g_micke3)

struct BurnDriverD BurnDrvMDg_micke3 = {
	"g_micke3", "g_mickey", NULL, "1994",
	"Mickey Mania - The Timeless Adventures of Mickey Mouse (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_micke3RomInfo, g_micke3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mickey's Ultimate Challenge (USA)
static struct BurnRomInfo g_mickucRomDesc[] = {
	{ "mickey's ultimate challenge (usa).md", 0x100000, 0x30b512ee, BRF_PRG },
};

STD_ROM_PICK(g_mickuc)
STD_ROM_FN(g_mickuc)

struct BurnDriverD BurnDrvMDg_mickuc = {
	"g_mickuc", NULL, NULL, "1900",
	"Mickey's Ultimate Challenge (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mickucRomInfo, g_mickucRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines (C)
static struct BurnRomInfo g_micmaRomDesc[] = {
	{ "micro machines (c).md", 0x80000, 0x54e4cff1, BRF_PRG },
};

STD_ROM_PICK(g_micma)
STD_ROM_FN(g_micma)

struct BurnDriver BurnDrvMDg_micma = {
	"g_micma", "g_micm", NULL, "1993",
	"Micro Machines (C)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_micmaRomInfo, g_micmaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines (USA, Europe) (Alt)
static struct BurnRomInfo g_micmbRomDesc[] = {
	{ "micro machines (usa, europe) (alt).md", 0x80000, 0xe5cf560d, BRF_PRG },
};

STD_ROM_PICK(g_micmb)
STD_ROM_FN(g_micmb)

struct BurnDriver BurnDrvMDg_micmb = {
	"g_micmb", "g_micm", NULL, "1993",
	"Micro Machines (USA, Europe) (Alt)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_micmbRomInfo, g_micmbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines (USA, Europe) (MDMM ACD3)
static struct BurnRomInfo g_micmcRomDesc[] = {
	{ "micro machines (usa, europe) (mdmm acd3).md", 0x80000, 0x50081a0b, BRF_PRG },
};

STD_ROM_PICK(g_micmc)
STD_ROM_FN(g_micmc)

struct BurnDriver BurnDrvMDg_micmc = {
	"g_micmc", "g_micm", NULL, "1993",
	"Micro Machines (USA, Europe) (MDMM ACD3)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_micmcRomInfo, g_micmcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines (USA, Europe)
static struct BurnRomInfo g_micmRomDesc[] = {
	{ "micro machines (usa, europe).md", 0x80000, 0x7ffbd1ad, BRF_PRG },
};

STD_ROM_PICK(g_micm)
STD_ROM_FN(g_micm)

struct BurnDriver BurnDrvMDg_micm = {
	"g_micm", NULL, NULL, "1993",
	"Micro Machines (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_micmRomInfo, g_micmRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines Turbo Tournament 96 (V1.1) (E)
static struct BurnRomInfo g_mic96RomDesc[] = {
	{ "micro machines turbo tournament 96 (v1.1) (e).md", 0x100000, 0x3137b3c4, BRF_PRG },
};

STD_ROM_PICK(g_mic96)
STD_ROM_FN(g_mic96)

struct BurnDriver BurnDrvMDg_mic96 = {
	"g_mic96", NULL, NULL, "1995",
	"Micro Machines Turbo Tournament 96 (V1.1) (E)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mic96RomInfo, g_mic96RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines 2 - Turbo Tournament (Europe) (J-Cart) (Alt)
static struct BurnRomInfo g_micm2RomDesc[] = {
	{ "micro machines 2 - turbo tournament (europe) (j-cart) (alt).md", 0x100000, 0x01c22a5d, BRF_PRG },
};

STD_ROM_PICK(g_micm2)
STD_ROM_FN(g_micm2)

struct BurnDriver BurnDrvMDg_micm2 = {
	"g_micm2", NULL, NULL, "1994",
	"Micro Machines 2 - Turbo Tournament (Europe) (J-Cart) (Alt)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_micm2RomInfo, g_micm2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines 2 - Turbo Tournament (Europe) (J-Cart)
static struct BurnRomInfo g_micm2aRomDesc[] = {
	{ "micro machines 2 - turbo tournament (europe) (j-cart).md", 0x100000, 0x42bfb7eb, BRF_PRG },
};

STD_ROM_PICK(g_micm2a)
STD_ROM_FN(g_micm2a)

struct BurnDriver BurnDrvMDg_micm2a = {
	"g_micm2a", "g_micm2", NULL, "1994",
	"Micro Machines 2 - Turbo Tournament (Europe) (J-Cart)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_micm2aRomInfo, g_micm2aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines Military (Europe) (J-Cart)
static struct BurnRomInfo g_mmmRomDesc[] = {
	{ "micro machines military (europe) (j-cart).md", 0x100000, 0xb3abb15e, BRF_PRG },
};

STD_ROM_PICK(g_mmm)
STD_ROM_FN(g_mmm)

struct BurnDriver BurnDrvMDg_mmm = {
	"g_mmm", NULL, NULL, "1996",
	"Micro Machines Military (Europe) (J-Cart)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mmmRomInfo, g_mmmRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines Military - It's a Blast! (E) [x]
static struct BurnRomInfo g_mmmaRomDesc[] = {
	{ "micro machines military - it's a blast! (e) [x].md", 0x100000, 0xa1ad9f97, BRF_PRG },
};

STD_ROM_PICK(g_mmma)
STD_ROM_FN(g_mmma)

struct BurnDriver BurnDrvMDg_mmma = {
	"g_mmma", "g_mmm", NULL, "1996",
	"Micro Machines Military - It's a Blast! (E) [x]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mmmaRomInfo, g_mmmaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines Turbo Tournament 96 (Europe) (J-Cart)
static struct BurnRomInfo g_mic96aRomDesc[] = {
	{ "micro machines turbo tournament 96 (europe) (j-cart).md", 0x100000, 0x7492b1de, BRF_PRG },
};

STD_ROM_PICK(g_mic96a)
STD_ROM_FN(g_mic96a)

struct BurnDriverD BurnDrvMDg_mic96a = {
	"g_mic96a", "g_mic96", NULL, "",
	"Micro Machines Turbo Tournament 96 (Europe) (J-Cart)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mic96aRomInfo, g_mic96aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Micro Machines Turbo Tournament 96 (Europe) (v1.1) (J-Cart)
static struct BurnRomInfo g_mic96bRomDesc[] = {
	{ "micro machines turbo tournament 96 (europe) (v1.1) (j-cart).md", 0x100000, 0x23319d0d, BRF_PRG },
};

STD_ROM_PICK(g_mic96b)
STD_ROM_FN(g_mic96b)

struct BurnDriver BurnDrvMDg_mic96b = {
	"g_mic96b", "g_mic96", NULL, "1995",
	"Micro Machines Turbo Tournament 96 (Europe) (v1.1) (J-Cart)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mic96bRomInfo, g_mic96bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Midnight Resistance (Japan)
static struct BurnRomInfo g_midrsjRomDesc[] = {
	{ "midnight resistance (japan).md", 0x100000, 0x8f3f6e4d, BRF_PRG },
};

STD_ROM_PICK(g_midrsj)
STD_ROM_FN(g_midrsj)

struct BurnDriverD BurnDrvMDg_midrsj = {
	"g_midrsj", "g_midrs", NULL, "1900",
	"Midnight Resistance (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_midrsjRomInfo, g_midrsjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Midnight Resistance (USA)
static struct BurnRomInfo g_midrsRomDesc[] = {
	{ "midnight resistance (usa).md", 0x100000, 0x187c6af6, BRF_PRG },
};

STD_ROM_PICK(g_midrs)
STD_ROM_FN(g_midrs)

struct BurnDriverD BurnDrvMDg_midrs = {
	"g_midrs", NULL, NULL, "1900",
	"Midnight Resistance (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_midrsRomInfo, g_midrsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Midway Presents Arcade's Greatest Hits (Europe)
static struct BurnRomInfo g_midwayRomDesc[] = {
	{ "midway presents arcade's greatest hits (europe).md", 0x80000, 0xc0dce0e5, BRF_PRG },
};

STD_ROM_PICK(g_midway)
STD_ROM_FN(g_midway)

struct BurnDriverD BurnDrvMDg_midway = {
	"g_midway", NULL, NULL, "1900",
	"Midway Presents Arcade's Greatest Hits (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_midwayRomInfo, g_midwayRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mig-29 Fighter Pilot (Europe)
static struct BurnRomInfo g_mig2fiRomDesc[] = {
	{ "mig-29 fighter pilot (europe).md", 0x100000, 0x70b0a5d7, BRF_PRG },
};

STD_ROM_PICK(g_mig2fi)
STD_ROM_FN(g_mig2fi)

struct BurnDriverD BurnDrvMDg_mig2fi = {
	"g_mig2fi", NULL, NULL, "1900",
	"Mig-29 Fighter Pilot (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mig2fiRomInfo, g_mig2fiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mig-29 Fighter Pilot (Japan)
static struct BurnRomInfo g_mig2f1RomDesc[] = {
	{ "mig-29 fighter pilot (japan).md", 0x100000, 0x3d239046, BRF_PRG },
};

STD_ROM_PICK(g_mig2f1)
STD_ROM_FN(g_mig2f1)

struct BurnDriverD BurnDrvMDg_mig2f1 = {
	"g_mig2f1", "g_mig2fi", NULL, "",
	"Mig-29 Fighter Pilot (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mig2f1RomInfo, g_mig2f1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mig-29 Fighter Pilot (USA)
static struct BurnRomInfo g_mig2f2RomDesc[] = {
	{ "mig-29 fighter pilot (usa).md", 0x100000, 0x59ccabb2, BRF_PRG },
};

STD_ROM_PICK(g_mig2f2)
STD_ROM_FN(g_mig2f2)

struct BurnDriverD BurnDrvMDg_mig2f2 = {
	"g_mig2f2", "g_mig2fi", NULL, "1900",
	"Mig-29 Fighter Pilot (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mig2f2RomInfo, g_mig2f2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Might and Magic - Gates to Another World (USA, Europe)
static struct BurnRomInfo g_mightaRomDesc[] = {
	{ "might and magic - gates to another world (usa, europe).md", 0xc0000, 0xf509145f, BRF_PRG },
};

STD_ROM_PICK(g_mighta)
STD_ROM_FN(g_mighta)

struct BurnDriver BurnDrvMDg_mighta = {
	"g_mighta", NULL, NULL, "1900",
	"Might and Magic - Gates to Another World (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mightaRomInfo, g_mightaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Might and Magic III - Isles of Terra (USA) (Proto)
static struct BurnRomInfo g_mm3pRomDesc[] = {
	{ "might and magic iii - isles of terra (usa) (proto).md", 0x200000, 0x6ef7104a, BRF_PRG },
};

STD_ROM_PICK(g_mm3p)
STD_ROM_FN(g_mm3p)

struct BurnDriverD BurnDrvMDg_mm3p = {
	"g_mm3p", NULL, NULL, "1900",
	"Might and Magic III - Isles of Terra (USA) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mm3pRomInfo, g_mm3pRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Europe)
static struct BurnRomInfo g_prRomDesc[] = {
	{ "mighty morphin power rangers (europe).md", 0x200000, 0x7f96e663, BRF_PRG },
};

STD_ROM_PICK(g_pr)
STD_ROM_FN(g_pr)

struct BurnDriverD BurnDrvMDg_pr = {
	"g_pr", NULL, NULL, "1900",
	"Mighty Morphin Power Rangers (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prRomInfo, g_prRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype - Aug 04, 1994)
static struct BurnRomInfo g_prpaRomDesc[] = {
	{ "mighty morphin power rangers (prototype - aug 04, 1994).md", 0x200000, 0xf3ae5aaf, BRF_PRG },
};

STD_ROM_PICK(g_prpa)
STD_ROM_FN(g_prpa)

struct BurnDriverD BurnDrvMDg_prpa = {
	"g_prpa", "g_pr", NULL, "",
	"Mighty Morphin Power Rangers (Prototype - Aug 04, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prpaRomInfo, g_prpaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype - Aug 08, 1994)
static struct BurnRomInfo g_prpbRomDesc[] = {
	{ "mighty morphin power rangers (prototype - aug 08, 1994).md", 0x200000, 0x57644549, BRF_PRG },
};

STD_ROM_PICK(g_prpb)
STD_ROM_FN(g_prpb)

struct BurnDriverD BurnDrvMDg_prpb = {
	"g_prpb", "g_pr", NULL, "",
	"Mighty Morphin Power Rangers (Prototype - Aug 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prpbRomInfo, g_prpbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype - Aug 09, 1994)
static struct BurnRomInfo g_prpcRomDesc[] = {
	{ "mighty morphin power rangers (prototype - aug 09, 1994).md", 0x200000, 0x4356fe0a, BRF_PRG },
};

STD_ROM_PICK(g_prpc)
STD_ROM_FN(g_prpc)

struct BurnDriverD BurnDrvMDg_prpc = {
	"g_prpc", "g_pr", NULL, "",
	"Mighty Morphin Power Rangers (Prototype - Aug 09, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prpcRomInfo, g_prpcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype - Aug 10, 1994)
static struct BurnRomInfo g_prpdRomDesc[] = {
	{ "mighty morphin power rangers (prototype - aug 10, 1994).md", 0x200000, 0xe79cd214, BRF_PRG },
};

STD_ROM_PICK(g_prpd)
STD_ROM_FN(g_prpd)

struct BurnDriverD BurnDrvMDg_prpd = {
	"g_prpd", "g_pr", NULL, "",
	"Mighty Morphin Power Rangers (Prototype - Aug 10, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prpdRomInfo, g_prpdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype - Jul 08, 1994)
static struct BurnRomInfo g_prpeRomDesc[] = {
	{ "mighty morphin power rangers (prototype - jul 08, 1994).md", 0x200000, 0xe6916c54, BRF_PRG },
};

STD_ROM_PICK(g_prpe)
STD_ROM_FN(g_prpe)

struct BurnDriverD BurnDrvMDg_prpe = {
	"g_prpe", "g_pr", NULL, "",
	"Mighty Morphin Power Rangers (Prototype - Jul 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prpeRomInfo, g_prpeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (Prototype - Jul 18, 1994)
static struct BurnRomInfo g_prpfRomDesc[] = {
	{ "mighty morphin power rangers (prototype - jul 18, 1994).md", 0x200000, 0x5accdb1a, BRF_PRG },
};

STD_ROM_PICK(g_prpf)
STD_ROM_FN(g_prpf)

struct BurnDriverD BurnDrvMDg_prpf = {
	"g_prpf", "g_pr", NULL, "",
	"Mighty Morphin Power Rangers (Prototype - Jul 18, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prpfRomInfo, g_prpfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers (USA)
static struct BurnRomInfo g_pruRomDesc[] = {
	{ "mighty morphin power rangers (usa).md", 0x200000, 0x715158a9, BRF_PRG },
};

STD_ROM_PICK(g_pru)
STD_ROM_FN(g_pru)

struct BurnDriverD BurnDrvMDg_pru = {
	"g_pru", "g_pr", NULL, "1900",
	"Mighty Morphin Power Rangers (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pruRomInfo, g_pruRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (Europe)
static struct BurnRomInfo g_prtmRomDesc[] = {
	{ "mighty morphin power rangers - the movie (europe).md", 0x200000, 0x254a4972, BRF_PRG },
};

STD_ROM_PICK(g_prtm)
STD_ROM_FN(g_prtm)

struct BurnDriverD BurnDrvMDg_prtm = {
	"g_prtm", NULL, NULL, "1900",
	"Mighty Morphin Power Rangers - The Movie (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prtmRomInfo, g_prtmRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (Prototype - Jul 13, 1995)
static struct BurnRomInfo g_prtmpaRomDesc[] = {
	{ "mighty morphin power rangers - the movie (prototype - jul 13, 1995).md", 0x200000, 0x227bf7fd, BRF_PRG },
};

STD_ROM_PICK(g_prtmpa)
STD_ROM_FN(g_prtmpa)

struct BurnDriverD BurnDrvMDg_prtmpa = {
	"g_prtmpa", "g_prtm", NULL, "",
	"Mighty Morphin Power Rangers - The Movie (Prototype - Jul 13, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prtmpaRomInfo, g_prtmpaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (Prototype - Jul 17, 1995)
static struct BurnRomInfo g_prtmpbRomDesc[] = {
	{ "mighty morphin power rangers - the movie (prototype - jul 17, 1995).md", 0x200000, 0x579de657, BRF_PRG },
};

STD_ROM_PICK(g_prtmpb)
STD_ROM_FN(g_prtmpb)

struct BurnDriverD BurnDrvMDg_prtmpb = {
	"g_prtmpb", "g_prtm", NULL, "",
	"Mighty Morphin Power Rangers - The Movie (Prototype - Jul 17, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prtmpbRomInfo, g_prtmpbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (Prototype - Jul 22, 1995)
static struct BurnRomInfo g_prtmpcRomDesc[] = {
	{ "mighty morphin power rangers - the movie (prototype - jul 22, 1995).md", 0x200000, 0xc2ca3a8b, BRF_PRG },
};

STD_ROM_PICK(g_prtmpc)
STD_ROM_FN(g_prtmpc)

struct BurnDriverD BurnDrvMDg_prtmpc = {
	"g_prtmpc", "g_prtm", NULL, "",
	"Mighty Morphin Power Rangers - The Movie (Prototype - Jul 22, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prtmpcRomInfo, g_prtmpcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (Prototype - Jul 24, 1995)
static struct BurnRomInfo g_prtmpdRomDesc[] = {
	{ "mighty morphin power rangers - the movie (prototype - jul 24, 1995).md", 0x200000, 0x3429fa3a, BRF_PRG },
};

STD_ROM_PICK(g_prtmpd)
STD_ROM_FN(g_prtmpd)

struct BurnDriverD BurnDrvMDg_prtmpd = {
	"g_prtmpd", "g_prtm", NULL, "",
	"Mighty Morphin Power Rangers - The Movie (Prototype - Jul 24, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prtmpdRomInfo, g_prtmpdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mighty Morphin Power Rangers - The Movie (USA)
static struct BurnRomInfo g_prtmuRomDesc[] = {
	{ "mighty morphin power rangers - the movie (usa).md", 0x200000, 0xaa941cbc, BRF_PRG },
};

STD_ROM_PICK(g_prtmu)
STD_ROM_FN(g_prtmu)

struct BurnDriverD BurnDrvMDg_prtmu = {
	"g_prtmu", "g_prtm", NULL, "1900",
	"Mighty Morphin Power Rangers - The Movie (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prtmuRomInfo, g_prtmuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mike Ditka Power Football (USA, Europe) (Alt)
static struct BurnRomInfo g_mikediRomDesc[] = {
	{ "mike ditka power football (usa, europe) (alt).md", 0x100000, 0xde50ca8e, BRF_PRG },
};

STD_ROM_PICK(g_mikedi)
STD_ROM_FN(g_mikedi)

struct BurnDriverD BurnDrvMDg_mikedi = {
	"g_mikedi", NULL, NULL, "1900",
	"Mike Ditka Power Football (USA, Europe) (Alt)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mikediRomInfo, g_mikediRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mike Ditka Power Football (USA, Europe)
static struct BurnRomInfo g_miked1RomDesc[] = {
	{ "mike ditka power football (usa, europe).md", 0x100000, 0x6078b310, BRF_PRG },
};

STD_ROM_PICK(g_miked1)
STD_ROM_FN(g_miked1)

struct BurnDriverD BurnDrvMDg_miked1 = {
	"g_miked1", "g_mikedi", NULL, "1900",
	"Mike Ditka Power Football (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_miked1RomInfo, g_miked1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Minato no Traysia (Japan)
static struct BurnRomInfo g_minatoRomDesc[] = {
	{ "minato no traysia (japan).md", 0x100000, 0xbd89fd09, BRF_PRG },
};

STD_ROM_PICK(g_minato)
STD_ROM_FN(g_minato)

struct BurnDriverD BurnDrvMDg_minato = {
	"g_minato", "g_traysi", NULL, "",
	"Minato no Traysia (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_minatoRomInfo, g_minatoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Minnesota Fats - Pool Legend (USA)
static struct BurnRomInfo g_minnesRomDesc[] = {
	{ "minnesota fats - pool legend (usa).md", 0x100000, 0x38174f40, BRF_PRG },
};

STD_ROM_PICK(g_minnes)
STD_ROM_FN(g_minnes)

struct BurnDriverD BurnDrvMDg_minnes = {
	"g_minnes", NULL, NULL, "1900",
	"Minnesota Fats - Pool Legend (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_minnesRomInfo, g_minnesRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Miracle Piano Teaching System (USA)
static struct BurnRomInfo g_miraclRomDesc[] = {
	{ "miracle piano teaching system (usa).md", 0x80000, 0xa719542e, BRF_PRG },
};

STD_ROM_PICK(g_miracl)
STD_ROM_FN(g_miracl)

struct BurnDriverD BurnDrvMDg_miracl = {
	"g_miracl", NULL, NULL, "1900",
	"Miracle Piano Teaching System (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_miraclRomInfo, g_miraclRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MK 5 - Mortal Combat - SubZero (Unl) [!]
static struct BurnRomInfo g_mk5morRomDesc[] = {
	{ "mk 5 - mortal combat - subzero (unl) [!].md", 0x200000, 0x11e367a1, BRF_PRG },
};

STD_ROM_PICK(g_mk5mor)
STD_ROM_FN(g_mk5mor)

struct BurnDriverD BurnDrvMDg_mk5mor = {
	"g_mk5mor", NULL, NULL, "",
	"MK 5 - Mortal Combat - SubZero (Unl) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mk5morRomInfo, g_mk5morRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MK 5 - Mortal Combat - SubZero (Unl) [p1][!]
static struct BurnRomInfo g_mk5mo1RomDesc[] = {
	{ "mk 5 - mortal combat - subzero (unl) [p1][!].md", 0x200000, 0x41203006, BRF_PRG },
};

STD_ROM_PICK(g_mk5mo1)
STD_ROM_FN(g_mk5mo1)

struct BurnDriverD BurnDrvMDg_mk5mo1 = {
	"g_mk5mo1", "g_mk5mor", NULL, "",
	"MK 5 - Mortal Combat - SubZero (Unl) [p1][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mk5mo1RomInfo, g_mk5mo1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MLBPA Baseball (USA)
static struct BurnRomInfo g_mlbpabRomDesc[] = {
	{ "mlbpa baseball (usa).md", 0x200000, 0x14a8064d, BRF_PRG },
};

STD_ROM_PICK(g_mlbpab)
STD_ROM_FN(g_mlbpab)

struct BurnDriverD BurnDrvMDg_mlbpab = {
	"g_mlbpab", NULL, NULL, "1900",
	"MLBPA Baseball (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mlbpabRomInfo, g_mlbpabRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Monopoly (USA) (Beta)
static struct BurnRomInfo g_monobRomDesc[] = {
	{ "monopoly (usa) (beta).md", 0x80000, 0xdfbcc3fa, BRF_PRG },
};

STD_ROM_PICK(g_monob)
STD_ROM_FN(g_monob)

struct BurnDriverD BurnDrvMDg_monob = {
	"g_monob", "g_mono", NULL, "",
	"Monopoly (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_monobRomInfo, g_monobRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Monopoly (USA)
static struct BurnRomInfo g_monoRomDesc[] = {
	{ "monopoly (usa).md", 0x80000, 0xc10268da, BRF_PRG },
};

STD_ROM_PICK(g_mono)
STD_ROM_FN(g_mono)

struct BurnDriverD BurnDrvMDg_mono = {
	"g_mono", NULL, NULL, "",
	"Monopoly (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_monoRomInfo, g_monoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Monster World IV (Japan)
static struct BurnRomInfo g_monsteRomDesc[] = {
	{ "monster world iv (japan).md", 0x200000, 0x36a3aaa4, BRF_PRG },
};

STD_ROM_PICK(g_monste)
STD_ROM_FN(g_monste)

struct BurnDriver BurnDrvMDg_monste = {
	"g_monste", NULL, NULL, "1900",
	"Monster World IV (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_monsteRomInfo, g_monsteRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mortal Kombat (World) (v1.1)
static struct BurnRomInfo g_mkRomDesc[] = {
	{ "mortal kombat (world) (v1.1).md", 0x200000, 0x33f19ab6, BRF_PRG },
};

STD_ROM_PICK(g_mk)
STD_ROM_FN(g_mk)

struct BurnDriver BurnDrvMDg_mk = {
	"g_mk", NULL, NULL, "1993",
	"Mortal Kombat (World) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mkRomInfo, g_mkRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mortal Kombat (World)
static struct BurnRomInfo g_mkaRomDesc[] = {
	{ "mortal kombat (world).md", 0x200000, 0x1aa3a207, BRF_PRG },
};

STD_ROM_PICK(g_mka)
STD_ROM_FN(g_mka)

struct BurnDriver BurnDrvMDg_mka = {
	"g_mka", "g_mk", NULL, "1900",
	"Mortal Kombat (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mkaRomInfo, g_mkaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mortal Kombat 3 (Europe)
static struct BurnRomInfo g_mk3RomDesc[] = {
	{ "mortal kombat 3 (europe).md", 0x400000, 0xaf6de3e8, BRF_PRG },
};

STD_ROM_PICK(g_mk3)
STD_ROM_FN(g_mk3)

struct BurnDriver BurnDrvMDg_mk3 = {
	"g_mk3", NULL, NULL, "1900",
	"Mortal Kombat 3 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mk3RomInfo, g_mk3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mortal Kombat 3 (USA)
static struct BurnRomInfo g_mk3aRomDesc[] = {
	{ "mortal kombat 3 (usa).md", 0x400000, 0xdd638af6, BRF_PRG },
};

STD_ROM_PICK(g_mk3a)
STD_ROM_FN(g_mk3a)

struct BurnDriver BurnDrvMDg_mk3a = {
	"g_mk3a", "g_mk3", NULL, "1900",
	"Mortal Kombat 3 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_VSFIGHT, 0,
	NULL, g_mk3aRomInfo, g_mk3aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mortal Kombat II (World)
static struct BurnRomInfo g_mk2RomDesc[] = {
	{ "mortal kombat ii (world).md", 0x300000, 0xa9e013d8, BRF_PRG },
};

STD_ROM_PICK(g_mk2)
STD_ROM_FN(g_mk2)

struct BurnDriver BurnDrvMDg_mk2 = {
	"g_mk2", NULL, NULL, "1994",
	"Mortal Kombat II (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mk2RomInfo, g_mk2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mr. Nutz (Europe)
static struct BurnRomInfo g_mrnutzRomDesc[] = {
	{ "mr. nutz (europe).md", 0x100000, 0x0786ea0b, BRF_PRG },
};

STD_ROM_PICK(g_mrnutz)
STD_ROM_FN(g_mrnutz)

struct BurnDriverD BurnDrvMDg_mrnutz = {
	"g_mrnutz", NULL, NULL, "1900",
	"Mr. Nutz (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mrnutzRomInfo, g_mrnutzRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ms. Pac-Man (USA, Europe)
static struct BurnRomInfo g_mspacmRomDesc[] = {
	{ "ms. pac-man (usa, europe).md", 0x20000, 0xaf041be6, BRF_PRG },
};

STD_ROM_PICK(g_mspacm)
STD_ROM_FN(g_mspacm)

struct BurnDriverD BurnDrvMDg_mspacm = {
	"g_mspacm", NULL, NULL, "1900",
	"Ms. Pac-Man (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mspacmRomInfo, g_mspacmRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ms. Pac-Man (U) [p1][!]
static struct BurnRomInfo g_mspac1RomDesc[] = {
	{ "ms. pac-man (u) [p1][!].md", 0x20000, 0x39b51b26, BRF_PRG },
};

STD_ROM_PICK(g_mspac1)
STD_ROM_FN(g_mspac1)

struct BurnDriverD BurnDrvMDg_mspac1 = {
	"g_mspac1", "g_mspacm", NULL, "",
	"Ms. Pac-Man (U) [p1][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mspac1RomInfo, g_mspac1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mugen Senshi Valis (Japan)
static struct BurnRomInfo g_mugensRomDesc[] = {
	{ "mugen senshi valis (japan).md", 0x100000, 0x24431625, BRF_PRG },
};

STD_ROM_PICK(g_mugens)
STD_ROM_FN(g_mugens)

struct BurnDriverD BurnDrvMDg_mugens = {
	"g_mugens", "g_valisu", NULL, "1900",
	"Mugen Senshi Valis (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mugensRomInfo, g_mugensRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Muhammad Ali Heavyweight Boxing (Europe)
static struct BurnRomInfo g_muhammRomDesc[] = {
	{ "muhammad ali heavyweight boxing (europe).md", 0x100000, 0x8ea4717b, BRF_PRG },
};

STD_ROM_PICK(g_muhamm)
STD_ROM_FN(g_muhamm)

struct BurnDriverD BurnDrvMDg_muhamm = {
	"g_muhamm", NULL, NULL, "1900",
	"Muhammad Ali Heavyweight Boxing (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_muhammRomInfo, g_muhammRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Muhammad Ali Heavyweight Boxing (USA) (Beta)
static struct BurnRomInfo g_muham1RomDesc[] = {
	{ "muhammad ali heavyweight boxing (usa) (beta).md", 0x100000, 0x7b852653, BRF_PRG },
};

STD_ROM_PICK(g_muham1)
STD_ROM_FN(g_muham1)

struct BurnDriverD BurnDrvMDg_muham1 = {
	"g_muham1", "g_muhamm", NULL, "1900",
	"Muhammad Ali Heavyweight Boxing (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_muham1RomInfo, g_muham1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Muhammad Ali Heavyweight Boxing (USA)
static struct BurnRomInfo g_muham2RomDesc[] = {
	{ "muhammad ali heavyweight boxing (usa).md", 0x100000, 0xb638b6a3, BRF_PRG },
};

STD_ROM_PICK(g_muham2)
STD_ROM_FN(g_muham2)

struct BurnDriverD BurnDrvMDg_muham2 = {
	"g_muham2", "g_muhamm", NULL, "1900",
	"Muhammad Ali Heavyweight Boxing (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_muham2RomInfo, g_muham2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// MUSHA - Metallic Uniframe Super Hybrid Armor (USA)
static struct BurnRomInfo g_mushamRomDesc[] = {
	{ "musha - metallic uniframe super hybrid armor (usa).md", 0x80000, 0x58a7f7b4, BRF_PRG },
};

STD_ROM_PICK(g_musham)
STD_ROM_FN(g_musham)

struct BurnDriverD BurnDrvMDg_musham = {
	"g_musham", NULL, NULL, "1900",
	"MUSHA - Metallic Uniframe Super Hybrid Armor (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mushamRomInfo, g_mushamRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Musha Aleste - Full Metal Fighter Ellinor (Japan)
static struct BurnRomInfo g_mushaaRomDesc[] = {
	{ "musha aleste - full metal fighter ellinor (japan).md", 0x80000, 0x8fde18ab, BRF_PRG },
};

STD_ROM_PICK(g_mushaa)
STD_ROM_FN(g_mushaa)

struct BurnDriverD BurnDrvMDg_mushaa = {
	"g_mushaa", "g_musham", NULL, "1900",
	"Musha Aleste - Full Metal Fighter Ellinor (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mushaaRomInfo, g_mushaaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mutant League Football (Japan)
static struct BurnRomInfo g_mutantRomDesc[] = {
	{ "mutant league football (japan).md", 0x100000, 0x2a97e6af, BRF_PRG },
};

STD_ROM_PICK(g_mutant)
STD_ROM_FN(g_mutant)

struct BurnDriverD BurnDrvMDg_mutant = {
	"g_mutant", NULL, NULL, "1900",
	"Mutant League Football (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mutantRomInfo, g_mutantRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mutant League Football (USA, Europe)
static struct BurnRomInfo g_mutan1RomDesc[] = {
	{ "mutant league football (usa, europe).md", 0x100000, 0xdce29c9d, BRF_PRG },
};

STD_ROM_PICK(g_mutan1)
STD_ROM_FN(g_mutan1)

struct BurnDriverD BurnDrvMDg_mutan1 = {
	"g_mutan1", "g_mutant", NULL, "1900",
	"Mutant League Football (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mutan1RomInfo, g_mutan1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mutant League Hockey (USA, Europe)
static struct BurnRomInfo g_mlhockRomDesc[] = {
	{ "mutant league hockey (usa, europe).md", 0x200000, 0x3529180f, BRF_PRG },
};

STD_ROM_PICK(g_mlhock)
STD_ROM_FN(g_mlhock)

struct BurnDriverD BurnDrvMDg_mlhock = {
	"g_mlhock", NULL, NULL, "1900",
	"Mutant League Hockey (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mlhockRomInfo, g_mlhockRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mystic Defender (USA, Europe) (Rev A)
static struct BurnRomInfo g_mysticRomDesc[] = {
	{ "mystic defender (usa, europe) (rev a).md", 0x80000, 0x50fd5d93, BRF_PRG },
};

STD_ROM_PICK(g_mystic)
STD_ROM_FN(g_mystic)

struct BurnDriverD BurnDrvMDg_mystic = {
	"g_mystic", NULL, NULL, "1900",
	"Mystic Defender (USA, Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mysticRomInfo, g_mysticRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mystic Defender (USA, Europe)
static struct BurnRomInfo g_mysti1RomDesc[] = {
	{ "mystic defender (usa, europe).md", 0x80000, 0xf9ce1ab8, BRF_PRG },
};

STD_ROM_PICK(g_mysti1)
STD_ROM_FN(g_mysti1)

struct BurnDriverD BurnDrvMDg_mysti1 = {
	"g_mysti1", "g_mystic", NULL, "1900",
	"Mystic Defender (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mysti1RomInfo, g_mysti1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Mystical Fighter (USA)
static struct BurnRomInfo g_mysti2RomDesc[] = {
	{ "mystical fighter (usa).md", 0x80000, 0xb2f2a69b, BRF_PRG },
};

STD_ROM_PICK(g_mysti2)
STD_ROM_FN(g_mysti2)

struct BurnDriverD BurnDrvMDg_mysti2 = {
	"g_mysti2", NULL, NULL, "1900",
	"Mystical Fighter (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_mysti2RomInfo, g_mysti2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nakajima Satoru Kanshuu F1 Grand Prix (Japan)
static struct BurnRomInfo g_nakajiRomDesc[] = {
	{ "nakajima satoru kanshuu f1 grand prix (japan).md", 0x100000, 0x93be47cf, BRF_PRG },
};

STD_ROM_PICK(g_nakaji)
STD_ROM_FN(g_nakaji)

struct BurnDriverD BurnDrvMDg_nakaji = {
	"g_nakaji", NULL, NULL, "1900",
	"Nakajima Satoru Kanshuu F1 Grand Prix (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nakajiRomInfo, g_nakajiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nakajima Satoru Kanshuu F1 Hero MD (Japan)
static struct BurnRomInfo g_nakaj1RomDesc[] = {
	{ "nakajima satoru kanshuu f1 hero md (japan).md", 0x100000, 0x24f87987, BRF_PRG },
};

STD_ROM_PICK(g_nakaj1)
STD_ROM_FN(g_nakaj1)

struct BurnDriverD BurnDrvMDg_nakaj1 = {
	"g_nakaj1", NULL, NULL, "1900",
	"Nakajima Satoru Kanshuu F1 Hero MD (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nakaj1RomInfo, g_nakaj1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nakajima Satoru Kanshuu F1 Super License (Japan)
static struct BurnRomInfo g_nakaj2RomDesc[] = {
	{ "nakajima satoru kanshuu f1 super license (japan).md", 0x100000, 0x8774bc79, BRF_PRG },
};

STD_ROM_PICK(g_nakaj2)
STD_ROM_FN(g_nakaj2)

struct BurnDriver BurnDrvMDg_nakaj2 = {
	"g_nakaj2", NULL, NULL, "1900",
	"Nakajima Satoru Kanshuu F1 Super License (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nakaj2RomInfo, g_nakaj2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Naomichi Ozaki no Super Masters (Japan)
static struct BurnRomInfo g_naomicRomDesc[] = {
	{ "naomichi ozaki no super masters (japan).md", 0x80000, 0x088ba825, BRF_PRG },
};

STD_ROM_PICK(g_naomic)
STD_ROM_FN(g_naomic)

struct BurnDriverD BurnDrvMDg_naomic = {
	"g_naomic", NULL, NULL, "1900",
	"Naomichi Ozaki no Super Masters (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naomicRomInfo, g_naomicRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action (USA)
static struct BurnRomInfo g_nbaaRomDesc[] = {
	{ "nba action (usa).md", 0x200000, 0x99c348ba, BRF_PRG },
};

STD_ROM_PICK(g_nbaa)
STD_ROM_FN(g_nbaa)

struct BurnDriver BurnDrvMDg_nbaa = {
	"g_nbaa", NULL, NULL, "1994",
	"NBA Action (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbaaRomInfo, g_nbaaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Dec 02, 1994 - B)
static struct BurnRomInfo g_naa95aRomDesc[] = {
	{ "nba action '95 (prototype - dec 02, 1994 - b).md", 0x200000, 0x04bf6f6e, BRF_PRG },
};

STD_ROM_PICK(g_naa95a)
STD_ROM_FN(g_naa95a)

struct BurnDriverD BurnDrvMDg_naa95a = {
	"g_naa95a", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Dec 02, 1994 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95aRomInfo, g_naa95aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Dec 09, 1994)
static struct BurnRomInfo g_naa95bRomDesc[] = {
	{ "nba action '95 (prototype - dec 09, 1994).md", 0x200000, 0x2b198487, BRF_PRG },
};

STD_ROM_PICK(g_naa95b)
STD_ROM_FN(g_naa95b)

struct BurnDriverD BurnDrvMDg_naa95b = {
	"g_naa95b", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Dec 09, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95bRomInfo, g_naa95bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Dec 15, 1994)
static struct BurnRomInfo g_naa95cRomDesc[] = {
	{ "nba action '95 (prototype - dec 15, 1994).md", 0x200000, 0x10a3b46d, BRF_PRG },
};

STD_ROM_PICK(g_naa95c)
STD_ROM_FN(g_naa95c)

struct BurnDriverD BurnDrvMDg_naa95c = {
	"g_naa95c", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Dec 15, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95cRomInfo, g_naa95cRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Dec 22, 1994 - A)
static struct BurnRomInfo g_naa95dRomDesc[] = {
	{ "nba action '95 (prototype - dec 22, 1994 - a).md", 0x200000, 0xf92ba323, BRF_PRG },
};

STD_ROM_PICK(g_naa95d)
STD_ROM_FN(g_naa95d)

struct BurnDriverD BurnDrvMDg_naa95d = {
	"g_naa95d", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Dec 22, 1994 - A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95dRomInfo, g_naa95dRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Dec 24, 1994 - A)
static struct BurnRomInfo g_naa95eRomDesc[] = {
	{ "nba action '95 (prototype - dec 24, 1994 - a).md", 0x200000, 0xddb04550, BRF_PRG },
};

STD_ROM_PICK(g_naa95e)
STD_ROM_FN(g_naa95e)

struct BurnDriverD BurnDrvMDg_naa95e = {
	"g_naa95e", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Dec 24, 1994 - A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95eRomInfo, g_naa95eRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Dec 29, 1994)
static struct BurnRomInfo g_naa95fRomDesc[] = {
	{ "nba action '95 (prototype - dec 29, 1994).md", 0x200000, 0xdcebe32a, BRF_PRG },
};

STD_ROM_PICK(g_naa95f)
STD_ROM_FN(g_naa95f)

struct BurnDriverD BurnDrvMDg_naa95f = {
	"g_naa95f", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Dec 29, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95fRomInfo, g_naa95fRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Dec 30, 1994)
static struct BurnRomInfo g_naa95gRomDesc[] = {
	{ "nba action '95 (prototype - dec 30, 1994).md", 0x200000, 0xd87956c9, BRF_PRG },
};

STD_ROM_PICK(g_naa95g)
STD_ROM_FN(g_naa95g)

struct BurnDriverD BurnDrvMDg_naa95g = {
	"g_naa95g", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Dec 30, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95gRomInfo, g_naa95gRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Dec 31, 1994)
static struct BurnRomInfo g_naa95hRomDesc[] = {
	{ "nba action '95 (prototype - dec 31, 1994).md", 0x200000, 0x582a378f, BRF_PRG },
};

STD_ROM_PICK(g_naa95h)
STD_ROM_FN(g_naa95h)

struct BurnDriverD BurnDrvMDg_naa95h = {
	"g_naa95h", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Dec 31, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95hRomInfo, g_naa95hRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Feb 01, 1995)
static struct BurnRomInfo g_naa95iRomDesc[] = {
	{ "nba action '95 (prototype - feb 01, 1995).md", 0x200000, 0x2c02a79d, BRF_PRG },
};

STD_ROM_PICK(g_naa95i)
STD_ROM_FN(g_naa95i)

struct BurnDriverD BurnDrvMDg_naa95i = {
	"g_naa95i", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Feb 01, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95iRomInfo, g_naa95iRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Feb 1, 1995)
static struct BurnRomInfo g_naa95jRomDesc[] = {
	{ "nba action '95 (prototype - feb 1, 1995).md", 0x1ff49e, 0xc4a0a624, BRF_PRG },
};

STD_ROM_PICK(g_naa95j)
STD_ROM_FN(g_naa95j)

struct BurnDriverD BurnDrvMDg_naa95j = {
	"g_naa95j", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Feb 1, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95jRomInfo, g_naa95jRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Feb 2, 1995)
static struct BurnRomInfo g_naa95kRomDesc[] = {
	{ "nba action '95 (prototype - feb 2, 1995).md", 0x1fe1f0, 0xa9167903, BRF_PRG },
};

STD_ROM_PICK(g_naa95k)
STD_ROM_FN(g_naa95k)

struct BurnDriverD BurnDrvMDg_naa95k = {
	"g_naa95k", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Feb 2, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95kRomInfo, g_naa95kRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 03, 1995)
static struct BurnRomInfo g_naa95lRomDesc[] = {
	{ "nba action '95 (prototype - jan 03, 1995).md", 0x200000, 0x374af160, BRF_PRG },
};

STD_ROM_PICK(g_naa95l)
STD_ROM_FN(g_naa95l)

struct BurnDriverD BurnDrvMDg_naa95l = {
	"g_naa95l", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 03, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95lRomInfo, g_naa95lRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 08, 1995)
static struct BurnRomInfo g_naa95mRomDesc[] = {
	{ "nba action '95 (prototype - jan 08, 1995).md", 0x200000, 0x0a6b7b9e, BRF_PRG },
};

STD_ROM_PICK(g_naa95m)
STD_ROM_FN(g_naa95m)

struct BurnDriverD BurnDrvMDg_naa95m = {
	"g_naa95m", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 08, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95mRomInfo, g_naa95mRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 12, 1995)
static struct BurnRomInfo g_naa95nRomDesc[] = {
	{ "nba action '95 (prototype - jan 12, 1995).md", 0x200000, 0xb47ff025, BRF_PRG },
};

STD_ROM_PICK(g_naa95n)
STD_ROM_FN(g_naa95n)

struct BurnDriverD BurnDrvMDg_naa95n = {
	"g_naa95n", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 12, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95nRomInfo, g_naa95nRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 15, 1995 - A)
static struct BurnRomInfo g_naa95oRomDesc[] = {
	{ "nba action '95 (prototype - jan 15, 1995 - a).md", 0x200000, 0x9c6a1f27, BRF_PRG },
};

STD_ROM_PICK(g_naa95o)
STD_ROM_FN(g_naa95o)

struct BurnDriverD BurnDrvMDg_naa95o = {
	"g_naa95o", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 15, 1995 - A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95oRomInfo, g_naa95oRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 21, 1995)
static struct BurnRomInfo g_naa95pRomDesc[] = {
	{ "nba action '95 (prototype - jan 21, 1995).md", 0x200000, 0xe337bdfb, BRF_PRG },
};

STD_ROM_PICK(g_naa95p)
STD_ROM_FN(g_naa95p)

struct BurnDriverD BurnDrvMDg_naa95p = {
	"g_naa95p", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 21, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95pRomInfo, g_naa95pRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 22, 1995 - B)
static struct BurnRomInfo g_naa95qRomDesc[] = {
	{ "nba action '95 (prototype - jan 22, 1995 - b).md", 0x200000, 0x7bd7ca47, BRF_PRG },
};

STD_ROM_PICK(g_naa95q)
STD_ROM_FN(g_naa95q)

struct BurnDriverD BurnDrvMDg_naa95q = {
	"g_naa95q", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 22, 1995 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95qRomInfo, g_naa95qRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 24, 1995 - B)
static struct BurnRomInfo g_naa95rRomDesc[] = {
	{ "nba action '95 (prototype - jan 24, 1995 - b).md", 0x200000, 0x15abcf41, BRF_PRG },
};

STD_ROM_PICK(g_naa95r)
STD_ROM_FN(g_naa95r)

struct BurnDriverD BurnDrvMDg_naa95r = {
	"g_naa95r", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 24, 1995 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95rRomInfo, g_naa95rRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 27, 1995 - A)
static struct BurnRomInfo g_naa95sRomDesc[] = {
	{ "nba action '95 (prototype - jan 27, 1995 - a).md", 0x1fe190, 0x79c7fb00, BRF_PRG },
};

STD_ROM_PICK(g_naa95s)
STD_ROM_FN(g_naa95s)

struct BurnDriverD BurnDrvMDg_naa95s = {
	"g_naa95s", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 27, 1995 - A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95sRomInfo, g_naa95sRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 27, 1995 - B)
static struct BurnRomInfo g_naa95tRomDesc[] = {
	{ "nba action '95 (prototype - jan 27, 1995 - b).md", 0x1fe190, 0xef7f608b, BRF_PRG },
};

STD_ROM_PICK(g_naa95t)
STD_ROM_FN(g_naa95t)

struct BurnDriverD BurnDrvMDg_naa95t = {
	"g_naa95t", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 27, 1995 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95tRomInfo, g_naa95tRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 28, 1995 - A)
static struct BurnRomInfo g_naa95uRomDesc[] = {
	{ "nba action '95 (prototype - jan 28, 1995 - a).md", 0x200000, 0x57c2c69c, BRF_PRG },
};

STD_ROM_PICK(g_naa95u)
STD_ROM_FN(g_naa95u)

struct BurnDriverD BurnDrvMDg_naa95u = {
	"g_naa95u", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 28, 1995 - A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95uRomInfo, g_naa95uRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 28, 1995)
static struct BurnRomInfo g_naa95vRomDesc[] = {
	{ "nba action '95 (prototype - jan 28, 1995).md", 0x1fe19e, 0x97d7075d, BRF_PRG },
};

STD_ROM_PICK(g_naa95v)
STD_ROM_FN(g_naa95v)

struct BurnDriverD BurnDrvMDg_naa95v = {
	"g_naa95v", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 28, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95vRomInfo, g_naa95vRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Jan 30, 1995)
static struct BurnRomInfo g_naa95wRomDesc[] = {
	{ "nba action '95 (prototype - jan 30, 1995).md", 0x200000, 0x2fac80b2, BRF_PRG },
};

STD_ROM_PICK(g_naa95w)
STD_ROM_FN(g_naa95w)

struct BurnDriverD BurnDrvMDg_naa95w = {
	"g_naa95w", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Jan 30, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95wRomInfo, g_naa95wRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Nov 18, 1994)
static struct BurnRomInfo g_naa95xRomDesc[] = {
	{ "nba action '95 (prototype - nov 18, 1994).md", 0x200000, 0x2d411e4b, BRF_PRG },
};

STD_ROM_PICK(g_naa95x)
STD_ROM_FN(g_naa95x)

struct BurnDriverD BurnDrvMDg_naa95x = {
	"g_naa95x", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Nov 18, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95xRomInfo, g_naa95xRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 (Prototype - Nov 23, 1994 - A)
static struct BurnRomInfo g_naa95yRomDesc[] = {
	{ "nba action '95 (prototype - nov 23, 1994 - a).md", 0x200000, 0x4650cfcc, BRF_PRG },
};

STD_ROM_PICK(g_naa95y)
STD_ROM_FN(g_naa95y)

struct BurnDriverD BurnDrvMDg_naa95y = {
	"g_naa95y", "g_naa95", NULL, "",
	"NBA Action '95 (Prototype - Nov 23, 1994 - A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95yRomInfo, g_naa95yRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action '95 Starring David Robinson (USA, Europe)
static struct BurnRomInfo g_naa95RomDesc[] = {
	{ "nba action '95 starring david robinson (usa, europe).md", 0x200000, 0xaa7006d6, BRF_PRG },
};

STD_ROM_PICK(g_naa95)
STD_ROM_FN(g_naa95)

struct BurnDriver BurnDrvMDg_naa95 = {
	"g_naa95", NULL, NULL, "1900",
	"NBA Action '95 Starring David Robinson (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_naa95RomInfo, g_naa95RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action (Prototype - Jan 04, 1994)
static struct BurnRomInfo g_nbaap1RomDesc[] = {
	{ "nba action (prototype - jan 04, 1994).md", 0x200000, 0x2491df2f, BRF_PRG },
};

STD_ROM_PICK(g_nbaap1)
STD_ROM_FN(g_nbaap1)

struct BurnDriverD BurnDrvMDg_nbaap1 = {
	"g_nbaap1", "g_nbaa", NULL, "",
	"NBA Action (Prototype - Jan 04, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbaap1RomInfo, g_nbaap1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action (Prototype - Jan 16, 1994)
static struct BurnRomInfo g_nbaap2RomDesc[] = {
	{ "nba action (prototype - jan 16, 1994).md", 0x200000, 0xfe43c79d, BRF_PRG },
};

STD_ROM_PICK(g_nbaap2)
STD_ROM_FN(g_nbaap2)

struct BurnDriverD BurnDrvMDg_nbaap2 = {
	"g_nbaap2", "g_nbaa", NULL, "",
	"NBA Action (Prototype - Jan 16, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbaap2RomInfo, g_nbaap2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Action (Prototype - Jan 27, 1994) (broken - C08 missing)
static struct BurnRomInfo g_nbaap3RomDesc[] = {
	{ "nba action (prototype - jan 27, 1994) (broken - c08 missing).md", 0x200000, 0x176a4bc5, BRF_PRG },
};

STD_ROM_PICK(g_nbaap3)
STD_ROM_FN(g_nbaap3)

struct BurnDriverD BurnDrvMDg_nbaap3 = {
	"g_nbaap3", "g_nbaa", NULL, "",
	"NBA Action (Prototype - Jan 27, 1994) (broken - C08 missing)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbaap3RomInfo, g_nbaap3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA All-Star Challenge (USA, Europe)
static struct BurnRomInfo g_nbaallRomDesc[] = {
	{ "nba all-star challenge (usa, europe).md", 0x100000, 0xc4674adf, BRF_PRG },
};

STD_ROM_PICK(g_nbaall)
STD_ROM_FN(g_nbaall)

struct BurnDriverD BurnDrvMDg_nbaall = {
	"g_nbaall", NULL, NULL, "1900",
	"NBA All-Star Challenge (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbaallRomInfo, g_nbaallRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Hang Time (Europe)
static struct BurnRomInfo g_nbahanRomDesc[] = {
	{ "nba hang time (europe).md", 0x300000, 0xedb4d4aa, BRF_PRG },
};

STD_ROM_PICK(g_nbahan)
STD_ROM_FN(g_nbahan)

struct BurnDriverD BurnDrvMDg_nbahan = {
	"g_nbahan", NULL, NULL, "1900",
	"NBA Hang Time (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbahanRomInfo, g_nbahanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Hang Time (USA)
static struct BurnRomInfo g_nbaha1RomDesc[] = {
	{ "nba hang time (usa).md", 0x300000, 0x176b0338, BRF_PRG },
};

STD_ROM_PICK(g_nbaha1)
STD_ROM_FN(g_nbaha1)

struct BurnDriverD BurnDrvMDg_nbaha1 = {
	"g_nbaha1", "g_nbahan", NULL, "1900",
	"NBA Hang Time (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbaha1RomInfo, g_nbaha1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Jam (Japan)
static struct BurnRomInfo g_nbajjRomDesc[] = {
	{ "nba jam (japan).md", 0x200000, 0xa6c6305a, BRF_PRG },
};

STD_ROM_PICK(g_nbajj)
STD_ROM_FN(g_nbajj)

struct BurnDriverD BurnDrvMDg_nbajj = {
	"g_nbajj", "g_nbaj", NULL, "1900",
	"NBA Jam (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbajjRomInfo, g_nbajjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Jam (USA, Europe) (v1.1)
static struct BurnRomInfo g_nbajRomDesc[] = {
	{ "nba jam (usa, europe) (v1.1).md", 0x200000, 0xeb8360e6, BRF_PRG },
};

STD_ROM_PICK(g_nbaj)
STD_ROM_FN(g_nbaj)

struct BurnDriverD BurnDrvMDg_nbaj = {
	"g_nbaj", NULL, NULL, "1900",
	"NBA Jam (USA, Europe) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbajRomInfo, g_nbajRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Jam (USA, Europe)
static struct BurnRomInfo g_nbajaRomDesc[] = {
	{ "nba jam (usa, europe).md", 0x200000, 0x10fa248f, BRF_PRG },
};

STD_ROM_PICK(g_nbaja)
STD_ROM_FN(g_nbaja)

struct BurnDriverD BurnDrvMDg_nbaja = {
	"g_nbaja", "g_nbaj", NULL, "1900",
	"NBA Jam (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbajaRomInfo, g_nbajaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Jam Tournament Edition (W) (REV01) [!]
static struct BurnRomInfo g_nbajtRomDesc[] = {
	{ "nba jam tournament edition (w) (rev01) [!].md", 0x300000, 0x6e25ebf0, BRF_PRG },
};

STD_ROM_PICK(g_nbajt)
STD_ROM_FN(g_nbajt)

struct BurnDriverD BurnDrvMDg_nbajt = {
	"g_nbajt", NULL, NULL, "1900",
	"NBA Jam Tournament Edition (W) (REV01) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbajtRomInfo, g_nbajtRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Jam Tournament Edition (World)
static struct BurnRomInfo g_nbajtaRomDesc[] = {
	{ "nba jam tournament edition (world).md", 0x300000, 0xe9ffcb37, BRF_PRG },
};

STD_ROM_PICK(g_nbajta)
STD_ROM_FN(g_nbajta)

struct BurnDriverD BurnDrvMDg_nbajta = {
	"g_nbajta", "g_nbajt", NULL, "1900",
	"NBA Jam Tournament Edition (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbajtaRomInfo, g_nbajtaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Live 95 (Korea)
static struct BurnRomInfo g_nbl95kRomDesc[] = {
	{ "nba live 95 (korea).md", 0x200000, 0x779c1244, BRF_PRG },
};

STD_ROM_PICK(g_nbl95k)
STD_ROM_FN(g_nbl95k)

struct BurnDriverD BurnDrvMDg_nbl95k = {
	"g_nbl95k", "g_nbl95", NULL, "",
	"NBA Live 95 (Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbl95kRomInfo, g_nbl95kRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Live 95 (USA, Europe)
static struct BurnRomInfo g_nbl95RomDesc[] = {
	{ "nba live 95 (usa, europe).md", 0x200000, 0x66018abc, BRF_PRG },
};

STD_ROM_PICK(g_nbl95)
STD_ROM_FN(g_nbl95)

struct BurnDriver BurnDrvMDg_nbl95 = {
	"g_nbl95", NULL, NULL, "1900",
	"NBA Live 95 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbl95RomInfo, g_nbl95RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Live 96 (USA, Europe)
static struct BurnRomInfo g_nbal96RomDesc[] = {
	{ "nba live 96 (usa, europe).md", 0x200000, 0x49de0062, BRF_PRG },
};

STD_ROM_PICK(g_nbal96)
STD_ROM_FN(g_nbal96)

struct BurnDriver BurnDrvMDg_nbal96 = {
	"g_nbal96", NULL, NULL, "1900",
	"NBA Live 96 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbal96RomInfo, g_nbal96RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Live 97 (USA, Europe)
static struct BurnRomInfo g_nbal97RomDesc[] = {
	{ "nba live 97 (usa, europe).md", 0x200000, 0x7024843a, BRF_PRG },
};

STD_ROM_PICK(g_nbal97)
STD_ROM_FN(g_nbal97)

struct BurnDriver BurnDrvMDg_nbal97 = {
	"g_nbal97", NULL, NULL, "1900",
	"NBA Live 97 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbal97RomInfo, g_nbal97RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Live 98 (USA)
static struct BurnRomInfo g_nbal98RomDesc[] = {
	{ "nba live 98 (usa).md", 0x200000, 0x23473a8a, BRF_PRG },
};

STD_ROM_PICK(g_nbal98)
STD_ROM_FN(g_nbal98)

struct BurnDriver BurnDrvMDg_nbal98 = {
	"g_nbal98", NULL, NULL, "1900",
	"NBA Live 98 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbal98RomInfo, g_nbal98RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Playoff - Bulls vs Blazers (J) [!]
static struct BurnRomInfo g_nbaplaRomDesc[] = {
	{ "nba playoff - bulls vs blazers (j) [!].md", 0x100000, 0x4565ce1f, BRF_PRG },
};

STD_ROM_PICK(g_nbapla)
STD_ROM_FN(g_nbapla)

struct BurnDriverD BurnDrvMDg_nbapla = {
	"g_nbapla", NULL, NULL, "1993",
	"NBA Playoff - Bulls vs Blazers (J) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbaplaRomInfo, g_nbaplaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Playoffs - Bulls Vs Blazers (Japan)
static struct BurnRomInfo g_nbapl1RomDesc[] = {
	{ "nba playoffs - bulls vs blazers (japan).md", 0x100000, 0xeae8c000, BRF_PRG },
};

STD_ROM_PICK(g_nbapl1)
STD_ROM_FN(g_nbapl1)

struct BurnDriverD BurnDrvMDg_nbapl1 = {
	"g_nbapl1", "g_nbapla", NULL, "",
	"NBA Playoffs - Bulls Vs Blazers (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbapl1RomInfo, g_nbapl1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Pro Basketball '94 (Japan)
static struct BurnRomInfo g_nbaproRomDesc[] = {
	{ "nba pro basketball '94 (japan).md", 0x200000, 0xeea19bce, BRF_PRG },
};

STD_ROM_PICK(g_nbapro)
STD_ROM_FN(g_nbapro)

struct BurnDriver BurnDrvMDg_nbapro = {
	"g_nbapro", NULL, NULL, "1900",
	"NBA Pro Basketball '94 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbaproRomInfo, g_nbaproRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Pro Basketball - Bulls Vs Lakers (Japan)
static struct BurnRomInfo g_nbapr1RomDesc[] = {
	{ "nba pro basketball - bulls vs lakers (japan).md", 0x100000, 0x4416ce39, BRF_PRG },
};

STD_ROM_PICK(g_nbapr1)
STD_ROM_FN(g_nbapr1)

struct BurnDriverD BurnDrvMDg_nbapr1 = {
	"g_nbapr1", "g_nbapro", NULL, "1993",
	"NBA Pro Basketball - Bulls Vs Lakers (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbapr1RomInfo, g_nbapr1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Showdown '94 (USA) (Beta)
static struct BurnRomInfo g_nbashbRomDesc[] = {
	{ "nba showdown '94 (usa) (beta).md", 0x200000, 0x6643a308, BRF_PRG },
};

STD_ROM_PICK(g_nbashb)
STD_ROM_FN(g_nbashb)

struct BurnDriver BurnDrvMDg_nbashb = {
	"g_nbashb", "g_nbash", NULL, "1900",
	"NBA Showdown '94 (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbashbRomInfo, g_nbashbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NBA Showdown '94 (USA, Europe)
static struct BurnRomInfo g_nbashRomDesc[] = {
	{ "nba showdown '94 (usa, europe).md", 0x200000, 0x160b7090, BRF_PRG },
};

STD_ROM_PICK(g_nbash)
STD_ROM_FN(g_nbash)

struct BurnDriver BurnDrvMDg_nbash = {
	"g_nbash", NULL, NULL, "1900",
	"NBA Showdown '94 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nbashRomInfo, g_nbashRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NCAA Final Four Basketball (USA)
static struct BurnRomInfo g_ncaafiRomDesc[] = {
	{ "ncaa final four basketball (usa).md", 0x180000, 0xed0c1303, BRF_PRG },
};

STD_ROM_PICK(g_ncaafi)
STD_ROM_FN(g_ncaafi)

struct BurnDriver BurnDrvMDg_ncaafi = {
	"g_ncaafi", NULL, NULL, "1900",
	"NCAA Final Four Basketball (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ncaafiRomInfo, g_ncaafiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NCAA Football (USA)
static struct BurnRomInfo g_ncaafoRomDesc[] = {
	{ "ncaa football (usa).md", 0x100000, 0x081012f0, BRF_PRG },
};

STD_ROM_PICK(g_ncaafo)
STD_ROM_FN(g_ncaafo)

struct BurnDriver BurnDrvMDg_ncaafo = {
	"g_ncaafo", NULL, NULL, "1900",
	"NCAA Football (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ncaafoRomInfo, g_ncaafoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nekketsu Koukou Dodgeball Bu - Soccer Hen MD (Japan)
static struct BurnRomInfo g_nekketRomDesc[] = {
	{ "nekketsu koukou dodgeball bu - soccer hen md (japan).md", 0x80000, 0xf49c3a86, BRF_PRG },
};

STD_ROM_PICK(g_nekket)
STD_ROM_FN(g_nekket)

struct BurnDriverD BurnDrvMDg_nekket = {
	"g_nekket", NULL, NULL, "1900",
	"Nekketsu Koukou Dodgeball Bu - Soccer Hen MD (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nekketRomInfo, g_nekketRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// New 3D Golf Simulation Devil's Course (Japan)
static struct BurnRomInfo g_new3dgRomDesc[] = {
	{ "new 3d golf simulation devil's course (japan).md", 0x180000, 0xbd090c67, BRF_PRG },
};

STD_ROM_PICK(g_new3dg)
STD_ROM_FN(g_new3dg)

struct BurnDriver BurnDrvMDg_new3dg = {
	"g_new3dg", NULL, NULL, "1900",
	"New 3D Golf Simulation Devil's Course (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_new3dgRomInfo, g_new3dgRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// New 3D Golf Simulation Harukanaru Augusta (Japan)
static struct BurnRomInfo g_new3d1RomDesc[] = {
	{ "new 3d golf simulation harukanaru augusta (japan).md", 0x180000, 0xd2a9bf92, BRF_PRG },
};

STD_ROM_PICK(g_new3d1)
STD_ROM_FN(g_new3d1)

struct BurnDriver BurnDrvMDg_new3d1 = {
	"g_new3d1", NULL, NULL, "1900",
	"New 3D Golf Simulation Harukanaru Augusta (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_new3d1RomInfo, g_new3d1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// New 3D Golf Simulation Pebble Beach no Hatou (Japan)
static struct BurnRomInfo g_new3d2RomDesc[] = {
	{ "new 3d golf simulation pebble beach no hatou (japan).md", 0x180000, 0x96ed2e5d, BRF_PRG },
};

STD_ROM_PICK(g_new3d2)
STD_ROM_FN(g_new3d2)

struct BurnDriver BurnDrvMDg_new3d2 = {
	"g_new3d2", NULL, NULL, "1900",
	"New 3D Golf Simulation Pebble Beach no Hatou (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_new3d2RomInfo, g_new3d2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// New 3D Golf Simulation Waialae no Kiseki (Japan)
static struct BurnRomInfo g_new3d3RomDesc[] = {
	{ "new 3d golf simulation waialae no kiseki (japan).md", 0x180000, 0xcbe2c1f6, BRF_PRG },
};

STD_ROM_PICK(g_new3d3)
STD_ROM_FN(g_new3d3)

struct BurnDriver BurnDrvMDg_new3d3 = {
	"g_new3d3", NULL, NULL, "1900",
	"New 3D Golf Simulation Waialae no Kiseki (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_new3d3RomInfo, g_new3d3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// New Zealand Story, The (Japan)
static struct BurnRomInfo g_newzeaRomDesc[] = {
	{ "new zealand story, the (japan).md", 0x80000, 0x1c77ad21, BRF_PRG },
};

STD_ROM_PICK(g_newzea)
STD_ROM_FN(g_newzea)

struct BurnDriverD BurnDrvMDg_newzea = {
	"g_newzea", NULL, NULL, "1900",
	"New Zealand Story, The (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_newzeaRomInfo, g_newzeaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Newman Haas Indy Car Featuring Nigel Mansell (World)
static struct BurnRomInfo g_newmanRomDesc[] = {
	{ "newman haas indy car featuring nigel mansell (world).md", 0x200000, 0x1233a229, BRF_PRG },
};

STD_ROM_PICK(g_newman)
STD_ROM_FN(g_newman)

struct BurnDriverD BurnDrvMDg_newman = {
	"g_newman", NULL, NULL, "1900",
	"Newman Haas Indy Car Featuring Nigel Mansell (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_newmanRomInfo, g_newmanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Aug 01, 1994)
static struct BurnRomInfo g_nfl95aRomDesc[] = {
	{ "nfl '95 (prototype - aug 01, 1994).md", 0x200000, 0x5a57ea4e, BRF_PRG },
};

STD_ROM_PICK(g_nfl95a)
STD_ROM_FN(g_nfl95a)

struct BurnDriverD BurnDrvMDg_nfl95a = {
	"g_nfl95a", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Aug 01, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95aRomInfo, g_nfl95aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Aug 05, 1994)
static struct BurnRomInfo g_nfl95bRomDesc[] = {
	{ "nfl '95 (prototype - aug 05, 1994).md", 0x200000, 0x88d51773, BRF_PRG },
};

STD_ROM_PICK(g_nfl95b)
STD_ROM_FN(g_nfl95b)

struct BurnDriverD BurnDrvMDg_nfl95b = {
	"g_nfl95b", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Aug 05, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95bRomInfo, g_nfl95bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Aug 10, 1994)
static struct BurnRomInfo g_nfl95cRomDesc[] = {
	{ "nfl '95 (prototype - aug 10, 1994).md", 0x200000, 0xa3c5710b, BRF_PRG },
};

STD_ROM_PICK(g_nfl95c)
STD_ROM_FN(g_nfl95c)

struct BurnDriverD BurnDrvMDg_nfl95c = {
	"g_nfl95c", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Aug 10, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95cRomInfo, g_nfl95cRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Aug 12, 1994)
static struct BurnRomInfo g_nfl95dRomDesc[] = {
	{ "nfl '95 (prototype - aug 12, 1994).md", 0x200000, 0x3d23633b, BRF_PRG },
};

STD_ROM_PICK(g_nfl95d)
STD_ROM_FN(g_nfl95d)

struct BurnDriverD BurnDrvMDg_nfl95d = {
	"g_nfl95d", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Aug 12, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95dRomInfo, g_nfl95dRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Aug 12, 1994)_
static struct BurnRomInfo g_nfl95eRomDesc[] = {
	{ "nfl '95 (prototype - aug 12, 1994)_.md", 0x200000, 0xcc86a259, BRF_PRG },
};

STD_ROM_PICK(g_nfl95e)
STD_ROM_FN(g_nfl95e)

struct BurnDriverD BurnDrvMDg_nfl95e = {
	"g_nfl95e", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Aug 12, 1994)_\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95eRomInfo, g_nfl95eRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Aug 17, 1994 - B)
static struct BurnRomInfo g_nfl95fRomDesc[] = {
	{ "nfl '95 (prototype - aug 17, 1994 - b).md", 0x200000, 0xa6015c29, BRF_PRG },
};

STD_ROM_PICK(g_nfl95f)
STD_ROM_FN(g_nfl95f)

struct BurnDriverD BurnDrvMDg_nfl95f = {
	"g_nfl95f", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Aug 17, 1994 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95fRomInfo, g_nfl95fRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Aug 17, 1994)
static struct BurnRomInfo g_nfl95gRomDesc[] = {
	{ "nfl '95 (prototype - aug 17, 1994).md", 0x200000, 0x655966c8, BRF_PRG },
};

STD_ROM_PICK(g_nfl95g)
STD_ROM_FN(g_nfl95g)

struct BurnDriverD BurnDrvMDg_nfl95g = {
	"g_nfl95g", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Aug 17, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95gRomInfo, g_nfl95gRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Aug 22, 1994)
static struct BurnRomInfo g_nfl95hRomDesc[] = {
	{ "nfl '95 (prototype - aug 22, 1994).md", 0x200000, 0xb01434e5, BRF_PRG },
};

STD_ROM_PICK(g_nfl95h)
STD_ROM_FN(g_nfl95h)

struct BurnDriverD BurnDrvMDg_nfl95h = {
	"g_nfl95h", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Aug 22, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95hRomInfo, g_nfl95hRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Aug 30, 1994)
static struct BurnRomInfo g_nfl95iRomDesc[] = {
	{ "nfl '95 (prototype - aug 30, 1994).md", 0x200000, 0xd0e0a436, BRF_PRG },
};

STD_ROM_PICK(g_nfl95i)
STD_ROM_FN(g_nfl95i)

struct BurnDriverD BurnDrvMDg_nfl95i = {
	"g_nfl95i", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Aug 30, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95iRomInfo, g_nfl95iRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Aug 31, 1994)
static struct BurnRomInfo g_nfl95jRomDesc[] = {
	{ "nfl '95 (prototype - aug 31, 1994).md", 0x200000, 0xc360521e, BRF_PRG },
};

STD_ROM_PICK(g_nfl95j)
STD_ROM_FN(g_nfl95j)

struct BurnDriverD BurnDrvMDg_nfl95j = {
	"g_nfl95j", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Aug 31, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95jRomInfo, g_nfl95jRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Sep 01, 1994)
static struct BurnRomInfo g_nfl95kRomDesc[] = {
	{ "nfl '95 (prototype - sep 01, 1994).md", 0x200000, 0x9240fcaa, BRF_PRG },
};

STD_ROM_PICK(g_nfl95k)
STD_ROM_FN(g_nfl95k)

struct BurnDriverD BurnDrvMDg_nfl95k = {
	"g_nfl95k", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Sep 01, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95kRomInfo, g_nfl95kRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Sep 02, 1994)
static struct BurnRomInfo g_nfl95lRomDesc[] = {
	{ "nfl '95 (prototype - sep 02, 1994).md", 0x200000, 0xff049a49, BRF_PRG },
};

STD_ROM_PICK(g_nfl95l)
STD_ROM_FN(g_nfl95l)

struct BurnDriverD BurnDrvMDg_nfl95l = {
	"g_nfl95l", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Sep 02, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95lRomInfo, g_nfl95lRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Sep 04, 1994)
static struct BurnRomInfo g_nfl95mRomDesc[] = {
	{ "nfl '95 (prototype - sep 04, 1994).md", 0x200000, 0x60604d40, BRF_PRG },
};

STD_ROM_PICK(g_nfl95m)
STD_ROM_FN(g_nfl95m)

struct BurnDriverD BurnDrvMDg_nfl95m = {
	"g_nfl95m", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Sep 04, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95mRomInfo, g_nfl95mRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Sep 05, 1994 - B)
static struct BurnRomInfo g_nfl95nRomDesc[] = {
	{ "nfl '95 (prototype - sep 05, 1994 - b).md", 0x200000, 0x123985a5, BRF_PRG },
};

STD_ROM_PICK(g_nfl95n)
STD_ROM_FN(g_nfl95n)

struct BurnDriverD BurnDrvMDg_nfl95n = {
	"g_nfl95n", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Sep 05, 1994 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95nRomInfo, g_nfl95nRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Sep 05, 1994)
static struct BurnRomInfo g_nfl95oRomDesc[] = {
	{ "nfl '95 (prototype - sep 05, 1994).md", 0x200000, 0xdbdf61ac, BRF_PRG },
};

STD_ROM_PICK(g_nfl95o)
STD_ROM_FN(g_nfl95o)

struct BurnDriverD BurnDrvMDg_nfl95o = {
	"g_nfl95o", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Sep 05, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95oRomInfo, g_nfl95oRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Sep 06, 1994)
static struct BurnRomInfo g_nfl95pRomDesc[] = {
	{ "nfl '95 (prototype - sep 06, 1994).md", 0x200000, 0x624b8699, BRF_PRG },
};

STD_ROM_PICK(g_nfl95p)
STD_ROM_FN(g_nfl95p)

struct BurnDriverD BurnDrvMDg_nfl95p = {
	"g_nfl95p", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Sep 06, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95pRomInfo, g_nfl95pRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Sep 07, 1994)
static struct BurnRomInfo g_nfl95qRomDesc[] = {
	{ "nfl '95 (prototype - sep 07, 1994).md", 0x200000, 0xae8aa4be, BRF_PRG },
};

STD_ROM_PICK(g_nfl95q)
STD_ROM_FN(g_nfl95q)

struct BurnDriverD BurnDrvMDg_nfl95q = {
	"g_nfl95q", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Sep 07, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95qRomInfo, g_nfl95qRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Sep 08, 1994)
static struct BurnRomInfo g_nfl95rRomDesc[] = {
	{ "nfl '95 (prototype - sep 08, 1994).md", 0x200000, 0x22c5e289, BRF_PRG },
};

STD_ROM_PICK(g_nfl95r)
STD_ROM_FN(g_nfl95r)

struct BurnDriverD BurnDrvMDg_nfl95r = {
	"g_nfl95r", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Sep 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95rRomInfo, g_nfl95rRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Sep 09, 1994)
static struct BurnRomInfo g_nfl95sRomDesc[] = {
	{ "nfl '95 (prototype - sep 09, 1994).md", 0x200000, 0x55df1066, BRF_PRG },
};

STD_ROM_PICK(g_nfl95s)
STD_ROM_FN(g_nfl95s)

struct BurnDriverD BurnDrvMDg_nfl95s = {
	"g_nfl95s", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Sep 09, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95sRomInfo, g_nfl95sRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Sep 11, 1994 - B)
static struct BurnRomInfo g_nfl95tRomDesc[] = {
	{ "nfl '95 (prototype - sep 11, 1994 - b).md", 0x200000, 0x111ac6a0, BRF_PRG },
};

STD_ROM_PICK(g_nfl95t)
STD_ROM_FN(g_nfl95t)

struct BurnDriverD BurnDrvMDg_nfl95t = {
	"g_nfl95t", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Sep 11, 1994 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95tRomInfo, g_nfl95tRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (Prototype - Sep 11, 1994)
static struct BurnRomInfo g_nfl95uRomDesc[] = {
	{ "nfl '95 (prototype - sep 11, 1994).md", 0x200000, 0x21614c4f, BRF_PRG },
};

STD_ROM_PICK(g_nfl95u)
STD_ROM_FN(g_nfl95u)

struct BurnDriverD BurnDrvMDg_nfl95u = {
	"g_nfl95u", "g_nfl95", NULL, "",
	"NFL '95 (Prototype - Sep 11, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95uRomInfo, g_nfl95uRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL '95 (USA, Europe)
static struct BurnRomInfo g_nfl95RomDesc[] = {
	{ "nfl '95 (usa, europe).md", 0x200000, 0xb58e4a81, BRF_PRG },
};

STD_ROM_PICK(g_nfl95)
STD_ROM_FN(g_nfl95)

struct BurnDriver BurnDrvMDg_nfl95 = {
	"g_nfl95", NULL, NULL, "1994",
	"NFL '95 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl95RomInfo, g_nfl95RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL 98 (USA)
static struct BurnRomInfo g_nfl98RomDesc[] = {
	{ "nfl 98 (usa).md", 0x200000, 0xf73ec54c, BRF_PRG },
};

STD_ROM_PICK(g_nfl98)
STD_ROM_FN(g_nfl98)

struct BurnDriver BurnDrvMDg_nfl98 = {
	"g_nfl98", NULL, NULL, "1997",
	"NFL 98 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl98RomInfo, g_nfl98RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL Football '94 (Japan)
static struct BurnRomInfo g_nfl94jRomDesc[] = {
	{ "nfl football '94 (japan).md", 0x200000, 0xe490dc4a, BRF_PRG },
};

STD_ROM_PICK(g_nfl94j)
STD_ROM_FN(g_nfl94j)

struct BurnDriver BurnDrvMDg_nfl94j = {
	"g_nfl94j", "g_nfl94", NULL, "1900",
	"NFL Football '94 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl94jRomInfo, g_nfl94jRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL Football '94 Starring Joe Montana (USA)
static struct BurnRomInfo g_nfl94RomDesc[] = {
	{ "nfl football '94 starring joe montana (usa).md", 0x200000, 0x0d486ed5, BRF_PRG },
};

STD_ROM_PICK(g_nfl94)
STD_ROM_FN(g_nfl94)

struct BurnDriver BurnDrvMDg_nfl94 = {
	"g_nfl94", NULL, NULL, "1900",
	"NFL Football '94 Starring Joe Montana (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nfl94RomInfo, g_nfl94RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL Quarterback Club (World)
static struct BurnRomInfo g_nflquaRomDesc[] = {
	{ "nfl quarterback club (world).md", 0x300000, 0x94542eaf, BRF_PRG },
};

STD_ROM_PICK(g_nflqua)
STD_ROM_FN(g_nflqua)

struct BurnDriverD BurnDrvMDg_nflqua = {
	"g_nflqua", NULL, NULL, "1900",
	"NFL Quarterback Club (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nflquaRomInfo, g_nflquaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL Quarterback Club 96 (USA, Europe)
static struct BurnRomInfo g_nflq96RomDesc[] = {
	{ "nfl quarterback club 96 (usa, europe).md", 0x400000, 0xd5a37cab, BRF_PRG },
};

STD_ROM_PICK(g_nflq96)
STD_ROM_FN(g_nflq96)

struct BurnDriverD BurnDrvMDg_nflq96 = {
	"g_nflq96", NULL, NULL, "1900",
	"NFL Quarterback Club 96 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nflq96RomInfo, g_nflq96RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NFL Sports Talk Football '93 Starring Joe Montana (USA, Europe)
static struct BurnRomInfo g_nflspoRomDesc[] = {
	{ "nfl sports talk football '93 starring joe montana (usa, europe).md", 0x180000, 0xce0b1fe1, BRF_PRG },
};

STD_ROM_PICK(g_nflspo)
STD_ROM_FN(g_nflspo)

struct BurnDriver BurnDrvMDg_nflspo = {
	"g_nflspo", NULL, NULL, "1900",
	"NFL Sports Talk Football '93 Starring Joe Montana (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nflspoRomInfo, g_nflspoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHK Taiga Drama - Taiheiki (Japan)
static struct BurnRomInfo g_nhktaiRomDesc[] = {
	{ "nhk taiga drama - taiheiki (japan).md", 0x100000, 0x09fbb30e, BRF_PRG },
};

STD_ROM_PICK(g_nhktai)
STD_ROM_FN(g_nhktai)

struct BurnDriver BurnDrvMDg_nhktai = {
	"g_nhktai", NULL, NULL, "1900",
	"NHK Taiga Drama - Taiheiki (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhktaiRomInfo, g_nhktaiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL '94 (USA, Europe)
static struct BurnRomInfo g_nhl94RomDesc[] = {
	{ "nhl '94 (usa, europe).md", 0x100000, 0x9438f5dd, BRF_PRG },
};

STD_ROM_PICK(g_nhl94)
STD_ROM_FN(g_nhl94)

struct BurnDriver BurnDrvMDg_nhl94 = {
	"g_nhl94", NULL, NULL, "1993",
	"NHL '94 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhl94RomInfo, g_nhl94RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveNoByteswapBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL 95 (USA, Europe)
static struct BurnRomInfo g_nhl95RomDesc[] = {
	{ "nhl 95 (usa, europe).md", 0x200000, 0xe8ee917e, BRF_PRG },
};

STD_ROM_PICK(g_nhl95)
STD_ROM_FN(g_nhl95)

struct BurnDriver BurnDrvMDg_nhl95 = {
	"g_nhl95", NULL, NULL, "1900",
	"NHL 95 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhl95RomInfo, g_nhl95RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL 96 (USA, Europe)
static struct BurnRomInfo g_nhl96RomDesc[] = {
	{ "nhl 96 (usa, europe).md", 0x200000, 0x8135702c, BRF_PRG },
};

STD_ROM_PICK(g_nhl96)
STD_ROM_FN(g_nhl96)

struct BurnDriver BurnDrvMDg_nhl96 = {
	"g_nhl96", NULL, NULL, "1900",
	"NHL 96 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhl96RomInfo, g_nhl96RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL 97 (USA, Europe)
static struct BurnRomInfo g_nhl97RomDesc[] = {
	{ "nhl 97 (usa, europe).md", 0x200000, 0xf067c103, BRF_PRG },
};

STD_ROM_PICK(g_nhl97)
STD_ROM_FN(g_nhl97)

struct BurnDriver BurnDrvMDg_nhl97 = {
	"g_nhl97", NULL, NULL, "1900",
	"NHL 97 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhl97RomInfo, g_nhl97RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL 98 (USA)
static struct BurnRomInfo g_nhl98RomDesc[] = {
	{ "nhl 98 (usa).md", 0x200000, 0x7b64cd98, BRF_PRG },
};

STD_ROM_PICK(g_nhl98)
STD_ROM_FN(g_nhl98)

struct BurnDriver BurnDrvMDg_nhl98 = {
	"g_nhl98", NULL, NULL, "1900",
	"NHL 98 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhl98RomInfo, g_nhl98RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Dec 01, 1994 - B)
static struct BurnRomInfo g_nhlasaRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - dec 01, 1994 - b).md", 0x1ffffa, 0xc209d720, BRF_PRG },
};

STD_ROM_PICK(g_nhlasa)
STD_ROM_FN(g_nhlasa)

struct BurnDriverD BurnDrvMDg_nhlasa = {
	"g_nhlasa", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Dec 01, 1994 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlasaRomInfo, g_nhlasaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Dec 01, 1994)
static struct BurnRomInfo g_nhlasbRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - dec 01, 1994).md", 0x1ffffa, 0x112e4cb3, BRF_PRG },
};

STD_ROM_PICK(g_nhlasb)
STD_ROM_FN(g_nhlasb)

struct BurnDriverD BurnDrvMDg_nhlasb = {
	"g_nhlasb", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Dec 01, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlasbRomInfo, g_nhlasbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Dec 02, 1994)
static struct BurnRomInfo g_nhlascRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - dec 02, 1994).md", 0x1ffffa, 0x01d6a6c7, BRF_PRG },
};

STD_ROM_PICK(g_nhlasc)
STD_ROM_FN(g_nhlasc)

struct BurnDriverD BurnDrvMDg_nhlasc = {
	"g_nhlasc", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Dec 02, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlascRomInfo, g_nhlascRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Nov 07, 1994)
static struct BurnRomInfo g_nhlasdRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 07, 1994).md", 0x200000, 0xe8f2c88f, BRF_PRG },
};

STD_ROM_PICK(g_nhlasd)
STD_ROM_FN(g_nhlasd)

struct BurnDriverD BurnDrvMDg_nhlasd = {
	"g_nhlasd", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Nov 07, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlasdRomInfo, g_nhlasdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Nov 09, 1994)
static struct BurnRomInfo g_nhlaseRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 09, 1994).md", 0x1ffff9, 0x82624073, BRF_PRG },
};

STD_ROM_PICK(g_nhlase)
STD_ROM_FN(g_nhlase)

struct BurnDriverD BurnDrvMDg_nhlase = {
	"g_nhlase", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Nov 09, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlaseRomInfo, g_nhlaseRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Nov 19, 1994)
static struct BurnRomInfo g_nhlasfRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 19, 1994).md", 0x200000, 0xcd0f588a, BRF_PRG },
};

STD_ROM_PICK(g_nhlasf)
STD_ROM_FN(g_nhlasf)

struct BurnDriverD BurnDrvMDg_nhlasf = {
	"g_nhlasf", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Nov 19, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlasfRomInfo, g_nhlasfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Nov 21, 1994)
static struct BurnRomInfo g_nhlasgRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 21, 1994).md", 0x200000, 0xcfe4059d, BRF_PRG },
};

STD_ROM_PICK(g_nhlasg)
STD_ROM_FN(g_nhlasg)

struct BurnDriverD BurnDrvMDg_nhlasg = {
	"g_nhlasg", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Nov 21, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlasgRomInfo, g_nhlasgRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Nov 22, 1994)
static struct BurnRomInfo g_nhlashRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 22, 1994).md", 0x1ffffa, 0x81d30fe6, BRF_PRG },
};

STD_ROM_PICK(g_nhlash)
STD_ROM_FN(g_nhlash)

struct BurnDriverD BurnDrvMDg_nhlash = {
	"g_nhlash", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Nov 22, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlashRomInfo, g_nhlashRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Nov 23, 1994)
static struct BurnRomInfo g_nhlasiRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 23, 1994).md", 0x1ffffa, 0x88d4fc38, BRF_PRG },
};

STD_ROM_PICK(g_nhlasi)
STD_ROM_FN(g_nhlasi)

struct BurnDriverD BurnDrvMDg_nhlasi = {
	"g_nhlasi", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Nov 23, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlasiRomInfo, g_nhlasiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Nov 27, 1994)
static struct BurnRomInfo g_nhlasjRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 27, 1994).md", 0x1ffffa, 0x658ffe52, BRF_PRG },
};

STD_ROM_PICK(g_nhlasj)
STD_ROM_FN(g_nhlasj)

struct BurnDriverD BurnDrvMDg_nhlasj = {
	"g_nhlasj", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Nov 27, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlasjRomInfo, g_nhlasjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Nov 28, 1994)
static struct BurnRomInfo g_nhlaskRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 28, 1994).md", 0x1ffffa, 0x51ad0056, BRF_PRG },
};

STD_ROM_PICK(g_nhlask)
STD_ROM_FN(g_nhlask)

struct BurnDriverD BurnDrvMDg_nhlask = {
	"g_nhlask", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Nov 28, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlaskRomInfo, g_nhlaskRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Nov 29, 1994)
static struct BurnRomInfo g_nhlaslRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - nov 29, 1994).md", 0x1ffffa, 0xa060a60b, BRF_PRG },
};

STD_ROM_PICK(g_nhlasl)
STD_ROM_FN(g_nhlasl)

struct BurnDriverD BurnDrvMDg_nhlasl = {
	"g_nhlasl", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Nov 29, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlaslRomInfo, g_nhlaslRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Oct 01, 1994)
static struct BurnRomInfo g_nhlasmRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - oct 01, 1994).md", 0x1ffff9, 0xb1c0fbb2, BRF_PRG },
};

STD_ROM_PICK(g_nhlasm)
STD_ROM_FN(g_nhlasm)

struct BurnDriverD BurnDrvMDg_nhlasm = {
	"g_nhlasm", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Oct 01, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlasmRomInfo, g_nhlasmRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Oct 21, 1994)
static struct BurnRomInfo g_nhlasnRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - oct 21, 1994).md", 0x200000, 0x17eb2238, BRF_PRG },
};

STD_ROM_PICK(g_nhlasn)
STD_ROM_FN(g_nhlasn)

struct BurnDriverD BurnDrvMDg_nhlasn = {
	"g_nhlasn", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Oct 21, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlasnRomInfo, g_nhlasnRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Sep 14, 1994)
static struct BurnRomInfo g_nhlasoRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - sep 14, 1994).md", 0x200000, 0x5d4bc48d, BRF_PRG },
};

STD_ROM_PICK(g_nhlaso)
STD_ROM_FN(g_nhlaso)

struct BurnDriverD BurnDrvMDg_nhlaso = {
	"g_nhlaso", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Sep 14, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlasoRomInfo, g_nhlasoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (Prototype - Sep 29, 1994)
static struct BurnRomInfo g_nhlaspRomDesc[] = {
	{ "nhl all-star hockey '95 (prototype - sep 29, 1994).md", 0x1ffff9, 0x96bae44f, BRF_PRG },
};

STD_ROM_PICK(g_nhlasp)
STD_ROM_FN(g_nhlasp)

struct BurnDriverD BurnDrvMDg_nhlasp = {
	"g_nhlasp", "g_nhlas", NULL, "",
	"NHL All-Star Hockey '95 (Prototype - Sep 29, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlaspRomInfo, g_nhlaspRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL All-Star Hockey '95 (USA)
static struct BurnRomInfo g_nhlasRomDesc[] = {
	{ "nhl all-star hockey '95 (usa).md", 0x200000, 0xe6c0218b, BRF_PRG },
};

STD_ROM_PICK(g_nhlas)
STD_ROM_FN(g_nhlas)

struct BurnDriverD BurnDrvMDg_nhlas = {
	"g_nhlas", NULL, NULL, "1900",
	"NHL All-Star Hockey '95 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlasRomInfo, g_nhlasRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHL Hockey (USA)
static struct BurnRomInfo g_nhlhocRomDesc[] = {
	{ "nhl hockey (usa).md", 0x80000, 0x2641653f, BRF_PRG },
};

STD_ROM_PICK(g_nhlhoc)
STD_ROM_FN(g_nhlhoc)

struct BurnDriver BurnDrvMDg_nhlhoc = {
	"g_nhlhoc", NULL, NULL, "1900",
	"NHL Hockey (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlhocRomInfo, g_nhlhocRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHLPA Hockey 93 (USA, Europe) (v1.1)
static struct BurnRomInfo g_nhlpahRomDesc[] = {
	{ "nhlpa hockey 93 (usa, europe) (v1.1).md", 0x80000, 0xf361d0bf, BRF_PRG },
};

STD_ROM_PICK(g_nhlpah)
STD_ROM_FN(g_nhlpah)

struct BurnDriverD BurnDrvMDg_nhlpah = {
	"g_nhlpah", NULL, NULL, "1900",
	"NHLPA Hockey 93 (USA, Europe) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlpahRomInfo, g_nhlpahRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// NHLPA Hockey 93 (USA, Europe)
static struct BurnRomInfo g_nhlpa1RomDesc[] = {
	{ "nhlpa hockey 93 (usa, europe).md", 0x80000, 0xcbbf4262, BRF_PRG },
};

STD_ROM_PICK(g_nhlpa1)
STD_ROM_FN(g_nhlpa1)

struct BurnDriverD BurnDrvMDg_nhlpa1 = {
	"g_nhlpa1", "g_nhlpah", NULL, "1900",
	"NHLPA Hockey 93 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nhlpa1RomInfo, g_nhlpa1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nigel Mansell's World Championship Racing (Europe)
static struct BurnRomInfo g_nigelmRomDesc[] = {
	{ "nigel mansell's world championship racing (europe).md", 0x100000, 0x3fe3d63b, BRF_PRG },
};

STD_ROM_PICK(g_nigelm)
STD_ROM_FN(g_nigelm)

struct BurnDriverD BurnDrvMDg_nigelm = {
	"g_nigelm", NULL, NULL, "1900",
	"Nigel Mansell's World Championship Racing (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nigelmRomInfo, g_nigelmRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nigel Mansell's World Championship Racing (USA)
static struct BurnRomInfo g_nigel1RomDesc[] = {
	{ "nigel mansell's world championship racing (usa).md", 0x100000, 0x6bc57b2c, BRF_PRG },
};

STD_ROM_PICK(g_nigel1)
STD_ROM_FN(g_nigel1)

struct BurnDriverD BurnDrvMDg_nigel1 = {
	"g_nigel1", "g_nigelm", NULL, "1900",
	"Nigel Mansell's World Championship Racing (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nigel1RomInfo, g_nigel1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nightmare Circus (Brazil) (Beta)
static struct BurnRomInfo g_ncircbRomDesc[] = {
	{ "nightmare circus (brazil) (beta).md", 0x200000, 0x31de5a94, BRF_PRG },
};

STD_ROM_PICK(g_ncircb)
STD_ROM_FN(g_ncircb)

struct BurnDriverD BurnDrvMDg_ncircb = {
	"g_ncircb", "g_ncirc", NULL, "1900",
	"Nightmare Circus (Brazil) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ncircbRomInfo, g_ncircbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nightmare Circus (Brazil)
static struct BurnRomInfo g_ncircRomDesc[] = {
	{ "nightmare circus (brazil).md", 0x200000, 0x06da3217, BRF_PRG },
};

STD_ROM_PICK(g_ncirc)
STD_ROM_FN(g_ncirc)

struct BurnDriverD BurnDrvMDg_ncirc = {
	"g_ncirc", NULL, NULL, "1900",
	"Nightmare Circus (Brazil)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ncircRomInfo, g_ncircRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nightmare Circus (Prototype)
static struct BurnRomInfo g_ncircpRomDesc[] = {
	{ "nightmare circus (prototype).md", 0x400000, 0xee96f1b8, BRF_PRG },
};

STD_ROM_PICK(g_ncircp)
STD_ROM_FN(g_ncircp)

struct BurnDriverD BurnDrvMDg_ncircp = {
	"g_ncircp", "g_ncirc", NULL, "",
	"Nightmare Circus (Prototype)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ncircpRomInfo, g_ncircpRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nikkan Sports Pro Yakyuu Van (Japan)
static struct BurnRomInfo g_nikkanRomDesc[] = {
	{ "nikkan sports pro yakyuu van (japan).md", 0x80000, 0xc3655a59, BRF_PRG },
};

STD_ROM_PICK(g_nikkan)
STD_ROM_FN(g_nikkan)

struct BurnDriverD BurnDrvMDg_nikkan = {
	"g_nikkan", NULL, NULL, "",
	"Nikkan Sports Pro Yakyuu Van (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nikkanRomInfo, g_nikkanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ninja Burai Densetsu (Japan)
static struct BurnRomInfo g_ninjabRomDesc[] = {
	{ "ninja burai densetsu (japan).md", 0x100000, 0xa8d828a0, BRF_PRG },
};

STD_ROM_PICK(g_ninjab)
STD_ROM_FN(g_ninjab)

struct BurnDriverD BurnDrvMDg_ninjab = {
	"g_ninjab", NULL, NULL, "1900",
	"Ninja Burai Densetsu (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ninjabRomInfo, g_ninjabRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ninja Gaiden (Japan) (Proto) [b]
static struct BurnRomInfo g_ninjagRomDesc[] = {
	{ "ninja gaiden (japan) (proto) [b].md", 0x100000, 0x0d7f74ba, BRF_PRG },
};

STD_ROM_PICK(g_ninjag)
STD_ROM_FN(g_ninjag)

struct BurnDriverD BurnDrvMDg_ninjag = {
	"g_ninjag", NULL, NULL, "1900",
	"Ninja Gaiden (Japan) (Proto) [b]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ninjagRomInfo, g_ninjagRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// No Escape (USA)
static struct BurnRomInfo g_noescaRomDesc[] = {
	{ "no escape (usa).md", 0x200000, 0x44ee5f20, BRF_PRG },
};

STD_ROM_PICK(g_noesca)
STD_ROM_FN(g_noesca)

struct BurnDriverD BurnDrvMDg_noesca = {
	"g_noesca", NULL, NULL, "1900",
	"No Escape (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_noescaRomInfo, g_noescaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nobunaga no Yabou - Bushou Fuuunroku (Japan)
static struct BurnRomInfo g_nobbusRomDesc[] = {
	{ "nobunaga no yabou - bushou fuuunroku (japan).md", 0x100000, 0x30bf8637, BRF_PRG },
};

STD_ROM_PICK(g_nobbus)
STD_ROM_FN(g_nobbus)

struct BurnDriverD BurnDrvMDg_nobbus = {
	"g_nobbus", NULL, NULL, "",
	"Nobunaga no Yabou - Bushou Fuuunroku (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nobbusRomInfo, g_nobbusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nobunaga no Yabou - Haouden (Japan)
static struct BurnRomInfo g_nobhaoRomDesc[] = {
	{ "nobunaga no yabou - haouden (japan).md", 0x200000, 0x96c01fc6, BRF_PRG },
};

STD_ROM_PICK(g_nobhao)
STD_ROM_FN(g_nobhao)

struct BurnDriver BurnDrvMDg_nobhao = {
	"g_nobhao", NULL, NULL, "1900",
	"Nobunaga no Yabou - Haouden (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nobhaoRomInfo, g_nobhaoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nobunaga no Yabou - Zenkoku Ban (Japan)
static struct BurnRomInfo g_nobzenRomDesc[] = {
	{ "nobunaga no yabou - zenkoku ban (japan).md", 0x80000, 0x1381b313, BRF_PRG },
};

STD_ROM_PICK(g_nobzen)
STD_ROM_FN(g_nobzen)

struct BurnDriver BurnDrvMDg_nobzen = {
	"g_nobzen", "g_nobamb", NULL, "1900",
	"Nobunaga no Yabou - Zenkoku Ban (Japan)\0", NULL, "Koei", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nobzenRomInfo, g_nobzenRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Nobunaga's Ambition (USA)
static struct BurnRomInfo g_nobambRomDesc[] = {
	{ "nobunaga's ambition (usa).md", 0x80000, 0xb9bc07bc, BRF_PRG },
};

STD_ROM_PICK(g_nobamb)
STD_ROM_FN(g_nobamb)

struct BurnDriver BurnDrvMDg_nobamb = {
	"g_nobamb", NULL, NULL, "1900",
	"Nobunaga's Ambition (USA)\0", NULL, "Koei", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_nobambRomInfo, g_nobambRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Normy's Beach Babe-O-Rama (USA, Europe)
static struct BurnRomInfo g_normysRomDesc[] = {
	{ "normy's beach babe-o-rama (usa, europe).md", 0x100000, 0xb56a8220, BRF_PRG },
};

STD_ROM_PICK(g_normys)
STD_ROM_FN(g_normys)

struct BurnDriverD BurnDrvMDg_normys = {
	"g_normys", NULL, NULL, "1900",
	"Normy's Beach Babe-O-Rama (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_normysRomInfo, g_normysRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Olympic Gold (Europe)
static struct BurnRomInfo g_olympiRomDesc[] = {
	{ "olympic gold (europe).md", 0x80000, 0x924e57d3, BRF_PRG },
};

STD_ROM_PICK(g_olympi)
STD_ROM_FN(g_olympi)

struct BurnDriverD BurnDrvMDg_olympi = {
	"g_olympi", NULL, NULL, "1900",
	"Olympic Gold (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_olympiRomInfo, g_olympiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Olympic Gold (Japan, Korea)
static struct BurnRomInfo g_olymp1RomDesc[] = {
	{ "olympic gold (japan, korea).md", 0x80000, 0xe9c925b8, BRF_PRG },
};

STD_ROM_PICK(g_olymp1)
STD_ROM_FN(g_olymp1)

struct BurnDriverD BurnDrvMDg_olymp1 = {
	"g_olymp1", "g_olympi", NULL, "1900",
	"Olympic Gold (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_olymp1RomInfo, g_olymp1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Olympic Gold (USA) (Alt)
static struct BurnRomInfo g_olymp2RomDesc[] = {
	{ "olympic gold (usa) (alt).md", 0x80000, 0xaf639376, BRF_PRG },
};

STD_ROM_PICK(g_olymp2)
STD_ROM_FN(g_olymp2)

struct BurnDriverD BurnDrvMDg_olymp2 = {
	"g_olymp2", "g_olympi", NULL, "1900",
	"Olympic Gold (USA) (Alt)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_olymp2RomInfo, g_olymp2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Olympic Gold (USA)
static struct BurnRomInfo g_olymp3RomDesc[] = {
	{ "olympic gold (usa).md", 0x80000, 0x339594b4, BRF_PRG },
};

STD_ROM_PICK(g_olymp3)
STD_ROM_FN(g_olymp3)

struct BurnDriverD BurnDrvMDg_olymp3 = {
	"g_olymp3", "g_olympi", NULL, "1900",
	"Olympic Gold (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_olymp3RomInfo, g_olymp3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Olympic Summer Games (USA, Europe)
static struct BurnRomInfo g_olsumRomDesc[] = {
	{ "olympic summer games (usa, europe).md", 0x200000, 0x9e470fb9, BRF_PRG },
};

STD_ROM_PICK(g_olsum)
STD_ROM_FN(g_olsum)

struct BurnDriverD BurnDrvMDg_olsum = {
	"g_olsum", NULL, NULL, "1900",
	"Olympic Summer Games (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_olsumRomInfo, g_olsumRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// On Dal Jang Goon (Korea)
static struct BurnRomInfo g_ondaljRomDesc[] = {
	{ "on dal jang goon (korea).md", 0x80000, 0x67ccb1ca, BRF_PRG },
};

STD_ROM_PICK(g_ondalj)
STD_ROM_FN(g_ondalj)

struct BurnDriverD BurnDrvMDg_ondalj = {
	"g_ondalj", NULL, NULL, "",
	"On Dal Jang Goon (Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ondaljRomInfo, g_ondaljRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Onslaught (USA, Europe)
static struct BurnRomInfo g_onslauRomDesc[] = {
	{ "onslaught (usa, europe).md", 0x80000, 0x9f19d6df, BRF_PRG },
};

STD_ROM_PICK(g_onslau)
STD_ROM_FN(g_onslau)

struct BurnDriverD BurnDrvMDg_onslau = {
	"g_onslau", NULL, NULL, "1900",
	"Onslaught (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_onslauRomInfo, g_onslauRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ooze, The (E) (Prototype - Jul 28, 1995)
static struct BurnRomInfo g_oozepaRomDesc[] = {
	{ "ooze, the (e) (prototype - jul 28, 1995).md", 0x100000, 0x7cf868e7, BRF_PRG },
};

STD_ROM_PICK(g_oozepa)
STD_ROM_FN(g_oozepa)

struct BurnDriverD BurnDrvMDg_oozepa = {
	"g_oozepa", "g_ooze", NULL, "",
	"Ooze, The (E) (Prototype - Jul 28, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_oozepaRomInfo, g_oozepaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ooze, The (Europe)
static struct BurnRomInfo g_oozeRomDesc[] = {
	{ "ooze, the (europe).md", 0x100000, 0xe16b102c, BRF_PRG },
};

STD_ROM_PICK(g_ooze)
STD_ROM_FN(g_ooze)

struct BurnDriverD BurnDrvMDg_ooze = {
	"g_ooze", NULL, NULL, "1900",
	"Ooze, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_oozeRomInfo, g_oozeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ooze, The (Japan, USA)
static struct BurnRomInfo g_oozejuRomDesc[] = {
	{ "ooze, the (japan, usa).md", 0x100000, 0x1c0dd42f, BRF_PRG },
};

STD_ROM_PICK(g_oozeju)
STD_ROM_FN(g_oozeju)

struct BurnDriverD BurnDrvMDg_oozeju = {
	"g_oozeju", "g_ooze", NULL, "1900",
	"Ooze, The (Japan, USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_oozejuRomInfo, g_oozejuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ooze, The (Prototype - Jun 15, 1995)
static struct BurnRomInfo g_oozepbRomDesc[] = {
	{ "ooze, the (prototype - jun 15, 1995).md", 0xe35ce, 0x921106fd, BRF_PRG },
};

STD_ROM_PICK(g_oozepb)
STD_ROM_FN(g_oozepb)

struct BurnDriverD BurnDrvMDg_oozepb = {
	"g_oozepb", "g_ooze", NULL, "",
	"Ooze, The (Prototype - Jun 15, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_oozepbRomInfo, g_oozepbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ooze, The (Prototype - Jun 19, 1995)
static struct BurnRomInfo g_oozepcRomDesc[] = {
	{ "ooze, the (prototype - jun 19, 1995).md", 0x100000, 0xfa39281d, BRF_PRG },
};

STD_ROM_PICK(g_oozepc)
STD_ROM_FN(g_oozepc)

struct BurnDriverD BurnDrvMDg_oozepc = {
	"g_oozepc", "g_ooze", NULL, "",
	"Ooze, The (Prototype - Jun 19, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_oozepcRomInfo, g_oozepcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ooze, The (Prototype - Jun 29, 1995 - B)
static struct BurnRomInfo g_oozepdRomDesc[] = {
	{ "ooze, the (prototype - jun 29, 1995 - b).md", 0xee456, 0xca93e93b, BRF_PRG },
};

STD_ROM_PICK(g_oozepd)
STD_ROM_FN(g_oozepd)

struct BurnDriverD BurnDrvMDg_oozepd = {
	"g_oozepd", "g_ooze", NULL, "",
	"Ooze, The (Prototype - Jun 29, 1995 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_oozepdRomInfo, g_oozepdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ooze, The (Prototype - Jun 29, 1995)
static struct BurnRomInfo g_oozepeRomDesc[] = {
	{ "ooze, the (prototype - jun 29, 1995).md", 0x100000, 0x1776763b, BRF_PRG },
};

STD_ROM_PICK(g_oozepe)
STD_ROM_FN(g_oozepe)

struct BurnDriverD BurnDrvMDg_oozepe = {
	"g_oozepe", "g_ooze", NULL, "",
	"Ooze, The (Prototype - Jun 29, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_oozepeRomInfo, g_oozepeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ooze, The (Prototype 104 - Jun 22, 1995)
static struct BurnRomInfo g_oozetfRomDesc[] = {
	{ "ooze, the (prototype 104 - jun 22, 1995).md", 0xebea8, 0xce1f139f, BRF_PRG },
};

STD_ROM_PICK(g_oozetf)
STD_ROM_FN(g_oozetf)

struct BurnDriverD BurnDrvMDg_oozetf = {
	"g_oozetf", "g_ooze", NULL, "",
	"Ooze, The (Prototype 104 - Jun 22, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_oozetfRomInfo, g_oozetfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ooze, The (Prototype 112 - Jun 26, 1995)
static struct BurnRomInfo g_oozetgRomDesc[] = {
	{ "ooze, the (prototype 112 - jun 26, 1995).md", 0xec570, 0x70419442, BRF_PRG },
};

STD_ROM_PICK(g_oozetg)
STD_ROM_FN(g_oozetg)

struct BurnDriverD BurnDrvMDg_oozetg = {
	"g_oozetg", "g_ooze", NULL, "",
	"Ooze, The (Prototype 112 - Jun 26, 1995)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_oozetgRomInfo, g_oozetgRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Operation Europe - Path to Victory 1939-45 (USA)
static struct BurnRomInfo g_operatRomDesc[] = {
	{ "operation europe - path to victory 1939-45 (usa).md", 0x100000, 0xe7cba1d8, BRF_PRG },
};

STD_ROM_PICK(g_operat)
STD_ROM_FN(g_operat)

struct BurnDriver BurnDrvMDg_operat = {
	"g_operat", NULL, NULL, "1900",
	"Operation Europe - Path to Victory 1939-45 (USA)\0", NULL, "Koei", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_operatRomInfo, g_operatRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Osomatsu-kun Hachamecha Gekijou (Japan)
static struct BurnRomInfo g_osomatRomDesc[] = {
	{ "osomatsu-kun hachamecha gekijou (japan).md", 0x40000, 0x2453350c, BRF_PRG },
};

STD_ROM_PICK(g_osomat)
STD_ROM_FN(g_osomat)

struct BurnDriverD BurnDrvMDg_osomat = {
	"g_osomat", NULL, NULL, "1900",
	"Osomatsu-kun Hachamecha Gekijou (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_osomatRomInfo, g_osomatRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ottifants, The (Europe)
static struct BurnRomInfo g_ottifaRomDesc[] = {
	{ "ottifants, the (europe).md", 0x100000, 0x41ac8003, BRF_PRG },
};

STD_ROM_PICK(g_ottifa)
STD_ROM_FN(g_ottifa)

struct BurnDriverD BurnDrvMDg_ottifa = {
	"g_ottifa", NULL, NULL, "1900",
	"Ottifants, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ottifaRomInfo, g_ottifaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ottifants, The (Germany) (Beta)
static struct BurnRomInfo g_ottif1RomDesc[] = {
	{ "ottifants, the (germany) (beta).md", 0x100000, 0xc6e3dd23, BRF_PRG },
};

STD_ROM_PICK(g_ottif1)
STD_ROM_FN(g_ottif1)

struct BurnDriverD BurnDrvMDg_ottif1 = {
	"g_ottif1", "g_ottifa", NULL, "1900",
	"Ottifants, The (Germany) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ottif1RomInfo, g_ottif1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Out of this World (Beta)
static struct BurnRomInfo g_ootwbRomDesc[] = {
	{ "out of this world (beta).md", 0x100000, 0x3aad905a, BRF_PRG },
};

STD_ROM_PICK(g_ootwb)
STD_ROM_FN(g_ootwb)

struct BurnDriverD BurnDrvMDg_ootwb = {
	"g_ootwb", "g_anothe", NULL, "1992",
	"Out of this World (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ootwbRomInfo, g_ootwbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Out of This World (USA)
static struct BurnRomInfo g_ootwRomDesc[] = {
	{ "out of this world (usa).md", 0x100000, 0x2da36e01, BRF_PRG },
};

STD_ROM_PICK(g_ootw)
STD_ROM_FN(g_ootw)

struct BurnDriverD BurnDrvMDg_ootw = {
	"g_ootw", "g_anothe", NULL, "1992",
	"Out of This World (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ootwRomInfo, g_ootwRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Outlander (Europe)
static struct BurnRomInfo g_outlanRomDesc[] = {
	{ "outlander (europe).md", 0x100000, 0xfe6f2350, BRF_PRG },
};

STD_ROM_PICK(g_outlan)
STD_ROM_FN(g_outlan)

struct BurnDriverD BurnDrvMDg_outlan = {
	"g_outlan", NULL, NULL, "1900",
	"Outlander (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_outlanRomInfo, g_outlanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Outlander (USA)
static struct BurnRomInfo g_outla1RomDesc[] = {
	{ "outlander (usa).md", 0x100000, 0xc5ba7bbf, BRF_PRG },
};

STD_ROM_PICK(g_outla1)
STD_ROM_FN(g_outla1)

struct BurnDriverD BurnDrvMDg_outla1 = {
	"g_outla1", "g_outlan", NULL, "1900",
	"Outlander (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_outla1RomInfo, g_outla1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun (Japan)
static struct BurnRomInfo g_orunaRomDesc[] = {
	{ "outrun (japan).md", 0x100000, 0xee7d9f4a, BRF_PRG },
};

STD_ROM_PICK(g_oruna)
STD_ROM_FN(g_oruna)

struct BurnDriverD BurnDrvMDg_oruna = {
	"g_oruna", "g_orun", NULL, "1900",
	"OutRun (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_orunaRomInfo, g_orunaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun (USA, Europe)
static struct BurnRomInfo g_orunRomDesc[] = {
	{ "outrun (usa, europe).md", 0x100000, 0xfdd9a8d2, BRF_PRG },
};

STD_ROM_PICK(g_orun)
STD_ROM_FN(g_orun)

struct BurnDriverD BurnDrvMDg_orun = {
	"g_orun", NULL, NULL, "",
	"OutRun (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_orunRomInfo, g_orunRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun 2019 (Europe)
static struct BurnRomInfo g_o2019RomDesc[] = {
	{ "outrun 2019 (europe).md", 0x100000, 0x5cb3536a, BRF_PRG },
};

STD_ROM_PICK(g_o2019)
STD_ROM_FN(g_o2019)

struct BurnDriverD BurnDrvMDg_o2019 = {
	"g_o2019", NULL, NULL, "1993",
	"OutRun 2019 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_o2019RomInfo, g_o2019RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun 2019 (Japan)
static struct BurnRomInfo g_o2019jRomDesc[] = {
	{ "outrun 2019 (japan).md", 0x100000, 0x0eac7440, BRF_PRG },
};

STD_ROM_PICK(g_o2019j)
STD_ROM_FN(g_o2019j)

struct BurnDriverD BurnDrvMDg_o2019j = {
	"g_o2019j", "g_o2019", NULL, "1993",
	"OutRun 2019 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_o2019jRomInfo, g_o2019jRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun 2019 (USA) (Beta)
static struct BurnRomInfo g_o2019bRomDesc[] = {
	{ "outrun 2019 (usa) (beta).md", 0x100000, 0xd2ecddfa, BRF_PRG },
};

STD_ROM_PICK(g_o2019b)
STD_ROM_FN(g_o2019b)

struct BurnDriverD BurnDrvMDg_o2019b = {
	"g_o2019b", "g_o2019", NULL, "1993",
	"OutRun 2019 (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_o2019bRomInfo, g_o2019bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRun 2019 (USA)
static struct BurnRomInfo g_o2019uRomDesc[] = {
	{ "outrun 2019 (usa).md", 0x100000, 0xe32e17e2, BRF_PRG },
};

STD_ROM_PICK(g_o2019u)
STD_ROM_FN(g_o2019u)

struct BurnDriverD BurnDrvMDg_o2019u = {
	"g_o2019u", "g_o2019", NULL, "1993",
	"OutRun 2019 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_o2019uRomInfo, g_o2019uRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRunners (Japan)
static struct BurnRomInfo g_orunrjRomDesc[] = {
	{ "outrunners (japan).md", 0x200000, 0xe164a09f, BRF_PRG },
};

STD_ROM_PICK(g_orunrj)
STD_ROM_FN(g_orunrj)

struct BurnDriverD BurnDrvMDg_orunrj = {
	"g_orunrj", "g_orunr", NULL, "199?",
	"OutRunners (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_orunrjRomInfo, g_orunrjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// OutRunners (USA)
static struct BurnRomInfo g_orunrRomDesc[] = {
	{ "outrunners (usa).md", 0x200000, 0xede636b9, BRF_PRG },
};

STD_ROM_PICK(g_orunr)
STD_ROM_FN(g_orunr)

struct BurnDriverD BurnDrvMDg_orunr = {
	"g_orunr", NULL, NULL, "199?",
	"OutRunners (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_orunrRomInfo, g_orunrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pac-Attack (USA)
static struct BurnRomInfo g_pacattRomDesc[] = {
	{ "pac-attack (usa).md", 0x40000, 0x5df382f7, BRF_PRG },
};

STD_ROM_PICK(g_pacatt)
STD_ROM_FN(g_pacatt)

struct BurnDriverD BurnDrvMDg_pacatt = {
	"g_pacatt", NULL, NULL, "1900",
	"Pac-Attack (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pacattRomInfo, g_pacattRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pac-Man 2 - The New Adventures (USA)
static struct BurnRomInfo g_pacmanRomDesc[] = {
	{ "pac-man 2 - the new adventures (usa).md", 0x200000, 0xfe7a7ed1, BRF_PRG },
};

STD_ROM_PICK(g_pacman)
STD_ROM_FN(g_pacman)

struct BurnDriverD BurnDrvMDg_pacman = {
	"g_pacman", NULL, NULL, "1900",
	"Pac-Man 2 - The New Adventures (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pacmanRomInfo, g_pacmanRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pac-Mania (USA, Europe)
static struct BurnRomInfo g_pmaniaRomDesc[] = {
	{ "pac-mania (usa, europe).md", 0x40000, 0x74bba09b, BRF_PRG },
};

STD_ROM_PICK(g_pmania)
STD_ROM_FN(g_pmania)

struct BurnDriverD BurnDrvMDg_pmania = {
	"g_pmania", NULL, NULL, "1900",
	"Pac-Mania (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pmaniaRomInfo, g_pmaniaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pachinko Kuunyan (Japan)
static struct BurnRomInfo g_pachinRomDesc[] = {
	{ "pachinko kuunyan (japan).md", 0x100000, 0x9d137e7f, BRF_PRG },
};

STD_ROM_PICK(g_pachin)
STD_ROM_FN(g_pachin)

struct BurnDriverD BurnDrvMDg_pachin = {
	"g_pachin", NULL, NULL, "",
	"Pachinko Kuunyan (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pachinRomInfo, g_pachinRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pacific Theater of Operations (USA)
static struct BurnRomInfo g_pacifiRomDesc[] = {
	{ "pacific theater of operations (usa).md", 0x100000, 0xd9d4c6e2, BRF_PRG },
};

STD_ROM_PICK(g_pacifi)
STD_ROM_FN(g_pacifi)

struct BurnDriver BurnDrvMDg_pacifi = {
	"g_pacifi", NULL, NULL, "1900",
	"Pacific Theater of Operations (USA)\0", NULL, "Koei", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pacifiRomInfo, g_pacifiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Paddle Fighter (Japan) (SegaNet)
static struct BurnRomInfo g_paddleRomDesc[] = {
	{ "paddle fighter (japan) (seganet).md", 0x40000, 0x3d8147e6, BRF_PRG },
};

STD_ROM_PICK(g_paddle)
STD_ROM_FN(g_paddle)

struct BurnDriverD BurnDrvMDg_paddle = {
	"g_paddle", NULL, NULL, "1994",
	"Paddle Fighter (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_paddleRomInfo, g_paddleRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Paddle Fighter (SN) (GNKO) (J) [!]
static struct BurnRomInfo g_paddl1RomDesc[] = {
	{ "paddle fighter (sn) (gnko) (j) [!].md", 0x40000, 0xebef05a4, BRF_PRG },
};

STD_ROM_PICK(g_paddl1)
STD_ROM_FN(g_paddl1)

struct BurnDriverD BurnDrvMDg_paddl1 = {
	"g_paddl1", "g_paddle", NULL, "",
	"Paddle Fighter (SN) (GNKO) (J) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_paddl1RomInfo, g_paddl1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pagemaster, The (Europe)
static struct BurnRomInfo g_pagemaRomDesc[] = {
	{ "pagemaster, the (europe).md", 0x200000, 0x79a180e2, BRF_PRG },
};

STD_ROM_PICK(g_pagema)
STD_ROM_FN(g_pagema)

struct BurnDriverD BurnDrvMDg_pagema = {
	"g_pagema", NULL, NULL, "1994",
	"Pagemaster, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pagemaRomInfo, g_pagemaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pagemaster, The (USA) (Beta)
static struct BurnRomInfo g_pagem1RomDesc[] = {
	{ "pagemaster, the (usa) (beta).md", 0x200000, 0x29895e3d, BRF_PRG },
};

STD_ROM_PICK(g_pagem1)
STD_ROM_FN(g_pagem1)

struct BurnDriverD BurnDrvMDg_pagem1 = {
	"g_pagem1", "g_pagema", NULL, "1994",
	"Pagemaster, The (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pagem1RomInfo, g_pagem1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pagemaster, The (USA)
static struct BurnRomInfo g_pagem2RomDesc[] = {
	{ "pagemaster, the (usa).md", 0x200000, 0x75a96d4e, BRF_PRG },
};

STD_ROM_PICK(g_pagem2)
STD_ROM_FN(g_pagem2)

struct BurnDriverD BurnDrvMDg_pagem2 = {
	"g_pagem2", "g_pagema", NULL, "1994",
	"Pagemaster, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pagem2RomInfo, g_pagem2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Panorama Cotton (Japan)
static struct BurnRomInfo g_panoraRomDesc[] = {
	{ "panorama cotton (japan).md", 0x280000, 0x9e57d92e, BRF_PRG },
};

STD_ROM_PICK(g_panora)
STD_ROM_FN(g_panora)

struct BurnDriverD BurnDrvMDg_panora = {
	"g_panora", NULL, NULL, "1900",
	"Panorama Cotton (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_panoraRomInfo, g_panoraRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Paperboy (Japan)
static struct BurnRomInfo g_paperbRomDesc[] = {
	{ "paperboy (japan).md", 0x80000, 0xe14250ae, BRF_PRG },
};

STD_ROM_PICK(g_paperb)
STD_ROM_FN(g_paperb)

struct BurnDriverD BurnDrvMDg_paperb = {
	"g_paperb", NULL, NULL, "1900",
	"Paperboy (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_paperbRomInfo, g_paperbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Paperboy (USA, Europe)
static struct BurnRomInfo g_paper1RomDesc[] = {
	{ "paperboy (usa, europe).md", 0x80000, 0x0a44819b, BRF_PRG },
};

STD_ROM_PICK(g_paper1)
STD_ROM_FN(g_paper1)

struct BurnDriverD BurnDrvMDg_paper1 = {
	"g_paper1", "g_paperb", NULL, "1900",
	"Paperboy (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_paper1RomInfo, g_paper1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Paperboy 2 (USA, Europe)
static struct BurnRomInfo g_paper2RomDesc[] = {
	{ "paperboy 2 (usa, europe).md", 0x100000, 0x1de28bb1, BRF_PRG },
};

STD_ROM_PICK(g_paper2)
STD_ROM_FN(g_paper2)

struct BurnDriverD BurnDrvMDg_paper2 = {
	"g_paper2", NULL, NULL, "1900",
	"Paperboy 2 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_paper2RomInfo, g_paper2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Party Quiz Mega Q (Japan)
static struct BurnRomInfo g_partyqRomDesc[] = {
	{ "party quiz mega q (japan).md", 0x100000, 0x9d4b447a, BRF_PRG },
};

STD_ROM_PICK(g_partyq)
STD_ROM_FN(g_partyq)

struct BurnDriverD BurnDrvMDg_partyq = {
	"g_partyq", NULL, NULL, "1900",
	"Party Quiz Mega Q (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_partyqRomInfo, g_partyqRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pat Riley Basketball (USA)
static struct BurnRomInfo g_patrilRomDesc[] = {
	{ "pat riley basketball (usa).md", 0x80000, 0x3d9318a7, BRF_PRG },
};

STD_ROM_PICK(g_patril)
STD_ROM_FN(g_patril)

struct BurnDriverD BurnDrvMDg_patril = {
	"g_patril", NULL, NULL, "1990",
	"Pat Riley Basketball (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_patrilRomInfo, g_patrilRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pebble Beach Golf Links (Europe)
static struct BurnRomInfo g_pebbleRomDesc[] = {
	{ "pebble beach golf links (europe).md", 0x200000, 0x6cfc7297, BRF_PRG },
};

STD_ROM_PICK(g_pebble)
STD_ROM_FN(g_pebble)

struct BurnDriver BurnDrvMDg_pebble = {
	"g_pebble", NULL, NULL, "1900",
	"Pebble Beach Golf Links (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pebbleRomInfo, g_pebbleRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pebble Beach Golf Links (USA)
static struct BurnRomInfo g_pebbl1RomDesc[] = {
	{ "pebble beach golf links (usa).md", 0x200000, 0x95823c43, BRF_PRG },
};

STD_ROM_PICK(g_pebbl1)
STD_ROM_FN(g_pebbl1)

struct BurnDriver BurnDrvMDg_pebbl1 = {
	"g_pebbl1", "g_pebble", NULL, "1900",
	"Pebble Beach Golf Links (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pebbl1RomInfo, g_pebbl1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pele II - World Tournament Soccer (USA, Europe)
static struct BurnRomInfo g_peleiiRomDesc[] = {
	{ "pele ii - world tournament soccer (usa, europe).md", 0x200000, 0x05a486e9, BRF_PRG },
};

STD_ROM_PICK(g_peleii)
STD_ROM_FN(g_peleii)

struct BurnDriverD BurnDrvMDg_peleii = {
	"g_peleii", NULL, NULL, "1900",
	"Pele II - World Tournament Soccer (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_peleiiRomInfo, g_peleiiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pele! (USA, Europe)
static struct BurnRomInfo g_peleusRomDesc[] = {
	{ "pele! (usa, europe).md", 0x100000, 0x5a8abe51, BRF_PRG },
};

STD_ROM_PICK(g_peleus)
STD_ROM_FN(g_peleus)

struct BurnDriverD BurnDrvMDg_peleus = {
	"g_peleus", NULL, NULL, "1900",
	"Pele! (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_peleusRomInfo, g_peleusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pepenga Pengo (Japan)
static struct BurnRomInfo g_pepengRomDesc[] = {
	{ "pepenga pengo (japan).md", 0x100000, 0xd1e2324b, BRF_PRG },
};

STD_ROM_PICK(g_pepeng)
STD_ROM_FN(g_pepeng)

struct BurnDriverD BurnDrvMDg_pepeng = {
	"g_pepeng", NULL, NULL, "1900",
	"Pepenga Pengo (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pepengRomInfo, g_pepengRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pete Sampras Tennis (USA, Europe) (J-Cart) (MDST6636)
static struct BurnRomInfo g_petesaRomDesc[] = {
	{ "pete sampras tennis (usa, europe) (j-cart) (mdst6636).md", 0x100000, 0x94e505b2, BRF_PRG },
};

STD_ROM_PICK(g_petesa)
STD_ROM_FN(g_petesa)

struct BurnDriverD BurnDrvMDg_petesa = {
	"g_petesa", NULL, NULL, "",
	"Pete Sampras Tennis (USA, Europe) (J-Cart) (MDST6636)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_petesaRomInfo, g_petesaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pete Sampras Tennis (USA, Europe) (J-Cart) (MDSTEE 13)
static struct BurnRomInfo g_petes1RomDesc[] = {
	{ "pete sampras tennis (usa, europe) (j-cart) (mdstee 13).md", 0x100000, 0xaa8b19bc, BRF_PRG },
};

STD_ROM_PICK(g_petes1)
STD_ROM_FN(g_petes1)

struct BurnDriverD BurnDrvMDg_petes1 = {
	"g_petes1", "g_petesa", NULL, "1900",
	"Pete Sampras Tennis (USA, Europe) (J-Cart) (MDSTEE 13)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_petes1RomInfo, g_petes1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pete Sampras Tennis (USA, Europe) (J-Cart)
static struct BurnRomInfo g_petes2RomDesc[] = {
	{ "pete sampras tennis (usa, europe) (j-cart).md", 0x100000, 0x9ef5bbd1, BRF_PRG },
};

STD_ROM_PICK(g_petes2)
STD_ROM_FN(g_petes2)

struct BurnDriverD BurnDrvMDg_petes2 = {
	"g_petes2", "g_petesa", NULL, "1900",
	"Pete Sampras Tennis (USA, Europe) (J-Cart)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_petes2RomInfo, g_petes2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA European Tour (USA, Europe)
static struct BurnRomInfo g_pgaeurRomDesc[] = {
	{ "pga european tour (usa, europe).md", 0x100000, 0x8ca45acd, BRF_PRG },
};

STD_ROM_PICK(g_pgaeur)
STD_ROM_FN(g_pgaeur)

struct BurnDriver BurnDrvMDg_pgaeur = {
	"g_pgaeur", NULL, NULL, "1900",
	"PGA European Tour (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pgaeurRomInfo, g_pgaeurRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour 96 (USA, Europe)
static struct BurnRomInfo g_pga96RomDesc[] = {
	{ "pga tour 96 (usa, europe).md", 0x200000, 0x9698bbde, BRF_PRG },
};

STD_ROM_PICK(g_pga96)
STD_ROM_FN(g_pga96)

struct BurnDriver BurnDrvMDg_pga96 = {
	"g_pga96", NULL, NULL, "1900",
	"PGA Tour 96 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pga96RomInfo, g_pga96RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf (USA, Europe) (v1.1)
static struct BurnRomInfo g_pgaaRomDesc[] = {
	{ "pga tour golf (usa, europe) (v1.1).md", 0x80000, 0x0489ff8e, BRF_PRG },
};

STD_ROM_PICK(g_pgaa)
STD_ROM_FN(g_pgaa)

struct BurnDriver BurnDrvMDg_pgaa = {
	"g_pgaa", "g_pga", NULL, "1900",
	"PGA Tour Golf (USA, Europe) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pgaaRomInfo, g_pgaaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf (USA, Europe) (v1.2)
static struct BurnRomInfo g_pgaRomDesc[] = {
	{ "pga tour golf (usa, europe) (v1.2).md", 0x80000, 0xc1f0b4e1, BRF_PRG },
};

STD_ROM_PICK(g_pga)
STD_ROM_FN(g_pga)

struct BurnDriver BurnDrvMDg_pga = {
	"g_pga", NULL, NULL, "1991",
	"PGA Tour Golf (USA, Europe) (v1.2)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pgaRomInfo, g_pgaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf II (Japan)
static struct BurnRomInfo g_pga2bRomDesc[] = {
	{ "pga tour golf ii (japan).md", 0x100000, 0xc05b7a4a, BRF_PRG },
};

STD_ROM_PICK(g_pga2b)
STD_ROM_FN(g_pga2b)

struct BurnDriver BurnDrvMDg_pga2b = {
	"g_pga2b", "g_pga2", NULL, "1900",
	"PGA Tour Golf II (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pga2bRomInfo, g_pga2bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf II (USA, Europe) (v1.1)
static struct BurnRomInfo g_pga2RomDesc[] = {
	{ "pga tour golf ii (usa, europe) (v1.1).md", 0x100000, 0xe82b8606, BRF_PRG },
};

STD_ROM_PICK(g_pga2)
STD_ROM_FN(g_pga2)

struct BurnDriver BurnDrvMDg_pga2 = {
	"g_pga2", NULL, NULL, "1992",
	"PGA Tour Golf II (USA, Europe) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pga2RomInfo, g_pga2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf II (USA, Europe)
static struct BurnRomInfo g_pga2aRomDesc[] = {
	{ "pga tour golf ii (usa, europe).md", 0x100000, 0x16b2d816, BRF_PRG },
};

STD_ROM_PICK(g_pga2a)
STD_ROM_FN(g_pga2a)

struct BurnDriver BurnDrvMDg_pga2a = {
	"g_pga2a", "g_pga2", NULL, "1900",
	"PGA Tour Golf II (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pga2aRomInfo, g_pga2aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// PGA Tour Golf III (USA, Europe)
static struct BurnRomInfo g_pga3RomDesc[] = {
	{ "pga tour golf iii (usa, europe).md", 0x200000, 0xaeb3f65f, BRF_PRG },
};

STD_ROM_PICK(g_pga3)
STD_ROM_FN(g_pga3)

struct BurnDriverD BurnDrvMDg_pga3 = {
	"g_pga3", NULL, NULL, "",
	"PGA Tour Golf III (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pga3RomInfo, g_pga3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star - Sennenki no Owari ni (Japan)
static struct BurnRomInfo g_pstr4jRomDesc[] = {
	{ "phantasy star - sennenki no owari ni (japan).md", 0x300000, 0xf0bfad42, BRF_PRG },
};

STD_ROM_PICK(g_pstr4j)
STD_ROM_FN(g_pstr4j)

struct BurnDriver BurnDrvMDg_pstr4j = {
	"g_pstr4j", "g_pstr4", NULL, "1994",
	"Phantasy Star - Sennenki no Owari ni (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr4jRomInfo, g_pstr4jRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_Sks3_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II (Brazil)
static struct BurnRomInfo g_pstr2aRomDesc[] = {
	{ "phantasy star ii (brazil).md", 0xc0000, 0xe6688b66, BRF_PRG },
};

STD_ROM_PICK(g_pstr2a)
STD_ROM_FN(g_pstr2a)

struct BurnDriver BurnDrvMDg_pstr2a = {
	"g_pstr2a", "g_pstr2", NULL, "1989",
	"Phantasy Star II (Brazil)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr2aRomInfo, g_pstr2aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II (USA, Europe) (Rev A)
static struct BurnRomInfo g_pstr2RomDesc[] = {
	{ "phantasy star ii (usa, europe) (rev a).md", 0xc0000, 0x904fa047, BRF_PRG },
};

STD_ROM_PICK(g_pstr2)
STD_ROM_FN(g_pstr2)

struct BurnDriver BurnDrvMDg_pstr2 = {
	"g_pstr2", NULL, NULL, "1989",
	"Phantasy Star II (USA, Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr2RomInfo, g_pstr2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II (USA, Europe)
static struct BurnRomInfo g_pstr2bRomDesc[] = {
	{ "phantasy star ii (usa, europe).md", 0xc0000, 0x0d07d0ef, BRF_PRG },
};

STD_ROM_PICK(g_pstr2b)
STD_ROM_FN(g_pstr2b)

struct BurnDriver BurnDrvMDg_pstr2b = {
	"g_pstr2b", "g_pstr2", NULL, "1989",
	"Phantasy Star II (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr2bRomInfo, g_pstr2bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Amia's Adventure (Japan) (SegaNet)
static struct BurnRomInfo g_ps2aaRomDesc[] = {
	{ "phantasy star ii - amia's adventure (japan) (seganet).md", 0x40000, 0xa3a724aa, BRF_PRG },
};

STD_ROM_PICK(g_ps2aa)
STD_ROM_FN(g_ps2aa)

struct BurnDriverD BurnDrvMDg_ps2aa = {
	"g_ps2aa", NULL, NULL, "",
	"Phantasy Star II - Amia's Adventure (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ps2aaRomInfo, g_ps2aaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Anne's Adventure (Japan) (SegaNet)
static struct BurnRomInfo g_ps2abRomDesc[] = {
	{ "phantasy star ii - anne's adventure (japan) (seganet).md", 0x40000, 0xfafa5b6f, BRF_PRG },
};

STD_ROM_PICK(g_ps2ab)
STD_ROM_FN(g_ps2ab)

struct BurnDriverD BurnDrvMDg_ps2ab = {
	"g_ps2ab", NULL, NULL, "1994",
	"Phantasy Star II - Anne's Adventure (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ps2abRomInfo, g_ps2abRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Huey's Adventure (Japan) (SegaNet)
static struct BurnRomInfo g_ps2acRomDesc[] = {
	{ "phantasy star ii - huey's adventure (japan) (seganet).md", 0x40000, 0x1a076f83, BRF_PRG },
};

STD_ROM_PICK(g_ps2ac)
STD_ROM_FN(g_ps2ac)

struct BurnDriverD BurnDrvMDg_ps2ac = {
	"g_ps2ac", NULL, NULL, "1994",
	"Phantasy Star II - Huey's Adventure (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ps2acRomInfo, g_ps2acRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Kaerazaru Toki no Owari ni (Japan)
static struct BurnRomInfo g_pstr2jRomDesc[] = {
	{ "phantasy star ii - kaerazaru toki no owari ni (japan).md", 0xc0000, 0xbec8eb5a, BRF_PRG },
};

STD_ROM_PICK(g_pstr2j)
STD_ROM_FN(g_pstr2j)

struct BurnDriver BurnDrvMDg_pstr2j = {
	"g_pstr2j", "g_pstr2", NULL, "1989",
	"Phantasy Star II - Kaerazaru Toki no Owari ni (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr2jRomInfo, g_pstr2jRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Kinds's Adventure (Japan) (SegaNet)
static struct BurnRomInfo g_ps2adRomDesc[] = {
	{ "phantasy star ii - kinds's adventure (japan) (seganet).md", 0x40000, 0xc334f308, BRF_PRG },
};

STD_ROM_PICK(g_ps2ad)
STD_ROM_FN(g_ps2ad)

struct BurnDriverD BurnDrvMDg_ps2ad = {
	"g_ps2ad", NULL, NULL, "1994",
	"Phantasy Star II - Kinds's Adventure (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ps2adRomInfo, g_ps2adRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Nei's Adventure (Japan) (SegaNet)
static struct BurnRomInfo g_ps2aeRomDesc[] = {
	{ "phantasy star ii - nei's adventure (japan) (seganet).md", 0x40000, 0x3d9ad465, BRF_PRG },
};

STD_ROM_PICK(g_ps2ae)
STD_ROM_FN(g_ps2ae)

struct BurnDriverD BurnDrvMDg_ps2ae = {
	"g_ps2ae", NULL, NULL, "",
	"Phantasy Star II - Nei's Adventure (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ps2aeRomInfo, g_ps2aeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Rudger's Adventure (Japan) (SegaNet)
static struct BurnRomInfo g_ps2afRomDesc[] = {
	{ "phantasy star ii - rudger's adventure (japan) (seganet).md", 0x40000, 0x6b5916d2, BRF_PRG },
};

STD_ROM_PICK(g_ps2af)
STD_ROM_FN(g_ps2af)

struct BurnDriverD BurnDrvMDg_ps2af = {
	"g_ps2af", NULL, NULL, "",
	"Phantasy Star II - Rudger's Adventure (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ps2afRomInfo, g_ps2afRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Shilka's Adventure (Japan) (SegaNet)
static struct BurnRomInfo g_ps2agRomDesc[] = {
	{ "phantasy star ii - shilka's adventure (japan) (seganet).md", 0x40000, 0x1f83beb2, BRF_PRG },
};

STD_ROM_PICK(g_ps2ag)
STD_ROM_FN(g_ps2ag)

struct BurnDriverD BurnDrvMDg_ps2ag = {
	"g_ps2ag", NULL, NULL, "1994",
	"Phantasy Star II - Shilka's Adventure (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ps2agRomInfo, g_ps2agRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star II - Yushis's Adventure (Japan) (SegaNet)
static struct BurnRomInfo g_ps2ahRomDesc[] = {
	{ "phantasy star ii - yushis's adventure (japan) (seganet).md", 0x40000, 0xd40c76d6, BRF_PRG },
};

STD_ROM_PICK(g_ps2ah)
STD_ROM_FN(g_ps2ah)

struct BurnDriverD BurnDrvMDg_ps2ah = {
	"g_ps2ah", NULL, NULL, "",
	"Phantasy Star II - Yushis's Adventure (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ps2ahRomInfo, g_ps2ahRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star III - Generations of Doom (Brazil)
static struct BurnRomInfo g_pstr3RomDesc[] = {
	{ "phantasy star iii - generations of doom (brazil).md", 0xc0000, 0x2e9b4c23, BRF_PRG },
};

STD_ROM_PICK(g_pstr3)
STD_ROM_FN(g_pstr3)

struct BurnDriver BurnDrvMDg_pstr3 = {
	"g_pstr3", NULL, NULL, "1991",
	"Phantasy Star III - Generations of Doom (Brazil)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr3RomInfo, g_pstr3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star III - Generations of Doom (USA, Europe)
static struct BurnRomInfo g_pstr3aRomDesc[] = {
	{ "phantasy star iii - generations of doom (usa, europe).md", 0xc0000, 0xc6b42b0f, BRF_PRG },
};

STD_ROM_PICK(g_pstr3a)
STD_ROM_FN(g_pstr3a)

struct BurnDriver BurnDrvMDg_pstr3a = {
	"g_pstr3a", "g_pstr3", NULL, "1991",
	"Phantasy Star III - Generations of Doom (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr3aRomInfo, g_pstr3aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star III - Toki no Keishousha (Japan)
static struct BurnRomInfo g_pstr3bRomDesc[] = {
	{ "phantasy star iii - toki no keishousha (japan).md", 0xc0000, 0x6c48c06f, BRF_PRG },
};

STD_ROM_PICK(g_pstr3b)
STD_ROM_FN(g_pstr3b)

struct BurnDriver BurnDrvMDg_pstr3b = {
	"g_pstr3b", "g_pstr3", NULL, "1991",
	"Phantasy Star III - Toki no Keishousha (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr3bRomInfo, g_pstr3bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star IV (Prototype - Aug 15, 1994)
static struct BurnRomInfo g_pstr4aRomDesc[] = {
	{ "phantasy star iv (prototype - aug 15, 1994).md", 0x300000, 0x60137f25, BRF_PRG },
};

STD_ROM_PICK(g_pstr4a)
STD_ROM_FN(g_pstr4a)

struct BurnDriverD BurnDrvMDg_pstr4a = {
	"g_pstr4a", "g_pstr4", NULL, "",
	"Phantasy Star IV (Prototype - Aug 15, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr4aRomInfo, g_pstr4aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star IV (Prototype - Jun 08, 1994)
static struct BurnRomInfo g_pstr4bRomDesc[] = {
	{ "phantasy star iv (prototype - jun 08, 1994).md", 0x300000, 0xdc2e1c0a, BRF_PRG },
};

STD_ROM_PICK(g_pstr4b)
STD_ROM_FN(g_pstr4b)

struct BurnDriverD BurnDrvMDg_pstr4b = {
	"g_pstr4b", "g_pstr4", NULL, "",
	"Phantasy Star IV (Prototype - Jun 08, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr4bRomInfo, g_pstr4bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star IV (Prototype - May 30, 1994)
static struct BurnRomInfo g_pstr4cRomDesc[] = {
	{ "phantasy star iv (prototype - may 30, 1994).md", 0x300000, 0xb32b17e1, BRF_PRG },
};

STD_ROM_PICK(g_pstr4c)
STD_ROM_FN(g_pstr4c)

struct BurnDriverD BurnDrvMDg_pstr4c = {
	"g_pstr4c", "g_pstr4", NULL, "",
	"Phantasy Star IV (Prototype - May 30, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr4cRomInfo, g_pstr4cRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star IV (Prototype - Nov 07, 1994)
static struct BurnRomInfo g_pstr4dRomDesc[] = {
	{ "phantasy star iv (prototype - nov 07, 1994).md", 0x300000, 0xbda29cdf, BRF_PRG },
};

STD_ROM_PICK(g_pstr4d)
STD_ROM_FN(g_pstr4d)

struct BurnDriverD BurnDrvMDg_pstr4d = {
	"g_pstr4d", "g_pstr4", NULL, "",
	"Phantasy Star IV (Prototype - Nov 07, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr4dRomInfo, g_pstr4dRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star IV (Prototype - Oct 27, 1994)
static struct BurnRomInfo g_pstr4eRomDesc[] = {
	{ "phantasy star iv (prototype - oct 27, 1994).md", 0x300000, 0x12a2590a, BRF_PRG },
};

STD_ROM_PICK(g_pstr4e)
STD_ROM_FN(g_pstr4e)

struct BurnDriverD BurnDrvMDg_pstr4e = {
	"g_pstr4e", "g_pstr4", NULL, "",
	"Phantasy Star IV (Prototype - Oct 27, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr4eRomInfo, g_pstr4eRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantasy Star IV (USA)
static struct BurnRomInfo g_pstr4RomDesc[] = {
	{ "phantasy star iv (usa).md", 0x300000, 0xfe236442, BRF_PRG },
};

STD_ROM_PICK(g_pstr4)
STD_ROM_FN(g_pstr4)

struct BurnDriver BurnDrvMDg_pstr4 = {
	"g_pstr4", NULL, NULL, "1994",
	"Phantasy Star IV (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pstr4RomInfo, g_pstr4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_Sks3_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantom 2040 (Europe)
static struct BurnRomInfo g_phantoRomDesc[] = {
	{ "phantom 2040 (europe).md", 0x200000, 0xb024882e, BRF_PRG },
};

STD_ROM_PICK(g_phanto)
STD_ROM_FN(g_phanto)

struct BurnDriver BurnDrvMDg_phanto = {
	"g_phanto", NULL, NULL, "1900",
	"Phantom 2040 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_phantoRomInfo, g_phantoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phantom 2040 (USA)
static struct BurnRomInfo g_phan22RomDesc[] = {
	{ "phantom 2040 (usa).md", 0x200000, 0xfb36e1f3, BRF_PRG },
};

STD_ROM_PICK(g_phan22)
STD_ROM_FN(g_phan22)

struct BurnDriver BurnDrvMDg_phan22 = {
	"g_phan22", "g_phanto", NULL, "1900",
	"Phantom 2040 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_phan22RomInfo, g_phan22RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phelios (Europe)
static struct BurnRomInfo g_phelioRomDesc[] = {
	{ "phelios (europe).md", 0x80000, 0x13abc2b2, BRF_PRG },
};

STD_ROM_PICK(g_phelio)
STD_ROM_FN(g_phelio)

struct BurnDriverD BurnDrvMDg_phelio = {
	"g_phelio", NULL, NULL, "1900",
	"Phelios (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_phelioRomInfo, g_phelioRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phelios (Japan)
static struct BurnRomInfo g_pheli1RomDesc[] = {
	{ "phelios (japan).md", 0x80000, 0x94596174, BRF_PRG },
};

STD_ROM_PICK(g_pheli1)
STD_ROM_FN(g_pheli1)

struct BurnDriverD BurnDrvMDg_pheli1 = {
	"g_pheli1", "g_phelio", NULL, "1900",
	"Phelios (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pheli1RomInfo, g_pheli1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Phelios (USA)
static struct BurnRomInfo g_pheli2RomDesc[] = {
	{ "phelios (usa).md", 0x80000, 0x11c79320, BRF_PRG },
};

STD_ROM_PICK(g_pheli2)
STD_ROM_FN(g_pheli2)

struct BurnDriverD BurnDrvMDg_pheli2 = {
	"g_pheli2", "g_phelio", NULL, "1900",
	"Phelios (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pheli2RomInfo, g_pheli2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pink Goes to Hollywood (USA) (Beta)
static struct BurnRomInfo g_pinkbRomDesc[] = {
	{ "pink goes to hollywood (usa) (beta).md", 0x100000, 0x56087cff, BRF_PRG },
};

STD_ROM_PICK(g_pinkb)
STD_ROM_FN(g_pinkb)

struct BurnDriverD BurnDrvMDg_pinkb = {
	"g_pinkb", "g_pink", NULL, "",
	"Pink Goes to Hollywood (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pinkbRomInfo, g_pinkbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pink Goes to Hollywood (USA)
static struct BurnRomInfo g_pinkRomDesc[] = {
	{ "pink goes to hollywood (usa).md", 0x100000, 0xb5804771, BRF_PRG },
};

STD_ROM_PICK(g_pink)
STD_ROM_FN(g_pink)

struct BurnDriverD BurnDrvMDg_pink = {
	"g_pink", NULL, NULL, "",
	"Pink Goes to Hollywood (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pinkRomInfo, g_pinkRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pinocchio (Europe)
static struct BurnRomInfo g_pinoccRomDesc[] = {
	{ "pinocchio (europe).md", 0x300000, 0x28014bdc, BRF_PRG },
};

STD_ROM_PICK(g_pinocc)
STD_ROM_FN(g_pinocc)

struct BurnDriverD BurnDrvMDg_pinocc = {
	"g_pinocc", NULL, NULL, "1900",
	"Pinocchio (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pinoccRomInfo, g_pinoccRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pinocchio (USA)
static struct BurnRomInfo g_pinoc1RomDesc[] = {
	{ "pinocchio (usa).md", 0x300000, 0xcd4128d8, BRF_PRG },
};

STD_ROM_PICK(g_pinoc1)
STD_ROM_FN(g_pinoc1)

struct BurnDriverD BurnDrvMDg_pinoc1 = {
	"g_pinoc1", "g_pinocc", NULL, "1900",
	"Pinocchio (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pinoc1RomInfo, g_pinoc1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pirates of Dark Water, The (USA) (January 1994)
static struct BurnRomInfo g_pirateRomDesc[] = {
	{ "pirates of dark water, the (usa) (january 1994).md", 0x200000, 0x0c45b9f7, BRF_PRG },
};

STD_ROM_PICK(g_pirate)
STD_ROM_FN(g_pirate)

struct BurnDriverD BurnDrvMDg_pirate = {
	"g_pirate", NULL, NULL, "1900",
	"Pirates of Dark Water, The (USA) (January 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pirateRomInfo, g_pirateRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pirates of Dark Water, The (USA, Europe) (May 1994)
static struct BurnRomInfo g_pirat1RomDesc[] = {
	{ "pirates of dark water, the (usa, europe) (may 1994).md", 0x200000, 0x0a62de34, BRF_PRG },
};

STD_ROM_PICK(g_pirat1)
STD_ROM_FN(g_pirat1)

struct BurnDriverD BurnDrvMDg_pirat1 = {
	"g_pirat1", "g_pirate", NULL, "1900",
	"Pirates of Dark Water, The (USA, Europe) (May 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pirat1RomInfo, g_pirat1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pirates! Gold (USA) (Beta)
static struct BurnRomInfo g_pgoldbRomDesc[] = {
	{ "pirates! gold (usa) (beta).md", 0x100000, 0x0a525641, BRF_PRG },
};

STD_ROM_PICK(g_pgoldb)
STD_ROM_FN(g_pgoldb)

struct BurnDriverD BurnDrvMDg_pgoldb = {
	"g_pgoldb", "g_pgold", NULL, "1900",
	"Pirates! Gold (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pgoldbRomInfo, g_pgoldbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pirates! Gold (USA)
static struct BurnRomInfo g_pgoldRomDesc[] = {
	{ "pirates! gold (usa).md", 0x100000, 0xed50e75c, BRF_PRG },
};

STD_ROM_PICK(g_pgold)
STD_ROM_FN(g_pgold)

struct BurnDriverD BurnDrvMDg_pgold = {
	"g_pgold", NULL, NULL, "1900",
	"Pirates! Gold (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pgoldRomInfo, g_pgoldRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pit-Fighter (World) (Rev A)
static struct BurnRomInfo g_pitfigRomDesc[] = {
	{ "pit-fighter (world) (rev a).md", 0x100000, 0xd48a8b02, BRF_PRG },
};

STD_ROM_PICK(g_pitfig)
STD_ROM_FN(g_pitfig)

struct BurnDriverD BurnDrvMDg_pitfig = {
	"g_pitfig", NULL, NULL, "1900",
	"Pit-Fighter (World) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pitfigRomInfo, g_pitfigRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pit-Fighter (World)
static struct BurnRomInfo g_pitfi1RomDesc[] = {
	{ "pit-fighter (world).md", 0x100000, 0x1e0e0831, BRF_PRG },
};

STD_ROM_PICK(g_pitfi1)
STD_ROM_FN(g_pitfi1)

struct BurnDriverD BurnDrvMDg_pitfi1 = {
	"g_pitfi1", "g_pitfig", NULL, "1900",
	"Pit-Fighter (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pitfi1RomInfo, g_pitfi1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pitfall - The Mayan Adventure (Europe)
static struct BurnRomInfo g_pitfalRomDesc[] = {
	{ "pitfall - the mayan adventure (europe).md", 0x200000, 0xc9198e19, BRF_PRG },
};

STD_ROM_PICK(g_pitfal)
STD_ROM_FN(g_pitfal)

struct BurnDriverD BurnDrvMDg_pitfal = {
	"g_pitfal", NULL, NULL, "1900",
	"Pitfall - The Mayan Adventure (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pitfalRomInfo, g_pitfalRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pitfall - The Mayan Adventure (USA)
static struct BurnRomInfo g_pitfa1RomDesc[] = {
	{ "pitfall - the mayan adventure (usa).md", 0x200000, 0xf917e34f, BRF_PRG },
};

STD_ROM_PICK(g_pitfa1)
STD_ROM_FN(g_pitfa1)

struct BurnDriverD BurnDrvMDg_pitfa1 = {
	"g_pitfa1", "g_pitfal", NULL, "1900",
	"Pitfall - The Mayan Adventure (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pitfa1RomInfo, g_pitfa1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pocahontas (Europe)
static struct BurnRomInfo g_pocahoRomDesc[] = {
	{ "pocahontas (europe).md", 0x400000, 0x165e7987, BRF_PRG },
};

STD_ROM_PICK(g_pocaho)
STD_ROM_FN(g_pocaho)

struct BurnDriverD BurnDrvMDg_pocaho = {
	"g_pocaho", NULL, NULL, "1900",
	"Pocahontas (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pocahoRomInfo, g_pocahoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pocahontas (USA)
static struct BurnRomInfo g_pocah1RomDesc[] = {
	{ "pocahontas (usa).md", 0x400000, 0x6ddd1c6d, BRF_PRG },
};

STD_ROM_PICK(g_pocah1)
STD_ROM_FN(g_pocah1)

struct BurnDriverD BurnDrvMDg_pocah1 = {
	"g_pocah1", "g_pocaho", NULL, "1900",
	"Pocahontas (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pocah1RomInfo, g_pocah1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pocket Monsters (Unl) [!]
static struct BurnRomInfo g_pocketRomDesc[] = {
	{ "pocket monsters (unl) [!].md", 0x200000, 0xf68f6367, BRF_PRG },
};

STD_ROM_PICK(g_pocket)
STD_ROM_FN(g_pocket)

struct BurnDriverD BurnDrvMDg_pocket = {
	"g_pocket", NULL, NULL, "",
	"Pocket Monsters (Unl) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pocketRomInfo, g_pocketRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pocket Monsters (Unl) [a1][!]
static struct BurnRomInfo g_pocke1RomDesc[] = {
	{ "pocket monsters (unl) [a1][!].md", 0x200000, 0xfb176667, BRF_PRG },
};

STD_ROM_PICK(g_pocke1)
STD_ROM_FN(g_pocke1)

struct BurnDriverD BurnDrvMDg_pocke1 = {
	"g_pocke1", "g_pocket", NULL, "",
	"Pocket Monsters (Unl) [a1][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pocke1RomInfo, g_pocke1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pocket Monsters 2 (Unl) [!]
static struct BurnRomInfo g_pocke2RomDesc[] = {
	{ "pocket monsters 2 (unl) [!].md", 0x200000, 0x30f7031f, BRF_PRG },
};

STD_ROM_PICK(g_pocke2)
STD_ROM_FN(g_pocke2)

struct BurnDriverD BurnDrvMDg_pocke2 = {
	"g_pocke2", NULL, NULL, "",
	"Pocket Monsters 2 (Unl) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pocke2RomInfo, g_pocke2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pokemon Crazy Drummer (Unl)
static struct BurnRomInfo g_pokemoRomDesc[] = {
	{ "pokemon crazy drummer (unl).md", 0x200000, 0x8838a25d, BRF_PRG },
};

STD_ROM_PICK(g_pokemo)
STD_ROM_FN(g_pokemo)

struct BurnDriverD BurnDrvMDg_pokemo = {
	"g_pokemo", NULL, NULL, "",
	"Pokemon Crazy Drummer (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pokemoRomInfo, g_pokemoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pokemon Stadium (Unl)
static struct BurnRomInfo g_pokem1RomDesc[] = {
	{ "pokemon stadium (unl).md", 0x200000, 0xfe187c5d, BRF_PRG },
};

STD_ROM_PICK(g_pokem1)
STD_ROM_FN(g_pokem1)

struct BurnDriverD BurnDrvMDg_pokem1 = {
	"g_pokem1", NULL, NULL, "",
	"Pokemon Stadium (Unl)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pokem1RomInfo, g_pokem1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Populous (Europe)
static struct BurnRomInfo g_populoRomDesc[] = {
	{ "populous (europe).md", 0x80000, 0x83d56f64, BRF_PRG },
};

STD_ROM_PICK(g_populo)
STD_ROM_FN(g_populo)

struct BurnDriverD BurnDrvMDg_populo = {
	"g_populo", NULL, NULL, "1900",
	"Populous (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_populoRomInfo, g_populoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Populous (Japan)
static struct BurnRomInfo g_popul1RomDesc[] = {
	{ "populous (japan).md", 0x80000, 0x97c26818, BRF_PRG },
};

STD_ROM_PICK(g_popul1)
STD_ROM_FN(g_popul1)

struct BurnDriverD BurnDrvMDg_popul1 = {
	"g_popul1", "g_populo", NULL, "1900",
	"Populous (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_popul1RomInfo, g_popul1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Populous (USA)
static struct BurnRomInfo g_popul2RomDesc[] = {
	{ "populous (usa).md", 0x80000, 0xbd74b31e, BRF_PRG },
};

STD_ROM_PICK(g_popul2)
STD_ROM_FN(g_popul2)

struct BurnDriverD BurnDrvMDg_popul2 = {
	"g_popul2", "g_populo", NULL, "1900",
	"Populous (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_popul2RomInfo, g_popul2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Power Athlete (Japan, Korea)
static struct BurnRomInfo g_poweraRomDesc[] = {
	{ "power athlete (japan, korea).md", 0x100000, 0xb41b77cf, BRF_PRG },
};

STD_ROM_PICK(g_powera)
STD_ROM_FN(g_powera)

struct BurnDriverD BurnDrvMDg_powera = {
	"g_powera", "g_deadly", NULL, "1900",
	"Power Athlete (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_poweraRomInfo, g_poweraRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Power Drive (Europe) (En,Fr,De,Es,Pt)
static struct BurnRomInfo g_powerdRomDesc[] = {
	{ "power drive (europe) (en,fr,de,es,pt).md", 0x100000, 0x8c00ad61, BRF_PRG },
};

STD_ROM_PICK(g_powerd)
STD_ROM_FN(g_powerd)

struct BurnDriverD BurnDrvMDg_powerd = {
	"g_powerd", NULL, NULL, "1900",
	"Power Drive (Europe) (En,Fr,De,Es,Pt)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_powerdRomInfo, g_powerdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Power Monger (Japan, Korea)
static struct BurnRomInfo g_pmongjRomDesc[] = {
	{ "power monger (japan, korea).md", 0x100000, 0x553289b3, BRF_PRG },
};

STD_ROM_PICK(g_pmongj)
STD_ROM_FN(g_pmongj)

struct BurnDriverD BurnDrvMDg_pmongj = {
	"g_pmongj", "g_pmong", NULL, "1900",
	"Power Monger (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pmongjRomInfo, g_pmongjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Power Monger (USA, Europe)
static struct BurnRomInfo g_pmongRomDesc[] = {
	{ "power monger (usa, europe).md", 0x100000, 0xfb599b86, BRF_PRG },
};

STD_ROM_PICK(g_pmong)
STD_ROM_FN(g_pmong)

struct BurnDriverD BurnDrvMDg_pmong = {
	"g_pmong", NULL, NULL, "1900",
	"Power Monger (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pmongRomInfo, g_pmongRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Powerball (USA)
static struct BurnRomInfo g_powerbRomDesc[] = {
	{ "powerball (usa).md", 0x80000, 0x7adf232f, BRF_PRG },
};

STD_ROM_PICK(g_powerb)
STD_ROM_FN(g_powerb)

struct BurnDriverD BurnDrvMDg_powerb = {
	"g_powerb", NULL, NULL, "1900",
	"Powerball (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_powerbRomInfo, g_powerbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Predator 2 (USA, Europe)
static struct BurnRomInfo g_predatRomDesc[] = {
	{ "predator 2 (usa, europe).md", 0x100000, 0xbdba113e, BRF_PRG },
};

STD_ROM_PICK(g_predat)
STD_ROM_FN(g_predat)

struct BurnDriverD BurnDrvMDg_predat = {
	"g_predat", NULL, NULL, "1900",
	"Predator 2 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_predatRomInfo, g_predatRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Premier Manager (Europe)
static struct BurnRomInfo g_premieRomDesc[] = {
	{ "premier manager (europe).md", 0x100000, 0x303b889f, BRF_PRG },
};

STD_ROM_PICK(g_premie)
STD_ROM_FN(g_premie)

struct BurnDriver BurnDrvMDg_premie = {
	"g_premie", NULL, NULL, "1900",
	"Premier Manager (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_premieRomInfo, g_premieRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Premier Manager 97 (Europe)
static struct BurnRomInfo g_prem97RomDesc[] = {
	{ "premier manager 97 (europe).md", 0x100000, 0xfccbf69b, BRF_PRG },
};

STD_ROM_PICK(g_prem97)
STD_ROM_FN(g_prem97)

struct BurnDriver BurnDrvMDg_prem97 = {
	"g_prem97", NULL, NULL, "1900",
	"Premier Manager 97 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prem97RomInfo, g_prem97RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pretty Girl Mahjongg (Ch)
static struct BurnRomInfo g_prettyRomDesc[] = {
	{ "pretty girl mahjongg (ch).md", 0x100000, 0x69f24500, BRF_PRG },
};

STD_ROM_PICK(g_pretty)
STD_ROM_FN(g_pretty)

struct BurnDriverD BurnDrvMDg_pretty = {
	"g_pretty", NULL, NULL, "",
	"Pretty Girl Mahjongg (Ch)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prettyRomInfo, g_prettyRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Primal Rage (USA, Europe)
static struct BurnRomInfo g_primalRomDesc[] = {
	{ "primal rage (usa, europe).md", 0x300000, 0x2884c6d1, BRF_PRG },
};

STD_ROM_PICK(g_primal)
STD_ROM_FN(g_primal)

struct BurnDriverD BurnDrvMDg_primal = {
	"g_primal", NULL, NULL, "1900",
	"Primal Rage (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_primalRomInfo, g_primalRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Prime Time NFL Starring Deion Sanders (USA)
static struct BurnRomInfo g_primetRomDesc[] = {
	{ "prime time nfl starring deion sanders (usa).md", 0x200000, 0x5aa53cbc, BRF_PRG },
};

STD_ROM_PICK(g_primet)
STD_ROM_FN(g_primet)

struct BurnDriver BurnDrvMDg_primet = {
	"g_primet", NULL, NULL, "1995",
	"Prime Time NFL Starring Deion Sanders (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_primetRomInfo, g_primetRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Prince of Persia (Europe) (Beta) (Earlier)
static struct BurnRomInfo g_prinp1RomDesc[] = {
	{ "prince of persia (europe) (beta) (earlier).md", 0x40000, 0x425e6a87, BRF_PRG },
};

STD_ROM_PICK(g_prinp1)
STD_ROM_FN(g_prinp1)

struct BurnDriverD BurnDrvMDg_prinp1 = {
	"g_prinp1", "g_prinp", NULL, "1993",
	"Prince of Persia (Europe) (Beta) (Earlier)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prinp1RomInfo, g_prinp1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Prince of Persia (Europe) (Beta)
static struct BurnRomInfo g_prinp2RomDesc[] = {
	{ "prince of persia (europe) (beta).md", 0x100000, 0x505314b6, BRF_PRG },
};

STD_ROM_PICK(g_prinp2)
STD_ROM_FN(g_prinp2)

struct BurnDriverD BurnDrvMDg_prinp2 = {
	"g_prinp2", "g_prinp", NULL, "1993",
	"Prince of Persia (Europe) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prinp2RomInfo, g_prinp2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Prince of Persia (Europe)
static struct BurnRomInfo g_prinpRomDesc[] = {
	{ "prince of persia (europe).md", 0x100000, 0x61de6fe0, BRF_PRG },
};

STD_ROM_PICK(g_prinp)
STD_ROM_FN(g_prinp)

struct BurnDriverD BurnDrvMDg_prinp = {
	"g_prinp", NULL, NULL, "1993",
	"Prince of Persia (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prinpRomInfo, g_prinpRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Prince of Persia (USA)
static struct BurnRomInfo g_prinp3RomDesc[] = {
	{ "prince of persia (usa).md", 0x100000, 0x13c181a4, BRF_PRG },
};

STD_ROM_PICK(g_prinp3)
STD_ROM_FN(g_prinp3)

struct BurnDriverD BurnDrvMDg_prinp3 = {
	"g_prinp3", "g_prinp", NULL, "1993",
	"Prince of Persia (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prinp3RomInfo, g_prinp3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Prince of Persia 2 - The Shadow and the Flame (Europe) (Proto)
static struct BurnRomInfo g_prin2RomDesc[] = {
	{ "prince of persia 2 - the shadow and the flame (europe) (proto).md", 0x200000, 0x3ab44d46, BRF_PRG },
};

STD_ROM_PICK(g_prin2)
STD_ROM_FN(g_prin2)

struct BurnDriverD BurnDrvMDg_prin2 = {
	"g_prin2", NULL, NULL, "1900",
	"Prince of Persia 2 - The Shadow and the Flame (Europe) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_prin2RomInfo, g_prin2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pro Action Replay (Europe) (Program)
static struct BurnRomInfo g_proactRomDesc[] = {
	{ "pro action replay (europe) (program).md", 0x20000, 0x17255224, BRF_PRG },
};

STD_ROM_PICK(g_proact)
STD_ROM_FN(g_proact)

struct BurnDriverD BurnDrvMDg_proact = {
	"g_proact", NULL, NULL, "",
	"Pro Action Replay (Europe) (Program)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_proactRomInfo, g_proactRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pro Action Replay 2 (Europe) (Alt) (Program)
static struct BurnRomInfo g_proa2RomDesc[] = {
	{ "pro action replay 2 (europe) (alt) (program).md", 0x10000, 0xe6669a61, BRF_PRG },
};

STD_ROM_PICK(g_proa2)
STD_ROM_FN(g_proa2)

struct BurnDriverD BurnDrvMDg_proa2 = {
	"g_proa2", NULL, NULL, "",
	"Pro Action Replay 2 (Europe) (Alt) (Program)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_proa2RomInfo, g_proa2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pro Action Replay 2 (Europe) (Program)
static struct BurnRomInfo g_proa2aRomDesc[] = {
	{ "pro action replay 2 (europe) (program).md", 0x10000, 0xa73abd27, BRF_PRG },
};

STD_ROM_PICK(g_proa2a)
STD_ROM_FN(g_proa2a)

struct BurnDriverD BurnDrvMDg_proa2a = {
	"g_proa2a", "g_proa2", NULL, "",
	"Pro Action Replay 2 (Europe) (Program)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_proa2aRomInfo, g_proa2aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pro Quarterback (USA)
static struct BurnRomInfo g_proquaRomDesc[] = {
	{ "pro quarterback (usa).md", 0x100000, 0xcc8b2b69, BRF_PRG },
};

STD_ROM_PICK(g_proqua)
STD_ROM_FN(g_proqua)

struct BurnDriverD BurnDrvMDg_proqua = {
	"g_proqua", NULL, NULL, "1900",
	"Pro Quarterback (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_proquaRomInfo, g_proquaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pro Yakyuu Super League '91 (Japan)
static struct BurnRomInfo g_proyakRomDesc[] = {
	{ "pro yakyuu super league '91 (japan).md", 0x80000, 0xa948ab7e, BRF_PRG },
};

STD_ROM_PICK(g_proyak)
STD_ROM_FN(g_proyak)

struct BurnDriver BurnDrvMDg_proyak = {
	"g_proyak", NULL, NULL, "1900",
	"Pro Yakyuu Super League '91 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_proyakRomInfo, g_proyakRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Probotector (Europe)
static struct BurnRomInfo g_probotRomDesc[] = {
	{ "probotector (europe).md", 0x200000, 0xbc597d48, BRF_PRG },
};

STD_ROM_PICK(g_probot)
STD_ROM_FN(g_probot)

struct BurnDriverD BurnDrvMDg_probot = {
	"g_probot", NULL, NULL, "1994",
	"Probotector (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_probotRomInfo, g_probotRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Psy-O-Blade (Japan)
static struct BurnRomInfo g_psyoblRomDesc[] = {
	{ "psy-o-blade (japan).md", 0xa0000, 0x8ba7e6c5, BRF_PRG },
};

STD_ROM_PICK(g_psyobl)
STD_ROM_FN(g_psyobl)

struct BurnDriverD BurnDrvMDg_psyobl = {
	"g_psyobl", NULL, NULL, "",
	"Psy-O-Blade (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_psyoblRomInfo, g_psyoblRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Psycho Pinball (Europe) (En,Fr,De,Es,It) (October 1994)
static struct BurnRomInfo g_psychoRomDesc[] = {
	{ "psycho pinball (europe) (en,fr,de,es,it) (october 1994).md", 0x180000, 0xd704784b, BRF_PRG },
};

STD_ROM_PICK(g_psycho)
STD_ROM_FN(g_psycho)

struct BurnDriverD BurnDrvMDg_psycho = {
	"g_psycho", NULL, NULL, "1900",
	"Psycho Pinball (Europe) (En,Fr,De,Es,It) (October 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_psychoRomInfo, g_psychoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Psycho Pinball (Europe) (En,Fr,De,Es,It) (September 1994)
static struct BurnRomInfo g_psych1RomDesc[] = {
	{ "psycho pinball (europe) (en,fr,de,es,it) (september 1994).md", 0x180000, 0x11e9c3f2, BRF_PRG },
};

STD_ROM_PICK(g_psych1)
STD_ROM_FN(g_psych1)

struct BurnDriverD BurnDrvMDg_psych1 = {
	"g_psych1", "g_psycho", NULL, "1900",
	"Psycho Pinball (Europe) (En,Fr,De,Es,It) (September 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_psych1RomInfo, g_psych1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Puggsy (Beta)
static struct BurnRomInfo g_puggsbRomDesc[] = {
	{ "puggsy (beta).md", 0x100000, 0x37fa4877, BRF_PRG },
};

STD_ROM_PICK(g_puggsb)
STD_ROM_FN(g_puggsb)

struct BurnDriverD BurnDrvMDg_puggsb = {
	"g_puggsb", "g_puggs", NULL, "1900",
	"Puggsy (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_puggsbRomInfo, g_puggsbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Puggsy (Europe)
static struct BurnRomInfo g_puggsRomDesc[] = {
	{ "puggsy (europe).md", 0x100000, 0x5d5c9ade, BRF_PRG },
};

STD_ROM_PICK(g_puggs)
STD_ROM_FN(g_puggs)

struct BurnDriverD BurnDrvMDg_puggs = {
	"g_puggs", NULL, NULL, "1900",
	"Puggsy (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_puggsRomInfo, g_puggsRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Puggsy (USA)
static struct BurnRomInfo g_puggsuRomDesc[] = {
	{ "puggsy (usa).md", 0x100000, 0x70132168, BRF_PRG },
};

STD_ROM_PICK(g_puggsu)
STD_ROM_FN(g_puggsu)

struct BurnDriverD BurnDrvMDg_puggsu = {
	"g_puggsu", "g_puggs", NULL, "1900",
	"Puggsy (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_puggsuRomInfo, g_puggsuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pulseman (Japan)
static struct BurnRomInfo g_pulsemRomDesc[] = {
	{ "pulseman (japan).md", 0x200000, 0x138a104e, BRF_PRG },
};

STD_ROM_PICK(g_pulsem)
STD_ROM_FN(g_pulsem)

struct BurnDriverD BurnDrvMDg_pulsem = {
	"g_pulsem", NULL, NULL, "1900",
	"Pulseman (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pulsemRomInfo, g_pulsemRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Punisher, The (Europe)
static struct BurnRomInfo g_punishRomDesc[] = {
	{ "punisher, the (europe).md", 0x200000, 0x729edd17, BRF_PRG },
};

STD_ROM_PICK(g_punish)
STD_ROM_FN(g_punish)

struct BurnDriverD BurnDrvMDg_punish = {
	"g_punish", NULL, NULL, "1900",
	"Punisher, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_punishRomInfo, g_punishRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Punisher, The (USA)
static struct BurnRomInfo g_punis1RomDesc[] = {
	{ "punisher, the (usa).md", 0x200000, 0x695cd8b8, BRF_PRG },
};

STD_ROM_PICK(g_punis1)
STD_ROM_FN(g_punis1)

struct BurnDriverD BurnDrvMDg_punis1 = {
	"g_punis1", "g_punish", NULL, "1900",
	"Punisher, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_punis1RomInfo, g_punis1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Putter Golf (Japan) (SegaNet)
static struct BurnRomInfo g_putterRomDesc[] = {
	{ "putter golf (japan) (seganet).md", 0x40000, 0x20f168a6, BRF_PRG },
};

STD_ROM_PICK(g_putter)
STD_ROM_FN(g_putter)

struct BurnDriverD BurnDrvMDg_putter = {
	"g_putter", NULL, NULL, "",
	"Putter Golf (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_putterRomInfo, g_putterRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Putter Golf (SN) (GNKO) (J) [!]
static struct BurnRomInfo g_putte1RomDesc[] = {
	{ "putter golf (sn) (gnko) (j) [!].md", 0x40000, 0xa6557faa, BRF_PRG },
};

STD_ROM_PICK(g_putte1)
STD_ROM_FN(g_putte1)

struct BurnDriverD BurnDrvMDg_putte1 = {
	"g_putte1", "g_putter", NULL, "",
	"Putter Golf (SN) (GNKO) (J) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_putte1RomInfo, g_putte1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Puyo Puyo (Japan)
static struct BurnRomInfo g_puyopuRomDesc[] = {
	{ "puyo puyo (japan).md", 0x80000, 0x7f26614e, BRF_PRG },
};

STD_ROM_PICK(g_puyopu)
STD_ROM_FN(g_puyopu)

struct BurnDriverD BurnDrvMDg_puyopu = {
	"g_puyopu", NULL, NULL, "1900",
	"Puyo Puyo (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_puyopuRomInfo, g_puyopuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Puyo Puyo 2 (Japan) (v1.1)
static struct BurnRomInfo g_puyo2RomDesc[] = {
	{ "puyo puyo 2 (japan) (v1.1).md", 0x200000, 0x25b7b2aa, BRF_PRG },
};

STD_ROM_PICK(g_puyo2)
STD_ROM_FN(g_puyo2)

struct BurnDriverD BurnDrvMDg_puyo2 = {
	"g_puyo2", NULL, NULL, "1900",
	"Puyo Puyo 2 (Japan) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_puyo2RomInfo, g_puyo2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Puyo Puyo 2 (Japan)
static struct BurnRomInfo g_puyo2aRomDesc[] = {
	{ "puyo puyo 2 (japan).md", 0x200000, 0x51ad7797, BRF_PRG },
};

STD_ROM_PICK(g_puyo2a)
STD_ROM_FN(g_puyo2a)

struct BurnDriverD BurnDrvMDg_puyo2a = {
	"g_puyo2a", "g_puyo2", NULL, "1900",
	"Puyo Puyo 2 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_puyo2aRomInfo, g_puyo2aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Puzzle & Action - Ichidanto-R (Japan)
static struct BurnRomInfo g_ichirRomDesc[] = {
	{ "puzzle & action - ichidanto-r (japan).md", 0x200000, 0x7bdec762, BRF_PRG },
};

STD_ROM_PICK(g_ichir)
STD_ROM_FN(g_ichir)

struct BurnDriverD BurnDrvMDg_ichir = {
	"g_ichir", NULL, NULL, "",
	"Puzzle & Action - Ichidanto-R (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ichirRomInfo, g_ichirRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Puzzle & Action - Tanto-R (Japan)
static struct BurnRomInfo g_tantrRomDesc[] = {
	{ "puzzle & action - tanto-r (japan).md", 0x200000, 0xd2d2d437, BRF_PRG },
};

STD_ROM_PICK(g_tantr)
STD_ROM_FN(g_tantr)

struct BurnDriverD BurnDrvMDg_tantr = {
	"g_tantr", NULL, NULL, "1900",
	"Puzzle & Action - Tanto-R (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_tantrRomInfo, g_tantrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pyramid Magic (Japan) (SegaNet)
static struct BurnRomInfo g_pyramiRomDesc[] = {
	{ "pyramid magic (japan) (seganet).md", 0x40000, 0x306d839e, BRF_PRG },
};

STD_ROM_PICK(g_pyrami)
STD_ROM_FN(g_pyrami)

struct BurnDriverD BurnDrvMDg_pyrami = {
	"g_pyrami", NULL, NULL, "1994",
	"Pyramid Magic (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pyramiRomInfo, g_pyramiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pyramid Magic (SN) (GNKO) (J) [!]
static struct BurnRomInfo g_pyram1RomDesc[] = {
	{ "pyramid magic (sn) (gnko) (j) [!].md", 0x40000, 0xb20272ea, BRF_PRG },
};

STD_ROM_PICK(g_pyram1)
STD_ROM_FN(g_pyram1)

struct BurnDriverD BurnDrvMDg_pyram1 = {
	"g_pyram1", "g_pyrami", NULL, "",
	"Pyramid Magic (SN) (GNKO) (J) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pyram1RomInfo, g_pyram1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pyramid Magic II (Japan) (SegaNet)
static struct BurnRomInfo g_pyram2RomDesc[] = {
	{ "pyramid magic ii (japan) (seganet).md", 0x40000, 0xc9ddac72, BRF_PRG },
};

STD_ROM_PICK(g_pyram2)
STD_ROM_FN(g_pyram2)

struct BurnDriverD BurnDrvMDg_pyram2 = {
	"g_pyram2", NULL, NULL, "1994",
	"Pyramid Magic II (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pyram2RomInfo, g_pyram2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pyramid Magic III (Japan) (SegaNet)
static struct BurnRomInfo g_pyram3RomDesc[] = {
	{ "pyramid magic iii (japan) (seganet).md", 0x40000, 0x8329820a, BRF_PRG },
};

STD_ROM_PICK(g_pyram3)
STD_ROM_FN(g_pyram3)

struct BurnDriverD BurnDrvMDg_pyram3 = {
	"g_pyram3", NULL, NULL, "1994",
	"Pyramid Magic III (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pyram3RomInfo, g_pyram3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Pyramid Magic Special (Japan) (SegaNet)
static struct BurnRomInfo g_pyram4RomDesc[] = {
	{ "pyramid magic special (japan) (seganet).md", 0x40000, 0x153a3afa, BRF_PRG },
};

STD_ROM_PICK(g_pyram4)
STD_ROM_FN(g_pyram4)

struct BurnDriverD BurnDrvMDg_pyram4 = {
	"g_pyram4", NULL, NULL, "1994",
	"Pyramid Magic Special (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_pyram4RomInfo, g_pyram4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// QuackShot Starring Donald Duck ~ QuackShot - Guruzia Ou no Hihou (World) (REV01) [a1][c][!]
static struct BurnRomInfo g_quacksRomDesc[] = {
	{ "quackshot starring donald duck ~ quackshot - guruzia ou no hihou (world) (rev01) [a1][c][!].md", 0x140000, 0xa5c946b3, BRF_PRG },
};

STD_ROM_PICK(g_quacks)
STD_ROM_FN(g_quacks)

struct BurnDriverD BurnDrvMDg_quacks = {
	"g_quacks", NULL, NULL, "1994",
	"QuackShot Starring Donald Duck ~ QuackShot - Guruzia Ou no Hihou (World) (REV01) [a1][c][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_quacksRomInfo, g_quacksRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// QuackShot Starring Donald Duck ~ QuackShot - Guruzia Ou no Hihou (World) (v1.1)
static struct BurnRomInfo g_quack1RomDesc[] = {
	{ "quackshot starring donald duck ~ quackshot - guruzia ou no hihou (world) (v1.1).md", 0x140000, 0x1801098b, BRF_PRG },
};

STD_ROM_PICK(g_quack1)
STD_ROM_FN(g_quack1)

struct BurnDriverD BurnDrvMDg_quack1 = {
	"g_quack1", "g_quacks", NULL, "1991",
	"QuackShot Starring Donald Duck ~ QuackShot - Guruzia Ou no Hihou (World) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_quack1RomInfo, g_quack1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// QuackShot Starring Donald Duck ~ QuackShot - Guruzia Ou no Hihou (World)
static struct BurnRomInfo g_quack2RomDesc[] = {
	{ "quackshot starring donald duck ~ quackshot - guruzia ou no hihou (world).md", 0x80000, 0x88c8dd94, BRF_PRG },
};

STD_ROM_PICK(g_quack2)
STD_ROM_FN(g_quack2)

struct BurnDriverD BurnDrvMDg_quack2 = {
	"g_quack2", "g_quacks", NULL, "1994",
	"QuackShot Starring Donald Duck ~ QuackShot - Guruzia Ou no Hihou (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_quack2RomInfo, g_quack2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Quad Challenge (USA)
static struct BurnRomInfo g_quadchRomDesc[] = {
	{ "quad challenge (usa).md", 0x80000, 0x74736a80, BRF_PRG },
};

STD_ROM_PICK(g_quadch)
STD_ROM_FN(g_quadch)

struct BurnDriverD BurnDrvMDg_quadch = {
	"g_quadch", NULL, NULL, "1900",
	"Quad Challenge (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_quadchRomInfo, g_quadchRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// R.B.I. Baseball '93 (USA)
static struct BurnRomInfo g_rbi93RomDesc[] = {
	{ "r.b.i. baseball '93 (usa).md", 0x100000, 0xbeafce84, BRF_PRG },
};

STD_ROM_PICK(g_rbi93)
STD_ROM_FN(g_rbi93)

struct BurnDriverD BurnDrvMDg_rbi93 = {
	"g_rbi93", NULL, NULL, "1900",
	"R.B.I. Baseball '93 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rbi93RomInfo, g_rbi93RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// R.B.I. Baseball '94 (USA, Europe)
static struct BurnRomInfo g_rbi94RomDesc[] = {
	{ "r.b.i. baseball '94 (usa, europe).md", 0x200000, 0x4eb4d5e4, BRF_PRG },
};

STD_ROM_PICK(g_rbi94)
STD_ROM_FN(g_rbi94)

struct BurnDriverD BurnDrvMDg_rbi94 = {
	"g_rbi94", NULL, NULL, "1900",
	"R.B.I. Baseball '94 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rbi94RomInfo, g_rbi94RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// R.B.I. Baseball 3 (USA)
static struct BurnRomInfo g_rbi4RomDesc[] = {
	{ "r.b.i. baseball 3 (usa).md", 0x80000, 0x4840348c, BRF_PRG },
};

STD_ROM_PICK(g_rbi4)
STD_ROM_FN(g_rbi4)

struct BurnDriverD BurnDrvMDg_rbi4 = {
	"g_rbi4", NULL, NULL, "1900",
	"R.B.I. Baseball 3 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rbi4RomInfo, g_rbi4RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// R.B.I. Baseball 4 (Japan)
static struct BurnRomInfo g_rbi4jRomDesc[] = {
	{ "r.b.i. baseball 4 (japan).md", 0x100000, 0x8f4e1005, BRF_PRG },
};

STD_ROM_PICK(g_rbi4j)
STD_ROM_FN(g_rbi4j)

struct BurnDriverD BurnDrvMDg_rbi4j = {
	"g_rbi4j", NULL, NULL, "",
	"R.B.I. Baseball 4 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rbi4jRomInfo, g_rbi4jRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// R.B.I. Baseball 4 (USA)
static struct BurnRomInfo g_rbi4uRomDesc[] = {
	{ "r.b.i. baseball 4 (usa).md", 0x100000, 0xfecf9b94, BRF_PRG },
};

STD_ROM_PICK(g_rbi4u)
STD_ROM_FN(g_rbi4u)

struct BurnDriverD BurnDrvMDg_rbi4u = {
	"g_rbi4u", "g_rbi4j", NULL, "1900",
	"R.B.I. Baseball 4 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rbi4uRomInfo, g_rbi4uRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Race Drivin' (USA)
static struct BurnRomInfo g_racedrRomDesc[] = {
	{ "race drivin' (usa).md", 0x80000, 0xd737cf3d, BRF_PRG },
};

STD_ROM_PICK(g_racedr)
STD_ROM_FN(g_racedr)

struct BurnDriverD BurnDrvMDg_racedr = {
	"g_racedr", NULL, NULL, "1993",
	"Race Drivin' (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_racedrRomInfo, g_racedrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Radical Rex (Europe)
static struct BurnRomInfo g_radicaRomDesc[] = {
	{ "radical rex (europe).md", 0x100000, 0xd02d3282, BRF_PRG },
};

STD_ROM_PICK(g_radica)
STD_ROM_FN(g_radica)

struct BurnDriverD BurnDrvMDg_radica = {
	"g_radica", NULL, NULL, "1900",
	"Radical Rex (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_radicaRomInfo, g_radicaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Radical Rex (USA)
static struct BurnRomInfo g_radic1RomDesc[] = {
	{ "radical rex (usa).md", 0x100000, 0x2e6eec7e, BRF_PRG },
};

STD_ROM_PICK(g_radic1)
STD_ROM_FN(g_radic1)

struct BurnDriverD BurnDrvMDg_radic1 = {
	"g_radic1", "g_radica", NULL, "1900",
	"Radical Rex (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_radic1RomInfo, g_radic1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ragnacenty (Korea)
static struct BurnRomInfo g_ragnacRomDesc[] = {
	{ "ragnacenty (korea).md", 0x200000, 0x77b5b10b, BRF_PRG },
};

STD_ROM_PICK(g_ragnac)
STD_ROM_FN(g_ragnac)

struct BurnDriver BurnDrvMDg_ragnac = {
	"g_ragnac", "g_soleil", NULL, "1994",
	"Ragnacenty (Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ragnacRomInfo, g_ragnacRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Raiden Densetsu ~ Raiden Trad (Japan, USA)
static struct BurnRomInfo g_raidenRomDesc[] = {
	{ "raiden densetsu ~ raiden trad (japan, usa).md", 0x100000, 0xf839a811, BRF_PRG },
};

STD_ROM_PICK(g_raiden)
STD_ROM_FN(g_raiden)

struct BurnDriverD BurnDrvMDg_raiden = {
	"g_raiden", NULL, NULL, "1900",
	"Raiden Densetsu ~ Raiden Trad (Japan, USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_raidenRomInfo, g_raidenRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rainbow Islands Extra (Japan)
static struct BurnRomInfo g_rainboRomDesc[] = {
	{ "rainbow islands extra (japan).md", 0x80000, 0xc74dcb35, BRF_PRG },
};

STD_ROM_PICK(g_rainbo)
STD_ROM_FN(g_rainbo)

struct BurnDriverD BurnDrvMDg_rainbo = {
	"g_rainbo", NULL, NULL, "1900",
	"Rainbow Islands Extra (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rainboRomInfo, g_rainboRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rambo III (World) (v1.1)
static struct BurnRomInfo g_ramboiRomDesc[] = {
	{ "rambo iii (world) (v1.1).md", 0x40000, 0x4d47a647, BRF_PRG },
};

STD_ROM_PICK(g_ramboi)
STD_ROM_FN(g_ramboi)

struct BurnDriverD BurnDrvMDg_ramboi = {
	"g_ramboi", NULL, NULL, "1900",
	"Rambo III (World) (v1.1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ramboiRomInfo, g_ramboiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rambo III (World)
static struct BurnRomInfo g_rambo1RomDesc[] = {
	{ "rambo iii (world).md", 0x40000, 0x2232f03d, BRF_PRG },
};

STD_ROM_PICK(g_rambo1)
STD_ROM_FN(g_rambo1)

struct BurnDriverD BurnDrvMDg_rambo1 = {
	"g_rambo1", "g_ramboi", NULL, "1900",
	"Rambo III (World)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rambo1RomInfo, g_rambo1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rampart (Japan, Korea)
static struct BurnRomInfo g_rampjRomDesc[] = {
	{ "rampart (japan, korea).md", 0x80000, 0x16ead64c, BRF_PRG },
};

STD_ROM_PICK(g_rampj)
STD_ROM_FN(g_rampj)

struct BurnDriverD BurnDrvMDg_rampj = {
	"g_rampj", "g_ramp", NULL, "",
	"Rampart (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rampjRomInfo, g_rampjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rampart (USA)
static struct BurnRomInfo g_rampRomDesc[] = {
	{ "rampart (usa).md", 0x80000, 0x9c4dd057, BRF_PRG },
};

STD_ROM_PICK(g_ramp)
STD_ROM_FN(g_ramp)

struct BurnDriverD BurnDrvMDg_ramp = {
	"g_ramp", NULL, NULL, "",
	"Rampart (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rampRomInfo, g_rampRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ranger-X (Europe)
static struct BurnRomInfo g_rangerRomDesc[] = {
	{ "ranger-x (europe).md", 0x100000, 0xb8c04804, BRF_PRG },
};

STD_ROM_PICK(g_ranger)
STD_ROM_FN(g_ranger)

struct BurnDriverD BurnDrvMDg_ranger = {
	"g_ranger", NULL, NULL, "1993",
	"Ranger-X (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rangerRomInfo, g_rangerRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ranger-X (USA)
static struct BurnRomInfo g_range1RomDesc[] = {
	{ "ranger-x (usa).md", 0x100000, 0x55915915, BRF_PRG },
};

STD_ROM_PICK(g_range1)
STD_ROM_FN(g_range1)

struct BurnDriverD BurnDrvMDg_range1 = {
	"g_range1", "g_ranger", NULL, "1993",
	"Ranger-X (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_range1RomInfo, g_range1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ransei no Hasha (Japan)
static struct BurnRomInfo g_ranseiRomDesc[] = {
	{ "ransei no hasha (japan).md", 0x100000, 0xa9a0083d, BRF_PRG },
};

STD_ROM_PICK(g_ransei)
STD_ROM_FN(g_ransei)

struct BurnDriverD BurnDrvMDg_ransei = {
	"g_ransei", NULL, NULL, "",
	"Ransei no Hasha (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ranseiRomInfo, g_ranseiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rastan Saga II (Japan)
static struct BurnRomInfo g_rastjRomDesc[] = {
	{ "rastan saga ii (japan).md", 0x80000, 0xebacfb5a, BRF_PRG },
};

STD_ROM_PICK(g_rastj)
STD_ROM_FN(g_rastj)

struct BurnDriverD BurnDrvMDg_rastj = {
	"g_rastj", "g_rast", NULL, "",
	"Rastan Saga II (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rastjRomInfo, g_rastjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rastan Saga II (USA)
static struct BurnRomInfo g_rastRomDesc[] = {
	{ "rastan saga ii (usa).md", 0x80000, 0xc7ee8965, BRF_PRG },
};

STD_ROM_PICK(g_rast)
STD_ROM_FN(g_rast)

struct BurnDriverD BurnDrvMDg_rast = {
	"g_rast", NULL, NULL, "",
	"Rastan Saga II (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rastRomInfo, g_rastRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// R.B.I. Baseball 4 (Beta)
static struct BurnRomInfo g_rbi4bRomDesc[] = {
	{ "r.b.i. baseball 4 (beta).md", 0x100000, 0xf7420278, BRF_PRG },
};

STD_ROM_PICK(g_rbi4b)
STD_ROM_FN(g_rbi4b)

struct BurnDriverD BurnDrvMDg_rbi4b = {
	"g_rbi4b", "g_rbi4j", NULL, "1900",
	"R.B.I. Baseball 4 (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rbi4bRomInfo, g_rbi4bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Red Zone (USA, Europe)
static struct BurnRomInfo g_redzonRomDesc[] = {
	{ "red zone (usa, europe).md", 0x200000, 0x56512ee5, BRF_PRG },
};

STD_ROM_PICK(g_redzon)
STD_ROM_FN(g_redzon)

struct BurnDriverD BurnDrvMDg_redzon = {
	"g_redzon", NULL, NULL, "1900",
	"Red Zone (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_redzonRomInfo, g_redzonRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ren & Stimpy Show Presents Stimpy's Invention, The (Europe)
static struct BurnRomInfo g_renstiRomDesc[] = {
	{ "ren & stimpy show presents stimpy's invention, the (europe).md", 0x100000, 0xc276c220, BRF_PRG },
};

STD_ROM_PICK(g_rensti)
STD_ROM_FN(g_rensti)

struct BurnDriverD BurnDrvMDg_rensti = {
	"g_rensti", NULL, NULL, "1900",
	"Ren & Stimpy Show Presents Stimpy's Invention, The (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_renstiRomInfo, g_renstiRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ren & Stimpy Show Presents Stimpy's Invention, The (USA) (Beta)
static struct BurnRomInfo g_renst1RomDesc[] = {
	{ "ren & stimpy show presents stimpy's invention, the (usa) (beta).md", 0x100000, 0xfcb86336, BRF_PRG },
};

STD_ROM_PICK(g_renst1)
STD_ROM_FN(g_renst1)

struct BurnDriverD BurnDrvMDg_renst1 = {
	"g_renst1", "g_rensti", NULL, "1900",
	"Ren & Stimpy Show Presents Stimpy's Invention, The (USA) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_renst1RomInfo, g_renst1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ren & Stimpy Show Presents Stimpy's Invention, The (USA)
static struct BurnRomInfo g_renst2RomDesc[] = {
	{ "ren & stimpy show presents stimpy's invention, the (usa).md", 0x100000, 0xd9503ba5, BRF_PRG },
};

STD_ROM_PICK(g_renst2)
STD_ROM_FN(g_renst2)

struct BurnDriverD BurnDrvMDg_renst2 = {
	"g_renst2", "g_rensti", NULL, "1900",
	"Ren & Stimpy Show Presents Stimpy's Invention, The (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_renst2RomInfo, g_renst2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rent a Hero (Japan)
static struct BurnRomInfo g_rentahRomDesc[] = {
	{ "rent a hero (japan).md", 0x100000, 0x2e515f82, BRF_PRG },
};

STD_ROM_PICK(g_rentah)
STD_ROM_FN(g_rentah)

struct BurnDriver BurnDrvMDg_rentah = {
	"g_rentah", NULL, NULL, "1900",
	"Rent a Hero (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rentahRomInfo, g_rentahRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Resq (Europe) (Proto)
static struct BurnRomInfo g_resqeuRomDesc[] = {
	{ "resq (europe) (proto).md", 0x100000, 0x558e35e0, BRF_PRG },
};

STD_ROM_PICK(g_resqeu)
STD_ROM_FN(g_resqeu)

struct BurnDriverD BurnDrvMDg_resqeu = {
	"g_resqeu", NULL, NULL, "1900",
	"Resq (Europe) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_resqeuRomInfo, g_resqeuRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Revenge of Shinobi, The (USA, Europe) (Rev A)
static struct BurnRomInfo g_revengRomDesc[] = {
	{ "revenge of shinobi, the (usa, europe) (rev a).md", 0x80000, 0xfe91ab7e, BRF_PRG },
};

STD_ROM_PICK(g_reveng)
STD_ROM_FN(g_reveng)

struct BurnDriverD BurnDrvMDg_reveng = {
	"g_reveng", NULL, NULL, "1990",
	"Revenge of Shinobi, The (USA, Europe) (Rev A)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_revengRomInfo, g_revengRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Revenge of Shinobi, The (USA, Europe) (Rev B)
static struct BurnRomInfo g_reven1RomDesc[] = {
	{ "revenge of shinobi, the (usa, europe) (rev b).md", 0x80000, 0x4d35ebe4, BRF_PRG },
};

STD_ROM_PICK(g_reven1)
STD_ROM_FN(g_reven1)

struct BurnDriverD BurnDrvMDg_reven1 = {
	"g_reven1", "g_reveng", NULL, "1990",
	"Revenge of Shinobi, The (USA, Europe) (Rev B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_reven1RomInfo, g_reven1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Revenge of Shinobi, The (USA, Europe)
static struct BurnRomInfo g_reven2RomDesc[] = {
	{ "revenge of shinobi, the (usa, europe).md", 0x80000, 0x05f27994, BRF_PRG },
};

STD_ROM_PICK(g_reven2)
STD_ROM_FN(g_reven2)

struct BurnDriverD BurnDrvMDg_reven2 = {
	"g_reven2", "g_reveng", NULL, "1990",
	"Revenge of Shinobi, The (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_reven2RomInfo, g_reven2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Revolution X (USA, Europe)
static struct BurnRomInfo g_revoluRomDesc[] = {
	{ "revolution x (usa, europe).md", 0x400000, 0x5fb0c5d4, BRF_PRG },
};

STD_ROM_PICK(g_revolu)
STD_ROM_FN(g_revolu)

struct BurnDriverD BurnDrvMDg_revolu = {
	"g_revolu", NULL, NULL, "1900",
	"Revolution X (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_revoluRomInfo, g_revoluRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Richard Scarry's Busytown (Prototype - Aug 09, 1994)
static struct BurnRomInfo g_rsbtpaRomDesc[] = {
	{ "richard scarry's busytown (prototype - aug 09, 1994).md", 0x1fecec, 0xc48cbc30, BRF_PRG },
};

STD_ROM_PICK(g_rsbtpa)
STD_ROM_FN(g_rsbtpa)

struct BurnDriverD BurnDrvMDg_rsbtpa = {
	"g_rsbtpa", "g_rsbt", NULL, "",
	"Richard Scarry's Busytown (Prototype - Aug 09, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rsbtpaRomInfo, g_rsbtpaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Richard Scarry's Busytown (Prototype - Aug 15, 1994)
static struct BurnRomInfo g_rsbtpbRomDesc[] = {
	{ "richard scarry's busytown (prototype - aug 15, 1994).md", 0x200000, 0x650ed917, BRF_PRG },
};

STD_ROM_PICK(g_rsbtpb)
STD_ROM_FN(g_rsbtpb)

struct BurnDriverD BurnDrvMDg_rsbtpb = {
	"g_rsbtpb", "g_rsbt", NULL, "",
	"Richard Scarry's Busytown (Prototype - Aug 15, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rsbtpbRomInfo, g_rsbtpbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Richard Scarry's Busytown (Prototype - Aug 16, 1994 - B)
static struct BurnRomInfo g_rsbtpcRomDesc[] = {
	{ "richard scarry's busytown (prototype - aug 16, 1994 - b).md", 0x200000, 0x760cff62, BRF_PRG },
};

STD_ROM_PICK(g_rsbtpc)
STD_ROM_FN(g_rsbtpc)

struct BurnDriverD BurnDrvMDg_rsbtpc = {
	"g_rsbtpc", "g_rsbt", NULL, "",
	"Richard Scarry's Busytown (Prototype - Aug 16, 1994 - B)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rsbtpcRomInfo, g_rsbtpcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Richard Scarry's Busytown (Prototype - Aug 17, 1994)
static struct BurnRomInfo g_rsbtpdRomDesc[] = {
	{ "richard scarry's busytown (prototype - aug 17, 1994).md", 0x1ffaa4, 0x3b9c3f4a, BRF_PRG },
};

STD_ROM_PICK(g_rsbtpd)
STD_ROM_FN(g_rsbtpd)

struct BurnDriverD BurnDrvMDg_rsbtpd = {
	"g_rsbtpd", "g_rsbt", NULL, "",
	"Richard Scarry's Busytown (Prototype - Aug 17, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rsbtpdRomInfo, g_rsbtpdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Richard Scarry's Busytown (Prototype - Aug 25, 1994)
static struct BurnRomInfo g_rsbtpeRomDesc[] = {
	{ "richard scarry's busytown (prototype - aug 25, 1994).md", 0x200000, 0xa0c013ba, BRF_PRG },
};

STD_ROM_PICK(g_rsbtpe)
STD_ROM_FN(g_rsbtpe)

struct BurnDriverD BurnDrvMDg_rsbtpe = {
	"g_rsbtpe", "g_rsbt", NULL, "",
	"Richard Scarry's Busytown (Prototype - Aug 25, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rsbtpeRomInfo, g_rsbtpeRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Richard Scarry's Busytown (Prototype - Aug 26, 1994)
static struct BurnRomInfo g_rsbtpfRomDesc[] = {
	{ "richard scarry's busytown (prototype - aug 26, 1994).md", 0x200000, 0x1ad270f3, BRF_PRG },
};

STD_ROM_PICK(g_rsbtpf)
STD_ROM_FN(g_rsbtpf)

struct BurnDriverD BurnDrvMDg_rsbtpf = {
	"g_rsbtpf", "g_rsbt", NULL, "",
	"Richard Scarry's Busytown (Prototype - Aug 26, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rsbtpfRomInfo, g_rsbtpfRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Richard Scarry's Busytown (Prototype - Jul 21, 1994)
static struct BurnRomInfo g_rsbtpgRomDesc[] = {
	{ "richard scarry's busytown (prototype - jul 21, 1994).md", 0x1f3008, 0x1e92d6ff, BRF_PRG },
};

STD_ROM_PICK(g_rsbtpg)
STD_ROM_FN(g_rsbtpg)

struct BurnDriverD BurnDrvMDg_rsbtpg = {
	"g_rsbtpg", "g_rsbt", NULL, "",
	"Richard Scarry's Busytown (Prototype - Jul 21, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rsbtpgRomInfo, g_rsbtpgRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Richard Scarry's BusyTown (USA)
static struct BurnRomInfo g_rsbtRomDesc[] = {
	{ "richard scarry's busytown (usa).md", 0x200000, 0x7bb60c3f, BRF_PRG },
};

STD_ROM_PICK(g_rsbt)
STD_ROM_FN(g_rsbt)

struct BurnDriverD BurnDrvMDg_rsbt = {
	"g_rsbt", NULL, NULL, "",
	"Richard Scarry's BusyTown (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rsbtRomInfo, g_rsbtRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Riddle Wired (Japan) (SegaNet)
static struct BurnRomInfo g_riddleRomDesc[] = {
	{ "riddle wired (japan) (seganet).md", 0x40000, 0xfae3d720, BRF_PRG },
};

STD_ROM_PICK(g_riddle)
STD_ROM_FN(g_riddle)

struct BurnDriverD BurnDrvMDg_riddle = {
	"g_riddle", NULL, NULL, "",
	"Riddle Wired (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_riddleRomInfo, g_riddleRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rings of Power (USA, Europe)
static struct BurnRomInfo g_ringsoRomDesc[] = {
	{ "rings of power (usa, europe).md", 0x100000, 0x41fcc497, BRF_PRG },
};

STD_ROM_PICK(g_ringso)
STD_ROM_FN(g_ringso)

struct BurnDriverD BurnDrvMDg_ringso = {
	"g_ringso", NULL, NULL, "1900",
	"Rings of Power (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ringsoRomInfo, g_ringsoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rise of the Robots (Europe)
static struct BurnRomInfo g_riseofRomDesc[] = {
	{ "rise of the robots (europe).md", 0x300000, 0x5650780b, BRF_PRG },
};

STD_ROM_PICK(g_riseof)
STD_ROM_FN(g_riseof)

struct BurnDriver BurnDrvMDg_riseof = {
	"g_riseof", NULL, NULL, "1994",
	"Rise of the Robots (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_riseofRomInfo, g_riseofRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Risk (USA)
static struct BurnRomInfo g_riskusRomDesc[] = {
	{ "risk (usa).md", 0x80000, 0x80416d0d, BRF_PRG },
};

STD_ROM_PICK(g_riskus)
STD_ROM_FN(g_riskus)

struct BurnDriverD BurnDrvMDg_riskus = {
	"g_riskus", NULL, NULL, "1900",
	"Risk (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_riskusRomInfo, g_riskusRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Risky Woods (USA, Europe)
static struct BurnRomInfo g_riskywRomDesc[] = {
	{ "risky woods (usa, europe).md", 0x100000, 0xd975e93c, BRF_PRG },
};

STD_ROM_PICK(g_riskyw)
STD_ROM_FN(g_riskyw)

struct BurnDriverD BurnDrvMDg_riskyw = {
	"g_riskyw", NULL, NULL, "1900",
	"Risky Woods (USA, Europe)\0", NULL, "Electronic Arts", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_riskywRomInfo, g_riskywRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ristar (Prototype - Aug 12, 1994)
static struct BurnRomInfo g_ristpaRomDesc[] = {
	{ "ristar (prototype - aug 12, 1994).md", 0x200000, 0x4371f046, BRF_PRG },
};

STD_ROM_PICK(g_ristpa)
STD_ROM_FN(g_ristpa)

struct BurnDriverD BurnDrvMDg_ristpa = {
	"g_ristpa", "g_rist", NULL, "",
	"Ristar (Prototype - Aug 12, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ristpaRomInfo, g_ristpaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ristar (Prototype - Aug 26, 1994)
static struct BurnRomInfo g_ristpbRomDesc[] = {
	{ "ristar (prototype - aug 26, 1994).md", 0x200000, 0xd0c74fdd, BRF_PRG },
};

STD_ROM_PICK(g_ristpb)
STD_ROM_FN(g_ristpb)

struct BurnDriverD BurnDrvMDg_ristpb = {
	"g_ristpb", "g_rist", NULL, "",
	"Ristar (Prototype - Aug 26, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ristpbRomInfo, g_ristpbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ristar (Prototype - Jul 01, 1994)
static struct BurnRomInfo g_ristpcRomDesc[] = {
	{ "ristar (prototype - jul 01, 1994).md", 0x200000, 0x7c5c7a0a, BRF_PRG },
};

STD_ROM_PICK(g_ristpc)
STD_ROM_FN(g_ristpc)

struct BurnDriverD BurnDrvMDg_ristpc = {
	"g_ristpc", "g_rist", NULL, "",
	"Ristar (Prototype - Jul 01, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ristpcRomInfo, g_ristpcRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ristar (Prototype - Jul 18, 1994)
static struct BurnRomInfo g_ristpdRomDesc[] = {
	{ "ristar (prototype - jul 18, 1994).md", 0x200000, 0x6becccc9, BRF_PRG },
};

STD_ROM_PICK(g_ristpd)
STD_ROM_FN(g_ristpd)

struct BurnDriverD BurnDrvMDg_ristpd = {
	"g_ristpd", "g_rist", NULL, "",
	"Ristar (Prototype - Jul 18, 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ristpdRomInfo, g_ristpdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ristar (USA, Europe) (August 1994)
static struct BurnRomInfo g_ristoRomDesc[] = {
	{ "ristar (usa, europe) (august 1994).md", 0x200000, 0x9700139b, BRF_PRG },
};

STD_ROM_PICK(g_risto)
STD_ROM_FN(g_risto)

struct BurnDriverD BurnDrvMDg_risto = {
	"g_risto", "g_rist", NULL, "1900",
	"Ristar (USA, Europe) (August 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ristoRomInfo, g_ristoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ristar (USA, Europe) (September 1994)
static struct BurnRomInfo g_ristRomDesc[] = {
	{ "ristar (usa, europe) (september 1994).md", 0x200000, 0x6511aa61, BRF_PRG },
};

STD_ROM_PICK(g_rist)
STD_ROM_FN(g_rist)

struct BurnDriverD BurnDrvMDg_rist = {
	"g_rist", NULL, NULL, "",
	"Ristar (USA, Europe) (September 1994)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ristRomInfo, g_ristRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ristar - The Shooting Star (Japan, Korea)
static struct BurnRomInfo g_ristjRomDesc[] = {
	{ "ristar - the shooting star (japan, korea).md", 0x200000, 0xce464f0e, BRF_PRG },
};

STD_ROM_PICK(g_ristj)
STD_ROM_FN(g_ristj)

struct BurnDriverD BurnDrvMDg_ristj = {
	"g_ristj", "g_rist", NULL, "",
	"Ristar - The Shooting Star (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ristjRomInfo, g_ristjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Road Rash (USA, Europe)
static struct BurnRomInfo g_roadraRomDesc[] = {
	{ "road rash (usa, europe).md", 0xc0000, 0xdea53d19, BRF_PRG },
};

STD_ROM_PICK(g_roadra)
STD_ROM_FN(g_roadra)

struct BurnDriver BurnDrvMDg_roadra = {
	"g_roadra", NULL, NULL, "1991",
	"Road Rash (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_roadraRomInfo, g_roadraRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Road Rash 3 (USA) (Alpha)
static struct BurnRomInfo g_rrsh3aRomDesc[] = {
	{ "road rash 3 (usa) (alpha).md", 0x200000, 0xb6626083, BRF_PRG },
};

STD_ROM_PICK(g_rrsh3a)
STD_ROM_FN(g_rrsh3a)

struct BurnDriverD BurnDrvMDg_rrsh3a = {
	"g_rrsh3a", "g_rrsh3", NULL, "",
	"Road Rash 3 (USA) (Alpha)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rrsh3aRomInfo, g_rrsh3aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Road Rash 3 (USA, Europe)
static struct BurnRomInfo g_rrsh3RomDesc[] = {
	{ "road rash 3 (usa, europe).md", 0x200000, 0x15785956, BRF_PRG },
};

STD_ROM_PICK(g_rrsh3)
STD_ROM_FN(g_rrsh3)

struct BurnDriver BurnDrvMDg_rrsh3 = {
	"g_rrsh3", NULL, NULL, "1995",
	"Road Rash 3 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rrsh3RomInfo, g_rrsh3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Road Rash II (Japan)
static struct BurnRomInfo g_rrsh2RomDesc[] = {
	{ "road rash ii (japan).md", 0x100000, 0x9a5723b6, BRF_PRG },
};

STD_ROM_PICK(g_rrsh2)
STD_ROM_FN(g_rrsh2)

struct BurnDriver BurnDrvMDg_rrsh2 = {
	"g_rrsh2", NULL, NULL, "1992",
	"Road Rash II (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rrsh2RomInfo, g_rrsh2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Road Rash II (USA, Europe) (v1.2)
static struct BurnRomInfo g_rrsh2aRomDesc[] = {
	{ "road rash ii (usa, europe) (v1.2).md", 0x100000, 0x0876e992, BRF_PRG },
};

STD_ROM_PICK(g_rrsh2a)
STD_ROM_FN(g_rrsh2a)

struct BurnDriver BurnDrvMDg_rrsh2a = {
	"g_rrsh2a", "g_rrsh2", NULL, "1992",
	"Road Rash II (USA, Europe) (v1.2)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rrsh2aRomInfo, g_rrsh2aRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Road Rash II (USA, Europe)
static struct BurnRomInfo g_rrsh2bRomDesc[] = {
	{ "road rash ii (usa, europe).md", 0x100000, 0x7b29c209, BRF_PRG },
};

STD_ROM_PICK(g_rrsh2b)
STD_ROM_FN(g_rrsh2b)

struct BurnDriver BurnDrvMDg_rrsh2b = {
	"g_rrsh2b", "g_rrsh2", NULL, "1992",
	"Road Rash II (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rrsh2bRomInfo, g_rrsh2bRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// RoadBlasters (Japan)
static struct BurnRomInfo g_roadbjRomDesc[] = {
	{ "roadblasters (japan).md", 0x80000, 0xa0015440, BRF_PRG },
};

STD_ROM_PICK(g_roadbj)
STD_ROM_FN(g_roadbj)

struct BurnDriverD BurnDrvMDg_roadbj = {
	"g_roadbj", "g_roadb", NULL, "1900",
	"RoadBlasters (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_roadbjRomInfo, g_roadbjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// RoadBlasters (USA)
static struct BurnRomInfo g_roadbRomDesc[] = {
	{ "roadblasters (usa).md", 0x80000, 0xec6cd5f0, BRF_PRG },
};

STD_ROM_PICK(g_roadb)
STD_ROM_FN(g_roadb)

struct BurnDriverD BurnDrvMDg_roadb = {
	"g_roadb", NULL, NULL, "1900",
	"RoadBlasters (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_roadbRomInfo, g_roadbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// RoboCop 3 (USA, Europe)
static struct BurnRomInfo g_robocoRomDesc[] = {
	{ "robocop 3 (usa, europe).md", 0x80000, 0x34fb7b27, BRF_PRG },
};

STD_ROM_PICK(g_roboco)
STD_ROM_FN(g_roboco)

struct BurnDriverD BurnDrvMDg_roboco = {
	"g_roboco", NULL, NULL, "1993",
	"RoboCop 3 (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_robocoRomInfo, g_robocoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Robocop Versus The Terminator (Beta 1)
static struct BurnRomInfo g_robteaRomDesc[] = {
	{ "robocop versus the terminator (beta 1).md", 0x200000, 0xecebff29, BRF_PRG },
};

STD_ROM_PICK(g_robtea)
STD_ROM_FN(g_robtea)

struct BurnDriverD BurnDrvMDg_robtea = {
	"g_robtea", "g_robte", NULL, "1993",
	"Robocop Versus The Terminator (Beta 1)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_robteaRomInfo, g_robteaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// RoboCop versus The Terminator (Europe) (Beta)
static struct BurnRomInfo g_robtebRomDesc[] = {
	{ "robocop versus the terminator (europe) (beta).md", 0x200000, 0x2487049f, BRF_PRG },
};

STD_ROM_PICK(g_robteb)
STD_ROM_FN(g_robteb)

struct BurnDriverD BurnDrvMDg_robteb = {
	"g_robteb", "g_robte", NULL, "1993",
	"RoboCop versus The Terminator (Europe) (Beta)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_robtebRomInfo, g_robtebRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// RoboCop versus The Terminator (Europe)
static struct BurnRomInfo g_robteRomDesc[] = {
	{ "robocop versus the terminator (europe).md", 0x200000, 0x85a93f8d, BRF_PRG },
};

STD_ROM_PICK(g_robte)
STD_ROM_FN(g_robte)

struct BurnDriverD BurnDrvMDg_robte = {
	"g_robte", NULL, NULL, "1993",
	"RoboCop versus The Terminator (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_robteRomInfo, g_robteRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// RoboCop versus The Terminator (USA)
static struct BurnRomInfo g_robtecRomDesc[] = {
	{ "robocop versus the terminator (usa).md", 0x200000, 0xbbad77a4, BRF_PRG },
};

STD_ROM_PICK(g_robtec)
STD_ROM_FN(g_robtec)

struct BurnDriverD BurnDrvMDg_robtec = {
	"g_robtec", "g_robte", NULL, "1993",
	"RoboCop versus The Terminator (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_robtecRomInfo, g_robtecRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Robot Battler (Japan) (SegaNet)
static struct BurnRomInfo g_robotbRomDesc[] = {
	{ "robot battler (japan) (seganet).md", 0x40000, 0xfdf23eff, BRF_PRG },
};

STD_ROM_PICK(g_robotb)
STD_ROM_FN(g_robotb)

struct BurnDriverD BurnDrvMDg_robotb = {
	"g_robotb", NULL, NULL, "1900",
	"Robot Battler (Japan) (SegaNet)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_robotbRomInfo, g_robotbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Robot Wreckage (USA) (Proto)
static struct BurnRomInfo g_robotwRomDesc[] = {
	{ "robot wreckage (usa) (proto).md", 0x100000, 0xc67ddb14, BRF_PRG },
};

STD_ROM_PICK(g_robotw)
STD_ROM_FN(g_robotw)

struct BurnDriverD BurnDrvMDg_robotw = {
	"g_robotw", NULL, NULL, "1993",
	"Robot Wreckage (USA) (Proto)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_robotwRomInfo, g_robotwRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rock n' Roll Racing (Europe)
static struct BurnRomInfo g_rocknrRomDesc[] = {
	{ "rock n' roll racing (europe).md", 0x100000, 0xbc5a0562, BRF_PRG },
};

STD_ROM_PICK(g_rocknr)
STD_ROM_FN(g_rocknr)

struct BurnDriverD BurnDrvMDg_rocknr = {
	"g_rocknr", NULL, NULL, "1900",
	"Rock n' Roll Racing (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rocknrRomInfo, g_rocknrRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rock n' Roll Racing (USA)
static struct BurnRomInfo g_rockn1RomDesc[] = {
	{ "rock n' roll racing (usa).md", 0x100000, 0x6abab577, BRF_PRG },
};

STD_ROM_PICK(g_rockn1)
STD_ROM_FN(g_rockn1)

struct BurnDriverD BurnDrvMDg_rockn1 = {
	"g_rockn1", "g_rocknr", NULL, "1900",
	"Rock n' Roll Racing (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rockn1RomInfo, g_rockn1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rocket Knight Adventures (Europe)
static struct BurnRomInfo g_rocketRomDesc[] = {
	{ "rocket knight adventures (europe).md", 0x100000, 0x8eedfd51, BRF_PRG },
};

STD_ROM_PICK(g_rocket)
STD_ROM_FN(g_rocket)

struct BurnDriverD BurnDrvMDg_rocket = {
	"g_rocket", NULL, NULL, "1900",
	"Rocket Knight Adventures (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rocketRomInfo, g_rocketRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rocket Knight Adventures (Japan)
static struct BurnRomInfo g_rocke1RomDesc[] = {
	{ "rocket knight adventures (japan).md", 0x100000, 0xd1c8c1c5, BRF_PRG },
};

STD_ROM_PICK(g_rocke1)
STD_ROM_FN(g_rocke1)

struct BurnDriverD BurnDrvMDg_rocke1 = {
	"g_rocke1", "g_rocket", NULL, "1900",
	"Rocket Knight Adventures (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rocke1RomInfo, g_rocke1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rocket Knight Adventures (USA)
static struct BurnRomInfo g_rocke2RomDesc[] = {
	{ "rocket knight adventures (usa).md", 0x100000, 0xa6efec47, BRF_PRG },
};

STD_ROM_PICK(g_rocke2)
STD_ROM_FN(g_rocke2)

struct BurnDriverD BurnDrvMDg_rocke2 = {
	"g_rocke2", "g_rocket", NULL, "1900",
	"Rocket Knight Adventures (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_PLATFORM, 0,
	NULL, g_rocke2RomInfo, g_rocke2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rockman Mega World (Japan) (Alt)
static struct BurnRomInfo g_rockmaRomDesc[] = {
	{ "rockman mega world (japan) (alt).md", 0x200000, 0x85c956ef, BRF_PRG },
};

STD_ROM_PICK(g_rockma)
STD_ROM_FN(g_rockma)

struct BurnDriverD BurnDrvMDg_rockma = {
	"g_rockma", "g_megama", NULL, "1900",
	"Rockman Mega World (Japan) (Alt)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rockmaRomInfo, g_rockmaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rockman Mega World (Japan)
static struct BurnRomInfo g_rockm1RomDesc[] = {
	{ "rockman mega world (japan).md", 0x200000, 0x4d87235e, BRF_PRG },
};

STD_ROM_PICK(g_rockm1)
STD_ROM_FN(g_rockm1)

struct BurnDriverD BurnDrvMDg_rockm1 = {
	"g_rockm1", "g_megama", NULL, "1900",
	"Rockman Mega World (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rockm1RomInfo, g_rockm1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rockman X3 (Unl) [!]
static struct BurnRomInfo g_rmx3RomDesc[] = {
	{ "rockman x3 (unl) [!].md", 0x200000, 0x3ee639f0, BRF_PRG },
};

STD_ROM_PICK(g_rmx3)
STD_ROM_FN(g_rmx3)

struct BurnDriverD BurnDrvMDg_rmx3 = {
	"g_rmx3", NULL, NULL, "",
	"Rockman X3 (Unl) [!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rmx3RomInfo, g_rmx3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Roger Clements MVP Baseball (USA)
static struct BurnRomInfo g_rogercRomDesc[] = {
	{ "roger clements mvp baseball (usa).md", 0x100000, 0x83699e34, BRF_PRG },
};

STD_ROM_PICK(g_rogerc)
STD_ROM_FN(g_rogerc)

struct BurnDriverD BurnDrvMDg_rogerc = {
	"g_rogerc", NULL, NULL, "1900",
	"Roger Clements MVP Baseball (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rogercRomInfo, g_rogercRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rolling Thunder 2 (Europe)
static struct BurnRomInfo g_rth2RomDesc[] = {
	{ "rolling thunder 2 (europe).md", 0x100000, 0xc440f292, BRF_PRG },
};

STD_ROM_PICK(g_rth2)
STD_ROM_FN(g_rth2)

struct BurnDriverD BurnDrvMDg_rth2 = {
	"g_rth2", NULL, NULL, "1900",
	"Rolling Thunder 2 (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rth2RomInfo, g_rth2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rolling Thunder 2 (Japan)
static struct BurnRomInfo g_rth2jRomDesc[] = {
	{ "rolling thunder 2 (japan).md", 0x100000, 0x965b2628, BRF_PRG },
};

STD_ROM_PICK(g_rth2j)
STD_ROM_FN(g_rth2j)

struct BurnDriverD BurnDrvMDg_rth2j = {
	"g_rth2j", "g_rth2", NULL, "1900",
	"Rolling Thunder 2 (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rth2jRomInfo, g_rth2jRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rolling Thunder 2 (USA)
static struct BurnRomInfo g_rth2uRomDesc[] = {
	{ "rolling thunder 2 (usa).md", 0x100000, 0x3ace429b, BRF_PRG },
};

STD_ROM_PICK(g_rth2u)
STD_ROM_FN(g_rth2u)

struct BurnDriverD BurnDrvMDg_rth2u = {
	"g_rth2u", "g_rth2", NULL, "1900",
	"Rolling Thunder 2 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rth2uRomInfo, g_rth2uRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rolling Thunder 3 (USA)
static struct BurnRomInfo g_rth3RomDesc[] = {
	{ "rolling thunder 3 (usa).md", 0x180000, 0x64fb13aa, BRF_PRG },
};

STD_ROM_PICK(g_rth3)
STD_ROM_FN(g_rth3)

struct BurnDriverD BurnDrvMDg_rth3 = {
	"g_rth3", NULL, NULL, "",
	"Rolling Thunder 3 (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rth3RomInfo, g_rth3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rolo to the Rescue (USA, Europe)
static struct BurnRomInfo g_rolotoRomDesc[] = {
	{ "rolo to the rescue (usa, europe).md", 0x80000, 0x306861a2, BRF_PRG },
};

STD_ROM_PICK(g_roloto)
STD_ROM_FN(g_roloto)

struct BurnDriverD BurnDrvMDg_roloto = {
	"g_roloto", NULL, NULL, "1992",
	"Rolo to the Rescue (USA, Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rolotoRomInfo, g_rolotoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Romance of the Three Kingdoms II (USA)
static struct BurnRomInfo g_r3k2RomDesc[] = {
	{ "romance of the three kingdoms ii (usa).md", 0x100000, 0x3d842478, BRF_PRG },
};

STD_ROM_PICK(g_r3k2)
STD_ROM_FN(g_r3k2)

struct BurnDriver BurnDrvMDg_r3k2 = {
	"g_r3k2", NULL, NULL, "19??",
	"Romance of the Three Kingdoms II (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_r3k2RomInfo, g_r3k2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Romance of the Three Kingdoms III - Dragon of Destiny (USA)
static struct BurnRomInfo g_r3k3RomDesc[] = {
	{ "romance of the three kingdoms iii - dragon of destiny (usa).md", 0x140000, 0x7e41c8fe, BRF_PRG },
};

STD_ROM_PICK(g_r3k3)
STD_ROM_FN(g_r3k3)

struct BurnDriver BurnDrvMDg_r3k3 = {
	"g_r3k3", NULL, NULL, "1993",
	"Romance of the Three Kingdoms III - Dragon of Destiny (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_r3k3RomInfo, g_r3k3RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x10000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ronaldinho 98 (B) [c][!]
static struct BurnRomInfo g_ronaldRomDesc[] = {
	{ "ronaldinho 98 (b) [c][!].md", 0x200000, 0xdd27c84e, BRF_PRG },
};

STD_ROM_PICK(g_ronald)
STD_ROM_FN(g_ronald)

struct BurnDriverD BurnDrvMDg_ronald = {
	"g_ronald", "g_inter1", NULL, "1998",
	"Ronaldinho 98 (B) [c][!]\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ronaldRomInfo, g_ronaldRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Royal Blood (Japan)
static struct BurnRomInfo g_royalbRomDesc[] = {
	{ "royal blood (japan).md", 0x100000, 0x0e0107f1, BRF_PRG },
};

STD_ROM_PICK(g_royalb)
STD_ROM_FN(g_royalb)

struct BurnDriver BurnDrvMDg_royalb = {
	"g_royalb", "g_gemfir", NULL, "1900",
	"Royal Blood (Japan)\0", NULL, "Koei", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_royalbRomInfo, g_royalbRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Rugby World Cup 1995 (USA, Europe) (En,Fr,It)
static struct BurnRomInfo g_rugbywRomDesc[] = {
	{ "rugby world cup 1995 (usa, europe) (en,fr,it).md", 0x200000, 0x61f90a8a, BRF_PRG },
};

STD_ROM_PICK(g_rugbyw)
STD_ROM_FN(g_rugbyw)

struct BurnDriverD BurnDrvMDg_rugbyw = {
	"g_rugbyw", NULL, NULL, "1900",
	"Rugby World Cup 1995 (USA, Europe) (En,Fr,It)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_rugbywRomInfo, g_rugbywRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Runark (Japan, Korea)
static struct BurnRomInfo g_runarkRomDesc[] = {
	{ "runark (japan, korea).md", 0x80000, 0x0894d8fb, BRF_PRG },
};

STD_ROM_PICK(g_runark)
STD_ROM_FN(g_runark)

struct BurnDriverD BurnDrvMDg_runark = {
	"g_runark", "g_growlu", NULL, "1900",
	"Runark (Japan, Korea)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_runarkRomInfo, g_runarkRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Ryuuko no Ken (Japan)
static struct BurnRomInfo g_ryuukoRomDesc[] = {
	{ "ryuuko no ken (japan).md", 0x200000, 0x054cf5f6, BRF_PRG },
};

STD_ROM_PICK(g_ryuuko)
STD_ROM_FN(g_ryuuko)

struct BurnDriver BurnDrvMDg_ryuuko = {
	"g_ryuuko", "g_artoff", NULL, "1994",
	"Ryuuko no Ken (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_ryuukoRomInfo, g_ryuukoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Sagaia (USA)
static struct BurnRomInfo g_sagaiaRomDesc[] = {
	{ "sagaia (usa).md", 0x100000, 0xf1e22f43, BRF_PRG },
};

STD_ROM_PICK(g_sagaia)
STD_ROM_FN(g_sagaia)

struct BurnDriverD BurnDrvMDg_sagaia = {
	"g_sagaia", NULL, NULL, "1900",
	"Sagaia (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_sagaiaRomInfo, g_sagaiaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Saint Sword (Japan)
static struct BurnRomInfo g_sswrdjRomDesc[] = {
	{ "saint sword (japan).md", 0x80000, 0x3960a00f, BRF_PRG },
};

STD_ROM_PICK(g_sswrdj)
STD_ROM_FN(g_sswrdj)

struct BurnDriverD BurnDrvMDg_sswrdj = {
	"g_sswrdj", NULL, NULL, "1900",
	"Saint Sword (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_sswrdjRomInfo, g_sswrdjRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Saint Sword (USA)
static struct BurnRomInfo g_sswrdRomDesc[] = {
	{ "saint sword (usa).md", 0x80000, 0x44f66bff, BRF_PRG },
};

STD_ROM_PICK(g_sswrd)
STD_ROM_FN(g_sswrd)

struct BurnDriverD BurnDrvMDg_sswrd = {
	"g_sswrd", "g_sswrdj", NULL, "1900",
	"Saint Sword (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_sswrdRomInfo, g_sswrdRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Same! Same! Same! (Japan)
static struct BurnRomInfo g_samesaRomDesc[] = {
	{ "same! same! same! (japan).md", 0x80000, 0x77bbd841, BRF_PRG },
};

STD_ROM_PICK(g_samesa)
STD_ROM_FN(g_samesa)

struct BurnDriverD BurnDrvMDg_samesa = {
	"g_samesa", "g_firesh", NULL, "1900",
	"Same! Same! Same! (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_samesaRomInfo, g_samesaRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Sampras Tennis 96 (Europe) (J-Cart)
static struct BurnRomInfo g_sampraRomDesc[] = {
	{ "sampras tennis 96 (europe) (j-cart).md", 0x200000, 0x14e3fb7b, BRF_PRG },
};

STD_ROM_PICK(g_sampra)
STD_ROM_FN(g_sampra)

struct BurnDriverD BurnDrvMDg_sampra = {
	"g_sampra", NULL, NULL, "1900",
	"Sampras Tennis 96 (Europe) (J-Cart)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_sampraRomInfo, g_sampraRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Samurai Shodown (Europe)
static struct BurnRomInfo g_samuraRomDesc[] = {
	{ "samurai shodown (europe).md", 0x300000, 0xc972014f, BRF_PRG },
};

STD_ROM_PICK(g_samura)
STD_ROM_FN(g_samura)

struct BurnDriverD BurnDrvMDg_samura = {
	"g_samura", NULL, NULL, "1994",
	"Samurai Shodown (Europe)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_samuraRomInfo, g_samuraRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Samurai Shodown (USA)
static struct BurnRomInfo g_samur1RomDesc[] = {
	{ "samurai shodown (usa).md", 0x300000, 0x5bb8b2d4, BRF_PRG },
};

STD_ROM_PICK(g_samur1)
STD_ROM_FN(g_samur1)

struct BurnDriverD BurnDrvMDg_samur1 = {
	"g_samur1", "g_samura", NULL, "1994",
	"Samurai Shodown (USA)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_samur1RomInfo, g_samur1RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// Samurai Spirits (Japan)
static struct BurnRomInfo g_samur2RomDesc[] = {
	{ "samurai spirits (japan).md", 0x300000, 0x0ea2ae36, BRF_PRG },
};

STD_ROM_PICK(g_samur2)
STD_ROM_FN(g_samur2)

struct BurnDriverD BurnDrvMDg_samur2 = {
	"g_samur2", "g_samura", NULL, "1994",
	"Samurai Spirits (Japan)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_16BIT_ONLY | BDF_CLONE, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_samur2RomInfo, g_samur2RomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveInit, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// San Guo Zhi Lie Zhuan - Luan Shi Qun Ying (China)
static struct BurnRomInfo g_sanguoRomDesc[] = {
	{ "san guo zhi lie zhuan - luan shi qun ying (china).md", 0x100000, 0x3b5cc398, BRF_PRG },
};

STD_ROM_PICK(g_sanguo)
STD_ROM_FN(g_sanguo)

struct BurnDriver BurnDrvMDg_sanguo = {
	"g_sanguo", NULL, NULL, "1900",
	"San Guo Zhi Lie Zhuan - Luan Shi Qun Ying (China)\0", NULL, "Sega License", "Megadrive",
	NULL, NULL, NULL, NULL,
	BDF_GAME_WORKING | BDF_16BIT_ONLY, 2, HARDWARE_SEGA_MEGADRIVE, GBF_MISC, 0,
	NULL, g_sanguoRomInfo, g_sanguoRomName, MegadriveInputInfo, MegadriveDIPInfo,
	MegadriveBackup_0x200000_0x4000_Init, MegadriveExit, MegadriveFrame, NULL, MegadriveScan,
	0, NULL, NULL, NULL, &bMegadriveRecalcPalette, 0x100, 320, 224, 4, 3
};

// San Guo Zhi V (China) (Unl)
static struct BurnRomInfo g_sangu1RomDe