#include "GlobalExtern.h"
#include <D3DX8.h>
extern "C" {
	void __cdecl hq2x_32(unsigned char*, unsigned char*, DWORD, DWORD, DWORD);
	unsigned int LUT16to32[65536];
	unsigned int RGBtoYUV[65536];
}

void MakeVertexListAnimatedLogo(bool animate)
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffffff;
	float right=0.0f,bottom=0.0f;
	if(animate) {
		if(AnimateROMBrowserLogoTimer() == 1) {
			zLeftAnimatedLogoTemp += lMoveROMBrowserLogo;
			zRightAnimatedLogoTemp += rMoveROMBrowserLogo;
			zTopAnimatedLogoTemp += tMoveROMBrowserLogo;
			zBottomAnimatedLogoTemp += bMoveROMBrowserLogo;
			cMoveROMBrowserLogo += speedROMBrowserLogo;

			if(cMoveROMBrowserLogo >= distanceROMBrowserLogo) {
				cMoveROMBrowserLogo = 0;
				lMoveROMBrowserLogo = -lMoveROMBrowserLogo;
				rMoveROMBrowserLogo = -rMoveROMBrowserLogo;
				tMoveROMBrowserLogo = -tMoveROMBrowserLogo;
				bMoveROMBrowserLogo = -bMoveROMBrowserLogo;
			}
		}
	}
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListAnimatedLogo;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftAnimatedLogoTemp;
	pv->y=scaley + zTopAnimatedLogoTemp;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightAnimatedLogoTemp; pv->y= scaley + zTopAnimatedLogoTemp; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftAnimatedLogoTemp; pv->y=-scaley  + zBottomAnimatedLogoTemp; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightAnimatedLogoTemp; pv->y=-scaley +  zBottomAnimatedLogoTemp; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferAnimatedLogo->Lock(0,sizeof(VertexListAnimatedLogo),&lock,0);
	memcpy(lock,VertexListAnimatedLogo,sizeof(VertexListAnimatedLogo));
	VertexBufferAnimatedLogo->Unlock();
	Device->SetStreamSource(0,VertexBufferAnimatedLogo,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListMenu()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0x00ffffff;

	if(SetAlpha == 1)
		colour=0xffffffff;
	else 
		colour=0x00ffffff;
	if(fade)
		colour |= fadeColor << 24;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListMenu;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftMenu;
	pv->y=scaley + zTopMenu;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMenu; pv->y= scaley + zTopMenu; pv++;
	*pv=vert[0]; pv->x=-scalex + zLeftMenu; pv->y=-scaley  + zBottomMenu; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMenu; pv->y=-scaley + zBottomMenu; pv++;
	right = 1; bottom= 1; pv=vert; 
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferMenu->Lock(0,sizeof(VertexListMenu),&lock,0);
	memcpy(lock,VertexListMenu,sizeof(VertexListMenu));
	VertexBufferMenu->Unlock();
	Device->SetStreamSource(0,VertexBufferMenu,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListMainMenuOverlay1()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0x00ffffff;

	if(SetAlpha == 1)
		colour=0xffffffff;
	else 
		colour=0x00ffffff;
	if(fade)
		colour |= fadeColor << 24;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListMainMenuOverlay1;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftMainMenuOverlay1;
	pv->y=scaley + zTopMainMenuOverlay1;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay1; pv->y= scaley + zTopMainMenuOverlay1; pv++;
	*pv=vert[0]; pv->x=-scalex + zLeftMainMenuOverlay1; pv->y=-scaley  + zBottomMainMenuOverlay1; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay1; pv->y=-scaley + zBottomMainMenuOverlay1; pv++;
	right = 1; bottom= 1; pv=vert; 
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferMainMenuOverlay1->Lock(0,sizeof(VertexListMainMenuOverlay1),&lock,0);
	memcpy(lock,VertexListMainMenuOverlay1,sizeof(VertexListMainMenuOverlay1));
	VertexBufferMainMenuOverlay1->Unlock();
	Device->SetStreamSource(0,VertexBufferMainMenuOverlay1,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListMainMenuOverlay2()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0x00ffffff;

	if(SetAlpha == 1)
		colour=0xffffffff;
	else 
		colour=0x00ffffff;
	if(fade)
		colour |= fadeColor << 24;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListMainMenuOverlay2;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftMainMenuOverlay2;
	pv->y=scaley + zTopMainMenuOverlay2;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay2; pv->y= scaley + zTopMainMenuOverlay2; pv++;
	*pv=vert[0]; pv->x=-scalex + zLeftMainMenuOverlay2; pv->y=-scaley  + zBottomMainMenuOverlay2; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay2; pv->y=-scaley + zBottomMainMenuOverlay2; pv++;
	right = 1; bottom= 1; pv=vert; 
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferMainMenuOverlay2->Lock(0,sizeof(VertexListMainMenuOverlay2),&lock,0);
	memcpy(lock,VertexListMainMenuOverlay2,sizeof(VertexListMainMenuOverlay2));
	VertexBufferMainMenuOverlay2->Unlock();
	Device->SetStreamSource(0,VertexBufferMainMenuOverlay2,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListMainMenuOverlay3()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0x00ffffff;

	if(SetAlpha == 1)
		colour=0xffffffff;
	else 
		colour=0x00ffffff;
	if(fade)
		colour |= fadeColor << 24;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListMainMenuOverlay3;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftMainMenuOverlay3;
	pv->y=scaley + zTopMainMenuOverlay3;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay3; pv->y= scaley + zTopMainMenuOverlay3; pv++;
	*pv=vert[0]; pv->x=-scalex + zLeftMainMenuOverlay3; pv->y=-scaley  + zBottomMainMenuOverlay3; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay3; pv->y=-scaley + zBottomMainMenuOverlay3; pv++;
	right = 1; bottom= 1; pv=vert; 
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferMainMenuOverlay3->Lock(0,sizeof(VertexListMainMenuOverlay3),&lock,0);
	memcpy(lock,VertexListMainMenuOverlay3,sizeof(VertexListMainMenuOverlay3));
	VertexBufferMainMenuOverlay3->Unlock();
	Device->SetStreamSource(0,VertexBufferMainMenuOverlay3,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListMainMenuOverlay4()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0x00ffffff;

	if(SetAlpha == 1)
		colour=0xffffffff;
	else 
		colour=0x00ffffff;
	if(fade)
		colour |= fadeColor << 24;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListMainMenuOverlay4;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftMainMenuOverlay4;
	pv->y=scaley + zTopMainMenuOverlay4;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay4; pv->y= scaley + zTopMainMenuOverlay4; pv++;
	*pv=vert[0]; pv->x=-scalex + zLeftMainMenuOverlay4; pv->y=-scaley  + zBottomMainMenuOverlay4; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay4; pv->y=-scaley + zBottomMainMenuOverlay4; pv++;
	right = 1; bottom= 1; pv=vert; 
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferMainMenuOverlay4->Lock(0,sizeof(VertexListMainMenuOverlay4),&lock,0);
	memcpy(lock,VertexListMainMenuOverlay4,sizeof(VertexListMainMenuOverlay4));
	VertexBufferMainMenuOverlay4->Unlock();
	Device->SetStreamSource(0,VertexBufferMainMenuOverlay4,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListMainMenuOverlay5()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0x00ffffff;

	if(SetAlpha == 1)
		colour=0xffffffff;
	else 
		colour=0x00ffffff;
	if(fade)
		colour |= fadeColor << 24;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListMainMenuOverlay5;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftMainMenuOverlay5;
	pv->y=scaley + zTopMainMenuOverlay5;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay5; pv->y= scaley + zTopMainMenuOverlay5; pv++;
	*pv=vert[0]; pv->x=-scalex + zLeftMainMenuOverlay5; pv->y=-scaley  + zBottomMainMenuOverlay5; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay5; pv->y=-scaley + zBottomMainMenuOverlay5; pv++;
	right = 1; bottom= 1; pv=vert; 
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferMainMenuOverlay5->Lock(0,sizeof(VertexListMainMenuOverlay5),&lock,0);
	memcpy(lock,VertexListMainMenuOverlay5,sizeof(VertexListMainMenuOverlay5));
	VertexBufferMainMenuOverlay5->Unlock();
	Device->SetStreamSource(0,VertexBufferMainMenuOverlay5,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListMainMenuOverlay6()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0x00ffffff;

	if(SetAlpha == 1)
		colour=0xffffffff;
	else 
		colour=0x00ffffff;
	if(fade)
		colour |= fadeColor << 24;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListMainMenuOverlay6;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftMainMenuOverlay6;
	pv->y=scaley + zTopMainMenuOverlay6;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay6; pv->y= scaley + zTopMainMenuOverlay6; pv++;
	*pv=vert[0]; pv->x=-scalex + zLeftMainMenuOverlay6; pv->y=-scaley  + zBottomMainMenuOverlay6; pv++;
	*pv=vert[0]; pv->x= scalex + zRightMainMenuOverlay6; pv->y=-scaley + zBottomMainMenuOverlay6; pv++;
	right = 1; bottom= 1; pv=vert; 
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferMainMenuOverlay6->Lock(0,sizeof(VertexListMainMenuOverlay6),&lock,0);
	memcpy(lock,VertexListMainMenuOverlay6,sizeof(VertexListMainMenuOverlay6));
	VertexBufferMainMenuOverlay6->Unlock();
	Device->SetStreamSource(0,VertexBufferMainMenuOverlay6,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListPreviewBorderVertical()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListPreviewBorderVertical;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftPreviewBorderVertical;
	pv->y=scaley + zTopPreviewBorderVertical;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightPreviewBorderVertical; pv->y= scaley + zTopPreviewBorderVertical; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftPreviewBorderVertical; pv->y=-scaley  + zBottomPreviewBorderVertical; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightPreviewBorderVertical; pv->y=-scaley +  zBottomPreviewBorderVertical; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferPreviewBorderVertical->Lock(0,sizeof(VertexListPreviewBorderVertical),&lock,0);
	memcpy(lock,VertexListPreviewBorderVertical,sizeof(VertexListPreviewBorderVertical));
	VertexBufferPreviewBorderVertical->Unlock();
	Device->SetStreamSource(0,VertexBufferPreviewBorderVertical,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListPreviewBorder()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListPreviewBorder;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftPreviewBorder;
	pv->y=scaley + zTopPreviewBorder;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightPreviewBorder; pv->y= scaley + zTopPreviewBorder; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftPreviewBorder; pv->y=-scaley  + zBottomPreviewBorder; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightPreviewBorder; pv->y=-scaley +  zBottomPreviewBorder; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferPreviewBorder->Lock(0,sizeof(VertexListPreviewBorder),&lock,0);
	memcpy(lock,VertexListPreviewBorder,sizeof(VertexListPreviewBorder));
	VertexBufferPreviewBorder->Unlock();
	Device->SetStreamSource(0,VertexBufferPreviewBorder,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListAlternatePreviewBorder()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListAlternatePreviewBorder;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftAlternatePreviewBorder;
	pv->y=scaley + zTopAlternatePreviewBorder;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightAlternatePreviewBorder; pv->y= scaley + zTopAlternatePreviewBorder; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftAlternatePreviewBorder; pv->y=-scaley  + zBottomAlternatePreviewBorder; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightAlternatePreviewBorder; pv->y=-scaley +  zBottomAlternatePreviewBorder; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferAlternatePreviewBorder->Lock(0,sizeof(VertexListAlternatePreviewBorder),&lock,0);
	memcpy(lock,VertexListAlternatePreviewBorder,sizeof(VertexListAlternatePreviewBorder));
	VertexBufferAlternatePreviewBorder->Unlock();
	Device->SetStreamSource(0,VertexBufferAlternatePreviewBorder,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListAlternatePreviewBorderVertical()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListAlternatePreviewBorderVertical;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftAlternatePreviewBorderVertical;
	pv->y=scaley + zTopAlternatePreviewBorderVertical;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightAlternatePreviewBorderVertical; pv->y= scaley + zTopAlternatePreviewBorderVertical; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftAlternatePreviewBorderVertical; pv->y=-scaley  + zBottomAlternatePreviewBorderVertical; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightAlternatePreviewBorderVertical; pv->y=-scaley +  zBottomAlternatePreviewBorderVertical; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferAlternatePreviewBorderVertical->Lock(0,sizeof(VertexListAlternatePreviewBorderVertical),&lock,0);
	memcpy(lock,VertexListAlternatePreviewBorderVertical,sizeof(VertexListAlternatePreviewBorderVertical));
	VertexBufferAlternatePreviewBorderVertical->Unlock();
	Device->SetStreamSource(0,VertexBufferAlternatePreviewBorderVertical,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListInfoBorder()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListInfoBorder;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftInfoBorder;
	pv->y=scaley + zTopInfoBorder;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightInfoBorder; pv->y= scaley + zTopInfoBorder; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftInfoBorder; pv->y=-scaley  + zBottomInfoBorder; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightInfoBorder; pv->y=-scaley +  zBottomInfoBorder; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferInfoBorder->Lock(0,sizeof(VertexListInfoBorder),&lock,0);
	memcpy(lock,VertexListInfoBorder,sizeof(VertexListInfoBorder));
	VertexBufferInfoBorder->Unlock();
	Device->SetStreamSource(0,VertexBufferInfoBorder,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListInfoBorderSimple()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListInfoBorderSimple;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftInfoBorderSimple;
	pv->y=scaley + zTopInfoBorderSimple;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightInfoBorderSimple; pv->y= scaley + zTopInfoBorderSimple; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftInfoBorderSimple; pv->y=-scaley  + zBottomInfoBorderSimple; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightInfoBorderSimple; pv->y=-scaley +  zBottomInfoBorderSimple; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferInfoBorderSimple->Lock(0,sizeof(VertexListInfoBorderSimple),&lock,0);
	memcpy(lock,VertexListInfoBorderSimple,sizeof(VertexListInfoBorderSimple));
	VertexBufferInfoBorderSimple->Unlock();
	Device->SetStreamSource(0,VertexBufferInfoBorderSimple,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}


void MakeVertexListVideoBorder()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListVideoBorder;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftVideoBorder;
	pv->y=scaley + zTopVideoBorder;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightVideoBorder; pv->y= scaley + zTopVideoBorder; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftVideoBorder; pv->y=-scaley  + zBottomVideoBorder; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightVideoBorder; pv->y=-scaley +  zBottomVideoBorder; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferVideoBorder->Lock(0,sizeof(VertexListVideoBorder),&lock,0);
	memcpy(lock,VertexListVideoBorder,sizeof(VertexListVideoBorder));
	VertexBufferVideoBorder->Unlock();
	Device->SetStreamSource(0,VertexBufferVideoBorder,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListDualVideoBorder()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListDualVideoBorder;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftDualVideoBorder;
	pv->y=scaley + zTopDualVideoBorder;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightDualVideoBorder; pv->y= scaley + zTopDualVideoBorder; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftDualVideoBorder; pv->y=-scaley  + zBottomDualVideoBorder; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightDualVideoBorder; pv->y=-scaley +  zBottomDualVideoBorder; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferDualVideoBorder->Lock(0,sizeof(VertexListDualVideoBorder),&lock,0);
	memcpy(lock,VertexListDualVideoBorder,sizeof(VertexListDualVideoBorder));
	VertexBufferDualVideoBorder->Unlock();
	Device->SetStreamSource(0,VertexBufferDualVideoBorder,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListROMBorder()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListROMBorder;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftROMBorder;
	pv->y=scaley + zTopROMBorder;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightROMBorder; pv->y= scaley + zTopROMBorder; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftROMBorder; pv->y=-scaley  + zBottomROMBorder; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightROMBorder; pv->y=-scaley +  zBottomROMBorder; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferROMBorder->Lock(0,sizeof(VertexListROMBorder),&lock,0);
	memcpy(lock,VertexListROMBorder,sizeof(VertexListROMBorder));
	VertexBufferROMBorder->Unlock();
	Device->SetStreamSource(0,VertexBufferROMBorder,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListSelectedBorder()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListSelectBorder;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftSelectBorder;
	pv->y=scaley + zTopSelectBorder;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightSelectBorder; pv->y= scaley + zTopSelectBorder; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftSelectBorder; pv->y=-scaley  + zBottomSelectBorder; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightSelectBorder; pv->y=-scaley +  zBottomSelectBorder; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferSelectBorder->Lock(0,sizeof(VertexListSelectBorder),&lock,0);
	memcpy(lock,VertexListSelectBorder,sizeof(VertexListSelectBorder));
	VertexBufferSelectBorder->Unlock();
	Device->SetStreamSource(0,VertexBufferSelectBorder,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}
void MakeVertexListPreview()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListPreview;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftPreview;
	pv->y=scaley + zTopPreview;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightPreview; pv->y= scaley + zTopPreview; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftPreview; pv->y=-scaley  + zBottomPreview; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightPreview; pv->y=-scaley +  zBottomPreview; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferPreview->Lock(0,sizeof(VertexListPreview),&lock,0);
	memcpy(lock,VertexListPreview,sizeof(VertexListPreview));
	VertexBufferPreview->Unlock();
	Device->SetStreamSource(0,VertexBufferPreview,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListPreviewVertical()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListPreviewVertical;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftPreviewVertical;
	pv->y=scaley + zTopPreviewVertical;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightPreviewVertical; pv->y= scaley + zTopPreviewVertical; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftPreviewVertical; pv->y=-scaley  + zBottomPreviewVertical; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightPreviewVertical; pv->y=-scaley +  zBottomPreviewVertical; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferPreviewVertical->Lock(0,sizeof(VertexListPreviewVertical),&lock,0);
	memcpy(lock,VertexListPreviewVertical,sizeof(VertexListPreviewVertical));
	VertexBufferPreviewVertical->Unlock();
	Device->SetStreamSource(0,VertexBufferPreviewVertical,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListAlternatePreviewVertical()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListAlternatePreviewVertical;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftAlternatePreviewVertical;
	pv->y=scaley + zTopAlternatePreviewVertical;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightAlternatePreviewVertical; pv->y= scaley + zTopAlternatePreviewVertical; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftAlternatePreviewVertical; pv->y=-scaley  + zBottomAlternatePreviewVertical; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightAlternatePreviewVertical; pv->y=-scaley +  zBottomAlternatePreviewVertical; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferAlternatePreviewVertical->Lock(0,sizeof(VertexListAlternatePreviewVertical),&lock,0);
	memcpy(lock,VertexListAlternatePreviewVertical,sizeof(VertexListAlternatePreviewVertical));
	VertexBufferAlternatePreviewVertical->Unlock();
	Device->SetStreamSource(0,VertexBufferAlternatePreviewVertical,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListAlternatePreview()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListAlternatePreview;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftAlternatePreview;
	pv->y=scaley + zTopAlternatePreview;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightAlternatePreview; pv->y= scaley + zTopAlternatePreview; pv++;
	*pv=vert[0]; pv->x=-scalex  + zLeftAlternatePreview; pv->y=-scaley  + zBottomAlternatePreview; pv++;
	*pv=vert[0]; pv->x= scalex  + zRightAlternatePreview; pv->y=-scaley +  zBottomAlternatePreview; pv++;
	right = 1;bottom= 1; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferAlternatePreview->Lock(0,sizeof(VertexListAlternatePreview),&lock,0);
	memcpy(lock,VertexListAlternatePreview,sizeof(VertexListAlternatePreview));
	VertexBufferAlternatePreview->Unlock();
	Device->SetStreamSource(0,VertexBufferAlternatePreview,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexListExitGame()
{
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffff;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexListExitGame;

	if(zoomOver < 4) {
		if(Emulation) {
			if((zLeftScale) > zLeftExitGame) { 
				zLeftScale = zLeftExitGame;
				zoomOver++;
			}
			else {
				zLeftScale += leftMove;
				if((zLeftScale) >= zLeftExitGame) {
					zLeftScale = zLeftExitGame;
					zoomOver++;
				}
			}

			if((zRightScale) < zRightExitGame) { 
				zRightScale = zRightExitGame;
				zoomOver++; 
			}
			else {
				zRightScale -= rightMove;
				if((zRightScale) <= zRightExitGame) {
					zRightScale = zRightExitGame; 
					zoomOver++;
				}
			}

			if((zTopScale) < zTopExitGame) { 
				zTopScale = zTopExitGame;
				zoomOver++; 
			}
			else {
				zTopScale -= topMove;
				if((zTopScale) <= zTopExitGame) {
					zoomOver++;
					zTopScale = zTopExitGame;
				}
			}

			if((zBottomScale) > zBottomExitGame) {
				zBottomScale = zBottomExitGame;
				zoomOver++;
			}
			else {
				zBottomScale += bottomMove;
				if((zBottomScale) >= zBottomExitGame) {
					zBottomScale = zBottomExitGame;
					zoomOver++;
				}
			}
		}
		else {
			zLeftScale = zLeftExitGame;
			zRightScale = zRightExitGame;
			zTopScale = zTopExitGame;
			zBottomScale = zBottomExitGame;
		}
	}

	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zLeftScale;
	pv->y=scaley + zTopScale;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex + zRightScale; pv->y= scaley + zTopScale; pv++;
	*pv=vert[0]; pv->x=-scalex + zLeftScale; pv->y=-scaley  + zBottomScale; pv++;
	*pv=vert[0]; pv->x= scalex + zRightScale; pv->y=-scaley +  zBottomScale; pv++;
	if(exitEmulation) {
		right = TexWidth; 
		bottom= TexHeight; 
	}
	else {
		right = 1;
		bottom= 1;
	}
	pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f; pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBufferExitGame->Lock(0,sizeof(VertexListExitGame),&lock,0);
	memcpy(lock,VertexListExitGame,sizeof(VertexListExitGame));
	VertexBufferExitGame->Unlock();
	Device->SetStreamSource(0,VertexBufferExitGame,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

void MakeVertexList() {
	struct CustomVertex *vert=NULL,*pv=NULL;
	float dist=0.0f;
	float scalex=0.0f,scaley=0.0f;
	unsigned int colour=0xffffff;
	if(scale && dimColor == 1) colour=0x102040;
	float right=0.0f,bottom=0.0f;
	dist=10.0; scalex=dist; scaley=dist;
	vert=VertexList;
	pv=vert;
	pv->z=dist;
	pv->x=-scalex + zBaseLeft + zLeft;
	pv->y=scaley + zBaseTop + zTop;
	pv->colour=colour; pv++;
	*pv=vert[0]; pv->x= scalex + zBaseRight + zRight; pv->y= scaley + zBaseTop + zTop; pv++;
	*pv=vert[0]; pv->x=-scalex + zBaseLeft + zLeft; pv->y=-scaley  + zBaseBottom + zBottom; pv++;
	*pv=vert[0]; pv->x= scalex + zBaseRight + zRight; pv->y=-scaley + zBaseBottom + zBottom; pv++;
	right = TexWidth; bottom= TexHeight; pv=vert;
	pv->u=0.0f; pv->v=0.00f; pv++;
	pv->u=right; pv->v=0.00f; pv++;
	pv->u=0.0f;  pv->v=bottom; pv++;
	pv->u=right; pv->v=bottom; 
	unsigned char *lock=NULL;
	VertexBuffer->Lock(0,sizeof(VertexList),&lock,0);
	memcpy(lock,VertexList,sizeof(VertexList));
	VertexBuffer->Unlock();
	Device->SetStreamSource(0,VertexBuffer,sizeof(CustomVertex));
	Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
}

int SetupMatrices()
{
	D3DXVECTOR3 eye ( 0.0f, 0.0f, 0.0f );
	D3DXVECTOR3 look( 0.0f, 0.0f, 0.0f );
	D3DXVECTOR3 up  ( 0.0f, 1.0f, 0.0f );
	D3DXMATRIX mat;
	float nudgex=0.0f,nudgey=0.0f;
	memset(&mat,0,sizeof(mat));
	mat.m[0][0]=mat.m[1][1]=mat.m[2][2]=mat.m[3][3]=1.0f;
	Device->SetTransform(D3DTS_WORLD,&mat);
	look.x=0;
	look.y=0;
	look.z=10.0f;
	nudgex=13.3333f/(float)(sWidth << 1);
	nudgey=10.0000f/(float)(sHeight << 1);
	eye.x +=nudgex; eye.y +=nudgey;
	look.x+=nudgex; look.y+=nudgey;
	D3DXMatrixLookAtLH(&mat,&eye,&look,&up);
	Device->SetTransform(D3DTS_VIEW,&mat);
	D3DXMatrixPerspectiveFovLH(&mat, 0.5f*3.14, 1.3333f, 0.2f, 1000.0f);
	Device->SetTransform(D3DTS_PROJECTION,&mat);
	return 0;
}

int SetupMatricesEmulation()
{
	//dprintf("sWidth: d\n", sWidth);
	//dprintf("sHeight: d\n", sHeight);
	D3DXVECTOR3 eye ( 0.0f, 0.0f, 0.0f );
	D3DXVECTOR3 look( 0.0f, 0.0f, 0.0f );
	D3DXVECTOR3 up  ( 0.0f, 1.0f, 0.0f );
	D3DXMATRIX mat;
	float nudgex=0.0f,nudgey=0.0f;
	memset(&mat,0,sizeof(mat));
	mat.m[0][0]=mat.m[1][1]=mat.m[2][2]=mat.m[3][3]=1.0f;
	Device->SetTransform(D3DTS_WORLD,&mat);
	look.x=0;
	look.y=0;
	look.z=10.0f;
	nudgex=13.3333f/(float)(sWidth << 1);
	nudgey=10.0000f/(float)(sHeight << 1);
	eye.x +=nudgex; eye.y +=nudgey;
	look.x+=nudgex; look.y+=nudgey;
	D3DXMatrixLookAtLH(&mat,&eye,&look,&up);
	Device->SetTransform(D3DTS_VIEW,&mat);
	D3DXMatrixPerspectiveFovLH(&mat, 0.5f*3.14, 1.3333f, 0.2f, 1000.0f);
	Device->SetTransform(D3DTS_PROJECTION,&mat);
	D3DXMATRIX q;
	D3DXMatrixRotationZ(&q, RotationDegrees * (3.14/180));
	Device->SetTransform(D3DTS_WORLD, &q);

	if(RotationDegrees == 90) {
		zBaseLeft=0.5999997;
		zBaseRight=-0.54997;
		zBaseTop=-3.329997;
		zBaseBottom=3.539998;
		return 0;
	}
	if(RotationDegrees == 180) {
		zBaseLeft=0.5999997;
		zBaseRight=-0.54997;
		zBaseTop=-3.329997;
		zBaseBottom=3.539998;
		return 0;
	}
	if(RotationDegrees == 270) {
		zBaseLeft=0.5999997;
		zBaseRight=-0.54997;
		zBaseTop=-3.329997;
		zBaseBottom=3.539998;
		return 0;
	}
	zBaseLeft=-2.629998;
	zBaseRight=2.489998;
	zBaseTop=-0.560000;
	zBaseBottom=0.620000;
	return 0;
}

void InitFilter() {
	int i, j, k, r, g, b, Y, u, v;
	for (i = 0; i < 65536; i++) {
		LUT16to32[i] = ((i & 0xF800) << 8) + ((i & 0x07E0) << 5) + ((i & 0x001F) << 3);
	}
	for (i = 0; i < 32; i++) {
		for (j = 0; j < 64; j++) {
			for (k = 0; k < 32; k++) {
				r = i << 3;
				g = j << 2;
				b = k << 3;
				Y =	(r + g + b) >> 2;
				u = 128 + ((r - b) >> 2);
				v = 128 + ((-r + 2 * g - b) >> 3);
				RGBtoYUV[(i << 11) + (j << 5) + k] = (Y << 16) + (u << 8) + v;
			}
		}
	}
}

void NoFilter() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	int pitch = lock.Pitch;
	for(int i = 0; i < nVidImageHeight; i++)
		memcpy(&SurfBuf[i * pitch], &pVidImage[i * nVidImagePitch], nVidImageWidth * 2);
	TexScreen->UnlockRect(0);
}

void FilterSuperScale() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	SuperScale((unsigned short*)pVidImage, nVidImagePitch/2,
		(unsigned short*)SurfBuf, lock.Pitch, nVidImageWidth, nVidImageHeight);
	TexScreen->UnlockRect(0);
}

void FilterAdvancedMame() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	AdvMame2x((unsigned char*)pVidImage, nVidImagePitch,
		(unsigned char*)SurfBuf, lock.Pitch, nVidImageWidth, nVidImageHeight);
	TexScreen->UnlockRect(0);
}

void FilterHQ2X() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	hq2x_32(pVidImage, SurfBuf, nVidImageWidth, nVidImageHeight, lock.Pitch );
	TexScreen->UnlockRect(0);
}

void Simple2x(unsigned char *srcPtr, unsigned int srcPitch, unsigned char * /* deltaPtr */,
			  unsigned char *dstPtr, unsigned int dstPitch, int width, int height)
{
	unsigned char *nextLine, *finish;
	nextLine = dstPtr + dstPitch;
	do {
		unsigned int *bP = (unsigned int *) srcPtr;
		unsigned int *dP = (unsigned int *) dstPtr;
		unsigned int *nL = (unsigned int *) nextLine;
		unsigned int currentPixel;
		finish = (unsigned char *) bP + ((width+2) << 1);
		currentPixel = *bP++;

		do {
			unsigned int color = currentPixel & 0xffff;
			color = color | (color << 16);
			*(dP) = color;
			*(nL) = color;
			color = currentPixel >> 16;
			color = color| (color << 16);      
			*(dP + 1) = color;
			*(nL + 1) = color;
			currentPixel = *bP++;
			dP += 2;
			nL += 2;
		} while ((unsigned char *) bP < finish);
		srcPtr += srcPitch;
		dstPtr += dstPitch << 1;
		nextLine += dstPitch << 1;
	}
	while (--height);
}

void FilterSimple2X() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	Simple2x(pVidImage, nVidImagePitch, 0, SurfBuf, lock.Pitch, nVidImageWidth, nVidImageHeight);
	TexScreen->UnlockRect(0);
}

void FilterScanlines() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	ScanlinesTV(pVidImage, nVidImagePitch, 0, SurfBuf, lock.Pitch, nVidImageWidth, nVidImageHeight);
	TexScreen->UnlockRect(0);
}

void Filter2xSaI() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	_2xSaI(pVidImage, nVidImagePitch, _2xSaiBuffer, SurfBuf, lock.Pitch, nVidImageWidth, nVidImageHeight);
	TexScreen->UnlockRect(0);
}

void FilterSuper2xSaI() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	Super2xSaI(pVidImage, nVidImagePitch, _2xSaiBuffer, SurfBuf, lock.Pitch, nVidImageWidth, nVidImageHeight);
	TexScreen->UnlockRect(0);
}

void FilterSuperEagle() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	SuperEagle(pVidImage, nVidImagePitch, _2xSaiBuffer, SurfBuf, lock.Pitch, nVidImageWidth, nVidImageHeight);
	TexScreen->UnlockRect(0);
}

void FilterSuperScale75() {
	D3DLOCKED_RECT lock={0,NULL};
	TexScreen->LockRect( 0, &lock, 0, 0L );
	unsigned char *SurfBuf = (unsigned char *)lock.pBits;
	SuperScale75((unsigned short*)pVidImage, nVidImagePitch/2,
		(unsigned short*)SurfBuf, lock.Pitch, nVidImageWidth, nVidImageHeight);
	TexScreen->UnlockRect(0);
}

void InitRender() {
	renderMethod[0] = &NoFilter;
	renderMethod[1] = &FilterSuperScale;
	renderMethod[2] = &FilterAdvancedMame;
	renderMethod[3] = &FilterHQ2X;
	renderMethod[4] = &FilterSimple2X;
	renderMethod[5] = &FilterScanlines;
	renderMethod[6] = &Filter2xSaI;
	renderMethod[7] = &FilterSuper2xSaI;
	renderMethod[8] = &FilterSuperEagle;
	renderMethod[9] = &FilterSuperScale75;
	
}
void DirectScreen()
{
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	(*renderMethod[SoftwareFilter])(); 
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	if(FPS == true) {
		DisplayFPS();
		Device->SetStreamSource(0,VertexBuffer,sizeof(CustomVertex));
		Device->SetVertexShader(D3DFVF_CUSTOMVERTEX);
		Device->SetTexture(0,TexScreen);
	}
	Device->Present(NULL,NULL,NULL,NULL);
	//Present();
	return;
}

void ResizeTexture() {
	if(SoftwareFilter == 0) {
		TexWidth = nVidImageWidth;
		TexHeight = nVidImageHeight;
	}
	else {
		TexWidth = nVidImageWidth * 2;
		TexHeight = nVidImageHeight * 2;
		ZeroMemory(_2xSaiBuffer, nVidImageWidth * nVidImageHeight * 2);
	}
	if(TexScreen) {
		TexScreen->Release();
		TexScreen = NULL;
	}
	if(SoftwareFilter == 3)
		Device->CreateTexture(TexWidth, TexHeight, 0, 0L, D3DFMT_LIN_A8R8G8B8, D3DPOOL_DEFAULT, &TexScreen);
	else
		Device->CreateTexture(TexWidth, TexHeight, 0, 0L, D3DFMT_LIN_R5G6B5, D3DPOOL_DEFAULT, &TexScreen);
	ZeroTexture();
	//SetupMatricesEmulation();
	//MakeVertexList();
	//Device->SetTexture(0,TexScreen);
}

void DrawBackground() {
	MakeVertexListMenu();
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
}

void SetHardwareFilter() {
	if(HardwareFilter == 0) {//NONE
		Device->SetTextureStageState(0, D3DTSS_MIPFILTER,D3DTEXF_NONE);
	}
	if(HardwareFilter == 1) {//POINT
		Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_POINT);
		Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_POINT);
		Device->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);
	}
	if(HardwareFilter == 2) {//Bilinear
		Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
		Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);
		Device->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_POINT);
	}
	if(HardwareFilter == 3) {//Trilinear
		Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
		Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);
		Device->SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_LINEAR);
	}
	if(HardwareFilter == 4) {//Anisotrpoic
		float fBias = -4.0;
		Device->SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((LPDWORD) (&fBias)));
		Device->SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_ANISOTROPIC);
		Device->SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_ANISOTROPIC);
		Device->SetTextureStageState(0, D3DTSS_MAXANISOTROPY, 4);
	}
	if(HardwareFilter == 5) {//Quincunx
		Device->SetTextureStageState(0, D3DTSS_MAGFILTER,D3DTEXF_QUINCUNX);
		Device->SetTextureStageState(0, D3DTSS_MINFILTER,D3DTEXF_QUINCUNX);
	}
	if(HardwareFilter == 6) {//Gaussian Cubic
		Device->SetTextureStageState(0, D3DTSS_MAGFILTER,D3DTEXF_GAUSSIANCUBIC);
		Device->SetTextureStageState(0, D3DTSS_MINFILTER,D3DTEXF_GAUSSIANCUBIC);
	}
}

void CheckForHDTVResolutions() {
	DWORD videoFlags = XGetVideoFlags(); 
	v480pAvailable = false; 
	v720pAvailable = false; 
	v1080iAvailable = false; 
	if ( XGetAVPack() == XC_AV_PACK_HDTV) 
	{ 
		if ( videoFlags & XC_VIDEO_FLAGS_HDTV_480p ) 
		{ 
			v480pAvailable = true; 
		} 
		if ( videoFlags & XC_VIDEO_FLAGS_HDTV_720p ) 
		{ 
			v720pAvailable = true; 
		} 
		if ( videoFlags & XC_VIDEO_FLAGS_HDTV_1080i ) 
		{ 
			v1080iAvailable = true; 
		} 
	} 
} 

void StartHDMode() { 
	if(HDMode == 0) return; //480i or 480p

	if(HDMode == 1) {//720p 
		if(vsyncEnabled == 1) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_ONE;
		if(vsyncEnabled == 0) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;//DEFAULT;//ONE;
		sWidth = 1280;
		sHeight = 720;
		d3dpp.Flags = D3DPRESENTFLAG_PROGRESSIVE | D3DPRESENTFLAG_WIDESCREEN ; 
		d3dpp.BackBufferFormat = D3DFMT_A8R8G8B8 ; 
		d3dpp.BackBufferWidth  = 1280; 
		d3dpp.BackBufferHeight  = 720; 
		Device->Reset(&d3dpp); 
		Device->Clear(0,NULL,D3DCLEAR_TARGET,0x0,1.0f,0);
		Device->Present( NULL, NULL, NULL, NULL ); 
		Device->SetFlickerFilter(FlickerFilter) ; 
		Device->SetSoftDisplayFilter(Soften) ; 
	} 
	if(HDMode == 2) { //1080i
		if(vsyncEnabled == 1) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_ONE;
		if(vsyncEnabled == 0) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;//DEFAULT;//ONE;
		sWidth = 1920;
		sHeight = 1080;
		d3dpp.Flags = D3DPRESENTFLAG_WIDESCREEN | D3DPRESENTFLAG_INTERLACED ; 
		d3dpp.BackBufferFormat = D3DFMT_LIN_R5G6B5 ; 
		d3dpp.BackBufferWidth  = 1920; 
		d3dpp.BackBufferHeight = 1080; 
		Device->Reset(&d3dpp); 
		Device->Clear(0,NULL,D3DCLEAR_TARGET,0x0,1.0f,0); 
		Device->Present( NULL, NULL, NULL, NULL ); 
		Device->SetFlickerFilter(FlickerFilter) ; 
		Device->SetSoftDisplayFilter(Soften) ; 
	} 
} 
void RestoreResolution() {
	if(v480pAvailable) { //480p
		sWidth = 640;
		sHeight = 480;

		if(pixelRatio == 1)
			d3dpp.Flags = D3DPRESENTFLAG_PROGRESSIVE  | D3DPRESENTFLAG_10X11PIXELASPECTRATIO;
		else
			d3dpp.Flags = D3DPRESENTFLAG_PROGRESSIVE;

		d3dpp.BackBufferFormat = D3DFMT_A8R8G8B8 ; 
		d3dpp.BackBufferWidth  = sWidth; 
		d3dpp.BackBufferHeight  = sHeight;  

		if(vsyncEnabled == 1) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_ONE;
		if(vsyncEnabled == 0) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;//DEFAULT;//ONE;

		Device->Reset(&d3dpp); 
		Device->Clear(0,NULL,D3DCLEAR_TARGET,0x0,1.0f,0);
		Device->Present( NULL, NULL, NULL, NULL ); 
		Device->SetFlickerFilter(FlickerFilter) ; 
		Device->SetSoftDisplayFilter(Soften) ; 
		return; 
	} 
	else { //480i
		if(vsyncEnabled == 1) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_ONE;
		if(vsyncEnabled == 0) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;//DEFAULT;//ONE;

		sWidth = 640;
		sHeight = 480;

		if(pixelRatio == 1)
			d3dpp.Flags = D3DPRESENTFLAG_INTERLACED  | D3DPRESENTFLAG_10X11PIXELASPECTRATIO;
		else
			d3dpp.Flags = D3DPRESENTFLAG_INTERLACED;

		d3dpp.BackBufferFormat = D3DFMT_LIN_R5G6B5 ; 
		d3dpp.BackBufferWidth  = sWidth; 
		d3dpp.BackBufferHeight  = sHeight;  
		Device->Reset(&d3dpp); 
		Device->Clear(0,NULL,D3DCLEAR_TARGET,0x0,1.0f,0);
		Device->Present( NULL, NULL, NULL, NULL ); 
		Device->SetFlickerFilter(FlickerFilter) ; 
		Device->SetSoftDisplayFilter(Soften) ; 
		return; 
	} 
	return; 
} 
void SetFlickerSoft() {
	DWORD videoFlags = XGetVideoFlags();
	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//set pal60 if available.
		if(videoFlags & XC_VIDEO_FLAGS_PAL_60Hz)
			d3dpp.FullScreen_RefreshRateInHz = 60 ;
		else
			d3dpp.FullScreen_RefreshRateInHz = 50 ;
	}
	else
		d3dpp.FullScreen_RefreshRateInHz = 60 ;

	if(vsyncEnabled == 1) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_ONE;
	if(vsyncEnabled == 0) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;

	Device->Reset(&d3dpp);
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0x0,1.0f,0);
	Device->Present( NULL, NULL, NULL, NULL );
	Device->SetFlickerFilter(FlickerFilter);
	Device->SetSoftDisplayFilter(Soften);
}

int DirectInit()
{
	D3DDISPLAYMODE mode;
	int ret=0;

	memset(&d3dpp,0,sizeof(d3dpp));
	memset(&mode,0,sizeof(mode));

	Direct3D=Direct3DCreate8(D3D_SDK_VERSION); if (Direct3D==NULL) return 1;
	sHeight = 480;
	sWidth = 640;	
	d3dpp.BackBufferWidth =sWidth;
	d3dpp.BackBufferHeight=sHeight;
	d3dpp.BackBufferCount =1;
	d3dpp.SwapEffect=D3DSWAPEFFECT_DISCARD;//WAS COPY

	DWORD XVidMode = XGetVideoFlags();

	if ( XGetAVPack() == XC_AV_PACK_HDTV) {
		if(XVidMode & XC_VIDEO_FLAGS_HDTV_480p) {
			d3dpp.Flags = D3DPRESENTFLAG_PROGRESSIVE;
			d3dpp.BackBufferFormat = D3DFMT_A8R8G8B8;
		}
		else {
			d3dpp.Flags = D3DPRESENTFLAG_INTERLACED;
			d3dpp.BackBufferFormat  = D3DFMT_LIN_R5G6B5 ;
		}
	}
	else {
		d3dpp.Flags = D3DPRESENTFLAG_INTERLACED;
		d3dpp.BackBufferFormat  = D3DFMT_LIN_R5G6B5 ;
	}

	d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_DEFAULT;//ONE;//D3DPRESENT_INTERVAL_IMMEDIATE

	if(pixelRatio == 1 && HDMode == 0)
		d3dpp.Flags |= D3DPRESENTFLAG_10X11PIXELASPECTRATIO;

	DWORD videoFlags = XGetVideoFlags();
	if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)
	{
		//set pal60 if available.
		if(videoFlags & XC_VIDEO_FLAGS_PAL_60Hz)
			d3dpp.FullScreen_RefreshRateInHz = 60 ;
		else
			d3dpp.FullScreen_RefreshRateInHz = 50 ;
	}
	else
		d3dpp.FullScreen_RefreshRateInHz = 60 ;

	if(vsyncEnabled == 1) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_ONE;
	if(vsyncEnabled == 0) d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;//DEFAULT;//ONE;

	CheckForHDTVResolutions(); 
	if(!v720pAvailable && !v1080iAvailable) { 
		HDMode = 0;
	} 
	if(v720pAvailable && HDMode == 1) { //from ini
		sWidth = 1280;
		sHeight = 720;
		d3dpp.Flags = D3DPRESENTFLAG_PROGRESSIVE | D3DPRESENTFLAG_WIDESCREEN ; 
		d3dpp.BackBufferFormat = D3DFMT_A8R8G8B8 ; 
		d3dpp.BackBufferWidth  = 1280; 
		d3dpp.BackBufferHeight  = 720; 
	}
	if(v1080iAvailable && HDMode == 2) { //from ini
		sWidth = 1920;
		sHeight = 1080;
		d3dpp.Flags = D3DPRESENTFLAG_WIDESCREEN | D3DPRESENTFLAG_INTERLACED ; 
		d3dpp.BackBufferFormat = D3DFMT_LIN_R5G6B5 ; 
		d3dpp.BackBufferWidth  = 1920; 
		d3dpp.BackBufferHeight = 1080; 
	} 

	Direct3D->CreateDevice(0,D3DDEVTYPE_HAL,NULL,D3DCREATE_HARDWARE_VERTEXPROCESSING,&d3dpp,&Device);
	Device->GetBackBuffer(0,D3DBACKBUFFER_TYPE_MONO,&DirectBack);
	SetupMatrices();
	InitRender();
	return 0;
}

void OptionVideoInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 3;
		//SetDelay();
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  { 
		ClickSound();
		OptionVideoSelected++;
		if(OptionVideoSelected > OptionVideoItems.size() - 1)
			OptionVideoSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  {  
		ClickSound();
		OptionVideoSelected--;
		if(OptionVideoSelected < 0)
			OptionVideoSelected = OptionVideoItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
		ConfirmSound();
		if(OptionVideoSelected == 0) {
			HardwareFilter--;
			if(HardwareFilter < 0)
				HardwareFilter = 6;
			if(HardwareFilter == 0)
				OptionVideoValueItems[0] = "None";
			if(HardwareFilter == 1)
				OptionVideoValueItems[0] = "Point";
			if(HardwareFilter == 2)
				OptionVideoValueItems[0] = "Bilinear";
			if(HardwareFilter == 3)
				OptionVideoValueItems[0] = "Trilinear";
			if(HardwareFilter == 4)
				OptionVideoValueItems[0] = "Anisotropic";
			if(HardwareFilter == 5)
				OptionVideoValueItems[0] = "Quincunx";
			if(HardwareFilter == 6)
				OptionVideoValueItems[0] = "Gaussian Cubic";
			SetHardwareFilter();
			return;
		}
		if(OptionVideoSelected == 1) {
			SoftwareFilter--;
			if(SoftwareFilter < 0)
				SoftwareFilter = 9;
			if(SoftwareFilter == 0)
				OptionVideoValueItems[1] = "No Filter";
			if(SoftwareFilter == 1)
				OptionVideoValueItems[1] = "SuperScale2X";
			if(SoftwareFilter == 2)
				OptionVideoValueItems[1] = "AdvanceMame2X";
			if(SoftwareFilter == 3)
				OptionVideoValueItems[1] = "HQ2X";
			if(SoftwareFilter == 4)
				OptionVideoValueItems[1] = "Simple2X";
			if(SoftwareFilter == 5)
				OptionVideoValueItems[1] = "Scanline";
			if(SoftwareFilter == 6)
				OptionVideoValueItems[1] = "2xSaI";
			if(SoftwareFilter == 7)
				OptionVideoValueItems[1] = "Super2xSaI";
			if(SoftwareFilter == 8)
				OptionVideoValueItems[1] = "SuperEagle";
			if(SoftwareFilter == 9)
				OptionVideoValueItems[1] = "SuperScale75";
			return;
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionVideoSelected == 0) {
			HardwareFilter++;
			if(HardwareFilter > 6)
				HardwareFilter = 0;
			if(HardwareFilter == 0)
				OptionVideoValueItems[0] = "None";
			if(HardwareFilter == 1)
				OptionVideoValueItems[0] = "Point";
			if(HardwareFilter == 2)
				OptionVideoValueItems[0] = "Bilinear";
			if(HardwareFilter == 3)
				OptionVideoValueItems[0] = "Trilinear";
			if(HardwareFilter == 4)
				OptionVideoValueItems[0] = "Anisotropic";
			if(HardwareFilter == 5)
				OptionVideoValueItems[0] = "Quincunx";
			if(HardwareFilter == 6)
				OptionVideoValueItems[0] = "Gaussian Cubic";
			SetHardwareFilter();
			return;
		}
		if(OptionVideoSelected == 1) {
			SoftwareFilter++;
			if(SoftwareFilter > 9)
				SoftwareFilter = 0;

			if(SoftwareFilter == 0)
				OptionVideoValueItems[1] = "No Filter";
			if(SoftwareFilter == 1)
				OptionVideoValueItems[1] = "SuperScale2X";
			if(SoftwareFilter == 2)
				OptionVideoValueItems[1] = "AdvanceMame2X";
			if(SoftwareFilter == 3)
				OptionVideoValueItems[1] = "HQ2X";
			if(SoftwareFilter == 4)
				OptionVideoValueItems[1] = "Simple2X";
			if(SoftwareFilter == 5)
				OptionVideoValueItems[1] = "Scanline";
			if(SoftwareFilter == 6)
				OptionVideoValueItems[1] = "2xSaI";
			if(SoftwareFilter == 7)
				OptionVideoValueItems[1] = "Super2xSaI";
			if(SoftwareFilter == 8)
				OptionVideoValueItems[1] = "SuperEagle";
			if(SoftwareFilter == 9)
				OptionVideoValueItems[1] = "SuperScale75";
			return;
		}
		if(OptionVideoSelected == 2) {
			m_bVideoModeChanged = true;
			CheckForHDTVResolutions(); 
			HDMode++; 

			if(!v720pAvailable && !v1080iAvailable) { 
				if(GameListWidth > 640)
					GameListWidth = 640;
				HDMode = 0; 
				OptionVideoValueItems[2] = "480i/480p";
				pixelRatio = 0;
				OptionVideoValueItems[8] = "Off";
				return; 
			} 
			if(!v720pAvailable && HDMode == 1) { 
				HDMode = 2; 
			} 
			if(v720pAvailable && HDMode == 1) { 
				if(GameListWidth > 1280)
					GameListWidth = 1280;
				dprintf("720 Start\n");
				StartHDMode();
				dprintf("720 End\n");
				OptionVideoValueItems[2] = "720p";
				return; 
			} 
			if(!v1080iAvailable && HDMode == 2) { 
				HDMode = 3; 
			} 
			if(v1080iAvailable && HDMode == 2) { 
				StartHDMode(); 
				OptionVideoValueItems[2] = "1080i";
				return; 
			} 
			if(HDMode == 3) { 
				if(GameListWidth > 640)
					GameListWidth = 640;
				HDMode = 0; 
				OptionVideoValueItems[2] = "480i/480p";
				pixelRatio = 0;
				OptionVideoValueItems[7] = "Off";
				RestoreResolution();
			} 
			return; 
		}
		if(OptionVideoSelected == 3) {
			FlickerFilter++;
			if(FlickerFilter > 5)
				FlickerFilter = 0;
			if(FlickerFilter == 0)
				OptionVideoValueItems[3] = "0";
			if(FlickerFilter == 1)
				OptionVideoValueItems[3] = "1";
			if(FlickerFilter == 2)
				OptionVideoValueItems[3] = "2";
			if(FlickerFilter == 3)
				OptionVideoValueItems[3] = "3";
			if(FlickerFilter == 4)
				OptionVideoValueItems[3] = "4";
			if(FlickerFilter == 5)
				OptionVideoValueItems[3] = "5";
			SetFlickerSoft();
			return;
		}
		if(OptionVideoSelected == 4) {
			Soften++;
			if(Soften > 1)
				Soften = 0;
			if(Soften == 0)
				OptionVideoValueItems[4] = "Off";
			if(Soften == 1)
				OptionVideoValueItems[4] = "On";
			SetFlickerSoft();
			return;
		}
		if(OptionVideoSelected == 5) {
			vsyncEnabled++;
			if(vsyncEnabled > 1)
				vsyncEnabled = 0;
			if(vsyncEnabled == 0)
				OptionVideoValueItems[5] = "Off";
			if(vsyncEnabled == 1)
				OptionVideoValueItems[5] = "On";
			SetFlickerSoft();
			return;
		}
		if(OptionVideoSelected == 6) {
			dimColor++;
			if(dimColor > 1)
				dimColor = 0;
			if(dimColor == 1) 
				OptionVideoValueItems[6] = "On";
			if(dimColor == 0)
				OptionVideoValueItems[6] = "Off";
			return;
		}
		if(OptionVideoSelected == 7) {
			if(HDMode == 0) {
				pixelRatio++;
				if(pixelRatio > 1)
					pixelRatio = 0;
				if(pixelRatio == 1) 
					OptionVideoValueItems[7] = "On";
				if(pixelRatio == 0)
					OptionVideoValueItems[7] = "Off";
				RestoreResolution();
			}
		}
	}
}

void OptionEmulationVideoInput() {
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		GUIState = 1;
		SaveGameIni(BurnDrvGetTextA(0));
		return;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_DOWN)  { 
		ClickSound();
		OptionEmulationVideoSelected++;
		if(OptionEmulationVideoSelected > OptionEmulationVideoItems.size() - 1)
			OptionEmulationVideoSelected = 0;
	}

	if (g_Gamepads[DefaultController].Event == XBGAMEPAD_DPAD_UP)  { 
		ClickSound();
		OptionEmulationVideoSelected--;
		if(OptionEmulationVideoSelected < 0)
			OptionEmulationVideoSelected = OptionEmulationVideoItems.size() - 1;
	}  

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_X) {
		ConfirmSound();
		if(OptionEmulationVideoSelected == 0) {
			HardwareFilter--;
			if(HardwareFilter < 0)
				HardwareFilter = 6;
			if(HardwareFilter == 0)
				OptionEmulationVideoValueItems[0] = "None";
			if(HardwareFilter == 1)
				OptionEmulationVideoValueItems[0] = "Point";
			if(HardwareFilter == 2)
				OptionEmulationVideoValueItems[0] = "Bilinear";
			if(HardwareFilter == 3)
				OptionEmulationVideoValueItems[0] = "Trilinear";
			if(HardwareFilter == 4)
				OptionEmulationVideoValueItems[0] = "Anisotropic";
			if(HardwareFilter == 5)
				OptionEmulationVideoValueItems[0] = "Quincunx";
			if(HardwareFilter == 6)
				OptionEmulationVideoValueItems[0] = "Gaussian Cubic";
			SetHardwareFilter();
			return;
		}
		if(OptionEmulationVideoSelected == 1) {
			SoftwareFilter--;
			if(SoftwareFilter < 0)
				SoftwareFilter = 9;

			if(SoftwareFilter == 0)
				OptionEmulationVideoValueItems[1] = "No Filter";
			if(SoftwareFilter == 1)
				OptionEmulationVideoValueItems[1] = "SuperScale2X";
			if(SoftwareFilter == 2)
				OptionEmulationVideoValueItems[1] = "AdvanceMame2X";
			if(SoftwareFilter == 3)
				OptionEmulationVideoValueItems[1] = "HQ2X";
			if(SoftwareFilter == 4)
				OptionEmulationVideoValueItems[1] = "Simple2X";
			if(SoftwareFilter == 5)
				OptionEmulationVideoValueItems[1] = "Scanline";
			if(SoftwareFilter == 6)
				OptionEmulationVideoValueItems[1] = "2xSaI";
			if(SoftwareFilter == 7)
				OptionEmulationVideoValueItems[1] = "Super2xSaI";
			if(SoftwareFilter == 8)
				OptionEmulationVideoValueItems[1] = "SuperEagle";
			if(SoftwareFilter == 9)
				OptionEmulationVideoValueItems[1] = "SuperScale75";
			ResizeTexture();

			return;
		}
		if(OptionEmulationVideoSelected == 2) {
			FlickerFilter--;
			if(FlickerFilter < 0)
				FlickerFilter = 5;
			if(FlickerFilter == 0)
				OptionEmulationVideoValueItems[2] = "0";
			if(FlickerFilter == 1)
				OptionEmulationVideoValueItems[2] = "1";
			if(FlickerFilter == 2)
				OptionEmulationVideoValueItems[2] = "2";
			if(FlickerFilter == 3)
				OptionEmulationVideoValueItems[2] = "3";
			if(FlickerFilter == 4)
				OptionEmulationVideoValueItems[2] = "4";
			if(FlickerFilter == 5)
				OptionEmulationVideoValueItems[2] = "5";
			SetFlickerSoft();
			return;
		}
		if(OptionEmulationVideoSelected == 9) {
			CyclePreview(-1);
		}
	}

	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_A) {
		ConfirmSound();
		if(OptionEmulationVideoSelected == 0) {
			HardwareFilter++;
			if(HardwareFilter > 6)
				HardwareFilter = 0;
			if(HardwareFilter == 0)
				OptionEmulationVideoValueItems[0] = "None";
			if(HardwareFilter == 1)
				OptionEmulationVideoValueItems[0] = "Point";
			if(HardwareFilter == 2)
				OptionEmulationVideoValueItems[0] = "Bilinear";
			if(HardwareFilter == 3)
				OptionEmulationVideoValueItems[0] = "Trilinear";
			if(HardwareFilter == 4)
				OptionEmulationVideoValueItems[0] = "Anisotropic";
			if(HardwareFilter == 5)
				OptionEmulationVideoValueItems[0] = "Quincunx";
			if(HardwareFilter == 6)
				OptionEmulationVideoValueItems[0] = "Gaussian Cubic";
			SetHardwareFilter();
			return;
		}
		if(OptionEmulationVideoSelected == 1) {
			SoftwareFilter++;
			if(SoftwareFilter > 9)
				SoftwareFilter = 0;

			if(SoftwareFilter == 0)
				OptionEmulationVideoValueItems[1] = "No Filter";
			if(SoftwareFilter == 1)
				OptionEmulationVideoValueItems[1] = "SuperScale2X";
			if(SoftwareFilter == 2)
				OptionEmulationVideoValueItems[1] = "AdvanceMame2X";
			if(SoftwareFilter == 3)
				OptionEmulationVideoValueItems[1] = "HQ2X";
			if(SoftwareFilter == 4)
				OptionEmulationVideoValueItems[1] = "Simple2X";
			if(SoftwareFilter == 5)
				OptionEmulationVideoValueItems[1] = "Scanline";
			if(SoftwareFilter == 6)
				OptionEmulationVideoValueItems[1] = "2xSaI";
			if(SoftwareFilter == 7)
				OptionEmulationVideoValueItems[1] = "Super2xSaI";
			if(SoftwareFilter == 8)
				OptionEmulationVideoValueItems[1] = "SuperEagle";
			if(SoftwareFilter == 9)
				OptionEmulationVideoValueItems[1] = "SuperScale75";
			ResizeTexture();

			return;
		}
		if(OptionEmulationVideoSelected == 2) {
			FlickerFilter++;
			if(FlickerFilter > 5)
				FlickerFilter = 0;
			if(FlickerFilter == 0)
				OptionEmulationVideoValueItems[2] = "0";
			if(FlickerFilter == 1)
				OptionEmulationVideoValueItems[2] = "1";
			if(FlickerFilter == 2)
				OptionEmulationVideoValueItems[2] = "2";
			if(FlickerFilter == 3)
				OptionEmulationVideoValueItems[2] = "3";
			if(FlickerFilter == 4)
				OptionEmulationVideoValueItems[2] = "4";
			if(FlickerFilter == 5)
				OptionEmulationVideoValueItems[2] = "5";
			SetFlickerSoft();
			return;
		}
		if(OptionEmulationVideoSelected == 3) {
			Soften++;
			if(Soften > 1)
				Soften = 0;
			if(Soften == 0)
				OptionEmulationVideoValueItems[3] = "Off";
			if(Soften == 1)
				OptionEmulationVideoValueItems[3] = "On";
			SetFlickerSoft();
			return;
		}
		if(OptionEmulationVideoSelected == 4) {
			GUIState = 8;
			return;
		}
		if(OptionEmulationVideoSelected == 5) {
			vsyncEnabled++;
			if(vsyncEnabled > 1)
				vsyncEnabled = 0;
			if(vsyncEnabled == 0)
				OptionEmulationVideoValueItems[5] = "Off";
			if(vsyncEnabled == 1)
				OptionEmulationVideoValueItems[5] = "On";
			SetFlickerSoft();
			return;
		}
		if(OptionEmulationVideoSelected == 6) {
			dimColor++;
			if(dimColor > 1)
				dimColor = 0;
			if(dimColor == 1) 
				OptionEmulationVideoValueItems[6] = "On";
			if(dimColor == 0)
				OptionEmulationVideoValueItems[6] = "Off";
			return;
		}
		if(OptionEmulationVideoSelected == 7) {
			if(HDMode == 0) {
				pixelRatio++;
				if(pixelRatio > 1)
					pixelRatio = 0;
				if(pixelRatio == 1) 
					OptionEmulationVideoValueItems[7] = "On";
				if(pixelRatio == 0)
					OptionEmulationVideoValueItems[7] = "Off";
				RestoreResolution();
			}
		}
		if(OptionEmulationVideoSelected == 8) {
			RotationDegrees += 90;
			if(RotationDegrees > 270) RotationDegrees = 0;
			if(RotationDegrees == 0) 
				OptionEmulationVideoValueItems[8] = "Disabled";
			if(RotationDegrees == 90) 
				OptionEmulationVideoValueItems[8] = "90 Degrees";
			if(RotationDegrees == 180) 
				OptionEmulationVideoValueItems[8] = "180 Degrees";
			if(RotationDegrees == 270) 
				OptionEmulationVideoValueItems[8] = "270 Degrees";
		}
		if(OptionEmulationVideoSelected == 9) {
			CyclePreview(1);
		}
		if(OptionEmulationVideoSelected == 10) {
			if(FPS == true) {
				FPS = false;
				OptionEmulationVideoValueItems[10] = "False";
			}
			else {
				FPS = true;
				OptionEmulationVideoValueItems[10] = "True";
			}
		}
	}
}

void DrawOptionVideoItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionVideoSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionEmulationVideoItem(int MenuItemNumber, char* text, int x, int y) {
	unsigned int c;
	if(OptionEmulationVideoSelected == MenuItemNumber) 
		c = 0xffff00; 
	else 
		c = 0xffffff;
	FontSetColour(c);
	FontText(ConvertCharStringToWCHAR(text), x, y, 640);
}

void DrawOptionVideoMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0,1.0f,0);
	Device->SetTexture(0,TexOption);
	DrawBackground();
	if(!Emulation) {
		for(int i = 0; i < OptionVideoItems.size(); i++) {
			DrawOptionVideoItem(i, (char*)OptionVideoItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
			DrawOptionVideoItem(i, (char*)OptionVideoValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
		}
	}
	else {
		for(int i = 0; i < OptionEmulationVideoItems.size(); i++) {
			DrawOptionEmulationVideoItem(i, (char*)OptionEmulationVideoItems[i].c_str(), MenuDetailPosX, MenuDetailPosY + (i * vSpace));
			DrawOptionEmulationVideoItem(i, (char*)OptionEmulationVideoValueItems[i].c_str(), MenuDetailPosX + MenuSpacing, MenuDetailPosY + (i * vSpace));
		}
	}
	Present();
}

void OptionVideoMenu() {
	if(!Emulation) {
		OptionVideoInput();
	}
	else {
		OptionEmulationVideoInput();
	}
	DrawOptionVideoMenu();
}

void OptionVideoScaleInput() {
	scale = true;
	ReadInput();
	if(g_Gamepads[DefaultController].Event == XBGAMEPAD_B) {
		CancelSound();
		scale = false;
		GUIState = 4;
		//SetDelay();
		SetupMatrices();
		scale = 0;
		//dimColor = 0;
		return;
	}

	if(RotationDegrees == 0) {
		if (g_Gamepads[DefaultController].fY1 > 0) { zTop+=0.01f;  zBottom+=0.01f; }// Up
		if (g_Gamepads[DefaultController].fY1 < 0) { zTop-=0.01f;  zBottom-=0.01f; } // Down
		if (g_Gamepads[DefaultController].fX1 < 0) { zLeft-=0.01f; zRight-=0.01f; } // Left
		if (g_Gamepads[DefaultController].fX1 > 0) { zLeft+=0.01f; zRight+=0.01f; }// Right
		if (g_Gamepads[DefaultController].fY2 > 0) { zBottom+=0.01f; } // Up
		if (g_Gamepads[DefaultController].fY2 < 0) { zBottom-=0.01f; } // Down
		if (g_Gamepads[DefaultController].fX2 < 0) { zRight-=0.01f; } // Left
		if (g_Gamepads[DefaultController].fX2 > 0) { zRight+=0.01f; } // Right
	}

	if(RotationDegrees == 90) {
		if (g_Gamepads[DefaultController].fY1 > 0) { zLeft+=0.01f; zRight+=0.01f; }// Up
		if (g_Gamepads[DefaultController].fY1 < 0) { zLeft-=0.01f; zRight-=0.01f; } // Down
		if (g_Gamepads[DefaultController].fX1 < 0) { zTop+=0.01f;  zBottom+=0.01f; } // Left
		if (g_Gamepads[DefaultController].fX1 > 0) { zTop-=0.01f;  zBottom-=0.01f; }// Right
		if (g_Gamepads[DefaultController].fY2 > 0) { zRight+=0.01f; } // Up
		if (g_Gamepads[DefaultController].fY2 < 0) { zRight-=0.01f; } // Down
		if (g_Gamepads[DefaultController].fX2 < 0) { zBottom+=0.01f; } // Left
		if (g_Gamepads[DefaultController].fX2 > 0) {  zBottom-=0.01f; } // Right
	}

	if(RotationDegrees == 180) {
		if (g_Gamepads[DefaultController].fY1 > 0) { zTop-=0.01f;  zBottom-=0.01f; }// Up
		if (g_Gamepads[DefaultController].fY1 < 0) { zTop+=0.01f;  zBottom+=0.01f; } // Down
		if (g_Gamepads[DefaultController].fX1 < 0) { zLeft+=0.01f; zRight+=0.01f; } // Left
		if (g_Gamepads[DefaultController].fX1 > 0) { zLeft-=0.01f; zRight-=0.01f; }// Right
		if (g_Gamepads[DefaultController].fY2 > 0) { zBottom-=0.01f; } // Up
		if (g_Gamepads[DefaultController].fY2 < 0) { zBottom+=0.01f; } // Down
		if (g_Gamepads[DefaultController].fX2 < 0) { zRight+=0.01f; } // Left
		if (g_Gamepads[DefaultController].fX2 > 0) { zRight-=0.01f; } // Right
	}

	if(RotationDegrees == 270) {
		if (g_Gamepads[DefaultController].fY1 > 0) { zLeft-=0.01f; zRight-=0.01f; }// Up
		if (g_Gamepads[DefaultController].fY1 < 0) { zLeft+=0.01f; zRight+=0.01f; } // Down
		if (g_Gamepads[DefaultController].fX1 < 0) { zTop-=0.01f;  zBottom-=0.01f; } // Left
		if (g_Gamepads[DefaultController].fX1 > 0) { zTop+=0.01f;  zBottom+=0.01f; }// Right
		if (g_Gamepads[DefaultController].fY2 > 0) { zRight-=0.01f; } // Up
		if (g_Gamepads[DefaultController].fY2 < 0) { zRight+=0.01f; } // Down
		if (g_Gamepads[DefaultController].fX2 < 0) { zBottom-=0.01f; } // Left
		if (g_Gamepads[DefaultController].fX2 > 0) { zBottom+=0.01f; } // Right
	}
}

void DrawOptionVideoScaleMenu() {
	Device->Clear(0,NULL,D3DCLEAR_TARGET,0xFFFFFFFF,1.0f,0);
	SetupMatricesEmulation();
	scale = 1;
	//dimColor = 1;
	MakeVertexList();
	Device->SetTexture(0,TexScreen);
	Device->DrawPrimitive(D3DPT_TRIANGLESTRIP,0,2);
	DisplayInstructions("Use the left and right analog sticks to adjust the image."); 
	Present();
}

void OptionVideoScaleMenu() {
	DrawOptionVideoScaleMenu();
	OptionVideoScaleInput();
}
