#ifdef XBOX_USB_MOUSE
/* USB Mouse support unfortunatly is only supported with XDK's
   after April 03 - Coders will need to update their XDK and
   to VS .net if they want to support USB Mouse.
*/
#define DEBUG_MOUSE		
#endif

#include <XBApp.h>
#include <XBFont.h>
#include <XBHelp.h>
#include <xgraphics.h>

#include <stdio.h>

#define UAEXVERSION L"0.81 Unofficial"

#include "keyboard_api.h"	//SnaX:14/06/03 

#ifdef XBOX_USB_MOUSE
static HANDLE g_hMouseDevice[4] = { 0 };
static XINPUT_MOUSE	g_MouseInput;
XINPUT_STATE g_MouseStates[4];

void InitMouse(void);
void Mouse_RefreshDeviceList(void);
void mouse_update(void);
#endif

extern "C" {

#include "sysconfig.h"
#include "sysdeps.h"
#include "xwin.h"
#include "options.h" 
#include "gensound.h"
#include "custom.h" 

#include "keybuf.h"
#include "keyboard.h"

#include "savestate.h"

extern void real_main (int argc, char **argv);
extern void uae_reset (void); 
extern void DISK_check_change (void);

int nr_joysticks;
int g_draw_status=1;
char *OPTIONSFILENAME;

void write_log (const char *s,...)
{
}

void setup_brkhandler (void)
{ 
}

int debuggable (void)
{
  return 0;
} 

void usage (void)
{
} 

int lockscr (void)
{
  return 1;
} 

void unlockscr (void)
{
} 

int strcasecmp(const char *a,const char *b) {
  return strcmpi(a,b);
}

//filesys stuff

//SnaX:14/06/03

//SnaX: Some fsdb stuff that is not defined due to non inclusion of fsdb.c

int fsdb_name_invalid(const char *)
{
	return 0;
}

uae_u32 filesys_parse_mask(uae_u32 mask)
{
	return mask ^ 0xF;
}

struct a_inode;

void fsdb_dir_writeback(a_inode *)
{
}

int fsdb_used_as_nname(a_inode *,const char *)
{
	return 0;
}

void fsdb_clean_dir(a_inode *)
{
}

a_inode *fsdb_lookup_aino_aname(a_inode *,const char *)
{
	return 0;
}

a_inode *fsdb_lookup_aino_nname(a_inode *,const char *)
{
	return 0;
}

char *fsdb_search_dir(const char *,char *)
{
	return 0;
}

void fsdb_fill_file_attrs(a_inode *)
{
}

int fsdb_set_file_attrs(a_inode *,int)
{
	return 0;
}

int fsdb_mode_representable_p(const a_inode *)
{
	return 0;
}

char *fsdb_create_unique_nname(a_inode *,const char *)
{
	return 0;
}

//SnaX:End:14/06/03

//gfx stuff
int check_prefs_changed_gfx (void)
{
  return 0;
}

int graphics_init(void)
{ 
  //we use a 16-bit surface
  //todo> make it write directly into the DX texture
  gfxvidinfo.width = 640;
  gfxvidinfo.height = 576; 
  gfxvidinfo.pixbytes = 2; 
  gfxvidinfo.rowbytes = 640*gfxvidinfo.pixbytes;
  gfxvidinfo.bufmem = (char *)malloc(640*576*2);
  gfxvidinfo.linemem = 0;
  gfxvidinfo.emergmem = (char *)malloc (gfxvidinfo.rowbytes);
  gfxvidinfo.maxblocklines = 10000;
  alloc_colors64k(6,5,5,10,5,0);
  return 1;
}

int graphics_setup (void)
{ 
  return 1;
}

void graphics_leave(void)
{
} 

void flush_line (int y)
{ 
}

void flush_block (int ystart, int ystop)
{ 
}

//sound stuff
uae_u16 sndbuffer[44100];
uae_u16 *sndbufpt;
int sndbufsize; 

int init_sound (void)
{
  sample_evtime = (long)maxhpos * maxvpos * 50 / currprefs.sound_freq;

  if (currprefs.sound_bits == 16) {
	  init_sound_table16 ();
	  sample_handler = currprefs.stereo ? sample16s_handler : sample16_handler;
  } else {
	  init_sound_table8 ();
	  sample_handler = currprefs.stereo ? sample8s_handler : sample8_handler;
  }
  
  sound_available = 1;
  sndbufsize=(44100*4)/50;
  sndbufpt = sndbuffer; 
  return 1;
}

int setup_sound (void)
{
  sound_available = 1;
  return 1;
}

void close_sound(void)
{
}

//joystick stuff
void init_joystick(void)
{
  nr_joysticks = 2;
}

void close_joystick(void)
{
}

//misc stuff
unsigned int flush_icache(void)
{ 
  return 0;
}

int needmousehack (void)
{ 
  return 0;
}

void LED (int a)
{
} 

void target_save_options (FILE *f, struct uae_prefs *p)
{ 
}

int target_parse_option (struct uae_prefs *p, char *option, char *value)
{ 
  return 0;
}

void parse_cmdline (int argc, char **argv)
{ 
}

};

#define MAX_KEYS 64

const char* AMIGA_KEYS[] = {
	"None", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q",
	"R", "S", "T", "U", "V", "W", "X", "Y", "Z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9",
	"F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "UP", "DOWN", "LEFT", "RIGHT",
	"SPACE", "BACKSPACE", "TAB", "RETURN", "ESCAPE", "DEL", "LEFT SHIFT", "RIGHT SHIFT", "CAPS LOCK",
	"LEFT ALT", "RIGHT ALT", "LEFT AMIGA", "RIGHT AMIGA", "HELP", NULL
};

const int AMIGA_KEYS_MAPPING[] = {
	-1, AK_A, AK_B, AK_C, AK_D, AK_E, AK_F, AK_G, AK_H, AK_I, AK_J, AK_K, AK_L, AK_M, AK_N, AK_O, AK_P, AK_Q,
	AK_R, AK_S, AK_T, AK_U, AK_V, AK_W, AK_X, AK_Y, AK_Z, AK_0, AK_1, AK_2, AK_3, AK_4, AK_5, AK_6, AK_7, AK_8, AK_9,
	AK_F1, AK_F2, AK_F3, AK_F4, AK_F5, AK_F6, AK_F7, AK_F8, AK_F9, AK_F10, AK_UP, AK_DN, AK_LF, AK_RT,
	AK_SPC, AK_BS, AK_TAB, AK_RET, AK_ESC, AK_DEL, AK_LSH, AK_RSH, AK_CAPSLOCK, AK_LALT, AK_RALT, AK_LAMI, AK_RAMI, AK_HELP
};

const int AMIGA_KEYS_GAMEPAD[] = {
	XINPUT_GAMEPAD_RIGHT_TRIGGER, XINPUT_GAMEPAD_LEFT_TRIGGER, XINPUT_GAMEPAD_WHITE, 
	XINPUT_GAMEPAD_Y, XINPUT_GAMEPAD_BLACK
};

class CXBoxUae : public CXBApplication
{
public:
  CXBoxUae();

  virtual HRESULT Initialize();
  virtual HRESULT Render();
  virtual HRESULT FrameMove();
  void ReadInput();
  void HandleEvents();

  // Font and help
  CXBFont         m_Font;
  CXBHelp         m_Help;
  BOOL            m_bDrawHelp;
  LPDIRECTSOUND8  m_pDSound;          // DirectSound object

  LPDIRECT3DTEXTURE8      m_pVideoTexture;

  LPDIRECT3DVERTEXBUFFER8 m_pVB;

  LPDIRECTSOUNDBUFFER8    m_pDSBuffer;            // DirectSoundBuffer

  void flush_screen();
  void render(bool dim);
  void read_joystick(int nr, unsigned int *dir, int *button);
  void write_sound();

  WAVEFORMATEX			m_stream_format;
  DSBUFFERDESC			m_stream_desc;
  UINT32				m_stream_buffer_size;
  UINT32 m_stream_buffer_in;

  int m_towait;
  int m_inmenu;

  int DoMenu(const char **menu, int defsel=0);
  int DoMapKeysMenu(const char **menu);
  int EnterName(char *dest);
  void DoResize();
  void ChangeResolution();
  void ResetResizeSettings(); 
  void SetDefaultOptions();
  void LoadOptions();
  void SaveOptions();

  bool key_button_pressed[5];
  int associated_key[5];

  int simulkey, simulkeywait;

  char m_savestatefile[1024];

  int m_scroffschanged;
  float m_scroffsx, m_scroffsy, m_scrstretchx, m_scrstretchy;

  int m_antialias;
  int m_resizing;

  int m_resolution;
  int m_resolutionheight;
  int m_resolutionwidth;

  int m_port0;

  int m_mouse_sensitivity;
  int m_mouse_swap;

  char m_config_file[512];
};

CXBoxUae *g_xbox;
extern "C" {

void flush_screen (int ystart, int ystop)
{ 
  g_xbox->flush_screen();
}

void handle_events (void)
{ 
  g_xbox->HandleEvents();
}

void read_joystick(int nr, unsigned int *dir, int *button)
{
  g_xbox->read_joystick(nr,dir,button);
}

void finish_sound_buffer (void)
{
  g_xbox->write_sound();
}
 
};

VOID __cdecl main()
{
    CXBoxUae xbApp;
    if( FAILED( xbApp.Create() ) )
        return;
    xbApp.Run();
}

CXBoxUae::CXBoxUae() {
  m_d3dpp.BackBufferFormat       = D3DFMT_R5G6B5;
  m_d3dpp.AutoDepthStencilFormat = D3DFMT_D16;

  m_d3dpp.FullScreen_PresentationInterval = D3DPRESENT_INTERVAL_ONE;

  SetDefaultOptions();
  LoadOptions();

  if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)        // PAL user
  {
    DWORD videoFlags = XGetVideoFlags();
    if(videoFlags & XC_VIDEO_FLAGS_PAL_60Hz)                // PAL 60 user
      m_d3dpp.FullScreen_RefreshRateInHz = 60;
    else
    m_d3dpp.FullScreen_RefreshRateInHz = 50;
  }

  memset(associated_key, 0, sizeof(associated_key));
}

void CXBoxUae::SetDefaultOptions()
{
  g_draw_status=1;

  m_antialias=4;
  m_d3dpp.MultiSampleType = D3DMULTISAMPLE_2_SAMPLES_SUPERSAMPLE_VERTICAL_LINEAR;

  m_resolution=0;
  m_resolutionwidth=640;
  m_resolutionheight=480;

  m_port0=0; //mouse
  m_mouse_sensitivity=2;
  m_mouse_swap=0;

  m_scroffsx=m_scroffsy=m_scrstretchx=m_scrstretchy=0;

  strcpy(m_config_file,"D:\\configs\\Default");
}

void CXBoxUae::LoadOptions()
{
  FILE *fh=fopen("T:\\options","rb");
  if(fh) {
#define RI(x) fread(&x,sizeof(x),1,fh);
    RI(g_draw_status);
    RI(m_antialias);
    RI(m_d3dpp.MultiSampleType);
    RI(m_resolution);
    RI(m_resolutionwidth);
    RI(m_resolutionheight);
    RI(m_port0);
    RI(m_mouse_sensitivity);
    RI(m_mouse_swap);
    RI(m_scroffsx);
    RI(m_scroffsy);
    RI(m_scrstretchx);
    RI(m_scrstretchy);
    RI(m_config_file);
    fclose(fh);
  }
}

void CXBoxUae::SaveOptions()
{
  FILE *fh=fopen("T:\\options","wb");
  if(fh) {
#define WI(x) fwrite(&x,sizeof(x),1,fh);
    WI(g_draw_status);
    WI(m_antialias);
    WI(m_d3dpp.MultiSampleType);
    WI(m_resolution);
    WI(m_resolutionwidth);
    WI(m_resolutionheight);
    WI(m_port0);
    WI(m_mouse_sensitivity);
    WI(m_mouse_swap);
    WI(m_scroffsx);
    WI(m_scroffsy);
    WI(m_scrstretchx);
    WI(m_scrstretchy);
    WI(m_config_file);
    fclose(fh);
  }
}

HRESULT CXBoxUae::Initialize() {
  // Create a font
  if( FAILED( m_Font.Create( "Font.xpr" ) ) )
    return XBAPPERR_MEDIANOTFOUND;

  // Create help
  if( FAILED( m_Help.Create( "Gamepad.xpr" ) ) )
    return XBAPPERR_MEDIANOTFOUND;    

  if( FAILED( DirectSoundCreate( NULL, &m_pDSound, NULL ) ) )
    return E_FAIL;

  g_xbox=this;

  m_scroffschanged=1;

  m_pd3dDevice->CreateTexture( 640, 576, 1, 0, D3DFMT_LIN_R6G5B5, D3DPOOL_MANAGED, &m_pVideoTexture);

  // Create a vertex buffer for rendering the screen
  m_pd3dDevice->CreateVertexBuffer( 4*6*sizeof(FLOAT), D3DUSAGE_WRITEONLY, 0L, D3DPOOL_DEFAULT, &m_pVB );

  // make a format description for what we want
	m_stream_format.wBitsPerSample	= 16;
	m_stream_format.wFormatTag		= WAVE_FORMAT_PCM;
	m_stream_format.nChannels			= 2;
	m_stream_format.nSamplesPerSec	= 44100;
	m_stream_format.nBlockAlign		= m_stream_format.wBitsPerSample * m_stream_format.nChannels / 8;
	m_stream_format.nAvgBytesPerSec	= m_stream_format.nSamplesPerSec * m_stream_format.nBlockAlign;

  m_stream_buffer_size=((44100*4)/50)*2;

  // create a buffer desc for the stream buffer
	m_stream_desc.dwSize				= sizeof(m_stream_desc);
	m_stream_desc.dwFlags				= 0;
	m_stream_desc.dwBufferBytes 		= m_stream_buffer_size;
	m_stream_desc.lpwfxFormat			= &m_stream_format;
	m_stream_desc.lpMixBins			= NULL;//&dsmb;
	
  if( FAILED( DirectSoundCreateBuffer( &m_stream_desc, &m_pDSBuffer ) ) )
      return E_FAIL;

  // reset buffer
  {
    DWORD locked;
	  void *buffer;

    m_pDSBuffer->Lock(0, m_stream_buffer_size, &buffer, &locked, NULL, NULL, 0);    
	  // clear the buffer to remove any noise in it
	  memset(buffer, 0, locked);
  }
  
  IDirectSoundBuffer_Play(m_pDSBuffer, 0, 0, DSBPLAY_LOOPING);

  m_towait=-1;
  m_stream_buffer_in=0;

  m_inmenu=0;

  simulkey=-1;
  simulkeywait=0;

  m_savestatefile[0]=0;

  m_resizing=0;

  //SnaX:14/06/03

  //SnaX:Keyboard Initialisation

  Keyboard_Init(25,500,50);

#ifdef XBOX_USB_MOUSE
  InitMouse();					// Lantus:USB Mouse support read notes above
#endif

  //SnaX:Config change functionality - Upon load check Launch info and set correct config

  DWORD launchType;
  LAUNCH_DATA lPtr;

  OPTIONSFILENAME=m_config_file;

  if (XGetLaunchInfo(&launchType,&lPtr)==ERROR_SUCCESS)
  {
	  if (launchType==LDT_TITLE &&
		  (char)lPtr.Data[0]=='U' &&
		  (char)lPtr.Data[1]=='A' &&
		  (char)lPtr.Data[2]=='E' &&
		  (char)lPtr.Data[3]=='X')
	  {
      strcpy(m_config_file,(char *)(&lPtr.Data[4]));
	  }
  }

  //SnaX:End:14/06/03

  return S_OK;
}

HRESULT CXBoxUae::Render() {
  real_main (0, NULL);
  XLaunchNewImage(NULL,NULL);
  return S_OK;
}

HRESULT CXBoxUae::FrameMove() {
  DirectSoundDoWork();
  return S_OK;
}

void CXBoxUae::flush_screen() {
	render(false);
}

void CXBoxUae::render(bool dim) {
  D3DLOCKED_RECT lock;
  int i;
  unsigned short *vidmem = (unsigned short*)gfxvidinfo.bufmem;
  m_pVideoTexture->LockRect(0,&lock,0,0L);
  unsigned short *pPixel = (unsigned short*)lock.pBits;

  if (dim) {
    for (i=0; i<640*576; i++) {
      // quick'n'dirty
      pPixel[i] = vidmem[i] / 5000;
    }
  } else 
    memcpy(pPixel,gfxvidinfo.bufmem,640*576*2);

  m_pVideoTexture->UnlockRect(0);

  m_pd3dDevice->Clear(0L, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0,0,0), 1.0f, 0L);
  
  // Set state to render the gamepad image
  m_pd3dDevice->SetTexture( 0, m_pVideoTexture );
  m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLOROP,   D3DTOP_MODULATE );
  m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TEXTURE );
  m_pd3dDevice->SetTextureStageState( 0, D3DTSS_COLORARG2, D3DTA_DIFFUSE );
  m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAOP,   D3DTOP_MODULATE );
  m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG1, D3DTA_TEXTURE );
  m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ALPHAARG2, D3DTA_DIFFUSE );
  m_pd3dDevice->SetTextureStageState( 1, D3DTSS_COLOROP,   D3DTOP_DISABLE );
  m_pd3dDevice->SetTextureStageState( 1, D3DTSS_ALPHAOP,   D3DTOP_DISABLE );
  m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ADDRESSU,  D3DTADDRESS_CLAMP );
  m_pd3dDevice->SetTextureStageState( 0, D3DTSS_ADDRESSV,  D3DTADDRESS_CLAMP );
  m_pd3dDevice->SetRenderState( D3DRS_ZENABLE,      FALSE );
  m_pd3dDevice->SetRenderState( D3DRS_FOGENABLE,    FALSE );
  m_pd3dDevice->SetRenderState( D3DRS_FOGTABLEMODE, D3DFOG_NONE );
  m_pd3dDevice->SetRenderState( D3DRS_FILLMODE,     D3DFILL_SOLID );
  m_pd3dDevice->SetRenderState( D3DRS_CULLMODE,     D3DCULL_CCW );
  m_pd3dDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
  m_pd3dDevice->SetRenderState( D3DRS_SRCBLEND,  D3DBLEND_SRCALPHA );
  m_pd3dDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );
  m_pd3dDevice->SetVertexShader( D3DFVF_XYZRHW|D3DFVF_TEX1 );

  if(m_scroffschanged) {
    struct VERTEX { D3DXVECTOR4 p; FLOAT tu, tv; };
    VERTEX* v;
    m_pVB->Lock( 0, 0, (BYTE**)&v, 0L );
    v[0].p = D3DXVECTOR4(   20 - 0.5f + m_scroffsx,   20 - 0.5f + m_scroffsy, 0, 0 );  v[0].tu =   0; v[0].tv =   0;
    v[1].p = D3DXVECTOR4( m_resolutionwidth-20 - 0.5f + m_scroffsx - m_scrstretchx,   20 - 0.5f + m_scroffsy, 0, 0 );  v[1].tu = 640; v[1].tv =   0;
    v[2].p = D3DXVECTOR4( m_resolutionwidth-20 - 0.5f + m_scroffsx  - m_scrstretchx, m_resolutionheight-20 - 0.5f + m_scroffsy - m_scrstretchy, 0, 0 );  v[2].tu = 640; v[2].tv = 576;
    v[3].p = D3DXVECTOR4(   20 - 0.5f + m_scroffsx, m_resolutionheight-20 - 0.5f + m_scroffsy - m_scrstretchy, 0, 0 );  v[3].tu =   0; v[3].tv = 576;
    m_pVB->Unlock();
    m_scroffschanged=0;
  }

  // Render the gamepad image
  m_pd3dDevice->SetStreamSource( 0, m_pVB, 6*sizeof(FLOAT) );
  m_pd3dDevice->DrawPrimitive( D3DPT_QUADLIST, 0, 1 );

  // Present the scene
  if (!dim && !m_resizing) m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
}

// Deadzone for the gamepad inputs
const SHORT XINPUT_DEADZONE = (SHORT)( 0.24f * FLOAT(0x7FFF) );

void CXBoxUae::ReadInput()
{
  // Read the input for all connected gampads
  XBInput_GetInput( m_Gamepad );

  // Lump inputs of all connected gamepads into one common structure.
  // This is done so apps that need only one gamepad can function with
  // any gamepad.
  ZeroMemory( &m_DefaultGamepad, sizeof(m_DefaultGamepad) );
  INT nThumbLX = 0;
  INT nThumbLY = 0;
  INT nThumbRX = 0;
  INT nThumbRY = 0;

  for( DWORD i=0; i<4; i++ ) {
    if( m_Gamepad[i].hDevice ) {
      // Only account for thumbstick info beyond the deadzone
      if( m_Gamepad[i].sThumbLX > XINPUT_DEADZONE ||
          m_Gamepad[i].sThumbLX < -XINPUT_DEADZONE )
          nThumbLX += m_Gamepad[i].sThumbLX;
      if( m_Gamepad[i].sThumbLY > XINPUT_DEADZONE ||
          m_Gamepad[i].sThumbLY < -XINPUT_DEADZONE )
          nThumbLY += m_Gamepad[i].sThumbLY;
      if( m_Gamepad[i].sThumbRX > XINPUT_DEADZONE ||
          m_Gamepad[i].sThumbRX < -XINPUT_DEADZONE )
          nThumbRX += m_Gamepad[i].sThumbRX;
      if( m_Gamepad[i].sThumbRY > XINPUT_DEADZONE ||
          m_Gamepad[i].sThumbRY < -XINPUT_DEADZONE )
          nThumbRY += m_Gamepad[i].sThumbRY;

      m_DefaultGamepad.fX1 += m_Gamepad[i].fX1;
      m_DefaultGamepad.fY1 += m_Gamepad[i].fY1;
      m_DefaultGamepad.fX2 += m_Gamepad[i].fX2;
      m_DefaultGamepad.fY2 += m_Gamepad[i].fY2;
      m_DefaultGamepad.wButtons        |= m_Gamepad[i].wButtons;
      m_DefaultGamepad.wPressedButtons |= m_Gamepad[i].wPressedButtons;
      m_DefaultGamepad.wLastButtons    |= m_Gamepad[i].wLastButtons;

      for( DWORD b=0; b<8; b++ ) {
        m_DefaultGamepad.bAnalogButtons[b]        |= m_Gamepad[i].bAnalogButtons[b];
        m_DefaultGamepad.bPressedAnalogButtons[b] |= m_Gamepad[i].bPressedAnalogButtons[b];
        m_DefaultGamepad.bLastAnalogButtons[b]    |= m_Gamepad[i].bLastAnalogButtons[b];
      }
    }
  }

  // Clamp summed thumbstick values to proper range
  m_DefaultGamepad.sThumbLX = SHORT( nThumbLX );
  m_DefaultGamepad.sThumbLY = SHORT( nThumbLY );
  m_DefaultGamepad.sThumbRX = SHORT( nThumbRX );
  m_DefaultGamepad.sThumbRY = SHORT( nThumbRY );

  // Handle special input combo to trigger a reboot to the Xbox Dashboard
  if( m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER] > 0 ) {
    if( m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER] > 0 ) {
      if( m_DefaultGamepad.bPressedAnalogButtons[XINPUT_GAMEPAD_BLACK] ) {
        LD_LAUNCH_DASHBOARD LaunchData = { XLD_LAUNCH_DASHBOARD_MAIN_MENU };
        XLaunchNewImage( NULL, (LAUNCH_DATA*)&LaunchData );
      }
    }
  }

  if(m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_START) m_inmenu=1;

  //fill up UAE's vars
  if(!m_inmenu) {
    if(m_port0==0) {
      // mouse
#ifdef XBOX_USB_MOUSE
		mouse_update();
#else
	  buttonstate[0] = m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_B ]>0;  //mouse left button
      buttonstate[2] = m_DefaultGamepad.bAnalogButtons[ XINPUT_GAMEPAD_X ]>0;  //mouse right button
#endif
      if(!m_mouse_swap)
      {
#ifndef XBOX_USB_MOUSE
        lastmx+=m_DefaultGamepad.sThumbLX/(256<<(5-m_mouse_sensitivity));
        lastmy-=m_DefaultGamepad.sThumbLY/(256<<(5-m_mouse_sensitivity));
#endif
      } 
      else 
      {
        int left = 0, right = 0, top = 0, bot = 0; 
        static float addval=1;
        top=(m_DefaultGamepad.wButtons&XINPUT_GAMEPAD_DPAD_UP)>0;
        bot=(m_DefaultGamepad.wButtons&XINPUT_GAMEPAD_DPAD_DOWN)>0;
        left=(m_DefaultGamepad.wButtons&XINPUT_GAMEPAD_DPAD_LEFT)>0;
        right=(m_DefaultGamepad.wButtons&XINPUT_GAMEPAD_DPAD_RIGHT)>0;
        if(!top && !bot && !left && !right) addval=1;
        addval+=(float)(m_mouse_sensitivity+1)/10;
        if(addval>8) addval=8;
        if(top) lastmy-=(int)addval;
        if(bot) lastmy+=(int)addval;
        if(left) lastmx-=(int)addval;
        if(right) lastmx+=(int)addval;
      }
    }

//Zhevon:14/06/03

    const int AMIGA_KEY[] = { 
       AK_A, AK_B, AK_C, AK_D, AK_E, AK_F, AK_G, AK_H, AK_I, AK_J, AK_K, AK_L, AK_M, AK_N, AK_O, AK_P, AK_Q, 
       AK_R, AK_S, AK_T, AK_U, AK_V, AK_W, AK_X, AK_Y, AK_Z, AK_0, AK_1, AK_2, AK_3, AK_4, AK_5, AK_6, AK_7, AK_8, AK_9, 
       AK_F1, AK_F2, AK_F3, AK_F4, AK_F5, AK_F6, AK_F7, AK_F8, AK_F9, AK_F10, AK_UP, AK_DN, AK_LF, AK_RT, 
       AK_SPC, AK_BS, AK_TAB, AK_RET, AK_ESC, AK_DEL, AK_LSH, AK_RSH, AK_CAPSLOCK, AK_LALT, AK_RALT, AK_LAMI, AK_RAMI, AK_HELP, 
       AK_NP0, AK_NP1, AK_NP2, AK_NP3, AK_NP4, AK_NP5, AK_NP6, AK_NP7, AK_NP8, AK_NP9, 
       AK_NPDIV, AK_NPMUL, AK_NPSUB, AK_NPADD, AK_NPDEL, AK_NPLPAREN, AK_NPRPAREN, AK_ENT, 
       AK_LBRACKET, AK_RBRACKET, AK_SEMICOLON, AK_COMMA, AK_PERIOD, AK_SLASH, AK_BACKSLASH, 
       AK_QUOTE, AK_NUMBERSIGN, AK_LTGT, AK_BACKQUOTE, AK_MINUS, AK_EQUAL, 
    }; 
 
    const int charToAMIGA_KEY[] = { 
       'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 
       'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 
       VK_F1,VK_F2,VK_F3,VK_F4,VK_F5,VK_F6, VK_F7,VK_F8,VK_F9,VK_F10,VK_UP,VK_DOWN,VK_LEFT,VK_RIGHT, 
       VK_SPACE,VK_BACK,VK_TAB, VK_RETURN,VK_ESCAPE,VK_DELETE,VK_LSHIFT, VK_RSHIFT,VK_CAPITAL, VK_LMENU,VK_RMENU, VK_LWIN,VK_RWIN,VK_HOME, 
       VK_NUMPAD0, VK_NUMPAD1, VK_NUMPAD2, VK_NUMPAD3, VK_NUMPAD4, VK_NUMPAD5, VK_NUMPAD6, VK_NUMPAD7, VK_NUMPAD8, VK_NUMPAD9, 
       VK_DIVIDE, VK_MULTIPLY, VK_SUBTRACT, VK_ADD, VK_DECIMAL, VK_PRIOR, VK_NEXT, VK_SEPARATOR, 
       VK_OEM_4, VK_OEM_6, VK_OEM_1, VK_OEM_COMMA, VK_OEM_PERIOD, VK_OEM_2, VK_OEM_5, 
       VK_OEM_7, VK_OEM_PLUS, VK_OEM_MINUS, VK_OEM_3, VK_OEM_8, 
       -1 
    }; 
     
    XINPUT_DEBUG_KEYSTROKE inStroke = Keyboard_GetVKInput(); 
    int inKey=inStroke.VirtualKey; 
    int pressedKey=-1; 
    int lCheck = 0; 
 
    while (charToAMIGA_KEY[lCheck]!=-1) 
    { 
       if (charToAMIGA_KEY[lCheck]==inKey) 
       { 
          pressedKey = AMIGA_KEY[lCheck]; 
          break; 
       } 
       lCheck++; 
    } 
 
    if (pressedKey != -1) 
    { 
       if (inStroke.Flags & XINPUT_DEBUG_KEYSTROKE_FLAG_KEYUP) 
          record_key((pressedKey << 1)+1); 
       else 
          record_key(pressedKey << 1); 
       pressedKey = -1; 
    } 

//Zhevon:End:14/06/03

	  // Manage mapped keys
    for (int i=0; i<5; i++) {
      if (m_DefaultGamepad.bAnalogButtons[AMIGA_KEYS_GAMEPAD[i]]>0) {
			  if (associated_key[i] && !key_button_pressed[i]) {
				  key_button_pressed[i] = true;
				  record_key(AMIGA_KEYS_MAPPING[associated_key[i]] << 1);
			  }
		  }
		  else {
  			if (key_button_pressed[i]) {
				  key_button_pressed[i] = false;
				  record_key((AMIGA_KEYS_MAPPING[associated_key[i]] << 1) + 1);
			  }
		  }
	  }

    if(simulkey!=-1) {
      if(!simulkeywait) {
        record_key(AMIGA_KEYS_MAPPING[simulkey]<<1);
        simulkeywait=10; //10 frames to wait should be alright
      } else {
        simulkeywait--;
        if(!simulkeywait) {
          record_key((AMIGA_KEYS_MAPPING[simulkey]<<1)+1);
          simulkey=-1;
        }
      }
    }
  }
}

char configstr[512];
const char *mainmenu[]={
  "Insert floppy",
  "Reset amiga",
  "Map keys",
  "Simulate keypress",
  "Load state",
  "Save state",
  "Options",
  configstr,		//SnaX:14/06/03 - Multi Config Support
  "Quit UAE-X",
  NULL
};

char floppyitems[4][256];
char floppynr[256];
const char *floppymenu[]={
  floppyitems[0],
  floppyitems[1],
  floppyitems[2],
  floppyitems[3],
  floppynr,
  NULL
};

const char *nbfloppymenu[]={
  "1",
  "2",
  "3",
  "4",
  NULL
};

const char *mapkeysmenu[] = {
  "Map key to right trigger",
  "Map key to left trigger",
  "Map key to white button",
  "Map key to Y button",
  "Map key to black button",
  NULL
};

char showdrivesstr[256];
char antialiasstr[256];
char resolutionstr[256];
char port0str[256];
char mousesensstr[256];
char swapmousestr[256];
const char *optionsmenu[] = {
  showdrivesstr,
  antialiasstr,
  "Position/Resize",
  "Reset Position/Resize settings",
  resolutionstr,
  port0str,
  mousesensstr,
  swapmousestr,
  NULL,
};

const char *antialiasmenu[] = {
  "None",
  "2x MultiSample Linear Filter",
  "2x MultiSample Quincunx Filter",
  "2x SuperSample Linear Horizontal Filter",
  "2x SuperSample Linear Vertical Filter",
  "4x MultiSample Linear Filter",
  "4x MultiSample Gaussian Filter",
  "4x SuperSample Linear Filter",
  "4x SuperSample Gaussian Filter",
  "9x MultiSample Gaussian Filter",
  "9x SuperSample Gaussian Filter",
  NULL
};

int antialiasmodes[]={
  D3DMULTISAMPLE_NONE,
  D3DMULTISAMPLE_2_SAMPLES_MULTISAMPLE_LINEAR,
  D3DMULTISAMPLE_2_SAMPLES_MULTISAMPLE_QUINCUNX,
  D3DMULTISAMPLE_2_SAMPLES_SUPERSAMPLE_HORIZONTAL_LINEAR,
  D3DMULTISAMPLE_2_SAMPLES_SUPERSAMPLE_VERTICAL_LINEAR,
  D3DMULTISAMPLE_4_SAMPLES_MULTISAMPLE_LINEAR,
  D3DMULTISAMPLE_4_SAMPLES_MULTISAMPLE_GAUSSIAN,
  D3DMULTISAMPLE_4_SAMPLES_SUPERSAMPLE_LINEAR,
  D3DMULTISAMPLE_4_SAMPLES_SUPERSAMPLE_GAUSSIAN,
  D3DMULTISAMPLE_9_SAMPLES_MULTISAMPLE_GAUSSIAN,
  D3DMULTISAMPLE_9_SAMPLES_SUPERSAMPLE_GAUSSIAN,
};

const char *resolutionmenu[] = {
  "640X480",
  "720X576 (50hz)",
  "720X480",
  NULL
};

const char *yesnomenu[]= {
  "No",
  "Yes",
  NULL,
};

const char *port0menu[]={
  "Mouse",
  "2nd joystick",
  NULL,
};

int isdir(const char *name) {
  if(!name) return 0;
  if(!strcmp(name,"..")) return 1;
  if(name[strlen(name)-1]=='\\') return 1;
  return 0;
}
static int namecompare( const void *arg1, const void *arg2 )
{
  char *a=*(char **)arg1;
  char *b=*(char **)arg2;
  if(isdir(a)&&!isdir(b)) return -1;
  if(!isdir(a)&&isdir(b)) return 1;
  return _stricmp(a,b);
}

static char curfloppypath[1024]="d:\\disks\\";
static char tmpstr[4096];
static char *tmpnames[4096];

void CXBoxUae::HandleEvents() {
  ReadInput();
  FrameMove();

  if(m_inmenu) {
    // reset soundbuffer
    {
      DWORD locked;
	    void *buffer;

      m_pDSBuffer->Lock(0, m_stream_buffer_size, &buffer, &locked, NULL, NULL, 0);    
  	  memset(buffer, 0, locked);
    }

    while(1) {
      static int defres=0;

      sprintf(configstr,"Change Config: %s",m_config_file+11);

      int res=DoMenu(mainmenu,defres);

      if(res==-1) break;
      defres=res;
      if(res==0) {
        //insert floppy
        while(1) {
          for(int i=0;i<4;i++)
            sprintf(floppyitems[i],"Insert in DF%i: (%s)",i,changed_prefs.df[i]);
          sprintf(floppynr,"Nb of floppies: %i",currprefs.nr_floppies);

          int res=DoMenu(floppymenu);
          if(res==-1) break;

          if(res==4) {
            //change nb of floppy drives
            int res2=DoMenu(nbfloppymenu);
            if(res2!=-1) currprefs.nr_floppies=res2+1;
            continue;
          }

contflopmenu:
          //file menu
          memset(tmpnames,0,sizeof(tmpnames));

          //scan directory
          int nb=0;
          tmpnames[nb++]=strdup("<empty>");
          if(stricmp(curfloppypath,"d:\\disks\\")) tmpnames[nb++]=strdup("..");
          HANDLE hFind;	
	        WIN32_FIND_DATAA oFindData;
          wsprintf(tmpstr,"%s*",curfloppypath);
	        hFind = FindFirstFile(tmpstr, &oFindData);
          if(hFind!=INVALID_HANDLE_VALUE) {
            do {
              if(oFindData.dwFileAttributes&FILE_ATTRIBUTE_DIRECTORY) {
                wsprintf(tmpstr,"%s\\",oFindData.cFileName);
                tmpnames[nb++]=strdup(tmpstr);
              } else
                tmpnames[nb++]=strdup(oFindData.cFileName);
            } while(nb<4096 && FindNextFile(hFind, &oFindData));
          }
          FindClose(hFind);

          //sort it
          qsort( (void *)tmpnames, (size_t)nb, sizeof( char * ), namecompare );

          static int defres2=0;
          int res2=DoMenu((const char **)&tmpnames,defres2);
          if(res2>=0) {
            defres2=res2;
            if(!strcmp(tmpnames[res2],"<empty>")) {
              //eject floppy
              changed_prefs.df[res][0]=0;
            } else if(!strcmp(tmpnames[res2],"..")) {
              //go back one dir up
              char *p=curfloppypath+strlen(curfloppypath)-1;
              while(*(p-1)!='\\') p--;
              *p=0;
              for(int i=0;i<nb;i++) free(tmpnames[i]);
              defres2=0;
              goto contflopmenu;
            } else if(isdir(tmpnames[res2])) {
              //change directory
              strcat(curfloppypath,tmpnames[res2]);
              for(int i=0;i<nb;i++) free(tmpnames[i]);
              defres2=0;
              goto contflopmenu;
            } else {
              //insert the choosen floppy
              strcpy(changed_prefs.df[res],curfloppypath);
              strcat(changed_prefs.df[res],tmpnames[res2]);
            }
          }

          for(int i=0;i<nb;i++) free(tmpnames[i]);
        }
      }
      if(res==1) {
        //reset amiga
        uae_reset();
        break;
      }
	    if (res==2) {
		    //map keys
		    DoMapKeysMenu(mapkeysmenu);
	    }
      if (res==3) {
        //simulate keypress
        static int defres=0;
        int res=DoMenu(AMIGA_KEYS,defres);
        if(res>=0) {
          defres=res;
          simulkey=res;
          simulkeywait=0;
          break;
        }
      }
      if(res==4) {
        //load state

        //file menu
        memset(tmpnames,0,sizeof(tmpnames));

        //scan directory
        int nb=0;
        HANDLE hFind;	
        WIN32_FIND_DATAA oFindData;
        hFind = FindFirstFile("T:\\*.uae", &oFindData);
        if(hFind!=INVALID_HANDLE_VALUE) {
          do {
            tmpnames[nb++]=strdup(oFindData.cFileName);
          } while(nb<4096 && FindNextFile(hFind, &oFindData));
        }
        FindClose(hFind);

        //sort it
        qsort( (void *)tmpnames, (size_t)nb, sizeof( char * ), namecompare );

        static int defres2=0;
        int res2=DoMenu((const char **)&tmpnames,defres2);
        if(res2>=0) {
          defres2=res2;

          //load uaex's specific vars
          {
            wsprintf(tmpstr,"T:\\%sx",tmpnames[res2]);
            FILE *fh=fopen(tmpstr,"rb");
            if(fh) {
              fread(associated_key,sizeof(associated_key),1,fh); // key mappings
              fclose(fh);
            }
          }
          //load uae's specific stuff at next VBL
          wsprintf(m_savestatefile,"T:\\%s",tmpnames[res2]);
          savestate_filename=m_savestatefile;
          savestate_state = STATE_DORESTORE;

          for(int i=0;i<nb;i++) free(tmpnames[i]);
          break;
        }

        for(int i=0;i<nb;i++) free(tmpnames[i]);
      }
      if(res==5) {
        //save state
        char name[1024];

        //file menu
        memset(tmpnames,0,sizeof(tmpnames));

        //scan directory
        int nb=0;
        tmpnames[nb++]=strdup("<new>");
        HANDLE hFind;	
        WIN32_FIND_DATAA oFindData;
        hFind = FindFirstFile("T:\\*.uae", &oFindData);
        if(hFind!=INVALID_HANDLE_VALUE) {
          do {
            tmpnames[nb++]=strdup(oFindData.cFileName);
          } while(nb<4096 && FindNextFile(hFind, &oFindData));
        }
        FindClose(hFind);

        //sort it
        qsort( (void *)tmpnames, (size_t)nb, sizeof( char * ), namecompare );

cancelled:
        static int defres2=0;
        int res2=DoMenu((const char **)&tmpnames,defres2);
        if(res2>=0) {
          defres2=res2;
          if(!strcmp(tmpnames[res2],"<new>")) {
            if(!EnterName(name)) goto cancelled; //yeah I know, I hate goto's too
            strcat(name,".uae");
          } else strcpy(name,tmpnames[res2]);

          //save uaex's specific vars
          {
            wsprintf(tmpstr,"T:\\%sx",name);
            FILE *fh=fopen(tmpstr,"wb");
            if(fh) {
              fwrite(associated_key,sizeof(associated_key),1,fh); // key mappings
              fclose(fh);
            }
          }
          //save uae's specific stuff at next VBL
          wsprintf(m_savestatefile,"T:\\%s",name);
          savestate_filename=m_savestatefile;
          savestate_state = STATE_DOSAVE;
          for(int i=0;i<nb;i++) free(tmpnames[i]);
          break;
        }
        for(int i=0;i<nb;i++) free(tmpnames[i]);
      }
      if(res==6) {
        //options
        while(1) {
          wsprintf(showdrivesstr,"Show drives status: %s",yesnomenu[g_draw_status]);
          wsprintf(antialiasstr,"Antialias mode: %s",antialiasmenu[m_antialias]);
          wsprintf(resolutionstr,"Resolution: %s",resolutionmenu[m_resolution]);
          wsprintf(port0str,"Joystick port 0: %s",port0menu[m_port0]);
          wsprintf(mousesensstr,"Mouse sensitivity: %d",m_mouse_sensitivity);
          wsprintf(swapmousestr,"Swap mouse/joystick thumb sticks: %s",yesnomenu[m_mouse_swap]);

          static int defres=0;
          int res=DoMenu(optionsmenu,defres);
          if(res>=0) {
            defres=res;
            if(res==0) g_draw_status=!g_draw_status;
            if(res==1) {
              int res2=DoMenu(antialiasmenu,m_antialias);
              if(res2>=0) {
                m_antialias=res2;
                m_d3dpp.MultiSampleType = antialiasmodes[m_antialias];
                m_pd3dDevice->Reset( &m_d3dpp );
              }
            }
            if(res==2) {
              //position/resize
              DoResize();
            }
            if(res==3) {
              //reset position/resize settings
              ResetResizeSettings();
            }
            if(res==4) {
              //resolution
              int res3=DoMenu(resolutionmenu,m_resolution);
              if(res3>=0) {
				        m_resolution=res3;
                ChangeResolution();
			        }
            }
            if(res==5) {
              //mouse emulation
              m_port0=!m_port0;
              switch(m_port0) {
              case 0: changed_prefs.jport0=2; break; //mouse
              case 1: changed_prefs.jport0=1; break; //2nd joystick
              }
            }
            if(res==6) {
              //mouse sensitivity
              m_mouse_sensitivity=(m_mouse_sensitivity+1)%4;
            }
            if(res==7) {
              m_mouse_swap=!m_mouse_swap;
            }
          } else break;
        }
        SaveOptions();
      }
//SnaX:14/06/03 - Config Change Support
  	  if(res==7)
  	  {
		   //change config
           memset(tmpnames,0,sizeof(tmpnames));
  
           //scan directory
           int nb=0;
           HANDLE hFind;	
 	       WIN32_FIND_DATAA oFindData;
		   wsprintf(tmpstr,"d:\\configs\\*");
		   hFind = FindFirstFile(tmpstr, &oFindData);
           if(hFind!=INVALID_HANDLE_VALUE) {
             do {
                 tmpnames[nb++]=strdup(oFindData.cFileName);
             } while(nb<4096 && FindNextFile(hFind, &oFindData));
           }
           FindClose(hFind);
 
           //sort it
           qsort( (void *)tmpnames, (size_t)nb, sizeof( char * ), namecompare );
 
           static int defres2=0;
           int res2=DoMenu((const char **)&tmpnames,defres2);
 
 		  if(res2>=0) 
 		  {
           defres2=res2;
           wsprintf(m_config_file,"d:\\configs\\%s",tmpnames[res2]);
           SaveOptions();
 
 		  LAUNCH_DATA reLaunchData;
 
 		  reLaunchData.Data[0]=(BYTE)'U';
 		  reLaunchData.Data[1]=(BYTE)'A';
 		  reLaunchData.Data[2]=(BYTE)'E';
 		  reLaunchData.Data[3]=(BYTE)'X';
 		  strcpy((char *)&reLaunchData.Data[4],m_config_file);
 
 		  for(int i=0;i<nb;i++) free(tmpnames[i]);
 
 		  XLaunchNewImage( "d:\\default.xbe", (LAUNCH_DATA*)&reLaunchData );
           break;
         }
 		  
 	  }
       if(res==8) {
//SnaX:End:14/06/03
        //quit
          LD_LAUNCH_DASHBOARD LaunchData = { XLD_LAUNCH_DASHBOARD_MAIN_MENU };
          XLaunchNewImage( NULL, (LAUNCH_DATA*)&LaunchData );
      }
    }

    //reset sound stuff
    m_towait=-1;
    m_stream_buffer_in=0;

    m_inmenu=0;
  }
}

int CXBoxUae::DoMenu(const char **menu, int defsel) {
  int sel=defsel;
  int offs=0;
  const int maxitems=15;
  DWORD time=0;
  bool need_redraw = true;  

  if(sel>=maxitems) {
    offs=sel;
  }

  while(1) {
    ReadInput();

    if (need_redraw) render(true);

    m_Font.DrawText(200,40,0x7fffffff,L"UAE-X " UAEXVERSION);

    int y=100;
    for(int i=0;menu[i+offs] && i<maxitems;i++) {
      WCHAR blah[256];
      mbstowcs(blah,menu[i+offs],256);
      m_Font.DrawText(  128, (float)y, (i+offs)==sel?0xffffffff:0x7fffffff, blah );
      y+=20;
    }

    // Present the scene
    if (need_redraw) {
      m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
      need_redraw = false;
    }

    // check buttons
    if(m_DefaultGamepad.bPressedAnalogButtons[ XINPUT_GAMEPAD_A ]>0) return sel;
    if(m_DefaultGamepad.bPressedAnalogButtons[ XINPUT_GAMEPAD_B ]>0) return -1;
  
    int down1=(m_DefaultGamepad.wPressedButtons&XINPUT_GAMEPAD_DPAD_DOWN)>0;
    int down2=m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]>0;
    if((down1 || down2) && menu[sel+1]) {
      //go down
      if(down1 || (down2&&(GetTickCount()-time>15))) {
        sel++;
        if(sel>=(offs+maxitems)) offs++;
        time=GetTickCount();
        need_redraw = true;
      }
    }
    int up1=(m_DefaultGamepad.wPressedButtons&XINPUT_GAMEPAD_DPAD_UP)>0;
    int up2=m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]>0;
    if((up1||up2) && sel>0) {
      //go up
      if(up1 || (up2&&(GetTickCount()-time>15))) {
        sel--;
        if(sel<offs) offs=sel;
        time=GetTickCount();
        need_redraw = true;
      }
    }
  }
}

int CXBoxUae::DoMapKeysMenu(const char **menu) {
  int sel=0;
  int offs=0;
  const int maxitems=15;
  DWORD time=0;
  bool need_redraw = true;  

  while(1) {
    ReadInput();

    if (need_redraw) render(true);

    int y=100;
    for(int i=0;menu[i+offs] && i<maxitems;i++) {
      WCHAR blah[256];
      char tempo[100];
      sprintf(tempo, "%s : %s", menu[i+offs], AMIGA_KEYS[associated_key[i]]);
      mbstowcs(blah, tempo,256);
      m_Font.DrawText(  128, (float)y, (i+offs)==sel?0xffffffff:0x7fffffff, blah );
      y+=20;
    }

    // Present the scene
    if (need_redraw) {
      m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
      need_redraw = false;
    }

    // check keys buttons
    if ((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT) > 0) {
      associated_key[sel]++;
      if (associated_key[sel] > MAX_KEYS) associated_key[sel] = 0;
      need_redraw = true;
    }
    if ((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT) > 0) {
      associated_key[sel]--;
      if (associated_key[sel] < 0) associated_key[sel] = MAX_KEYS;
      need_redraw = true;
    }

    // check buttons
    if(m_DefaultGamepad.bPressedAnalogButtons[ XINPUT_GAMEPAD_A ]>0) return sel;
    if(m_DefaultGamepad.bPressedAnalogButtons[ XINPUT_GAMEPAD_B ]>0) return -1;
  
    int down1=(m_DefaultGamepad.wPressedButtons&XINPUT_GAMEPAD_DPAD_DOWN)>0;
    int down2=m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_RIGHT_TRIGGER]>0;
    if((down1 || down2) && menu[sel+1]) {
      //go down
      if(down1 || (down2&&(GetTickCount()-time>30))) {
        sel++;
        if(sel>=(offs+maxitems)) offs++;
        time=GetTickCount();
        need_redraw = true;
      }
    }
    int up1=(m_DefaultGamepad.wPressedButtons&XINPUT_GAMEPAD_DPAD_UP)>0;
    int up2=m_DefaultGamepad.bAnalogButtons[XINPUT_GAMEPAD_LEFT_TRIGGER]>0;
    if((up1||up2) && sel>0) {
      //go up
      if(up1 || (up2&&(GetTickCount()-time>30))) {
        sel--;
        if(sel<offs) offs=sel;
        time=GetTickCount();
        need_redraw = true;
      }
    }
  }
}

int CXBoxUae::EnterName(char *dest) {
  bool need_redraw = true;  
  int posx=0,posy=0;

  dest[0]=0;

  const char *letters[]= {
    "ABCDEFGHIJKLM",
    "NOPQRSTUVWXYZ",
    "abcdefghijklm",
    "nopqrstuvwxyz",
    "0123456789",
    NULL
  };

  while(1) {
    ReadInput();

    if (need_redraw) render(true);

    WCHAR blah[256];
    char tempo[256];

    //display name
    sprintf(tempo, "Name: %s", dest);
    mbstowcs(blah, tempo,256);
    m_Font.DrawText(  128, 100, 0x7fffffff, blah );
    
    //display keys
    int y=150;
    for(int i=0;letters[i];i++) {
      int x=180;
      for(int j=0;j<(int)strlen(letters[i]);j++) {
        sprintf(tempo, "%c", letters[i][j]);
        mbstowcs(blah, tempo,256);
        m_Font.DrawText(  (float)x, (float)y, (posx==j&&posy==i)?0xffffffff:0x7fffffff, blah );
        x+=20;
      }
      y+=20;
    }

    m_Font.DrawText(  180, 280, posy==5?0xffffffff:0x7fffffff, L"Backspace");
    m_Font.DrawText(  180, 320, posy==6?0xffffffff:0x7fffffff, L"Save");

    // Present the scene
    if (need_redraw) {
      m_pd3dDevice->Present( NULL, NULL, NULL, NULL );
      need_redraw = false;
    }

    if ((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_RIGHT) > 0) {
      posx++;
      need_redraw=true;
    }
    if ((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_LEFT) > 0) {
      posx--;
      need_redraw=true;
    }
    if ((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_DOWN) > 0) {
      posy++;
      need_redraw=true;
    }
    if ((m_DefaultGamepad.wPressedButtons & XINPUT_GAMEPAD_DPAD_UP) > 0) {
      posy--;
      need_redraw=true;
    }

    if(posx<0) posx=0;
    if(posy<5 && posx>=(int)strlen(letters[posy])) posx=strlen(letters[posy])-1;

    if(posy<0) posy=0;
    if(posy>6) posy=6;

    if(m_DefaultGamepad.bPressedAnalogButtons[ XINPUT_GAMEPAD_B ]>0) return 0;

    if(m_DefaultGamepad.bPressedAnalogButtons[ XINPUT_GAMEPAD_A ]>0) {
      if(posy<5) {
        int l=strlen(dest);
        dest[l]=letters[posy][posx];
        dest[l+1]=0;
        need_redraw=true;
      } else {
        if(posy==5) {
          //del
          if(strlen(dest)>0) dest[strlen(dest)-1]=0;
          need_redraw=true;
        }
        if(posy==6) {
          //enter
          if(dest[0]) return 1;
        }
      }
    }
  }

  return 0;
}

void CXBoxUae::DoResize() {
  m_resizing=1;

  while(1) {
    ReadInput();

    render(false);

    m_Font.DrawText(  128, 128, 0x7fffffff, L"Change position using the left thumb stick");
    m_Font.DrawText(  128, 148, 0x7fffffff, L"Resize using the right thumb stick");

    m_pd3dDevice->Present( NULL, NULL, NULL, NULL );

    m_scrstretchx-=m_DefaultGamepad.sThumbRX/8192;
    m_scrstretchy+=m_DefaultGamepad.sThumbRY/8192;
    m_scroffsx+=m_DefaultGamepad.sThumbLX/8192;
    m_scroffsy-=m_DefaultGamepad.sThumbLY/8192;
    m_scroffschanged=1;

    if(m_DefaultGamepad.bPressedAnalogButtons[ XINPUT_GAMEPAD_B ]>0) break;
    if(m_DefaultGamepad.bPressedAnalogButtons[ XINPUT_GAMEPAD_A ]>0) break;
  }

  m_resizing=0;
}

void CXBoxUae::read_joystick(int nr, unsigned int *dir, int *button)
{
  *dir = 0;
  *button = 0;
  if (nr >= nr_joysticks)	return;

  XBGAMEPAD gp=m_Gamepad[nr];
  
  *button=gp.bAnalogButtons[ XINPUT_GAMEPAD_A ]>0;

  int left = 0, right = 0, top = 0, bot = 0; 
  if(!m_mouse_swap)
  {
    top=(gp.wButtons&XINPUT_GAMEPAD_DPAD_UP)>0;
    bot=(gp.wButtons&XINPUT_GAMEPAD_DPAD_DOWN)>0;
    left=(gp.wButtons&XINPUT_GAMEPAD_DPAD_LEFT)>0;
    right=(gp.wButtons&XINPUT_GAMEPAD_DPAD_RIGHT)>0;
  } else {
    top=gp.sThumbLY>XINPUT_DEADZONE;
    bot=gp.sThumbLY<-XINPUT_DEADZONE;
    left=gp.sThumbLX<-XINPUT_DEADZONE;
    right=gp.sThumbLX>XINPUT_DEADZONE;
  }
  if (left) top = !top;
  if (right) bot = !bot;
  *dir = bot | (right << 1) | (top << 8) | (left << 9);   
}

void CXBoxUae::write_sound() {
  DWORD bytes_to_copy=sndbufsize;

  void *buffer1, *buffer2;
  DWORD length1, length2;
  HRESULT result;
  int cur_bytes;
  short *data=(short *)sndbuffer;

  int setto0=0;
  if(m_towait!=-1) {
    DWORD playPos, writePos;
    do {
      if(m_pDSBuffer->GetCurrentPosition(&playPos,&writePos)!=DS_OK) break;
    } while((int)playPos<m_towait);
  } else {
    setto0=1; //sound init
  }
  
	// attempt to lock the stream buffer
  do {
    result = m_pDSBuffer->Lock(m_stream_buffer_in, bytes_to_copy, &buffer1, &length1, &buffer2, &length2, 0);
  } while (result!=DS_OK);
  
  // adjust the input pointer
	m_stream_buffer_in = (m_stream_buffer_in + bytes_to_copy) % m_stream_buffer_size;

  // set the position to wait next frame to keep emulation smoothly in sync
  m_towait=m_stream_buffer_in-128;//-(bytes_to_copy/2);
  if(m_towait<0) m_towait+=m_stream_buffer_size;
	
	// copy the first chunk
	cur_bytes = (bytes_to_copy > length1) ? length1 : bytes_to_copy;
	memcpy(buffer1, data, cur_bytes);
  	
	// adjust for the number of bytes
	bytes_to_copy -= cur_bytes;
	data = (short *)((unsigned char *)data + cur_bytes);
	
	// copy the second chunk
	if (bytes_to_copy != 0)
	{
    cur_bytes = (bytes_to_copy > length2) ? length2 : bytes_to_copy;
		memcpy(buffer2, data, cur_bytes);
    bytes_to_copy-=cur_bytes;
	}

  if(setto0) {
    m_pDSBuffer->SetCurrentPosition(0);
  }
}

void CXBoxUae::ChangeResolution() {
  switch(m_resolution) {
  case 0:
    m_resolutionwidth=640;
    m_resolutionheight=480;
    break;
  case 1:
    m_resolutionwidth=720;
    m_resolutionheight=576;
    break;
  case 2:
    m_resolutionwidth=720;
    m_resolutionheight=480;
    break;
  }

  // Adjust presentation parameters
  m_d3dpp.BackBufferWidth = m_resolutionwidth;
  m_d3dpp.BackBufferHeight = m_resolutionheight;
  m_d3dpp.Flags = FALSE ? D3DPRESENTFLAG_PROGRESSIVE : D3DPRESENTFLAG_INTERLACED;
  m_d3dpp.Flags |= FALSE ? D3DPRESENTFLAG_WIDESCREEN : 0;
 
  if (m_resolution==1) { // 720X576 doesn't support pal 60
    m_d3dpp.FullScreen_RefreshRateInHz = 50; 
  } else {
	  if(XGetVideoStandard() == XC_VIDEO_STANDARD_PAL_I)        // PAL user
	  {
      DWORD videoFlags = XGetVideoFlags();
      if(videoFlags & XC_VIDEO_FLAGS_PAL_60Hz)                // PAL 60 user
        m_d3dpp.FullScreen_RefreshRateInHz = 60;
      else
        m_d3dpp.FullScreen_RefreshRateInHz = 50;
    }
  }

  // Reset the device
  m_pd3dDevice->Reset( &m_d3dpp );

  m_scroffschanged=1;
}

void CXBoxUae::ResetResizeSettings() {
  m_scroffsx=m_scroffsy=m_scrstretchx=m_scrstretchy=0;
  m_scroffschanged=1;
}


#ifdef XBOX_USB_MOUSE

void InitMouse(void)
{
	DWORD i;
	DWORD dwDeviceMask;

	// set up mouse

	dwDeviceMask = XGetDevices( XDEVICE_TYPE_DEBUG_MOUSE );

	// Open the devices
    for( i=0; i < XGetPortCount(); i++ )
    {
        if( dwDeviceMask & (1<<i) ) 
        {
            // Now open the device
            XINPUT_POLLING_PARAMETERS pollValues;
            pollValues.fAutoPoll       = TRUE;
            pollValues.fInterruptOut   = TRUE;
            pollValues.bInputInterval  = 32;  
            pollValues.bOutputInterval = 32;
            pollValues.ReservedMBZ1    = 0;
            pollValues.ReservedMBZ2    = 0;

            g_hMouseDevice[i] = XInputOpen( XDEVICE_TYPE_DEBUG_MOUSE, i, 
                                            XDEVICE_NO_SLOT, &pollValues );
        }
    }
 
}

void Mouse_RefreshDeviceList()
{

    // Get status about gamepad insertions and removals. Note that, in order to
    // not miss devices, we will check for removed device BEFORE checking for
    // insertions

	DWORD i;
    DWORD dwInsertions, dwRemovals;
    XGetDeviceChanges( XDEVICE_TYPE_DEBUG_MOUSE, &dwInsertions, &dwRemovals );

    // Loop through all ports
    for( i=0; i < XGetPortCount(); i++ )
    {
        // Handle removed devices.
        if( dwRemovals & (1<<i) )
        {
            XInputClose( g_hMouseDevice[i] );
            g_hMouseDevice[i] = NULL;
        }

        // Handle inserted devices
        if( dwInsertions & (1<<i) )
        {
            // Now open the device
            XINPUT_POLLING_PARAMETERS pollValues;
            pollValues.fAutoPoll       = TRUE;
            pollValues.fInterruptOut   = TRUE;
            pollValues.bInputInterval  = 32;  
            pollValues.bOutputInterval = 32;
            pollValues.ReservedMBZ1    = 0;
            pollValues.ReservedMBZ2    = 0;

            g_hMouseDevice[i] = XInputOpen( XDEVICE_TYPE_DEBUG_MOUSE, i, 
                                            XDEVICE_NO_SLOT, &pollValues );
        }

         
    }
 
}


void mouse_update(void)
{
 	int i;
	static int prev_buttons;
	static int lastmouseX, lastmouseY;
	int mouseX, mouseY;
 
	Mouse_RefreshDeviceList();
   
	 // Loop through all gamepads
    for( i=0; i < XGetPortCount(); i++ )
    {
        // If we have a valid device, poll it's state and track button changes
        if( g_hMouseDevice[i] )
        {
            // Read the input state
            XInputGetState( g_hMouseDevice[i], &g_MouseStates[i] );
			
			mouseX = mouseY = 0;

            // Copy gamepad to local structure
            memcpy( &g_MouseInput, &g_MouseStates[i].DebugMouse, sizeof(XINPUT_MOUSE) );

			if ((lastmouseX == g_MouseInput.cMickeysX) &&
				(lastmouseY == g_MouseInput.cMickeysY))
				mouseX = mouseY = 0;
			else
			{
				mouseX = g_MouseInput.cMickeysX;
				mouseY = g_MouseInput.cMickeysY;

				lastmx += mouseX;
				lastmy += mouseY;
			}
 
			if (g_MouseInput.bButtons & XINPUT_DEBUG_MOUSE_LEFT_BUTTON)
				buttonstate[0] = 1;
			else
				buttonstate[0] = 0;

			if (g_MouseInput.bButtons & XINPUT_DEBUG_MOUSE_MIDDLE_BUTTON)
				buttonstate[1] = 1;
			else
				buttonstate[1] = 0;

			if (g_MouseInput.bButtons & XINPUT_DEBUG_MOUSE_RIGHT_BUTTON)
				buttonstate[2] = 1;
			else
				buttonstate[2] = 0;
 
			lastmouseX = g_MouseInput.cMickeysX;
			lastmouseY = g_MouseInput.cMickeysY;

			
        }
    }
 
}

#endif