#include "burnint.h"
#include "burn_sound.h"

#define CLIP(A) ((A) < -0x8000 ? -0x8000 : (A) > 0x7fff ? 0x7fff : (A))

void BurnSoundCopyClamp_C(int *Src, short *Dest, int Len)
{
   Len = Len << 1;
   do{
      Len--;
		*Dest = CLIP((*Src >> 8));
		Src++;
		Dest++;
	}while(Len);
}

void BurnSoundCopyClamp_Add_C(int *Src, short *Dest, int Len)
{
   Len = Len << 1;
   do{
      Len--;
		*Dest = CLIP((*Src >> 8) + *Dest);
		Src++;
		Dest++;
	}while(Len);
}

void BurnSoundCopyClamp_Mono_C(int *Src, short *Dest, int Len)
{
   do{
      Len--;
		Dest[0] = CLIP((*Src >> 8));
		Dest[1] = CLIP((*Src >> 8));
		Src++;
		Dest += 2;
	}while(Len);
}

void BurnSoundCopyClamp_Mono_Add_C(int *Src, short *Dest, int Len)
{
   do{
      Len--;
		Dest[0] = CLIP((*Src >> 8) + Dest[0]);
		Dest[1] = CLIP((*Src >> 8) + Dest[1]);
		Src++;
		Dest += 2;
	}while(Len);
}

// converted by regret, thanks to XingXing
void BurnSoundCopy_FM_C(short* SrcL, short* SrcR, short* Dest, int Len, int VolL, int VolR)
{
	int volL = VolL >> 10;
	int volR = VolR >> 10;

   do{
      Len--;
		Dest[0] = CLIP((*SrcL * volL) >> 8);
		Dest[1] = CLIP((*SrcR * volR) >> 8);
		SrcL++;
		SrcR++;
		Dest += 2;
	}while(Len);
}

void BurnSoundCopy_FM_Add_C(short* SrcL, short* SrcR, short* Dest, int Len, int VolL, int VolR)
{
	int volL = VolL >> 10;
	int volR = VolR >> 10;

   do{
      Len--;
		Dest[0] = CLIP(((*SrcL * volL) >> 8) + Dest[0]);
		Dest[1] = CLIP(((*SrcR * volR) >> 8) + Dest[1]);
		SrcL++;
		SrcR++;
		Dest += 2;
	}while(Len);
}

#undef CLIP
