@echo off
if not exist default_orig.xbe goto err1
if exist default.xbe del default.xbe
if exist default.tmp del default.tmp
if exist out.xbe del out.xbe

@echo Applying patch (default_orig.xbe to default.xbe)
copy /b default_orig.xbe default.tmp

if exist patch.bin del patch.bin
..\bin\nasm -f bin -o patch.bin patch.asm


rem #
rem # poke .xbe header to include space for my patch binary at end
rem #
..\bin\poke default.tmp 0x0010c 0x00 0x99
..\bin\poke default.tmp 0x0035c 0x00 0x89
..\bin\poke default.tmp 0x00364 0x00 0x89


rem #
rem # patch-in jump to my code
rem #
..\bin\poke default.tmp 0x02844 0xe9 0xb7 0x6e 0x0a 0x00

rem #
rem # add RtlInitAnsiString to kernel import table
rem #
..\bin\poke default.tmp 0x02c6b 0x21 0x01 0x00 0x80


rem #
rem # patch-in my code (from patch.asm)
rem #
..\bin\poke default.tmp 0xa9700 @patch.bin

..\bin\xbe default.tmp -wb
ren out.xbe default.xbe
del default.tmp
echo Success!  Use default.xbe to generate evoxdump.bin

goto end

:err1
echo Missing file default_orig.xbe!

:end
