
BITS	32
	cpu	586

	segment	code



;typedef struct tagANSI_STRING {
;	USHORT	Length;
;	USHORT	MaximumLength;
;	PCHAR	Buffer;
;} ANSI_STRING;

struc	ANSI_STRING
	.Length	resw	1
	.MaximumLength	resw	1
	.Buffer	resd	1
	.Size:
endstruc

;typedef struct tagOBJECT_ATTRIBUTES {
;	HANDLE	RootDirectory;
;	ANSI_STRING	*ObjectName;
;	ULONG	Attributes;
;} OBJECT_ATTRIBUTES;

struc	OBJECT_ATTRIBUTES
	.RootDirectory	resd	1
	.ObjectName	resd	1
	.Attributes	resd	1
	.Size:
endstruc

;typedef struct tagIO_STATUS_BLOCK {
;	union {
;		unsigned int	Status;
;		PVOID	Pointer;
;	} u1;
;	ULONG_PTR	Information;
;} IO_STATUS_BLOCK;

struc	IO_STATUS_BLOCK
	.u1	resd	1
	.Information	resd	1
	.Size:
endstruc

struc HANDLE
	.Handle	resd	1
	.Size:
endstruc

struc LARGE_INTEGER
	.QuadPart	resd	2
	.Size:
endstruc

; poke to file offset: 0980

imp_IoCreateSymbolicLink	equ	0x796e4
orig_create_symlinks_1	equ	0x1bd50
orig_create_symlinks_2	equ	0x1bf90


	org	0x10980

My_jump_table:
	jmp	My_create_symlinks_1	;@ = 00010980
	jmp	My_create_symlinks_2	;@ = 00010985
	jmp	Out_ftp_dir_line		;@ = 0001098a
	jmp	Out_ftp_dir_line_F	;@ = 0001098f
	jmp	Get_partition_start	;@ = 00010994
	jmp	Is_FATX_drive		;@ = 00010999
	jmp	Do_FTP_cmd_HDDINFO	;@ = 0001099e
	jmp	Get_ENV_array_name	;@ = 000109a3
	jmp	Get_ENV_array_value	;@ = 000109a8
	jmp	Make_F_G_free_space_strings	;@ = 000109ad
	jmp	Hook_F_G_free_space_into_menu	;@ = 000109b2
	jmp	Doformat_drive_letter_hook	;@ = 000109b7
	jmp	Another_drive_letter_hook	;@ = 000109bc

Sector_io_buffer	equ	0x53afa8
read_raw_hd_sector	equ	0x1bca0
aFatx	equ	0x7bbd8



sprintf	equ	0x2a8d7
FTP_dir_drive_format_string	equ	0x7cdcc
output_ftp_string	equ	0x246c0

Out_ftp_dir_line:
.arg0_bp_offset	equ	8
.arg1_bp_offset	equ	12
.l_buf_bp_offset	equ	-200
.stack_adjust	equ	(.l_buf_bp_offset-20)
	push	ebp
	mov	ebp,esp
	add	esp,.stack_adjust
	push	esi
	push	edi
	push	eax
	push	ebx
	push	ecx
	push	edx

	xor	eax,eax
	mov	al,[ebp+.arg1_bp_offset]
	push	eax
	push	FTP_dir_drive_format_string
	lea	eax,[ebp+.l_buf_bp_offset]
	push	eax
	call	sprintf
	add	esp,12

	lea	eax,[ebp+.l_buf_bp_offset]
	lea	edx,[eax+1]
.loop
	mov	cl,byte [eax]
	inc	eax
	test	cl,cl
	jnz	short .loop

	sub	eax,edx
	push	eax
	lea	eax,[ebp+.l_buf_bp_offset]
	push	eax
	mov	ebx,[ebp+.arg0_bp_offset]
	mov	ecx,ebx
	call	output_ftp_string

	pop	edx
	pop	ecx
	pop	ebx
	pop	eax
	pop	edi
	pop	esi
	mov	esp,ebp
	pop	ebp
	ret	8


;
;@00021e60: push ebx (53)
;@00021e61: call Out_ftp_dir_line_F (off=fffeeb29) (e8,29,eb,fe,ff)
;@00021e66: nop
;          ....
;@00021e8d: next insn
;
Out_ftp_dir_line_F:
.arg0_bp_offset	equ	8
	push	ebp
	mov	ebp,esp

	push	0x46
	mov	eax,[ebp+.arg0_bp_offset]
	push	eax
	call	Out_ftp_dir_line


	push	0x47
	mov	eax,[ebp+.arg0_bp_offset]
	push	eax
	call	Out_ftp_dir_line

	mov	esp,ebp
	pop	ebp
	ret	4

imp_NtDeviceIoControlFile	equ	0x797a8
imp_NtOpenFile			equ	0x796cc
imp_NtReadFile			equ	0x79764
imp_NtClose				equ	0x7970c


ansi_path_hd0_part0	equ	0x7d4e4


Get_partition_start:
.arg0_bp_offset	equ	8
.var_handle	equ	(0-HANDLE.Size)
.var_byte_offset	equ	(.var_handle-LARGE_INTEGER.Size)
.var_io_stat_block	equ	(.var_byte_offset-IO_STATUS_BLOCK.Size)
.var_obj_attr	equ	(.var_io_stat_block-OBJECT_ATTRIBUTES.Size)
.var_a_path	equ	(.var_obj_attr-ANSI_STRING.Size)
.stack_adjust	equ	.var_a_path
	push	ebp
	mov	ebp,esp
	add	esp,.stack_adjust
	push	esi
	push	edi
	push	ebx
	push	ecx
	push	edx

;;	jmp	.exit_error

;	obj_attr.RootDirectory = 0;
	xor	eax,eax
	mov	[ebp+.var_obj_attr+OBJECT_ATTRIBUTES.RootDirectory],eax

;	obj_attr.ObjectName = &a_path;
	mov	eax,ansi_path_hd0_part0
	mov	[ebp+.var_obj_attr+OBJECT_ATTRIBUTES.ObjectName],eax

;	obj_attr.Attributes = 0x40;
	mov	dword [ebp+.var_obj_attr+OBJECT_ATTRIBUTES.Attributes],0x40

;	NtOpenFile(&handle, 0x80100000, &obj_attr, &io_stat_block, 3, 0x10);
	push	0x10
	push	3
	lea	eax,[ebp+.var_io_stat_block]
	push	eax
	lea	eax,[ebp+.var_obj_attr]
	push	eax
	push	0x80100000
	lea	eax,[ebp+.var_handle]
	push	eax
	call	dword [imp_NtOpenFile]
	cmp	eax,0
	jl	.j_exit_error
	jmp	short	.no_error
.j_exit_error:
	jmp	.exit_error
.no_error:

;	*(unsigned int *)Sector_io_buffer = 0;
;	*(unsigned int *)(Sector_io_buffer + 4) = 0;
;	*(unsigned int *)(Sector_io_buffer + 8) = 0;
	xor	eax,eax
	mov	dword [Sector_io_buffer],eax
	mov	dword [Sector_io_buffer+128],eax
	mov	dword [Sector_io_buffer+128+4],eax

;	NtDeviceIoControlFile(handle, 0, 0, 0, &io_stat_block, 0xcafebabe, Sector_io_buffer, 128, Sector_io_buffer+128, 128);

;;	mov	eax,0xffffffff
;;	jmp	short .skip_ioctl

	push	128
	push	Sector_io_buffer+128
	push	128
	push	Sector_io_buffer
	push	0xcafebabe
	lea	eax,[ebp+.var_io_stat_block]
	push	eax
	push	0
	push	0
	push	0
	mov	eax,[ebp+.var_handle]
	push	eax
	call	dword [imp_NtDeviceIoControlFile]
.skip_ioctl:
	test	eax,eax
	jnz	.exit_error_close

	mov	eax,[ebp+.var_handle]
	push	eax
	call	dword [imp_NtClose]

	mov	eax,dword [Sector_io_buffer+128]
	cmp	eax,0xcafebabe
	jnz	.exit_error

	mov	eax,dword [Sector_io_buffer+128+4]
	cmp	eax,0xbabeface
	jnz	.exit_error

	mov	eax,dword [Sector_io_buffer+128+12]	;LOWCODE_BASE
	add	eax,dword [Sector_io_buffer+128+24]	;offset to partition table
	add	eax,(16+32)
	mov	esi,eax					;points to first partition table entry

	mov	eax,[ebp+.arg0_bp_offset]
	dec	eax
	mov	ecx,32					;size of partition entry
	mul	ecx
	add	esi,eax					;points to selected partition

	mov	eax,dword [esi+20]
	jmp	short .exit


.exit_error_close
	mov	eax,[ebp+.var_handle]
	push	eax
	call	dword [imp_NtClose]

.exit_error:
	mov	eax,[ebp+.arg0_bp_offset]
	dec	eax
	shl	eax,2
	add	eax,.default_partition_starts
	mov	eax,dword [eax]
.exit:
	pop	edx
	pop	ecx
	pop	ebx
	pop	edi
	pop	esi
	mov	esp,ebp
	pop	ebp
	ret	4

.default_partition_starts:
	dd	0x0055f400	;partition1/E:
	dd	0x00465400	;partition2/C:
	dd	0x00000400	;partition3/X:
	dd	0x00177400	;partition4/Y:
	dd	0x002ee400	;partition5/Z:
	dd	0x00ee8ab0	;partition6/F:
	dd	0xffffffff	;partition7/G:
;;	dd	0x10800000




Is_FATX_drive:
.arg0_bp_offset	equ	8
.var_handle	equ	(0-HANDLE.Size)
.stack_adjust	equ	.var_handle
	push	ebp
	mov	ebp,esp
	add	esp,.stack_adjust
	push	esi
	push	edi
	push	ebx
	push	ecx
	push	edx

	mov	eax,[ebp+.arg0_bp_offset]
	push	eax
	call	Get_partition_start
	cmp	eax,0xffffffff
	jz	short .exit_false

	push	Sector_io_buffer
	push	eax
	xor	eax,eax
	mov	ecx,128
	mov	edi,Sector_io_buffer
	rep	stosd
	call	read_raw_hd_sector
	add	esp,8

	mov	ecx,Sector_io_buffer
	mov	edx,[ecx]
	mov	eax,aFatx
	mov	ecx,[eax]
	cmp	edx,ecx
	jnz	short .exit_false
	
.exit_true:
	mov	eax,1
	jmp	short .exit

.exit_false:
	xor	eax,eax

.exit:
	pop	edx
	pop	ecx
	pop	ebx
	pop	edi
	pop	esi
	mov	esp,ebp
	pop	ebp
	ret	4


Drive_flags_array	equ	0x53b1a8

;
My_create_symlinks_1:
	push	ebp
	mov	ebp,esp
	push	esi
	push	edi
	push	ebx
	push	ecx
	push	edx

	xor	esi,esi
.loop1:
	mov	byte [esi+Drive_flags_array],0x80
	inc	esi
	cmp	esi,7
	jb	.loop1

	call	My_create_symlinks_2
	xor	eax,eax
	mov	al,byte [Drive_flags_array+0]
	or	al,byte [Drive_flags_array+1]
	and	al,0x80

.exit:
	pop	edx
	pop	ecx
	pop	ebx
	pop	edi
	pop	esi
	mov	esp,ebp
	pop	ebp
	ret	0


;
My_create_symlinks_2:
	push	ebp
	mov	ebp,esp
	push	esi
	push	edi
	push	ebx
	push	ecx
	push	edx

	xor	esi,esi
.loop1:
	mov	al,byte [esi+Drive_flags_array]
	and	al,0x80
	test	al,al
	jz	short .already_mounted

	mov	eax,esi
	inc	eax
	push	eax
	call	Is_FATX_drive
	test	eax,eax
	jnz	.is_fatx

.drive_error:
	mov	byte [esi+Drive_flags_array],0x80
	jmp	short .c_loop

.is_fatx
	mov	eax,esi
	shl	eax,2
	add	eax,ansi_path_table
	mov	eax,[eax]
	push	eax
	mov	eax,esi
	shl	eax,2
	add	eax,ansi_drive_table
	mov	eax,[eax]
	push	eax
	call	dword [imp_IoCreateSymbolicLink]
	test	eax,eax
	jnz	short .drive_error

	mov	byte [esi+Drive_flags_array],0x0

.already_mounted
.c_loop:
	inc	esi
	cmp	esi,7
	jb	.loop1

.exit:
	pop	edx
	pop	ecx
	pop	ebx
	pop	edi
	pop	esi
	mov	esp,ebp
	pop	ebp
	ret	0


ansi_drive_G_string:
	dw	6
	dw	7
	dd	drive_G_string

drive_G_string:
	db	'\??\G:',0


ansi_path_G_string:
	dw	0x1c
	dw	0x1d
	dd	path_G_string
path_G_string:
	db	'\Device\Harddisk0\Partition7',0




ansi_drive_C_string	equ	0x90f78
ansi_path_C_string	equ	0x90f80	;part2

ansi_drive_E_string	equ	0x90f88
ansi_path_E_string	equ	0x90f90	;part1

ansi_drive_F_string	equ	0x90f98
ansi_path_F_string	equ	0x90fa0	;part6

ansi_drive_X_string	equ	0x90fa8
ansi_path_X_string	equ	0x90fb0	;part3

ansi_drive_Y_string	equ	0x90fb8
ansi_path_Y_string	equ	0x90fc0	;part4

ansi_drive_Z_string	equ	0x90fc8
ansi_path_Z_string	equ	0x90fd0	;part5


ansi_drive_table:
	dd	ansi_drive_E_string
	dd	ansi_drive_C_string
	dd	ansi_drive_X_string
	dd	ansi_drive_Y_string
	dd	ansi_drive_Z_string
	dd	ansi_drive_F_string
	dd	ansi_drive_G_string

ansi_path_table:
	dd	ansi_path_E_string
	dd	ansi_path_C_string
	dd	ansi_path_X_string
	dd	ansi_path_Y_string
	dd	ansi_path_Z_string
	dd	ansi_path_F_string
	dd	ansi_path_G_string

drive_letter_table:
	db	'e'
	db	'c'
	db	'x'
	db	'y'
	db	'z'
	db	'f'
	db	'g'
	db	0

C_colon_backslash	equ	0x7b780
E_colon_backslash	equ	0x7b77c
F_colon_backslash	equ	0x7b778
X_colon_backslash	equ	0x7b774
Y_colon_backslash	equ	0x7b770
Z_colon_backslash	equ	0x7b76c

G_colon_backslash	db	'g:\',0

str_200_OK	equ	0x7cbe0

out_ftp_drive_info	equ	0x21710
out_ftp_finished_status	equ	0x223a9

Do_FTP_cmd_HDDINFO:
	mov	esi,[ebp-0x14]

	push	C_colon_backslash
	push	esi
	mov	ecx,ebx
	call	out_ftp_drive_info

	push	E_colon_backslash
	push	esi
	mov	ecx,ebx
	call	out_ftp_drive_info

	push	F_colon_backslash
	push	esi
	mov	ecx,ebx
	call	out_ftp_drive_info

	push	G_colon_backslash
	push	esi
	mov	ecx,ebx
	call	out_ftp_drive_info

	push	X_colon_backslash
	push	esi
	mov	ecx,ebx
	call	out_ftp_drive_info

	push	Y_colon_backslash
	push	esi
	mov	ecx,ebx
	call	out_ftp_drive_info

	push	Z_colon_backslash
	push	esi
	mov	ecx,ebx
	call	out_ftp_drive_info

	push	str_200_OK
	push	esi
	jmp	out_ftp_finished_status



ENV_array_names	equ	0x7fde0
ENV_array_values	equ	0x7fde4
Num_builtin_ENV	equ	0x11

envname__SpaceG	db	'S',0,'p',0,'a',0,'c',0,'e',0,'G',0,0,0
;;envval__SpaceG	db	'1',0,'2',0,'3',0,'.',0,'4',0,'5',0,'6',0,'.',0,'7',0,'8',0,'9',0,0,0
envval__SpaceG	equ	0x527bd0
envname__Undef1	db	'U',0,'1',0,0,0
envval__Undef1	db	'?',0
envname__Undef2	db	'U',0,'2',0,0,0
envval__Undef2	db	'?',0
envname__Undef3	db	'U',0,'3',0,0,0
envval__Undef3	db	'?',0
envname__Undef4	db	'U',0,'4',0,0,0
envval__Undef4	db	'?',0

My_ENV_array:
My_ENV_array_names:
	dd	envname__SpaceG
My_ENV_array_values:
	dd	envval__SpaceG

	dd	envname__Undef1
	dd	envval__Undef1
	dd	envname__Undef2
	dd	envval__Undef2
	dd	envname__Undef3
	dd	envval__Undef3
	dd	envname__Undef4
	dd	envval__Undef4

Num_my_ENV	equ	(($-My_ENV_array)/8)





Get_ENV_array_name:
	cmp	edi,Num_builtin_ENV
	jb	short .use_builtin

	push	edi
	sub	edi,Num_builtin_ENV
	mov	ecx,dword [My_ENV_array_names+(edi*8)]
	pop	edi
	retn
.use_builtin:
	mov	ecx,dword [ENV_array_names+(edi*8)]
	retn



Get_ENV_array_value:
	cmp	edi,Num_builtin_ENV
	jb	short .use_builtin

	push	edi
	sub	edi,Num_builtin_ENV
	mov	edx,dword [My_ENV_array_values+(edi*8)]
	pop	edi
	retn

.use_builtin:
	mov	edx,dword [ENV_array_values+(edi*8)]
	retn

strFreeSpaceF	equ	0x527ba0
strFreeSpaceG	equ	0x527bd0

get_free_space_unicode_str	equ	0x18200
strcpy_unicode	equ	0x2a638

Make_F_G_free_space_strings:
	push	F_colon_backslash
	call	get_free_space_unicode_str
	push	eax
	push	strFreeSpaceF
	call	strcpy_unicode
	add	esp,12

	push	G_colon_backslash
	call	get_free_space_unicode_str
	push	eax
	push	strFreeSpaceG
	call	strcpy_unicode
	add	esp,12
	retn


Menu_array_1	equ	0x3a3828
Menu_array_2	equ	0x3a382c
Menu_array_3	equ	0x3a3830
Menu_array_4	equ	0x3a3830

Label_FreeSpaceOnF	equ	0x7a4a4
Label_FreeSpaceOnG	dw	'F','r','e','e',' ','S','p','a','c','e',' ','o','n',' ','G',':',0

Hook_F_G_free_space_into_menu:	;@ = 000109b2
	mov	eax,esi
	shl	eax,4
	add	eax,Menu_array_1
	mov	dword [eax],Label_FreeSpaceOnF
	mov	dword [eax+4],ebx
	mov	dword [eax+8],strFreeSpaceF
	mov	dword [eax+12],ecx
	inc	esi

	mov	eax,esi
	shl	eax,4
	add	eax,Menu_array_1
	mov	dword [eax],Label_FreeSpaceOnG
	mov	dword [eax+4],ebx
	mov	dword [eax+8],strFreeSpaceG
	mov	dword [eax+12],ecx
	inc	esi

	retn


tolower:
	cmp	al,'a'
	jb	.exit
	cmp	al,'z'
	ja	.exit
	or	al,0x20
.exit:
	retn

Drive_letter_to_partition_string:
	call	tolower
	mov	esi,drive_letter_table
.loop:
	cmp	byte [esi],0
	jz	.exit_not_found

	cmp	al,byte [esi]
	jz	.exit_match

	inc	esi
	jmp	short .loop

.exit_match:
	sub	esi,drive_letter_table
	add	esi,esi
	add	esi,esi
	add	esi,ansi_path_table
	mov	esi,[esi]
	mov	esi,[esi+4]
	jmp	short .exit

.exit_not_found:
	mov	esi,0
.exit:
	retn


Doformat_drive_letter_hook_continue	equ	0x18fc4
Doformat_drive_letter_hook_error	equ	0x18fd2

Doformat_drive_letter_hook:
	call	Drive_letter_to_partition_string
	test	esi,esi
	jz	short .continue_error

	jmp	Doformat_drive_letter_hook_continue
.continue_error:
	jmp	Doformat_drive_letter_hook_error



Dev_cdrom0_string	equ	0x7bb90
Dest_string_buf	equ	0x53ab90
Another_drive_letter_hook_continue	equ	0x1c231


Another_drive_letter_hook:
	call	Drive_letter_to_partition_string
	test	esi,esi
	jnz	.have_hd_string
	cmp	al,'d'
	jnz	.exit_error
	mov	esi,Dev_cdrom0_string
	mov	ecx,15
	jmp	short .have_string

.have_hd_string:
	mov	ecx,29

.have_string:
	mov	edi,Dest_string_buf
	rep	movsb

.exit_error:

	jmp	Another_drive_letter_hook_continue
