@echo off
if not exist evoxdump.bin goto err1
if exist default.xbe del default.xbe
if exist default.tmp del default.tmp
if exist out.xbe del out.xbe

@echo Applying patch (evoxdump.bin to default.xbe)
copy /b evoxdump.bin default.tmp

if exist patch.bin del patch.bin
..\bin\nasm -f bin -o patch.bin patch.asm




rem #
rem # Fix up .xbe header
rem #
rem # entry point xor'd with key
rem #
..\bin\poke default.tmp 0x00128 0x24 0x28 0xfe 0xa8

rem #
rem # Fix up .xbe header
rem #
rem # kernel thunk xor'd with key
rem #
..\bin\poke default.tmp 0x00158 0x16 0xd6 0x6a 0x5b


rem #
rem # Fix up .xbe header
rem #
rem # adjust .text start/size to include my patch code
rem #
..\bin\poke default.tmp 0x00358 0x80 0x09
..\bin\poke default.tmp 0x0035c 0x20 0x23
..\bin\poke default.tmp 0x00360 0x80 0x09
..\bin\poke default.tmp 0x00364 0x20 0x23

rem #
rem # change address of strIP (to make room for SpaceG string)
rem #
..\bin\poke default.tmp 0x039bf 0xfe
..\bin\poke default.tmp 0x0a1ce 0xfe
..\bin\poke default.tmp 0x0a21f 0xfe
..\bin\poke default.tmp 0x0a2a9 0xfe
..\bin\poke default.tmp 0x6fffc 0xfe

rem #
rem # call 109b2 (Hook_F_G_free_space_into_menu), plus nop's
rem #
..\bin\poke default.tmp 0x03d3a 0xe8 0x73 0xcc 0xff 0xff
..\bin\poke default.tmp 0x03d3f 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x03d47 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x03d4f 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x03d57 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90

rem #
rem # format drive jump to 'drive letter->partition string' function
rem #
..\bin\poke default.tmp 0x08f83 0xe9 0x2f 0x7a 0xff 0xff

rem #
rem # call replacement for lookup environment string (Get_ENV_array_name) (so I can add SpaceG)
rem #
..\bin\poke default.tmp 0x09450 0xe8 0x4e 0x75 0xff 0xff 0x90 0x90

rem #
rem # change max env string count from 0x11 to 0x16
rem #
..\bin\poke default.tmp 0x0946c 0x16

rem #
rem # call replacement for lookup environment string (Get_ENV_array_value) (so I can add SpaceG)
rem #
..\bin\poke default.tmp 0x09497 0xe8 0x0c 0x75 0xff 0xff 0x90 0x90

rem #
rem # replace code that gets free space for F: with new code that gets F:/G: free space
rem #
..\bin\poke default.tmp 0x09f40 0xe8 0x68 0x6a 0xff 0xff
..\bin\poke default.tmp 0x09f45 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x09f4d 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x09f55 0x90 0x90 0x90

rem #
rem # create symlinks (drive letters) for all drives
rem #
..\bin\poke default.tmp 0x0bd9f 0xe8 0xdc 0x4b 0xff 0xff 0x89 0xc3
..\bin\poke default.tmp 0x0bda6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bdae 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bdb6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bdbe 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bdc6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bdce 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bdd6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bdde 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bde6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bdee 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bdf6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bdfe 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be06 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be0e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be16 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be1e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be26 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be2e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be36 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be3e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be46 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be4e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be56 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be5e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be66 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be6e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be76 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be7e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be86 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be8e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be96 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0be9e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bea6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0beae 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0beb6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bebe 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bec6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bece 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bed6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bede 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bee6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0beee 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bef6 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0befe 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bf06 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bf0e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bf16 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bf1e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bf26 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bf2e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bf36 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bf3e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bf46 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0bf4e 0x90 0x90 0x90 0x90 0x90 0x90


rem #
rem # re-create sym links for all drives (if not already created)
rem #
..\bin\poke default.tmp 0x0bf90 0xe9 0xf0 0x49 0xff 0xff

rem #
rem # convert drive letter to partition string hook
rem #
..\bin\poke default.tmp 0x0c1a2 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x0c1aa 0xe9 0x0d 0x48 0xff 0xff


rem #
rem # replace output F: ftp dir string with output F:/G: ftp dir string
rem #
..\bin\poke default.tmp 0x11e60 0x53 0xe8 0x29 0xeb 0xfe 0xff
..\bin\poke default.tmp 0x11e66 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x11e6e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x11e76 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x11e7e 0x90 0x90 0x90 0x90 0x90 0x90 0x90 0x90
..\bin\poke default.tmp 0x11e86 0x90 0x90 0x90 0x90 0x90 0x90 0x90 

rem #
rem # replace FTP "hddinfo" command
rem #
..\bin\poke default.tmp 0x13220 0x9e 0x09 0x01

rem #
rem # Replace Partition[1-6] with Partition[1-N]
rem #
..\bin\poke default.tmp 0x6c97a 0x4e

rem #
rem # replace drivelist output
rem #
..\bin\poke default.tmp 0x6b395 0x47 0x48 0x49 0x4a 0x4b 0x4c 0x4d 0x4e 0x4f 0x58 0x59 0x5a 0x0a 0x00


rem #
rem # patch-in my code (from patch.asm)
rem #
..\bin\poke default.tmp 0x00980 @patch.bin



..\bin\xbe default.tmp -wb
ren out.xbe default.xbe
del default.tmp

echo Success!  Use default.xbe as replacement for EvoX dashboard

goto end

:err1
echo Missing file evoxdump.bin!

:end

