/* XBFLASH - Xbox Flash image utility
 * Copyright (C) 2002  Paul Bartholomew
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * 
 * xbflash.c - Main program
 * 
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <direct.h>

#include "xbconfig.h"
#include "xbunpack.h"
#include "xbpack.h"

//
// Usage:	xbflash -unpack config.ini filename.rom outdirname
//						-or-
//			xbflash -pack config.ini indirname filename.rom
//

char	*Pname;


void
usage(void)
{
	fprintf(stderr,
		"Usage:\t%s -unpack config.ini filename.rom outdirname\n", Pname);
	fprintf(stderr, "\t\t\t-or-\n");
	fprintf(stderr,
		"\t%s -pack config.ini indirname filename.rom\n", Pname);
}

int
main(int argc, char *argv[])
{
	int	want_unpack = 0;

	Pname = argv[0];

	if (argc != 5) {
		usage();
		exit(1);
	}

	if (!strcmp(argv[1], "-unpack")) {
		want_unpack = 1;
	} else if (!strcmp(argv[1], "-pack")) {
		want_unpack = 0;
	} else {
		usage();
		exit(1);
	}

	if (!read_xbconfig_file(argv[2])) {
		exit(1);
	}
	if (want_unpack) {
		if (!do_xbunpack(argv[3], argv[4])) {
			exit(1);
		}
	} else {
		if (!do_xbpack(argv[3], argv[4])) {
			exit(1);
		}
	}
	return 0;
}

