// Xbox Linux Preview
//
//  show some animal as well as some text on the Xbox logo screen
//  
//  Of course this application makes little sense, but it proves that it is
//  possible to write Xbox software without using the XDK or using any code
//  or data copyrighted by Microsoft. This application can be used as a
//  template for Xbox development and might be used as a base for the Xbox
//  Linux bootloader.
//  Note that everything is assembly only, but it should be possible to
//  call C functions from within the assembly code. Though, it is not
//  possible yet to call any Xbox kernel functions.
//
//  Copyright (C) 2002 Michael Steil, July 6th 2002
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General 
// Public License for more details.
//
// The latest version of the GPL can be retrieved at:
// http://www.gnu.org/licenses/gpl.html .
//
// Xbox is a trademark or registered trademark of Microsoft Corporation.
// No relationship between the author(s) and Microsoft Corporation exists or is
// implied.

.code32

.data
// This includes a minimal XBE header. It's not complete, i.e. software that wants
// to decode the header, such as "xbedump" (or probably Microsoft's certification
// tools) are likely to fail, but it is a valid header for the Xbox kernel.
#include "xbe.S"

.intel_syntax noprefix

// draw a 256-color 80x80 pixel logo onto the upper right corner
	mov esi, offset linux_logo
	mov edi, 0xF0040240		// Xbox screen RAM starts here
	mov edx, 80
	mov ebx, 0
logo_l2:	
	mov ecx, 80
logo_l1:	
	lodsb		//  encoded pixel
	mov bl, al
	sub bl, 0x20
	mov al, linux_logo_blue[ebx]
	stosb
	mov al, linux_logo_green[ebx]
	stosb
	mov al, linux_logo_red[ebx]
	stosb
	mov al, 0xff
	stosb
	loop logo_l1
	add edi, (640-80)*4
	dec edx
	jne logo_l2
	
// print some text below the logo
	lea esi, text
	mov edx, 0		// x position
charloop:
	mov eax, 0
	lodsb			// char
	test al,al
	je charend

	push esi
	shl eax, 4		// index to character
	lea esi, font[eax]

	mov eax, edx
	shl eax, 5		// index to screen line
	lea edi, 0xF0072265[eax]

	mov ecx, 16
fl1:
	lodsb
	push ecx
	mov ecx, 8
fl2:
	shl al, 1
	push eax
	mov eax, 0
	jnc f2
	dec eax
f2:
	stosd
	pop eax
	loop fl2
	add edi, 640*4 - 8*4
	pop ecx
	loop fl1

	pop esi
	inc edx
	jmp charloop
charend:
	
// flash the LEDs
// use this as debug code to check whether control reaches a certain point
#define LED_RED_C0	0x80
#define LED_RED_C1	0x40
#define LED_RED_C2	0x20
#define LED_RED_C3	0x10
#define LED_GREEN_C0	0x08
#define LED_GREEN_C1	0x04
#define LED_GREEN_C2	0x02
#define LED_GREEN_C3	0x01
	mov dx, 0xc004
	mov al, 0x20
	out dx, al
	mov dx, 0xc008
	mov al, 8
	out dx, al
	mov dx, 0xc006
	mov al, LED_RED_C0+LED_GREEN_C1+LED_RED_C2+LED_GREEN_C2
	out dx, al
	mov dx, 0xc000
	in ax, dx
	out dx, al
	mov dx, 0xc002
	mov al, 0x1a
	out dx, al

	mov eax, 1000000	// not the official method, but it works
l1:
	dec eax
	jne l1

	mov dx, 0xc004
	mov al, 0x20
	out dx, al
	mov dx, 0xc008
	mov al, 7
	out dx, al
	mov dx, 0xc006
	mov al, 1
	out dx, al
	mov dx, 0xc000
	in ax, dx
	out dx, al
	mov dx, 0xc002
	mov al, 0x1a
	out dx, al
infinite:
	jmp infinite

text:
	.string "Xbox Linux - coming soon! http://xbox-linux.sourceforge.net/"

#include "font.S"
#include "logo.S"
