// ******************************************************************
// * 
// * proj : OpenXDK
// *
// * desc : Open Source XBox Development Kit
// *
// * file : xboxkrnl.h
// *
// * note : XBox Kernel Declarations
// *
// ******************************************************************
#ifndef XBOXKRNL_H
#define XBOXKRNL_H

#if defined(__cplusplus)
extern "C"
{
#endif

#ifndef _XBOXKRNL_INTERNAL_
#define XBOXSYSAPI __declspec( dllimport )
#else
#define XBOXSYSAPI __declspec( dllexport )
#endif

// ******************************************************************
// * Null
// ******************************************************************
#ifndef	NULL
#define NULL                0
#endif

// ******************************************************************
// * Basic types
// ******************************************************************
typedef void                VOID;
typedef void               *PVOID;
typedef unsigned char       BYTE;
typedef BYTE                BOOLEAN;
typedef	unsigned int		DWORD;
typedef unsigned long       ULONG;
typedef	unsigned __int64	ULONGULONG;
typedef unsigned long      *PULONG;
typedef unsigned long       PHYSICAL_ADDRESS;
typedef	unsigned short		WORD;

// ******************************************************************
// * NTAPI
// ******************************************************************
#define NTAPI __stdcall

// ******************************************************************
// * Documentation purposes only
// ******************************************************************
#define EXPORTNUM(a)
#define OPTIONAL
#define IN
#define OUT

// ******************************************************************
// * DECLSPEC_NORETURN
// ******************************************************************
#define DECLSPEC_NORETURN __declspec( noreturn )

// ******************************************************************
// * Debug
// ******************************************************************
#include "dbg.h"

// ******************************************************************
// * Executive
// ******************************************************************
#include "ex.h"

// ******************************************************************
// * Hardware Abstraction Layer
// ******************************************************************
#include "hal.h"

// ******************************************************************
// * I/O Manager
// ******************************************************************
#include "io.h"

// ******************************************************************
// * Kernel
// ******************************************************************
#include "kernel.h"

// ******************************************************************
// * Memory Manager
// ******************************************************************
#include "mm.h"

// ******************************************************************
// * NT
// ******************************************************************
#include "nt.h"

// ******************************************************************
// * Object Manager
// ******************************************************************
#include "ob.h"

// ******************************************************************
// * Process Structure
// ******************************************************************
#include "ps.h"

// ******************************************************************
// * Run-time Library
// ******************************************************************
#include "rtl.h"

// ******************************************************************
// * XBox
// ******************************************************************
#include "xbox.h"

#if defined(__cplusplus)
}
#endif

#endif


