#include <stdio.h>
#include <stdlib.h>
#include <hal/xbox.h>
#include <hal/fileio.h>
#include <openxdk/debug.h>
#include <SDL.h>

void DrawPixel(SDL_Surface *screen, int x, int y, unsigned char R, unsigned char G, unsigned char B)
{
  unsigned int color = SDL_MapRGB(screen->format, R, G, B);
  switch (screen->format->BytesPerPixel)
  {
    case 1: // Assuming 8-bpp
      {
        unsigned char *bufp;
        bufp = (unsigned char *)screen->pixels + y*screen->pitch + x;
        *bufp = color;
      }
      break;
    case 2: // Probably 15-bpp or 16-bpp
      {
        unsigned short *bufp;
        bufp = (unsigned short *)screen->pixels + y*screen->pitch/2 + x;
        *bufp = color;
      }
      break;
    case 3: // Slow 24-bpp mode, usually not used
      {
        unsigned char *bufp;
        bufp = (unsigned char *)screen->pixels + y*screen->pitch + x * 3;
        if(SDL_BYTEORDER == SDL_LIL_ENDIAN)
        {
          bufp[0] = color;
          bufp[1] = color >> 8;
          bufp[2] = color >> 16;
        } else {
          bufp[2] = color;
          bufp[1] = color >> 8;
          bufp[0] = color >> 16;
        }
      }
      break;
    case 4: // Probably 32-bpp
      {
        unsigned int *bufp;
        bufp = (unsigned int *)screen->pixels + y*screen->pitch/4 + x;
        *bufp = color;
      }
      break;
  }
}

void drawScreen(int width, int height, int bpp)
{
	SDL_Surface *screen = SDL_SetVideoMode(width, height, bpp, SDL_HWSURFACE | SDL_DOUBLEBUF);
	for(int x=0; x<width; x++)
	{
		for(int y=0; y<height; y++)
		{
			DrawPixel(screen, x, y, y/2, y/2, x/3);
		}
	}
	SDL_Flip(screen);
	XSleep(1000);
}

void XBoxStartup()
{
	int width = 640;
	int height = 480;
	int bpp = 32;
	
	SDL_Init(SDL_INIT_VIDEO);
	drawScreen(width, height, 8);
	drawScreen(width, height, 16);
	drawScreen(width, height, 24);
	drawScreen(width, height, 32);
	XReboot();
}
