#include <stdio.h>
#include <stdlib.h>
#include <hal/xbox.h>
#include <hal/fileio.h>
#include <openxdk/debug.h>

void XBoxStartup()
{
	int handle;
	int read, written, newLocation;
	char buffer[20];
	
	// open the file for write access, overwrite if already there
	XCreateFile(&handle, "x:/blah.txt", GENERIC_WRITE, FILE_SHARE_WRITE, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL);
	
	// write some data to the file
	XWriteFile(handle, "0123456789abcdefghijABCDEFGHIJ\", )!@#$%^&*(", 40, &written);
	debugPrint("bytes written=");
	debugPrintNum(written);
	debugPrint("\n");
	
	// now close the file
	XCloseHandle(handle);

	// open the file for read access
	XCreateFile(&handle, "x:/blah.txt", GENERIC_READ, FILE_SHARE_READ, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL);

	// read the first 20 bytes and dump to screen
	XReadFile(handle, buffer, 20, &read);
	buffer[19] = 0;
	debugPrint(buffer);
	debugPrint("\n");

	// seek to offset 10 of the file
	XSetFilePointer(handle, 10, &newLocation, FILE_BEGIN);

	// read 20 bytes from offset 10 of the file and dump to screen
	XReadFile(handle, buffer, 20, &read);
	buffer[19] = 0;
	debugPrint(buffer);
	debugPrint("\n");

	// close the file handle
	XCloseHandle(handle);
	
	XSleep(5000);
	XReboot();
}
