/// <summary>
/// C# XBGM# Xbox Game Manager.
///  
/// Copyright (C) 2004  KaYa
/// 
/// 
/// This library is free software; you can redistribute it and/or
/// modify it under the terms of the GNU Lesser General Public
/// License as published by the Free Software Foundation; either
/// version 2.1 of the License, or (at your option) any later version.
/// 
/// This library is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
/// Lesser General Public License for more details.
/// 
/// You should have received a copy of the GNU Lesser General Public
/// License along with this library; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// Bug fixes, suggestions and comments should be sent to xbgm@kayaweed.net
/// 
/// Change Log:
/// 
/// Revision 0.1  2004/07/27 KaYa
/// first release
///
/// </summary>


using System;
using System.Collections;
using System.Data;
using System.Text;
using System.IO;
using Gtk;


/// <summary>
/// Description of PrefDialog.	
/// </summary>
public class PrefDialog
	{
		Dialog		dialog;
		Entry 		DIR_entry;
		Entry 		PORT_entry;
		Entry 		IP_entry;
		Entry 		USER_entry;
		Entry 		PASS_entry;
		Entry 		XBMC_entry;
		CheckButton Cache;

		public PrefDialog() 
		{ 
			CreateGui();
		}

		public void CreateGui() 
		{
			dialog = new Dialog ();
			dialog.Title = "Configuration";
			dialog.BorderWidth = 3;
			dialog.VBox.BorderWidth = 5;
			dialog.HasSeparator = false;

			Frame frame = new Frame ("Configuration");
			string image = Stock.DialogInfo;
			
			HBox hbox = new HBox (false, 2);
			hbox.BorderWidth = 5;
			hbox.PackStart (new Gtk.Image (image, IconSize.Dialog), true, true, 0);
		
			Table table = new Table (6, 3, false);
			hbox.PackStart (table);
			table.ColumnSpacing = 4;
			table.RowSpacing = 4;
			Label label = null;

			label = new Label ("IP");
			table.Attach (label, 0, 1, 0, 1);
			IP_entry = new Entry ();
			IP_entry.Text = "10.0.0.3";
			table.Attach (IP_entry, 1, 2, 0, 1);
			
			label = new Label ("Port");
			table.Attach (label, 0, 1, 1, 2);
			PORT_entry = new Entry ();
			PORT_entry.Text = "21";
			table.Attach (PORT_entry, 1, 2, 1, 2);
			
			label = new Label ("User");
			table.Attach (label, 0, 1, 2, 3);
			USER_entry = new Entry ();
			USER_entry.Text = "xbox";
			table.Attach (USER_entry, 1, 2, 2, 3);			
			
			label = new Label ("Pass");
			table.Attach (label, 0, 1, 3, 4);
			PASS_entry = new Entry ();
			PASS_entry.Text = "xbox";
			table.Attach (PASS_entry, 1, 2, 3, 4);
					
			label = new Label ("Directory");
			table.Attach (label, 0, 1, 4, 5);
			DIR_entry = new Entry ();
			DIR_entry.Text = "F:/";
			table.Attach (DIR_entry, 1, 2, 4, 5);

			label = new Label ("XBMC");
			table.Attach (label, 0, 1, 5, 6);
			XBMC_entry = new Entry ();
			XBMC_entry.Text = "E:/XBMC/default.xbe";
			table.Attach (XBMC_entry, 1, 2, 5, 6);
			
			Cache = new CheckButton();
			Cache.Label = "Use Cache";
			Cache.Active = true;
			hbox.PackStart (Cache, false, false, 0);
			
			frame.Add (hbox);

			dialog.VBox.PackStart (frame, true, true, 0);

			Button button = null;
			button = new Button (Stock.Ok);
			button.Clicked += new EventHandler (Connect_Action);
			button.CanDefault = true;
			dialog.ActionArea.PackStart (button, true, true, 0);
			button.GrabDefault ();

			button = new Button (Stock.Cancel);
			button.Clicked += new EventHandler (Dialog_Cancel);
			dialog.ActionArea.PackStart (button, true, true, 0);
			dialog.Modal = true;

			dialog.ShowAll ();
		}

		
		void Connect_Action (object o, EventArgs args) 
		{
			//Console.WriteLine("1:" + USER_entry.Text + " 2:" + PASS_entry.Text);
			dialog.Hide ();
		}

		void Dialog_Cancel (object o, EventArgs args) 
		{
			dialog.Hide ();
		}

		public void Run ()
		{
			dialog.Run();
		}
	
		// To get the info PASS USER IP DIR PORT
		public string Password
		{
			get { return PASS_entry.Text; }
			set { PASS_entry.Text = value; }
		}
		
		public string User
		{
			get { return USER_entry.Text; }
			set { USER_entry.Text = value; }
		}

		public string IP
		{
			get { return IP_entry.Text; }
			set { IP_entry.Text = value; }
		}

		public string Dir
		{
			get { return DIR_entry.Text; }
			set { DIR_entry.Text = value; }
		}

		public int Port
		{
			get { return Convert.ToInt32(PORT_entry.Text); }
			set { PORT_entry.Text = value.ToString(); }
		}
		
		public bool UseCache
		{
			get { return Cache.Active; }
			set { Cache.Active = value; }
		}

		public string XBMCDir
		{
			get { return XBMC_entry.Text; }
			set { XBMC_entry.Text = value; }
		}
		
		public void Close()
		{
			dialog.Destroy();
		}
	}

