	.586
	.model  flat, STDCALL
	option   casemap: none   ; Case sensitive
	include  \MASM32\include\Windows.inc
	include  \MASM32\include\user32.inc
	include  \Masm32\include\gdi32.inc
	include  \MASM32\include\kernel32.inc
	include  \MASM32\include\comctl32.inc
	include  \MASM32\include\imagehlp.inc
	include  \MASM32\include\shell32.inc
	include  \MASM32\include\ole32.inc
	include  \MASM32\include\comdlg32.inc
	include  \MASM32\include\advapi32.inc
	
	includelib  \MASM32\lib\user32.lib
	includelib  \Masm32\lib\gdi32.lib
	includelib  \MASM32\lib\kernel32.lib
	includelib  \MASM32\lib\comctl32.lib
	includelib  \MASM32\LIB\imagehlp.LIB
	includelib  \MASM32\lib\shell32.lib
	includelib  \MASM32\lib\ole32.lib
	includelib  \MASM32\lib\comdlg32.lib
	includelib  \MASM32\lib\advapi32.lib

	include		\MASM32\include\dialogs.inc
	include		SimpleXdata.asm
;== Functions =============================================================

	GetArguments		PROTO :DWORD
	WinMain				PROTO :DWORD,:DWORD,:DWORD,:DWORD
	ExtractAnISOFile	PROTO :DWORD,:DWORD
	SaveFileName		PROTO :DWORD,:DWORD,:DWORD,:DWORD
	ChooseIsoFile		PROTO :DWORD,:DWORD,:DWORD,:DWORD
	MainDlgProc			PROTO :DWORD,:DWORD,:DWORD,:DWORD
	
	ProgressDlgProc		PROTO :DWORD,:DWORD,:DWORD,:DWORD
	CleanMemory			PROTO :DWORD
	GetDirInfo			PROTO :DWORD,:DWORD

	ISOCreationThread	PROTO :DWORD
	CreateAnISOFile		PROTO :DWORD
	DirSort				PROTO :DWORD,:DWORD
	GetAllFiles			PROTO :DWORD
	AddMaskAll			PROTO :DWORD,:DWORD	
	MakeVFAT			PROTO :DWORD,:DWORD,:DWORD,:DWORD
	GetAddress			PROTO :DWORD,:DWORD,:DWORD
	EnhancedQuickSort	PROTO :DWORD,:DWORD
	Compare				PROTO :DWORD,:DWORD
	Swap				PROTO :DWORD,:DWORD
	PrintDir			PROTO :DWORD,:DWORD,:DWORD
	PrintVFAT			PROTO :DWORD,:DWORD	
	AddFolder			PROTO :DWORD,:DWORD,:DWORD
	CopyHeader			PROTO :DWORD,:DWORD,:DWORD,:DWORD
	SetIndexes			PROTO :DWORD
	CreateISO			PROTO :DWORD,:DWORD
	WriteXFolder		PROTO :DWORD,:DWORD,:DWORD
	WriteXFile			PROTO :DWORD,:DWORD,:DWORD,:DWORD
	PathJoin			PROTO :DWORD,:DWORD,:DWORD
	IsValidPath			PROTO :DWORD
	
	SetProgressRange	PROTO :DWORD
	SetProgressPos		PROTO :DWORD
	SetFileText			PROTO :DWORD
	
	ISOExtract			PROTO :DWORD
	ReadFolder			PROTO :DWORD,:DWORD,:DWORD,:DWORD
	ChooseFolder		PROTO :DWORD,:DWORD,:DWORD,:DWORD
	CreateNewFolder		PROTO :DWORD
	SetBufferSize		PROTO :DWORD
	
	CheckXboxIso		PROTO :DWORD
	IsEnoughFreeSpace	PROTO :DWORD,:DWORD,:DWORD
	CreationProc		PROTO :DWORD
	ExtractionProc		PROTO :DWORD
	
	GetPartitionType	PROTO :DWORD
	
	MyMessageBox		PROTO :DWORD
	
; #########################################################################
ENTRY_ITEM STRUCT 4
	left		WORD ?
	right		WORD ?
	index		DWORD ?
	filesize	DWORD ?
	attrib		BYTE ?
	namelen		BYTE ?
	filename	BYTE 256 DUP (?)
	pDirInfo	DWORD ?
ENTRY_ITEM ENDS

DIR_INFO STRUCT 4
	pSubFolder	DWORD ?
	numItems	DWORD ?
	pEntryItem	DWORD ? //point back to the entry
	pImage		DWORD ?
	dwImageSize	DWORD ?
	szPath		CHAR MAX_PATH Dup (?)
DIR_INFO ENDS

EXTRACT_ITEM STRUCT 4
	filename DWORD ?
	folder	DWORD ?
EXTRACT_ITEM ENDS

ULARGE_INTEGER STRUCT 4
	lowPart	DWORD ?
	highPart DWORD ?
ULARGE_INTEGER ENDS

PARTITION_INFORMATION STRUCT
	StartingOffset		LARGE_INTEGER <>
	PartitionLength		LARGE_INTEGER <>
	HiddenSectors		DWORD ?
	PartitionNumber		DWORD ?
	PartitionType		BYTE ?
	BootIndicator		BOOL ?
	RecognizedPartition BOOL ?
	RewritePartition	BOOL ?
PARTITION_INFORMATION ENDS


;********************
DEBUG equ TRUE
;********************

IOCTL_DISK_GET_PARTITION_INFO equ 74004h
PARTITION_NTFS equ 7

;== Variables =============================================================

.const
	ID_APPICON		equ 102
	EXTRACT_ACTION	equ 0
	CREATE_ACTION	equ 1
	
.data?
	hInstance	HANDLE ?
	hMainWindow	HANDLE ?
	
	root	ENTRY_ITEM <>
	
	numThreads	DWORD ?
	WBytes		DWORD ?
	RBytes		DWORD ?
	pZeroImage	DWORD ?
	dwISOSectorSize	DWORD ?	
	

	hWinDlg		HANDLE ?
	hProgress	HANDLE ?
	hLblFile	HANDLE ?
	hLblAction	HANDLE ?
	hBtnAction	HANDLE ?

	dwMaxFileSize	DWORD ?
	dwBufferSize	DWORD ?
	dwCurrentSize	DWORD ?
	dwPMask		DWORD ?
	dwPShift	DWORD ?
	dwMaxRange	DWORD ?
	dwCurPos	DWORD ?
	
	bError		BOOL ?
	bExit		BOOL ?
	bStop		BOOL ?
	dwActionType	DWORD ?
	lpszErrorMsg	DWORD ?
	
	pWriteBuffer	DWORD ?
	
	dwStartTime		DWORD ?
	dwStopTime		DWORD ?
	lpszArguments	DWORD ?
	dwMainAction	DWORD ?
	numOfFiles		DWORD ?
	numOfFolders	DWORD ?
	hLogFile		DWORD ?
;**************************************************************************
;##########################################################################
.code

start:
	mov hLogFile,0
	
	invoke	GetModuleHandle, NULL
	mov		hInstance, eax
	call MainCode
	
	.IF hLogFile!=0
		invoke CloseHandle,hLogFile
	.ENDIF
	invoke	ExitProcess, eax
MainCode proc uses esi
	LOCAL szArguments[MAX_PATH]:CHAR

	lea edi,szArguments
	mov lpszArguments,edi
	
	invoke	InitCommonControls
	invoke	CoInitialize,NULL
	invoke	GetArguments,edi
	.IF eax!=0
		invoke SetCurrentDirectory,DWORD PTR [edi]
		.IF eax!=0
			invoke CreateAnISOFile,edi
			ret
		.ELSE
			invoke CreateFile,DWORD PTR [edi],GENERIC_READ,FILE_SHARE_READ or FILE_SHARE_WRITE,\
				NULL,OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL
			.IF eax!=INVALID_HANDLE_VALUE
				invoke ExtractAnISOFile,eax,edi
				ret		
			.ENDIF
		.ENDIF
	.ENDIF
	call OnlyOneInstance
	.IF eax
   		call CreateMainDialog
   	.ENDIF
   	ret
MainCode endp
;=========================================================================
CreateAnISOFile proc lpArguments:DWORD
	LOCAL ThreadID:DWORD
	
	;initialize Root Info	
	mov root.left,0
	mov root.right,0
	mov root.index,108h

	invoke CreateThread,NULL,NULL,ADDR ISOCreationThread,lpArguments,\
			NORMAL_PRIORITY_CLASS,ADDR ThreadID
	.IF eax!=NULL
		invoke CloseHandle,eax
		mov dwMainAction,EXTRACT_ACTION
		call CreateProgressDialog
	.ELSE
		invoke MessageBox,NULL,ADDR szLogCantCreateThread,ADDR szAppName,MB_OK
	.ENDIF
	
	ret
CreateAnISOFile endp
;=========================================================================
ExtractAnISOFile proc uses edi esi ebx hISOFile:DWORD,lpArguments:DWORD
	LOCAL ThreadID:DWORD
	LOCAL eiIsoFile:EXTRACT_ITEM
	LOCAL dwFileSize: ULARGE_INTEGER
	LOCAL szStorageFolder[MAX_PATH]:CHAR
	
	mov ebx,hISOFile
	invoke CheckXboxIso,hISOFile
	push eax
	lea edi,dwFileSize
	lea eax,[edi+4]
	invoke GetFileSize,ebx,eax
	mov [edi],eax
	invoke CloseHandle,ebx
	pop eax
	.IF eax==0 ; checkXboxIso returns 0 that means the XboxMedia string is match
		lea edi,szStorageFolder
		mov eax,lpArguments
		mov edx,DWORD PTR [eax+4] ;check second argument
		.IF edx !=0
			invoke lstrcpy,edi,edx
			invoke lstrlen,edi
			;add "\" for IsValidPath function
			.IF BYTE PTR [edi+eax-1] != '\'
				mov WORD PTR [edi+eax],'\'
			.ENDIF
			invoke IsValidPath,edi
			or eax,eax
			jnz lbl_CheckFreeSpace
			
			;If the path is not valid
			mov eax,lpArguments
			invoke lstrcpy,edi,DWORD PTR [eax+4]
			invoke CreateNewFolder,edi
			or eax,eax
			jnz lbl_CheckFreeSpace
			
		.ENDIF
		
		;Set the iso path as the intial folder
		mov eax,lpArguments
		mov esi,DWORD PTR [eax]
		xor edx,edx
		mov al,BYTE PTR [esi]
		.WHILE al!=0
			lodsb
			stosb
			.IF al=='\'
				mov edx,edi
			.ENDIF
		.ENDW
		.IF edx!=0
			mov BYTE PTR [edx],0
		.ENDIF
		
		lea edi,szStorageFolder
		
	lbl_ChooseFolder:
		invoke ChooseFolder,hWinDlg,ADDR szFolderToExtract,edi,TRUE
		or eax,eax
		jz lbl_EAIS_Exit
		
	lbl_CheckFreeSpace:			
		invoke IsEnoughFreeSpace,edi,ADDR dwFileSize,FALSE
		cmp eax,0 ;IsEnoughFreeSpace returns >0 meaning enough
		jg @F
			invoke MessageBox,hWinDlg,ADDR szNotEnoughSpace4Extract,ADDR szAppName,MB_OK + MB_ICONERROR
			jmp lbl_ChooseFolder
		@@:
		
		mov eax,lpArguments
		mov ecx,DWORD PTR [eax]
		mov eiIsoFile.filename,ecx
		mov eiIsoFile.folder,edi

		invoke CreateThread,NULL,NULL,ADDR ISOExtract,ADDR eiIsoFile,\
				NORMAL_PRIORITY_CLASS,ADDR ThreadID
		invoke CloseHandle,eax
		mov dwMainAction,CREATE_ACTION
		call CreateProgressDialog
	.ELSE
		invoke MessageBox,hWinDlg,ADDR szInvalidXboxFile,ADDR szAppName,MB_OK + MB_ICONERROR
	.ENDIF
lbl_EAIS_Exit:
	ret
ExtractAnISOFile endp
;=========================================================================
InitControlsEx proc
	LOCAL icce:INITCOMMONCONTROLSEX
	mov icce.dwSize, SIZEOF INITCOMMONCONTROLSEX
	mov icce.dwICC,ICC_PROGRESS_CLASS
	invoke InitCommonControlsEx,ADDR icce
	ret
InitControlsEx endp
	
;=========================================================================
; WinMain PROCEDURE
;=========================================================================
; #########################################################################
ID_BTN_EXTRACTION equ 1001
ID_BTN_CREATION equ 1002
ID_BTN_ADDSHELLEXT equ 1003
ID_BTN_REMOVESHELLEXT equ 1004

CreateMainDialog proc
	
	Dialog APP_NAME, \		   ; caption
			"MS Sans Serif",10, \			; font,pointsize
			WS_OVERLAPPED or WS_SYSMENU or DS_CENTER, \	  ; styles for dialog window
			4, \							; number of controls
			50,50,83,97, \				 ; x y co-ordinates
			1024							; memory buffer size
	DlgButton "Extract an ISO",WS_TABSTOP,5,5,70,14,ID_BTN_EXTRACTION
	DlgButton "Make an ISO",WS_TABSTOP,5,25,70,14,ID_BTN_CREATION
	DlgButton "Establish shell Exts.",WS_TABSTOP,5,45,70,14,ID_BTN_ADDSHELLEXT
	DlgButton "Remove shell Exts.",WS_TABSTOP,5,65,70,14,ID_BTN_REMOVESHELLEXT
	CallModalDialog hInstance,0,MainDlgProc,NULL
	ret
CreateMainDialog endp
;=========================================================================
MainDlgProc proc uses ebx hWin:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD
	mov eax,uMsg
	.IF	eax==WM_INITDIALOG
		invoke LoadIcon,hInstance,ID_APPICON
		invoke SendMessage,hWin,WM_SETICON,ICON_SMALL,eax
	.ELSEIF eax==WM_COMMAND
		mov eax,wParam
		.IF eax==ID_BTN_CREATION
			;Select a folder
			invoke CreationProc,hWin
		.ELSEIF eax==ID_BTN_EXTRACTION
			;Select an iso file
			;invoke GetFileName	
			invoke ExtractionProc,hWin
		.ELSEIF eax==ID_BTN_ADDSHELLEXT
			;Remove settings of the previous version
			call RemoveAssociatedFolder
			call RemoveAssociatedIsoFile
			
			;Call "DllRegisterServer"
			invoke LoadLibrary,ADDR szSimpleXExtDll
			.IF eax!=0
    			mov ebx,eax
				invoke GetProcAddress, ebx, ADDR szDllReg
				.IF eax!=0
					call eax
					invoke MessageBox,hWin,ADDR szAddRegSuccess,ADDR szAppName,MB_OK + MB_ICONINFORMATION
				.ELSE
					invoke MessageBox,hWin,ADDR szRegNotFound,ADDR szAppName,MB_OK + MB_ICONERROR
				.ENDIF
				invoke FreeLibrary, ebx
			.ELSE
				invoke MessageBox,hWin,ADDR szDllNotFound,ADDR szAppName,MB_OK + MB_ICONERROR
			.ENDIF
			
		.ELSEIF eax==ID_BTN_REMOVESHELLEXT
			;Call "UnDllRegisterServer"
			invoke LoadLibrary,ADDR szSimpleXExtDll
			.IF eax!=0
    			mov ebx,eax
				invoke GetProcAddress, ebx, ADDR szDllUnreg
				.IF eax!=0
					call eax
					invoke MessageBox,hWin,ADDR szRemoveRegSuccess,ADDR szAppName,MB_OK + MB_ICONINFORMATION
				.ELSE
					invoke MessageBox,hWin,ADDR szUnRegNotFound,ADDR szAppName,MB_OK + MB_ICONERROR
				.ENDIF
				invoke FreeLibrary, ebx
			.ELSE
				invoke MessageBox,hWin,ADDR szDllNotFound,ADDR szAppName,MB_OK + MB_ICONERROR
			.ENDIF

		.ENDIF
	.ELSEIF eax==WM_CLOSE
		invoke EndDialog,hWin,0
	.ENDIF

	xor eax,eax
	ret
MainDlgProc endp
;==========================================================================
CreationProc proc uses edi hParent:DWORD
	LOCAL szCommandLine[MAX_PATH]:CHAR
	LOCAL processInfo: PROCESS_INFORMATION 
	LOCAL startInfo:STARTUPINFO
	
	mov eax,lpszArguments
   	lea edx,[eax+20]
   	lea edi,szCommandLine
	invoke lstrcpy,edi,edx
	invoke lstrlen,eax
	lea edi,[edi+eax]
	mov DWORD PTR [edi],'" '
	inc edi
	inc edi
	invoke ChooseFolder,hParent,ADDR szFolderToCreate,edi,FALSE
	.IF eax!=0
		invoke GetStartupInfo,ADDR startInfo
		lea edi,szCommandLine
		invoke lstrlen,edi
		mov WORD PTR [edi+eax],'"'
		
		invoke CreateProcess,NULL,ADDR szCommandLine,NULL,NULL,FALSE,\
			NORMAL_PRIORITY_CLASS,NULL,NULL,ADDR startInfo,ADDR processInfo
	.ENDIF	
	ret
CreationProc endp
;==========================================================================
ExtractionProc proc hParent:DWORD
	LOCAL szCommandLine[MAX_PATH]:CHAR
	LOCAL processInfo: PROCESS_INFORMATION 
	LOCAL startInfo:STARTUPINFO
	
	mov eax,lpszArguments
   	lea edx,[eax+20]
   	lea edi,szCommandLine
	invoke lstrcpy,edi,edx
	invoke lstrlen,eax
	lea edi,[edi+eax]
	mov DWORD PTR [edi],'" '
	inc edi
	inc edi
		
	invoke ChooseIsoFile,hParent,ADDR szChooseXisoFile,ADDR szIsoFilter,edi
	.IF eax!=0
		invoke GetStartupInfo,ADDR startInfo
		lea edi,szCommandLine
		invoke lstrlen,edi
		mov WORD PTR [edi+eax],'"'
		
		invoke CreateProcess,NULL,ADDR szCommandLine,NULL,NULL,FALSE,\
			NORMAL_PRIORITY_CLASS,NULL,NULL,ADDR startInfo,ADDR processInfo
	.ENDIF
	ret
ExtractionProc endp
;==========================================================================
; Arguments Analysis
; Split the argument to maximum 5 parts
; first 4 dwords of lpArgument will hold the addresses of the arguments after the first
;==========================================================================
GetArguments proc uses esi edi lpArgument:DWORD
	invoke GetCommandLine
	mov esi,eax
	
	mov edi,lpArgument
	mov edx,edi
	lea edi,[edi+5*4]
	xor ecx,ecx
	mov eax,ecx
	mov DWORD PTR [edx],0
	mov al,BYTE PTR [esi]
	.WHILE al!=0
		mov ah,' '		
		.IF al=='"'
			mov ah,al
			inc esi
		.ENDIF
		.WHILE BYTE PTR [esi]!=ah
			lodsb
			stosb
			or al,al
			je GA_Exit
		.ENDW
		mov BYTE PTR [edi],0
		.IF BYTE PTR [esi]=='"'
			inc esi
			.BREAK .IF BYTE PTR [esi]==0
		.ENDIF
		inc esi
		inc edi
		mov DWORD PTR [edx],edi
		.BREAK .IF ecx==4
		inc ecx
		lea edx,[edx+4]
		mov al,BYTE PTR [esi]
	.ENDW
	.WHILE BYTE PTR [esi]!=0
		movsb
	.ENDW
GA_Exit:
	mov DWORD PTR [edx],0
	mov DWORD PTR [edi],0
	mov eax,ecx
	ret
	
GetArguments endp
;--------------------------------------------------------------------------
RemoveAssociatedFolder proc
	LOCAL hKey:DWORD
	invoke RegDeleteKey,HKEY_CLASSES_ROOT,ADDR szRegFolderCommand
	cmp eax,ERROR_SUCCESS
	jne RAF_Exit
	
	invoke RegDeleteKey,HKEY_CLASSES_ROOT,ADDR szRegFolder
	
RAF_Exit:
	ret
RemoveAssociatedFolder endp
;--------------------------------------------------------------------------
RemoveAssociatedIsoFile proc
	LOCAL hKey:DWORD
	LOCAL dwDisposition:DWORD
	LOCAL dwRWBytes:DWORD
	LOCAL pISOAutoFile:DWORD
	LOCAL szSubKey[256]:CHAR
	invoke RegCreateKeyEx,HKEY_CLASSES_ROOT,ADDR szRegISOFile,NULL,\
		NULL,REG_OPTION_NON_VOLATILE,KEY_WRITE,NULL,ADDR hKey,ADDR dwDisposition
	cmp eax,ERROR_SUCCESS
	jne RAIF_Exit
	mov dwRWBytes,256
	invoke RegQueryValue,hKey,NULL,ADDR szSubKey,ADDR dwRWBytes
	.IF eax==ERROR_SUCCESS
		lea eax,szSubKey
		mov pISOAutoFile,eax
	.ELSE
		lea eax,szISOAutoFile
		mov pISOAutoFile,eax
		invoke RegSetValue,hKey,NULL,REG_SZ,eax,13
		cmp eax,ERROR_SUCCESS
		jne RAIF_Exit
	.ENDIF

	invoke RegCreateKeyEx,HKEY_CLASSES_ROOT,pISOAutoFile,NULL,\
		NULL,REG_OPTION_NON_VOLATILE,KEY_WRITE,NULL,ADDR hKey,ADDR dwDisposition
	cmp eax,ERROR_SUCCESS
	jne RAIF_Exit

	invoke RegDeleteKey,hKey,ADDR szRegFileCommand
	cmp eax,ERROR_SUCCESS
	jne RAIF_Exit
	
	invoke RegDeleteKey,hKey,ADDR szRegFileExtract
	
RAIF_Exit:
	ret
RemoveAssociatedIsoFile endp
; #########################################################################
	ID_LBL_FILE	equ	1001
	ID_LBL_ACTION equ 1002
	ID_BTN_ACTION equ 1051
	ID_PROGRESS equ 1081
CreateProgressDialog proc
	
	mov bError,FALSE
	mov bStop,FALSE
	mov bExit,FALSE
	mov dwActionType,ACT_STOP
	mov hWinDlg,0

	Dialog APP_NAME_EXTRACTION, \		   ; caption
			"MS Sans Serif",10, \			; font,pointsize
			WS_OVERLAPPED or WS_SYSMENU or DS_CENTER, \	  ; styles for dialog window
			4, \							; number of controls
			50,50,260,40, \				 ; x y co-ordinates
			1024							; memory buffer size
	DlgStatic "Writing:",SS_LEFT,5,5,30,10,ID_LBL_ACTION
	DlgStatic " ",SS_LEFT,30,5,180,10,ID_LBL_FILE
	DlgButton "Stop",WS_TABSTOP,215,3,40,14,ID_BTN_ACTION
	DlgProgress PBS_SMOOTH or WS_BORDER,0,20,257,10,ID_PROGRESS

	CallModalDialog hInstance,0,ProgressDlgProc,NULL
	ret
CreateProgressDialog endp
;=========================================================================
	ACT_STOP	equ 1
	ACT_QUIT	equ 2
ProgressDlgProc proc hWin:DWORD,uMsg:DWORD,wParam:DWORD,lParam:DWORD

	mov eax,uMsg
	.IF	eax==WM_INITDIALOG
		invoke GetDlgItem,hWin,ID_PROGRESS
		mov hProgress, eax
		invoke SendMessage,hProgress,PBM_SETBKCOLOR,0,00000000h  ; black
		invoke SendMessage,hProgress,PBM_SETBARCOLOR,0,00FF0000h ; blue	
		invoke GetDlgItem,hWin,ID_LBL_FILE
		mov hLblFile,eax
		invoke GetDlgItem,hWin,ID_LBL_ACTION
		mov hLblAction,eax
		invoke GetDlgItem,hWin,ID_BTN_ACTION
		mov hBtnAction,eax
		push hWin
		pop hWinDlg
		invoke LoadIcon,hInstance,ID_APPICON
		invoke SendMessage,hWin,WM_SETICON,ICON_SMALL,eax
		.IF dwMainAction == EXTRACT_ACTION
			invoke SendMessage,hWin,WM_SETTEXT,0,ADDR szCreationTitle
			invoke SendMessage,hLblAction,WM_SETTEXT,0,ADDR szLblActAdding
		.ENDIF
	.ELSEIF eax==WM_COMMAND
		.IF wParam==ID_BTN_ACTION
			mov eax,dwActionType
			.IF eax==ACT_STOP
				mov bStop,TRUE
			.ELSEIF eax==ACT_QUIT
				invoke EndDialog,hWin,0
			.ENDIF
		.ENDIF
	.ELSEIF eax==WM_CLOSE
		.IF !bStop
			mov bStop,TRUE
		.ENDIF
		invoke EndDialog,hWin,0
	.ENDIF

	xor eax,eax
	ret
ProgressDlgProc endp
;=========================================================================
CheckXboxIso proc uses esi hIsoFile:DWORD
	LOCAL szTemp[24]:CHAR
	lea esi,szTemp
	invoke SetFilePointer,hIsoFile,10000h,0,FILE_BEGIN
	invoke ReadFile,hIsoFile,esi,14h,ADDR RBytes,NULL
	mov DWORD PTR [esi+14h],0
	invoke lstrcmp,esi,ADDR szXboxMediaString
	ret
CheckXboxIso endp
; #########################################################################
CleanMemory proc uses esi edi ebx ecx edx pEntryItem:DWORD
	mov eax,pEntryItem
	mov esi,(ENTRY_ITEM PTR [eax]).pDirInfo
	mov ebx,esi
	.IF (ebx!=0) && (ebx!=INVALID_HANDLE_VALUE)
		mov edi,(DIR_INFO PTR [esi]).pSubFolder
		mov edx,(DIR_INFO PTR [esi]).numItems
		xor ecx,ecx
		.WHILE ecx<edx
			mov al,(ENTRY_ITEM PTR [edi]).attrib
			and al,10h
			.IF al==10h
				mov eax,(ENTRY_ITEM PTR [edi]).pDirInfo
				.IF eax!=0
					invoke CleanMemory,edi
				.ENDIF
			.ENDIF
			lea edi,[edi+SIZEOF ENTRY_ITEM]
			inc ecx
		.ENDW
		mov eax,(DIR_INFO PTR [esi]).pImage
		.IF (eax!=INVALID_HANDLE_VALUE) || (eax!=0)
			invoke GlobalFree,eax
		.ENDIF
		mov eax,(DIR_INFO PTR [esi]).pSubFolder
		.IF (eax!=INVALID_HANDLE_VALUE) || (eax!=0)
			invoke GlobalFree,eax
		.ENDIF
		.IF (eax!=INVALID_HANDLE_VALUE) || (eax!=0)
			invoke GlobalFree,ebx
		.ENDIF
		mov eax,pEntryItem
		mov (ENTRY_ITEM PTR [eax]).pDirInfo,0
	.ENDIF
	ret
CleanMemory endp
;=========================================================================
	 
ISOCreationThread proc uses esi param:DWORD
	LOCAL dwFileSize:ULARGE_INTEGER
	LOCAL buffer[128]:CHAR
	LOCAL szNewISOFile[MAX_PATH]:CHAR
	LOCAL szInitFile[MAX_PATH]:CHAR
	
	invoke GetDirInfo,0,ADDR root
  	.IF bError
		invoke SendMessage,hBtnAction,WM_SETTEXT,0,ADDR szBtnQuit
		mov dwActionType,ACT_QUIT
		invoke SetFileText,ADDR szUnknownError
		invoke SetForegroundWindow,hWinDlg
	.ELSE
		xor ecx,ecx
		mov numOfFolders,ecx
		mov numOfFiles,ecx
		invoke SetIndexes,ADDR root ;return the size of ISO in Sector
		mov dwISOSectorSize,eax 
		
		;calculate the file size of iso
		mov ecx,eax
		shl eax,11
		rol ecx,11
		and ecx,7FFh
		lea edx,dwFileSize
		assume edx:PTR ULARGE_INTEGER
		mov [edx].lowPart,eax
		mov [edx].highPart,ecx
		assume edx:NOTHING
		
		mov ecx,param
		lea edi,szNewISOFile
		mov esi,DWORD PTR [ecx+4]
		.IF esi!=0
			invoke IsValidPath,esi
			.IF eax!=0
				invoke lstrcpy,edi,esi
				jmp lbl_CheckFreeSpace	;jump if the given filename is valid
			.ENDIF
		.ELSE
			invoke lstrcpy,edi,DWORD PTR [ecx]
			invoke lstrlen,edi
			mov DWORD PTR [edi+eax],"osi." ;add iso extension 
			mov BYTE PTR [edi+eax+4],0
		.ENDIF
			
	lbl_GetFileName:
		invoke SaveFileName,hWinDlg,ADDR szIsoTitle,ADDR szIsoFilter,edi
		.IF eax==0
			invoke EndDialog,hWinDlg,0
			jmp lbl_IC_Exit
		.ENDIF

	lbl_CheckFreeSpace:

		invoke IsEnoughFreeSpace,edi,ADDR dwFileSize,TRUE
		cmp eax,0
		jg lbl_CheckPatition
			invoke MessageBox,hWinDlg,ADDR szNotEnoughSpace4Create,ADDR szAppName,MB_OK + MB_ICONSTOP
		jmp lbl_GetFileName
		
	lbl_CheckPatition:
		mov eax,dwISOSectorSize
		.IF eax>=200000h ;(sectors)
			invoke GetPartitionType,edi
			.IF eax!="SFTN"  ; NTFS_Partition
				invoke MessageBox,hWinDlg,ADDR szNeedNTFSPartition,ADDR szAppName,MB_OK + MB_ICONSTOP
				jmp lbl_GetFileName
			.ENDIF
		.ENDIF
	
		invoke CreateISO,ADDR root,edi
lbl_IC_Exit:
	.ENDIF
	invoke CleanMemory,ADDR root
	invoke ExitThread,0
	ret
ISOCreationThread endp

;=========================================================================
; Check the given filename (with full path) to create ISO
; is valid or not
;-------------------------------------------------------------------------
IsValidPath proc uses esi edi lpPath:DWORD
	LOCAL pFileName:DWORD
	LOCAL buffer[MAX_PATH]:CHAR
	LOCAL curFolder[MAX_PATH]:CHAR
	
	lea edi,buffer
	mov esi,lpPath
	xor edx,edx
	mov al,BYTE PTR [esi]
	;separate path from filename
	;if the filename is not included in the path, the path must be ended by '\'
	.WHILE al!=0
		lodsb
		stosb
		.IF al=='\'
			mov edx,edi
		.ENDIF		
	.ENDW
	
	mov eax,edx
	.IF eax!=0
		mov BYTE PTR [edx],0
		invoke GetCurrentDirectory,MAX_PATH, ADDR curFolder
		.IF eax!=0
			invoke SetCurrentDirectory,ADDR buffer 
			.IF eax!=0
				invoke SetCurrentDirectory,ADDR curFolder
				mov eax,TRUE
			.ENDIF
		.ENDIF
	.ENDIF
	ret
IsValidPath endp 

;=========================================================================
; Collection all information about files and subfolders
;-------------------------------------------------------------------------
GetDirInfo proc uses edi esi ebx ecx path:DWORD, pEntryItem:DWORD
	LOCAL pDirInfo:DWORD
	LOCAL pMainData:DWORD
	LOCAL pVirMap:DWORD
	LOCAL numItems:DWORD
	LOCAL bResult:BOOL
	LOCAL pathBuffer[MAX_PATH]:CHAR
	
	mov bResult,FALSE

	invoke GlobalAlloc,GMEM_FIXED,SIZEOF DIR_INFO
	.IF eax!=INVALID_HANDLE_VALUE
		mov pDirInfo,eax
		mov esi,pEntryItem
		mov (ENTRY_ITEM PTR [esi]).pDirInfo,eax
		mov esi,eax
		mov eax,pEntryItem
		mov (DIR_INFO PTR [esi]).pEntryItem,eax
		lea edi,(DIR_INFO PTR [esi]).szPath
		mov eax,path
		.IF eax!=0
			invoke lstrcpy,edi,eax
		.ELSE
			mov DWORD PTR [edi],0
		.ENDIF
	
		invoke AddMaskAll,ADDR pathBuffer,edi
		invoke GetAllFiles,eax
		.IF (eax!=INVALID_HANDLE_VALUE)
			mov pMainData,eax
			.IF ecx>0
				mov ebx,ecx
				invoke DirSort,eax,ecx
				.IF eax!=INVALID_HANDLE_VALUE
					mov pVirMap,eax
					invoke MakeVFAT, pMainData,eax,ebx,edi
					.IF eax!=INVALID_HANDLE_VALUE
						mov esi,pDirInfo
						assume esi:PTR DIR_INFO
						mov [esi].pSubFolder,eax
						mov [esi].numItems,ebx
						mov esi,[esi].pEntryItem
						assume esi:NOTHING
						mov (ENTRY_ITEM PTR [esi]).filesize,edx		
						mov bResult,TRUE
					.ELSE
						invoke MessageBox,hWinDlg,ADDR szDebugMakeVFATError,ADDR szAppName,MB_OK
					.ENDIF
				
					invoke GlobalFree,pVirMap
				.ELSE
					invoke MessageBox,hWinDlg,ADDR szDebugDirSortError,ADDR szAppName,MB_OK
				.ENDIF
			.ELSE
				xor eax,eax
				mov esi,pDirInfo
				mov esi,(DIR_INFO PTR [esi]).pEntryItem
				mov (ENTRY_ITEM PTR [esi]).filesize,eax
				mov (ENTRY_ITEM PTR [esi]).pDirInfo,eax
				invoke GlobalFree,pDirInfo
				mov bResult,TRUE
			.ENDIF
			mov eax,pMainData
			;Clean allocated memory
			xor ebx,ebx
			@@:
				inc ebx
				push eax
				mov eax,DWORD PTR [eax+(SIZEOF WIN32_FIND_DATA)*64]
				or eax,eax
				jne @B
			.WHILE ebx>0
				call GlobalFree
				dec ebx
			.ENDW
			;----------------------
		.ELSE
			invoke MessageBox,hWinDlg,ADDR szDebugGetFilesError,ADDR szAppName,MB_OK	
		.ENDIF
		.IF !bResult
			xor eax,eax
			mov esi,pDirInfo
			mov esi,(DIR_INFO PTR [esi]).pEntryItem
			mov (ENTRY_ITEM PTR [esi]).filesize,eax
			mov (ENTRY_ITEM PTR [esi]).pDirInfo,eax
			invoke GlobalFree,pDirInfo
			mov bError,TRUE
		.ENDIF
	.ENDIF
	mov eax,bResult
	ret
GetDirInfo endp
;==================================================================
MakeVFAT proc uses esi edi ebx Array:DWORD, Map:DWORD, numItems:DWORD, path:DWORD
	LOCAL pVFAT:DWORD
	LOCAL tempPath[MAX_PATH]:CHAR
	mov eax,numItems
	inc eax
	mov ecx,SIZEOF ENTRY_ITEM
	mul ecx
	invoke GlobalAlloc,GMEM_FIXED,eax
	.IF eax!=INVALID_HANDLE_VALUE
		mov pVFAT,eax
		xor ebx,ebx
		mov edx,ebx
		.WHILE ebx<numItems
			push edx
			invoke GetAddress,Array,Map,ebx
			mov esi,eax
			
			mov eax,ebx
			mov ecx,SIZEOF ENTRY_ITEM
			mul ecx
			add eax,pVFAT
			mov edi,eax
			pop edx
			call TransferData
			
			assume edi:PTR ENTRY_ITEM
			mov al,[edi].attrib
			and al,10h
			.IF al==10h
				push edx
				lea edx,[edi].filename
				invoke PathJoin,ADDR tempPath,path,edx
				invoke GetDirInfo,eax,edi
				pop edx
			.ENDIF
			inc ebx
		.ENDW
		mov [edi].right,0
		assume edi:NOTHING
		shl edx,2		;return edx as the MAP size of folder
		mov eax,pVFAT	;return eax as a pointer to VFAT
	.ENDIF
	ret 
MakeVFAT endp 
;==================================================================
; set filesize, attrib, namelen and copy filename
; ebx = index
TransferData proc

	push edx
	push edi
	assume esi:PTR WIN32_FIND_DATA
	assume edi:PTR ENTRY_ITEM
	mov [edi].left,0
	mov eax, [esi].dwFileAttributes
	mov [edi].attrib,al
	mov [edi].pDirInfo,0
	
	mov eax,[esi].nFileSizeHigh
	.IF eax<=0
		mov eax,[esi].nFileSizeLow
		mov [edi].filesize,eax
		.IF eax>dwMaxFileSize
			mov dwMaxFileSize,eax
		.ENDIF
	.ELSE ;the file is too big
		mov [edi].filesize,-1
	.ENDIF
	
	;copy string
	lea edx,[edi].namelen
	lea esi,[esi].cFileName
	lea edi,[edi].filename
	xor ecx,ecx
	@@:
		inc ecx
		movsb
		cmp BYTE PTR [edi-1],0
		jne @B
	dec ecx
	mov BYTE PTR [edx],cl
	add ecx,14
	mov eax,ecx
	shr ecx,2
	and eax,03
	je @F
		inc ecx
	@@:
	
	pop edi
	pop edx
	add edx,ecx
	mov eax,edx
	and eax,01FFh
	.IF eax>0
		.IF eax<ecx
			sub edx,eax
			add ecx,edx
			mov [edi].right,cx
			push edi
			sub edi,SIZEOF ENTRY_ITEM
			mov [edi].right,dx
			pop edi
			mov edx,ecx
			jmp @F
		.ENDIF
	.ENDIF
	mov [edi].right,dx
@@:
	assume esi:NOTHING
	assume edi:NOTHING
	ret
TransferData endp	
;==================================================================
;return:
;eax = the handle of Memory holding a collection of WIN32_FIND_DATA 
;ecx = number of items
;edx = the pointer of the Memory
GetAllFiles proc uses esi edi ebx Path:DWORD

	invoke GlobalAlloc, GMEM_FIXED,(SIZEOF WIN32_FIND_DATA)*64+4
	push eax
	.IF eax!=INVALID_HANDLE_VALUE
		mov edi,eax
		mov DWORD PTR [edi+(SIZEOF WIN32_FIND_DATA)*64],0
		invoke FindFirstFile,Path,edi
		xor ebx,ebx
		.IF eax != INVALID_HANDLE_VALUE
			mov esi, eax		;handle of Search
			.WHILE eax!=0
				mov al,(WIN32_FIND_DATA PTR [edi]).cFileName[0]
				.IF al!='.'
					lea edi,[edi+SIZEOF (WIN32_FIND_DATA)]
					inc ebx
					mov edx,ebx
					and edx,3Fh
					.IF edx==0
						invoke GlobalAlloc,GMEM_FIXED,(SIZEOF WIN32_FIND_DATA)*64+4
						.IF eax==INVALID_HANDLE_VALUE
							invoke MessageBox,NULL,ADDR szDebugNoMoreMem,ADDR szAppName,MB_OK
							xor ebx,ebx
							.BREAK
						.ENDIF
						mov DWORD PTR [edi],eax
						mov edi,eax
						mov DWORD PTR [edi+(SIZEOF WIN32_FIND_DATA)*64],0
					.ENDIF
				.ENDIF
				invoke FindNextFile,esi,edi
			.ENDW
			invoke FindClose,esi
		.ENDIF
		mov ecx,ebx ; return numer of items to ecx
	.ELSE
		invoke MessageBox,NULL,ADDR szDebugNoMoreMem,ADDR szAppName,MB_OK
	.ENDIF
	pop eax
	ret
GetAllFiles endp
;=========================================================================
SetIndexes proc uses esi edi ebx pEntryItem:DWORD
	mov ebx,pEntryItem
	mov esi,(ENTRY_ITEM PTR [ebx]).pDirInfo
	.IF esi!=0
		assume esi:PTR DIR_INFO
		.IF [esi].numItems>0
			mov esi,ebx
			assume esi:PTR ENTRY_ITEM
			mov ecx,[esi].index
			mov eax,[esi].filesize
			mov edx,eax
			and eax,07FFh
			shr edx,11
			or eax,eax
			je @F
				inc edx	
			@@:
			push edx 		;Save the Size of FAT to create the Image
			add ecx,edx
			
			mov esi,[esi].pDirInfo
			assume esi:PTR DIR_INFO
			mov ebx,[esi].numItems
			mov edi,[esi].pSubFolder
			assume edi:PTR ENTRY_ITEM
			;----------------------------------
			push edi
			push ebx
			.WHILE ebx>0
				mov al,[edi].attrib
				and al,10h
				.IF al!=10h
					inc numOfFiles
					mov eax,[edi].filesize
					.IF eax!=0
						mov [edi].index,ecx
						mov edx,eax
						and eax,07FFh
						shr edx,11
						or eax,eax
						je @F
							inc edx
						@@:
						add ecx,edx
					.ELSE ;if filesize==0 => index=0
						mov [edi].index,eax
					.ENDIF
				.ENDIF
				lea edi,[edi+SIZEOF ENTRY_ITEM]
				dec ebx
			.ENDW
			pop ebx
			pop edi
			;----------------------------------
			push edi
			.WHILE ebx>0
				mov al,[edi].attrib
				and al,10h
				.IF (al == 10h)
					inc numOfFolders
					mov eax,[edi].filesize
					.IF (eax>0) 
						mov [edi].index,ecx
						mov edx,eax
						and eax,07FFh
						shr edx,11
						or eax,eax
						je @F
							inc edx
						@@:
						add ecx,edx
						invoke SetIndexes,edi
					.ELSE
						mov [edi].index,eax
					.ENDIF
				.ENDIF
				lea edi,[edi+SIZEOF ENTRY_ITEM]
				dec ebx
			.ENDW
			pop edi
			;------------------------------------
			pop ebx			;Restore the size of being created image
			;ebx: Size of Image, edi: pSubFolder, esi: pDirInfo
			call CreateFATImage
		.ELSE
			mov esi,pEntryItem
			assume esi:PTR ENTRY_ITEM
			xor eax,eax
			mov	[esi].index,eax
			mov [esi].filesize,eax
		.ENDIF
	.ELSE
		mov esi,pEntryItem
		assume esi:PTR ENTRY_ITEM
		xor eax,eax
		mov	[esi].index,eax
		mov [esi].filesize,eax
	.ENDIF	
	mov eax,ecx
	assume esi:NOTHING
	assume edi:NOTHING
	ret
SetIndexes endp
;=========================================================================
CreateFATImage proc uses esi edi ebx ecx
	;----------------------------------
	;Create Image
	
	shl ebx,11				;The size of image (bytes) = sectors * 2048
	invoke GlobalAlloc,GMEM_FIXED,ebx
	.IF eax!=INVALID_HANDLE_VALUE
		assume esi:PTR DIR_INFO
		mov [esi].pImage, eax
		mov [esi].dwImageSize,ebx
		
		mov esi,edi			;pSubFolder
		mov edi,eax			;pImage
		;----- FFed Image
		push edi
		mov ecx,ebx
		shr ecx,2
		xor eax,eax
		dec eax
		rep stosd
		pop edi
		;----------------
		assume esi: PTR ENTRY_ITEM
		xor ecx,ecx
		xor edx,edx
		@@:
			push esi
			push edi
			lea edi,[edi+edx*4]
			mov dx,[esi].right
			movzx cx,[esi].namelen
			lea esi,[esi].left		
			add cx,14
			rep movsb
			pop edi
			pop esi
			lea esi,[esi+SIZEOF ENTRY_ITEM]
		or edx,edx
		jne @B
	.ENDIF
	ret
CreateFATImage endp
;==================================================================
;eax: handle
;edx: pointer
DirSort proc uses esi edi ebx ecx array:DWORD, numItems:DWORD
	
	mov eax,numItems
	xor esi,esi
	lea eax,[esi+eax*4]
	invoke GlobalAlloc,GMEM_FIXED,eax
	push eax
	.IF eax != INVALID_HANDLE_VALUE
		mov edi,eax
		push edi
		mov esi,array
		mov ecx,numItems
		mov edx,ecx
		xor eax,eax
		@@:
			mov DWORD PTR [edi],eax
			inc eax
			lea edi,[edi+4]
		loop @B
		pop edi
		dec edx
		mov esi,edi
		mov edi,array
		invoke EnhancedQuickSort,0,edx
	.ENDIF
	pop eax
	ret
DirSort endp
;==========================================================================
;	edi: pMainArray
;	esi: vMap
EnhancedQuickSort proc uses esi edi ebx ecx edx dwLow:DWORD, dwHigh:DWORD
	mov eax,dwHigh
	sub eax,dwLow
	.IF eax>3
		mov ecx,dwLow
		mov edx,dwHigh
		invoke Compare,ecx,edx
		or eax,eax
		jle @F
			invoke Swap,ecx,edx
		@@:
		mov ebx,ecx
		;now ebx is pivot
		.WHILE edx>ecx
			dec edx
			.WHILE edx>ecx
				invoke Compare,ebx,edx
				or eax,eax
				jl @F
					invoke Swap,ebx,edx
					mov ebx,edx
					.BREAK
				@@:
				dec edx
			.ENDW
			inc ecx
			.WHILE ecx<edx
				invoke Compare,ecx,ebx
				or eax,eax
				jl @F
					invoke Swap,ecx,ebx
					mov ebx,ecx
					.BREAK
				@@:
				inc ecx
			.ENDW
		.ENDW
		dec ebx
		cmp ebx,dwLow
		jle @F
			invoke EnhancedQuickSort,dwLow,ebx
		@@:
		inc ebx
		inc ebx
		cmp ebx,dwHigh
		jge @F
			invoke EnhancedQuickSort,ebx,dwHigh
		@@:
	.ELSE
		mov ebx,dwLow
		inc ebx
		.WHILE (ebx<=dwHigh)
			mov edx,ebx
			mov ecx,ebx
			.WHILE ecx>dwLow
				dec ecx
				invoke Compare,ecx,edx
				or eax,eax
				jle @F	
				invoke Swap,ecx,edx
				dec edx
			.ENDW
			@@:
			inc ebx
		.ENDW
	.ENDIF
	ret
EnhancedQuickSort endp 
;==========================================================================
;edi: pMainArray
;esi: vMap
Compare proc uses ecx edx pos1:DWORD, pos2:DWORD

	invoke GetAddress,edi,esi,pos2
	lea eax,(WIN32_FIND_DATA PTR [eax]).cFileName
	push eax

	invoke GetAddress,edi,esi,pos1
	lea eax,(WIN32_FIND_DATA PTR [eax]).cFileName
	push eax

	call StringCompare
	ret
Compare endp
;==========================================================================

StringCompare proc uses esi edi edx lpStr1:DWORD, lpStr2:DWORD
	mov esi,lpStr1
	mov edi,lpStr2
	xor eax,eax
	mov edx,eax
SC_NextChar:
	mov al,BYTE PTR [esi]
	mov dl,BYTE PTR [edi]
	or dl,dl
	jz SC_Exit
	or al,al
	jz SC_Exit
	
	cmp al,'a'
	jb @F
	cmp al,'z'
	ja @F
	sub al,32
@@:
	cmp dl,'a'
	jb @F
	cmp dl,'z'
	ja @F
	sub dl,32
@@:
	inc esi
	inc edi
	cmp al,dl
	je SC_NextChar
SC_Exit:
	sub al,dl
	movsx eax,al
	ret
StringCompare endp

;==========================================================================
GetAddress proc uses edi esi ecx pFileData:DWORD,pMap:DWORD,pos:DWORD
	mov edi,pFileData
	mov esi,pMap
	mov eax,pos
	mov ecx,DWORD PTR [esi+eax*4]
	mov eax,ecx
	shr ecx,6
	.WHILE ecx>0
		lea edi,[edi+ (SIZEOF WIN32_FIND_DATA)*64]
		mov edi,DWORD PTR [edi]
		dec ecx
	.ENDW
	and eax,3Fh
	mov ecx,SIZEOF WIN32_FIND_DATA
	mul ecx
	add eax,edi
	ret
GetAddress endp	
;==========================================================================
;edi: pMainArray
;esi: vMap
Swap proc uses ecx edx pos1:DWORD, pos2:DWORD
	mov ecx, pos1
	mov edx, pos2
	mov eax, DWORD PTR [esi+ecx*4]
	push [esi+edx*4]
	pop [esi+ecx*4]
	mov DWORD PTR [esi+edx*4],eax
	ret
Swap endp

;==========================================================================
;size of iso is rouned to 10000h
;=========================================================================		
	
CreateISO proc uses esi edi ebx pRoot:DWORD,lpNewISOFile:DWORD
	LOCAL pDwHiSize:DWORD

	;Set appropriate buffer size
	mov eax,dwMaxFileSize
	shr eax,10
	.IF eax>1800h ;50MB/4 = 12.5MB
		mov eax,1800h
	.ENDIF
	shl eax,11
	invoke SetBufferSize,eax
	
	invoke GlobalAlloc,GMEM_FIXED,eax
	.IF eax!=INVALID_HANDLE_VALUE
		mov edi,eax
		invoke CreateFile,lpNewISOFile,GENERIC_WRITE,0,NULL,
				CREATE_ALWAYS, FILE_ATTRIBUTE_ARCHIVE,NULL
		.IF eax!=INVALID_HANDLE_VALUE
			mov esi,eax
			mov dwCurrentSize,0
			mov dwCurPos,0
			invoke SetProgressRange,dwISOSectorSize
			invoke GlobalAlloc,GMEM_FIXED or GMEM_ZEROINIT,10000h
			mov pZeroImage,eax
			mov edx,pRoot
			assume edx:PTR ENTRY_ITEM
			mov ecx,[edx].filesize
			mov ebx,[edx].pDirInfo
			.IF eax!=0
				mov eax,dwISOSectorSize
				mov edx,eax
				and eax,1Fh
				je @F
					shr edx,5
					inc edx
					shl edx,5
				@@:
				invoke CopyHeader,esi,edi,edx,ecx
				;write FAT------------
				assume ebx:PTR DIR_INFO
				mov edx,[ebx].pImage
				mov ecx,[ebx].dwImageSize
				invoke WriteFile,esi,edx,ecx,ADDR WBytes,NULL
				cmp bStop,TRUE
				je UserStop
				assume ebx:NOTHING
				;--- Write Files and Folders -----------------
				invoke WriteXFolder,esi,edi,ebx
				cmp bStop,TRUE
				je UserStop
				;--- Round the image to 10000h in size
				invoke GetFileSize,esi,ADDR pDwHiSize
				and eax,0FFFFh
				.IF eax!=0
					mov ecx,10000h
					sub ecx,eax
					invoke WriteFile,esi,pZeroImage,ecx,ADDR WBytes,NULL
				.ENDIF
			.ENDIF
		UserStop:
			invoke GlobalFree,pZeroImage
			invoke CloseHandle,esi	
		.ENDIF
		invoke GlobalFree,edi
		.IF !bStop
			invoke SetFileText,ADDR szActionComplete
		.ELSEIF bError
			invoke SetFileText,lpszErrorMsg
		.ELSE
			invoke SetFileText,ADDR szUserStop
			invoke DeleteFile,lpNewISOFile
		.ENDIF
	.ELSE
		invoke SetFileText,ADDR szCreatNewFileError
	.ENDIF
	mov bStop,TRUE
	invoke CleanMemory,pRoot
	invoke SendMessage,hBtnAction,WM_SETTEXT,0,ADDR szBtnQuit
	mov dwActionType,ACT_QUIT
	invoke SetForegroundWindow,hWinDlg
	
	ret
CreateISO endp
;=========================================================================
WriteXFolder proc uses esi edi ebx hFile:DWORD,pBuffer:DWORD,pDirInfo:DWORD
	LOCAL pPath:DWORD
	mov esi, pDirInfo
	assume esi:PTR DIR_INFO
	mov ebx,[esi].numItems
	.IF ebx>0
		lea eax,[esi].szPath
		mov pPath,eax
		mov esi,[esi].pSubFolder	
		;-------------- Write files and FAT of sub folders
		assume esi:PTR ENTRY_ITEM
		push esi
		push ebx
		.WHILE ebx>0
			mov al,[esi].attrib 
			and al,10h
			.IF al != 10h
				lea edx,[esi].filename
				mov eax,[esi].filesize
				.IF eax==-1
					mov bStop,TRUE
					mov bError,TRUE
					push OFFSET szFileTooBigError
					pop lpszErrorMsg
					jmp WXF_UserStop
				.ENDIF
				.IF eax!=0
					invoke WriteXFile,hFile,pBuffer,pPath,edx
				.ENDIF
			.ENDIF
			
			.BREAK .IF bStop==TRUE
			lea esi,[esi+SIZEOF ENTRY_ITEM]
			dec ebx
		.ENDW
		pop ebx
		pop esi
		cmp bStop,TRUE
		je WXF_UserStop
		;-------------- Write sub folders
		.WHILE ebx>0
			mov al,[esi].attrib 
			and al,10h
			.IF (al == 10h)
				.IF ([esi].filesize!=0)
					mov edi,[esi].pDirInfo
					assume edi:PTR DIR_INFO
					mov edx,[edi].pImage
					mov ecx,[edi].dwImageSize
					; Write FAT of sub folder
					invoke WriteFile,hFile,edx,ecx,ADDR WBytes,NULL
					invoke SetProgressPos,WBytes
					; Write the files inside the folder
					invoke WriteXFolder,hFile,pBuffer,edi
					assume edi:NOTHING
				.ENDIF
			.ENDIF
			cmp bStop,TRUE
			je WXF_UserStop
			lea esi,[esi+SIZEOF ENTRY_ITEM]
			dec ebx
		.ENDW
	.ENDIF
WXF_UserStop:
	assume esi:NOTHING
	ret
WriteXFolder endp
;=========================================================================
WriteXFile proc uses edi esi ebx hFile:DWORD,pBuffer:DWORD,path:DWORD,filename:DWORD
	LOCAL fullPath[MAX_PATH]:CHAR
	lea edi,fullPath
	invoke PathJoin,edi,path,filename
	invoke SetFileText,edi
	invoke CreateFile,edi,GENERIC_READ,FILE_SHARE_READ,NULL,
			OPEN_EXISTING,FILE_ATTRIBUTE_ARCHIVE,NULL
	.IF eax!=INVALID_HANDLE_VALUE
		mov ebx,eax
		mov esi,pBuffer
		invoke ReadFile,ebx,esi,dwBufferSize,ADDR RBytes,NULL
		.WHILE eax!=0
			mov ecx,RBytes
			invoke WriteFile,hFile,esi,ecx,ADDR WBytes,NULL
			.IF eax==0
				mov bStop,TRUE
				mov bError,TRUE
				push OFFSET szWriteFileError
				pop lpszErrorMsg
				.BREAK
			.ENDIF
			invoke SetProgressPos,WBytes
			mov eax,WBytes
			.BREAK .IF eax<dwBufferSize
			.BREAK .IF bStop==TRUE
			mov WBytes,0
			invoke ReadFile,ebx,esi,dwBufferSize,ADDR RBytes,NULL
		.ENDW
		mov eax,WBytes
		and eax,07FFh
		.IF (eax>0) && (bStop!=TRUE)
			mov ecx,800h
			sub ecx,eax
			invoke WriteFile,hFile,pZeroImage,ecx,ADDR WBytes,NULL
			.IF eax==0
				mov bStop,TRUE
				mov bError,TRUE
				push OFFSET szWriteFileError
				pop lpszErrorMsg
			.ELSE
				invoke SetProgressPos,WBytes
			.ENDIF
		.ENDIF
		
		invoke CloseHandle,ebx
	.ELSE
		mov bStop,TRUE
		mov bError,TRUE
		push OFFSET szFileOpenError
		pop lpszErrorMsg
		invoke MessageBox,hWinDlg,ADDR fullPath,ADDR szOpenFileError,MB_OK + MB_ICONSTOP
	.ENDIF			
	ret
WriteXFile endp
;=========================================================================
	HEADER_SIZE equ 84000h
CopyHeader proc uses esi edi ebx hNewFile:DWORD,pBuffer:DWORD,ISOSize:DWORD,rootSize:DWORD
	LOCAL bReturn:DWORD
	LOCAL nSystemTime:SYSTEMTIME
	LOCAL nFileTime:FILETIME
	mov bReturn,FALSE
	invoke GlobalAlloc,GMEM_FIXED or GMEM_ZEROINIT,HEADER_SIZE
	.IF eax!=INVALID_HANDLE_VALUE
		mov ebx,eax
		;File Header Information
		lea edi,[ebx+8000h]
		mov eax,30444301h
		mov [edi],eax		;Write 01+"CD0"
		mov eax,00013130h
		mov [edi+4h],eax		;Write "01"+01
		
		mov eax,ISOSize
		mov [edi+50h],eax
		rol ax,8
		rol eax,16
		rol ax,8
		mov [edi+54h],eax

		mov eax,01000001h
		mov [edi+78h],eax
		mov [edi+7Ch],eax
		mov eax,00080800h
		mov [edi+80h],eax
		
		mov eax,20202020h
		mov ecx,156
		lea edi,[edi+0BEh]
		rep stosd
		dec edi
		mov eax,30303030h
		mov ecx,4
		@@:
			stosd
			stosd
			stosd
			stosd
			inc edi
		loop @B
		mov BYTE PTR [edi],01h
		
		lea edi,[ebx+8800h]
		mov eax,304443FFh
		mov [edi],eax		;Write FF+"CD0"
		mov eax,00013130h
		mov [edi+4h],eax		;Write "01"+01
		
		;--- Fill XIso Info
		lea edi,[ebx+10000h]
		push edi
		mov ecx,5
		mov esi,OFFSET szXboxMediaString
		rep movsd
		mov eax,0108h
		stosd
		mov eax,rootSize
		stosd
		invoke GetSystemTime,ADDR nSystemTime
		invoke SystemTimeToFileTime,ADDR nSystemTime,ADDR nFileTime
		lea esi,nFileTime
		movsd
		movsd
		pop edi
		lea edi,[edi+7ECh]
		mov eax,"RCIM"
		stosd
		mov eax,"FOSO"
		stosd
		mov eax,"BX*T"
		stosd
		mov eax,"M*XO"
		stosd
		mov eax,"AIDE"
		stosd
		invoke WriteFile,hNewFile,ebx,HEADER_SIZE,ADDR WBytes,NULL
		invoke GlobalFree,ebx
	.ENDIF
	mov eax,bReturn
	ret
CopyHeader endp
;=========================================================================
SetBufferSize proc dwSuggestedSize:DWORD
	LOCAL mst:MEMORYSTATUS
	mov mst.dwLength,SIZEOF MEMORYSTATUS
	invoke GlobalMemoryStatus,ADDR mst
	mov eax,mst.dwAvailPhys
	sub eax,5*1024*1024		;2MB
	mov ecx,dwSuggestedSize
	.IF eax<ecx
		and eax,0FFFF0000h
		.IF eax==0
			mov eax,10000h  ;	atleast 528KB
		.ENDIF
	.ELSE
		mov eax,ecx
	.ENDIF
	mov dwBufferSize,eax
	ret
SetBufferSize endp
; #########################################################################
	MAX_BUFFER_SIZE equ 10*1024*1024
;This is a Thread	
ISOExtract proc uses esi param:DWORD
	LOCAL hISOFile:DWORD
	LOCAL dwHiSize:DWORD
	LOCAL szStorageFolder[MAX_PATH]:CHAR
	invoke GetTickCount
	mov dwStartTime,eax
	mov esi,param
	assume esi:PTR EXTRACT_ITEM
	invoke SetCurrentDirectory,[esi].folder
	.IF eax!=0
		invoke CreateFile,[esi].filename, GENERIC_READ, FILE_SHARE_READ, NULL,\
				OPEN_EXISTING, FILE_ATTRIBUTE_ARCHIVE, NULL
		assume esi:NOTHING
		.IF eax!=INVALID_HANDLE_VALUE
			mov hISOFile, eax
			
			invoke GetFileSize,hISOFile,ADDR dwHiSize
			shr eax,11
			mov ecx,dwHiSize
			shl ecx,21
			or eax,ecx ;convert to sector size
			invoke SetProgressRange,eax
			invoke SetBufferSize,MAX_BUFFER_SIZE
			invoke GlobalAlloc, GMEM_FIXED,dwBufferSize
			mov pWriteBuffer,eax		
			mov esi,eax
			
			xor eax,eax
			mov root.left,ax
			mov root.right,ax
			mov al,10h
			mov root.attrib,al
			
			invoke SetFilePointer, hISOFile, 10014h,0,FILE_BEGIN
			invoke ReadFile,hISOFile,ADDR root.index, 8, ADDR RBytes,NULL
			.IF eax!=0
				invoke ReadFolder,hISOFile, root.index, root.filesize, 0
				.IF bStop
					invoke SetFileText,ADDR szUserStop
				.ELSE
					invoke GetTickCount
					mov dwStopTime,eax
					invoke SetFileText,ADDR szActionComplete
				.ENDIF
			.ENDIF
			invoke GlobalFree, pWriteBuffer
			invoke CloseHandle,hISOFile
		.ELSE
			invoke SetFileText,ADDR szOpenFileError
		.ENDIF
	.ELSE
		invoke SetFileText,ADDR szNonExistFolder
	.ENDIF
	invoke SetForegroundWindow,hWinDlg
	invoke SendMessage,hBtnAction,WM_SETTEXT,0,ADDR szBtnQuit
	mov dwActionType,ACT_QUIT
IE_UserStop:
	invoke ExitThread, 0
	ret
ISOExtract endp

; #########################################################################
	
ReadFolder proc uses edi esi hFile:DWORD, startingSector:DWORD, mapSize:DWORD, folderName:DWORD
	LOCAL pMFolder:DWORD
	LOCAL dwHighSize:DWORD
	LOCAL entryName[256]:CHAR
	LOCAL fullPath[MAX_PATH]:CHAR
	
	invoke GlobalAlloc, GMEM_FIXED, mapSize
	mov pMFolder,eax
	
	mov edx,startingSector
	mov eax,edx
	shl edx,11
	and eax, 0FFE00000h
	rol eax,11
	mov dwHighSize,eax
			
	invoke SetFilePointer, hFile, edx, ADDR dwHighSize,FILE_BEGIN
	invoke ReadFile, hFile, pMFolder, mapSize,ADDR RBytes,NULL
	invoke SetProgressPos, RBytes
	mov eax, RBytes
	.IF (eax>0)
		
		mov eax,0
		@@:
			
			shl eax,2
			add eax,pMFolder
			mov esi,eax
			assume esi:PTR ENTRY_ITEM
			movsx	edx,[esi].namelen
			inc edx
			invoke lstrcpyn,ADDR entryName,ADDR [esi].filename[0],edx
			mov edx,eax
			movsx eax, [esi].right
			push eax
			mov al, [esi].attrib
			and al,10h
			.IF (al==10h)
				lea edi,fullPath
				invoke PathJoin,edi,folderName,ADDR entryName
				invoke CreateDirectory,edi,NULL
				push edi
				push [esi].filesize
				push [esi].index
				push hFile
				call ReadFolder
			.ELSE
				xor eax,eax
				push folderName
				push edx
				mov al, [esi].namelen
				push eax
				mov al, [esi].attrib
				push eax
				push [esi].filesize
				push [esi].index
				mov ax, [esi].right
				push eax
				mov ax, [esi].left
				push eax
				push hFile
				call ExtractFile
			.ENDIF
			pop eax
			.IF bStop
				jmp RF_Exit
			.ENDIF
			cmp ax,0
	 		ja @B
	 
		assume esi:NOTHING
		
	.ENDIF
RF_Exit:	
	invoke GlobalFree, pMFolder
	
	ret
ReadFolder endp

;#########################################################

ExtractFile proc uses edi hFile:DWORD,wLeft:DWORD,wRight:DWORD,dwIndex:DWORD,dwSize:DWORD,bAttrib:DWORD,bLength:DWORD,filename:DWORD, path:DWORD
	LOCAL hNewFile:DWORD
	LOCAL dwSizeHigh:DWORD
	LOCAL tempStr[MAX_PATH]:CHAR

	invoke PathJoin,ADDR tempStr,path,filename
	invoke SetFileText,ADDR tempStr
		
	invoke CreateFile, ADDR tempStr, GENERIC_WRITE,0, NULL,\
		CREATE_ALWAYS, FILE_ATTRIBUTE_ARCHIVE, NULL
	.IF eax!=INVALID_HANDLE_VALUE
		mov hNewFile, eax
		mov edx,dwIndex
		.IF dwIndex!=0
			mov eax,edx
			shl edx,11
			and eax, 0FFE00000h
			rol eax,11
			mov dwSizeHigh,eax
			
			invoke SetFilePointer, hFile, edx,ADDR dwSizeHigh,FILE_BEGIN
			
			mov edi,dwSize
			.IF edi!=0
				.WHILE edi>dwBufferSize
					invoke ReadFile, hFile, pWriteBuffer, dwBufferSize,ADDR RBytes,NULL
					; if RWBytes != dwBufferSize => Error
					.IF (eax!=0)
						mov edx,RBytes
						invoke WriteFile,hNewFile,pWriteBuffer,edx,ADDR WBytes,NULL
						invoke SetProgressPos, WBytes
					.ENDIF
					sub edi,dwBufferSize
					.BREAK .IF bStop
				.ENDW
				.IF (edi>0) && (!bStop)
					invoke ReadFile, hFile,pWriteBuffer, edi,ADDR RBytes,NULL
					; if RWBytes != edi => Error
					.IF (eax!=0)
						mov edx,RBytes
						invoke WriteFile,hNewFile,pWriteBuffer,edx,ADDR WBytes,NULL
						invoke SetProgressPos, WBytes
					.ENDIF
				.ENDIF
			.ENDIF
		.ENDIF
		invoke CloseHandle, hNewFile
	.ELSE
	;error

	.ENDIF

	ret
ExtractFile endp
;=========================================================================
; Browse for folder PROCEDURE
;=========================================================================
	BIF_NEWDIALOGSTYLE equ 40h
ChooseFolder proc hParent:DWORD,lpTitle:DWORD,lpFolder:DWORD,bNewFolder:DWORD
	LOCAL	pidl:DWORD
	LOCAL	bri:BROWSEINFO
   
   	xor ecx,ecx
	
	push	hParent
	pop	bri.hwndOwner
	mov	bri.pidlRoot, ecx
	mov	bri.pszDisplayName, ecx
	push lpTitle
	pop	bri.lpszTitle
	mov eax,BIF_RETURNONLYFSDIRS or BIF_DONTGOBELOWDOMAIN or BIF_STATUSTEXT
	.IF bNewFolder==TRUE
		or eax,BIF_NEWDIALOGSTYLE
	.ENDIF
	mov	bri.ulFlags,eax
	
	push OFFSET BrowseCallbackProc
	pop bri.lpfn
	push lpFolder
	pop	bri.lParam
	
	mov	bri.iImage, ecx
	invoke SHBrowseForFolder, ADDR bri
	.IF eax!=NULL
		mov pidl, eax
		invoke SHGetPathFromIDList, pidl,lpFolder
	.ENDIF
		
	ret
ChooseFolder  endp

;=========================================================================
; Callback function to set initial folder
;-------------------------------------------------------------------------
BrowseCallbackProc proc hWnd:DWORD, uMsg:DWORD, lparam:DWORD, lpData:DWORD
	LOCAL szDir[MAX_PATH]:CHAR
	mov eax,uMsg
	.IF eax==BFFM_INITIALIZED
		mov eax,lpData
		.IF BYTE PTR [eax]!=0
			invoke SendMessage,hWnd, BFFM_SETSELECTION, TRUE, eax
		.ENDIF
	.ENDIF
	ret
BrowseCallbackProc endp

;=========================================================================
; Callback function to set initial folder
;-------------------------------------------------------------------------
CreateNewFolder proc uses edi esi lpPath:DWORD
	LOCAL SlashPointers[128]:DWORD
	LOCAL tempPath[MAX_PATH]:CHAR
	lea edi,tempPath
	mov esi,lpPath
	lea edx,SlashPointers
	mov al,BYTE PTR [esi]
	.WHILE al!=0
		lodsb
		stosb
		.IF al=='\'
			mov ecx,edi
			dec ecx
			mov DWORD PTR [edx],ecx
			lea edx,[edx+4] 
		.ENDIF
	.ENDW
	mov DWORD PTR [edx],0
	
	lea esi,tempPath
	lea edi,SlashPointers
	.WHILE DWORD PTR [edi]!=0
		mov eax,DWORD PTR [edi]
		mov BYTE PTR [eax],'\'
		lea edi,[edi+4]
		mov eax,DWORD PTR [edi]
		.IF eax!=0
			mov BYTE PTR [eax],0
		.ENDIF
		invoke CreateDirectory,esi,NULL
	.ENDW
	;the result of this function is the result of last CreateDirectory
	ret
CreateNewFolder endp
;=========================================================================
PathJoin proc uses esi edi szTemp:DWORD, folder:DWORD, fileName:DWORD
	
	mov edi,szTemp
	push edi
	mov esi,folder
	or esi,esi
	je next
	cmp BYTE PTR [esi],0
	je next
	xor ax,ax
	@@:
		lodsb
		stosb
		or al,al
	jne @B
	mov BYTE PTR [edi-1],"\"
next:		
	mov esi,fileName
	xor ax,ax
	@@:
		lodsb
		stosb
		or al,al
	jne @B
	pop eax
	ret
PathJoin endp
;=========================================================================
AddMaskAll proc uses esi edi szTemp:DWORD, szPath:DWORD
	mov edi,szTemp
	push edi
	mov esi,szPath
	or esi,esi
	je AMA_End
	cmp BYTE PTR [esi],0
	je AMA_End
	xor ax,ax
	@@:
		lodsb
		stosb
		or al,al
	jne @B
	mov BYTE PTR [edi-1],"\"
AMA_End:
	mov DWORD PTR [edi],"*.*"
	pop eax
	ret
AddMaskAll endp
;===========================================================================
SaveFileName proc uses edi esi ebx hParent:DWORD,lpTitle:DWORD,lpFilter:DWORD,lpNewFile:DWORD
	LOCAL ofn:OPENFILENAME
	LOCAL szInitFolder[MAX_PATH]:CHAR
	;---- initialize ofn
	xor eax,eax
	lea edi,ofn
	mov ecx,SIZEOF OPENFILENAME
	shr ecx,2
	rep stosd
	;-------------------
	mov esi,lpNewFile
	lea edi,szInitFolder
	xor ebx,ebx
	mov al,BYTE PTR [esi]
	.IF al!=0
		.WHILE al!=0
			lodsb
			stosb
			.IF al=='\'
				mov ebx,edi
			.ENDIF
		.ENDW
		.IF ebx!=0
			invoke lstrcpy,lpNewFile,ebx
			mov BYTE PTR [ebx],0
		.ENDIF
		lea edx,szInitFolder
	.ELSE
		xor edx,edx
	.ENDIF
	
	lea edi,ofn
	assume edi:PTR OPENFILENAME
	mov [edi].lStructSize, SIZEOF OPENFILENAME
	mov [edi].lpstrInitialDir,edx
	
	push hParent
	pop [edi].hWndOwner
	
	push hInstance
	pop [edi].hInstance
	
	push lpFilter
	pop [edi].lpstrFilter
	
	mov eax,lpNewFile
	mov [edi].lpstrFile,eax
	mov [edi].nMaxFile,MAX_PATH
	
	push OFFSET szDefaultExtension
	pop [edi].lpstrDefExt
	
	push lpTitle
	pop [edi].lpstrTitle
	
	mov [edi].Flags, OFN_EXPLORER or OFN_LONGNAMES or OFN_NOCHANGEDIR or OFN_OVERWRITEPROMPT
	
	invoke GetSaveFileName,ADDR ofn
	movzx ecx,[edi].nFileOffset
	assume edi:NOTHING
	ret
SaveFileName endp
;===========================================================================
ChooseIsoFile proc uses edi hParent:DWORD,lpTitle:DWORD,lpFilter:DWORD,lpIsoFile:DWORD
	LOCAL ofn:OPENFILENAME
	
	xor eax,eax
	lea edi,ofn
	mov ecx,SIZEOF OPENFILENAME
	shr ecx,2
	rep stosd
	
	lea edi,ofn
	assume edi:PTR OPENFILENAME
	mov [edi].lStructSize, SIZEOF OPENFILENAME
	
	push hParent
	pop [edi].hWndOwner
	
	push hInstance
	pop [edi].hInstance
	
	push lpFilter
	pop [edi].lpstrFilter
	
	mov eax,lpIsoFile
	mov DWORD PTR [eax],0
	mov [edi].lpstrFile,eax
	
	mov [edi].nMaxFile,MAX_PATH
	
	push lpTitle
	pop [edi].lpstrTitle
	
	mov [edi].Flags, OFN_EXPLORER or OFN_LONGNAMES or OFN_NOCHANGEDIR or OFN_FILEMUSTEXIST
	
	invoke GetOpenFileName,ADDR ofn
	
	ret
ChooseIsoFile endp
;===========================================================================
SetProgressRange proc uses ebx ISOSectorSize:DWORD

	mov eax,ISOSectorSize
	sub eax,265
	mov edx,eax
	xor ecx,ecx
	xor ebx,ebx
	inc ebx
	@@:
		and eax,0FFFF0000h
		je @F
		shr edx,1
		mov eax,edx
		inc ecx
		shl ebx,1
		jmp @B
	@@:
	dec ebx
	
	mov dwPMask,ebx
	mov dwPShift,ecx
	mov dwMaxRange,edx
	mov dwCurPos,0
	rol edx,16
	invoke SendMessage,hProgress,PBM_SETRANGE,0,edx
	invoke SendMessage,hProgress,PBM_SETPOS,0,0
	ret
SetProgressRange endp
;==========================================================================
SetProgressPos proc uses esi ebx ecx edx addedSize:DWORD
	mov edx,addedSize
	mov eax,edx
	shr edx,11		;divide addedSize/2048
	and eax,7FFh
	je @F
		inc edx		;round the size into Sector size
	@@:	
	add edx,dwCurrentSize
	mov dwCurrentSize,edx
	mov eax,edx
	mov ecx,dwPShift
	shr eax,cl
	
	or eax,eax
	je @F
		and edx,dwPMask
		mov dwCurrentSize,edx
		add eax,dwCurPos
		mov dwCurPos,eax
		invoke SendMessage,hProgress,PBM_SETPOS,eax,NULL
	@@:
	ret
SetProgressPos endp
;==========================================================================
SetFileText proc lpText:DWORD
	.IF bError
		invoke SendMessage,hLblAction,WM_SETTEXT,0,ADDR szLblActError
	.ENDIF
	invoke SendMessage,hLblFile,WM_SETTEXT,0,lpText
	ret
SetFileText endp
;*******************************************************************
OnlyOneInstance	proc uses ebx
	LOCAL	hSemaphore:HANDLE
	
	invoke	CreateSemaphore, NULL, 0, 1, ADDR szClassName
	mov	hSemaphore,eax

	invoke	GetLastError
	.IF (eax == ERROR_ALREADY_EXISTS)
		invoke	CloseHandle, hSemaphore
		invoke	FindWindow,NULL,ADDR szAppName
		.IF eax!=0
			invoke SetForegroundWindow,eax
		.ENDIF
		xor eax,eax
	.ELSEIF (eax == ERROR_SUCCESS) ; created Semaphore will
		mov	eax, TRUE  		; prevent other instances
	.ELSE
		xor eax,eax
	.ENDIF
	
	ret
OnlyOneInstance	endp
;==========================================================================
IsEnoughFreeSpace proc uses edi lpszPath:DWORD,lpULInteger:DWORD,bCutFileName:DWORD
	LOCAL localFreeBytes:ULARGE_INTEGER
	LOCAL totalBytes:ULARGE_INTEGER
	LOCAL totalFreeBytes:ULARGE_INTEGER
	LOCAL folderPath[MAX_PATH]:CHAR
	.IF bCutFileName
		push esi
		mov esi,lpszPath
		lea edi,folderPath
		push edi
		.WHILE BYTE PTR [esi]!=0
			movsb
			.IF BYTE PTR [esi]=='\'
				mov edx,edi
			.ENDIF
		.ENDW
		mov BYTE PTR [edi],0
		mov BYTE PTR [edx],0
		pop edi
		pop esi
	.ELSE
		mov edi,lpszPath
	.ENDIF
	invoke GetDiskFreeSpaceEx,edi,ADDR localFreeBytes,\
		ADDR totalBytes, ADDR totalFreeBytes
	mov edx,lpULInteger
	assume edx:PTR ULARGE_INTEGER
	lea ecx,localFreeBytes
	assume ecx:PTR ULARGE_INTEGER
	mov eax,[ecx].highPart
	.IF eax==[edx].highPart
		mov eax,[ecx].lowPart
		sub eax,[edx].lowPart
	.ELSE
		sub eax,[edx].highPart
	.ENDIF
	mov ecx,0
	jz @F 
		;if eax!=0
		jc lLow
			; if Borrow is zero return 1
			inc ecx
			jmp @F
		lLow:
			; if Borrow is zero return -1
			dec ecx
	@@:
	mov eax,ecx
	assume ecx:NOTHING
	assume edx:NOTHING
	ret
IsEnoughFreeSpace endp
;==========================================================================
GetPartitionType proc uses edi esi lpPath:DWORD
	LOCAL pathDrive[8]:CHAR
	LOCAL szFileSystemName[256]:CHAR
	
	mov esi,lpPath
	lea edi,pathDrive
	mov al,BYTE PTR [esi]
	.WHILE al!=0
		lodsb
		stosb
		.BREAK .IF al=='\'
	.ENDW
	lea edi,szFileSystemName
	mov DWORD PTR [edi],0
	invoke GetVolumeInformation,ADDR pathDrive,NULL,0,NULL,NULL,NULL,edi,256
	mov eax,DWORD PTR [edi]
	
	ret
GetPartitionType endp
;==========================================================================
	szLogFileName db "SimpleXLog.txt",0
	szFormatLogLine db "[%02d/%02d/%04d %2d:%2d:%2d]: %s",13,10,0
WriteLogFile proc uses esi edi lpszLogLine:DWORD
	LOCAL now:SYSTEMTIME
	LOCAL argList[8]:DWORD
	LOCAL buffer[512]:CHAR
	.IF DEBUG
		.IF hLogFile==0
			invoke CreateFile,ADDR szLogFileName,GENERIC_WRITE,FILE_SHARE_READ or FILE_SHARE_WRITE,\
				NULL,OPEN_EXISTING,0,NULL
			.IF eax!=INVALID_HANDLE_VALUE
				mov hLogFile,eax
			.ENDIF
		.ENDIF

		.IF hLogFile!=0
			lea esi,now
			invoke GetLocalTime,esi
			lea edi,argList[0]
			
			assume esi:PTR SYSTEMTIME
			movsx eax,[esi].wDay
			stosd
			movsx eax,[esi].wMonth
			stosd
			movsx eax,[esi].wYear
			stosd
			movsx eax,[esi].wHour
			stosd
			movsx eax,[esi].wMinute
			stosd
			movsx eax,[esi].wSecond
			stosd
			assume esi:NOTHING
			mov eax,lpszLogLine
			stosd
			
			lea edi,buffer
			lea esi,argList[0]
			invoke wvsprintf,edi,ADDR szFormatLogLine,esi
			invoke lstrlen,edi
			invoke WriteFile,hLogFile,edi,eax,ADDR WBytes,NULL
		.ENDIF
	.ENDIF
	ret
WriteLogFile endp
;==========================================================================
MyMessageBox proc msg:DWORD
	invoke MessageBox,hWinDlg,msg,ADDR szAppName,MB_OK
	ret
MyMessageBox endp
;##########################################################################
end start
;##########################################################################
