/*
	Copyright 2003 Chris Cavey
	
	This file is part of XID.
	
	XID is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.
	
	XID is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with XID; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _XID_REPORT_H
#define _XID_REPORT_H
	
#ifdef __cplusplus
extern "C"
{
#endif
	#include "wdm.h"
#ifdef __cplusplus
}
#endif

#include "xidcontroller.h"
#include "xidconfig.h"
#include "xidtypes.h"
#include "xidbytestream.h"

// "genConfig" bit flags

#define _X_FLAG	0x00000001
#define _Y_FLAG	0x00000002
#define _RX_FLAG	0x00000004
#define _RY_FLAG	0x00000008
#define _Z_FLAG	0x00000010
#define _RZ_FLAG	0x00000020
#define _S1_FLAG	0x00000040
#define _S2_FLAG	0x00000080
#define _HAT_FLAG	0x00000100
#define X_AXIS		0
#define Y_AXIS		1
#define RX_AXIS	2
#define RY_AXIS	3
#define Z_AXIS		4
#define RZ_AXIS	5
#define S1_AXIS	6
#define S2_AXIS	7
#define BUTTON1	8
#define BUTTON2	9
#define BUTTON3	10
#define BUTTON4	11
#define BUTTON5	12
#define BUTTON6	13
#define BUTTON7	14
#define BUTTON8	15
#define BUTTON9	16
#define BUTTON10	17
#define BUTTON11	18
#define BUTTON12	19
#define BUTTON13	20
#define BUTTON14	21
#define BUTTON15	22
#define BUTTON16	23
#define POVHAT		24

class XIDREPORT
{
	private:
		bool flag;
		unsigned int reportDescSize, inputReportSize, largeAxesCount, smallAxesCount;
		signed int offsetMapping[25]; // need a -1 sentinel value
	public:
		XIDREPORT();
		XIDCONTROLLER padInterface;
		XIDCONFIG dynConfig;
		void generateInputReport(unsigned char *);
		void generateReportDescriptor(unsigned char *);
		unsigned int getReportDescSize();
		unsigned int getInputReportSize();
};

#endif