/* XBFLASH - Xbox Flash image utility
 * Copyright (C) 2002  Paul Bartholomew
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * 
 * xbflash.c - Main program
 * 
 */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <direct.h>

#include "xbconfig.h"
#include "xbunpack.h"
#include "xbpack.h"

//
// Usage:	xbflash -unpack config.ini filename.rom outdirname
//						-or-
//			xbflash -pack config.ini indirname filename.rom
//

char	*Pname;

#include "cryptlib/hash/sha.h"
#include "cryptlib/crypt/rc4.h"

#if	0
unsigned char Test_key[] = {
	0xB4, 0x71, 0xEF, 0x97, 0x06, 0x5F, 0x49, 0x0A,
	0xE0, 0xF7, 0x2A, 0xA2, 0xC7, 0x40, 0x67, 0xAF,
};

unsigned char Test_key_2[] = {
0xEB, 0x9D, 0x7D, 0xCB, 0xA5, 0xBE, 0x50, 0xF3,
0x36, 0xF6, 0xE7, 0xDC, 0xAF, 0xCB, 0x5F, 0xB9,
};

void
test(void)
{
	SHA_CTX	sha_ctx;
	RC4_KEY	rc4_key;
	unsigned char	sha_digest[SHA_DIGEST_LENGTH];
	unsigned char	tmp_key[16];
	int	i;

	SHA1_Init(&sha_ctx);

	// start with rc4 key
	SHA1_Update(&sha_ctx, Test_key, 16);

	SHA1_Update(&sha_ctx, Test_key_2, 16);

	for (i = 0; i < 16; i++) {
		tmp_key[i] = Test_key[i] ^ 0x5c;
	}

	SHA1_Update(&sha_ctx, tmp_key, 16);
	SHA1_Final(sha_digest, &sha_ctx);

	RC4_set_key(&rc4_key, 20, sha_digest);
}
#endif

void
usage(void)
{
	fprintf(stderr,
		"Usage:\t%s -unpack config.ini filename.rom outdirname\n", Pname);
	fprintf(stderr, "\t\t\t-or-\n");
	fprintf(stderr,
		"\t%s -pack config.ini indirname filename.rom\n", Pname);
}

int
main(int argc, char *argv[])
{
	int	want_unpack = 0;

	Pname = argv[0];

	if (argc != 5) {
		usage();
		exit(1);
	}

	if (!strcmp(argv[1], "-unpack")) {
		want_unpack = 1;
	} else if (!strcmp(argv[1], "-pack")) {
		want_unpack = 0;
	} else {
		usage();
		exit(1);
	}

	if (!read_xbconfig_file(argv[2])) {
		exit(1);
	}
	if (want_unpack) {
		if (!do_xbunpack(argv[3], argv[4])) {
			exit(1);
		}
	} else {
		if (!do_xbpack(argv[3], argv[4])) {
			exit(1);
		}
	}
	return 0;
}

