unit uZipDirectoryInfo;

interface
uses
  uIDirectoryInfo,Classes,Sysutils,uiZipper;

Type
  TZipDirectoryInfo = Class(TInterfacedObject , IDirectoryInfo)
  Protected
    fZipperIntf : IZipper;
    RootDirectory : String;
    FileListPos : Longint;
    Function Init(aRootPath:String; aPath: String):Longint;
    Function FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec):Longint;
    Function FindNext(var aSearchRec: TSearchRec):Longint;
    Procedure FindClose(var aSearchRec: TSearchRec);
    Function FileExists(aFileName: String):Boolean;
    Function GetFileStream(aRootPath:String; aFilename:String):TStream;
  End;

implementation
uses
  windows, uFileStreamWithCleaner;

Type
  _GetZipInterface = Function :IZipper; StdCall;
var
  DllHandle:Cardinal;
  GZI:_GetZipInterface;

Function GetZipIntf:IZipper;
begin
  if @GZI<>Nil then
    Result := GZI
  else
    Result := Nil;
End;


{ TRealDirectoryInfo }

function TZipDirectoryInfo.FileExists(aFileName: String): Boolean;
begin
  Result := False;
end;

procedure TZipDirectoryInfo.FindClose(var aSearchRec: TSearchRec);
begin
//  Sysutils.FindClose(aSearchRec);
end;

function TZipDirectoryInfo.FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec): Longint;
begin
  aSearchrec.FindHandle := 0;
  Result := Self.FindNext(aSearchrec);
end;


function TZipDirectoryInfo.FindNext(var aSearchRec: TSearchRec): Longint;
var
  done:Boolean;
  curfile : String;
  curAttr : Longint;
begin
  done := False;
  Result := -1;
  While ((aSearchRec.FindHandle) < (fZipperIntf.GetCount)) and (not done) do
    begin
      inc(aSearchRec.FindHandle);
      CurFile := fZipperIntf.getFullName(aSearchRec.findhandle-1);
      CurAttr := fZipperIntf.GetExternalFileAttributes(aSearchRec.findhandle-1);
      if (CurFile[Length(CurFile)]='\') then
        Delete(curfile,length(curfile),1);
      if (extractFilePath(CurFile) = RootDirectory) then
        begin
          aSearchrec.Name := fZipperIntf.GetFilename(aSearchRec.findhandle-1);
          if aSearchRec.name = '' then
            aSearchrec.Name := CurFile;
          aSearchRec.Attr := CurAttr;
          Done:=True;
        end;
    end;
  if done then
    Result := 0;
end;

function TZipDirectoryInfo.GetFileStream(aRootPath, aFilename: String): TStream;
var
  mZipperIntf: IZipper;
  tmpFilename : String;
  tmpPath : String;
begin
  Result := Nil;
  mZipperIntf:= GetZipIntf;
  if not assigned(mZipperIntf) then exit;
  mZipperIntf.SetZipName(Pchar(aRootPath));
  DateTimeToString(tmpFilename,'yyyymmddhhmmss',now);
  tmpFilename := TmpFilename +Inttostr(Random(6000))+'.tmp';
  TmpPath := GetEnvironmentVariable('TEMP');
  if tmpPath = '' then
    TmpPath := GetEnvironmentVariable('TMP');
  if (tmpPath <> '') and (tmpPath[Length(tmpPath)]<>'\') then
    TmpPath := TmpPath + '\';
  tmpFilename := TmpPath+'RelaX'+TmpFilename;
  mZipperIntf.UnZipToFile(PChar(tmpFileName),Pchar(aFilename));
  Result := TFileStreamWithCleaner.Create(tmpFileName,fmOpenRead	+fmShareDenyNone);
  mZipperIntf:=Nil;
end;

function TZipDirectoryInfo.Init(aRootPath, aPath: String): Longint;
begin
  Result := -1;
  fZipperIntf := GetZipIntf;
  if not assigned(fZipperIntf) then exit;

  fZipperIntf.SetZipName(Pchar(aRootPath));

  Result := 0;
  Try
    RootDirectory := aPath;
    If (Length(RootDirectory)>0) and (RootDirectory[Length(RootDirectory)]<>'\') then
      RootDirectory := RootDirectory + '\';
    fZipperIntf.ReadZip;
  Except
    on exception do
      Result := -1;
  End;
end;

Initialization
  @GZI := Nil;
  DllHandle := 0;
  if Dllhandle=0 then
    DllHandle := LoadLibrary('RelaxUnzipper.dll');
  if DLLHandle=0 then exit;
  if @GZI=Nil then
    @GZI := GetProcAddress(DllHandle,'GetZipInterface');
Finalization
  if Dllhandle<>0 then
    FreeLibrary(DllHandle)
end.
