unit uShoutcastStream;

interface
uses
  classes,
  Controls,
  dateUtils,
  sysutils,
  windows,
  forms,
  Main,
  ExtCtrls,
  StdCtrls,
  inifiles,
  IdBaseComponent,
  IdComponent,
  IdTCPConnection,
  IdTCPClient;

Type
  TShoutCastStream = Class(TStream)
  Private
    ShoutCastThread:TThread;
    FFilename:String;
    fTimeout:Integer;
  Protected
    function GetSize: Int64; Override;
  Public
    Constructor Create(Filename:String);
    Destructor Destroy; Override;
    function Seek(const Offset: Int64; Origin: TSeekOrigin): Int64; Override;
    function Read(var Buffer; Count: Longint): Longint; Override;
    function Write(const Buffer; Count: Longint): Longint; Override;
  end;

implementation

uses Math;
const
  fakefilesize = 2000000000;

Type
  TShoutCastThread = Class(TThread)
  Private
    BufferLocked:Boolean;
  Protected
    TCPClient: TIdTCPClient;
    myPanel:TPanel;
    myLabel:TLabel;
    Buffer:array[1..2000000] of byte; //2mb buffer
    BufOffset:Int64;
    Buffilled:Int64;
    Position:Int64;
    url:String;
    fTimeout:Integer;
    LastBufferPush:TDateTime;
    Inexecute:Boolean;
    plsInifile:TIniFile;
    CurrentServer:Integer;
    MaxServers:Integer;
  Public
    Constructor Create(ip:String;Port:Integer;Location:String;Timeout:Integer); Overload;
    Constructor Create(aPlsFilename:String); Overload;
    Destructor Destroy; OVerride;
    Procedure ConstructorInit;
    Procedure TryNextServer;
    Procedure ConnectUrl;
    Procedure Execute; Override;
    Procedure LockBuffer;
    Procedure UnlockBuffer;
    Procedure UpdateBufferStats;
    Procedure DisplayCleanup;
    Procedure SyncUpdateBufferStats;
    Function GetBufferStreamTimeOut:Int64;
  End;


{ TShoutCastStream }


constructor TShoutCastStream.Create(Filename: String);
var
  ip:String;
  port:Integer;
  Location:String;
  f:TextFile;
begin
  Inherited Create;
  FFilename := FileName;
  if pos('.PLS',uppercase(FFilename))>0 then
    begin
      ShoutCastThread := TShoutCastThread.Create(ffilename);
      ShoutCastThread.Resume;
    end
  else
    begin
      AssignFile(f,FileName);
      Reset(f);
      Readln(f,ip);
      Readln(f,port);
      Readln(f,Location);
      Readln(f,fTimeout);
      CloseFile(f);
      ShoutCastThread := TShoutCastThread.Create(ip,port,location,ftimeout);
      ShoutCastThread.Resume;
    End;

end;

destructor TShoutCastStream.Destroy;
begin
  ShoutCastThread.Terminate;
  FreeAndNil(ShoutCastThread);
  inherited;
end;

function TShoutCastStream.GetSize: Int64;
begin
   Result := fakefilesize;
end;


function TShoutCastStream.Read(var Buffer; Count: Integer): Longint;
var
  SCT : TShoutCastThread;
begin
  Result := Count;
  SCT := TShoutCastThread(ShoutCastThread);
  if SCT.Position > fakefilesize-50000 then
     FillChar(Buffer,count,#0)
  else
    begin
      While (SCT.bufoffset+SCT.buffilled)<SCT.Position+Count do
        Begin
          SCT.SyncUpdateBufferStats;
          if (SCT.GetBufferStreamTimeOut>fTimeout*1000) and (fTimeout>0) then ;
          if sct.Inexecute = false then
            sct.Execute;
//            Raise Exception.Create('StreamTimeout!!');
          Sleep(50);
        end;
      SCT.SyncUpdateBufferStats;
      Move(SCT.buffer[SCT.Position-SCT.bufoffset],buffer,count);
      if    (SCT.Position >(SCT.BufOffset+1500000))
        and (SCT.Buffilled>(Sizeof(SCT.Buffer)-500000)) then
        begin
          // moving while thread can put some more in buffer..
          // this could cause the glitches... trying to work around it with lockbuffer and unlockbuffer
          SCT.LockBuffer;
          Move(SCT.buffer[Count+1],SCT.buffer[1],Sct.BufFilled-Count);
          Dec(SCT.Buffilled,count);
          Inc(SCT.BufOffset,count);
          SCT.UnlockBuffer;
          SCT.SyncUpdateBufferStats;
        end;
    end;
  inc(sct.Position,count);
end;

function TShoutCastStream.Seek(const Offset: Int64;
  Origin: TSeekOrigin): Int64;
begin
  case origin of
    soBeginning : begin
                    TShoutCastThread(ShoutCastThread).Position := Offset;
                  end;
    soCurrent   : begin
                    TShoutCastThread(ShoutCastThread).Position := TShoutCastThread(ShoutCastThread).Position + offset;
                  end;
    soEnd       : begin
                    TShoutCastThread(ShoutCastThread).Position := fakefilesize + offset;
                  end;
  end;
  Result := TShoutCastThread(ShoutCastThread).Position;
end;

function TShoutCastStream.Write(const Buffer; Count: Integer): Longint;
begin
  // Not supported!!
  Result := 0;
end;

{ TShoutCastThread }

constructor TShoutCastThread.Create(ip: String; Port: Integer;Location: String;Timeout:Integer);
begin
  Inherited Create(True);
  ConstructorInit;
  fTimeout := Timeout;
  url := 'http://'+IP+':'+Inttostr(Port)+Location;
  ConnectUrl;
end;

procedure TShoutCastThread.ConstructorInit;
begin
  MaxServers := 1;
  CurrentServer := 1;
  BufOffset := 0;
  Position := 0;
  Buffilled := 0;
  fTimeout := 10;
  myPanel:=Nil;
  LastBufferPush:=Now;
  BufferLocked := False;
  TCPClient:=TIdTCPClient.Create(Nil);
end;

constructor TShoutCastThread.Create(aPlsFilename: String);
var
  s:STring;
begin
  Inherited Create(True);
  ConstructorInit;
  fTimeout := 10;
  plsInifile := TIniFile.Create(aPlsFilename);
  s:=Trim(plsInifile.ReadString('playlist','numberofentries','0'));
  if s='' then
    s:='0';
  Self.MaxServers := StrToInt(s);
  CurrentServer := 0;
  Self.TryNextServer;
end;

destructor TShoutCastThread.Destroy;
begin
  while inexecute do sleep(10);
  Synchronize(DisplayCleanup);
  TCPClient.Disconnect;
  FreeAndNil(TCPCLient);
  FreeAndNil(plsInifile);
  inherited;
end;

procedure TShoutCastThread.DisplayCleanup;
begin
  FreeAndNil(myPanel);
end;

procedure TShoutCastThread.Execute;
var
  tmpbuf:array[1..4096] of byte;
begin
  Inexecute := True;
  Try
    Repeat
      if Length(Buffer)-BufFilled>(sizeof(tmpbuf)+3000) then
        begin
          // filling up the buffer...
          while (TCPClient.connected) and (TCPClient.InputBuffer.Size<sizeof(tmpbuf)) and (self.terminated=false) and (Self.GetBufferStreamTimeOut<fTimeOut*1000) do
            begin
              TCPClient.ReadFromStack(True,Self.fTimeout*100,False);
              sleep(10);
              SyncUpdateBufferStats;
            end;
          if (TCPClient.connected) and (Self.GetBufferStreamTimeOut<fTimeout*1000) then
            begin
              TCPClient.ReadBuffer(tmpbuf,sizeof(tmpbuf));
              SyncUpdateBufferStats;
              // lock buffer done to get exclusive access to the buffer
              // trying to stop the glitches..
              LockBuffer;
              move(tmpbuf,buffer[buffilled+1],sizeof(tmpbuf));
              inc(BufFilled,Sizeof(tmpbuf));
              LastBufferPush := Now;
              UnlockBuffer;
            end
          else
            begin
              TryNextServer; 
            end;
        end
      else
        sleep(50);
    until Self.Terminated;
  finally
    InExecute := false;
  end;
end;

function TShoutCastThread.GetBufferStreamTimeOut: Int64;
begin
  If CurrentServer>MaxServers then
    Raise Exception.Create('No more servers to connect to.. streaming failed');
  Result := MilliSecondsBetween(Now,LastBufferPush);
end;

procedure TShoutCastThread.LockBuffer;
begin
  While BufferLocked=true do
    Sleep(5);
  BufferLocked := True;
end;

procedure TShoutCastThread.SyncUpdateBufferStats;
begin
  Synchronize(UpdateBufferStats);
end;

procedure TShoutCastThread.ConnectUrl;
var
  s:String;
  host:String;
  Port:String;
  path:String;
begin
  s:= Url;
  delete(s,1,7);
  host:='';
  Repeat
    host:=host+s[1];
    delete(s,1,1);
  until s[1]=':';
  delete(s,1,1);

  port := '';
  Repeat
    port:=port+s[1];
    delete(s,1,1);
    if s = '' then
      s:= '/';
  until s[1]='/';
  path := s;

  TCPClient.Port := StrToInt(port);
  TCPClient.Host := host;
  SyncUpdateBufferStats;
  Try
    TCPClient.Connect(5000);
  Except
    on exception do
      begin
        exit;
      end;
  end;
  LastBufferPush:=Now;
  TCPClient.Write( 'GET '+path+' HTTP/1.1'+#13#10
                  +'User-Agent: RelaX'+Main.Version+#13#10
                  +'Host: '+host+#13#10#13#10#13#10);
end;

procedure TShoutCastThread.TryNextServer;
var
  S:String;
//  s2:String;
begin
  if TCPClient.Connected then
    TCPClient.Disconnect;
  while tcpClient.Connected do
    sleep(10);  
  Inc(CurrentServer);
  If CurrentServer>MaxServers then
    Raise Exception.Create('No more servers to connect to.. streaming failed');
  s :=Trim(plsInifile.ReadString('playlist','File'+Inttostr(CurrentServer),''));
  Url := s;
  ConnectUrl;
  if TCPClient.Connected=false then
    TryNextServer;
//  s2:=Trim(plsInifile.ReadString('playlist','Length'+Inttostr(CurrentServer),''));
end;

procedure TShoutCastThread.UnlockBuffer;
begin
  BufferLocked := False;
end;

procedure TShoutCastThread.UpdateBufferStats;
begin
  if not assigned(mypanel) then
    begin
       mypanel := TPanel.create(frmMain);
       myPanel.Parent := frmMain.ScrollBox1;
       myPanel.Height := 24;
       myPanel.Align := alBottom;
       myLabel := TLabel.Create(myPanel);
       myLabel.Parent := myPanel;
       myLabel.Left := 20;
       myLabel.Top := 4;
    end;
  myLabel.Caption := 'server: '+Inttostr(CurrentServer)+'/'+Inttostr(MaxServers)+' url: '+url+'   bufferoffset: '+IntToStr(BufOffset)+'  bufferfilled: '+Inttostr(Buffilled)+'  StreamPosition: '+Inttostr(Position)+'  Stoptimeout: '+Inttostr(fTimeout)+'s  Timeout: '+Inttostr(GetBufferStreamTimeOut)+'ms';
end;


end.
