unit uSRTMaker;

interface

  Function GetSRTList(aSRTFile:String; aAlternateFolder:String):String;
  Function SRTFileExists(aSRTFile:String;aAlternateFolder:String):Boolean;

implementation

uses sysutils,classes;


Function SRTFileExists(aSRTFile:String;aAlternateFolder:String):Boolean;
var
  FileWithoutExt:String;
begin
  Result := False;
  if fileexists(aSRTFile) then
    Result := True;
  FileWithoutExt := aSRTFile;
  Delete(FileWithoutExt,Length(FileWithoutExt)-2,3);
  if FileExists(FileWithoutExt+'sub') then
    Result := True;
  FileWithoutExt := ExtractFileName(FileWithoutExt);
  if FileExists(aAlternateFolder+FileWithoutExt+'srt') then
    Result := True;
  if FileExists(aAlternateFolder+FileWithoutExt+'sub') then
    Result := True;
end;

// only getting here when no srt file found!
Function GetSRTList(aSRTFile:String;aAlternateFolder:String):String;
var
  CFile:String;
  sl:TStringlist;
Begin
  Result := '';
  Try
    CFile := ExtractFileName(aSRTFile);
    if FileExists(aAlternateFolder+CFile) then
      Begin
        sl:=TStringlist.Create;
        sl.LoadFromFile(aAlternateFolder+CFile);
        Result := sl.Text;
        FreeAndNil(sl);
      End;
  Except
    on exception do
      Result := '';
  End;
end;

end.
