unit uISODirectoryInfo;

interface
uses
  uIDirectoryInfo,Classes,Sysutils, UnISOReader;

Type
  TOLDISODirectoryInfo = Class(TInterfacedObject , IDirectoryInfo)
  Protected
    ISOFile:String;
    Function Init(aRootPath:String; aPath: String):Longint;
    Function FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec):Longint;
    Function FindNext(var aSearchRec: TSearchRec):Longint;
    Procedure FindClose(var aSearchRec: TSearchRec);
    Function FileExists(aFileName: String):Boolean;
    Function GetFileStream(aRootPath:String; aFilename:String):TStream;
  End;

  TISODirectoryInfo = Class(TInterfacedObject , IDirectoryInfo)
  protected
    FISOReader: TSearchableISOFileReader;
    function FileExists(aFileName: String): Boolean;
    procedure FindClose(var aSearchRec: TSearchRec);
    function FindFirst(aWildCard: String; FileMode: Integer;
      var aSearchRec: TSearchRec): Longint;
    function FindNext(var aSearchRec: TSearchRec): Longint;
    function GetFileStream(aRootPath, aFilename: String): TStream;
    function Init(aRootPath, aPath: String): Longint;
  end;
implementation

{ TRealDirectoryInfo }

function TOLDISODirectoryInfo.FileExists(aFileName: String): Boolean;
begin
  Result := False;
end;

procedure TOLDISODirectoryInfo.FindClose(var aSearchRec: TSearchRec);
begin
  aSearchRec.FindHandle := 0;
end;

function TOLDISODirectoryInfo.FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec): Longint;
begin
  Result := 0;
  aSearchRec.Attr := faReadOnly;
  aSearchRec.Name := 'AVSEQ01.MPG';
  aSearchRec.FindHandle := 1;
end;

function TOLDISODirectoryInfo.FindNext(var aSearchRec: TSearchRec): Longint;
begin
  if aSearchRec.FindHandle = 1 then
    begin
      aSearchRec.Attr := faReadOnly;
      aSearchRec.Name := 'AVSEQ01.DAT';
      aSearchRec.FindHandle := 0;
      Result := 0;
    end
  else
    Result := -1; // no more files;
end;

function TOLDISODirectoryInfo.GetFileStream(aRootPath, aFilename: String): TStream;
begin
  Result := TISOFileStream.Create(aRootPath,aFileName,0,fmOpenRead+fmShareDenyNone);
end;

function TOLDISODirectoryInfo.Init(aRootPath, aPath: String): Longint;
begin
  Result := 0;
  isoFile := aRootPath;
end;


{ TISODirectoryInfo }

function TISODirectoryInfo.FileExists(aFileName: String): Boolean;
begin
  Result := False;
end;

procedure TISODirectoryInfo.FindClose(var aSearchRec: TSearchRec);
begin
  FISOReader.FindClose(aSearchRec);
end;

function TISODirectoryInfo.FindFirst(aWildCard: String; FileMode: Integer;
  var aSearchRec: TSearchRec): Longint;
begin
  Result := FIsoReader.FindFirst(aWildCard, FileMode, aSearchRec);
end;

function TISODirectoryInfo.FindNext(var aSearchRec: TSearchRec): Longint;
begin
  Result := FIsoReader.FindNext(aSearchRec);
end;

function TISODirectoryInfo.GetFileStream(aRootPath,
  aFilename: String): TStream;
begin
  try
    Result := TISOFileStream.Create(aRootPath, aFileName, 0,fmOpenRead+fmShareDenyNone);
  except
    Result := nil;
  end;
end;

function TISODirectoryInfo.Init(aRootPath, aPath: String): Longint;
begin
  Result := 0;
  try
    FISOReader:=  TSearchableISOFileReader.Create(ARootPAth);
    FISOReader.SetCurrentDirectory(aPath);
    //, fmOpenRead + fmShareDenyNone);
  except
    Result := -1;
  end;

end;

end.

