unit uIDirectoryInfo;

interface
uses
  classes, Sysutils;

Type
  IDirectoryInfo = Interface(IUnknown)
    // the init..
    // for example aRootPath can be filled with Nothing in directory mode or it can be filled
    // with for example "c:\series\24\24_1x01.Bin" in iso mode..
    // the path can be filled with "C:\some\files\" in directory mode or it can be filled with "\MPEG2\"
    // in iso mode
    // return something else then 0 to say that the init has failed..
    // for example to say that the file is no real iso..
    // or that the file does not exists..
    // or that the path given not exists :)
    Function Init(aRootPath:String; aPath: String):Longint;

    // wildcard is currently *.* so dont bother to mutch with that now
    // FilemMode is filled with FaAnyFile .. not to important
    // Searchrec is a TSearchrecord of which i'm only using attrib (faDirectory mainly for directory's
    // otherwise it will go into filemode... and the name .. rest is not used yet..
    Function FindFirst(aWildCard: String; FileMode: Integer; var aSearchRec: TSearchRec):Longint;

    // Findnext will continue to the next file in the wildcard..
    // use TSearchRec.FindData or FindHandle to store where u last were
    // result something different then 0 when there are nomore files to give back
    Function FindNext(var aSearchRec: TSearchRec):Longint;

    // Closes the Searchrec.. (mayb free your objects hidden in the finddata or findhandle
    Procedure FindClose(var aSearchRec: TSearchRec);

    // function is called while looping trough findfirst to see if there are any 'TBN' files or
    // 'SRT' subtitle files..
    Function FileExists(aFileName: String):Boolean;

    // this procedure can be called without the init first being called
    // for directorymode the params can be "  '','C:\music.mp3'  "
    // for ismode the params can be " ' C:\series\24\24_1x01.bin','\MPEG2\AVSEQ01.MPG'  "
    // Result is a TStream decendent.. if it does not work result a nill
    Function GetFileStream(aRootPath:String; aFilename:String):TStream; 

  end;

implementation

end.
